/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.BatchWriterImpl;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.Writer;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletDeletedException;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.FateTxId;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataTableUtil {
    private static final Text EMPTY_TEXT = new Text();
    private static Map<Credentials, Writer> root_tables = new HashMap<Credentials, Writer>();
    private static Map<Credentials, Writer> metadata_tables = new HashMap<Credentials, Writer>();
    private static final Logger log = LoggerFactory.getLogger(MetadataTableUtil.class);

    private MetadataTableUtil() {
    }

    public static synchronized Writer getMetadataTable(ServerContext context) {
        Credentials credentials = context.getCredentials();
        Writer metadataTable = metadata_tables.get(credentials);
        if (metadataTable == null) {
            metadataTable = new Writer((ClientContext)context, MetadataTable.ID);
            metadata_tables.put(credentials, metadataTable);
        }
        return metadataTable;
    }

    public static synchronized Writer getRootTable(ServerContext context) {
        Credentials credentials = context.getCredentials();
        Writer rootTable = root_tables.get(credentials);
        if (rootTable == null) {
            rootTable = new Writer((ClientContext)context, RootTable.ID);
            root_tables.put(credentials, rootTable);
        }
        return rootTable;
    }

    public static void putLockID(ServerContext context, ZooLock zooLock, Mutation m) {
        MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN.put(m, new Value(zooLock.getLockID().serialize(context.getZooKeeperRoot() + "/").getBytes(StandardCharsets.UTF_8)));
    }

    private static void update(ServerContext context, Mutation m, KeyExtent extent) {
        MetadataTableUtil.update(context, null, m, extent);
    }

    public static void update(ServerContext context, ZooLock zooLock, Mutation m, KeyExtent extent) {
        Writer t = extent.isMeta() ? MetadataTableUtil.getRootTable(context) : MetadataTableUtil.getMetadataTable(context);
        MetadataTableUtil.update(context, t, zooLock, m);
    }

    public static void update(ServerContext context, Writer t, ZooLock zooLock, Mutation m) {
        if (zooLock != null) {
            MetadataTableUtil.putLockID(context, zooLock, m);
        }
        while (true) {
            try {
                t.update(m);
                return;
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
            catch (ConstraintViolationException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public static void updateTabletFlushID(KeyExtent extent, long flushID, ServerContext context, ZooLock zooLock) {
        if (!extent.isRootTablet()) {
            Mutation m = new Mutation(extent.getMetadataEntry());
            MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value((flushID + "").getBytes(StandardCharsets.UTF_8)));
            MetadataTableUtil.update(context, zooLock, m, extent);
        }
    }

    public static void updateTabletCompactID(KeyExtent extent, long compactID, ServerContext context, ZooLock zooLock) {
        if (!extent.isRootTablet()) {
            Mutation m = new Mutation(extent.getMetadataEntry());
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value((compactID + "").getBytes(StandardCharsets.UTF_8)));
            MetadataTableUtil.update(context, zooLock, m, extent);
        }
    }

    public static void updateTabletDataFile(long tid, KeyExtent extent, Map<FileRef, DataFileValue> estSizes, String time, ServerContext context, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        Value tidValue = new Value((CharSequence)FateTxId.formatTid((long)tid));
        for (Map.Entry<FileRef, DataFileValue> entry : estSizes.entrySet()) {
            Text file = entry.getKey().meta();
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, file, new Value(entry.getValue().encode()));
            m.put(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, file, tidValue);
        }
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void updateTabletDir(KeyExtent extent, String newDir, ServerContext context, ZooLock lock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(newDir.getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, lock, m, extent);
    }

    public static void addTablet(KeyExtent extent, String path, ServerContext context, char timeType, ZooLock lock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(path.getBytes(StandardCharsets.UTF_8)));
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value((timeType + "0").getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, lock, m, extent);
    }

    public static void updateTabletVolumes(KeyExtent extent, List<LogEntry> logsToRemove, List<LogEntry> logsToAdd, List<FileRef> filesToRemove, SortedMap<FileRef, DataFileValue> filesToAdd, String newDir, ZooLock zooLock, ServerContext context) {
        if (extent.isRootTablet()) {
            if (newDir != null) {
                throw new IllegalArgumentException("newDir not expected for " + extent);
            }
            if (filesToRemove.size() != 0 || filesToAdd.size() != 0) {
                throw new IllegalArgumentException("files not expected for " + extent);
            }
            for (LogEntry logEntry : logsToAdd) {
                MetadataTableUtil.addRootLogEntry(context, zooLock, logEntry);
            }
            MetadataTableUtil.removeUnusedWALEntries(context, extent, logsToRemove, zooLock);
        } else {
            Mutation m = new Mutation(extent.getMetadataEntry());
            for (LogEntry logEntry : logsToRemove) {
                m.putDelete(logEntry.getColumnFamily(), logEntry.getColumnQualifier());
            }
            for (LogEntry logEntry : logsToAdd) {
                m.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
            }
            for (FileRef fileRef : filesToRemove) {
                m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, fileRef.meta());
            }
            for (Map.Entry entry : filesToAdd.entrySet()) {
                m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, ((FileRef)entry.getKey()).meta(), new Value(((DataFileValue)entry.getValue()).encode()));
            }
            if (newDir != null) {
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(newDir.getBytes(StandardCharsets.UTF_8)));
            }
            MetadataTableUtil.update(context, m, extent);
        }
    }

    private static void retryZooKeeperUpdate(ServerContext context, ZooLock zooLock, ZooOperation op) {
        while (true) {
            try {
                ZooReaderWriter zoo = context.getZooReaderWriter();
                if (!zoo.isLockHeld(zooLock.getLockID())) break;
                op.run((IZooReaderWriter)zoo);
            }
            catch (Exception e) {
                log.error("Unexpected exception {}", (Object)e.getMessage(), (Object)e);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    private static void addRootLogEntry(final ServerContext context, ZooLock zooLock, final LogEntry entry) {
        MetadataTableUtil.retryZooKeeperUpdate(context, zooLock, new ZooOperation(){

            @Override
            public void run(IZooReaderWriter rw) throws KeeperException, InterruptedException, IOException {
                String root = MetadataTableUtil.getZookeeperLogLocation(context);
                rw.putPersistentData(root + "/" + entry.getUniqueID(), entry.toBytes(), ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
        });
    }

    public static SortedMap<FileRef, DataFileValue> getDataFileSizes(KeyExtent extent, ServerContext context) {
        TreeMap<FileRef, DataFileValue> sizes = new TreeMap<FileRef, DataFileValue>();
        try (ScannerImpl mdScanner = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);){
            Map.Entry entry;
            mdScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            Text row = extent.getMetadataEntry();
            Key endKey = new Key(row, MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, new Text(""));
            endKey = endKey.followingKey(PartialKey.ROW_COLFAM);
            mdScanner.setRange(new Range(new Key(row), endKey));
            Object object = mdScanner.iterator();
            while (object.hasNext() && ((Key)(entry = (Map.Entry)object.next()).getKey()).getRow().equals((Object)row)) {
                DataFileValue dfv = new DataFileValue(((Value)entry.getValue()).get());
                sizes.put(new FileRef(context.getVolumeManager(), (Key)entry.getKey()), dfv);
            }
            object = sizes;
            return object;
        }
    }

    public static void rollBackSplit(Text metadataEntry, Text oldPrevEndRow, ServerContext context, ZooLock zooLock) {
        KeyExtent ke = new KeyExtent(metadataEntry, oldPrevEndRow);
        Mutation m = ke.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.putDelete(m);
        MetadataTableUtil.update(context, zooLock, m, new KeyExtent(metadataEntry, (Text)null));
    }

    public static void splitTablet(KeyExtent extent, Text oldPrevEndRow, double splitRatio, ServerContext context, ZooLock zooLock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.put(m, new Value(Double.toString(splitRatio).getBytes(StandardCharsets.UTF_8)));
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow((Text)oldPrevEndRow));
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void finishSplit(Text metadataEntry, Map<FileRef, DataFileValue> datafileSizes, List<FileRef> highDatafilesToRemove, ServerContext context, ZooLock zooLock) {
        Mutation m = new Mutation(metadataEntry);
        MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.putDelete(m);
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
        for (Map.Entry<FileRef, DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, entry.getKey().meta(), new Value(entry.getValue().encode()));
        }
        for (FileRef pathToRemove : highDatafilesToRemove) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, pathToRemove.meta());
        }
        MetadataTableUtil.update(context, zooLock, m, new KeyExtent(metadataEntry, (Text)null));
    }

    public static void finishSplit(KeyExtent extent, Map<FileRef, DataFileValue> datafileSizes, List<FileRef> highDatafilesToRemove, ServerContext context, ZooLock zooLock) {
        MetadataTableUtil.finishSplit(extent.getMetadataEntry(), datafileSizes, highDatafilesToRemove, context, zooLock);
    }

    public static void addDeleteEntries(KeyExtent extent, Set<FileRef> datafilesToDelete, ServerContext context) {
        TableId tableId = extent.getTableId();
        for (FileRef pathToRemove : datafilesToDelete) {
            MetadataTableUtil.update(context, MetadataTableUtil.createDeleteMutation(context, tableId, pathToRemove.path().toString()), extent);
        }
    }

    public static void addDeleteEntry(ServerContext context, TableId tableId, String path) {
        MetadataTableUtil.update(context, MetadataTableUtil.createDeleteMutation(context, tableId, path), new KeyExtent(tableId, null, null));
    }

    public static Mutation createDeleteMutation(ServerContext context, TableId tableId, String pathToRemove) {
        Path path = context.getVolumeManager().getFullPath(tableId, pathToRemove);
        Mutation delFlag = new Mutation(new Text(MetadataSchema.DeletesSection.getRowPrefix() + path));
        delFlag.put(EMPTY_TEXT, EMPTY_TEXT, new Value(new byte[0]));
        return delFlag;
    }

    public static void removeScanFiles(KeyExtent extent, Set<FileRef> scanFiles, ServerContext context, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        for (FileRef pathToRemove : scanFiles) {
            m.putDelete(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, pathToRemove.meta());
        }
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static void splitDatafiles(Text midRow, double splitRatio, Map<FileRef, FileUtil.FileInfo> firstAndLastRows, SortedMap<FileRef, DataFileValue> datafiles, SortedMap<FileRef, DataFileValue> lowDatafileSizes, SortedMap<FileRef, DataFileValue> highDatafileSizes, List<FileRef> highDatafilesToRemove) {
        for (Map.Entry<FileRef, DataFileValue> entry : datafiles.entrySet()) {
            long lowEntries;
            long lowSize;
            Text firstRow = null;
            Text lastRow = null;
            boolean rowsKnown = false;
            FileUtil.FileInfo mfi = firstAndLastRows.get(entry.getKey());
            if (mfi != null) {
                firstRow = mfi.getFirstRow();
                lastRow = mfi.getLastRow();
                rowsKnown = true;
            }
            if (rowsKnown && firstRow.compareTo((BinaryComparable)midRow) > 0) {
                long highSize = entry.getValue().getSize();
                long highEntries = entry.getValue().getNumEntries();
                highDatafileSizes.put(entry.getKey(), new DataFileValue(highSize, highEntries, entry.getValue().getTime()));
                continue;
            }
            if (rowsKnown && lastRow.compareTo((BinaryComparable)midRow) <= 0) {
                lowSize = entry.getValue().getSize();
                lowEntries = entry.getValue().getNumEntries();
                lowDatafileSizes.put(entry.getKey(), new DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
                highDatafilesToRemove.add(entry.getKey());
                continue;
            }
            lowSize = (long)Math.floor((double)entry.getValue().getSize() * splitRatio);
            lowEntries = (long)Math.floor((double)entry.getValue().getNumEntries() * splitRatio);
            lowDatafileSizes.put(entry.getKey(), new DataFileValue(lowSize, lowEntries, entry.getValue().getTime()));
            long highSize = (long)Math.ceil((double)entry.getValue().getSize() * (1.0 - splitRatio));
            long highEntries = (long)Math.ceil((double)entry.getValue().getNumEntries() * (1.0 - splitRatio));
            highDatafileSizes.put(entry.getKey(), new DataFileValue(highSize, highEntries, entry.getValue().getTime()));
        }
    }

    public static void deleteTable(TableId tableId, boolean insertDeletes, ServerContext context, ZooLock lock) throws AccumuloException {
        try (ScannerImpl ms = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);
             BatchWriterImpl bw = new BatchWriterImpl((ClientContext)context, MetadataTable.ID, new BatchWriterConfig().setMaxMemory(1000000L).setMaxLatency(120000L, TimeUnit.MILLISECONDS).setMaxWriteThreads(2));){
            Key key;
            Mutation m = null;
            ms.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            if (insertDeletes) {
                ms.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)ms);
                for (Map.Entry cell : ms) {
                    key = (Key)cell.getKey();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        FileRef ref = new FileRef(context.getVolumeManager(), key);
                        bw.addMutation(MetadataTableUtil.createDeleteMutation(context, tableId, ref.meta().toString()));
                    }
                    if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                    bw.addMutation(MetadataTableUtil.createDeleteMutation(context, tableId, ((Value)cell.getValue()).toString()));
                }
                bw.flush();
                ms.clearColumns();
            }
            for (Map.Entry cell : ms) {
                key = (Key)cell.getKey();
                if (m == null) {
                    m = new Mutation(key.getRow());
                    if (lock != null) {
                        MetadataTableUtil.putLockID(context, lock, m);
                    }
                }
                if (key.getRow().compareTo(m.getRow(), 0, m.getRow().length) != 0) {
                    bw.addMutation(m);
                    m = new Mutation(key.getRow());
                    if (lock != null) {
                        MetadataTableUtil.putLockID(context, lock, m);
                    }
                }
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
            }
            if (m != null) {
                bw.addMutation(m);
            }
        }
    }

    static String getZookeeperLogLocation(ServerContext context) {
        return context.getZooKeeperRoot() + "/root_tablet/walogs";
    }

    public static void setRootTabletDir(ServerContext context, String dir) throws IOException {
        ZooReaderWriter zoo = context.getZooReaderWriter();
        String zpath = context.getZooKeeperRoot() + "/root_tablet/dir";
        try {
            zoo.putPersistentData(zpath, dir.getBytes(StandardCharsets.UTF_8), -1, ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public static String getRootTabletDir(ServerContext context) throws IOException {
        ZooReaderWriter zoo = context.getZooReaderWriter();
        String zpath = context.getZooKeeperRoot() + "/root_tablet/dir";
        try {
            return new String(zoo.getData(zpath, null), StandardCharsets.UTF_8);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public static Pair<List<LogEntry>, SortedMap<FileRef, DataFileValue>> getFileAndLogEntries(ServerContext context, KeyExtent extent) throws KeeperException, InterruptedException, IOException {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        TreeMap<FileRef, DataFileValue> sizes = new TreeMap<FileRef, DataFileValue>();
        VolumeManager fs = context.getVolumeManager();
        if (extent.isRootTablet()) {
            FileStatus[] files;
            MetadataTableUtil.getRootLogEntries(context, result);
            Path rootDir = new Path(MetadataTableUtil.getRootTabletDir(context));
            for (FileStatus fileStatus : files = fs.listStatus(rootDir)) {
                if (fileStatus.getPath().toString().endsWith("_tmp")) continue;
                DataFileValue dfv = new DataFileValue(0L, 0L);
                sizes.put(new FileRef(fileStatus.getPath().toString(), fileStatus.getPath()), dfv);
            }
        } else {
            try (TabletsMetadata tablets = TabletsMetadata.builder().forTablet(extent).fetchFiles().fetchLogs().fetchPrev().build((AccumuloClient)context);){
                TabletMetadata tablet = (TabletMetadata)Iterables.getOnlyElement((Iterable)tablets);
                if (!tablet.getExtent().equals((Object)extent)) {
                    throw new RuntimeException("Unexpected extent " + tablet.getExtent() + " expected " + extent);
                }
                result.addAll(tablet.getLogs());
                tablet.getFilesMap().forEach((k, v) -> sizes.put(new FileRef((String)k, fs.getFullPath(tablet.getTableId(), (String)k)), (DataFileValue)v));
            }
        }
        return new Pair(result, sizes);
    }

    public static List<LogEntry> getLogEntries(ServerContext context, KeyExtent extent) throws IOException, KeeperException, InterruptedException {
        log.info("Scanning logging entries for {}", (Object)extent);
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        if (extent.equals((Object)RootTable.EXTENT)) {
            log.info("Getting logs for root tablet from zookeeper");
            MetadataTableUtil.getRootLogEntries(context, result);
        } else {
            log.info("Scanning metadata for logs used for tablet {}", (Object)extent);
            Scanner scanner = MetadataTableUtil.getTabletLogScanner(context, extent);
            Text pattern = extent.getMetadataEntry();
            for (Map.Entry entry : scanner) {
                Text row = ((Key)entry.getKey()).getRow();
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LogColumnFamily.NAME) || !row.equals((Object)pattern)) continue;
                result.add(LogEntry.fromKeyValue((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue())));
            }
        }
        log.info("Returning logs {} for extent {}", result, (Object)extent);
        return result;
    }

    static void getRootLogEntries(ServerContext context, ArrayList<LogEntry> result) throws KeeperException, InterruptedException, IOException {
        ZooReaderWriter zoo = context.getZooReaderWriter();
        String root = MetadataTableUtil.getZookeeperLogLocation(context);
        result.clear();
        for (String child : zoo.getChildren(root)) {
            try {
                LogEntry e = LogEntry.fromBytes((byte[])zoo.getData(root + "/" + child, null));
                e = new LogEntry(RootTable.EXTENT, 0L, e.server, e.filename);
                result.add(e);
            }
            catch (KeeperException.NoNodeException ex) {}
        }
    }

    private static Scanner getTabletLogScanner(ServerContext context, KeyExtent extent) {
        TableId tableId = MetadataTable.ID;
        if (extent.isMeta()) {
            tableId = RootTable.ID;
        }
        ScannerImpl scanner = new ScannerImpl((ClientContext)context, tableId, Authorizations.EMPTY);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        Text start = extent.getMetadataEntry();
        Key endKey = new Key(start, MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        endKey = endKey.followingKey(PartialKey.ROW_COLFAM);
        scanner.setRange(new Range(new Key(start), endKey));
        return scanner;
    }

    public static Iterator<LogEntry> getLogEntries(ServerContext context) throws IOException, KeeperException, InterruptedException {
        return new LogEntryIterator(context);
    }

    public static void removeUnusedWALEntries(final ServerContext context, KeyExtent extent, final List<LogEntry> entries, ZooLock zooLock) {
        if (extent.isRootTablet()) {
            MetadataTableUtil.retryZooKeeperUpdate(context, zooLock, new ZooOperation(){

                @Override
                public void run(IZooReaderWriter rw) throws KeeperException, InterruptedException {
                    String root = MetadataTableUtil.getZookeeperLogLocation(context);
                    for (LogEntry entry : entries) {
                        String path = root + "/" + entry.getUniqueID();
                        log.debug("Removing " + path + " from zookeeper");
                        rw.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
                    }
                }
            });
        } else {
            Mutation m = new Mutation(extent.getMetadataEntry());
            for (LogEntry entry : entries) {
                m.putDelete(entry.getColumnFamily(), entry.getColumnQualifier());
            }
            MetadataTableUtil.update(context, zooLock, m, extent);
        }
    }

    private static void getFiles(Set<String> files, Collection<String> tabletFiles, TableId srcTableId) {
        for (String file : tabletFiles) {
            if (srcTableId != null && !file.startsWith("../") && !file.contains(":")) {
                file = "../" + srcTableId + file;
            }
            files.add(file);
        }
    }

    private static Mutation createCloneMutation(TableId srcTableId, TableId tableId, Map<Key, Value> tablet) {
        KeyExtent ke = new KeyExtent(tablet.keySet().iterator().next().getRow(), (Text)null);
        Mutation m = new Mutation(MetadataSchema.TabletsSection.getRow((TableId)tableId, (Text)ke.getEndRow()));
        for (Map.Entry<Key, Value> entry : tablet.entrySet()) {
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                String cf = entry.getKey().getColumnQualifier().toString();
                if (!cf.startsWith("../") && !cf.contains(":")) {
                    cf = "../" + srcTableId + entry.getKey().getColumnQualifier();
                }
                m.put(entry.getKey().getColumnFamily(), new Text(cf), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                m.put(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME, entry.getKey().getColumnQualifier(), entry.getValue());
                continue;
            }
            if (entry.getKey().getColumnFamily().equals((Object)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME)) continue;
            m.put(entry.getKey().getColumnFamily(), entry.getKey().getColumnQualifier(), entry.getValue());
        }
        return m;
    }

    private static Iterable<TabletMetadata> createCloneScanner(String testTableName, TableId tableId, AccumuloClient client) throws TableNotFoundException {
        Range range;
        String tableName;
        if (testTableName != null) {
            tableName = testTableName;
            range = MetadataSchema.TabletsSection.getRange((TableId)tableId);
        } else if (tableId.equals((Object)MetadataTable.ID)) {
            tableName = RootTable.NAME;
            range = MetadataSchema.TabletsSection.getRange();
        } else {
            tableName = MetadataTable.NAME;
            range = MetadataSchema.TabletsSection.getRange((TableId)tableId);
        }
        return TabletsMetadata.builder().scanTable(tableName).overRange(range).checkConsistency().saveKeyValues().fetchFiles().fetchLocation().fetchLast().fetchCloned().fetchPrev().fetchTime().build(client);
    }

    @VisibleForTesting
    public static void initializeClone(String testTableName, TableId srcTableId, TableId tableId, AccumuloClient client, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        Iterator<TabletMetadata> ti = MetadataTableUtil.createCloneScanner(testTableName, srcTableId, client).iterator();
        if (!ti.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId);
        }
        while (ti.hasNext()) {
            bw.addMutation(MetadataTableUtil.createCloneMutation(srcTableId, tableId, ti.next().getKeyValues()));
        }
        bw.flush();
    }

    private static int compareEndRows(Text endRow1, Text endRow2) {
        return new KeyExtent(TableId.of((String)"0"), endRow1, null).compareTo(new KeyExtent(TableId.of((String)"0"), endRow2, null));
    }

    @VisibleForTesting
    public static int checkClone(String testTableName, TableId srcTableId, TableId tableId, AccumuloClient client, BatchWriter bw) throws TableNotFoundException, MutationsRejectedException {
        Iterator<TabletMetadata> srcIter = MetadataTableUtil.createCloneScanner(testTableName, srcTableId, client).iterator();
        Iterator<TabletMetadata> cloneIter = MetadataTableUtil.createCloneScanner(testTableName, tableId, client).iterator();
        if (!cloneIter.hasNext() || !srcIter.hasNext()) {
            throw new RuntimeException(" table deleted during clone?  srcTableId = " + srcTableId + " tableId=" + tableId);
        }
        int rewrites = 0;
        while (cloneIter.hasNext()) {
            Mutation m;
            boolean cloneSuccessful;
            TabletMetadata cloneTablet = cloneIter.next();
            Text cloneEndRow = cloneTablet.getEndRow();
            HashSet<String> cloneFiles = new HashSet<String>();
            boolean bl = cloneSuccessful = cloneTablet.getCloned() != null;
            if (!cloneSuccessful) {
                MetadataTableUtil.getFiles(cloneFiles, cloneTablet.getFiles(), null);
            }
            ArrayList<TabletMetadata> srcTablets = new ArrayList<TabletMetadata>();
            TabletMetadata srcTablet = srcIter.next();
            srcTablets.add(srcTablet);
            Text srcEndRow = srcTablet.getEndRow();
            int cmp = MetadataTableUtil.compareEndRows(cloneEndRow, srcEndRow);
            if (cmp < 0) {
                throw new TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
            }
            HashSet<String> srcFiles = new HashSet<String>();
            if (!cloneSuccessful) {
                MetadataTableUtil.getFiles(srcFiles, srcTablet.getFiles(), srcTableId);
            }
            while (cmp > 0) {
                srcTablet = srcIter.next();
                srcTablets.add(srcTablet);
                srcEndRow = srcTablet.getEndRow();
                cmp = MetadataTableUtil.compareEndRows(cloneEndRow, srcEndRow);
                if (cmp < 0) {
                    throw new TabletDeletedException("Tablets deleted from src during clone : " + cloneEndRow + " " + srcEndRow);
                }
                if (cloneSuccessful) continue;
                MetadataTableUtil.getFiles(srcFiles, srcTablet.getFiles(), srcTableId);
            }
            if (cloneSuccessful) continue;
            if (!srcFiles.containsAll(cloneFiles)) {
                m = new Mutation(cloneTablet.getExtent().getMetadataEntry());
                for (Map.Entry entry : cloneTablet.getKeyValues().entrySet()) {
                    Key k = (Key)entry.getKey();
                    m.putDelete(k.getColumnFamily(), k.getColumnQualifier(), k.getTimestamp());
                }
                bw.addMutation(m);
                for (TabletMetadata st : srcTablets) {
                    bw.addMutation(MetadataTableUtil.createCloneMutation(srcTableId, tableId, st.getKeyValues()));
                }
                ++rewrites;
                continue;
            }
            m = new Mutation(cloneTablet.getExtent().getMetadataEntry());
            m.put(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME, new Text(""), new Value("OK".getBytes(StandardCharsets.UTF_8)));
            bw.addMutation(m);
        }
        bw.flush();
        return rewrites;
    }

    public static void cloneTable(ServerContext context, TableId srcTableId, TableId tableId, VolumeManager volumeManager) throws Exception {
        try (BatchWriter bw = context.createBatchWriter(MetadataTable.NAME, new BatchWriterConfig());){
            while (true) {
                try {
                    int rewrites;
                    MetadataTableUtil.initializeClone(null, srcTableId, tableId, (AccumuloClient)context, bw);
                    while ((rewrites = MetadataTableUtil.checkClone(null, srcTableId, tableId, (AccumuloClient)context, bw)) != 0) {
                    }
                    bw.flush();
                }
                catch (TabletDeletedException tde) {
                    bw.flush();
                    MetadataTableUtil.deleteTable(tableId, false, context, null);
                    log.debug("Tablets merged in table {} while attempting to clone, trying again", (Object)srcTableId);
                    UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                break;
            }
            Scanner mscanner = context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            mscanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME);
            int dirCount = 0;
            for (Map.Entry entry : mscanner) {
                Key k = (Key)entry.getKey();
                Mutation m = new Mutation(k.getRow());
                m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
                VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(tableId, new KeyExtent(k.getRow(), (Text)null).getEndRow(), context);
                String dir = volumeManager.choose(chooserEnv, ServerConstants.getBaseUris(context)) + "/tables" + "/" + tableId + "/" + new String(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])Constants.CLONE_PREFIX_BYTES));
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(dir.getBytes(StandardCharsets.UTF_8)));
                bw.addMutation(m);
            }
        }
    }

    public static void chopped(ServerContext context, KeyExtent extent, ZooLock zooLock) {
        Mutation m = new Mutation(extent.getMetadataEntry());
        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.put(m, new Value("chopped".getBytes(StandardCharsets.UTF_8)));
        MetadataTableUtil.update(context, zooLock, m, extent);
    }

    public static long getBulkLoadTid(Value v) {
        String vs = v.toString();
        if (FateTxId.isFormatedTid((String)vs)) {
            return FateTxId.fromString((String)vs);
        }
        return Long.parseLong(vs);
    }

    public static void removeBulkLoadEntries(AccumuloClient client, TableId tableId, long tid) throws Exception {
        try (IsolatedScanner mscanner = new IsolatedScanner(client.createScanner(MetadataTable.NAME, Authorizations.EMPTY));
             BatchWriter bw = client.createBatchWriter(MetadataTable.NAME, new BatchWriterConfig());){
            mscanner.setRange(new KeyExtent(tableId, null, null).toMetadataRange());
            mscanner.fetchColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            for (Map.Entry entry : mscanner) {
                log.trace("Looking at entry {} with tid {}", (Object)entry, (Object)tid);
                long entryTid = MetadataTableUtil.getBulkLoadTid((Value)entry.getValue());
                if (tid != entryTid) continue;
                log.trace("deleting entry {}", (Object)entry);
                Key key = (Key)entry.getKey();
                Mutation m = new Mutation(key.getRow());
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
                bw.addMutation(m);
            }
        }
    }

    public static Map<Long, ? extends Collection<FileRef>> getBulkFilesLoaded(ServerContext context, KeyExtent extent) {
        Text metadataRow = extent.getMetadataEntry();
        HashMap<Long, List> result = new HashMap<Long, List>();
        VolumeManager fs = context.getVolumeManager();
        try (ScannerImpl scanner = new ScannerImpl((ClientContext)context, extent.isMeta() ? RootTable.ID : MetadataTable.ID, Authorizations.EMPTY);){
            scanner.setRange(new Range(metadataRow));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            for (Map.Entry entry : scanner) {
                Long tid = MetadataTableUtil.getBulkLoadTid((Value)entry.getValue());
                List lst = result.computeIfAbsent(tid, k -> new ArrayList());
                lst.add(new FileRef(fs, (Key)entry.getKey()));
            }
        }
        return result;
    }

    public static void addBulkLoadInProgressFlag(ServerContext context, String path, long fateTxid) {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.BlipSection.getRowPrefix() + path));
        m.put(EMPTY_TEXT, EMPTY_TEXT, new Value((CharSequence)FateTxId.formatTid((long)fateTxid)));
        MetadataTableUtil.update(context, m, new KeyExtent(TableId.of((String)"anythingNotMetadata"), null, null));
    }

    public static void removeBulkLoadInProgressFlag(ServerContext context, String path) {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.BlipSection.getRowPrefix() + path));
        m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
        MetadataTableUtil.update(context, m, new KeyExtent(TableId.of((String)"anythingNotMetadata"), null, null));
    }

    public static SortedMap<Text, SortedMap<ColumnFQ, Value>> getTabletEntries(SortedMap<Key, Value> tabletKeyValues, List<ColumnFQ> columns) {
        TreeMap<Text, SortedMap<ColumnFQ, Value>> tabletEntries = new TreeMap<Text, SortedMap<ColumnFQ, Value>>();
        HashSet<ColumnFQ> colSet = null;
        if (columns != null) {
            colSet = new HashSet<ColumnFQ>(columns);
        }
        for (Map.Entry<Key, Value> entry : tabletKeyValues.entrySet()) {
            ColumnFQ currentKey = new ColumnFQ(entry.getKey());
            if (columns != null && !colSet.contains(currentKey)) continue;
            Text row = entry.getKey().getRow();
            SortedMap<ColumnFQ, Value> colVals = tabletEntries.get(row);
            if (colVals == null) {
                colVals = new TreeMap<ColumnFQ, Value>();
                tabletEntries.put(row, colVals);
            }
            colVals.put(currentKey, entry.getValue());
        }
        return tabletEntries;
    }

    private static class LogEntryIterator
    implements Iterator<LogEntry> {
        Iterator<LogEntry> zookeeperEntries = null;
        Iterator<LogEntry> rootTableEntries = null;
        Iterator<Map.Entry<Key, Value>> metadataEntries = null;

        LogEntryIterator(ServerContext context) throws IOException, KeeperException, InterruptedException {
            this.zookeeperEntries = MetadataTableUtil.getLogEntries(context, RootTable.EXTENT).iterator();
            this.rootTableEntries = MetadataTableUtil.getLogEntries(context, new KeyExtent(MetadataTable.ID, null, null)).iterator();
            try {
                Scanner scanner = context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
                log.info("Setting range to {}", (Object)MetadataSchema.TabletsSection.getRange());
                scanner.setRange(MetadataSchema.TabletsSection.getRange());
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                this.metadataEntries = scanner.iterator();
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.zookeeperEntries.hasNext() || this.rootTableEntries.hasNext() || this.metadataEntries.hasNext();
        }

        @Override
        public LogEntry next() {
            if (this.zookeeperEntries.hasNext()) {
                return this.zookeeperEntries.next();
            }
            if (this.rootTableEntries.hasNext()) {
                return this.rootTableEntries.next();
            }
            Map.Entry<Key, Value> entry = this.metadataEntries.next();
            return LogEntry.fromKeyValue((Key)entry.getKey(), (Value)entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface ZooOperation {
        public void run(IZooReaderWriter var1) throws KeeperException, InterruptedException, IOException;
    }
}

