/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.clone;

import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.clone.CloneInfo;
import org.slf4j.LoggerFactory;

class FinishCloneTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public FinishCloneTable(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) {
        environment.getTableManager().transitionTableState(this.cloneInfo.tableId, TableState.ONLINE);
        Utils.unreserveNamespace(environment, this.cloneInfo.srcNamespaceId, tid, false);
        if (!this.cloneInfo.srcNamespaceId.equals((Object)this.cloneInfo.namespaceId)) {
            Utils.unreserveNamespace(environment, this.cloneInfo.namespaceId, tid, false);
        }
        Utils.unreserveTable(environment, this.cloneInfo.srcTableId, tid, false);
        Utils.unreserveTable(environment, this.cloneInfo.tableId, tid, true);
        environment.getEventCoordinator().event("Cloned table %s from %s", this.cloneInfo.tableName, this.cloneInfo.srcTableId);
        LoggerFactory.getLogger(FinishCloneTable.class).debug("Cloned table " + this.cloneInfo.srcTableId + " " + this.cloneInfo.tableId + " " + this.cloneInfo.tableName);
        return null;
    }

    @Override
    public void undo(long tid, Master environment) {
    }
}

