/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.bulkVer2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.bulk.BulkSerialize;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.fate.FateTxId;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.bulkVer2.BulkInfo;
import org.apache.accumulo.master.tableOps.bulkVer2.LoadFiles;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkImportMove
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BulkImportMove.class);
    private final BulkInfo bulkInfo;

    public BulkImportMove(BulkInfo bulkInfo) {
        this.bulkInfo = bulkInfo;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Path bulkDir = new Path(this.bulkInfo.bulkDir);
        Path sourceDir = new Path(this.bulkInfo.sourceDir);
        String fmtTid = FateTxId.formatTid((long)tid);
        log.debug("{} sourceDir {}", (Object)fmtTid, (Object)sourceDir);
        VolumeManager fs = master.getFileSystem();
        if (this.bulkInfo.tableState == TableState.ONLINE) {
            TransactionWatcher.ZooArbitrator.start((ServerContext)master.getContext(), (String)"bulkTx", (long)tid);
        }
        try {
            Map oldToNewNameMap = BulkSerialize.readRenameMap((String)bulkDir.toString(), p -> fs.open(p));
            this.moveFiles(tid, sourceDir, bulkDir, master, fs, oldToNewNameMap);
            return new LoadFiles(this.bulkInfo);
        }
        catch (Exception ex) {
            throw new AcceptableThriftTableOperationException(this.bulkInfo.tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_BAD_INPUT_DIRECTORY, this.bulkInfo.sourceDir + ": " + ex);
        }
    }

    private void moveFiles(long tid, Path sourceDir, Path bulkDir, Master master, VolumeManager fs, Map<String, String> renames) throws Exception {
        MetadataTableUtil.addBulkLoadInProgressFlag((ServerContext)master.getContext(), (String)("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName()), (long)tid);
        int workerCount = master.getConfiguration().getCount(Property.MASTER_BULK_RENAME_THREADS);
        SimpleThreadPool workers = new SimpleThreadPool(workerCount, "bulkDir move");
        ArrayList<Future> results = new ArrayList<Future>();
        String fmtTid = FateTxId.formatTid((long)tid);
        for (Map.Entry<String, String> renameEntry : renames.entrySet()) {
            results.add(workers.submit(() -> {
                boolean success;
                Path originalPath = new Path(sourceDir, (String)renameEntry.getKey());
                Path newPath = new Path(bulkDir, (String)renameEntry.getValue());
                try {
                    success = fs.rename(originalPath, newPath);
                }
                catch (IOException e) {
                    if (!fs.exists(newPath) || fs.exists(originalPath)) {
                        throw e;
                    }
                    log.debug("Ingoring rename exception because destination already exists. {} orig: {} new: {}", new Object[]{fmtTid, originalPath, newPath, e});
                    success = true;
                }
                if (!success && fs.exists(newPath) && !fs.exists(originalPath)) {
                    log.debug("Ingoring rename failure because destination already exists. {} orig: {} new: {}", new Object[]{fmtTid, originalPath, newPath});
                    success = true;
                }
                if (success && log.isTraceEnabled()) {
                    log.trace("{} moved {} to {}", new Object[]{fmtTid, originalPath, newPath});
                }
                return success;
            }));
        }
        workers.shutdown();
        while (!workers.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        for (Future future : results) {
            try {
                if (((Boolean)future.get()).booleanValue()) continue;
                throw new AcceptableThriftTableOperationException(this.bulkInfo.tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.OTHER, "Failed to move files from " + this.bulkInfo.sourceDir);
            }
            catch (ExecutionException ee) {
                throw new AcceptableThriftTableOperationException(this.bulkInfo.tableId.canonical(), null, TableOperation.BULK_IMPORT, TableOperationExceptionType.OTHER, ee.getCause().getMessage());
            }
        }
    }
}

