/*  Zutils - Utilities dealing with compressed files
    Copyright (C) 2009-2018 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

bool next_filename( std::list< std::string > & filenames,
                    std::string & input_filename, bool & error,
                    const bool recursive, const bool ignore_stdin = false,
                    const bool no_messages = false )
  {
  while( !filenames.empty() )
    {
    input_filename = filenames.front();
    filenames.pop_front();
    if( input_filename.empty() || input_filename == "-" )
      {
      if( ignore_stdin ) continue;
      input_filename.clear(); return true;
      }
    if( recursive )
      {
      struct stat st;
      if( stat( input_filename.c_str(), &st ) == 0 && S_ISDIR( st.st_mode ) )
        {
        DIR * const dirp = opendir( input_filename.c_str() );
        if( !dirp )
          {
          if( !no_messages )
            show_error2( "Can't open directory", input_filename.c_str() );
          error = true; continue;
          }
        std::list< std::string > tmp_list;
        while( true )
          {
          const struct dirent * const entryp = readdir( dirp );
          if( !entryp ) { closedir( dirp ); break; }
          const std::string tmp_name( entryp->d_name );
          if( tmp_name == "." || tmp_name == ".." ) continue;
          const std::string full_name( input_filename + "/" + tmp_name );
          if( enabled_format( extension_format( extension_index( tmp_name ) ) ) ||
              ( stat( full_name.c_str(), &st ) == 0 && S_ISDIR( st.st_mode ) ) )
            tmp_list.push_back( full_name );
          }
        filenames.splice( filenames.begin(), tmp_list );
        continue;
        }
      }
    return true;
    }
  input_filename.clear();
  return false;
  }
