/*------------------------------------------------------------------------------
 *
 * Copyright (c) 2011-2025, EURid vzw. All rights reserved.
 * The YADIFA TM software product is provided under the BSD 3-clause license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *        * Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *        * Redistributions in binary form must reproduce the above copyright
 *          notice, this list of conditions and the following disclaimer in the
 *          documentation and/or other materials provided with the distribution.
 *        * Neither the name of EURid nor the names of its contributors may be
 *          used to endorse or promote products derived from this software
 *          without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *----------------------------------------------------------------------------*/

/**-----------------------------------------------------------------------------
 * @defgroup nsec3 NSEC3 functions
 * @ingroup dnsdbdnssec
 * @brief
 *
 *
 *
 * @{
 *----------------------------------------------------------------------------*/
#pragma once

#ifdef __cplusplus
extern "C"
{
#endif

struct chain_replay_s;

typedef ya_result chain_replay_record_add_method(struct chain_replay_s *cr, const uint8_t *fqdn, uint16_t rtype, const zdb_ttlrdata *ttlrdata);
typedef ya_result chain_replay_record_del_method(struct chain_replay_s *cr, const uint8_t *fqdn, uint16_t rtype, const zdb_ttlrdata *ttlrdata);
typedef ya_result chain_replay_execute_method(struct chain_replay_s *cr);
typedef void      chain_replay_finalize_method(struct chain_replay_s *cr);

struct chain_replay_vtbl
{
    chain_replay_record_add_method *const record_add;
    chain_replay_record_del_method *const record_del;
    chain_replay_execute_method *const    execute;
    chain_replay_finalize_method *const   finalise;
    const char                           *__class__;
};

struct chain_replay_s
{
    const struct chain_replay_vtbl *vtbl;
    void                           *data;
};

typedef struct chain_replay_s chain_replay_t;

#ifdef __cplusplus
}
#endif

/** @} */
