# -*- coding: utf-8 -*-
# vim:fenc=utf-8

# Copyright (C) 2012-2019 by Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
#
# X2Go Session Broker is free software; you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# X2Go Session Broker is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""\
:class:`x2gobroker.brokers.zeroconf_broker.X2GoBroker` class - a demo X2GoBroker implementations that needs not configuration at all

"""
__NAME__ = 'x2gobroker-pylib'

# modules
import uuid

# Python X2GoBroker modules
import x2gobroker.brokers.base_broker as base

class X2GoBroker(base.X2GoBroker):

    backend_name = 'zeroconf'

    def list_profiles(self, username):
        """\

        Retrieve a list of session profiles for the authenticated user.

        With the ``zeroconf`` broker backend, this list of session profiles is
        hard-coded. This if for testing purposes, only.

        :param username: query session profile list for this user
        :type username: ``str``

        :returns: list of profile dictionaries
        :rtype: ``dict``

        """
        _list_of_profiles = {
            uuid.uuid4(): {
                'user': '',
                'defsndport': True,
                'useiconv': False,
                'iconvfrom': 'UTF-8',
                'height': 600,
                'export': '',
                'quality': 9,
                'fullscreen': False,
                'layout': '',
                'useexports': 1,
                'width': 800,
                'speed': 2,
                'soundsystem': 'pulse',
                'print': True,
                'type': 'auto',
                'sndport': 4713,
                'xinerama': True,
                'variant': '',
                'usekbd': True,
                'fstunnel': True,
                'applications': ['TERMINAL','WWWBROWSER','MAILCLIENT','OFFICE',],
                'host': 'localhost',
                'multidisp': 0,
                'sshproxyport': 22,
                'sound': True,
                'rootless': 0,
                'name': 'LOCALHOST',
                'iconvto': 'UTF-8',
                'soundtunnel': True,
                'command': self.get_backend_value('broker_{backend}'.format(backend=self.backend_name), 'desktop-shell').upper(),
                'dpi': 96,
                'sshport': 22,
                'setdpi': 0,
                'pack': '16m-jpeg',
            },
        }
        list_of_profiles = {}
        for profile_id in list(_list_of_profiles.keys()):
            profile = self.get_profile_defaults()
            profile.update(_list_of_profiles[profile_id])
            list_of_profiles[profile_id] = profile
        return list_of_profiles

    def select_session(self, profile_id, username=None, **kwargs):
        """\
        Start/resume a session by selecting a profile name offered by the
        X2Go client.

        With the ``zeroconf`` broker backend, the X2Go server that the
        session is launched on is hard-coded (localhost, port 22). This
        is for testing purposes only.

        :param profile_id: the selected profile ID. This matches one of the dictionary
            keys offered by the ``list_profiles`` method
        :type profile_id: ``str``
        :param username: specify X2Go Server username that this operation runs for
        :type username: ``str``
        :param pubkey: The broker clients may send us a public key that we may
            temporarily install into a remote X2Go Server for non-interactive login
        :type pubkey: ``str``

        :returns: the seclected session (X2Go session ID)
        :rtype: ``str``

        """
        selectprofile_output = {
            'server': 'localhost',
            'port': 22,
        }
        return selectprofile_output
