// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_2_0_autogen.cpp:
//   Capture functions for the OpenGL ES 2.0 entry points.

#include "libANGLE/capture_gles_2_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationES2.h"

using namespace angle;

namespace gl
{

CallCapture CaptureActiveTexture(const State &glState, bool isCallValid, GLenum texture)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", GLenumGroup::TextureUnit, ParamType::TGLenum, texture);

    return CallCapture(gl::EntryPoint::ActiveTexture, std::move(paramBuffer));
}

CallCapture CaptureAttachShader(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(gl::EntryPoint::AttachShader, std::move(paramBuffer));
}

CallCapture CaptureBindAttribLocation(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLuint index,
                                      const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureBindAttribLocation_name(glState, isCallValid, programPacked, index, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::BindAttribLocation, std::move(paramBuffer));
}

CallCapture CaptureBindBuffer(const State &glState,
                              bool isCallValid,
                              BufferBinding targetPacked,
                              BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(gl::EntryPoint::BindBuffer, std::move(paramBuffer));
}

CallCapture CaptureBindFramebuffer(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   FramebufferID framebufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    return CallCapture(gl::EntryPoint::BindFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureBindRenderbuffer(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(gl::EntryPoint::BindRenderbuffer, std::move(paramBuffer));
}

CallCapture CaptureBindTexture(const State &glState,
                               bool isCallValid,
                               TextureType targetPacked,
                               TextureID texturePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);

    return CallCapture(gl::EntryPoint::BindTexture, std::move(paramBuffer));
}

CallCapture CaptureBlendColor(const State &glState,
                              bool isCallValid,
                              GLfloat red,
                              GLfloat green,
                              GLfloat blue,
                              GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture(gl::EntryPoint::BlendColor, std::move(paramBuffer));
}

CallCapture CaptureBlendEquation(const State &glState, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(gl::EntryPoint::BlendEquation, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparate(const State &glState,
                                         bool isCallValid,
                                         GLenum modeRGB,
                                         GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("modeRGB", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(gl::EntryPoint::BlendEquationSeparate, std::move(paramBuffer));
}

CallCapture CaptureBlendFunc(const State &glState, bool isCallValid, GLenum sfactor, GLenum dfactor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("sfactor", GLenumGroup::BlendingFactor, ParamType::TGLenum, sfactor);
    paramBuffer.addEnumParam("dfactor", GLenumGroup::BlendingFactor, ParamType::TGLenum, dfactor);

    return CallCapture(gl::EntryPoint::BlendFunc, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparate(const State &glState,
                                     bool isCallValid,
                                     GLenum sfactorRGB,
                                     GLenum dfactorRGB,
                                     GLenum sfactorAlpha,
                                     GLenum dfactorAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("sfactorRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum,
                             sfactorRGB);
    paramBuffer.addEnumParam("dfactorRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum,
                             dfactorRGB);
    paramBuffer.addEnumParam("sfactorAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum,
                             sfactorAlpha);
    paramBuffer.addEnumParam("dfactorAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum,
                             dfactorAlpha);

    return CallCapture(gl::EntryPoint::BlendFuncSeparate, std::move(paramBuffer));
}

CallCapture CaptureBufferData(const State &glState,
                              bool isCallValid,
                              BufferBinding targetPacked,
                              GLsizeiptr size,
                              const void *data,
                              BufferUsage usagePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureBufferData_data(glState, isCallValid, targetPacked, size, data, usagePacked, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    paramBuffer.addValueParam("usagePacked", ParamType::TBufferUsage, usagePacked);

    return CallCapture(gl::EntryPoint::BufferData, std::move(paramBuffer));
}

CallCapture CaptureBufferSubData(const State &glState,
                                 bool isCallValid,
                                 BufferBinding targetPacked,
                                 GLintptr offset,
                                 GLsizeiptr size,
                                 const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureBufferSubData_data(glState, isCallValid, targetPacked, offset, size, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::BufferSubData, std::move(paramBuffer));
}

CallCapture CaptureCheckFramebufferStatus(const State &glState,
                                          bool isCallValid,
                                          GLenum target,
                                          GLenum returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::CheckFramebufferStatus, std::move(paramBuffer));
}

CallCapture CaptureClear(const State &glState, bool isCallValid, GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mask", GLenumGroup::ClearBufferMask, ParamType::TGLbitfield, mask);

    return CallCapture(gl::EntryPoint::Clear, std::move(paramBuffer));
}

CallCapture CaptureClearColor(const State &glState,
                              bool isCallValid,
                              GLfloat red,
                              GLfloat green,
                              GLfloat blue,
                              GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture(gl::EntryPoint::ClearColor, std::move(paramBuffer));
}

CallCapture CaptureClearDepthf(const State &glState, bool isCallValid, GLfloat d)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("d", ParamType::TGLfloat, d);

    return CallCapture(gl::EntryPoint::ClearDepthf, std::move(paramBuffer));
}

CallCapture CaptureClearStencil(const State &glState, bool isCallValid, GLint s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLint, s);

    return CallCapture(gl::EntryPoint::ClearStencil, std::move(paramBuffer));
}

CallCapture CaptureColorMask(const State &glState,
                             bool isCallValid,
                             GLboolean red,
                             GLboolean green,
                             GLboolean blue,
                             GLboolean alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLboolean, red);
    paramBuffer.addValueParam("green", ParamType::TGLboolean, green);
    paramBuffer.addValueParam("blue", ParamType::TGLboolean, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLboolean, alpha);

    return CallCapture(gl::EntryPoint::ColorMask, std::move(paramBuffer));
}

CallCapture CaptureCompileShader(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(gl::EntryPoint::CompileShader, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage2D(const State &glState,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexImage2D_data(glState, isCallValid, targetPacked, level, internalformat,
                                     width, height, border, imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexImage2D, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage2D(const State &glState,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
    CaptureCompressedTexSubImage2D_data(glState, isCallValid, targetPacked, level, xoffset, yoffset,
                                        width, height, format, imageSize, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::CompressedTexSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureCopyTexImage2D(const State &glState,
                                  bool isCallValid,
                                  TextureTarget targetPacked,
                                  GLint level,
                                  GLenum internalformat,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLint border)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);

    return CallCapture(gl::EntryPoint::CopyTexImage2D, std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage2D(const State &glState,
                                     bool isCallValid,
                                     TextureTarget targetPacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width,
                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::CopyTexSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureCreateProgram(const State &glState, bool isCallValid, GLuint returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::CreateProgram, std::move(paramBuffer));
}

CallCapture CaptureCreateShader(const State &glState,
                                bool isCallValid,
                                ShaderType typePacked,
                                GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TShaderType, typePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::CreateShader, std::move(paramBuffer));
}

CallCapture CaptureCullFace(const State &glState, bool isCallValid, CullFaceMode modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TCullFaceMode, modePacked);

    return CallCapture(gl::EntryPoint::CullFace, std::move(paramBuffer));
}

CallCapture CaptureDeleteBuffers(const State &glState,
                                 bool isCallValid,
                                 GLsizei n,
                                 const BufferID *buffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
    InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
    CaptureDeleteBuffers_buffersPacked(glState, isCallValid, n, buffersPacked, &buffersPackedParam);
    paramBuffer.addParam(std::move(buffersPackedParam));

    return CallCapture(gl::EntryPoint::DeleteBuffers, std::move(paramBuffer));
}

CallCapture CaptureDeleteFramebuffers(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      const FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersPackedParam("framebuffersPacked",
                                         ParamType::TFramebufferIDConstPointer);
    InitParamValue(ParamType::TFramebufferIDConstPointer, framebuffersPacked,
                   &framebuffersPackedParam.value);
    CaptureDeleteFramebuffers_framebuffersPacked(glState, isCallValid, n, framebuffersPacked,
                                                 &framebuffersPackedParam);
    paramBuffer.addParam(std::move(framebuffersPackedParam));

    return CallCapture(gl::EntryPoint::DeleteFramebuffers, std::move(paramBuffer));
}

CallCapture CaptureDeleteProgram(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(gl::EntryPoint::DeleteProgram, std::move(paramBuffer));
}

CallCapture CaptureDeleteRenderbuffers(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       const RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                          ParamType::TRenderbufferIDConstPointer);
    InitParamValue(ParamType::TRenderbufferIDConstPointer, renderbuffersPacked,
                   &renderbuffersPackedParam.value);
    CaptureDeleteRenderbuffers_renderbuffersPacked(glState, isCallValid, n, renderbuffersPacked,
                                                   &renderbuffersPackedParam);
    paramBuffer.addParam(std::move(renderbuffersPackedParam));

    return CallCapture(gl::EntryPoint::DeleteRenderbuffers, std::move(paramBuffer));
}

CallCapture CaptureDeleteShader(const State &glState,
                                bool isCallValid,
                                ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(gl::EntryPoint::DeleteShader, std::move(paramBuffer));
}

CallCapture CaptureDeleteTextures(const State &glState,
                                  bool isCallValid,
                                  GLsizei n,
                                  const TextureID *texturesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
    InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked, &texturesPackedParam.value);
    CaptureDeleteTextures_texturesPacked(glState, isCallValid, n, texturesPacked,
                                         &texturesPackedParam);
    paramBuffer.addParam(std::move(texturesPackedParam));

    return CallCapture(gl::EntryPoint::DeleteTextures, std::move(paramBuffer));
}

CallCapture CaptureDepthFunc(const State &glState, bool isCallValid, GLenum func)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("func", GLenumGroup::DepthFunction, ParamType::TGLenum, func);

    return CallCapture(gl::EntryPoint::DepthFunc, std::move(paramBuffer));
}

CallCapture CaptureDepthMask(const State &glState, bool isCallValid, GLboolean flag)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("flag", ParamType::TGLboolean, flag);

    return CallCapture(gl::EntryPoint::DepthMask, std::move(paramBuffer));
}

CallCapture CaptureDepthRangef(const State &glState, bool isCallValid, GLfloat n, GLfloat f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLfloat, n);
    paramBuffer.addValueParam("f", ParamType::TGLfloat, f);

    return CallCapture(gl::EntryPoint::DepthRangef, std::move(paramBuffer));
}

CallCapture CaptureDetachShader(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(gl::EntryPoint::DetachShader, std::move(paramBuffer));
}

CallCapture CaptureDisable(const State &glState, bool isCallValid, GLenum cap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("cap", GLenumGroup::EnableCap, ParamType::TGLenum, cap);

    return CallCapture(gl::EntryPoint::Disable, std::move(paramBuffer));
}

CallCapture CaptureDisableVertexAttribArray(const State &glState, bool isCallValid, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::DisableVertexAttribArray, std::move(paramBuffer));
}

CallCapture CaptureDrawArrays(const State &glState,
                              bool isCallValid,
                              PrimitiveMode modePacked,
                              GLint first,
                              GLsizei count)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    return CallCapture(gl::EntryPoint::DrawArrays, std::move(paramBuffer));
}

CallCapture CaptureDrawElements(const State &glState,
                                bool isCallValid,
                                PrimitiveMode modePacked,
                                GLsizei count,
                                DrawElementsType typePacked,
                                const void *indices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
    CaptureDrawElements_indices(glState, isCallValid, modePacked, count, typePacked, indices,
                                &indicesParam);
    paramBuffer.addParam(std::move(indicesParam));

    return CallCapture(gl::EntryPoint::DrawElements, std::move(paramBuffer));
}

CallCapture CaptureEnable(const State &glState, bool isCallValid, GLenum cap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("cap", GLenumGroup::EnableCap, ParamType::TGLenum, cap);

    return CallCapture(gl::EntryPoint::Enable, std::move(paramBuffer));
}

CallCapture CaptureEnableVertexAttribArray(const State &glState, bool isCallValid, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::EnableVertexAttribArray, std::move(paramBuffer));
}

CallCapture CaptureFinish(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::Finish, std::move(paramBuffer));
}

CallCapture CaptureFlush(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::Flush, std::move(paramBuffer));
}

CallCapture CaptureFramebufferRenderbuffer(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           GLenum renderbuffertarget,
                                           RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("renderbuffertarget", GLenumGroup::RenderbufferTarget,
                             ParamType::TGLenum, renderbuffertarget);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(gl::EntryPoint::FramebufferRenderbuffer, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2D(const State &glState,
                                        bool isCallValid,
                                        GLenum target,
                                        GLenum attachment,
                                        TextureTarget textargetPacked,
                                        TextureID texturePacked,
                                        GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(gl::EntryPoint::FramebufferTexture2D, std::move(paramBuffer));
}

CallCapture CaptureFrontFace(const State &glState, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", GLenumGroup::FrontFaceDirection, ParamType::TGLenum, mode);

    return CallCapture(gl::EntryPoint::FrontFace, std::move(paramBuffer));
}

CallCapture CaptureGenBuffers(const State &glState,
                              bool isCallValid,
                              GLsizei n,
                              BufferID *buffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDPointer);
    InitParamValue(ParamType::TBufferIDPointer, buffersPacked, &buffersPackedParam.value);
    CaptureGenBuffers_buffersPacked(glState, isCallValid, n, buffersPacked, &buffersPackedParam);
    paramBuffer.addParam(std::move(buffersPackedParam));

    return CallCapture(gl::EntryPoint::GenBuffers, std::move(paramBuffer));
}

CallCapture CaptureGenFramebuffers(const State &glState,
                                   bool isCallValid,
                                   GLsizei n,
                                   FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersPackedParam("framebuffersPacked", ParamType::TFramebufferIDPointer);
    InitParamValue(ParamType::TFramebufferIDPointer, framebuffersPacked,
                   &framebuffersPackedParam.value);
    CaptureGenFramebuffers_framebuffersPacked(glState, isCallValid, n, framebuffersPacked,
                                              &framebuffersPackedParam);
    paramBuffer.addParam(std::move(framebuffersPackedParam));

    return CallCapture(gl::EntryPoint::GenFramebuffers, std::move(paramBuffer));
}

CallCapture CaptureGenRenderbuffers(const State &glState,
                                    bool isCallValid,
                                    GLsizei n,
                                    RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersPackedParam("renderbuffersPacked", ParamType::TRenderbufferIDPointer);
    InitParamValue(ParamType::TRenderbufferIDPointer, renderbuffersPacked,
                   &renderbuffersPackedParam.value);
    CaptureGenRenderbuffers_renderbuffersPacked(glState, isCallValid, n, renderbuffersPacked,
                                                &renderbuffersPackedParam);
    paramBuffer.addParam(std::move(renderbuffersPackedParam));

    return CallCapture(gl::EntryPoint::GenRenderbuffers, std::move(paramBuffer));
}

CallCapture CaptureGenTextures(const State &glState,
                               bool isCallValid,
                               GLsizei n,
                               TextureID *texturesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDPointer);
    InitParamValue(ParamType::TTextureIDPointer, texturesPacked, &texturesPackedParam.value);
    CaptureGenTextures_texturesPacked(glState, isCallValid, n, texturesPacked,
                                      &texturesPackedParam);
    paramBuffer.addParam(std::move(texturesPackedParam));

    return CallCapture(gl::EntryPoint::GenTextures, std::move(paramBuffer));
}

CallCapture CaptureGenerateMipmap(const State &glState, bool isCallValid, TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(gl::EntryPoint::GenerateMipmap, std::move(paramBuffer));
}

CallCapture CaptureGetActiveAttrib(const State &glState,
                                   bool isCallValid,
                                   ShaderProgramID programPacked,
                                   GLuint index,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLint *size,
                                   GLenum *type,
                                   GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetActiveAttrib_length(glState, isCallValid, programPacked, index, bufSize, length, size,
                                  type, name, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, size, &sizeParam.value);
    CaptureGetActiveAttrib_size(glState, isCallValid, programPacked, index, bufSize, length, size,
                                type, name, &sizeParam);
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
    CaptureGetActiveAttrib_type(glState, isCallValid, programPacked, index, bufSize, length, size,
                                type, name, &typeParam);
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
    CaptureGetActiveAttrib_name(glState, isCallValid, programPacked, index, bufSize, length, size,
                                type, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::GetActiveAttrib, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniform(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLuint index,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *size,
                                    GLenum *type,
                                    GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetActiveUniform_length(glState, isCallValid, programPacked, index, bufSize, length,
                                   size, type, name, &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, size, &sizeParam.value);
    CaptureGetActiveUniform_size(glState, isCallValid, programPacked, index, bufSize, length, size,
                                 type, name, &sizeParam);
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
    CaptureGetActiveUniform_type(glState, isCallValid, programPacked, index, bufSize, length, size,
                                 type, name, &typeParam);
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
    CaptureGetActiveUniform_name(glState, isCallValid, programPacked, index, bufSize, length, size,
                                 type, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(gl::EntryPoint::GetActiveUniform, std::move(paramBuffer));
}

CallCapture CaptureGetAttachedShaders(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLsizei maxCount,
                                      GLsizei *count,
                                      ShaderProgramID *shadersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("maxCount", ParamType::TGLsizei, maxCount);

    ParamCapture countParam("count", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, count, &countParam.value);
    CaptureGetAttachedShaders_count(glState, isCallValid, programPacked, maxCount, count,
                                    shadersPacked, &countParam);
    paramBuffer.addParam(std::move(countParam));

    ParamCapture shadersPackedParam("shadersPacked", ParamType::TShaderProgramIDPointer);
    InitParamValue(ParamType::TShaderProgramIDPointer, shadersPacked, &shadersPackedParam.value);
    CaptureGetAttachedShaders_shadersPacked(glState, isCallValid, programPacked, maxCount, count,
                                            shadersPacked, &shadersPackedParam);
    paramBuffer.addParam(std::move(shadersPackedParam));

    return CallCapture(gl::EntryPoint::GetAttachedShaders, std::move(paramBuffer));
}

CallCapture CaptureGetAttribLocation(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     const GLchar *name,
                                     GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetAttribLocation_name(glState, isCallValid, programPacked, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetAttribLocation, std::move(paramBuffer));
}

CallCapture CaptureGetBooleanv(const State &glState,
                               bool isCallValid,
                               GLenum pname,
                               GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
    InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
    CaptureGetBooleanv_data(glState, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetBooleanv, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteriv(const State &glState,
                                        bool isCallValid,
                                        BufferBinding targetPacked,
                                        GLenum pname,
                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetBufferParameteriv_params(glState, isCallValid, targetPacked, pname, params,
                                       &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetBufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetError(const State &glState, bool isCallValid, GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetError, std::move(paramBuffer));
}

CallCapture CaptureGetFloatv(const State &glState, bool isCallValid, GLenum pname, GLfloat *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, data, &dataParam.value);
    CaptureGetFloatv_data(glState, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetFloatv, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameteriv(const State &glState,
                                                       bool isCallValid,
                                                       GLenum target,
                                                       GLenum attachment,
                                                       GLenum pname,
                                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", GLenumGroup::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetFramebufferAttachmentParameteriv_params(glState, isCallValid, target, attachment,
                                                      pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetFramebufferAttachmentParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetIntegerv(const State &glState, bool isCallValid, GLenum pname, GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
    CaptureGetIntegerv_data(glState, isCallValid, pname, data, &dataParam);
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(gl::EntryPoint::GetIntegerv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramInfoLog(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetProgramInfoLog_length(glState, isCallValid, programPacked, bufSize, length, infoLog,
                                    &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
    CaptureGetProgramInfoLog_infoLog(glState, isCallValid, programPacked, bufSize, length, infoLog,
                                     &infoLogParam);
    paramBuffer.addParam(std::move(infoLogParam));

    return CallCapture(gl::EntryPoint::GetProgramInfoLog, std::move(paramBuffer));
}

CallCapture CaptureGetProgramiv(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                GLenum pname,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::ProgramPropertyARB, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetProgramiv_params(glState, isCallValid, programPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetProgramiv, std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameteriv(const State &glState,
                                              bool isCallValid,
                                              GLenum target,
                                              GLenum pname,
                                              GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::RenderbufferParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetRenderbufferParameteriv_params(glState, isCallValid, target, pname, params,
                                             &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetRenderbufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetShaderInfoLog(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID shaderPacked,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetShaderInfoLog_length(glState, isCallValid, shaderPacked, bufSize, length, infoLog,
                                   &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
    CaptureGetShaderInfoLog_infoLog(glState, isCallValid, shaderPacked, bufSize, length, infoLog,
                                    &infoLogParam);
    paramBuffer.addParam(std::move(infoLogParam));

    return CallCapture(gl::EntryPoint::GetShaderInfoLog, std::move(paramBuffer));
}

CallCapture CaptureGetShaderPrecisionFormat(const State &glState,
                                            bool isCallValid,
                                            GLenum shadertype,
                                            GLenum precisiontype,
                                            GLint *range,
                                            GLint *precision)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("shadertype", GLenumGroup::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addEnumParam("precisiontype", GLenumGroup::PrecisionType, ParamType::TGLenum,
                             precisiontype);

    ParamCapture rangeParam("range", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, range, &rangeParam.value);
    CaptureGetShaderPrecisionFormat_range(glState, isCallValid, shadertype, precisiontype, range,
                                          precision, &rangeParam);
    paramBuffer.addParam(std::move(rangeParam));

    ParamCapture precisionParam("precision", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, precision, &precisionParam.value);
    CaptureGetShaderPrecisionFormat_precision(glState, isCallValid, shadertype, precisiontype,
                                              range, precision, &precisionParam);
    paramBuffer.addParam(std::move(precisionParam));

    return CallCapture(gl::EntryPoint::GetShaderPrecisionFormat, std::move(paramBuffer));
}

CallCapture CaptureGetShaderSource(const State &glState,
                                   bool isCallValid,
                                   ShaderProgramID shaderPacked,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLchar *source)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
    CaptureGetShaderSource_length(glState, isCallValid, shaderPacked, bufSize, length, source,
                                  &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sourceParam("source", ParamType::TGLcharPointer);
    InitParamValue(ParamType::TGLcharPointer, source, &sourceParam.value);
    CaptureGetShaderSource_source(glState, isCallValid, shaderPacked, bufSize, length, source,
                                  &sourceParam);
    paramBuffer.addParam(std::move(sourceParam));

    return CallCapture(gl::EntryPoint::GetShaderSource, std::move(paramBuffer));
}

CallCapture CaptureGetShaderiv(const State &glState,
                               bool isCallValid,
                               ShaderProgramID shaderPacked,
                               GLenum pname,
                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::ShaderParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetShaderiv_params(glState, isCallValid, shaderPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetShaderiv, std::move(paramBuffer));
}

CallCapture CaptureGetString(const State &glState,
                             bool isCallValid,
                             GLenum name,
                             const GLubyte *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("name", GLenumGroup::StringName, ParamType::TGLenum, name);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLubyteConstPointer);
    InitParamValue(ParamType::TGLubyteConstPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetString, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterfv(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetTexParameterfv_params(glState, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameterfv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameteriv(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetTexParameteriv_params(glState, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetTexParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetUniformLocation(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      const GLchar *name,
                                      GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
    CaptureGetUniformLocation_name(glState, isCallValid, programPacked, name, &nameParam);
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetUniformLocation, std::move(paramBuffer));
}

CallCapture CaptureGetUniformfv(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                GLint location,
                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetUniformfv_params(glState, isCallValid, programPacked, location, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetUniformfv, std::move(paramBuffer));
}

CallCapture CaptureGetUniformiv(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                GLint location,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("location", ParamType::TGLint, location);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetUniformiv_params(glState, isCallValid, programPacked, location, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetUniformiv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribPointerv(const State &glState,
                                           bool isCallValid,
                                           GLuint index,
                                           GLenum pname,
                                           void **pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
    InitParamValue(ParamType::TvoidPointerPointer, pointer, &pointerParam.value);
    CaptureGetVertexAttribPointerv_pointer(glState, isCallValid, index, pname, pointer,
                                           &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribPointerv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribfv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum pname,
                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
    CaptureGetVertexAttribfv_params(glState, isCallValid, index, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribfv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum pname,
                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
    CaptureGetVertexAttribiv_params(glState, isCallValid, index, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::GetVertexAttribiv, std::move(paramBuffer));
}

CallCapture CaptureHint(const State &glState, bool isCallValid, GLenum target, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::HintTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("mode", GLenumGroup::HintMode, ParamType::TGLenum, mode);

    return CallCapture(gl::EntryPoint::Hint, std::move(paramBuffer));
}

CallCapture CaptureIsBuffer(const State &glState,
                            bool isCallValid,
                            BufferID bufferPacked,
                            GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsBuffer, std::move(paramBuffer));
}

CallCapture CaptureIsEnabled(const State &glState,
                             bool isCallValid,
                             GLenum cap,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("cap", GLenumGroup::EnableCap, ParamType::TGLenum, cap);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsEnabled, std::move(paramBuffer));
}

CallCapture CaptureIsFramebuffer(const State &glState,
                                 bool isCallValid,
                                 FramebufferID framebufferPacked,
                                 GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureIsProgram(const State &glState,
                             bool isCallValid,
                             ShaderProgramID programPacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsProgram, std::move(paramBuffer));
}

CallCapture CaptureIsRenderbuffer(const State &glState,
                                  bool isCallValid,
                                  RenderbufferID renderbufferPacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsRenderbuffer, std::move(paramBuffer));
}

CallCapture CaptureIsShader(const State &glState,
                            bool isCallValid,
                            ShaderProgramID shaderPacked,
                            GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsShader, std::move(paramBuffer));
}

CallCapture CaptureIsTexture(const State &glState,
                             bool isCallValid,
                             TextureID texturePacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsTexture, std::move(paramBuffer));
}

CallCapture CaptureLineWidth(const State &glState, bool isCallValid, GLfloat width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("width", ParamType::TGLfloat, width);

    return CallCapture(gl::EntryPoint::LineWidth, std::move(paramBuffer));
}

CallCapture CaptureLinkProgram(const State &glState,
                               bool isCallValid,
                               ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(gl::EntryPoint::LinkProgram, std::move(paramBuffer));
}

CallCapture CapturePixelStorei(const State &glState, bool isCallValid, GLenum pname, GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::PixelStoreParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(gl::EntryPoint::PixelStorei, std::move(paramBuffer));
}

CallCapture CapturePolygonOffset(const State &glState,
                                 bool isCallValid,
                                 GLfloat factor,
                                 GLfloat units)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLfloat, factor);
    paramBuffer.addValueParam("units", ParamType::TGLfloat, units);

    return CallCapture(gl::EntryPoint::PolygonOffset, std::move(paramBuffer));
}

CallCapture CaptureReadPixels(const State &glState,
                              bool isCallValid,
                              GLint x,
                              GLint y,
                              GLsizei width,
                              GLsizei height,
                              GLenum format,
                              GLenum type,
                              void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
    CaptureReadPixels_pixels(glState, isCallValid, x, y, width, height, format, type, pixels,
                             &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::ReadPixels, std::move(paramBuffer));
}

CallCapture CaptureReleaseShaderCompiler(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::ReleaseShaderCompiler, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorage(const State &glState,
                                       bool isCallValid,
                                       GLenum target,
                                       GLenum internalformat,
                                       GLsizei width,
                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::RenderbufferStorage, std::move(paramBuffer));
}

CallCapture CaptureSampleCoverage(const State &glState,
                                  bool isCallValid,
                                  GLfloat value,
                                  GLboolean invert)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);
    paramBuffer.addValueParam("invert", ParamType::TGLboolean, invert);

    return CallCapture(gl::EntryPoint::SampleCoverage, std::move(paramBuffer));
}

CallCapture CaptureScissor(const State &glState,
                           bool isCallValid,
                           GLint x,
                           GLint y,
                           GLsizei width,
                           GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::Scissor, std::move(paramBuffer));
}

CallCapture CaptureShaderBinary(const State &glState,
                                bool isCallValid,
                                GLsizei count,
                                const ShaderProgramID *shadersPacked,
                                GLenum binaryformat,
                                const void *binary,
                                GLsizei length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture shadersPackedParam("shadersPacked", ParamType::TShaderProgramIDConstPointer);
    InitParamValue(ParamType::TShaderProgramIDConstPointer, shadersPacked,
                   &shadersPackedParam.value);
    CaptureShaderBinary_shadersPacked(glState, isCallValid, count, shadersPacked, binaryformat,
                                      binary, length, &shadersPackedParam);
    paramBuffer.addParam(std::move(shadersPackedParam));

    paramBuffer.addEnumParam("binaryformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             binaryformat);

    ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
    CaptureShaderBinary_binary(glState, isCallValid, count, shadersPacked, binaryformat, binary,
                               length, &binaryParam);
    paramBuffer.addParam(std::move(binaryParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    return CallCapture(gl::EntryPoint::ShaderBinary, std::move(paramBuffer));
}

CallCapture CaptureShaderSource(const State &glState,
                                bool isCallValid,
                                ShaderProgramID shaderPacked,
                                GLsizei count,
                                const GLchar *const *string,
                                const GLint *length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture stringParam("string", ParamType::TGLcharConstPointerPointer);
    InitParamValue(ParamType::TGLcharConstPointerPointer, string, &stringParam.value);
    CaptureShaderSource_string(glState, isCallValid, shaderPacked, count, string, length,
                               &stringParam);
    paramBuffer.addParam(std::move(stringParam));

    ParamCapture lengthParam("length", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, length, &lengthParam.value);
    CaptureShaderSource_length(glState, isCallValid, shaderPacked, count, string, length,
                               &lengthParam);
    paramBuffer.addParam(std::move(lengthParam));

    return CallCapture(gl::EntryPoint::ShaderSource, std::move(paramBuffer));
}

CallCapture CaptureStencilFunc(const State &glState,
                               bool isCallValid,
                               GLenum func,
                               GLint ref,
                               GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("func", GLenumGroup::StencilFunction, ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(gl::EntryPoint::StencilFunc, std::move(paramBuffer));
}

CallCapture CaptureStencilFuncSeparate(const State &glState,
                                       bool isCallValid,
                                       GLenum face,
                                       GLenum func,
                                       GLint ref,
                                       GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::StencilFaceDirection, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("func", GLenumGroup::StencilFunction, ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(gl::EntryPoint::StencilFuncSeparate, std::move(paramBuffer));
}

CallCapture CaptureStencilMask(const State &glState, bool isCallValid, GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(gl::EntryPoint::StencilMask, std::move(paramBuffer));
}

CallCapture CaptureStencilMaskSeparate(const State &glState,
                                       bool isCallValid,
                                       GLenum face,
                                       GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::StencilFaceDirection, ParamType::TGLenum, face);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(gl::EntryPoint::StencilMaskSeparate, std::move(paramBuffer));
}

CallCapture CaptureStencilOp(const State &glState,
                             bool isCallValid,
                             GLenum fail,
                             GLenum zfail,
                             GLenum zpass)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("fail", GLenumGroup::StencilOp, ParamType::TGLenum, fail);
    paramBuffer.addEnumParam("zfail", GLenumGroup::StencilOp, ParamType::TGLenum, zfail);
    paramBuffer.addEnumParam("zpass", GLenumGroup::StencilOp, ParamType::TGLenum, zpass);

    return CallCapture(gl::EntryPoint::StencilOp, std::move(paramBuffer));
}

CallCapture CaptureStencilOpSeparate(const State &glState,
                                     bool isCallValid,
                                     GLenum face,
                                     GLenum sfail,
                                     GLenum dpfail,
                                     GLenum dppass)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLenumGroup::StencilFaceDirection, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("sfail", GLenumGroup::StencilOp, ParamType::TGLenum, sfail);
    paramBuffer.addEnumParam("dpfail", GLenumGroup::StencilOp, ParamType::TGLenum, dpfail);
    paramBuffer.addEnumParam("dppass", GLenumGroup::StencilOp, ParamType::TGLenum, dppass);

    return CallCapture(gl::EntryPoint::StencilOpSeparate, std::move(paramBuffer));
}

CallCapture CaptureTexImage2D(const State &glState,
                              bool isCallValid,
                              TextureTarget targetPacked,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexImage2D_pixels(glState, isCallValid, targetPacked, level, internalformat, width,
                             height, border, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexImage2D, std::move(paramBuffer));
}

CallCapture CaptureTexParameterf(const State &glState,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::TexParameterf, std::move(paramBuffer));
}

CallCapture CaptureTexParameterfv(const State &glState,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
    CaptureTexParameterfv_params(glState, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameterfv, std::move(paramBuffer));
}

CallCapture CaptureTexParameteri(const State &glState,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(gl::EntryPoint::TexParameteri, std::move(paramBuffer));
}

CallCapture CaptureTexParameteriv(const State &glState,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
    CaptureTexParameteriv_params(glState, isCallValid, targetPacked, pname, params, &paramsParam);
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(gl::EntryPoint::TexParameteriv, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage2D(const State &glState,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLint xoffset,
                                 GLint yoffset,
                                 GLsizei width,
                                 GLsizei height,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
    CaptureTexSubImage2D_pixels(glState, isCallValid, targetPacked, level, xoffset, yoffset, width,
                                height, format, type, pixels, &pixelsParam);
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(gl::EntryPoint::TexSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureUniform1f(const State &glState, bool isCallValid, GLint location, GLfloat v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);

    return CallCapture(gl::EntryPoint::Uniform1f, std::move(paramBuffer));
}

CallCapture CaptureUniform1fv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform1fv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform1fv, std::move(paramBuffer));
}

CallCapture CaptureUniform1i(const State &glState, bool isCallValid, GLint location, GLint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);

    return CallCapture(gl::EntryPoint::Uniform1i, std::move(paramBuffer));
}

CallCapture CaptureUniform1iv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform1iv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform1iv, std::move(paramBuffer));
}

CallCapture CaptureUniform2f(const State &glState,
                             bool isCallValid,
                             GLint location,
                             GLfloat v0,
                             GLfloat v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);

    return CallCapture(gl::EntryPoint::Uniform2f, std::move(paramBuffer));
}

CallCapture CaptureUniform2fv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform2fv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform2fv, std::move(paramBuffer));
}

CallCapture CaptureUniform2i(const State &glState,
                             bool isCallValid,
                             GLint location,
                             GLint v0,
                             GLint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);

    return CallCapture(gl::EntryPoint::Uniform2i, std::move(paramBuffer));
}

CallCapture CaptureUniform2iv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform2iv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform2iv, std::move(paramBuffer));
}

CallCapture CaptureUniform3f(const State &glState,
                             bool isCallValid,
                             GLint location,
                             GLfloat v0,
                             GLfloat v1,
                             GLfloat v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);

    return CallCapture(gl::EntryPoint::Uniform3f, std::move(paramBuffer));
}

CallCapture CaptureUniform3fv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform3fv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform3fv, std::move(paramBuffer));
}

CallCapture CaptureUniform3i(const State &glState,
                             bool isCallValid,
                             GLint location,
                             GLint v0,
                             GLint v1,
                             GLint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);

    return CallCapture(gl::EntryPoint::Uniform3i, std::move(paramBuffer));
}

CallCapture CaptureUniform3iv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform3iv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform3iv, std::move(paramBuffer));
}

CallCapture CaptureUniform4f(const State &glState,
                             bool isCallValid,
                             GLint location,
                             GLfloat v0,
                             GLfloat v1,
                             GLfloat v2,
                             GLfloat v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLfloat, v3);

    return CallCapture(gl::EntryPoint::Uniform4f, std::move(paramBuffer));
}

CallCapture CaptureUniform4fv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniform4fv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform4fv, std::move(paramBuffer));
}

CallCapture CaptureUniform4i(const State &glState,
                             bool isCallValid,
                             GLint location,
                             GLint v0,
                             GLint v1,
                             GLint v2,
                             GLint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLint, v3);

    return CallCapture(gl::EntryPoint::Uniform4i, std::move(paramBuffer));
}

CallCapture CaptureUniform4iv(const State &glState,
                              bool isCallValid,
                              GLint location,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
    CaptureUniform4iv_value(glState, isCallValid, location, count, value, &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::Uniform4iv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2fv(const State &glState,
                                    bool isCallValid,
                                    GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix2fv_value(glState, isCallValid, location, count, transpose, value,
                                  &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::UniformMatrix2fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3fv(const State &glState,
                                    bool isCallValid,
                                    GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix3fv_value(glState, isCallValid, location, count, transpose, value,
                                  &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::UniformMatrix3fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4fv(const State &glState,
                                    bool isCallValid,
                                    GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("location", ParamType::TGLint, location);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
    CaptureUniformMatrix4fv_value(glState, isCallValid, location, count, transpose, value,
                                  &valueParam);
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(gl::EntryPoint::UniformMatrix4fv, std::move(paramBuffer));
}

CallCapture CaptureUseProgram(const State &glState, bool isCallValid, ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(gl::EntryPoint::UseProgram, std::move(paramBuffer));
}

CallCapture CaptureValidateProgram(const State &glState,
                                   bool isCallValid,
                                   ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(gl::EntryPoint::ValidateProgram, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib1f(const State &glState, bool isCallValid, GLuint index, GLfloat x)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);

    return CallCapture(gl::EntryPoint::VertexAttrib1f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib1fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib1fv_v(glState, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(gl::EntryPoint::VertexAttrib1fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib2f(const State &glState,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);

    return CallCapture(gl::EntryPoint::VertexAttrib2f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib2fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib2fv_v(glState, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(gl::EntryPoint::VertexAttrib2fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib3f(const State &glState,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y,
                                  GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(gl::EntryPoint::VertexAttrib3f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib3fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib3fv_v(glState, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(gl::EntryPoint::VertexAttrib3fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib4f(const State &glState,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y,
                                  GLfloat z,
                                  GLfloat w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("w", ParamType::TGLfloat, w);

    return CallCapture(gl::EntryPoint::VertexAttrib4f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib4fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
    CaptureVertexAttrib4fv_v(glState, isCallValid, index, v, &vParam);
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(gl::EntryPoint::VertexAttrib4fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribPointer(const State &glState,
                                       bool isCallValid,
                                       GLuint index,
                                       GLint size,
                                       VertexAttribType typePacked,
                                       GLboolean normalized,
                                       GLsizei stride,
                                       const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
    CaptureVertexAttribPointer_pointer(glState, isCallValid, index, size, typePacked, normalized,
                                       stride, pointer, &pointerParam);
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(gl::EntryPoint::VertexAttribPointer, std::move(paramBuffer));
}

CallCapture CaptureViewport(const State &glState,
                            bool isCallValid,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::Viewport, std::move(paramBuffer));
}

}  // namespace gl
