target = euler1 euler2 euler3
\integer{n = \confparm1 = ?randint(5..6)}
\integer{n = \confparm1 = 1?randint(5..6)}
\integer{n = \confparm1 = 2?randint(7..8)}
\integer{n = \confparm1 = 3?randint(9..11)}

\text{ouinon = oui,non}

#if #TARGET (euler1)
 \title{Chanes eulriennes}
\author{Romain BOILLAUD}
\email{Romain.Boillaud@wanadoo.fr}
#endif

#if #TARGET (euler2)
 \title{Chanes ou cycles eulriens}
\author{Bernadette PERRIN-RIOU}
\email{bpr@math.u-psud.fr}
#endif

#if #TARGET (euler3)
 \title{Chanes ou cycles eulriens  II}
\author{Bernadette PERRIN-RIOU}
\email{bpr@math.u-psud.fr}
#endif

\language{fr}
\range{-30..30}

\computeanswer{no}
\format{html}
\precision{10000}
\text{test = 1}
\text{choix=randitem(1,2)}
#if #TARGET (euler1)

\text{G1 = \choix=1 ? slib(graph/randomconnex \n):slib(graph/randomeuler \n)}
\text{G = \choix =1 ? \G1 : item(1,\G1)}
\matrix{G = wims(declosing \G)}
\text{euler=\choix=2 ? item(2,\G1)}
\text{euler=wims(declosing \euler)}
\text{euler1=\choix=2 ? item(3,\G1)}
#endif

#if #TARGET (euler2) || #TARGET (euler3)
\if{\choix =1 }{\integer{m = randint(\n, min(floor(5*\n/2), \n*(\n-1)/2))}
\text{liste = wims(values 1 for x = 1 to \m)}
\text{liste0 = wims(values 0 for x = 1 to \n*(\n-1)/2 -\m)}
\text{liste = shuffle(\liste,\liste0)}
\matrix{G = pari(n = \n; liste = [\liste];
M = matrix(n,n,i,j,if(i<j, liste[n*(n-1)/2-(n-i+1)*(n-i)/2 +j-i]));
M = matrix(n,n,i,j,if(i<j,M[i,j],M[j,i]));print(M))}
}
{
\text{G =slib(graph/randomeuler \n)}
\text{G = item(1,\G)}
\text{euler=\choix=2 ? item(2,\Geuler)}
\text{euler=wims(declosing \euler)}
}
\matrix{G=wims(declosing \G)}
\text{cc = slib(graph/connexity [\G])}
\text{cc = \cc[1]}
\integer{ccc = min(2,\cc)}
#endif



\matrix{deg = pari(N = [\G]; 
  dg = vector(\n,i,0);
  for(i = 1,\n, dg[i] = sum(X = 1,\n,N[i,X]) );
  print(dg))
}
\integer{s = pari(deg = Vec([\deg]); sum(X = 1,\n,deg[X])/2)}

\integer{ns = 0}
\for{i = 1 to \n}{
  \integer{ns = item(\i,\deg)%2 = 0?\ns:\ns+1}
}
\integer{eul = (\ns = 0) or (\ns = 2)?1:0}
\integer{ceul = (\ns = 0) ?1:0}

\text{dessin = slib(graph/draw [\G])}
#if #TARGET (euler1)

\statement{On considre le graphe reprsent ci-dessous : 
<center> \draw{200,200}{\dessin} </center>
Donner une chane eulrienne de ce graphe (donner  la liste de ses sommets dans l'ordre,
spars par des virgules). Rpondre 0 s'il n'y en a aucune. 
}

\answer{Chane eulrienne}{\rep1}{type=vector}


\integer{m = items(\rep1)}
\matrix{v = pari(matrix(1,(\m)-1))}
\matrix{a = pari(matrix(\n,\n))}
\integer{b = 0}
\for{i = 1 to ((\m)-1)}{
  \integer{I = item(\i,\rep1)}
  \integer{J = item((\i)+1,\rep1)}
  \integer{u = item(\I,row(\J,\G))}
  \matrix{v = wims(replace item number \i by \u in \v)}
  \integer{u = item(\I,row(\J,\a))}
  \if{\u = 0}{
    \matrix{a = pari(A = [\a];A[\I,\J] = 1;A[\J,\I] = 1;print(A))}
    matrix{c = row(\J,\A)}
    matrix{c = wims(replace internal item number \I by 1 in \c)}
    matrix{A = wims(replace internal line number \J by \c in \A)}
  }{\integer{b = \i}}
}
\integer{r = 0 isin \v ?0:1}
\if{\b<>0}{\text{faute=wims(nospace \rep1)}
\text{faute1=\rep1[\b]}
\text{faute2=\rep1[\b+1]}

\text{faute =wims(replace internal \faute1,\faute2 by <font color=red><b>\faute1,\faute2</b></font> in \faute)}
\text{faute = wims(replace internal item \faute2,\faute1 by <font color=red><b>\faute2,\faute1
</b></font> in \faute)}
}

\integer{cmat = pari([\a] = = [\G])}
\condition{Chane eulrienne}{((\r = 1) and (\b = 0) and (\cmat = 1)) or ((\eul = 0) and (\rep1 = 0))}
\feedback{\m<>(\s)+1 and \rep1 <> 0}{La chane que vous avez entr ne contient pas le bon nombre de sommets.}
\if{\r = 0}{
  \integer{test = 0}
  \for{i = 1 to \n}{
    \if{item(\i,\v) = 0 and \test = 0}{\integer{test = \i}}
  }
}
\text{a1 = item(\test,\rep1)}
\text{a2 = item(\test+1,\rep1)}
\feedback{\r = 0}{Une des artes que vous avez cites n'en est pas une... Par exemple, il n'y a pas d'arte reliant les sommets \a1 et \a2.}
\feedback{\b <>0 }{Vous utilisez deux fois la mme arte :
\faute
}
\feedback{(\rep1 <> 0) and (\cmat = 0)}{Votre chane n'utilise pas toutes les artes du graphe.}
\text{bon=((\r = 1) and (\b = 0) and (\cmat = 1)) ? 1:0}

\text{eulerrep=\choix=2 ? \euler}
\text{eulerrep=\bon=1 ? \rep1}

\if {\choix=2 or \bon = 1}{
	\integer{m=items(\eulerrep)}
	\integer{dr=255}
	\integer{dg=0}
	\integer{db=255}
	\integer{fr=0}
	\integer{fg=255}
	\integer{fb=0}
	\integer{sr  = (\fr-\dr)/\m}
	\integer{sg = (\fg - \dg) / \m}
	\integer{sb = (\fb - \db) / \m}
	\text{couleur=}
	\for{i=0 to \m-2}
{\text{code=simplify(\dr+\i*(\sr)),simplify(\dg+\i*(\sg)),simplify(\db+\i*(\sb))}
\text{couleur=\couleur;  \eulerrep[\i+1],\eulerrep[\i+2], [\code]}
}
	\text{couleur =wims(nonempty items \couleur)}
	\text{dessin2= slib(graph/draw [\G],blue,blue,,[\couleur])}
}
\feedback{(\eul = 1) and \bon=0}{Le graphe contient une chane eulrienne d'aprs le thorme d'Euler.
\if{\choix = 2}{Par exemple, la chane \euler. 
<center>\draw{200,200}{\dessin2}</center>
}}
\feedback{(\eul = 1) and \bon=1}{Le graphe contient une chane eulrienne d'aprs le thorme d'Euler.
Et la chane \rep1 est bien une chane eulrienne : 
<center>\draw{200,200}{\dessin2}</center>
}

\feedback{(\eul = 0) and (\rep1 <> 0)}{Il n'y a pas de chane eulrienne dans ce graphe d'aprs le thorme d'Euler.}
\help{Une chane eulrienne est une chane passant exactement 
une fois par toutes les artes.

<p>Pour trouver une chane eulrienne d'extrmits 
\(A) et \(B), on prend une chane d'origine 
\(A)  et d'extrmit 
 \(B), ne contenant pas deux fois la mme arte. On adjoint ensuite 
 cette chane une chane ferme d'origine  un sommet de cette chane ou \(A)
  ou \(B), ne contenant pas deux fois la mme arte 
et ne contenant pas les artes dj utilises. 
   On obtient une nouvelle chane allant de \(A)  \(B) en recollant
 les deux chanes prcdentes. Et on recommence jusqu' avoir puis toutes les artes.
<p> Le thorme d'Euler dit qu'il existe une chane eulrienne si 
tous les sommets sauf au plus deux sont de degr pair. }
#endif

#if #TARGET (euler2) || #TARGET (euler3)
\text{cc=slib(graph/connexity [\G])}
\text{cc=\cc[1]}
\integer{ccc=min(2,\cc)}
\integer{eul=\ccc=1 ? 2-\eul:2}
\integer{ceul=\ccc=1 ? 2-\ceul:2}
#endif



#if #TARGET (euler2)
\text{lister = item(1..\n+3,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15,r16)}

\steps{\lister}

\statement{On considre le graphe reprsent ci-dessous : 
<center> \draw{200,200}{\dessin} </center>

Donner le degr de chacun des sommets. 
<table align = "center" border = 1 bgcolor = "navajowhite"><tr align = "center"> \for{k = 1 to \n}{<th>\k</th>}
</tr><tr align = "center">
 \for{k = 4 to \n+3}{<td>\embed{\lister[\k],5}</td>}</tr></table>

Le graphe est-il connexe \embed{reply1}?
 <p>
Existe-t-il <ul><li>une chane eulrienne  : \embed{reply2}? </li>
<li>un cycle eulrien \embed{reply3} ? </li> 
</ul>

}
\answer{}{\ccc;\ouinon}{type = radio}
\answer{}{\eul;\ouinon}{type = radio}
\answer{}{\ceul;\ouinon}{type = radio}
\answer{}{\deg[1]}{type = numeric}
\answer{}{\deg[2]}{type = numeric}
\answer{}{\deg[3]}{type = numeric}
\answer{}{\deg[4]}{type = numeric}
\answer{}{\deg[5]}{type = numeric}
\answer{}{\deg[6]}{type = numeric}
\answer{}{\deg[7]}{type = numeric}
\answer{}{\deg[8]}{type = numeric}
\answer{}{\deg[9]}{type = numeric}
\answer{}{\deg[11]}{type = numeric}
\answer{}{\deg[12]}{type = numeric}
\answer{}{\deg[13]}{type = numeric}
\answer{}{\deg[14]}{type = numeric}
\answer{}{\deg[15]}{type = numeric}
\answer{}{\deg[16]}{type = numeric}

#endif

\hint{Que dit le thorme d'Euler ?}
\text{dessin1 = \cc>1 ? slib(graph/drawcc [\G])}

#if #TARGET (euler2)
\feedback{\ccc = 2 and  (\reply2 = 1 or \reply3 = 1)}{Le graphe n'est pas connexe, il ne peut donc pas avoir de chanes ou de cycles eulriens : }
\feedback{\ccc = 1 and  \cc>1 }{Le graphe n'est pas connexe, il ne peut donc pas avoir de chanes ou de cycles eulriens : }
\feedback{\cc > 1}{\dessin1 <center> \draw{200,200}{\dessin1}</center>}

\feedback{\ccc = 1 and  (\reply2 = 1) and \eul = 2}{Par le thorme d'Euler, le graphe admet une chane eulrienne si et seulement s'il est connexe et si les degrs de tous les sommets sauf peut-tre deux sont pairs. }
\feedback{\ccc = 1 and  (\reply3 = 1) and \ceul = 2}{Par le thorme d'Euler, le graphe admet un cycle eulrien si et seulement s'il est connexe et si les degrs de tous les sommets sont pairs. }

#endif

#if #TARGET (euler3)

\statement{\On considre le graphe reprsent ci-dessous : 
<center> \draw{200,200}{\dessin} </center>

<p>
Existe-t-il <ul><li>une chane eulrienne  : \embed{reply 1}? </li>
<li>un cycle eulrien \embed{reply 2} ? </li> 
</ul>

}

\answer{}{\eul;\ouinon}{type = radio}
\answer{}{\ceul;\ouinon}{type = radio}

\feedback{ \cc>1 }{Le graphe n'est pas connexe, il ne peut donc pas avoir de chanes ou de cycles eulriens :
<center> \draw{200,200}{\dessin1}</center>}
\feedback{\cc = 1 and  \reply1<>2}{Par le thorme d'Euler, le graphe admet une chane eulrienne si et seulement s'il est connexe et si les degrs de tous les sommets sauf peut-tre deux sont pairs. }
\feedback{\cc = 1 and  \reply2 <> 2}{Par le thorme d'Euler, le graphe admet un cycle eulrien si et seulement s'il est connexe et si les degrs de tous les sommets sont pairs. }
#endif