# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
from distutils.core import setup

def MakeFileList(DirectoryPath):
    finalFiles = []
    for file in os.listdir(DirectoryPath):
      if os.path.isfile(os.path.join(DirectoryPath,file)) and file[len(file)-1]!='~' and file!=".svn": finalFiles.append (os.path.join(DirectoryPath,file))
    return finalFiles

setup(name = "videoporama",
      version = "0.8.1",
      description = "Videoporama - Application to make video of image slideshow",
      author = "Ponchaut Olivier - Levray Dominique",
      author_email = "videoporama@numericable.be",
      url = "http://www.videoporama.tuxfamily.org",
      data_files = [("./",[           "README",
                                      "INSTALL",
                                      "licences.txt",
                                      "about.py",
                                      "Configuration.py",
                                      "ConfigurationDlg.py",
                                      "DefText.py",
                                      "DefTextDlg.py",
                                      "DefZoomPoint.py",
                                      "DefZoomPointDlg.py",
                                      "DefMoviePoint.py",
                                      "DefMoviePointDlg.py",
                                      "DocHelpDlg.py",
                                      "Documentation.py",
                                      "GlobalDefines.py",
                                      "interface.py",
                                      "lot.py",
                                      "lotDlg.py",
                                      "main_win.py",
                                      "main_winDLG.py",
                                      "mplayer.py",
                                      "OFD.py",
                                      "Render.py",
                                      "RenderDlg.py",
                                      "Videoporama.py",
                                      "PortableVideoporama.py",
                                      "statusconf.py",
                                      "SND_editorDlg.py",
                                      "SoundDlg.py",
                                      "snd_editor.py",
                                      "RenderDlgSound.py",
                                      "RenderDlgMovie.py",
                                      "SoundProcess.py",
                                      "soundProgress.py",
                                      "sound.py",
                                      "Transitions.py",
                                      "VideoporamaOFD.xml"]),
                    ("locale",      MakeFileList("locale")),
                    ("help",        MakeFileList("help")),
                    ("help/images", MakeFileList("help/images")),
                    ("icons",       MakeFileList("icons")),
                    ("iconstr",     MakeFileList("iconstr")),
                    ("luma",        MakeFileList("luma"))
                    ],
      scripts = ["videoporama"],
      long_description= """
Videoporama is an application to make diaporama from images export in video file. It is written in Python using QT4 and the PyQt4 GUI toolkit. It use MJPEGtools, ffmpeg, sox and PIL to build images and convert them to movie
"""
)
