/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TFrameItem.h"

TFrameItem::TFrameItem(QImage &p, int h_s, QAction &delAct, QAction &saveAct)
{	
	this->p = &p;
	this->h_s = h_s;
	this->w_s = (int)(h_s * 1.5);
	
	widthBorder = 2;
	shadowSize = 5;
	
	boundRect = QRectF(0, 0, w_s, h_s);
	bigRect = QRectF(shadowSize, shadowSize, w_s - shadowSize*2, h_s - shadowSize*2);
	pixRect = QRectF(bigRect.x() + widthBorder, bigRect.y() + widthBorder, bigRect.width() - widthBorder*2, bigRect.height() - widthBorder*2);
	source = QRectF(0, 0, this->p->width(), this->p->height());
	
    isSelect = false;
    this->setAcceptsHoverEvents(true);

    hovered = false;

    // colors fo pressed and hovered layer
	colPress = QColor(0, 0, 250, 100);
	colHover = QColor(250, 250, 250, 100);

    // create context menu
    menu = new QMenu();
	menu->addAction(&saveAct);
	menu->addAction(&delAct);
}

QRectF TFrameItem::boundingRect() const
{
    return boundRect;
}

void TFrameItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *,
               QWidget *)
{
    if (isObscured())
    	return;

	painter->setRenderHint(QPainter::Antialiasing, true);
	
	QPen penTmp(QColor(10, 10, 10, 0), -1);
	penTmp.setCapStyle(Qt::RoundCap);
	painter->setPen(penTmp);
	
	for(int i = shadowSize; i >= 0; i--)
	{
		painter->setBrush(QBrush(QColor(50, 50, 50, 10 + i * 15)));
		painter->drawRoundRect(i, i, (int)(boundRect.width() - i*2), (int)(boundRect.height() - i*2), 15, 15);
	}
	
    QColor tempColor = QColor(250, 250, 250, 250);
    QPen pen(tempColor, 0, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin);
    painter->setPen(pen);


    painter->setBrush(tempColor);
    painter->drawRoundRect(bigRect, 0, 0);
	
//#if QT_VERSION >= 0x040300
	painter->drawImage(pixRect, (*p).scaledToWidth(pixRect.width(), Qt::SmoothTransformation));
//#else
//    painter->drawImage(pixRect, *p, source);
//#endif
	
	// for hover
	if(hovered)
	{
		painter->setBrush(colHover); 
    	painter->drawRect(bigRect);
	}	

    // for press event
	if(isSelect)
	{
		painter->setBrush(QBrush(colPress)); 
		painter->drawRect(bigRect);
	}
}

void TFrameItem::hoverMoveEvent(QGraphicsSceneHoverEvent *)
{
    hovered = true;
    this->update();
}

void TFrameItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *)
{
    hovered = false;
    this->update();
}

void TFrameItem::select()
{
	if(!isSelect)
	{
		this->update();
		emit onSelectItem(*this); // sending link to this item
	}
	isSelect = true;
}

void TFrameItem::mousePressEvent(QGraphicsSceneMouseEvent *)
{
    this->select();
}

void TFrameItem::deSelect()
{
	isSelect = false;
	this->update();
}

void TFrameItem::contextMenuEvent(QGraphicsSceneContextMenuEvent *)
{
    menu->exec(QCursor::pos());
}

void TFrameItem::S_Save()
{
    emit onSave(*this);
}
