/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_compodb.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_plugin.h>

extern VDKBuilder* TheApp;
static char buff[256];

DEFINE_SIGNAL_MAP(VDKBCompodbForm,VDKForm)
ON_SIGNAL(closeButton,clicked_signal,OncloseButtonClick),
ON_SIGNAL(compoList,realize_signal,OnRealizeCompoList),
ON_SIGNAL(compoList,select_row_signal,OncompoListSelectRow),
ON_SIGNAL(deleteButton,clicked_signal,OndeleteButtonClick),
ON_SIGNAL(addButton,clicked_signal,OnaddButtonClick),
ON_SIGNAL(modifyButton,clicked_signal,OnmodifyButtonClick),
ON_SIGNAL(saveButton,clicked_signal,OnsaveButtonClick)
END_SIGNAL_MAP

// treeview model data
enum
{
  ICON = 0,
  LIBNAME,
  LIBPATH,
  LIBID,
  LIBVALID,
  COMPONAME,
  LIBERROR,
  MAX_COL
};

static struct
{
  char* title;
  int ordinal_number;
  GType gtype;
} data_structure[] =
{
  {N_("Compo"),           ICON,              GDK_TYPE_PIXBUF },
  {N_("Library name"),    LIBNAME,           G_TYPE_STRING   },
  {N_("Library path"),    LIBPATH,           G_TYPE_STRING   },
  {N_(" Id "),            LIBID,             G_TYPE_INT      },
  {N_("Valid"),           LIBVALID,          G_TYPE_BOOLEAN  },
  {N_("Component name"),  COMPONAME,         G_TYPE_STRING   },
  {N_("Error"),           LIBERROR,          G_TYPE_STRING   },
  {NULL,-1,0}
};


/*
form constructor
*/
VDKBCompodbForm::VDKBCompodbForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
main form destructor
*/
VDKBCompodbForm::~VDKBCompodbForm()
{
}


/*
main form setup
*/
void
VDKBCompodbForm::Setup(void)
{
  GUISetup(); // vdkb gui setup
  // put your code below here
  Changed = false;
}
/*
main form setup
*/
void
VDKBCompodbForm::GUISetup(void)
{
  SetSize(460,315);
  Title = _("VDKBuilder component database");
  vbox1 = new VDKBox(this,v_box);
  Add(vbox1,0,1,1,0);

  VDKScrolled* scrolled = new VDKScrolled(this);

  compoList = new VDKTreeView(this,NULL,GTK_SELECTION_SINGLE);
  scrolled->AddWithoutViewport(compoList,l_justify,false,false,0);
  vbox1->Add(scrolled,0,1,1,3);

  separator0 = new VDKSeparator(this,h_separator);
  vbox1->Add(separator0,0,0,0,3);
  hbox2 = new VDKBox(this,h_box);
  hbox2->SetSize(400,25);
  vbox1->Add(hbox2,0,0,0,3);
  hbox2->BorderWidth(0);
  closeButton = new VDKCustomButton(this,_("Close"));
  closeButton->Relief = (GtkReliefStyle) 0;
  hbox2->Add(closeButton,0,1,1,3);
  deleteButton = new VDKCustomButton(this,_("Delete"));
  hbox2->Add(deleteButton,0,1,1,3);
  addButton = new VDKCustomButton(this,_("Add"));
  hbox2->Add(addButton,0,1,1,3);
  // modifyButton = new VDKCustomButton(this,_("Modify"));
  // hbox2->Add(modifyButton,0,1,1,3);
  // disabled for now
  // modifyButton->Enabled = false;
  saveButton = new VDKCustomButton(this,_("Save"));
  saveButton->Enabled = true;
  hbox2->Add(saveButton,0,1,1,3);
  statusbar0 = new VDKStatusbar(this);
  statusbar0->SetSize(391,25);
  vbox1->Add(statusbar0,l_justify,false,false,0);
}
//
char *strnzcpy(char *trgt, const char *src, int n)
//copies max (n-1) bytes from src to trgt and adds a zero, if neccessary
{
        trgt[--n] = 0;
        return strncpy(trgt,src,n);
}


//
bool
VDKBCompodbForm::OnRealizeCompoList(VDKObject* sender)
{
  // makes model
  int t;
  GType* types = new GType[MAX_COL];
  VDKTreeViewModel *model = NULL;
  types[0] = GDK_TYPE_PIXBUF;
  for(t=1; data_structure[t].title; t++)
    types[t] = data_structure[t].gtype;
  compoList->Model = (model = new VDKTreeViewModel(types,MAX_COL));
  delete[] types;
  if(model)
    {
      VDKTreeViewColumn* column = NULL;
      for(t=0; data_structure[t].title; t++)
	column = new VDKTreeViewColumn(compoList,data_structure[t].ordinal_number, 
				       _(data_structure[t].title));
      LoadComponentDb();
      gtk_tree_view_set_rules_hint (GTK_TREE_VIEW(compoList->WrappedWidget()), TRUE);
      GtkTreeIter iter;
      if(model->Root(&iter))
	compoList->SelectNode(&iter);
    }

  return true;
}

void
VDKBCompodbForm::LoadComponentDb()
{
# define MAX_MSG 256
  char libname[MAX_MSG],libpath[MAX_MSG], name[MAX_MSG],error[MAX_MSG];
  const char **icon;
  VDKTreeViewModel* model = compoList->Model;
  VDKBPluginListIterator li(TheApp->PluginList());
  for(;li;li++)
    {
      GtkTreeIter iter;
      VDKBPlugin plugin = li.current();
      strnzcpy(libname,plugin.LibName(),MAX_MSG);
      strnzcpy(libpath,plugin.PathName(),MAX_MSG);
      strnzcpy(name,plugin.IsValid() ? plugin.Interface()->VDKName():
	      (char*) _("invalid "),MAX_MSG);
      strnzcpy(error,plugin.Error() ? plugin.Error() : (char*) " ",MAX_MSG);
      icon = (const char**) plugin.Icon();
      VDKPixbuf* pixbuf = NULL;
      if(icon)
	pixbuf = new VDKPixbuf(this,icon);
      model->AppendBlank(&iter);
      model->SetData(&iter, 
		     ICON , pixbuf ? pixbuf->AsGdkPixbuf(): NULL, 
		     LIBNAME, libname,
		     LIBPATH,libpath,
		     LIBID,plugin.Id(),
		     LIBVALID,plugin.IsValid(),
		     COMPONAME,name,
		     LIBERROR,error,
		     -1);
    }
}
//
bool
VDKBCompodbForm::SaveComponentDb()
{
  sprintf(buff,"%s/.vdkb2/%s",(char*) TheApp->user_home,VDKB_PLUGIN_FILE);
  FILE* fp = fopen(buff,"w+");
  if(!fp)	
      return false;
  VDKBPluginListIterator li(TheApp->PluginList());
  for(;li;li++)
	fprintf(fp,"%s,%s\n",
		(char*) li.current().PathName(),
		(char*) li.current().LibName());
  fclose(fp);
  return true;
}

/*
 */
bool
VDKBCompodbForm::CanClose()
{
    if(Changed &&	
       (Application()->VDKMessageBox(APPNAME,
				  _("Component database changed\nsave it ?"),
				  VDK_ICONQUESTION|VDK_YESNO,
				  _(user_messages[user_ok]),
				  _(user_messages[user_no])) == VDK_IDYES))
	OnsaveButtonClick(NULL);
    return true;
}
// signal response method
bool
VDKBCompodbForm::OncloseButtonClick(VDKObject* sender)
{
  Close();
  return true;
}

// signal response method
bool
VDKBCompodbForm::OncompoListSelectRow(VDKObject* sender)
{
  return true;
}

// signal response method
bool
VDKBCompodbForm::OndeleteButtonClick(VDKObject* sender)
{
  VDKTreeViewModel *model = compoList->Model;
  compoList->GetSelections();
  if(compoList->Selections().size() == 1)
    {
      int t = 0;
      GtkTreeIter iter = compoList->Selections()[0];
      char* name = (char*) model->GetCell(&iter,LIBNAME);
      VDKBPluginListIterator li(TheApp->PluginList());
      for(;li;li++,t++)
	if(!strcmp(name, (char*) li.current().LibName()))
	  {
	    (TheApp->PluginList())[t].DlClose();
	    TheApp->PluginList().unlink(t);
	    Changed = true;
	    model->Remove(&iter);
	    saveButton->Enabled = Changed;	
	  }
      compoList->Selections().flush();
      delete[] name;
    }
  return true;
}

// signal response method
bool
VDKBCompodbForm::OnaddButtonClick(VDKObject* sender)
{
    char libpath[MAX_MSG];
    char libname[MAX_MSG];
    char name[MAX_MSG],error[MAX_MSG];
    const char ** icon;
    VDKTreeViewModel* model = compoList->Model;
    *libpath = *libname = '\0';
    VDKBCompoInputForm* child = new VDKBCompoInputForm(this,
						       libpath,
						       libname);
    child->Setup();
    child->ShowModal(GTK_WIN_POS_CENTER);
    if(*libpath && *libname)
	{
	  VDKBPlugin plugin(libpath,libname);
	  TheApp->PluginList().add(plugin);
	  plugin.DlOpen();
	  strnzcpy(name,plugin.IsValid() ? plugin.Interface()->VDKName():
	      (char*) _("invalid "),MAX_MSG);
	  icon = (const char**) plugin.Icon();
	  VDKPixbuf* pixbuf = NULL;
	  if(icon)
	    pixbuf = new VDKPixbuf(this,icon);
	  GtkTreeIter iter ;
	  model->AppendBlank(&iter);
	  model->SetData(&iter, 
			 ICON , pixbuf ? pixbuf->AsGdkPixbuf(): NULL, 
			 LIBNAME, libname,
			 LIBPATH, libpath,
			 LIBID,plugin.Id(),
			 LIBVALID,plugin.IsValid(),
			 COMPONAME,name,
			 LIBERROR,error,
			 -1);
	  Changed = true;
	}
    saveButton->Enabled = Changed;
    return true;	
}

// signal response method
bool
VDKBCompodbForm::OnmodifyButtonClick(VDKObject* sender)
{
  return true;
}

// signal response method
bool
VDKBCompodbForm::OnsaveButtonClick(VDKObject* sender)
{
    if(!SaveComponentDb())
	Application()->VDKMessageBox(
				APPNAME,
				_("Could not save component database"),
				VDK_ICONINFORMATION|VDK_OK,
				_(user_messages[user_ok]),
				NULL,
				5000);
    Changed = false;
    return true;
}
////////////////////////////////////
// VDKBCompoInputForm CLASS
///////////////////////////////////
DEFINE_SIGNAL_MAP(VDKBCompoInputForm,VDKForm)
ON_SIGNAL(acceptButton,clicked_signal,OnacceptButtonClick),
    ON_SIGNAL(cancelButton,clicked_signal,OncancelButtonClick)
END_SIGNAL_MAP
/*
form constructor
*/
VDKBCompoInputForm::VDKBCompoInputForm(VDKForm* owner,
				       char* libpath,
				       char* libname):
	VDKForm(owner,(char*) NULL),libpath(libpath),libname(libname)
{
}

/*
main form destructor
*/
VDKBCompoInputForm::~VDKBCompoInputForm()
{
}

/*
main form setup
*/
void
VDKBCompoInputForm::GUISetup(void)
{
	SetSize(321,100);
	Title = _("Component database  dialog");
vbox1 = new VDKBox(this,v_box);
Add(vbox1,0,1,1,0);
vbox2 = new VDKBox(this,v_box);
vbox1->Add(vbox2,0,1,1,0);
vbox2->BorderWidth(0);
hbox5 = new VDKBox(this,h_box);
hbox5->SetSize(319,30);
vbox2->Add(hbox5,0,1,1,0);
hbox5->BorderWidth(0);
label0 = new VDKLabel(this,_("Enter library path:"));
hbox5->Add(label0,0,1,1,0);
libpathEntry = new VDKEntry(this,0);
libpathEntry->SetSize(195,25);
hbox5->Add(libpathEntry,0,1,0,0);
hbox6 = new VDKBox(this,h_box);
hbox6->SetSize(319,30);
vbox2->Add(hbox6,0,1,1,0);
hbox6->BorderWidth(0);
label1 = new VDKLabel(this,_("Enter library name:"));
label1->SetSize(102,35);
hbox6->Add(label1,0,1,1,0);
libnameEntry = new VDKEntry(this,0);
libnameEntry->SetSize(195,25);
hbox6->Add(libnameEntry,0,1,0,0);
separator1 = new VDKSeparator(this,h_separator);
vbox1->Add(separator1,0,0,0,0);
hbox10 = new VDKBox(this,h_box);
vbox1->Add(hbox10,0,1,1,0);
hbox10->BorderWidth(0);
acceptButton = new VDKCustomButton(this,(char*) NULL,
				   _("_Accept"),
				   16,(GtkPositionType) 0);
hbox10->Add(acceptButton,0,1,0,0);
cancelButton = new VDKCustomButton(this,(char*) NULL,
				   _("_Cancel"),
				   16,(GtkPositionType) 0);
hbox10->Add(cancelButton,0,1,0,0);
}
/*
main form setup
*/
void
VDKBCompoInputForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
// put your code below here

}
// signal response method
bool
VDKBCompoInputForm::OnacceptButtonClick(VDKObject* sender)
{
    if(strlen(libpathEntry->Text) > 0)
	strcpy(libpath,libpathEntry->Text);
    else
	*libpath = '\0';
    if(strlen(libnameEntry->Text) > 0)
	strcpy(libname,libnameEntry->Text);
    else
	*libname = '\0';
    Close();
    return true;
}

// signal response method
bool
VDKBCompoInputForm::OncancelButtonClick(VDKObject* sender)
{
    *libname = *libpath = '\0';
    Close();
    return true;	
}



