# -*- coding: utf-8 -*-
'''
Vdirsyncer synchronizes calendars and contacts.
'''

from __future__ import print_function

PROJECT_HOME = 'https://github.com/pimutils/vdirsyncer'
BUGTRACKER_HOME = PROJECT_HOME + '/issues'
DOCS_HOME = 'https://vdirsyncer.pimutils.org/en/stable'

try:
    from .version import version as __version__  # noqa
except ImportError:  # pragma: no cover
    raise ImportError(
        'Failed to find (autogenerated) version.py. '
        'This might be because you are installing from GitHub\'s tarballs, '
        'use the PyPI ones.'
    )


def _check_python_version():  # pragma: no cover
    import sys
    if sys.version_info < (3, 3, 0):
        print('vdirsyncer requires at least Python 3.3.')
        sys.exit(1)


_check_python_version()
del _check_python_version
