/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __CIM_SERVICE_H
#define __CIM_SERVICE_H
#include "CIM_EnabledLogicalElement.h"
namespace CimClassNamespace
{

	// Class CIM_Service:
	// A CIM_Service is a Logical Element that contains the information necessary to represent and manage the functionality provided by a Device and/or SoftwareFeature. A Service is a general-purpose object to configure and manage the implementation of functionality. It is not the functionality itself.
	class CIM_Service  : public CIM_EnabledLogicalElement
	{
	public:
		// type definitions
		typedef CimClassContainer<CIM_Service> CIM_ServiceContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// This field is a Cim Key.
		// The scoping System's CreationClassName.
		string SystemCreationClassName;

		// This field is a Cim Key.
		// The scoping System's Name.
		string SystemName;

		// This field is a Cim Key.
		// CreationClassName indicates the name of the class or the subclass used in the creation of an instance. When used with the other key properties of this class, this property allows all instances of this class and its subclasses to be uniquely identified.
		string CreationClassName;

		// This field is a Cim Key.
		// The Name property uniquely identifies the Service and provides an indication of the functionality that is managed. This functionality is described in more detail in the object's Description property.
		string Name;

		// The name of the primary owner for the service, if one is defined. The primary owner is the initial support contact for the Service.
		string PrimaryOwnerName;

		// This field determines whether the PrimaryOwnerName field is valid.
		bool PrimaryOwnerNameSpecified;

		// A string that provides information on how the primary owner of the Service can be reached (e.g. phone number, email address, ...).
		string PrimaryOwnerContact;

		// This field determines whether the PrimaryOwnerContact field is valid.
		bool PrimaryOwnerContactSpecified;

		// StartMode is a string value indicating whether the Service is automatically started by a System, Operating System, etc. or only started upon request. This property is deprecated in lieu of the EnabledDefault property inherited from EnabledLogicalElement, which addresses the same semantics. The change to a uint16 data type was discussed when CIM V2.0 was defined. However, existing V1.0 implementations used the string property and did not want to modify their code. Therefore, StartMode was grandfathered into the Schema. Use of the Deprecated qualifier allows the maintenance of the existing property, but also permits an improved, clarified definition using EnabledDefault.
		string StartMode;

		// This field determines whether the StartMode field is valid.
		bool StartModeSpecified;

		// Started is a boolean indicating whether the Service has been started (TRUE), or stopped (FALSE).
		bool Started;

		// This field determines whether the Started field is valid.
		bool StartedSpecified;

		// Invoke RequestStateChange Classes:
		// Requests that the element's state be changed to the value specified in the RequestedState parameter. When the requested state change takes place, the element's EnabledState and RequestedState will be the same. Invoking the RequestStateChange method multiple times could result in earlier requests being overwritten/lost.
		// If 0 is returned, then the task completed successfully and the use of ConcreteJob was not required. If 4096 (0x1000) is returned, then the task will take some time to complete, ConcreteJob will be created, and its reference returned in the output parameter Job. Any other return code indicates an error condition.
		class RequestStateChange_INPUT : public Serializable
		{
		public:
			// class fields
			// The state requested for the element. This information will be placed into the instance's RequestedState property if the RequestStateChange method's return code is 0, 3, or 4096 (0x1000) - 'Completed with No Error', 'Timeout', or 'Job Started' respectively. Refer to the description of the EnabledState and RequestedState properties for the detailed meanings of the RequestedState values.
			// Legal values:
			// Enabled: 2
			// Disabled: 3
			// Shut Down: 4
			// Offline: 6
			// Test: 7
			// Defer: 8
			// Quiesce: 9
			// Reboot: 10
			// Reset: 11
			// DMTF Reserved: ..
			// Vendor Reserved: 32768..65535
			unsigned short RequestedState;

			// This field determines whether the RequestedState field is valid.
			bool RequestedStateSpecified;

			// A timeout period that specifies the maximum amount of time that the client expects the transition to the new state to take. The interval format MUST be used to specify the TimeoutPeriod. A value of 0 or a null parameter indicates that the client has no time requirements for the transition.
			// If this property does not contain 0 or null and the implementation doesn't support this parameter. A return code of 'Use Of Timeout Parameter Not Supported' MUST be returned.
			DateTime TimeoutPeriod;

			// This field determines whether the TimeoutPeriod field is valid.
			bool TimeoutPeriodSpecified;

			// Class Constructor
			RequestStateChange_INPUT();

			// Class Destructor
			~RequestStateChange_INPUT(){}

			// This function appends a serialization of this instance to the given node.
			void SerializeMembers(XMLElement& node) const;
		};

		class RequestStateChange_OUTPUT : public DeSerializable
		{
		public:
			// class fields
			// Reference to the job (may be null if task completed).
			EndpointReference Job;

			// This field determines whether the Job field is valid.
			bool JobSpecified;

			// Function Return Value:
			// Legal values:
			// Completed with No Error: 0
			// Not Supported: 1
			// Unknown/Unspecified Error: 2
			// Can NOT complete within Timeout Period: 3
			// Failed: 4
			// Invalid Parameter: 5
			// In Use: 6
			// DMTF Reserved: ..
			// Method Parameters Checked - Job Started: 4096
			// Invalid State Transition: 4097
			// Use of Timeout Parameter Not Supported: 4098
			// Busy: 4099
			// Method Reserved: 4100..32767
			// Vendor Specific: 32768..65535
			unsigned int ReturnValue;

			// Class Constructor
			RequestStateChange_OUTPUT();

			// Class Destructor
			~RequestStateChange_OUTPUT(){}

			// This function sets a field value according to the given node.
			void SetValue(const XMLElement& elem);

		};

		// Invoke StartService Classes:
		// The StartService method places the Service in the started state. Note that this method's function overlaps with the RequestedState property. RequestedState was added to the model to maintain a record (i.e., a persisted value) of the last state request. Invoking the StartService method should set the RequestedState property appropriately. The method returns an integer value of 0 if the Service was successfully started, 1 if the request is not supported and any other number to indicate an error. In a subclass, the set of possible return codes could be specified, using a ValueMap qualifier on the method. The strings to which the ValueMap contents are 'translated' may also be specified in the subclass as a Values array qualifier.
		//
		// Note that this method overlaps in semantics with the RequestStateChange method inherited from EnabledLogicalElement. This method is maintained since it has been widely implemented, and its simple 'start' semantics are convenient to use.
		class StartService_INPUT : public Serializable
		{
		public:
			// class fields
			// Class Constructor
			StartService_INPUT();

			// Class Destructor
			~StartService_INPUT(){}

			// This function appends a serialization of this instance to the given node.
			void SerializeMembers(XMLElement& node) const;
		};

		class StartService_OUTPUT : public DeSerializable
		{
		public:
			// class fields
			// Function Return Value:
			unsigned int ReturnValue;

			// Class Constructor
			StartService_OUTPUT();

			// Class Destructor
			~StartService_OUTPUT(){}

			// This function sets a field value according to the given node.
			void SetValue(const XMLElement& elem);

		};

		// Invoke StopService Classes:
		// The StopService method places the Service in the stopped state. Note that this method's function overlaps with the RequestedState property. RequestedState was added to the model to maintain a record (i.e., a persisted value) of the last state request. Invoking the StopService method should set the RequestedState property appropriately. The method returns an integer value of 0 if the Service was successfully stopped, 1 if the request is not supported and any other number to indicate an error. In a subclass, the set of possible return codes could be specified, using a ValueMap qualifier on the method. The strings to which the ValueMap contents are 'translated' may also be specified in the subclass as a Values array qualifier.
		//
		// Note that this method overlaps in semantics with the RequestStateChange method inherited from EnabledLogicalElement. This method is maintained since it has been widely implemented, and its simple 'stop' semantics are convenient to use.
		class StopService_INPUT : public Serializable
		{
		public:
			// class fields
			// Class Constructor
			StopService_INPUT();

			// Class Destructor
			~StopService_INPUT(){}

			// This function appends a serialization of this instance to the given node.
			void SerializeMembers(XMLElement& node) const;
		};

		class StopService_OUTPUT : public DeSerializable
		{
		public:
			// class fields
			// Function Return Value:
			unsigned int ReturnValue;

			// Class Constructor
			StopService_OUTPUT();

			// Class Destructor
			~StopService_OUTPUT(){}

			// This function sets a field value according to the given node.
			void SetValue(const XMLElement& elem);

		};

		// Class Constructor
		CIM_Service(
			const string& objName = CIM_Service::CLASS_NAME,
			const string& uri = CIM_Service::CLASS_URI,
			const string& ns = CIM_Service::CLASS_NS,
			const string& nsPrefix = CIM_Service::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~CIM_Service(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

		// This function performs the Invoke RequestStateChange operation using the given input.
		// The output of the function is returned in the given output class.
		virtual void InvokeRequestStateChange(RequestStateChange_INPUT &input, RequestStateChange_OUTPUT &output,  const WsmanClient *cl = defaultProvider) const;

		// This function performs the Invoke StartService operation using the given input.
		// The output of the function is returned in the given output class.
		virtual void InvokeStartService(StartService_INPUT &input, StartService_OUTPUT &output,  const WsmanClient *cl = defaultProvider) const;

		// This function performs the Invoke StopService operation using the given input.
		// The output of the function is returned in the given output class.
		virtual void InvokeStopService(StopService_INPUT &input, StopService_OUTPUT &output,  const WsmanClient *cl = defaultProvider) const;

	};
}
#endif
