#!/usr/bin/python

"""
Generates a *.js file (defaults to unity-api-page-proxy-builder.js) by parsing & extracting expected
information out of an input .js filename (defaults to unity-api.js). Extracts only the meaningful bits
(mostly the argument sanitizer bits) and generates a proper web page side unity api w/ a proper validation
layer (as exposed by unity-api.js)

Takes an input filename as an argument.
"""

import sys

class DEFAULTS:
    input_api_filename = "unity-api.js"
    output_api_filename = "unity-api-page-proxy-builder-gen-py.js"

input_api_filename = DEFAULTS.input_api_filename
output_api_filename = DEFAULTS.output_api_filename

def extractFunctionDefinition (name, content):
    import re
    funcre = re.compile (r'([^\w_]|\s*)(' + name + r')\s*\((?P<params>.*?)\)\s*{', re.MULTILINE)
    m = re.search (funcre, content)
    if m:
        s = ['{']
        start = m.end(0)
        end = start + 1
        for idx in xrange (start, len(content)-1):
            if content[idx] == '{':
                s.append('{')
            elif content[idx] == '}':
                s.pop()
                if s.count('{') == 0:
                    end = idx
                    break
        return m.group('params'), content[start:end]
    return None, None

def untabify (body):
    mintabs = min([len([c for c in line if c == ' ' or c == '\t']) for line in body.split('\n') if len(line.strip()) != 0])
    return '\n'.join ([line[mintabs:] for line in body.split('\n')])

def generateFunction (name, params, body):
    return """
var %s = function (%s) {
  %s
};
""" % (name, params, untabify(body))

def extractObjectDefinition(content, oname):
    import re
    apire = re.compile(oname + '\s*[=|:]\s*', re.MULTILINE)
    m = re.search(apire, content)
    s = []
    start = m.end(0)
    end = start
    for idx in xrange (start, len(content)-1):
        if content[idx] == '{':
            s.append('{')
        elif content[idx] == '}':
            s.pop()
            if s.count('{') == 0:
                end = idx
                break
    return content[start:end]

def extractApiDefinition(content):
    return extractObjectDefinition(content, 'api')

def generateUnityApiTargetFile (inputfilename, outputfilename):
    content = open(inputfilename).read()
    function_names = ['findName', 'stringify', 'stringifyArgs', 'createArgumentsSanitaizer']
    extracted_data = [(function_name, extractFunctionDefinition(function_name, content)) for function_name in function_names]
    extracted_functions = [{'name': extracted_datum[0], 'params': extracted_datum[1][0], 'body': extracted_datum[1][1]} for extracted_datum in extracted_data]

    buildercontent = 'var UnityWebappsApiPageProxyBuilder = function(backend) {\n'
    buildercontent += """
  var dummy = true;
  var unity = { context: dummy, contextReady: dummy };
  var uwa = { ContextActionCallbackType: null };

  var CallbackManager = {
    makeCallback: function (dumd, func) {
      return func;
    }
  };
"""
    buildercontent += '\n'.join([generateFunction(func['name'], func['params'], func['body']) for func in extracted_functions])
    buildercontent += 'var api = {\n};\n'
    buildercontent += '};\n\n'
    open(outputfilename, "w+").write(buildercontent)

generateUnityApiTargetFile (input_api_filename, output_api_filename)


