/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MKDIRCMD_H
#define _SC_MKDIRCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class MkdirParam;

/**
 * Command for creating dirs in a working copy or a repository.
 */
class MkdirCmd : public ScCmd
{
public:
  /**
   * Construct a MkdirCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  MkdirCmd( MkdirParam* param, CmdResultCallback* cb );
  ~MkdirCmd();

  void run();

private:
  // in
  MkdirParam*        _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_MKDIRCMD_H
