/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOCKPARAM_H
#define _SC_LOCKPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "util/String.h"

/**
 * Parameter class for LockCmd.
 */
class LockParam : public ScParam
{
public:
  LockParam( const svn::Paths& pathsOrUrls, const sc::String& comment, bool stealLocks )
    : _pathsOrUrls(pathsOrUrls), _comment(comment), _stealLocks(stealLocks)
  {
  }

  ~LockParam()
  {
  }

  const svn::Paths& getPathsOrUrls() const
  {
    return _pathsOrUrls;
  }

  const sc::String& getComment() const
  {
    return _comment;
  }

  void setComment( const sc::String& comment )
  {
    _comment = comment;
  }

  bool getStealLocks() const
  {
    return _stealLocks;
  }

  void setStealLocks( bool steal )
  {
    _stealLocks = steal;
  }

  ScParamAccept(LockParam);

private:
  // in
  svn::Paths  _pathsOrUrls;
  sc::String  _comment;
  bool        _stealLocks;
};

#endif // _SC_LOCKPARAM_H
