/* ====================================================================
 * Copyright (c) 2006-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_TABWIDGET_H
#define _SC_TABWIDGET_H

// sc

// qt
#include <QtGui/QTabBar>
class QStackedWidget;
class QTab;


class Tabbar : public QTabBar
{
  typedef QTabBar super;
  Q_OBJECT

public:
  Tabbar( QWidget* parent );
  ~Tabbar();

  QSize sizeHint() const;
  QSize tabSizeHint( int idx ) const;
  void paintEvent( QPaintEvent* e );
};

/////////////////////////////////////////////////////////////////////

class TabWidget : public QWidget
{
  typedef QWidget super;
  Q_OBJECT

public:
  TabWidget( QWidget* parent );

  int addTab( QWidget* child, const QString& label );
  void setTabTitle( QWidget* child, const QString& title );
  void setTabTooltip( QWidget* child, const QString& title );

private:
  QTabBar*        _bar;
  QStackedWidget* _stack;
};

#endif // _SC_TABWIDGET_H
