/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BOOKMARKVIEWITEMMODEL_H
#define _SC_BOOKMARKVIEWITEMMODEL_H

// sc
class Bookmark;
class BookmarkItem;

// qt
#include <QtCore/QAbstractItemModel>


enum Roles {
  OnItemRole              = Qt::UserRole,
  ExpandedDecorationRole,
  CurrentWcRole,
  BookmarkRole,
  ActiveRole,
  ActiveDecorationRole
};


class BookmarkViewItemModel : public QAbstractItemModel
{
  typedef QObject super;
  Q_OBJECT

public:
  BookmarkViewItemModel();
  ~BookmarkViewItemModel();

  // QAbstractItemModel
  QModelIndex index( int row, int column, const QModelIndex& parent ) const;
  QModelIndex index( Bookmark* bm );
  QModelIndex parent( const QModelIndex& index ) const;
  int columnCount( const QModelIndex& parent ) const;
  int rowCount( const QModelIndex& parent ) const;
  QVariant headerData( int section, Qt::Orientation orientation, int role ) const;
  QVariant data( const QModelIndex& index, int role ) const;
  bool setData( const QModelIndex& index, const QVariant& value, int role );
  Qt::ItemFlags flags( const QModelIndex &index ) const;
  Qt::DropActions supportedDragActions() const;
  Qt::DropActions supportedDropActions() const;
  void sort( int column, Qt::SortOrder );

  /** returns the @a Bookmark at given @a index position. */
  Bookmark* bookmark( const QModelIndex& index );

  /** advance active decoration. */
  void advanceDecoration();

public slots:
  /** add a @a Bookmark. */
  void add(Bookmark*);
  /** remove a @a Bookmark. */
  void remove(Bookmark*);
  /** re-sort bookmarks based on their sort order attribute. */
  void sort();

private:
  /** move active anamition to next frame. */
  void advanceFrame( const QModelIndex& idx );
  /** get parent item, returns @a _root for an invalid @a index. */
  BookmarkItem* getParentItem( const QModelIndex& ) const;
  /** get parent item of @a Bookmark, returns @c NULL for an unknown @a Bookmark. */
  BookmarkItem* getParentItem( Bookmark* ) const;
  /** get the item of @a Bookmark, returns @c NULL for an unknown @a Bookmark. */
  BookmarkItem* getItem( Bookmark* ) const;

  BookmarkItem* _root; ///< the root item.
};

#endif // _SC_BOOKMARKVIEWITEMMODEL_H
