//============================================================================
//
//   SSSS    tt          lll  lll
//  SS  SS   tt           ll   ll
//  SS     tttttt  eeee   ll   ll   aaaa
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2018 by Bradford W. Mott, Stephen Anthony
// and the Stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//============================================================================

#ifndef DRIVING_WIDGET_HXX
#define DRIVING_WIDGET_HXX

class Controller;
class ButtonWidget;
class CheckboxWidget;
class DataGridWidget;

#include "ControllerWidget.hxx"

class DrivingWidget : public ControllerWidget
{
  public:
    DrivingWidget(GuiObject* boss, const GUI::Font& font, int x, int y,
                  Controller& controller);
    virtual ~DrivingWidget() = default;

  private:
    enum {
      kGrayUpCmd   = 'DWup',
      kGrayDownCmd = 'DWdn',
      kFireCmd     = 'DWfr'
    };
    ButtonWidget *myGrayUp, *myGrayDown;
    DataGridWidget* myGrayValue;
    CheckboxWidget* myFire;

    int myGrayIndex;

    static uInt8 ourGrayTable[4];

  private:
    void loadConfig() override;
    void handleCommand(CommandSender* sender, int cmd, int data, int id) override;

    void setValue();

    // Following constructors and assignment operators not supported
    DrivingWidget() = delete;
    DrivingWidget(const DrivingWidget&) = delete;
    DrivingWidget(DrivingWidget&&) = delete;
    DrivingWidget& operator=(const DrivingWidget&) = delete;
    DrivingWidget& operator=(DrivingWidget&&) = delete;
};

#endif
