package test;

public class ImageSpinner implements Runnable {
	RotatableImage image;
	final float totalDegrees;
	float degrees;
	float speed; // in degrees per second

	public ImageSpinner(RotatableImage image, float degrees, float speed) {
		this.image = image;
		this.degrees = degrees;
		this.totalDegrees = degrees;
		this.speed = speed;
	}

	public void run() {
		// assume about 40 frames per second, and that the it doesn't matter if
		// it isn't exact
		int fps = 40;
		while (Math.abs(degrees) > Math.abs(speed / fps)) { // how close is the
															// degrees to 0?
			float degreesToRotate = speed / fps;
			image.spin(degreesToRotate);
			degrees -= degreesToRotate;
			/*
			 * sleep will always wait at least 1000 / fps before recalcing but
			 * you have no guarantee that it won't take forever! If you
			 * absolutely require better timing, this isn't the solution for you
			 */
			try {
				Thread.sleep(1000 / fps);
			} catch (InterruptedException e) { /* swallow */
				//
			}
		}
		image.setSpin(totalDegrees); // this might need to be 360 -
										// totalDegrees, not sure
	}

}
