/*
 * Copyright (C) 2009-2010  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */

#ifndef SourceHighlightIdeFrame_H
#define SourceHighlightIdeFrame_H

#include <QFrame>

#include "ui_sourcehighlightideframe.h"

class QSettings;

namespace Ui {
    class SourceHighlightIdeFrame;
}

namespace srchiliteqt {
    class TextEditHighlighted;
}

class SourceHighlightIdeFrame : public QFrame {
    Q_OBJECT
public:
    SourceHighlightIdeFrame(QWidget *parent = 0);
    ~SourceHighlightIdeFrame();

    srchiliteqt::TextEditHighlighted *getLangTextEdit() const;
    QTextEdit *getInputTextEdit() const;
    srchiliteqt::TextEditHighlighted *getOutputTextEdit() const;

    void saveSettings(QSettings &settings);
    void readSettings(QSettings &settings);

    void setPreviewContents(const QString &contents);
    void goToEndOfPreviewContents();
    void setNoPreview();

protected:
    void changeEvent(QEvent *e);

public:
    Ui::SourceHighlightIdeFrame *m_ui;
};

#endif // SourceHighlightIdeFrame_H
