#include "stdafx.h"
#include "TestLib.h"
#include "AffineGapVectorized.h"
#include "LandauVishkin.h"

// Test fixture for all the affine gap tests
struct AffineGapVectorizedTest {
    AffineGapVectorized<> ag;
    AffineGapVectorizedTest() : ag(1, 4, 6, 1) {
        initializeLVProbabilitiesToPhredPlus33();
    }
    int editDist;

    int computeScore(
        const char* text,
        int textLen,
        const char* pattern,
        const char* qualityString,
        int patternLen,
        int w,
        int scoreInit)
    {
        char* quality = new char[strlen(text) + 1];
        for (int i = 0; i < strlen(text); i++) {
            quality[i] = '2';
        }
        quality[strlen(text)] = '\0';

        int retVal = ag.computeScore(text, textLen, pattern, quality, patternLen, w, scoreInit);

        delete[] quality;
        return retVal;
    }
};




TEST_F(AffineGapVectorizedTest, "equal strings") {
    ASSERT_EQ(25, computeScore("ACGTA", 5, "ACGTA", NULL, 5, 16, 20));
}


TEST_F(AffineGapVectorizedTest, "one deletion") {
    ASSERT_EQ(21, computeScore("AACGTACGT", 9, "ACGTACGT", NULL, 8, 16, 20));
}


TEST_F(AffineGapVectorizedTest, "long deletion") {
    // ASSERT_EQ(21, ag.computeScore("ACGTAAAAACGTACGTACGT", 20, "ACGTACGTACGTACGT", NULL, 16, 3, 20)); // edit distance = 3
    ASSERT_EQ(26, computeScore("ACGTAAAAACGTACGTACGT", 20, "ACGTACGTACGTACGT", NULL, 16, 16, 20)); // edit distance = 4
}


TEST_F(AffineGapVectorizedTest, "long insertion") {
    ASSERT_EQ(104, computeScore("CCGTCTCAACAATAACAACAACAACAACAAAAACCAGTCACTGTGTTAGGGACAGTCAGAACATGGGGGGATGGGAAAGAGGAGTTACAGGGAGACTT", 98, "CCGTCTCAACAATAACAACAACAACAACAACAAAAGCCAGTCACTGTGTTAGGGACAGTCAGAACATGGGGGGATGGGAAAGAGGAGTTACAGGGAGACTT", "22222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222", 101, 16, 20));
    ASSERT_EQ(103, computeScore("ACAATTAGGCAAAAAATCAATGGGATTCAGACAAATATGGGACAATTTTCTCTCTCTGTCTCTCTCTCTGTCTCTCTCTCTGACACACACACACA", 95, "ACAATTAGGCAAAAAATCAATGGGATTCAGACAAATATGGGACAATTTTCTCTCTCTGTCTCTCTCTCTGTCTCTGTCTCTCTCTCTGACACACACACACA", "22222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222", 101, 16, 20)); // 64M6I31M
}


TEST_F(AffineGapVectorizedTest, "synthetic") {
    ASSERT_EQ(72, computeScore("CATTGGCCAGGCTGGTCTCGAACTCCTGACCTCATGATCCACACGCCTCGA", 51, "TGTTGGTCAGGCTGGTCTCGAACTCCT", NULL, 27, 16, 60))
    ASSERT_EQ(80, computeScore("CAAAAATTAGCTGGGCACGGTGGCAGGCGCCTGTAATCCCAGCTACTCAGGAGACTGAGGCAGGAGAA", 68, "GAAAAATTAGCTGTGCACGGTGGCAGGCGCCTGTA", NULL, 35, 16, 55));
    ASSERT_EQ(41, computeScore("CAAAAAATTAGCCACGCATGGTGGCATATCCCTGTAGTCCCAGCTACTCGGGGCTGAGGCAGGAG", 65, "GAAAAATTAGCTGTGCACGGTGGCAGGCGCCTGTA", NULL, 35, 16, 40));
    ASSERT_EQ(95, computeScore("TAACCAATTAGACAGCTTCTTCCCACCCCAGACCCCAGAGACCTGGCCCAAGCCTGGAGAAGACATCCTGTTTCCCCTGAGGAAGTGGCCCAGATTG", 97, "AAACCAATTAGACAGCTTCTTC", NULL, 22, 16, 78));
    ASSERT_EQ(83, computeScore("CTCTGTCTCTCTCTCTGTCTCTCTCTTTTAACAGGGTATAAACAGACTTAGGGTAACTAAAAAACGGATTAACAATAAGTGATACGA", 87, "CTCTGTCTCTGTCTCTCTCTCTGTCTCTCTCTTTTAACAGGGTATAAACAGACTTAGGGTAACTAAAAAACGGATTAACA", NULL, 80, 8, 21));
}


/* Edit distance tests */
/*
TEST_F(AffineGapTest, "edit distance-equal length strings") {
    ag.computeScore("GAGTCCCCTTTTTTTTTTTTTCCTTTATAAAAGGCTTTCGATCAGACTCGGTCCGTCATACTTTCTGTGACTTCTATTTTCTCGTCAGAACTTGAGATGT", 100, "GAGTCCCCTTTTTTTTTTTTTCCTTTATAAAAGGCTTTCGATCAGACTCGGTCCGTCATACTTTCTGTGACTTCAATTAACTCGTCAGAACTTGAGATGT", NULL, 100, 16, 20, NULL, &editDist);
    ASSERT_EQ(editDist, 3);
}

TEST_F(AffineGapTest, "edit distance-ref longer") {
    ASSERT_EQ(8, ag.computeScore("TGAGAGGGACGGACATGAGGGGACAAAGTCAAGTCTTTTGTTCAAACTTTATGTCTTGTATCTTATGGAGGTCAAATCTTTCAGACTACATACGGAGAATCAAGG", 105, "TGAGCGGGACGGACATGACAAAGTCAAGTCTTTTGTACAAACTTTATGTCTTGTATCTTATGGAGGTCAAATCTTTCAGACTACATACGGAGAATCCAGG", NULL, 100, 16, 20))
}

TEST_F(AffineGapTest, "edit distance-ref shorter") {
    ASSERT_EQ(5, ag.computeScore("ATACTGAACGACTTCCAAGTCTACTAGTAATCGTCAAAAATCGTTATTTCGTAAAAAAAAAGAAAAAACTCTGTCCCAGAGTATAACAACGGG", 93, "ATACTGAACGACTTCCAAGTCTACTAGAAATCGTCAAAAATCGTTATTTCGTACAAAAAAAAATAAAAAACTCTGTCCCATAGTATAACAACGGG", NULL, 95, 16, 20))
}
*/

