# This module contains patches for slixmpp; some have pending requests upstream
# and should be removed on the next slixmpp release.

# ruff: noqa: F401

import logging

import slixmpp.plugins
import slixmpp.stanza.roster
from slixmpp import InvalidJID, Message
from slixmpp.plugins.xep_0050 import XEP_0050, Command
from slixmpp.plugins.xep_0469.stanza import NS as PINNED_NS
from slixmpp.plugins.xep_0469.stanza import Pinned
from slixmpp.xmlstream import StanzaBase

from . import (
    link_preview,
    xep_0077,
    xep_0100,
    xep_0153,
    xep_0292,
)


# TODO: remove this when we pin slixmpp > 1.9.0
def get_items(self):
    items = {}
    for item in self["substanzas"]:
        if isinstance(item, slixmpp.stanza.roster.RosterItem):
            try:
                items[item["jid"]] = item.values
            except InvalidJID:
                logging.warning("Invalid JID in roster: %s", item)
                continue
            del items[item["jid"]]["jid"]
            del items[item["jid"]]["lang"]
    return items


slixmpp.stanza.roster.Roster.get_items = get_items  # type:ignore


def set_pinned(self, val: bool):
    extensions = self.parent()
    if val:
        extensions.enable("pinned")
    else:
        extensions._del_sub(f"{{{PINNED_NS}}}pinned")


Pinned.set_pinned = set_pinned


def session_bind(self, jid):
    self.xmpp["xep_0030"].add_feature(Command.namespace)
    # awful hack to for the disco items: we need to comment this line
    # related issue: https://todo.sr.ht/~nicoco/slidge/131
    # self.xmpp['xep_0030'].set_items(node=Command.namespace, items=tuple())


XEP_0050.session_bind = session_bind  # type:ignore


def reply(self, body=None, clear=True):
    """
    Overrides slixmpp's Message.reply(), since it strips to sender's resource
    for mtype=groupchat, and we do not want that, because when we raise an XMPPError,
    we actually want to preserve the resource.
    (this is called in RootStanza.exception() to handle XMPPErrors)
    """
    new_message = StanzaBase.reply(self, clear)
    new_message["thread"] = self["thread"]
    new_message["parent_thread"] = self["parent_thread"]

    del new_message["id"]
    if self.stream is not None and self.stream.use_message_ids:
        new_message["id"] = self.stream.new_id()

    if body is not None:
        new_message["body"] = body
    return new_message


Message.reply = reply  # type: ignore


slixmpp.plugins.PLUGINS.extend(
    [
        "link_preview",
        "xep_0292_provider",
    ]
)
