//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
warning("off");

function r=testresult(eps)
  if argn(2)<=0 then eps=1d-10;end
  if or(isnan(real(y))<>isnan(real(yref)))  then r=%t,return,end;
  if or(isnan(imag(y))<>isnan(imag(yref)))  then r=%t,return,end;
  if or(size(y)<>size(yref)) then r=%t,return,end;
  if yref==[] then r=%f,return,end;
  k=find(abs(yref)==0);
  r=or(abs(y(k)-yref(k))>eps);
  k=find(abs(yref)<>0);
  r=r|or(max(abs(y(k)-yref(k))./abs(yref(k)))>eps);
endfunction
ieee(1)

// ------------------------------ bessely(alpha,x)------------------------------
//test of numerical precision reference computed by maple
exec(SCI+'/modules/special_functions/tests/unit_tests/bessely_ref.sce',-1)
besselY=bessely(alpha',x);
if norm((besselY-besselY_ref)./abs(besselY_ref),1)>1d6*%eps then pause,end

alpha=[];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[-10.3349026794206473];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-10.3349026794206473];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.0882569642156769973];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0882569642156769696];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[0.376850010012790504 -0.0169407393250650198 -0.308517625249033867];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.376850010012790504 -0.0169407393250650129 -0.308517625249033811];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0627738863740378017+0.576433895270028751*%i 0.266221867363905018+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0627738863740374964+0.576433895270028751*%i 0.266221867363905074+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[ 0.376850010012790504
-0.0169407393250650198
 -0.308517625249033867];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.376850010012790504
-0.0169407393250650129
 -0.308517625249033811];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0627738863740378017+0.576433895270028751*%i 
 0.266221867363905018+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0627738863740374964+0.576433895270028751*%i 
 0.266221867363905074+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0594911047067641363+0.570852419787944876*%i 0.266276386958715638+0.00106971720159772243*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0583131019071235768+0.55954878453009449*%i 0.261003761229849252+0.00104853538181959999*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[-6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[-0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.324674424791800087 0.397925710557099965 0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031 0.397925710557100021 0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.28459437186807196-0.165140860986515869*%i -0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.28459437186807196-0.165140860986515869*%i -0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[0.324674424791800087
0.397925710557099965
0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031
0.397925710557100021
0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ 0.28459437186807196-0.165140860986515869*%i 
-0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.28459437186807196-0.165140860986515869*%i 
-0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.273570530695402159-0.163153078769770365*%i -0.053488563419309812+0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.268153471243458119-0.159922431356041589*%i -0.0524294189006919362+0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[-6366197.72367634624 -127323954473516.594 -5.09295817894065707e+21];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-6366197.72367634624 -127323954473516.578 -5.09295817894065812e+21];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[-0.781212821300288907 -1.65068260681625478 -5.82151760596473089];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.781212821300288907 -1.65068260681625478 -5.82151760596473089];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.324674424791800087 0.215903594603614996 0.146267162693192898];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031 0.215903594603615023 0.14626716269319287];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[0.324674424791800087 -0.16040039348492377 -0.538541616105031817
0.397925710557099965 0.215903594603615023 -0.182022115953484942
0.147863143391226859 0.367662882605524655 0.146267162693192898];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031 -0.160400393484923798 -0.538541616105031817
0.397925710557100021 0.215903594603615051 -0.182022115953484942
0.147863143391226803 0.367662882605524544 0.14626716269319287];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ 0.28459437186807196-0.165140860986515869*%i -0.140744947159810951-0.531189823766873737*%i -0.207473852876394749+0.456203778119049386*%i 
-0.0534845083974161278+0*%i -0.278956274125194581+0*%i -0.0793518126145812824+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.28459437186807196-0.165140860986515869*%i -0.140744947159811229-0.531189823766873737*%i -0.207473852876394638+0.456203778119049441*%i 
-0.0534845083974161833+0*%i -0.278956274125194637+0*%i -0.0793518126145812824+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[-168658652.388109088 -4047807657314589 -1.78103536921841748e+23];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-168658652.388109088 -4047807657314589.5 -1.78103536921841714e+23];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[-0.901214954842308846 -2.02168904229560242 -7.99421683125834193];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.901214954842308735 -2.02168904229560242 -7.99421683125834193];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.236105148830688782 0.137707238974328822 0.0774312728572489062];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.236105148830688782 0.137707238974328877 0.0774312728572488507];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[0.236105148830688782 -0.249464037123650451 -0.601985736612042799
0.404200660729673644 0.137707238974328822 -0.25272269785791196
0.231079618553641175 0.350580558421466015 0.0774312728572489062];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.236105148830688782 -0.249464037123650617 -0.60198573661204291
 0.4042006607296737 0.137707238974328877 -0.252722697857912071
0.231079618553641009 0.350580558421465849 0.0774312728572488507];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.240226585254262215-0.173655347820190264*%i -0.0558641372965151817-0.434822373349611213*%i -0.206555050445403759+0.435740066003517668*%i 
-0.12841584805211595+0*%i -0.268892924189574611+0*%i -0.0124328265233755314+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.24022658525426227-0.173655347820190098*%i -0.0558641372965149458-0.434822373349611269*%i -0.206555050445404065+0.435740066003517612*%i 
-0.128415848052115866+0*%i -0.268892924189574556+0*%i -0.0124328265233754898+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[-10.3349026794206473
-6366197.72367634624
-127323954473516.594];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-10.3349026794206473
-6366197.72367634624
-127323954473516.578];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.0882569642156769973
-0.781212821300288907
 -1.65068260681625478];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0882569642156769696
-0.781212821300288907
 -1.65068260681625478];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[ 0.376850010012790504 0.324674424791800087 -0.160400393484923798
-0.0169407393250650198 0.397925710557099965 0.215903594603614996
 -0.308517625249033867 0.147863143391226887 0.367662882605524655];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.376850010012790504 0.324674424791800031 -0.160400393484923853
-0.0169407393250650129 0.397925710557100021 0.215903594603615023
 -0.308517625249033811 0.147863143391226831 0.367662882605524544];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0627738863740378017+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i -0.140744947159810951-0.531189823766873737*%i 
 0.266221867363905018+0*%i -0.0534845083974161417+0*%i -0.278956274125194581+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0627738863740374964+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i -0.140744947159811201-0.531189823766873737*%i 
 0.266221867363905074+0*%i -0.0534845083974161833+0*%i -0.278956274125194637+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[0.376850010012790504
0.397925710557099965
0.367662882605524655];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.376850010012790504
0.397925710557100021
0.367662882605524544];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0594911047067641363+0.570852419787944876*%i 0.273570530695402159-0.163153078769770365*%i -0.134563835842271912-0.526358624867831137*%i 
 0.266276386958715638+0.00106971720159772243*%i -0.0534885634193098258+0.00545213754945528262*%i -0.279008596242427576+0.000258725570376667352*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0583131019071235768+0.55954878453009449*%i 0.268153471243458119-0.159922431356041589*%i -0.131899293367662818-0.515936025779016094*%i 
 0.261003761229849252+0.00104853538181959999*%i -0.0524294189006919362+0.00534417799266206917*%i -0.273483855878007609+0.000253602460833710075*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[-10.5435018262277929
-8811068.85048608482
-179745804549905.625];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-10.5435018262277929
-8811068.85048608482
-179745804549905.656];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[0.0643040307807657419
-0.793245652497184595
 -1.68252516187502232];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0643040307807657419
-0.793245652497184706
 -1.68252516187502277];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[ 0.384820425921874987 0.316452158174697407 -0.169632958363080733
-0.00447693217669133808 0.399776541248366868 0.208362968213358424
 -0.302795423995985136 0.15685459545204769 0.366792098940420641];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.384820425921874987 0.316452158174697407 -0.169632958363080816
-0.00447693217669134502 0.399776541248366868 0.208362968213358452
 -0.302795423995985136 0.156854595452047746 0.366792098940420641];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0535918058658350627+0.575574764795366067*%i 0.286331738254591017-0.166506620507523545*%i -0.133607798473967337-0.529044147557647282*%i 
 0.26392041753001122+0*%i -0.0613287659781691918+0*%i -0.278814546410423747+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0535918058658351945+0.575574764795366067*%i 0.286331738254590962-0.166506620507523573*%i -0.13360779847396731-0.52904414755764706*%i 
 0.26392041753001122+0*%i -0.061328765978169178+0*%i -0.278814546410423747+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[0.384820425921874987
0.399776541248366868
0.366792098940420641];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.384820425921874987
0.399776541248366868
0.366792098940420641];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0503114628539832326+0.569955434445619136*%i 0.27533846887479968-0.164682242384238758*%i -0.127380869613414494-0.524145792482789141*%i 
 0.263974678263304063+0.00123918133456109997*%i -0.061334389730632502+0.00542770518273297253*%i -0.278866950019879489+0.000114433428284946292*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0493152291415966115+0.55866956068757101*%i 0.269886401901392015-0.161421315502212115*%i -0.12485855939972948-0.513767010410947855*%i 
 0.258747629420268188+0.00121464390012337303*%i -0.0601198874420454457+0.00532022941921519998*%i -0.273345014438587053+0.000112167494586902505*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[-0.324674424791800087 -0.397925710557099965 -0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.324674424791800031 -0.397925710557100021 -0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.28459437186807196+0.165140860986515869*%i 0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.28459437186807196+0.165140860986515869*%i 0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[-0.324674424791800087
-0.397925710557099965
-0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.324674424791800031
-0.397925710557100021
-0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ -0.28459437186807196+0.165140860986515869*%i 
0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.28459437186807196+0.165140860986515869*%i 
0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.273570530695402159+0.163153078769770365*%i 0.053488563419309812-0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.268153471243458119+0.159922431356041589*%i 0.0524294189006919362-0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[ 6366197.72367634624
-8.4104417400672E-12];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 6366197.72367634624
 -8.4104417400672E-12];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[ 0.781212821300288907
-0.240297839123427059];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.781212821300288907
-0.240297839123427059];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[-0.324674424791800087 -0.477718215087092224
-0.397925710557099965 -0.185285948354267732
-0.147863143391226859 0.169651306144741165];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.324674424791800031 -0.477718215087092224
-0.397925710557100021 -0.185285948354267732
-0.147863143391226803 0.169651306144741165];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.28459437186807196+0.165140860986515869*%i -1.66533453693773654e-16-0.120953010973629607*%i 
0.0534845083974161278+0*%i -0.170966347821113557+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.28459437186807196+0.165140860986515869*%i -1.66533453693773654e-16-0.120953010973629607*%i 
0.0534845083974161833+0*%i -0.170966347821113557+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ -0.28459437186807196+0.165140860986515869*%i 
-0.170966347821113557+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.28459437186807196+0.165140860986515869*%i 
-0.170966347821113557+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.273570530695402159+0.163153078769770365*%i 0.00552027940993567862-0.120968618958143467*%i 
 0.053488563419309812-0.00545213754945528262*%i -0.171004326769525289-0.00409499672885600772*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.268153471243458119+0.159922431356041589*%i 0.00541097055390155068-0.118573279814522647*%i 
0.0524294189006919362-0.00534417799266206917*%i -0.16761821422920356-0.00401391036082020345*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[5.09295817894065707e+21
 -127323954473516.594
 6366197.72367634624
 -10.3349026794206473
 -6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[5.09295817894065812e+21
 -127323954473516.578
 6366197.72367634624
 -10.3349026794206473
 -6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[1];
yref=[ 5.82151760596473089
 -1.65068260681625478
 0.781212821300288907
0.0882569642156769973
-0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 5.82151760596473089
 -1.65068260681625478
 0.781212821300288907
0.0882569642156769696
-0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[3 4 5];
yref=[ 0.538541616105031817 -0.160400393484923798 -0.324674424791800087 0.376850010012790504 0.324674424791800087
 0.182022115953484942 0.215903594603614996 -0.397925710557099965 -0.0169407393250650198 0.397925710557099965
-0.146267162693192898 0.367662882605524655 -0.147863143391226859 -0.308517625249033867 0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.538541616105031817 -0.160400393484923853 -0.324674424791800031 0.376850010012790504 0.324674424791800031
0.182022115953484942 0.215903594603615023 -0.397925710557100021 -0.0169407393250650129 0.397925710557100021
-0.14626716269319287 0.367662882605524544 -0.147863143391226803 -0.308517625249033811 0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.207473852876394749-0.456203778119049386*%i -0.140744947159810951-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740378017+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
0.0793518126145812824+0*%i -0.278956274125194581+0*%i 0.0534845083974161278+0*%i 0.266221867363905018+0*%i -0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.207473852876394638-0.456203778119049441*%i -0.140744947159811201-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740374964+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
0.0793518126145812824+0*%i -0.278956274125194637+0*%i 0.0534845083974161833+0*%i 0.266221867363905074+0*%i -0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.200627649489689364-0.451768607139008516*%i -0.134563835842271912-0.526358624867831137*%i -0.273570530695402159+0.163153078769770365*%i 0.0594911047067641363+0.570852419787944876*%i 0.273570530695402159-0.163153078769770365*%i 
0.0793716263712800352+0.00501260111167922684*%i -0.279008596242427576+0.000258725570376667352*%i 0.053488563419309812-0.00545213754945528262*%i 0.266276386958715638+0.00106971720159772243*%i -0.053488563419309812+0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.196654955858446223-0.44282298935929687*%i -0.131899293367662818-0.515936025779016094*%i -0.268153471243458119+0.159922431356041589*%i 0.0583131019071235768+0.55954878453009449*%i 0.268153471243458119-0.159922431356041589*%i 
0.0777999628673285148+0.00491334495948420047*%i -0.273483855878007609+0.000253602460833710075*%i 0.0524294189006919362-0.00534417799266206917*%i 0.261003761229849252+0.00104853538181959999*%i -0.0524294189006919362+0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[-127323954473516.594
 6366197.72367634624
-10.3349026794206473
-6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-127323954473516.578
 6366197.72367634624
-10.3349026794206473
-6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[1];
yref=[ -1.65068260681625478
 0.781212821300288907
0.0882569642156769973
-0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -1.65068260681625478
 0.781212821300288907
0.0882569642156769696
-0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[3 4 5];
yref=[-0.160400393484923798 -0.324674424791800087 0.376850010012790504 0.324674424791800087
 0.215903594603614996 -0.397925710557099965 -0.0169407393250650198 0.397925710557099965
 0.367662882605524655 -0.147863143391226859 -0.308517625249033867 0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.160400393484923853 -0.324674424791800031 0.376850010012790504 0.324674424791800031
 0.215903594603615023 -0.397925710557100021 -0.0169407393250650129 0.397925710557100021
 0.367662882605524544 -0.147863143391226803 -0.308517625249033811 0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.140744947159810951-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740378017+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
-0.278956274125194581+0*%i 0.0534845083974161278+0*%i 0.266221867363905018+0*%i -0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.140744947159811201-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740374964+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
-0.278956274125194637+0*%i 0.0534845083974161833+0*%i 0.266221867363905074+0*%i -0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.134563835842271912-0.526358624867831137*%i -0.273570530695402159+0.163153078769770365*%i 0.0594911047067641363+0.570852419787944876*%i 0.273570530695402159-0.163153078769770365*%i 
-0.279008596242427576+0.000258725570376667352*%i 0.053488563419309812-0.00545213754945528262*%i 0.266276386958715638+0.00106971720159772243*%i -0.053488563419309812+0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.131899293367662818-0.515936025779016094*%i -0.268153471243458119+0.159922431356041589*%i 0.0583131019071235768+0.55954878453009449*%i 0.268153471243458119-0.159922431356041589*%i 
-0.273483855878007609+0.000253602460833710075*%i 0.0524294189006919362-0.00534417799266206917*%i 0.261003761229849252+0.00104853538181959999*%i -0.0524294189006919362+0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 520508809.337161601
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 520508809.337161541
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 0.314183689901754548
 0.454431262899763211
-0.586842447641611864
 -1.27601068959802011];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.314183689901754548
 0.454431262899763155
-0.586842447641611864
 -1.27601068959802033];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[-0.466080611113182774 0.212390924829804428 0.423602426147222433 -0.014709792627767504
-0.306380088504755232 -0.199425513451468028 0.336293915522475506 0.317128383884334675
0.0416545814756713872 -0.355966921924181279 0.00106144915522857208 0.356264127687647869];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.466080611113182774 0.212390924829804484 0.423602426147222433 -0.0147097926277675942
-0.306380088504755177 -0.199425513451468028 0.336293915522475562 0.317128383884334619
0.0416545814756714428 -0.355966921924181279 0.00106144915522855821 0.356264127687647758];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.121666717696636423+0.0833864463893779634*%i 0.110649033008904024+0.419447053092179445*%i 0.130761158765862334-0.0489113461352237433*%i -0.135726515511943424-0.4100667949292639*%i 
-0.0862806191484301321+0*%i 0.268366926287593732+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.12166671769663634+0.0833864463893780328*%i 0.110649033008904024+0.4194470530921795*%i 0.130761158765862362-0.0489113461352239931*%i -0.135726515511943285-0.4100667949292639*%i 
-0.086280619148430146+0*%i 0.268366926287593677+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -0.113594218202467456+0.080767182276823099*%i 0.109351445375408682+0.417004570698233712*%i 0.122488039151380818-0.046468467367517037*%i -0.132866541475518879-0.408157234754056908*%i 
-0.0863035346120157726-0.00510058899774245254*%i 0.268418706707374222-0.00153406339209650328*%i 0.0671311394293841734+0.00525581351428117127*%i -0.25722816126732434+0.0023833881553354877*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.111344901977376662+0.0791678849144669128*%i 0.107186141681151675+0.408747326961261703*%i 0.120062613472129431-0.0455483300642385985*%i -0.130235607681160659-0.400075180006480513*%i 
-0.0845946101283816532-0.00499959056867008752*%i 0.263103660205283252-0.00150368690170144784*%i 0.0658018538062531688+0.00515174143384616867*%i -0.252134702411367373+0.00233619390783472436*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -13533229042766080
 520508809.337161601
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -13533229042766082
 520508809.337161541
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ -1.27130885664432558
 0.314183689901754548
 0.454431262899763211
-0.586842447641611864
 -1.27601068959802011];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -1.2713088566443258
 0.314183689901754548
 0.454431262899763155
-0.586842447641611864
 -1.27601068959802033];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[0.191545604801620084 -0.466080611113182774 0.212390924829804428 0.423602426147222433 -0.014709792627767504
0.398572570979558172 -0.306380088504755232 -0.199425513451468028 0.336293915522475506 0.317128383884334675
0.334306539556831872 0.0416545814756713872 -0.355966921924181279 0.00106144915522857208 0.356264127687647869];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.191545604801620056 -0.466080611113182774 0.212390924829804484 0.423602426147222433 -0.0147097926277675942
0.398572570979558116 -0.306380088504755177 -0.199425513451468028 0.336293915522475562 0.317128383884334619
0.334306539556831872 0.0416545814756714428 -0.355966921924181279 0.00106144915522855821 0.356264127687647758];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.153982384517294985-0.389747770816509909*%i -0.121666717696636423+0.0833864463893779634*%i 0.110649033008904024+0.419447053092179445*%i 0.130761158765862334-0.0489113461352237433*%i -0.135726515511943424-0.4100667949292639*%i 
-0.241661020360698642+0*%i -0.0862806191484301321+0*%i 0.268366926287593732+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.153982384517294929-0.38974777081651002*%i -0.12166671769663634+0.0833864463893780328*%i 0.110649033008904024+0.4194470530921795*%i 0.130761158765862362-0.0489113461352239931*%i -0.135726515511943285-0.4100667949292639*%i 
-0.241661020360698614+0*%i -0.086280619148430146+0*%i 0.268366926287593677+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.149888167842517933-0.388349236524206054*%i -0.113594218202467456+0.080767182276823099*%i 0.109351445375408682+0.417004570698233712*%i 0.122488039151380818-0.046468467367517037*%i -0.132866541475518879-0.408157234754056908*%i 
-0.241702100416107291+0.00304920616213296336*%i -0.0863035346120157726-0.00510058899774245254*%i 0.268418706707374222-0.00153406339209650328*%i 0.0671311394293841734+0.00525581351428117127*%i -0.25722816126732434+0.0023833881553354877*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.146920183263616416-0.380659406420718049*%i -0.111344901977376662+0.0791678849144669128*%i 0.107186141681151675+0.408747326961261703*%i 0.120062613472129431-0.0455483300642385985*%i -0.130235607681160659-0.400075180006480513*%i 
-0.236916078163324606+0.00298882783476134631*%i -0.0845946101283816532-0.00499959056867008752*%i 0.263103660205283252-0.00150368690170144784*%i 0.0658018538062531688+0.00515174143384616867*%i -0.252134702411367373+0.00233619390783472436*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
