// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2013 - Scilab Enterprises - Vincent COUVERT
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- Non-regression test for bug 12319 -->
// <-- TEST WITH GRAPHIC -->
// <-- INTERACTIVE TEST -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/12319
//
// <-- Short Description -->
// Slider not respond to "Value" for positioning post 5.4.0 in recent nightly builds

ppi = 120; // pixels per inch

figGC = figure( ...
        'Userdata',0, ...
        'figure_position',[4*ppi, 4*ppi], ...
        'figure_size',[5*ppi, 3*ppi], ...
        'auto_resize','on', ...
        'BackgroundColor',[0.85, 0.85, 0.85], ...
        'figure_name', 'Slider Not Respond to ''Value'', val');


mySlider= uicontrol( ...
        'Parent'        , figGC, ...
        'Style'            , 'slider', ...
        'Min'            , -90, ...
        'Max'            , 90, ...
        'Value'            , 0,...
        'SliderStep'    , [1.00, 5.00],...
        'Units'            , 'inches',...
        'Position'        , [1.0,1.0,1.00,0.15] );

// Check that the slider cursor is centered.