/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CulcInputDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/09
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __CULCINPUTDLG_H__
#define __CULCINPUTDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
#define CID_BTN_0             0
#define CID_BTN_1             1
#define CID_BTN_2             2
#define CID_BTN_3             3
#define CID_BTN_4             4
#define CID_BTN_5             5
#define CID_BTN_6             6
#define CID_BTN_7             7
#define CID_BTN_8             8
#define CID_BTN_9             9
#define CID_BTN_EQUAL        10
#define CID_BTN_DOT          11
#define CID_BTN_CLEAR        12
#define CID_BTN_PURASU       13
#define CID_BTN_MAINASU      14
#define CID_BTN_KAKERU       15
#define CID_BTN_WARU         16
#define CID_BTN_OPEN         17
#define CID_BTN_CLOSED       18


struct _CULCINPUT_DLG
{
	int value;
	char title[256];
	char msg1[256];
	char msg2[256];
	char default_str[256];
	char push_str;
	gdouble anser;

	GtkWidget *entry;
	GtkWidget *button[20];
	GtkWidget *parent;
	GtkWidget *dialog;
};
typedef struct _CULCINPUT_DLG CULCINPUT_DLG;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _CULCINPUTDLG_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL char def_str[256];


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _CULCINPUTDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* コピー【移動/複写】設定 */
gint CulcInputDialog(CULCINPUT_DLG *culcinput_dlg);
gint CulcInputBox(GtkWidget *widget, char *title, char *msg1, char *msg2, char *default_str);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __CULCINPUTDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CulcInputDlg.h
 * ====================================================================
 */
