#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-05  
# conf/config-nss.sh

### P A R A M S
# none

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...
nssconffile=nsswitch.conf

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_MOD=644

### H E L P E R S

function confWinbind()
{
awk 'BEGIN {
	FS=" ";
	keys="passwd:,shadow:,group:";
	n=split(keys,key,",");
	}
	{
	foundkey=0;
	for(k=1;k<=n;k++)
	{
		if(key[k] == $1)
		{
			foundkey=1;
			#printf("<%s\n",$0);
			if(index($0,"winbind") == 0)
			{
				printf("%-12s\t",$1);
				set=0;
				for (i=2;i<=NF;i++)
				{
					printf("%s ",$i);
					if("files" == $i || "compat" == $i)
					{
						printf("winbind ");
						set=1;
					}
				}
				if (!set)
					printf("winbind");
				printf("\n");
			}
			else
			{
				printf("%s\n",$0);
			}
			break;
		}
	}
	if(!foundkey)
		print
	}'
}

function confDns()
{
awk 'BEGIN {
	FS=" ";
	keys="hosts:";
	n=split(keys,key,",");
	}
	{
		if(index($0,"#[SADMS]#") == 0)
		{
			foundkey=0;
			for(k=1;k<=n;k++)
			{
				if(key[k] == $1)
				{
					foundkey=1;
					#printf("<%s\n",$0);
					if(index($0,"mdns") != 0)
					{
						printf("%s\n",$0);
						printf("#[SADMS]#%-12s\t",$1,"");
						found=0;
						for (i=2;i<=NF;i++)
						{
							if(index($i,"mdns") != 0)
							{
								found=1;
								continue;
							}
							if(found && index($i,"[NOTFOUND=return]") != 0)
							{
								found=0;
								continue;
							}
							found=0;
							printf("%s ",$i);
						}
						printf("\n");
					}
					else
					{
						printf("%s\n",$0);
					}
					break;
				}
			}
			if(!foundkey)
				print
		}
	}'
}

function fixUbuntuNscd()
{
	echo "ubuntu create /var/run/nscd /var/db/nscd for nscd operation"
	[ -d /var/run/nscd ] || mkdir -p /var/run/nscd
	[ -d /var/db/nscd ] || mkdir -p /var/db/nscd
}

function fixAvahi()
{
	if grep 'hosts:.*mdns' ${ETCDIR}/${nssconffile} > /dev/null; then
		echo "WARNING: avahi may interfere with naming"
		echo "in case of trouble,uncomment suggested 'host:' line in ${ETCDIR}/${nssconffile}"
	fi
}

### S T A R T

echo "+configure name switch service"

# E N S U R E   N S S S W I T C H . C O N F   E X I S T S
# create nsswitch.conf if needed
if [ ! -f ${ETCDIR}/${nssconffile} ]; then
	echo "copy new ${ETCDIR}/${nssconffile}"
	cp ./_${nssconffile} ${ETCDIR}/${nssconffile}
fi

# C U S T O M I Z E   E X I S T I N G   N S S W I T C H . C O N F
cat ${ETCDIR}/${nssconffile} | confWinbind | confDns > ${TMPDIR}/${nssconffile}
#cat ${TMPDIR}/${nssconffile} | grep -v "^#" | grep -v "^$"

# D N S
fixAvahi

# I N S T A L L
echo "install modified ${nssconffile} to ${ETCDIR}"
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_MOD} ${TMPDIR}/${nssconffile} ${ETCDIR} > /dev/null

# C L E A N U P
rm -f ${TMPDIR}/${nssconffile}

# D Y N A M I C   L O A D E R
echo "configure dynamic linker run time bindings"
ldconfig -v 2> /dev/null | grep winbind | sed 's/^[[:space:]]*//'

#  N A M E   S W I T C H   C A C H E   D A E M O N  F I X
case ${DISTRIBUTION} in
	Ubuntu)
		exit 0
		;;
	*)
		;;
esac

# S E R V I C E  N A M E   S W I T C H   C A C H E   D A E M O N  A U T O S T A R T
echo "+${NSCDSERVICE} automatic startup"
${SERVICEADD} ${NSCDSERVICE} > /dev/null;

# S E R V I C E  N A M E   S W I T C H   C A C H E   D A E M O N  
echo "+start ${NSCDSERVICE}"
if ${SERVICESTATUS} ${NSCDSERVICE} > /dev/null; then
	${SERVICE} ${NSCDSERVICE} restart > /dev/null
else
	${SERVICE} ${NSCDSERVICE} start > /dev/null
fi

if ${SERVICESTATUS} ${NSCDSERVICE} > /dev/null; then
	echo "${NSCDSERVICE} started"
else
	echo "${NSCDSERVICE} failed to start" >&2
	exit 1
fi
