/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKECAMERAZOOMCONTROL_H
#define FAKECAMERAZOOMCONTROL_H

#include <QCameraZoomControl>

class FakeCameraService;

class FakeCameraZoomControl : public QCameraZoomControl
{
public:
    FakeCameraZoomControl(FakeCameraService *service, QObject *parent = 0);

    qreal currentDigitalZoom() const;
    qreal currentOpticalZoom() const;
    qreal maximumDigitalZoom() const;
    qreal maximumOpticalZoom() const;
    qreal requestedDigitalZoom() const;
    qreal requestedOpticalZoom() const;
    void zoomTo(qreal optical, qreal digital);

    void resetZoom();

private:
    FakeCameraService *m_service;
    qreal m_zoom;
    qreal m_maxZoom;
};

#endif // FAKECAMERAZOOMCONTROL_H
