/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <QObject>
#include <QList>

class QChatBasicPlugin;
class QChatWidgetPlugin;
class Plugin;

#include "abstractchatcore.h"

#include <QPluginLoader>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class PluginManager : public QObject
{
  Q_OBJECT
  private:
    QList<Plugin*> m_plugins;

  public:
    PluginManager(QObject *parent = 0);
    ~PluginManager();

    /**
     * @brief Gets information about available plugins
     *
     * This function checks all appropriate directories for availability of plugins,\n
     * trying to load every plugin and get information about it(put this information to PluginInfo object)\n
     * and after all unloads plugin.
     */
    void getPlugins();

    QList<Plugin*> plugins(){return m_plugins;}

    Plugin* getPluginByPath(const QString&);

  public slots:
    void load(const QString&);
    void unload(const QString&);

  signals:
    void sendData(const QString &, const QMap<QString, QByteArray> &, quint64,
             AbstractChatCore::DataType, const QString &, uint, const QString &);
};

#endif
