#ifndef QCSKYSYSTEM_HPP
#define QCSKYSYSTEM_HPP

/**
	@author Harald Krippel <harald@the-develop.net>
*/
#include <QObject>
#include <plib/ssgaSky.h>

class Camera;

class qcSkySystem: public QObject, public ssgaSky
{
   Q_OBJECT
  public:
    qcSkySystem(QObject *parent=0, Camera * context=0);

    ~qcSkySystem();
  void update( float dt );
  sgdVec3* add_stardata(int nstars);

  public slots:
   void   slot_update(float dt);
   void   slot_preDraw();
   void   slot_postDraw();

  protected:

  int        nplanets;
  sgdVec3    *planet_data;
  int        nstars;
  sgdVec3    *star_data;

  double m_log01;
  double sqrt_m_log01;

  sgVec4 myblack;
  sgVec4 mywhite;
//static sgVec4 translucent_white = { 1.0, 1.0, 1.0, 0.8 } ;

  sgVec4 base_sky_color;
  sgVec4 base_fog_color;

  sgVec4 base_ambient;
  sgVec4 base_diffuse;
  sgVec4 base_specular;

  sgVec4 sky_color ;
  sgVec4 fog_color ;
  sgVec4 cloud_color ;

  sgVec4 scene_ambient ;
  sgVec4 scene_diffuse ;
  sgVec4 scene_specular ;
  sgCoord campos ;

  Camera *my_context;
};

#endif
