'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2431 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2431
\- EEPROM (1 kBit)
.SH SYNOPSIS
Erasable programmable read-only memory (EEPROM)
.PP
.B 2D
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-3|ALL]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 2D
DS2431
.SH SPECIAL PROPERTIES
.SS memory
.I read-write, binary
.br
128 bytes of EEPROM memory. Initially all bits are set to 1. Memory is non-volatile.
.SS pages/page.0 ... pages/page.3 pages/page.ALL
.I read-write, yes-no
.br
Memory is split into 4 pages of 32 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2431
The
.B DS2431 (3)
is used for storing memory which should be available even after a reset or power off. It is also switch to erase-only mode (EPROM) although this isn't implemented in OWFS.
.I OWFS
system handles this automatically.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2431.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Christian Magnusson (mag@mag.cx)
