/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt --conf-parser 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X)	/* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: sgsnemu [OPTIONS]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
	"  -h, --help                    Print help and exit",
	"  -V, --version                 Print version and exit",
	"  -d, --debug                   Run in debug mode  (default=off)",
	"  -c, --conf=STRING             Read configuration file",
	"      --pidfile=STRING          Filename of process id file\n                                  (default=`./sgsnemu.pid')",
	"      --statedir=STRING         Directory of nonvolatile data  (default=`./')",
	"      --dns=STRING              DNS Server to use",
	"  -l, --listen=STRING           Local host",
	"  -r, --remote=STRING           Remote host",
	"      --contexts=INT            Number of contexts  (default=`1')",
	"      --timelimit=INT           Exit after timelimit seconds  (default=`0')",
	"      --gtpversion=INT          GTP version to use  (default=`1')",
	"  -a, --apn=STRING              Access point name  (default=`internet')",
	"      --selmode=INT             Selection mode  (default=`0x01')",
	"      --rattype=1..5            Radio Access Technology Type  (default=`1')",
	"      --userloc=type.MCC.MNC.LAC.CIorSACorRAC\n                                User Location Information\n                                  (default=`02509946241207')",
	"      --rai=MCC.MNC.LAC.RAC     Routing Area Information\n                                  (default=`02509946241207')",
	"      --mstz=sign.NbQuartersOfAnHour.DSTAdjustment\n                                MS Time Zone  (default=`0')",
	"      --imeisv=STRING           IMEI(SV) International Mobile Equipment\n                                  Identity (and Software Version)\n                                  (default=`2143658709214365')",
	"      --norecovery              Do not send recovery  (default=off)",
	"  -i, --imsi=STRING             IMSI  (default=`240010123456789')",
	"      --nsapi=INT               NSAPI  (default=`0')",
	"  -m, --msisdn=STRING           Mobile Station ISDN number\n                                  (default=`46702123456')",
	"  -q, --qos=INT                 Requested quality of service\n                                  (default=`0x000b921f')",
	"      --qose1=INT               Requested quality of service Extension 1\n                                  (default=`0x9396404074f9ffff')",
	"      --qose2=INT               Requested quality of service Extension 2\n                                  (default=`0x11')",
	"      --qose3=INT               Requested quality of service Extension 3\n                                  (default=`0x0101')",
	"      --qose4=INT               Requested quality of service Extension 4\n                                  (default=`0x4040')",
	"      --charging=INT            Charging characteristics  (default=`0x0800')",
	"  -u, --uid=STRING              Login user ID  (default=`mig')",
	"  -p, --pwd=STRING              Login password  (default=`hemmelig')",
	"\n Mode: createif\n  any option of this mode is related to tun interface, all payload going in and\n  out  via tunN interface",
	"      --createif                Create local network interface  (default=off)",
	"  -n, --net=STRING              Network address for local interface",
	"      --defaultroute            Create default route  (default=off)",
	"      --ipup=STRING             Script to run after link-up",
	"      --ipdown=STRING           Script to run after link-down",
	"      --tun-device=STRING       Name of the local network interface",
	"\n Mode: pinghost\n  generate ICMP payload inside G-PDU without setting up tun interface",
	"      --pinghost=STRING         Ping remote host",
	"      --pingrate=INT            Number of ping req per second  (default=`1')",
	"      --pingsize=INT            Number of ping data bytes  (default=`56')",
	"      --pingcount=INT           Number of ping req to send  (default=`0')",
	"      --pingquiet               Do not print ping packet info  (default=off)",
	"      --no-tx-gpdu-seq          Don't transmit G-PDU sequence nums\n                                  (default=off)",
	"  -t, --pdp-type=(v4|v6)        PDP Type  (default=`v4')",
	0
};

typedef enum { ARG_NO, ARG_FLAG, ARG_STRING, ARG_INT
} cmdline_parser_arg_type;

static
void clear_given(struct gengetopt_args_info *args_info);
static
void clear_args(struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal(int argc, char **argv,
			struct gengetopt_args_info *args_info,
			struct cmdline_parser_params *params,
			const char *additional_error);

static int
cmdline_parser_required2(struct gengetopt_args_info *args_info,
			 const char *prog_name, const char *additional_error);
struct line_list {
	char *string_arg;
	struct line_list *next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void free_cmd_list(void)
{
	/* free the list of a previous call */
	if (cmd_line_list) {
		while (cmd_line_list) {
			cmd_line_list_tmp = cmd_line_list;
			cmd_line_list = cmd_line_list->next;
			free(cmd_line_list_tmp->string_arg);
			free(cmd_line_list_tmp);
		}
	}
}

static char *gengetopt_strdup(const char *s);

static
void clear_given(struct gengetopt_args_info *args_info)
{
	args_info->help_given = 0;
	args_info->version_given = 0;
	args_info->debug_given = 0;
	args_info->conf_given = 0;
	args_info->pidfile_given = 0;
	args_info->statedir_given = 0;
	args_info->dns_given = 0;
	args_info->listen_given = 0;
	args_info->remote_given = 0;
	args_info->contexts_given = 0;
	args_info->timelimit_given = 0;
	args_info->gtpversion_given = 0;
	args_info->apn_given = 0;
	args_info->selmode_given = 0;
	args_info->rattype_given = 0;
	args_info->userloc_given = 0;
	args_info->rai_given = 0;
	args_info->mstz_given = 0;
	args_info->imeisv_given = 0;
	args_info->norecovery_given = 0;
	args_info->imsi_given = 0;
	args_info->nsapi_given = 0;
	args_info->msisdn_given = 0;
	args_info->qos_given = 0;
	args_info->qose1_given = 0;
	args_info->qose2_given = 0;
	args_info->qose3_given = 0;
	args_info->qose4_given = 0;
	args_info->charging_given = 0;
	args_info->uid_given = 0;
	args_info->pwd_given = 0;
	args_info->createif_given = 0;
	args_info->net_given = 0;
	args_info->defaultroute_given = 0;
	args_info->ipup_given = 0;
	args_info->ipdown_given = 0;
	args_info->tun_device_given = 0;
	args_info->pinghost_given = 0;
	args_info->pingrate_given = 0;
	args_info->pingsize_given = 0;
	args_info->pingcount_given = 0;
	args_info->pingquiet_given = 0;
	args_info->no_tx_gpdu_seq_given = 0;
	args_info->pdp_type_given = 0;
	args_info->createif_mode_counter = 0;
	args_info->pinghost_mode_counter = 0;
}

static
void clear_args(struct gengetopt_args_info *args_info)
{
	FIX_UNUSED(args_info);
	args_info->debug_flag = 0;
	args_info->conf_arg = NULL;
	args_info->conf_orig = NULL;
	args_info->pidfile_arg = gengetopt_strdup("./sgsnemu.pid");
	args_info->pidfile_orig = NULL;
	args_info->statedir_arg = gengetopt_strdup("./");
	args_info->statedir_orig = NULL;
	args_info->dns_arg = NULL;
	args_info->dns_orig = NULL;
	args_info->listen_arg = NULL;
	args_info->listen_orig = NULL;
	args_info->remote_arg = NULL;
	args_info->remote_orig = NULL;
	args_info->contexts_arg = 1;
	args_info->contexts_orig = NULL;
	args_info->timelimit_arg = 0;
	args_info->timelimit_orig = NULL;
	args_info->gtpversion_arg = 1;
	args_info->gtpversion_orig = NULL;
	args_info->apn_arg = gengetopt_strdup("internet");
	args_info->apn_orig = NULL;
	args_info->selmode_arg = 0x01;
	args_info->selmode_orig = NULL;
	args_info->rattype_arg = 1;
	args_info->rattype_orig = NULL;
	args_info->userloc_arg = gengetopt_strdup("02509946241207");
	args_info->userloc_orig = NULL;
	args_info->rai_arg = gengetopt_strdup("02509946241207");
	args_info->rai_orig = NULL;
	args_info->mstz_arg = gengetopt_strdup("0");
	args_info->mstz_orig = NULL;
	args_info->imeisv_arg = gengetopt_strdup("2143658709214365");
	args_info->imeisv_orig = NULL;
	args_info->norecovery_flag = 0;
	args_info->imsi_arg = gengetopt_strdup("240010123456789");
	args_info->imsi_orig = NULL;
	args_info->nsapi_arg = 0;
	args_info->nsapi_orig = NULL;
	args_info->msisdn_arg = gengetopt_strdup("46702123456");
	args_info->msisdn_orig = NULL;
	args_info->qos_arg = 0x000b921f;
	args_info->qos_orig = NULL;
	args_info->qose1_arg = 0x9396404074f9ffff;
	args_info->qose1_orig = NULL;
	args_info->qose2_arg = 0x11;
	args_info->qose2_orig = NULL;
	args_info->qose3_arg = 0x0101;
	args_info->qose3_orig = NULL;
	args_info->qose4_arg = 0x4040;
	args_info->qose4_orig = NULL;
	args_info->charging_arg = 0x0800;
	args_info->charging_orig = NULL;
	args_info->uid_arg = gengetopt_strdup("mig");
	args_info->uid_orig = NULL;
	args_info->pwd_arg = gengetopt_strdup("hemmelig");
	args_info->pwd_orig = NULL;
	args_info->createif_flag = 0;
	args_info->net_arg = NULL;
	args_info->net_orig = NULL;
	args_info->defaultroute_flag = 0;
	args_info->ipup_arg = NULL;
	args_info->ipup_orig = NULL;
	args_info->ipdown_arg = NULL;
	args_info->ipdown_orig = NULL;
	args_info->tun_device_arg = NULL;
	args_info->tun_device_orig = NULL;
	args_info->pinghost_arg = NULL;
	args_info->pinghost_orig = NULL;
	args_info->pingrate_arg = 1;
	args_info->pingrate_orig = NULL;
	args_info->pingsize_arg = 56;
	args_info->pingsize_orig = NULL;
	args_info->pingcount_arg = 0;
	args_info->pingcount_orig = NULL;
	args_info->pingquiet_flag = 0;
	args_info->no_tx_gpdu_seq_flag = 0;
	args_info->pdp_type_arg = gengetopt_strdup("v4");
	args_info->pdp_type_orig = NULL;

}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

	args_info->help_help = gengetopt_args_info_help[0];
	args_info->version_help = gengetopt_args_info_help[1];
	args_info->debug_help = gengetopt_args_info_help[2];
	args_info->conf_help = gengetopt_args_info_help[3];
	args_info->pidfile_help = gengetopt_args_info_help[4];
	args_info->statedir_help = gengetopt_args_info_help[5];
	args_info->dns_help = gengetopt_args_info_help[6];
	args_info->listen_help = gengetopt_args_info_help[7];
	args_info->remote_help = gengetopt_args_info_help[8];
	args_info->contexts_help = gengetopt_args_info_help[9];
	args_info->timelimit_help = gengetopt_args_info_help[10];
	args_info->gtpversion_help = gengetopt_args_info_help[11];
	args_info->apn_help = gengetopt_args_info_help[12];
	args_info->selmode_help = gengetopt_args_info_help[13];
	args_info->rattype_help = gengetopt_args_info_help[14];
	args_info->userloc_help = gengetopt_args_info_help[15];
	args_info->rai_help = gengetopt_args_info_help[16];
	args_info->mstz_help = gengetopt_args_info_help[17];
	args_info->imeisv_help = gengetopt_args_info_help[18];
	args_info->norecovery_help = gengetopt_args_info_help[19];
	args_info->imsi_help = gengetopt_args_info_help[20];
	args_info->nsapi_help = gengetopt_args_info_help[21];
	args_info->msisdn_help = gengetopt_args_info_help[22];
	args_info->qos_help = gengetopt_args_info_help[23];
	args_info->qose1_help = gengetopt_args_info_help[24];
	args_info->qose2_help = gengetopt_args_info_help[25];
	args_info->qose3_help = gengetopt_args_info_help[26];
	args_info->qose4_help = gengetopt_args_info_help[27];
	args_info->charging_help = gengetopt_args_info_help[28];
	args_info->uid_help = gengetopt_args_info_help[29];
	args_info->pwd_help = gengetopt_args_info_help[30];
	args_info->createif_help = gengetopt_args_info_help[32];
	args_info->net_help = gengetopt_args_info_help[33];
	args_info->defaultroute_help = gengetopt_args_info_help[34];
	args_info->ipup_help = gengetopt_args_info_help[35];
	args_info->ipdown_help = gengetopt_args_info_help[36];
	args_info->tun_device_help = gengetopt_args_info_help[37];
	args_info->pinghost_help = gengetopt_args_info_help[39];
	args_info->pingrate_help = gengetopt_args_info_help[40];
	args_info->pingsize_help = gengetopt_args_info_help[41];
	args_info->pingcount_help = gengetopt_args_info_help[42];
	args_info->pingquiet_help = gengetopt_args_info_help[43];
	args_info->no_tx_gpdu_seq_help = gengetopt_args_info_help[44];
	args_info->pdp_type_help = gengetopt_args_info_help[45];

}

void cmdline_parser_print_version(void)
{
	printf("%s %s\n",
	       (strlen(CMDLINE_PARSER_PACKAGE_NAME) ?
		CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
	       CMDLINE_PARSER_VERSION);

	if (strlen(gengetopt_args_info_versiontext) > 0)
		printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	cmdline_parser_print_version();

	if (strlen(gengetopt_args_info_purpose) > 0)
		printf("\n%s\n", gengetopt_args_info_purpose);

	if (strlen(gengetopt_args_info_usage) > 0)
		printf("\n%s\n", gengetopt_args_info_usage);

	printf("\n");

	if (strlen(gengetopt_args_info_description) > 0)
		printf("%s\n\n", gengetopt_args_info_description);
}

void cmdline_parser_print_help(void)
{
	int i = 0;
	print_help_common();
	while (gengetopt_args_info_help[i])
		printf("%s\n", gengetopt_args_info_help[i++]);
}

void cmdline_parser_init(struct gengetopt_args_info *args_info)
{
	clear_given(args_info);
	clear_args(args_info);
	init_args_info(args_info);
}

void cmdline_parser_params_init(struct cmdline_parser_params *params)
{
	if (params) {
		params->override = 0;
		params->initialize = 1;
		params->check_required = 1;
		params->check_ambiguity = 0;
		params->print_errors = 1;
	}
}

struct cmdline_parser_params *cmdline_parser_params_create(void)
{
	struct cmdline_parser_params *params = (struct cmdline_parser_params *)
	    malloc(sizeof(struct cmdline_parser_params));
	cmdline_parser_params_init(params);
	return params;
}

static void free_string_field(char **s)
{
	if (*s) {
		free(*s);
		*s = 0;
	}
}

static void cmdline_parser_release(struct gengetopt_args_info *args_info)
{

	free_string_field(&(args_info->conf_arg));
	free_string_field(&(args_info->conf_orig));
	free_string_field(&(args_info->pidfile_arg));
	free_string_field(&(args_info->pidfile_orig));
	free_string_field(&(args_info->statedir_arg));
	free_string_field(&(args_info->statedir_orig));
	free_string_field(&(args_info->dns_arg));
	free_string_field(&(args_info->dns_orig));
	free_string_field(&(args_info->listen_arg));
	free_string_field(&(args_info->listen_orig));
	free_string_field(&(args_info->remote_arg));
	free_string_field(&(args_info->remote_orig));
	free_string_field(&(args_info->contexts_orig));
	free_string_field(&(args_info->timelimit_orig));
	free_string_field(&(args_info->gtpversion_orig));
	free_string_field(&(args_info->apn_arg));
	free_string_field(&(args_info->apn_orig));
	free_string_field(&(args_info->selmode_orig));
	free_string_field(&(args_info->rattype_orig));
	free_string_field(&(args_info->userloc_arg));
	free_string_field(&(args_info->userloc_orig));
	free_string_field(&(args_info->rai_arg));
	free_string_field(&(args_info->rai_orig));
	free_string_field(&(args_info->mstz_arg));
	free_string_field(&(args_info->mstz_orig));
	free_string_field(&(args_info->imeisv_arg));
	free_string_field(&(args_info->imeisv_orig));
	free_string_field(&(args_info->imsi_arg));
	free_string_field(&(args_info->imsi_orig));
	free_string_field(&(args_info->nsapi_orig));
	free_string_field(&(args_info->msisdn_arg));
	free_string_field(&(args_info->msisdn_orig));
	free_string_field(&(args_info->qos_orig));
	free_string_field(&(args_info->qose1_orig));
	free_string_field(&(args_info->qose2_orig));
	free_string_field(&(args_info->qose3_orig));
	free_string_field(&(args_info->qose4_orig));
	free_string_field(&(args_info->charging_orig));
	free_string_field(&(args_info->uid_arg));
	free_string_field(&(args_info->uid_orig));
	free_string_field(&(args_info->pwd_arg));
	free_string_field(&(args_info->pwd_orig));
	free_string_field(&(args_info->net_arg));
	free_string_field(&(args_info->net_orig));
	free_string_field(&(args_info->ipup_arg));
	free_string_field(&(args_info->ipup_orig));
	free_string_field(&(args_info->ipdown_arg));
	free_string_field(&(args_info->ipdown_orig));
	free_string_field(&(args_info->tun_device_arg));
	free_string_field(&(args_info->tun_device_orig));
	free_string_field(&(args_info->pinghost_arg));
	free_string_field(&(args_info->pinghost_orig));
	free_string_field(&(args_info->pingrate_orig));
	free_string_field(&(args_info->pingsize_orig));
	free_string_field(&(args_info->pingcount_orig));
	free_string_field(&(args_info->pdp_type_arg));
	free_string_field(&(args_info->pdp_type_orig));

	clear_given(args_info);
}

static void
write_into_file(FILE * outfile, const char *opt, const char *arg,
		const char *values[])
{
	FIX_UNUSED(values);
	if (arg) {
		fprintf(outfile, "%s=\"%s\"\n", opt, arg);
	} else {
		fprintf(outfile, "%s\n", opt);
	}
}

int cmdline_parser_dump(FILE * outfile, struct gengetopt_args_info *args_info)
{
	int i = 0;

	if (!outfile) {
		fprintf(stderr, "%s: cannot dump options to stream\n",
			CMDLINE_PARSER_PACKAGE);
		return EXIT_FAILURE;
	}

	if (args_info->help_given)
		write_into_file(outfile, "help", 0, 0);
	if (args_info->version_given)
		write_into_file(outfile, "version", 0, 0);
	if (args_info->debug_given)
		write_into_file(outfile, "debug", 0, 0);
	if (args_info->conf_given)
		write_into_file(outfile, "conf", args_info->conf_orig, 0);
	if (args_info->pidfile_given)
		write_into_file(outfile, "pidfile", args_info->pidfile_orig, 0);
	if (args_info->statedir_given)
		write_into_file(outfile, "statedir", args_info->statedir_orig,
				0);
	if (args_info->dns_given)
		write_into_file(outfile, "dns", args_info->dns_orig, 0);
	if (args_info->listen_given)
		write_into_file(outfile, "listen", args_info->listen_orig, 0);
	if (args_info->remote_given)
		write_into_file(outfile, "remote", args_info->remote_orig, 0);
	if (args_info->contexts_given)
		write_into_file(outfile, "contexts", args_info->contexts_orig,
				0);
	if (args_info->timelimit_given)
		write_into_file(outfile, "timelimit", args_info->timelimit_orig,
				0);
	if (args_info->gtpversion_given)
		write_into_file(outfile, "gtpversion",
				args_info->gtpversion_orig, 0);
	if (args_info->apn_given)
		write_into_file(outfile, "apn", args_info->apn_orig, 0);
	if (args_info->selmode_given)
		write_into_file(outfile, "selmode", args_info->selmode_orig, 0);
	if (args_info->rattype_given)
		write_into_file(outfile, "rattype", args_info->rattype_orig, 0);
	if (args_info->userloc_given)
		write_into_file(outfile, "userloc", args_info->userloc_orig, 0);
	if (args_info->rai_given)
		write_into_file(outfile, "rai", args_info->rai_orig, 0);
	if (args_info->mstz_given)
		write_into_file(outfile, "mstz", args_info->mstz_orig, 0);
	if (args_info->imeisv_given)
		write_into_file(outfile, "imeisv", args_info->imeisv_orig, 0);
	if (args_info->norecovery_given)
		write_into_file(outfile, "norecovery", 0, 0);
	if (args_info->imsi_given)
		write_into_file(outfile, "imsi", args_info->imsi_orig, 0);
	if (args_info->nsapi_given)
		write_into_file(outfile, "nsapi", args_info->nsapi_orig, 0);
	if (args_info->msisdn_given)
		write_into_file(outfile, "msisdn", args_info->msisdn_orig, 0);
	if (args_info->qos_given)
		write_into_file(outfile, "qos", args_info->qos_orig, 0);
	if (args_info->qose1_given)
		write_into_file(outfile, "qose1", args_info->qose1_orig, 0);
	if (args_info->qose2_given)
		write_into_file(outfile, "qose2", args_info->qose2_orig, 0);
	if (args_info->qose3_given)
		write_into_file(outfile, "qose3", args_info->qose3_orig, 0);
	if (args_info->qose4_given)
		write_into_file(outfile, "qose4", args_info->qose4_orig, 0);
	if (args_info->charging_given)
		write_into_file(outfile, "charging", args_info->charging_orig,
				0);
	if (args_info->uid_given)
		write_into_file(outfile, "uid", args_info->uid_orig, 0);
	if (args_info->pwd_given)
		write_into_file(outfile, "pwd", args_info->pwd_orig, 0);
	if (args_info->createif_given)
		write_into_file(outfile, "createif", 0, 0);
	if (args_info->net_given)
		write_into_file(outfile, "net", args_info->net_orig, 0);
	if (args_info->defaultroute_given)
		write_into_file(outfile, "defaultroute", 0, 0);
	if (args_info->ipup_given)
		write_into_file(outfile, "ipup", args_info->ipup_orig, 0);
	if (args_info->ipdown_given)
		write_into_file(outfile, "ipdown", args_info->ipdown_orig, 0);
	if (args_info->tun_device_given)
		write_into_file(outfile, "tun-device",
				args_info->tun_device_orig, 0);
	if (args_info->pinghost_given)
		write_into_file(outfile, "pinghost", args_info->pinghost_orig,
				0);
	if (args_info->pingrate_given)
		write_into_file(outfile, "pingrate", args_info->pingrate_orig,
				0);
	if (args_info->pingsize_given)
		write_into_file(outfile, "pingsize", args_info->pingsize_orig,
				0);
	if (args_info->pingcount_given)
		write_into_file(outfile, "pingcount", args_info->pingcount_orig,
				0);
	if (args_info->pingquiet_given)
		write_into_file(outfile, "pingquiet", 0, 0);
	if (args_info->no_tx_gpdu_seq_given)
		write_into_file(outfile, "no-tx-gpdu-seq", 0, 0);
	if (args_info->pdp_type_given)
		write_into_file(outfile, "pdp-type", args_info->pdp_type_orig,
				0);

	i = EXIT_SUCCESS;
	return i;
}

int
cmdline_parser_file_save(const char *filename,
			 struct gengetopt_args_info *args_info)
{
	FILE *outfile;
	int i = 0;

	outfile = fopen(filename, "w");

	if (!outfile) {
		fprintf(stderr, "%s: cannot open file for writing: %s\n",
			CMDLINE_PARSER_PACKAGE, filename);
		return EXIT_FAILURE;
	}

	i = cmdline_parser_dump(outfile, args_info);
	fclose(outfile);

	return i;
}

void cmdline_parser_free(struct gengetopt_args_info *args_info)
{
	cmdline_parser_release(args_info);
}

/** @brief replacement of strdup, which is not standard */
char *gengetopt_strdup(const char *s)
{
	char *result = 0;
	if (!s)
		return result;

	result = (char *)malloc(strlen(s) + 1);
	if (result == (char *)0)
		return (char *)0;
	strcpy(result, s);
	return result;
}

int cmdline_parser(int argc, char **argv, struct gengetopt_args_info *args_info)
{
	return cmdline_parser2(argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext(int argc, char **argv, struct gengetopt_args_info *args_info,
		   struct cmdline_parser_params *params)
{
	int result;
	result = cmdline_parser_internal(argc, argv, args_info, params, 0);

	if (result == EXIT_FAILURE) {
		cmdline_parser_free(args_info);
		exit(EXIT_FAILURE);
	}

	return result;
}

int
cmdline_parser2(int argc, char **argv, struct gengetopt_args_info *args_info,
		int override, int initialize, int check_required)
{
	int result;
	struct cmdline_parser_params params;

	params.override = override;
	params.initialize = initialize;
	params.check_required = check_required;
	params.check_ambiguity = 0;
	params.print_errors = 1;

	result = cmdline_parser_internal(argc, argv, args_info, &params, 0);

	if (result == EXIT_FAILURE) {
		cmdline_parser_free(args_info);
		exit(EXIT_FAILURE);
	}

	return result;
}

int
cmdline_parser_required(struct gengetopt_args_info *args_info,
			const char *prog_name)
{
	int result = EXIT_SUCCESS;

	if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
		result = EXIT_FAILURE;

	if (result == EXIT_FAILURE) {
		cmdline_parser_free(args_info);
		exit(EXIT_FAILURE);
	}

	return result;
}

int
cmdline_parser_required2(struct gengetopt_args_info *args_info,
			 const char *prog_name, const char *additional_error)
{
	int error_occurred = 0;
	FIX_UNUSED(additional_error);

	/* checks for required options */

	/* checks for dependences among options */
	if (args_info->net_given && !args_info->createif_given) {
		fprintf(stderr,
			"%s: '--net' ('-n') option depends on option 'createif'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->defaultroute_given && !args_info->createif_given) {
		fprintf(stderr,
			"%s: '--defaultroute' option depends on option 'createif'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->ipup_given && !args_info->createif_given) {
		fprintf(stderr,
			"%s: '--ipup' option depends on option 'createif'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->ipdown_given && !args_info->createif_given) {
		fprintf(stderr,
			"%s: '--ipdown' option depends on option 'createif'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->tun_device_given && !args_info->createif_given) {
		fprintf(stderr,
			"%s: '--tun-device' option depends on option 'createif'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->pingrate_given && !args_info->pinghost_given) {
		fprintf(stderr,
			"%s: '--pingrate' option depends on option 'pinghost'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->pingsize_given && !args_info->pinghost_given) {
		fprintf(stderr,
			"%s: '--pingsize' option depends on option 'pinghost'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->pingcount_given && !args_info->pinghost_given) {
		fprintf(stderr,
			"%s: '--pingcount' option depends on option 'pinghost'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}
	if (args_info->pingquiet_given && !args_info->pinghost_given) {
		fprintf(stderr,
			"%s: '--pingquiet' option depends on option 'pinghost'%s\n",
			prog_name, (additional_error ? additional_error : ""));
		error_occurred = 1;
	}

	return error_occurred;
}

static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
	       unsigned int *field_given, unsigned int *prev_given,
	       char *value, const char *possible_values[],
	       const char *default_value,
	       cmdline_parser_arg_type arg_type,
	       int check_ambiguity, int override,
	       int no_free, int multiple_option,
	       const char *long_opt, char short_opt,
	       const char *additional_error)
{
	char *stop_char = 0;
	const char *val = value;
	int found;
	char **string_field;
	FIX_UNUSED(field);

	stop_char = 0;
	found = 0;

	if (!multiple_option && prev_given
	    && (*prev_given || (check_ambiguity && *field_given))) {
		if (short_opt != '-')
			fprintf(stderr,
				"%s: `--%s' (`-%c') option given more than once%s\n",
				package_name, long_opt, short_opt,
				(additional_error ? additional_error : ""));
		else
			fprintf(stderr,
				"%s: `--%s' option given more than once%s\n",
				package_name, long_opt,
				(additional_error ? additional_error : ""));
		return 1;	/* failure */
	}

	FIX_UNUSED(default_value);

	if (field_given && *field_given && !override)
		return 0;
	if (prev_given)
		(*prev_given)++;
	if (field_given)
		(*field_given)++;
	if (possible_values)
		val = possible_values[found];

	switch (arg_type) {
	case ARG_FLAG:
		*((int *)field) = !*((int *)field);
		break;
	case ARG_INT:
		if (val)
			*((int *)field) = strtol(val, &stop_char, 0);
		break;
	case ARG_STRING:
		if (val) {
			string_field = (char **)field;
			if (!no_free && *string_field)
				free(*string_field);	/* free previous string */
			*string_field = gengetopt_strdup(val);
		}
		break;
	default:
		break;
	};

	/* check numeric conversion */
	switch (arg_type) {
	case ARG_INT:
		if (val && !(stop_char && *stop_char == '\0')) {
			fprintf(stderr, "%s: invalid numeric value: %s\n",
				package_name, val);
			return 1;	/* failure */
		}
		break;
	default:
		;
	};

	/* store the original value */
	switch (arg_type) {
	case ARG_NO:
	case ARG_FLAG:
		break;
	default:
		if (value && orig_field) {
			if (no_free) {
				*orig_field = value;
			} else {
				if (*orig_field)
					free(*orig_field);	/* free previous string */
				*orig_field = gengetopt_strdup(value);
			}
		}
	};

	return 0;		/* OK */
}

static int check_modes(int given1[], const char *options1[],
		       int given2[], const char *options2[])
{
	int i = 0, j = 0, errors = 0;

	while (given1[i] >= 0) {
		if (given1[i]) {
			while (given2[j] >= 0) {
				if (given2[j]) {
					++errors;
					fprintf(stderr,
						"%s: option %s conflicts with option %s\n",
						package_name, options1[i],
						options2[j]);
				}
				++j;
			}
		}
		++i;
	}

	return errors;
}

int
cmdline_parser_internal(int argc, char **argv,
			struct gengetopt_args_info *args_info,
			struct cmdline_parser_params *params,
			const char *additional_error)
{
	int c;			/* Character of the parsed option.  */

	int error_occurred = 0;
	struct gengetopt_args_info local_args_info;

	int override;
	int initialize;
	int check_required;
	int check_ambiguity;

	package_name = argv[0];

	override = params->override;
	initialize = params->initialize;
	check_required = params->check_required;
	check_ambiguity = params->check_ambiguity;

	if (initialize)
		cmdline_parser_init(args_info);

	cmdline_parser_init(&local_args_info);

	optarg = 0;
	optind = 0;
	opterr = params->print_errors;
	optopt = '?';

	while (1) {
		int option_index = 0;

		static struct option long_options[] = {
			{"help", 0, NULL, 'h'},
			{"version", 0, NULL, 'V'},
			{"debug", 0, NULL, 'd'},
			{"conf", 1, NULL, 'c'},
			{"pidfile", 1, NULL, 0},
			{"statedir", 1, NULL, 0},
			{"dns", 1, NULL, 0},
			{"listen", 1, NULL, 'l'},
			{"remote", 1, NULL, 'r'},
			{"contexts", 1, NULL, 0},
			{"timelimit", 1, NULL, 0},
			{"gtpversion", 1, NULL, 0},
			{"apn", 1, NULL, 'a'},
			{"selmode", 1, NULL, 0},
			{"rattype", 1, NULL, 0},
			{"userloc", 1, NULL, 0},
			{"rai", 1, NULL, 0},
			{"mstz", 1, NULL, 0},
			{"imeisv", 1, NULL, 0},
			{"norecovery", 0, NULL, 0},
			{"imsi", 1, NULL, 'i'},
			{"nsapi", 1, NULL, 0},
			{"msisdn", 1, NULL, 'm'},
			{"qos", 1, NULL, 'q'},
			{"qose1", 1, NULL, 0},
			{"qose2", 1, NULL, 0},
			{"qose3", 1, NULL, 0},
			{"qose4", 1, NULL, 0},
			{"charging", 1, NULL, 0},
			{"uid", 1, NULL, 'u'},
			{"pwd", 1, NULL, 'p'},
			{"createif", 0, NULL, 0},
			{"net", 1, NULL, 'n'},
			{"defaultroute", 0, NULL, 0},
			{"ipup", 1, NULL, 0},
			{"ipdown", 1, NULL, 0},
			{"tun-device", 1, NULL, 0},
			{"pinghost", 1, NULL, 0},
			{"pingrate", 1, NULL, 0},
			{"pingsize", 1, NULL, 0},
			{"pingcount", 1, NULL, 0},
			{"pingquiet", 0, NULL, 0},
			{"no-tx-gpdu-seq", 0, NULL, 0},
			{"pdp-type", 1, NULL, 't'},
			{0, 0, 0, 0}
		};

		c = getopt_long(argc, argv, "hVdc:l:r:a:i:m:q:u:p:n:t:",
				long_options, &option_index);

		if (c == -1)
			break;	/* Exit from `while (1)' loop.  */

		switch (c) {
		case 'h':	/* Print help and exit.  */
			cmdline_parser_print_help();
			cmdline_parser_free(&local_args_info);
			exit(EXIT_SUCCESS);

		case 'V':	/* Print version and exit.  */
			cmdline_parser_print_version();
			cmdline_parser_free(&local_args_info);
			exit(EXIT_SUCCESS);

		case 'd':	/* Run in debug mode.  */

			if (update_arg
			    ((void *)&(args_info->debug_flag), 0,
			     &(args_info->debug_given),
			     &(local_args_info.debug_given), optarg, 0, 0,
			     ARG_FLAG, check_ambiguity, override, 1, 0, "debug",
			     'd', additional_error))
				goto failure;

			break;
		case 'c':	/* Read configuration file.  */

			if (update_arg((void *)&(args_info->conf_arg),
				       &(args_info->conf_orig),
				       &(args_info->conf_given),
				       &(local_args_info.conf_given), optarg, 0,
				       0, ARG_STRING, check_ambiguity, override,
				       0, 0, "conf", 'c', additional_error))
				goto failure;

			break;
		case 'l':	/* Local host.  */

			if (update_arg((void *)&(args_info->listen_arg),
				       &(args_info->listen_orig),
				       &(args_info->listen_given),
				       &(local_args_info.listen_given), optarg,
				       0, 0, ARG_STRING, check_ambiguity,
				       override, 0, 0, "listen", 'l',
				       additional_error))
				goto failure;

			break;
		case 'r':	/* Remote host.  */

			if (update_arg((void *)&(args_info->remote_arg),
				       &(args_info->remote_orig),
				       &(args_info->remote_given),
				       &(local_args_info.remote_given), optarg,
				       0, 0, ARG_STRING, check_ambiguity,
				       override, 0, 0, "remote", 'r',
				       additional_error))
				goto failure;

			break;
		case 'a':	/* Access point name.  */

			if (update_arg((void *)&(args_info->apn_arg),
				       &(args_info->apn_orig),
				       &(args_info->apn_given),
				       &(local_args_info.apn_given), optarg, 0,
				       "internet", ARG_STRING, check_ambiguity,
				       override, 0, 0, "apn", 'a',
				       additional_error))
				goto failure;

			break;
		case 'i':	/* IMSI.  */

			if (update_arg((void *)&(args_info->imsi_arg),
				       &(args_info->imsi_orig),
				       &(args_info->imsi_given),
				       &(local_args_info.imsi_given), optarg, 0,
				       "240010123456789", ARG_STRING,
				       check_ambiguity, override, 0, 0, "imsi",
				       'i', additional_error))
				goto failure;

			break;
		case 'm':	/* Mobile Station ISDN number.  */

			if (update_arg((void *)&(args_info->msisdn_arg),
				       &(args_info->msisdn_orig),
				       &(args_info->msisdn_given),
				       &(local_args_info.msisdn_given), optarg,
				       0, "46702123456", ARG_STRING,
				       check_ambiguity, override, 0, 0,
				       "msisdn", 'm', additional_error))
				goto failure;

			break;
		case 'q':	/* Requested quality of service.  */

			if (update_arg((void *)&(args_info->qos_arg),
				       &(args_info->qos_orig),
				       &(args_info->qos_given),
				       &(local_args_info.qos_given), optarg, 0,
				       "0x000b921f", ARG_INT, check_ambiguity,
				       override, 0, 0, "qos", 'q',
				       additional_error))
				goto failure;

			break;
		case 'u':	/* Login user ID.  */

			if (update_arg((void *)&(args_info->uid_arg),
				       &(args_info->uid_orig),
				       &(args_info->uid_given),
				       &(local_args_info.uid_given), optarg, 0,
				       "mig", ARG_STRING, check_ambiguity,
				       override, 0, 0, "uid", 'u',
				       additional_error))
				goto failure;

			break;
		case 'p':	/* Login password.  */

			if (update_arg((void *)&(args_info->pwd_arg),
				       &(args_info->pwd_orig),
				       &(args_info->pwd_given),
				       &(local_args_info.pwd_given), optarg, 0,
				       "hemmelig", ARG_STRING, check_ambiguity,
				       override, 0, 0, "pwd", 'p',
				       additional_error))
				goto failure;

			break;
		case 'n':	/* Network address for local interface.  */
			args_info->createif_mode_counter += 1;

			if (update_arg((void *)&(args_info->net_arg),
				       &(args_info->net_orig),
				       &(args_info->net_given),
				       &(local_args_info.net_given), optarg, 0,
				       0, ARG_STRING, check_ambiguity, override,
				       0, 0, "net", 'n', additional_error))
				goto failure;

			break;
		case 't':	/* PDP Type.  */

			if (update_arg((void *)&(args_info->pdp_type_arg),
				       &(args_info->pdp_type_orig),
				       &(args_info->pdp_type_given),
				       &(local_args_info.pdp_type_given),
				       optarg, 0, "v4", ARG_STRING,
				       check_ambiguity, override, 0, 0,
				       "pdp-type", 't', additional_error))
				goto failure;

			break;

		case 0:	/* Long option with no short option */
			/* Filename of process id file.  */
			if (strcmp(long_options[option_index].name, "pidfile")
			    == 0) {

				if (update_arg
				    ((void *)&(args_info->pidfile_arg),
				     &(args_info->pidfile_orig),
				     &(args_info->pidfile_given),
				     &(local_args_info.pidfile_given), optarg,
				     0, "./sgsnemu.pid", ARG_STRING,
				     check_ambiguity, override, 0, 0, "pidfile",
				     '-', additional_error))
					goto failure;

			}
			/* Directory of nonvolatile data.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "statedir") == 0) {

				if (update_arg
				    ((void *)&(args_info->statedir_arg),
				     &(args_info->statedir_orig),
				     &(args_info->statedir_given),
				     &(local_args_info.statedir_given), optarg,
				     0, "./", ARG_STRING, check_ambiguity,
				     override, 0, 0, "statedir", '-',
				     additional_error))
					goto failure;

			}
			/* DNS Server to use.  */
			else if (strcmp(long_options[option_index].name, "dns")
				 == 0) {

				if (update_arg((void *)&(args_info->dns_arg),
					       &(args_info->dns_orig),
					       &(args_info->dns_given),
					       &(local_args_info.dns_given),
					       optarg, 0, 0, ARG_STRING,
					       check_ambiguity, override, 0, 0,
					       "dns", '-', additional_error))
					goto failure;

			}
			/* Number of contexts.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "contexts") == 0) {

				if (update_arg
				    ((void *)&(args_info->contexts_arg),
				     &(args_info->contexts_orig),
				     &(args_info->contexts_given),
				     &(local_args_info.contexts_given), optarg,
				     0, "1", ARG_INT, check_ambiguity, override,
				     0, 0, "contexts", '-', additional_error))
					goto failure;

			}
			/* Exit after timelimit seconds.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "timelimit") == 0) {

				if (update_arg
				    ((void *)&(args_info->timelimit_arg),
				     &(args_info->timelimit_orig),
				     &(args_info->timelimit_given),
				     &(local_args_info.timelimit_given), optarg,
				     0, "0", ARG_INT, check_ambiguity, override,
				     0, 0, "timelimit", '-', additional_error))
					goto failure;

			}
			/* GTP version to use.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "gtpversion") == 0) {

				if (update_arg
				    ((void *)&(args_info->gtpversion_arg),
				     &(args_info->gtpversion_orig),
				     &(args_info->gtpversion_given),
				     &(local_args_info.gtpversion_given),
				     optarg, 0, "1", ARG_INT, check_ambiguity,
				     override, 0, 0, "gtpversion", '-',
				     additional_error))
					goto failure;

			}
			/* Selection mode.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "selmode") == 0) {

				if (update_arg
				    ((void *)&(args_info->selmode_arg),
				     &(args_info->selmode_orig),
				     &(args_info->selmode_given),
				     &(local_args_info.selmode_given), optarg,
				     0, "0x01", ARG_INT, check_ambiguity,
				     override, 0, 0, "selmode", '-',
				     additional_error))
					goto failure;

			}
			/* Radio Access Technology Type.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "rattype") == 0) {

				if (update_arg
				    ((void *)&(args_info->rattype_arg),
				     &(args_info->rattype_orig),
				     &(args_info->rattype_given),
				     &(local_args_info.rattype_given), optarg,
				     0, "1", ARG_INT, check_ambiguity, override,
				     0, 0, "rattype", '-', additional_error))
					goto failure;

			}
			/* User Location Information.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "userloc") == 0) {

				if (update_arg
				    ((void *)&(args_info->userloc_arg),
				     &(args_info->userloc_orig),
				     &(args_info->userloc_given),
				     &(local_args_info.userloc_given), optarg,
				     0, "02509946241207", ARG_STRING,
				     check_ambiguity, override, 0, 0, "userloc",
				     '-', additional_error))
					goto failure;

			}
			/* Routing Area Information.  */
			else if (strcmp(long_options[option_index].name, "rai")
				 == 0) {

				if (update_arg((void *)&(args_info->rai_arg),
					       &(args_info->rai_orig),
					       &(args_info->rai_given),
					       &(local_args_info.rai_given),
					       optarg, 0, "02509946241207",
					       ARG_STRING, check_ambiguity,
					       override, 0, 0, "rai", '-',
					       additional_error))
					goto failure;

			}
			/* MS Time Zone.  */
			else if (strcmp(long_options[option_index].name, "mstz")
				 == 0) {

				if (update_arg((void *)&(args_info->mstz_arg),
					       &(args_info->mstz_orig),
					       &(args_info->mstz_given),
					       &(local_args_info.mstz_given),
					       optarg, 0, "0", ARG_STRING,
					       check_ambiguity, override, 0, 0,
					       "mstz", '-', additional_error))
					goto failure;

			}
			/* IMEI(SV) International Mobile Equipment Identity (and Software Version).  */
			else if (strcmp
				 (long_options[option_index].name,
				  "imeisv") == 0) {

				if (update_arg((void *)&(args_info->imeisv_arg),
					       &(args_info->imeisv_orig),
					       &(args_info->imeisv_given),
					       &(local_args_info.imeisv_given),
					       optarg, 0, "2143658709214365",
					       ARG_STRING, check_ambiguity,
					       override, 0, 0, "imeisv", '-',
					       additional_error))
					goto failure;

			}
			/* Do not send recovery.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "norecovery") == 0) {

				if (update_arg
				    ((void *)&(args_info->norecovery_flag), 0,
				     &(args_info->norecovery_given),
				     &(local_args_info.norecovery_given),
				     optarg, 0, 0, ARG_FLAG, check_ambiguity,
				     override, 1, 0, "norecovery", '-',
				     additional_error))
					goto failure;

			}
			/* NSAPI.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "nsapi") == 0) {

				if (update_arg((void *)&(args_info->nsapi_arg),
					       &(args_info->nsapi_orig),
					       &(args_info->nsapi_given),
					       &(local_args_info.nsapi_given),
					       optarg, 0, "0", ARG_INT,
					       check_ambiguity, override, 0, 0,
					       "nsapi", '-', additional_error))
					goto failure;

			}
			/* Requested quality of service Extension 1.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "qose1") == 0) {

				if (update_arg((void *)&(args_info->qose1_arg),
					       &(args_info->qose1_orig),
					       &(args_info->qose1_given),
					       &(local_args_info.qose1_given),
					       optarg, 0, "0x9396404074f9ffff",
					       ARG_INT, check_ambiguity,
					       override, 0, 0, "qose1", '-',
					       additional_error))
					goto failure;

			}
			/* Requested quality of service Extension 2.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "qose2") == 0) {

				if (update_arg((void *)&(args_info->qose2_arg),
					       &(args_info->qose2_orig),
					       &(args_info->qose2_given),
					       &(local_args_info.qose2_given),
					       optarg, 0, "0x11", ARG_INT,
					       check_ambiguity, override, 0, 0,
					       "qose2", '-', additional_error))
					goto failure;

			}
			/* Requested quality of service Extension 3.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "qose3") == 0) {

				if (update_arg((void *)&(args_info->qose3_arg),
					       &(args_info->qose3_orig),
					       &(args_info->qose3_given),
					       &(local_args_info.qose3_given),
					       optarg, 0, "0x0101", ARG_INT,
					       check_ambiguity, override, 0, 0,
					       "qose3", '-', additional_error))
					goto failure;

			}
			/* Requested quality of service Extension 4.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "qose4") == 0) {

				if (update_arg((void *)&(args_info->qose4_arg),
					       &(args_info->qose4_orig),
					       &(args_info->qose4_given),
					       &(local_args_info.qose4_given),
					       optarg, 0, "0x4040", ARG_INT,
					       check_ambiguity, override, 0, 0,
					       "qose4", '-', additional_error))
					goto failure;

			}
			/* Charging characteristics.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "charging") == 0) {

				if (update_arg
				    ((void *)&(args_info->charging_arg),
				     &(args_info->charging_orig),
				     &(args_info->charging_given),
				     &(local_args_info.charging_given), optarg,
				     0, "0x0800", ARG_INT, check_ambiguity,
				     override, 0, 0, "charging", '-',
				     additional_error))
					goto failure;

			}
			/* Create local network interface.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "createif") == 0) {
				args_info->createif_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->createif_flag), 0,
				     &(args_info->createif_given),
				     &(local_args_info.createif_given), optarg,
				     0, 0, ARG_FLAG, check_ambiguity, override,
				     1, 0, "createif", '-', additional_error))
					goto failure;

			}
			/* Create default route.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "defaultroute") == 0) {
				args_info->createif_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->defaultroute_flag), 0,
				     &(args_info->defaultroute_given),
				     &(local_args_info.defaultroute_given),
				     optarg, 0, 0, ARG_FLAG, check_ambiguity,
				     override, 1, 0, "defaultroute", '-',
				     additional_error))
					goto failure;

			}
			/* Script to run after link-up.  */
			else if (strcmp(long_options[option_index].name, "ipup")
				 == 0) {
				args_info->createif_mode_counter += 1;

				if (update_arg((void *)&(args_info->ipup_arg),
					       &(args_info->ipup_orig),
					       &(args_info->ipup_given),
					       &(local_args_info.ipup_given),
					       optarg, 0, 0, ARG_STRING,
					       check_ambiguity, override, 0, 0,
					       "ipup", '-', additional_error))
					goto failure;

			}
			/* Script to run after link-down.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "ipdown") == 0) {
				args_info->createif_mode_counter += 1;

				if (update_arg((void *)&(args_info->ipdown_arg),
					       &(args_info->ipdown_orig),
					       &(args_info->ipdown_given),
					       &(local_args_info.ipdown_given),
					       optarg, 0, 0, ARG_STRING,
					       check_ambiguity, override, 0, 0,
					       "ipdown", '-', additional_error))
					goto failure;

			}
			/* Name of the local network interface.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "tun-device") == 0) {
				args_info->createif_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->tun_device_arg),
				     &(args_info->tun_device_orig),
				     &(args_info->tun_device_given),
				     &(local_args_info.tun_device_given),
				     optarg, 0, 0, ARG_STRING, check_ambiguity,
				     override, 0, 0, "tun-device", '-',
				     additional_error))
					goto failure;

			}
			/* Ping remote host.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "pinghost") == 0) {
				args_info->pinghost_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->pinghost_arg),
				     &(args_info->pinghost_orig),
				     &(args_info->pinghost_given),
				     &(local_args_info.pinghost_given), optarg,
				     0, 0, ARG_STRING, check_ambiguity,
				     override, 0, 0, "pinghost", '-',
				     additional_error))
					goto failure;

			}
			/* Number of ping req per second.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "pingrate") == 0) {
				args_info->pinghost_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->pingrate_arg),
				     &(args_info->pingrate_orig),
				     &(args_info->pingrate_given),
				     &(local_args_info.pingrate_given), optarg,
				     0, "1", ARG_INT, check_ambiguity, override,
				     0, 0, "pingrate", '-', additional_error))
					goto failure;

			}
			/* Number of ping data bytes.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "pingsize") == 0) {
				args_info->pinghost_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->pingsize_arg),
				     &(args_info->pingsize_orig),
				     &(args_info->pingsize_given),
				     &(local_args_info.pingsize_given), optarg,
				     0, "56", ARG_INT, check_ambiguity,
				     override, 0, 0, "pingsize", '-',
				     additional_error))
					goto failure;

			}
			/* Number of ping req to send.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "pingcount") == 0) {
				args_info->pinghost_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->pingcount_arg),
				     &(args_info->pingcount_orig),
				     &(args_info->pingcount_given),
				     &(local_args_info.pingcount_given), optarg,
				     0, "0", ARG_INT, check_ambiguity, override,
				     0, 0, "pingcount", '-', additional_error))
					goto failure;

			}
			/* Do not print ping packet info.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "pingquiet") == 0) {
				args_info->pinghost_mode_counter += 1;

				if (update_arg
				    ((void *)&(args_info->pingquiet_flag), 0,
				     &(args_info->pingquiet_given),
				     &(local_args_info.pingquiet_given), optarg,
				     0, 0, ARG_FLAG, check_ambiguity, override,
				     1, 0, "pingquiet", '-', additional_error))
					goto failure;

			}
			/* Don't transmit G-PDU sequence nums.  */
			else if (strcmp
				 (long_options[option_index].name,
				  "no-tx-gpdu-seq") == 0) {

				if (update_arg
				    ((void *)&(args_info->no_tx_gpdu_seq_flag),
				     0, &(args_info->no_tx_gpdu_seq_given),
				     &(local_args_info.no_tx_gpdu_seq_given),
				     optarg, 0, 0, ARG_FLAG, check_ambiguity,
				     override, 1, 0, "no-tx-gpdu-seq", '-',
				     additional_error))
					goto failure;

			}

			break;
		case '?':	/* Invalid option.  */
			/* `getopt_long' already printed an error message.  */
			goto failure;

		default:	/* bug: option not considered.  */
			fprintf(stderr, "%s: option unknown: %c%s\n",
				CMDLINE_PARSER_PACKAGE, c,
				(additional_error ? additional_error : ""));
			abort();
		}		/* switch */
	}			/* while */

	if (args_info->createif_mode_counter
	    && args_info->pinghost_mode_counter) {
		int createif_given[] =
		    { args_info->createif_given, args_info->net_given,
			args_info->defaultroute_given, args_info->ipup_given,
			args_info->ipdown_given, args_info->tun_device_given, -1
		};
		const char *createif_desc[] =
		    { "--createif", "--net", "--defaultroute", "--ipup",
			"--ipdown", "--tun-device", 0
		};
		int pinghost_given[] =
		    { args_info->pinghost_given, args_info->pingrate_given,
			args_info->pingsize_given, args_info->pingcount_given,
			args_info->pingquiet_given, -1
		};
		const char *pinghost_desc[] =
		    { "--pinghost", "--pingrate", "--pingsize", "--pingcount",
			"--pingquiet", 0
		};
		error_occurred +=
		    check_modes(createif_given, createif_desc, pinghost_given,
				pinghost_desc);
	}

	if (check_required) {
		error_occurred +=
		    cmdline_parser_required2(args_info, argv[0],
					     additional_error);
	}

	cmdline_parser_release(&local_args_info);

	if (error_occurred)
		return (EXIT_FAILURE);

	return 0;

failure:

	cmdline_parser_release(&local_args_info);
	return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int _cmdline_parser_configfile(const char *filename, int *my_argc)
{
	FILE *file;
	char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE + 1];
	char linebuf[CONFIG_FILE_LINE_SIZE];
	int line_num = 0;
	int result = 0, equal;
	char *fopt, *farg;
	char *str_index;
	size_t len, next_token;
	char delimiter;

	if ((file = fopen(filename, "r")) == 0) {
		fprintf(stderr, "%s: Error opening configuration file '%s'\n",
			CMDLINE_PARSER_PACKAGE, filename);
		return EXIT_FAILURE;
	}

	while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0) {
		++line_num;
		my_argv[0] = '\0';
		len = strlen(linebuf);
		if (len > (CONFIG_FILE_LINE_BUFFER_SIZE - 1)) {
			fprintf(stderr,
				"%s:%s:%d: Line too long in configuration file\n",
				CMDLINE_PARSER_PACKAGE, filename, line_num);
			result = EXIT_FAILURE;
			break;
		}

		/* find first non-whitespace character in the line */
		next_token = strspn(linebuf, " \t\r\n");
		str_index = linebuf + next_token;

		if (str_index[0] == '\0' || str_index[0] == '#')
			continue;	/* empty line or comment line is skipped */

		fopt = str_index;

		/* truncate fopt at the end of the first non-valid character */
		next_token = strcspn(fopt, " \t\r\n=");

		if (fopt[next_token] == '\0') {	/* the line is over */
			farg = 0;
			equal = 0;
			goto noarg;
		}

		/* remember if equal sign is present */
		equal = (fopt[next_token] == '=');
		fopt[next_token++] = '\0';

		/* advance pointers to the next token after the end of fopt */
		next_token += strspn(fopt + next_token, " \t\r\n");

		/* check for the presence of equal sign, and if so, skip it */
		if (!equal)
			if ((equal = (fopt[next_token] == '='))) {
				next_token++;
				next_token +=
				    strspn(fopt + next_token, " \t\r\n");
			}
		str_index += next_token;

		/* find argument */
		farg = str_index;
		if (farg[0] == '\"' || farg[0] == '\'') {	/* quoted argument */
			str_index = strchr(++farg, str_index[0]);	/* skip opening quote */
			if (!str_index) {
				fprintf
				    (stderr,
				     "%s:%s:%d: unterminated string in configuration file\n",
				     CMDLINE_PARSER_PACKAGE, filename,
				     line_num);
				result = EXIT_FAILURE;
				break;
			}
		} else {	/* read up the remaining part up to a delimiter */
			next_token = strcspn(farg, " \t\r\n#\'\"");
			str_index += next_token;
		}

		/* truncate farg at the delimiter and store it for further check */
		delimiter = *str_index, *str_index++ = '\0';

		/* everything but comment is illegal at the end of line */
		if (delimiter != '\0' && delimiter != '#') {
			str_index += strspn(str_index, " \t\r\n");
			if (*str_index != '\0' && *str_index != '#') {
				fprintf
				    (stderr,
				     "%s:%s:%d: malformed string in configuration file\n",
				     CMDLINE_PARSER_PACKAGE, filename,
				     line_num);
				result = EXIT_FAILURE;
				break;
			}
		}

noarg:
		if (!strcmp(fopt, "include")) {
			if (farg && *farg) {
				result =
				    _cmdline_parser_configfile(farg, my_argc);
			} else {
				fprintf(stderr,
					"%s:%s:%d: include requires a filename argument.\n",
					CMDLINE_PARSER_PACKAGE, filename,
					line_num);
			}
			continue;
		}
		len = strlen(fopt);
		strcat(my_argv, len > 1 ? "--" : "-");
		strcat(my_argv, fopt);
		if (len > 1 && ((farg && *farg) || equal))
			strcat(my_argv, "=");
		if (farg && *farg)
			strcat(my_argv, farg);
		++(*my_argc);

		cmd_line_list_tmp =
		    (struct line_list *)malloc(sizeof(struct line_list));
		cmd_line_list_tmp->next = cmd_line_list;
		cmd_line_list = cmd_line_list_tmp;
		cmd_line_list->string_arg = gengetopt_strdup(my_argv);
	}			/* while */

	if (file)
		fclose(file);
	return result;
}

int
cmdline_parser_configfile(const char *filename,
			  struct gengetopt_args_info *args_info,
			  int override, int initialize, int check_required)
{
	struct cmdline_parser_params params;

	params.override = override;
	params.initialize = initialize;
	params.check_required = check_required;
	params.check_ambiguity = 0;
	params.print_errors = 1;

	return cmdline_parser_config_file(filename, args_info, &params);
}

int
cmdline_parser_config_file(const char *filename,
			   struct gengetopt_args_info *args_info,
			   struct cmdline_parser_params *params)
{
	int i, result;
	int my_argc = 1;
	char **my_argv_arg;
	char *additional_error;

	/* store the program name */
	cmd_line_list_tmp =
	    (struct line_list *)malloc(sizeof(struct line_list));
	cmd_line_list_tmp->next = cmd_line_list;
	cmd_line_list = cmd_line_list_tmp;
	cmd_line_list->string_arg = gengetopt_strdup(CMDLINE_PARSER_PACKAGE);

	result = _cmdline_parser_configfile(filename, &my_argc);

	if (result != EXIT_FAILURE) {
		my_argv_arg = (char **)malloc((my_argc + 1) * sizeof(char *));
		cmd_line_list_tmp = cmd_line_list;

		for (i = my_argc - 1; i >= 0; --i) {
			my_argv_arg[i] = cmd_line_list_tmp->string_arg;
			cmd_line_list_tmp = cmd_line_list_tmp->next;
		}

		my_argv_arg[my_argc] = 0;

		additional_error =
		    (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) +
				   1);
		strcpy(additional_error, ADDITIONAL_ERROR);
		strcat(additional_error, filename);
		result =
		    cmdline_parser_internal(my_argc, my_argv_arg, args_info,
					    params, additional_error);

		free(additional_error);
		free(my_argv_arg);
	}

	free_cmd_list();
	if (result == EXIT_FAILURE) {
		cmdline_parser_free(args_info);
		exit(EXIT_FAILURE);
	}

	return result;
}
