/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "../ChannelsFlags.h"

class TestChannelsFlags : public GTLTest::Case {
  public:
    TestChannelsFlags() : GTLTest::Case("ChannelsFlags")
    {
    }
    virtual void runTest()
    {
      GTLCore::ChannelsFlags flags;
      GTLTEST_CHECK_EQUAL(flags.value(), UINT64_MAX);
      for(int i = 0; i < 64; ++i)
      {
        GTLTEST_CHECK( flags.isChannelEnabled(i) );
      }
      for(int i = 0; i < 64; ++i)
      {
        flags.disableChannel(i);
        GTLTEST_CHECK( not flags.isChannelEnabled(i) );
        for(int j = i + 1; j < 64; ++j)
        {
          GTLTEST_CHECK_MESSAGE( flags.isChannelEnabled(j), j << " should be enabled" );
        }
        for(int j = 0; j < i; ++j)
        {
          GTLTEST_CHECK_MESSAGE( not flags.isChannelEnabled(j), j << " should be disabled" );
        }
      }
      for(int i = 63; i >= 0; --i)
      {
        flags.enableChannel(i);
        GTLTEST_CHECK( flags.isChannelEnabled(i) );
        for(int j = i + 1; j < 64; ++j)
        {
          GTLTEST_CHECK_MESSAGE( flags.isChannelEnabled(j), j << " should be enabled" );
        }
        for(int j = 0; j < i; ++j)
        {
          GTLTEST_CHECK_MESSAGE( not flags.isChannelEnabled(j), j << " should be disabled" );
        }
      }
      flags.setValue(011); // 1001 in binary
      GTLTEST_CHECK_EQUAL(flags.value(), 011);
      GTLTEST_CHECK(flags.isChannelEnabled(0));
      GTLTEST_CHECK(not flags.isChannelEnabled(1));
      GTLTEST_CHECK(not flags.isChannelEnabled(2));
      GTLTEST_CHECK(flags.isChannelEnabled(3));
    }
};

