/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef SENSORS_COMMON_H_
#define SENSORS_COMMON_H_

#include <Common.h>

// CacheAccess/Core: cache memory can be shared between multiple cores

// Family Model Stepping Registers CacheAccess/Core (shared / independant / none)
const static char* _GenuineIntel_CPUs[][5] = {
												// Genuine Intel(R) CPU
												{"6", "14", "8", "x86", "shared"},\
												// Intel(R) Core(TM)2 CPU
												{"6", "15", "6", "ia64", "shared"},\
												// Intel(R) Pentium(R) 4 CPU
												{"15", "2", "9", "x86", "none"},\
												// Intel(R) Xeon(TM) CPU
												{"15", "6", "4", "ia64", "independant"}
																								};
// Family Model Stepping Registers CacheAccess/Core (shared / independant / none)
const static char* _AuthenticAMD_Processors[][5] = {
														// AMD-K7(tm) Processor
														{"6", "1", "2", "x86", "none"},\
														// mobile AMD Athlon(tm) XP
														{"6", "8", "0", "x86", "none"},\
														// Dual Core AMD Opteron(tm) Processor
														{"15", "33", "2", "x86_64", "independant"},\
														// AMD Athlon(tm) 64 Processor
														{"15", "47", "2", "x86_64", "none"},\
														// AMD Athlon(tm) 64 X2 Dual Core Processor
														{"15", "75", "2", "x86_64", "independant"},\
														{"15", "67", "3", "x86_64", "independant"}
																												};

typedef struct {
	unsigned short nb_hardware_thread;
	vector<unsigned short> hardware_thread_load_averages;
	vector<unsigned long long> previous_hardware_thread_idle_cputimes;
	vector<unsigned long long> previous_hardware_thread_total_cputimes;
	bool associated_cache_memory;
	unsigned long long cache_memory_size;
	// in kHz
	unsigned long current_freq;
	unsigned short load_average;
} _processor_core;

typedef struct {
	vector<_processor_core> processor_cores;
	bool associated_cache_memory;
	// in KBytes
	unsigned long long cache_memory_size;
	unsigned short family;
	unsigned short model;
	unsigned short stepping;
	// x86, s390, ppc, x86_64, ia64, generic
	string architecture;
	string vendor;
	string name;
	unsigned short physical_address_size;
	unsigned short virtual_address_size;
	unsigned short load_average;
} _processor_topology;

string CPU_printProcessors(const vector<_processor_topology>& processors);

void CPU_setCoreToDefault(_processor_core& processor_core);

void CPU_setTopologyToDefault(_processor_topology& processor_topology);

void CPU_findProcessorArchitecture(_processor_topology& topology);

int CPU_getProcessors(const string& cpuinfo_path, vector<_processor_topology>& processors, string& errorMessage);

int CPU_getLoadAverages(vector<_processor_topology>& new_processors, const vector<_processor_topology>& old_processors, string& errorMessage);

#endif /*SENSORS_COMMON_H_*/
