/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTORDEREDCOMPONENTACCESS_H_
#define OPENDRIM_BOOTORDEREDCOMPONENTACCESS_H_

#include "Boot_Common.h"

#include "OpenDRIM_BootOrderedComponent.h"
#include "assocOpenDRIM_BootOrderedComponent.h"

int Boot_OpenDRIM_BootOrderedComponent_load(const CMPIBroker* broker, string& errorMessage);

int Boot_OpenDRIM_BootOrderedComponent_unload(string& errorMessage);

int Boot_OpenDRIM_BootOrderedComponent_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootOrderedComponent>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootOrderedComponent_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootOrderedComponent& instance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootOrderedComponent_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOrderedComponent& newInstance, const OpenDRIM_BootOrderedComponent& oldInstance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootOrderedComponent_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOrderedComponent& instance, string& errorMessage);

int Boot_OpenDRIM_BootOrderedComponent_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootOrderedComponent& instance, string& errorMessage);

int Boot_OpenDRIM_BootOrderedComponent_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootOrderedComponent_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootOrderedComponent_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_BootOrderedComponent>& OpenDRIM_BootOrderedComponent_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootOrderedComponent_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_BootOrderedComponent>& OpenDRIM_BootOrderedComponent_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootOrderedComponent_populate(OpenDRIM_BootOrderedComponent& instance, string& errorMessage);

#endif /*OPENDRIM_BOOTORDEREDCOMPONENTACCESS_H_*/
