;NSIS OCAL Installer Script
; Written by Jon Phillips
;
; NOTES: Languages are only initialized after onInit!!!
; Thus, if you do anything in onInit, than they will use the Windows 
; auto-detected language for the strings!!!! UGGGGGHHHH!!!!
;
; NOTE: $LANGUAGE is set automatically once you have picked a language...
;
; NOTE: Language Translations are generated by external perl script. 
; PLEASE SEE README.txt
;
; This is processed and 0.17 is replaced with the version of the app.
;
;--------------------------------
; CONSTANTS

; Versions of the software...this is for the registration
;!define VER_MAJOR 0
;!define VER_MINOR 35
;!define VER_REVISION 0
;!define VER_BUILD 0

;!define VER_FILE "${VER_MAJOR}${VER_MINOR}${VER_REVISION}"  ; 100
;!define VER_DISPLAY "${VER_MAJOR}.${VER_MINOR}.${VER_REVISION}" ; 1.0.0

!define VER_FILE "0.17"  ; 100
!define VER_DISPLAY "0.17" ; 1.0.0

!define APP_NAME "openclipart"
!define APP_EXE "GPStarter.exe"
;!define openclipart "Open Clip Art Library"
;!define Open Clip Art Library openclipart
!define INSTALLER_NAME "..\packages\openclipart-0.17-win32.exe"

!define REG_KEY "Content\openclipart"

!define PROJECT_URL "http://www.openclipartlibrary.org/"

!define INSTALL_DIR "$PROGRAMFILES\Open Clip Art Library"
!define SOURCE_DIR "..\packages\openclipart-0.17-full"
!define LICENSES_DIR "Licenses"
!define IMAGES_DIR "images"

!define DIRECTX_VERSION_REQUIRED 900





;--------------------------------
;Include Modern UI

    !include "MUI.nsh"

    
;--------------------------------
;General

    ;Name and file
    Name "Open Clip Art Library"
    OutFile "${INSTALLER_NAME}"
    
    ;Default installation folder
    InstallDir "${INSTALL_DIR}"
    
    ;Get installation folder from registry if available
    InstallDirRegKey HKCU ${REG_KEY} ""

    ; SetCompressor lzma
    ShowInstDetails show
    ShowUninstDetails show
    SetDateSave on
	
    ; optional - might mess up older windows
    XPStyle on
    
;--------------------------------
;Variables

    Var MUI_TEMP
    Var STARTMENU_FOLDER
	
    Var SYSTEM_CHECKED
  
;--------------------------------
;Interface Settings

    !define MUI_ICON "${IMAGES_DIR}\install.ico" ; installer icon, Default: ${nsis}\Contrib\Graphics\Icons\modern-install.ico
    !define MUI_UNICON "${IMAGES_DIR}\uninstall.ico" ; uninstaller icon, ${nsis}\Contrib\Graphics\Icons\modern-uninstall.ico
    !define MUI_HEADERIMAGE
    !define MUI_HEADERIMAGE_BITMAP "${IMAGES_DIR}\header.bmp" ; optional
    
    !define MUI_COMPONENTSPAGE_NODESC
    
    !define MUI_ABORTWARNING

;--------------------------------
;Language Selection Dialog Settings

    ;Remember the installer language
    !define MUI_LANGDLL_REGISTRY_ROOT "HKCU" 
    !define MUI_LANGDLL_REGISTRY_KEY "${REG_KEY}" 
    !define MUI_LANGDLL_REGISTRY_VALUENAME "Installer Language"

;--------------------------------
;Pages

    !insertmacro MUI_DEFAULT MUI_LANGDLL_WINDOWTITLE $(SELECT_LANG_TITLE)
    !insertmacro MUI_DEFAULT MUI_LANGDLL_INFO $(SELECT_LANG_INFO)

    
    !define MUI_WELCOMEFINISHPAGE_CUSTOMFUNCTION_INIT CheckSetup

    ; NOT DONE CURRENTLY
    ;!define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH
    ;!define MUI_UNWELCOMEFINISHPAGE_BITMAP "${IMAGES_DIR}\win_finish.bmp"
    ;!define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH    
    ;!define MUI_WELCOMEFINISHPAGE_BITMAP "${IMAGES_DIR}\win_welcome.bmp"
    !insertmacro MUI_PAGE_WELCOME


	; moved license data to below lang. as recommended

    !define MUI_LICENSEPAGE_RADIOBUTTONS

    ;!insertmacro MUI_PAGE_LICENSE ".\openclipart\Licenses\LICENSE.rtf"    
	!insertmacro MUI_PAGE_LICENSE $(LICENSE)
    
    !insertmacro MUI_PAGE_COMPONENTS
    !insertmacro MUI_PAGE_DIRECTORY
    
    ;Start Menu Folder Page Configuration
    !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU" 
    !define MUI_STARTMENUPAGE_REGISTRY_KEY "${REG_KEY}" 
    !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"
    
    !insertmacro MUI_PAGE_STARTMENU Application $STARTMENU_FOLDER
    
    
    !insertmacro MUI_PAGE_INSTFILES
    
    
    !insertmacro MUI_UNPAGE_WELCOME
    
    
    !define MUI_FINISHPAGE_RUN "$INSTDIR\${APP_EXE}"
    ; MUI_FINISHPAGE_RUN_TEXT text
    ; !define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.txt"
    ; !define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
    
    
    !define MUI_FINISHPAGE_LINK "${PROJECT_URL}"
    !define MUI_FINISHPAGE_LINK_LOCATION "${PROJECT_URL}"
    !insertmacro MUI_PAGE_FINISH
    
    
    !insertmacro MUI_UNPAGE_CONFIRM
    !insertmacro MUI_UNPAGE_INSTFILES


    
;--------------------------------
;Languages

; first language in this list is the default language

; $PARSE_LANGUAGES_START$ ; DO NOT DELETE THIS LINE!!!
    !insertmacro MUI_LANGUAGE "English" 
    !insertmacro MUI_LANGUAGE "French"
    !insertmacro MUI_LANGUAGE "German"
    !insertmacro MUI_LANGUAGE "Spanish"
    !insertmacro MUI_LANGUAGE "SimpChinese"
    !insertmacro MUI_LANGUAGE "TradChinese"
    !insertmacro MUI_LANGUAGE "Japanese"
    !insertmacro MUI_LANGUAGE "Korean"
    !insertmacro MUI_LANGUAGE "Italian"
    !insertmacro MUI_LANGUAGE "Dutch"
    !insertmacro MUI_LANGUAGE "Danish"
    !insertmacro MUI_LANGUAGE "Swedish"
    !insertmacro MUI_LANGUAGE "Norwegian"
    !insertmacro MUI_LANGUAGE "Finnish"
    !insertmacro MUI_LANGUAGE "Greek"
    !insertmacro MUI_LANGUAGE "Russian"
    !insertmacro MUI_LANGUAGE "Portuguese"
    !insertmacro MUI_LANGUAGE "PortugueseBR"
    !insertmacro MUI_LANGUAGE "Polish"
    !insertmacro MUI_LANGUAGE "Ukrainian"
    !insertmacro MUI_LANGUAGE "Czech"
    !insertmacro MUI_LANGUAGE "Slovak"
    !insertmacro MUI_LANGUAGE "Croatian"
    !insertmacro MUI_LANGUAGE "Bulgarian"
    !insertmacro MUI_LANGUAGE "Hungarian"
    ;!insertmacro MUI_LANGUAGE "Thai"
    !insertmacro MUI_LANGUAGE "Romanian"
    !insertmacro MUI_LANGUAGE "Latvian"
    !insertmacro MUI_LANGUAGE "Macedonian"
    !insertmacro MUI_LANGUAGE "Estonian"
    !insertmacro MUI_LANGUAGE "Turkish"
    !insertmacro MUI_LANGUAGE "Lithuanian"
    !insertmacro MUI_LANGUAGE "Catalan"
    !insertmacro MUI_LANGUAGE "Slovenian"
    !insertmacro MUI_LANGUAGE "Serbian"
    !insertmacro MUI_LANGUAGE "SerbianLatin"
    !insertmacro MUI_LANGUAGE "Arabic"
    !insertmacro MUI_LANGUAGE "Farsi"
    !insertmacro MUI_LANGUAGE "Hebrew"
    !insertmacro MUI_LANGUAGE "Indonesian"
    !insertmacro MUI_LANGUAGE "Mongolian"
    ;!insertmacro MUI_LANGUAGE "Luxembourgish"
    !insertmacro MUI_LANGUAGE "Albanian"
    !insertmacro MUI_LANGUAGE "Breton"
    !insertmacro MUI_LANGUAGE "Belarusian"
    !insertmacro MUI_LANGUAGE "Icelandic"
; $PARSE_LANGUAGES_END$ ; DO NOT DELETE THIS LINE!!!


;--------------------------------
;Reserve Files
  
    ;These files should be inserted before other files in the data block
    ;Keep these lines before any File command
    ;Only for solid compression (by default, solid compression is enabled for BZIP2 and LZMA)
    
    !insertmacro MUI_RESERVEFILE_LANGDLL



;--------------------------------
;Local Translations for custom messages, dialogs, etc
;
; This line includes the automatically built language support for strings.
; nsis is replaced by Makefile

    !include "./includes/language-includes.nsh"



	
       


;--------------------------------
;Installer Sections

Section "Open Clip Art Library (required)" SecClient

    SectionIn RO    ; required
    
    SetOutPath "$INSTDIR"   ; where things will be primarily saved to
    
    ;Files
    File /r "${SOURCE_DIR}\*"
    File /r "${LICENSES_DIR}"
    
    ;Store installation folder
    WriteRegStr HKCU "${REG_KEY}" "" $INSTDIR

    ; for the registry to store version info
    ;WriteRegDword HKLM "${REG_KEY}" "VersionMajor" "${VER_MAJOR}"
    ;WriteRegDword HKLM "${REG_KEY}" "VersionMinor" "${VER_MINOR}"
    ;WriteRegDword HKLM "${REG_KEY}" "VersionRevision" "${VER_REVISION}"
    ;WriteRegDword HKLM "${REG_KEY}" "VersionBuild" "${VER_BUILD}"
    
    ; for the add/remove windows components
    WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "UninstallString" '"$INSTDIR\Uninstall Open Clip Art Library.exe"'
    WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "InstallLocation" "$INSTDIR"
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "DisplayName" "Open Clip Art Library"
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "DisplayIcon" "$INSTDIR\${APP_EXE},0"
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "DisplayVersion" "${VER_DISPLAY}"
    ;WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "VersionMajor" "${VER_MAJOR}"
    ;WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "VersionMinor" "${VER_MINOR}.${VER_REVISION}"
    WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "URLInfoAbout" "${PROJECT_URL}"
    WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "NoModify" "1"
    WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart" "NoRepair" "1"    
    
    
    ;Create uninstaller
    WriteUninstaller "$INSTDIR\Uninstall Open Clip Art Library.exe"
    
    !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
    
    ;Create shortcuts
    CreateDirectory "$SMPROGRAMS\$STARTMENU_FOLDER"
    CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\Open Clip Art Library.lnk" "$INSTDIR\${APP_EXE}" ""
    CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\Uninstall Open Clip Art Library.lnk" "$INSTDIR\Uninstall FULL_NAME.exe"
    
    !insertmacro MUI_STARTMENU_WRITE_END

SectionEnd


; Optional section (can be disabled by the user)
Section "Desktop Shortcut" SecDesktop

    CreateShortCut "$DESKTOP\Open Clip Art Library.lnk" "$INSTDIR\${APP_EXE}" ""
  
SectionEnd


; Optional section (can be disabled by the user)
Section "Quick Launch Shortcut" SecQuick

    CreateShortCut "$QUICKLAUNCH\Open Clip Art Library.lnk" "$INSTDIR\${APP_EXE}" ""
  
SectionEnd



;--------------------------------
;Installer Functions

Function .onInit

    ; Doesn't work in time to autobuild translations
	; ExecShell "C:\Perl\bin\perl.exe" ".\bin\buildtranslations.plx"

    ; turned off lang. selector
    ; !insertmacro MUI_LANGDLL_DISPLAY

	
FunctionEnd


;--------------------------------
;Descriptions

    ;USE A LANGUAGE STRING IF YOU WANT YOUR DESCRIPTIONS TO BE LANGAUGE SPECIFIC
    
    ;Language strings
    ; LangString DESC_SecClient ${LANG_ENGLISH} "Installs the core XXXX PC Client."
    ; LangString DESC_SecDesktop ${LANG_ENGLISH} "Installs XXXX shortcuts to the desktop."
    ; LangString DESC_SecQuick ${LANG_ENGLISH} "Installs a XXXX PC Client shortcut the Quicklaunch menu."
    
    ;Assign descriptions to sections
    ; !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    ;   !insertmacro MUI_DESCRIPTION_TEXT ${SecClient} $(DESC_SecClient)
    ;   !insertmacro MUI_DESCRIPTION_TEXT ${SecDesktop} $(DESC_SecDesktop)
    ;   !insertmacro MUI_DESCRIPTION_TEXT ${SecQuick} $(DESC_SecQuick)
    ; !insertmacro MUI_FUNCTION_DESCRIPTION_END

 
;--------------------------------
;Uninstaller Section

Section "Uninstall"
  
    ; for some reason delete can't handle full names with spaces...hmmm
    Delete "$DESKTOP\Open Clip Art Library.lnk"
    Delete "$QUICKLAUNCH\Open Clip Art Library.lnk"
    
    !insertmacro MUI_STARTMENU_GETFOLDER Application $MUI_TEMP
    
    ;Delete empty start menu parent diretories
    StrCpy "$MUI_TEMP" "$SMPROGRAMS\$MUI_TEMP"
    
    startMenuDeleteLoop:
        ClearErrors
        RMDir /r $MUI_TEMP
        GetFullPathName $MUI_TEMP "$MUI_TEMP\.."
        
        IfErrors startMenuDeleteLoopDone
        
        StrCmp $MUI_TEMP $SMPROGRAMS startMenuDeleteLoopDone startMenuDeleteLoop
    startMenuDeleteLoopDone:
    
    RMDir /r "$INSTDIR" ; get rid of the installation directory yo
    
    ; Delete keys in the registry
    DeleteRegKey /ifempty HKCU ${REG_KEY} ; for the app
    ; for the add/remove windows components
    DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\openclipart"

SectionEnd

;--------------------------------
;Uninstaller Functions

Function un.onInit

    ;POPUP LANG SELECTION:  !insertmacro MUI_LANGDLL_DISPLAY

    !insertmacro MUI_UNGETLANGUAGE  
  
FunctionEnd


;--------------------------------
; GENERAL FUNCTIONS


;
; CheckRequirements
; 
; Checks the systems requirements and installs and allows the install to
; proceed in the requirements are met
;

Function CheckRequirements

    Call GetWindowsVersion
    Pop $R0
    
    ; StrCpy $R0 "NT 3.4"
    
    ; APP requires at least Windows 2000
    
    StrCmp $R0 "95" lbl_msg_error
    StrCmp $R0 "98" lbl_msg_error
    StrCmp $R0 "ME" lbl_msg_error
    
    ; This is such a hack because of the limited capability of NSIS
    StrCpy $R9 $R0 2 ; copying into their automatically define $R9
    StrCmp $R9 "NT" lbl_msg_error

  
    Call GetDXVersion
    Pop $R3
    ; APP REQUIRES Directx 904, which is 9.0C, but I think 900 will work
    IntCmp $R3 ${DIRECTX_VERSION_REQUIRED} lbl_done lbl_msg_directx_error 
    
    Return

    
    lbl_msg_error:
        ; TODO: Localize this string
        MessageBox MB_OK $(REQ_WIN2000) ; "You are using $R0. You need at least Windows 2000 for this application." ; 
        Quit
        
    lbl_msg_directx_error:
        ; TODO: Localize this string
        MessageBox MB_OK $(REQ_DIRECTX) ; "Requires DirectX 9.0c or later. Please install first."
        Quit
    
    lbl_done:
    
FunctionEnd


; GetWindowsVersion
;
; Based on Yazno's function, http://yazno.tripod.com/powerpimpit/
; Updated by Joost Verburg
;
; Returns on top of stack
;
; Windows Version (95, 98, ME, NT x.x, 2000, XP, 2003)
; or
; '' (Unknown Windows Version)
;
; Usage:
;   Call GetWindowsVersion
;   Pop $R0
;   ; at this point $R0 is "NT 4.0" or whatnot

Function GetWindowsVersion

    Push $R0
    Push $R1
    
    ClearErrors
    
    ReadRegStr $R0 HKLM \
    "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
    
    IfErrors 0 lbl_winnt
    
    ; we are not NT
    ReadRegStr $R0 HKLM \
    "SOFTWARE\Microsoft\Windows\CurrentVersion" VersionNumber
    
    StrCpy $R1 $R0 1
    StrCmp $R1 '4' 0 lbl_error
    
    StrCpy $R1 $R0 3
    
    StrCmp $R1 '4.0' lbl_win32_95
    StrCmp $R1 '4.9' lbl_win32_ME lbl_win32_98
    
    lbl_win32_95:
     StrCpy $R0 '95'
    Goto lbl_done
    
    lbl_win32_98:
     StrCpy $R0 '98'
    Goto lbl_done
    
    lbl_win32_ME:
     StrCpy $R0 'ME'
    Goto lbl_done
    
    lbl_winnt:
    
    StrCpy $R1 $R0 1
    
    StrCmp $R1 '3' lbl_winnt_x
    StrCmp $R1 '4' lbl_winnt_x
    
    StrCpy $R1 $R0 3
    
    StrCmp $R1 '5.0' lbl_winnt_2000
    StrCmp $R1 '5.1' lbl_winnt_XP
    StrCmp $R1 '5.2' lbl_winnt_2003 lbl_error
    
    lbl_winnt_x:
     StrCpy $R0 "NT $R0" 6
    Goto lbl_done
    
    lbl_winnt_2000:
     Strcpy $R0 '2000'
    Goto lbl_done
    
    lbl_winnt_XP:
     Strcpy $R0 'XP'
    Goto lbl_done
    
    lbl_winnt_2003:
     Strcpy $R0 '2003'
    Goto lbl_done
    
    lbl_error:
     Strcpy $R0 ''
    lbl_done:
    
    Pop $R1
    Exch $R0

FunctionEnd


; GetDXVersion
;
; Gets the currently installed DirectX Version
;
; USAGE:
;    Call GetDXVersion
;    Pop $R3
;    IntCmp $R3 900 lbl_done lbl_msg_directx_error 
;

Function GetDXVersion
    Push $0
    Push $1
    
    ReadRegStr $0 HKLM "Software\Microsoft\DirectX" "Version"
    IfErrors noDirectX
    
    StrCpy $1 $0 2 5    ; get the minor version
    StrCpy $0 $0 2 2    ; get the major version
    IntOp $0 $0 * 100   ; $0 = major * 100 + minor
    IntOp $0 $0 + $1
    Goto done
    
    noDirectX:
      StrCpy $0 0
    
    done:
      Pop $1
      Exch $0
FunctionEnd


;
; CheckInstance
;
; Checks to see if an instance of the installer is running and if s
;
; USAGE:
;   Call CheckInstance
;

Function CheckInstance
    System::Call 'kernel32::CreateMutexA(i 0, i 0, t "openclipartInstance") i .r1 ?e'
    Pop $R0
    StrCmp $R0 0 +3
    MessageBox MB_OK|MB_ICONEXCLAMATION $(INSTALLER_IS_RUNNING) ; "The installer is already running."; 
    Quit
FunctionEnd


Function CheckSetup
    
	; this is a hack to onlly allow this to run once
    StrCmp $SYSTEM_CHECKED 1 lbl_done
	StrCpy $SYSTEM_CHECKED 1
    
    ; So that multiple Instance cannot run
    Call CheckInstance

    ; no need to check requirements here, right now for compatibility
    ; Call CheckRequirements    

    ; For testing...
	; MessageBox MB_OK|MB_ICONEXCLAMATION "TEST: $LANGUAGE ${LANG_ENGLISH} ${LANG_KOREAN} $(INSTALLER_IS_RUNNING)";    
    
	lbl_done:
	
FunctionEnd

