// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeAnalysis_Shell_HeaderFile
#define _ShapeAnalysis_Shell_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TopTools_IndexedMapOfShape_HeaderFile
#include <TopTools_IndexedMapOfShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopoDS_Shape;
class TopoDS_Compound;


//! This class provides operators to analyze edges orientation <br>
//!          in the shell. <br>
class ShapeAnalysis_Shell  {
public:

  DEFINE_STANDARD_ALLOC

  //! Clears data about loaded shells and performed checks <br>
  Standard_EXPORT     void Clear() ;
  //! Adds shells contained in the <shape> to the list of loaded shells <br>
  Standard_EXPORT     void LoadShells(const TopoDS_Shape& shape) ;
  //! Checks if shells fulfill orientation condition, i.e. if each <br>
//!          edge is, either present once (free edge) or twice (connected <br>
//!          edge) but with different orientations (FORWARD/REVERSED) <br>
//!          Edges which do not fulfill these conditions are bad <br>
//! <br>
//!          If <alsofree> is True free edges are considered. <br>
//!          Free edges can be queried but are not bad <br>
  Standard_EXPORT     Standard_Boolean CheckOrientedShells(const TopoDS_Shape& shape,const Standard_Boolean alsofree = Standard_False,const Standard_Boolean checkinternaledges = Standard_False) ;
  //! Tells if a shape is loaded (only shells are checked) <br>
  Standard_EXPORT     Standard_Boolean IsLoaded(const TopoDS_Shape& shape) const;
  //! Returns the actual number of loaded shapes (i.e. shells) <br>
  Standard_EXPORT     Standard_Integer NbLoaded() const;
  //! Returns a loaded shape specified by its rank number. <br>
//!          Returns null shape if <num> is out of range <br>
  Standard_EXPORT     TopoDS_Shape Loaded(const Standard_Integer num) const;
  //! Tells if at least one edge is recorded as bad <br>
  Standard_EXPORT     Standard_Boolean HasBadEdges() const;
  //! Returns the list of bad edges as a Compound <br>
//!          It is empty (not null) if no edge are recorded as bad <br>
  Standard_EXPORT     TopoDS_Compound BadEdges() const;
  //! Tells if at least one edge is recorded as free (not connected) <br>
  Standard_EXPORT     Standard_Boolean HasFreeEdges() const;
  //! Returns the list of free (not connected) edges as a Compound <br>
//!          It is empty (not null) if no edge are recorded as free <br>
  Standard_EXPORT     TopoDS_Compound FreeEdges() const;
  //! Tells if at least one edge is connected (shared twice or more) <br>
  Standard_EXPORT     Standard_Boolean HasConnectedEdges() const;





protected:





private:



TopTools_IndexedMapOfShape myShells;
TopTools_IndexedMapOfShape myBad;
TopTools_IndexedMapOfShape myFree;
Standard_Boolean myConex;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
