// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Aspect_WindowDriver_HeaderFile
#define _Aspect_WindowDriver_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Aspect_WindowDriver_HeaderFile
#include <Handle_Aspect_WindowDriver.hxx>
#endif

#ifndef _Handle_Aspect_Window_HeaderFile
#include <Handle_Aspect_Window.hxx>
#endif
#ifndef _Aspect_TypeOfDrawMode_HeaderFile
#include <Aspect_TypeOfDrawMode.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_Driver_HeaderFile
#include <Aspect_Driver.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Aspect_TypeOfResize_HeaderFile
#include <Aspect_TypeOfResize.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class Aspect_Window;
class Aspect_DriverError;
class TCollection_ExtendedString;


//! defines the WINDOW oriented output driver. <br>
//!  Warning: A limited number of mono attribute and translatable BUFFERS can be defined <br>
//!          for retaining a lot of primitives for DRAGGING . <br>
//! <br>
class Aspect_WindowDriver : public Aspect_Driver {

public:

  //! Begin graphics and drawn directly to the Window or Pixmap if <br>
  Standard_EXPORT   virtual  void BeginDraw(const Standard_Boolean DoubleBuffer = Standard_True,const Standard_Integer aRetainBuffer = 0)  = 0;
  
  Standard_EXPORT   virtual  Aspect_TypeOfResize ResizeSpace()  = 0;
  
  Standard_EXPORT     Handle_Aspect_Window Window() const;
  //! Change the current drawing mode of the Driver <br>
//!  	    XW_REPLACE : the primitive is drawn with his defined color. <br>
//!	    XW_ERASE   : the primitive is erased from the window. <br>
//!	    XW_XOR     : the primitive is xored to the window. <br>
//!	    XW_XORLIGHT: the primitive is xored depending of the current <br>
//!			highlight and background colors. <br>
  Standard_EXPORT   virtual  void SetDrawMode(const Aspect_TypeOfDrawMode aMode)  = 0;
  //! Allocate the retain buffer <aRetainBuffer> , <br>
//! Defines the DWU coordinates of the pivot point for all primitives <br>
  Standard_EXPORT   virtual  Standard_Boolean OpenBuffer(const Standard_Integer aRetainBuffer,const Standard_ShortReal aPivotX = 0.0,const Standard_ShortReal aPivotY = 0.0,const Standard_Integer aWidthIndex = 0,const Standard_Integer aColorIndex = 0,const Standard_Integer aFontIndex = 0,const Aspect_TypeOfDrawMode aDrawMode = Aspect_TODM_REPLACE)  = 0;
  //! Clear & Deallocate the retain buffer <aRetainBuffer>. <br>
  Standard_EXPORT   virtual  void CloseBuffer(const Standard_Integer aRetainBuffer) const = 0;
  //! Erase & Clear ALL primitives retains in the buffer <aRetainBuffer>. <br>
  Standard_EXPORT   virtual  void ClearBuffer(const Standard_Integer aRetainBuffer) const = 0;
  //! Draw ALL primitives retains in the buffer <aRetainBuffer>. <br>
//!  Warning: Note that the aspect of a retain buffer drawing is <br>
//! mono-colored with the current buffer Attributes and <br>
//! Depending of the DoubleBuffer state flag at the BeginDraw() buffer time, <br>
//! when DB is TRUE,an XOR method is use for drawing and erasing buffers in the <br>
//! same way.In this case,some color side effect can occurs depending of the <br>
//! traversal primitive colors and the supported hardware. <br>
//! when DB is FALSE and the background drawing has been generated with <br>
//! DB at TRUE,no color side effect occurs because the DB is used for restoring <br>
//! the drawing context at EraseBuffer() time,this is more powerfull for the <br>
//! drawing quality excepted for large buffers (flicking) . <br>
  Standard_EXPORT   virtual  void DrawBuffer(const Standard_Integer aRetainBuffer) const = 0;
  //! Erase ALL primitives retains in the buffer <aRetainBuffer>. <br>
  Standard_EXPORT   virtual  void EraseBuffer(const Standard_Integer aRetainBuffer) const = 0;
  //! Erase , Translate and reDraw ALL primitives retains in the buffer <br>
  Standard_EXPORT   virtual  void MoveBuffer(const Standard_Integer aRetainBuffer,const Standard_ShortReal aPivotX = 0.0,const Standard_ShortReal aPivotY = 0.0) const = 0;
  //! Erase , Scale the buffer from the Pivot point and reDraw ALL primitives <br>
  Standard_EXPORT   virtual  void ScaleBuffer(const Standard_Integer aRetainBuffer,const Quantity_Factor aScaleX = 1.0,const Quantity_Factor aScaleY = 1.0) const = 0;
  //! Erase , Rotate the buffer from the Pivot point and reDraw ALL primitives <br>
  Standard_EXPORT   virtual  void RotateBuffer(const Standard_Integer aRetainBuffer,const Quantity_PlaneAngle anAngle = 0.0) const = 0;
  //! Returns TRUE if the retain buffer <aRetainBuffer> is enabled <br>
  Standard_EXPORT   virtual  Standard_Boolean BufferIsOpen(const Standard_Integer aRetainBuffer) const = 0;
  //! Returns TRUE if the retain buffer has not been opened or empty. <br>
//!         Returns FALSE if a lot of primitives have been stored inside <br>
//!         because a BeginDraw(..,<aRetainBuffer>) has been done previously. <br>
  Standard_EXPORT   virtual  Standard_Boolean BufferIsEmpty(const Standard_Integer aRetainBuffer) const = 0;
  //! Returns TRUE if the retain buffer s actually displayed at screen. <br>
  Standard_EXPORT   virtual  Standard_Boolean BufferIsDrawn(const Standard_Integer aRetainBuffer) const = 0;
  //! Returns the current buffer rotate angle from the X axis. <br>
  Standard_EXPORT   virtual  void AngleOfBuffer(const Standard_Integer aRetainBuffer,Quantity_PlaneAngle& anAngle) const = 0;
  //! Returns the current buffer scale factors. <br>
  Standard_EXPORT   virtual  void ScaleOfBuffer(const Standard_Integer aRetainBuffer,Quantity_Factor& aScaleX,Quantity_Factor& aScaleY) const = 0;
  //! Returns the current buffer position. <br>
  Standard_EXPORT   virtual  void PositionOfBuffer(const Standard_Integer aRetainBuffer,Standard_ShortReal& aPivotX,Standard_ShortReal& aPivotY) const = 0;
  //! Returns the TEXT size in DWU space depending <br>
//!          of the required FontIndex if aFontIndex is >= 0 <br>
//!          or the current FontIndex if < 0 (default). <br>
  Standard_EXPORT   virtual  void TextSize(const TCollection_ExtendedString& aText,Standard_ShortReal& aWidth,Standard_ShortReal& aHeight,const Standard_Integer aFontIndex = -1) const = 0;
  //! Returns the TEXT size and offsets <br>
//!	    in DWU space depending <br>
//!          of the required FontIndex if aFontIndex is >= 0 <br>
//!          or the current FontIndex if < 0 (default). <br>
  Standard_EXPORT   virtual  void TextSize(const TCollection_ExtendedString& aText,Standard_ShortReal& aWidth,Standard_ShortReal& aHeight,Standard_ShortReal& anXoffset,Standard_ShortReal& anYoffset,const Standard_Integer aFontIndex = -1) const = 0;
  //! Returns the font string,slant,size and <br>
  Standard_EXPORT   virtual  Standard_CString FontSize(Quantity_PlaneAngle& aSlant,Standard_ShortReal& aSize,Standard_ShortReal& aBheight,const Standard_Integer aFontIndex = -1) const = 0;
  
//! Returns the min and max driver virtual color indexs. <br>
  Standard_EXPORT   virtual  void ColorBoundIndexs(Standard_Integer& aMinIndex,Standard_Integer& aMaxIndex) const = 0;
  
//! Returns the local colormap hardware index from a virtual driver color <br>
//! index or returns -1 if the index is not defined. <br>
  Standard_EXPORT   virtual  Standard_Integer LocalColorIndex(const Standard_Integer anIndex) const = 0;
  
//! Returns the min and max driver virtual font indexs. <br>
  Standard_EXPORT   virtual  void FontBoundIndexs(Standard_Integer& aMinIndex,Standard_Integer& aMaxIndex) const = 0;
  
//! Returns the associated fontmap hardware index from a virtual driver font <br>
//! index or returns -1 if the index is not defined. <br>
  Standard_EXPORT   virtual  Standard_Integer LocalFontIndex(const Standard_Integer anIndex) const = 0;
  
//! Returns the min and max driver virtual type indexs. <br>
  Standard_EXPORT   virtual  void TypeBoundIndexs(Standard_Integer& aMinIndex,Standard_Integer& aMaxIndex) const = 0;
  
//! Returns the associated typemap hardware index from a virtual driver type <br>
//! index or returns -1 if the index is not defined. <br>
  Standard_EXPORT   virtual  Standard_Integer LocalTypeIndex(const Standard_Integer anIndex) const = 0;
  
//! Returns the min and max driver virtual width indexs. <br>
  Standard_EXPORT   virtual  void WidthBoundIndexs(Standard_Integer& aMinIndex,Standard_Integer& aMaxIndex) const = 0;
  
//! Returns the associated widthmap hardware index from a virtual driver width <br>
//! index or returns -1 if the index is not defined. <br>
  Standard_EXPORT   virtual  Standard_Integer LocalWidthIndex(const Standard_Integer anIndex) const = 0;
  
//! Returns the min and max driver virtual marker indexs. <br>
  Standard_EXPORT   virtual  void MarkBoundIndexs(Standard_Integer& aMinIndex,Standard_Integer& aMaxIndex) const = 0;
  
//! Returns the local markmap hardware index from a virtual driver marker <br>
//! index or returns -1 if the index is not defined. <br>
  Standard_EXPORT   virtual  Standard_Integer LocalMarkIndex(const Standard_Integer anIndex) const = 0;




  DEFINE_STANDARD_RTTI(Aspect_WindowDriver)

protected:

  
  Standard_EXPORT   Aspect_WindowDriver(const Handle(Aspect_Window)& aWindow);

Handle_Aspect_Window MyWindow;
Aspect_TypeOfDrawMode MyDrawMode;
Standard_Integer MyRetainBuffer;


private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
