SET(OBD_SIMGEN_SOCKET "On" CACHE BOOL "Enable socket obdsim generator")

# Only build socket gen if we can find the network functions we're using
INCLUDE(CheckIncludeFiles)
INCLUDE(CheckSymbolExists)

CHECK_INCLUDE_FILES("sys/socket.h" HAVE_SYS_SOCKET_H)
CHECK_INCLUDE_FILES("netdb.h" HAVE_NETDB_H)

IF(HAVE_SYS_SOCKET_H)
	CHECK_SYMBOL_EXISTS(getaddrinfo "sys/socket.h" HAVE_GETADDRINFO_SYSSOCKET)
ENDIF(HAVE_SYS_SOCKET_H)
IF(HAVE_NETDB_H)
	CHECK_SYMBOL_EXISTS(getaddrinfo "netdb.h" HAVE_GETADDRINFO_NETDB)
ENDIF(HAVE_NETDB_H)

IF(NOT HAVE_GETADDRINFO_SYSSOCKET AND NOT HAVE_GETADDRINFO_NETDB)
	SET(OBD_SIMGEN_SOCKET "Off" CACHE BOOL "Enable socket obdsim generator" FORCE)
	MESSAGE(STATUS "Couldn't find getaddrinfo. Not building socket sim generator")
ELSE(NOT HAVE_GETADDRINFO_SYSSOCKET AND NOT HAVE_GETADDRINFO_NETDB)
	MESSAGE(STATUS "Found getaddrinfo. Building socket sim generator")
ENDIF(NOT HAVE_GETADDRINFO_SYSSOCKET AND NOT HAVE_GETADDRINFO_NETDB)


IF(OBD_SIMGEN_SOCKET)
	FILE(GLOB OBDSIMGEN_SOCKET_SRCS
		generators/socket/*.c
	)
	ADD_LIBRARY(ckobdsim_socket STATIC ${OBDSIMGEN_SOCKET_SRCS})
	SET(GENERATOR_LIBS ${GENERATOR_LIBS} ckobdsim_socket)
	ADD_DEFINITIONS(-DOBDSIMGEN_SOCKET)
ENDIF(OBD_SIMGEN_SOCKET)

