/**
 * $Source: /cvsroot/obantoo/obantoo/src/de/jost_net/OBanToo/SEPA/BankenDaten/BLZSatz.java,v $
 * $Revision: 1.6 $
 * $Date: 2014/01/13 20:30:11 $
 * $Author: jverein $
 *
 * Copyright by Heiner Jostkleigrewe
 * Diese Datei steht unter LGPL - siehe beigefgte lpgl.txt
 */
package de.jost_net.OBanToo.SEPA.BankenDaten;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;

public class BLZSatz
{

  private BufferedInputStream bi;

  /**
   * Die Bankleitzahl dient der eindeutigen Identifizierung eines
   * Zahlungsdienstleisters.
   */
  private String blz = null;

  /**
   * Merkmal, ob bankleitzahlfhrender Zahlungsdienstleister ("1") oder nicht
   * ("2")
   */
  private String zahlungsdienstleister = null;

  /**
   * Bezeichnung des Zahlungsdienstleisters
   */
  private String bezeichnung = null;

  private String plz = null;

  private String ort = null;

  private String kurzbezeichnung = null;

  /**
   * Fr den Kartenzahlungsverkehr mittels Bankkundenkarten die am
   * girocard-System teilnehmen, haben die Spitzenverbnde des Kreditgewerbes
   * eine gesonderte Institutsnummerierung festgelegt; danach erhlt der
   * kartenausgebende Zahlungsdienstleister eine fnfstellige Institutsnummer
   * fr PAN (= Primary Account Number). Einer Institutsnummer fr PAN ist immer
   * nur genau eine Bankleitzahl zugeordnet.
   */
  private String institutsnummerPAN = null;

  /**
   * Der Bank Identifier Code (BIC) besteht aus acht oder elf zusammenhngenden
   * Stellen und setzt sich aus den Komponenten BANKCODE (4 Stellen),
   * LÄNDERCODE (2 Stellen), ORTSCODE (2 Stellen) sowie ggf. einem FILIALCODE
   * (3 Stellen) zusammen.
   */
  private String bic = null;

  /**
   * Zahlungsdienstleister sind verpflichtet, zum Zahlungsverkehr
   * ausschließlich prfziffergesicherte Kontonummern gemߟ ihrer in der
   * Bankleitzahlendatei angegebenen Prfzifferberechnungsmethode zu verwenden.
   * Die Angabe der Prfzifferberechnungsmethode "09" (keine
   * Prfzifferberechnung) ist zulssig.
   */
  private String pruefziffernmethode = null;

  /**
   * Bei jeder Neuanlage eines Datensatzes wird automatisiert eine eindeutige
   * Nummer vergeben. Eine einmal verwendete Nummer wird nicht noch einmal
   * vergeben.
   */
  private String nummer = null;

  /**
   * Seit dem letzten Abschluss der Bankleitzahlendatei neu hinzugekommene
   * Datenstze werden mit "A" (Addition), genderte Datenstze mit "M"
   * (Modified), unvernderte Datenstze mit "U" (Unchanged) gekennzeichnet.
   * Gelschte Datenstze werden mit "D" (Deletion) gekennzeichnet und sind -
   * als Hinweis - letztmalig in der Bankleitzahlendatei enthalten. Diese
   * Datenstze sind ab dem Gltigkeitstermin der Bankleitzahlendatei im
   * Zahlungsverkehr nicht mehr zu verwenden.
   */
  private String aenderungskennzeichen = null;

  /**
   * Zur frhzeitigen Information der Teilnehmer am Zahlungsverkehr und zur
   * Beschleunigung der Umstellung der Bankverbindung kann ein
   * Zahlungsdienstleister, der die Lschung einer Bankleitzahl mit dem Merkmal
   * "1" im Feld 2 beabsichtigt, die Lschung ankndigen. Die Ankndigung kann
   * erfolgen, sobald der Zahlungsdienstleister seine Kunden ber die genderte
   * Kontoverbindung informiert hat. Das Feld enthlt das Merkmal "0" (keine
   * Angabe) oder "1" (Bankleitzahl im Feld 1 ist zur Lschung vorgesehen).
   */
  private String hinweisloeschung = null;

  /**
   * Das Feld enthlt entweder den Wert "00000000" (Bankleitzahl ist nicht zur
   * Lschung vorgesehen bzw. der Zahlungsdienstleister hat keine
   * Nachfolge-Bankleitzahl verffentlicht) oder die Angabe einer
   * "Bankleitzahl". Eine Bankleitzahl kann angegeben sein, wenn das Feld 2 das
   * Merkmal "1" enthlt und entweder die bevorstehende Lschung der
   * Bankleitzahl angekndigt wurde (Feld 12 = "1") oder die Bankleitzahl zum
   * aktuellen Gültigkeitstermin gelscht wird (Feld 11 = "D"). Auf Grund der
   * Verffentlichung einer Nachfolge-Bankleitzahl knnen Anwender diese in
   * Zahlungsverkehrsdateien verwenden. Dazu wird in den Kontostammdaten –
   * unter Beibehaltung der Kontonummer - die zur Lschung angekndigte
   * Bankleitzahl bzw. die gelschte Bankleitzahl im Feld 1 der
   * Bankleitzahlendatei durch die Nachfolge-Bankleitzahl dauerhaft ersetzt.
   * Zahlungsdienstleister sind nicht berechtigt, in Zahlungsverkehrsdateien
   * Bankleitzahlen durch Nachfolge-Bankleitzahlen zu ersetzen.
   */
  private String nachfolgeblz = null;

  private String ibanregel = null;

  private String zeile;

  private int pos = 0;

  public BLZSatz(BufferedReader br) throws IOException
  {
    zeile = br.readLine();
    if (zeile == null)
    {
      return;
    }
    blz = getString(8);
    zahlungsdienstleister = getString(1);
    bezeichnung = getString(58).trim();
    plz = getString(5);
    ort = getString(35);
    kurzbezeichnung = getString(27);
    institutsnummerPAN = getString(5);
    bic = getString(11);
    pruefziffernmethode = getString(2);
    nummer = getString(6);
    aenderungskennzeichen = getString(1);
    hinweisloeschung = getString(1);
    nachfolgeblz = getString(8);
    ibanregel = getString(6);
  }

  private String getString(int len)
  {
    String ret = zeile.substring(pos, pos + len);
    pos += len;
    return ret;
  }

  public String getBlz()
  {
    return blz;
  }

  public String getZahlungsdienstleister()
  {
    return zahlungsdienstleister;
  }

  public String getBezeichnung()
  {
    return bezeichnung;
  }

  public String getPlz()
  {
    return plz;
  }

  public String getOrt()
  {
    return ort;
  }

  public String getKurzbezeichnung()
  {
    return kurzbezeichnung;
  }

  public String getInstitutsnummerPAN()
  {
    return institutsnummerPAN;
  }

  public String getBic()
  {
    return bic;
  }

  public String getPruefziffernmethode()
  {
    return pruefziffernmethode;
  }

  public String getNummer()
  {
    return nummer;
  }

  public String getAenderungskennzeichen()
  {
    return aenderungskennzeichen;
  }

  public String getHinweisloeschung()
  {
    return hinweisloeschung;
  }

  public String getNachfolgeblz()
  {
    return nachfolgeblz;
  }

  public String getIBANRegel()
  {
    return ibanregel;
  }

  public boolean hasNext() throws IOException
  {
    return bi.available() > 0;
  }

  @Override
  public String toString()
  {
    return blz + ", " + bic + ", " + bezeichnung + ", Änderungskennzeichen="
        + aenderungskennzeichen + ", Hinweis Lschung=" + hinweisloeschung
        + ", Zahlungsdienstleister=" + zahlungsdienstleister;
  }
}
