/* SettingsDialog.c generated by valac 0.38.4, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;
typedef struct _moserialSettingsDialogPrivate moserialSettingsDialogPrivate;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
enum  {
	MOSERIAL_SETTINGS_DIALOG_0_PROPERTY,
	MOSERIAL_SETTINGS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* moserial_settings_dialog_properties[MOSERIAL_SETTINGS_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())
enum  {
	MOSERIAL_SETTINGS_DIALOG_UPDATE_SETTINGS_SIGNAL,
	MOSERIAL_SETTINGS_DIALOG_NUM_SIGNALS
};
static guint moserial_settings_dialog_signals[MOSERIAL_SETTINGS_DIALOG_NUM_SIGNALS] = {0};

struct _moserialSettingsDialog {
	GObject parent_instance;
	moserialSettingsDialogPrivate * priv;
};

struct _moserialSettingsDialogClass {
	GObjectClass parent_class;
};

struct _moserialSettingsDialogPrivate {
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBox* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
	GtkListStore* deviceModel;
};

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_settings_dialog_parent_class = NULL;
extern gchar* settings_DEFAULT_DEVICEFILE;

GType moserial_settings_dialog_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogPrivate))
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings);
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self);
const gchar* settings_get_device (Settings* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_parity_get_type (void) G_GNUC_CONST;
SettingsParity settings_get_parity (Settings* self);
GType settings_access_mode_get_type (void) G_GNUC_CONST;
SettingsAccessMode settings_get_accessMode (Settings* self);
GType settings_handshake_get_type (void) G_GNUC_CONST;
SettingsHandshake settings_get_handshake (Settings* self);
gboolean settings_get_localEcho (Settings* self);
gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self);
void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w);
void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w);
Settings* settings_new (const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
Settings* settings_construct (GType object_type, const gchar* device, gint baudRate, gint dataBits, gint stopBits, SettingsParity parity, SettingsHandshake handshake, SettingsAccessMode accessMode, gboolean localEcho);
moserialSettingsDialog* moserial_settings_dialog_new (void);
moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type);
static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void mo_utils_populateComboBox (GtkComboBox* Combo, gchar** val_array, int val_array_length1);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void moserial_settings_dialog_finalize (GObject * obj);

extern const gchar* SETTINGS_BaudRateItems[16];
extern const gchar* SETTINGS_DataBitItems[4];
extern const gchar* SETTINGS_StopBitItems[2];
extern const gchar* SETTINGS_ParityModeStrings[5];
extern const gchar* SETTINGS_AccessModeStrings[3];

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static inline void _g_list_free__g_free0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}


static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self) {
	GList* deviceTypes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeIter iter = {0};
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	deviceTypes = NULL;
	_tmp0_ = g_strdup ("/dev/ttyS");
	deviceTypes = g_list_append (deviceTypes, _tmp0_);
	_tmp1_ = g_strdup ("/dev/ttyUSB");
	deviceTypes = g_list_append (deviceTypes, _tmp1_);
	_tmp2_ = g_strdup ("/dev/ttyACM");
	deviceTypes = g_list_append (deviceTypes, _tmp2_);
	_tmp3_ = g_strdup ("/dev/rfcomm");
	deviceTypes = g_list_append (deviceTypes, _tmp3_);
	_tmp4_ = g_strdup ("/dev/cuaU");
	deviceTypes = g_list_append (deviceTypes, _tmp4_);
	_tmp5_ = g_strdup ("/dev/cua");
	deviceTypes = g_list_append (deviceTypes, _tmp5_);
	_tmp6_ = self->priv->deviceModel;
	gtk_list_store_clear (_tmp6_);
	_tmp7_ = deviceTypes;
	{
		GList* devType_collection = NULL;
		GList* devType_it = NULL;
		devType_collection = _tmp7_;
		for (devType_it = devType_collection; devType_it != NULL; devType_it = devType_it->next) {
			gchar* _tmp8_;
			gchar* devType = NULL;
			_tmp8_ = g_strdup ((const gchar*) devType_it->data);
			devType = _tmp8_;
			{
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_;
							gchar* dev = NULL;
							const gchar* _tmp12_;
							gint _tmp13_;
							gchar* _tmp14_;
							const gchar* _tmp15_;
							gboolean _tmp16_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = i;
								i = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = i;
							if (!(_tmp11_ < MOSERIAL_SETTINGS_DIALOG_max_devices)) {
								break;
							}
							_tmp12_ = devType;
							_tmp13_ = i;
							_tmp14_ = g_strdup_printf ("%s%d", _tmp12_, _tmp13_);
							dev = _tmp14_;
							_tmp15_ = dev;
							_tmp16_ = g_file_test (_tmp15_, G_FILE_TEST_EXISTS);
							if (_tmp16_) {
								GtkListStore* _tmp17_;
								GtkTreeIter _tmp18_ = {0};
								GtkListStore* _tmp19_;
								GtkTreeIter _tmp20_;
								const gchar* _tmp21_;
								_tmp17_ = self->priv->deviceModel;
								gtk_list_store_append (_tmp17_, &_tmp18_);
								iter = _tmp18_;
								_tmp19_ = self->priv->deviceModel;
								_tmp20_ = iter;
								_tmp21_ = dev;
								gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp21_, -1);
							}
							_g_free0 (dev);
						}
					}
				}
				_g_free0 (devType);
			}
		}
	}
	__g_list_free__g_free0_0 (deviceTypes);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings) {
	Settings* _tmp0_;
	Settings* _tmp1_;
	GtkDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	moserial_settings_dialog_populateDevices (self);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp1_;
	moserial_settings_dialog_loadSettings (self);
	_tmp2_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
}


void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self) {
	GtkTreeModel* t = NULL;
	GtkTreeIter ti = {0};
	gboolean success = FALSE;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GtkComboBox* _tmp18_;
	GtkTreeModel* _tmp19_;
	GtkTreeModel* _tmp20_;
	GtkTreeModel* _tmp21_;
	GtkTreeIter _tmp22_ = {0};
	gboolean _tmp23_;
	GtkComboBox* _tmp39_;
	GtkTreeModel* _tmp40_;
	GtkTreeModel* _tmp41_;
	GtkTreeModel* _tmp42_;
	GtkTreeIter _tmp43_ = {0};
	gboolean _tmp44_;
	GtkComboBox* _tmp60_;
	GtkTreeModel* _tmp61_;
	GtkTreeModel* _tmp62_;
	GtkTreeModel* _tmp63_;
	GtkTreeIter _tmp64_ = {0};
	gboolean _tmp65_;
	GtkComboBox* _tmp81_;
	Settings* _tmp82_;
	SettingsParity _tmp83_;
	SettingsParity _tmp84_;
	GtkComboBox* _tmp85_;
	Settings* _tmp86_;
	SettingsAccessMode _tmp87_;
	SettingsAccessMode _tmp88_;
	GtkCheckButton* _tmp89_;
	GtkCheckButton* _tmp90_;
	gboolean _tmp91_ = FALSE;
	Settings* _tmp92_;
	SettingsHandshake _tmp93_;
	SettingsHandshake _tmp94_;
	gboolean _tmp99_ = FALSE;
	Settings* _tmp100_;
	SettingsHandshake _tmp101_;
	SettingsHandshake _tmp102_;
	Settings* _tmp107_;
	gboolean _tmp108_;
	gboolean _tmp109_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deviceCombo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = t;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	ti = _tmp4_;
	success = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_;
		GValue str_data = {0};
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GValue _tmp9_ = {0};
		const gchar* _tmp10_;
		Settings* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GtkTreeModel* _tmp16_;
		gboolean _tmp17_;
		_tmp6_ = success;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = t;
		_tmp8_ = ti;
		gtk_tree_model_get_value (_tmp7_, &_tmp8_, 0, &_tmp9_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp9_;
		_tmp10_ = g_value_get_string (&str_data);
		_tmp11_ = self->priv->currentSettings;
		_tmp12_ = settings_get_device (_tmp11_);
		_tmp13_ = _tmp12_;
		if (g_strcmp0 (_tmp10_, _tmp13_) == 0) {
			GtkComboBox* _tmp14_;
			GtkTreeIter _tmp15_;
			_tmp14_ = self->priv->deviceCombo;
			_tmp15_ = ti;
			gtk_combo_box_set_active_iter (_tmp14_, &_tmp15_);
		}
		_tmp16_ = t;
		_tmp17_ = gtk_tree_model_iter_next (_tmp16_, &ti);
		success = _tmp17_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp18_ = self->priv->baudRateCombo;
	_tmp19_ = gtk_combo_box_get_model (_tmp18_);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (t);
	t = _tmp20_;
	_tmp21_ = t;
	_tmp23_ = gtk_tree_model_get_iter_first (_tmp21_, &_tmp22_);
	ti = _tmp22_;
	success = _tmp23_;
	while (TRUE) {
		gboolean _tmp24_;
		GValue str_data = {0};
		GtkTreeModel* _tmp25_;
		GtkTreeIter _tmp26_;
		GValue _tmp27_ = {0};
		const gchar* _tmp28_;
		Settings* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gboolean _tmp34_;
		GtkTreeModel* _tmp37_;
		gboolean _tmp38_;
		_tmp24_ = success;
		if (!_tmp24_) {
			break;
		}
		_tmp25_ = t;
		_tmp26_ = ti;
		gtk_tree_model_get_value (_tmp25_, &_tmp26_, 0, &_tmp27_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp27_;
		_tmp28_ = g_value_get_string (&str_data);
		_tmp29_ = self->priv->currentSettings;
		_tmp30_ = settings_get_baudRate (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("%i", _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strcmp0 (_tmp28_, _tmp33_) == 0;
		_g_free0 (_tmp33_);
		if (_tmp34_) {
			GtkComboBox* _tmp35_;
			GtkTreeIter _tmp36_;
			_tmp35_ = self->priv->baudRateCombo;
			_tmp36_ = ti;
			gtk_combo_box_set_active_iter (_tmp35_, &_tmp36_);
		}
		_tmp37_ = t;
		_tmp38_ = gtk_tree_model_iter_next (_tmp37_, &ti);
		success = _tmp38_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp39_ = self->priv->dataBitsCombo;
	_tmp40_ = gtk_combo_box_get_model (_tmp39_);
	_tmp41_ = _g_object_ref0 (_tmp40_);
	_g_object_unref0 (t);
	t = _tmp41_;
	_tmp42_ = t;
	_tmp44_ = gtk_tree_model_get_iter_first (_tmp42_, &_tmp43_);
	ti = _tmp43_;
	success = _tmp44_;
	while (TRUE) {
		gboolean _tmp45_;
		GValue str_data = {0};
		GtkTreeModel* _tmp46_;
		GtkTreeIter _tmp47_;
		GValue _tmp48_ = {0};
		const gchar* _tmp49_;
		Settings* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gboolean _tmp55_;
		GtkTreeModel* _tmp58_;
		gboolean _tmp59_;
		_tmp45_ = success;
		if (!_tmp45_) {
			break;
		}
		_tmp46_ = t;
		_tmp47_ = ti;
		gtk_tree_model_get_value (_tmp46_, &_tmp47_, 0, &_tmp48_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp48_;
		_tmp49_ = g_value_get_string (&str_data);
		_tmp50_ = self->priv->currentSettings;
		_tmp51_ = settings_get_dataBits (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strdup_printf ("%i", _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strcmp0 (_tmp49_, _tmp54_) == 0;
		_g_free0 (_tmp54_);
		if (_tmp55_) {
			GtkComboBox* _tmp56_;
			GtkTreeIter _tmp57_;
			_tmp56_ = self->priv->dataBitsCombo;
			_tmp57_ = ti;
			gtk_combo_box_set_active_iter (_tmp56_, &_tmp57_);
		}
		_tmp58_ = t;
		_tmp59_ = gtk_tree_model_iter_next (_tmp58_, &ti);
		success = _tmp59_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp60_ = self->priv->stopBitsCombo;
	_tmp61_ = gtk_combo_box_get_model (_tmp60_);
	_tmp62_ = _g_object_ref0 (_tmp61_);
	_g_object_unref0 (t);
	t = _tmp62_;
	_tmp63_ = t;
	_tmp65_ = gtk_tree_model_get_iter_first (_tmp63_, &_tmp64_);
	ti = _tmp64_;
	success = _tmp65_;
	while (TRUE) {
		gboolean _tmp66_;
		GValue str_data = {0};
		GtkTreeModel* _tmp67_;
		GtkTreeIter _tmp68_;
		GValue _tmp69_ = {0};
		const gchar* _tmp70_;
		Settings* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gboolean _tmp76_;
		GtkTreeModel* _tmp79_;
		gboolean _tmp80_;
		_tmp66_ = success;
		if (!_tmp66_) {
			break;
		}
		_tmp67_ = t;
		_tmp68_ = ti;
		gtk_tree_model_get_value (_tmp67_, &_tmp68_, 0, &_tmp69_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp69_;
		_tmp70_ = g_value_get_string (&str_data);
		_tmp71_ = self->priv->currentSettings;
		_tmp72_ = settings_get_stopBits (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strdup_printf ("%i", _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strcmp0 (_tmp70_, _tmp75_) == 0;
		_g_free0 (_tmp75_);
		if (_tmp76_) {
			GtkComboBox* _tmp77_;
			GtkTreeIter _tmp78_;
			_tmp77_ = self->priv->stopBitsCombo;
			_tmp78_ = ti;
			gtk_combo_box_set_active_iter (_tmp77_, &_tmp78_);
		}
		_tmp79_ = t;
		_tmp80_ = gtk_tree_model_iter_next (_tmp79_, &ti);
		success = _tmp80_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp81_ = self->priv->parityCombo;
	_tmp82_ = self->priv->currentSettings;
	_tmp83_ = settings_get_parity (_tmp82_);
	_tmp84_ = _tmp83_;
	gtk_combo_box_set_active (_tmp81_, (gint) _tmp84_);
	_tmp85_ = self->priv->accessModeCombo;
	_tmp86_ = self->priv->currentSettings;
	_tmp87_ = settings_get_accessMode (_tmp86_);
	_tmp88_ = _tmp87_;
	gtk_combo_box_set_active (_tmp85_, (gint) _tmp88_);
	_tmp89_ = self->priv->hardwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp89_, FALSE);
	_tmp90_ = self->priv->softwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp90_, FALSE);
	_tmp92_ = self->priv->currentSettings;
	_tmp93_ = settings_get_handshake (_tmp92_);
	_tmp94_ = _tmp93_;
	if (_tmp94_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp91_ = TRUE;
	} else {
		Settings* _tmp95_;
		SettingsHandshake _tmp96_;
		SettingsHandshake _tmp97_;
		_tmp95_ = self->priv->currentSettings;
		_tmp96_ = settings_get_handshake (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp91_ = _tmp97_ == SETTINGS_HANDSHAKE_HARDWARE;
	}
	if (_tmp91_) {
		GtkCheckButton* _tmp98_;
		_tmp98_ = self->priv->hardwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp98_, TRUE);
	}
	_tmp100_ = self->priv->currentSettings;
	_tmp101_ = settings_get_handshake (_tmp100_);
	_tmp102_ = _tmp101_;
	if (_tmp102_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp99_ = TRUE;
	} else {
		Settings* _tmp103_;
		SettingsHandshake _tmp104_;
		SettingsHandshake _tmp105_;
		_tmp103_ = self->priv->currentSettings;
		_tmp104_ = settings_get_handshake (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp99_ = _tmp105_ == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	if (_tmp99_) {
		GtkCheckButton* _tmp106_;
		_tmp106_ = self->priv->softwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp106_, TRUE);
	}
	_tmp107_ = self->priv->currentSettings;
	_tmp108_ = settings_get_localEcho (_tmp107_);
	_tmp109_ = _tmp108_;
	if (_tmp109_) {
		GtkCheckButton* _tmp110_;
		_tmp110_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp110_, TRUE);
	} else {
		GtkCheckButton* _tmp111_;
		_tmp111_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp111_, FALSE);
	}
	_g_object_unref0 (t);
}


gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = NULL;
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w) {
	gchar* device = NULL;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean pLocalEcho = FALSE;
	GtkTreeModel* t = NULL;
	GtkTreeIter iter = {0};
	gboolean success = FALSE;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkComboBox* _tmp14_;
	gint _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	GtkComboBox* _tmp18_;
	gint _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_;
	GtkComboBox* _tmp22_;
	gint _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_;
	GtkComboBox* _tmp26_;
	gint _tmp27_;
	GtkComboBox* _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_ = FALSE;
	GtkCheckButton* _tmp31_;
	gboolean _tmp32_;
	GtkCheckButton* _tmp39_;
	gboolean _tmp40_;
	const gchar* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	SettingsParity _tmp45_;
	SettingsHandshake _tmp46_;
	SettingsAccessMode _tmp47_;
	Settings* _tmp48_;
	Settings* _tmp49_;
	Settings* _tmp50_;
	Settings* _tmp51_;
	GtkDialog* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->deviceCombo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = self->priv->deviceCombo;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	success = _tmp5_;
	_tmp6_ = success;
	if (_tmp6_) {
		GValue str_data = {0};
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GValue _tmp9_ = {0};
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = t;
		_tmp8_ = iter;
		gtk_tree_model_get_value (_tmp7_, &_tmp8_, 0, &_tmp9_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp9_;
		_tmp10_ = g_value_get_string (&str_data);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (device);
		device = _tmp11_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	} else {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = settings_DEFAULT_DEVICEFILE;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (device);
		device = _tmp13_;
	}
	_tmp14_ = self->priv->baudRateCombo;
	_tmp15_ = gtk_combo_box_get_active (_tmp14_);
	_tmp16_ = SETTINGS_BaudRateItems[_tmp15_];
	_tmp17_ = atoi (_tmp16_);
	baudRate = _tmp17_;
	_tmp18_ = self->priv->dataBitsCombo;
	_tmp19_ = gtk_combo_box_get_active (_tmp18_);
	_tmp20_ = SETTINGS_DataBitItems[_tmp19_];
	_tmp21_ = atoi (_tmp20_);
	dataBits = _tmp21_;
	_tmp22_ = self->priv->stopBitsCombo;
	_tmp23_ = gtk_combo_box_get_active (_tmp22_);
	_tmp24_ = SETTINGS_StopBitItems[_tmp23_];
	_tmp25_ = atoi (_tmp24_);
	stopBits = _tmp25_;
	_tmp26_ = self->priv->parityCombo;
	_tmp27_ = gtk_combo_box_get_active (_tmp26_);
	parity = (SettingsParity) _tmp27_;
	_tmp28_ = self->priv->accessModeCombo;
	_tmp29_ = gtk_combo_box_get_active (_tmp28_);
	accessMode = (SettingsAccessMode) _tmp29_;
	_tmp31_ = self->priv->hardwareHandshake;
	_tmp32_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp31_);
	if (_tmp32_) {
		GtkCheckButton* _tmp33_;
		gboolean _tmp34_;
		_tmp33_ = self->priv->softwareHandshake;
		_tmp34_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp33_);
		_tmp30_ = _tmp34_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		GtkCheckButton* _tmp35_;
		gboolean _tmp36_;
		_tmp35_ = self->priv->hardwareHandshake;
		_tmp36_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp35_);
		if (_tmp36_) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			GtkCheckButton* _tmp37_;
			gboolean _tmp38_;
			_tmp37_ = self->priv->softwareHandshake;
			_tmp38_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp37_);
			if (_tmp38_) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	_tmp39_ = self->priv->localEcho;
	_tmp40_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp39_);
	pLocalEcho = _tmp40_;
	_tmp41_ = device;
	_tmp42_ = baudRate;
	_tmp43_ = dataBits;
	_tmp44_ = stopBits;
	_tmp45_ = parity;
	_tmp46_ = handshake;
	_tmp47_ = accessMode;
	_tmp48_ = settings_new (_tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_, pLocalEcho);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp48_;
	_tmp49_ = self->priv->settings;
	_tmp50_ = _g_object_ref0 (_tmp49_);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp50_;
	_tmp51_ = self->priv->currentSettings;
	g_signal_emit (self, moserial_settings_dialog_signals[MOSERIAL_SETTINGS_DIALOG_UPDATE_SETTINGS_SIGNAL], 0, _tmp51_);
	_tmp52_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp52_);
	_g_object_unref0 (t);
	_g_free0 (device);
}


moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type) {
	moserialSettingsDialog * self = NULL;
	self = (moserialSettingsDialog*) g_object_new (object_type, NULL);
	return self;
}


moserialSettingsDialog* moserial_settings_dialog_new (void) {
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG);
}


static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = moserial_settings_dialog_hide ((moserialSettingsDialog*) self);
	return result;
}


static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_cancel ((moserialSettingsDialog*) self, _sender);
}


static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_ok ((moserialSettingsDialog*) self, _sender);
}


static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSettingsDialog * self;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkDialog* _tmp3_;
	GtkBuilder* _tmp4_;
	GObject* _tmp5_;
	GtkButton* _tmp6_;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_;
	GtkButton* _tmp9_;
	GtkBuilder* _tmp10_;
	GObject* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkBuilder* _tmp14_;
	GObject* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkComboBox* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkComboBox* _tmp21_;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_;
	GtkComboBox* _tmp24_;
	GtkComboBox* _tmp25_;
	GtkBuilder* _tmp26_;
	GObject* _tmp27_;
	GtkCheckButton* _tmp28_;
	GtkCheckButton* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	GtkCheckButton* _tmp32_;
	GtkCheckButton* _tmp33_;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_;
	GtkComboBox* _tmp36_;
	GtkComboBox* _tmp37_;
	GtkBuilder* _tmp38_;
	GObject* _tmp39_;
	GtkCheckButton* _tmp40_;
	GtkCheckButton* _tmp41_;
	GtkDialog* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_;
	GtkComboBox* _tmp47_;
	GtkListStore* _tmp48_;
	GtkComboBox* _tmp49_;
	GtkListStore* _tmp50_;
	GtkCellRenderer* deviceCell = NULL;
	GtkCellRendererText* _tmp51_;
	GtkComboBox* _tmp52_;
	GtkCellRenderer* _tmp53_;
	GtkComboBox* _tmp54_;
	GtkCellRenderer* _tmp55_;
	parent_class = G_OBJECT_CLASS (moserial_settings_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog);
	_tmp0_ = gtk_builder_new_from_resource (UIROOT "settings_dialog.ui");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "settings_dialog");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp3_;
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "settings_cancel_button");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->cancelButton);
	self->priv->cancelButton = _tmp6_;
	_tmp7_ = builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "settings_ok_button");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->okButton);
	self->priv->okButton = _tmp9_;
	_tmp10_ = builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "settings_baud_rate");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->baudRateCombo);
	self->priv->baudRateCombo = _tmp12_;
	_tmp13_ = self->priv->baudRateCombo;
	mo_utils_populateComboBox (_tmp13_, SETTINGS_BaudRateItems, G_N_ELEMENTS (SETTINGS_BaudRateItems));
	_tmp14_ = builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "settings_data_bits");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->dataBitsCombo);
	self->priv->dataBitsCombo = _tmp16_;
	_tmp17_ = self->priv->dataBitsCombo;
	mo_utils_populateComboBox (_tmp17_, SETTINGS_DataBitItems, G_N_ELEMENTS (SETTINGS_DataBitItems));
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "settings_stop_bits");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->stopBitsCombo);
	self->priv->stopBitsCombo = _tmp20_;
	_tmp21_ = self->priv->stopBitsCombo;
	mo_utils_populateComboBox (_tmp21_, SETTINGS_StopBitItems, G_N_ELEMENTS (SETTINGS_StopBitItems));
	_tmp22_ = builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "settings_parity");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->parityCombo);
	self->priv->parityCombo = _tmp24_;
	_tmp25_ = self->priv->parityCombo;
	mo_utils_populateComboBox (_tmp25_, SETTINGS_ParityModeStrings, G_N_ELEMENTS (SETTINGS_ParityModeStrings));
	_tmp26_ = builder;
	_tmp27_ = gtk_builder_get_object (_tmp26_, "settings_hardware_handshake");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->hardwareHandshake);
	self->priv->hardwareHandshake = _tmp28_;
	_tmp29_ = self->priv->hardwareHandshake;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp29_, _ ("Also known as RTS/CTS handshaking"));
	_tmp30_ = builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "settings_software_handshake");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->softwareHandshake);
	self->priv->softwareHandshake = _tmp32_;
	_tmp33_ = self->priv->softwareHandshake;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp33_, _ ("Also known as XON/XOFF handshaking"));
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "settings_open_for");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->accessModeCombo);
	self->priv->accessModeCombo = _tmp36_;
	_tmp37_ = self->priv->accessModeCombo;
	mo_utils_populateComboBox (_tmp37_, SETTINGS_AccessModeStrings, G_N_ELEMENTS (SETTINGS_AccessModeStrings));
	_tmp38_ = builder;
	_tmp39_ = gtk_builder_get_object (_tmp38_, "settings_local_echo");
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->localEcho);
	self->priv->localEcho = _tmp40_;
	_tmp41_ = self->priv->localEcho;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp41_, _ ("Normally disabled"));
	_tmp42_ = self->priv->dialog;
	g_signal_connect_object ((GtkWidget*) _tmp42_, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
	_tmp43_ = self->priv->cancelButton;
	g_signal_connect_object (_tmp43_, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
	_tmp44_ = self->priv->okButton;
	g_signal_connect_object (_tmp44_, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
	_tmp45_ = builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "settings_device");
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->deviceCombo);
	self->priv->deviceCombo = _tmp47_;
	_tmp48_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->deviceModel);
	self->priv->deviceModel = _tmp48_;
	_tmp49_ = self->priv->deviceCombo;
	_tmp50_ = self->priv->deviceModel;
	gtk_combo_box_set_model (_tmp49_, (GtkTreeModel*) _tmp50_);
	_tmp51_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp51_);
	deviceCell = (GtkCellRenderer*) _tmp51_;
	_tmp52_ = self->priv->deviceCombo;
	_tmp53_ = deviceCell;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp52_, _tmp53_, FALSE);
	_tmp54_ = self->priv->deviceCombo;
	_tmp55_ = deviceCell;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp54_, _tmp55_, "text", 0, NULL);
	_g_object_unref0 (deviceCell);
	_g_object_unref0 (builder);
	return obj;
}


static void moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass) {
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->constructor = moserial_settings_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	moserial_settings_dialog_signals[MOSERIAL_SETTINGS_DIALOG_UPDATE_SETTINGS_SIGNAL] = g_signal_new ("update-settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}


static void moserial_settings_dialog_instance_init (moserialSettingsDialog * self) {
	self->priv = MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE (self);
}


static void moserial_settings_dialog_finalize (GObject * obj) {
	moserialSettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog);
	_g_object_unref0 (self->priv->currentSettings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancelButton);
	_g_object_unref0 (self->priv->okButton);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->deviceCombo);
	_g_object_unref0 (self->priv->baudRateCombo);
	_g_object_unref0 (self->priv->dataBitsCombo);
	_g_object_unref0 (self->priv->stopBitsCombo);
	_g_object_unref0 (self->priv->parityCombo);
	_g_object_unref0 (self->priv->hardwareHandshake);
	_g_object_unref0 (self->priv->softwareHandshake);
	_g_object_unref0 (self->priv->accessModeCombo);
	_g_object_unref0 (self->priv->localEcho);
	_g_object_unref0 (self->priv->deviceModel);
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}


GType moserial_settings_dialog_get_type (void) {
	static volatile gsize moserial_settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_settings_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
		GType moserial_settings_dialog_type_id;
		moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
		g_once_init_leave (&moserial_settings_dialog_type_id__volatile, moserial_settings_dialog_type_id);
	}
	return moserial_settings_dialog_type_id__volatile;
}



