/*
    This file is part of svmcore.
    Replace non ISO functions drand48() and srand48().
    
    This code is written by Davide Albanese, albanese@fbk.it.
    (C) 2008 Fondazione Bruno Kessler - Via Santa Croce 77, 38100 Trento, ITALY.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdlib.h>


double svm_drand48 (void)
{
  return ((double) rand ()) / ((double) RAND_MAX);
}

void svm_srand48 (long int seed)
{
  srand ((unsigned int) seed) ;
}
