/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ScriptHelp.h
// Geir Austad - ECMWF Sep 01

#ifndef ScriptHelp_H
#define ScriptHelp_H

#include "UIScriptHelp.h"

#ifndef RequestPanelHelp_H
#include "RequestPanelHelp.h"
#endif

#ifndef ShellTask_H
#include "ShellTask.h"
#endif

class ScriptHelp: public RequestPanelHelp, public UIScriptHelp_c, public ShellTask
{
public:

// -- Contructors
  ScriptHelp(Widget, RequestPanel&, const Parameter&);

// -- Destructor
  virtual ~ScriptHelp(); 

  virtual bool dialog() { return true; }  

private:

// No copy allowed
  
  ScriptHelp(const ScriptHelp&);
  ScriptHelp& operator=(const ScriptHelp&);
  
  // -- Members
  bool gotInput_;
  
  // -- Overridden methods
  virtual void closeCB(Widget,XtPointer);

  virtual void start();
  virtual void ready(const char *);
  virtual void done(FILE*);

  
};

#endif
