/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File EditorToolFactory.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef EditorToolFactory_H
#define EditorToolFactory_H

#include "inc_stl.h"
#include <string>
using std::string;

class EditorTool;
class Editor;

class EditorToolFactory {
public:

// -- Exceptions
	// None

// -- Contructors

	EditorToolFactory(const string&,int);

// -- Destructor

	virtual ~EditorToolFactory(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual EditorTool* make(Editor*,const string&) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static map<string,EditorTool*> create(Editor*);

protected:

// -- Members

	string name_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	EditorToolFactory(const EditorToolFactory&);
	EditorToolFactory& operator=(const EditorToolFactory&);

// -- Members
	

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const EditorToolFactory& p)
	//	{ p.print(s); return s; }

};

template<class T,class E>
class EditorToolMaker : public EditorToolFactory {
	EditorTool* make(Editor* e,const string& name) 
	{ 
		E* a = dynamic_cast<E*>(e,name);
		return a ? new T(*a) : 0;
	}
public:
	EditorToolMaker(const string& name,int n) : EditorToolFactory(name,n) {}
};


#endif
