/**
 */
package org.malai.widget.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.malai.widget.util.WidgetAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class WidgetItemProviderAdapterFactory extends WidgetAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WidgetItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Tree} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TreeItemProvider treeItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Tree}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTreeAdapter() {
		if (treeItemProvider == null) {
			treeItemProvider = new TreeItemProvider(this);
		}

		return treeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Slider} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SliderItemProvider sliderItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Slider}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSliderAdapter() {
		if (sliderItemProvider == null) {
			sliderItemProvider = new SliderItemProvider(this);
		}

		return sliderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.ProgressBar} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProgressBarItemProvider progressBarItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.ProgressBar}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProgressBarAdapter() {
		if (progressBarItemProvider == null) {
			progressBarItemProvider = new ProgressBarItemProvider(this);
		}

		return progressBarItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Table} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableItemProvider tableItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Table}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTableAdapter() {
		if (tableItemProvider == null) {
			tableItemProvider = new TableItemProvider(this);
		}

		return tableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Label} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelItemProvider labelItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Label}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelAdapter() {
		if (labelItemProvider == null) {
			labelItemProvider = new LabelItemProvider(this);
		}

		return labelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.TextArea} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextAreaItemProvider textAreaItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.TextArea}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextAreaAdapter() {
		if (textAreaItemProvider == null) {
			textAreaItemProvider = new TextAreaItemProvider(this);
		}

		return textAreaItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.TextField} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextFieldItemProvider textFieldItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.TextField}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextFieldAdapter() {
		if (textFieldItemProvider == null) {
			textFieldItemProvider = new TextFieldItemProvider(this);
		}

		return textFieldItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Spinner} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SpinnerItemProvider spinnerItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Spinner}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSpinnerAdapter() {
		if (spinnerItemProvider == null) {
			spinnerItemProvider = new SpinnerItemProvider(this);
		}

		return spinnerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.MultiLineList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiLineListItemProvider multiLineListItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.MultiLineList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiLineListAdapter() {
		if (multiLineListItemProvider == null) {
			multiLineListItemProvider = new MultiLineListItemProvider(this);
		}

		return multiLineListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.SingleLineList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleLineListItemProvider singleLineListItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.SingleLineList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleLineListAdapter() {
		if (singleLineListItemProvider == null) {
			singleLineListItemProvider = new SingleLineListItemProvider(this);
		}

		return singleLineListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Panel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PanelItemProvider panelItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Panel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPanelAdapter() {
		if (panelItemProvider == null) {
			panelItemProvider = new PanelItemProvider(this);
		}

		return panelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Window} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WindowItemProvider windowItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Window}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWindowAdapter() {
		if (windowItemProvider == null) {
			windowItemProvider = new WindowItemProvider(this);
		}

		return windowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.DialogueBox} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DialogueBoxItemProvider dialogueBoxItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.DialogueBox}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDialogueBoxAdapter() {
		if (dialogueBoxItemProvider == null) {
			dialogueBoxItemProvider = new DialogueBoxItemProvider(this);
		}

		return dialogueBoxItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.SplitPane} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SplitPaneItemProvider splitPaneItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.SplitPane}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSplitPaneAdapter() {
		if (splitPaneItemProvider == null) {
			splitPaneItemProvider = new SplitPaneItemProvider(this);
		}

		return splitPaneItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.TabbedPanel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TabbedPanelItemProvider tabbedPanelItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.TabbedPanel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTabbedPanelAdapter() {
		if (tabbedPanelItemProvider == null) {
			tabbedPanelItemProvider = new TabbedPanelItemProvider(this);
		}

		return tabbedPanelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Button} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ButtonItemProvider buttonItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Button}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createButtonAdapter() {
		if (buttonItemProvider == null) {
			buttonItemProvider = new ButtonItemProvider(this);
		}

		return buttonItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.ToggleButton} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToggleButtonItemProvider toggleButtonItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.ToggleButton}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createToggleButtonAdapter() {
		if (toggleButtonItemProvider == null) {
			toggleButtonItemProvider = new ToggleButtonItemProvider(this);
		}

		return toggleButtonItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.Menu} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MenuItemProvider menuItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.Menu}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMenuAdapter() {
		if (menuItemProvider == null) {
			menuItemProvider = new MenuItemProvider(this);
		}

		return menuItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.CheckBox} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CheckBoxItemProvider checkBoxItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.CheckBox}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCheckBoxAdapter() {
		if (checkBoxItemProvider == null) {
			checkBoxItemProvider = new CheckBoxItemProvider(this);
		}

		return checkBoxItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.RadioButton} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RadioButtonItemProvider radioButtonItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.RadioButton}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRadioButtonAdapter() {
		if (radioButtonItemProvider == null) {
			radioButtonItemProvider = new RadioButtonItemProvider(this);
		}

		return radioButtonItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.ToggleMenu} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ToggleMenuItemProvider toggleMenuItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.ToggleMenu}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createToggleMenuAdapter() {
		if (toggleMenuItemProvider == null) {
			toggleMenuItemProvider = new ToggleMenuItemProvider(this);
		}

		return toggleMenuItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.malai.widget.RadioMenu} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RadioMenuItemProvider radioMenuItemProvider;

	/**
	 * This creates an adapter for a {@link org.malai.widget.RadioMenu}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRadioMenuAdapter() {
		if (radioMenuItemProvider == null) {
			radioMenuItemProvider = new RadioMenuItemProvider(this);
		}

		return radioMenuItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (treeItemProvider != null) treeItemProvider.dispose();
		if (sliderItemProvider != null) sliderItemProvider.dispose();
		if (progressBarItemProvider != null) progressBarItemProvider.dispose();
		if (tableItemProvider != null) tableItemProvider.dispose();
		if (labelItemProvider != null) labelItemProvider.dispose();
		if (textAreaItemProvider != null) textAreaItemProvider.dispose();
		if (textFieldItemProvider != null) textFieldItemProvider.dispose();
		if (spinnerItemProvider != null) spinnerItemProvider.dispose();
		if (multiLineListItemProvider != null) multiLineListItemProvider.dispose();
		if (singleLineListItemProvider != null) singleLineListItemProvider.dispose();
		if (panelItemProvider != null) panelItemProvider.dispose();
		if (windowItemProvider != null) windowItemProvider.dispose();
		if (dialogueBoxItemProvider != null) dialogueBoxItemProvider.dispose();
		if (splitPaneItemProvider != null) splitPaneItemProvider.dispose();
		if (tabbedPanelItemProvider != null) tabbedPanelItemProvider.dispose();
		if (buttonItemProvider != null) buttonItemProvider.dispose();
		if (toggleButtonItemProvider != null) toggleButtonItemProvider.dispose();
		if (menuItemProvider != null) menuItemProvider.dispose();
		if (checkBoxItemProvider != null) checkBoxItemProvider.dispose();
		if (radioButtonItemProvider != null) radioButtonItemProvider.dispose();
		if (toggleMenuItemProvider != null) toggleMenuItemProvider.dispose();
		if (radioMenuItemProvider != null) radioMenuItemProvider.dispose();
	}

}
