-- Test cayley_polytope/c2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1},{0,1,0,0,1,0,1,0,1},{0,0,1,0,0,1,1,0,0},{1,1,1,0,0,0,0,0,0},{0,0,0,1,1,1,1,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1},{0,0,0,0,0,1,1,1,1},{0,0,0,1,1,0,0,0,1},{0,0,1,0,1,0,0,1,0},{0,1,0,1,0,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test cayley_polytope/c1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1,0,1,0},{0,0,1,1,0,0,1,1,0,0,1},{1,1,1,1,0,0,0,0,0,0,0},{0,0,0,0,1,1,1,1,0,0,0},{0,0,0,0,0,0,0,0,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,1,1,1,1,1},{0,0,0,1,1,1,0,0,0,1,1},{0,0,1,0,0,1,0,0,1,0,1},{0,1,0,0,1,0,0,1,0,1,0},{1,0,0,1,0,0,1,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test cayley_polytope/c4.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1},{0,1,0,1,1,1,3},{0,0,1,1,0,0,4},{1,1,1,1,0,0,0},{0,0,0,0,1,0,0},{0,0,0,0,0,1,0}};
desiredHB = matrix {{1,1,1,1,1,1,1},{0,0,1,1,1,1,3},{0,1,0,0,0,1,4},{1,1,0,0,1,1,0},{0,0,0,1,0,0,0},{0,0,1,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test cayley_polytope/c3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{0,1,0,1,1,3},{0,0,1,1,0,4},{1,1,1,1,0,0},{0,0,0,0,1,0},{0,0,0,0,0,1}};
desiredHB = matrix {{1,1,1,1,1,1},{0,0,1,1,1,3},{0,1,0,0,1,4},{1,1,0,1,1,0},{0,0,1,0,0,0},{0,0,0,0,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test print_constraints/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,1,1,0,0,0},{1,0,0,1,1,0},{0,1,0,1,0,1},{0,0,1,0,1,1}};
desiredHB = matrix {{1,1,1,1,1,1},{0,0,0,1,1,1},{0,1,1,0,0,1},{1,0,1,0,1,0},{1,1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test delpezzo/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1},{1,0,0,0,-1,0,0,0,1,-1},{0,1,0,0,0,-1,0,0,1,-1},{0,0,1,0,0,0,-1,0,1,-1},{0,0,0,1,0,0,0,-1,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1},{-1,-1,0,0,0,0,0,0,0,1,1},{-1,0,-1,0,0,0,0,0,1,0,1},{-1,0,0,-1,0,0,0,1,0,0,1},{-1,0,0,0,-1,0,1,0,0,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test delpezzo/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1},{1,0,0,0,0,-1,0,0,0,0,1},{0,1,0,0,0,0,-1,0,0,0,1},{0,0,1,0,0,0,0,-1,0,0,1},{0,0,0,1,0,0,0,0,-1,0,1},{0,0,0,0,1,0,0,0,0,-1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,0,0,0,1,1},{0,-1,0,0,0,0,0,0,0,1,0,1},{0,0,-1,0,0,0,0,0,1,0,0,1},{0,0,0,-1,0,0,0,1,0,0,0,1},{0,0,0,0,-1,0,1,0,0,0,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test delpezzo/3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1},{1,0,0,0,0,0,-1,0,0,0,0,0,1},{0,1,0,0,0,0,0,-1,0,0,0,0,1},{0,0,1,0,0,0,0,0,-1,0,0,0,1},{0,0,0,1,0,0,0,0,0,-1,0,0,1},{0,0,0,0,1,0,0,0,0,0,-1,0,1},{0,0,0,0,0,1,0,0,0,0,0,-1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,0,0,0,0,0,1,1},{0,-1,0,0,0,0,0,0,0,0,0,1,0,1},{0,0,-1,0,0,0,0,0,0,0,1,0,0,1},{0,0,0,-1,0,0,0,0,0,1,0,0,0,1},{0,0,0,0,-1,0,0,0,1,0,0,0,0,1},{0,0,0,0,0,-1,0,1,0,0,0,0,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test delpezzo/0.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,0,0,-1,0,0,1,-1},{0,1,0,0,-1,0,1,-1},{0,0,1,0,0,-1,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1},{-1,-1,0,0,0,0,0,1,1},{-1,0,-1,0,0,0,1,0,1},{-1,0,0,-1,0,1,0,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test cell_from_subdivision/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1},{0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0},{0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0},{1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0,1},{1,1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0},{1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1},{0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0},{0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0},{1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0,1},{1,1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0},{1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test cell_from_subdivision/1-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test cell_from_subdivision/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,1,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,1,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test gc_closure/3-0.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{3/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2},{1/2,1/2,3/2,-1/2,1/2,1/2,1/2,1/2},{1/2,1/2,1/2,1/2,3/2,-1/2,1/2,1/2},{1/2,1/2,1/2,1/2,1/2,1/2,3/2,-1/2}};
desiredHB = matrix {{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3},{1,0,1,1,1,1,1,2,-1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,0,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,1,1,1,1,2,2,2,2},{1,1,0,1,1,1,2,1,1,0,1,1,1,2,-1,0,0,0,1,1,1,1,1,2,2,2,3,0,1,1,1,2,1,1,0,1,1,1,2,1,1,1,1,2,2,1,1,2,2,1,1,2,2,0,0,1,1,1,1,2,2,2,2,3,3,0,0,1,1,1,1,2,2,2,2,3,3,1,1,2,2,1,1,2,2,0,0,1,1,1,1,2,2,2,2,3,3,0,0,1,1,1,1,2,2,2,2,3,3,1,1,2,2,1,1,2,2,1,1,2,2},{1,1,1,0,1,2,1,1,1,1,0,1,2,1,1,0,1,2,-1,0,1,2,3,0,1,2,1,1,0,1,2,1,1,1,1,0,1,2,1,1,1,1,2,1,2,1,2,1,2,1,2,1,2,1,2,0,1,2,3,0,1,2,3,1,2,1,2,0,1,2,3,0,1,2,3,1,2,1,2,1,2,1,2,1,2,1,2,0,1,2,3,0,1,2,3,1,2,1,2,0,1,2,3,0,1,2,3,1,2,1,2,1,2,1,2,1,2,1,2,1,2}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test gc_closure/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,0,0,1,0,1,0,1},{1,1,0,0,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test gc_closure/3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{2/3,2/3,0,1/3,1/2,1/2,2/3,1/3,1/3,1/3,2/3,1/3,2/3,2/3,1/2,1/3,1/3,2/3,1,1/3,2/3,1/2,1/2,1/2},{2/3,2/3,1/2,1/3,0,1/2,2/3,1/3,1/3,1/3,1/3,2/3,1/3,1/3,1/2,2/3,2/3,1/3,1/2,2/3,2/3,1/2,1/2,1},{1/3,2/3,1/2,2/3,1/2,1/2,1/3,1/3,2/3,1/3,1/3,1/3,2/3,1/3,0,2/3,1/3,2/3,1/2,2/3,2/3,1/2,1,1/2},{2/3,1/3,1/2,2/3,1/2,0,1/3,2/3,1/3,1/3,1/3,1/3,1/3,2/3,1/2,1/3,2/3,2/3,1/2,2/3,2/3,1,1/2,1/2}};
desiredHB = matrix {{2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{0,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2},{1,0,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,2},{1,1,0,1,1,1,2,1,1,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2},{1,1,1,0,1,2,1,1,1,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test gc_closure/1-0.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test SCHLEGEL_VERTEX_COLORS/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VISUAL_DUAL_FACE_LATTICE/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test compress_incidence/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,0,0,0},{-1,1,0,0},{-1,0,1,0},{-1,0,0,1}};
desiredHB = matrix {{0,0,0,1},{0,0,1,-1},{0,1,0,-1},{1,0,0,-1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test lawrence/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{1,1,2,2,3,3,0,0,0,0,0,0},{2,3,1,3,1,2,0,0,0,0,0,0},{3,2,3,1,2,1,0,0,0,0,0,0},{1,0,0,0,0,0,1,0,0,0,0,0},{0,1,0,0,0,0,0,1,0,0,0,0},{0,0,1,0,0,0,0,0,1,0,0,0},{0,0,0,1,0,0,0,0,0,1,0,0},{0,0,0,0,1,0,0,0,0,0,1,0},{0,0,0,0,0,1,0,0,0,0,0,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{0,0,0,0,0,0,1,1,2,2,3,3,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,6,6},{0,0,0,0,0,0,2,3,1,3,1,2,1,1,1,1,2,1,2,2,2,2,4,3,3,3,2,1,1,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,3,3,4,4,5,5,3,4},{0,0,0,0,0,0,3,2,3,1,2,1,1,1,1,2,1,1,2,2,2,4,2,3,3,3,2,1,1,2,2,2,2,2,2,2,2,1,1,1,1,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,3,4,4,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,2,2,2,2,2,2,2,2,3,3,4,4,4,4,4,4,5,5,2,3,3,3,3,3,3,4,4,4,4,4,4,6,3,3,4,3,4,4,2,3,3,3,3,3,3,4,4,4,4,4,4,6,2,2,3,3,3,3,3,3,4,4,5,5,4,4,3,3,3,4,4,5,5,4,3},{0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,0,1,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,0,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,0,1,0,0,0,0,1,1,0,1,0,1,1,1,0,0,1,0,0,0,1,0,0},{0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,1,1,1,1,0,0,1,0,0,0,1,0,1,0,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,1,1,0,0,1,1,0,1,1,0,0,0,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,1,1,0,0,1,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,0,1,1,1,0,0,0,1,0,0,0},{0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,0,1,0,0,1,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,1,0,1,1,1,0,0,1,0,0,1,0,0,0,1,1,0,0,1,0,0,1,1,1,1,1,0,0,1,0,1,1,1,0,0,1,0,0,0,1,0,1,1,0,1,1,0,1,1,0,0,1,1,0,0,0,1,1,0,1,0,0,1,0,1,0,1,1,1,0,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,0,1,0},{0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1,1,1,1,0,1,0,0,1,0,1,0,1,0,0,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,0,0,1,1,0,1,0,0,1,0,1,1,0,0,0,1,0,0,0,1,1,0,1,0,1,1,0,0,1,0,0,1,0,1,0,0,1,1,1,0,1,1,1,0,0,1,1,1,0,0,0,1,1,1,0,1,0,1,1,1,0,0,0,1,1,0,0,0,1,0,0,1,1,1,0,1,0,1,1,0,1,0,0,1,0,1,0,0,1,1,0,1,0,1},{0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,1,0,1,0,1,0,1,0,0,1,1,1,1,1,0,0,0,0,1,0,1,0,1,1,0,0,1,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0,1,0,1,1,1,0,1,1,0,1,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,1,1,1,0,1,1,0,1,1,1,0,1,1,1,0,1,0,0,0,1,1,0,0,1,0,1,1,1,0,0,0,1,1,0,1,0,1,1,1},{1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,1,1,1,0,1,0,0,0,1,0,0,0,1,1,1,1,1,0,1,0,0,1,0,1,0,0,1,0,1,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,0,1,0,1,0,1,1,0,1,1,0,1,0,0,1,0,0,1,0,1,0,1,0,1,0,1,1,0,0,0,1,0,0,0,0,0,1,0,0,1,1,0,1,1,1,0,0,1,0,1,0,1,0,1,1,1,1,0,1,1,0,1,0,0,0,1,1,1,1,1,1,0,1,0,1,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test rand_sphere/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{3/32,7/64,3/4,-3/16,-5/32,-3/4,-1/4,1/64,-7/8,-1,5/8,5/32,-3/4,3/64,-7/32,-3/8,3/8,-1,-1/32},{5/8,5/8,3/8,-1/2,1,1/2,-3/32,-1/4,7/256,-1/4,-3/4,-7/128,5/8,-3/8,-7/128,-7/8,5/8,3/16,1},{-3/4,-3/4,-5/8,-3/4,1/4,1/4,1,1,-1/2,-3/16,3/8,-1,7/256,7/8,1,-3/8,3/4,5/64,5/16}};
desiredHB = matrix {{1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,90,90,90,90,90,90,90,90,90,90,90,90,90,90,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,108,108,108,108,108,108,108,108,108,108,108,108,108,108,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,110,110,110,110,110,110,110,110,110,110,110,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,113,113,113,113,113,113,113,113,113,113,113,113,113,113,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,120,120,120,120,120,120,120,120,120,120,120,120,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,130,130,130,130,130,130,130,130,130,130,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,132,132,132,132,132,132,132,132,133,133,133,133,133,133,133,133,133,133,133,133,133,133,134,134,134,134,134,134,134,134,134,134,135,135,135,136,136,136,136,137,137,137,137,138,138,138,139,139,139,140,140,140,141,141,141,141,141,141,141,141,141,141,142,142,142,143,143,143,143,143,143,144,144,144,144,144,144,144,145,145,145,145,145,145,145,145,145,145,145,146,146,146,146,147,147,147,147,147,147,147,147,147,147,148,148,148,148,148,148,149,149,149,149,149,150,150,150,150,150,151,151,151,151,151,152,152,152,152,152,153,153,153,153,153,153,154,154,154,154,155,155,155,155,155,156,156,156,157,157,157,158,158,158,158,158,159,159,159,159,160,160,160,160,160,160,161,161,161,161,161,161,161,161,161,162,162,163,163,163,163,163,164,164,164,164,164,165,166,166,166,167,167,167,167,167,168,168,168,169,169,169,169,170,170,170,170,171,171,171,172,172,173,173,173,173,173,173,173,173,174,174,174,174,174,175,175,175,175,175,175,175,176,176,176,176,176,176,177,177,177,177,177,178,178,178,178,178,179,179,179,179,179,180,180,180,181,181,181,181,181,181,181,182,182,182,182,182,183,183,183,183,184,185,185,185,185,185,185,185,185,186,186,186,186,186,186,187,187,188,188,188,188,188,188,189,189,189,189,190,190,190,191,191,191,191,192,193,193,193,193,193,193,194,194,194,195,195,196,196,196,196,196,196,198,198,198,198,199,199,199,199,200,200,201,201,201,201,201,202,202,202,203,203,203,203,204,204,204,204,204,204,205,205,205,206,206,206,206,206,206,206,206,206,207,207,207,207,208,208,208,208,209,209,210,210,210,210,211,213,213,213,213,214,214,214,215,215,215,215,216,216,216,216,216,216,216,217,217,217,217,218,218,218,218,218,219,219,220,220,221,221,221,222,222,222,223,223,223,223,224,224,224,224,225,225,225,225,225,226,226,227,227,227,227,228,228,228,229,229,229,229,229,230,230,230,231,231,231,231,231,231,232,232,232,232,232,233,233,233,233,233,233,233,234,234,234,235,235,235,235,235,235,235,236,236,236,236,236,236,237,238,238,238,238,239,239,240,240,241,242,242,242,243,243,244,244,244,244,244,245,245,245,245,245,245,246,246,246,246,246,246,247,247,247,247,248,248,248,248,248,249,249,249,250,250,250,250,250,251,252,252,252,252,252,253,253,253,253,253,253,254,254,254,254,254,255,255,255,256,256,256,256,257,257,257,257,258,258,259,259,259,259,259,260,260,260,260,262,262,263,263,265,265,265,265,265,266,266,266,267,267,267,270,270,272,272,273,275,276,279,279,280,281,281,281,281,283,283,284,290,290,292,293,294,296,297,301,301,303,306,306,307,308,309,310,314,320,323,324,327,331,333,336,337,340,341,347,350,353,354,358,364,367,368,380,381,394,398,403,410,411,424,438,455,468},{0,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,5,5,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,5,5,6,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,5,5,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,5,6,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,6,6,7,7,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9,-9,-9,-8,-8,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,5,5,5,6,6,7,8,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,5,5,8,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9,-9,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,5,6,9,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-10,-9,-9,-9,-8,-8,-8,-8,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,5,5,7,10,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-11,-11,-11,-11,-10,-10,-10,-10,-9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,4,5,5,5,5,-17,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-9,-9,-9,-9,-9,-9,-8,-8,-8,-7,-7,-7,-7,-6,-5,-5,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,6,6,7,9,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-15,-15,-15,-14,-13,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9,-9,-9,-8,-7,-6,-5,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,5,7,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-16,-16,-15,-15,-15,-15,-15,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9,-9,-8,-8,-8,-7,-6,-6,-6,-6,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,4,4,4,5,6,7,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-18,-18,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9,-7,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,4,4,5,5,5,5,6,7,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-18,-18,-18,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-9,-9,-8,-7,-6,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,5,5,5,7,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-20,-19,-19,-18,-18,-18,-17,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9,-8,-6,-5,-5,-5,-5,-5,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,6,7,8,-23,-22,-22,-22,-22,-22,-22,-22,-22,-22,-22,-22,-22,-21,-21,-21,-20,-20,-19,-19,-19,-19,-18,-18,-18,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-6,-5,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,4,4,4,5,5,5,7,7,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-22,-22,-22,-21,-21,-20,-19,-19,-19,-18,-18,-18,-17,-17,-16,-16,-16,-15,-15,-14,-12,-11,-11,-9,-8,-8,-7,-5,-4,-4,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,5,6,9,-24,-24,-24,-24,-24,-24,-24,-24,-24,-24,-23,-23,-23,-20,-20,-20,-20,-19,-19,-19,-18,-17,-16,-16,-15,-14,-12,-9,-7,-7,-7,-6,-5,-5,-5,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,4,4,4,4,4,5,5,-25,-25,-25,-25,-25,-25,-25,-25,-25,-24,-22,-22,-21,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-12,-10,-8,-7,-6,-6,-5,-5,-5,-5,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5,5,5,7,8,-26,-26,-26,-26,-26,-26,-26,-25,-25,-24,-23,-22,-22,-22,-21,-21,-20,-20,-20,-19,-18,-18,-18,-18,-17,-15,-13,-9,-9,-8,-7,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,6,6,7,7,-27,-27,-27,-27,-27,-27,-27,-27,-27,-26,-24,-24,-24,-23,-22,-22,-22,-21,-21,-20,-19,-12,-11,-9,-8,-7,-7,-7,-7,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,1,1,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,5,5,5,5,7,7,9,-29,-28,-28,-28,-28,-28,-28,-28,-28,-27,-26,-25,-24,-24,-24,-22,-22,-21,-21,-20,-19,-18,-17,-16,-15,-15,-14,-14,-13,-13,-12,-11,-9,-9,-8,-8,-7,-7,-6,-6,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,5,5,6,6,7,-29,-29,-29,-29,-29,-29,-29,-29,-28,-28,-27,-27,-27,-27,-26,-26,-25,-24,-23,-22,-22,-21,-18,-18,-11,-10,-10,-8,-8,-7,-7,-6,-6,-5,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,1,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,-30,-30,-30,-30,-30,-30,-30,-30,-29,-29,-28,-28,-28,-27,-27,-27,-26,-25,-25,-24,-24,-24,-23,-23,-23,-23,-22,-22,-21,-18,-9,-7,-7,-6,-6,-6,-6,-5,-5,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,9,9,-31,-31,-31,-31,-30,-29,-29,-29,-27,-25,-25,-24,-23,-23,-22,-19,-12,-9,-8,-8,-7,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,6,6,7,7,-32,-32,-31,-31,-30,-29,-28,-28,-28,-27,-26,-25,-24,-22,-19,-19,-19,-17,-11,-9,-8,-7,-7,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,7,-33,-33,-33,-33,-32,-32,-31,-29,-29,-29,-28,-28,-27,-26,-26,-26,-25,-25,-24,-23,-22,-19,-19,-16,-12,-11,-11,-9,-8,-8,-7,-7,-4,-3,-2,-1,0,1,2,2,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5,6,6,-34,-34,-33,-32,-31,-31,-29,-28,-26,-23,-18,-16,-11,-9,-7,-7,-6,-5,-4,-4,-3,-2,-1,0,0,1,1,2,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,-35,-35,-35,-35,-34,-33,-33,-32,-32,-30,-30,-29,-29,-28,-27,-27,-26,-25,-21,-19,-19,-17,-15,-13,-12,-7,-7,-4,-4,-2,-1,1,1,2,3,3,3,3,3,4,4,4,4,5,5,5,5,5,5,6,6,6,7,7,7,7,7,8,10,12,-36,-36,-36,-36,-35,-34,-34,-33,-33,-31,-31,-30,-29,-29,-29,-28,-27,-26,-25,-23,-16,-14,-12,-10,-4,-4,0,0,0,1,1,1,2,2,2,2,2,2,3,3,3,4,4,5,5,5,5,6,6,6,6,7,7,-37,-35,-35,-34,-33,-33,-31,-31,-31,-30,-29,-25,-24,-21,-9,-7,-7,-6,-4,-2,-1,0,2,2,3,3,3,3,3,3,4,4,5,5,5,5,6,6,6,6,7,7,9,-38,-38,-37,-36,-36,-34,-34,-33,-32,-32,-31,-31,-31,-30,-26,-25,-24,-18,-16,-16,-8,-8,-8,-7,-7,-5,-5,-4,-3,-2,2,3,3,3,3,3,4,5,5,5,5,5,5,5,6,6,6,6,7,-39,-39,-39,-39,-38,-37,-36,-35,-33,-32,-31,-31,-24,-17,-9,-8,-7,-7,-3,0,0,2,2,2,3,4,4,4,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,10,-40,-40,-40,-39,-39,-37,-36,-33,-32,-31,-29,-22,-21,-18,-10,-9,-7,-6,1,1,1,2,2,2,2,3,3,3,3,5,5,5,5,6,6,6,6,6,7,7,7,7,8,8,11,-41,-41,-41,-40,-37,-37,-35,-33,-32,-30,-27,-16,-5,-3,0,0,2,3,4,4,5,5,5,6,6,6,6,6,7,7,9,-42,-42,-39,-39,-38,-38,-37,-36,-35,-33,-28,-22,-22,-9,-7,-4,-3,-1,0,2,2,2,4,4,5,5,5,5,5,6,6,6,6,7,7,7,8,12,-43,-43,-43,-42,-40,-40,-39,-39,-38,-37,-34,-33,-33,-33,-31,-30,-24,-9,-8,-1,2,3,5,5,5,6,6,6,6,7,7,7,7,8,-44,-42,-41,-41,-39,-39,-36,-31,-8,-5,-2,1,1,1,2,2,2,2,2,3,3,4,5,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,10,11,-45,-45,-45,-40,-40,-39,-36,-32,-22,-21,-9,-8,-7,-5,-5,-5,-3,-1,0,1,2,2,2,3,3,3,4,4,5,6,6,6,6,7,7,7,7,7,8,8,9,9,9,-46,-46,-46,-45,-44,-44,-41,-41,-40,-40,-39,-38,-34,-28,-28,-23,-20,-10,-8,-7,0,2,4,5,6,6,6,6,6,6,7,7,7,7,8,8,9,-47,-47,-45,-41,-41,-41,-40,-40,-40,-39,-38,-31,-13,-11,-10,-9,-1,1,2,2,2,3,3,5,5,6,6,6,6,7,7,7,7,8,8,10,-48,-43,-43,-41,-38,-37,-34,-30,-23,-21,-14,-10,-4,1,1,2,2,2,2,2,3,3,5,5,5,6,6,6,7,7,7,7,8,8,8,-49,-48,-45,-45,-45,-43,-42,-41,-39,-38,-35,-27,-21,-11,-10,-7,-4,-2,1,2,2,2,4,5,6,6,6,7,7,7,7,7,7,8,8,8,9,9,9,12,12,-50,-50,-50,-46,-43,-43,-42,-41,-41,-39,-38,-37,-32,-28,-27,-18,-14,-13,-12,-11,-11,-10,1,2,2,2,3,3,4,5,5,6,6,7,7,7,7,8,8,8,9,9,10,-51,-51,-51,-50,-49,-44,-43,-43,-42,-42,-41,-39,-39,-39,-38,-35,-32,-27,-24,-4,0,2,2,4,6,6,7,7,7,7,8,8,8,9,-52,-52,-49,-46,-46,-44,-43,-42,-36,-34,-34,-28,-20,-19,-12,-11,-5,-4,-3,-3,1,2,2,2,2,3,4,6,6,7,7,7,7,8,8,8,8,9,9,-53,-53,-53,-53,-52,-48,-47,-44,-43,-42,-42,-41,-41,-38,-38,-36,-26,-26,-6,-3,0,2,2,2,3,3,4,5,5,7,7,7,7,8,8,8,8,8,9,9,9,9,-54,-51,-49,-48,-46,-44,-41,-33,-26,-24,-16,-14,-8,1,2,2,2,4,4,6,6,7,7,7,7,8,8,8,8,8,9,9,9,10,10,10,13,-55,-55,-55,-51,-50,-50,-49,-45,-40,-37,-29,-27,-21,-18,-13,-13,-11,-6,1,2,2,2,3,5,6,7,7,8,8,8,8,9,9,9,9,10,-56,-56,-56,-55,-51,-51,-50,-50,-45,-43,-42,-34,-31,-11,-2,0,1,2,2,2,3,5,6,7,7,7,8,8,8,8,9,9,9,10,10,11,12,-57,-57,-55,-50,-48,-45,-30,-20,-11,-7,-2,-1,1,2,2,2,2,3,4,5,7,8,8,8,8,9,9,9,10,-58,-58,-54,-52,-51,-51,-48,-45,-42,-38,-36,-34,-32,-30,-22,-15,-13,-8,-2,0,0,2,2,2,3,5,6,7,8,8,8,8,9,9,9,9,9,10,10,10,13,-52,-50,-19,-13,-7,2,2,2,4,5,6,7,8,8,8,8,9,9,9,9,9,10,10,11,14,-60,-59,-56,-53,-52,-52,-52,-46,-44,-44,-19,-13,1,2,2,2,3,3,5,7,8,8,9,9,9,9,10,10,-61,-61,-55,-55,-53,-52,-52,-50,-46,-45,-43,-35,-31,0,0,2,2,2,3,4,5,6,6,8,8,8,9,9,9,10,10,-62,-62,-62,-61,-56,-55,-54,-53,-53,-48,-45,-21,-10,-10,-8,1,2,2,2,2,4,8,8,9,9,9,9,10,10,10,11,-64,-63,-63,-63,-62,-57,-57,-54,-53,-49,-48,-45,-43,-15,-12,-12,-11,-10,-8,-5,-2,1,2,2,2,3,3,5,6,7,9,9,9,9,9,10,10,10,10,10,11,11,11,11,14,-64,-62,-61,-55,-54,-54,-52,-49,-25,-13,-12,-11,-1,1,1,2,2,2,2,3,4,4,6,9,9,9,9,10,10,10,10,11,11,11,11,12,13,-65,-65,-65,-62,-60,-54,-50,-35,-14,-12,2,3,5,5,7,8,9,9,9,10,10,10,10,10,11,11,-66,-66,-65,-61,-57,-55,-54,-53,-42,-33,-14,-10,0,3,6,6,8,9,9,9,9,10,10,10,11,11,13,-67,-66,-63,-58,-57,-55,-52,-47,-15,-14,-12,-1,4,9,9,9,10,10,10,10,11,11,11,-68,-66,-65,-62,-61,-61,-59,-57,-57,-56,-56,-55,-54,-52,-49,-15,-15,5,9,9,10,10,10,10,10,11,11,11,12,12,12,15,15,-66,-63,-62,-61,-61,-59,-59,-58,-51,-39,-31,-24,-14,6,7,7,9,10,10,10,10,11,11,11,12,13,-70,-69,-64,-58,-49,-30,-28,-26,-16,-14,-1,9,10,10,10,11,11,11,12,-71,-67,-63,-54,-46,-41,-39,-5,-1,10,10,10,10,11,11,11,12,-67,-67,-64,-64,-63,-63,-62,-59,-58,-57,-57,-56,-55,-45,-38,-17,-15,-12,6,10,10,10,10,11,11,11,11,11,12,12,12,12,-71,-65,-65,-64,-56,-41,-15,-15,4,10,10,11,11,11,11,11,12,12,12,13,13,13,16,-71,-67,-66,-66,-65,-64,-48,-47,-37,-15,-15,-13,-6,10,11,11,11,11,12,12,12,13,-68,-67,-65,-62,-55,-52,-39,-16,-15,9,10,10,11,11,11,12,12,12,13,-75,-69,-69,-68,-65,-63,-62,-61,-60,-59,-50,-49,-48,-45,-17,3,5,8,11,11,11,11,12,12,12,13,-72,-68,-65,-65,-59,-49,-41,-35,-29,-17,-16,-1,11,11,11,11,12,12,12,12,12,13,13,13,16,16,-68,-68,-66,-66,-65,-63,-60,-55,-53,-51,-49,-47,-39,-15,-4,8,11,11,11,12,12,12,12,12,13,13,14,17,-66,-65,-64,-43,-41,-37,-19,-18,-17,-6,4,11,11,12,12,12,12,13,13,-73,-71,-71,-68,-67,-61,-43,-43,-18,-15,11,11,11,12,12,12,13,13,15,-70,-69,-64,-62,-56,-51,-48,-45,-43,-41,-18,11,11,12,12,12,13,13,13,14,-78,-74,-71,-69,-68,-55,-24,-22,-20,-19,-16,-15,9,12,12,12,12,12,13,13,13,13,14,14,14,14,17,-65,-63,-63,-61,-60,-59,-59,-45,-16,-13,-1,5,12,12,12,12,13,13,13,13,13,14,14,15,-74,-72,-49,-44,-32,-18,-13,-11,12,12,12,13,13,13,13,14,14,-73,-20,-19,-18,11,11,12,12,12,13,13,13,14,14,16,-79,-78,-77,-67,-61,-57,-19,-17,-13,-9,-2,12,12,13,13,13,14,14,14,-78,-77,-77,-69,-67,-67,-60,-54,-46,-19,12,12,13,13,13,13,13,14,14,14,15,15,15,18,-82,-79,-78,-74,-72,-67,-66,-65,-20,7,9,10,12,13,13,13,13,14,14,14,15,16,-79,-74,-74,-71,-62,-26,-23,13,13,13,14,14,14,15,-81,-71,-62,-61,-20,-18,2,10,13,13,13,14,14,14,15,-84,-83,-76,-69,-69,-65,-64,-35,0,7,13,13,13,13,14,14,14,14,15,15,15,-72,-37,-19,13,13,14,14,14,14,14,15,15,15,15,16,16,16,19,-83,-81,-76,-75,-74,-72,-71,-66,-56,-22,-19,-19,-12,13,13,14,14,14,14,15,15,15,16,-84,-83,-71,-63,-49,-20,-19,-18,13,14,14,14,15,15,15,16,-70,-68,-55,-53,-51,-21,-19,11,13,14,14,14,15,15,15,15,16,-83,-78,-77,-77,-73,-69,-62,-26,-9,-7,14,14,14,14,15,15,15,15,16,16,16,19,-89,-80,-77,-76,-73,-70,-18,14,14,14,14,15,15,15,15,15,16,16,17,20,-85,-83,-81,-79,-78,-77,-58,-22,-20,-16,-3,2,14,14,15,15,15,15,16,16,-87,-84,-74,-72,-40,-18,14,14,15,15,15,16,16,17,18,-95,-87,-87,-78,-76,-75,-71,-64,-20,-15,11,14,14,15,15,15,16,16,16,-91,-90,-89,-89,-89,-79,-78,-78,-76,-74,-68,-20,-17,15,15,15,15,15,16,16,16,17,17,17,17,17,20,-90,-90,-81,-78,-78,-66,-22,-21,-18,2,15,15,15,15,16,16,16,16,17,17,18,-88,-85,-77,-29,-23,-22,-22,-13,6,15,15,15,16,16,16,16,17,17,-93,-91,-82,-79,-74,-68,-66,-31,-23,-22,14,15,15,15,16,16,16,17,17,19,-96,-90,-83,-80,-60,-23,-23,-6,15,15,15,16,16,16,17,17,17,-95,-94,-89,-88,-82,-80,-54,-43,-24,-14,15,16,16,16,16,17,17,17,18,18,18,21,21,-95,-75,-67,-62,-49,15,16,16,16,16,17,17,17,18,-97,-94,-94,-92,-90,-88,-86,-84,-23,-20,-5,-3,16,16,16,17,17,17,18,-96,-94,-79,-38,16,16,16,17,17,17,18,-99,-96,-91,-90,-73,-68,-23,3,4,6,16,16,16,17,17,17,17,18,18,18,21,-96,-84,-34,-24,-23,16,16,17,17,17,17,18,18,19,19,19,22,-99,-85,-23,-9,13,16,16,17,17,17,18,18,18,19,-100,-95,-91,-89,-88,-70,-46,-25,-11,16,17,17,17,18,18,18,19,-102,-100,-99,-89,-85,-78,-48,16,17,17,17,18,18,18,18,19,20,-107,-102,-101,-87,-23,12,17,17,17,18,18,18,18,19,19,19,22,-102,-98,-25,-24,17,17,17,18,18,18,18,19,19,20,23,-103,-103,-99,-93,-84,-77,17,17,17,18,18,18,18,19,19,-110,-103,-102,-101,-100,-94,-93,-91,-74,-37,-24,-23,-10,17,17,18,18,18,19,19,19,21,-98,-81,-26,-24,17,17,18,18,18,19,19,19,-106,-106,-82,-80,-26,-25,-24,-23,-14,-1,18,18,18,18,19,19,19,20,20,20,23,-111,-108,-108,-102,-26,-21,17,18,18,18,19,19,19,20,20,21,-106,-106,-96,-96,-95,-95,-27,-26,-25,8,9,10,18,18,18,19,19,19,20,20,-107,-106,-103,-93,-93,-87,-28,-27,-27,-25,18,18,18,19,19,19,20,20,22,-112,-99,-95,-91,-88,-26,15,18,18,18,19,19,19,20,20,20,20,-117,-104,-102,-95,-95,-89,-83,-81,-40,-28,-5,15,18,19,19,19,19,20,20,20,21,21,21,24,-111,-108,-108,-105,-98,-97,-93,-42,18,19,19,19,20,20,20,21,-113,-109,-102,-91,-77,-76,-28,-28,-26,-17,16,18,19,19,19,20,20,20,20,21,-113,-113,-104,-91,-85,-83,-29,-27,-27,-19,19,19,19,20,20,21,-119,-114,-110,-97,-95,-27,19,19,20,24,-115,-114,-109,-101,-95,-94,-85,-74,-31,-27,-23,-8,-6,20,25,-115,-114,-113,-99,-91,-85,-83,13,-115,-115,-115,-114,-114,-107,-104,-101,-97,-84,-82,-28,-8,3,-118,-115,-113,-113,-111,-94,-89,-45,-29,-28,-118,-101,12,-118,-99,-80,-22,-103,-31,-29,17,-88,-34,1,-120,-102,-36,-119,-110,-96,-124,-124,-122,-120,-119,-117,-115,-106,-80,-13,-124,-124,-31,-125,-108,-94,-26,-4,-2,-131,-127,-118,-112,-111,-100,-37,-130,-128,-126,-125,-110,-109,-108,-102,-2,5,7,-127,-119,-107,-39,-130,-129,-128,-127,-126,-113,-98,-31,-28,22,-131,-127,-114,-113,-100,-16,-138,-128,-126,-104,-97,-131,-131,-129,-108,-104,-131,-131,-128,-124,-30,-139,-127,-116,-115,-106,-134,-115,-113,-106,-42,-9,-133,-132,-132,-108,-137,-114,-108,-100,-94,-128,-117,-117,-137,-136,-102,-138,-133,-132,-125,-33,-138,-122,-121,-115,-140,-139,-121,-120,-109,-10,-142,-141,-139,-138,-137,-135,-135,-129,-117,-141,-114,-144,-140,-125,-123,-24,-140,-139,-123,-123,-119,-119,-146,-144,-126,-146,-146,-125,-121,-120,-139,-135,-121,-131,-130,-127,-123,-138,-127,-126,-27,-148,-142,-125,-152,-139,-150,-150,-133,-132,-129,-128,-127,-125,-153,-153,-147,-134,-130,-154,-153,-151,-150,-132,-131,-129,-150,-131,-130,-128,-121,-117,-155,-152,-134,-133,-131,-155,-143,-134,-123,-36,-151,-141,-134,-133,-120,-159,-158,-125,-160,-157,-157,-147,-136,-124,-117,-159,-157,-145,-127,-125,-159,-152,-138,-119,-113,-162,-156,-139,-121,-119,-117,-115,-35,-164,-163,-160,-158,-143,-133,-165,-154,-161,-161,-161,-148,-147,-141,-147,-145,-120,-119,-166,-166,-162,-166,-164,-163,-140,-137,-169,-169,-168,-167,-141,-134,-171,-149,-125,-169,-149,-169,-167,-165,-163,-147,-147,-167,-162,-151,-148,-175,-174,-150,-131,-176,-176,-177,-176,-151,-146,-139,-164,-162,-153,-174,-169,-158,-148,-176,-171,-170,-170,-157,-137,-178,-154,-150,-184,-181,-178,-176,-176,-174,-151,-145,-142,-182,-181,-179,-155,-181,-160,-159,-144,-157,-143,-176,-172,-161,-140,-151,-187,-185,-160,-159,-188,-187,-162,-188,-179,-166,-162,-184,-183,-176,-164,-161,-157,-154,-188,-180,-164,-163,-191,-187,-184,-174,-171,-193,-168,-192,-173,-192,-166,-163,-194,-193,-160,-194,-181,-169,-157,-198,-182,-167,-157,-197,-197,-193,-176,-169,-198,-194,-200,-193,-175,-163,-200,-171,-171,-200,-199,-193,-178,-165,-201,-197,-187,-201,-201,-199,-184,-169,-167,-203,-185,-167,-159,-153,-205,-205,-204,-200,-198,-182,-182,-195,-177,-161,-205,-203,-179,-177,-161,-159,-157,-204,-191,-177,-177,-174,-173,-204,-209,-203,-189,-180,-209,-179,-211,-163,-181,-212,-181,-178,-213,-193,-215,-213,-205,-186,-180,-222,-213,-213,-213,-211,-183,-216,-216,-214,-199,-184,-182,-216,-216,-214,-186,-218,-210,-194,-188,-184,-215,-191,-187,-215,-199,-188,-186,-162,-188,-221,-221,-190,-188,-183,-226,-220,-210,-190,-180,-180,-222,-220,-207,-192,-190,-222,-182,-168,-224,-223,-213,-192,-225,-223,-193,-184,-215,-176,-228,-227,-217,-216,-209,-229,-224,-178,-174,-208,-182,-236,-205,-221,-204,-203,-200,-180,-234,-219,-197,-238,-194,-188,-211,-186,-235,-194,-230,-221,-222,-236,-214,-211,-250,-242,-241,-221,-216,-203,-200,-243,-236,-231,-228,-252,-220,-217,-254,-206,-253,-250,-245,-242,-256,-237,-234,-223,-259,-251,-248,-240,-279,-264,-268,-265,-257,-254,-290,-282,-274,-271,-293,-296,-288,-299,-305,-302,-319,-308,-334,-336,-325,-342,-356,-362,-379},{0,-1,0,0,0,1,-1,-1,-1,0,0,1,1,1,-1,-1,0,0,0,1,1,-1,-1,0,0,0,1,1,1,-2,-2,-1,-1,-1,0,0,1,1,2,2,-2,-1,-1,0,0,1,1,2,2,2,-2,-2,-1,-1,0,0,1,1,1,2,2,-1,0,1,1,-1,-1,0,0,0,0,1,1,1,2,2,-2,-1,1,1,2,2,-3,-2,-1,-1,0,0,1,2,2,3,3,-3,-1,-1,0,0,1,1,3,3,3,3,-1,0,0,1,1,2,2,2,3,3,1,2,-2,-1,-1,-1,0,0,0,0,1,1,1,2,2,-2,0,2,3,3,-3,-2,-1,0,1,1,3,4,-4,-3,-1,0,0,1,2,2,3,4,4,-3,-1,-1,0,0,1,1,3,3,4,4,4,4,-2,-1,0,0,1,1,2,2,3,3,4,4,1,2,3,3,-3,-3,-2,-1,-1,-1,0,0,0,0,0,1,1,1,1,2,2,2,-3,-3,-1,-1,1,3,-4,-1,0,0,2,2,3,4,4,-5,-4,0,1,3,4,5,-3,-1,0,0,1,2,4,5,5,5,-2,-1,-1,0,0,1,1,3,3,4,5,5,5,5,-4,-3,-2,-1,-1,0,0,1,1,2,2,4,4,5,-3,1,3,4,-4,-4,-2,-2,-1,-1,-1,0,0,0,0,0,1,1,1,1,2,2,2,-3,-2,-1,0,4,4,-4,-3,-2,-1,0,1,4,-5,-4,-3,1,2,4,5,5,-5,-4,-1,0,1,3,4,5,6,-3,-3,-1,-1,0,1,2,4,4,5,6,6,6,-5,-4,-3,-2,-1,-1,0,0,1,1,3,3,4,5,6,6,6,6,-2,-1,-1,0,0,1,1,2,2,4,5,6,-5,-4,-1,0,1,4,5,-5,-5,-4,4,-5,1,2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,2,2,2,-2,-1,-1,1,1,2,-4,0,1,5,5,-5,-2,1,5,6,-7,-6,-5,-1,1,2,5,6,-5,-1,0,1,3,5,6,6,7,7,-6,-5,-5,-3,-2,0,1,2,4,5,6,7,7,7,-2,-2,-1,-1,0,0,1,3,5,6,7,7,7,7,-6,-6,-5,-2,-1,-1,0,0,1,1,2,4,5,6,7,-6,0,1,5,6,-6,-5,0,5,5,-5,-6,-5,3,-3,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,-4,-3,-2,1,4,-3,0,1,1,5,-6,2,5,6,-7,-4,-2,-1,1,3,4,6,7,-7,2,6,7,-7,-7,-6,-5,-2,0,3,6,6,7,8,8,-3,1,2,6,7,8,8,8,8,-7,-7,-3,-3,-2,-1,0,0,1,3,6,7,8,8,8,8,-7,-6,-3,-3,-2,-1,-1,0,0,1,1,2,4,6,7,7,-7,-6,0,1,7,-3,6,-6,4,-6,4,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,-2,1,5,5,-5,-5,-2,0,2,6,6,-6,-5,1,6,7,-7,-6,-3,-1,2,6,7,-6,3,6,7,8,-7,-4,-1,0,2,4,6,7,8,8,9,-5,-1,0,3,6,7,8,9,9,-8,-8,-3,1,5,7,7,8,9,9,9,9,-8,-3,-1,0,1,2,3,7,9,9,9,-8,-4,-4,-3,-2,-1,-1,0,0,1,1,4,4,6,7,8,-4,0,1,7,8,-7,-4,7,7,-4,-3,3,5,3,-1,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,-4,-3,-2,1,1,2,2,3,5,5,-1,1,4,-4,-2,2,3,7,7,-7,7,8,-5,2,7,8,-1,-1,3,7,8,9,-4,-1,0,7,8,9,10,-5,-1,-1,1,3,7,8,9,9,10,10,10,-9,-4,-2,1,7,8,9,10,10,10,-9,-3,-1,0,2,3,6,7,10,10,10,10,-5,-3,-2,-1,-1,0,0,1,1,4,4,7,9,-1,0,1,6,8,4,7,8,2,5,2,4,-3,-3,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,-3,-2,1,2,5,5,6,7,7,-3,-1,7,-6,2,7,8,-4,-1,3,8,9,9,-7,-4,-2,-1,4,5,8,9,-5,-1,3,8,9,10,10,0,8,9,10,11,11,-5,-1,1,3,8,9,11,11,-5,-3,1,3,8,11,11,11,11,-7,-6,-5,-5,-1,11,11,11,11,-8,-3,-2,-2,-1,-1,0,0,1,1,4,4,7,8,10,-1,0,1,-2,-1,0,4,7,9,3,-7,6,7,1,2,1,1,-3,-3,-3,-2,-2,-2,-1,-1,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,4,-5,-3,-2,1,1,2,2,3,-6,7,7,-2,8,8,-8,-5,8,9,-3,-2,8,9,-1,3,8,9,10,-3,8,9,10,11,-1,0,3,8,9,9,10,11,-2,-1,0,9,10,11,12,-5,1,12,12,12,-8,-7,-6,1,3,12,12,12,12,-6,5,12,12,12,-6,-5,-4,-3,-2,-2,-1,-1,0,0,4,7,8,9,10,11,11,-3,-1,0,1,8,10,-10,-9,-8,-3,0,10,0,7,2,7,0,-4,-3,-3,-3,-2,-2,-1,-1,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,-2,1,1,2,3,5,6,-7,6,-4,9,-2,0,3,4,9,10,-3,-1,9,10,3,9,10,11,-6,-3,-2,-1,9,10,11,12,-1,9,10,-7,-3,-1,4,9,13,-9,-8,1,12,13,13,13,-3,7,13,13,13,-4,13,13,13,13,-4,-3,-2,-2,-1,-1,0,0,9,12,-11,-6,-1,0,1,7,11,0,1,3,8,10,-7,-7,1,-1,-4,-4,-3,-3,-3,-3,-2,-2,-1,0,0,1,1,1,2,2,2,2,2,3,3,3,3,4,-2,6,-3,9,9,-3,9,10,-6,9,10,-4,-1,3,10,11,4,10,11,12,-5,-2,10,11,12,4,10,11,-7,14,14,-7,-2,1,14,14,14,-3,14,14,14,14,-4,-4,1,5,8,14,14,14,14,-4,-3,-2,-2,-1,-1,0,0,9,10,13,-12,-1,0,1,7,9,12,-7,0,1,3,10,2,-4,10,0,-2,-4,-4,-4,-3,-3,-3,-2,-2,-1,-1,0,0,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,-2,-1,1,6,1,4,5,8,-2,3,10,10,-5,-3,10,11,-1,10,11,0,10,11,12,4,10,11,12,13,-5,10,11,10,-8,-5,-2,0,9,-8,-7,-2,8,15,15,-8,-5,1,15,15,15,-8,-3,15,15,15,15,-5,15,15,15,-7,-5,-4,-3,-2,-2,-1,-1,0,0,9,10,11,14,14,-2,-1,0,1,7,10,13,-2,-1,0,1,2,3,10,-8,-8,1,2,10,1,-4,-4,-3,-3,-3,-3,-2,-2,-1,0,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,-3,0,1,6,-7,8,-8,-2,8,9,8,-4,11,-7,-4,11,12,12,-5,0,4,5,11,12,11,12,13,-6,11,12,14,-2,-7,6,5,16,-7,-3,9,16,16,16,16,16,16,10,16,16,16,-9,-8,-7,16,16,16,16,-6,-5,-4,-3,-2,-1,-1,9,11,12,15,-9,-2,-1,0,1,7,11,14,-9,-1,0,1,2,-6,-2,-1,0,1,-6,10,-6,0,2,-4,-5,-3,-3,-2,-2,-1,0,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,-5,-2,-2,1,2,8,8,10,11,11,11,12,-6,1,11,12,-4,-3,0,11,12,13,12,13,14,12,-2,5,-7,17,-7,17,17,17,-4,17,17,17,17,-10,-9,-6,17,17,17,17,-5,17,17,17,-7,-5,-4,-3,-2,-1,-1,11,12,16,-2,-1,0,7,11,15,-10,-8,-1,0,1,2,0,0,-1,-4,-3,-2,-1,0,1,2,2,2,2,3,3,3,3,3,4,4,4,5,-4,-1,7,-4,-1,-4,1,7,10,10,1,12,-5,1,4,12,13,12,13,-4,12,13,14,12,13,-7,-4,-3,16,-8,-4,-2,11,-2,10,-4,-2,9,18,-1,18,18,18,-11,-3,18,18,18,-7,-1,1,18,18,18,18,-5,4,10,18,18,18,-5,-4,-4,-3,-2,-1,-1,12,13,17,17,-4,-2,-1,0,12,16,-1,0,1,1,2,4,13,-9,-8,0,-4,-1,10,-3,-3,-2,1,2,2,3,3,3,3,3,4,4,4,5,5,-6,-3,3,3,7,-6,-3,0,-6,-3,-4,11,12,10,13,1,13,-7,13,14,-5,13,14,15,6,13,-6,-2,19,19,-3,1,12,19,19,19,3,11,19,19,19,19,-4,17,19,19,19,-11,15,19,19,19,19,-11,-5,-4,-3,-2,-1,13,14,15,18,-2,-1,0,12,13,17,-1,0,1,1,2,4,13,0,0,-10,-9,-5,13,11,-2,-3,-3,-2,1,2,2,3,3,3,4,4,4,4,5,5,-5,-2,7,7,-8,-5,1,2,9,-9,-5,-2,0,5,-5,2,3,4,12,12,-5,3,13,13,1,13,14,-6,13,14,13,14,15,0,12,14,11,-6,10,9,-6,3,-6,-2,6,7,20,20,-6,-4,1,20,20,20,20,-8,19,20,20,20,20,-6,13,17,20,20,20,20,-5,13,15,16,20,20,20,-9,-8,-7,-6,-5,-4,-3,-2,14,19,-2,-1,0,12,13,14,18,-2,-1,0,0,1,1,4,13,-2,-1,0,-1,12,13,1,-3,1,1,2,2,3,3,3,4,4,4,4,5,5,-1,-7,9,-7,-1,11,-7,-4,0,9,-7,2,0,1,14,14,15,15,-8,0,5,14,15,-6,14,3,17,-7,1,-3,19,-2,-3,-2,10,16,20,21,21,1,20,21,21,21,21,21,21,17,21,21,21,21,-11,-10,-7,-6,-6,15,21,21,21,-6,-5,-4,-3,-2,14,20,20,-9,-2,-1,12,14,19,-9,-2,-1,0,0,1,1,4,-1,-1,0,13,-2,-1,13,-2,13,2,3,-3,1,2,3,3,4,4,4,4,4,5,5,-1,2,4,1,6,-9,0,2,11,-9,-6,-3,-6,2,13,14,14,13,15,-3,15,15,16,-4,15,-8,0,22,-8,22,22,-3,19,22,22,22,-8,21,22,22,22,22,-12,-11,16,20,22,22,22,14,22,22,22,22,-4,-3,-2,18,21,-2,-1,14,15,20,-12,-10,-2,-1,0,0,1,4,12,14,-9,-1,0,-4,-2,0,-3,13,-3,1,2,3,3,4,4,4,4,4,5,5,5,6,-2,-1,2,1,2,11,-8,-2,13,-8,-5,2,3,15,4,15,16,15,16,15,13,-8,19,-3,0,9,-4,21,23,23,-4,15,18,23,23,23,23,-13,9,15,23,23,23,23,-5,15,23,23,23,23,-1,14,23,23,23,-3,-2,22,-2,-1,15,16,17,21,-2,-1,-1,0,0,1,12,15,16,-1,0,1,0,-3,-2,1,2,3,4,4,4,5,5,5,6,2,3,5,-10,-1,10,13,-4,2,15,16,16,16,17,16,6,-7,5,-3,-2,23,11,-3,20,24,24,24,17,24,24,24,24,24,24,24,-8,4,24,24,24,24,-6,24,24,24,-9,-8,-7,23,-9,-1,16,22,-2,-1,-1,0,0,12,16,-2,-2,-1,0,1,0,16,3,4,4,5,5,5,5,6,6,1,1,11,5,-3,-1,2,3,14,15,-6,16,16,15,17,14,17,1,12,11,0,-7,-7,-7,22,9,13,-4,-2,19,25,25,25,25,1,25,25,25,-1,24,25,25,25,25,23,24,25,25,25,-7,25,25,25,25,-11,-10,-4,21,24,16,17,23,-11,-10,-2,-2,-1,-1,0,0,12,16,-2,-1,0,1,-3,-3,-2,-1,0,16,16,1,3,4,4,5,5,6,6,1,8,10,5,1,11,13,-2,15,-5,-1,1,17,4,17,18,18,5,20,-8,-1,10,-1,21,18,26,26,-5,26,26,26,26,26,26,26,16,26,26,26,26,15,26,26,26,26,-13,-12,11,26,26,26,25,17,18,20,24,-3,-2,-2,-1,-1,0,12,17,-12,-10,-3,-2,-1,0,1,-1,0,-4,-1,-7,16,3,3,4,4,5,5,6,6,6,1,1,2,3,2,1,13,15,-4,17,18,18,-5,-1,23,-3,-1,7,12,20,27,27,1,27,27,27,27,27,27,27,-5,27,27,27,-14,-13,-7,27,27,27,27,-6,27,27,27,17,26,18,19,25,-14,-3,-2,-2,-1,-1,0,17,18,-2,-1,0,1,9,-13,-4,-1,0,-5,16,2,5,3,4,5,5,6,6,6,7,1,2,2,0,1,14,-3,17,-6,18,19,-3,20,-3,0,-3,22,-9,3,-3,10,-4,-3,-3,22,1,18,17,19,-2,4,16,-4,28,28,1,28,28,28,28,3,27,28,28,28,28,5,28,28,28,28,26,27,28,28,28,28,28,28,28,-10,-9,-8,24,27,-11,-10,18,19,26,-5,-3,-2,-2,-1,-1,17,18,19,-2,-1,0,9,-1,0,-5,17,-5,3,4,5,5,6,6,6,7,1,9,-1,1,2,9,-1,1,14,16,17,-5,19,19,1,6,10,-4,11,-3,-2,-3,6,0,29,-3,2,29,29,29,29,29,29,29,29,29,29,29,16,23,29,29,29,29,29,29,29,29,29,29,29,28,-5,19,20,27,-12,-10,-3,-2,-2,-1,-1,17,19,-4,-2,-1,0,9,-2,-1,0,18,19,3,4,5,6,6,6,7,7,-2,9,-3,1,2,0,1,2,5,2,16,3,16,18,-4,-2,2,19,-7,20,14,6,-3,-4,-2,0,19,23,30,30,30,30,30,30,30,17,30,30,30,30,-5,-1,30,30,30,30,30,30,30,-5,30,30,30,-13,-12,22,29,20,22,28,-13,-4,-3,-2,-2,-1,17,19,20,-11,-3,-2,-1,0,9,19,-5,-2,-1,0,19,-3,-2,-1,19,0,1,5,6,7,7,3,-5,-2,1,-2,2,18,19,-6,20,21,23,5,-1,-3,30,-2,0,31,31,31,31,31,32,30,31,31,31,31,29,30,31,31,31,31,32,16,27,31,31,31,31,-1,26,30,31,31,31,31,32,-15,-14,24,31,31,31,-10,-7,20,22,23,30,20,21,29,-4,-3,-2,20,20,21,-5,-3,-2,-1,9,17,20,-2,-1,0,-6,-1,-1,19,5,6,3,4,1,13,-4,-1,3,2,18,20,21,-4,-2,1,7,-5,12,12,-3,-2,1,32,32,-5,-1,32,32,16,32,32,32,32,17,32,32,32,32,32,32,32,-16,-7,32,32,32,32,32,32,-11,-10,-9,-7,31,-12,-11,30,-4,-3,-2,21,-3,-2,-1,17,-6,-2,-1,0,-1,-7,5,5,6,7,3,9,1,-6,0,14,-3,8,-1,3,6,20,4,5,-7,-5,23,12,25,8,18,-1,12,-1,-1,3,-4,-1,18,33,-7,33,33,32,25,31,-11,-5,-5,-4,-3,-2,22,-3,-2,-1,17,-2,-1,0,6,-1,0,5,8,3,-2,1,4,-2,-5,22,4,8,-4,-4,-2,-5,16,10,12,-5,34,34,34,34,-9,18,1,33,32,-5,-4,-3,23,-6,-3,-2,-1,17,22,-15,-3,-2,-1,0,6,22,-3,-2,-1,0,5,6,8,8,3,-2,5,1,2,-1,17,-7,-4,17,16,22,-3,4,-6,-6,0,-6,-6,-2,13,4,14,18,35,35,-3,-15,34,33,-15,-6,-5,-4,-3,-3,-2,17,23,-7,-3,-2,-1,0,6,-2,-1,0,-8,-3,-2,-1,22,1,1,-5,5,6,8,8,10,-2,3,1,2,0,8,-3,-6,0,1,21,0,24,0,26,-7,10,33,16,3,23,-17,-16,30,-12,-11,-10,-14,-13,-7,8,28,34,-6,-5,-4,-7,-2,-3,-2,-1,6,-8,-2,-1,0,-1,22,7,3,12,1,1,2,-2,1,19,-5,22,-5,-5,6,-3,-5,0,-8,37,37,-18,-10,-6,35,-15,-12,-6,-5,-5,-4,-5,-2,-3,-2,-1,14,-2,-1,0,23,-9,-1,22,7,7,9,3,4,3,16,1,-1,8,-4,7,21,-2,26,0,-7,-2,-5,-2,-8,9,13,0,7,19,34,38,34,38,36,-7,-6,-5,-4,15,25,-16,-3,-2,-1,14,24,25,-2,-1,0,3,-1,7,7,8,9,5,3,4,10,11,-3,-6,23,-7,-5,31,-7,0,30,-7,33,34,-7,-7,31,-5,-8,25,26,-3,-2,-1,14,25,-9,-3,-2,-1,0,3,-3,-2,-1,25,0,8,8,9,5,11,6,1,-2,-5,25,-4,-2,-6,-5,-1,-1,-4,-8,-17,-12,-11,-15,-14,-12,-7,-17,-16,-8,-7,-9,-3,-2,14,-3,-2,-1,0,3,-10,-2,-1,25,-3,-2,1,8,8,9,5,1,2,20,-4,25,27,29,36,41,41,-19,-18,-7,-13,-17,-9,-3,-2,22,-10,-3,-2,-1,3,-2,-1,25,9,9,3,14,1,2,4,3,14,-6,-6,0,27,6,-11,-8,-3,-20,37,-8,-6,34,28,29,-18,-3,-2,22,27,-3,-2,-1,11,-11,-2,-1,-1,-3,7,9,9,11,3,15,-1,3,9,15,-5,-3,27,27,-3,29,0,9,27,-10,-8,-9,-2,22,28,-3,-2,-1,11,-3,-2,-1,0,-1,7,7,-3,3,0,2,24,2,-4,-11,-9,-13,-12,-2,-17,-16,-13,-9,-8,-17,32,-10,22,-11,-3,-2,-1,11,-4,-3,-2,-1,0,28,-4,-3,-2,-1,0,0,8,10,10,1,3,-2,1,-5,-5,13,9,0,36,-2,10,36,-2,-2,41,-19,-9,-8,37,-19,-18,-10,-17,32,-11,-4,-3,-2,11,-3,-2,-1,0,28,-2,-1,-8,-2,28,8,10,10,12,5,14,19,19,-1,1,11,1,30,0,32,37,39,3,0,2,-21,-9,5,30,-12,-4,-3,-2,19,29,-3,-2,-1,0,-2,-1,28,9,10,5,0,4,8,-3,3,14,20,26,-7,-1,21,-1,24,-22,-13,-17,-10,-9,35,36,-6,30,-4,-3,-2,19,-3,-2,-1,8,-2,-1,-6,9,1,2,-2,28,29,32,33,-1,-1,19,-1,-14,-14,-13,-18,-17,-14,-10,-9,-18,-11,-12,-6,12,-3,-2,19,-3,-2,-1,8,-3,-2,-1,9,7,0,3,18,2,-1,-4,24,30,7,12,15,-3,-1,-16,-13,-9,-8,-11,-10,-9,-12,-6,-13,-3,19,-4,-3,-2,-1,8,31,-3,-2,-1,-4,-3,-2,-1,0,9,10,11,3,0,2,-3,-6,27,28,28,4,34,11,0,32,-3,1,-3,-3,0,2,-21,-11,-10,-2,-21,38,-8,-13,33,27,32,-4,-3,-2,8,-3,-2,-1,-2,31,-2,10,10,11,13,14,9,-2,11,-5,19,25,5,32,32,33,7,33,40,40,-9,-23,-11,-10,-8,-14,27,-4,-3,-2,16,-3,-2,-1,-2,10,11,5,3,22,3,-4,3,8,2,2,13,18,17,-2,31,-5,-2,-17,-5,-14,-19,-12,-11,-10,-20,-13,-6,27,-4,-3,-2,16,-3,-2,-1,5,-2,-1,9,10,11,11,13,0,4,-3,20,-2,31,1,31,-2,35,26,13,41,-19,-16,-13,-12,-11,-10,-13,-10,0,-14,36,-4,-3,-2,16,-4,-3,-2,-1,5,-4,-3,-2,-1,11,17,0,2,12,-5,34,9,40,37,-1,2,2,17,-13,-12,-11,-14,-7,-15,35,-4,-3,16,34,-4,-3,-2,-1,5,-3,-2,-1,-4,-3,-2,0,10,11,12,19,0,3,2,4,5,9,14,-4,19,-1,-4,11,-1,13,-23,-13,-12,-11,-23,-15,35,-3,24,-4,-3,-2,5,-3,-2,-1,34,-2,10,12,12,14,3,8,3,8,-6,33,36,24,43,-1,-20,-25,-15,-13,-12,-11,-21,39,-16,-6,-3,24,-4,-3,-2,13,-3,-2,-1,-2,34,34,12,11,12,16,5,15,33,0,47,-1,29,-19,-2,-3,-14,-13,-12,-11,-3,-15,-3,24,-4,-3,-2,13,-3,-2,-1,-2,11,12,5,0,0,25,2,35,28,10,0,0,0,15,20,-1,-2,23,-18,-20,-14,-14,-13,-12,-15,-16,38,9,-4,-3,-2,13,-4,-3,-2,-1,2,-4,-3,-2,-1,1,2,35,-2,-2,-14,-13,-12,-16,42,-17,32,-5,-4,-3,13,-4,-3,-2,-1,2,-3,-2,-3,0,12,14,20,13,-1,1,2,37,-5,1,-2,21,-16,-15,-14,-13,-25,-23,-17,32,-4,-3,-4,-3,-2,2,-3,-2,12,13,0,3,0,-3,29,22,39,-6,39,46,16,-27,-10,-15,-14,-13,-16,45,-24,-18,41,-4,-3,21,-4,-3,-2,-3,-2,11,13,13,15,3,2,5,-2,4,36,5,-1,-4,18,-4,-23,-16,-15,-14,-13,-17,-3,21,-4,-3,-2,10,-4,-3,-2,-2,12,11,12,13,15,2,24,-1,-4,31,30,40,-1,1,-1,10,-6,37,37,-11,-25,-16,-16,-15,-14,-24,-17,-18,-3,40,-5,-4,-3,-2,10,-5,-4,-3,-2,-1,-5,-4,-3,-2,-1,12,8,19,18,-3,14,25,40,37,4,-1,1,-6,-17,-6,-16,-15,-14,-3,-24,-25,-18,-19,-5,-4,-3,10,-4,-3,-2,-1,-9,-3,-2,39,-3,-1,12,13,14,19,4,-5,39,0,-2,-1,-15,-27,-26,-19,4,29,-5,-4,-3,-4,-3,-2,-1,40,-3,-2,12,14,10,23,10,-4,23,22,47,41,-2,-2,-29,-18,-20,-8,-7,-5,-4,-3,18,-4,-3,-2,-3,-2,-7,13,16,6,5,4,2,40,1,-4,-2,-2,-28,-19,-4,-3,18,-4,-3,-2,7,-4,-3,-2,13,18,12,-1,2,3,1,2,23,-5,29,-3,32,42,1,-4,11,-20,-4,6,-5,-4,-3,-2,7,-4,-3,-2,-5,-4,-3,-2,-1,8,4,27,2,3,2,13,14,20,44,39,-1,-7,-21,-9,-4,-4,-5,-4,-3,7,-4,-3,-2,-3,-3,12,16,4,36,-4,-1,-1,-1,-3,12,-16,26,-5,-4,-3,-4,-3,-2,-3,12,22,4,44,50,45,43,-9,-3,-5,-4,-3,15,-4,-3,-2,-3,6,17,0,2,6,31,3,28,34,4,40,43,45,50,0,-3,-3,1,-11,-5,-4,-3,15,-5,-4,-3,-2,4,-5,-4,-3,-2,19,1,2,1,43,14,-2,21,-11,-5,-4,-5,-4,-3,-2,4,-4,-3,-2,-5,-4,-3,-1,21,-1,2,3,7,-1,10,51,41,-2,-2,13,-5,-4,-5,-4,-3,4,-4,-3,-2,-3,4,3,8,5,6,1,-2,3,-2,1,-4,23,-5,-4,-3,-4,-3,-2,-3,12,4,22,4,-2,23,2,33,39,45,53,52,48,45,1,-7,-7,-4,-5,-4,-3,12,-4,-3,-2,-3,25,2,-4,17,47,51,58,49,-1,-3,-1,14,-5,-4,-3,12,-5,-4,-3,-2,1,-5,-4,-3,-2,0,2,34,-3,18,-1,6,43,11,49,53,50,16,21,8,-3,-9,-6,-5,-4,-5,-4,-3,-2,1,-4,-3,-4,-1,-5,26,43,59,0,50,-3,-5,0,-3,-1,-5,-4,-5,-4,-3,1,-4,-3,29,2,3,7,6,50,0,58,-2,-2,-5,-4,20,-5,-4,-3,-4,-3,-8,11,3,7,50,12,47,17,60,57,54,-2,-5,-4,-5,-4,-3,-5,-4,-3,-3,24,4,3,17,16,1,-2,-2,-2,-4,-2,0,-4,-6,-5,-4,-3,9,-6,-5,-4,-3,-6,-5,-4,-3,-2,43,52,52,1,52,1,51,23,-2,15,-10,-4,-6,-5,-4,9,-10,-5,-4,-3,-2,-4,-3,-4,4,14,18,53,-1,-3,-4,-4,-6,-5,-4,-5,-4,-3,-2,-4,-3,8,13,-5,-3,-8,-2,-6,-5,-4,-5,-4,-3,-4,-3,-8,11,32,0,46,57,49,-5,29,29,-3,-6,-5,-4,-5,-4,-3,-5,-4,-3,1,1,3,9,50,53,57,37,0,-2,-5,5,-6,-5,-4,-3,6,-5,-4,-3,-6,-5,-4,-2,8,4,2,0,0,54,54,53,-4,-8,-8,-10,-5,-6,-5,-4,6,-5,-4,-3,-4,-4,36,3,32,50,58,-5,-2,-6,-5,-4,-5,-4,-3,-4,16,52,57,-2,23,26,-4,-10,-6,-5,-4,-5,-4,-3,-4,31,6,24,57,57,60,59,-1,-4,3,-6,-5,-4,14,-6,-5,-4,-3,-6,-5,-4,5,-1,-3,-6,-5,-6,-5,-4,-3,3,-7,-5,-4,-3,-6,-5,-4,-2,1,9,37,43,49,56,55,60,15,3,-3,4,-3,-6,-5,-6,-5,-4,3,-5,-4,-3,-4,4,3,59,11,0,-2,23,-3,-5,-6,-5,-4,-5,-4,-3,-4,7,61,0,0,0,-4,15,-5,-5,-6,-5,-4,-6,-5,-4,-3,-4,12,-6,-4,3,60,13,19,-2,-5,-5,-6,-5,-4,11,-6,-5,-4,-3,-6,-5,-4,-3,34,29,48,54,61,62,9,-7,-6,-5,2,-6,-5,-4,-3,0,-5,-4,-5,-2,43,1,1,1,44,1,62,13,20,24,-4,-7,-6,-5,-6,-5,-4,0,-5,-4,5,21,45,63,-1,-4,-6,-5,-6,-5,-4,-5,-4,-9,-9,11,2,3,59,62,63,33,69,-3,-3,-9,-6,-5,-6,-5,-4,-6,-5,-4,-2,1,1,3,6,53,59,61,64,64,21,-3,-3,-7,-6,-5,-4,8,-6,-5,-4,-7,-6,-5,-4,19,-3,2,4,8,61,63,70,-4,17,19,-4,-11,-7,-6,-5,-6,-5,-4,-3,-5,-4,-5,4,32,65,-2,-6,-4,23,-8,-5,-7,-6,-5,-6,-5,-4,-3,-5,-4,10,5,9,65,14,71,68,-2,-6,3,-9,-7,-6,-5,-6,-5,-4,-5,-4,-9,7,17,-2,64,77,-6,-3,-4,-7,-6,-5,-6,-5,-4,-6,-5,-4,41,3,25,-4,58,67,67,-1,3,-4,-6,-7,-6,-5,-4,-6,-5,-4,-7,-6,-5,-3,-2,4,15,20,78,-1,-6,-7,-6,-5,-1,-6,-5,-4,-5,5,2,10,2,2,2,2,2,0,-3,-6,-6,-7,-6,-5,-6,-5,-4,-5,3,3,15,-3,-7,-6,-5,-6,-5,-4,-5,6,3,32,31,0,21,-4,-5,-8,-8,-7,-6,-5,-7,-6,-5,-4,-7,-6,-5,-4,13,69,-2,13,-4,-7,-6,-7,-6,-5,-4,-6,-5,-7,-6,-5,-3,3,70,-4,-4,-10,-7,-6,-7,-6,-5,-6,-5,-4,-5,4,23,45,65,29,81,-1,-5,-4,-6,-7,-6,-5,-6,-5,-4,-5,5,6,5,-7,17,12,-1,-6,-7,-6,-5,-7,-6,-5,-4,-5,-3,25,1,1,72,-3,-6,-7,-6,-5,-7,-6,-5,-4,-7,-6,-5,-4,2,-2,-3,23,-8,-7,-6,-7,-6,-5,-4,-6,-5,-6,-3,3,5,3,52,15,62,-8,-7,-6,-7,-6,-5,-4,-6,-5,11,3,46,3,23,57,63,11,50,-2,-4,9,-5,-7,-6,-7,-6,-5,-10,-6,-5,-10,7,75,3,-4,-7,-6,-7,-6,-5,-7,-6,-5,3,4,1,1,-5,20,-4,5,-4,-7,-8,-7,-6,-5,-7,-6,-5,-8,-7,-6,-4,9,2,5,26,-5,20,-12,-8,-7,-6,-7,-6,-5,-6,-5,-6,2,4,11,62,68,72,-7,-5,4,-9,-6,-9,-8,-7,-6,-7,-6,-5,-6,-5,11,2,5,77,77,80,-3,-7,0,-6,-8,-7,-6,-7,-6,-5,-6,-5,-10,7,-5,72,68,78,17,-11,-8,-7,-6,-7,-6,-5,-8,-7,-6,-5,14,3,43,0,76,81,5,22,-2,-6,-5,8,-7,-8,-7,-6,-5,-7,-6,-5,-8,-7,-6,-4,4,0,20,25,67,73,79,-2,-7,-8,-7,-6,-7,-6,-5,-6,5,7,13,82,80,79,-7,-3,20,-4,-7,-7,-8,-7,-6,-7,-7,-6,-5,-6,3,5,46,81,88,88,15,-5,14,-4,-8,-7,-6,-6,-5,-6,19,1,17,70,81,-5,-8,-6,-5,-5,2,2,31,12,2,58,89,77,-3,-5,25,-6,-6,-5,-4,3,0,4,81,46,88,85,-14,3,4,9,16,40,3,63,-3,83,83,81,11,-5,-8,2,3,3,24,3,18,91,-2,25,3,4,14,-10,9,85,79,-4,85,5,8,-12,83,-3,-6,12,87,-3,-1,3,87,4,5,3,4,9,0,44,87,88,-5,4,5,15,3,88,85,20,-7,-7,13,1,6,77,54,95,-4,8,-1,2,5,84,90,42,89,-6,-9,-9,3,50,2,-3,1,5,-2,1,34,3,92,25,15,26,6,-1,82,88,87,-5,14,-3,25,98,75,4,8,1,91,98,4,10,1,1,-4,12,34,87,93,99,4,95,-1,2,-3,-6,13,5,19,100,6,93,99,106,97,45,97,97,6,23,107,4,30,32,38,-4,2,26,91,102,5,3,98,95,2,-6,6,4,1,28,23,5,8,2,83,6,71,7,0,97,98,-5,-2,26,102,102,105,105,3,11,101,5,12,104,106,3,43,-1,105,91,97,105,107,12,106,106,-5,17,34,108,43,22,4,5,96,102,108,108,109,1,3,6,26,79,109,5,6,8,22,108,67,110,24,110,110,55,116,110,7,18,107,110,111,9,13,109,117,-5,33,80,112,112,100,2,6,118,7,4,12,4,112,113,124,5,5,73,119,116,5,44,110,125,115,5,18,115,126,123,120,117,-5,37,4,3,3,110,25,2,11,2,7,10,63,1,117,93,51,118,117,5,7,5,5,5,25,108,96,5,6,10,12,3,84,7,111,119,6,117,4,4,4,4,122,122,5,63,116,121,4,6,21,121,7,31,2,5,124,128,125,68,47,121,23,1,4,129,6,10,11,47,104,123,6,92,130,15,4,5,5,26,5,80,127,136,7,6,7,22,11,111,3,137,130,125,43,13,4,113,129,7,5,132,133,25,6,131,5,43,120,133,-1,1,31,125,135,131,140,7,13,4,135,6,24,35,5,88,3,76,9,99,5,136,133,6,9,121,6,3,136,109,14,73,4,140,6,9,7,109,140,7,1,8,35,119,146,19,142,142,5,14,27,114,147,6,9,0,4,6,6,93,147,148,7,72,147,154,145,5,8,6,25,10,20,60,-2,139,155,10,11,142,117,154,151,148,3,16,147,147,105,150,21,5,3,6,146,7,149,8,138,148,13,151,153,5,5,3,6,0,145,154,18,4,6,7,23,153,5,8,5,56,154,155,7,8,3,153,9,4,113,150,156,2,101,155,0,2,89,157,155,157,7,8,155,158,146,28,6,6,157,134,164,7,7,81,151,159,7,165,157,7,13,60,160,7,8,160,166,5,172,4,8,53,52,18,9,24,173,159,97,163,17,85,2,5,145,142,161,9,73,130,22,118,165,4,163,22,167,36,6,81,48,126,114,16,27,30,127,159,159,147,59,65,122,110,33,155,143,53,176,61,94,106,94,73,151,139,172,90,135,123,168,61,140,131,119,164,152,70,115,160,148,107,99,144,120,140,128,124,157,100,120,153,149,133,162,158},{0,0,-1,0,1,0,-1,0,1,-1,1,-1,0,1,0,1,-1,0,1,-1,0,-1,0,-1,0,1,-1,0,1,-1,0,-2,-1,1,-2,2,-1,1,0,1,0,-2,2,-2,2,-2,2,-1,0,1,0,1,-1,2,-2,2,-2,1,2,0,1,0,-1,-2,-1,-1,0,-2,-1,0,1,-1,0,1,0,1,-1,-2,-2,2,-1,1,-1,-2,-3,3,-3,3,3,-2,2,0,1,0,-3,3,-3,3,-3,3,-1,0,1,2,3,-3,3,-3,3,-3,2,3,0,1,-3,1,-1,-2,-1,0,-2,-1,0,1,-1,0,1,0,1,-2,-3,2,0,1,-2,-3,3,4,-3,3,-1,1,-1,-3,4,-4,4,4,-3,3,-2,0,1,-2,-4,4,-4,4,-4,4,-3,3,-1,0,1,2,4,4,-4,4,-4,4,-4,4,-3,3,0,1,-4,3,2,3,1,2,-1,-2,-1,0,-3,-2,-1,0,1,-2,-1,0,1,-1,0,1,-2,-1,-3,2,-3,-1,-2,3,-4,4,-3,3,-2,0,1,-2,-3,5,-4,3,-1,1,-4,5,-5,5,5,-4,-2,0,1,2,5,-5,5,-5,5,-5,5,-4,4,-3,-1,0,1,2,-1,4,5,-5,5,-5,5,-5,5,-5,5,-3,3,1,4,-5,4,3,1,2,-2,-1,-2,-1,0,-3,-2,-1,0,1,-2,-1,0,1,-1,0,1,-2,-3,2,-4,0,1,-2,-3,2,3,4,-4,-1,-2,-3,-4,5,-4,-2,0,2,-3,-4,6,6,-5,-4,-3,-1,1,-5,4,6,7,6,6,-5,-4,4,-2,0,1,2,1,3,5,6,-6,6,-6,6,-6,6,-5,5,-5,-3,0,1,2,3,6,-6,6,-6,6,-6,6,-6,6,-5,4,1,1,4,-5,-6,-6,5,3,1,2,4,-3,2,-3,-4,-2,-1,-3,-2,-1,0,-3,-2,-1,0,1,-2,-1,0,1,-1,0,1,1,-4,2,-4,3,-3,-3,4,4,0,1,-3,-5,-5,-1,1,-3,-3,-4,6,6,-5,-2,0,-5,7,7,-6,-5,-3,-1,3,1,2,0,-4,2,-6,7,7,7,-6,-5,-4,-2,0,1,2,-7,7,-7,7,-7,7,7,-6,-5,-3,0,1,2,3,0,1,3,7,-7,7,-7,7,-7,7,-7,-6,-5,4,1,1,-7,-7,5,3,2,4,-6,5,6,4,3,2,-5,-2,-2,-1,-3,-2,-1,0,-4,-3,-2,-1,0,1,-3,-2,-1,0,1,-1,0,1,0,1,-2,-3,1,3,-1,-4,4,-5,4,-1,-3,-5,-2,0,-3,-5,-6,6,-6,-5,-4,-1,1,-4,-6,-2,0,-3,-1,1,-6,-7,8,-6,-3,4,-1,1,2,-7,8,-7,-4,-2,0,1,2,3,-1,0,-7,8,-8,-8,-8,8,8,-7,-5,-3,0,1,2,3,0,-2,-6,8,8,-8,8,-8,8,-8,8,-8,-7,-5,-2,4,1,3,-8,-8,3,-4,5,4,5,4,1,-2,-3,-2,-1,-3,-2,-1,0,-4,-3,-2,-1,0,1,-3,-2,-1,0,1,-1,0,1,0,1,1,3,0,1,-3,-2,-5,4,4,0,1,-3,-4,-6,-1,1,-3,-4,-6,6,-6,-2,0,-5,-6,-3,-1,1,-5,-7,9,9,-7,-6,-4,-2,0,3,2,-7,10,9,-7,-5,-3,-1,1,2,-2,-1,-8,9,-7,-4,5,-2,0,1,2,3,-1,9,-9,-9,9,9,-8,-5,1,2,3,0,-6,8,9,9,-9,9,-9,9,-9,9,-8,8,-7,-5,5,-5,-9,-9,6,3,0,-4,-2,5,-3,-4,4,3,0,-1,-2,-3,-2,-1,-4,-3,-2,-1,0,-4,-3,-2,-1,0,1,-3,-2,-1,0,1,-1,0,1,0,1,-3,0,1,-5,3,-4,3,-3,0,1,-6,-6,-3,-5,4,-6,-5,0,1,-4,-1,1,-6,-7,-2,0,-8,9,-7,-3,-1,1,-8,10,10,-4,-2,0,2,-8,-9,11,10,-8,-5,-3,-1,4,1,2,3,-2,-9,11,10,-6,-4,-2,1,2,3,-1,10,-10,-10,10,-9,-8,-7,1,2,3,4,8,10,10,-10,10,-10,10,-10,10,-9,9,-7,5,-10,-10,-10,8,6,9,-5,5,3,-7,-1,-2,-3,-2,-1,-3,-2,-1,-4,-3,-2,0,-4,-3,-2,-1,0,1,-3,-2,-1,0,1,-2,-1,0,1,2,0,1,0,1,3,3,0,1,-1,0,1,-6,-7,-1,-5,-7,-2,0,-7,-8,-7,-1,1,2,-6,5,8,9,-7,-6,-2,0,-8,-9,-8,-3,-1,1,3,11,-4,-2,0,2,3,-9,-10,11,-9,-5,-3,2,3,-9,11,11,10,-6,1,2,3,4,5,7,-8,9,-11,1,2,3,4,-3,11,-11,11,-11,11,-11,11,-11,11,-10,10,-9,-7,5,-11,-11,-11,-9,-10,-11,10,-8,5,9,7,-8,-5,-8,-9,2,-2,-3,-2,-1,-4,-3,-2,-4,-3,-4,-3,-2,0,-3,-2,-1,0,1,-2,-1,0,1,2,0,1,1,-3,0,1,-6,3,-5,3,3,-3,0,1,-7,0,1,-4,-6,-1,1,-8,7,-2,0,9,-8,-3,-1,1,8,-4,-2,0,2,12,-10,-9,-5,-3,5,-1,1,12,13,12,-4,-2,4,3,-10,12,2,3,4,4,6,-9,12,11,1,2,3,4,-8,10,2,3,4,-7,11,12,12,-12,12,-12,12,-12,12,11,-10,-9,-7,-4,5,6,-10,-12,-12,-12,-9,7,1,-1,6,-9,-12,5,-11,-9,9,-8,1,-3,-3,-2,-1,-4,-3,-4,-3,-4,-3,-3,-2,-1,0,1,-2,-1,0,1,2,-1,0,1,2,1,1,-6,3,-5,3,-3,-2,-4,-3,-7,0,7,-9,-8,-7,-1,1,-9,9,-2,0,-9,-3,-1,1,-9,-10,11,12,-4,-2,0,2,13,-5,-3,-10,-11,14,-10,-6,3,3,5,13,5,2,3,4,-12,-10,2,3,4,13,2,3,4,5,13,13,-13,13,-13,13,-13,13,-9,6,0,11,-13,-13,-13,-11,7,-13,-13,12,-10,-4,-4,-3,9,0,-3,-2,-4,-3,-2,-1,-4,-3,-4,-4,-3,-3,-2,1,-2,-1,0,1,2,-1,0,1,2,1,1,1,2,0,1,-8,-1,1,-7,-2,0,-9,9,-9,-1,1,-9,-2,0,2,-10,11,-3,-1,1,-10,-4,-2,-11,3,4,-11,15,14,2,3,4,15,2,3,4,5,-13,14,14,-12,-11,2,3,4,5,14,14,-14,14,-14,14,-14,14,-11,-9,6,0,-14,-14,-14,-12,-11,7,11,-14,-14,13,-7,12,-8,-4,9,-1,-3,-3,-2,-4,-3,-1,-5,-4,-5,-4,-4,-3,-3,-2,1,-2,-1,0,1,2,-1,0,1,2,0,1,2,1,-7,-7,1,-8,-5,-4,1,-9,-8,0,1,-8,6,-1,1,9,-2,0,11,-3,-1,1,-10,-4,-2,0,2,-11,-5,-3,-6,-11,-12,15,15,-8,-12,-12,16,-10,3,4,-11,-13,15,2,3,4,-10,16,2,3,4,5,-13,3,4,5,12,-12,15,15,-15,15,-15,15,-15,15,-12,-11,-9,6,7,-15,-15,-15,-15,-13,-11,8,-14,-15,-15,-15,14,14,-10,11,11,12,-14,-7,0,-4,-2,-5,-4,-3,-1,-5,-4,-5,-4,-3,1,-3,-2,-1,0,1,2,-1,0,1,2,0,1,2,-6,-8,-7,0,-4,1,-4,4,-2,-1,-3,-9,0,-8,6,-1,1,2,-10,11,-10,-9,-2,0,-3,-1,1,-11,-4,-2,3,14,-12,11,-12,4,-13,16,10,3,4,2,3,4,5,-11,3,4,5,9,11,13,3,4,5,6,15,16,16,16,16,-16,16,-13,-11,-9,7,-7,-16,-16,-16,-16,-14,-11,8,-6,-16,-16,-16,15,-9,-14,-15,-16,14,-8,-10,-7,12,-14,-5,-4,-5,-4,-5,-4,-5,-4,-3,1,-3,-2,-1,0,1,2,-1,0,1,2,0,1,2,-5,-7,-8,-9,-8,0,1,1,0,1,-1,1,-9,-11,-2,0,-11,9,11,-3,-1,1,-2,0,2,-3,14,-12,-13,4,-14,3,4,5,17,2,3,4,5,8,10,-15,3,4,5,6,17,4,5,6,15,17,17,17,17,-17,17,-13,-11,7,-17,-17,-17,-15,-13,8,10,14,-17,-17,-17,16,-17,14,12,-5,-5,-5,-5,-4,-3,-3,-2,-1,1,-2,-1,0,1,2,0,1,2,1,-6,-8,1,-7,-9,-8,-10,-4,0,1,-11,0,-10,10,-10,-1,1,-2,0,-12,-3,-1,1,-4,-2,-12,-13,13,4,-13,-14,17,-8,18,-10,-15,19,-12,4,-16,3,4,5,7,19,3,4,5,-15,-17,18,3,4,5,6,18,17,-14,4,5,6,18,-17,18,18,18,-18,18,-13,-11,7,8,-16,-18,-18,-18,-13,9,-18,-18,-18,17,17,-17,-9,14,15,-18,-13,14,-13,-6,-5,-5,-3,-3,-2,-2,-1,0,1,2,0,1,2,1,2,-5,-7,-5,4,1,-6,-8,-10,-7,-9,4,-1,1,-3,1,10,0,-10,-1,1,-12,-2,0,2,-11,-3,-13,17,4,5,20,19,-11,3,4,5,18,-13,3,4,5,6,20,-3,4,5,6,-10,-8,4,5,6,7,-9,19,19,19,19,19,-13,-11,-8,8,-19,-19,-19,-15,-13,9,-19,-19,-19,18,18,-18,-12,-19,17,14,15,-13,-9,-14,14,-6,-5,-5,-3,-3,-2,-2,-1,2,-1,0,1,2,1,2,-6,-8,1,2,-5,-7,-10,-9,1,-5,-8,-10,-11,-7,-9,-11,-10,-9,0,1,4,-11,0,1,10,-1,1,-11,-2,0,-3,-1,1,-14,-5,-2,-7,-14,-9,-11,-15,17,-16,21,16,-15,4,5,-17,20,20,3,4,5,6,-17,0,3,4,5,6,-18,-13,-5,4,5,6,7,21,-14,-10,-8,5,6,7,16,18,19,20,20,20,20,20,-13,8,-20,-20,-20,-16,-15,-13,9,-20,-20,-20,19,-20,19,-19,-15,-19,-20,-20,17,-15,-12,-18,-6,-4,-3,-3,-2,-2,-1,2,-1,0,1,2,1,2,-9,-6,1,-7,-11,1,-8,-10,-12,-4,-9,9,-13,10,0,-1,1,2,-11,-14,-12,-2,0,-13,-3,-14,3,-14,16,16,4,21,21,22,-14,9,6,4,5,21,1,4,5,6,4,5,6,-7,4,5,6,7,13,15,20,-19,21,-12,5,6,7,21,21,21,21,21,-15,8,9,18,-21,-21,-17,-15,10,18,-21,-21,-21,20,-21,20,-20,-21,19,-21,-16,-19,-20,-15,17,-12,-19,1,-6,-4,-3,-2,2,-1,0,1,2,3,1,2,-9,-7,4,-11,-4,-6,5,-11,1,-7,-9,-11,-10,9,-1,0,1,-2,1,9,0,-1,1,11,-2,-17,22,5,-18,5,6,23,-3,4,5,6,-19,8,4,5,6,7,12,14,-11,-2,5,6,7,14,5,6,7,8,22,22,22,-7,9,-22,-22,-17,-15,10,14,18,-22,-22,-22,21,21,-21,-18,-17,19,-22,-22,-18,19,-22,17,-15,-6,-4,-3,-2,2,-1,0,1,2,3,0,1,2,2,-9,-9,-7,-11,-10,1,-8,-12,1,-9,-11,9,-13,0,-13,-1,1,-2,0,-3,-7,-15,4,19,21,-15,20,1,5,6,24,-13,-7,4,5,6,7,11,-18,-14,4,5,6,7,24,-15,5,6,7,8,23,-17,6,7,8,23,23,9,-23,-23,-17,-15,-12,10,-23,-23,22,-23,22,22,-19,-17,-14,-23,-23,-23,-23,19,-16,-4,-3,-2,-1,0,2,0,1,2,2,-7,-6,4,-7,-13,-4,1,-12,9,1,1,0,-1,1,-2,-14,-16,-17,23,24,5,-16,25,-3,6,5,6,-11,4,5,6,7,5,6,7,-21,-21,5,6,7,8,25,6,7,8,22,23,24,9,22,-24,-17,11,-24,-24,23,-24,23,-20,-17,-24,22,-24,-24,-24,-24,-14,-2,-2,-1,0,1,2,3,1,2,-8,-13,0,-10,-13,-14,9,-13,-1,1,-12,0,1,-2,1,-4,0,-16,-8,-10,18,-17,-18,17,1,18,15,25,26,-7,6,5,6,7,25,5,6,7,-23,9,5,6,7,8,-1,2,6,7,8,25,6,7,8,9,20,22,-24,-6,10,-19,-17,11,21,22,-25,24,-25,24,-25,24,-21,-19,-25,-25,-25,-25,-23,22,-24,-25,-25,-17,-14,-23,-2,-2,-1,0,3,1,2,-8,1,2,-9,-14,-3,0,-14,1,-13,-15,-15,0,-15,-1,1,2,-15,3,-17,24,-17,25,-3,-11,6,7,26,5,6,7,5,6,7,8,-17,5,6,7,8,-19,6,7,8,9,17,19,-21,7,8,9,10,-19,-17,-11,11,-26,-26,25,-26,25,25,-22,-19,21,23,24,-26,-26,-26,-26,-26,-26,22,-25,-17,-17,-3,-2,-2,-1,0,3,1,2,3,-8,-14,-13,-12,-14,-15,-3,0,-14,1,1,0,18,23,1,26,27,-20,-18,-7,6,7,27,5,6,7,5,6,7,8,28,6,7,8,16,18,27,6,7,8,9,-25,7,8,9,-20,10,-19,-17,12,18,-27,-27,26,-27,26,26,-21,-19,-27,-27,-27,-27,-24,21,24,-27,-27,22,-20,-25,2,-3,-2,-1,3,1,2,3,2,-8,-11,6,-15,-15,1,-15,0,-14,0,1,-17,3,-18,-19,-19,4,-18,-19,-20,-16,21,-21,-22,-3,26,-12,-14,-11,29,25,-16,29,6,7,28,5,6,7,8,27,2,5,6,7,8,26,6,7,8,9,0,3,6,7,8,9,8,9,10,26,27,28,-5,11,25,26,-21,-19,12,-26,27,-28,27,-28,27,-22,-21,-19,-28,-28,-28,-25,-28,-28,24,-21,-22,-3,-2,-1,3,1,2,3,2,-8,2,-13,-12,-11,-1,-14,-15,1,1,0,-15,1,0,17,-17,-19,25,-19,29,29,30,24,29,7,30,28,6,7,8,5,6,7,8,6,7,8,9,-21,14,6,7,8,9,7,8,9,10,8,9,10,11,-28,-21,-19,12,25,27,28,-29,28,-29,28,-23,-21,27,-29,-29,-29,-26,-29,-29,-29,-22,-19,-3,-2,-1,0,1,3,2,3,-10,2,-12,-12,-11,-15,-15,-14,-12,-16,1,-16,-2,1,-16,-17,-17,1,-15,1,-7,-18,29,30,31,30,16,13,7,6,7,8,6,7,8,19,6,7,8,9,-27,30,7,8,9,7,8,9,10,-28,8,9,10,24,26,-16,11,-21,-16,13,25,29,29,-30,29,29,-24,-23,-21,27,-30,-30,-30,-30,-27,-23,27,-30,-30,-30,-22,-28,-29,-30,-19,-27,-28,-1,0,2,3,-7,-11,-13,-12,-15,-17,1,0,-16,0,2,3,-22,30,32,7,32,31,7,8,6,7,8,8,3,6,7,8,9,0,3,6,7,8,9,9,-23,-5,7,8,9,10,-29,-8,4,7,8,9,10,10,21,23,-13,9,10,11,30,-29,-22,-18,-16,12,-23,-21,13,30,30,30,-24,-23,-21,29,-31,-31,-31,-28,-25,-23,-31,-31,-31,27,-31,-30,-22,-1,0,-7,-6,-12,2,-14,-16,-15,-17,1,1,1,-19,18,-21,-19,19,-21,-22,33,33,31,7,8,33,-28,7,9,-23,6,7,8,9,-23,7,8,10,7,8,9,10,20,33,8,9,11,9,10,11,30,31,32,-30,12,29,30,13,31,31,31,-23,-32,-32,-32,-26,29,-32,-32,-32,-32,27,-2,-1,0,1,-7,1,-12,-13,-17,0,-16,-11,-18,-18,-15,1,-18,-17,-17,-19,3,-15,4,-21,-15,-26,-22,-27,33,30,34,-28,21,7,34,8,11,12,-15,14,31,-32,32,32,32,32,-23,-33,-33,-33,-27,-33,-33,-33,-31,-33,-33,-2,3,-7,-14,-16,7,-17,-16,1,-20,-21,24,31,34,34,22,27,26,35,7,7,8,8,-31,-26,-32,13,14,33,33,33,-23,32,-34,-34,-34,-28,-25,28,-34,-34,-34,-34,-32,-24,-33,-34,-34,-34,-2,-1,2,3,-7,-14,-8,-16,-15,-18,2,-15,-17,-4,-6,1,-20,-20,-22,-23,-24,-24,-25,31,-23,32,-25,-25,7,8,35,28,13,14,29,34,34,34,34,-35,-35,-29,-25,32,-35,-35,-35,-35,-33,-35,-35,-35,30,-33,-34,-35,-24,-34,-33,-24,-2,-1,2,3,2,-14,-11,-16,-15,-19,-12,-18,-17,-20,-20,-1,-21,2,-22,3,23,-24,7,-23,35,-21,25,27,-9,34,35,36,32,33,-34,-32,-14,15,35,35,35,34,-36,-36,-36,-36,-34,32,-36,-36,-36,-36,-27,4,-11,3,-16,-19,-18,-19,-20,1,-18,0,-22,16,-23,38,38,37,-31,8,9,24,37,37,15,32,35,36,-36,36,36,-36,-37,-37,-37,-37,-32,-37,-37,-37,-28,32,-37,-27,0,4,0,-11,-10,-17,2,-20,-20,-14,-19,-16,1,-21,3,19,-23,-27,29,-28,34,31,28,38,33,-27,14,8,15,9,15,37,37,37,37,-32,-27,32,-38,-38,-38,-33,-29,-26,-38,-38,-38,-37,-38,0,4,4,3,-6,-11,-13,-7,-11,-20,-19,1,-24,29,15,37,39,17,40,-8,-5,-37,39,-13,38,37,-30,-27,-39,-39,-39,-34,-29,35,-39,-39,-39,-39,-38,-38,-39,-39,-26,-37,1,4,3,-6,3,8,-20,-21,-20,1,-23,25,24,29,-33,40,-34,39,32,39,40,36,37,39,40,33,35,39,-38,37,-40,-40,-35,-40,-40,-40,-40,-39,35,-40,-40,-29,-38,-39,-38,1,4,4,-6,-20,-19,2,-21,1,2,3,7,12,13,29,31,41,39,35,39,-41,-41,-33,37,-41,-41,-41,-40,-41,-41,-29,2,4,-15,1,-20,-19,-19,-21,-10,-21,-25,-29,-8,37,36,43,42,28,-4,42,-40,-12,-29,-26,35,-42,-42,-34,-31,-42,-42,-42,-38,37,-42,-42,-42,-35,-1,2,4,2,-15,3,-20,-18,-12,-6,-22,-24,1,2,-25,3,-29,-33,23,44,43,42,-43,-35,-31,-43,-43,-43,-39,-43,-43,-43,-43,-43,-1,7,-18,-15,-22,-22,2,20,45,41,45,43,44,-42,39,40,43,44,44,39,-23,42,-36,40,-44,-44,-44,-40,-43,-44,-44,-44,-44,-31,-42,-43,-44,-44,-43,-42,0,3,4,-23,-21,-22,-25,-26,-31,-28,38,45,19,-40,39,20,-41,-42,0,36,45,45,-11,37,39,44,40,-25,42,-45,-45,-45,-41,-45,-45,-45,-45,-34,-45,-45,-37,-44,-31,0,3,4,3,-10,3,2,3,-23,-24,-15,-25,2,26,0,6,7,43,46,45,33,46,-43,-33,42,-46,-46,-46,-39,-35,-46,-46,-46,-46,-46,-46,-34,1,4,-10,-24,-22,-17,-23,-24,-11,-5,1,-28,-38,30,47,29,32,47,43,47,47,-22,-19,-46,-36,-47,-47,-47,-40,-47,-47,-47,-44,-47,-47,-41,1,-24,-23,-24,1,0,3,0,-34,-35,-32,48,43,47,48,43,44,47,48,48,43,47,45,-47,-43,-48,-48,-41,-48,-48,-48,-45,-48,-48,-48,5,-5,-21,-19,3,-25,-25,-24,-5,1,-27,-29,-31,50,49,38,46,-44,49,49,49,49,47,-48,45,-49,-42,-49,-49,-49,-49,-46,-36,-49,-49,-49,-47,-48,-49,-46,-47,5,2,4,-19,-26,-26,-25,-24,2,-2,-3,21,0,-30,-34,-17,-40,47,-41,51,49,48,40,50,50,-48,41,-21,-48,47,-35,-40,-37,-50,-50,-50,-47,-50,-50,-50,-50,-36,-49,2,5,4,4,2,-19,-26,-18,-25,-10,-4,20,1,2,2,-29,-4,6,3,52,37,51,51,-49,47,-41,-51,-51,-51,-45,-51,-51,-51,-51,5,3,-14,-25,3,-27,-26,-28,-29,-32,27,-31,-33,-34,52,28,-46,-47,45,-47,52,47,52,52,52,46,50,-51,-42,-52,-52,-52,-46,-52,-52,-52,-50,-52,-52,0,5,3,5,3,-25,-24,-27,-11,-29,2,-30,-1,-31,3,-11,-33,3,40,48,54,53,53,53,52,-50,-51,50,-34,-53,-53,-53,-47,-53,-53,-53,-53,-51,-52,-53,-53,-53,5,4,-25,-27,-18,-27,1,-32,-1,-9,-43,-43,53,-45,54,54,54,52,-52,50,-39,-54,-54,-48,-41,-54,-54,-54,-54,-52,-54,-54,-54,-52,-53,-54,-52,1,5,4,3,-25,-23,-27,-29,-31,-31,-33,-38,-35,-43,56,45,55,-44,44,55,55,55,45,52,-42,-55,-46,-55,-55,-55,-53,-55,-55,-55,-41,-55,1,4,5,4,-23,-16,-26,13,-28,-1,2,-19,6,56,47,41,56,56,56,56,50,-33,52,-55,-56,-47,-56,-56,-56,-51,-56,-56,-56,-56,-42,-41,-50,2,5,4,-26,-17,1,-39,2,57,37,50,-53,-54,57,57,57,57,-55,55,-56,-48,-57,-57,-57,-52,-57,-57,-57,-57,2,5,-18,-28,-29,3,-31,1,-10,-33,-37,-38,-39,-35,-37,56,58,42,53,52,59,58,58,58,57,55,-41,-54,-58,-58,-58,-53,-58,-58,-58,-58,-57,-57,-58,-58,-56,-30,-31,-25,59,-52,59,59,59,57,-32,55,-47,-59,-59,-59,-54,-59,-59,-59,-59,-58,-59,-59,-58,-57,3,3,4,-15,-30,-31,-31,1,-34,-35,-47,43,60,60,60,60,49,53,57,-48,-60,-60,-60,-60,-60,-59,-60,-60,3,5,-29,-27,-31,-30,3,-13,2,-34,-1,6,-37,45,61,61,61,61,60,-29,53,57,-40,-61,-61,-53,-61,-61,-61,-61,-61,1,4,5,5,-27,-31,-29,-31,-31,-1,27,-48,-53,49,-54,54,62,62,62,62,60,-62,-54,-62,-62,-62,-58,-62,-62,-62,-62,5,1,6,4,4,-28,4,-32,-31,-7,-9,-1,-38,60,63,55,64,36,37,64,49,64,63,63,63,56,62,60,-62,-48,-63,-63,-63,-63,-59,-62,-63,-63,-63,-63,-61,-62,-63,-63,-61,6,-9,4,-14,-32,-22,-12,2,-24,60,64,63,-59,64,-60,64,64,64,-61,57,56,62,60,-64,-64,-64,-60,-64,-64,-64,-64,-57,-64,-64,-48,-63,-63,2,6,5,5,-23,-32,0,-44,65,65,65,53,56,62,-62,-54,-65,-65,-65,-65,-65,-65,-65,-49,-65,-65,2,5,-4,4,-26,-33,-15,-17,5,-15,66,-57,49,65,62,-64,-65,-66,-66,-66,-59,-66,-66,-66,-66,-66,-60,3,5,-18,-32,-34,-36,1,-40,68,67,-57,51,65,-67,-67,-60,-67,-67,-67,-64,-67,-67,-67,3,5,-7,-30,-32,-31,-35,-36,-13,-34,-7,-36,-8,1,-40,69,58,65,-68,-65,-68,-68,-68,-68,-65,-68,-68,-68,-66,-67,-68,-65,-66,-13,-27,4,-35,-34,-36,-25,-25,-25,-10,-23,-53,-57,65,-67,-68,-69,-69,-69,-69,-66,-69,-69,-69,-69,-68,1,4,-27,3,-41,-51,-52,-53,70,60,71,-60,-70,-70,-70,-70,-70,-70,-70,1,5,-33,1,5,-10,-14,-63,-66,-71,-71,-71,-65,-71,-71,-71,-71,-22,-6,-35,-36,-33,4,-37,-12,-6,-39,0,3,2,2,-49,-59,-60,71,-69,-72,-72,-72,-66,-72,-72,-72,-72,-70,-71,-72,-72,-72,5,-36,-36,-37,-1,-44,73,56,-69,-73,-73,-73,-73,-73,-73,-71,-73,-73,-73,-71,-72,-73,-71,5,-34,-36,-35,-32,-37,-43,2,-22,-62,74,64,-66,-74,-74,-74,-74,-72,-74,-74,-74,-74,-31,-35,-33,-39,-42,-45,-51,71,75,-73,-75,-66,-75,-75,-75,-75,-75,-75,-75,-3,-31,-5,-34,-38,-20,-41,-11,-5,1,5,2,-7,-13,73,-72,-73,-75,-76,-76,-76,-71,-76,-76,-76,-76,5,-39,-38,-26,1,-2,5,-19,-58,77,-64,-66,-77,-77,-77,-72,-77,-77,-77,-77,-76,-76,-77,-77,-75,-75,-40,4,-39,-25,-41,-41,-4,-43,-4,2,-6,-45,-47,71,-71,-76,-78,-78,-78,-78,-78,-78,-78,-77,-78,-78,-77,-76,-39,-19,3,5,-54,-19,78,80,77,-71,-75,-79,-79,-79,-79,-79,-78,-79,-79,5,-40,-39,-38,-40,2,-54,1,79,80,-80,-80,-72,-80,-80,-80,-80,-80,-74,-33,-42,-43,3,-45,-12,-47,5,-3,-11,-67,-81,-81,-81,-81,-81,-81,-81,-81,-81,6,-35,-42,-29,-31,-50,-65,-66,-67,82,82,81,-81,-82,-82,-82,-82,-78,-81,-82,-82,-82,-80,-81,-82,-82,-80,-6,2,3,-48,-1,-49,-3,-46,83,72,-76,-80,-83,-83,-83,-79,-77,-83,-83,-83,-83,-83,-83,-82,-41,-32,-49,-16,-63,84,-72,-73,-84,-84,-84,-84,-84,-84,-84,-84,-84,-39,72,86,85,-84,-84,-85,-85,-85,-85,-85,-85,-85,-85,-79,-23,5,-41,-5,4,-11,87,63,65,-76,-79,-86,-86,-86,-86,-86,-86,-86,-86,-41,-43,-43,30,-2,3,1,-28,-59,86,-87,-84,-87,-87,-87,-87,-84,-87,-87,-87,-85,-86,-87,-85,-25,-39,-44,-46,-47,1,0,-2,88,-85,-86,-86,-88,-88,-88,-88,-85,-88,-88,-88,-88,-87,5,-47,-15,3,1,-70,-72,-89,-89,-89,-89,-89,-89,-89,-22,3,-3,-54,70,69,-85,-88,-90,-90,-90,-90,-90,-90,-90,6,-34,-27,2,3,4,1,-68,-85,-86,-91,-91,-91,-85,-91,-91,-91,-91,-90,-91,-91,-50,-68,92,-92,-92,-92,-92,-92,-92,-90,-90,-92,-92,-92,-90,-91,-92,-90,-45,-41,-14,-8,-2,3,-1,1,-55,87,93,88,-81,-93,-93,-93,-93,-93,-91,-93,-93,-93,-93,-43,-47,2,-54,-64,93,75,-79,-94,-94,-94,-94,-94,-94,-94,-94,-53,1,-62,-63,-64,95,82,-94,-95,-95,-95,-95,-95,-95,-95,-95,-95,-40,-49,-51,-52,3,-52,-52,-77,-85,-86,-96,-96,-96,-91,-96,-96,-96,-96,-95,-96,-96,-94,6,-26,-7,-1,2,1,89,-97,-97,-97,-95,-97,-97,-97,-97,-96,-97,-97,-96,-95,5,-51,-52,-53,-13,-54,-12,85,81,80,-90,-92,-98,-98,-98,-98,-98,-97,-98,-98,-48,-33,-17,1,-73,99,-99,-99,-99,-99,-99,-99,-99,-94,-93,-20,-51,-51,3,2,2,-34,4,100,-86,-98,-100,-100,-100,-100,-100,-100,-100,-100,-46,-49,-50,-51,-47,-6,0,3,3,1,-51,101,-86,-101,-101,-101,-101,-97,-101,-101,-101,-99,-100,-101,-101,-92,-99,-51,-50,-54,0,3,4,102,87,87,-96,-97,-102,-102,-102,-102,-102,-102,-102,-102,-102,-101,-53,-26,2,-82,104,103,83,-89,-99,-103,-103,-103,-103,-103,-103,-103,-103,-103,-39,-51,-55,3,-57,4,-4,-82,105,99,-103,-104,-104,-104,-104,-104,-104,-104,-104,-98,-38,-40,-57,1,7,106,104,-95,-105,-105,-105,-105,-105,-105,-105,-105,-105,6,-52,-34,-54,-5,3,-21,-78,100,-92,-106,-106,-106,-106,-106,-106,-106,-106,-104,-105,-106,-104,-104,-51,-59,-61,7,-76,-107,-107,-107,-107,-106,-107,-107,-107,-107,-47,-55,-48,-56,-57,-58,-59,-60,105,-91,-98,-99,-108,-108,-108,-108,-108,-108,-108,-55,-56,-58,-83,-109,-109,-109,-109,-109,-109,-109,-46,-56,-30,-32,-67,-63,110,-104,-104,-105,-110,-110,-110,-110,-110,-110,-110,-109,-110,-110,-108,-47,2,-87,98,111,-111,-111,-111,-111,-111,-111,-111,-111,-109,-110,-111,-109,-56,3,112,-100,-110,-112,-112,-112,-112,-112,-112,-112,-112,-112,-55,-40,-20,4,-40,9,-83,113,-100,-113,-113,-113,-113,-113,-113,-113,-113,-51,-55,-57,-61,-57,-65,-83,-114,-114,-114,-114,-114,-114,-114,-114,-114,-113,-11,-56,-57,4,-96,-113,-115,-115,-115,-115,-115,-115,-115,-114,-115,-115,-113,-58,-59,-96,96,-116,-116,-116,-116,-116,-116,-116,-116,-116,-115,-114,-59,-57,-61,-16,-64,-20,-117,-117,-117,-117,-117,-117,-117,-117,-117,-32,-60,-3,-61,-42,-9,-3,-63,-37,-92,118,109,-105,-118,-118,-118,-118,-118,-114,-118,-118,-112,-62,-5,113,119,-119,-119,-119,-119,-119,-119,-119,-119,-60,-59,-72,-73,120,102,120,114,-105,-111,-120,-120,-120,-120,-120,-120,-120,-118,-119,-120,-118,-41,-57,-55,-41,121,105,-117,-121,-121,-121,-121,-121,-121,-121,-121,-120,-62,-62,-64,-8,-2,4,123,122,116,-117,-118,-118,-122,-122,-122,-122,-122,-122,-122,-122,-55,-63,-64,3,4,3,-101,124,119,-102,-123,-123,-123,-123,-123,-123,-123,-123,-117,-50,-66,-2,-10,-2,108,-122,-124,-124,-124,-124,-124,-124,-123,-124,-124,-124,-29,-66,-28,-70,1,3,-75,-70,-97,125,-114,-119,-125,-125,-125,-125,-125,-125,-125,-125,-123,-124,-125,-123,-63,-64,-48,-46,-7,-1,1,-97,-126,-126,-126,-126,-126,-126,-126,-126,-59,-63,-63,3,-14,-16,128,125,109,-110,-126,-127,-127,-127,-127,-128,-127,-127,-127,-127,-64,-62,-27,-1,8,6,112,128,114,-110,-128,-128,-128,-128,-128,-128,-28,-63,-54,-9,1,129,-129,-129,-129,-127,-64,-65,-41,-69,-75,-26,6,-24,-106,130,110,-117,-118,-130,-128,-66,-65,-67,2,-43,2,-6,-127,-67,-67,-62,-55,-20,-71,-14,-73,1,-11,-15,120,-119,-124,-65,-68,-69,-49,-70,-73,8,-102,110,127,-67,-72,-130,-63,1,-23,-115,4,127,126,-134,-14,-111,-128,-62,2,-111,-70,-76,-5,-68,-67,-71,-72,-69,-73,-35,3,-20,-124,-71,-70,125,-71,4,-13,125,-130,-131,-45,-69,-75,-4,-32,7,-115,-58,-68,-72,-73,-2,4,-49,-4,-133,-136,-137,-73,-30,-83,-116,-70,-71,-70,-73,-37,-81,-7,123,132,-134,-67,-73,-3,3,-12,-129,-39,-72,-56,7,-29,-75,-70,-75,-3,5,-76,-70,-77,-79,-125,-48,-49,-2,4,5,-76,4,-86,-90,-121,-137,-69,-78,-63,5,-71,-2,1,8,-16,-42,4,5,-77,-55,8,-79,-56,-55,-55,-130,-79,-72,-3,6,-79,-80,5,-1,-95,-143,-75,-80,-80,-54,-64,-83,-82,-86,-18,-80,-35,-74,-81,5,1,-139,-81,-63,4,5,6,4,-81,-77,5,-83,-73,4,4,-96,-50,-89,0,-5,1,5,4,-87,4,3,-144,-72,-61,4,-26,-78,-87,-87,-4,2,4,3,4,-99,-85,-83,-69,-24,5,-84,-86,-86,-71,5,-41,4,-71,4,3,-58,7,-9,-85,-77,3,5,4,-85,-92,3,7,-147,-64,-23,5,4,-21,-86,-87,7,-83,-91,-84,-96,4,-6,10,-91,-92,-31,7,-1,-92,-57,1,10,-18,-92,-84,5,10,2,-6,-14,-154,-43,-92,-94,-95,6,-99,-90,-96,-95,-95,-92,-47,-102,6,-17,-64,-15,-17,-95,-93,-97,-96,-97,-78,-10,-27,-96,-95,-92,-91,-110,-44,-91,0,-16,-98,6,-99,-100,-101,-102,5,6,-102,-46,1,2,-97,-99,-105,-15,-95,-60,-97,-100,4,6,-6,-45,-70,2,-86,-105,-111,6,-103,-104,-104,-65,-16,-14,-103,-33,6,-79,-101,-104,-105,-85,-106,-50,-5,9,-99,-103,-104,-110,-99,-11,-115,9,6,-13,-72,-108,-116,-30,-4,-103,-107,5,5,-77,-107,6,-107,-76,-2,6,-108,-110,-93,-3,5,-3,9,-109,-110,-121,6,-108,-93,-84,-117,-39,-106,-56,-107,-28,-111,4,-2,-111,-109,-19,-112,-118,6,-36,-95,-53,-126,-4,-112,-108,-114,-20,6,-111,-113,-107,-87,-14,8,-94,6,7,-114,-107,-99,-19,8,-115,-116,-121,-115,-116,-117,-39,8,8,-115,-62,4,11,-13,-113,-111,-116,-100,-118,-122,-79,-120,0,11,-114,-115,7,-25,7,-1,-9,-118,-122,6,7,-42,8,-106,-117,-121,-128,7,-119,6,-115,-22,4,-111,6,7,-120,-131,-118,-122,-125,4,7,-85,-122,-123,-123,-108,6,-121,-119,-123,-85,7,7,-123,-122,-123,7,-118,-127,-31,5,7,-124,-48,7,-124,-134,-65,7,-18,7,-124,-123,6,7,-11,-83,-127,-132,6,-28,10,-127,-128,-61,0,7,-128,10,-17,-128,-122,-81,7,-128,-129,7,10,-134,13,-126,-127,-89,-91,-134,-123,-115,13,-16,-54,-7,-101,-71,-137,-146,-11,-17,-15,-127,-75,-34,-100,-51,-6,-147,-14,-123,-5,-114,-147,-77,-103,-40,-57,-117,-123,-121,-35,-8,-20,-37,-100,-100,-46,-63,-125,-26,-43,-111,-23,-106,-77,-69,-86,-97,-32,-49,-29,-92,-55,-72,-35,-119,-51,-61,-78,-41,-58,-121,-84,-47,-64,-93,-107,-70,-87,-76,-93,-99,-79,-123,-109,-85,-91,-114,-100,-106}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test zonotope/6.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1},{0,0,2,0,2,2,0,0,2,2,2,2,2,0,0,0},{0,4,4,0,0,4,4,0,0,4,0,4,0,4,0,4},{0,0,8,8,0,8,0,8,0,0,8,0,8,8,0,8}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},{0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4},{0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test zonotope/8.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{2,4,5,-1,1,4,3,2,5,0,-5,0,-2,1,-3,4,-7,-3,-2,-4,5,-9,-4,2,5,-11,2,-1,-10,-12,2,-7,0,3,-2,-4,0,0,-9,-12,0,-12,-3,-6,2,-1,-7,-6,-7,-9,-4,-4,-1,-11,-9,-12,-9,-11,-3,-5,-8,-6,-7,-10,-5,-3,-8,-4,-7,-3,-6,-9},{-2,0,1,-4,-1,3,4,-3,-1,6,-3,-3,-3,1,-4,2,-3,7,-1,-4,2,-1,7,-2,0,0,5,7,-1,1,4,-1,-2,0,6,-1,0,4,6,4,2,2,-3,-4,4,6,6,7,1,5,6,1,3,3,-2,3,5,1,-2,6,4,-3,5,3,4,4,2,5,3,2,0,-1},{0,-1,0,0,-3,0,0,2,2,1,-1,4,-3,-5,2,-3,1,0,-5,2,3,-2,0,5,5,2,-3,-2,2,-1,4,-4,7,7,3,-6,9,6,0,0,8,2,6,4,-6,-5,-2,2,-6,2,-4,-8,-8,3,5,-3,-3,5,9,5,5,7,-5,-5,7,8,7,-7,-7,10,10,8}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5},{1,2,2,2,2,2,3,3,3,3,3,4,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,5,5,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,6,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,-1,0,0,0,0,0,1,1,1,1,1,2},{-1,-2,-1,0,1,2,-3,-2,-1,0,1,0,1,2,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-3,-2,-1,0,1,2,-1,0,5,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,0,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,8,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,3,-1,0,1,1,2,3,4,5,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,4,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,2,3,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,1,2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,8,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,0,2,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,3,0,1,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,3,-1,0,-1,0,1,2,3,4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,-2,0,1,2,3,4,-2,-1,0,1,2,3,4,5,6,7,-3,-2,-1,0,1,2,3,4,5,6,7,8,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,1,2,3,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,2,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-3,2,3,0,1,2,3,4,5,-2,-1,0,1,2,3,4,5,6,7,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-4,-3,-2,-1,0,1,2,3,4,-1,0,1,2,3,4,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,0,1,2,1,2,3,4,5,0,1,2,3,4,3}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test zonotope/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1/2,-1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2},{-1,-1,1,1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1},{-2,-2,-2,-2,2,2,2,2,2,-2,-2,-2,-2,2,2,2},{-4,-4,-4,-4,-4,4,4,4,4,4,4,4,4,-4,-4,-4}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},{-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},{-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test zonotope/9.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{0,2,0,2,0,2,0,2,0,2,0,2},{0,0,2,2,4,4,0,0,2,2,4,4},{0,0,2,2,0,0,-2,-2,-4,-4,-2,-2}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},{0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4},{-2,-1,0,-3,-2,-1,0,1,-4,-3,-2,-1,0,1,2,-3,-2,-1,0,1,-2,-1,0,-2,-1,0,-3,-2,-1,0,1,-4,-3,-2,-1,0,1,2,-3,-2,-1,0,1,-2,-1,0,-2,-1,0,-3,-2,-1,0,1,-4,-3,-2,-1,0,1,2,-3,-2,-1,0,1,-2,-1,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test SIMPLICITY/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{0,1,0,0,0},{1,0,0,0,0},{0,0,1,0,2}};
desiredHB = matrix {{1,1,1,1,1},{0,0,0,0,1},{0,0,0,1,0},{0,1,2,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test SIMPLICITY/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1},{0,1,0,0},{1,0,0,0},{0,0,1,0}};
desiredHB = matrix {{1,1,1,1},{0,0,0,1},{0,0,1,0},{0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VERTEX_LABELS/Q4.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-4/29,-1/2,0,1/19,1/12,19/30,-7/12,1/2,2/3,1/6,4/29,3/19,2/3,2/29,0,0,1/2,7/12,-1/19,-2/29,-19/30,-1/12,-1/2,-2/3,-1/6,-2/3,-3/19},{2/29,-1/2,0,3/19,1/6,2/3,2/3,1/2,-19/30,-1/12,-2/29,-1/19,7/12,4/29,0,0,-1/2,-2/3,-3/19,-4/29,-2/3,-1/6,1/2,19/30,1/12,-7/12,1/19},{-5/29,2,1,3/19,1/4,19/10,-7/4,2,-19/10,-1/4,-5/29,-3/19,7/4,5/29,0,-1,-2,-7/4,3/19,5/29,19/10,1/4,-2,-19/10,-1/4,7/4,-3/19},{8/29,-1/2,0,5/19,1/4,-1/2,-1/2,-1/2,-1/2,1/4,8/29,5/19,-1/2,8/29,1/3,0,-1/2,-1/2,5/19,8/29,-1/2,1/4,-1/2,-1/2,1/4,-1/2,5/19}};
desiredHB = matrix {{1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,25,25,25,25,26,26,26,26,27,27,27,27,28,28,28,28,29,29,29,29,29,29,29,29,30,30,30,30},{0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,0,0,0,1,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,2,2,2,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,0,0,0,0,1,1,1,2,2,2,2,2,2,3,3,3,3,3,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,-4,-4,-4,-4,-3,-3,-2,-2,-2,-2,2,2,2,2,3,3,4,4,4,4,-5,-5,-5,-5,-4,-4,-3,-3,-3,-3,-2,-1,-1,0,0,1,1,2,3,3,3,3,4,4,5,5,5,5,-5,-5,-4,-4,-4,-4,-3,-2,-1,-1,1,1,2,3,4,4,4,4,5,5,-6,-6,-5,-5,-5,-5,-4,-3,-2,-1,1,2,3,4,5,5,5,5,6,6,-7,-7,-6,-6,-6,-6,-5,-4,-3,-2,-1,-1,1,1,2,3,4,5,6,6,6,6,7,7,-8,-8,-7,-7,-7,-7,-6,-5,-4,-3,-2,-1,1,2,3,4,5,6,7,7,7,7,8,8,-8,-8,-7,-6,-5,-4,-3,-2,2,3,4,5,6,7,8,8,-9,-9,-8,-7,-6,-5,-4,-3,3,4,5,6,7,8,9,9,-9,-8,-7,-6,-5,-4,-2,-2,-1,0,0,1,2,2,4,5,6,7,8,9,-10,-9,-8,-7,-6,-5,5,6,7,8,9,10,-11,-10,-9,-8,-7,-6,6,7,8,9,10,11,-12,-11,-10,-9,-8,-7,7,8,9,10,11,12,-11,-10,-9,-8,-3,-1,1,3,8,9,10,11,-12,-11,-10,-9,9,10,11,12,-13,-12,-11,-10,10,11,12,13,-14,-13,-12,-11,11,12,13,14,-15,-14,-13,-12,12,13,14,15,-16,-15,-14,-13,13,14,15,16,-15,-14,14,15,-16,-15,15,16,-17,-16,16,17,-18,-17,17,18,-19,-18,-4,-2,2,4,18,19,-20,-19,19,20},{0,0,0,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,0,-1,0,1,0,-1,0,1,-2,-1,-1,1,1,2,-2,2,-2,-1,-1,1,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-2,2,2,3,-3,0,3,-3,-1,1,3,-3,0,3,-3,-2,-2,2,2,3,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-4,-3,-3,3,3,4,-4,-1,1,4,-4,-2,-1,1,2,4,-4,4,-4,-2,-1,1,2,4,-4,-1,1,4,-4,-3,-3,3,3,4,-3,-2,-1,0,1,2,3,-4,-4,4,4,-2,2,-3,-2,2,3,-3,-2,2,3,-2,2,-4,-4,4,4,-5,-5,5,5,-3,3,-4,-3,3,4,1,-2,0,-1,1,0,2,-1,-4,-3,3,4,-3,3,-5,-5,5,5,-4,4,-5,-4,4,5,2,-3,-1,1,-1,1,3,-2,-5,-4,4,5,-4,4,-5,5,-6,-5,5,6,3,-4,1,-2,2,-1,4,-3,-6,-5,5,6,-5,5,-6,6,-7,-6,6,7,4,-5,2,-3,-1,1,-1,1,3,-2,5,-4,-7,-6,6,7,-6,6,-7,7,-8,-7,7,8,5,-6,3,-4,1,-2,2,-1,4,-3,6,-5,-8,-7,7,8,-7,7,-8,8,6,-7,4,-5,2,-3,3,-2,5,-4,7,-6,-8,8,-9,9,7,-8,5,-6,3,-4,4,-3,6,-5,8,-7,-9,9,8,-9,6,-7,4,-5,0,1,-2,-2,2,2,-1,0,5,-4,7,-6,9,-8,9,-10,7,-8,5,-6,6,-5,8,-7,10,-9,10,-11,8,-9,6,-7,7,-6,9,-8,11,-10,11,-12,9,-10,7,-8,8,-7,10,-9,12,-11,10,-11,8,-9,1,-3,3,-1,9,-8,11,-10,11,-12,9,-10,10,-9,12,-11,12,-13,10,-11,11,-10,13,-12,13,-14,11,-12,12,-11,14,-13,14,-15,12,-13,13,-12,15,-14,15,-16,13,-14,14,-13,16,-15,14,-15,15,-14,15,-16,16,-15,16,-17,17,-16,17,-18,18,-17,18,-19,2,-4,4,-2,19,-18,19,-20,20,-19},{-1,0,1,2,3,4,-1,0,1,-4,-3,-2,-1,0,1,-4,-3,-2,-1,0,1,2,3,4,-1,0,1,-4,-3,-2,-1,0,1,2,3,4,0,0,0,0,0,3,0,-3,3,2,3,-3,-2,-3,0,0,-3,-3,-2,2,3,3,-3,0,3,6,3,0,-3,-6,6,5,6,-6,-5,-6,3,0,-3,0,0,0,0,-3,0,3,-6,-6,-5,5,6,6,-6,-3,0,3,6,9,6,3,0,-3,-6,-9,9,8,9,-9,-8,-9,6,3,-3,-6,3,3,2,-2,-3,-3,0,0,-3,-3,-2,2,3,3,-6,-3,3,6,-9,-9,-8,8,9,9,-9,-6,-3,0,3,6,9,11,12,-12,-11,6,-6,6,5,-5,-6,-6,-5,5,6,-6,6,-12,-11,11,12,14,15,-15,-14,9,-9,9,8,-8,-9,-3,3,-1,1,1,-1,3,-3,-9,-8,8,9,-9,9,-15,-14,14,15,12,-12,12,11,-11,-12,-6,6,1,-1,-1,1,6,-6,-12,-11,11,12,-12,12,15,-15,15,14,-14,-15,-9,9,-3,3,3,-3,9,-9,-15,-14,14,15,-15,15,18,-18,18,17,-17,-18,-12,12,-6,6,1,-1,-1,1,6,-6,12,-12,-18,-17,17,18,-18,18,21,-21,21,20,-20,-21,-15,15,-9,9,-3,3,3,-3,9,-9,15,-15,-21,-20,20,21,-21,21,23,-23,-18,18,-12,12,-6,6,6,-6,12,-12,18,-18,-23,23,26,-26,-21,21,-15,15,-9,9,9,-9,15,-15,21,-21,-26,26,-24,24,-18,18,-12,12,-1,-2,2,1,1,2,-2,-1,12,-12,18,-18,24,-24,-27,27,-21,21,-15,15,15,-15,21,-21,27,-27,-30,30,-24,24,-18,18,18,-18,24,-24,30,-30,-33,33,-27,27,-21,21,21,-21,27,-27,33,-33,-30,30,-24,24,-3,3,3,-3,24,-24,30,-30,-33,33,-27,27,27,-27,33,-33,-36,36,-30,30,30,-30,36,-36,-39,39,-33,33,33,-33,39,-39,-42,42,-36,36,36,-36,42,-42,-45,45,-39,39,39,-39,45,-45,-42,42,42,-42,-45,45,45,-45,-48,48,48,-48,-51,51,51,-51,-54,54,-5,5,5,-5,54,-54,-57,57,57,-57},{0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,1,0,0,-1,-1,-1,-1,0,0,0,0,-1,-1,-1,-1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-2,-2,1,-2,-2,1,1,-2,-2,1,-2,-2,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-3,-3,0,0,-3,-3,0,1,1,0,-3,-3,-3,-3,0,1,1,0,-3,-3,0,0,-3,-3,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,-1,-1,0,0,-1,-1,0,0,-1,-1,-1,-3,-3,-3,-3,-4,-4,-4,-4,-2,-2,-2,-1,-1,-2,1,1,2,2,2,2,1,1,-2,-1,-1,-2,-2,-2,-4,-4,-4,-4,-3,-3,-3,-2,-2,-3,0,0,2,2,2,2,0,0,-3,-2,-2,-3,-3,-3,-4,-4,-4,-3,-3,-4,-1,-1,2,2,2,2,-1,-1,-4,-3,-3,-4,-4,-4,-5,-5,-5,-4,-4,-5,-2,-2,1,1,3,3,3,3,1,1,-2,-2,-5,-4,-4,-5,-5,-5,-6,-6,-6,-5,-5,-6,-3,-3,0,0,3,3,3,3,0,0,-3,-3,-6,-5,-5,-6,-6,-6,-6,-6,-4,-4,-1,-1,2,2,2,2,-1,-1,-4,-4,-6,-6,-7,-7,-5,-5,-2,-2,1,1,1,1,-2,-2,-5,-5,-7,-7,-6,-6,-3,-3,0,0,4,4,4,4,4,4,4,4,0,0,-3,-3,-6,-6,-7,-7,-4,-4,-1,-1,-1,-1,-4,-4,-7,-7,-8,-8,-5,-5,-2,-2,-2,-2,-5,-5,-8,-8,-9,-9,-6,-6,-3,-3,-3,-3,-6,-6,-9,-9,-7,-7,-4,-4,5,5,5,5,-4,-4,-7,-7,-8,-8,-5,-5,-5,-5,-8,-8,-9,-9,-6,-6,-6,-6,-9,-9,-10,-10,-7,-7,-7,-7,-10,-10,-11,-11,-8,-8,-8,-8,-11,-11,-12,-12,-9,-9,-9,-9,-12,-12,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,8,8,8,8,-14,-14,-15,-15,-15,-15}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VERTEX_LABELS/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test 4ti2/zsolve.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,1,1,1,-1,-1,-1,-1},{-1,-1,1,1,1,1,-1,-1},{1,-1,-1,1,-1,1,-1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test 4ti2/hilb1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{0,1,0,1,2,1},{0,0,1,1,1,2},{0,0,0,3,3,3}};
desiredHB = matrix {{1,2,1,1,1,1,1,1},{0,1,1,1,2,1,1,0},{0,1,2,1,1,1,0,1},{0,1,3,3,3,2,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test 4ti2/groeb2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,0,0,1,0,0},{0,1,0,0,1,0},{0,0,1,0,0,1},{0,1,1,0,0,0},{1,0,0,0,0,1},{0,0,0,1,1,0},{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1},{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0},{0,1,0,1,0,0},{1,0,0,0,0,1},{0,0,1,0,1,0},{1,0,1,0,0,0},{0,1,0,0,1,0},{0,0,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test 4ti2/sparse.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,0,0,0,0,0},{0,1,0,0,0,0},{0,0,1,0,0,0},{0,0,0,1,0,0},{0,0,0,0,1,0}};
desiredHB = matrix {{1,1,1,1,1,1},{0,1,0,0,0,0},{0,0,1,0,0,0},{0,0,0,1,0,0},{0,0,0,0,1,0},{0,0,0,0,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test POSITIVE/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1},{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test POSITIVE/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test split_compatibility_graph/3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test porta/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{0,1,1,1},{0,3,1,5/3},{0,3,5/2,1},{1,0,0,0},{0,2,4,1},{0,3,5,2}};
desiredHB = matrix {{0,1,2,3},{0,3,2,5},{0,3,5,3},{1,0,0,0},{0,2,8,3},{0,3,10,6}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VISUAL_MIN_MAX_FACE/in1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VISUAL_MIN_MAX_FACE/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test spherize/1-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{2,-2,2,-2,2,-2,2,-2},{-2,-2,2,2,-2,-2,2,2},{-2,-2,-2,-2,2,2,2,2}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},{-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2},{-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test random_edge_epl/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,0,0,1,0,1,0,1},{3/4,1,0,1/4,0,1/4,1,3/4},{3/16,1/4,0,1/16,1,15/16,3/4,13/16}};
desiredHB = matrix {{1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,11,11,12,12,12,12,13,13,14,14,15,15,16,16,16,16},{0,0,0,0,1,2,0,0,1,1,2,2,3,3,3,3,0,0,1,1,2,2,3,3,3,4,4,4,4,4,4,4,4,1,1,2,2,3,3,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,11,11,12,12,12,12,13,13,14,14,15,15,16,16,16,16},{0,0,1,2,1,1,3,3,2,2,2,2,1,1,2,2,4,4,3,3,3,3,3,3,3,1,1,1,2,2,3,3,3,4,4,4,4,4,4,4,4,4,4,2,2,3,3,4,4,2,2,3,3,4,4,2,2,3,3,4,4,2,2,3,3,4,4,3,3,4,4,3,3,4,4,3,3,4,4,8,8,3,3,4,4,4,4,4,4,4,4,4,4,12,12},{0,1,1,1,1,1,1,2,1,2,1,2,1,2,1,2,1,3,1,3,1,3,1,2,3,1,2,3,1,3,1,2,3,1,4,1,4,1,4,1,2,3,4,1,4,1,4,1,5,1,5,1,5,1,5,1,6,1,6,1,6,1,7,1,7,1,7,1,8,1,8,1,9,1,9,1,10,1,10,2,9,1,11,1,11,1,12,1,13,1,14,1,15,3,13}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test free_sum_decomposition/2-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,-1,0,0,0,0},{0,1,1,-1,0,0},{0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,1},{1,-1,0,0,0,1,0},{0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test free_sum_decomposition/3-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,1,0,1,1,0,0,-4},{1,0,1,-2,1,1,-3,1},{0,0,-1,1,1,1,1,-3}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-4,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1},{1,0,1,-1,0,1,1,-2,-1,0,0,1,1,-3,-2,-1,-1,0,0,1,1,1,-2,-1,0,0,1,1},{-3,-2,-2,-1,-1,-2,-1,0,0,-1,0,-1,0,1,1,0,1,0,1,-1,0,1,1,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test AFFINE_HULL/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1},{0,1,0,0},{1,0,0,0},{0,0,1,0}};
desiredHB = matrix {{1,1,1,1},{0,0,0,1},{0,0,1,0},{0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VISUAL_GRAPH/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test schlegel_params/1-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test schlegel_params/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test DUAL_BOUNDED_H_VECTOR/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{0,1,0,0,1,0},{0,0,1,0,0,1},{0,0,0,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1},{0,0,0,0,1,1},{0,0,1,1,0,0},{0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VISUAL_VERTEX_COLORS/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VISUAL_VERTEX_COLORS/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test lattice_bipyramid/simpyr2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{0,3,0,0,1},{0,0,3,0,1},{0,0,0,3,-5}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3},{0,0,0,0,1,1,1,2,2,3,0,0,0,1,1,1,1,1,1,1,2,0,0,1,0},{0,1,2,3,0,1,2,0,1,0,0,1,2,-5,-4,-3,-2,-1,0,1,0,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test lattice_bipyramid/cubepyr1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,1},{-1,-1,-1,-1,1,1,1,1,-1,1},{0,0,0,0,0,0,0,0,2,-2}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,1},{-1,-1,-1,0,0,1,-1,-1,0,0,1,-1,0,1,-1,-1,0,0,1,-1,-1,0,0,0,1,1,-1,0,0,1,1,-1,0,1,-1,0,0,1,1,-1,0,0,1,1,1},{0,1,2,0,1,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,-1,0,1,-1,0,0,-1,0,-1,0,0,0,0,0,-1,0,-1,0,0,-1,0,-2,-1,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test lattice_bipyramid/cube.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test lattice_bipyramid/simpyr1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{0,3,0,1,1},{0,0,3,1,1},{0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1,1,2,2,3},{0,1,2,3,0,1,1,1,2,0,1,0},{0,0,0,0,0,-1,0,1,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test vertex_barycenter/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{1/2,-1/2,3/4,2,100},{2/3,2/3,2/3,3,200},{3/4,-3/4,1/2,4,300}};
desiredHB = matrix {{1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12},{2,100,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64,65,65,66,66,67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,74,75,75,76,76,77,77,78,78,79,79,80,80,81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88,89,89,90,90,91,91,92,92,93,93,94,95,96,97,0,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,15,16,16,16,17,17,17,18,18,18,19,19,19,20,20,20,21,21,21,22,22,22,23,23,23,24,24,24,25,25,25,26,26,26,27,27,27,28,28,28,29,29,29,30,30,30,31,31,31,32,32,32,33,33,33,34,34,34,35,35,35,36,36,36,37,37,37,38,38,38,39,39,39,40,40,40,41,41,41,42,42,42,43,43,43,44,44,44,45,45,45,46,46,46,47,47,47,48,48,48,49,49,49,50,50,50,50,51,51,51,51,52,52,52,53,53,53,54,54,54,55,55,55,56,56,56,57,57,57,58,58,58,59,59,59,60,60,60,61,61,61,62,62,62,63,63,63,64,64,64,65,65,65,66,66,66,67,67,67,68,68,68,69,69,69,70,70,70,71,71,71,72,72,72,73,73,73,74,74,74,75,75,75,76,76,76,77,77,77,78,78,78,79,79,79,80,80,80,81,81,81,82,82,82,83,83,83,84,84,85,85,86,86,87,87,88,89,90,91,0,0,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,12,13,13,13,13,14,14,14,14,15,15,15,15,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,22,22,22,22,23,23,23,23,24,24,24,24,25,25,25,25,26,26,26,26,27,27,27,27,28,28,28,28,29,29,29,29,30,30,30,30,31,31,31,31,32,32,32,32,33,33,33,33,34,34,34,34,35,35,35,35,36,36,36,36,37,37,37,37,38,38,38,38,39,39,39,39,40,40,40,40,41,41,41,41,42,42,42,42,43,43,43,43,44,44,44,44,45,45,45,45,46,46,46,46,47,47,47,47,48,48,48,48,49,49,49,49,49,50,50,50,50,50,51,51,51,51,51,52,52,52,52,53,53,53,53,54,54,54,54,55,55,55,55,56,56,56,56,57,57,57,57,58,58,58,58,59,59,59,59,60,60,60,60,61,61,61,61,62,62,62,62,63,63,63,63,64,64,64,64,65,65,65,65,66,66,66,66,67,67,67,67,68,68,68,68,69,69,69,69,70,70,70,70,71,71,71,71,72,72,72,72,73,73,73,74,74,74,75,75,75,76,76,76,77,77,77,78,78,79,79,80,80,81,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,-1,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,15,16,16,16,17,17,17,18,18,18,19,19,19,20,20,20,21,21,21,22,22,22,23,23,23,24,24,24,25,25,25,26,26,26,27,27,27,28,28,28,29,29,29,30,30,30,31,31,31,32,32,32,33,33,33,34,34,34,35,35,35,36,36,36,37,37,37,38,38,38,39,39,39,40,40,40,41,41,41,42,42,42,43,43,43,44,44,44,45,45,45,46,46,46,47,47,47,48,48,48,48,49,49,49,49,50,50,50,50,51,51,51,52,52,52,52,53,53,53,53,54,54,54,54,55,55,55,55,56,56,56,56,57,57,57,57,58,58,58,58,59,59,59,59,60,60,60,60,61,61,61,61,62,62,62,62,63,63,63,64,64,64,65,65,65,66,66,66,67,67,68,68,69,69,70,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,-2,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,12,13,13,13,13,14,14,14,14,15,15,15,15,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,22,22,22,22,23,23,23,23,24,24,24,24,25,25,25,25,26,26,26,26,27,27,27,27,28,28,28,28,29,29,29,29,30,30,30,30,31,31,31,31,32,32,32,32,33,33,33,33,34,34,34,34,35,35,35,35,36,36,36,36,37,37,37,37,38,38,38,38,39,39,39,39,40,40,40,40,41,41,41,41,42,42,42,42,43,43,43,43,44,44,44,44,45,45,45,45,46,46,46,46,47,47,47,47,48,48,48,48,48,49,49,49,49,49,50,50,50,50,51,51,51,51,52,52,52,52,53,53,53,54,54,55,55,56,56,57,58,59,60,-2,-2,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,12,13,13,13,13,14,14,14,14,15,15,15,15,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,22,22,22,22,23,23,23,23,24,24,24,24,25,25,25,25,26,26,26,26,27,27,27,27,28,28,28,28,29,29,29,29,30,30,30,30,31,31,31,31,32,32,32,32,33,33,33,33,34,34,34,34,35,35,35,35,36,36,36,36,37,37,37,37,38,38,38,38,39,39,39,39,40,40,40,40,41,41,41,41,42,42,42,42,43,43,43,43,44,44,44,44,45,45,45,45,46,46,46,47,47,47,48,48,48,49,49,49,50,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,-3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,15,16,16,16,17,17,17,18,18,18,19,19,19,20,20,20,21,21,21,22,22,22,23,23,23,24,24,24,25,25,25,26,26,26,27,27,27,28,28,28,29,29,29,30,30,30,31,31,31,32,32,32,33,33,33,34,34,34,35,35,35,36,36,37,37,38,38,39,39,40,41,42,43,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,12,13,13,13,13,14,14,14,14,15,15,15,15,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,22,22,22,22,23,23,23,23,24,24,24,24,25,25,25,25,26,26,26,27,27,27,28,28,28,29,29,29,30,30,31,31,32,32,33,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,14,14,14,15,15,16,16,17,17,18,18,19,20,21,22,23,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,10,10,11,11,12,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,-6,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105},{3,200,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,190,192,194,2,2,3,4,3,4,5,6,6,7,8,8,9,10,10,11,12,12,13,14,14,15,16,16,17,18,18,19,20,20,21,22,22,23,24,24,25,26,26,27,28,28,29,30,30,31,32,32,33,34,34,35,36,36,37,38,38,39,40,40,41,42,42,43,44,44,45,46,46,47,48,48,49,50,50,51,52,52,53,54,54,55,56,56,57,58,58,59,60,60,61,62,62,63,64,64,65,66,66,67,68,68,69,70,70,71,72,72,73,74,74,75,76,76,77,78,78,79,80,80,81,82,82,83,84,84,85,86,86,87,88,88,89,90,90,91,92,92,93,94,94,95,96,96,97,98,98,99,100,100,101,102,103,102,103,104,105,105,106,107,107,108,109,109,110,111,111,112,113,113,114,115,115,116,117,117,118,119,119,120,121,121,122,123,123,124,125,125,126,127,127,128,129,129,130,131,131,132,133,133,134,135,135,136,137,137,138,139,139,140,141,141,142,143,143,144,145,145,146,147,147,148,149,149,150,151,151,152,153,153,154,155,155,156,157,157,158,159,159,160,161,161,162,163,163,164,165,165,166,167,167,168,169,169,170,171,172,173,174,175,176,177,179,181,183,3,4,3,4,5,6,3,3,4,6,7,8,4,5,8,9,10,7,10,11,12,9,12,13,14,11,14,15,16,13,16,17,18,15,18,19,20,17,20,21,22,19,22,23,24,21,24,25,26,23,26,27,28,25,28,29,30,27,30,31,32,29,32,33,34,31,34,35,36,33,36,37,38,35,38,39,40,37,40,41,42,39,42,43,44,41,44,45,46,43,46,47,48,45,48,49,50,47,50,51,52,49,52,53,54,51,54,55,56,53,56,57,58,55,58,59,60,57,60,61,62,59,62,63,64,61,64,65,66,63,66,67,68,65,68,69,70,67,70,71,72,69,72,73,74,71,74,75,76,73,76,77,78,75,78,79,80,77,80,81,82,79,82,83,84,81,84,85,86,83,86,87,88,85,88,89,90,87,90,91,92,89,92,93,94,91,94,95,96,93,96,97,98,95,98,99,100,97,100,101,102,103,99,102,103,104,105,101,104,105,106,107,103,107,108,109,105,109,110,111,107,111,112,113,109,113,114,115,111,115,116,117,113,117,118,119,115,119,120,121,117,121,122,123,119,123,124,125,121,125,126,127,123,127,128,129,125,129,130,131,127,131,132,133,129,133,134,135,131,135,136,137,133,137,138,139,135,139,140,141,137,141,142,143,139,143,144,145,141,145,146,147,143,147,148,149,145,149,150,147,151,152,149,153,154,151,155,156,153,157,158,155,159,157,161,159,163,161,165,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,4,4,5,6,4,5,6,7,8,4,5,8,9,10,4,4,5,10,11,12,5,12,13,14,14,15,16,16,17,18,18,19,20,20,21,22,22,23,24,24,25,26,26,27,28,28,29,30,30,31,32,32,33,34,34,35,36,36,37,38,38,39,40,40,41,42,42,43,44,44,45,46,46,47,48,48,49,50,50,51,52,52,53,54,54,55,56,56,57,58,58,59,60,60,61,62,62,63,64,64,65,66,66,67,68,68,69,70,70,71,72,72,73,74,74,75,76,76,77,78,78,79,80,80,81,82,82,83,84,84,85,86,86,87,88,88,89,90,90,91,92,92,93,94,94,95,96,96,97,98,98,99,100,100,101,102,103,102,103,104,105,104,105,106,107,107,108,109,103,109,110,111,105,111,112,113,107,113,114,115,109,115,116,117,111,117,118,119,113,119,120,121,115,121,122,123,117,123,124,125,119,125,126,127,121,127,128,129,123,129,130,131,125,131,132,127,133,134,129,135,136,131,137,138,133,139,135,141,137,143,139,145,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,4,4,5,6,4,5,6,7,8,4,5,6,8,9,10,4,4,5,6,10,11,12,4,4,4,5,6,12,13,14,4,5,5,6,6,14,15,16,6,8,16,17,18,10,18,19,20,12,20,21,22,14,22,23,24,16,24,25,26,18,26,27,28,20,28,29,30,22,30,31,32,24,32,33,34,26,34,35,36,28,36,37,38,30,38,39,40,32,40,41,42,34,42,43,44,36,44,45,46,38,46,47,48,40,48,49,50,42,50,51,52,44,52,53,54,46,54,55,56,48,56,57,58,50,58,59,60,52,60,61,62,54,62,63,64,56,64,65,66,58,66,67,68,60,68,69,70,62,70,71,72,64,72,73,74,66,74,75,76,68,76,77,78,70,78,79,80,72,80,81,82,74,82,83,84,76,84,85,86,78,86,87,88,80,88,89,90,82,90,91,92,84,92,93,94,86,94,95,96,88,96,97,98,90,98,99,100,92,100,101,102,94,102,103,104,105,96,104,105,106,107,98,107,108,109,100,109,110,111,102,111,112,113,104,113,114,115,116,117,118,119,120,121,123,125,127,5,6,5,6,7,8,5,6,8,9,10,5,6,10,11,12,5,6,12,13,14,5,6,14,15,16,5,5,5,6,6,16,17,18,5,6,6,8,18,19,20,10,20,21,22,12,22,23,24,14,24,25,26,16,26,27,28,18,28,29,30,20,30,31,32,22,32,33,34,24,34,35,36,26,36,37,38,28,38,39,40,30,40,41,42,32,42,43,44,34,44,45,46,36,46,47,48,38,48,49,50,40,50,51,52,42,52,53,54,44,54,55,56,46,56,57,58,48,58,59,60,50,60,61,62,52,62,63,64,54,64,65,66,56,66,67,68,58,68,69,70,60,70,71,72,62,72,73,74,64,74,75,76,66,76,77,78,68,78,79,80,70,80,81,82,72,82,83,84,74,84,85,86,76,86,87,88,78,88,89,90,80,90,91,92,82,92,93,94,84,94,95,96,86,96,97,98,88,98,99,100,90,100,101,92,102,103,94,104,105,96,106,107,98,109,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,6,6,7,8,6,7,8,9,10,6,7,10,11,12,6,7,12,13,14,6,7,14,15,16,6,7,16,17,18,6,7,18,19,20,6,6,7,7,20,21,22,6,7,7,22,23,24,24,25,26,26,27,28,28,29,30,30,31,32,32,33,34,34,35,36,36,37,38,38,39,40,40,41,42,42,43,44,44,45,46,46,47,48,48,49,50,50,51,52,52,53,54,54,55,56,56,57,58,58,59,60,60,61,62,62,63,64,64,65,66,66,67,68,68,69,70,70,71,72,72,73,74,74,75,76,76,77,78,78,79,80,80,81,82,82,83,84,85,86,87,88,89,90,92,94,96,6,6,7,8,6,7,8,9,10,6,7,8,10,11,12,6,7,8,12,13,14,6,7,8,14,15,16,6,7,8,16,17,18,6,7,8,18,19,20,6,6,7,8,20,21,22,6,6,6,7,7,8,22,23,24,6,6,7,7,8,8,9,24,25,26,7,8,8,11,26,27,28,13,28,29,30,15,30,31,32,17,32,33,34,19,34,35,36,21,36,37,38,23,38,39,40,25,40,41,42,27,42,43,44,29,44,45,46,31,46,47,48,33,48,49,50,35,50,51,52,37,52,53,54,39,54,55,56,41,56,57,58,43,58,59,60,45,60,61,62,47,62,63,64,49,64,65,51,66,67,53,68,69,55,70,71,57,72,59,74,61,76,63,78,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,7,8,7,8,9,10,7,8,10,11,12,7,8,12,13,14,7,8,14,15,16,7,8,16,17,18,7,8,18,19,20,7,8,20,21,22,7,8,22,23,24,7,8,24,25,26,7,7,8,8,26,27,28,7,7,8,8,28,29,30,8,30,31,32,32,33,34,34,35,36,36,37,38,38,39,40,40,41,42,42,43,44,44,45,46,47,48,49,50,51,52,54,56,58,60,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,8,8,9,10,8,9,10,11,12,8,9,12,13,14,8,9,14,15,16,8,9,16,17,18,8,9,18,19,20,8,9,20,21,22,8,9,22,23,24,8,9,24,25,26,8,9,26,27,8,8,9,28,29,8,8,9,9,10,30,31,8,8,9,9,12,32,33,9,14,34,16,36,18,38,20,40,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,8,8,9,8,9,10,11,8,9,10,12,13,8,9,10,14,15,8,9,10,16,8,9,10,18,8,9,10,20,8,9,10,22,8,9,10,8,9,10,8,9,10,8,8,9,10,8,8,9,9,10,10,8,8,9,9,10,10,12,8,9,9,10,10,14,10,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206},{4,300,2,5,8,11,14,17,20,23,26,29,32,35,38,41,44,47,50,53,56,59,62,65,68,71,74,77,80,83,86,89,92,95,98,101,104,107,110,113,116,119,122,125,128,131,134,137,140,143,146,149,150,152,153,155,156,158,159,161,162,164,165,167,168,170,171,173,174,176,177,179,180,182,183,185,186,188,189,191,192,194,195,197,198,200,201,203,204,206,207,209,210,212,213,215,216,218,219,221,222,224,225,227,228,230,231,233,234,236,237,239,240,242,243,245,246,248,249,251,252,254,255,257,258,260,261,263,264,266,267,269,270,272,273,275,276,278,279,281,284,287,290,0,1,2,3,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,254,255,257,258,260,261,263,266,269,272,0,1,1,2,3,4,2,3,3,5,6,7,4,6,8,9,10,9,11,12,13,12,14,15,16,15,17,18,19,18,20,21,22,21,23,24,25,24,26,27,28,27,29,30,31,30,32,33,34,33,35,36,37,36,38,39,40,39,41,42,43,42,44,45,46,45,47,48,49,48,50,51,52,51,53,54,55,54,56,57,58,57,59,60,61,60,62,63,64,63,65,66,67,66,68,69,70,69,71,72,73,72,74,75,76,75,77,78,79,78,80,81,82,81,83,84,85,84,86,87,88,87,89,90,91,90,92,93,94,93,95,96,97,96,98,99,100,99,101,102,103,102,104,105,106,105,107,108,109,108,110,111,112,111,113,114,115,114,116,117,118,117,119,120,121,120,122,123,124,123,125,126,127,126,128,129,130,129,131,132,133,132,134,135,136,135,137,138,139,138,140,141,142,141,143,144,145,144,146,147,148,149,147,149,150,151,152,150,152,153,154,155,153,156,157,158,156,159,160,161,159,162,163,164,162,165,166,167,165,168,169,170,168,171,172,173,171,174,175,176,174,177,178,179,177,180,181,182,180,183,184,185,183,186,187,188,186,189,190,191,189,192,193,194,192,195,196,197,195,198,199,200,198,201,202,203,201,204,205,206,204,207,208,209,207,210,211,212,210,213,214,215,213,216,217,218,216,219,220,219,222,223,222,225,226,225,228,229,228,231,232,231,234,234,237,237,240,240,243,243,246,249,252,255,258,261,264,267,270,273,276,279,282,285,288,291,294,297,300,-1,0,1,2,1,2,3,4,5,2,3,6,7,8,3,4,4,9,10,11,5,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,147,148,149,150,150,151,152,153,154,155,156,153,157,158,159,156,160,161,162,159,163,164,165,162,166,167,168,165,169,170,171,168,172,173,174,171,175,176,177,174,178,179,180,177,181,182,183,180,184,185,186,183,187,188,189,186,190,191,189,193,194,192,196,197,195,199,200,198,202,201,205,204,208,207,211,210,213,216,219,222,225,228,231,234,237,240,243,246,249,252,255,258,261,264,267,270,273,276,279,282,285,288,291,294,297,300,-3,-2,-1,0,-1,0,1,2,3,0,1,2,4,5,6,1,3,2,3,7,8,9,2,3,4,3,4,10,11,12,3,4,5,5,7,13,14,15,6,10,16,17,18,13,19,20,21,16,22,23,24,19,25,26,27,22,28,29,30,25,31,32,33,28,34,35,36,31,37,38,39,34,40,41,42,37,43,44,45,40,46,47,48,43,49,50,51,46,52,53,54,49,55,56,57,52,58,59,60,55,61,62,63,58,64,65,66,61,67,68,69,64,70,71,72,67,73,74,75,70,76,77,78,73,79,80,81,76,82,83,84,79,85,86,87,82,88,89,90,85,91,92,93,88,94,95,96,91,97,98,99,94,100,101,102,97,103,104,105,100,106,107,108,103,109,110,111,106,112,113,114,109,115,116,117,112,118,119,120,115,121,122,123,118,124,125,126,121,127,128,129,124,130,131,132,127,133,134,135,130,136,137,138,133,139,140,141,136,142,143,144,139,145,146,147,148,142,148,149,150,151,145,152,153,154,148,155,156,157,151,158,159,160,154,161,162,164,165,167,168,170,171,173,176,179,182,-3,-2,-2,-1,0,1,-1,0,2,3,4,0,1,5,6,7,1,2,8,9,10,2,3,11,12,13,3,4,5,4,7,14,15,16,4,5,6,10,17,18,19,13,20,21,22,16,23,24,25,19,26,27,28,22,29,30,31,25,32,33,34,28,35,36,37,31,38,39,40,34,41,42,43,37,44,45,46,40,47,48,49,43,50,51,52,46,53,54,55,49,56,57,58,52,59,60,61,55,62,63,64,58,65,66,67,61,68,69,70,64,71,72,73,67,74,75,76,70,77,78,79,73,80,81,82,76,83,84,85,79,86,87,88,82,89,90,91,85,92,93,94,88,95,96,97,91,98,99,100,94,101,102,103,97,104,105,106,100,107,108,109,103,110,111,112,106,113,114,115,109,116,117,118,112,119,120,121,115,122,123,124,118,125,126,127,121,128,129,130,124,131,132,133,127,134,135,136,130,137,138,139,133,140,141,136,143,144,139,146,147,142,149,150,145,153,148,151,154,157,160,163,166,169,172,175,178,181,184,187,190,193,196,199,202,205,208,211,214,217,220,223,226,229,232,235,238,241,244,247,250,253,256,259,262,265,268,271,274,277,280,283,286,289,292,295,298,301,-4,-3,-2,-1,-2,-1,0,1,2,-1,0,3,4,5,0,1,6,7,8,1,2,9,10,11,2,3,12,13,14,3,4,15,16,17,4,6,5,8,18,19,20,5,6,7,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,114,115,117,118,120,121,123,126,129,132,-6,-5,-4,-3,-4,-3,-2,-1,0,-3,-2,-1,1,2,3,-2,-1,0,4,5,6,-1,0,1,7,8,9,0,1,2,10,11,12,1,2,3,13,14,15,2,6,3,4,16,17,18,3,5,6,4,8,5,19,20,21,4,5,5,7,6,9,11,22,23,24,6,7,8,14,25,26,27,17,28,29,30,20,31,32,33,23,34,35,36,26,37,38,39,29,40,41,42,32,43,44,45,35,46,47,48,38,49,50,51,41,52,53,54,44,55,56,57,47,58,59,60,50,61,62,63,53,64,65,66,56,67,68,69,59,70,71,72,62,73,74,75,65,76,77,78,68,79,80,81,71,82,83,74,85,86,77,88,89,80,91,92,83,94,86,97,89,100,92,103,95,98,101,104,107,110,113,116,119,122,125,128,131,134,137,140,143,146,149,152,155,158,161,164,167,170,173,176,179,182,185,188,191,194,197,200,203,206,209,212,215,218,221,224,227,230,233,236,239,242,245,248,251,254,257,260,263,266,269,272,275,278,281,284,287,290,293,296,299,302,305,-6,-5,-5,-4,-3,-2,-4,-3,-1,0,1,-3,-2,2,3,4,-2,-1,5,6,7,-1,0,8,9,10,0,1,11,12,13,1,2,14,15,16,2,3,17,18,19,3,4,20,21,22,4,7,5,9,23,24,25,5,6,6,8,26,27,28,7,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,53,54,56,57,59,60,62,65,68,71,74,158,161,164,167,170,173,176,179,182,185,188,191,194,197,200,203,206,209,212,215,218,221,224,227,230,233,236,239,242,245,248,251,254,257,260,263,266,269,272,275,278,281,284,287,290,293,296,299,302,305,-7,-6,-5,-4,-5,-4,-3,-2,-1,-4,-3,0,1,2,-3,-2,3,4,5,-2,-1,6,7,8,-1,0,9,10,11,0,1,12,13,14,1,2,15,16,17,2,3,18,19,20,3,4,21,22,4,9,5,24,25,5,8,6,10,12,27,28,6,7,7,9,15,30,31,8,18,33,21,36,24,39,27,42,30,33,36,39,42,45,48,51,54,57,60,63,66,69,72,75,78,81,84,87,90,93,96,99,102,105,108,111,114,117,120,123,126,129,132,135,138,141,144,147,150,153,156,159,-9,-8,-7,-7,-6,-5,-4,-6,-5,-4,-2,-1,-5,-4,-3,1,2,-4,-3,-2,4,-3,-2,-1,7,-2,-1,0,10,-1,0,1,13,0,1,2,1,2,3,2,3,4,3,9,4,5,4,8,5,10,6,12,5,7,6,9,7,11,15,6,7,8,8,10,18,9,21,24,27,30,33,36,39,42,45,48,51,54,57,60,63,66,69,72,75,78,81,84,87,90,93,96,99,102,105,108,111,114,117,120,123,126,129,132,135,138,141,144,147,150,153,156,159,162,165,168,171,174,177,180,183,186,189,192,195,198,201,204,207,210,213,216,219,222,225,228,231,234,237,240,243,246,249,252,255,258,261,264,267,270,273,276,279,282,285,288,291,294,297,300,303,306}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test vertex_barycenter/cr.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test TRIANGULATION/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test rand_aof/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test lattice_automorphisms/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1},{0,0,1,1,1,1,-1,-1,-1,-1},{1,0,1,-1,0,1,1,-3,-1,1},{-1,-1,1,1,0,0,1,1,-1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1},{-3,-2,-2,-1,-1,-1,0,0,0,1,1,1,-2,-1,-1,0,0,0,1,1,1,-1,0,0,1,1},{1,0,1,-1,0,1,-1,0,1,-1,0,1,1,0,1,-1,0,1,-1,0,1,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VertexPerm/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VertexPerm/4.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VertexPerm/4p.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,1,-1,1,-1,1,-1,-1},{1,-1,1,1,-1,-1,1,-1},{1,-1,-1,-1,1,1,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VertexPerm/2p.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1},{1,1,1,1,0,0,1,1,0,1},{1,1,1,0,0,0,0,1,0,1},{0,0,1,0,1,1,0,0,0,0},{0,0,1,0,1,1,0,1,1,1},{0,1,1,1,0,1,0,0,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1},{0,0,0,0,0,1,1,1,1,1},{0,1,1,0,0,0,0,0,0,1},{1,1,1,0,0,0,0,1,1,1},{1,0,1,0,1,0,1,0,1,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VertexPerm/1p.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,0,0,-1,0,0},{0,1,0,0,-1,0},{0,0,1,0,0,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test VertexPerm/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1},{1,0,1,0,1,1,1,0,1,1},{1,0,0,0,1,1,0,0,1,1},{0,1,0,0,0,0,0,1,0,1},{1,1,0,1,0,1,0,1,0,1},{0,0,0,1,0,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1},{0,0,0,0,0,1,1,1,1,1},{0,1,1,0,0,0,0,0,0,1},{1,1,1,0,0,0,0,1,1,1},{1,0,1,0,1,0,1,0,1,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test congruent_polytopes/24cell-non-regular.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,-1,0,1,0,0,1,1,0,1,0,-1,-1,0,0,1,0,0,-1,0,-1,0,0,-1},{0,0,0,-1,0,0,0,-1,0,0,-1,0,0,-1,0,-1,0,-1,1,1,1,1,1,1},{-1,1,1,0,0,0,0,0,1,-1,1,1,0,0,-1,-1,-1,0,0,0,1,-1,0,0},{-1,1,-1,-1,-1,1,-1,0,0,0,0,0,1,0,0,0,1,1,1,-1,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1},{0,0,0,1,1,1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,-1,-1,-1,0,0,0},{0,1,1,0,0,1,0,0,1,-1,-1,0,0,0,1,1,-1,0,0,-1,0,0,-1,-1,0},{1,0,1,0,1,0,0,1,0,0,1,-1,0,1,-1,0,0,-1,0,0,-1,0,-1,0,-1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test congruent_polytopes/24-cell.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,0,0,0,0,0,0,1/2,1/2,1/2,1/2,1/2,1/2,1/2,1/2,1},{0,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,-1,0,0,0,0,1,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,0},{0,-1/2,-1/2,1/2,1/2,-1/2,-1/2,1/2,1/2,0,-1,0,0,1,0,-1/2,-1/2,1/2,1/2,-1/2,-1/2,1/2,1/2,0},{0,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,0,0,-1,1,0,0,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},{-1,0,0,0,0,0,0,0,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,-1,0,0,0,0,0,1,0,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,1,1},{0,0,-1,0,0,0,1,0,0,-1,-1,-1,0,0,1,1,1,-1,-1,1,1,-1,-1,-1,0,0,1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,-1,0,0,1,1,1,-1,-1,1,1,-1,-1,-1,0,0,1,1,1},{0,0,0,-1,0,1,0,0,0,-1,0,1,-1,1,-1,0,1,-1,1,-1,1,-1,0,1,-1,1,-1,0,1,-1,1,-1,1,-1,1,-1,1,-1,0,1,-1,1,-1,0,1,-1,1,-1,1,-1,0,1,-1,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test congruent_polytopes/polar_24-cell.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-1,-1,-1},{-1,0,-1,-1,0,1,1,1,-1,0,0,1,0,0,1,0,-1,0,0,1,0,0,0,-1},{-1,-1,0,1,1,-1,0,1,0,0,0,0,1,-1,0,1,0,-1,0,0,1,0,-1,0},{0,-1,-1,0,-1,0,-1,0,0,-1,1,0,0,0,1,1,1,1,1,0,0,-1,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1},{-1,0,0,0,0,0,1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0,-1,0,0,0,1,-1,-1,-1,0,0,0,1,1,1,-1,0,0,0,1,0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0,0,-1,0,1,0,-1,0,1,-1,0,1,-1,0,1,0,-1,0,1,0,0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1c.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,0,6,0,5,-5},{6,-5,0,5,-5,0},{0,6,5,-5,0,-5},{5,0,-5,0,-5,6},{-5,5,0,-5,6,0},{0,-5,-5,6,0,5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/8.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},{1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0},{1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,1},{0,1,0,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,1,0,1,1},{0,0,1,0,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,1,0,1,1,1,0,1,1,1},{0,0,0,1,0,0,1,0,1,1,0,0,1,0,1,1,0,1,1,1,0,0,1,0,1,1,0,1,1,1,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1},{0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1},{1,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1},{1,1,0,1,1,1,0,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0},{1,1,1,0,1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0},{1,1,1,1,0,1,1,1,0,1,1,0,1,0,0,1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1h.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/19.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/4.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{0,0,0,1,1,1},{1,1,1,0,0,0},{1,1,2,1,1,2},{1,2,1,1,2,1}};
desiredHB = matrix {{1,1,1,1,1,1},{0,0,0,1,1,1},{1,1,1,0,0,0},{1,1,2,1,1,2},{1,2,1,1,2,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/3-cube+action.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1b.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,0,6,0,5,-5},{6,-5,0,5,-5,0},{0,6,5,-5,0,-5},{5,0,-5,0,-5,6},{-5,5,0,-5,6,0},{0,-5,-5,6,0,5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1f.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,0,6,0,5,-5},{6,-5,0,5,-5,0},{0,6,5,-5,0,-5},{5,0,-5,0,-5,6},{-5,5,0,-5,6,0},{0,-5,-5,6,0,5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/18.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,0,0,0,1,1},{0,0,1,0,1,0,1,1,0,0},{0,1,1,0,0,1,0,0,0,1},{1,1,0,0,0,0,0,1,1,0},{1,0,0,1,0,1,1,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,1,1,1,1},{0,0,0,1,1,1,0,0,0,1},{0,1,1,0,0,1,0,0,1,0},{1,0,1,0,1,0,0,1,0,0},{1,1,0,1,0,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1d.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,0,6,0,5,-5},{6,-5,0,5,-5,0},{0,6,5,-5,0,-5},{5,0,-5,0,-5,6},{-5,5,0,-5,6,0},{0,-5,-5,6,0,5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1a.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,0,6,0,5,-5},{6,-5,0,5,-5,0},{0,6,5,-5,0,-5},{5,0,-5,0,-5,6},{-5,5,0,-5,6,0},{0,-5,-5,6,0,5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1e.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,0,6,0,5,-5},{6,-5,0,5,-5,0},{0,6,5,-5,0,-5},{5,0,-5,0,-5,6},{-5,5,0,-5,6,0},{0,-5,-5,6,0,5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/1g.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
desiredHB = matrix {{1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-5,-5,0,0,5,6,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},{0,6,-5,5,-5,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,10,10,-1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-2,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,10,10,-3,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-4,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,-5,-4,-4,-4,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-6,-5,-5,-5,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-7,-6,-6,-6,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-8,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,8,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,7,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,5,5,5,6,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,-9,-9,-8,-8,-8,-7,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-6,-6,-5,-5,-5,-5,-5,-5,-5,-4,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,1,1,1,1,2,2,2,3,-9,-9,-8,-8,-8,-8,-7,-7,-7,-7,-7,-6,-6,-6,-6,-6,-5,-5,-5,-5,-4,-4,-4,-4,-3,-3,-3,-3,-2,-2,-2,-2,-1,-1,-1,-1,0,0,0,0,1,1,2,-9,-9,-8,-8,-8,-7,-7,-6,-6,-5,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1},{-5,0,6,-5,0,5,1,0,1,-1,0,-2,-1,-3,-2,-4,-3,-5,-4,-6,-5,-7,-6,-9,-8,-7,-9,-8,1,0,1,-1,0,1,2,-2,-1,0,1,-3,-2,-1,0,-4,-3,-2,-1,-5,-4,-3,-2,-6,-5,-4,-3,-8,-7,-6,-5,-4,-9,-8,-7,-6,-5,-9,-8,-7,-6,-9,-8,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-8,-7,-6,-5,-4,-3,-2,-9,-8,-7,-6,-5,-4,-3,-9,-8,-7,-6,-5,-4,-8,-7,-6,-8,-7,1,0,1,2,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-8,-7,-6,-5,-4,-3,-2,-1,0,-9,-8,-7,-6,-5,-4,-3,-2,-1,-9,-8,-7,-6,-5,-4,-3,-2,-8,-7,-6,-5,-4,-8,-7,-6,-5,-7,-6,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,-8,-7,-6,-5,-4,-3,-2,-7,-6,-5,-4,-3,-7,-6,-5,-4,-6,-5,1,0,1,2,-1,0,1,2,3,-2,-1,0,1,2,3,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-8,-7,-6,-5,-4,-3,-2,-1,0,-7,-6,-5,-4,-3,-2,-1,-7,-6,-5,-4,-3,-2,-6,-5,-4,-3,-5,-4,1,0,1,2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,-7,-6,-5,-4,-3,-2,-1,0,1,-6,-5,-4,-3,-2,-1,0,-6,-5,-4,-3,-2,-1,-5,-4,-3,-2,-4,-3,1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,-6,-5,-4,-3,-2,-1,0,1,2,-6,-5,-4,-3,-2,-1,0,1,-5,-4,-3,-2,-1,0,-4,-3,-2,-1,-3,-2,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,-5,-4,-3,-2,-1,0,1,2,3,-5,-4,-3,-2,-1,0,1,2,-4,-3,-2,-1,0,1,-3,-2,-1,0,-2,-1,0,1,-1,0,1,2,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,5,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,-5,-4,-3,-2,-1,0,1,2,3,4,-4,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,-2,-1,0,1,-1,0,1,2,0,1,2,3,-1,0,1,2,3,4,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,1,2,3,1,2,3,4,0,1,2,3,4,5,-1,0,1,2,3,4,5,6,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-4,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,0,3,4,2,3,4,5,1,2,3,4,5,6,0,1,2,3,4,5,6,7,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,0,4,5,3,4,5,6,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,8,9,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,-1,0,1,0,5,6,4,5,6,7,3,4,5,6,7,8,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,9,-1,0,1,2,3,4,5,6,7,8,9,10,-2,-1,0,1,2,3,4,5,6,7,8,9,10,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,5,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,6,7,5,6,7,8,4,5,6,7,8,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,-1,0,1,2,3,4,5,6,7,8,9,-2,-1,0,1,2,3,4,5,6,7,8,-3,-2,-1,0,1,2,3,4,5,6,7,-4,-3,-2,-1,0,1,2,3,4,5,6,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,0,7,8,6,7,8,9,5,6,7,8,9,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,-1,0,1,2,3,4,5,6,7,-2,-1,0,1,2,3,4,5,-3,-2,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,8,9,7,8,9,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,1,2,3,4,5,6,0,1,2,3,4,5,-1,0,1,2,3,4,-2,-1,0,1,2,3,-1,0,1,2,-1,0,1,0,9,10,7,8,9,10,6,7,8,9,10,5,6,7,8,9,4,5,6,7,3,4,5,6,2,3,4,5,1,2,3,4,0,1,2,3,-1,0,1,2,0,1,0,9,10,8,9,10,7,8,6,7,5,6,4,5,3,4,2,3,1,2,0,1,0},{6,5,0,0,-5,-5,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9},{0,-5,5,-5,6,0,1,0,0,-1,-1,-2,-2,-3,-3,-4,-4,-5,-5,-6,-6,-7,-7,-8,-8,-8,-9,-9,2,1,1,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-2,-3,-3,-3,-3,-4,-4,-4,-4,-5,-5,-5,-5,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,3,2,2,2,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-9,-9,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,6,5,5,5,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,7,6,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,9,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-7,-7,-8,-8,-8,-8,-9,-9,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-5,-5,-6,-6,-6,-6,-6,-6,-7,-7,-7,-7,-8,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-4,-4,-4,-5,-5,-5,-5,-5,-5,-6,-6,-6,-7,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-4,-4,-4,-4,-4,-5,-5,-5,-6,10,10,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-3,-3,-3,-3,-3,-4,-4,-4,-5,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-3,-3,-4,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,-1,-1,-1,-1,-2,-2,-2,-3,10,10,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-2,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,1,1,1,1,0,0,-1,10,10,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,2,2,1,1,0},{5,0,-5,6,0,-5,0,1,0,2,1,3,2,4,3,5,4,6,5,7,6,8,7,10,9,8,10,9,0,1,0,2,1,0,-1,3,2,1,0,4,3,2,1,5,4,3,2,6,5,4,3,7,6,5,4,9,8,7,6,5,10,9,8,7,6,10,9,8,7,10,9,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,5,4,3,2,1,0,6,5,4,3,2,1,8,7,6,5,4,3,2,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,9,8,7,9,8,0,1,0,-1,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,9,8,7,6,5,4,3,2,1,10,9,8,7,6,5,4,3,2,10,9,8,7,6,5,4,3,9,8,7,6,5,9,8,7,6,8,7,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,9,8,7,6,5,4,3,2,1,0,-1,10,9,8,7,6,5,4,3,2,1,0,10,9,8,7,6,5,4,3,2,1,9,8,7,6,5,4,3,8,7,6,5,4,8,7,6,5,7,6,0,1,0,-1,2,1,0,-1,-2,3,2,1,0,-1,-2,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,10,9,8,7,6,5,4,3,2,1,0,-1,-2,10,9,8,7,6,5,4,3,2,1,0,-1,9,8,7,6,5,4,3,2,1,8,7,6,5,4,3,2,8,7,6,5,4,3,7,6,5,4,6,5,0,1,0,-1,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,9,8,7,6,5,4,3,2,1,0,-1,8,7,6,5,4,3,2,1,0,7,6,5,4,3,2,1,7,6,5,4,3,2,6,5,4,3,5,4,0,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,8,7,6,5,4,3,2,1,0,-1,-2,7,6,5,4,3,2,1,0,-1,7,6,5,4,3,2,1,0,6,5,4,3,2,1,5,4,3,2,4,3,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,6,5,4,3,2,1,0,-1,-2,6,5,4,3,2,1,0,-1,5,4,3,2,1,0,4,3,2,1,3,2,1,0,2,1,0,-1,3,2,1,0,-1,-2,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,-4,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,6,5,4,3,2,1,0,-1,-2,-3,5,4,3,2,1,0,-1,-2,4,3,2,1,0,-1,3,2,1,0,2,1,0,-1,1,0,-1,-2,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,-5,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,10,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,0,-1,-2,0,-1,-2,-3,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,-4,-5,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,1,-2,-3,-1,-2,-3,-4,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,-5,-6,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,1,-3,-4,-2,-3,-4,-5,-1,-2,-3,-4,-5,-6,0,-1,-2,-3,-4,-5,-6,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,2,1,0,1,-4,-5,-3,-4,-5,-6,-2,-3,-4,-5,-6,-7,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,-6,-7,-8,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,6,5,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,-4,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-5,-6,-4,-5,-6,-7,-3,-4,-5,-6,-7,-2,-3,-4,-5,-6,-7,-8,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,1,0,-1,-2,-3,-4,-5,-6,-7,-8,-9,2,1,0,-1,-2,-3,-4,-5,-6,-7,-8,3,2,1,0,-1,-2,-3,-4,-5,-6,-7,4,3,2,1,0,-1,-2,-3,-4,-5,-6,5,4,3,2,1,0,-1,-2,-3,-4,-5,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,3,2,1,0,-1,2,1,0,1,-6,-7,-5,-6,-7,-8,-4,-5,-6,-7,-8,-2,-3,-4,-5,-6,-7,-8,-9,-1,-2,-3,-4,-5,-6,-7,-8,-9,0,-1,-2,-3,-4,-5,-6,-7,-8,1,0,-1,-2,-3,-4,-5,-6,-7,2,1,0,-1,-2,-3,-4,-5,-6,3,2,1,0,-1,-2,-3,-4,4,3,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-7,-8,-6,-7,-8,-4,-5,-6,-7,-8,-9,-3,-4,-5,-6,-7,-8,-9,-2,-3,-4,-5,-6,-7,-8,-1,-2,-3,-4,-5,-6,-7,0,-1,-2,-3,-4,-5,1,0,-1,-2,-3,-4,2,1,0,-1,-2,-3,3,2,1,0,-1,-2,2,1,0,-1,2,1,0,1,-8,-9,-6,-7,-8,-9,-5,-6,-7,-8,-9,-4,-5,-6,-7,-8,-3,-4,-5,-6,-2,-3,-4,-5,-1,-2,-3,-4,0,-1,-2,-3,1,0,-1,-2,2,1,0,-1,1,0,1,-8,-9,-7,-8,-9,-6,-7,-5,-6,-4,-5,-3,-4,-2,-3,-1,-2,0,-1,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test action/12.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test edge_middle/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{0,-1,1,0,-1,1,0,-1,-1,1,1,0},{-1,0,0,1,-1,-1,-1,1,0,1,0,1},{-1,-1,-1,-1,0,0,1,0,1,0,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1},{-1,0,0,0,1,-1,-1,-1,0,0,0,1,1,1,-1,0,0,0,1},{0,-1,0,1,0,-1,0,1,-1,0,1,-1,0,1,0,-1,0,1,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test edge_middle/1-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test centroid_volume/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test centroid_volume/3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test permutahedron/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4},{2,2,3,3,4,4,1,1,3,3,4,4,1,1,2,2,4,4,1,1,2,2,3,3},{3,4,2,4,2,3,3,4,1,4,1,3,2,4,1,4,1,2,2,3,1,3,1,2},{4,3,4,2,3,2,4,3,4,1,3,1,4,2,4,1,2,1,3,2,3,1,2,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4},{2,2,3,3,3,4,4,1,1,2,2,2,3,3,3,3,4,4,4,1,1,1,2,2,2,2,3,3,3,4,4,1,1,2,2,2,3,3},{3,4,2,3,4,2,3,3,4,2,3,4,1,2,3,4,1,2,3,2,3,4,1,2,3,4,1,2,3,1,2,2,3,1,2,3,1,2},{4,3,4,3,2,3,2,4,3,4,3,2,4,3,2,1,3,2,1,4,3,2,4,3,2,1,3,2,1,2,1,3,2,3,2,1,2,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test permutahedron/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,3,-3,3,-3,3,-3,3,-3,3,-3,3,-3,3,-3,3,-3},{2,2,-2,-2,2,2,-2,-2,3,3,-3,-3,3,3,-3,-3,1,1,-1,-1,1,1,-1,-1,3,3,-3,-3,3,3,-3,-3,1,1,-1,-1,1,1,-1,-1,2,2,-2,-2,2,2,-2,-2},{3,3,3,3,-3,-3,-3,-3,2,2,2,2,-2,-2,-2,-2,3,3,3,3,-3,-3,-3,-3,1,1,1,1,-1,-1,-1,-1,2,2,2,2,-2,-2,-2,-2,1,1,1,1,-1,-1,-1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,-3,-3,-3,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,-2,-2,-2,-1,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,1,2,2,2},{-1,0,1,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-1,0,1,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-2,-1,0,1,2,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-3,-2,-1,0,1,2,3,-2,-1,0,1,2,-1,0,1,-1,0,1,-2,-1,0,1,2,-2,-1,0,1,2,-2,-1,0,1,2,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test permutahedron/3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5},{2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,4,4,4,4,4,4,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4},{3,3,4,4,5,5,2,2,4,4,5,5,2,2,3,3,5,5,2,2,3,3,4,4,3,3,4,4,5,5,1,1,4,4,5,5,1,1,3,3,5,5,1,1,3,3,4,4,2,2,4,4,5,5,1,1,4,4,5,5,1,1,2,2,5,5,1,1,2,2,4,4,2,2,3,3,5,5,1,1,3,3,5,5,1,1,2,2,5,5,1,1,2,2,3,3,2,2,3,3,4,4,1,1,3,3,4,4,1,1,2,2,4,4,1,1,2,2,3,3},{4,5,3,5,3,4,4,5,2,5,2,4,3,5,2,5,2,3,3,4,2,4,2,3,4,5,3,5,3,4,4,5,1,5,1,4,3,5,1,5,1,3,3,4,1,4,1,3,4,5,2,5,2,4,4,5,1,5,1,4,2,5,1,5,1,2,2,4,1,4,1,2,3,5,2,5,2,3,3,5,1,5,1,3,2,5,1,5,1,2,2,3,1,3,1,2,3,4,2,4,2,3,3,4,1,4,1,3,2,4,1,4,1,2,2,3,1,3,1,2},{5,4,5,3,4,3,5,4,5,2,4,2,5,3,5,2,3,2,4,3,4,2,3,2,5,4,5,3,4,3,5,4,5,1,4,1,5,3,5,1,3,1,4,3,4,1,3,1,5,4,5,2,4,2,5,4,5,1,4,1,5,2,5,1,2,1,4,2,4,1,2,1,5,3,5,2,3,2,5,3,5,1,3,1,5,2,5,1,2,1,3,2,3,1,2,1,4,3,4,2,3,2,4,3,4,1,3,1,4,2,4,1,2,1,3,2,3,1,2,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5},{2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4},{3,3,4,4,4,5,5,2,2,3,3,3,4,4,4,4,5,5,5,2,2,2,3,3,3,3,4,4,4,5,5,2,2,3,3,3,4,4,3,3,4,4,4,5,5,2,2,3,3,3,4,4,4,4,5,5,5,1,1,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,1,1,2,2,2,3,3,3,3,4,4,4,2,2,3,3,3,4,4,4,4,5,5,5,1,1,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,5,1,1,1,2,2,2,2,3,3,3,4,4,2,2,2,3,3,3,3,4,4,4,5,5,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,5,1,1,1,2,2,2,2,3,3,3,4,4,1,1,2,2,2,3,3,2,2,3,3,3,4,4,1,1,2,2,2,3,3,3,3,4,4,4,1,1,1,2,2,2,2,3,3,3,4,4,1,1,2,2,2,3,3},{4,5,3,4,5,3,4,4,5,3,4,5,2,3,4,5,2,3,4,3,4,5,2,3,4,5,2,3,4,2,3,3,4,2,3,4,2,3,4,5,3,4,5,3,4,4,5,3,4,5,2,3,4,5,2,3,4,4,5,3,4,5,2,3,4,5,1,2,3,4,5,1,2,3,4,3,4,5,2,3,4,5,1,2,3,4,5,1,2,3,4,1,2,3,3,4,2,3,4,1,2,3,4,1,2,3,4,5,3,4,5,2,3,4,5,2,3,4,4,5,3,4,5,2,3,4,5,1,2,3,4,5,1,2,3,4,3,4,5,2,3,4,5,1,2,3,4,5,1,2,3,4,1,2,3,2,3,4,5,1,2,3,4,5,1,2,3,4,1,2,3,1,2,2,3,4,1,2,3,4,1,2,3,1,2,3,4,5,2,3,4,5,2,3,4,2,3,3,4,5,2,3,4,5,1,2,3,4,5,1,2,3,4,1,2,3,2,3,4,5,1,2,3,4,5,1,2,3,4,1,2,3,1,2,2,3,4,1,2,3,4,1,2,3,1,2,2,3,1,2,3,1,2,3,4,2,3,4,2,3,3,4,2,3,4,1,2,3,4,1,2,3,2,3,4,1,2,3,4,1,2,3,1,2,2,3,1,2,3,1,2},{5,4,5,4,3,4,3,5,4,5,4,3,5,4,3,2,4,3,2,5,4,3,5,4,3,2,4,3,2,3,2,4,3,4,3,2,3,2,5,4,5,4,3,4,3,5,4,5,4,3,5,4,3,2,4,3,2,5,4,5,4,3,5,4,3,2,5,4,3,2,1,4,3,2,1,5,4,3,5,4,3,2,5,4,3,2,1,4,3,2,1,3,2,1,4,3,4,3,2,4,3,2,1,3,2,1,5,4,5,4,3,5,4,3,2,4,3,2,5,4,5,4,3,5,4,3,2,5,4,3,2,1,4,3,2,1,5,4,3,5,4,3,2,5,4,3,2,1,4,3,2,1,3,2,1,5,4,3,2,5,4,3,2,1,4,3,2,1,3,2,1,2,1,4,3,2,4,3,2,1,3,2,1,2,1,5,4,3,5,4,3,2,4,3,2,3,2,5,4,3,5,4,3,2,5,4,3,2,1,4,3,2,1,3,2,1,5,4,3,2,5,4,3,2,1,4,3,2,1,3,2,1,2,1,4,3,2,4,3,2,1,3,2,1,2,1,3,2,3,2,1,2,1,4,3,4,3,2,3,2,4,3,4,3,2,4,3,2,1,3,2,1,4,3,2,4,3,2,1,3,2,1,2,1,3,2,3,2,1,2,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test dual_linear_program/3-0.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test dual_linear_program/1-max.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,0,0,0},{79/48,1,37/6,3,1,1,0},{65/48,2,43/6,0,1,0,0},{31/24,0,0,4,0,1,0},{0,0,31/3,0,2,1,0},{0,0,0,65/2,3,27/2,1},{0,31/2,0,0,0,0,1},{-53/12,-7,-52/3,1,-2,1,0}};
desiredHB = matrix {{0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,4,4,5,6,6,7,8,8,9,14,15,20,21,34,48},{0,1,2,2,3,3,4,2,3,3,4,4,5,5,5,6,6,7,8,9,10,11,12,13,6,8,15,7,25,9,10,37,12,13,14,17,23,26,33,35,56,79},{0,1,0,2,1,3,0,4,3,5,2,6,1,5,7,0,8,9,10,11,12,13,14,15,4,8,17,5,29,7,8,43,10,11,12,15,19,22,27,29,46,65},{0,0,2,1,3,1,5,0,2,0,4,0,6,2,0,8,0,0,0,0,0,0,0,0,5,3,1,6,0,7,8,0,9,10,10,11,18,19,26,27,44,62},{0,2,2,1,1,3,1,0,0,2,0,4,0,4,6,0,8,10,12,14,16,18,20,22,1,7,23,0,42,1,0,62,1,0,2,5,0,3,0,1,0,0},{1,3,27,0,22,1,46,0,0,0,17,0,41,0,0,65,0,0,0,0,0,0,0,2,15,0,0,10,1,8,3,0,1,0,0,0,0,0,2,0,1,0},{1,0,0,2,0,0,0,31,7,28,0,25,0,1,22,0,19,16,13,10,7,4,1,0,0,0,0,0,0,0,0,0,0,4,1,0,1,0,0,0,0,0},{0,-2,2,-6,-2,-8,2,-14,-10,-16,-6,-18,-2,-14,-20,2,-22,-24,-26,-28,-30,-32,-34,-36,-12,-22,-42,-16,-70,-22,-26,-104,-32,-36,-38,-46,-62,-70,-88,-94,-150,-212}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test dual_linear_program/1-min.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,0,0,0},{1,1,1,0},{0,1,0,0},{0,0,1,0},{4,2,1,0},{43/2,3,27/2,1},{0,0,0,1},{3,-2,1,0}};
desiredHB = matrix {{0,0,0,1,2},{0,1,2,2,2},{0,1,0,0,0},{0,0,2,1,0},{0,2,2,5,8},{1,3,27,35,43},{1,0,0,0,0},{0,-2,2,4,6}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test dual_linear_program/3-max.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,0,0,0},{0,1,0,0},{1,1,0,0},{0,0,1,0},{5,0,1,0},{0,0,0,1},{1,0,0,1}};
desiredHB = matrix {{0,0,0,1},{0,0,1,0},{0,0,1,1},{0,1,0,0},{0,1,0,5},{1,0,0,0},{1,0,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test dual_linear_program/3-min.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,0,0,0},{1,1,0,0},{0,1,0,0},{5,0,1,0},{0,0,1,0},{1,0,0,1},{0,0,0,1}};
desiredHB = matrix {{0,0,0,1},{0,0,1,1},{0,0,1,0},{0,1,0,5},{0,1,0,0},{1,0,0,1},{1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test dual_linear_program/1-0.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{29,7,41/2,40,40,40,40,40},{7,7,21/2,21/2,7,21/2,7,245/24},{22,0,0,39/2,0,0,11,165/8},{2,2,3,3,2,3,2,35/12}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,11,11,11,11,11,11,11,11,11,11,13,13,24,24},{7,8,8,9,9,9,10,10,10,10,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,38,38,38,38,38,38,38,38,38,38,38,38,38,38,39,39,39,39,39,39,39,39,39,39,39,39,39,40,40,40,40,40,40,40,40,40,40,40,40,41,42,42,43,43,43,44,44,44,44,45,45,45,45,45,46,46,46,46,46,46,47,47,47,47,47,47,47,48,48,48,48,48,48,48,48,49,49,49,49,49,49,49,49,49,50,50,50,50,50,50,50,50,50,50,51,51,51,51,51,51,51,51,51,51,51,52,52,52,52,52,52,52,52,52,52,52,52,53,53,53,53,53,53,53,53,53,53,53,53,53,54,54,54,54,54,54,54,54,54,54,54,54,54,54,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,110,110,111,111,111,111,112,112,112,112,113,113,113,113,114,114,114,114,115,115,115,115,116,116,116,116,117,117,117,117,118,118,118,118,119,119,119,119,120,120,120,120,192,192,193,193,193,193,194,194,194,194,195,195,195,195,196,196,196,196,197,197,197,197,198,198,198,198,199,199,199,199,200,200,200,200,274,274,275,275,275,275,276,276,276,276,277,277,277,277,278,278,278,278,279,279,279,279,280,280,280,280,356,356,357,357,357,357,358,358,358,358,359,359,359,359,360,360,360,360,438,438,439,439,439,439,440,440,440,440,520,520,960,960},{7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,112,112,112,112,112,112,112,112,112,112,133,133,245,245},{0,0,1,0,1,2,0,1,2,3,0,1,2,3,4,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,11,0,1,2,3,4,5,6,7,8,9,10,11,12,0,1,2,3,4,5,6,7,8,9,10,11,12,13,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,0,1,2,3,4,5,6,7,8,9,10,11,12,13,0,1,2,3,4,5,6,7,8,9,10,11,12,0,1,2,3,4,5,6,7,8,9,10,11,0,0,1,0,1,2,0,1,2,3,0,1,2,3,4,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,11,0,1,2,3,4,5,6,7,8,9,10,11,12,0,1,2,3,4,5,6,7,8,9,10,11,12,13,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,61,62,60,61,62,63,59,60,61,62,58,59,60,61,57,58,59,60,56,57,58,59,55,56,57,58,54,55,56,57,53,54,55,56,52,53,54,55,51,52,53,54,102,103,101,102,103,104,100,101,102,103,99,100,101,102,98,99,100,101,97,98,99,100,96,97,98,99,95,96,97,98,94,95,96,97,143,144,142,143,144,145,141,142,143,144,140,141,142,143,139,140,141,142,138,139,140,141,137,138,139,140,184,185,183,184,185,186,182,183,184,185,181,182,183,184,180,181,182,183,225,226,224,225,226,227,223,224,225,226,266,267,494,495},{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,32,32,32,32,32,32,32,32,32,32,38,38,70,70}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test CUBICAL/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test SCHLEGEL_SOLID/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test TRIANGULATION_BOUNDARY/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1},{0,1,0,0},{0,0,1,0},{0,0,0,2}};
desiredHB = matrix {{1,1,1,1,1},{0,0,0,0,1},{0,0,0,1,0},{0,1,2,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test TRIANGULATION_BOUNDARY/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test 2-face-sizes-simple/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test 2-face-sizes-simple/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{5/8,-5/8,0,0,0,0,0,0},{0,0,5/8,-5/8,0,0,0,0},{0,0,0,0,5/8,-5/8,0,0},{0,0,0,0,0,0,5/8,-5/8}};
desiredHB = matrix {{1,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8},{0,-1,0,0,0,0,0,0,1,-3,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,-5,-4,-4,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,5},{0,0,-1,0,0,0,0,1,0,0,-1,0,0,0,0,1,-2,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,2,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,3,-2,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,2,-1,0,0,0,0,1,0,0,-1,0,0,0,0,1,-2,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,2,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,3,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,-5,-4,-4,-4,-4,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,5,-4,-3,-3,-3,-3,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,3,-2,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,2,-1,0,0,0,0,1,0},{0,0,0,-1,0,0,1,0,0,0,0,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,0,0,0,0,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-4,-3,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,3,4,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-4,-3,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,3,4,-5,-4,-4,-3,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,3,4,4,5,-4,-3,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,3,4,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-4,-3,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,3,4,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0,0,-1,0,0,1,0,0},{0,0,0,0,-1,1,0,0,0,0,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,0,0,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-4,4,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-4,4,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-4,4,-5,5,-4,4,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-4,4,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-4,4,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0,0,0,-1,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/11-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{0,0,1,-1,0,0},{0,1,0,0,-1,0},{1,0,0,0,0,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,1},{0,-1,0,0,0,1,0},{0,0,-1,0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/6.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1/4,-1/4,-1/4,-1/4,1/4,1/4,1/4,1/4,1/2,1/2,1/2,1/2,1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,-1/2,-1/2,-1/2,-1/2},{-1/2,-1/2,-1/4,1/4,-1/2,-1/2,-1/4,1/2,-1/4,1/4,1/4,-1/4,1/2,1/4,1/4,-1/4,1/2,1/2,1/4,-1/4,1/4,1/4,-1/4,-1/4},{1/4,-1/4,1/2,1/2,-1/4,1/4,1/2,-1/4,1/4,1/4,-1/4,-1/4,1/4,1/2,-1/2,-1/2,1/4,-1/4,-1/2,-1/2,-1/4,1/4,1/4,-1/4}};
desiredHB = matrix {{1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},{0,-1,0,0,0,0,1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,1,1,1,1,1,1,1,1,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2},{0,0,-1,0,0,1,0,-1,-1,-1,0,0,1,1,1,-1,-1,1,1,-1,-1,-1,0,0,1,1,1,-1,-1,-1,0,0,1,1,1,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,-2,-2,-1,-1,1,1,2,2,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,-1,-1,-1,0,0,1,1,1},{0,0,0,-1,1,0,0,-1,0,1,-1,1,-1,0,1,-1,1,-1,1,-1,0,1,-1,1,-1,0,1,-1,0,1,-1,1,-1,0,1,-1,0,1,-2,2,-2,2,-2,2,-1,0,1,-1,1,-2,2,-2,2,-1,1,-1,0,1,-2,2,-2,2,-2,2,-1,0,1,-1,0,1,-1,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/11.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{0,-1/2,0,1/2,1/2,1/2,1/2,0,-1/2,-1/2,0,-1/2},{-1/2,0,1/2,-1/2,0,1/2,0,1/2,1/2,0,-1/2,-1/2},{1/2,1/2,1/2,0,-1/2,0,1/2,-1/2,0,-1/2,-1/2,0}};
desiredHB = matrix {{1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3},{0,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{0,-1,0,0,0,1,-1,-1,-1,0,0,1,1,1,-1,0,0,0,1,-1,-1,1,1,-1,-1,1,1},{0,0,-1,0,1,0,-1,0,1,-1,1,-1,0,1,0,-1,0,1,0,-1,1,-1,1,-1,1,-1,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1,1,1/2},{0,0,1,1,0,0,1,1,1/2,1},{0,0,0,0,1,1,1,1/2,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,2,2,2},{0,0,0,0,1,1,1,1,2,2},{0,0,1,1,0,0,1,2,1,2},{0,1,0,1,0,1,0,2,2,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/2-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/4.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{1,0,1,1,0,0},{1,0,0,1,0,1},{0,0,1,1,1,0}};
desiredHB = matrix {{1,1,1,1,1,1},{0,0,0,1,1,1},{0,0,1,0,1,1},{0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/5-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/1-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/3-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{0,0,1,0,1,1,2/3,1,1,0,0,1/3},{0,1,1,0,0,1,0,1/3,0,1,2/3,1},{0,0,0,1,1,1,0,0,1/3,2/3,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3},{0,0,0,1,1,1,0,0,1,1,2,2,0,0,1,2,3,3},{0,0,1,0,1,1,1,2,0,2,0,1,2,3,3,0,0,1},{0,1,0,1,0,1,2,1,0,2,1,0,3,2,3,0,1,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/5.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,0,1,1},{1,1/2,0,0,0,1,1/2,1},{0,0,0,1/2,1,1,1,1/2}};
desiredHB = matrix {{1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3},{0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,3},{0,0,1,1,0,1,1,1,2,0,1,1,1,2,1,1,2,2},{0,1,0,1,1,0,1,2,1,1,0,1,2,1,1,2,1,2}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,1/2,1,1,1,1/2,1,1,1/2,1,1,1,1/2},{0,1,0,1,0,1/4,0,3/4,1,1,0,0,1/4,1,3/4,1},{0,0,1,1,0,0,1/4,0,0,1/4,3/4,1,1,3/4,1,1}};
desiredHB = matrix {{1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4},{0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4},{0,0,1,1,0,0,0,1,1,1,2,2,2,0,1,1,1,2,0,0,1,1,1,1,2,2,2,2,3,3,0,0,1,1,3,3,4,4},{0,1,0,1,0,1,2,0,1,2,0,1,2,1,0,1,2,1,1,2,0,1,2,3,0,1,2,3,1,2,1,3,0,4,0,4,1,3}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/4-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test truncation/6-in.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{1/2,1/2,1/2,1/2,-1/2,-1/2,-1/2,-1/2,0,0,0,0},{1/2,-1/2,0,0,1/2,-1/2,0,0,1/2,1/2,-1/2,-1/2},{0,0,1/2,-1/2,0,0,1/2,-1/2,1/2,-1/2,1/2,-1/2}};
desiredHB = matrix {{1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3},{0,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{0,-1,0,0,0,1,-1,-1,-1,0,0,1,1,1,-1,0,0,0,1,-1,-1,1,1,-1,-1,1,1},{0,0,-1,0,1,0,-1,0,1,-1,1,-1,0,1,0,-1,0,1,0,-1,1,-1,1,-1,1,-1,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test FAR_HYPERPLANE/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1},{0,1,0,0},{1,0,0,0},{0,0,1,0}};
desiredHB = matrix {{1,1,1,1},{0,0,0,1},{0,0,1,0},{0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test compose/in1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test compose/in2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1},{3/2,-3/2,0,0,0,0},{0,0,3/2,-3/2,0,0},{0,0,0,0,3/2,-3/2}};
desiredHB = matrix {{1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2},{-1,0,0,0,0,0,1,-3,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,3},{0,-1,0,0,0,1,0,0,-1,0,0,1,-2,-1,-1,0,0,1,1,2,-3,-2,-2,-1,-1,0,0,1,1,2,2,3,-2,-1,-1,0,0,1,1,2,-1,0,0,1,0},{0,0,-1,0,1,0,0,0,0,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,-2,2,-3,3,-2,2,-1,1,0,0,-1,1,-2,2,-1,1,0,0,-1,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test facets_from_incidence/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1/3,-1/3,0,0,-1/3,0,0,1/3,1/3,2/3,2/3,2/3,2/3,1/3,1/3,0,0,0,0,-1/3,-2/3,-2/3,-2/3,-2/3},{-2/3,0,-2/3,-1/3,2/3,1/3,2/3,-2/3,2/3,0,1/3,0,-1/3,0,0,2/3,1/3,-1/3,-2/3,0,1/3,0,0,-1/3},{0,-2/3,-1/3,-2/3,0,-2/3,-1/3,0,0,1/3,0,-1/3,0,2/3,-2/3,1/3,2/3,2/3,1/3,2/3,0,1/3,-1/3,0}};
desiredHB = matrix {{1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{0,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,1,1,1,1,1,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2},{0,-1,0,0,0,1,-1,-1,-1,0,0,1,1,1,-1,0,0,0,1,-1,0,0,0,1,-2,-1,-1,0,0,1,1,2,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,-2,-1,-1,0,0,1,1,2,-1,0,0,0,1},{0,0,-1,0,1,0,-1,0,1,-1,1,-1,0,1,0,-1,0,1,0,0,-1,0,1,0,0,-1,1,-2,2,-1,1,0,-1,0,1,-2,2,-2,2,-2,2,-1,0,1,0,-1,1,-2,2,-1,1,0,0,-1,0,1,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test graph_from_face_lattice/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test graph_from_face_lattice/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test splits_in_subdivision/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test FACE_SIMPLICITY/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{0,1,0,1,0},{1,0,0,1,0},{0,0,1,1,2}};
desiredHB = matrix {{1,1,1,1,1,2},{0,0,0,1,1,1},{0,0,1,0,1,1},{1,2,0,0,1,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test FACE_SIMPLICITY/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1},{0,1,0,0},{1,0,0,0},{0,0,1,0}};
desiredHB = matrix {{1,1,1,1},{0,0,0,1},{0,0,1,0},{0,1,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test SCHLEGEL_CONSTRUCTION/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test product/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,1,1,1,1},{0,0,0,0,1,1,1,1,0,0,0,0},{0,0,2,2,0,0,2,2,0,0,2,2},{0,2,0,2,0,2,0,2,0,2,0,2}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0},{0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2},{0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test product/4.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,0,0,0},{0,1,1,0,0},{0,1,0,0,0},{2,2,0,1,1},{2,2,0,-1,1}};
desiredHB = matrix {{0,0,0,0,1,1},{0,0,0,1,0,1},{0,0,0,0,0,1},{1,1,1,0,2,2},{-1,0,1,0,2,2}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test product/3.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,0,0,0},{0,1,1,0,0},{0,1,0,0,0},{2,2,0,1,1},{2,2,0,-1,1}};
desiredHB = matrix {{0,0,0,0,1,1},{0,0,0,1,0,1},{0,0,0,0,0,1},{1,1,1,0,2,2},{-1,0,1,0,2,2}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test mapping_polytope/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1},{0,1/2,0,1/2,0,1,1/2,1/2,0},{0,1/2,0,-1/2,0,0,-1/2,1/2,0},{1/2,0,0,0,1/2,0,1/2,1/2,1},{1/2,0,0,0,-1/2,0,1/2,-1/2,0}};
desiredHB = matrix {{1,1,1,2,2,2,2,2,2},{0,0,1,0,0,1,1,1,1},{0,0,0,0,0,-1,-1,1,1},{0,1,0,1,1,0,1,0,1},{0,0,0,-1,1,0,1,0,-1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test mapping_polytope/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{-1,1,1,-1,1,-1,1,-1},{2,0,0,2,-2,0,-2,0},{0,-2,0,2,0,2,-2,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,2,2,2,-1,-1,-1,0,0,0,1,1,1,-2,-2,-2,-1,-1,-1,0,0,0},{0,1,2,0,1,2,0,1,2,-1,0,1,-1,0,1,-1,0,1,-2,-1,0,-2,-1,0,-2,-1,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test CUBICALITY/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1},{0,1,0,0},{0,0,1,0},{0,0,0,2}};
desiredHB = matrix {{1,1,1,1,1},{0,0,0,0,1},{0,0,0,1,0},{0,1,2,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test CUBICALITY/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test canonical_coord/2R.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,0,0,0,0},{2,3/2,1,-1,0,0},{3,2,-1,1,0,0},{4,5/2,2,-2,1,0},{5,3,-2,2,-1,0}};
desiredHB = matrix {{0,1,2},{0,0,0},{0,5,7},{1,0,-1},{-1,9,12}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test simplex/7l.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1},{0,0,0,1},{0,0,2,2},{0,3,3,3}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,1},{0,0,0,0,1,1,2,2},{0,1,2,3,2,3,3,3}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test simplex/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1,0},{0,0,0,0,1}};
desiredHB = matrix {{1,1,1,1,1},{0,0,0,0,1},{0,0,0,1,0},{0,0,1,0,0},{0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test simplex/6f.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1},{1,0,0,0,0,0,-1},{0,1,0,0,0,0,-1},{0,0,1,0,0,0,-1},{0,0,0,1,0,0,-1},{0,0,0,0,1,0,-1},{0,0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,1},{-1,0,0,0,0,0,1,0},{-1,0,0,0,0,1,0,0},{-1,0,0,0,1,0,0,0},{-1,0,0,1,0,0,0,0},{-1,0,1,0,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test simplex/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{0,5/8,0,0,0},{0,0,5/8,0,0},{0,0,0,5/8,0},{0,0,0,0,5/8}};
desiredHB = matrix {{1,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8},{0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,5},{0,0,0,1,0,0,0,0,0,1,1,1,2,2,3,0,0,0,1,1,2,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,0,0,0,0,0,1,1,1,1,2,2,2,3,3,4,0,0,0,0,1,1,1,2,2,3,0,0,0,1,1,2,0,0,1,0},{0,0,1,0,0,0,1,2,3,0,1,2,0,1,0,0,1,2,0,1,0,0,1,0,0,0,1,2,3,4,5,0,1,2,3,4,0,1,2,3,0,1,2,0,1,0,0,1,2,3,4,0,1,2,3,0,1,2,0,1,0,0,1,2,3,0,1,2,0,1,0,0,1,2,0,1,0,0,1,0,0},{0,1,0,0,0,3,2,1,0,2,1,0,1,0,0,2,1,0,1,0,0,1,0,0,0,5,4,3,2,1,0,4,3,2,1,0,3,2,1,0,2,1,0,1,0,0,4,3,2,1,0,3,2,1,0,2,1,0,1,0,0,3,2,1,0,2,1,0,1,0,0,2,1,0,1,0,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test triang_boundary/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,1,1,1,1},{0,0,1,1,0,0,1,1},{0,1,0,1,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test triang_boundary/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1},{0,1,0,1,0,1,0,1,1/2},{0,0,1,1,0,0,1,1,1/2},{0,0,0,0,1,1,1,1,3/2}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,2},{0,0,0,0,1,1,1,1,1},{0,0,1,1,0,0,1,1,1},{0,1,0,1,0,1,0,1,3}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test birkhoff/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{1,0,0,1,0,0,0,0,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0},{0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1},{0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0},{0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,1,0,0,1,0,0},{0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},{1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0},{0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1},{0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0},{0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0},{0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0},{1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0},{0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0},{1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0},{0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0},{1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0},{0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1},{1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0},{0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0},{0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0},{1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0},{0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1},{0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0},{1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0},{0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0},{0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0},{0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test birkhoff/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1},{1,0,0,0,1,0,1,0,0,0,0,0},{0,0,1,0,0,1,0,0,0,0,1,0},{0,1,0,0,0,0,0,0,1,0,0,1},{0,0,0,1,0,0,0,1,0,1,0,0},{0,1,0,0,0,1,0,1,0,0,0,0},{1,0,0,1,0,0,0,0,0,0,0,1},{0,0,1,0,0,0,1,0,0,1,0,0},{0,0,0,0,1,0,0,0,1,0,1,0},{0,0,1,1,0,0,0,0,1,0,0,0},{0,1,0,0,1,0,0,0,0,1,0,0},{1,0,0,0,0,0,0,1,0,0,1,0},{0,0,0,0,0,1,1,0,0,0,0,1},{0,0,0,0,0,0,0,0,0,1,1,1},{0,0,0,0,0,0,1,1,1,0,0,0},{0,0,0,1,1,1,0,0,0,0,0,0},{1,1,1,0,0,0,0,0,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3},{0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1},{0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1},{1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0},{0,0,1,0,0,1,0,0,1,0,0,0,1,1,1,0,1,1,0,1,1,0,1,1},{0,1,0,0,1,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,1,1,0,1},{1,0,0,0,0,0,0,1,0,0,1,0,1,0,1,1,0,1,1,1,1,1,1,0},{0,0,0,1,0,0,1,0,0,1,0,0,1,1,0,1,1,0,1,1,0,1,1,1},{0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,0,1,0,1,1,1,0},{1,0,0,0,0,1,0,0,0,1,0,0,1,0,1,1,1,1,1,1,0,0,1,1},{0,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,0,1},{0,0,0,0,1,0,0,0,1,0,1,0,0,1,1,1,0,1,0,1,1,1,1,1},{1,0,0,0,1,0,1,0,0,0,0,0,1,1,1,1,0,1,1,1,0,1,0,1},{0,0,1,1,0,0,0,0,0,0,1,0,1,1,0,1,1,1,0,1,1,1,1,0},{0,1,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,0,1,1,1,0,1,1},{0,0,0,0,0,1,0,1,0,0,0,1,1,0,1,0,1,1,1,0,1,1,1,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test split_polyhedron/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{4,4/3,20/3,4,4,4/3,4/3,4/3,20/3,4/3,4,4,4/3,4,4,20/3,4,20/3,4,4/3,20/3,28/3},{4/3,4,4,4,4/3,20/3,4,20/3,4/3,4,20/3,20/3,28/3,20/3,4,4,4/3,4/3,4/3,4,4,4/3},{4/3,4,4/3,4/3,4,4,20/3,20/3,4/3,4,4/3,4,4,4/3,20/3,4,20/3,4,20/3,28/3,4,4/3},{28/3,20/3,4,20/3,20/3,4,4,4/3,20/3,20/3,4,4/3,4/3,4,4/3,4/3,4,4,4,4/3,4/3,4},{20/3,28/3,4,20/3,20/3,4,4,20/3,4/3,20/3,4,4/3,4,4/3,4/3,4/3,4,4,4/3,4,4,4/3},{4,4/3,4/3,4/3,4,4,20/3,4/3,20/3,4,4/3,4,4/3,4,20/3,4,20/3,4,28/3,20/3,4/3,4},{4,4/3,4,4,4/3,20/3,4,4/3,20/3,4,20/3,20/3,20/3,28/3,4,4,4/3,4/3,4,4/3,4/3,4},{4/3,4,20/3,4,4,4/3,4/3,20/3,4/3,4/3,4,4,4,4/3,4,20/3,4,20/3,4/3,4,28/3,20/3}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3},{2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,18,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27,27,28},{4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,8,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,2,2,2,2,3,3,3,3,2,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,18,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,17,17,17,17,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,3,3,3,3,4,4,4,4,3,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,27,27,27,27,28,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,27,27,27,27,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,26,26,26,26,26,26,26,26,26,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,4,4,4,4,5,5,5,5,4},{4,4,4,5,5,5,6,6,6,7,7,8,4,4,4,5,5,5,5,6,6,6,7,7,4,4,4,5,5,5,6,6,6,4,4,5,5,4,3,3,4,4,4,5,5,5,6,6,6,7,7,3,3,3,4,4,4,4,5,5,5,5,6,6,6,7,7,3,3,3,4,4,4,4,5,5,5,5,6,6,6,3,3,3,4,4,4,5,5,5,3,3,4,4,2,3,3,4,4,4,5,5,5,6,6,6,2,2,3,3,3,4,4,4,4,5,5,5,5,6,6,6,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,6,6,6,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,2,2,2,3,3,3,4,4,4,2,2,3,3,3,4,4,4,4,5,5,5,2,2,2,3,3,3,3,4,4,4,4,5,5,5,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,2,2,2,3,3,3,4,4,4,2,2,2,3,3,3,4,4,4,2,2,2,3,3,3,4,4,4,2,2,2,3,3,3,4,4,4,2,2,3,3,2,2,3,3,2,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,16,16,16,17,17,18,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,12,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,16,16,16,17,17,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,16,16,16,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,12,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,8,8,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,11,11,11,12,12,12,12,12,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,8,8,8,9,9,9,10,10,10,8,8,9,9,8,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,16,16,16,17,17,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,7,7,7,7,7,8,8,9,9,10,10,11,11,11,11,11,7,7,7,7,8,8,9,9,10,10,10,10,7,7,7,8,8,9,9,9,7,7,8,8,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,16,16,16,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,6,6,6,6,7,7,8,8,9,9,9,9,6,6,6,7,7,7,8,8,8,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,15,15,15,15,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,5,5,5,5,5,6,6,7,7,8,8,9,9,9,9,9,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,4,4,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,3,4,4,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,13,13,13,13,13,13,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,10,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,9,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,3,3,4,4,4,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,12,12,12,12,12,12,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,10,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,9,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,3,3,3,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,3,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,3,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,9,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,3,3,3,3,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,3,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,3,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,9,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,3,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,8,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,8,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,8,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,8,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,3,3,3,3,3,4,4,5,5,6,6,7,7,7,7,7,3,3,3,3,3,4,4,5,5,6,6,7,7,7,7,7,3,3,3,3,3,4,4,5,5,6,6,7,7,7,7,7,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,3,3,3,3,4,4,5,5,6,6,6,6,3,3,3,3,4,4,5,5,6,6,6,6,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,3,3,3,4,4,4,5,5,5,3,3,3,4,4,5,5,5,3,3,3,4,4,4,5,5,5,3,3,4,4,3,3,4,4,3,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,25,25,25,25,26,26,26,27,27,28,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,25,25,25,25,26,26,26,27,27,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,25,25,25,25,26,26,26,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,25,25,25,25,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,12,12,12,12,12,12,12,13,13,13,13,13,13,13,14,14,14,14,14,14,14,15,15,15,15,15,15,15,16,16,16,16,16,16,16,17,17,17,17,17,17,17,18,18,18,18,18,18,18,12,12,12,12,12,12,13,13,13,13,13,13,14,14,14,14,14,14,15,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,17,12,12,12,12,12,13,13,13,13,13,14,14,14,14,14,15,15,15,15,15,16,16,16,16,16,12,12,12,12,13,13,13,13,14,14,14,14,15,15,15,15,12,12,12,13,13,13,14,14,14,12,12,13,13,12,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,25,25,25,25,26,26,26,27,27,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,26,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,25,25,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,24,24,24,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,11,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,11,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,11,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,11,11,11,11,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,11,11,11,11,11,12,12,13,13,14,14,15,15,15,15,15,11,11,11,11,12,12,13,13,14,14,14,14,11,11,11,12,12,13,13,13,11,11,12,12,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,25,25,25,25,26,26,26,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,26,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,26,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,25,25,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,24,24,24,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,10,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,10,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,10,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,10,10,10,10,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,10,10,10,10,10,11,11,12,12,13,13,14,14,14,14,14,10,10,10,10,11,11,12,12,13,13,13,13,10,10,10,11,11,11,12,12,12,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,25,25,25,25,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,25,25,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,25,25,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,25,25,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,24,24,24,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,18,9,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,9,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,9,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,9,9,9,9,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,9,9,9,9,9,10,10,11,11,12,12,13,13,13,13,13,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,12,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,24,24,24,24,24,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,24,24,24,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,24,24,24,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,24,24,24,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,24,24,24,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,18,18,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,17,8,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,8,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,8,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,8,8,8,8,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,8,8,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,11,11,11,12,12,12,12,12,7,7,7,7,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,23,23,23,23,23,23,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,23,23,23,23,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,18,18,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,16,7,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,7,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,7,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,22,22,22,22,22,22,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,18,18,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,17,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,16,16,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,15,6,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,6,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,12,12,12,12,12,12,12,5,5,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,21,21,21,21,21,21,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,18,18,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,17,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,16,16,16,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,15,15,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,5,5,5,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,4,5,5,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,20,20,20,20,20,20,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,18,18,18,18,18,18,18,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,17,17,17,17,17,17,17,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,16,16,16,16,16,16,16,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,15,15,15,15,15,15,15,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,14,14,14,14,14,14,14,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,13,13,13,13,13,13,13,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,4,4,4,4,4,5,5,6,6,7,7,8,8,8,8,8,4,4,4,4,4,5,5,6,6,7,7,8,8,8,8,8,4,4,4,4,4,5,5,6,6,7,7,8,8,8,8,8,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,4,4,4,4,5,5,6,6,7,7,7,7,4,4,4,4,5,5,6,6,7,7,7,7,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,4,4,4,5,5,5,6,6,6,4,4,4,5,5,6,6,6,4,4,4,5,5,5,6,6,6,4,4,5,5,4,4,5,5,4},{6,6,6,5,5,5,4,4,4,3,3,2,5,5,5,4,4,4,4,3,3,3,2,2,4,4,4,3,3,3,2,2,2,3,3,2,2,2,7,7,6,6,6,5,5,5,4,4,4,3,3,6,6,6,5,5,5,5,4,4,4,4,3,3,3,2,2,5,5,5,4,4,4,4,3,3,3,3,2,2,2,4,4,4,3,3,3,2,2,2,3,3,2,2,8,7,7,6,6,6,5,5,5,4,4,4,7,7,6,6,6,5,5,5,5,4,4,4,4,3,3,3,6,6,6,5,5,5,5,4,4,4,4,4,3,3,3,3,2,2,2,5,5,5,4,4,4,4,3,3,3,3,2,2,2,2,4,4,4,3,3,3,2,2,2,7,7,6,6,6,5,5,5,5,4,4,4,6,6,6,5,5,5,5,4,4,4,4,3,3,3,5,5,5,5,4,4,4,4,3,3,3,3,2,2,2,4,4,4,3,3,3,2,2,2,6,6,6,5,5,5,4,4,4,5,5,5,4,4,4,3,3,3,4,4,4,3,3,3,2,2,2,5,5,4,4,4,4,3,3,4,13,13,13,13,13,13,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,4,4,3,12,12,12,12,12,12,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,5,5,5,5,4,4,4,3,3,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,4,4,4,4,3,3,3,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,3,3,3,3,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,7,7,7,7,7,6,6,6,6,6,5,5,5,5,5,4,4,4,4,4,3,3,3,3,3,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,5,5,5,4,4,4,3,3,3,4,4,3,3,3,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,4,4,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,8,8,8,8,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,7,7,7,7,7,6,6,5,5,4,4,3,3,3,3,3,6,6,6,6,5,5,4,4,3,3,3,3,5,5,5,4,4,3,3,3,4,4,3,3,15,15,15,15,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,8,8,8,8,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,7,7,7,7,7,6,6,5,5,4,4,3,3,3,3,3,6,6,6,6,5,5,4,4,3,3,3,3,5,5,5,4,4,4,3,3,3,16,16,16,15,15,15,15,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,8,8,8,8,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,7,7,7,7,7,6,6,5,5,4,4,3,3,3,3,3,6,6,6,6,5,5,5,5,4,4,4,4,3,3,3,3,17,17,16,16,16,15,15,15,15,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,3,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,8,8,8,8,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,7,7,7,7,7,6,6,6,6,6,5,5,5,5,5,4,4,4,4,4,3,3,3,3,3,18,17,17,16,16,16,15,15,15,15,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,3,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,3,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,17,17,16,16,16,15,15,15,15,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,12,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,3,9,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,16,16,16,15,15,15,15,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,10,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,9,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,15,15,15,15,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,10,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,9,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,3,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,12,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,9,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,3,3,3,3,3,3,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,13,13,13,13,13,13,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,12,12,12,12,12,11,11,11,11,11,10,10,10,10,10,9,9,9,9,9,8,8,8,8,8,11,11,11,11,11,10,10,9,9,8,8,7,7,7,7,7,10,10,10,10,10,9,9,8,8,7,7,6,6,6,6,6,9,9,9,9,9,8,8,7,7,6,6,5,5,5,5,5,8,8,8,8,8,7,7,7,7,7,6,6,6,6,6,5,5,5,5,5,4,4,4,4,4,11,11,11,11,10,10,10,10,9,9,9,9,8,8,8,8,10,10,10,10,9,9,8,8,7,7,7,7,9,9,9,9,8,8,7,7,6,6,6,6,8,8,8,8,7,7,7,7,6,6,6,6,5,5,5,5,10,10,10,9,9,9,8,8,8,9,9,9,8,8,7,7,7,8,8,8,7,7,7,6,6,6,9,9,8,8,8,8,7,7,8,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,7,7,7,7,6,6,6,5,5,4,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,5,5,5,4,4,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,5,5,5,5,4,4,4,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,4,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,8,8,8,8,8,7,7,7,7,7,6,6,6,6,6,5,5,5,5,5,4,4,4,4,4,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,6,6,6,5,5,5,4,4,4,5,5,4,4,4,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,7,7,7,7,6,6,6,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,8,8,8,8,8,7,7,6,6,5,5,4,4,4,4,4,7,7,7,7,6,6,5,5,4,4,4,4,6,6,6,5,5,4,4,4,5,5,4,4,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,7,7,7,7,6,6,6,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,8,8,8,8,8,7,7,6,6,5,5,4,4,4,4,4,7,7,7,7,6,6,5,5,4,4,4,4,6,6,6,5,5,5,4,4,4,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,7,7,7,7,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,8,8,8,8,8,7,7,6,6,5,5,4,4,4,4,4,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,9,9,9,9,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,8,8,8,8,8,7,7,7,7,7,6,6,6,6,6,5,5,5,5,5,4,4,4,4,4,25,25,25,25,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,24,24,24,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,10,10,10,10,10,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,26,26,26,25,25,25,25,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,25,25,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,24,24,24,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,4,27,27,26,26,26,25,25,25,25,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,26,26,26,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,25,25,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,24,24,24,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,28,27,27,26,26,26,25,25,25,25,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,27,27,26,26,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,26,26,26,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,25,25,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,24,24,24,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,27,27,26,26,26,25,25,25,25,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,26,26,26,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,25,25,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,24,24,24,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,19,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,18,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,26,26,26,25,25,25,25,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,25,25,25,25,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,24,24,24,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,19,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,18,18,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,17,17,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,25,25,25,25,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,24,24,24,24,24,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,19,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,18,18,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,17,17,17,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,16,16,16,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,24,24,24,24,24,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,23,23,23,23,23,23,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,19,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,18,18,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,17,17,17,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,15,15,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,23,23,23,23,23,23,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,22,22,22,22,22,22,22,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,19,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,18,18,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,17,17,17,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,16,16,16,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,15,15,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,14,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,21,21,21,21,21,21,21,21,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,19,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,18,18,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,17,17,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,16,16,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,15,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,14,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,13,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,20,20,20,20,20,20,20,20,20,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,19,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,18,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,17,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,16,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,13,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,4,4,4,4,4,4,4,4,4,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,19,19,19,19,19,19,19,19,19,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,11,18,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,10,17,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,9,16,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,8,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,7,14,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,6,13,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,12,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,18,18,18,18,18,18,18,18,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,11,17,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,10,16,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,9,15,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,8,14,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,7,13,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,6,6,6,6,6,6,6,6,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,18,18,18,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,15,15,15,15,15,15,15,14,14,14,14,14,14,14,13,13,13,13,13,13,13,12,12,12,12,12,12,12,17,17,17,17,17,17,17,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,11,16,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,10,15,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,9,14,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,8,13,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,7,7,7,7,7,7,7,12,12,12,12,12,12,12,11,11,11,11,11,11,11,10,10,10,10,10,10,10,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,17,17,17,17,17,17,16,16,16,16,16,16,15,15,15,15,15,15,14,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,16,16,16,16,16,16,15,15,14,14,13,13,12,12,11,11,11,11,11,11,15,15,15,15,15,15,14,14,13,13,12,12,11,11,10,10,10,10,10,10,14,14,14,14,14,14,13,13,12,12,11,11,10,10,9,9,9,9,9,9,13,13,13,13,13,13,12,12,11,11,10,10,9,9,8,8,8,8,8,8,12,12,12,12,12,12,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,13,13,13,13,13,12,12,12,12,12,15,15,15,15,15,14,14,13,13,12,12,11,11,11,11,11,14,14,14,14,14,13,13,12,12,11,11,10,10,10,10,10,13,13,13,13,13,12,12,11,11,10,10,9,9,9,9,9,12,12,12,12,12,11,11,11,11,11,10,10,10,10,10,9,9,9,9,9,8,8,8,8,8,15,15,15,15,14,14,14,14,13,13,13,13,12,12,12,12,14,14,14,14,13,13,12,12,11,11,11,11,13,13,13,13,12,12,11,11,10,10,10,10,12,12,12,12,11,11,11,11,10,10,10,10,9,9,9,9,14,14,14,13,13,13,12,12,12,13,13,13,12,12,11,11,11,12,12,12,11,11,11,10,10,10,13,13,12,12,12,12,11,11,12},{6,7,8,5,6,7,4,5,6,4,5,4,5,6,7,4,5,6,7,4,5,6,4,5,4,5,6,4,5,6,4,5,6,4,5,4,5,4,6,7,5,6,7,4,5,6,3,4,5,3,4,5,6,7,4,5,6,7,3,4,5,6,3,4,5,3,4,4,5,6,3,4,5,6,3,4,5,6,3,4,5,3,4,5,3,4,5,3,4,5,3,4,3,4,6,5,6,4,5,6,3,4,5,2,3,4,5,6,4,5,6,3,4,5,6,2,3,4,5,2,3,4,4,5,6,3,4,5,6,2,3,4,5,6,2,3,4,5,2,3,4,3,4,5,2,3,4,5,2,3,4,5,2,3,4,5,2,3,4,2,3,4,2,3,4,4,5,3,4,5,2,3,4,5,2,3,4,3,4,5,2,3,4,5,2,3,4,5,2,3,4,2,3,4,5,2,3,4,5,2,3,4,5,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,4,2,3,2,3,2,3,2,3,2,13,14,15,16,17,18,12,13,14,15,16,17,11,12,13,14,15,16,10,11,12,13,14,15,9,10,11,12,13,14,8,9,10,11,12,13,8,9,10,11,12,8,9,10,11,8,9,10,8,9,8,12,13,14,15,16,17,11,12,13,14,15,16,17,10,11,12,13,14,15,16,9,10,11,12,13,14,15,8,9,10,11,12,13,14,8,9,10,11,12,13,8,9,10,11,12,8,9,10,11,8,9,10,8,9,11,12,13,14,15,16,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,8,9,10,11,12,13,8,9,10,11,12,8,9,10,11,8,9,10,10,11,12,13,14,15,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,8,9,10,11,12,13,8,9,10,11,12,8,9,10,11,9,10,11,12,13,14,8,9,10,11,12,13,14,8,9,10,11,12,13,14,8,9,10,11,12,13,14,8,9,10,11,12,13,14,8,9,10,11,12,13,8,9,10,11,12,8,9,10,11,12,13,8,9,10,11,12,13,8,9,10,11,12,13,8,9,10,11,12,13,8,9,10,11,12,13,8,9,10,11,12,13,8,9,10,11,12,8,9,10,11,12,8,9,10,11,12,8,9,10,11,12,8,9,10,11,12,8,9,10,11,8,9,10,11,8,9,10,11,8,9,10,11,8,9,10,8,9,10,8,9,10,8,9,8,9,8,13,14,15,16,17,12,13,14,15,16,17,11,12,13,14,15,16,10,11,12,13,14,15,9,10,11,12,13,14,8,9,10,11,12,13,7,8,9,10,11,12,7,8,9,10,11,7,8,9,10,7,8,9,7,8,12,13,14,15,16,17,11,17,10,16,9,15,8,14,7,13,7,12,7,11,7,10,7,9,7,8,11,12,13,14,15,16,10,16,9,16,8,15,7,14,7,13,7,12,7,11,7,10,7,8,9,10,11,12,13,14,15,9,15,8,15,7,15,7,14,7,13,7,12,7,11,7,8,9,10,9,10,11,12,13,14,8,14,7,14,7,14,7,14,7,13,7,12,7,8,9,10,11,8,9,10,11,12,13,7,13,7,13,7,13,7,13,7,13,7,8,9,10,11,12,7,8,9,10,11,12,7,12,7,12,7,12,7,12,7,8,9,10,11,12,7,8,9,10,11,7,11,7,11,7,11,7,8,9,10,11,7,8,9,10,7,10,7,10,7,8,9,10,7,8,9,7,9,7,8,9,7,8,7,8,13,14,15,16,12,13,14,15,16,11,12,13,14,15,16,10,11,12,13,14,15,9,10,11,12,13,14,8,9,10,11,12,13,7,8,9,10,11,12,6,7,8,9,10,11,6,7,8,9,10,6,7,8,9,6,7,8,12,13,14,15,16,11,16,10,16,9,15,8,14,7,13,6,12,6,11,6,10,6,9,6,7,8,11,12,13,14,15,16,10,16,9,16,8,15,7,14,6,13,6,12,6,11,6,10,6,9,6,7,8,10,11,12,13,14,15,9,15,8,15,7,15,6,14,6,13,6,12,6,11,6,10,6,7,8,9,9,10,11,12,13,14,8,14,7,14,6,14,6,14,6,13,6,12,6,11,6,7,8,9,10,8,9,10,11,12,13,7,13,6,13,6,13,6,13,6,13,6,12,6,7,8,9,10,11,7,8,9,10,11,12,6,12,6,12,6,12,6,12,6,12,6,7,8,9,10,11,12,6,7,8,9,10,11,6,11,6,11,6,11,6,11,6,7,8,9,10,11,6,7,8,9,10,6,10,6,10,6,10,6,7,8,9,10,6,7,8,9,6,9,6,9,6,7,8,9,6,7,8,6,7,8,6,7,8,13,14,15,12,13,14,15,11,12,13,14,15,10,11,12,13,14,15,9,10,11,12,13,14,8,9,10,11,12,13,7,8,9,10,11,12,6,7,8,9,10,11,5,6,7,8,9,10,5,6,7,8,9,5,6,7,8,12,13,14,15,11,15,10,15,9,15,8,14,7,13,6,12,5,11,5,10,5,9,5,6,7,8,11,12,13,14,15,10,15,9,15,8,15,7,14,6,13,5,12,5,11,5,10,5,9,5,6,7,8,10,11,12,13,14,15,9,15,8,15,7,15,6,14,5,13,5,12,5,11,5,10,5,9,5,6,7,8,9,10,11,12,13,14,8,14,7,14,6,14,5,14,5,13,5,12,5,11,5,10,5,6,7,8,9,8,9,10,11,12,13,7,13,6,13,5,13,5,13,5,13,5,12,5,11,5,6,7,8,9,10,7,8,9,10,11,12,6,12,5,12,5,12,5,12,5,12,5,12,5,6,7,8,9,10,11,6,7,8,9,10,11,5,11,5,11,5,11,5,11,5,11,5,6,7,8,9,10,11,5,6,7,8,9,10,5,10,5,10,5,10,5,10,5,6,7,8,9,10,5,6,7,8,9,5,9,5,9,5,9,5,6,7,8,9,5,6,7,8,5,6,7,8,5,6,7,8,5,6,7,8,13,14,12,13,14,11,12,13,14,10,11,12,13,14,9,10,11,12,13,14,8,9,10,11,12,13,7,8,9,10,11,12,6,7,8,9,10,11,5,6,7,8,9,10,4,5,6,7,8,9,4,5,6,7,8,12,13,14,11,14,10,14,9,14,8,14,7,13,6,12,5,11,4,10,4,9,4,5,6,7,8,11,12,13,14,10,14,9,14,8,14,7,14,6,13,5,12,4,11,4,10,4,9,4,5,6,7,8,10,11,12,13,14,9,14,8,14,7,14,6,14,5,13,4,12,4,11,4,10,4,9,4,5,6,7,8,9,10,11,12,13,14,8,14,7,14,6,14,5,14,4,13,4,12,4,11,4,10,4,9,4,5,6,7,8,8,9,10,11,12,13,7,13,6,13,5,13,4,13,4,13,4,12,4,11,4,10,4,5,6,7,8,9,7,8,9,10,11,12,6,12,5,12,4,12,4,12,4,12,4,12,4,11,4,5,6,7,8,9,10,6,7,8,9,10,11,5,11,4,11,4,11,4,11,4,11,4,11,4,5,6,7,8,9,10,11,5,6,7,8,9,10,4,10,4,10,4,10,4,10,4,10,4,5,6,7,8,9,10,4,5,6,7,8,9,4,9,4,9,4,9,4,9,4,5,6,7,8,9,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,13,12,13,11,12,13,10,11,12,13,9,10,11,12,13,8,9,10,11,12,13,7,8,9,10,11,12,6,7,8,9,10,11,5,6,7,8,9,10,4,5,6,7,8,9,3,4,5,6,7,8,12,13,11,13,10,13,9,13,8,13,7,13,6,12,5,11,4,10,3,9,3,4,5,6,7,8,11,12,13,10,13,9,13,8,13,7,13,6,13,5,12,4,11,3,10,3,9,3,4,5,6,7,8,10,11,12,13,9,13,8,13,7,13,6,13,5,13,4,12,3,11,3,10,3,9,3,4,5,6,7,8,9,10,11,12,13,8,13,7,13,6,13,5,13,4,13,3,12,3,11,3,10,3,9,3,4,5,6,7,8,8,9,10,11,12,13,7,13,6,13,5,13,4,13,3,13,3,12,3,11,3,10,3,9,3,4,5,6,7,8,7,8,9,10,11,12,6,12,5,12,4,12,3,12,3,12,3,12,3,11,3,10,3,4,5,6,7,8,9,6,7,8,9,10,11,5,11,4,11,3,11,3,11,3,11,3,11,3,11,3,4,5,6,7,8,9,10,5,6,7,8,9,10,4,10,3,10,3,10,3,10,3,10,3,10,3,4,5,6,7,8,9,10,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,9,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,11,12,10,11,12,9,10,11,12,8,9,10,11,12,7,8,9,10,11,12,6,7,8,9,10,11,12,5,6,7,8,9,10,11,4,5,6,7,8,9,10,3,4,5,6,7,8,9,3,4,5,6,7,8,10,11,12,9,12,8,12,7,12,6,12,5,12,4,11,3,10,3,9,3,4,5,6,7,8,9,10,11,12,8,12,7,12,6,12,5,12,4,12,3,11,3,10,3,9,3,4,5,6,7,8,8,9,10,11,12,7,12,6,12,5,12,4,12,3,12,3,11,3,10,3,9,3,4,5,6,7,8,7,8,9,10,11,12,6,12,5,12,4,12,3,12,3,12,3,11,3,10,3,9,3,4,5,6,7,8,6,7,8,9,10,11,12,5,12,4,12,3,12,3,12,3,12,3,11,3,10,3,9,3,4,5,6,7,8,5,6,7,8,9,10,11,4,11,3,11,3,11,3,11,3,11,3,11,3,10,3,4,5,6,7,8,9,4,5,6,7,8,9,10,3,10,3,10,3,10,3,10,3,10,3,10,3,4,5,6,7,8,9,10,3,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,9,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,9,10,11,8,9,10,11,7,8,9,10,11,6,7,8,9,10,11,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,3,4,5,6,7,8,9,10,3,4,5,6,7,8,9,3,4,5,6,7,8,8,9,10,11,7,11,6,11,5,11,4,11,3,11,3,10,3,9,3,4,5,6,7,8,7,8,9,10,11,6,11,5,11,4,11,3,11,3,11,3,10,3,9,3,4,5,6,7,8,6,7,8,9,10,11,5,11,4,11,3,11,3,11,3,11,3,10,3,9,3,4,5,6,7,8,5,6,7,8,9,10,11,4,11,3,11,3,11,3,11,3,11,3,10,3,9,3,4,5,6,7,8,4,5,6,7,8,9,10,11,3,11,3,11,3,11,3,11,3,11,3,10,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,10,3,10,3,10,3,10,3,10,3,10,3,10,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,9,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,7,8,9,10,6,7,8,9,10,5,6,7,8,9,10,4,5,6,7,8,9,10,3,4,5,6,7,8,9,10,3,4,5,6,7,8,9,10,3,4,5,6,7,8,9,3,4,5,6,7,8,6,7,8,9,10,5,10,4,10,3,10,3,10,3,10,3,9,3,4,5,6,7,8,5,6,7,8,9,10,4,10,3,10,3,10,3,10,3,10,3,9,3,4,5,6,7,8,4,5,6,7,8,9,10,3,10,3,10,3,10,3,10,3,10,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,10,3,10,3,10,3,10,3,10,3,10,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,10,3,10,3,10,3,10,3,10,3,10,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,9,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,5,6,7,8,9,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,3,4,5,6,7,8,9,3,9,3,9,3,9,3,9,3,9,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,8,3,8,3,8,3,8,3,4,5,6,7,8,3,4,5,6,7,8,3,8,3,8,3,8,3,8,3,4,5,6,7,8,3,4,5,6,7,8,3,8,3,8,3,8,3,8,3,4,5,6,7,8,3,4,5,6,7,8,3,8,3,8,3,8,3,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,7,3,7,3,7,3,4,5,6,7,3,4,5,6,7,3,7,3,7,3,7,3,4,5,6,7,3,4,5,6,7,3,7,3,7,3,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,7,3,4,5,6,3,4,5,6,3,4,5,6,3,4,5,6,3,4,5,6,3,6,3,6,3,4,5,6,3,4,5,6,3,6,3,6,3,4,5,6,3,4,5,6,3,4,5,6,3,4,5,6,3,4,5,6,3,4,5,3,4,5,3,4,5,3,4,5,3,5,3,4,5,3,4,5,3,4,5,3,4,5,3,4,3,4,3,4,3,4,3,20,21,22,23,24,25,26,27,28,19,20,21,22,23,24,25,26,27,18,19,20,21,22,23,24,25,26,17,18,19,20,21,22,23,24,25,16,17,18,19,20,21,22,23,24,15,16,17,18,19,20,21,22,23,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,12,13,14,15,16,17,12,13,14,15,16,12,13,14,15,12,13,14,12,13,12,19,20,21,22,23,24,25,26,27,18,19,20,21,22,23,24,25,26,27,17,18,19,20,21,22,23,24,25,26,16,17,18,19,20,21,22,23,24,25,15,16,17,18,19,20,21,22,23,24,14,15,16,17,18,19,20,21,22,23,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,12,13,14,15,16,17,12,13,14,15,16,12,13,14,15,12,13,14,12,13,18,19,20,21,22,23,24,25,26,17,18,19,20,21,22,23,24,25,26,16,17,18,19,20,21,22,23,24,25,26,15,16,17,18,19,20,21,22,23,24,25,14,15,16,17,18,19,20,21,22,23,24,13,14,15,16,17,18,19,20,21,22,23,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,12,13,14,15,16,17,12,13,14,15,16,12,13,14,15,12,13,14,17,18,19,20,21,22,23,24,25,16,17,18,19,20,21,22,23,24,25,15,16,17,18,19,20,21,22,23,24,25,14,15,16,17,18,19,20,21,22,23,24,25,13,14,15,16,17,18,19,20,21,22,23,24,12,13,14,15,16,17,18,19,20,21,22,23,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,12,13,14,15,16,17,12,13,14,15,16,12,13,14,15,16,17,18,19,20,21,22,23,24,15,16,17,18,19,20,21,22,23,24,14,15,16,17,18,19,20,21,22,23,24,13,14,15,16,17,18,19,20,21,22,23,24,12,13,14,15,16,17,18,19,20,21,22,23,24,12,13,14,15,16,17,18,19,20,21,22,23,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,12,13,14,15,16,17,12,13,14,15,16,15,16,17,18,19,20,21,22,23,14,15,16,17,18,19,20,21,22,23,13,14,15,16,17,18,19,20,21,22,23,12,13,14,15,16,17,18,19,20,21,22,23,12,13,14,15,16,17,18,19,20,21,22,23,12,13,14,15,16,17,18,19,20,21,22,23,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,12,13,14,15,16,17,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,22,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,12,13,14,15,16,17,18,12,13,14,15,16,17,18,12,13,14,15,16,17,18,12,13,14,15,16,17,18,12,13,14,15,16,17,18,12,13,14,15,16,17,18,12,13,14,15,16,17,12,13,14,15,16,17,12,13,14,15,16,17,12,13,14,15,16,17,12,13,14,15,16,17,12,13,14,15,16,17,12,13,14,15,16,12,13,14,15,16,12,13,14,15,16,12,13,14,15,16,12,13,14,15,16,12,13,14,15,12,13,14,15,12,13,14,15,12,13,14,15,12,13,14,12,13,14,12,13,14,12,13,12,13,12,20,21,22,23,24,25,26,27,19,20,21,22,23,24,25,26,27,18,19,20,21,22,23,24,25,26,17,18,19,20,21,22,23,24,25,16,17,18,19,20,21,22,23,24,15,16,17,18,19,20,21,22,23,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,11,12,13,14,15,16,11,12,13,14,15,11,12,13,14,11,12,13,11,12,19,20,21,22,23,24,25,26,27,18,27,17,26,16,25,15,24,14,23,13,22,12,21,11,20,11,19,11,18,11,17,11,16,11,15,11,14,11,13,11,12,18,19,20,21,22,23,24,25,26,17,26,16,26,15,25,14,24,13,23,12,22,11,21,11,20,11,19,11,18,11,17,11,16,11,15,11,14,11,12,13,17,18,19,20,21,22,23,24,25,16,25,15,25,14,25,13,24,12,23,11,22,11,21,11,20,11,19,11,18,11,17,11,16,11,15,11,12,13,14,16,17,18,19,20,21,22,23,24,15,24,14,24,13,24,12,24,11,23,11,22,11,21,11,20,11,19,11,18,11,17,11,16,11,12,13,14,15,15,16,17,18,19,20,21,22,23,14,23,13,23,12,23,11,23,11,23,11,22,11,21,11,20,11,19,11,18,11,17,11,12,13,14,15,16,14,15,16,17,18,19,20,21,22,13,22,12,22,11,22,11,22,11,22,11,22,11,21,11,20,11,19,11,18,11,12,13,14,15,16,17,13,14,15,16,17,18,19,20,21,12,21,11,21,11,21,11,21,11,21,11,21,11,21,11,20,11,19,11,12,13,14,15,16,17,18,12,13,14,15,16,17,18,19,20,11,20,11,20,11,20,11,20,11,20,11,20,11,20,11,20,11,12,13,14,15,16,17,18,19,11,12,13,14,15,16,17,18,19,11,19,11,19,11,19,11,19,11,19,11,19,11,19,11,12,13,14,15,16,17,18,19,11,12,13,14,15,16,17,18,11,18,11,18,11,18,11,18,11,18,11,18,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,11,17,11,17,11,17,11,17,11,17,11,12,13,14,15,16,17,11,12,13,14,15,16,11,16,11,16,11,16,11,16,11,12,13,14,15,16,11,12,13,14,15,11,15,11,15,11,15,11,12,13,14,15,11,12,13,14,11,14,11,14,11,12,13,14,11,12,13,11,13,11,12,13,11,12,11,12,20,21,22,23,24,25,26,19,20,21,22,23,24,25,26,18,19,20,21,22,23,24,25,26,17,18,19,20,21,22,23,24,25,16,17,18,19,20,21,22,23,24,15,16,17,18,19,20,21,22,23,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,10,11,12,13,14,15,10,11,12,13,14,10,11,12,13,10,11,12,19,20,21,22,23,24,25,26,18,26,17,26,16,25,15,24,14,23,13,22,12,21,11,20,10,19,10,18,10,17,10,16,10,15,10,14,10,13,10,11,12,18,19,20,21,22,23,24,25,26,17,26,16,26,15,25,14,24,13,23,12,22,11,21,10,20,10,19,10,18,10,17,10,16,10,15,10,14,10,13,10,11,12,17,18,19,20,21,22,23,24,25,16,25,15,25,14,25,13,24,12,23,11,22,10,21,10,20,10,19,10,18,10,17,10,16,10,15,10,14,10,11,12,13,16,17,18,19,20,21,22,23,24,15,24,14,24,13,24,12,24,11,23,10,22,10,21,10,20,10,19,10,18,10,17,10,16,10,15,10,11,12,13,14,15,16,17,18,19,20,21,22,23,14,23,13,23,12,23,11,23,10,23,10,22,10,21,10,20,10,19,10,18,10,17,10,16,10,11,12,13,14,15,14,15,16,17,18,19,20,21,22,13,22,12,22,11,22,10,22,10,22,10,22,10,21,10,20,10,19,10,18,10,17,10,11,12,13,14,15,16,13,14,15,16,17,18,19,20,21,12,21,11,21,10,21,10,21,10,21,10,21,10,21,10,20,10,19,10,18,10,11,12,13,14,15,16,17,12,13,14,15,16,17,18,19,20,11,20,10,20,10,20,10,20,10,20,10,20,10,20,10,20,10,19,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,10,19,10,19,10,19,10,19,10,19,10,19,10,19,10,19,10,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,10,18,10,18,10,18,10,18,10,18,10,18,10,18,10,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,10,17,10,17,10,17,10,17,10,17,10,17,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,10,16,10,16,10,16,10,16,10,16,10,11,12,13,14,15,16,10,11,12,13,14,15,10,15,10,15,10,15,10,15,10,11,12,13,14,15,10,11,12,13,14,10,14,10,14,10,14,10,11,12,13,14,10,11,12,13,10,13,10,13,10,11,12,13,10,11,12,10,11,12,10,11,12,20,21,22,23,24,25,19,20,21,22,23,24,25,18,19,20,21,22,23,24,25,17,18,19,20,21,22,23,24,25,16,17,18,19,20,21,22,23,24,15,16,17,18,19,20,21,22,23,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,9,10,11,12,13,14,9,10,11,12,13,9,10,11,12,19,20,21,22,23,24,25,18,25,17,25,16,25,15,24,14,23,13,22,12,21,11,20,10,19,9,18,9,17,9,16,9,15,9,14,9,13,9,10,11,12,18,19,20,21,22,23,24,25,17,25,16,25,15,25,14,24,13,23,12,22,11,21,10,20,9,19,9,18,9,17,9,16,9,15,9,14,9,13,9,10,11,12,17,18,19,20,21,22,23,24,25,16,25,15,25,14,25,13,24,12,23,11,22,10,21,9,20,9,19,9,18,9,17,9,16,9,15,9,14,9,13,9,10,11,12,16,17,18,19,20,21,22,23,24,15,24,14,24,13,24,12,24,11,23,10,22,9,21,9,20,9,19,9,18,9,17,9,16,9,15,9,14,9,10,11,12,13,15,16,17,18,19,20,21,22,23,14,23,13,23,12,23,11,23,10,23,9,22,9,21,9,20,9,19,9,18,9,17,9,16,9,15,9,10,11,12,13,14,14,15,16,17,18,19,20,21,22,13,22,12,22,11,22,10,22,9,22,9,22,9,21,9,20,9,19,9,18,9,17,9,16,9,10,11,12,13,14,15,13,14,15,16,17,18,19,20,21,12,21,11,21,10,21,9,21,9,21,9,21,9,21,9,20,9,19,9,18,9,17,9,10,11,12,13,14,15,16,12,13,14,15,16,17,18,19,20,11,20,10,20,9,20,9,20,9,20,9,20,9,20,9,20,9,19,9,18,9,10,11,12,13,14,15,16,17,11,12,13,14,15,16,17,18,19,10,19,9,19,9,19,9,19,9,19,9,19,9,19,9,19,9,19,9,10,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,18,9,18,9,18,9,18,9,18,9,18,9,18,9,18,9,18,9,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,9,17,9,17,9,17,9,17,9,17,9,17,9,17,9,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,9,16,9,16,9,16,9,16,9,16,9,16,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,9,15,9,15,9,15,9,15,9,15,9,10,11,12,13,14,15,9,10,11,12,13,14,9,14,9,14,9,14,9,14,9,10,11,12,13,14,9,10,11,12,13,9,13,9,13,9,13,9,10,11,12,13,9,10,11,12,9,10,11,12,9,10,11,12,9,10,11,12,20,21,22,23,24,19,20,21,22,23,24,18,19,20,21,22,23,24,17,18,19,20,21,22,23,24,16,17,18,19,20,21,22,23,24,15,16,17,18,19,20,21,22,23,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,8,9,10,11,12,13,8,9,10,11,12,19,20,21,22,23,24,18,24,17,24,16,24,15,24,14,23,13,22,12,21,11,20,10,19,9,18,8,17,8,16,8,15,8,14,8,13,8,9,10,11,12,18,19,20,21,22,23,24,17,24,16,24,15,24,14,24,13,23,12,22,11,21,10,20,9,19,8,18,8,17,8,16,8,15,8,14,8,13,8,9,10,11,12,17,18,19,20,21,22,23,24,16,24,15,24,14,24,13,24,12,23,11,22,10,21,9,20,8,19,8,18,8,17,8,16,8,15,8,14,8,13,8,9,10,11,12,16,17,18,19,20,21,22,23,24,15,24,14,24,13,24,12,24,11,23,10,22,9,21,8,20,8,19,8,18,8,17,8,16,8,15,8,14,8,13,8,9,10,11,12,15,16,17,18,19,20,21,22,23,14,23,13,23,12,23,11,23,10,23,9,22,8,21,8,20,8,19,8,18,8,17,8,16,8,15,8,14,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,13,22,12,22,11,22,10,22,9,22,8,22,8,21,8,20,8,19,8,18,8,17,8,16,8,15,8,9,10,11,12,13,14,13,14,15,16,17,18,19,20,21,12,21,11,21,10,21,9,21,8,21,8,21,8,21,8,20,8,19,8,18,8,17,8,16,8,9,10,11,12,13,14,15,12,13,14,15,16,17,18,19,20,11,20,10,20,9,20,8,20,8,20,8,20,8,20,8,20,8,19,8,18,8,17,8,9,10,11,12,13,14,15,16,11,12,13,14,15,16,17,18,19,10,19,9,19,8,19,8,19,8,19,8,19,8,19,8,19,8,19,8,18,8,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,9,18,8,18,8,18,8,18,8,18,8,18,8,18,8,18,8,18,8,9,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,8,17,8,17,8,17,8,17,8,17,8,17,8,17,8,17,8,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,8,15,8,15,8,15,8,15,8,15,8,15,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,8,14,8,14,8,14,8,14,8,14,8,9,10,11,12,13,14,8,9,10,11,12,13,8,13,8,13,8,13,8,13,8,9,10,11,12,13,8,9,10,11,12,8,9,10,11,12,8,9,10,11,12,8,9,10,11,12,8,9,10,11,12,20,21,22,23,19,20,21,22,23,18,19,20,21,22,23,17,18,19,20,21,22,23,16,17,18,19,20,21,22,23,15,16,17,18,19,20,21,22,23,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,7,8,9,10,11,12,19,20,21,22,23,18,23,17,23,16,23,15,23,14,23,13,22,12,21,11,20,10,19,9,18,8,17,7,16,7,15,7,14,7,13,7,8,9,10,11,12,18,19,20,21,22,23,17,23,16,23,15,23,14,23,13,23,12,22,11,21,10,20,9,19,8,18,7,17,7,16,7,15,7,14,7,13,7,8,9,10,11,12,17,18,19,20,21,22,23,16,23,15,23,14,23,13,23,12,23,11,22,10,21,9,20,8,19,7,18,7,17,7,16,7,15,7,14,7,13,7,8,9,10,11,12,16,17,18,19,20,21,22,23,15,23,14,23,13,23,12,23,11,23,10,22,9,21,8,20,7,19,7,18,7,17,7,16,7,15,7,14,7,13,7,8,9,10,11,12,15,16,17,18,19,20,21,22,23,14,23,13,23,12,23,11,23,10,23,9,22,8,21,7,20,7,19,7,18,7,17,7,16,7,15,7,14,7,13,7,8,9,10,11,12,14,15,16,17,18,19,20,21,22,13,22,12,22,11,22,10,22,9,22,8,22,7,21,7,20,7,19,7,18,7,17,7,16,7,15,7,14,7,8,9,10,11,12,13,13,14,15,16,17,18,19,20,21,12,21,11,21,10,21,9,21,8,21,7,21,7,21,7,20,7,19,7,18,7,17,7,16,7,15,7,8,9,10,11,12,13,14,12,13,14,15,16,17,18,19,20,11,20,10,20,9,20,8,20,7,20,7,20,7,20,7,20,7,19,7,18,7,17,7,16,7,8,9,10,11,12,13,14,15,11,12,13,14,15,16,17,18,19,10,19,9,19,8,19,7,19,7,19,7,19,7,19,7,19,7,19,7,18,7,17,7,8,9,10,11,12,13,14,15,16,10,11,12,13,14,15,16,17,18,9,18,8,18,7,18,7,18,7,18,7,18,7,18,7,18,7,18,7,18,7,8,9,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,17,8,17,7,17,7,17,7,17,7,17,7,17,7,17,7,17,7,17,7,8,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,7,16,7,16,7,16,7,16,7,16,7,16,7,16,7,16,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,7,15,7,15,7,15,7,15,7,15,7,15,7,15,7,8,9,10,11,12,13,14,15,7,8,9,10,11,12,13,14,7,14,7,14,7,14,7,14,7,14,7,14,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,7,13,7,13,7,13,7,13,7,13,7,8,9,10,11,12,13,7,8,9,10,11,12,7,8,9,10,11,12,7,8,9,10,11,12,7,8,9,10,11,12,7,8,9,10,11,12,7,8,9,10,11,12,20,21,22,19,20,21,22,18,19,20,21,22,17,18,19,20,21,22,16,17,18,19,20,21,22,15,16,17,18,19,20,21,22,14,15,16,17,18,19,20,21,22,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,19,20,21,22,18,22,17,22,16,22,15,22,14,22,13,22,12,21,11,20,10,19,9,18,8,17,7,16,6,15,6,14,6,13,6,7,8,9,10,11,12,18,19,20,21,22,17,22,16,22,15,22,14,22,13,22,12,22,11,21,10,20,9,19,8,18,7,17,6,16,6,15,6,14,6,13,6,7,8,9,10,11,12,17,18,19,20,21,22,16,22,15,22,14,22,13,22,12,22,11,22,10,21,9,20,8,19,7,18,6,17,6,16,6,15,6,14,6,13,6,7,8,9,10,11,12,16,17,18,19,20,21,22,15,22,14,22,13,22,12,22,11,22,10,22,9,21,8,20,7,19,6,18,6,17,6,16,6,15,6,14,6,13,6,7,8,9,10,11,12,15,16,17,18,19,20,21,22,14,22,13,22,12,22,11,22,10,22,9,22,8,21,7,20,6,19,6,18,6,17,6,16,6,15,6,14,6,13,6,7,8,9,10,11,12,14,15,16,17,18,19,20,21,22,13,22,12,22,11,22,10,22,9,22,8,22,7,21,6,20,6,19,6,18,6,17,6,16,6,15,6,14,6,13,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,12,21,11,21,10,21,9,21,8,21,7,21,6,21,6,20,6,19,6,18,6,17,6,16,6,15,6,14,6,7,8,9,10,11,12,13,12,13,14,15,16,17,18,19,20,11,20,10,20,9,20,8,20,7,20,6,20,6,20,6,20,6,19,6,18,6,17,6,16,6,15,6,7,8,9,10,11,12,13,14,11,12,13,14,15,16,17,18,19,10,19,9,19,8,19,7,19,6,19,6,19,6,19,6,19,6,19,6,18,6,17,6,16,6,7,8,9,10,11,12,13,14,15,10,11,12,13,14,15,16,17,18,9,18,8,18,7,18,6,18,6,18,6,18,6,18,6,18,6,18,6,18,6,17,6,7,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,8,17,7,17,6,17,6,17,6,17,6,17,6,17,6,17,6,17,6,17,6,7,8,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,7,16,6,16,6,16,6,16,6,16,6,16,6,16,6,16,6,16,6,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,6,15,6,15,6,15,6,15,6,15,6,15,6,15,6,15,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,6,14,6,14,6,14,6,14,6,14,6,14,6,14,6,7,8,9,10,11,12,13,14,6,7,8,9,10,11,12,13,6,13,6,13,6,13,6,13,6,13,6,13,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,6,7,8,9,10,11,12,6,7,8,9,10,11,12,6,7,8,9,10,11,12,6,7,8,9,10,11,12,6,7,8,9,10,11,12,6,7,8,9,10,11,12,20,21,19,20,21,18,19,20,21,17,18,19,20,21,16,17,18,19,20,21,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,13,14,15,16,17,18,19,20,21,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,5,6,7,8,9,10,11,12,19,20,21,18,21,17,21,16,21,15,21,14,21,13,21,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,5,13,5,6,7,8,9,10,11,12,18,19,20,21,17,21,16,21,15,21,14,21,13,21,12,21,11,21,10,20,9,19,8,18,7,17,6,16,5,15,5,14,5,13,5,6,7,8,9,10,11,12,17,18,19,20,21,16,21,15,21,14,21,13,21,12,21,11,21,10,21,9,20,8,19,7,18,6,17,5,16,5,15,5,14,5,13,5,6,7,8,9,10,11,12,16,17,18,19,20,21,15,21,14,21,13,21,12,21,11,21,10,21,9,21,8,20,7,19,6,18,5,17,5,16,5,15,5,14,5,13,5,6,7,8,9,10,11,12,15,16,17,18,19,20,21,14,21,13,21,12,21,11,21,10,21,9,21,8,21,7,20,6,19,5,18,5,17,5,16,5,15,5,14,5,13,5,6,7,8,9,10,11,12,14,15,16,17,18,19,20,21,13,21,12,21,11,21,10,21,9,21,8,21,7,21,6,20,5,19,5,18,5,17,5,16,5,15,5,14,5,13,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,12,21,11,21,10,21,9,21,8,21,7,21,6,21,5,20,5,19,5,18,5,17,5,16,5,15,5,14,5,13,5,6,7,8,9,10,11,12,12,13,14,15,16,17,18,19,20,11,20,10,20,9,20,8,20,7,20,6,20,5,20,5,20,5,19,5,18,5,17,5,16,5,15,5,14,5,6,7,8,9,10,11,12,13,11,12,13,14,15,16,17,18,19,10,19,9,19,8,19,7,19,6,19,5,19,5,19,5,19,5,19,5,18,5,17,5,16,5,15,5,6,7,8,9,10,11,12,13,14,10,11,12,13,14,15,16,17,18,9,18,8,18,7,18,6,18,5,18,5,18,5,18,5,18,5,18,5,18,5,17,5,16,5,6,7,8,9,10,11,12,13,14,15,9,10,11,12,13,14,15,16,17,8,17,7,17,6,17,5,17,5,17,5,17,5,17,5,17,5,17,5,17,5,17,5,6,7,8,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,16,7,16,6,16,5,16,5,16,5,16,5,16,5,16,5,16,5,16,5,16,5,6,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,6,15,5,15,5,15,5,15,5,15,5,15,5,15,5,15,5,15,5,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,5,14,5,14,5,14,5,14,5,14,5,14,5,14,5,14,5,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,5,13,5,13,5,13,5,13,5,13,5,13,5,13,5,6,7,8,9,10,11,12,13,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,20,19,20,18,19,20,17,18,19,20,16,17,18,19,20,15,16,17,18,19,20,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,12,13,14,15,16,17,18,19,20,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,19,20,18,20,17,20,16,20,15,20,14,20,13,20,12,20,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,5,6,7,8,9,10,11,12,18,19,20,17,20,16,20,15,20,14,20,13,20,12,20,11,20,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,5,6,7,8,9,10,11,12,17,18,19,20,16,20,15,20,14,20,13,20,12,20,11,20,10,20,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,16,17,18,19,20,15,20,14,20,13,20,12,20,11,20,10,20,9,20,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,15,16,17,18,19,20,14,20,13,20,12,20,11,20,10,20,9,20,8,20,7,20,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,14,15,16,17,18,19,20,13,20,12,20,11,20,10,20,9,20,8,20,7,20,6,20,5,19,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,12,20,11,20,10,20,9,20,8,20,7,20,6,20,5,20,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,12,13,14,15,16,17,18,19,20,11,20,10,20,9,20,8,20,7,20,6,20,5,20,4,20,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,11,12,13,14,15,16,17,18,19,10,19,9,19,8,19,7,19,6,19,5,19,4,19,4,19,4,19,4,18,4,17,4,16,4,15,4,14,4,5,6,7,8,9,10,11,12,13,10,11,12,13,14,15,16,17,18,9,18,8,18,7,18,6,18,5,18,4,18,4,18,4,18,4,18,4,18,4,17,4,16,4,15,4,5,6,7,8,9,10,11,12,13,14,9,10,11,12,13,14,15,16,17,8,17,7,17,6,17,5,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,16,4,5,6,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,5,6,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,5,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,5,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,18,19,17,18,19,16,17,18,19,15,16,17,18,19,14,15,16,17,18,19,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,11,12,13,14,15,16,17,18,19,10,11,12,13,14,15,16,17,18,19,9,10,11,12,13,14,15,16,17,18,8,9,10,11,12,13,14,15,16,17,7,8,9,10,11,12,13,14,15,16,6,7,8,9,10,11,12,13,14,15,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,17,18,19,16,19,15,19,14,19,13,19,12,19,11,19,10,19,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,5,6,7,8,9,10,11,12,16,17,18,19,15,19,14,19,13,19,12,19,11,19,10,19,9,19,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,15,16,17,18,19,14,19,13,19,12,19,11,19,10,19,9,19,8,19,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,14,15,16,17,18,19,13,19,12,19,11,19,10,19,9,19,8,19,7,19,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,12,19,11,19,10,19,9,19,8,19,7,19,6,19,5,19,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,12,13,14,15,16,17,18,19,11,19,10,19,9,19,8,19,7,19,6,19,5,19,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,11,12,13,14,15,16,17,18,19,10,19,9,19,8,19,7,19,6,19,5,19,4,19,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,10,11,12,13,14,15,16,17,18,19,9,19,8,19,7,19,6,19,5,19,4,19,4,19,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,9,10,11,12,13,14,15,16,17,18,8,18,7,18,6,18,5,18,4,18,4,18,4,18,4,18,4,18,4,17,4,16,4,15,4,14,4,5,6,7,8,9,10,11,12,13,8,9,10,11,12,13,14,15,16,17,7,17,6,17,5,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,16,4,15,4,5,6,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,15,16,6,16,5,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,5,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,15,5,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,5,6,7,8,9,10,11,12,13,14,15,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,16,17,18,15,16,17,18,14,15,16,17,18,13,14,15,16,17,18,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,18,8,9,10,11,12,13,14,15,16,17,18,7,8,9,10,11,12,13,14,15,16,17,6,7,8,9,10,11,12,13,14,15,16,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,15,16,17,18,14,18,13,18,12,18,11,18,10,18,9,18,8,18,7,18,6,17,5,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,14,15,16,17,18,13,18,12,18,11,18,10,18,9,18,8,18,7,18,6,18,5,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,12,18,11,18,10,18,9,18,8,18,7,18,6,18,5,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,12,13,14,15,16,17,18,11,18,10,18,9,18,8,18,7,18,6,18,5,18,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,11,12,13,14,15,16,17,18,10,18,9,18,8,18,7,18,6,18,5,18,4,18,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,10,11,12,13,14,15,16,17,18,9,18,8,18,7,18,6,18,5,18,4,18,4,18,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,9,10,11,12,13,14,15,16,17,18,8,18,7,18,6,18,5,18,4,18,4,18,4,18,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,8,9,10,11,12,13,14,15,16,17,18,7,18,6,18,5,18,4,18,4,18,4,18,4,18,4,18,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,7,8,9,10,11,12,13,14,15,16,17,6,17,5,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,16,4,15,4,14,4,5,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,13,14,15,16,5,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,15,4,5,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,14,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,14,15,16,17,13,14,15,16,17,12,13,14,15,16,17,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,17,7,8,9,10,11,12,13,14,15,16,17,6,7,8,9,10,11,12,13,14,15,16,17,5,6,7,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,15,16,17,12,17,11,17,10,17,9,17,8,17,7,17,6,17,5,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,12,13,14,15,16,17,11,17,10,17,9,17,8,17,7,17,6,17,5,17,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,11,12,13,14,15,16,17,10,17,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,10,11,12,13,14,15,16,17,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,9,10,11,12,13,14,15,16,17,8,17,7,17,6,17,5,17,4,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,8,9,10,11,12,13,14,15,16,17,7,17,6,17,5,17,4,17,4,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,7,8,9,10,11,12,13,14,15,16,17,6,17,5,17,4,17,4,17,4,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,13,14,15,16,17,5,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,14,15,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,15,4,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,12,13,14,15,16,11,12,13,14,15,16,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,16,6,7,8,9,10,11,12,13,14,15,16,5,6,7,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,11,12,13,14,15,16,10,16,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,10,11,12,13,14,15,16,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,9,10,11,12,13,14,15,16,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,8,9,10,11,12,13,14,15,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,7,8,9,10,11,12,13,14,15,16,6,16,5,16,4,16,4,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,13,14,15,16,5,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,14,15,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,15,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,10,11,12,13,14,15,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,15,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,9,10,11,12,13,14,15,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,8,9,10,11,12,13,14,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,7,8,9,10,11,12,13,14,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,13,14,15,5,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,14,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,7,8,9,10,11,12,13,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,13,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,13,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,11,4,11,4,11,4,11,4,11,4,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,11,4,11,4,11,4,11,4,11,4,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,11,4,11,4,11,4,11,4,11,4,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,11,4,11,4,11,4,11,4,11,4,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,11,4,11,4,11,4,11,4,11,4,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,11,4,11,4,11,4,11,4,11,4,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,10,4,10,4,10,4,10,4,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,10,4,10,4,10,4,10,4,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,10,4,10,4,10,4,10,4,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,10,4,10,4,10,4,10,4,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,10,4,10,4,10,4,10,4,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,10,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,9,4,9,4,9,4,9,4,5,6,7,8,9,4,5,6,7,8,9,4,9,4,9,4,9,4,9,4,5,6,7,8,9,4,5,6,7,8,9,4,9,4,9,4,9,4,9,4,5,6,7,8,9,4,5,6,7,8,9,4,9,4,9,4,9,4,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,9,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,8,4,8,4,8,4,5,6,7,8,4,5,6,7,8,4,8,4,8,4,8,4,5,6,7,8,4,5,6,7,8,4,8,4,8,4,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,8,4,5,6,7,4,5,6,7,4,5,6,7,4,5,6,7,4,5,6,7,4,7,4,7,4,5,6,7,4,5,6,7,4,7,4,7,4,5,6,7,4,5,6,7,4,5,6,7,4,5,6,7,4,5,6,7,4,5,6,4,5,6,4,5,6,4,5,6,4,6,4,5,6,4,5,6,4,5,6,4,5,6,4,5,4,5,4,5,4,5,4},{4,3,2,5,4,3,6,5,4,6,5,6,4,3,2,5,4,3,2,5,4,3,5,4,4,3,2,4,3,2,4,3,2,3,2,3,2,2,4,3,5,4,3,6,5,4,7,6,5,7,6,4,3,2,5,4,3,2,6,5,4,3,6,5,4,6,5,4,3,2,5,4,3,2,5,4,3,2,5,4,3,4,3,2,4,3,2,4,3,2,3,2,3,2,4,5,4,6,5,4,7,6,5,8,7,6,4,3,5,4,3,6,5,4,3,7,6,5,4,7,6,5,4,3,2,5,4,3,2,6,5,4,3,2,6,5,4,3,6,5,4,4,3,2,5,4,3,2,5,4,3,2,5,4,3,2,4,3,2,4,3,2,4,3,2,5,4,6,5,4,7,6,5,4,7,6,5,5,4,3,6,5,4,3,6,5,4,3,6,5,4,5,4,3,2,5,4,3,2,5,4,3,2,5,4,3,4,3,2,4,3,2,4,3,2,6,5,4,6,5,4,6,5,4,5,4,3,5,4,3,5,4,3,4,3,2,4,3,2,4,3,2,5,4,5,4,4,3,4,3,4,8,7,6,5,4,3,9,8,7,6,5,4,10,9,8,7,6,5,11,10,9,8,7,6,12,11,10,9,8,7,13,12,11,10,9,8,13,12,11,10,9,13,12,11,10,13,12,11,13,12,13,8,7,6,5,4,3,9,8,7,6,5,4,3,10,9,8,7,6,5,4,11,10,9,8,7,6,5,12,11,10,9,8,7,6,12,11,10,9,8,7,12,11,10,9,8,12,11,10,9,12,11,10,12,11,8,7,6,5,4,3,9,8,7,6,5,4,3,10,9,8,7,6,5,4,3,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,11,10,9,8,7,6,11,10,9,8,7,11,10,9,8,11,10,9,8,7,6,5,4,3,9,8,7,6,5,4,3,10,9,8,7,6,5,4,3,10,9,8,7,6,5,4,3,10,9,8,7,6,5,4,10,9,8,7,6,5,10,9,8,7,6,10,9,8,7,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,9,8,7,6,5,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,5,4,3,5,4,3,5,4,3,4,3,4,3,3,8,7,6,5,4,9,8,7,6,5,4,10,9,8,7,6,5,11,10,9,8,7,6,12,11,10,9,8,7,13,12,11,10,9,8,14,13,12,11,10,9,14,13,12,11,10,14,13,12,11,14,13,12,14,13,8,7,6,5,4,3,9,3,10,4,11,5,12,6,13,7,13,8,13,9,13,10,13,11,13,12,8,7,6,5,4,3,9,3,10,3,11,4,12,5,12,6,12,7,12,8,12,9,12,11,10,8,7,6,5,4,3,9,3,10,3,11,3,11,4,11,5,11,6,11,7,11,10,9,8,8,7,6,5,4,3,9,3,10,3,10,3,10,3,10,4,10,5,10,9,8,7,6,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,8,7,6,5,4,3,8,3,8,3,8,3,8,3,8,7,6,5,4,3,7,6,5,4,3,7,3,7,3,7,3,7,6,5,4,3,6,5,4,3,6,3,6,3,6,5,4,3,5,4,3,5,3,5,4,3,4,3,4,3,8,7,6,5,9,8,7,6,5,10,9,8,7,6,5,11,10,9,8,7,6,12,11,10,9,8,7,13,12,11,10,9,8,14,13,12,11,10,9,15,14,13,12,11,10,15,14,13,12,11,15,14,13,12,15,14,13,8,7,6,5,4,9,4,10,4,11,5,12,6,13,7,14,8,14,9,14,10,14,11,14,13,12,8,7,6,5,4,3,9,3,10,3,11,4,12,5,13,6,13,7,13,8,13,9,13,10,13,12,11,8,7,6,5,4,3,9,3,10,3,11,3,12,4,12,5,12,6,12,7,12,8,12,11,10,9,8,7,6,5,4,3,9,3,10,3,11,3,11,3,11,4,11,5,11,6,11,10,9,8,7,8,7,6,5,4,3,9,3,10,3,10,3,10,3,10,3,10,4,10,9,8,7,6,5,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,3,8,7,6,5,4,3,8,3,8,3,8,3,8,3,8,7,6,5,4,3,7,6,5,4,3,7,3,7,3,7,3,7,6,5,4,3,6,5,4,3,6,3,6,3,6,5,4,3,5,4,3,5,4,3,5,4,3,8,7,6,9,8,7,6,10,9,8,7,6,11,10,9,8,7,6,12,11,10,9,8,7,13,12,11,10,9,8,14,13,12,11,10,9,15,14,13,12,11,10,16,15,14,13,12,11,16,15,14,13,12,16,15,14,13,8,7,6,5,9,5,10,5,11,5,12,6,13,7,14,8,15,9,15,10,15,11,15,14,13,12,8,7,6,5,4,9,4,10,4,11,4,12,5,13,6,14,7,14,8,14,9,14,10,14,13,12,11,8,7,6,5,4,3,9,3,10,3,11,3,12,4,13,5,13,6,13,7,13,8,13,9,13,12,11,10,8,7,6,5,4,3,9,3,10,3,11,3,12,3,12,4,12,5,12,6,12,7,12,11,10,9,8,8,7,6,5,4,3,9,3,10,3,11,3,11,3,11,3,11,4,11,5,11,10,9,8,7,6,8,7,6,5,4,3,9,3,10,3,10,3,10,3,10,3,10,3,10,9,8,7,6,5,4,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,3,8,7,6,5,4,3,8,3,8,3,8,3,8,3,8,7,6,5,4,3,7,6,5,4,3,7,3,7,3,7,3,7,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,6,5,4,3,8,7,9,8,7,10,9,8,7,11,10,9,8,7,12,11,10,9,8,7,13,12,11,10,9,8,14,13,12,11,10,9,15,14,13,12,11,10,16,15,14,13,12,11,17,16,15,14,13,12,17,16,15,14,13,8,7,6,9,6,10,6,11,6,12,6,13,7,14,8,15,9,16,10,16,11,16,15,14,13,12,8,7,6,5,9,5,10,5,11,5,12,5,13,6,14,7,15,8,15,9,15,10,15,14,13,12,11,8,7,6,5,4,9,4,10,4,11,4,12,4,13,5,14,6,14,7,14,8,14,9,14,13,12,11,10,8,7,6,5,4,3,9,3,10,3,11,3,12,3,13,4,13,5,13,6,13,7,13,8,13,12,11,10,9,8,7,6,5,4,3,9,3,10,3,11,3,12,3,12,3,12,4,12,5,12,6,12,11,10,9,8,7,8,7,6,5,4,3,9,3,10,3,11,3,11,3,11,3,11,3,11,4,11,10,9,8,7,6,5,8,7,6,5,4,3,9,3,10,3,10,3,10,3,10,3,10,3,10,9,8,7,6,5,4,3,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,3,8,7,6,5,4,3,8,3,8,3,8,3,8,3,8,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,7,6,5,4,3,8,9,8,10,9,8,11,10,9,8,12,11,10,9,8,13,12,11,10,9,8,14,13,12,11,10,9,15,14,13,12,11,10,16,15,14,13,12,11,17,16,15,14,13,12,18,17,16,15,14,13,8,7,9,7,10,7,11,7,12,7,13,7,14,8,15,9,16,10,17,11,17,16,15,14,13,12,8,7,6,9,6,10,6,11,6,12,6,13,6,14,7,15,8,16,9,16,10,16,15,14,13,12,11,8,7,6,5,9,5,10,5,11,5,12,5,13,5,14,6,15,7,15,8,15,9,15,14,13,12,11,10,8,7,6,5,4,9,4,10,4,11,4,12,4,13,4,14,5,14,6,14,7,14,8,14,13,12,11,10,9,8,7,6,5,4,3,9,3,10,3,11,3,12,3,13,3,13,4,13,5,13,6,13,7,13,12,11,10,9,8,8,7,6,5,4,3,9,3,10,3,11,3,12,3,12,3,12,3,12,4,12,5,12,11,10,9,8,7,6,8,7,6,5,4,3,9,3,10,3,11,3,11,3,11,3,11,3,11,3,11,10,9,8,7,6,5,4,8,7,6,5,4,3,9,3,10,3,10,3,10,3,10,3,10,3,10,9,8,7,6,5,4,3,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,9,8,10,9,8,11,10,9,8,12,11,10,9,8,13,12,11,10,9,8,14,13,12,11,10,9,8,15,14,13,12,11,10,9,16,15,14,13,12,11,10,17,16,15,14,13,12,11,17,16,15,14,13,12,9,8,7,10,7,11,7,12,7,13,7,14,7,15,8,16,9,16,10,16,15,14,13,12,11,9,8,7,6,10,6,11,6,12,6,13,6,14,6,15,7,15,8,15,9,15,14,13,12,11,10,9,8,7,6,5,10,5,11,5,12,5,13,5,14,5,14,6,14,7,14,8,14,13,12,11,10,9,9,8,7,6,5,4,10,4,11,4,12,4,13,4,13,4,13,5,13,6,13,7,13,12,11,10,9,8,9,8,7,6,5,4,3,10,3,11,3,12,3,12,3,12,3,12,4,12,5,12,6,12,11,10,9,8,7,9,8,7,6,5,4,3,10,3,11,3,11,3,11,3,11,3,11,3,11,4,11,10,9,8,7,6,5,9,8,7,6,5,4,3,10,3,10,3,10,3,10,3,10,3,10,3,10,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,10,9,8,11,10,9,8,12,11,10,9,8,13,12,11,10,9,8,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,16,15,14,13,12,11,10,9,8,7,11,7,12,7,13,7,14,7,15,7,15,8,15,9,15,14,13,12,11,10,10,9,8,7,6,11,6,12,6,13,6,14,6,14,6,14,7,14,8,14,13,12,11,10,9,10,9,8,7,6,5,11,5,12,5,13,5,13,5,13,5,13,6,13,7,13,12,11,10,9,8,10,9,8,7,6,5,4,11,4,12,4,12,4,12,4,12,4,12,5,12,6,12,11,10,9,8,7,10,9,8,7,6,5,4,3,11,3,11,3,11,3,11,3,11,3,11,4,11,5,11,10,9,8,7,6,10,9,8,7,6,5,4,3,10,3,10,3,10,3,10,3,10,3,10,3,10,9,8,7,6,5,4,9,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,11,10,9,8,12,11,10,9,8,13,12,11,10,9,8,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,15,14,13,12,11,10,11,10,9,8,7,12,7,13,7,14,7,14,7,14,7,14,8,14,13,12,11,10,9,11,10,9,8,7,6,12,6,13,6,13,6,13,6,13,6,13,7,13,12,11,10,9,8,11,10,9,8,7,6,5,12,5,12,5,12,5,12,5,12,5,12,6,12,11,10,9,8,7,11,10,9,8,7,6,5,4,11,4,11,4,11,4,11,4,11,4,11,5,11,10,9,8,7,6,10,9,8,7,6,5,4,3,10,3,10,3,10,3,10,3,10,3,10,4,10,9,8,7,6,5,9,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,12,11,10,9,8,13,12,11,10,9,8,14,13,12,11,10,9,8,14,13,12,11,10,9,8,14,13,12,11,10,9,8,14,13,12,11,10,9,8,14,13,12,11,10,9,12,11,10,9,8,7,13,7,13,7,13,7,13,7,13,7,13,12,11,10,9,8,12,11,10,9,8,7,6,12,6,12,6,12,6,12,6,12,6,12,11,10,9,8,7,11,10,9,8,7,6,5,11,5,11,5,11,5,11,5,11,5,11,10,9,8,7,6,10,9,8,7,6,5,4,10,4,10,4,10,4,10,4,10,4,10,9,8,7,6,5,9,8,7,6,5,4,3,9,3,9,3,9,3,9,3,9,3,9,8,7,6,5,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,13,12,11,10,9,8,13,12,11,10,9,8,13,12,11,10,9,8,13,12,11,10,9,8,13,12,11,10,9,8,13,12,11,10,9,8,12,11,10,9,8,7,12,7,12,7,12,7,12,7,12,11,10,9,8,7,11,10,9,8,7,6,11,6,11,6,11,6,11,6,11,10,9,8,7,6,10,9,8,7,6,5,10,5,10,5,10,5,10,5,10,9,8,7,6,5,9,8,7,6,5,4,9,4,9,4,9,4,9,4,9,8,7,6,5,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,12,11,10,9,8,12,11,10,9,8,12,11,10,9,8,12,11,10,9,8,12,11,10,9,8,11,10,9,8,7,11,7,11,7,11,7,11,10,9,8,7,10,9,8,7,6,10,6,10,6,10,6,10,9,8,7,6,9,8,7,6,5,9,5,9,5,9,5,9,8,7,6,5,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,11,10,9,8,11,10,9,8,11,10,9,8,11,10,9,8,10,9,8,7,10,7,10,7,10,9,8,7,9,8,7,6,9,6,9,6,9,8,7,6,8,7,6,5,8,7,6,5,8,7,6,5,8,7,6,5,10,9,8,10,9,8,10,9,8,9,8,7,9,7,9,8,7,8,7,6,8,7,6,8,7,6,9,8,9,8,8,7,8,7,8,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,20,19,18,17,16,15,20,19,18,17,16,20,19,18,17,20,19,18,20,19,20,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,15,14,13,12,11,10,9,8,7,6,16,15,14,13,12,11,10,9,8,7,17,16,15,14,13,12,11,10,9,8,18,17,16,15,14,13,12,11,10,9,19,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,19,18,17,16,15,14,19,18,17,16,15,19,18,17,16,19,18,17,19,18,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,16,15,14,13,12,11,10,9,8,7,6,17,16,15,14,13,12,11,10,9,8,7,18,17,16,15,14,13,12,11,10,9,8,18,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,18,17,16,15,14,13,18,17,16,15,14,18,17,16,15,18,17,16,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,16,15,14,13,12,11,10,9,8,7,6,5,17,16,15,14,13,12,11,10,9,8,7,6,17,16,15,14,13,12,11,10,9,8,7,17,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,17,16,15,14,13,12,17,16,15,14,13,17,16,15,14,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,16,15,14,13,12,11,10,9,8,7,6,5,4,16,15,14,13,12,11,10,9,8,7,6,5,16,15,14,13,12,11,10,9,8,7,6,16,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,16,15,14,13,12,11,16,15,14,13,12,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,15,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,15,14,13,12,11,10,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,7,6,5,4,7,6,5,4,7,6,5,4,7,6,5,4,6,5,4,6,5,4,6,5,4,5,4,5,4,4,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,21,20,19,18,17,16,21,20,19,18,17,21,20,19,18,21,20,19,21,20,12,11,10,9,8,7,6,5,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,20,12,20,13,20,14,20,15,20,16,20,17,20,18,20,19,12,11,10,9,8,7,6,5,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,19,10,19,11,19,12,19,13,19,14,19,15,19,16,19,18,17,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,5,17,6,18,7,18,8,18,9,18,10,18,11,18,12,18,13,18,14,18,17,16,15,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,5,17,6,17,7,17,8,17,9,17,10,17,11,17,12,17,16,15,14,13,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,16,10,16,15,14,13,12,11,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,15,14,13,12,11,10,9,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,13,12,11,10,9,8,7,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,4,11,4,11,4,11,4,11,4,11,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,4,10,4,10,4,10,4,10,4,10,9,8,7,6,5,4,9,8,7,6,5,4,9,4,9,4,9,4,9,4,9,8,7,6,5,4,8,7,6,5,4,8,4,8,4,8,4,8,7,6,5,4,7,6,5,4,7,4,7,4,7,6,5,4,6,5,4,6,4,6,5,4,5,4,5,4,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,22,21,20,19,18,17,16,15,22,21,20,19,18,17,16,22,21,20,19,18,17,22,21,20,19,18,22,21,20,19,22,21,20,12,11,10,9,8,7,6,5,13,5,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,21,13,21,14,21,15,21,16,21,17,21,18,21,20,19,12,11,10,9,8,7,6,5,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,20,11,20,12,20,13,20,14,20,15,20,16,20,17,20,19,18,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,19,9,19,10,19,11,19,12,19,13,19,14,19,15,19,18,17,16,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,5,18,6,18,7,18,8,18,9,18,10,18,11,18,12,18,13,18,17,16,15,14,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,17,5,17,6,17,7,17,8,17,9,17,10,17,11,17,16,15,14,13,12,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,16,15,14,13,12,11,10,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,14,13,12,11,10,9,8,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,4,11,4,11,4,11,4,11,4,11,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,4,10,4,10,4,10,4,10,4,10,9,8,7,6,5,4,9,8,7,6,5,4,9,4,9,4,9,4,9,4,9,8,7,6,5,4,8,7,6,5,4,8,4,8,4,8,4,8,7,6,5,4,7,6,5,4,7,4,7,4,7,6,5,4,6,5,4,6,5,4,6,5,4,12,11,10,9,8,7,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,23,22,21,20,19,18,17,16,15,23,22,21,20,19,18,17,16,23,22,21,20,19,18,17,23,22,21,20,19,18,23,22,21,20,19,23,22,21,20,12,11,10,9,8,7,6,13,6,14,6,15,6,16,7,17,8,18,9,19,10,20,11,21,12,22,13,22,14,22,15,22,16,22,17,22,18,22,21,20,19,12,11,10,9,8,7,6,5,13,5,14,5,15,5,16,6,17,7,18,8,19,9,20,10,21,11,21,12,21,13,21,14,21,15,21,16,21,17,21,20,19,18,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,20,10,20,11,20,12,20,13,20,14,20,15,20,16,20,19,18,17,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,19,8,19,9,19,10,19,11,19,12,19,13,19,14,19,18,17,16,15,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,5,18,6,18,7,18,8,18,9,18,10,18,11,18,12,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,17,10,17,16,15,14,13,12,11,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,16,15,14,13,12,11,10,9,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,14,13,12,11,10,9,8,7,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,4,11,4,11,4,11,4,11,4,11,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,4,10,4,10,4,10,4,10,4,10,9,8,7,6,5,4,9,8,7,6,5,4,9,4,9,4,9,4,9,4,9,8,7,6,5,4,8,7,6,5,4,8,4,8,4,8,4,8,7,6,5,4,7,6,5,4,7,6,5,4,7,6,5,4,7,6,5,4,12,11,10,9,8,13,12,11,10,9,8,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,23,22,21,20,19,18,17,16,15,24,23,22,21,20,19,18,17,16,24,23,22,21,20,19,18,17,24,23,22,21,20,19,18,24,23,22,21,20,19,24,23,22,21,20,12,11,10,9,8,7,13,7,14,7,15,7,16,7,17,8,18,9,19,10,20,11,21,12,22,13,23,14,23,15,23,16,23,17,23,18,23,22,21,20,19,12,11,10,9,8,7,6,13,6,14,6,15,6,16,6,17,7,18,8,19,9,20,10,21,11,22,12,22,13,22,14,22,15,22,16,22,17,22,21,20,19,18,12,11,10,9,8,7,6,5,13,5,14,5,15,5,16,5,17,6,18,7,19,8,20,9,21,10,21,11,21,12,21,13,21,14,21,15,21,16,21,20,19,18,17,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,20,9,20,10,20,11,20,12,20,13,20,14,20,15,20,19,18,17,16,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,19,7,19,8,19,9,19,10,19,11,19,12,19,13,19,18,17,16,15,14,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,18,5,18,6,18,7,18,8,18,9,18,10,18,11,18,17,16,15,14,13,12,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,17,16,15,14,13,12,11,10,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,15,14,13,12,11,10,9,8,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,5,15,14,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,4,11,4,11,4,11,4,11,4,11,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,4,10,4,10,4,10,4,10,4,10,9,8,7,6,5,4,9,8,7,6,5,4,9,4,9,4,9,4,9,4,9,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,8,7,6,5,4,12,11,10,9,13,12,11,10,9,14,13,12,11,10,9,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,23,22,21,20,19,18,17,16,15,24,23,22,21,20,19,18,17,16,25,24,23,22,21,20,19,18,17,25,24,23,22,21,20,19,18,25,24,23,22,21,20,19,25,24,23,22,21,20,12,11,10,9,8,13,8,14,8,15,8,16,8,17,8,18,9,19,10,20,11,21,12,22,13,23,14,24,15,24,16,24,17,24,18,24,23,22,21,20,19,12,11,10,9,8,7,13,7,14,7,15,7,16,7,17,7,18,8,19,9,20,10,21,11,22,12,23,13,23,14,23,15,23,16,23,17,23,22,21,20,19,18,12,11,10,9,8,7,6,13,6,14,6,15,6,16,6,17,6,18,7,19,8,20,9,21,10,22,11,22,12,22,13,22,14,22,15,22,16,22,21,20,19,18,17,12,11,10,9,8,7,6,5,13,5,14,5,15,5,16,5,17,5,18,6,19,7,20,8,21,9,21,10,21,11,21,12,21,13,21,14,21,15,21,20,19,18,17,16,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,20,7,20,8,20,9,20,10,20,11,20,12,20,13,20,14,20,19,18,17,16,15,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,19,5,19,6,19,7,19,8,19,9,19,10,19,11,19,12,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,18,4,18,5,18,6,18,7,18,8,18,9,18,10,18,17,16,15,14,13,12,11,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,4,17,5,17,6,17,7,17,8,17,16,15,14,13,12,11,10,9,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,4,16,4,16,5,16,6,16,15,14,13,12,11,10,9,8,7,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,14,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,4,11,4,11,4,11,4,11,4,11,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,4,10,4,10,4,10,4,10,4,10,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,9,8,7,6,5,4,12,11,10,13,12,11,10,14,13,12,11,10,15,14,13,12,11,10,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,18,17,16,15,14,13,12,11,10,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,23,22,21,20,19,18,17,16,15,24,23,22,21,20,19,18,17,16,25,24,23,22,21,20,19,18,17,26,25,24,23,22,21,20,19,18,26,25,24,23,22,21,20,19,26,25,24,23,22,21,20,12,11,10,9,13,9,14,9,15,9,16,9,17,9,18,9,19,10,20,11,21,12,22,13,23,14,24,15,25,16,25,17,25,18,25,24,23,22,21,20,19,12,11,10,9,8,13,8,14,8,15,8,16,8,17,8,18,8,19,9,20,10,21,11,22,12,23,13,24,14,24,15,24,16,24,17,24,23,22,21,20,19,18,12,11,10,9,8,7,13,7,14,7,15,7,16,7,17,7,18,7,19,8,20,9,21,10,22,11,23,12,23,13,23,14,23,15,23,16,23,22,21,20,19,18,17,12,11,10,9,8,7,6,13,6,14,6,15,6,16,6,17,6,18,6,19,7,20,8,21,9,22,10,22,11,22,12,22,13,22,14,22,15,22,21,20,19,18,17,16,12,11,10,9,8,7,6,5,13,5,14,5,15,5,16,5,17,5,18,5,19,6,20,7,21,8,21,9,21,10,21,11,21,12,21,13,21,14,21,20,19,18,17,16,15,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,19,5,20,6,20,7,20,8,20,9,20,10,20,11,20,12,20,13,20,19,18,17,16,15,14,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,19,5,19,6,19,7,19,8,19,9,19,10,19,11,19,18,17,16,15,14,13,12,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,18,4,18,4,18,5,18,6,18,7,18,8,18,9,18,17,16,15,14,13,12,11,10,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,4,17,4,17,5,17,6,17,7,17,16,15,14,13,12,11,10,9,8,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,5,16,15,14,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,4,11,4,11,4,11,4,11,4,11,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,10,9,8,7,6,5,4,12,11,13,12,11,14,13,12,11,15,14,13,12,11,16,15,14,13,12,11,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,19,18,17,16,15,14,13,12,11,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,23,22,21,20,19,18,17,16,15,24,23,22,21,20,19,18,17,16,25,24,23,22,21,20,19,18,17,26,25,24,23,22,21,20,19,18,27,26,25,24,23,22,21,20,19,27,26,25,24,23,22,21,20,12,11,10,13,10,14,10,15,10,16,10,17,10,18,10,19,10,20,11,21,12,22,13,23,14,24,15,25,16,26,17,26,18,26,25,24,23,22,21,20,19,12,11,10,9,13,9,14,9,15,9,16,9,17,9,18,9,19,9,20,10,21,11,22,12,23,13,24,14,25,15,25,16,25,17,25,24,23,22,21,20,19,18,12,11,10,9,8,13,8,14,8,15,8,16,8,17,8,18,8,19,8,20,9,21,10,22,11,23,12,24,13,24,14,24,15,24,16,24,23,22,21,20,19,18,17,12,11,10,9,8,7,13,7,14,7,15,7,16,7,17,7,18,7,19,7,20,8,21,9,22,10,23,11,23,12,23,13,23,14,23,15,23,22,21,20,19,18,17,16,12,11,10,9,8,7,6,13,6,14,6,15,6,16,6,17,6,18,6,19,6,20,7,21,8,22,9,22,10,22,11,22,12,22,13,22,14,22,21,20,19,18,17,16,15,12,11,10,9,8,7,6,5,13,5,14,5,15,5,16,5,17,5,18,5,19,5,20,6,21,7,21,8,21,9,21,10,21,11,21,12,21,13,21,20,19,18,17,16,15,14,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,20,5,20,6,20,7,20,8,20,9,20,10,20,11,20,12,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,19,4,19,5,19,6,19,7,19,8,19,9,19,10,19,18,17,16,15,14,13,12,11,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,18,4,18,4,18,4,18,5,18,6,18,7,18,8,18,17,16,15,14,13,12,11,10,9,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,4,17,4,17,4,17,5,17,6,17,16,15,14,13,12,11,10,9,8,7,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,15,14,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,4,12,4,12,4,12,4,12,4,12,4,12,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,12,13,12,14,13,12,15,14,13,12,16,15,14,13,12,17,16,15,14,13,12,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,23,22,21,20,19,18,17,16,15,24,23,22,21,20,19,18,17,16,25,24,23,22,21,20,19,18,17,26,25,24,23,22,21,20,19,18,27,26,25,24,23,22,21,20,19,28,27,26,25,24,23,22,21,20,12,11,13,11,14,11,15,11,16,11,17,11,18,11,19,11,20,11,21,12,22,13,23,14,24,15,25,16,26,17,27,18,27,26,25,24,23,22,21,20,19,12,11,10,13,10,14,10,15,10,16,10,17,10,18,10,19,10,20,10,21,11,22,12,23,13,24,14,25,15,26,16,26,17,26,25,24,23,22,21,20,19,18,12,11,10,9,13,9,14,9,15,9,16,9,17,9,18,9,19,9,20,9,21,10,22,11,23,12,24,13,25,14,25,15,25,16,25,24,23,22,21,20,19,18,17,12,11,10,9,8,13,8,14,8,15,8,16,8,17,8,18,8,19,8,20,8,21,9,22,10,23,11,24,12,24,13,24,14,24,15,24,23,22,21,20,19,18,17,16,12,11,10,9,8,7,13,7,14,7,15,7,16,7,17,7,18,7,19,7,20,7,21,8,22,9,23,10,23,11,23,12,23,13,23,14,23,22,21,20,19,18,17,16,15,12,11,10,9,8,7,6,13,6,14,6,15,6,16,6,17,6,18,6,19,6,20,6,21,7,22,8,22,9,22,10,22,11,22,12,22,13,22,21,20,19,18,17,16,15,14,12,11,10,9,8,7,6,5,13,5,14,5,15,5,16,5,17,5,18,5,19,5,20,5,21,6,21,7,21,8,21,9,21,10,21,11,21,12,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,20,4,20,5,20,6,20,7,20,8,20,9,20,10,20,11,20,19,18,17,16,15,14,13,12,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,19,4,19,4,19,5,19,6,19,7,19,8,19,9,19,18,17,16,15,14,13,12,11,10,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,18,4,18,4,18,4,18,4,18,4,18,5,18,6,18,7,18,17,16,15,14,13,12,11,10,9,8,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,5,17,16,15,14,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,15,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,12,14,13,12,15,14,13,12,16,15,14,13,12,17,16,15,14,13,12,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,23,22,21,20,19,18,17,16,15,14,24,23,22,21,20,19,18,17,16,15,25,24,23,22,21,20,19,18,17,16,26,25,24,23,22,21,20,19,18,17,27,26,25,24,23,22,21,20,19,18,27,26,25,24,23,22,21,20,19,13,12,11,14,11,15,11,16,11,17,11,18,11,19,11,20,11,21,11,22,12,23,13,24,14,25,15,26,16,26,17,26,25,24,23,22,21,20,19,18,13,12,11,10,14,10,15,10,16,10,17,10,18,10,19,10,20,10,21,10,22,11,23,12,24,13,25,14,25,15,25,16,25,24,23,22,21,20,19,18,17,13,12,11,10,9,14,9,15,9,16,9,17,9,18,9,19,9,20,9,21,9,22,10,23,11,24,12,24,13,24,14,24,15,24,23,22,21,20,19,18,17,16,13,12,11,10,9,8,14,8,15,8,16,8,17,8,18,8,19,8,20,8,21,8,22,9,23,10,23,11,23,12,23,13,23,14,23,22,21,20,19,18,17,16,15,13,12,11,10,9,8,7,14,7,15,7,16,7,17,7,18,7,19,7,20,7,21,7,22,8,22,9,22,10,22,11,22,12,22,13,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,14,6,15,6,16,6,17,6,18,6,19,6,20,6,21,6,21,7,21,8,21,9,21,10,21,11,21,12,21,20,19,18,17,16,15,14,13,13,12,11,10,9,8,7,6,5,14,5,15,5,16,5,17,5,18,5,19,5,20,5,20,5,20,6,20,7,20,8,20,9,20,10,20,11,20,19,18,17,16,15,14,13,12,13,12,11,10,9,8,7,6,5,4,14,4,15,4,16,4,17,4,18,4,19,4,19,4,19,4,19,5,19,6,19,7,19,8,19,9,19,10,19,18,17,16,15,14,13,12,11,13,12,11,10,9,8,7,6,5,4,14,4,15,4,16,4,17,4,18,4,18,4,18,4,18,4,18,4,18,5,18,6,18,7,18,8,18,17,16,15,14,13,12,11,10,9,13,12,11,10,9,8,7,6,5,4,14,4,15,4,16,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,5,17,6,17,16,15,14,13,12,11,10,9,8,7,13,12,11,10,9,8,7,6,5,4,14,4,15,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,15,14,13,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,5,4,14,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,14,13,12,15,14,13,12,16,15,14,13,12,17,16,15,14,13,12,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,23,22,21,20,19,18,17,16,15,14,13,24,23,22,21,20,19,18,17,16,15,14,25,24,23,22,21,20,19,18,17,16,15,26,25,24,23,22,21,20,19,18,17,16,26,25,24,23,22,21,20,19,18,17,26,25,24,23,22,21,20,19,18,14,13,12,11,15,11,16,11,17,11,18,11,19,11,20,11,21,11,22,11,23,12,24,13,25,14,25,15,25,16,25,24,23,22,21,20,19,18,17,14,13,12,11,10,15,10,16,10,17,10,18,10,19,10,20,10,21,10,22,10,23,11,24,12,24,13,24,14,24,15,24,23,22,21,20,19,18,17,16,14,13,12,11,10,9,15,9,16,9,17,9,18,9,19,9,20,9,21,9,22,9,23,10,23,11,23,12,23,13,23,14,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,15,8,16,8,17,8,18,8,19,8,20,8,21,8,22,8,22,9,22,10,22,11,22,12,22,13,22,21,20,19,18,17,16,15,14,14,13,12,11,10,9,8,7,15,7,16,7,17,7,18,7,19,7,20,7,21,7,21,7,21,8,21,9,21,10,21,11,21,12,21,20,19,18,17,16,15,14,13,14,13,12,11,10,9,8,7,6,15,6,16,6,17,6,18,6,19,6,20,6,20,6,20,6,20,7,20,8,20,9,20,10,20,11,20,19,18,17,16,15,14,13,12,14,13,12,11,10,9,8,7,6,5,15,5,16,5,17,5,18,5,19,5,19,5,19,5,19,5,19,6,19,7,19,8,19,9,19,10,19,18,17,16,15,14,13,12,11,14,13,12,11,10,9,8,7,6,5,4,15,4,16,4,17,4,18,4,18,4,18,4,18,4,18,4,18,5,18,6,18,7,18,8,18,9,18,17,16,15,14,13,12,11,10,14,13,12,11,10,9,8,7,6,5,4,15,4,16,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,5,17,6,17,7,17,16,15,14,13,12,11,10,9,8,14,13,12,11,10,9,8,7,6,5,4,15,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,5,16,15,14,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,6,5,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,15,14,13,12,16,15,14,13,12,17,16,15,14,13,12,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,23,22,21,20,19,18,17,16,15,14,13,12,24,23,22,21,20,19,18,17,16,15,14,13,25,24,23,22,21,20,19,18,17,16,15,14,25,24,23,22,21,20,19,18,17,16,15,25,24,23,22,21,20,19,18,17,16,25,24,23,22,21,20,19,18,17,15,14,13,12,11,16,11,17,11,18,11,19,11,20,11,21,11,22,11,23,11,24,12,24,13,24,14,24,15,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,16,10,17,10,18,10,19,10,20,10,21,10,22,10,23,10,23,11,23,12,23,13,23,14,23,22,21,20,19,18,17,16,15,15,14,13,12,11,10,9,16,9,17,9,18,9,19,9,20,9,21,9,22,9,22,9,22,10,22,11,22,12,22,13,22,21,20,19,18,17,16,15,14,15,14,13,12,11,10,9,8,16,8,17,8,18,8,19,8,20,8,21,8,21,8,21,8,21,9,21,10,21,11,21,12,21,20,19,18,17,16,15,14,13,15,14,13,12,11,10,9,8,7,16,7,17,7,18,7,19,7,20,7,20,7,20,7,20,7,20,8,20,9,20,10,20,11,20,19,18,17,16,15,14,13,12,15,14,13,12,11,10,9,8,7,6,16,6,17,6,18,6,19,6,19,6,19,6,19,6,19,6,19,7,19,8,19,9,19,10,19,18,17,16,15,14,13,12,11,15,14,13,12,11,10,9,8,7,6,5,16,5,17,5,18,5,18,5,18,5,18,5,18,5,18,5,18,6,18,7,18,8,18,9,18,17,16,15,14,13,12,11,10,15,14,13,12,11,10,9,8,7,6,5,4,16,4,17,4,17,4,17,4,17,4,17,4,17,4,17,4,17,5,17,6,17,7,17,8,17,16,15,14,13,12,11,10,9,15,14,13,12,11,10,9,8,7,6,5,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,5,16,6,16,15,14,13,12,11,10,9,8,7,15,14,13,12,11,10,9,8,7,6,5,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,14,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,5,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,16,15,14,13,12,17,16,15,14,13,12,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,23,22,21,20,19,18,17,16,15,14,13,12,24,23,22,21,20,19,18,17,16,15,14,13,12,24,23,22,21,20,19,18,17,16,15,14,13,24,23,22,21,20,19,18,17,16,15,14,24,23,22,21,20,19,18,17,16,15,24,23,22,21,20,19,18,17,16,16,15,14,13,12,11,17,11,18,11,19,11,20,11,21,11,22,11,23,11,23,11,23,12,23,13,23,14,23,22,21,20,19,18,17,16,15,16,15,14,13,12,11,10,17,10,18,10,19,10,20,10,21,10,22,10,22,10,22,10,22,11,22,12,22,13,22,21,20,19,18,17,16,15,14,16,15,14,13,12,11,10,9,17,9,18,9,19,9,20,9,21,9,21,9,21,9,21,9,21,10,21,11,21,12,21,20,19,18,17,16,15,14,13,16,15,14,13,12,11,10,9,8,17,8,18,8,19,8,20,8,20,8,20,8,20,8,20,8,20,9,20,10,20,11,20,19,18,17,16,15,14,13,12,16,15,14,13,12,11,10,9,8,7,17,7,18,7,19,7,19,7,19,7,19,7,19,7,19,7,19,8,19,9,19,10,19,18,17,16,15,14,13,12,11,16,15,14,13,12,11,10,9,8,7,6,17,6,18,6,18,6,18,6,18,6,18,6,18,6,18,6,18,7,18,8,18,9,18,17,16,15,14,13,12,11,10,16,15,14,13,12,11,10,9,8,7,6,5,17,5,17,5,17,5,17,5,17,5,17,5,17,5,17,5,17,6,17,7,17,8,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,7,6,5,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,6,5,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,5,15,14,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,6,5,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,17,16,15,14,13,12,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,23,22,21,20,19,18,17,16,15,14,13,12,23,22,21,20,19,18,17,16,15,14,13,12,23,22,21,20,19,18,17,16,15,14,13,12,23,22,21,20,19,18,17,16,15,14,13,23,22,21,20,19,18,17,16,15,14,23,22,21,20,19,18,17,16,15,17,16,15,14,13,12,11,18,11,19,11,20,11,21,11,22,11,22,11,22,11,22,11,22,12,22,13,22,21,20,19,18,17,16,15,14,17,16,15,14,13,12,11,10,18,10,19,10,20,10,21,10,21,10,21,10,21,10,21,10,21,11,21,12,21,20,19,18,17,16,15,14,13,17,16,15,14,13,12,11,10,9,18,9,19,9,20,9,20,9,20,9,20,9,20,9,20,9,20,10,20,11,20,19,18,17,16,15,14,13,12,17,16,15,14,13,12,11,10,9,8,18,8,19,8,19,8,19,8,19,8,19,8,19,8,19,8,19,9,19,10,19,18,17,16,15,14,13,12,11,17,16,15,14,13,12,11,10,9,8,7,18,7,18,7,18,7,18,7,18,7,18,7,18,7,18,7,18,8,18,9,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,8,7,6,17,6,17,6,17,6,17,6,17,6,17,6,17,6,17,6,17,7,17,8,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,7,6,5,16,5,16,5,16,5,16,5,16,5,16,5,16,5,16,5,16,6,16,7,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,6,5,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,5,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,13,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,12,22,21,20,19,18,17,16,15,14,13,22,21,20,19,18,17,16,15,14,18,17,16,15,14,13,12,11,19,11,20,11,21,11,21,11,21,11,21,11,21,11,21,11,21,12,21,20,19,18,17,16,15,14,13,18,17,16,15,14,13,12,11,10,19,10,20,10,20,10,20,10,20,10,20,10,20,10,20,10,20,11,20,19,18,17,16,15,14,13,12,18,17,16,15,14,13,12,11,10,9,19,9,19,9,19,9,19,9,19,9,19,9,19,9,19,9,19,10,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,9,8,18,8,18,8,18,8,18,8,18,8,18,8,18,8,18,8,18,9,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,8,7,17,7,17,7,17,7,17,7,17,7,17,7,17,7,17,7,17,8,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,7,6,16,6,16,6,16,6,16,6,16,6,16,6,16,6,16,6,16,7,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,6,5,15,5,15,5,15,5,15,5,15,5,15,5,15,5,15,5,15,6,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,5,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,12,21,20,19,18,17,16,15,14,13,19,18,17,16,15,14,13,12,11,20,11,20,11,20,11,20,11,20,11,20,11,20,11,20,11,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,10,19,10,19,10,19,10,19,10,19,10,19,10,19,10,19,10,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,9,18,9,18,9,18,9,18,9,18,9,18,9,18,9,18,9,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,8,17,8,17,8,17,8,17,8,17,8,17,8,17,8,17,8,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,7,16,7,16,7,16,7,16,7,16,7,16,7,16,7,16,7,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,6,15,6,15,6,15,6,15,6,15,6,15,6,15,6,15,6,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,5,14,5,14,5,14,5,14,5,14,5,14,5,14,5,14,5,14,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,19,11,19,11,19,11,19,11,19,11,19,11,19,11,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,18,10,18,10,18,10,18,10,18,10,18,10,18,10,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,17,9,17,9,17,9,17,9,17,9,17,9,17,9,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,15,7,15,7,15,7,15,7,15,7,15,7,15,7,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,14,6,14,6,14,6,14,6,14,6,14,6,14,6,14,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,13,5,13,5,13,5,13,5,13,5,13,5,13,5,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,18,17,16,15,14,13,12,11,18,11,18,11,18,11,18,11,18,11,18,11,18,17,16,15,14,13,12,11,17,16,15,14,13,12,11,10,17,10,17,10,17,10,17,10,17,10,17,10,17,16,15,14,13,12,11,10,16,15,14,13,12,11,10,9,16,9,16,9,16,9,16,9,16,9,16,9,16,15,14,13,12,11,10,9,15,14,13,12,11,10,9,8,15,8,15,8,15,8,15,8,15,8,15,8,15,14,13,12,11,10,9,8,14,13,12,11,10,9,8,7,14,7,14,7,14,7,14,7,14,7,14,7,14,13,12,11,10,9,8,7,13,12,11,10,9,8,7,6,13,6,13,6,13,6,13,6,13,6,13,6,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,18,17,16,15,14,13,12,18,17,16,15,14,13,12,18,17,16,15,14,13,12,18,17,16,15,14,13,12,18,17,16,15,14,13,12,18,17,16,15,14,13,12,18,17,16,15,14,13,12,17,16,15,14,13,12,11,17,11,17,11,17,11,17,11,17,11,17,16,15,14,13,12,11,16,15,14,13,12,11,10,16,10,16,10,16,10,16,10,16,10,16,15,14,13,12,11,10,15,14,13,12,11,10,9,15,9,15,9,15,9,15,9,15,9,15,14,13,12,11,10,9,14,13,12,11,10,9,8,14,8,14,8,14,8,14,8,14,8,14,13,12,11,10,9,8,13,12,11,10,9,8,7,13,7,13,7,13,7,13,7,13,7,13,12,11,10,9,8,7,12,11,10,9,8,7,6,12,11,10,9,8,7,6,12,11,10,9,8,7,6,12,11,10,9,8,7,6,12,11,10,9,8,7,6,12,11,10,9,8,7,6,12,11,10,9,8,7,6,17,16,15,14,13,12,17,16,15,14,13,12,17,16,15,14,13,12,17,16,15,14,13,12,17,16,15,14,13,12,17,16,15,14,13,12,16,15,14,13,12,11,16,11,16,11,16,11,16,11,16,15,14,13,12,11,15,14,13,12,11,10,15,10,15,10,15,10,15,10,15,14,13,12,11,10,14,13,12,11,10,9,14,9,14,9,14,9,14,9,14,13,12,11,10,9,13,12,11,10,9,8,13,8,13,8,13,8,13,8,13,12,11,10,9,8,12,11,10,9,8,7,12,11,10,9,8,7,12,11,10,9,8,7,12,11,10,9,8,7,12,11,10,9,8,7,12,11,10,9,8,7,16,15,14,13,12,16,15,14,13,12,16,15,14,13,12,16,15,14,13,12,16,15,14,13,12,15,14,13,12,11,15,11,15,11,15,11,15,14,13,12,11,14,13,12,11,10,14,10,14,10,14,10,14,13,12,11,10,13,12,11,10,9,13,9,13,9,13,9,13,12,11,10,9,12,11,10,9,8,12,11,10,9,8,12,11,10,9,8,12,11,10,9,8,12,11,10,9,8,15,14,13,12,15,14,13,12,15,14,13,12,15,14,13,12,14,13,12,11,14,11,14,11,14,13,12,11,13,12,11,10,13,10,13,10,13,12,11,10,12,11,10,9,12,11,10,9,12,11,10,9,12,11,10,9,14,13,12,14,13,12,14,13,12,13,12,11,13,11,13,12,11,12,11,10,12,11,10,12,11,10,13,12,13,12,12,11,12,11,12},{4,3,2,4,3,2,4,3,2,3,2,2,5,4,3,5,4,3,2,4,3,2,3,2,6,5,4,5,4,3,4,3,2,6,5,5,4,6,4,3,4,3,2,4,3,2,4,3,2,3,2,5,4,3,5,4,3,2,5,4,3,2,4,3,2,3,2,6,5,4,6,5,4,3,5,4,3,2,4,3,2,7,6,5,6,5,4,5,4,3,7,6,6,5,4,4,3,4,3,2,4,3,2,4,3,2,5,4,5,4,3,5,4,3,2,5,4,3,2,4,3,2,6,5,4,6,5,4,3,6,5,4,3,2,5,4,3,2,4,3,2,7,6,5,7,6,5,4,6,5,4,3,5,4,3,2,8,7,6,7,6,5,6,5,4,5,4,5,4,3,5,4,3,2,4,3,2,6,5,4,6,5,4,3,5,4,3,2,4,3,2,7,6,5,4,6,5,4,3,5,4,3,2,4,3,2,7,6,5,6,5,4,5,4,3,6,5,4,5,4,3,4,3,2,6,5,4,5,4,3,4,3,2,6,5,4,5,4,3,4,3,2,5,4,4,3,5,4,4,3,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,6,5,4,3,5,4,3,4,3,3,9,8,7,6,5,4,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,6,5,4,3,5,4,3,4,3,10,9,8,7,6,5,10,9,8,7,6,5,4,10,9,8,7,6,5,4,3,10,9,8,7,6,5,4,3,9,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,6,5,4,3,5,4,3,11,10,9,8,7,6,11,10,9,8,7,6,5,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,3,9,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,6,5,4,3,12,11,10,9,8,7,12,11,10,9,8,7,6,11,10,9,8,7,6,5,10,9,8,7,6,5,4,9,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,13,12,11,10,9,8,12,11,10,9,8,7,11,10,9,8,7,6,10,9,8,7,6,5,9,8,7,6,5,4,8,7,6,5,4,3,13,12,11,10,9,12,11,10,9,8,11,10,9,8,7,10,9,8,7,6,9,8,7,6,5,13,12,11,10,12,11,10,9,11,10,9,8,10,9,8,7,13,12,11,12,11,10,11,10,9,13,12,12,11,13,8,7,6,5,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,6,5,4,3,5,4,3,4,3,9,8,7,6,5,4,9,3,9,3,9,3,9,3,9,3,8,3,7,3,6,3,5,3,4,3,10,9,8,7,6,5,10,4,10,3,10,3,10,3,9,3,8,3,7,3,6,3,5,4,3,11,10,9,8,7,6,11,5,11,4,11,3,10,3,9,3,8,3,7,3,6,5,4,3,12,11,10,9,8,7,12,6,12,5,11,4,10,3,9,3,8,3,7,6,5,4,3,13,12,11,10,9,8,13,7,12,6,11,5,10,4,9,3,8,7,6,5,4,3,14,13,12,11,10,9,13,8,12,7,11,6,10,5,9,8,7,6,5,4,14,13,12,11,10,13,9,12,8,11,7,10,9,8,7,6,14,13,12,11,13,10,12,9,11,10,9,8,14,13,12,13,11,12,11,10,14,13,13,12,8,7,6,5,8,7,6,5,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,6,5,4,3,5,4,3,9,8,7,6,5,9,4,9,3,9,3,9,3,9,3,9,3,8,3,7,3,6,3,5,4,3,10,9,8,7,6,5,10,4,10,3,10,3,10,3,10,3,9,3,8,3,7,3,6,3,5,4,3,11,10,9,8,7,6,11,5,11,4,11,3,11,3,10,3,9,3,8,3,7,3,6,5,4,3,12,11,10,9,8,7,12,6,12,5,12,4,11,3,10,3,9,3,8,3,7,6,5,4,3,13,12,11,10,9,8,13,7,13,6,12,5,11,4,10,3,9,3,8,7,6,5,4,3,14,13,12,11,10,9,14,8,13,7,12,6,11,5,10,4,9,8,7,6,5,4,3,15,14,13,12,11,10,14,9,13,8,12,7,11,6,10,9,8,7,6,5,15,14,13,12,11,14,10,13,9,12,8,11,10,9,8,7,15,14,13,12,14,11,13,10,12,11,10,9,15,14,13,14,13,12,13,12,11,8,7,6,8,7,6,5,8,7,6,5,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,6,5,4,3,9,8,7,6,9,5,9,4,9,3,9,3,9,3,9,3,9,3,8,3,7,3,6,5,4,3,10,9,8,7,6,10,5,10,4,10,3,10,3,10,3,10,3,9,3,8,3,7,3,6,5,4,3,11,10,9,8,7,6,11,5,11,4,11,3,11,3,11,3,10,3,9,3,8,3,7,3,6,5,4,3,12,11,10,9,8,7,12,6,12,5,12,4,12,3,11,3,10,3,9,3,8,3,7,6,5,4,3,13,12,11,10,9,8,13,7,13,6,13,5,12,4,11,3,10,3,9,3,8,7,6,5,4,3,14,13,12,11,10,9,14,8,14,7,13,6,12,5,11,4,10,3,9,8,7,6,5,4,3,15,14,13,12,11,10,15,9,14,8,13,7,12,6,11,5,10,9,8,7,6,5,4,16,15,14,13,12,11,15,10,14,9,13,8,12,7,11,10,9,8,7,6,16,15,14,13,12,15,11,14,10,13,9,12,11,10,9,8,16,15,14,13,15,14,13,12,14,13,12,11,13,12,11,10,8,7,8,7,6,8,7,6,5,8,7,6,5,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,7,6,5,4,3,9,8,7,9,6,9,5,9,4,9,3,9,3,9,3,9,3,9,3,8,3,7,6,5,4,3,10,9,8,7,10,6,10,5,10,4,10,3,10,3,10,3,10,3,9,3,8,3,7,6,5,4,3,11,10,9,8,7,11,6,11,5,11,4,11,3,11,3,11,3,10,3,9,3,8,3,7,6,5,4,3,12,11,10,9,8,7,12,6,12,5,12,4,12,3,12,3,11,3,10,3,9,3,8,3,7,6,5,4,3,13,12,11,10,9,8,13,7,13,6,13,5,13,4,12,3,11,3,10,3,9,3,8,7,6,5,4,3,14,13,12,11,10,9,14,8,14,7,14,6,13,5,12,4,11,3,10,3,9,8,7,6,5,4,3,15,14,13,12,11,10,15,9,15,8,14,7,13,6,12,5,11,4,10,9,8,7,6,5,4,3,16,15,14,13,12,11,16,10,15,9,14,8,13,7,12,6,11,10,9,8,7,6,5,17,16,15,14,13,12,16,11,15,10,14,9,13,8,12,11,10,9,8,7,17,16,15,14,13,16,15,14,13,12,15,14,13,12,11,14,13,12,11,10,13,12,11,10,9,8,8,7,8,7,6,8,7,6,5,8,7,6,5,4,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,8,7,6,5,4,3,9,8,9,7,9,6,9,5,9,4,9,3,9,3,9,3,9,3,9,3,8,7,6,5,4,3,10,9,8,10,7,10,6,10,5,10,4,10,3,10,3,10,3,10,3,9,3,8,7,6,5,4,3,11,10,9,8,11,7,11,6,11,5,11,4,11,3,11,3,11,3,10,3,9,3,8,7,6,5,4,3,12,11,10,9,8,12,7,12,6,12,5,12,4,12,3,12,3,11,3,10,3,9,3,8,7,6,5,4,3,13,12,11,10,9,8,13,7,13,6,13,5,13,4,13,3,12,3,11,3,10,3,9,3,8,7,6,5,4,3,14,13,12,11,10,9,14,8,14,7,14,6,14,5,13,4,12,3,11,3,10,3,9,8,7,6,5,4,3,15,14,13,12,11,10,15,9,15,8,15,7,14,6,13,5,12,4,11,3,10,9,8,7,6,5,4,3,16,15,14,13,12,11,16,10,16,9,15,8,14,7,13,6,12,5,11,10,9,8,7,6,5,4,17,16,15,14,13,12,17,11,16,10,15,9,14,8,13,7,12,11,10,9,8,7,6,18,17,16,15,14,13,17,16,15,14,13,12,16,15,14,13,12,11,15,14,13,12,11,10,14,13,12,11,10,9,13,12,11,10,9,8,9,8,9,8,7,9,8,7,6,9,8,7,6,5,9,8,7,6,5,4,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,3,9,8,7,6,5,4,3,8,7,6,5,4,3,10,9,8,10,7,10,6,10,5,10,4,10,3,10,3,10,3,9,3,8,7,6,5,4,3,11,10,9,8,11,7,11,6,11,5,11,4,11,3,11,3,10,3,9,3,8,7,6,5,4,3,12,11,10,9,8,12,7,12,6,12,5,12,4,12,3,11,3,10,3,9,3,8,7,6,5,4,3,13,12,11,10,9,8,13,7,13,6,13,5,13,4,12,3,11,3,10,3,9,3,8,7,6,5,4,3,14,13,12,11,10,9,8,14,7,14,6,14,5,13,4,12,3,11,3,10,3,9,3,8,7,6,5,4,3,15,14,13,12,11,10,9,15,8,15,7,14,6,13,5,12,4,11,3,10,3,9,8,7,6,5,4,3,16,15,14,13,12,11,10,16,9,15,8,14,7,13,6,12,5,11,4,10,9,8,7,6,5,4,3,17,16,15,14,13,12,11,16,10,15,9,14,8,13,7,12,6,11,10,9,8,7,6,5,17,16,15,14,13,12,16,15,14,13,12,11,15,14,13,12,11,10,14,13,12,11,10,9,13,12,11,10,9,8,12,11,10,9,8,7,10,9,8,10,9,8,7,10,9,8,7,6,10,9,8,7,6,5,10,9,8,7,6,5,4,10,9,8,7,6,5,4,3,10,9,8,7,6,5,4,3,9,8,7,6,5,4,3,8,7,6,5,4,3,11,10,9,8,11,7,11,6,11,5,11,4,11,3,10,3,9,3,8,7,6,5,4,3,12,11,10,9,8,12,7,12,6,12,5,12,4,11,3,10,3,9,3,8,7,6,5,4,3,13,12,11,10,9,8,13,7,13,6,13,5,12,4,11,3,10,3,9,3,8,7,6,5,4,3,14,13,12,11,10,9,8,14,7,14,6,13,5,12,4,11,3,10,3,9,3,8,7,6,5,4,3,15,14,13,12,11,10,9,8,15,7,14,6,13,5,12,4,11,3,10,3,9,3,8,7,6,5,4,3,16,15,14,13,12,11,10,9,15,8,14,7,13,6,12,5,11,4,10,3,9,8,7,6,5,4,3,16,15,14,13,12,11,10,15,9,14,8,13,7,12,6,11,5,10,9,8,7,6,5,4,16,15,14,13,12,11,15,14,13,12,11,10,14,13,12,11,10,9,13,12,11,10,9,8,12,11,10,9,8,7,11,10,9,8,7,6,11,10,9,8,11,10,9,8,7,11,10,9,8,7,6,11,10,9,8,7,6,5,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,3,9,8,7,6,5,4,3,8,7,6,5,4,3,12,11,10,9,8,12,7,12,6,12,5,11,4,10,3,9,3,8,7,6,5,4,3,13,12,11,10,9,8,13,7,13,6,12,5,11,4,10,3,9,3,8,7,6,5,4,3,14,13,12,11,10,9,8,14,7,13,6,12,5,11,4,10,3,9,3,8,7,6,5,4,3,15,14,13,12,11,10,9,8,14,7,13,6,12,5,11,4,10,3,9,3,8,7,6,5,4,3,15,14,13,12,11,10,9,8,14,7,13,6,12,5,11,4,10,3,9,3,8,7,6,5,4,3,15,14,13,12,11,10,9,14,8,13,7,12,6,11,5,10,4,9,8,7,6,5,4,3,15,14,13,12,11,10,14,13,12,11,10,9,13,12,11,10,9,8,12,11,10,9,8,7,11,10,9,8,7,6,10,9,8,7,6,5,12,11,10,9,8,12,11,10,9,8,7,12,11,10,9,8,7,6,11,10,9,8,7,6,5,10,9,8,7,6,5,4,9,8,7,6,5,4,3,8,7,6,5,4,3,13,12,11,10,9,8,13,7,12,6,11,5,10,4,9,3,8,7,6,5,4,3,14,13,12,11,10,9,8,13,7,12,6,11,5,10,4,9,3,8,7,6,5,4,3,14,13,12,11,10,9,8,13,7,12,6,11,5,10,4,9,3,8,7,6,5,4,3,14,13,12,11,10,9,8,13,7,12,6,11,5,10,4,9,3,8,7,6,5,4,3,14,13,12,11,10,9,8,13,7,12,6,11,5,10,4,9,3,8,7,6,5,4,3,14,13,12,11,10,9,13,12,11,10,9,8,12,11,10,9,8,7,11,10,9,8,7,6,10,9,8,7,6,5,9,8,7,6,5,4,13,12,11,10,9,8,12,11,10,9,8,7,11,10,9,8,7,6,10,9,8,7,6,5,9,8,7,6,5,4,8,7,6,5,4,3,13,12,11,10,9,8,12,7,11,6,10,5,9,4,8,7,6,5,4,3,13,12,11,10,9,8,12,7,11,6,10,5,9,4,8,7,6,5,4,3,13,12,11,10,9,8,12,7,11,6,10,5,9,4,8,7,6,5,4,3,13,12,11,10,9,8,12,7,11,6,10,5,9,4,8,7,6,5,4,3,13,12,11,10,9,8,12,11,10,9,8,7,11,10,9,8,7,6,10,9,8,7,6,5,9,8,7,6,5,4,8,7,6,5,4,3,12,11,10,9,8,11,10,9,8,7,10,9,8,7,6,9,8,7,6,5,8,7,6,5,4,12,11,10,9,8,11,7,10,6,9,5,8,7,6,5,4,12,11,10,9,8,11,7,10,6,9,5,8,7,6,5,4,12,11,10,9,8,11,7,10,6,9,5,8,7,6,5,4,12,11,10,9,8,11,10,9,8,7,10,9,8,7,6,9,8,7,6,5,8,7,6,5,4,11,10,9,8,10,9,8,7,9,8,7,6,8,7,6,5,11,10,9,8,10,7,9,6,8,7,6,5,11,10,9,8,10,7,9,6,8,7,6,5,11,10,9,8,10,9,8,7,9,8,7,6,8,7,6,5,10,9,8,9,8,7,8,7,6,10,9,8,9,7,8,7,6,10,9,8,9,8,7,8,7,6,9,8,8,7,9,8,8,7,8,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,7,6,5,4,6,5,4,5,4,4,13,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,7,6,5,4,6,5,4,5,4,14,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,7,6,5,4,6,5,4,15,14,13,12,11,10,9,8,7,15,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,6,5,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,7,6,5,4,16,15,14,13,12,11,10,9,8,16,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,7,6,16,15,14,13,12,11,10,9,8,7,6,5,16,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,17,16,15,14,13,12,11,10,9,17,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,8,7,17,16,15,14,13,12,11,10,9,8,7,6,16,15,14,13,12,11,10,9,8,7,6,5,15,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,18,17,16,15,14,13,12,11,10,18,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,18,17,16,15,14,13,12,11,10,18,17,16,15,14,13,12,11,10,9,17,16,15,14,13,12,11,10,9,8,16,15,14,13,12,11,10,9,8,7,15,14,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,19,18,17,16,15,14,13,12,18,17,16,15,14,13,12,11,17,16,15,14,13,12,11,10,16,15,14,13,12,11,10,9,15,14,13,12,11,10,9,8,14,13,12,11,10,9,8,7,13,12,11,10,9,8,7,6,20,19,18,17,16,15,14,19,18,17,16,15,14,13,18,17,16,15,14,13,12,17,16,15,14,13,12,11,16,15,14,13,12,11,10,15,14,13,12,11,10,9,14,13,12,11,10,9,8,20,19,18,17,16,15,19,18,17,16,15,14,18,17,16,15,14,13,17,16,15,14,13,12,16,15,14,13,12,11,15,14,13,12,11,10,20,19,18,17,16,19,18,17,16,15,18,17,16,15,14,17,16,15,14,13,16,15,14,13,12,20,19,18,17,19,18,17,16,18,17,16,15,17,16,15,14,20,19,18,19,18,17,18,17,16,20,19,19,18,20,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,7,6,5,4,6,5,4,5,4,13,12,11,10,9,8,7,6,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,4,11,4,10,4,9,4,8,4,7,4,6,4,5,4,14,13,12,11,10,9,8,7,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,4,11,4,10,4,9,4,8,4,7,4,6,5,4,15,14,13,12,11,10,9,8,7,15,6,15,5,15,4,15,4,15,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,4,7,6,5,4,16,15,14,13,12,11,10,9,8,16,7,16,6,16,5,16,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,7,6,5,4,17,16,15,14,13,12,11,10,9,17,8,17,7,17,6,17,5,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,18,17,16,15,14,13,12,11,10,18,9,18,8,18,7,17,6,16,5,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,20,12,19,11,18,10,17,9,16,8,15,7,14,6,13,12,11,10,9,8,7,6,5,21,20,19,18,17,16,15,14,20,13,19,12,18,11,17,10,16,9,15,8,14,13,12,11,10,9,8,7,21,20,19,18,17,16,15,20,14,19,13,18,12,17,11,16,10,15,14,13,12,11,10,9,21,20,19,18,17,16,20,15,19,14,18,13,17,12,16,15,14,13,12,11,21,20,19,18,17,20,16,19,15,18,14,17,16,15,14,13,21,20,19,18,20,17,19,16,18,17,16,15,21,20,19,20,18,19,18,17,21,20,20,19,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,7,6,5,4,6,5,4,13,12,11,10,9,8,7,6,13,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,4,11,4,10,4,9,4,8,4,7,4,6,5,4,14,13,12,11,10,9,8,7,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,4,11,4,10,4,9,4,8,4,7,4,6,5,4,15,14,13,12,11,10,9,8,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,4,7,6,5,4,16,15,14,13,12,11,10,9,8,16,7,16,6,16,5,16,4,16,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,7,6,5,4,17,16,15,14,13,12,11,10,9,17,8,17,7,17,6,17,5,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,18,17,16,15,14,13,12,11,10,18,9,18,8,18,7,18,6,17,5,16,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,10,19,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,21,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,21,13,20,12,19,11,18,10,17,9,16,8,15,7,14,13,12,11,10,9,8,7,6,22,21,20,19,18,17,16,15,21,14,20,13,19,12,18,11,17,10,16,9,15,14,13,12,11,10,9,8,22,21,20,19,18,17,16,21,15,20,14,19,13,18,12,17,11,16,15,14,13,12,11,10,22,21,20,19,18,17,21,16,20,15,19,14,18,13,17,16,15,14,13,12,22,21,20,19,18,21,17,20,16,19,15,18,17,16,15,14,22,21,20,19,21,18,20,17,19,18,17,16,22,21,20,21,20,19,20,19,18,12,11,10,9,8,7,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,7,6,5,4,13,12,11,10,9,8,7,13,6,13,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,4,11,4,10,4,9,4,8,4,7,6,5,4,14,13,12,11,10,9,8,7,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,4,11,4,10,4,9,4,8,4,7,6,5,4,15,14,13,12,11,10,9,8,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,4,7,6,5,4,16,15,14,13,12,11,10,9,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,7,6,5,4,17,16,15,14,13,12,11,10,9,17,8,17,7,17,6,17,5,17,4,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,18,17,16,15,14,13,12,11,10,18,9,18,8,18,7,18,6,18,5,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,10,19,9,19,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,21,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,22,13,21,12,20,11,19,10,18,9,17,8,16,7,15,6,14,13,12,11,10,9,8,7,6,5,23,22,21,20,19,18,17,16,15,22,14,21,13,20,12,19,11,18,10,17,9,16,8,15,14,13,12,11,10,9,8,7,23,22,21,20,19,18,17,16,22,15,21,14,20,13,19,12,18,11,17,10,16,15,14,13,12,11,10,9,23,22,21,20,19,18,17,22,16,21,15,20,14,19,13,18,12,17,16,15,14,13,12,11,23,22,21,20,19,18,22,17,21,16,20,15,19,14,18,17,16,15,14,13,23,22,21,20,19,22,18,21,17,20,16,19,18,17,16,15,23,22,21,20,22,21,20,19,21,20,19,18,20,19,18,17,12,11,10,9,8,12,11,10,9,8,7,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,8,7,6,5,4,13,12,11,10,9,8,13,7,13,6,13,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,4,11,4,10,4,9,4,8,7,6,5,4,14,13,12,11,10,9,8,14,7,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,4,11,4,10,4,9,4,8,7,6,5,4,15,14,13,12,11,10,9,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,7,6,5,4,16,15,14,13,12,11,10,9,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,4,8,7,6,5,4,17,16,15,14,13,12,11,10,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,18,17,16,15,14,13,12,11,10,18,9,18,8,18,7,18,6,18,5,18,4,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,10,19,9,19,8,19,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,21,12,21,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,22,13,22,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,13,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,23,14,22,13,21,12,20,11,19,10,18,9,17,8,16,7,15,14,13,12,11,10,9,8,7,6,24,23,22,21,20,19,18,17,16,23,15,22,14,21,13,20,12,19,11,18,10,17,9,16,15,14,13,12,11,10,9,8,24,23,22,21,20,19,18,17,23,16,22,15,21,14,20,13,19,12,18,11,17,16,15,14,13,12,11,10,24,23,22,21,20,19,18,23,17,22,16,21,15,20,14,19,13,18,17,16,15,14,13,12,24,23,22,21,20,19,23,18,22,17,21,16,20,15,19,18,17,16,15,14,24,23,22,21,20,23,22,21,20,19,22,21,20,19,18,21,20,19,18,17,20,19,18,17,16,12,11,10,9,12,11,10,9,8,12,11,10,9,8,7,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,9,8,7,6,5,4,13,12,11,10,9,13,8,13,7,13,6,13,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,14,13,12,11,10,9,14,8,14,7,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,15,14,13,12,11,10,9,15,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,16,15,14,13,12,11,10,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,17,16,15,14,13,12,11,10,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,4,9,8,7,6,5,4,18,17,16,15,14,13,12,11,10,18,9,18,8,18,7,18,6,18,5,18,4,18,4,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,10,19,9,19,8,19,7,19,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,21,12,21,11,21,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,22,13,22,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,13,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,23,14,23,13,22,12,21,11,20,10,19,9,18,8,17,7,16,6,15,14,13,12,11,10,9,8,7,6,5,24,23,22,21,20,19,18,17,16,24,15,23,14,22,13,21,12,20,11,19,10,18,9,17,8,16,15,14,13,12,11,10,9,8,7,25,24,23,22,21,20,19,18,17,24,16,23,15,22,14,21,13,20,12,19,11,18,10,17,16,15,14,13,12,11,10,9,25,24,23,22,21,20,19,18,24,17,23,16,22,15,21,14,20,13,19,12,18,17,16,15,14,13,12,11,25,24,23,22,21,20,19,24,18,23,17,22,16,21,15,20,14,19,18,17,16,15,14,13,25,24,23,22,21,20,24,23,22,21,20,19,23,22,21,20,19,18,22,21,20,19,18,17,21,20,19,18,17,16,20,19,18,17,16,15,12,11,10,12,11,10,9,12,11,10,9,8,12,11,10,9,8,7,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,10,9,8,7,6,5,4,13,12,11,10,13,9,13,8,13,7,13,6,13,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,4,11,4,10,9,8,7,6,5,4,14,13,12,11,10,14,9,14,8,14,7,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,15,14,13,12,11,10,15,9,15,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,16,15,14,13,12,11,10,16,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,17,16,15,14,13,12,11,10,17,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,18,17,16,15,14,13,12,11,10,18,9,18,8,18,7,18,6,18,5,18,4,18,4,18,4,17,4,16,4,15,4,14,4,13,4,12,4,11,4,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,10,19,9,19,8,19,7,19,6,19,5,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,20,7,20,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,21,12,21,11,21,10,21,9,21,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,22,13,22,12,22,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,13,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,23,14,23,13,23,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,14,13,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,24,15,24,14,23,13,22,12,21,11,20,10,19,9,18,8,17,7,16,15,14,13,12,11,10,9,8,7,6,25,24,23,22,21,20,19,18,17,25,16,24,15,23,14,22,13,21,12,20,11,19,10,18,9,17,16,15,14,13,12,11,10,9,8,26,25,24,23,22,21,20,19,18,25,17,24,16,23,15,22,14,21,13,20,12,19,11,18,17,16,15,14,13,12,11,10,26,25,24,23,22,21,20,19,25,18,24,17,23,16,22,15,21,14,20,13,19,18,17,16,15,14,13,12,26,25,24,23,22,21,20,25,24,23,22,21,20,19,24,23,22,21,20,19,18,23,22,21,20,19,18,17,22,21,20,19,18,17,16,21,20,19,18,17,16,15,20,19,18,17,16,15,14,12,11,12,11,10,12,11,10,9,12,11,10,9,8,12,11,10,9,8,7,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,11,10,9,8,7,6,5,4,13,12,11,13,10,13,9,13,8,13,7,13,6,13,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,4,11,10,9,8,7,6,5,4,14,13,12,11,14,10,14,9,14,8,14,7,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,15,14,13,12,11,15,10,15,9,15,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,16,15,14,13,12,11,16,10,16,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,17,16,15,14,13,12,11,17,10,17,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,11,18,10,18,9,18,8,18,7,18,6,18,5,18,4,18,4,18,4,17,4,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,11,19,10,19,9,19,8,19,7,19,6,19,5,19,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,4,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,20,7,20,6,20,5,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,21,12,21,11,21,10,21,9,21,8,21,7,20,6,19,5,18,4,17,4,16,4,15,4,14,4,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,22,13,22,12,22,11,22,10,22,9,21,8,20,7,19,6,18,5,17,4,16,4,15,4,14,13,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,23,14,23,13,23,12,23,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,14,13,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,24,15,24,14,24,13,23,12,22,11,21,10,20,9,19,8,18,7,17,6,16,15,14,13,12,11,10,9,8,7,6,5,25,24,23,22,21,20,19,18,17,25,16,25,15,24,14,23,13,22,12,21,11,20,10,19,9,18,8,17,16,15,14,13,12,11,10,9,8,7,26,25,24,23,22,21,20,19,18,26,17,25,16,24,15,23,14,22,13,21,12,20,11,19,10,18,17,16,15,14,13,12,11,10,9,27,26,25,24,23,22,21,20,19,26,18,25,17,24,16,23,15,22,14,21,13,20,12,19,18,17,16,15,14,13,12,11,27,26,25,24,23,22,21,20,26,25,24,23,22,21,20,19,25,24,23,22,21,20,19,18,24,23,22,21,20,19,18,17,23,22,21,20,19,18,17,16,22,21,20,19,18,17,16,15,21,20,19,18,17,16,15,14,20,19,18,17,16,15,14,13,12,12,11,12,11,10,12,11,10,9,12,11,10,9,8,12,11,10,9,8,7,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,13,12,13,11,13,10,13,9,13,8,13,7,13,6,13,5,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,12,11,10,9,8,7,6,5,4,14,13,12,14,11,14,10,14,9,14,8,14,7,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,11,10,9,8,7,6,5,4,15,14,13,12,15,11,15,10,15,9,15,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,16,15,14,13,12,16,11,16,10,16,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,17,16,15,14,13,12,17,11,17,10,17,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,18,11,18,10,18,9,18,8,18,7,18,6,18,5,18,4,18,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,11,19,10,19,9,19,8,19,7,19,6,19,5,19,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,20,7,20,6,20,5,20,4,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,21,12,21,11,21,10,21,9,21,8,21,7,21,6,20,5,19,4,18,4,17,4,16,4,15,4,14,4,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,22,13,22,12,22,11,22,10,22,9,22,8,21,7,20,6,19,5,18,4,17,4,16,4,15,4,14,13,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,23,14,23,13,23,12,23,11,23,10,22,9,21,8,20,7,19,6,18,5,17,4,16,4,15,14,13,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,24,15,24,14,24,13,24,12,23,11,22,10,21,9,20,8,19,7,18,6,17,5,16,15,14,13,12,11,10,9,8,7,6,5,4,25,24,23,22,21,20,19,18,17,25,16,25,15,25,14,24,13,23,12,22,11,21,10,20,9,19,8,18,7,17,16,15,14,13,12,11,10,9,8,7,6,26,25,24,23,22,21,20,19,18,26,17,26,16,25,15,24,14,23,13,22,12,21,11,20,10,19,9,18,17,16,15,14,13,12,11,10,9,8,27,26,25,24,23,22,21,20,19,27,18,26,17,25,16,24,15,23,14,22,13,21,12,20,11,19,18,17,16,15,14,13,12,11,10,28,27,26,25,24,23,22,21,20,27,26,25,24,23,22,21,20,19,26,25,24,23,22,21,20,19,18,25,24,23,22,21,20,19,18,17,24,23,22,21,20,19,18,17,16,23,22,21,20,19,18,17,16,15,22,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,13,12,13,12,11,13,12,11,10,13,12,11,10,9,13,12,11,10,9,8,13,12,11,10,9,8,7,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,14,13,12,14,11,14,10,14,9,14,8,14,7,14,6,14,5,14,4,14,4,14,4,14,4,14,4,14,4,13,4,12,11,10,9,8,7,6,5,4,15,14,13,12,15,11,15,10,15,9,15,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,16,15,14,13,12,16,11,16,10,16,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,17,16,15,14,13,12,17,11,17,10,17,9,17,8,17,7,17,6,17,5,17,4,17,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,18,11,18,10,18,9,18,8,18,7,18,6,18,5,18,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,11,19,10,19,9,19,8,19,7,19,6,19,5,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,20,7,20,6,20,5,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,21,11,21,10,21,9,21,8,21,7,21,6,20,5,19,4,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,22,12,22,11,22,10,22,9,22,8,21,7,20,6,19,5,18,4,17,4,16,4,15,4,14,4,13,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,23,13,23,12,23,11,23,10,22,9,21,8,20,7,19,6,18,5,17,4,16,4,15,4,14,13,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,15,24,14,24,13,24,12,23,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,14,13,12,11,10,9,8,7,6,5,4,25,24,23,22,21,20,19,18,17,16,25,15,25,14,24,13,23,12,22,11,21,10,20,9,19,8,18,7,17,6,16,15,14,13,12,11,10,9,8,7,6,5,26,25,24,23,22,21,20,19,18,17,26,16,25,15,24,14,23,13,22,12,21,11,20,10,19,9,18,8,17,16,15,14,13,12,11,10,9,8,7,27,26,25,24,23,22,21,20,19,18,26,17,25,16,24,15,23,14,22,13,21,12,20,11,19,10,18,17,16,15,14,13,12,11,10,9,27,26,25,24,23,22,21,20,19,26,25,24,23,22,21,20,19,18,25,24,23,22,21,20,19,18,17,24,23,22,21,20,19,18,17,16,23,22,21,20,19,18,17,16,15,22,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,14,13,12,14,13,12,11,14,13,12,11,10,14,13,12,11,10,9,14,13,12,11,10,9,8,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,15,14,13,12,15,11,15,10,15,9,15,8,15,7,15,6,15,5,15,4,15,4,15,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,16,15,14,13,12,16,11,16,10,16,9,16,8,16,7,16,6,16,5,16,4,16,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,17,16,15,14,13,12,17,11,17,10,17,9,17,8,17,7,17,6,17,5,17,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,18,11,18,10,18,9,18,8,18,7,18,6,18,5,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,11,19,10,19,9,19,8,19,7,19,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,20,7,20,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,21,11,21,10,21,9,21,8,21,7,20,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,22,11,22,10,22,9,22,8,21,7,20,6,19,5,18,4,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,13,23,12,23,11,23,10,22,9,21,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,15,14,24,13,24,12,23,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,13,12,11,10,9,8,7,6,5,4,25,24,23,22,21,20,19,18,17,16,15,25,14,24,13,23,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,14,13,12,11,10,9,8,7,6,5,4,26,25,24,23,22,21,20,19,18,17,16,25,15,24,14,23,13,22,12,21,11,20,10,19,9,18,8,17,7,16,15,14,13,12,11,10,9,8,7,6,26,25,24,23,22,21,20,19,18,17,25,16,24,15,23,14,22,13,21,12,20,11,19,10,18,9,17,16,15,14,13,12,11,10,9,8,26,25,24,23,22,21,20,19,18,25,24,23,22,21,20,19,18,17,24,23,22,21,20,19,18,17,16,23,22,21,20,19,18,17,16,15,22,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,15,14,13,12,15,14,13,12,11,15,14,13,12,11,10,15,14,13,12,11,10,9,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,15,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,6,5,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,16,15,14,13,12,16,11,16,10,16,9,16,8,16,7,16,6,16,5,16,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,17,16,15,14,13,12,17,11,17,10,17,9,17,8,17,7,17,6,17,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,18,11,18,10,18,9,18,8,18,7,18,6,18,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,11,19,10,19,9,19,8,19,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,21,11,21,10,21,9,21,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,22,11,22,10,22,9,21,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,13,12,23,11,23,10,22,9,21,8,20,7,19,6,18,5,17,4,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,15,14,13,24,12,23,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,12,11,10,9,8,7,6,5,4,25,24,23,22,21,20,19,18,17,16,15,14,24,13,23,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,13,12,11,10,9,8,7,6,5,4,25,24,23,22,21,20,19,18,17,16,15,24,14,23,13,22,12,21,11,20,10,19,9,18,8,17,7,16,6,15,14,13,12,11,10,9,8,7,6,5,25,24,23,22,21,20,19,18,17,16,24,15,23,14,22,13,21,12,20,11,19,10,18,9,17,8,16,15,14,13,12,11,10,9,8,7,25,24,23,22,21,20,19,18,17,24,23,22,21,20,19,18,17,16,23,22,21,20,19,18,17,16,15,22,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,16,15,14,13,12,11,16,15,14,13,12,11,10,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,16,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,7,6,16,15,14,13,12,11,10,9,8,7,6,5,16,15,14,13,12,11,10,9,8,7,6,5,4,15,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,17,16,15,14,13,12,17,11,17,10,17,9,17,8,17,7,17,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,18,11,18,10,18,9,18,8,18,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,11,19,10,19,9,19,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,21,11,21,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,22,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,13,12,23,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,15,14,13,12,23,11,22,10,21,9,20,8,19,7,18,6,17,5,16,4,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,15,14,13,23,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,15,14,23,13,22,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,13,12,11,10,9,8,7,6,5,4,24,23,22,21,20,19,18,17,16,15,23,14,22,13,21,12,20,11,19,10,18,9,17,8,16,7,15,14,13,12,11,10,9,8,7,6,24,23,22,21,20,19,18,17,16,23,22,21,20,19,18,17,16,15,22,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,17,16,15,14,13,12,11,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,17,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,8,7,17,16,15,14,13,12,11,10,9,8,7,6,16,15,14,13,12,11,10,9,8,7,6,5,15,14,13,12,11,10,9,8,7,6,5,4,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,18,17,16,15,14,13,12,18,11,18,10,18,9,18,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,11,19,10,19,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,21,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,13,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,13,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,13,12,22,11,21,10,20,9,19,8,18,7,17,6,16,5,15,4,14,4,13,4,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,13,22,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,12,11,10,9,8,7,6,5,4,23,22,21,20,19,18,17,16,15,14,22,13,21,12,20,11,19,10,18,9,17,8,16,7,15,6,14,13,12,11,10,9,8,7,6,5,23,22,21,20,19,18,17,16,15,22,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,18,17,16,15,14,13,12,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,18,17,16,15,14,13,12,11,10,9,18,17,16,15,14,13,12,11,10,9,8,17,16,15,14,13,12,11,10,9,8,7,16,15,14,13,12,11,10,9,8,7,6,15,14,13,12,11,10,9,8,7,6,5,14,13,12,11,10,9,8,7,6,5,4,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,19,11,19,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,12,21,11,20,10,19,9,18,8,17,7,16,6,15,5,14,4,13,4,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,13,21,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,12,11,10,9,8,7,6,5,4,22,21,20,19,18,17,16,15,14,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,19,18,17,16,15,14,13,12,11,10,18,17,16,15,14,13,12,11,10,9,17,16,15,14,13,12,11,10,9,8,16,15,14,13,12,11,10,9,8,7,15,14,13,12,11,10,9,8,7,6,14,13,12,11,10,9,8,7,6,5,13,12,11,10,9,8,7,6,5,4,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,12,20,11,19,10,18,9,17,8,16,7,15,6,14,5,13,4,12,11,10,9,8,7,6,5,4,21,20,19,18,17,16,15,14,13,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,11,18,10,17,9,16,8,15,7,14,6,13,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,11,18,10,17,9,16,8,15,7,14,6,13,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,11,18,10,17,9,16,8,15,7,14,6,13,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,11,18,10,17,9,16,8,15,7,14,6,13,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,11,18,10,17,9,16,8,15,7,14,6,13,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,11,18,10,17,9,16,8,15,7,14,6,13,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,11,18,10,17,9,16,8,15,7,14,6,13,5,12,11,10,9,8,7,6,5,4,20,19,18,17,16,15,14,13,12,19,18,17,16,15,14,13,12,11,18,17,16,15,14,13,12,11,10,17,16,15,14,13,12,11,10,9,16,15,14,13,12,11,10,9,8,15,14,13,12,11,10,9,8,7,14,13,12,11,10,9,8,7,6,13,12,11,10,9,8,7,6,5,12,11,10,9,8,7,6,5,4,19,18,17,16,15,14,13,12,18,17,16,15,14,13,12,11,17,16,15,14,13,12,11,10,16,15,14,13,12,11,10,9,15,14,13,12,11,10,9,8,14,13,12,11,10,9,8,7,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,19,18,17,16,15,14,13,12,18,11,17,10,16,9,15,8,14,7,13,6,12,11,10,9,8,7,6,5,19,18,17,16,15,14,13,12,18,11,17,10,16,9,15,8,14,7,13,6,12,11,10,9,8,7,6,5,19,18,17,16,15,14,13,12,18,11,17,10,16,9,15,8,14,7,13,6,12,11,10,9,8,7,6,5,19,18,17,16,15,14,13,12,18,11,17,10,16,9,15,8,14,7,13,6,12,11,10,9,8,7,6,5,19,18,17,16,15,14,13,12,18,11,17,10,16,9,15,8,14,7,13,6,12,11,10,9,8,7,6,5,19,18,17,16,15,14,13,12,18,11,17,10,16,9,15,8,14,7,13,6,12,11,10,9,8,7,6,5,19,18,17,16,15,14,13,12,18,17,16,15,14,13,12,11,17,16,15,14,13,12,11,10,16,15,14,13,12,11,10,9,15,14,13,12,11,10,9,8,14,13,12,11,10,9,8,7,13,12,11,10,9,8,7,6,12,11,10,9,8,7,6,5,18,17,16,15,14,13,12,17,16,15,14,13,12,11,16,15,14,13,12,11,10,15,14,13,12,11,10,9,14,13,12,11,10,9,8,13,12,11,10,9,8,7,12,11,10,9,8,7,6,18,17,16,15,14,13,12,17,11,16,10,15,9,14,8,13,7,12,11,10,9,8,7,6,18,17,16,15,14,13,12,17,11,16,10,15,9,14,8,13,7,12,11,10,9,8,7,6,18,17,16,15,14,13,12,17,11,16,10,15,9,14,8,13,7,12,11,10,9,8,7,6,18,17,16,15,14,13,12,17,11,16,10,15,9,14,8,13,7,12,11,10,9,8,7,6,18,17,16,15,14,13,12,17,11,16,10,15,9,14,8,13,7,12,11,10,9,8,7,6,18,17,16,15,14,13,12,17,16,15,14,13,12,11,16,15,14,13,12,11,10,15,14,13,12,11,10,9,14,13,12,11,10,9,8,13,12,11,10,9,8,7,12,11,10,9,8,7,6,17,16,15,14,13,12,16,15,14,13,12,11,15,14,13,12,11,10,14,13,12,11,10,9,13,12,11,10,9,8,12,11,10,9,8,7,17,16,15,14,13,12,16,11,15,10,14,9,13,8,12,11,10,9,8,7,17,16,15,14,13,12,16,11,15,10,14,9,13,8,12,11,10,9,8,7,17,16,15,14,13,12,16,11,15,10,14,9,13,8,12,11,10,9,8,7,17,16,15,14,13,12,16,11,15,10,14,9,13,8,12,11,10,9,8,7,17,16,15,14,13,12,16,15,14,13,12,11,15,14,13,12,11,10,14,13,12,11,10,9,13,12,11,10,9,8,12,11,10,9,8,7,16,15,14,13,12,15,14,13,12,11,14,13,12,11,10,13,12,11,10,9,12,11,10,9,8,16,15,14,13,12,15,11,14,10,13,9,12,11,10,9,8,16,15,14,13,12,15,11,14,10,13,9,12,11,10,9,8,16,15,14,13,12,15,11,14,10,13,9,12,11,10,9,8,16,15,14,13,12,15,14,13,12,11,14,13,12,11,10,13,12,11,10,9,12,11,10,9,8,15,14,13,12,14,13,12,11,13,12,11,10,12,11,10,9,15,14,13,12,14,11,13,10,12,11,10,9,15,14,13,12,14,11,13,10,12,11,10,9,15,14,13,12,14,13,12,11,13,12,11,10,12,11,10,9,14,13,12,13,12,11,12,11,10,14,13,12,13,11,12,11,10,14,13,12,13,12,11,12,11,10,13,12,12,11,13,12,12,11,12},{2,3,4,2,3,4,2,3,4,3,4,4,2,3,4,2,3,4,5,3,4,5,4,5,2,3,4,3,4,5,4,5,6,3,4,4,5,4,2,3,2,3,4,2,3,4,2,3,4,3,4,2,3,4,2,3,4,5,2,3,4,5,3,4,5,4,5,2,3,4,2,3,4,5,3,4,5,6,4,5,6,2,3,4,3,4,5,4,5,6,3,4,4,5,2,2,3,2,3,4,2,3,4,2,3,4,2,3,2,3,4,2,3,4,5,2,3,4,5,3,4,5,2,3,4,2,3,4,5,2,3,4,5,6,3,4,5,6,4,5,6,2,3,4,2,3,4,5,3,4,5,6,4,5,6,7,2,3,4,3,4,5,4,5,6,2,3,2,3,4,2,3,4,5,3,4,5,2,3,4,2,3,4,5,3,4,5,6,4,5,6,2,3,4,5,3,4,5,6,4,5,6,7,5,6,7,3,4,5,4,5,6,5,6,7,2,3,4,3,4,5,4,5,6,3,4,5,4,5,6,5,6,7,4,5,6,5,6,7,6,7,8,4,5,5,6,5,6,6,7,6,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,4,5,6,7,8,5,6,7,8,6,7,8,7,8,8,3,4,5,6,7,8,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,9,4,5,6,7,8,9,5,6,7,8,9,6,7,8,9,7,8,9,8,9,3,4,5,6,7,8,3,4,5,6,7,8,9,3,4,5,6,7,8,9,10,3,4,5,6,7,8,9,10,4,5,6,7,8,9,10,5,6,7,8,9,10,6,7,8,9,10,7,8,9,10,8,9,10,3,4,5,6,7,8,3,4,5,6,7,8,9,3,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,5,6,7,8,9,10,11,6,7,8,9,10,11,7,8,9,10,11,8,9,10,11,3,4,5,6,7,8,3,4,5,6,7,8,9,4,5,6,7,8,9,10,5,6,7,8,9,10,11,6,7,8,9,10,11,12,7,8,9,10,11,12,8,9,10,11,12,3,4,5,6,7,8,4,5,6,7,8,9,5,6,7,8,9,10,6,7,8,9,10,11,7,8,9,10,11,12,8,9,10,11,12,13,4,5,6,7,8,5,6,7,8,9,6,7,8,9,10,7,8,9,10,11,8,9,10,11,12,5,6,7,8,6,7,8,9,7,8,9,10,8,9,10,11,6,7,8,7,8,9,8,9,10,7,8,8,9,8,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,4,5,6,7,8,5,6,7,8,6,7,8,7,8,3,4,5,6,7,8,3,9,3,9,3,9,3,9,3,9,4,9,5,9,6,9,7,9,8,9,3,4,5,6,7,8,3,9,3,10,3,10,3,10,4,10,5,10,6,10,7,10,8,9,10,3,4,5,6,7,8,3,9,3,10,3,11,4,11,5,11,6,11,7,11,8,9,10,11,3,4,5,6,7,8,3,9,3,10,4,11,5,12,6,12,7,12,8,9,10,11,12,3,4,5,6,7,8,3,9,4,10,5,11,6,12,7,13,8,9,10,11,12,13,3,4,5,6,7,8,4,9,5,10,6,11,7,12,8,9,10,11,12,13,4,5,6,7,8,5,9,6,10,7,11,8,9,10,11,12,5,6,7,8,6,9,7,10,8,9,10,11,6,7,8,7,9,8,9,10,7,8,8,9,3,4,5,6,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,4,5,6,7,8,5,6,7,8,6,7,8,3,4,5,6,7,3,8,3,9,3,9,3,9,3,9,3,9,4,9,5,9,6,9,7,8,9,3,4,5,6,7,8,3,9,3,10,3,10,3,10,3,10,4,10,5,10,6,10,7,10,8,9,10,3,4,5,6,7,8,3,9,3,10,3,11,3,11,4,11,5,11,6,11,7,11,8,9,10,11,3,4,5,6,7,8,3,9,3,10,3,11,4,12,5,12,6,12,7,12,8,9,10,11,12,3,4,5,6,7,8,3,9,3,10,4,11,5,12,6,13,7,13,8,9,10,11,12,13,3,4,5,6,7,8,3,9,4,10,5,11,6,12,7,13,8,9,10,11,12,13,14,3,4,5,6,7,8,4,9,5,10,6,11,7,12,8,9,10,11,12,13,4,5,6,7,8,5,9,6,10,7,11,8,9,10,11,12,5,6,7,8,6,9,7,10,8,9,10,11,6,7,8,7,8,9,8,9,10,3,4,5,3,4,5,6,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,4,5,6,7,8,5,6,7,8,3,4,5,6,3,7,3,8,3,9,3,9,3,9,3,9,3,9,4,9,5,9,6,7,8,9,3,4,5,6,7,3,8,3,9,3,10,3,10,3,10,3,10,4,10,5,10,6,10,7,8,9,10,3,4,5,6,7,8,3,9,3,10,3,11,3,11,3,11,4,11,5,11,6,11,7,11,8,9,10,11,3,4,5,6,7,8,3,9,3,10,3,11,3,12,4,12,5,12,6,12,7,12,8,9,10,11,12,3,4,5,6,7,8,3,9,3,10,3,11,4,12,5,13,6,13,7,13,8,9,10,11,12,13,3,4,5,6,7,8,3,9,3,10,4,11,5,12,6,13,7,14,8,9,10,11,12,13,14,3,4,5,6,7,8,3,9,4,10,5,11,6,12,7,13,8,9,10,11,12,13,14,3,4,5,6,7,8,4,9,5,10,6,11,7,12,8,9,10,11,12,13,4,5,6,7,8,5,9,6,10,7,11,8,9,10,11,12,5,6,7,8,6,7,8,9,7,8,9,10,8,9,10,11,3,4,3,4,5,3,4,5,6,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,4,5,6,7,8,3,4,5,3,6,3,7,3,8,3,9,3,9,3,9,3,9,3,9,4,9,5,6,7,8,9,3,4,5,6,3,7,3,8,3,9,3,10,3,10,3,10,3,10,4,10,5,10,6,7,8,9,10,3,4,5,6,7,3,8,3,9,3,10,3,11,3,11,3,11,4,11,5,11,6,11,7,8,9,10,11,3,4,5,6,7,8,3,9,3,10,3,11,3,12,3,12,4,12,5,12,6,12,7,12,8,9,10,11,12,3,4,5,6,7,8,3,9,3,10,3,11,3,12,4,13,5,13,6,13,7,13,8,9,10,11,12,13,3,4,5,6,7,8,3,9,3,10,3,11,4,12,5,13,6,14,7,14,8,9,10,11,12,13,14,3,4,5,6,7,8,3,9,3,10,4,11,5,12,6,13,7,14,8,9,10,11,12,13,14,15,3,4,5,6,7,8,3,9,4,10,5,11,6,12,7,13,8,9,10,11,12,13,14,3,4,5,6,7,8,4,9,5,10,6,11,7,12,8,9,10,11,12,13,4,5,6,7,8,5,6,7,8,9,6,7,8,9,10,7,8,9,10,11,8,9,10,11,12,3,3,4,3,4,5,3,4,5,6,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,5,6,7,8,3,4,3,5,3,6,3,7,3,8,3,9,3,9,3,9,3,9,3,9,4,5,6,7,8,9,3,4,5,3,6,3,7,3,8,3,9,3,10,3,10,3,10,3,10,4,10,5,6,7,8,9,10,3,4,5,6,3,7,3,8,3,9,3,10,3,11,3,11,3,11,4,11,5,11,6,7,8,9,10,11,3,4,5,6,7,3,8,3,9,3,10,3,11,3,12,3,12,4,12,5,12,6,12,7,8,9,10,11,12,3,4,5,6,7,8,3,9,3,10,3,11,3,12,3,13,4,13,5,13,6,13,7,13,8,9,10,11,12,13,3,4,5,6,7,8,3,9,3,10,3,11,3,12,4,13,5,14,6,14,7,14,8,9,10,11,12,13,14,3,4,5,6,7,8,3,9,3,10,3,11,4,12,5,13,6,14,7,15,8,9,10,11,12,13,14,15,3,4,5,6,7,8,3,9,3,10,4,11,5,12,6,13,7,14,8,9,10,11,12,13,14,15,3,4,5,6,7,8,3,9,4,10,5,11,6,12,7,13,8,9,10,11,12,13,14,3,4,5,6,7,8,4,5,6,7,8,9,5,6,7,8,9,10,6,7,8,9,10,11,7,8,9,10,11,12,8,9,10,11,12,13,3,4,3,4,5,3,4,5,6,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,9,4,5,6,7,8,9,3,4,5,3,6,3,7,3,8,3,9,3,10,3,10,3,10,4,10,5,6,7,8,9,10,3,4,5,6,3,7,3,8,3,9,3,10,3,11,3,11,4,11,5,11,6,7,8,9,10,11,3,4,5,6,7,3,8,3,9,3,10,3,11,3,12,4,12,5,12,6,12,7,8,9,10,11,12,3,4,5,6,7,8,3,9,3,10,3,11,3,12,4,13,5,13,6,13,7,13,8,9,10,11,12,13,3,4,5,6,7,8,9,3,10,3,11,3,12,4,13,5,14,6,14,7,14,8,14,9,10,11,12,13,14,3,4,5,6,7,8,9,3,10,3,11,4,12,5,13,6,14,7,15,8,15,9,10,11,12,13,14,15,3,4,5,6,7,8,9,3,10,4,11,5,12,6,13,7,14,8,15,9,10,11,12,13,14,15,16,3,4,5,6,7,8,9,4,10,5,11,6,12,7,13,8,14,9,10,11,12,13,14,15,4,5,6,7,8,9,5,6,7,8,9,10,6,7,8,9,10,11,7,8,9,10,11,12,8,9,10,11,12,13,9,10,11,12,13,14,3,4,5,3,4,5,6,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,9,3,4,5,6,7,8,9,10,3,4,5,6,7,8,9,10,4,5,6,7,8,9,10,5,6,7,8,9,10,3,4,5,6,3,7,3,8,3,9,3,10,3,11,4,11,5,11,6,7,8,9,10,11,3,4,5,6,7,3,8,3,9,3,10,3,11,4,12,5,12,6,12,7,8,9,10,11,12,3,4,5,6,7,8,3,9,3,10,3,11,4,12,5,13,6,13,7,13,8,9,10,11,12,13,3,4,5,6,7,8,9,3,10,3,11,4,12,5,13,6,14,7,14,8,14,9,10,11,12,13,14,3,4,5,6,7,8,9,10,3,11,4,12,5,13,6,14,7,15,8,15,9,15,10,11,12,13,14,15,3,4,5,6,7,8,9,10,4,11,5,12,6,13,7,14,8,15,9,16,10,11,12,13,14,15,16,4,5,6,7,8,9,10,5,11,6,12,7,13,8,14,9,15,10,11,12,13,14,15,16,5,6,7,8,9,10,6,7,8,9,10,11,7,8,9,10,11,12,8,9,10,11,12,13,9,10,11,12,13,14,10,11,12,13,14,15,3,4,5,6,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,9,3,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,5,6,7,8,9,10,11,6,7,8,9,10,11,3,4,5,6,7,3,8,3,9,3,10,4,11,5,12,6,12,7,8,9,10,11,12,3,4,5,6,7,8,3,9,3,10,4,11,5,12,6,13,7,13,8,9,10,11,12,13,3,4,5,6,7,8,9,3,10,4,11,5,12,6,13,7,14,8,14,9,10,11,12,13,14,3,4,5,6,7,8,9,10,4,11,5,12,6,13,7,14,8,15,9,15,10,11,12,13,14,15,4,5,6,7,8,9,10,11,5,12,6,13,7,14,8,15,9,16,10,16,11,12,13,14,15,16,5,6,7,8,9,10,11,6,12,7,13,8,14,9,15,10,16,11,12,13,14,15,16,17,6,7,8,9,10,11,7,8,9,10,11,12,8,9,10,11,12,13,9,10,11,12,13,14,10,11,12,13,14,15,11,12,13,14,15,16,3,4,5,6,7,3,4,5,6,7,8,3,4,5,6,7,8,9,4,5,6,7,8,9,10,5,6,7,8,9,10,11,6,7,8,9,10,11,12,7,8,9,10,11,12,3,4,5,6,7,8,3,9,4,10,5,11,6,12,7,13,8,9,10,11,12,13,3,4,5,6,7,8,9,4,10,5,11,6,12,7,13,8,14,9,10,11,12,13,14,4,5,6,7,8,9,10,5,11,6,12,7,13,8,14,9,15,10,11,12,13,14,15,5,6,7,8,9,10,11,6,12,7,13,8,14,9,15,10,16,11,12,13,14,15,16,6,7,8,9,10,11,12,7,13,8,14,9,15,10,16,11,17,12,13,14,15,16,17,7,8,9,10,11,12,8,9,10,11,12,13,9,10,11,12,13,14,10,11,12,13,14,15,11,12,13,14,15,16,12,13,14,15,16,17,3,4,5,6,7,8,4,5,6,7,8,9,5,6,7,8,9,10,6,7,8,9,10,11,7,8,9,10,11,12,8,9,10,11,12,13,4,5,6,7,8,9,5,10,6,11,7,12,8,13,9,10,11,12,13,14,5,6,7,8,9,10,6,11,7,12,8,13,9,14,10,11,12,13,14,15,6,7,8,9,10,11,7,12,8,13,9,14,10,15,11,12,13,14,15,16,7,8,9,10,11,12,8,13,9,14,10,15,11,16,12,13,14,15,16,17,8,9,10,11,12,13,9,10,11,12,13,14,10,11,12,13,14,15,11,12,13,14,15,16,12,13,14,15,16,17,13,14,15,16,17,18,5,6,7,8,9,6,7,8,9,10,7,8,9,10,11,8,9,10,11,12,9,10,11,12,13,6,7,8,9,10,7,11,8,12,9,13,10,11,12,13,14,7,8,9,10,11,8,12,9,13,10,14,11,12,13,14,15,8,9,10,11,12,9,13,10,14,11,15,12,13,14,15,16,9,10,11,12,13,10,11,12,13,14,11,12,13,14,15,12,13,14,15,16,13,14,15,16,17,7,8,9,10,8,9,10,11,9,10,11,12,10,11,12,13,8,9,10,11,9,12,10,13,11,12,13,14,9,10,11,12,10,13,11,14,12,13,14,15,10,11,12,13,11,12,13,14,12,13,14,15,13,14,15,16,9,10,11,10,11,12,11,12,13,10,11,12,11,13,12,13,14,11,12,13,12,13,14,13,14,15,11,12,12,13,12,13,13,14,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,7,8,9,10,11,12,8,9,10,11,12,9,10,11,12,10,11,12,11,12,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,5,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,13,7,8,9,10,11,12,13,8,9,10,11,12,13,9,10,11,12,13,10,11,12,13,11,12,13,12,13,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,14,6,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,8,9,10,11,12,13,14,9,10,11,12,13,14,10,11,12,13,14,11,12,13,14,12,13,14,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,5,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,15,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,9,10,11,12,13,14,15,10,11,12,13,14,15,11,12,13,14,15,12,13,14,15,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,16,5,6,7,8,9,10,11,12,13,14,15,16,6,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,10,11,12,13,14,15,16,11,12,13,14,15,16,12,13,14,15,16,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,15,5,6,7,8,9,10,11,12,13,14,15,16,6,7,8,9,10,11,12,13,14,15,16,17,7,8,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,11,12,13,14,15,16,17,12,13,14,15,16,17,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,5,6,7,8,9,10,11,12,13,14,6,7,8,9,10,11,12,13,14,15,7,8,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,18,19,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,13,7,8,9,10,11,12,13,14,8,9,10,11,12,13,14,15,9,10,11,12,13,14,15,16,10,11,12,13,14,15,16,17,11,12,13,14,15,16,17,18,12,13,14,15,16,17,18,19,6,7,8,9,10,11,12,7,8,9,10,11,12,13,8,9,10,11,12,13,14,9,10,11,12,13,14,15,10,11,12,13,14,15,16,11,12,13,14,15,16,17,12,13,14,15,16,17,18,7,8,9,10,11,12,8,9,10,11,12,13,9,10,11,12,13,14,10,11,12,13,14,15,11,12,13,14,15,16,12,13,14,15,16,17,8,9,10,11,12,9,10,11,12,13,10,11,12,13,14,11,12,13,14,15,12,13,14,15,16,9,10,11,12,10,11,12,13,11,12,13,14,12,13,14,15,10,11,12,11,12,13,12,13,14,11,12,12,13,12,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,7,8,9,10,11,12,8,9,10,11,12,9,10,11,12,10,11,12,11,12,4,5,6,7,8,9,10,11,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,13,6,13,7,13,8,13,9,13,10,13,11,13,12,13,4,5,6,7,8,9,10,11,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,7,14,8,14,9,14,10,14,11,14,12,13,14,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,15,9,15,10,15,11,15,12,13,14,15,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,16,5,16,6,16,7,16,8,16,9,16,10,16,11,16,12,13,14,15,16,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,17,7,17,8,17,9,17,10,17,11,17,12,13,14,15,16,17,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,18,9,18,10,18,11,18,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,19,11,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,13,7,14,8,15,9,16,10,17,11,18,12,13,14,15,16,17,18,19,6,7,8,9,10,11,12,7,13,8,14,9,15,10,16,11,17,12,13,14,15,16,17,18,7,8,9,10,11,12,8,13,9,14,10,15,11,16,12,13,14,15,16,17,8,9,10,11,12,9,13,10,14,11,15,12,13,14,15,16,9,10,11,12,10,13,11,14,12,13,14,15,10,11,12,11,13,12,13,14,11,12,12,13,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,7,8,9,10,11,12,8,9,10,11,12,9,10,11,12,10,11,12,4,5,6,7,8,9,10,11,4,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,13,6,13,7,13,8,13,9,13,10,13,11,12,13,4,5,6,7,8,9,10,11,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,7,14,8,14,9,14,10,14,11,14,12,13,14,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,15,9,15,10,15,11,15,12,13,14,15,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,16,10,16,11,16,12,13,14,15,16,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,17,6,17,7,17,8,17,9,17,10,17,11,17,12,13,14,15,16,17,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,18,8,18,9,18,10,18,11,18,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,19,10,19,11,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,13,7,14,8,15,9,16,10,17,11,18,12,13,14,15,16,17,18,19,6,7,8,9,10,11,12,7,13,8,14,9,15,10,16,11,17,12,13,14,15,16,17,18,7,8,9,10,11,12,8,13,9,14,10,15,11,16,12,13,14,15,16,17,8,9,10,11,12,9,13,10,14,11,15,12,13,14,15,16,9,10,11,12,10,13,11,14,12,13,14,15,10,11,12,11,12,13,12,13,14,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,7,8,9,10,11,12,8,9,10,11,12,9,10,11,12,4,5,6,7,8,9,10,4,11,4,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,13,6,13,7,13,8,13,9,13,10,11,12,13,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,7,14,8,14,9,14,10,14,11,12,13,14,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,15,9,15,10,15,11,15,12,13,14,15,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,16,10,16,11,16,12,13,14,15,16,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,17,5,17,6,17,7,17,8,17,9,17,10,17,11,17,12,13,14,15,16,17,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,18,6,18,7,18,8,18,9,18,10,18,11,18,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,19,9,19,10,19,11,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,13,7,14,8,15,9,16,10,17,11,18,12,13,14,15,16,17,18,19,6,7,8,9,10,11,12,7,13,8,14,9,15,10,16,11,17,12,13,14,15,16,17,18,7,8,9,10,11,12,8,13,9,14,10,15,11,16,12,13,14,15,16,17,8,9,10,11,12,9,13,10,14,11,15,12,13,14,15,16,9,10,11,12,10,11,12,13,11,12,13,14,12,13,14,15,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,7,8,9,10,11,12,8,9,10,11,12,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,13,6,13,7,13,8,13,9,10,11,12,13,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,7,14,8,14,9,14,10,11,12,13,14,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,15,9,15,10,15,11,12,13,14,15,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,16,10,16,11,16,12,13,14,15,16,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,17,10,17,11,17,12,13,14,15,16,17,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,5,18,6,18,7,18,8,18,9,18,10,18,11,18,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,19,8,19,9,19,10,19,11,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,21,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,13,7,14,8,15,9,16,10,17,11,18,12,13,14,15,16,17,18,19,6,7,8,9,10,11,12,7,13,8,14,9,15,10,16,11,17,12,13,14,15,16,17,18,7,8,9,10,11,12,8,13,9,14,10,15,11,16,12,13,14,15,16,17,8,9,10,11,12,9,10,11,12,13,10,11,12,13,14,11,12,13,14,15,12,13,14,15,16,4,5,6,7,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,7,8,9,10,11,12,4,5,6,7,8,4,9,4,10,4,11,4,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,13,6,13,7,13,8,9,10,11,12,13,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,7,14,8,14,9,10,11,12,13,14,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,15,9,15,10,11,12,13,14,15,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,16,10,16,11,12,13,14,15,16,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,17,10,17,11,17,12,13,14,15,16,17,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,18,5,18,6,18,7,18,8,18,9,18,10,18,11,18,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,19,7,19,8,19,9,19,10,19,11,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,21,11,21,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,13,7,14,8,15,9,16,10,17,11,18,12,13,14,15,16,17,18,19,6,7,8,9,10,11,12,7,13,8,14,9,15,10,16,11,17,12,13,14,15,16,17,18,7,8,9,10,11,12,8,9,10,11,12,13,9,10,11,12,13,14,10,11,12,13,14,15,11,12,13,14,15,16,12,13,14,15,16,17,4,5,6,4,5,6,7,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,4,5,6,7,4,8,4,9,4,10,4,11,4,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,13,6,13,7,8,9,10,11,12,13,4,5,6,7,8,4,9,4,10,4,11,4,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,7,14,8,9,10,11,12,13,14,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,15,9,10,11,12,13,14,15,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,16,10,11,12,13,14,15,16,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,17,10,17,11,12,13,14,15,16,17,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,18,4,18,5,18,6,18,7,18,8,18,9,18,10,18,11,18,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,5,19,6,19,7,19,8,19,9,19,10,19,11,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,20,7,20,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,21,9,21,10,21,11,21,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,22,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,13,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,13,7,14,8,15,9,16,10,17,11,18,12,13,14,15,16,17,18,19,6,7,8,9,10,11,12,7,8,9,10,11,12,13,8,9,10,11,12,13,14,9,10,11,12,13,14,15,10,11,12,13,14,15,16,11,12,13,14,15,16,17,12,13,14,15,16,17,18,4,5,4,5,6,4,5,6,7,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,4,5,6,4,7,4,8,4,9,4,10,4,11,4,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,13,6,7,8,9,10,11,12,13,4,5,6,7,4,8,4,9,4,10,4,11,4,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,14,7,8,9,10,11,12,13,14,4,5,6,7,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,15,8,9,10,11,12,13,14,15,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,16,9,10,11,12,13,14,15,16,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,17,10,11,12,13,14,15,16,17,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,4,17,4,18,4,18,4,18,5,18,6,18,7,18,8,18,9,18,10,18,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,19,5,19,6,19,7,19,8,19,9,19,10,19,11,19,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,5,20,6,20,7,20,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,20,7,21,8,21,9,21,10,21,11,21,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,21,9,22,10,22,11,22,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,23,12,13,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,13,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,5,13,6,14,7,15,8,16,9,17,10,18,11,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,6,7,8,9,10,11,12,13,7,8,9,10,11,12,13,14,8,9,10,11,12,13,14,15,9,10,11,12,13,14,15,16,10,11,12,13,14,15,16,17,11,12,13,14,15,16,17,18,12,13,14,15,16,17,18,19,4,4,5,4,5,6,4,5,6,7,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,4,5,4,6,4,7,4,8,4,9,4,10,4,11,4,12,4,13,4,13,4,13,4,13,4,13,4,13,4,13,4,13,5,6,7,8,9,10,11,12,13,4,5,6,4,7,4,8,4,9,4,10,4,11,4,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,7,8,9,10,11,12,13,14,4,5,6,7,4,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,8,9,10,11,12,13,14,15,4,5,6,7,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,10,11,12,13,14,15,16,17,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,4,18,4,18,4,18,5,18,6,18,7,18,8,18,9,18,10,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,19,5,19,6,19,7,19,8,19,9,19,10,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,4,20,5,20,6,20,7,20,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,5,20,6,21,7,21,8,21,9,21,10,21,11,21,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,20,7,21,8,22,9,22,10,22,11,22,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,21,9,22,10,23,11,23,12,13,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,23,12,13,14,15,16,17,18,19,20,21,22,23,24,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,13,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,4,5,4,5,6,4,5,6,7,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,5,6,7,8,9,10,11,12,13,4,5,6,4,7,4,8,4,9,4,10,4,11,4,12,4,13,4,14,4,14,4,14,4,14,4,14,4,14,5,14,6,7,8,9,10,11,12,13,14,4,5,6,7,4,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,15,4,15,4,15,4,15,5,15,6,15,7,8,9,10,11,12,13,14,15,4,5,6,7,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,16,4,16,4,16,5,16,6,16,7,16,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,4,17,4,17,5,17,6,17,7,17,8,17,9,10,11,12,13,14,15,16,17,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,4,18,4,18,5,18,6,18,7,18,8,18,9,18,10,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,5,19,6,19,7,19,8,19,9,19,10,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,4,19,5,20,6,20,7,20,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,13,4,14,4,15,4,16,4,17,4,18,4,19,5,20,6,21,7,21,8,21,9,21,10,21,11,21,12,21,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,13,4,14,4,15,4,16,4,17,4,18,5,19,6,20,7,21,8,22,9,22,10,22,11,22,12,22,13,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,21,9,22,10,23,11,23,12,23,13,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,23,12,24,13,14,15,16,17,18,19,20,21,22,23,24,4,5,6,7,8,9,10,11,12,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,23,13,14,15,16,17,18,19,20,21,22,23,24,4,5,6,7,8,9,10,11,12,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,22,13,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,21,13,14,15,16,17,18,19,20,21,22,5,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,4,5,6,4,5,6,7,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,14,6,7,8,9,10,11,12,13,14,4,5,6,7,4,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,15,4,15,4,15,5,15,6,15,7,8,9,10,11,12,13,14,15,4,5,6,7,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,16,4,16,5,16,6,16,7,16,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,4,17,5,17,6,17,7,17,8,17,9,10,11,12,13,14,15,16,17,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,4,18,5,18,6,18,7,18,8,18,9,18,10,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,19,7,19,8,19,9,19,10,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,4,18,5,19,6,20,7,20,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,13,4,14,4,15,4,16,4,17,4,18,5,19,6,20,7,21,8,21,9,21,10,21,11,21,12,21,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,13,14,4,15,4,16,4,17,4,18,5,19,6,20,7,21,8,22,9,22,10,22,11,22,12,22,13,22,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,13,14,4,15,4,16,4,17,5,18,6,19,7,20,8,21,9,22,10,23,11,23,12,23,13,23,14,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,13,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,23,12,24,13,24,14,15,16,17,18,19,20,21,22,23,24,4,5,6,7,8,9,10,11,12,13,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,23,13,24,14,15,16,17,18,19,20,21,22,23,24,25,4,5,6,7,8,9,10,11,12,13,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,22,13,23,14,15,16,17,18,19,20,21,22,23,24,5,6,7,8,9,10,11,12,13,14,6,15,7,16,8,17,9,18,10,19,11,20,12,21,13,22,14,15,16,17,18,19,20,21,22,23,6,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,22,4,5,6,7,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,5,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,15,7,8,9,10,11,12,13,14,15,4,5,6,7,8,4,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,16,5,16,6,16,7,16,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,5,17,6,17,7,17,8,17,9,10,11,12,13,14,15,16,17,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,16,4,17,5,18,6,18,7,18,8,18,9,18,10,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,19,8,19,9,19,10,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,13,4,14,4,15,4,16,4,17,5,18,6,19,7,20,8,21,9,21,10,21,11,21,12,21,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,13,14,4,15,4,16,4,17,5,18,6,19,7,20,8,21,9,22,10,22,11,22,12,22,13,22,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,13,14,15,4,16,4,17,5,18,6,19,7,20,8,21,9,22,10,23,11,23,12,23,13,23,14,23,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,13,14,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,23,12,24,13,24,14,24,15,16,17,18,19,20,21,22,23,24,4,5,6,7,8,9,10,11,12,13,14,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,23,13,24,14,25,15,16,17,18,19,20,21,22,23,24,25,5,6,7,8,9,10,11,12,13,14,15,6,16,7,17,8,18,9,19,10,20,11,21,12,22,13,23,14,24,15,16,17,18,19,20,21,22,23,24,25,6,7,8,9,10,11,12,13,14,15,7,16,8,17,9,18,10,19,11,20,12,21,13,22,14,23,15,16,17,18,19,20,21,22,23,24,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,22,15,16,17,18,19,20,21,22,23,4,5,6,7,8,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,15,4,5,6,7,8,9,10,11,12,13,14,15,16,5,6,7,8,9,10,11,12,13,14,15,16,6,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,16,4,5,6,7,8,9,4,10,4,11,4,12,4,13,4,14,4,15,4,16,5,17,6,17,7,17,8,17,9,10,11,12,13,14,15,16,17,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,4,16,5,17,6,18,7,18,8,18,9,18,10,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,19,9,19,10,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,13,4,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,21,11,21,12,21,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,13,14,4,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,22,12,22,13,22,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,13,14,15,4,16,5,17,6,18,7,19,8,20,9,21,10,22,11,23,12,23,13,23,14,23,15,16,17,18,19,20,21,22,23,4,5,6,7,8,9,10,11,12,13,14,15,16,5,17,6,18,7,19,8,20,9,21,10,22,11,23,12,24,13,24,14,24,15,24,16,17,18,19,20,21,22,23,24,5,6,7,8,9,10,11,12,13,14,15,16,6,17,7,18,8,19,9,20,10,21,11,22,12,23,13,24,14,25,15,25,16,17,18,19,20,21,22,23,24,25,6,7,8,9,10,11,12,13,14,15,16,7,17,8,18,9,19,10,20,11,21,12,22,13,23,14,24,15,25,16,17,18,19,20,21,22,23,24,25,26,7,8,9,10,11,12,13,14,15,16,8,17,9,18,10,19,11,20,12,21,13,22,14,23,15,24,16,17,18,19,20,21,22,23,24,25,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,22,15,16,17,18,19,20,21,22,23,16,17,18,19,20,21,22,23,24,4,5,6,7,8,9,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,4,5,6,7,8,9,10,11,12,13,14,15,5,6,7,8,9,10,11,12,13,14,15,16,6,7,8,9,10,11,12,13,14,15,16,17,7,8,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,17,4,5,6,7,8,9,10,4,11,4,12,4,13,4,14,4,15,5,16,6,17,7,18,8,18,9,18,10,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,4,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,19,10,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,13,4,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,21,12,21,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,13,14,4,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,22,13,22,14,15,16,17,18,19,20,21,22,4,5,6,7,8,9,10,11,12,13,14,15,5,16,6,17,7,18,8,19,9,20,10,21,11,22,12,23,13,23,14,23,15,16,17,18,19,20,21,22,23,5,6,7,8,9,10,11,12,13,14,15,16,6,17,7,18,8,19,9,20,10,21,11,22,12,23,13,24,14,24,15,24,16,17,18,19,20,21,22,23,24,6,7,8,9,10,11,12,13,14,15,16,17,7,18,8,19,9,20,10,21,11,22,12,23,13,24,14,25,15,25,16,25,17,18,19,20,21,22,23,24,25,7,8,9,10,11,12,13,14,15,16,17,8,18,9,19,10,20,11,21,12,22,13,23,14,24,15,25,16,26,17,18,19,20,21,22,23,24,25,26,8,9,10,11,12,13,14,15,16,17,9,18,10,19,11,20,12,21,13,22,14,23,15,24,16,25,17,18,19,20,21,22,23,24,25,26,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,22,15,16,17,18,19,20,21,22,23,16,17,18,19,20,21,22,23,24,17,18,19,20,21,22,23,24,25,4,5,6,7,8,9,10,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,14,5,6,7,8,9,10,11,12,13,14,15,6,7,8,9,10,11,12,13,14,15,16,7,8,9,10,11,12,13,14,15,16,17,8,9,10,11,12,13,14,15,16,17,18,9,10,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,18,4,5,6,7,8,9,10,11,4,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,13,4,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,21,13,14,15,16,17,18,19,20,21,4,5,6,7,8,9,10,11,12,13,14,5,15,6,16,7,17,8,18,9,19,10,20,11,21,12,22,13,22,14,15,16,17,18,19,20,21,22,5,6,7,8,9,10,11,12,13,14,15,6,16,7,17,8,18,9,19,10,20,11,21,12,22,13,23,14,23,15,16,17,18,19,20,21,22,23,6,7,8,9,10,11,12,13,14,15,16,7,17,8,18,9,19,10,20,11,21,12,22,13,23,14,24,15,24,16,17,18,19,20,21,22,23,24,7,8,9,10,11,12,13,14,15,16,17,8,18,9,19,10,20,11,21,12,22,13,23,14,24,15,25,16,25,17,18,19,20,21,22,23,24,25,8,9,10,11,12,13,14,15,16,17,18,9,19,10,20,11,21,12,22,13,23,14,24,15,25,16,26,17,26,18,19,20,21,22,23,24,25,26,9,10,11,12,13,14,15,16,17,18,10,19,11,20,12,21,13,22,14,23,15,24,16,25,17,26,18,19,20,21,22,23,24,25,26,27,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,22,15,16,17,18,19,20,21,22,23,16,17,18,19,20,21,22,23,24,17,18,19,20,21,22,23,24,25,18,19,20,21,22,23,24,25,26,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,12,4,5,6,7,8,9,10,11,12,13,5,6,7,8,9,10,11,12,13,14,6,7,8,9,10,11,12,13,14,15,7,8,9,10,11,12,13,14,15,16,8,9,10,11,12,13,14,15,16,17,9,10,11,12,13,14,15,16,17,18,10,11,12,13,14,15,16,17,18,19,11,12,13,14,15,16,17,18,19,4,5,6,7,8,9,10,11,12,4,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,13,14,15,16,17,18,19,20,4,5,6,7,8,9,10,11,12,13,5,14,6,15,7,16,8,17,9,18,10,19,11,20,12,21,13,14,15,16,17,18,19,20,21,5,6,7,8,9,10,11,12,13,14,6,15,7,16,8,17,9,18,10,19,11,20,12,21,13,22,14,15,16,17,18,19,20,21,22,6,7,8,9,10,11,12,13,14,15,7,16,8,17,9,18,10,19,11,20,12,21,13,22,14,23,15,16,17,18,19,20,21,22,23,7,8,9,10,11,12,13,14,15,16,8,17,9,18,10,19,11,20,12,21,13,22,14,23,15,24,16,17,18,19,20,21,22,23,24,8,9,10,11,12,13,14,15,16,17,9,18,10,19,11,20,12,21,13,22,14,23,15,24,16,25,17,18,19,20,21,22,23,24,25,9,10,11,12,13,14,15,16,17,18,10,19,11,20,12,21,13,22,14,23,15,24,16,25,17,26,18,19,20,21,22,23,24,25,26,10,11,12,13,14,15,16,17,18,19,11,20,12,21,13,22,14,23,15,24,16,25,17,26,18,27,19,20,21,22,23,24,25,26,27,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,22,15,16,17,18,19,20,21,22,23,16,17,18,19,20,21,22,23,24,17,18,19,20,21,22,23,24,25,18,19,20,21,22,23,24,25,26,19,20,21,22,23,24,25,26,27,4,5,6,7,8,9,10,11,12,5,6,7,8,9,10,11,12,13,6,7,8,9,10,11,12,13,14,7,8,9,10,11,12,13,14,15,8,9,10,11,12,13,14,15,16,9,10,11,12,13,14,15,16,17,10,11,12,13,14,15,16,17,18,11,12,13,14,15,16,17,18,19,12,13,14,15,16,17,18,19,20,5,6,7,8,9,10,11,12,13,6,14,7,15,8,16,9,17,10,18,11,19,12,20,13,14,15,16,17,18,19,20,21,6,7,8,9,10,11,12,13,14,7,15,8,16,9,17,10,18,11,19,12,20,13,21,14,15,16,17,18,19,20,21,22,7,8,9,10,11,12,13,14,15,8,16,9,17,10,18,11,19,12,20,13,21,14,22,15,16,17,18,19,20,21,22,23,8,9,10,11,12,13,14,15,16,9,17,10,18,11,19,12,20,13,21,14,22,15,23,16,17,18,19,20,21,22,23,24,9,10,11,12,13,14,15,16,17,10,18,11,19,12,20,13,21,14,22,15,23,16,24,17,18,19,20,21,22,23,24,25,10,11,12,13,14,15,16,17,18,11,19,12,20,13,21,14,22,15,23,16,24,17,25,18,19,20,21,22,23,24,25,26,11,12,13,14,15,16,17,18,19,12,20,13,21,14,22,15,23,16,24,17,25,18,26,19,20,21,22,23,24,25,26,27,12,13,14,15,16,17,18,19,20,13,14,15,16,17,18,19,20,21,14,15,16,17,18,19,20,21,22,15,16,17,18,19,20,21,22,23,16,17,18,19,20,21,22,23,24,17,18,19,20,21,22,23,24,25,18,19,20,21,22,23,24,25,26,19,20,21,22,23,24,25,26,27,20,21,22,23,24,25,26,27,28,6,7,8,9,10,11,12,13,7,8,9,10,11,12,13,14,8,9,10,11,12,13,14,15,9,10,11,12,13,14,15,16,10,11,12,13,14,15,16,17,11,12,13,14,15,16,17,18,12,13,14,15,16,17,18,19,13,14,15,16,17,18,19,20,7,8,9,10,11,12,13,14,8,15,9,16,10,17,11,18,12,19,13,20,14,15,16,17,18,19,20,21,8,9,10,11,12,13,14,15,9,16,10,17,11,18,12,19,13,20,14,21,15,16,17,18,19,20,21,22,9,10,11,12,13,14,15,16,10,17,11,18,12,19,13,20,14,21,15,22,16,17,18,19,20,21,22,23,10,11,12,13,14,15,16,17,11,18,12,19,13,20,14,21,15,22,16,23,17,18,19,20,21,22,23,24,11,12,13,14,15,16,17,18,12,19,13,20,14,21,15,22,16,23,17,24,18,19,20,21,22,23,24,25,12,13,14,15,16,17,18,19,13,20,14,21,15,22,16,23,17,24,18,25,19,20,21,22,23,24,25,26,13,14,15,16,17,18,19,20,14,15,16,17,18,19,20,21,15,16,17,18,19,20,21,22,16,17,18,19,20,21,22,23,17,18,19,20,21,22,23,24,18,19,20,21,22,23,24,25,19,20,21,22,23,24,25,26,20,21,22,23,24,25,26,27,8,9,10,11,12,13,14,9,10,11,12,13,14,15,10,11,12,13,14,15,16,11,12,13,14,15,16,17,12,13,14,15,16,17,18,13,14,15,16,17,18,19,14,15,16,17,18,19,20,9,10,11,12,13,14,15,10,16,11,17,12,18,13,19,14,20,15,16,17,18,19,20,21,10,11,12,13,14,15,16,11,17,12,18,13,19,14,20,15,21,16,17,18,19,20,21,22,11,12,13,14,15,16,17,12,18,13,19,14,20,15,21,16,22,17,18,19,20,21,22,23,12,13,14,15,16,17,18,13,19,14,20,15,21,16,22,17,23,18,19,20,21,22,23,24,13,14,15,16,17,18,19,14,20,15,21,16,22,17,23,18,24,19,20,21,22,23,24,25,14,15,16,17,18,19,20,15,16,17,18,19,20,21,16,17,18,19,20,21,22,17,18,19,20,21,22,23,18,19,20,21,22,23,24,19,20,21,22,23,24,25,20,21,22,23,24,25,26,10,11,12,13,14,15,11,12,13,14,15,16,12,13,14,15,16,17,13,14,15,16,17,18,14,15,16,17,18,19,15,16,17,18,19,20,11,12,13,14,15,16,12,17,13,18,14,19,15,20,16,17,18,19,20,21,12,13,14,15,16,17,13,18,14,19,15,20,16,21,17,18,19,20,21,22,13,14,15,16,17,18,14,19,15,20,16,21,17,22,18,19,20,21,22,23,14,15,16,17,18,19,15,20,16,21,17,22,18,23,19,20,21,22,23,24,15,16,17,18,19,20,16,17,18,19,20,21,17,18,19,20,21,22,18,19,20,21,22,23,19,20,21,22,23,24,20,21,22,23,24,25,12,13,14,15,16,13,14,15,16,17,14,15,16,17,18,15,16,17,18,19,16,17,18,19,20,13,14,15,16,17,14,18,15,19,16,20,17,18,19,20,21,14,15,16,17,18,15,19,16,20,17,21,18,19,20,21,22,15,16,17,18,19,16,20,17,21,18,22,19,20,21,22,23,16,17,18,19,20,17,18,19,20,21,18,19,20,21,22,19,20,21,22,23,20,21,22,23,24,14,15,16,17,15,16,17,18,16,17,18,19,17,18,19,20,15,16,17,18,16,19,17,20,18,19,20,21,16,17,18,19,17,20,18,21,19,20,21,22,17,18,19,20,18,19,20,21,19,20,21,22,20,21,22,23,16,17,18,17,18,19,18,19,20,17,18,19,18,20,19,20,21,18,19,20,19,20,21,20,21,22,18,19,19,20,19,20,20,21,20}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test flag_vector/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1,-1,-1,-1,0,0,0,1,1,1},{-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1,-1,0,1}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test flag_vector/2.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{0,1,0,0,0,0,0,0},{0,0,1,0,0,0,0,0},{0,0,0,1,0,0,0,0},{0,0,0,0,1,0,0,0},{0,0,0,0,0,1,0,0},{0,0,0,0,0,0,1,0},{0,0,0,0,0,0,0,1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,1},{0,0,0,0,0,0,1,0},{0,0,0,0,0,1,0,0},{0,0,0,0,1,0,0,0},{0,0,0,1,0,0,0,0},{0,0,1,0,0,0,0,0},{0,1,0,0,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test beneath_beyond/8.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1},{0,1,0,1,0},{0,0,1,1,0},{0,0,0,0,1},{0,0,0,0,0},{0,0,0,0,0}};
desiredHB = matrix {{1,1,1,1,1},{0,0,0,1,1},{0,0,1,0,1},{0,1,0,0,0},{0,0,0,0,0},{0,0,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test beneath_beyond/1r.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test beneath_beyond/1.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1},{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
desiredHB = matrix {{1,1,1,1,1,1,1,1,1},{-1,0,0,0,0,0,0,0,1},{0,-1,0,0,0,0,0,1,0},{0,0,-1,0,0,0,1,0,0},{0,0,0,-1,0,1,0,0,0}};
desiredHB = sort desiredHB;
C = coneFromVData(raysC)
computedHB = sort matrix {hilbertBasis C};
assert(sort desiredHB == sort computedHB);
///

-- Test beneath_beyond/4.poly
-- Checking hilbertBasis
TEST ///
raysC = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-