#include <stdio.h>
#include "nameslist-dll.h"
#include "uninameslist-fr.h"

/* This file was generated using the program 'buildnameslist.c' */


/*
; Standard Unicode 10.0 ou
;	Norme internationale ISO/CEI 10646:2017
;
; Ces noms français sont utilisés pour confectionner
;	les commentaires documentant chacun des caractères
;	dont les poids de tri sont déterminés dans la table commune
;	de la norme internationale ISO/CEI 14651. Cette dernière table
;	est normative. La présente liste est informative, jusqu’à ce que
;	l’ISO/CEI 10646 ait été remise à niveau en français.
;
; Contributions à la version 10.0 française des noms de caractère :
;	Jacques André, France
;	Patrick Andries, Canada (Québec)
;	Bernard Chauvois, France
;	Karljürgen Feuerherm, Canada (Ontario)
;	Alain LaBonté, Canada (Québec)
;	Marc Lodewijck, Belgique
;	Michel Suignard, États-Unis d’Amérique
;	François Yergeau, Canada (Québec)
*/

/* Retrieve a pointer to the name of a Unicode codepoint. */
UN_DLL_EXPORT
const char *uniNamesList_nameFR(unsigned long uni) {
	const char *pt=NULL;

	if ( uni<0x110000 )
		pt=UnicodeNameAnnotFR[uni>>16][(uni>>8)&0xff][uni&0xff].name;
	return( pt );
}

/* Retrieve a pointer to annotation details of a Unicode codepoint. */
UN_DLL_EXPORT
const char *uniNamesList_annotFR(unsigned long uni) {
	const char *pt=NULL;

	if ( uni<0x110000 )
		pt=UnicodeNameAnnotFR[uni>>16][(uni>>8)&0xff][uni&0xff].annot;
	return( pt );
}

/* Retrieve Nameslist.txt version number. */
UN_DLL_EXPORT
const char *uniNamesList_NamesListVersionFR(void) {
	return( "Nameslist-Version: 10.0" );
}


/* These functions are available in libuninameslist-0.4.20140731 and higher */

/* Return number of blocks in this NamesList. */
UN_DLL_EXPORT
int uniNamesList_blockCountFR(void) {
	return( UNICODE_FR_BLOCK_MAX );
}

/* Return block number for this unicode value, -1 if unlisted unicode value */
UN_DLL_EXPORT
int uniNamesList_blockNumberFR(unsigned long uni) {
	if ( uni<0x110000 ) {
		int i;
		for (i=0; i<UNICODE_FR_BLOCK_MAX; i++) {
			if ( uni<(unsigned long)(UnicodeBlockFR[i].start) ) break;
			if ( uni<=(unsigned long)(UnicodeBlockFR[i].end) ) return( i );
		}
	}
	return( -1 );
}

/* Return unicode value starting this Unicode block (-1 if bad uniBlock). */
UN_DLL_EXPORT
long uniNamesList_blockStartFR(int uniBlock) {
	if ( uniBlock<0 || uniBlock>=UNICODE_FR_BLOCK_MAX )
		return( -1 );
	return( (long)(UnicodeBlockFR[uniBlock].start) );
}

/* Return unicode value ending this Unicode block (-1 if bad uniBlock). */
UN_DLL_EXPORT
long uniNamesList_blockEndFR(int uniBlock) {
	if ( uniBlock<0 || uniBlock>=UNICODE_FR_BLOCK_MAX )
		return( -1 );
	return( (long)(UnicodeBlockFR[uniBlock].end) );
}

/* Return a pointer to the blockname for this unicode block. */
UN_DLL_EXPORT
const char * uniNamesList_blockNameFR(int uniBlock) {
	if ( uniBlock<0 || uniBlock>=UNICODE_FR_BLOCK_MAX )
		return( NULL );
	return( UnicodeBlockFR[uniBlock].name );
}

UN_DLL_LOCAL
static const struct unicode_nameannot nullarrayFR[] = {
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL }
};

UN_DLL_LOCAL
static const struct unicode_nameannot nullarray2FR[] = {
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL }, { NULL, NULL }, { NULL, NULL },
	{ NULL, NULL }, { NULL, NULL },
	{ NULL, "	* on est assuré que la valeur ?FFFE n'est en aucune façon un caractère Unicode" },
	{ NULL, "	* on est assuré que la valeur ?FFFF n'est en aucune façon un caractère Unicode" },
};

UN_DLL_LOCAL
static const struct unicode_nameannot * const nullnullarrayFR[] = {
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR,
	nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarrayFR, nullarray2FR
};

UN_DLL_EXPORT
const struct unicode_block UnicodeBlockFR[] = {
	{ 0x0, 0x7f, "Commandes C0 et latin de base (Latin de base)" },
	{ 0x80, 0xff, "Commandes C1 et supplément Latin-1 (Supplément Latin-1)" },
	{ 0x100, 0x17f, "Latin étendu A" },
	{ 0x180, 0x24f, "Latin étendu B" },
	{ 0x250, 0x2af, "Supplément pour l’API" },
	{ 0x2b0, 0x2ff, "Lettres modificatives à chasse" },
	{ 0x300, 0x36f, "Diacritiques" },
	{ 0x370, 0x3ff, "Grec et copte" },
	{ 0x400, 0x4ff, "Cyrillique" },
	{ 0x500, 0x52f, "Supplément cyrillique" },
	{ 0x530, 0x58f, "Arménien" },
	{ 0x590, 0x5ff, "Hébreu" },
	{ 0x600, 0x6ff, "Arabe" },
	{ 0x700, 0x74f, "Syriaque" },
	{ 0x750, 0x77f, "Supplément arabe" },
	{ 0x780, 0x7bf, "Thâna" },
	{ 0x7c0, 0x7ff, "N’ko" },
	{ 0x800, 0x83f, "Samaritain" },
	{ 0x840, 0x85f, "Mandéen" },
	{ 0x860, 0x86f, "Supplément syriaque" },
	{ 0x8a0, 0x8ff, "Arabe étendu A" },
	{ 0x900, 0x97f, "Dévanâgarî" },
	{ 0x980, 0x9ff, "Bengali" },
	{ 0xa00, 0xa7f, "Gourmoukhî" },
	{ 0xa80, 0xaff, "Goudjarati" },
	{ 0xb00, 0xb7f, "Oriya" },
	{ 0xb80, 0xbff, "Tamoul" },
	{ 0xc00, 0xc7f, "Télougou" },
	{ 0xc80, 0xcff, "Kannara" },
	{ 0xd00, 0xd7f, "Malayalam" },
	{ 0xd80, 0xdff, "Singhalais" },
	{ 0xe00, 0xe7f, "Thaï" },
	{ 0xe80, 0xeff, "Lao" },
	{ 0xf00, 0xfff, "Tibétain" },
	{ 0x1000, 0x109f, "Birman" },
	{ 0x10a0, 0x10ff, "Géorgien" },
	{ 0x1100, 0x11ff, "Jamos hangûl" },
	{ 0x1200, 0x137f, "Éthiopien" },
	{ 0x1380, 0x139f, "Supplément éthiopien" },
	{ 0x13a0, 0x13ff, "Chérokie" },
	{ 0x1400, 0x167f, "Syllabaires autochtones canadiens" },
	{ 0x1680, 0x169f, "Ogam" },
	{ 0x16a0, 0x16ff, "Runes" },
	{ 0x1700, 0x171f, "Tagalog" },
	{ 0x1720, 0x173f, "Hanounóo" },
	{ 0x1740, 0x175f, "Bouhid" },
	{ 0x1760, 0x177f, "Tagbanoua" },
	{ 0x1780, 0x17ff, "Khmer" },
	{ 0x1800, 0x18af, "Mongol" },
	{ 0x18b0, 0x18ff, "Syllabaires autochtones canadiens étendus" },
	{ 0x1900, 0x194f, "Limbu" },
	{ 0x1950, 0x197f, "Taï-le" },
	{ 0x1980, 0x19df, "Nouveau taï lü" },
	{ 0x19e0, 0x19ff, "Symboles khmers" },
	{ 0x1a00, 0x1a1f, "Bougui" },
	{ 0x1a20, 0x1aaf, "Taï-tham" },
	{ 0x1ab0, 0x1aff, "Diacritiques complémentaires" },
	{ 0x1b00, 0x1b7f, "Balinais" },
	{ 0x1b80, 0x1bbf, "Soundanais" },
	{ 0x1bc0, 0x1bff, "Batak" },
	{ 0x1c00, 0x1c4f, "Leptcha" },
	{ 0x1c50, 0x1c7f, "Ol tchiki" },
	{ 0x1c80, 0x1c8f, "Cyrillique étendu C" },
	{ 0x1cc0, 0x1ccf, "Supplément soundanais" },
	{ 0x1cd0, 0x1cff, "Supplément védique" },
	{ 0x1d00, 0x1d7f, "Supplément phonétique" },
	{ 0x1d80, 0x1dbf, "Supplément phonétique étendu" },
	{ 0x1dc0, 0x1dff, "Supplément de diacritiques" },
	{ 0x1e00, 0x1eff, "Latin étendu additionnel" },
	{ 0x1f00, 0x1fff, "Grec étendu" },
	{ 0x2000, 0x206f, "Ponctuation générale" },
	{ 0x2070, 0x209f, "Exposants et indices" },
	{ 0x20a0, 0x20cf, "Symboles monétaires" },
	{ 0x20d0, 0x20ff, "Signes combinatoires pour des symboles" },
	{ 0x2100, 0x214f, "Symboles de type lettre" },
	{ 0x2150, 0x218f, "Formes numérales" },
	{ 0x2190, 0x21ff, "Flèches" },
	{ 0x2200, 0x22ff, "Opérateurs mathématiques" },
	{ 0x2300, 0x23ff, "Signes techniques divers" },
	{ 0x2400, 0x243f, "Pictogrammes de commande" },
	{ 0x2440, 0x245f, "Reconnaissance optique de caractères" },
	{ 0x2460, 0x24ff, "Symboles alphanumériques bornés ou entourés" },
	{ 0x2500, 0x257f, "Filets" },
	{ 0x2580, 0x259f, "Pavés" },
	{ 0x25a0, 0x25ff, "Formes géométriques" },
	{ 0x2600, 0x26ff, "Symboles divers" },
	{ 0x2700, 0x27bf, "Casseau" },
	{ 0x27c0, 0x27ef, "Divers symboles mathématiques - A" },
	{ 0x27f0, 0x27ff, "Supplément A de flèches" },
	{ 0x2800, 0x28ff, "Combinaisons Braille" },
	{ 0x2900, 0x297f, "Supplément B de flèches" },
	{ 0x2980, 0x29ff, "Divers symboles mathématiques - B" },
	{ 0x2a00, 0x2aff, "Opérateurs mathématiques supplémentaires" },
	{ 0x2b00, 0x2bff, "Divers symboles et flèches" },
	{ 0x2c00, 0x2c5f, "Glagolitique" },
	{ 0x2c60, 0x2c7f, "Latin étendu C" },
	{ 0x2c80, 0x2cff, "Copte" },
	{ 0x2d00, 0x2d2f, "Supplément géorgien" },
	{ 0x2d30, 0x2d7f, "Tifinaghe" },
	{ 0x2d80, 0x2ddf, "Éthiopien étendu" },
	{ 0x2de0, 0x2dff, "Cyrillique étendu A" },
	{ 0x2e00, 0x2e7f, "Ponctuation complémentaire" },
	{ 0x2e80, 0x2eff, "Formes supplémentaires des clés CJC" },
	{ 0x2f00, 0x2fdf, "Clés chinoises K’ang-hsi" },
	{ 0x2ff0, 0x2fff, "Caractères de description idéographique" },
	{ 0x3000, 0x303f, "Symboles et ponctuation CJC" },
	{ 0x3040, 0x309f, "Hiragana" },
	{ 0x30a0, 0x30ff, "Katakana" },
	{ 0x3100, 0x312f, "Bopomofo" },
	{ 0x3130, 0x318f, "Jamos hangûl de compatibilité" },
	{ 0x3190, 0x319f, "Kanboun" },
	{ 0x31a0, 0x31bf, "Bopomofo étendu" },
	{ 0x31c0, 0x31ef, "Traits CJC" },
	{ 0x31f0, 0x31ff, "Supplément phonétique katakana" },
	{ 0x3200, 0x32ff, "Lettres et mois CJC bornés ou entourés" },
	{ 0x3300, 0x33ff, "Compatibilité CJC" },
	{ 0x3400, 0x4db5, "Supplément A aux idéogrammes unifiés CJC" },
	{ 0x4dc0, 0x4dff, "Hexagrammes du Classique des mutations ou Yi-king" },
	{ 0x4e00, 0x9fea, "Idéogrammes unifiés CJC" },
	{ 0xa000, 0xa48f, "Syllabaire yi des Monts frais" },
	{ 0xa490, 0xa4cf, "Clés yi" },
	{ 0xa4d0, 0xa4ff, "Lissou" },
	{ 0xa500, 0xa63f, "Vaï" },
	{ 0xa640, 0xa69f, "Cyrillique étendu B" },
	{ 0xa6a0, 0xa6ff, "Bamoum" },
	{ 0xa700, 0xa71f, "Lettres modificatives de ton" },
	{ 0xa720, 0xa7ff, "Latin étendu D" },
	{ 0xa800, 0xa82f, "Sylotî nâgrî" },
	{ 0xa830, 0xa83f, "Formes numériques communes indiennes" },
	{ 0xa840, 0xa87f, "Phags-pa" },
	{ 0xa880, 0xa8df, "Saurachtra" },
	{ 0xa8e0, 0xa8ff, "Dévanâgarî étendue" },
	{ 0xa900, 0xa92f, "Kayah li" },
	{ 0xa930, 0xa95f, "Rejang" },
	{ 0xa960, 0xa97f, "Jamos hangûl complémentaires A" },
	{ 0xa980, 0xa9df, "Javanais" },
	{ 0xa9e0, 0xa9ff, "Birman étendu B" },
	{ 0xaa00, 0xaa5f, "Tcham" },
	{ 0xaa60, 0xaa7f, "Birman étendu A" },
	{ 0xaa80, 0xaadf, "Taï-viet" },
	{ 0xaae0, 0xaaff, "Supplément meitei mayek" },
	{ 0xab00, 0xab2f, "Éthiopien étendu A" },
	{ 0xab30, 0xab6f, "Latin étendu E" },
	{ 0xab70, 0xabbf, "Supplément chérokie" },
	{ 0xabc0, 0xabff, "Meitei mayek" },
	{ 0xac00, 0xd7a3, "Syllabes hangûl" },
	{ 0xd7b0, 0xd7ff, "Jamos hangûl complémentaires B" },
	{ 0xd800, 0xdb7f, "Demi-zone haute" },
	{ 0xdb80, 0xdbff, "Partie à usage privé de la demi-zone haute" },
	{ 0xdc00, 0xdfff, "Demi-zone basse" },
	{ 0xe000, 0xf8ff, "Zone à usage privé" },
	{ 0xf900, 0xfaff, "Idéogrammes de compatibilité CJC" },
	{ 0xfb00, 0xfb4f, "Formes de présentation alphabétiques" },
	{ 0xfb50, 0xfdff, "Formes A de présentation arabes" },
	{ 0xfe00, 0xfe0f, "Sélecteurs de variante" },
	{ 0xfe10, 0xfe1f, "Formes verticales" },
	{ 0xfe20, 0xfe2f, "Demi-signes combinatoires" },
	{ 0xfe30, 0xfe4f, "Formes de compatibilité CJC" },
	{ 0xfe50, 0xfe6f, "Petites variantes de forme" },
	{ 0xfe70, 0xfeff, "Formes B de présentation arabes" },
	{ 0xff00, 0xffef, "Formes de demi-chasse et de pleine chasse" },
	{ 0xfff0, 0xffff, "Caractères spéciaux" },
	{ 0x10000, 0x1007f, "Syllabaire linéaire B" },
	{ 0x10080, 0x100ff, "Idéogrammes du linéaire B" },
	{ 0x10100, 0x1013f, "Nombres égéens" },
	{ 0x10140, 0x1018f, "Nombres grecs anciens" },
	{ 0x10190, 0x101cf, "Symboles de l’Antiquité" },
	{ 0x101d0, 0x101ff, "Disque de Phaïstos" },
	{ 0x10280, 0x1029f, "Lycien" },
	{ 0x102a0, 0x102df, "Carien" },
	{ 0x102e0, 0x102ff, "Nombres épactes coptes" },
	{ 0x10300, 0x1032f, "Vieil italique" },
	{ 0x10330, 0x1034f, "Gotique" },
	{ 0x10350, 0x1037f, "Ancien permien" },
	{ 0x10380, 0x1039f, "Ougaritique" },
	{ 0x103a0, 0x103df, "Vieux perse" },
	{ 0x10400, 0x1044f, "Déséret" },
	{ 0x10450, 0x1047f, "Shavien" },
	{ 0x10480, 0x104af, "Osmanya" },
	{ 0x104b0, 0x104ff, "Osage" },
	{ 0x10500, 0x1052f, "Elbasan" },
	{ 0x10530, 0x1056f, "Albanien" },
	{ 0x10600, 0x1077f, "Linéaire A" },
	{ 0x10800, 0x1083f, "Syllabaire chypriote" },
	{ 0x10840, 0x1085f, "Araméen impérial" },
	{ 0x10860, 0x1087f, "Palmyréen" },
	{ 0x10880, 0x108af, "Nabatéen" },
	{ 0x108e0, 0x108ff, "Hatréen" },
	{ 0x10900, 0x1091f, "Phénicien" },
	{ 0x10920, 0x1093f, "Lydien" },
	{ 0x10980, 0x1099f, "Hiéroglyphes méroïtiques" },
	{ 0x109a0, 0x109ff, "Cursif méroïtique" },
	{ 0x10a00, 0x10a5f, "Kharochthî" },
	{ 0x10a60, 0x10a7f, "Sud-arabique" },
	{ 0x10a80, 0x10a9f, "Vieil arabe du Nord" },
	{ 0x10ac0, 0x10aff, "Manichéen" },
	{ 0x10b00, 0x10b3f, "Avestique" },
	{ 0x10b40, 0x10b5f, "Parthe des inscriptions" },
	{ 0x10b60, 0x10b7f, "Pehlvi des inscriptions" },
	{ 0x10b80, 0x10baf, "Pehlvi des psautiers" },
	{ 0x10c00, 0x10c4f, "Orkhon" },
	{ 0x10c80, 0x10cff, "Runes hongroises" },
	{ 0x10e60, 0x10e7f, "Symboles numéraux rûmî" },
	{ 0x11000, 0x1107f, "Brahmi" },
	{ 0x11080, 0x110cf, "Kayathi" },
	{ 0x110d0, 0x110ff, "Sora sompeng" },
	{ 0x11100, 0x1114f, "Chakma" },
	{ 0x11150, 0x1117f, "Mahajani" },
	{ 0x11180, 0x111df, "Charada" },
	{ 0x111e0, 0x111ff, "Nombres archaïques singhalais" },
	{ 0x11200, 0x1124f, "Khojki" },
	{ 0x11280, 0x112af, "Multanais" },
	{ 0x112b0, 0x112ff, "Khudawadi" },
	{ 0x11300, 0x1137f, "Grantha" },
	{ 0x11400, 0x1147f, "Néwar" },
	{ 0x11480, 0x114df, "Tirhuta" },
	{ 0x11580, 0x115ff, "Siddham" },
	{ 0x11600, 0x1165f, "Modi" },
	{ 0x11660, 0x1167f, "Supplément mongol" },
	{ 0x11680, 0x116cf, "Takri" },
	{ 0x11700, 0x1173f, "Âhom" },
	{ 0x118a0, 0x118ff, "Varang kchiti" },
	{ 0x11a00, 0x11a4f, "Zanabazar carré" },
	{ 0x11a50, 0x11aaf, "Soyombo" },
	{ 0x11ac0, 0x11aff, "Pau Cin Hau" },
	{ 0x11c00, 0x11c6f, "Bhaiksuki" },
	{ 0x11c70, 0x11cbf, "Marchen" },
	{ 0x11d00, 0x11d5f, "Gondi de Masaram" },
	{ 0x12000, 0x123ff, "Cunéiforme" },
	{ 0x12400, 0x1247f, "Ponctuation et nombres cunéiformes" },
	{ 0x12480, 0x1254f, "Cunéiforme proto-dynastique" },
	{ 0x13000, 0x1342f, "Hiéroglyphes égyptiens" },
	{ 0x14400, 0x1467f, "Hiéroglyphes anatoliens" },
	{ 0x16800, 0x16a3f, "Supplément bamoum" },
	{ 0x16a40, 0x16a6f, "Mro" },
	{ 0x16ad0, 0x16aff, "Vah bassa" },
	{ 0x16b00, 0x16b8f, "Pahawh hmong" },
	{ 0x16f00, 0x16f9f, "Miao" },
	{ 0x16fe0, 0x16fff, "Symboles et ponctuation idéographiques" },
	{ 0x17000, 0x187ec, "Tangoute" },
	{ 0x18800, 0x18aff, "Composants tangoutes" },
	{ 0x1b000, 0x1b0ff, "Supplément de kana" },
	{ 0x1b100, 0x1b12f, "Kana complémentaires A" },
	{ 0x1b170, 0x1b2ff, "Nüshu" },
	{ 0x1bc00, 0x1bc9f, "Sténographie Duployé" },
	{ 0x1bca0, 0x1bcaf, "Formatage de sténographie" },
	{ 0x1d000, 0x1d0ff, "Symboles musicaux byzantins" },
	{ 0x1d100, 0x1d1ff, "Symboles musicaux" },
	{ 0x1d200, 0x1d24f, "Notation musicale grecque ancienne" },
	{ 0x1d300, 0x1d35f, "Symboles du Classique du mystère suprême" },
	{ 0x1d360, 0x1d37f, "Chiffres-bâtonnets chinois" },
	{ 0x1d400, 0x1d7ff, "Symboles mathématiques alphanumériques" },
	{ 0x1d800, 0x1daaf, "SignWriting de Sutton" },
	{ 0x1e000, 0x1e02f, "Supplément glagolitique" },
	{ 0x1e800, 0x1e8df, "Mendé kikakui" },
	{ 0x1e900, 0x1e95f, "Adlam" },
	{ 0x1ee00, 0x1eeff, "Symboles mathématiques alphabétiques arabes" },
	{ 0x1f000, 0x1f02f, "Tuiles de majong" },
	{ 0x1f030, 0x1f09f, "Dominos" },
	{ 0x1f0a0, 0x1f0ff, "Cartes à jouer" },
	{ 0x1f100, 0x1f1ff, "Supplément de symboles alphanumériques bornés ou entourés" },
	{ 0x1f200, 0x1f2ff, "Supplément d’idéogrammes bornés ou entourés" },
	{ 0x1f300, 0x1f5ff, "Divers symboles et pictogrammes" },
	{ 0x1f600, 0x1f64f, "Émoticônes" },
	{ 0x1f650, 0x1f67f, "Casseau ornemental" },
	{ 0x1f680, 0x1f6ff, "Symboles cartographiques ou liés au transport" },
	{ 0x1f700, 0x1f77f, "Symboles alchimiques" },
	{ 0x1f780, 0x1f7ff, "Supplément de formes géométriques" },
	{ 0x1f800, 0x1f8ff, "Supplément C de flèches" },
	{ 0x1f900, 0x1f9ff, "Supplément de symboles et de pictogrammes" },
	{ 0x1ff80, 0x1ffff, "Points de code non attribués" },
	{ 0x20000, 0x2a6d6, "Supplément B aux idéogrammes unifiés CJC" },
	{ 0x2a700, 0x2b734, "Supplément C aux idéogrammes unifiés CJC" },
	{ 0x2b740, 0x2b81d, "Supplément D aux idéogrammes unifiés CJC" },
	{ 0x2b820, 0x2cea1, "Supplément E aux idéogrammes unifiés CJC" },
	{ 0x2ceb0, 0x2ebe0, "Supplément F aux idéogrammes unifiés CJC" },
	{ 0x2f800, 0x2fa1f, "Supplément aux idéogrammes de compatibilité CJC" },
	{ 0x2ff80, 0x2ffff, "Points de code non attribués" },
	{ 0x3ff80, 0x3ffff, "Points de code non attribués" },
	{ 0x4ff80, 0x4ffff, "Points de code non attribués" },
	{ 0x5ff80, 0x5ffff, "Points de code non attribués" },
	{ 0x6ff80, 0x6ffff, "Points de code non attribués" },
	{ 0x7ff80, 0x7ffff, "Points de code non attribués" },
	{ 0x8ff80, 0x8ffff, "Points de code non attribués" },
	{ 0x9ff80, 0x9ffff, "Points de code non attribués" },
	{ 0xaff80, 0xaffff, "Points de code non attribués" },
	{ 0xbff80, 0xbffff, "Points de code non attribués" },
	{ 0xcff80, 0xcffff, "Points de code non attribués" },
	{ 0xdff80, 0xdffff, "Points de code non attribués" },
	{ 0xe0000, 0xe007f, "Étiquettes" },
	{ 0xe0100, 0xe01ef, "Supplément de sélecteurs de variante" },
	{ 0xeff80, 0xeffff, "Points de code non attribués" },
	{ 0xfff80, 0xfffff, "Zone supplémentaire A à usage privé" },
	{ 0x10ff80, 0x10ffff, "Zone supplémentaire B à usage privé" }
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_00[] = {
/* 0000 */ { NULL,"	= NUL"},
/* 0001 */ { NULL,"	= DÉBUT D'EN-TÊTE"},
/* 0002 */ { NULL,"	= DÉBUT DE TEXTE"},
/* 0003 */ { NULL,"	= FIN DE TEXTE"},
/* 0004 */ { NULL,"	= FIN DE TRANSMISSION"},
/* 0005 */ { NULL,"	= DEMANDE"},
/* 0006 */ { NULL,"	= ACCUSÉ DE RÉCEPTION\n"
	"	= accusé de réception positif"},
/* 0007 */ { NULL,"	= SONNERIE"},
/* 0008 */ { NULL,"	= ESPACE ARRIÈRE"},
/* 0009 */ { NULL,"	= TABULATION HORIZONTALE"},
/* 000A */ { NULL,"	= CHANGEMENT DE LIGNE\n"
	"	= passage à la ligne, fin de ligne"},
/* 000B */ { NULL,"	= TABULATION VERTICALE"},
/* 000C */ { NULL,"	= SAUT DE PAGE\n"
	"	= page suivante"},
/* 000D */ { NULL,"	= RETOUR DE CHARIOT"},
/* 000E */ { NULL,"	= HORS CODE"},
/* 000F */ { NULL,"	= EN CODE"},
/* 0010 */ { NULL,"	= ÉCHAPPEMENT TRANSMISSION"},
/* 0011 */ { NULL,"	= COMMANDE DE DISPOSITIF UN\n"
	"	= commande d'appareil un"},
/* 0012 */ { NULL,"	= COMMANDE DE DISPOSITIF DEUX\n"
	"	= commande d'appareil deux"},
/* 0013 */ { NULL,"	= COMMANDE DE DISPOSITIF TROIS\n"
	"	= commande d'appareil trois"},
/* 0014 */ { NULL,"	= COMMANDE DE DISPOSITIF QUATRE\n"
	"	= commande d'appareil quatre"},
/* 0015 */ { NULL,"	= ACCUSÉ DE RÉCEPTION NÉGATIF"},
/* 0016 */ { NULL,"	= SYNCHRONISATION"},
/* 0017 */ { NULL,"	= FIN DE BLOC DE TRANSMISSION"},
/* 0018 */ { NULL,"	= ANNULATION"},
/* 0019 */ { NULL,"	= FIN DE SUPPORT"},
/* 001A */ { NULL,"	= SUBSTITUTION\n"
	"	x (caractère de remplacement - FFFD)"},
/* 001B */ { NULL,"	= ÉCHAPPEMENT"},
/* 001C */ { NULL,"	= SÉPARATEUR DE FICHIERS\n"
	"	= séparateur d'information quatre"},
/* 001D */ { NULL,"	= SÉPARATEUR DE GROUPES\n"
	"	= séparateur d'information trois"},
/* 001E */ { NULL,"	= SÉPARATEUR D'ENREGISTREMENTS\n"
	"	= séparateur d'information deux"},
/* 001F */ { NULL,"	= SÉPARATEUR DE SOUS-ARTICLES\n"
	"	= séparateur d'information un"},
/* 0020 */ { "ESPACE","	* le mot « espace » est féminin en typographie\n"
	"	* parfois considérée comme un caractère de commande\n"
	"	* autres espaces : 2000-200A\n"
	"	x (espace insécable - 00A0)\n"
	"	x (espace sans chasse - 200B)\n"
	"	x (gluon de mots - 2060)\n"
	"	x (espace idéographique - 3000)\n"
	"	x (indicateur d'ordre des octets - FEFF)"},
/* 0021 */ { "POINT D'EXCLAMATION","	= factorielle\n"
	"	x (point d'exclamation renversé - 00A1)\n"
	"	x (lettre latine clic rétroflexe - 01C3)\n"
	"	x (double point d'exclamation - 203C)\n"
	"	x (point exclarrogatif - 203D)\n"
	"	x (point d'exclamation de fantaisie épais - 2762)"},
/* 0022 */ { "GUILLEMET ANGLAIS","	= guillemet dactylographique, petit guillemet\n"
	"	= guillemet APL\n"
	"	* neutre (vertical), utilisé comme guillemet ouvrant ou fermant\n"
	"	* les caractères recommandés en anglais pour les guillemets appariés sont 201C et 201D\n"
	"	* 05F4 est recommandé pour le gerchâïm dans l'écriture de l'hébreu\n"
	"	x (lettre modificative seconde - 02BA)\n"
	"	x (diacritique double accent aigu - 030B)\n"
	"	x (diacritique double ligne verticale en chef - 030E)\n"
	"	x (ponctuation hébraïque gerchâïm - 05F4)\n"
	"	x (double prime - 2033)\n"
	"	x (guillemet de répétition - 3003)"},
/* 0023 */ { "CROISILLON","	= carré, chemin de fer, octothorpe, ducat\n"
	"	* contrairement à l'usage américain, ce symbole ne représente pas le numéro\n"
	"	* il est peu utilisé dans la typographie française\n"
	"	* à ne pas confondre avec le dièse (266F)\n"
	"	x (symbole l b barré - 2114)\n"
	"	x (carré de visualisation - 2317)\n"
	"	x (dièse - 266F)"},
/* 0024 */ { "SYMBOLE DOLLAR","	= milreis, escudo, piastre\n"
	"	* utilisé pour de nombreuses devises (pesos) en Amérique latine et ailleurs\n"
	"	* le glyphe peut comporter une ou deux barres verticales\n"
	"	* d'autres caractères de symboles monétaires sont codés à partir de la valeur 20A0\n"
	"	x (symbole monétaire - 00A4)\n"
	"	x (symbole peso - 20B1)\n"
	"	x (gros symbole dollar - 1F4B2)"},
/* 0025 */ { "SYMBOLE POUR CENT","	x (symbole arabe pour cent - 066A)\n"
	"	x (symbole pour mille - 2030)\n"
	"	x (symbole pour dix mille - 2031)\n"
	"	x (signe moins commercial - 2052)"},
/* 0026 */ { "PERLUÈTE","	= esperluète/esperluette, et commercial, et\n"
	"	x (note tironienne et - 204A)\n"
	"	x (perluète culbutée - 214B)\n"
	"	x (ornement perluète au trait fort - 1F674)"},
/* 0027 */ { "APOSTROPHE","	= apostrophe droite, apostrophe dactylographique\n"
	"	= guillemet APL\n"
	"	* glyphe neutre (vertical) à usages variés\n"
	"	* le caractère recommandé pour indiquer l'apostrophe est 2019\n"
	"	* les caractères recommandés pour les guillemets appariés en anglais sont 2018 et 2019\n"
	"	* 05F3 est recommandé pour le gerich dans l'écriture de l'hébreu\n"
	"	x (lettre modificative prime - 02B9)\n"
	"	x (lettre modificative apostrophe - 02BC)\n"
	"	x (lettre modificative ligne verticale - 02C8)\n"
	"	x (diacritique accent aigu - 0301)\n"
	"	x (ponctuation hébraïque gerich - 05F3)\n"
	"	x (prime - 2032)\n"
	"	x (lettre minuscule latine saltillo - A78C)"},
/* 0028 */ { "PARENTHÈSE GAUCHE","	= parenthèse ouvrante (1.0)"},
/* 0029 */ { "PARENTHÈSE DROITE","	= parenthèse fermante (1.0)\n"
	"	* se référer à la discussion sur la signification des caractères appariés"},
/* 002A */ { "ASTÉRISQUE","	= étoile (sur les claviers téléphoniques)\n"
	"	x (étoile à cinq branches arabe - 066D)\n"
	"	x (astérisque baissé - 204E)\n"
	"	x (opérateur astérisque - 2217)\n"
	"	x (sextile - 26B9)\n"
	"	x (gros astérisque - 2731)"},
/* 002B */ { "SIGNE PLUS","	= addition\n"
	"	x (signe plus épais - 2795)"},
/* 002C */ { "VIRGULE","	= séparateur décimal\n"
	"	x (virgule arabe - 060C)\n"
	"	x (guillemet-virgule inférieur - 201A)\n"
	"	x (virgule réfléchie - 2E41)\n"
	"	x (virgule idéographique - 3001)"},
/* 002D */ { "TRAIT D'UNION-SIGNE MOINS","	= tiret, trait d'union, signe moins\n"
	"	* appelé division par les typographes\n"
	"	* le caractère recommandé pour le signe moins est 2212\n"
	"	x (trait d'union - 2010)\n"
	"	x (trait d'union insécable - 2011)\n"
	"	x (tiret numérique - 2012)\n"
	"	x (tiret demi-cadratin - 2013)\n"
	"	x (puce trait d'union - 2043)\n"
	"	x (signe moins - 2212)\n"
	"	x (symbole romain once - 10191)"},
/* 002E */ { "POINT","	= point final, séparateur de milliers, point décimal anglo-saxon\n"
	"	* peut apparaître haussé pour les chiffres elzéviriens\n"
	"	x (point arabe - 06D4)\n"
	"	x (point sténographique - 2E3C)\n"
	"	x (point idéographique - 3002)"},
/* 002F */ { "BARRE OBLIQUE","	= cotice, oblique\n"
	"	x (lettre latine clic dental - 01C0)\n"
	"	x (diacritique barre oblique longue couvrante - 0338)\n"
	"	x (barre de fraction - 2044)\n"
	"	x (barre oblique de division - 2215)"},
/* 0030 */ { "CHIFFRE ZÉRO","	~ 0030 FE00 forme à barre diagonale courte"},
/* 0031 */ { "CHIFFRE UN",NULL},
/* 0032 */ { "CHIFFRE DEUX",NULL},
/* 0033 */ { "CHIFFRE TROIS",NULL},
/* 0034 */ { "CHIFFRE QUATRE",NULL},
/* 0035 */ { "CHIFFRE CINQ",NULL},
/* 0036 */ { "CHIFFRE SIX",NULL},
/* 0037 */ { "CHIFFRE SEPT",NULL},
/* 0038 */ { "CHIFFRE HUIT",NULL},
/* 0039 */ { "CHIFFRE NEUF",NULL},
/* 003A */ { "DEUX-POINTS","	* également utilisé comme signe de division ou d'échelle ; pour ces emplois mathématiques, 2236 est recommandé\n"
	"	x (point arménien - 0589)\n"
	"	x (ponctuation hébraïque sof pasouq - 05C3)\n"
	"	x (rapport - 2236)\n"
	"	x (lettre modificative deux-points - A789)"},
/* 003B */ { "POINT-VIRGULE","	* ce caractère (et non 037E) est la représentation recommandée du « point d'interrogation grec »\n"
	"	x (point d'interrogation grec - 037E)\n"
	"	x (point-virgule arabe - 061B)\n"
	"	x (point-virgule réfléchi - 204F)"},
/* 003C */ { "SIGNE INFÉRIEUR À","	= crochet brisé ouvrant\n"
	"	x (guillemet simple vers la gauche - 2039)\n"
	"	x (chevron pointant à gauche - 2329)\n"
	"	x (chevron mathématique gauche - 27E8)\n"
	"	x (chevron gauche - 3008)"},
/* 003D */ { "SIGNE ÉGAL","	= égalité\n"
	"	* caractères connexes : 2241-2263\n"
	"	x (pas égal à - 2260)\n"
	"	x (identique à - 2261)\n"
	"	x (lettre modificative signe égal court - A78A)\n"
	"	x (symbole romain sextant - 10190)"},
/* 003E */ { "SIGNE SUPÉRIEUR À","	= crochet brisé fermant\n"
	"	x (guillemet simple vers la droite - 203A)\n"
	"	x (chevron pointant à droite - 232A)\n"
	"	x (chevron mathématique droit - 27E9)\n"
	"	x (chevron droit - 3009)"},
/* 003F */ { "POINT D'INTERROGATION","	x (point d'interrogation renversé - 00BF)\n"
	"	x (point d'interrogation grec - 037E)\n"
	"	x (point d'interrogation arabe - 061F)\n"
	"	x (point exclarrogatif - 203D)\n"
	"	x (point d'interrogation-exclamation - 2048)\n"
	"	x (point d'exclamation-interrogation - 2049)"},
/* 0040 */ { "ARROBE","	= arobase, arobas, arrobas, à commercial\n"
	"	= queue de singe\n"
	"	* ancienne mesure de poids espagnole"},
/* 0041 */ { "LETTRE MAJUSCULE LATINE A",NULL},
/* 0042 */ { "LETTRE MAJUSCULE LATINE B","	x (majuscule b de ronde - 212C)"},
/* 0043 */ { "LETTRE MAJUSCULE LATINE C","	x (majuscule c ajouré - 2102)\n"
	"	x (majuscule c gothique - 212D)"},
/* 0044 */ { "LETTRE MAJUSCULE LATINE D",NULL},
/* 0045 */ { "LETTRE MAJUSCULE LATINE E","	x (constante d'euler - 2107)\n"
	"	x (majuscule e de ronde - 2130)"},
/* 0046 */ { "LETTRE MAJUSCULE LATINE F","	x (majuscule f de ronde - 2131)\n"
	"	x (majuscule f culbuté - 2132)"},
/* 0047 */ { "LETTRE MAJUSCULE LATINE G",NULL},
/* 0048 */ { "LETTRE MAJUSCULE LATINE H","	x (majuscule h de ronde - 210B)\n"
	"	x (majuscule h gothique - 210C)\n"
	"	x (majuscule h ajouré - 210D)"},
/* 0049 */ { "LETTRE MAJUSCULE LATINE I","	* le turc et l'azéri utilisent 0131 pour la minuscule\n"
	"	x (lettre majuscule latine i point en chef - 0130)\n"
	"	x (lettre majuscule cyrillique i biélorusse-ukrainien - 0406)\n"
	"	x (lettre cyrillique palotchka - 04C0)\n"
	"	x (majuscule i de ronde - 2110)\n"
	"	x (majuscule i gothique - 2111)\n"
	"	x (chiffre romain un - 2160)"},
/* 004A */ { "LETTRE MAJUSCULE LATINE J",NULL},
/* 004B */ { "LETTRE MAJUSCULE LATINE K","	x (symbole kelvin - 212A)"},
/* 004C */ { "LETTRE MAJUSCULE LATINE L","	x (majuscule l de ronde - 2112)"},
/* 004D */ { "LETTRE MAJUSCULE LATINE M","	x (majuscule m de ronde - 2133)"},
/* 004E */ { "LETTRE MAJUSCULE LATINE N","	x (majuscule n ajouré - 2115)"},
/* 004F */ { "LETTRE MAJUSCULE LATINE O",NULL},
/* 0050 */ { "LETTRE MAJUSCULE LATINE P","	x (majuscule p ajouré - 2119)"},
/* 0051 */ { "LETTRE MAJUSCULE LATINE Q","	x (majuscule q ajouré - 211A)"},
/* 0052 */ { "LETTRE MAJUSCULE LATINE R","	x (majuscule r de ronde - 211B)\n"
	"	x (majuscule r gothique - 211C)\n"
	"	x (majuscule r ajouré - 211D)"},
/* 0053 */ { "LETTRE MAJUSCULE LATINE S",NULL},
/* 0054 */ { "LETTRE MAJUSCULE LATINE T",NULL},
/* 0055 */ { "LETTRE MAJUSCULE LATINE U",NULL},
/* 0056 */ { "LETTRE MAJUSCULE LATINE V","	x (chiffre romain cinq - 2164)"},
/* 0057 */ { "LETTRE MAJUSCULE LATINE W",NULL},
/* 0058 */ { "LETTRE MAJUSCULE LATINE X",NULL},
/* 0059 */ { "LETTRE MAJUSCULE LATINE Y",NULL},
/* 005A */ { "LETTRE MAJUSCULE LATINE Z","	x (majuscule z ajouré - 2124)\n"
	"	x (majuscule z gothique - 2128)"},
/* 005B */ { "CROCHET GAUCHE","	= crochet ouvrant (1.0)\n"
	"	* autres crochets et signes de la même espèce : 27E6-27EB, 2983-2998, 3008-301B"},
/* 005C */ { "BARRE OBLIQUE INVERSÉE","	= contre-cotice, oblique inverse, contre-oblique\n"
	"	x (diacritique barre oblique inversée couvrante - 20E5)\n"
	"	x (différence d'ensembles - 2216)"},
/* 005D */ { "CROCHET DROIT","	= crochet fermant (1.0)"},
/* 005E */ { "ACCENT CIRCONFLEXE","	* ce caractère chasse\n"
	"	x (lettre modificative pointe de flèche vers le haut - 02C4)\n"
	"	x (lettre modificative accent circonflexe - 02C6)\n"
	"	x (diacritique accent circonflexe - 0302)\n"
	"	x (chevron d'insertion - 2038)\n"
	"	x (pointe de flèche vers le haut - 2303)"},
/* 005F */ { "TIRET BAS","	= tiret de soulignement, souligné\n"
	"	* ce caractère chasse\n"
	"	x (lettre modificative macron bas - 02CD)\n"
	"	x (diacritique macron souscrit - 0331)\n"
	"	x (diacritique trait souscrit - 0332)\n"
	"	x (double tiret bas - 2017)"},
/* 0060 */ { "ACCENT GRAVE","	* ce caractère chasse\n"
	"	x (lettre modificative accent grave - 02CB)\n"
	"	x (diacritique accent grave - 0300)\n"
	"	x (prime réfléchi - 2035)"},
/* 0061 */ { "LETTRE MINUSCULE LATINE A",NULL},
/* 0062 */ { "LETTRE MINUSCULE LATINE B",NULL},
/* 0063 */ { "LETTRE MINUSCULE LATINE C",NULL},
/* 0064 */ { "LETTRE MINUSCULE LATINE D",NULL},
/* 0065 */ { "LETTRE MINUSCULE LATINE E","	x (symbole estimé - 212E)\n"
	"	x (minuscule e de ronde - 212F)"},
/* 0066 */ { "LETTRE MINUSCULE LATINE F",NULL},
/* 0067 */ { "LETTRE MINUSCULE LATINE G","	x (lettre minuscule latine g cursif - 0261)\n"
	"	x (minuscule g de ronde - 210A)"},
/* 0068 */ { "LETTRE MINUSCULE LATINE H","	x (lettre minuscule cyrillique hé - 04BB)\n"
	"	x (constante de planck - 210E)"},
/* 0069 */ { "LETTRE MINUSCULE LATINE I","	* le turc et l'azéri utilisent 0130 pour la majuscule\n"
	"	x (lettre minuscule latine i sans point - 0131)\n"
	"	x (minuscule mathématique italique i sans point - 1D6A4)"},
/* 006A */ { "LETTRE MINUSCULE LATINE J","	x (lettre minuscule latine j sans point - 0237)\n"
	"	x (minuscule mathématique italique j sans point - 1D6A5)"},
/* 006B */ { "LETTRE MINUSCULE LATINE K",NULL},
/* 006C */ { "LETTRE MINUSCULE LATINE L","	x (minuscule l de ronde - 2113)\n"
	"	x (minuscule mathématique l de ronde - 1D4C1)"},
/* 006D */ { "LETTRE MINUSCULE LATINE M",NULL},
/* 006E */ { "LETTRE MINUSCULE LATINE N","	x (exposant lettre minuscule latine n - 207F)"},
/* 006F */ { "LETTRE MINUSCULE LATINE O","	x (minuscule o de ronde - 2134)"},
/* 0070 */ { "LETTRE MINUSCULE LATINE P",NULL},
/* 0071 */ { "LETTRE MINUSCULE LATINE Q",NULL},
/* 0072 */ { "LETTRE MINUSCULE LATINE R",NULL},
/* 0073 */ { "LETTRE MINUSCULE LATINE S",NULL},
/* 0074 */ { "LETTRE MINUSCULE LATINE T",NULL},
/* 0075 */ { "LETTRE MINUSCULE LATINE U",NULL},
/* 0076 */ { "LETTRE MINUSCULE LATINE V",NULL},
/* 0077 */ { "LETTRE MINUSCULE LATINE W",NULL},
/* 0078 */ { "LETTRE MINUSCULE LATINE X",NULL},
/* 0079 */ { "LETTRE MINUSCULE LATINE Y",NULL},
/* 007A */ { "LETTRE MINUSCULE LATINE Z","	x (lettre minuscule latine z barré - 01B6)"},
/* 007B */ { "ACCOLADE GAUCHE","	= accolade ouvrante (1.0)"},
/* 007C */ { "BARRE VERTICALE","	* utilisée par paire pour indiquer une valeur absolue\n"
	"	x (lettre latine clic dental - 01C0)\n"
	"	x (ponctuation hébraïque paseq - 05C0)\n"
	"	x (est un diviseur de - 2223)\n"
	"	x (barre verticale fine - 2758)"},
/* 007D */ { "ACCOLADE DROITE","	= accolade fermante (1.0)"},
/* 007E */ { "TILDE","	* ce caractère chasse\n"
	"	x (petit tilde - 02DC)\n"
	"	x (diacritique tilde - 0303)\n"
	"	x (tiret ondé - 2053)\n"
	"	x (opérateur tilde - 223C)\n"
	"	x (tilde pleine chasse - FF5E)"},
/* 007F */ { NULL,"	= SUPPRESSION"},
/* 0080 */ { NULL,"	= caractère de bourre"},
/* 0081 */ { NULL,"	= octet supérieur prédéfini"},
/* 0082 */ { NULL,"	= ARRÊT PERMIS ICI\n"
	"	x (espace sans chasse - 200B)"},
/* 0083 */ { NULL,"	= AUCUN ARRÊT ICI\n"
	"	x (gluon de mots - 2060)"},
/* 0084 */ { NULL,"	* anciennement dénommé « index »"},
/* 0085 */ { NULL,"	= À LA LIGNE\n"
	"	= ligne suivante"},
/* 0086 */ { NULL,"	= DÉBUT DE ZONE SÉLECTIONNÉE"},
/* 0087 */ { NULL,"	= FIN DE ZONE SÉLECTIONNÉE"},
/* 0088 */ { NULL,"	= TAQUET DE TABULATEUR HORIZONTAL\n"
	"	= arrêt de tabulateur horizontal"},
/* 0089 */ { NULL,"	= TABULATEUR HORIZONTAL AVEC JUSTIFICATION"},
/* 008A */ { NULL,"	= TAQUET DE TABULATEUR VERTICAL\n"
	"	= arrêt de tabulateur vertical"},
/* 008B */ { NULL,"	= INTERLIGNE PARTIEL VERS LE BAS\n"
	"	= interligne partiel avant"},
/* 008C */ { NULL,"	= INTERLIGNE PARTIEL VERS LE HAUT\n"
	"	= interligne partiel arrière"},
/* 008D */ { NULL,"	= INDEX RENVERSÉ\n"
	"	= interligne inversé"},
/* 008E */ { NULL,"	= REMPLACEMENT UNIQUE DEUX"},
/* 008F */ { NULL,"	= REMPLACEMENT UNIQUE TROIS"},
/* 0090 */ { NULL,"	= CHAÎNE DE COMMANDE D'APPAREILS"},
/* 0091 */ { NULL,"	= USAGE PRIVÉ UN"},
/* 0092 */ { NULL,"	= USAGE PRIVÉ DEUX"},
/* 0093 */ { NULL,"	= MISE EN MODE TRANSMISSION"},
/* 0094 */ { NULL,"	= ANNULATION DU CARACTÈRE PRÉCÉDENT"},
/* 0095 */ { NULL,"	= MESSAGE EN ATTENTE"},
/* 0096 */ { NULL,"	= DÉBUT DE ZONE PROTÉGÉE"},
/* 0097 */ { NULL,"	= FIN DE ZONE PROTÉGÉE"},
/* 0098 */ { NULL,"	= DÉBUT DE CHAÎNE"},
/* 0099 */ { NULL,"	= introducteur de caractère graphique unique"},
/* 009A */ { NULL,"	= INTRODUCTEUR DE CARACTÈRE UNIQUE"},
/* 009B */ { NULL,"	= INTRODUCTEUR DE SÉQUENCE DE COMMANDES"},
/* 009C */ { NULL,"	= FIN DE CHAÎNE"},
/* 009D */ { NULL,"	= COMMANDE DE SYSTÈME D'EXPLOITATION"},
/* 009E */ { NULL,"	= MESSAGE PRIVÉ"},
/* 009F */ { NULL,"	= COMMANDE DE PROGICIEL"},
/* 00A0 */ { "ESPACE INSÉCABLE","	= espace imposée, espace sans coupure, espace liante\n"
	"	* communément abrégée NBSP (no-break space)\n"
	"	x (espace - 0020)\n"
	"	x (espace tabulaire - 2007)\n"
	"	x (espace insécable étroite - 202F)\n"
	"	x (gluon de mots - 2060)\n"
	"	x (indicateur d'ordre des octets - FEFF)\n"
	"	# <insécable> 0020"},
/* 00A1 */ { "POINT D'EXCLAMATION RENVERSÉ","	= point d'exclamation inversé\n"
	"	* castillan, asturien, galicien\n"
	"	x (point d'exclamation - 0021)"},
/* 00A2 */ { "SYMBOLE CENTIME","	= symbole cent américain"},
/* 00A3 */ { "SYMBOLE LIVRE","	= livre sterling, punt irlandaise, livre tournoi, lire italienne, lire turque, etc.\n"
	"	x (symbole lire - 20A4)\n"
	"	x (symbole lire turque - 20BA)\n"
	"	x (symbole romain demi-once - 10192)"},
/* 00A4 */ { "SYMBOLE MONÉTAIRE","	* d'autres caractères de symboles monétaires sont codés dans l'intervalle 20A0-20BF\n"
	"	x (symbole dollar - 0024)"},
/* 00A5 */ { "SYMBOLE YEN","	= symbole yuan\n"
	"	* le glyphe peut comporter une ou deux barres transversales, mais le symbole officiel au Japon et en Chine en comporte deux"},
/* 00A6 */ { "BARRE BRISÉE","	= barre verticale brisée (1.0)\n"
	"	= barre discontinue, barre déjointe, barre à trou"},
/* 00A7 */ { "PARAGRAPHE","	= alinéa"},
/* 00A8 */ { "TRÉMA","	* ce caractère chasse\n"
	"	x (diacritique tréma - 0308)\n"
	"	# 0020 0308"},
/* 00A9 */ { "SYMBOLE COPYRIGHT","	= mention de réserve\n"
	"	x (copyright de phonogramme - 2117)\n"
	"	x (lettre majuscule latine c cerclée - 24B8)"},
/* 00AA */ { "INDICATEUR ORDINAL FÉMININ","	* castillan\n"
	"	# <exp> 0061"},
/* 00AB */ { "GUILLEMET GAUCHE","	= guillemet chevron pointant vers la gauche\n"
	"	* habituellement ouvrant, mais dans certaines langues fermant\n"
	"	x (très inférieur à - 226A)\n"
	"	x (double chevron gauche - 300A)"},
/* 00AC */ { "SIGNE NÉGATION","	= symbole non\n"
	"	x (signe négation réfléchi - 2310)"},
/* 00AD */ { "TRAIT D'UNION CONDITIONNEL","	= trait d'union virtuel\n"
	"	* communément abrégé SHY (soft hyphen)"},
/* 00AE */ { "SYMBOLE MARQUE DÉPOSÉE","	x (lettre majuscule latine r cerclée - 24C7)"},
/* 00AF */ { "MACRON","	= barre supérieure APL\n"
	"	* ce caractère chasse\n"
	"	x (lettre modificative macron - 02C9)\n"
	"	x (diacritique macron - 0304)\n"
	"	x (diacritique tiret haut - 0305)\n"
	"	# 0020 0304"},
/* 00B0 */ { "SYMBOLE DEGRÉ","	* ce caractère chasse\n"
	"	x (rond en chef - 02DA)\n"
	"	x (diacritique rond en chef - 030A)\n"
	"	x (exposant zéro - 2070)\n"
	"	x (opérateur rond - 2218)"},
/* 00B1 */ { "SIGNE PLUS-OU-MOINS","	x (signe moins-ou-plus - 2213)"},
/* 00B2 */ { "EXPOSANT DEUX","	= au carré\n"
	"	* autres exposants : 2070-2079\n"
	"	x (exposant un - 00B9)\n"
	"	# <exp> 0032"},
/* 00B3 */ { "EXPOSANT TROIS","	= cube\n"
	"	x (exposant un - 00B9)\n"
	"	# <exp> 0033"},
/* 00B4 */ { "ACCENT AIGU","	* ce caractère chasse\n"
	"	x (lettre modificative prime - 02B9)\n"
	"	x (lettre modificative accent aigu - 02CA)\n"
	"	x (diacritique accent aigu - 0301)\n"
	"	x (prime - 2032)\n"
	"	# 0020 0301"},
/* 00B5 */ { "SYMBOLE MICRO","	# 03BC lettre minuscule grecque mu"},
/* 00B6 */ { "PIED-DE-MOUCHE","	= fin de paragraphe\n"
	"	* signe de paragraphe dans certains pays d'Europe\n"
	"	x (pied-de-mouche réfléchi - 204B)\n"
	"	x (pied-de-mouche de fantaisie à jambage courbé - 2761)\n"
	"	x (capitule - 2E3F)"},
/* 00B7 */ { "POINT MÉDIAN","	= point central, point au milieu\n"
	"	= virgule géorgienne\n"
	"	= point médian grec (ano teleia)\n"
	"	* également utilisé comme point décimal élevé ou pour indiquer la multiplication ; 22C5 est recommandé pour la multiplication\n"
	"	x (ano teleia grec - 0387)\n"
	"	x (ponctuation runique simple - 16EB)\n"
	"	x (puce - 2022)\n"
	"	x (point de conduite simple - 2024)\n"
	"	x (point de coupure de mot - 2027)\n"
	"	x (opérateur puce - 2219)\n"
	"	x (opérateur point - 22C5)\n"
	"	x (point médian séparateur de mots - 2E31)\n"
	"	x (point élevé - 2E33)\n"
	"	x (point médian katakana - 30FB)\n"
	"	x (lettre latine point sinologique - A78F)"},
/* 00B8 */ { "CÉDILLE","	* ce caractère chasse\n"
	"	* autres diacritiques avec chasse : 02D8-02DB\n"
	"	x (diacritique cédille - 0327)\n"
	"	# 0020 0327"},
/* 00B9 */ { "EXPOSANT UN","	x (exposant deux - 00B2)\n"
	"	x (exposant trois - 00B3)\n"
	"	# <exp> 0031"},
/* 00BA */ { "INDICATEUR ORDINAL MASCULIN","	* castillan\n"
	"	# <exp> 006F"},
/* 00BB */ { "GUILLEMET DROIT","	= guillemet chevron pointant vers la droite\n"
	"	* habituellement fermant, mais dans certaines langues ouvrant\n"
	"	x (très supérieur à - 226B)\n"
	"	x (double chevron droit - 300B)"},
/* 00BC */ { "FRACTION ORDINAIRE UN QUART","	# <fraction> 0031 2044 0034"},
/* 00BD */ { "FRACTION ORDINAIRE UN DEMI","	# <fraction> 0031 2044 0032"},
/* 00BE */ { "FRACTION ORDINAIRE TROIS QUARTS","	# <fraction> 0033 2044 0034"},
/* 00BF */ { "POINT D'INTERROGATION RENVERSÉ","	= point d'interrogation inversé\n"
	"	* castillan\n"
	"	x (point d'interrogation - 003F)\n"
	"	x (point d'interrogation réfléchi - 2E2E)"},
/* 00C0 */ { "LETTRE MAJUSCULE LATINE A ACCENT GRAVE","	: 0041 0300"},
/* 00C1 */ { "LETTRE MAJUSCULE LATINE A ACCENT AIGU","	: 0041 0301"},
/* 00C2 */ { "LETTRE MAJUSCULE LATINE A ACCENT CIRCONFLEXE","	: 0041 0302"},
/* 00C3 */ { "LETTRE MAJUSCULE LATINE A TILDE","	: 0041 0303"},
/* 00C4 */ { "LETTRE MAJUSCULE LATINE A TRÉMA","	: 0041 0308"},
/* 00C5 */ { "LETTRE MAJUSCULE LATINE A ROND EN CHEF","	x (symbole angström - 212B)\n"
	"	: 0041 030A"},
/* 00C6 */ { "LETTRE MAJUSCULE LATINE AE","	= digramme soudé ae majuscule, ash majuscule (du vieil anglais æsc)\n"
	"	= e dans l'a majuscule"},
/* 00C7 */ { "LETTRE MAJUSCULE LATINE C CÉDILLE","	: 0043 0327"},
/* 00C8 */ { "LETTRE MAJUSCULE LATINE E ACCENT GRAVE","	: 0045 0300"},
/* 00C9 */ { "LETTRE MAJUSCULE LATINE E ACCENT AIGU","	: 0045 0301"},
/* 00CA */ { "LETTRE MAJUSCULE LATINE E ACCENT CIRCONFLEXE","	: 0045 0302"},
/* 00CB */ { "LETTRE MAJUSCULE LATINE E TRÉMA","	: 0045 0308"},
/* 00CC */ { "LETTRE MAJUSCULE LATINE I ACCENT GRAVE","	: 0049 0300"},
/* 00CD */ { "LETTRE MAJUSCULE LATINE I ACCENT AIGU","	: 0049 0301"},
/* 00CE */ { "LETTRE MAJUSCULE LATINE I ACCENT CIRCONFLEXE","	: 0049 0302"},
/* 00CF */ { "LETTRE MAJUSCULE LATINE I TRÉMA","	: 0049 0308"},
/* 00D0 */ { "LETTRE MAJUSCULE LATINE ED","	= eth majuscule\n"
	"	* islandais\n"
	"	* la minuscule est 00F0\n"
	"	x (lettre majuscule latine d barré - 0110)\n"
	"	x (lettre majuscule latine d africain - 0189)"},
/* 00D1 */ { "LETTRE MAJUSCULE LATINE N TILDE","	: 004E 0303"},
/* 00D2 */ { "LETTRE MAJUSCULE LATINE O ACCENT GRAVE","	: 004F 0300"},
/* 00D3 */ { "LETTRE MAJUSCULE LATINE O ACCENT AIGU","	: 004F 0301"},
/* 00D4 */ { "LETTRE MAJUSCULE LATINE O ACCENT CIRCONFLEXE","	: 004F 0302"},
/* 00D5 */ { "LETTRE MAJUSCULE LATINE O TILDE","	: 004F 0303"},
/* 00D6 */ { "LETTRE MAJUSCULE LATINE O TRÉMA","	: 004F 0308"},
/* 00D7 */ { "SIGNE DE MULTIPLICATION","	= produit cartésien en notation z\n"
	"	x (signe en forme de croix - 274C)"},
/* 00D8 */ { "LETTRE MAJUSCULE LATINE O BARRÉ OBLIQUEMENT","	= o coticé\n"
	"	x (ensemble vide - 2205)"},
/* 00D9 */ { "LETTRE MAJUSCULE LATINE U ACCENT GRAVE","	: 0055 0300"},
/* 00DA */ { "LETTRE MAJUSCULE LATINE U ACCENT AIGU","	: 0055 0301"},
/* 00DB */ { "LETTRE MAJUSCULE LATINE U ACCENT CIRCONFLEXE","	: 0055 0302"},
/* 00DC */ { "LETTRE MAJUSCULE LATINE U TRÉMA","	: 0055 0308"},
/* 00DD */ { "LETTRE MAJUSCULE LATINE Y ACCENT AIGU","	: 0059 0301"},
/* 00DE */ { "LETTRE MAJUSCULE LATINE THORN","	* islandais"},
/* 00DF */ { "LETTRE MINUSCULE LATINE S DUR","	= eszett, s dur allemand\n"
	"	* allemand\n"
	"	* la majuscule est « SS »\n"
	"	* la majuscule non conventionnelle est 1E9E\n"
	"	* typographiquement, le glyphe de ce caractère peut reposer sur une ligature de 017F avec 0073 ou avec un glyphe de style ancien pour 007A (semblable en apparence à 0292). Les deux formes existent de façon interchangeable aujourd'hui.\n"
	"	x (lettre minuscule grecque bêta - 03B2)"},
/* 00E0 */ { "LETTRE MINUSCULE LATINE A ACCENT GRAVE","	: 0061 0300"},
/* 00E1 */ { "LETTRE MINUSCULE LATINE A ACCENT AIGU","	: 0061 0301"},
/* 00E2 */ { "LETTRE MINUSCULE LATINE A ACCENT CIRCONFLEXE","	: 0061 0302"},
/* 00E3 */ { "LETTRE MINUSCULE LATINE A TILDE","	* portugais\n"
	"	: 0061 0303"},
/* 00E4 */ { "LETTRE MINUSCULE LATINE A TRÉMA","	: 0061 0308"},
/* 00E5 */ { "LETTRE MINUSCULE LATINE A ROND EN CHEF","	* danois, norvégien, suédois, wallon\n"
	"	: 0061 030A"},
/* 00E6 */ { "LETTRE MINUSCULE LATINE AE","	= digramme soudé ae minuscule, ash minuscule (du vieil anglais æsc)\n"
	"	= e dans l'a minuscule\n"
	"	* danois, norvégien, islandais, féroïen, vieil anglais, français, API\n"
	"	x (digramme soudé minuscule latin oe - 0153)\n"
	"	x (ligature minuscule cyrillique a ié - 04D5)"},
/* 00E7 */ { "LETTRE MINUSCULE LATINE C CÉDILLE","	: 0063 0327"},
/* 00E8 */ { "LETTRE MINUSCULE LATINE E ACCENT GRAVE","	: 0065 0300"},
/* 00E9 */ { "LETTRE MINUSCULE LATINE E ACCENT AIGU","	: 0065 0301"},
/* 00EA */ { "LETTRE MINUSCULE LATINE E ACCENT CIRCONFLEXE","	: 0065 0302"},
/* 00EB */ { "LETTRE MINUSCULE LATINE E TRÉMA","	: 0065 0308"},
/* 00EC */ { "LETTRE MINUSCULE LATINE I ACCENT GRAVE","	* italien, malgache\n"
	"	: 0069 0300"},
/* 00ED */ { "LETTRE MINUSCULE LATINE I ACCENT AIGU","	: 0069 0301"},
/* 00EE */ { "LETTRE MINUSCULE LATINE I ACCENT CIRCONFLEXE","	: 0069 0302"},
/* 00EF */ { "LETTRE MINUSCULE LATINE I TRÉMA","	: 0069 0308"},
/* 00F0 */ { "LETTRE MINUSCULE LATINE ED","	= eth minuscule\n"
	"	* islandais, féroïen, vieil anglais, API\n"
	"	* la majuscule est 00D0\n"
	"	x (lettre minuscule grecque delta - 03B4)\n"
	"	x (dérivée partielle - 2202)"},
/* 00F1 */ { "LETTRE MINUSCULE LATINE N TILDE","	: 006E 0303"},
/* 00F2 */ { "LETTRE MINUSCULE LATINE O ACCENT GRAVE","	: 006F 0300"},
/* 00F3 */ { "LETTRE MINUSCULE LATINE O ACCENT AIGU","	: 006F 0301"},
/* 00F4 */ { "LETTRE MINUSCULE LATINE O ACCENT CIRCONFLEXE","	: 006F 0302"},
/* 00F5 */ { "LETTRE MINUSCULE LATINE O TILDE","	* portugais, estonien\n"
	"	: 006F 0303"},
/* 00F6 */ { "LETTRE MINUSCULE LATINE O TRÉMA","	: 006F 0308"},
/* 00F7 */ { "SIGNE DE DIVISION","	* occasionnellement utilisé comme une variante, visuellement plus distincte dans certains contextes, de 2212 ou de 2011\n"
	"	* autrefois utilisé comme un signe de ponctuation pour indiquer des passages douteux dans les manuscrits\n"
	"	x (obèle syriaque héracléen - 070B)\n"
	"	x (signe moins commercial - 2052)\n"
	"	x (signe moins - 2212)\n"
	"	x (barre oblique de division - 2215)\n"
	"	x (est un diviseur de - 2223)\n"
	"	x (rapport - 2236)\n"
	"	x (signe de division épais - 2797)"},
/* 00F8 */ { "LETTRE MINUSCULE LATINE O BARRÉ OBLIQUEMENT","	= o coticé\n"
	"	* danois, norvégien, féroïen, API"},
/* 00F9 */ { "LETTRE MINUSCULE LATINE U ACCENT GRAVE","	* français, italien\n"
	"	: 0075 0300"},
/* 00FA */ { "LETTRE MINUSCULE LATINE U ACCENT AIGU","	: 0075 0301"},
/* 00FB */ { "LETTRE MINUSCULE LATINE U ACCENT CIRCONFLEXE","	: 0075 0302"},
/* 00FC */ { "LETTRE MINUSCULE LATINE U TRÉMA","	: 0075 0308"},
/* 00FD */ { "LETTRE MINUSCULE LATINE Y ACCENT AIGU","	* tchèque, slovaque, islandais, féroïen, gallois, malgache\n"
	"	: 0079 0301"},
/* 00FE */ { "LETTRE MINUSCULE LATINE THORN","	* islandais, vieil anglais, phonétique\n"
	"	* lettre runique empruntée à l'écriture latine\n"
	"	x (lettre runique thurisaz thorn thurs th - 16A6)"},
/* 00FF */ { "LETTRE MINUSCULE LATINE Y TRÉMA","	* français, orthographe hongroise médiévale\n"
	"	* la majuscule est 0178\n"
	"	: 0079 0308"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_01[] = {
/* 0100 */ { "LETTRE MAJUSCULE LATINE A MACRON","	: 0041 0304"},
/* 0101 */ { "LETTRE MINUSCULE LATINE A MACRON","	* letton, latin, etc.\n"
	"	: 0061 0304"},
/* 0102 */ { "LETTRE MAJUSCULE LATINE A BRÈVE","	: 0041 0306"},
/* 0103 */ { "LETTRE MINUSCULE LATINE A BRÈVE","	* roumain, vietnamien, latin, etc.\n"
	"	: 0061 0306"},
/* 0104 */ { "LETTRE MAJUSCULE LATINE A OGONEK","	: 0041 0328"},
/* 0105 */ { "LETTRE MINUSCULE LATINE A OGONEK","	* polonais, lituanien, etc.\n"
	"	: 0061 0328"},
/* 0106 */ { "LETTRE MAJUSCULE LATINE C ACCENT AIGU","	: 0043 0301"},
/* 0107 */ { "LETTRE MINUSCULE LATINE C ACCENT AIGU","	* polonais, croate, etc.\n"
	"	x (lettre minuscule cyrillique tié - 045B)\n"
	"	: 0063 0301"},
/* 0108 */ { "LETTRE MAJUSCULE LATINE C ACCENT CIRCONFLEXE","	: 0043 0302"},
/* 0109 */ { "LETTRE MINUSCULE LATINE C ACCENT CIRCONFLEXE","	* espéranto\n"
	"	: 0063 0302"},
/* 010A */ { "LETTRE MAJUSCULE LATINE C POINT EN CHEF","	: 0043 0307"},
/* 010B */ { "LETTRE MINUSCULE LATINE C POINT EN CHEF","	* maltais, gaélique irlandais (ancienne orthographe)\n"
	"	: 0063 0307"},
/* 010C */ { "LETTRE MAJUSCULE LATINE C CARON","	: 0043 030C"},
/* 010D */ { "LETTRE MINUSCULE LATINE C CARON","	= c chevron, c accent hirondelle\n"
	"	* tchèque, slovaque, slovène et de nombreuses autres langues\n"
	"	: 0063 030C"},
/* 010E */ { "LETTRE MAJUSCULE LATINE D CARON","	= d chevron, d accent hirondelle\n"
	"	* on préfère la forme avec un caron dans tous les contextes\n"
	"	: 0044 030C"},
/* 010F */ { "LETTRE MINUSCULE LATINE D CARON","	* tchèque, slovaque\n"
	"	* pour la composition, on recommande la forme avec l'apostrophe\n"
	"	: 0064 030C"},
/* 0110 */ { "LETTRE MAJUSCULE LATINE D BARRÉ","	x (lettre majuscule latine ed - 00D0)\n"
	"	x (lettre minuscule latine d barré - 0111)\n"
	"	x (lettre majuscule latine d africain - 0189)"},
/* 0111 */ { "LETTRE MINUSCULE LATINE D BARRÉ","	* croate, vietnamien, same\n"
	"	* les américanistes utilisent une variante de glyphe avec une barre traversant la panse\n"
	"	x (lettre majuscule latine d barré - 0110)\n"
	"	x (lettre minuscule cyrillique djé - 0452)"},
/* 0112 */ { "LETTRE MAJUSCULE LATINE E MACRON","	: 0045 0304"},
/* 0113 */ { "LETTRE MINUSCULE LATINE E MACRON","	* letton, latin, etc.\n"
	"	: 0065 0304"},
/* 0114 */ { "LETTRE MAJUSCULE LATINE E BRÈVE","	: 0045 0306"},
/* 0115 */ { "LETTRE MINUSCULE LATINE E BRÈVE","	* letton, latin, etc.\n"
	"	: 0065 0306"},
/* 0116 */ { "LETTRE MAJUSCULE LATINE E POINT EN CHEF","	: 0045 0307"},
/* 0117 */ { "LETTRE MINUSCULE LATINE E POINT EN CHEF","	* lituanien\n"
	"	: 0065 0307"},
/* 0118 */ { "LETTRE MAJUSCULE LATINE E OGONEK","	: 0045 0328"},
/* 0119 */ { "LETTRE MINUSCULE LATINE E OGONEK","	* polonais, lituanien, etc.\n"
	"	: 0065 0328"},
/* 011A */ { "LETTRE MAJUSCULE LATINE E CARON","	: 0045 030C"},
/* 011B */ { "LETTRE MINUSCULE LATINE E CARON","	= e chevron\n"
	"	* tchèque, sorabe, etc.\n"
	"	: 0065 030C"},
/* 011C */ { "LETTRE MAJUSCULE LATINE G ACCENT CIRCONFLEXE","	: 0047 0302"},
/* 011D */ { "LETTRE MINUSCULE LATINE G ACCENT CIRCONFLEXE","	* espéranto\n"
	"	: 0067 0302"},
/* 011E */ { "LETTRE MAJUSCULE LATINE G BRÈVE","	: 0047 0306"},
/* 011F */ { "LETTRE MINUSCULE LATINE G BRÈVE","	* turc, azéri\n"
	"	x (lettre minuscule latine g caron - 01E7)\n"
	"	: 0067 0306"},
/* 0120 */ { "LETTRE MAJUSCULE LATINE G POINT EN CHEF","	: 0047 0307"},
/* 0121 */ { "LETTRE MINUSCULE LATINE G POINT EN CHEF","	* maltais, gaélique irlandais (ancienne orthographe)\n"
	"	: 0067 0307"},
/* 0122 */ { "LETTRE MAJUSCULE LATINE G CÉDILLE","	: 0047 0327"},
/* 0123 */ { "LETTRE MINUSCULE LATINE G CÉDILLE","	* letton\n"
	"	* il existe trois variantes principales de glyphe\n"
	"	: 0067 0327"},
/* 0124 */ { "LETTRE MAJUSCULE LATINE H ACCENT CIRCONFLEXE","	* la minuscule est 0266 en nawdm (ou losso)\n"
	"	: 0048 0302"},
/* 0125 */ { "LETTRE MINUSCULE LATINE H ACCENT CIRCONFLEXE","	* espéranto\n"
	"	: 0068 0302"},
/* 0126 */ { "LETTRE MAJUSCULE LATINE H BARRÉ",NULL},
/* 0127 */ { "LETTRE MINUSCULE LATINE H BARRÉ","	* maltais, API, etc.\n"
	"	x (lettre minuscule cyrillique tié - 045B)\n"
	"	x (constante de planck sur deux pi - 210F)"},
/* 0128 */ { "LETTRE MAJUSCULE LATINE I TILDE","	: 0049 0303"},
/* 0129 */ { "LETTRE MINUSCULE LATINE I TILDE","	* groenlandais (ancienne orthographe)\n"
	"	: 0069 0303"},
/* 012A */ { "LETTRE MAJUSCULE LATINE I MACRON","	: 0049 0304"},
/* 012B */ { "LETTRE MINUSCULE LATINE I MACRON","	* letton, latin, etc.\n"
	"	: 0069 0304"},
/* 012C */ { "LETTRE MAJUSCULE LATINE I BRÈVE","	: 0049 0306"},
/* 012D */ { "LETTRE MINUSCULE LATINE I BRÈVE","	* latin, etc.\n"
	"	: 0069 0306"},
/* 012E */ { "LETTRE MAJUSCULE LATINE I OGONEK","	: 0049 0328"},
/* 012F */ { "LETTRE MINUSCULE LATINE I OGONEK","	* lituanien, etc.\n"
	"	: 0069 0328"},
/* 0130 */ { "LETTRE MAJUSCULE LATINE I POINT EN CHEF","	= i point\n"
	"	* turc, azéri\n"
	"	* la minuscule est 0069\n"
	"	x (lettre majuscule latine i - 0049)\n"
	"	: 0049 0307"},
/* 0131 */ { "LETTRE MINUSCULE LATINE I SANS POINT","	* turc, azéri\n"
	"	* la majuscule est 0049\n"
	"	x (lettre minuscule latine i - 0069)"},
/* 0132 */ { "DIGRAMME SOUDÉ MAJUSCULE LATIN IJ","	# 0049 004A"},
/* 0133 */ { "DIGRAMME SOUDÉ MINUSCULE LATIN IJ","	= ligature ij\n"
	"	* néerlandais\n"
	"	# 0069 006A"},
/* 0134 */ { "LETTRE MAJUSCULE LATINE J ACCENT CIRCONFLEXE","	: 004A 0302"},
/* 0135 */ { "LETTRE MINUSCULE LATINE J ACCENT CIRCONFLEXE","	* espéranto\n"
	"	: 006A 0302"},
/* 0136 */ { "LETTRE MAJUSCULE LATINE K CÉDILLE","	: 004B 0327"},
/* 0137 */ { "LETTRE MINUSCULE LATINE K CÉDILLE","	* letton\n"
	"	: 006B 0327"},
/* 0138 */ { "LETTRE MINUSCULE LATINE KRA","	* groenlandais (ancienne orthographe)"},
/* 0139 */ { "LETTRE MAJUSCULE LATINE L ACCENT AIGU","	: 004C 0301"},
/* 013A */ { "LETTRE MINUSCULE LATINE L ACCENT AIGU","	* slovaque\n"
	"	: 006C 0301"},
/* 013B */ { "LETTRE MAJUSCULE LATINE L CÉDILLE","	: 004C 0327"},
/* 013C */ { "LETTRE MINUSCULE LATINE L CÉDILLE","	* letton\n"
	"	: 006C 0327"},
/* 013D */ { "LETTRE MAJUSCULE LATINE L CARON","	* pour la composition, on recommande la forme avec l'apostrophe\n"
	"	: 004C 030C"},
/* 013E */ { "LETTRE MINUSCULE LATINE L CARON","	* slovaque\n"
	"	* pour la composition, on recommande la forme avec l'apostrophe\n"
	"	: 006C 030C"},
/* 013F */ { "LETTRE MAJUSCULE LATINE L POINT MÉDIAN","	* certaines polices affichent le point médian à l'intérieur du L, mais la forme avec le point qui suit le L est recommandée\n"
	"	# 004C 00B7"},
/* 0140 */ { "LETTRE MINUSCULE LATINE L POINT MÉDIAN","	# 006C 00B7\n"
	"	* caractère de compatibilité catalan pour ISO/CEI 6937\n"
	"	* la représentation recommandée pour le catalan est : 006C 00B7"},
/* 0141 */ { "LETTRE MAJUSCULE LATINE L BARRÉ","	x (lettre majuscule latine l rayé - 023D)"},
/* 0142 */ { "LETTRE MINUSCULE LATINE L BARRÉ","	* polonais, etc.\n"
	"	x (lettre minuscule latine l rayé - 019A)"},
/* 0143 */ { "LETTRE MAJUSCULE LATINE N ACCENT AIGU","	: 004E 0301"},
/* 0144 */ { "LETTRE MINUSCULE LATINE N ACCENT AIGU","	* polonais, etc.\n"
	"	: 006E 0301"},
/* 0145 */ { "LETTRE MAJUSCULE LATINE N CÉDILLE","	: 004E 0327"},
/* 0146 */ { "LETTRE MINUSCULE LATINE N CÉDILLE","	* letton\n"
	"	: 006E 0327"},
/* 0147 */ { "LETTRE MAJUSCULE LATINE N CARON","	: 004E 030C"},
/* 0148 */ { "LETTRE MINUSCULE LATINE N CARON","	* tchèque, slovaque\n"
	"	: 006E 030C"},
/* 0149 */ { "LETTRE MINUSCULE LATINE N PRÉCÉDÉE D'UNE APOSTROPHE","	= lettre minuscule apostrophe n (1.0)\n"
	"	* ce caractère est obsolète et son utilisation est fortement déconseillée\n"
	"	* afrikaans\n"
	"	* il ne s'agit pas en fait d'une lettre unique, mais d'une forme typographique courante de l'article indéfini\n"
	"	# 02BC 006E\n"
	"	* caractère de compatibilité pour ISO/CEI 6937\n"
	"	* la majuscule est 02BC 004E"},
/* 014A */ { "LETTRE MAJUSCULE LATINE ENG","	* same\n"
	"	* le glyphe peut aussi avoir l'apparence d'une grande minuscule"},
/* 014B */ { "LETTRE MINUSCULE LATINE ENG","	* same, mendé, API, etc."},
/* 014C */ { "LETTRE MAJUSCULE LATINE O MACRON","	: 004F 0304"},
/* 014D */ { "LETTRE MINUSCULE LATINE O MACRON","	* letton, latin, etc.\n"
	"	: 006F 0304"},
/* 014E */ { "LETTRE MAJUSCULE LATINE O BRÈVE","	: 004F 0306"},
/* 014F */ { "LETTRE MINUSCULE LATINE O BRÈVE","	* latin\n"
	"	: 006F 0306"},
/* 0150 */ { "LETTRE MAJUSCULE LATINE O DOUBLE ACCENT AIGU","	: 004F 030B"},
/* 0151 */ { "LETTRE MINUSCULE LATINE O DOUBLE ACCENT AIGU","	* hongrois\n"
	"	: 006F 030B"},
/* 0152 */ { "DIGRAMME SOUDÉ MAJUSCULE LATIN OE",NULL},
/* 0153 */ { "DIGRAMME SOUDÉ MINUSCULE LATIN OE","	= ligature oe, e dans l'o\n"
	"	= ethel (du vieil anglais eðel)\n"
	"	* français, API, vieil islandais, vieil anglais, etc.\n"
	"	x (lettre minuscule latine ae - 00E6)\n"
	"	x (lettre latine petite capitale oe - 0276)"},
/* 0154 */ { "LETTRE MAJUSCULE LATINE R ACCENT AIGU","	: 0052 0301"},
/* 0155 */ { "LETTRE MINUSCULE LATINE R ACCENT AIGU","	* slovaque, etc.\n"
	"	: 0072 0301"},
/* 0156 */ { "LETTRE MAJUSCULE LATINE R CÉDILLE","	: 0052 0327"},
/* 0157 */ { "LETTRE MINUSCULE LATINE R CÉDILLE","	* live\n"
	"	: 0072 0327"},
/* 0158 */ { "LETTRE MAJUSCULE LATINE R CARON","	: 0052 030C"},
/* 0159 */ { "LETTRE MINUSCULE LATINE R CARON","	* tchèque, sorabe, etc.\n"
	"	: 0072 030C"},
/* 015A */ { "LETTRE MAJUSCULE LATINE S ACCENT AIGU","	: 0053 0301"},
/* 015B */ { "LETTRE MINUSCULE LATINE S ACCENT AIGU","	* polonais, translittération du sanskrit, etc.\n"
	"	: 0073 0301"},
/* 015C */ { "LETTRE MAJUSCULE LATINE S ACCENT CIRCONFLEXE","	: 0053 0302"},
/* 015D */ { "LETTRE MINUSCULE LATINE S ACCENT CIRCONFLEXE","	* espéranto\n"
	"	: 0073 0302"},
/* 015E */ { "LETTRE MAJUSCULE LATINE S CÉDILLE","	: 0053 0327"},
/* 015F */ { "LETTRE MINUSCULE LATINE S CÉDILLE","	* turc, azéri, roumain, etc.\n"
	"	* le caractère 0219 doit être utilisé pour le roumain\n"
	"	x (lettre minuscule latine s virgule souscrite - 0219)\n"
	"	: 0073 0327"},
/* 0160 */ { "LETTRE MAJUSCULE LATINE S CARON","	: 0053 030C"},
/* 0161 */ { "LETTRE MINUSCULE LATINE S CARON","	= s chevron\n"
	"	* tchèque, estonien, finnois, slovaque et de nombreuses autres langues\n"
	"	: 0073 030C"},
/* 0162 */ { "LETTRE MAJUSCULE LATINE T CÉDILLE","	: 0054 0327"},
/* 0163 */ { "LETTRE MINUSCULE LATINE T CÉDILLE","	* translittération des langues sémitiques, etc.\n"
	"	* le caractère 021B doit être utilisé pour le roumain\n"
	"	x (lettre minuscule latine t virgule souscrite - 021B)\n"
	"	: 0074 0327"},
/* 0164 */ { "LETTRE MAJUSCULE LATINE T CARON","	= t chevron\n"
	"	* on préfère la forme avec un caron dans tous les contextes\n"
	"	: 0054 030C"},
/* 0165 */ { "LETTRE MINUSCULE LATINE T CARON","	* tchèque, slovaque\n"
	"	* pour la composition, on recommande la forme avec l'apostrophe\n"
	"	: 0074 030C"},
/* 0166 */ { "LETTRE MAJUSCULE LATINE T BARRÉ",NULL},
/* 0167 */ { "LETTRE MINUSCULE LATINE T BARRÉ","	* same"},
/* 0168 */ { "LETTRE MAJUSCULE LATINE U TILDE","	: 0055 0303"},
/* 0169 */ { "LETTRE MINUSCULE LATINE U TILDE","	* groenlandais (ancienne orthographe)\n"
	"	: 0075 0303"},
/* 016A */ { "LETTRE MAJUSCULE LATINE U MACRON","	: 0055 0304"},
/* 016B */ { "LETTRE MINUSCULE LATINE U MACRON","	* letton, lituanien, latin, etc.\n"
	"	: 0075 0304"},
/* 016C */ { "LETTRE MAJUSCULE LATINE U BRÈVE","	: 0055 0306"},
/* 016D */ { "LETTRE MINUSCULE LATINE U BRÈVE","	* latin, espéranto, etc.\n"
	"	: 0075 0306"},
/* 016E */ { "LETTRE MAJUSCULE LATINE U ROND EN CHEF","	: 0055 030A"},
/* 016F */ { "LETTRE MINUSCULE LATINE U ROND EN CHEF","	* tchèque, sorabe, etc.\n"
	"	: 0075 030A"},
/* 0170 */ { "LETTRE MAJUSCULE LATINE U DOUBLE ACCENT AIGU","	: 0055 030B"},
/* 0171 */ { "LETTRE MINUSCULE LATINE U DOUBLE ACCENT AIGU","	* hongrois\n"
	"	: 0075 030B"},
/* 0172 */ { "LETTRE MAJUSCULE LATINE U OGONEK","	: 0055 0328"},
/* 0173 */ { "LETTRE MINUSCULE LATINE U OGONEK","	* lituanien\n"
	"	: 0075 0328"},
/* 0174 */ { "LETTRE MAJUSCULE LATINE W ACCENT CIRCONFLEXE","	: 0057 0302"},
/* 0175 */ { "LETTRE MINUSCULE LATINE W ACCENT CIRCONFLEXE","	* gallois\n"
	"	: 0077 0302"},
/* 0176 */ { "LETTRE MAJUSCULE LATINE Y ACCENT CIRCONFLEXE","	: 0059 0302"},
/* 0177 */ { "LETTRE MINUSCULE LATINE Y ACCENT CIRCONFLEXE","	* gallois\n"
	"	: 0079 0302"},
/* 0178 */ { "LETTRE MAJUSCULE LATINE Y TRÉMA","	* français, igbo\n"
	"	* la minuscule est 00FF\n"
	"	: 0059 0308"},
/* 0179 */ { "LETTRE MAJUSCULE LATINE Z ACCENT AIGU","	: 005A 0301"},
/* 017A */ { "LETTRE MINUSCULE LATINE Z ACCENT AIGU","	* polonais, etc.\n"
	"	: 007A 0301"},
/* 017B */ { "LETTRE MAJUSCULE LATINE Z POINT EN CHEF","	: 005A 0307"},
/* 017C */ { "LETTRE MINUSCULE LATINE Z POINT EN CHEF","	* polonais, etc.\n"
	"	: 007A 0307"},
/* 017D */ { "LETTRE MAJUSCULE LATINE Z CARON","	: 005A 030C"},
/* 017E */ { "LETTRE MINUSCULE LATINE Z CARON","	* tchèque, estonien, finnois, slovaque, slovène et de nombreuses autres langues\n"
	"	: 007A 030C"},
/* 017F */ { "LETTRE MINUSCULE LATINE S LONG","	* fréquemment utilisée avec les caractères romains et italiques jusqu'au XVIIIe siècle\n"
	"	* utilisée aujourd'hui avec les caractères gothiques et gaéliques\n"
	"	# 0073 lettre minuscule latine s"},
/* 0180 */ { "LETTRE MINUSCULE LATINE B BARRÉ","	* forme américaniste et indo-européaniste pour le bêta phonétique\n"
	"	* les américanistes utilisent une variante de glyphe avec une barre traversant la panse\n"
	"	* vieux saxon\n"
	"	* sa majuscule est 0243\n"
	"	x (lettre minuscule grecque bêta - 03B2)\n"
	"	x (symbole visuel pour l'espace - 2422)"},
/* 0181 */ { "LETTRE MAJUSCULE LATINE B CROSSE","	* zoulou, alphabet pan-nigérian\n"
	"	* la minuscule est 0253"},
/* 0182 */ { "LETTRE MAJUSCULE LATINE B POTENCE",NULL},
/* 0183 */ { "LETTRE MINUSCULE LATINE B POTENCE","	* ancienne graphie du tchouang (zhuang)\n"
	"	* écritures de langues minoritaires dans l'ancienne Union soviétique\n"
	"	x (lettre majuscule cyrillique bé - 0411)"},
/* 0184 */ { "LETTRE MAJUSCULE LATINE SIXIÈME TON",NULL},
/* 0185 */ { "LETTRE MINUSCULE LATINE SIXIÈME TON","	* ancienne graphie du tchouang (zhuang)\n"
	"	* le troisième ton tchouang correspond au cyrillique zé\n"
	"	* le quatrième ton tchouang correspond au cyrillique tché\n"
	"	x (lettre minuscule latine deuxième ton - 01A8)\n"
	"	x (lettre minuscule latine cinquième ton - 01BD)\n"
	"	x (lettre minuscule cyrillique zé - 0437)\n"
	"	x (lettre minuscule cyrillique tché - 0447)\n"
	"	x (lettre minuscule cyrillique signe mou - 044C)"},
/* 0186 */ { "LETTRE MAJUSCULE LATINE O OUVERT","	* typographiquement, un C réfléchi\n"
	"	* langues africaines\n"
	"	* la minuscule est 0254"},
/* 0187 */ { "LETTRE MAJUSCULE LATINE C CROSSE",NULL},
/* 0188 */ { "LETTRE MINUSCULE LATINE C CROSSE","	* langues africaines"},
/* 0189 */ { "LETTRE MAJUSCULE LATINE D AFRICAIN","	* éwé\n"
	"	* la minuscule est 0256\n"
	"	x (lettre majuscule latine ed - 00D0)\n"
	"	x (lettre majuscule latine d barré - 0110)"},
/* 018A */ { "LETTRE MAJUSCULE LATINE D CROSSE","	* alphabet pan-nigérian\n"
	"	* la minuscule est 0257"},
/* 018B */ { "LETTRE MAJUSCULE LATINE D POTENCE",NULL},
/* 018C */ { "LETTRE MINUSCULE LATINE D POTENCE","	* écritures de langues minoritaires dans l'ancienne Union soviétique\n"
	"	* ancienne graphie du tchouang (zhuang)"},
/* 018D */ { "LETTRE MINUSCULE LATINE DELTA CULBUTÉE","	= o crochet polonais réfléchi, o hameçon réfléchi\n"
	"	* symbole phonétique désuet de la fricative dentale labialisée\n"
	"	* orthographe recommandée : 007A 02B7 ou 007A 032B"},
/* 018E */ { "LETTRE MAJUSCULE LATINE E RÉFLÉCHI","	= e culbuté\n"
	"	* alphabet pan-nigérian\n"
	"	* la minuscule est 01DD"},
/* 018F */ { "LETTRE MAJUSCULE LATINE SCHWA","	* azéri, etc.\n"
	"	* la minuscule est 0259\n"
	"	x (lettre majuscule cyrillique schwa - 04D8)"},
/* 0190 */ { "LETTRE MAJUSCULE LATINE E OUVERT","	= epsilon\n"
	"	* langues africaines\n"
	"	* la minuscule est 025B\n"
	"	x (constante d'euler - 2107)\n"
	"	x (chiffre trois culbuté - 218B)"},
/* 0191 */ { "LETTRE MAJUSCULE LATINE F HAMEÇON","	* langues africaines\n"
	"	x (lettre majuscule latine f barré - A798)"},
/* 0192 */ { "LETTRE MINUSCULE LATINE F HAMEÇON","	= f cursif\n"
	"	= symbole monétaire du florin (Pays-Bas)\n"
	"	= symbole de fonction"},
/* 0193 */ { "LETTRE MAJUSCULE LATINE G CROSSE","	* langues africaines\n"
	"	* la minuscule est 0260"},
/* 0194 */ { "LETTRE MAJUSCULE LATINE GAMMA","	* langues africaines\n"
	"	* la minuscule est 0263"},
/* 0195 */ { "LETTRE MINUSCULE LATINE HV","	= hwair\n"
	"	* translittération du gotique\n"
	"	* la majuscule est 01F6"},
/* 0196 */ { "LETTRE MAJUSCULE LATINE IOTA","	* langues africaines\n"
	"	* la minuscule est 0269"},
/* 0197 */ { "LETTRE MAJUSCULE LATINE I BARRÉ","	= i barre\n"
	"	* langues africaines\n"
	"	* la minuscule est 0268\n"
	"	* ISO 6438 indique comme minuscule 026A, non 0268\n"
	"	x (lettre latine petite capitale i - 026A)"},
/* 0198 */ { "LETTRE MAJUSCULE LATINE K CROSSE",NULL},
/* 0199 */ { "LETTRE MINUSCULE LATINE K CROSSE","	* haoussa, alphabet pan-nigérian"},
/* 019A */ { "LETTRE MINUSCULE LATINE L RAYÉ","	= l barré, l barre, l barre horizontale\n"
	"	* phonétique américaniste en lieu et place de 026C\n"
	"	* la majuscule est 023D\n"
	"	x (lettre minuscule latine l barré - 0142)"},
/* 019B */ { "LETTRE MINUSCULE LATINE LAMBDA BARRÉ","	= lambda barre\n"
	"	* phonétique américaniste"},
/* 019C */ { "LETTRE MAJUSCULE LATINE M CULBUTÉ","	* ancienne graphie du tchouang (zhuang)\n"
	"	* la minuscule est 026F"},
/* 019D */ { "LETTRE MAJUSCULE LATINE N HAMEÇON À GAUCHE","	* langues africaines\n"
	"	* la minuscule est 0272"},
/* 019E */ { "LETTRE MINUSCULE LATINE N À LONG FÛT À DROITE","	* symbole désuet du signe japonais 3093\n"
	"	* orthographe recommandée du « n » syllabique : 006E 0329\n"
	"	* indique la nasalisation d'une voyelle en teton (sioux lakota)\n"
	"	* la majuscule est 0220"},
/* 019F */ { "LETTRE MAJUSCULE LATINE O TILDE MÉDIAN","	= o barré, o barre\n"
	"	* la minuscule est 0275\n"
	"	* langues africaines\n"
	"	x (lettre majuscule cyrillique o barré - 04E8)"},
/* 01A0 */ { "LETTRE MAJUSCULE LATINE O CORNU","	: 004F 031B"},
/* 01A1 */ { "LETTRE MINUSCULE LATINE O CORNU","	* vietnamien\n"
	"	: 006F 031B"},
/* 01A2 */ { "LETTRE MAJUSCULE LATINE GHA",NULL},
/* 01A3 */ { "LETTRE MINUSCULE LATINE GHA","	* alphabets romanisés panturcs\n"
	"	* les appellations anglaises de ces deux caractères sont erronées"},
/* 01A4 */ { "LETTRE MAJUSCULE LATINE P CROSSE",NULL},
/* 01A5 */ { "LETTRE MINUSCULE LATINE P CROSSE","	* langues africaines"},
/* 01A6 */ { "LETTRE LATINE YR","	* norrois\n"
	"	* tiré de la norme allemande DIN 31624 et d'ISO 5246-2\n"
	"	* la minuscule est 0280"},
/* 01A7 */ { "LETTRE MAJUSCULE LATINE DEUXIÈME TON",NULL},
/* 01A8 */ { "LETTRE MINUSCULE LATINE DEUXIÈME TON","	* ancienne graphie du tchouang (zhuang)\n"
	"	* typographiquement, un S réfléchi\n"
	"	x (lettre minuscule latine sixième ton - 0185)"},
/* 01A9 */ { "LETTRE MAJUSCULE LATINE ECH","	* langues africaines\n"
	"	* la minuscule est 0283\n"
	"	x (lettre majuscule grecque sigma - 03A3)"},
/* 01AA */ { "LETTRE LATINE ECH RÉFLÉCHI BOUCLÉ","	* symbole phonétique désuet de la palato-alvéolaire labialisée ou de la fricative palatale\n"
	"	* tchi\n"
	"	* orthographes recommandées : 0283 02B7, 00E7 02B7, 0068 0265, etc."},
/* 01AB */ { "LETTRE MINUSCULE LATINE T HAMEÇON PALATAL","	* symbole phonétique désuet de la dentale ou de l'alvéolaire palatalisée\n"
	"	* orthographe recommandée : 0074 02B2"},
/* 01AC */ { "LETTRE MAJUSCULE LATINE T CROSSE","	* il existe également une variante avec la crosse à droite"},
/* 01AD */ { "LETTRE MINUSCULE LATINE T CROSSE","	* langues africaines"},
/* 01AE */ { "LETTRE MAJUSCULE LATINE T HAMEÇON RÉTROFLEXE","	* langues africaines\n"
	"	* la minuscule est 0288"},
/* 01AF */ { "LETTRE MAJUSCULE LATINE U CORNU","	: 0055 031B"},
/* 01B0 */ { "LETTRE MINUSCULE LATINE U CORNU","	* vietnamien\n"
	"	: 0075 031B"},
/* 01B1 */ { "LETTRE MAJUSCULE LATINE UPSILON","	* langues africaines\n"
	"	* typographiquement, une adaptation d'un oméga majuscule culbuté\n"
	"	* la minuscule est 028A\n"
	"	x (symbole ohm renversé - 2127)"},
/* 01B2 */ { "LETTRE MAJUSCULE LATINE V CROSSE","	= v cursif\n"
	"	* langues africaines\n"
	"	* la minuscule est 028B"},
/* 01B3 */ { "LETTRE MAJUSCULE LATINE Y CROSSE","	* il existe également une variante avec la crosse à gauche"},
/* 01B4 */ { "LETTRE MINUSCULE LATINE Y CROSSE","	* bini, ésoko et autres langues édo d'Afrique occidentale"},
/* 01B5 */ { "LETTRE MAJUSCULE LATINE Z BARRÉ",NULL},
/* 01B6 */ { "LETTRE MINUSCULE LATINE Z BARRÉ","	= z barre\n"
	"	* alphabets romanisés panturcs\n"
	"	* variante manuscrite du « z » latin\n"
	"	x (lettre minuscule latine z - 007A)"},
/* 01B7 */ { "LETTRE MAJUSCULE LATINE EJ","	* langues africaines, same skolt\n"
	"	* la minuscule est 0292\n"
	"	x (lettre majuscule latine yogh - 021C)\n"
	"	x (lettre majuscule cyrillique dzé abkhaze - 04E0)"},
/* 01B8 */ { "LETTRE MAJUSCULE LATINE EJ RÉFLÉCHI",NULL},
/* 01B9 */ { "LETTRE MINUSCULE LATINE EJ RÉFLÉCHI","	* symbole phonétique désuet de la fricative pharyngale sonore\n"
	"	* sur le plan typographique, parfois restitué à l'aide d'un 3 culbuté\n"
	"	* orthographe recommandée : 0295\n"
	"	x (lettre latine fricative pharyngale sonore - 0295)\n"
	"	x (lettre arabe 'aïn - 0639)"},
/* 01BA */ { "LETTRE MINUSCULE LATINE EJ À JAMBAGE","	* symbole désuet de la palato-alvéolaire labialisée sonore ou de la fricative palatale\n"
	"	* tchi\n"
	"	* orthographes recommandées : 0292 02B7 ou 006A 02B7"},
/* 01BB */ { "LETTRE LATINE DEUX BARRÉ","	* symbole désuet de l'affriquée [dz]\n"
	"	* orthographes recommandées : 0292 ou 0064 007A"},
/* 01BC */ { "LETTRE MAJUSCULE LATINE CINQUIÈME TON",NULL},
/* 01BD */ { "LETTRE MINUSCULE LATINE CINQUIÈME TON","	* ancienne graphie du tchouang (zhuang)\n"
	"	x (lettre minuscule latine sixième ton - 0185)"},
/* 01BE */ { "LETTRE LATINE COUP DE GLOTTE BARRÉ CULBUTÉ","	* symbole phonétique désuet de l'affriquée [ts]\n"
	"	* orthographe recommandée : 0074 0073\n"
	"	* la forme de la lettre dérive de la ligature du ts plutôt que du coup de glotte culbuté"},
/* 01BF */ { "LETTRE LATINE WYNN","	= wen\n"
	"	* lettre runique empruntée à l'écriture latine\n"
	"	* remplacée par « w » dans les transcriptions modernes du vieil anglais\n"
	"	* la majuscule est 01F7\n"
	"	x (lettre runique wunjo wynn w - 16B9)"},
/* 01C0 */ { "LETTRE LATINE CLIC DENTAL","	* tradition khoï\n"
	"	* « c » en zoulou\n"
	"	x (barre oblique - 002F)\n"
	"	x (barre verticale - 007C)\n"
	"	x (lettre minuscule latine t culbuté - 0287)\n"
	"	x (est un diviseur de - 2223)"},
/* 01C1 */ { "LETTRE LATINE CLIC LATÉRAL","	* tradition khoï\n"
	"	* « x » en zoulou\n"
	"	x (lettre latine coup de glotte culbuté - 0296)\n"
	"	x (parallèle à - 2225)"},
/* 01C2 */ { "LETTRE LATINE CLIC ALVÉOLAIRE","	= clic alvéolo-palatal (API)\n"
	"	* tradition khoï\n"
	"	x (pas égal à - 2260)"},
/* 01C3 */ { "LETTRE LATINE CLIC RÉTROFLEXE","	= lettre latine point d'exclamation (1.0)\n"
	"	= clic post-alvéolaire (API)\n"
	"	* tradition khoï\n"
	"	* « q » en zoulou\n"
	"	x (point d'exclamation - 0021)\n"
	"	x (lettre latine c étiré - 0297)"},
/* 01C4 */ { "LETTRE MAJUSCULE LATINE DZ CARON","	# 0044 017D"},
/* 01C5 */ { "LETTRE MAJUSCULE LATINE D AVEC LETTRE MINUSCULE Z CARON","	# 0044 017E"},
/* 01C6 */ { "LETTRE MINUSCULE LATINE DZ CARON","	x (lettre minuscule cyrillique dzhé - 045F)\n"
	"	# 0064 017E"},
/* 01C7 */ { "LETTRE MAJUSCULE LATINE LJ","	# 004C 004A"},
/* 01C8 */ { "LETTRE MAJUSCULE LATINE L AVEC LETTRE MINUSCULE J","	# 004C 006A"},
/* 01C9 */ { "LETTRE MINUSCULE LATINE LJ","	= digramme soudé lj\n"
	"	x (lettre minuscule cyrillique lié - 0459)\n"
	"	# 006C 006A"},
/* 01CA */ { "LETTRE MAJUSCULE LATINE NJ","	# 004E 004A"},
/* 01CB */ { "LETTRE MAJUSCULE LATINE N AVEC LETTRE MINUSCULE J","	# 004E 006A"},
/* 01CC */ { "LETTRE MINUSCULE LATINE NJ","	= digramme soudé nj\n"
	"	x (lettre minuscule cyrillique ñé - 045A)\n"
	"	# 006E 006A"},
/* 01CD */ { "LETTRE MAJUSCULE LATINE A CARON","	: 0041 030C"},
/* 01CE */ { "LETTRE MINUSCULE LATINE A CARON","	* troisième ton pinyin\n"
	"	: 0061 030C"},
/* 01CF */ { "LETTRE MAJUSCULE LATINE I CARON","	: 0049 030C"},
/* 01D0 */ { "LETTRE MINUSCULE LATINE I CARON","	* troisième ton pinyin\n"
	"	: 0069 030C"},
/* 01D1 */ { "LETTRE MAJUSCULE LATINE O CARON","	: 004F 030C"},
/* 01D2 */ { "LETTRE MINUSCULE LATINE O CARON","	* troisième ton pinyin\n"
	"	: 006F 030C"},
/* 01D3 */ { "LETTRE MAJUSCULE LATINE U CARON","	: 0055 030C"},
/* 01D4 */ { "LETTRE MINUSCULE LATINE U CARON","	* troisième ton pinyin\n"
	"	: 0075 030C"},
/* 01D5 */ { "LETTRE MAJUSCULE LATINE U TRÉMA ET MACRON","	: 00DC 0304"},
/* 01D6 */ { "LETTRE MINUSCULE LATINE U TRÉMA ET MACRON","	* premier ton pinyin\n"
	"	: 00FC 0304"},
/* 01D7 */ { "LETTRE MAJUSCULE LATINE U TRÉMA ET ACCENT AIGU","	: 00DC 0301"},
/* 01D8 */ { "LETTRE MINUSCULE LATINE U TRÉMA ET ACCENT AIGU","	* deuxième ton pinyin\n"
	"	: 00FC 0301"},
/* 01D9 */ { "LETTRE MAJUSCULE LATINE U TRÉMA ET CARON","	: 00DC 030C"},
/* 01DA */ { "LETTRE MINUSCULE LATINE U TRÉMA ET CARON","	* troisième ton pinyin\n"
	"	: 00FC 030C"},
/* 01DB */ { "LETTRE MAJUSCULE LATINE U TRÉMA ET ACCENT GRAVE","	: 00DC 0300"},
/* 01DC */ { "LETTRE MINUSCULE LATINE U TRÉMA ET ACCENT GRAVE","	* quatrième ton pinyin\n"
	"	: 00FC 0300"},
/* 01DD */ { "LETTRE MINUSCULE LATINE E CULBUTÉ","	* alphabet pan-nigérian\n"
	"	* utiliser 0259 pour tous les autres emplois du schwa\n"
	"	* la majuscule est 018E\n"
	"	x (lettre minuscule latine schwa - 0259)"},
/* 01DE */ { "LETTRE MAJUSCULE LATINE A TRÉMA ET MACRON","	: 00C4 0304"},
/* 01DF */ { "LETTRE MINUSCULE LATINE A TRÉMA ET MACRON","	* live, tradition ouraliciste\n"
	"	: 00E4 0304"},
/* 01E0 */ { "LETTRE MAJUSCULE LATINE A POINT EN CHEF ET MACRON","	: 0226 0304"},
/* 01E1 */ { "LETTRE MINUSCULE LATINE A POINT EN CHEF ET MACRON","	* tradition ouraliciste\n"
	"	: 0227 0304"},
/* 01E2 */ { "LETTRE MAJUSCULE LATINE AE MACRON","	: 00C6 0304"},
/* 01E3 */ { "LETTRE MINUSCULE LATINE AE MACRON","	= digramme soudé ae macron, ash macron\n"
	"	* norrois, vieil anglais\n"
	"	: 00E6 0304"},
/* 01E4 */ { "LETTRE MAJUSCULE LATINE G BARRÉ",NULL},
/* 01E5 */ { "LETTRE MINUSCULE LATINE G BARRÉ","	* same skolt"},
/* 01E6 */ { "LETTRE MAJUSCULE LATINE G CARON","	: 0047 030C"},
/* 01E7 */ { "LETTRE MINUSCULE LATINE G CARON","	* same skolt\n"
	"	x (lettre minuscule latine g brève - 011F)\n"
	"	: 0067 030C"},
/* 01E8 */ { "LETTRE MAJUSCULE LATINE K CARON","	: 004B 030C"},
/* 01E9 */ { "LETTRE MINUSCULE LATINE K CARON","	* same skolt\n"
	"	: 006B 030C"},
/* 01EA */ { "LETTRE MAJUSCULE LATINE O OGONEK","	: 004F 0328"},
/* 01EB */ { "LETTRE MINUSCULE LATINE O OGONEK","	* same, iroquoien, vieil islandais\n"
	"	: 006F 0328"},
/* 01EC */ { "LETTRE MAJUSCULE LATINE O OGONEK ET MACRON","	: 01EA 0304"},
/* 01ED */ { "LETTRE MINUSCULE LATINE O OGONEK ET MACRON","	* vieil islandais\n"
	"	: 01EB 0304"},
/* 01EE */ { "LETTRE MAJUSCULE LATINE EJ CARON","	: 01B7 030C"},
/* 01EF */ { "LETTRE MINUSCULE LATINE EJ CARON","	* same skolt\n"
	"	: 0292 030C"},
/* 01F0 */ { "LETTRE MINUSCULE LATINE J CARON","	* API et de nombreuses langues\n"
	"	: 006A 030C"},
/* 01F1 */ { "LETTRE MAJUSCULE LATINE DZ","	# 0044 005A"},
/* 01F2 */ { "LETTRE MAJUSCULE LATINE D AVEC LETTRE MINUSCULE Z","	# 0044 007A"},
/* 01F3 */ { "LETTRE MINUSCULE LATINE DZ","	= digramme soudé dz\n"
	"	* présent pour des raisons de compatibilité\n"
	"	* la forme minuscule était anciennement utilisée dans l'API pour la consonne affriquée alvéolaire voisée\n"
	"	# 0064 007A"},
/* 01F4 */ { "LETTRE MAJUSCULE LATINE G ACCENT AIGU","	: 0047 0301"},
/* 01F5 */ { "LETTRE MINUSCULE LATINE G ACCENT AIGU","	* translittération du macédonien et du serbe\n"
	"	: 0067 0301"},
/* 01F6 */ { "LETTRE MAJUSCULE LATINE HWAIR","	* la minuscule est 0195"},
/* 01F7 */ { "LETTRE MAJUSCULE LATINE WYNN","	= wen\n"
	"	* la minuscule est 01BF"},
/* 01F8 */ { "LETTRE MAJUSCULE LATINE N GRAVE","	: 004E 0300"},
/* 01F9 */ { "LETTRE MINUSCULE LATINE N GRAVE","	* pinyin\n"
	"	: 006E 0300"},
/* 01FA */ { "LETTRE MAJUSCULE LATINE A ROND EN CHEF ET ACCENT AIGU","	: 00C5 0301"},
/* 01FB */ { "LETTRE MINUSCULE LATINE A ROND EN CHEF ET ACCENT AIGU","	: 00E5 0301"},
/* 01FC */ { "LETTRE MAJUSCULE LATINE AE ACCENT AIGU","	: 00C6 0301"},
/* 01FD */ { "LETTRE MINUSCULE LATINE AE ACCENT AIGU","	= digramme soudé ae accent aigu, ash accent aigu\n"
	"	: 00E6 0301"},
/* 01FE */ { "LETTRE MAJUSCULE LATINE O BARRÉ ACCENT AIGU","	: 00D8 0301"},
/* 01FF */ { "LETTRE MINUSCULE LATINE O BARRÉ ACCENT AIGU","	: 00F8 0301"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_02[] = {
/* 0200 */ { "LETTRE MAJUSCULE LATINE A DOUBLE ACCENT GRAVE","	: 0041 030F"},
/* 0201 */ { "LETTRE MINUSCULE LATINE A DOUBLE ACCENT GRAVE","	: 0061 030F"},
/* 0202 */ { "LETTRE MAJUSCULE LATINE A BRÈVE RENVERSÉE","	: 0041 0311"},
/* 0203 */ { "LETTRE MINUSCULE LATINE A BRÈVE RENVERSÉE","	: 0061 0311"},
/* 0204 */ { "LETTRE MAJUSCULE LATINE E DOUBLE ACCENT GRAVE","	: 0045 030F"},
/* 0205 */ { "LETTRE MINUSCULE LATINE E DOUBLE ACCENT GRAVE","	: 0065 030F"},
/* 0206 */ { "LETTRE MAJUSCULE LATINE E BRÈVE RENVERSÉE","	: 0045 0311"},
/* 0207 */ { "LETTRE MINUSCULE LATINE E BRÈVE RENVERSÉE","	: 0065 0311"},
/* 0208 */ { "LETTRE MAJUSCULE LATINE I DOUBLE ACCENT GRAVE","	: 0049 030F"},
/* 0209 */ { "LETTRE MINUSCULE LATINE I DOUBLE ACCENT GRAVE","	: 0069 030F"},
/* 020A */ { "LETTRE MAJUSCULE LATINE I BRÈVE RENVERSÉE","	: 0049 0311"},
/* 020B */ { "LETTRE MINUSCULE LATINE I BRÈVE RENVERSÉE","	: 0069 0311"},
/* 020C */ { "LETTRE MAJUSCULE LATINE O DOUBLE ACCENT GRAVE","	: 004F 030F"},
/* 020D */ { "LETTRE MINUSCULE LATINE O DOUBLE ACCENT GRAVE","	: 006F 030F"},
/* 020E */ { "LETTRE MAJUSCULE LATINE O BRÈVE RENVERSÉE","	: 004F 0311"},
/* 020F */ { "LETTRE MINUSCULE LATINE O BRÈVE RENVERSÉE","	: 006F 0311"},
/* 0210 */ { "LETTRE MAJUSCULE LATINE R DOUBLE ACCENT GRAVE","	: 0052 030F"},
/* 0211 */ { "LETTRE MINUSCULE LATINE R DOUBLE ACCENT GRAVE","	: 0072 030F"},
/* 0212 */ { "LETTRE MAJUSCULE LATINE R BRÈVE RENVERSÉE","	: 0052 0311"},
/* 0213 */ { "LETTRE MINUSCULE LATINE R BRÈVE RENVERSÉE","	: 0072 0311"},
/* 0214 */ { "LETTRE MAJUSCULE LATINE U DOUBLE ACCENT GRAVE","	: 0055 030F"},
/* 0215 */ { "LETTRE MINUSCULE LATINE U DOUBLE ACCENT GRAVE","	: 0075 030F"},
/* 0216 */ { "LETTRE MAJUSCULE LATINE U BRÈVE RENVERSÉE","	: 0055 0311"},
/* 0217 */ { "LETTRE MINUSCULE LATINE U BRÈVE RENVERSÉE","	: 0075 0311"},
/* 0218 */ { "LETTRE MAJUSCULE LATINE S VIRGULE SOUSCRITE","	: 0053 0326"},
/* 0219 */ { "LETTRE MINUSCULE LATINE S VIRGULE SOUSCRITE","	* roumain, quand la forme à virgule souscrite s'impose\n"
	"	x (lettre minuscule latine s cédille - 015F)\n"
	"	: 0073 0326"},
/* 021A */ { "LETTRE MAJUSCULE LATINE T VIRGULE SOUSCRITE","	: 0054 0326"},
/* 021B */ { "LETTRE MINUSCULE LATINE T VIRGULE SOUSCRITE","	* roumain, quand la forme à virgule souscrite s'impose\n"
	"	x (lettre minuscule latine t cédille - 0163)\n"
	"	: 0074 0326"},
/* 021C */ { "LETTRE MAJUSCULE LATINE YOGH","	x (lettre majuscule latine ej - 01B7)"},
/* 021D */ { "LETTRE MINUSCULE LATINE YOGH","	* moyen anglais, écossais\n"
	"	x (lettre minuscule latine ej - 0292)\n"
	"	x (lettre minuscule latine g insulaire - 1D79)"},
/* 021E */ { "LETTRE MAJUSCULE LATINE H CARON","	: 0048 030C"},
/* 021F */ { "LETTRE MINUSCULE LATINE H CARON","	* romani finlandais\n"
	"	: 0068 030C"},
/* 0220 */ { "LETTRE MAJUSCULE LATINE N À LONG FÛT À DROITE","	* teton (sioux lakota)\n"
	"	* la minuscule est 019E"},
/* 0221 */ { "LETTRE MINUSCULE LATINE D BOUCLÉ","	* emploi phonétique en sinologie"},
/* 0222 */ { "LETTRE MAJUSCULE LATINE OU",NULL},
/* 0223 */ { "LETTRE MINUSCULE LATINE OU","	* algonquien, huron\n"
	"	x (chiffre huit - 0038)"},
/* 0224 */ { "LETTRE MAJUSCULE LATINE Z HAMEÇON",NULL},
/* 0225 */ { "LETTRE MINUSCULE LATINE Z HAMEÇON","	* moyen haut-allemand"},
/* 0226 */ { "LETTRE MAJUSCULE LATINE A POINT EN CHEF","	: 0041 0307"},
/* 0227 */ { "LETTRE MINUSCULE LATINE A POINT EN CHEF","	* tradition ouraliciste\n"
	"	: 0061 0307"},
/* 0228 */ { "LETTRE MAJUSCULE LATINE E CÉDILLE","	: 0045 0327"},
/* 0229 */ { "LETTRE MINUSCULE LATINE E CÉDILLE","	: 0065 0327"},
/* 022A */ { "LETTRE MAJUSCULE LATINE O TRÉMA ET MACRON","	: 00D6 0304"},
/* 022B */ { "LETTRE MINUSCULE LATINE O TRÉMA ET MACRON","	: 00F6 0304"},
/* 022C */ { "LETTRE MAJUSCULE LATINE O TILDE ET MACRON","	: 00D5 0304"},
/* 022D */ { "LETTRE MINUSCULE LATINE O TILDE ET MACRON","	: 00F5 0304"},
/* 022E */ { "LETTRE MAJUSCULE LATINE O POINT EN CHEF","	: 004F 0307"},
/* 022F */ { "LETTRE MINUSCULE LATINE O POINT EN CHEF","	: 006F 0307"},
/* 0230 */ { "LETTRE MAJUSCULE LATINE O POINT EN CHEF ET MACRON","	: 022E 0304"},
/* 0231 */ { "LETTRE MINUSCULE LATINE O POINT EN CHEF ET MACRON","	: 022F 0304"},
/* 0232 */ { "LETTRE MAJUSCULE LATINE Y MACRON","	: 0059 0304"},
/* 0233 */ { "LETTRE MINUSCULE LATINE Y MACRON","	* également en cornique\n"
	"	: 0079 0304"},
/* 0234 */ { "LETTRE MINUSCULE LATINE L BOUCLÉ",NULL},
/* 0235 */ { "LETTRE MINUSCULE LATINE N BOUCLÉ",NULL},
/* 0236 */ { "LETTRE MINUSCULE LATINE T BOUCLÉ",NULL},
/* 0237 */ { "LETTRE MINUSCULE LATINE J SANS POINT","	x (minuscule mathématique italique j sans point - 1D6A5)"},
/* 0238 */ { "LIGATURE MINUSCULE LATINE DB",NULL},
/* 0239 */ { "LIGATURE MINUSCULE LATINE QP",NULL},
/* 023A */ { "LETTRE MAJUSCULE LATINE A BARRÉ","	* la minuscule est 2C65"},
/* 023B */ { "LETTRE MAJUSCULE LATINE C BARRÉ",NULL},
/* 023C */ { "LETTRE MINUSCULE LATINE C BARRÉ","	* utilisée en linguistique américaniste"},
/* 023D */ { "LETTRE MAJUSCULE LATINE L RAYÉ","	* la minuscule est 019A"},
/* 023E */ { "LETTRE MAJUSCULE LATINE T BARRÉ DIAGONALEMENT","	* la minuscule est 2C66"},
/* 023F */ { "LETTRE MINUSCULE LATINE S À PARAPHE","	* fricative labio-alvéolaire sourde\n"
	"	* la majuscule est 2C7E\n"
	"	x (lettre minuscule latine s hameçon rétroflexe - 0282)"},
/* 0240 */ { "LETTRE MINUSCULE LATINE Z À PARAPHE","	* fricative labio-alvéolaire voisée\n"
	"	* la majuscule est 2C7F\n"
	"	x (lettre minuscule latine z hameçon rétroflexe - 0290)"},
/* 0241 */ { "LETTRE MAJUSCULE LATINE COUP DE GLOTTE",NULL},
/* 0242 */ { "LETTRE MINUSCULE LATINE COUP DE GLOTTE","	* lettre bicamérale utilisée en tchipéwayan, flanc-de-chien, esclave (systèmes d'écriture autochtones canadiens)\n"
	"	x (lettre latine coup de glotte - 0294)\n"
	"	x (lettre modificative coup de glotte - 02C0)"},
/* 0243 */ { "LETTRE MAJUSCULE LATINE B BARRÉ","	* la minuscule est 0180"},
/* 0244 */ { "LETTRE MAJUSCULE LATINE U BARRÉ","	* la minuscule est 0289"},
/* 0245 */ { "LETTRE MAJUSCULE LATINE V CULBUTÉ","	* la minuscule est 028C"},
/* 0246 */ { "LETTRE MAJUSCULE LATINE E BARRÉ",NULL},
/* 0247 */ { "LETTRE MINUSCULE LATINE E BARRÉ",NULL},
/* 0248 */ { "LETTRE MAJUSCULE LATINE J BARRÉ",NULL},
/* 0249 */ { "LETTRE MINUSCULE LATINE J BARRÉ",NULL},
/* 024A */ { "LETTRE MAJUSCULE LATINE PETIT Q HAMEÇON RÉTROFLEXE",NULL},
/* 024B */ { "LETTRE MINUSCULE LATINE Q HAMEÇON RÉTROFLEXE",NULL},
/* 024C */ { "LETTRE MAJUSCULE LATINE R BARRÉ",NULL},
/* 024D */ { "LETTRE MINUSCULE LATINE R BARRÉ",NULL},
/* 024E */ { "LETTRE MAJUSCULE LATINE Y BARRÉ",NULL},
/* 024F */ { "LETTRE MINUSCULE LATINE Y BARRÉ",NULL},
/* 0250 */ { "LETTRE MINUSCULE LATINE A CULBUTÉ","	* voyelle basse centrale non arrondie\n"
	"	* la majuscule est 2C6F"},
/* 0251 */ { "LETTRE MINUSCULE LATINE ALPHA","	= lettre minuscule latine a cursif (1.0)\n"
	"	* voyelle basse postérieure non arrondie\n"
	"	* la majuscule est 2C6D\n"
	"	x (lettre minuscule grecque alpha - 03B1)"},
/* 0252 */ { "LETTRE MINUSCULE LATINE ALPHA CULBUTÉ","	* voyelle basse postérieure arrondie\n"
	"	* la majuscule est 2C70\n"
	"	x (lettre minuscule latine alpha renversé - AB64)"},
/* 0253 */ { "LETTRE MINUSCULE LATINE B CROSSE","	* occlusive bilabiale implosive\n"
	"	* alphabet pan-nigérian\n"
	"	* la majuscule est 0181"},
/* 0254 */ { "LETTRE MINUSCULE LATINE O OUVERT","	* typographiquement, un c réfléchi\n"
	"	* voyelle moyenne inférieure postérieure arrondie\n"
	"	* dans un usage danois ancien, « ɔ: » signifie « c'est-à-dire »\n"
	"	* la majuscule est 0186"},
/* 0255 */ { "LETTRE MINUSCULE LATINE C BOUCLÉ","	* fricative alvéolopalatale laminale sourde\n"
	"	* utilisée dans les transcriptions du mandarin\n"
	"	* ce son est écrit à l'aide de 015B en polonais"},
/* 0256 */ { "LETTRE MINUSCULE LATINE D HAMEÇON RÉTROFLEXE","	= d crochet rétroflexe\n"
	"	* occlusive rétroflexe sonore\n"
	"	* la majuscule est 0189"},
/* 0257 */ { "LETTRE MINUSCULE LATINE D CROSSE","	* occlusive dentale implosive ou alvéolaire\n"
	"	* éwé, alphabet pan-nigérian\n"
	"	* la majuscule est 018A"},
/* 0258 */ { "LETTRE MINUSCULE LATINE E RÉFLÉCHI","	* voyelle moyenne supérieure centrale non arrondie"},
/* 0259 */ { "LETTRE MINUSCULE LATINE SCHWA","	* voyelle moyenne centrale\n"
	"	* la majuscule est 018F\n"
	"	* la variante majuscule 018E est associée avec 01DD\n"
	"	x (lettre minuscule latine e culbuté - 01DD)\n"
	"	x (lettre minuscule cyrillique schwa - 04D9)"},
/* 025A */ { "LETTRE MINUSCULE LATINE SCHWA CROCHET","	* schwa rhotacisé"},
/* 025B */ { "LETTRE MINUSCULE LATINE E OUVERT","	= epsilon\n"
	"	* voyelle moyenne inférieure antérieure non arrondie\n"
	"	* la majuscule est 0190\n"
	"	x (lettre minuscule grecque epsilon - 03B5)"},
/* 025C */ { "LETTRE MINUSCULE LATINE E OUVERT RÉFLÉCHI","	= epsilon réfléchi\n"
	"	* voyelle moyenne inférieure centrale non arrondie\n"
	"	* la majuscule est A7AB"},
/* 025D */ { "LETTRE MINUSCULE LATINE E OUVERT RÉFLÉCHI CROCHET","	= epsilon réfléchi crochet\n"
	"	* voyelle moyenne inférieure centrale rhotacisée"},
/* 025E */ { "LETTRE MINUSCULE LATINE E OUVERT RÉFLÉCHI FERMÉ","	= epsilon réfléchi fermé\n"
	"	* voyelle moyenne inférieure centrale arrondie"},
/* 025F */ { "LETTRE MINUSCULE LATINE J SANS POINT BARRÉ","	* occlusive palatale sonore\n"
	"	* typographiquement un f culbuté, mais mieux perçue comme une forme de j\n"
	"	* transcrit par « gy » en hongrois\n"
	"	* également le symbole désuet de l'affriquée palato-alvéolaire 02A4"},
/* 0260 */ { "LETTRE MINUSCULE LATINE G CROSSE","	* occlusive vélaire implosive\n"
	"	* la majuscule est 0193"},
/* 0261 */ { "LETTRE MINUSCULE LATINE G CURSIF","	* occlusive vélaire sonore\n"
	"	* la majuscule est A7AC\n"
	"	x (lettre minuscule latine g - 0067)"},
/* 0262 */ { "LETTRE LATINE PETITE CAPITALE G","	* occlusive uvulaire sonore"},
/* 0263 */ { "LETTRE MINUSCULE LATINE GAMMA","	* fricative vélaire sonore\n"
	"	* la majuscule est 0194\n"
	"	x (lettre minuscule grecque gamma - 03B3)"},
/* 0264 */ { "LETTRE MINUSCULE LATINE PETIT GAMMA","	* voyelle moyenne supérieure postérieure non arrondie"},
/* 0265 */ { "LETTRE MINUSCULE LATINE H CULBUTÉ","	* approximante médiane labiopalatale sonore\n"
	"	* la majuscule est A78D"},
/* 0266 */ { "LETTRE MINUSCULE LATINE H CROSSE","	* fricative glottale sonore\n"
	"	* « h » anglais entre sons voisés dans « behave », « manhood »\n"
	"	* la maujuscule est A7AA\n"
	"	* la majuscule est 0124 en nawdm (ou losso)\n"
	"	x (lettre modificative minuscule h crosse - 02B1)"},
/* 0267 */ { "LETTRE MINUSCULE LATINE HENG CROSSE","	* fricative vélaire et palato-alvéolaire coarticulée sourde\n"
	"	* « tj », « kj » ou « sj » dans certains dialectes suédois"},
/* 0268 */ { "LETTRE MINUSCULE LATINE I BARRÉ","	= i barre\n"
	"	* voyelle haute centrale non arrondie\n"
	"	* la majuscule est 0197\n"
	"	* ISO 6438 donne 026A et non 0268 comme minuscule de 0197"},
/* 0269 */ { "LETTRE MINUSCULE LATINE IOTA","	* voyelle haute inférieure antérieure non arrondie\n"
	"	* rendue désuète par l'API en 1989\n"
	"	* l'API recommande l'emploi de 026A (lettre latine petite capitale i)\n"
	"	* la majuscule est 0196\n"
	"	x (lettre minuscule grecque iota - 03B9)"},
/* 026A */ { "LETTRE LATINE PETITE CAPITALE I","	* voyelle haute inférieure antérieure non arrondie\n"
	"	* forme recommandée par l'API en lieu et place de 0269\n"
	"	* la majuscule est A7AE\n"
	"	* le glyphe devrait présenter des empattements y compris dans des polices API sans empattements, pour éviter la confusion avec la minuscule « l »"},
/* 026B */ { "LETTRE MINUSCULE LATINE L TILDE MÉDIAN","	* approximante latérale alvéolaire vélarisée sonore\n"
	"	* « l » anglais dans « table », une variété du 0142 polonais\n"
	"	* la majuscule est 2C62"},
/* 026C */ { "LETTRE MINUSCULE LATINE L SANGLÉ","	* latérale fricative alvéolaire sourde\n"
	"	* la majuscule est A7AD"},
/* 026D */ { "LETTRE MINUSCULE LATINE L HAMEÇON RÉTROFLEXE","	* latérale rétroflexe sonore"},
/* 026E */ { "LETTRE MINUSCULE LATINE LEJ","	* latérale fricative sonore\n"
	"	* zoulou : « dhl » (dans « dhla » manger)"},
/* 026F */ { "LETTRE MINUSCULE LATINE M CULBUTÉ","	* voyelle haute postérieure non arrondie\n"
	"	* la majuscule est 019C"},
/* 0270 */ { "LETTRE MINUSCULE LATINE M CULBUTÉ À LONG FÛT","	* approximante vélaire sonore"},
/* 0271 */ { "LETTRE MINUSCULE LATINE M HAMEÇON","	* nasale labiodentale sonore\n"
	"	* la majuscule est 2C6E"},
/* 0272 */ { "LETTRE MINUSCULE LATINE N HAMEÇON À GAUCHE","	* nasale palatale sonore\n"
	"	* « gn » en français et italien, « ñ » en castillan\n"
	"	* la majuscule est 019D"},
/* 0273 */ { "LETTRE MINUSCULE LATINE N HAMEÇON RÉTROFLEXE","	* nasale rétroflexe sonore"},
/* 0274 */ { "LETTRE LATINE PETITE CAPITALE N","	* nasale uvulaire sonore"},
/* 0275 */ { "LETTRE MINUSCULE LATINE O BARRÉ","	= o barre\n"
	"	* voyelle moyenne centrale arrondie, c'est-à-dire un schwa arrondi\n"
	"	* la majuscule est 019F\n"
	"	x (lettre minuscule grecque thêta - 03B8)\n"
	"	x (lettre minuscule cyrillique fita - 0473)\n"
	"	x (lettre minuscule cyrillique o barré - 04E9)"},
/* 0276 */ { "LETTRE LATINE PETITE CAPITALE OE","	* voyelle basse antérieure arrondie\n"
	"	x (digramme soudé minuscule latin oe - 0153)"},
/* 0277 */ { "LETTRE MINUSCULE LATINE OMÉGA FERMÉ","	* voyelle haute inférieure postérieure arrondie\n"
	"	* rendue désuète par l'API en 1989\n"
	"	* l'API recommande l'emploi de 028A (lettre minuscule latine upsilon)\n"
	"	x (lettre grecque petite capitale oméga - AB65)"},
/* 0278 */ { "LETTRE MINUSCULE LATINE PHI","	* fricative bilabiale sourde\n"
	"	x (lettre minuscule grecque phi - 03C6)"},
/* 0279 */ { "LETTRE MINUSCULE LATINE R CULBUTÉ","	* approximante médiane alvéolaire sonore\n"
	"	x (lettre modificative minuscule r culbuté - 02B4)"},
/* 027A */ { "LETTRE MINUSCULE LATINE R CULBUTÉ À LONG FÛT","	* vibrante battue latérale sonore"},
/* 027B */ { "LETTRE MINUSCULE LATINE R CROSSE CULBUTÉ","	* approximante rétroflexe sonore\n"
	"	x (lettre modificative minuscule r crosse culbuté - 02B5)"},
/* 027C */ { "LETTRE MINUSCULE LATINE R À LONG FÛT","	* vibrante fricative apico-alvéolaire\n"
	"	* rendue désuète par l'API en 1989\n"
	"	* correspond au 0159 tchèque\n"
	"	* l'API recommande 0072 031D pour représenter le son tchèque\n"
	"	* utilisée comme caractère gaélique (une variante de glyphe de 0072)"},
/* 027D */ { "LETTRE MINUSCULE LATINE R HAMEÇON RÉTROFLEXE","	* vibrante battue rétroflexe sonore\n"
	"	* la majuscule est 2C64"},
/* 027E */ { "LETTRE MINUSCULE LATINE R SANS OBIT","	* l'obit désigne un empattement supérieur\n"
	"	* vibrante battue alvéolaire sonore"},
/* 027F */ { "LETTRE MINUSCULE LATINE R SANS OBIT RÉFLÉCHI","	* l'obit désigne un empattement supérieur\n"
	"	* voyelle apicodentale\n"
	"	* utilisée par les sinisants et autres spécialistes des langues sino-tibétaines\n"
	"	* l'API recommande 007A 0329\n"
	"	* la représentation recommandée préconise une hampe descendante"},
/* 0280 */ { "LETTRE LATINE PETITE CAPITALE R","	* vibrante roulée uvulaire sonore\n"
	"	* R « grasseyé » (langues germaniques, norrois)\n"
	"	* la majuscule est 01A6"},
/* 0281 */ { "LETTRE LATINE PETITE CAPITALE R RENVERSÉ","	* fricative uvulaire sonore\n"
	"	x (lettre modificative petite capitale r renversé - 02B6)"},
/* 0282 */ { "LETTRE MINUSCULE LATINE S HAMEÇON RÉTROFLEXE","	* fricative rétroflexe sourde"},
/* 0283 */ { "LETTRE MINUSCULE LATINE ECH","	* fricative post-alvéolaire sourde\n"
	"	* la majuscule est 01A9\n"
	"	x (intégrale - 222B)"},
/* 0284 */ { "LETTRE MINUSCULE LATINE J SANS POINT BARRÉ CROSSE","	* occlusive palatale implosive\n"
	"	* sur le plan typographique, repose sur 025F, non sur 0283"},
/* 0285 */ { "LETTRE MINUSCULE LATINE R SANS OBIT RÉFLÉCHI HAMEÇON RÉTROFLEXE","	* voyelle rétroflexe apicale\n"
	"	* utilisée par les sinisants et autres spécialistes des langues sino-tibétaines\n"
	"	* l'API recommande 0290 0329\n"
	"	* à l'origine 027F plus le hameçon rétroflexe 0322\n"
	"	* la représentation recommandée préconise une hampe descendante"},
/* 0286 */ { "LETTRE MINUSCULE LATINE ECH BOUCLÉ","	* fricative palatalisée post-alvéolaire sourde\n"
	"	* écriture recommandée : 0290 0329"},
/* 0287 */ { "LETTRE MINUSCULE LATINE T CULBUTÉ","	* clic dental (son de « tsk tsk »)\n"
	"	* la majuscule est A7B1\n"
	"	x (lettre latine clic dental - 01C0)"},
/* 0288 */ { "LETTRE MINUSCULE LATINE T HAMEÇON RÉTROFLEXE","	* occlusive rétroflexe sourde\n"
	"	* la majuscule est 01AE"},
/* 0289 */ { "LETTRE MINUSCULE LATINE U BARRÉ","	* voyelle haute centrale arrondie\n"
	"	* la majuscule est 0244"},
/* 028A */ { "LETTRE MINUSCULE LATINE UPSILON","	* voyelle haute inférieure postérieure arrondie\n"
	"	* forme recommandée par l'API en lieu et place de 0277\n"
	"	* la majuscule est 01B1\n"
	"	x (lettre minuscule grecque upsilon - 03C5)"},
/* 028B */ { "LETTRE MINUSCULE LATINE V CROSSE","	= lettre minuscule latine v cursif (1.0)\n"
	"	* approximante labiodentale sonore\n"
	"	* la majuscule est 01B2\n"
	"	x (lettre minuscule grecque upsilon - 03C5)"},
/* 028C */ { "LETTRE MINUSCULE LATINE V CULBUTÉ","	= chevron\n"
	"	* voyelle moyenne inférieure postérieure non arrondie\n"
	"	* la majuscule est 0245\n"
	"	x (lettre majuscule grecque lambda - 039B)\n"
	"	x (chevron d'insertion - 2038)\n"
	"	x (et logique - 2227)"},
/* 028D */ { "LETTRE MINUSCULE LATINE W CULBUTÉ","	* approximante labiovélaire arrondie sourde"},
/* 028E */ { "LETTRE MINUSCULE LATINE Y CULBUTÉ","	* approximante latérale sonore"},
/* 028F */ { "LETTRE LATINE PETITE CAPITALE Y","	* voyelle haute inférieure antérieure arrondie"},
/* 0290 */ { "LETTRE MINUSCULE LATINE Z HAMEÇON RÉTROFLEXE","	* fricative rétroflexe sonore"},
/* 0291 */ { "LETTRE MINUSCULE LATINE Z BOUCLÉ","	* fricative laminale alvéolopalatale sonore\n"
	"	* son écrit à l'aide de 017A en polonais"},
/* 0292 */ { "LETTRE MINUSCULE LATINE EJ","	* fricative post-alvéolaire sonore\n"
	"	* portait le nom erroné de « yogh » dans Unicode 1.0\n"
	"	* la majuscule est 01B7\n"
	"	* same skolt\n"
	"	x (lettre minuscule latine yogh - 021D)\n"
	"	x (lettre minuscule cyrillique dzé abkhaze - 04E1)\n"
	"	x (symbole once - 2125)\n"
	"	x (symbole alchimique du demi-gros - 1F772)"},
/* 0293 */ { "LETTRE MINUSCULE LATINE EJ BOUCLÉ","	* fricative post-alvéolaire palatalisée sonore"},
/* 0294 */ { "LETTRE LATINE COUP DE GLOTTE","	* lettre unicamérale\n"
	"	* utilisée en API, dans d'autres notations phonétiques et dans les systèmes d'écriture qui utilisent un coup de glotte unicaméral\n"
	"	x (lettre majuscule latine coup de glotte - 0241)\n"
	"	x (lettre modificative coup de glotte - 02C0)"},
/* 0295 */ { "LETTRE LATINE FRICATIVE PHARYNGALE SONORE","	= lettre latine coup de glotte réfléchi (1.0)\n"
	"	* 'aïn\n"
	"	x (lettre minuscule latine ej réfléchi - 01B9)\n"
	"	x (lettre modificative coup de glotte réfléchi - 02C1)"},
/* 0296 */ { "LETTRE LATINE COUP DE GLOTTE CULBUTÉ","	* clic latéral\n"
	"	x (lettre latine clic latéral - 01C1)"},
/* 0297 */ { "LETTRE LATINE C ÉTIRÉ","	* clic palatal (ou alvéolaire)\n"
	"	x (lettre latine clic rétroflexe - 01C3)\n"
	"	x (complément - 2201)"},
/* 0298 */ { "LETTRE LATINE CLIC BILABIAL","	= œil-de-bœuf\n"
	"	x (opérateur point cerclé - 2299)"},
/* 0299 */ { "LETTRE LATINE PETITE CAPITALE B","	* vibrante roulée bilabiale"},
/* 029A */ { "LETTRE MINUSCULE LATINE E OUVERT FERMÉ","	= epsilon fermé\n"
	"	* voyelle moyenne inférieure antérieure arrondie\n"
	"	* forme non API pour la représentation recommandée 0153"},
/* 029B */ { "LETTRE LATINE PETITE CAPITALE G CROSSE","	* implosive uvulaire sonore"},
/* 029C */ { "LETTRE LATINE PETITE CAPITALE H","	* fricative épiglottale sourde"},
/* 029D */ { "LETTRE MINUSCULE LATINE J À QUEUE CROISÉE","	* fricative palatale sonore\n"
	"	* la majuscule est A7B2"},
/* 029E */ { "LETTRE MINUSCULE LATINE K CULBUTÉ","	* proposée pour le clic vélaire\n"
	"	* la majuscule est A7B0\n"
	"	* retirée par l'API en 1970"},
/* 029F */ { "LETTRE LATINE PETITE CAPITALE L","	* approximante latérale vélaire"},
/* 02A0 */ { "LETTRE MINUSCULE LATINE Q CROSSE","	* implosive uvulaire sourde"},
/* 02A1 */ { "LETTRE LATINE COUP DE GLOTTE BARRÉ","	* occlusive épiglottale sonore"},
/* 02A2 */ { "LETTRE LATINE COUP DE GLOTTE BARRÉ RÉFLÉCHI","	* fricative épiglottale sonore"},
/* 02A3 */ { "LETTRE MINUSCULE LATINE DIGRAMME DZ","	* affriquée dentale sonore"},
/* 02A4 */ { "LETTRE MINUSCULE LATINE DIGRAMME DEJ","	* affriquée post-alvéolaire sonore"},
/* 02A5 */ { "LETTRE MINUSCULE LATINE DIGRAMME DZ BOUCLÉ","	* affriquée alvéolopalatale sonore"},
/* 02A6 */ { "LETTRE MINUSCULE LATINE DIGRAMME TS","	* affriquée dentale sourde"},
/* 02A7 */ { "LETTRE MINUSCULE LATINE DIGRAMME TECH","	* affriquée post-alvéolaire sourde"},
/* 02A8 */ { "LETTRE MINUSCULE LATINE DIGRAMME TC BOUCLÉ","	* affriquée alvéolopalatale sourde"},
/* 02A9 */ { "LETTRE MINUSCULE LATINE DIGRAMME FENG","	* fricative vélopharyngale"},
/* 02AA */ { "LETTRE MINUSCULE LATINE DIGRAMME LS","	* fricative alvéolaire latérale (zézaiement)"},
/* 02AB */ { "LETTRE MINUSCULE LATINE DIGRAMME LZ","	* fricative alvéolaire latérale sonore"},
/* 02AC */ { "LETTRE LATINE PERCUSSION BILABIALE","	* baiser audible"},
/* 02AD */ { "LETTRE LATINE PERCUSSION BIDENTALE","	* grincement de dents audible"},
/* 02AE */ { "LETTRE MINUSCULE LATINE H HAMEÇON RÉTROFLEXE CULBUTÉ",NULL},
/* 02AF */ { "LETTRE MINUSCULE LATINE H HAMEÇON RÉTROFLEXE ET CROSSE CULBUTÉ",NULL},
/* 02B0 */ { "LETTRE MODIFICATIVE MINUSCULE H","	* aspiré\n"
	"	# <exp> 0068"},
/* 02B1 */ { "LETTRE MODIFICATIVE MINUSCULE H CROSSE","	* soufflé sonore, murmuré\n"
	"	x (lettre minuscule latine h crosse - 0266)\n"
	"	x (diacritique tréma souscrit - 0324)\n"
	"	# <exp> 0266"},
/* 02B2 */ { "LETTRE MODIFICATIVE MINUSCULE J","	* palatalisé\n"
	"	x (diacritique hameçon palatal souscrit - 0321)\n"
	"	# <exp> 006A"},
/* 02B3 */ { "LETTRE MODIFICATIVE MINUSCULE R","	# <exp> 0072"},
/* 02B4 */ { "LETTRE MODIFICATIVE MINUSCULE R CULBUTÉ","	x (lettre minuscule latine r culbuté - 0279)\n"
	"	# <exp> 0279"},
/* 02B5 */ { "LETTRE MODIFICATIVE MINUSCULE R CROSSE CULBUTÉ","	x (lettre minuscule latine r crosse culbuté - 027B)\n"
	"	# <exp> 027B"},
/* 02B6 */ { "LETTRE MODIFICATIVE PETITE CAPITALE R RENVERSÉ","	* les quatre diacritiques ci-dessus servent à marquer une coloration en r\n"
	"	x (lettre latine petite capitale r renversé - 0281)\n"
	"	# <exp> 0281"},
/* 02B7 */ { "LETTRE MODIFICATIVE MINUSCULE W","	* labialisé\n"
	"	x (diacritique oméga souscrit - 032B)\n"
	"	# <exp> 0077"},
/* 02B8 */ { "LETTRE MODIFICATIVE MINUSCULE Y","	* palatalisé\n"
	"	* utilisé par les américanistes à la place de 02B2\n"
	"	# <exp> 0079"},
/* 02B9 */ { "LETTRE MODIFICATIVE PRIME","	* accent principal\n"
	"	* translittération du signe mou cyrillique (palatalisation)\n"
	"	* translittération du gerich hébreu\n"
	"	x (apostrophe - 0027)\n"
	"	x (accent aigu - 00B4)\n"
	"	x (lettre modificative accent aigu - 02CA)\n"
	"	x (diacritique accent aigu - 0301)\n"
	"	x (signe numéral grec - 0374)\n"
	"	x (ponctuation hébraïque gerich - 05F3)\n"
	"	x (prime - 2032)"},
/* 02BA */ { "LETTRE MODIFICATIVE SECONDE","	* accent tonique exagéré, accent contrastif\n"
	"	* translittération du signe dur cyrillique (absence de palatalisation)\n"
	"	x (guillemet anglais - 0022)\n"
	"	x (diacritique double accent aigu - 030B)\n"
	"	x (double prime - 2033)"},
/* 02BB */ { "LETTRE MODIFICATIVE VIRGULE CULBUTÉE","	* autre forme typographique pour 02BD ou 02BF\n"
	"	* utilisée en hawaïen pour représenter l'okina (le coup de glotte)\n"
	"	x (diacritique virgule culbutée en chef - 0312)\n"
	"	x (apostrophe n'ko de ton bas - 07F5)\n"
	"	x (guillemet-apostrophe culbuté - 2018)"},
/* 02BC */ { "LETTRE MODIFICATIVE APOSTROPHE","	= apostrophe\n"
	"	* coup de glotte, glottalisation, éjectif\n"
	"	* clone avec chasse de l'esprit doux grec\n"
	"	* beaucoup de langues considèrent ce caractère comme une lettre de leur alphabet\n"
	"	* s'utilise comme une marque de ton en bodo, en dogri et en maïthili\n"
	"	* 2019 est le caractère privilégié pour noter une apostrophe de ponctuation\n"
	"	x (apostrophe - 0027)\n"
	"	x (diacritique virgule en chef - 0313)\n"
	"	x (diacritique virgule en chef à droite - 0315)\n"
	"	x (apostrophe arménienne - 055A)\n"
	"	x (apostrophe n'ko de ton haut - 07F4)\n"
	"	x (esprit doux grec - 1FBF)\n"
	"	x (guillemet-apostrophe - 2019)"},
/* 02BD */ { "LETTRE MODIFICATIVE VIRGULE RÉFLÉCHIE","	* légèrement aspiré\n"
	"	x (diacritique virgule réfléchie en chef - 0314)\n"
	"	x (lettre modificative arménienne demi-rond gauche - 0559)\n"
	"	x (esprit rude grec - 1FFE)\n"
	"	x (guillemet-virgule supérieur culbuté - 201B)"},
/* 02BE */ { "LETTRE MODIFICATIVE DEMI-ROND DROIT","	* clone avec chasse de l'esprit rude grec\n"
	"	* translittération de la hamza arabe (coup de glotte)\n"
	"	* translittération de l'alef hébreu\n"
	"	x (apostrophe arménienne - 055A)\n"
	"	x (lettre hébraïque alef - 05D0)\n"
	"	x (lettre arabe hamza - 0621)"},
/* 02BF */ { "LETTRE MODIFICATIVE DEMI-ROND GAUCHE","	* translittération du 'aïn arabe (fricative pharyngale sonore)\n"
	"	* translittération du 'aïn hébreu\n"
	"	x (lettre modificative arménienne demi-rond gauche - 0559)\n"
	"	x (lettre hébraïque 'aïn - 05E2)\n"
	"	x (lettre arabe 'aïn - 0639)"},
/* 02C0 */ { "LETTRE MODIFICATIVE COUP DE GLOTTE","	* éjectif ou glottalisé\n"
	"	* autre forme typographique pour 02BC ou 02BE\n"
	"	x (lettre latine coup de glotte - 0294)\n"
	"	x (diacritique crochet en chef - 0309)"},
/* 02C1 */ { "LETTRE MODIFICATIVE COUP DE GLOTTE RÉFLÉCHI","	* autre forme typographique pour 02BF\n"
	"	x (lettre latine fricative pharyngale sonore - 0295)"},
/* 02C2 */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LA GAUCHE","	* articulation antérieure, avancée, protractée"},
/* 02C3 */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LA DROITE","	* articulation postérieure, rétractée"},
/* 02C4 */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LE HAUT","	* articulation vers le haut\n"
	"	x (accent circonflexe - 005E)\n"
	"	x (pointe de flèche vers le haut - 2303)"},
/* 02C5 */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LE BAS","	* articulation vers le bas"},
/* 02C6 */ { "LETTRE MODIFICATIVE ACCENT CIRCONFLEXE","	* ton montant-descendant, contour descendant, accent secondaire\n"
	"	x (accent circonflexe - 005E)\n"
	"	x (diacritique accent circonflexe - 0302)\n"
	"	x (lettre modificative accent circonflexe bas - A788)"},
/* 02C7 */ { "CARON","	= hatchek, chevron, accent hirondelle\n"
	"	* ton descendant-montant, contour montant\n"
	"	* troisième ton du mandarin\n"
	"	* ce caractère chasse\n"
	"	x (diacritique caron - 030C)"},
/* 02C8 */ { "LETTRE MODIFICATIVE LIGNE VERTICALE","	* accent principal\n"
	"	* précède la lettre ou la syllabe modifiée\n"
	"	x (apostrophe - 0027)\n"
	"	x (diacritique ligne verticale en chef - 030D)"},
/* 02C9 */ { "LETTRE MODIFICATIVE MACRON","	* ton haut\n"
	"	* précède ou suit la lettre ou la syllabe modifiée\n"
	"	* premier ton du mandarin\n"
	"	x (macron - 00AF)\n"
	"	x (diacritique macron - 0304)"},
/* 02CA */ { "LETTRE MODIFICATIVE ACCENT AIGU","	* contour haut montant (API), ton haut, accent principal\n"
	"	* deuxième ton du mandarin\n"
	"	x (accent aigu - 00B4)\n"
	"	x (lettre modificative prime - 02B9)\n"
	"	x (diacritique accent aigu - 0301)\n"
	"	x (signe numéral grec - 0374)\n"
	"	x (signe d'accentuation arménien - 055B)"},
/* 02CB */ { "LETTRE MODIFICATIVE ACCENT GRAVE","	* contour haut descendant (API), ton bas, accent secondaire ou tertiaire\n"
	"	* quatrième ton du mandarin\n"
	"	x (accent grave - 0060)\n"
	"	x (diacritique accent grave - 0300)\n"
	"	x (virgule arménienne - 055D)"},
/* 02CC */ { "LETTRE MODIFICATIVE LIGNE VERTICALE BASSE","	* accent secondaire\n"
	"	* précède la lettre ou la syllabe modifiée\n"
	"	x (diacritique ligne verticale souscrite - 0329)"},
/* 02CD */ { "LETTRE MODIFICATIVE MACRON BAS","	* ton bas\n"
	"	x (tiret bas - 005F)\n"
	"	x (diacritique macron souscrit - 0331)"},
/* 02CE */ { "LETTRE MODIFICATIVE ACCENT GRAVE BAS","	* contour bas descendant, ton bas descendant"},
/* 02CF */ { "LETTRE MODIFICATIVE ACCENT AIGU BAS","	* contour bas montant, ton bas montant\n"
	"	x (signe numéral grec souscrit - 0375)"},
/* 02D0 */ { "LETTRE MODIFICATIVE DEUX POINTS TRIANGULAIRES","	= chrone\n"
	"	* marque de longueur, indique une prononciation longue\n"
	"	x (deux-points - 003A)"},
/* 02D1 */ { "LETTRE MODIFICATIVE POINT TRIANGULAIRE","	= demi-chrone\n"
	"	* indique une prononciation mi-longue\n"
	"	x (point médian - 00B7)"},
/* 02D2 */ { "LETTRE MODIFICATIVE DEMI-ROND DROIT CENTRÉ","	* articulation plus arrondie"},
/* 02D3 */ { "LETTRE MODIFICATIVE DEMI-ROND GAUCHE CENTRÉ","	* articulation moins arrondie"},
/* 02D4 */ { "LETTRE MODIFICATIVE TAQUET HAUT","	* fermeture de voyelle, élévation de voyelle\n"
	"	x (diacritique taquet haut souscrit - 031D)\n"
	"	x (diacritique point souscrit - 0323)"},
/* 02D5 */ { "LETTRE MODIFICATIVE TAQUET BAS","	* ouverture de voyelle, abaissement de voyelle\n"
	"	x (diacritique demi-rond gauche souscrit - 031C)\n"
	"	x (diacritique taquet bas souscrit - 031E)"},
/* 02D6 */ { "LETTRE MODIFICATIVE SIGNE PLUS","	* articulation avancée ou antérieure, protractée\n"
	"	x (diacritique signe plus souscrit - 031F)"},
/* 02D7 */ { "LETTRE MODIFICATIVE SIGNE MOINS","	* articulation rétractée ou postérieure\n"
	"	* ce glyphe peut présenter de petits empattements\n"
	"	x (diacritique signe moins souscrit - 0320)\n"
	"	x (signe moins - 2212)"},
/* 02D8 */ { "BRÈVE","	x (diacritique brève - 0306)\n"
	"	# 0020 0306"},
/* 02D9 */ { "POINT EN CHEF","	* cinquième ton du mandarin (léger ou neutre)\n"
	"	x (diacritique point en chef - 0307)\n"
	"	# 0020 0307"},
/* 02DA */ { "ROND EN CHEF","	x (symbole degré - 00B0)\n"
	"	x (diacritique rond en chef - 030A)\n"
	"	# 0020 030A"},
/* 02DB */ { "OGONEK","	x (diacritique ogonek - 0328)\n"
	"	# 0020 0328"},
/* 02DC */ { "PETIT TILDE","	x (tilde - 007E)\n"
	"	x (diacritique tilde - 0303)\n"
	"	x (opérateur tilde - 223C)\n"
	"	# 0020 0303"},
/* 02DD */ { "DOUBLE ACCENT AIGU","	x (diacritique double accent aigu - 030B)\n"
	"	# 0020 030B"},
/* 02DE */ { "LETTRE MODIFICATIVE CROCHET DE RHOTACISME","	* rhotacisation de voyelle\n"
	"	* souvent ligaturé : 025A = 0259 + 02DE ; 025D = 025C + 02DE"},
/* 02DF */ { "LETTRE MODIFICATIVE ACCENT EN CROIX","	= accent cruciforme, accent croix de saint André\n"
	"	* accent grave suédois"},
/* 02E0 */ { "LETTRE MODIFICATIVE MINUSCULE GAMMA","	* vélarisé\n"
	"	# <exp> 0263"},
/* 02E1 */ { "LETTRE MODIFICATIVE MINUSCULE L","	# <exp> 006C"},
/* 02E2 */ { "LETTRE MODIFICATIVE MINUSCULE S","	# <exp> 0073"},
/* 02E3 */ { "LETTRE MODIFICATIVE MINUSCULE X","	# <exp> 0078"},
/* 02E4 */ { "LETTRE MODIFICATIVE MINUSCULE COUP DE GLOTTE RÉFLÉCHI","	# <exp> 0295"},
/* 02E5 */ { "LETTRE MODIFICATIVE BARRE DE TON TRÈS HAUT",NULL},
/* 02E6 */ { "LETTRE MODIFICATIVE BARRE DE TON HAUT",NULL},
/* 02E7 */ { "LETTRE MODIFICATIVE BARRE DE TON MOYEN",NULL},
/* 02E8 */ { "LETTRE MODIFICATIVE BARRE DE TON BAS",NULL},
/* 02E9 */ { "LETTRE MODIFICATIVE BARRE DE TON TRÈS BAS",NULL},
/* 02EA */ { "LETTRE MODIFICATIVE SIGNE DE TON DE DÉPART YIN",NULL},
/* 02EB */ { "LETTRE MODIFICATIVE SIGNE DE TON DE DÉPART YANG",NULL},
/* 02EC */ { "LETTRE MODIFICATIVE VOISÉE",NULL},
/* 02ED */ { "LETTRE MODIFICATIVE NON ASPIRÉE",NULL},
/* 02EE */ { "LETTRE MODIFICATIVE DOUBLE APOSTROPHE","	* nénetse"},
/* 02EF */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LE BAS BASSE",NULL},
/* 02F0 */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LE HAUT BASSE",NULL},
/* 02F1 */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LA GAUCHE BASSE",NULL},
/* 02F2 */ { "LETTRE MODIFICATIVE POINTE DE FLÈCHE VERS LA DROITE BASSE",NULL},
/* 02F3 */ { "LETTRE MODIFICATIVE ROND BAS","	x (diacritique rond souscrit - 0325)"},
/* 02F4 */ { "LETTRE MODIFICATIVE ACCENT GRAVE MÉDIAN",NULL},
/* 02F5 */ { "LETTRE MODIFICATIVE DOUBLE ACCENT GRAVE MÉDIAN",NULL},
/* 02F6 */ { "LETTRE MODIFICATIVE DOUBLE ACCENT AIGU MÉDIAN",NULL},
/* 02F7 */ { "LETTRE MODIFICATIVE TILDE BAS",NULL},
/* 02F8 */ { "LETTRE MODIFICATIVE DEUX-POINTS ÉLEVÉ",NULL},
/* 02F9 */ { "LETTRE MODIFICATIVE DÉBUT TON HAUT",NULL},
/* 02FA */ { "LETTRE MODIFICATIVE FIN TON HAUT",NULL},
/* 02FB */ { "LETTRE MODIFICATIVE DÉBUT TON BAS",NULL},
/* 02FC */ { "LETTRE MODIFICATIVE FIN TON BAS",NULL},
/* 02FD */ { "LETTRE MODIFICATIVE PLATEAU",NULL},
/* 02FE */ { "LETTRE MODIFICATIVE PLATEAU OUVERT",NULL},
/* 02FF */ { "LETTRE MODIFICATIVE FLÈCHE VERS LA GAUCHE BASSE",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_03[] = {
/* 0300 */ { "DIACRITIQUE ACCENT GRAVE","	= accent grave grec, varia grec\n"
	"	x (accent grave - 0060)\n"
	"	x (lettre modificative accent grave - 02CB)"},
/* 0301 */ { "DIACRITIQUE ACCENT AIGU","	= accent tonique\n"
	"	= accent aigu grec, oxeia grec\n"
	"	x (apostrophe - 0027)\n"
	"	x (accent aigu - 00B4)\n"
	"	x (lettre modificative prime - 02B9)\n"
	"	x (lettre modificative accent aigu - 02CA)\n"
	"	x (accent grec - 0384)"},
/* 0302 */ { "DIACRITIQUE ACCENT CIRCONFLEXE","	= chapeau\n"
	"	x (accent circonflexe - 005E)\n"
	"	x (lettre modificative accent circonflexe - 02C6)"},
/* 0303 */ { "DIACRITIQUE TILDE","	* API : nasalisation\n"
	"	* marque de ton vietnamienne\n"
	"	x (tilde - 007E)\n"
	"	x (petit tilde - 02DC)"},
/* 0304 */ { "DIACRITIQUE MACRON","	= long\n"
	"	* syriaque\n"
	"	* à distinguer du caractère suivant\n"
	"	x (macron - 00AF)\n"
	"	x (lettre modificative macron - 02C9)"},
/* 0305 */ { "DIACRITIQUE TIRET HAUT","	* se lie à gauche et à droite\n"
	"	x (macron - 00AF)"},
/* 0306 */ { "DIACRITIQUE BRÈVE","	= bref\n"
	"	= brève grecque, brakhus grec\n"
	"	x (brève - 02D8)\n"
	"	x (diacritique cyrillique kavyka - A67C)"},
/* 0307 */ { "DIACRITIQUE POINT EN CHEF","	= dérivée (notation newtonienne)\n"
	"	* syriaque\n"
	"	* API (retiré en 1976) : palatalisation\n"
	"	x (point en chef - 02D9)"},
/* 0308 */ { "DIACRITIQUE TRÉMA","	= double point en chef, tréma\n"
	"	= tréma grec\n"
	"	= dérivée double\n"
	"	* syriaque\n"
	"	x (tréma - 00A8)"},
/* 0309 */ { "DIACRITIQUE CROCHET EN CHEF","	= hoï\n"
	"	* crène à la gauche ou à la droite du diacritique au-dessus des voyelles\n"
	"	* marque de ton vietnamienne\n"
	"	x (lettre modificative coup de glotte - 02C0)"},
/* 030A */ { "DIACRITIQUE ROND EN CHEF","	* syriaque\n"
	"	x (symbole degré - 00B0)\n"
	"	x (rond en chef - 02DA)"},
/* 030B */ { "DIACRITIQUE DOUBLE ACCENT AIGU","	* hongrois, tchouvache\n"
	"	x (guillemet anglais - 0022)\n"
	"	x (lettre modificative seconde - 02BA)\n"
	"	x (double accent aigu - 02DD)"},
/* 030C */ { "DIACRITIQUE CARON","	= hatchek, chevron, accent hirondelle\n"
	"	x (caron - 02C7)"},
/* 030D */ { "DIACRITIQUE LIGNE VERTICALE EN CHEF","	* il ne s'agit pas d'un accent grec, en dépit de l'annotation contraire d'ISO 10646\n"
	"	* marshallais\n"
	"	x (lettre modificative ligne verticale - 02C8)"},
/* 030E */ { "DIACRITIQUE DOUBLE LIGNE VERTICALE EN CHEF","	* marshallais\n"
	"	x (guillemet anglais - 0022)"},
/* 030F */ { "DIACRITIQUE DOUBLE ACCENT GRAVE","	* phonétique serbe et croate"},
/* 0310 */ { "DIACRITIQUE TCHANDRABINDOU","	= candrabindu\n"
	"	x (diacritique dévanâgarî tchandrabindou - 0901)"},
/* 0311 */ { "DIACRITIQUE BRÈVE RENVERSÉE","	x (diacritique cyrillique de palatalisation - 0484)\n"
	"	x (diacritique cyrillique pokrytié - 0487)"},
/* 0312 */ { "DIACRITIQUE VIRGULE CULBUTÉE EN CHEF","	= cédille suscrite, cédille en chef\n"
	"	* letton (mais pas utilisé dans les décompositions)\n"
	"	x (lettre modificative virgule culbutée - 02BB)"},
/* 0313 */ { "DIACRITIQUE VIRGULE EN CHEF","	= esprit doux, psili grec\n"
	"	* éjective ou glottalisation des américanistes\n"
	"	x (lettre modificative apostrophe - 02BC)\n"
	"	x (diacritique cyrillique psili pneumata - 0486)\n"
	"	x (apostrophe arménienne - 055A)"},
/* 0314 */ { "DIACRITIQUE VIRGULE RÉFLÉCHIE EN CHEF","	= esprit rude, dasia grec\n"
	"	x (lettre modificative virgule réfléchie - 02BD)\n"
	"	x (diacritique cyrillique dasia pneumata - 0485)\n"
	"	x (lettre modificative arménienne demi-rond gauche - 0559)"},
/* 0315 */ { "DIACRITIQUE VIRGULE EN CHEF À DROITE","	x (lettre modificative apostrophe - 02BC)"},
/* 0316 */ { "DIACRITIQUE ACCENT GRAVE SOUSCRIT",NULL},
/* 0317 */ { "DIACRITIQUE ACCENT AIGU SOUSCRIT",NULL},
/* 0318 */ { "DIACRITIQUE TAQUET GAUCHE SOUSCRIT",NULL},
/* 0319 */ { "DIACRITIQUE TAQUET DROIT SOUSCRIT",NULL},
/* 031A */ { "DIACRITIQUE ANGLE GAUCHE EN CHEF","	* API : pas de détente audible"},
/* 031B */ { "DIACRITIQUE CORNU","	* vietnamien"},
/* 031C */ { "DIACRITIQUE DEMI-ROND GAUCHE SOUSCRIT","	* API : voyelle arrondie\n"
	"	x (lettre modificative taquet bas - 02D5)"},
/* 031D */ { "DIACRITIQUE TAQUET HAUT SOUSCRIT","	* API : élévation ou fermeture de voyelle\n"
	"	x (lettre modificative taquet haut - 02D4)"},
/* 031E */ { "DIACRITIQUE TAQUET BAS SOUSCRIT","	* API : abaissement ou ouverture de voyelle\n"
	"	x (lettre modificative taquet bas - 02D5)"},
/* 031F */ { "DIACRITIQUE SIGNE PLUS SOUSCRIT","	* API : articulation avancée ou protractée\n"
	"	x (lettre modificative signe plus - 02D6)"},
/* 0320 */ { "DIACRITIQUE SIGNE MOINS SOUSCRIT","	* syriaque\n"
	"	* API : articulation rétractée ou postérieure\n"
	"	* ce glyphe peut présenter de petits empattements\n"
	"	x (lettre modificative signe moins - 02D7)"},
/* 0321 */ { "DIACRITIQUE HAMEÇON PALATAL SOUSCRIT","	* API : palatalisation\n"
	"	x (lettre modificative minuscule j - 02B2)"},
/* 0322 */ { "DIACRITIQUE HAMEÇON RÉTROFLEXE SOUSCRIT","	* API : rétroflexion"},
/* 0323 */ { "DIACRITIQUE POINT SOUSCRIT","	= nang\n"
	"	* syriaque\n"
	"	* API : voyelle fermée\n"
	"	* américanistes et indo-européanistes : rétraction ou rétroflexion\n"
	"	* arabisants : vélarisation ou pharyngalisation\n"
	"	* marque de ton vietnamienne\n"
	"	x (lettre modificative taquet haut - 02D4)"},
/* 0324 */ { "DIACRITIQUE TRÉMA SOUSCRIT","	* syriaque\n"
	"	* API : voix soufflée ou murmure\n"
	"	x (lettre modificative minuscule h crosse - 02B1)"},
/* 0325 */ { "DIACRITIQUE ROND SOUSCRIT","	* API : sourd, non voisé\n"
	"	* vocalique (dans les translittérations latines des sonantes de l'Inde)\n"
	"	* madourais, syriaque\n"
	"	x (lettre modificative rond bas - 02F3)"},
/* 0326 */ { "DIACRITIQUE VIRGULE SOUSCRITE","	* roumain, letton, live"},
/* 0327 */ { "DIACRITIQUE CÉDILLE","	* français, turc, azéri\n"
	"	x (cédille - 00B8)"},
/* 0328 */ { "DIACRITIQUE OGONEK","	= crochet nasal\n"
	"	* américanistes : nasalisation\n"
	"	* polonais, lituanien\n"
	"	x (ogonek - 02DB)\n"
	"	x (diacritique ouverture souscrite - 1AB7)"},
/* 0329 */ { "DIACRITIQUE LIGNE VERTICALE SOUSCRITE","	* API : syllabique\n"
	"	* yorouba\n"
	"	* dialectologie allemande\n"
	"	* peut s'attacher ou non ; la forme peut varier selon les préférences\n"
	"	x (lettre modificative ligne verticale basse - 02CC)"},
/* 032A */ { "DIACRITIQUE PONTET SOUSCRIT","	* API : dentale"},
/* 032B */ { "DIACRITIQUE OMÉGA SOUSCRIT","	* API : labialisation\n"
	"	x (lettre modificative minuscule w - 02B7)"},
/* 032C */ { "DIACRITIQUE CARON SOUSCRIT","	* API : sonore, voisé"},
/* 032D */ { "DIACRITIQUE ACCENT CIRCONFLEXE SOUSCRIT","	* syriaque\n"
	"	* américanistes : articulation protractée"},
/* 032E */ { "DIACRITIQUE BRÈVE SOUSCRITE","	* syriaque\n"
	"	* transcription du hittite"},
/* 032F */ { "DIACRITIQUE BRÈVE RENVERSÉE SOUSCRITE","	* américanistes : articulation protractée (variante de 032D)\n"
	"	* indo-européanistes : semi-voyelle"},
/* 0330 */ { "DIACRITIQUE TILDE SOUSCRIT","	* syriaque\n"
	"	* API : voix cassée, traquée, Knarrstimme"},
/* 0331 */ { "DIACRITIQUE MACRON SOUSCRIT","	x (tiret bas - 005F)\n"
	"	x (lettre modificative macron bas - 02CD)"},
/* 0332 */ { "DIACRITIQUE TRAIT SOUSCRIT","	= souligné, tiret bas\n"
	"	* se lie à gauche et à droite\n"
	"	x (tiret bas - 005F)"},
/* 0333 */ { "DIACRITIQUE DOUBLE TRAIT SOUSCRIT","	= double souligné, double tiret bas\n"
	"	* se lie à gauche et à droite\n"
	"	x (diacritique signe égal souscrit - 0347)\n"
	"	x (double tiret bas - 2017)"},
/* 0334 */ { "DIACRITIQUE TILDE COUVRANT","	* API : vélarisation ou pharyngalisation"},
/* 0335 */ { "DIACRITIQUE BARRE COURTE COUVRANTE",NULL},
/* 0336 */ { "DIACRITIQUE BARRE LONGUE COUVRANTE",NULL},
/* 0337 */ { "DIACRITIQUE BARRE OBLIQUE COURTE COUVRANTE","	= cotice diminuée couvrante"},
/* 0338 */ { "DIACRITIQUE BARRE OBLIQUE LONGUE COUVRANTE","	= cotice couvrante"},
/* 0339 */ { "DIACRITIQUE DEMI-ROND DROIT SOUSCRIT",NULL},
/* 033A */ { "DIACRITIQUE PONTET RENVERSÉ SOUSCRIT","	* API : apicale\n"
	"	x (diacritique pont renversé souscrit - 1DF9)"},
/* 033B */ { "DIACRITIQUE CARRÉ SOUSCRIT","	* API : laminale\n"
	"	* pour un usage API, la forme recommandée du glyphe est un rectangle horizontal"},
/* 033C */ { "DIACRITIQUE MOUETTE SOUSCRITE","	* API : linguo-labiale"},
/* 033D */ { "DIACRITIQUE X EN CHEF",NULL},
/* 033E */ { "DIACRITIQUE TILDE VERTICAL","	= yérik (yérok)\n"
	"	* utilisé pour le yérik cyrillique, indique l'omission du yer\n"
	"	* il ne s'agit pas d'un signe de palatisation\n"
	"	x (diacritique cyrillique de palatalisation - 0484)\n"
	"	x (tilde vertical - 2E2F)\n"
	"	x (diacritique cyrillique payérok - A67D)"},
/* 033F */ { "DIACRITIQUE DOUBLE TRAIT EN CHEF",NULL},
/* 0340 */ { "DIACRITIQUE TON GRAVE","	: 0300 diacritique accent grave"},
/* 0341 */ { "DIACRITIQUE TON AIGU","	: 0301 diacritique accent aigu"},
/* 0342 */ { "DIACRITIQUE GREC ACCENT CIRCONFLEXE","	* son tracé représente la modulation vocale montante puis descendante\n"
	"	* une autre forme du glyphe rappelle une brève renversée\n"
	"	x (diacritique tilde - 0303)\n"
	"	x (diacritique brève renversée - 0311)"},
/* 0343 */ { "DIACRITIQUE GREC CORONIS","	= corônis (littéralement : « petit crochet »)\n"
	"	* la coronis est portée par la syllabe qui résulte d'une crase\n"
	"	* signe graphique semblable à l'esprit doux\n"
	"	: 0313 diacritique virgule en chef"},
/* 0344 */ { "DIACRITIQUE GREC TRÉMA ACCENT","	* l'utilisation de ce caractère est déconseillée\n"
	"	: 0308 0301"},
/* 0345 */ { "DIACRITIQUE GREC IOTA SOUSCRIT","	* présente des particularités liées à la casse\n"
	"	x (caractère grec iota souscrit - 037A)\n"
	"	x (lettre majuscule grecque iota - 0399)"},
/* 0346 */ { "DIACRITIQUE PONTET EN CHEF","	* API : dentolabiale\n"
	"	x (diacritique pont en chef - 20E9)"},
/* 0347 */ { "DIACRITIQUE SIGNE ÉGAL SOUSCRIT","	* API : alvéolaire"},
/* 0348 */ { "DIACRITIQUE DOUBLE LIGNE VERTICALE SOUSCRITE","	* API : forte articulation"},
/* 0349 */ { "DIACRITIQUE ANGLE GAUCHE SOUSCRIT","	* API : faible articulation"},
/* 034A */ { "DIACRITIQUE TILDE BARRÉ EN CHEF","	* API : dénasale"},
/* 034B */ { "DIACRITIQUE HOMOTHÉTIQUE EN CHEF","	* API : nasillement"},
/* 034C */ { "DIACRITIQUE PRESQUE ÉGAL À EN CHEF","	* API : friction vélopharyngale"},
/* 034D */ { "DIACRITIQUE FLÈCHE GAUCHE-DROITE SOUSCRITE","	* API : écartement labial"},
/* 034E */ { "DIACRITIQUE FLÈCHE VERS LE HAUT SOUSCRITE","	* API : articulation sifflée"},
/* 034F */ { "DIACRITIQUE INVISIBLE BLOQUANT","	* il n'a pas de représentation visible\n"
	"	* sert à indiquer qu'une séquence de caractères ne doit pas être considérée comme un seul graphème ou qu'une séquence de diacritiques ne doit pas être réordonnée selon l'algorithme habituel\n"
	"	* le nom anglais de ce caractère (« combining grapheme joiner », communément abrégé CGJ) ne représente pas sa fonction"},
/* 0350 */ { "DIACRITIQUE POINTE DE FLÈCHE VERS LA DROITE EN CHEF",NULL},
/* 0351 */ { "DIACRITIQUE DEMI-ROND GAUCHE EN CHEF",NULL},
/* 0352 */ { "DIACRITIQUE POINT D'ORGUE",NULL},
/* 0353 */ { "DIACRITIQUE X SOUSCRIT",NULL},
/* 0354 */ { "DIACRITIQUE POINTE DE FLÈCHE VERS LA GAUCHE SOUSCRITE",NULL},
/* 0355 */ { "DIACRITIQUE POINTE DE FLÈCHE VERS LA DROITE SOUSCRITE",NULL},
/* 0356 */ { "DIACRITIQUE POINTES DE FLÈCHE VERS LA DROITE ET VERS LE HAUT SOUSCRITES",NULL},
/* 0357 */ { "DIACRITIQUE DEMI-ROND DROIT EN CHEF",NULL},
/* 0358 */ { "DIACRITIQUE POINT EN CHEF À DROITE","	* translittération latine des dialectes chinois min-nan\n"
	"	x (diacritique point en chef à gauche - 1DF8)"},
/* 0359 */ { "DIACRITIQUE ASTÉRISQUE SOUSCRIT","	x (astérisque baissé - 204E)"},
/* 035A */ { "DIACRITIQUE DOUBLE ROND SOUSCRIT","	* translittération du kharochthî"},
/* 035B */ { "DIACRITIQUE ZIGZAG EN CHEF","	* abréviation latine, phonétique lituanienne et transcriptions médiévistes"},
/* 035C */ { "DIACRITIQUE DOUBLE BRÈVE SOUSCRITE","	= ligature tirant souscrit, trait d'union papyrologique\n"
	"	* un autre glyphe courant relie les caractères voisins à mi-hauteur\n"
	"	x (diacritique double brève - 035D)\n"
	"	x (diacritique double brève renversée - 0361)\n"
	"	x (diacritique moitié gauche de ligature souscrite - FE27)"},
/* 035D */ { "DIACRITIQUE DOUBLE BRÈVE",NULL},
/* 035E */ { "DIACRITIQUE DOUBLE MACRON",NULL},
/* 035F */ { "DIACRITIQUE DOUBLE MACRON SOUSCRIT",NULL},
/* 0360 */ { "DIACRITIQUE DOUBLE TILDE",NULL},
/* 0361 */ { "DIACRITIQUE DOUBLE BRÈVE RENVERSÉE","	= ligature tirant\n"
	"	x (diacritique moitié gauche de ligature - FE20)"},
/* 0362 */ { "DIACRITIQUE DOUBLE FLÈCHE VERS LA DROITE SOUSCRITE","	* API : articulation glissante"},
/* 0363 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE A",NULL},
/* 0364 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE E",NULL},
/* 0365 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE I",NULL},
/* 0366 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE O",NULL},
/* 0367 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE U",NULL},
/* 0368 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE C",NULL},
/* 0369 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE D",NULL},
/* 036A */ { "DIACRITIQUE LETTRE MINUSCULE LATINE H",NULL},
/* 036B */ { "DIACRITIQUE LETTRE MINUSCULE LATINE M",NULL},
/* 036C */ { "DIACRITIQUE LETTRE MINUSCULE LATINE R",NULL},
/* 036D */ { "DIACRITIQUE LETTRE MINUSCULE LATINE T",NULL},
/* 036E */ { "DIACRITIQUE LETTRE MINUSCULE LATINE V",NULL},
/* 036F */ { "DIACRITIQUE LETTRE MINUSCULE LATINE X",NULL},
/* 0370 */ { "LETTRE MAJUSCULE GRECQUE HÊTA","	x (lettre majuscule latine moitié de h - 2C75)"},
/* 0371 */ { "LETTRE MINUSCULE GRECQUE HÊTA","	x (lettre minuscule latine moitié de h - 2C76)"},
/* 0372 */ { "LETTRE MAJUSCULE GRECQUE SAMPI ARCHAÏQUE",NULL},
/* 0373 */ { "LETTRE MINUSCULE GRECQUE SAMPI ARCHAÏQUE",NULL},
/* 0374 */ { "SIGNE NUMÉRAL GREC","	= dexia keréa\n"
	"	* signe se plaçant à droite des lettres\n"
	"	* pour les nombres inférieurs à 1.000\n"
	"	x (lettre modificative accent aigu - 02CA)\n"
	"	: 02B9 lettre modificative prime"},
/* 0375 */ { "SIGNE NUMÉRAL GREC SOUSCRIT","	= aristerí keréa\n"
	"	* signe se plaçant à gauche des lettres\n"
	"	* pour les nombres supérieurs à 999\n"
	"	x (lettre modificative accent aigu bas - 02CF)"},
/* 0376 */ { "LETTRE MAJUSCULE GRECQUE DIGAMMA PAMPHYLIEN",NULL},
/* 0377 */ { "LETTRE MINUSCULE GRECQUE DIGAMMA PAMPHYLIEN",NULL},
/* 0378 */ { NULL,NULL},
/* 0379 */ { NULL,NULL},
/* 037A */ { "CARACTÈRE GREC IOTA SOUSCRIT","	x (diacritique grec iota souscrit - 0345)\n"
	"	# 0020 0345"},
/* 037B */ { "SYMBOLE GREC SIGMA LUNAIRE MINUSCULE RÉFLÉCHI",NULL},
/* 037C */ { "SYMBOLE GREC SIGMA LUNAIRE MINUSCULE POINTÉ",NULL},
/* 037D */ { "SYMBOLE GREC SIGMA LUNAIRE MINUSCULE POINTÉ RÉFLÉCHI",NULL},
/* 037E */ { "POINT D'INTERROGATION GREC","	= érotimatiko\n"
	"	* ponctuation de fin de phrase\n"
	"	* 003B est le caractère recommandé\n"
	"	x (point d'interrogation - 003F)\n"
	"	: 003B point-virgule"},
/* 037F */ { "LETTRE MAJUSCULE GRECQUE YOT","	* la minuscule est 03F3"},
/* 0380 */ { NULL,NULL},
/* 0381 */ { NULL,NULL},
/* 0382 */ { NULL,NULL},
/* 0383 */ { NULL,NULL},
/* 0384 */ { "ACCENT GREC","	= caractère grec accent aigu\n"
	"	x (accent aigu - 00B4)\n"
	"	x (diacritique ligne verticale en chef - 030D)\n"
	"	# 0020 0301"},
/* 0385 */ { "TRÉMA ACCENT GREC","	* décomposition par équivalence de compatibilité : 0020 0308 0301\n"
	"	: 00A8 0301"},
/* 0386 */ { "LETTRE MAJUSCULE GRECQUE ALPHA ACCENT","	: 0391 0301"},
/* 0387 */ { "ANO TELEIA GREC","	= point en haut, point-virgule grec\n"
	"	* équivalent grec du point-virgule\n"
	"	* 00B7 est le caractère recommandé\n"
	"	: 00B7 point médian"},
/* 0388 */ { "LETTRE MAJUSCULE GRECQUE EPSILON ACCENT","	: 0395 0301"},
/* 0389 */ { "LETTRE MAJUSCULE GRECQUE ÊTA ACCENT","	: 0397 0301"},
/* 038A */ { "LETTRE MAJUSCULE GRECQUE IOTA ACCENT","	: 0399 0301"},
/* 038B */ { NULL,NULL},
/* 038C */ { "LETTRE MAJUSCULE GRECQUE OMICRON ACCENT","	: 039F 0301"},
/* 038D */ { NULL,NULL},
/* 038E */ { "LETTRE MAJUSCULE GRECQUE UPSILON ACCENT","	: 03A5 0301"},
/* 038F */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ACCENT","	: 03A9 0301"},
/* 0390 */ { "LETTRE MINUSCULE GRECQUE IOTA TRÉMA ET ACCENT","	: 03CA 0301"},
/* 0391 */ { "LETTRE MAJUSCULE GRECQUE ALPHA",NULL},
/* 0392 */ { "LETTRE MAJUSCULE GRECQUE BÊTA",NULL},
/* 0393 */ { "LETTRE MAJUSCULE GRECQUE GAMMA","	= fonction gamma\n"
	"	x (majuscule gamma ajouré - 213E)"},
/* 0394 */ { "LETTRE MAJUSCULE GRECQUE DELTA","	x (incrément - 2206)"},
/* 0395 */ { "LETTRE MAJUSCULE GRECQUE EPSILON",NULL},
/* 0396 */ { "LETTRE MAJUSCULE GRECQUE DZÊTA",NULL},
/* 0397 */ { "LETTRE MAJUSCULE GRECQUE ÊTA",NULL},
/* 0398 */ { "LETTRE MAJUSCULE GRECQUE THÊTA",NULL},
/* 0399 */ { "LETTRE MAJUSCULE GRECQUE IOTA","	= iota adscrit"},
/* 039A */ { "LETTRE MAJUSCULE GRECQUE KAPPA",NULL},
/* 039B */ { "LETTRE MAJUSCULE GRECQUE LAMBDA",NULL},
/* 039C */ { "LETTRE MAJUSCULE GRECQUE MU",NULL},
/* 039D */ { "LETTRE MAJUSCULE GRECQUE NU",NULL},
/* 039E */ { "LETTRE MAJUSCULE GRECQUE XI",NULL},
/* 039F */ { "LETTRE MAJUSCULE GRECQUE OMICRON",NULL},
/* 03A0 */ { "LETTRE MAJUSCULE GRECQUE PI","	x (majuscule pi ajouré - 213F)\n"
	"	x (produit de la famille - 220F)"},
/* 03A1 */ { "LETTRE MAJUSCULE GRECQUE RHÔ",NULL},
/* 03A2 */ { NULL,NULL},
/* 03A3 */ { "LETTRE MAJUSCULE GRECQUE SIGMA","	x (lettre majuscule latine ech - 01A9)\n"
	"	x (sommation de la famille - 2211)"},
/* 03A4 */ { "LETTRE MAJUSCULE GRECQUE TAU",NULL},
/* 03A5 */ { "LETTRE MAJUSCULE GRECQUE UPSILON",NULL},
/* 03A6 */ { "LETTRE MAJUSCULE GRECQUE PHI",NULL},
/* 03A7 */ { "LETTRE MAJUSCULE GRECQUE KHI",NULL},
/* 03A8 */ { "LETTRE MAJUSCULE GRECQUE PSI",NULL},
/* 03A9 */ { "LETTRE MAJUSCULE GRECQUE OMÉGA","	x (symbole ohm - 2126)\n"
	"	x (symbole ohm renversé - 2127)"},
/* 03AA */ { "LETTRE MAJUSCULE GRECQUE IOTA TRÉMA","	: 0399 0308"},
/* 03AB */ { "LETTRE MAJUSCULE GRECQUE UPSILON TRÉMA","	: 03A5 0308"},
/* 03AC */ { "LETTRE MINUSCULE GRECQUE ALPHA ACCENT","	: 03B1 0301"},
/* 03AD */ { "LETTRE MINUSCULE GRECQUE EPSILON ACCENT","	: 03B5 0301"},
/* 03AE */ { "LETTRE MINUSCULE GRECQUE ÊTA ACCENT","	: 03B7 0301"},
/* 03AF */ { "LETTRE MINUSCULE GRECQUE IOTA ACCENT","	: 03B9 0301"},
/* 03B0 */ { "LETTRE MINUSCULE GRECQUE UPSILON TRÉMA ET ACCENT","	: 03CB 0301"},
/* 03B1 */ { "LETTRE MINUSCULE GRECQUE ALPHA","	x (lettre minuscule latine alpha - 0251)\n"
	"	x (proportionnel à - 221D)"},
/* 03B2 */ { "LETTRE MINUSCULE GRECQUE BÊTA","	x (lettre minuscule latine s dur - 00DF)\n"
	"	x (lettre minuscule latine b barré - 0180)\n"
	"	x (lettre minuscule latine bêta - A7B5)"},
/* 03B3 */ { "LETTRE MINUSCULE GRECQUE GAMMA","	x (lettre minuscule latine gamma - 0263)\n"
	"	x (minuscule gamma ajouré - 213D)"},
/* 03B4 */ { "LETTRE MINUSCULE GRECQUE DELTA",NULL},
/* 03B5 */ { "LETTRE MINUSCULE GRECQUE EPSILON","	x (lettre minuscule latine e ouvert - 025B)"},
/* 03B6 */ { "LETTRE MINUSCULE GRECQUE DZÊTA",NULL},
/* 03B7 */ { "LETTRE MINUSCULE GRECQUE ÊTA",NULL},
/* 03B8 */ { "LETTRE MINUSCULE GRECQUE THÊTA","	x (lettre minuscule latine o barré - 0275)\n"
	"	x (lettre minuscule cyrillique fita - 0473)"},
/* 03B9 */ { "LETTRE MINUSCULE GRECQUE IOTA","	x (lettre minuscule latine iota - 0269)\n"
	"	x (lettre minuscule grecque iota culbuté - 2129)"},
/* 03BA */ { "LETTRE MINUSCULE GRECQUE KAPPA",NULL},
/* 03BB */ { "LETTRE MINUSCULE GRECQUE LAMBDA",NULL},
/* 03BC */ { "LETTRE MINUSCULE GRECQUE MU","	x (symbole micro - 00B5)"},
/* 03BD */ { "LETTRE MINUSCULE GRECQUE NU",NULL},
/* 03BE */ { "LETTRE MINUSCULE GRECQUE XI",NULL},
/* 03BF */ { "LETTRE MINUSCULE GRECQUE OMICRON",NULL},
/* 03C0 */ { "LETTRE MINUSCULE GRECQUE PI","	* la constante mathématique 3,141592..."},
/* 03C1 */ { "LETTRE MINUSCULE GRECQUE RHÔ",NULL},
/* 03C2 */ { "LETTRE MINUSCULE GRECQUE SIGMA FINAL","	= stigma (nom en grec moderne pour cette forme de la lettre)\n"
	"	* à ne pas confondre avec la vraie lettre stigma\n"
	"	x (lettre minuscule grecque stigma - 03DB)"},
/* 03C3 */ { "LETTRE MINUSCULE GRECQUE SIGMA","	* lettre numérale pour noter le nombre 200 dans le système de numération grecque"},
/* 03C4 */ { "LETTRE MINUSCULE GRECQUE TAU",NULL},
/* 03C5 */ { "LETTRE MINUSCULE GRECQUE UPSILON","	x (lettre minuscule latine upsilon - 028A)\n"
	"	x (lettre minuscule latine v crosse - 028B)"},
/* 03C6 */ { "LETTRE MINUSCULE GRECQUE PHI","	x (lettre minuscule latine phi - 0278)\n"
	"	x (symbole grec phi - 03D5)\n"
	"	* la lettre grecque habituelle, dont la représentation graphique varie considérablement\n"
	"	* en mathématique, on préfère la forme bouclée pour la distinguer de 03D5"},
/* 03C7 */ { "LETTRE MINUSCULE GRECQUE KHI","	x (lettre minuscule latine khi - AB53)"},
/* 03C8 */ { "LETTRE MINUSCULE GRECQUE PSI",NULL},
/* 03C9 */ { "LETTRE MINUSCULE GRECQUE OMÉGA","	x (lettre minuscule latine oméga - A7B7)"},
/* 03CA */ { "LETTRE MINUSCULE GRECQUE IOTA TRÉMA","	: 03B9 0308"},
/* 03CB */ { "LETTRE MINUSCULE GRECQUE UPSILON TRÉMA","	: 03C5 0308"},
/* 03CC */ { "LETTRE MINUSCULE GRECQUE OMICRON ACCENT","	: 03BF 0301"},
/* 03CD */ { "LETTRE MINUSCULE GRECQUE UPSILON ACCENT","	: 03C5 0301"},
/* 03CE */ { "LETTRE MINUSCULE GRECQUE OMÉGA ACCENT","	: 03C9 0301"},
/* 03CF */ { "SYMBOLE GREC KAI MAJUSCULE","	x (symbole grec kai - 03D7)"},
/* 03D0 */ { "SYMBOLE GREC BÊTA","	= bêta courbé, bêta bouclé\n"
	"	# 03B2 lettre minuscule grecque bêta"},
/* 03D1 */ { "SYMBOLE GREC THÊTA","	= thêta cursif\n"
	"	* utilisé comme symbole technique\n"
	"	# 03B8 lettre minuscule grecque thêta"},
/* 03D2 */ { "SYMBOLE GREC UPSILON CROCHET","	# 03A5 lettre majuscule grecque upsilon"},
/* 03D3 */ { "SYMBOLE GREC UPSILON ACCENT AIGU ET CROCHET","	: 03D2 0301"},
/* 03D4 */ { "SYMBOLE GREC UPSILON TRÉMA ET CROCHET","	= lettre majuscule grecque upsilon tréma et crochet\n"
	"	: 03D2 0308"},
/* 03D5 */ { "SYMBOLE GREC PHI","	* utilisé comme symbole technique à l'aide d'un glyphe droit\n"
	"	* correspond aux entités de symbole « phi1 »\n"
	"	# 03C6 lettre minuscule grecque phi"},
/* 03D6 */ { "SYMBOLE GREC PI","	= pi dorien, pi cursif, oméga pi\n"
	"	* utilisé comme symbole technique\n"
	"	* une variante du pi, ressemblant à un oméga\n"
	"	# 03C0 lettre minuscule grecque pi"},
/* 03D7 */ { "SYMBOLE GREC KAI","	= ligature kai\n"
	"	* utilisé comme perluète\n"
	"	x (symbole copte kai - 2CE4)"},
/* 03D8 */ { "LETTRE GRECQUE KOPPA ARCHAÏQUE",NULL},
/* 03D9 */ { "LETTRE MINUSCULE GRECQUE KOPPA ARCHAÏQUE","	* les koppas archaïques en Q constituent les lettres alphabétiques habituelles et peuvent être utilisés aussi comme symboles pour noter le nombre 90 dans les textes classiques et préclassiques"},
/* 03DA */ { "LETTRE GRECQUE STIGMA","	* le nom « stigma » s'appliquait à l'origine à une ligature sigma-tau médiévale, dont la forme pouvait être méprise pour celle d'une forme cursive du digamma\n"
	"	* sert à la numération alphabétique grecque avec la valeur 6\n"
	"	x (chiffre romain six forme tardive - 2185)"},
/* 03DB */ { "LETTRE MINUSCULE GRECQUE STIGMA","	x (lettre minuscule grecque sigma final - 03C2)"},
/* 03DC */ { "LETTRE GRECQUE DIGAMMA","	= waw"},
/* 03DD */ { "LETTRE MINUSCULE GRECQUE DIGAMMA","	= waw minuscule\n"
	"	* sert à la numération alphabétique grecque avec la valeur 6"},
/* 03DE */ { "LETTRE GRECQUE KOPPA",NULL},
/* 03DF */ { "LETTRE MINUSCULE GRECQUE KOPPA","	* utilisée en grec moderne pour noter le nombre 90, par exemple dans la datation de documents juridiques"},
/* 03E0 */ { "LETTRE GRECQUE SAMPI","	= san"},
/* 03E1 */ { "LETTRE MINUSCULE GRECQUE SAMPI","	= san minuscule\n"
	"	* sert dans la numération alphabétique pour noter le nombre 900"},
/* 03E2 */ { "LETTRE MAJUSCULE COPTE CHAÏ",NULL},
/* 03E3 */ { "LETTRE MINUSCULE COPTE CHAÏ",NULL},
/* 03E4 */ { "LETTRE MAJUSCULE COPTE FAÏ",NULL},
/* 03E5 */ { "LETTRE MINUSCULE COPTE FAÏ",NULL},
/* 03E6 */ { "LETTRE MAJUSCULE COPTE KHAÏ",NULL},
/* 03E7 */ { "LETTRE MINUSCULE COPTE KHAÏ",NULL},
/* 03E8 */ { "LETTRE MAJUSCULE COPTE HORI",NULL},
/* 03E9 */ { "LETTRE MINUSCULE COPTE HORI",NULL},
/* 03EA */ { "LETTRE MAJUSCULE COPTE DJANDJA",NULL},
/* 03EB */ { "LETTRE MINUSCULE COPTE DJANDJA",NULL},
/* 03EC */ { "LETTRE MAJUSCULE COPTE TCHIMA",NULL},
/* 03ED */ { "LETTRE MINUSCULE COPTE TCHIMA",NULL},
/* 03EE */ { "LETTRE MAJUSCULE COPTE TI",NULL},
/* 03EF */ { "LETTRE MINUSCULE COPTE TI",NULL},
/* 03F0 */ { "SYMBOLE GREC KAPPA","	= kappa cursif\n"
	"	* utilisé comme symbole technique\n"
	"	# 03BA lettre minuscule grecque kappa"},
/* 03F1 */ { "SYMBOLE GREC RHÔ","	= rhô à queue\n"
	"	* utilisé comme symbole technique\n"
	"	# 03C1 lettre minuscule grecque rhô"},
/* 03F2 */ { "SYMBOLE GREC SIGMA LUNAIRE","	= lettre minuscule grecque sigma lunaire (1.0)\n"
	"	# 03C2 lettre minuscule grecque sigma final"},
/* 03F3 */ { "LETTRE GRECQUE YOT","	* la majuscule est 037F"},
/* 03F4 */ { "SYMBOLE GREC THÊTA MAJUSCULE","	x (lettre majuscule cyrillique fita - 0472)\n"
	"	# 0398 lettre majuscule grecque thêta"},
/* 03F5 */ { "SYMBOLE GREC EPSILON LUNAIRE","	= epsilon droit\n"
	"	x (petit appartient à - 220A)\n"
	"	# 03B5 lettre minuscule grecque epsilon"},
/* 03F6 */ { "SYMBOLE GREC EPSILON LUNAIRE RÉFLÉCHI","	= epsilon droit réfléchi\n"
	"	x (petit contient comme élément - 220D)"},
/* 03F7 */ { "LETTRE MAJUSCULE GRECQUE CHO",NULL},
/* 03F8 */ { "LETTRE MINUSCULE GRECQUE CHO",NULL},
/* 03F9 */ { "SYMBOLE GREC SIGMA LUNAIRE MAJUSCULE","	# 03A3 lettre majuscule grecque sigma"},
/* 03FA */ { "LETTRE MAJUSCULE GRECQUE SAN",NULL},
/* 03FB */ { "LETTRE MINUSCULE GRECQUE SAN",NULL},
/* 03FC */ { "SYMBOLE GREC RHÔ BARRÉ","	* utilisé avec des abréviations qui contiennent 03C1"},
/* 03FD */ { "SYMBOLE GREC SIGMA LUNAIRE MAJUSCULE RÉFLÉCHI","	= antisigma\n"
	"	* indique qu'une ligne d'un texte se trouve à une position incorrecte"},
/* 03FE */ { "SYMBOLE GREC SIGMA LUNAIRE MAJUSCULE POINTÉ","	= sigma périestigmenon\n"
	"	* indique qu'un réarrangement doit être effectué"},
/* 03FF */ { "SYMBOLE GREC SIGMA LUNAIRE MAJUSCULE POINTÉ RÉFLÉCHI","	= antisigma périestigmenon\n"
	"	* indique que les lignes qui succèdent à ce symbole doivent être déplacées à l'endroit marqué par 03FE"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_04[] = {
/* 0400 */ { "LETTRE MAJUSCULE CYRILLIQUE IÉ GRAVE","	: 0415 0300"},
/* 0401 */ { "LETTRE MAJUSCULE CYRILLIQUE IO","	: 0415 0308"},
/* 0402 */ { "LETTRE MAJUSCULE CYRILLIQUE DJÉ","	* serbe"},
/* 0403 */ { "LETTRE MAJUSCULE CYRILLIQUE GUIÉ","	: 0413 0301"},
/* 0404 */ { "LETTRE MAJUSCULE CYRILLIQUE IÉ UKRAINIEN",NULL},
/* 0405 */ { "LETTRE MAJUSCULE CYRILLIQUE DZÉ",NULL},
/* 0406 */ { "LETTRE MAJUSCULE CYRILLIQUE I BIÉLORUSSE-UKRAINIEN","	x (lettre majuscule latine i - 0049)\n"
	"	x (lettre minuscule cyrillique i biélorusse-ukrainien - 0456)\n"
	"	x (lettre cyrillique palotchka - 04C0)"},
/* 0407 */ { "LETTRE MAJUSCULE CYRILLIQUE YI","	* ukrainien\n"
	"	: 0406 0308"},
/* 0408 */ { "LETTRE MAJUSCULE CYRILLIQUE YÉ",NULL},
/* 0409 */ { "LETTRE MAJUSCULE CYRILLIQUE LIÉ",NULL},
/* 040A */ { "LETTRE MAJUSCULE CYRILLIQUE ÑÉ",NULL},
/* 040B */ { "LETTRE MAJUSCULE CYRILLIQUE TIÉ","	* serbe"},
/* 040C */ { "LETTRE MAJUSCULE CYRILLIQUE KIÉ","	: 041A 0301"},
/* 040D */ { "LETTRE MAJUSCULE CYRILLIQUE I GRAVE","	: 0418 0300"},
/* 040E */ { "LETTRE MAJUSCULE CYRILLIQUE OU BREF","	* biélorusse\n"
	"	: 0423 0306"},
/* 040F */ { "LETTRE MAJUSCULE CYRILLIQUE DZHÉ",NULL},
/* 0410 */ { "LETTRE MAJUSCULE CYRILLIQUE A",NULL},
/* 0411 */ { "LETTRE MAJUSCULE CYRILLIQUE BÉ","	x (lettre minuscule latine b potence - 0183)"},
/* 0412 */ { "LETTRE MAJUSCULE CYRILLIQUE VÉ",NULL},
/* 0413 */ { "LETTRE MAJUSCULE CYRILLIQUE GUÉ",NULL},
/* 0414 */ { "LETTRE MAJUSCULE CYRILLIQUE DÉ",NULL},
/* 0415 */ { "LETTRE MAJUSCULE CYRILLIQUE IÉ",NULL},
/* 0416 */ { "LETTRE MAJUSCULE CYRILLIQUE JÉ",NULL},
/* 0417 */ { "LETTRE MAJUSCULE CYRILLIQUE ZÉ",NULL},
/* 0418 */ { "LETTRE MAJUSCULE CYRILLIQUE I",NULL},
/* 0419 */ { "LETTRE MAJUSCULE CYRILLIQUE I BREF","	: 0418 0306"},
/* 041A */ { "LETTRE MAJUSCULE CYRILLIQUE KA",NULL},
/* 041B */ { "LETTRE MAJUSCULE CYRILLIQUE ELLE",NULL},
/* 041C */ { "LETTRE MAJUSCULE CYRILLIQUE EMME",NULL},
/* 041D */ { "LETTRE MAJUSCULE CYRILLIQUE ENNE",NULL},
/* 041E */ { "LETTRE MAJUSCULE CYRILLIQUE O",NULL},
/* 041F */ { "LETTRE MAJUSCULE CYRILLIQUE PÉ",NULL},
/* 0420 */ { "LETTRE MAJUSCULE CYRILLIQUE ERRE",NULL},
/* 0421 */ { "LETTRE MAJUSCULE CYRILLIQUE ESSE",NULL},
/* 0422 */ { "LETTRE MAJUSCULE CYRILLIQUE TÉ",NULL},
/* 0423 */ { "LETTRE MAJUSCULE CYRILLIQUE OU","	x (lettre majuscule cyrillique ouk - 0478)\n"
	"	x (lettre minuscule cyrillique ou droit - 04AF)\n"
	"	x (lettre majuscule cyrillique monogramme ouk - A64A)"},
/* 0424 */ { "LETTRE MAJUSCULE CYRILLIQUE EFFE",NULL},
/* 0425 */ { "LETTRE MAJUSCULE CYRILLIQUE KHA",NULL},
/* 0426 */ { "LETTRE MAJUSCULE CYRILLIQUE TSÉ",NULL},
/* 0427 */ { "LETTRE MAJUSCULE CYRILLIQUE TCHÉ",NULL},
/* 0428 */ { "LETTRE MAJUSCULE CYRILLIQUE CHA",NULL},
/* 0429 */ { "LETTRE MAJUSCULE CYRILLIQUE CHTCHA",NULL},
/* 042A */ { "LETTRE MAJUSCULE CYRILLIQUE SIGNE DUR",NULL},
/* 042B */ { "LETTRE MAJUSCULE CYRILLIQUE YÉROU","	= i dur majuscule"},
/* 042C */ { "LETTRE MAJUSCULE CYRILLIQUE SIGNE MOU",NULL},
/* 042D */ { "LETTRE MAJUSCULE CYRILLIQUE É",NULL},
/* 042E */ { "LETTRE MAJUSCULE CYRILLIQUE IOU",NULL},
/* 042F */ { "LETTRE MAJUSCULE CYRILLIQUE IA",NULL},
/* 0430 */ { "LETTRE MINUSCULE CYRILLIQUE A",NULL},
/* 0431 */ { "LETTRE MINUSCULE CYRILLIQUE BÉ",NULL},
/* 0432 */ { "LETTRE MINUSCULE CYRILLIQUE VÉ",NULL},
/* 0433 */ { "LETTRE MINUSCULE CYRILLIQUE GUÉ",NULL},
/* 0434 */ { "LETTRE MINUSCULE CYRILLIQUE DÉ",NULL},
/* 0435 */ { "LETTRE MINUSCULE CYRILLIQUE IÉ",NULL},
/* 0436 */ { "LETTRE MINUSCULE CYRILLIQUE JÉ",NULL},
/* 0437 */ { "LETTRE MINUSCULE CYRILLIQUE ZÉ",NULL},
/* 0438 */ { "LETTRE MINUSCULE CYRILLIQUE I",NULL},
/* 0439 */ { "LETTRE MINUSCULE CYRILLIQUE I BREF","	: 0438 0306"},
/* 043A */ { "LETTRE MINUSCULE CYRILLIQUE KA",NULL},
/* 043B */ { "LETTRE MINUSCULE CYRILLIQUE ELLE",NULL},
/* 043C */ { "LETTRE MINUSCULE CYRILLIQUE EMME",NULL},
/* 043D */ { "LETTRE MINUSCULE CYRILLIQUE ENNE",NULL},
/* 043E */ { "LETTRE MINUSCULE CYRILLIQUE O",NULL},
/* 043F */ { "LETTRE MINUSCULE CYRILLIQUE PÉ",NULL},
/* 0440 */ { "LETTRE MINUSCULE CYRILLIQUE ERRE",NULL},
/* 0441 */ { "LETTRE MINUSCULE CYRILLIQUE ESSE",NULL},
/* 0442 */ { "LETTRE MINUSCULE CYRILLIQUE TÉ",NULL},
/* 0443 */ { "LETTRE MINUSCULE CYRILLIQUE OU",NULL},
/* 0444 */ { "LETTRE MINUSCULE CYRILLIQUE EFFE",NULL},
/* 0445 */ { "LETTRE MINUSCULE CYRILLIQUE KHA",NULL},
/* 0446 */ { "LETTRE MINUSCULE CYRILLIQUE TSÉ",NULL},
/* 0447 */ { "LETTRE MINUSCULE CYRILLIQUE TCHÉ",NULL},
/* 0448 */ { "LETTRE MINUSCULE CYRILLIQUE CHA",NULL},
/* 0449 */ { "LETTRE MINUSCULE CYRILLIQUE CHTCHA",NULL},
/* 044A */ { "LETTRE MINUSCULE CYRILLIQUE SIGNE DUR",NULL},
/* 044B */ { "LETTRE MINUSCULE CYRILLIQUE YÉROU","	= i dur minuscule\n"
	"	x (lettre minuscule cyrillique yérou à yer postérieur - A651)"},
/* 044C */ { "LETTRE MINUSCULE CYRILLIQUE SIGNE MOU","	x (lettre minuscule latine sixième ton - 0185)\n"
	"	x (lettre minuscule cyrillique yér neutre - A64F)"},
/* 044D */ { "LETTRE MINUSCULE CYRILLIQUE É",NULL},
/* 044E */ { "LETTRE MINUSCULE CYRILLIQUE IOU","	x (lettre minuscule cyrillique you réfléchi - A655)"},
/* 044F */ { "LETTRE MINUSCULE CYRILLIQUE IA",NULL},
/* 0450 */ { "LETTRE MINUSCULE CYRILLIQUE IÉ GRAVE","	* macédonien\n"
	"	: 0435 0300"},
/* 0451 */ { "LETTRE MINUSCULE CYRILLIQUE IO","	* russe, etc.\n"
	"	: 0435 0308"},
/* 0452 */ { "LETTRE MINUSCULE CYRILLIQUE DJÉ","	* serbe\n"
	"	x (lettre minuscule latine d barré - 0111)"},
/* 0453 */ { "LETTRE MINUSCULE CYRILLIQUE GUIÉ","	* macédonien\n"
	"	: 0433 0301"},
/* 0454 */ { "LETTRE MINUSCULE CYRILLIQUE IÉ UKRAINIEN","	= yeste vieux cyrillique"},
/* 0455 */ { "LETTRE MINUSCULE CYRILLIQUE DZÉ","	= dzélo vieux cyrillique\n"
	"	* macédonien\n"
	"	x (lettre minuscule cyrillique dzélo - A643)"},
/* 0456 */ { "LETTRE MINUSCULE CYRILLIQUE I BIÉLORUSSE-UKRAINIEN","	= i vieux cyrillique"},
/* 0457 */ { "LETTRE MINUSCULE CYRILLIQUE YI","	* ukrainien\n"
	"	: 0456 0308"},
/* 0458 */ { "LETTRE MINUSCULE CYRILLIQUE YÉ","	* serbe, azéri, altaï"},
/* 0459 */ { "LETTRE MINUSCULE CYRILLIQUE LIÉ","	* serbe, macédonien\n"
	"	x (lettre minuscule latine lj - 01C9)"},
/* 045A */ { "LETTRE MINUSCULE CYRILLIQUE ÑÉ","	* serbe, macédonien\n"
	"	x (lettre minuscule latine nj - 01CC)"},
/* 045B */ { "LETTRE MINUSCULE CYRILLIQUE TIÉ","	= gyerve vieux cyrillique\n"
	"	* serbe\n"
	"	x (lettre minuscule latine c accent aigu - 0107)\n"
	"	x (lettre minuscule latine h barré - 0127)\n"
	"	x (lettre majuscule cyrillique tié - 040B)\n"
	"	x (constante de planck sur deux pi - 210F)\n"
	"	x (lettre minuscule cyrillique diérv - A649)"},
/* 045C */ { "LETTRE MINUSCULE CYRILLIQUE KIÉ","	* macédonien\n"
	"	: 043A 0301"},
/* 045D */ { "LETTRE MINUSCULE CYRILLIQUE I GRAVE","	* macédonien, bulgare\n"
	"	: 0438 0300"},
/* 045E */ { "LETTRE MINUSCULE CYRILLIQUE OU BREF","	* biélorusse, ouzbek\n"
	"	: 0443 0306"},
/* 045F */ { "LETTRE MINUSCULE CYRILLIQUE DZHÉ","	* serbe, macédonien, abkhaze\n"
	"	x (lettre minuscule latine dz caron - 01C6)"},
/* 0460 */ { "LETTRE MAJUSCULE CYRILLIQUE OMÉGA",NULL},
/* 0461 */ { "LETTRE MINUSCULE CYRILLIQUE OMÉGA","	x (lettre minuscule cyrillique oméga large - A64D)"},
/* 0462 */ { "LETTRE MAJUSCULE CYRILLIQUE IAT'",NULL},
/* 0463 */ { "LETTRE MINUSCULE CYRILLIQUE IAT'","	x (lettre minuscule cyrillique yate yodisé - A653)\n"
	"	x (lettre latine minuscule sakha yat - AB60)"},
/* 0464 */ { "LETTRE MAJUSCULE CYRILLIQUE É YODISÉ",NULL},
/* 0465 */ { "LETTRE MINUSCULE CYRILLIQUE É YODISÉ","	x (lettre latine minuscule é yodisé - AB61)"},
/* 0466 */ { "LETTRE MAJUSCULE CYRILLIQUE PETIT IOUSSE",NULL},
/* 0467 */ { "LETTRE MINUSCULE CYRILLIQUE PETIT IOUSSE","	x (lettre minuscule cyrillique petit yousse fermé - A659)\n"
	"	x (lettre minuscule cyrillique yousse fusionné - A65B)"},
/* 0468 */ { "LETTRE MAJUSCULE CYRILLIQUE PETIT IOUSSE YODISÉ",NULL},
/* 0469 */ { "LETTRE MINUSCULE CYRILLIQUE PETIT IOUSSE YODISÉ","	x (lettre minuscule cyrillique ia - 044F)\n"
	"	x (lettre minuscule cyrillique petit yousse yodisé fermé - A65D)"},
/* 046A */ { "LETTRE MAJUSCULE CYRILLIQUE GRAND IOUSSE",NULL},
/* 046B */ { "LETTRE MINUSCULE CYRILLIQUE GRAND IOUSSE","	x (lettre minuscule cyrillique yousse fusionné - A65B)"},
/* 046C */ { "LETTRE MAJUSCULE CYRILLIQUE GRAND IOUSSE YODISÉ",NULL},
/* 046D */ { "LETTRE MINUSCULE CYRILLIQUE GRAND IOUSSE YODISÉ",NULL},
/* 046E */ { "LETTRE MAJUSCULE CYRILLIQUE KSI",NULL},
/* 046F */ { "LETTRE MINUSCULE CYRILLIQUE KSI",NULL},
/* 0470 */ { "LETTRE MAJUSCULE CYRILLIQUE PSI",NULL},
/* 0471 */ { "LETTRE MINUSCULE CYRILLIQUE PSI",NULL},
/* 0472 */ { "LETTRE MAJUSCULE CYRILLIQUE FITA",NULL},
/* 0473 */ { "LETTRE MINUSCULE CYRILLIQUE FITA","	x (lettre minuscule latine o barré - 0275)\n"
	"	x (lettre minuscule grecque thêta - 03B8)"},
/* 0474 */ { "LETTRE MAJUSCULE CYRILLIQUE IJITSA",NULL},
/* 0475 */ { "LETTRE MINUSCULE CYRILLIQUE IJITSA",NULL},
/* 0476 */ { "LETTRE MAJUSCULE CYRILLIQUE IJITSA DOUBLE ACCENT GRAVE","	: 0474 030F"},
/* 0477 */ { "LETTRE MINUSCULE CYRILLIQUE IJITSA DOUBLE ACCENT GRAVE","	: 0475 030F"},
/* 0478 */ { "LETTRE MAJUSCULE CYRILLIQUE OUK","	* n'entre pas dans la composition d'un digramme dont l'écriture recommandée est 041E 0443\n"
	"	* l'écriture recommandée du monogramme ouk est A64A\n"
	"	x (lettre majuscule cyrillique ou - 0423)"},
/* 0479 */ { "LETTRE MINUSCULE CYRILLIQUE OUK","	* n'entre pas dans la composition d'un digramme dont l'écriture recommandée est 043E 0443\n"
	"	* l'écriture recommandée du monogramme ouk est A64B"},
/* 047A */ { "LETTRE MAJUSCULE CYRILLIQUE OMÉGA ROND",NULL},
/* 047B */ { "LETTRE MINUSCULE CYRILLIQUE OMÉGA ROND",NULL},
/* 047C */ { "LETTRE MAJUSCULE CYRILLIQUE OMÉGA TITLO","	= « bel oméga » cyrillique\n"
	"	* en dépit de son nom, ce caractère n'a pas de titlo et n'est pas constitué d'un oméga muni d'un diacritique\n"
	"	x (lettre majuscule cyrillique oméga large - A64C)"},
/* 047D */ { "LETTRE MINUSCULE CYRILLIQUE OMÉGA TITLO","	x (lettre minuscule grecque oméga esprit doux et circonflexe - 1F66)"},
/* 047E */ { "LETTRE MAJUSCULE CYRILLIQUE OMÉGA TÉ",NULL},
/* 047F */ { "LETTRE MINUSCULE CYRILLIQUE OMÉGA TÉ",NULL},
/* 0480 */ { "LETTRE MAJUSCULE CYRILLIQUE KOPPA",NULL},
/* 0481 */ { "LETTRE MINUSCULE CYRILLIQUE KOPPA",NULL},
/* 0482 */ { "SIGNE CYRILLIQUE MILLIERS",NULL},
/* 0483 */ { "DIACRITIQUE CYRILLIQUE TITLO","	* n'est pas utilisé avec les lettres 047C et 047D\n"
	"	x (diacritique cyrillique vzmét - A66F)"},
/* 0484 */ { "DIACRITIQUE CYRILLIQUE DE PALATALISATION","	* n'est pas utilisé pour le signe kamora (accent circonflexe cyrillique)\n"
	"	x (lettre modificative apostrophe - 02BC)\n"
	"	x (diacritique brève renversée - 0311)"},
/* 0485 */ { "DIACRITIQUE CYRILLIQUE DASIA PNEUMATA","	x (diacritique virgule réfléchie en chef - 0314)"},
/* 0486 */ { "DIACRITIQUE CYRILLIQUE PSILI PNEUMATA","	x (diacritique virgule en chef - 0313)"},
/* 0487 */ { "DIACRITIQUE CYRILLIQUE POKRYTIÉ","	* utilisé seulement avec les lettres 047C et 047D\n"
	"	* attesté également en glagolitique\n"
	"	x (diacritique brève renversée - 0311)\n"
	"	x (diacritique cyrillique vzmét - A66F)"},
/* 0488 */ { "DIACRITIQUE CYRILLIQUE SIGNE CENTAINE DE MILLIERS","	* il faut utiliser 20DD pour la myriade (dix mille)"},
/* 0489 */ { "DIACRITIQUE CYRILLIQUE SIGNE MILLIONS","	x (diacritique cyrillique dix millions - A670)"},
/* 048A */ { "LETTRE MAJUSCULE CYRILLIQUE I BREF À QUEUE",NULL},
/* 048B */ { "LETTRE MINUSCULE CYRILLIQUE I BREF À QUEUE","	* same de Kildin"},
/* 048C */ { "LETTRE MAJUSCULE CYRILLIQUE SIGNE SEMI-MOU",NULL},
/* 048D */ { "LETTRE MINUSCULE CYRILLIQUE SIGNE SEMI-MOU","	* same de Kildin"},
/* 048E */ { "LETTRE MAJUSCULE CYRILLIQUE ERRE AGRAFÉ",NULL},
/* 048F */ { "LETTRE MINUSCULE CYRILLIQUE ERRE AGRAFÉ","	* same de Kildin"},
/* 0490 */ { "LETTRE MAJUSCULE CYRILLIQUE GUÉ HAMPÉ",NULL},
/* 0491 */ { "LETTRE MINUSCULE CYRILLIQUE GUÉ HAMPÉ","	* ukrainien"},
/* 0492 */ { "LETTRE MAJUSCULE CYRILLIQUE GUÉ BARRÉ",NULL},
/* 0493 */ { "LETTRE MINUSCULE CYRILLIQUE GUÉ BARRÉ","	* azéri, bachkir, etc.\n"
	"	* la forme à barre transversale est recommandée au détriment de celle à demi-barre ressemblant à un F"},
/* 0494 */ { "LETTRE MAJUSCULE CYRILLIQUE GUÉ CROCHET MÉDIAN",NULL},
/* 0495 */ { "LETTRE MINUSCULE CYRILLIQUE GUÉ CROCHET MÉDIAN","	* iakoute, formes anciennes de l'abkhaze"},
/* 0496 */ { "LETTRE MAJUSCULE CYRILLIQUE JÉ CRAMPON",NULL},
/* 0497 */ { "LETTRE MINUSCULE CYRILLIQUE JÉ CRAMPON","	* tatar"},
/* 0498 */ { "LETTRE MAJUSCULE CYRILLIQUE ZÉ CRAMPON",NULL},
/* 0499 */ { "LETTRE MINUSCULE CYRILLIQUE ZÉ CRAMPON","	* bachkir\n"
	"	* les formes à crochet vers la droite sont privilégiées, bien que l'on rencontre parfois des formes à crochet vers la gauche"},
/* 049A */ { "LETTRE MAJUSCULE CYRILLIQUE KA CRAMPON",NULL},
/* 049B */ { "LETTRE MINUSCULE CYRILLIQUE KA CRAMPON","	* abkhaze, tadjik, etc."},
/* 049C */ { "LETTRE MAJUSCULE CYRILLIQUE KA BARRE VERTICALE",NULL},
/* 049D */ { "LETTRE MINUSCULE CYRILLIQUE KA BARRE VERTICALE","	* azéri"},
/* 049E */ { "LETTRE MAJUSCULE CYRILLIQUE KA BARRÉ",NULL},
/* 049F */ { "LETTRE MINUSCULE CYRILLIQUE KA BARRÉ","	* abkhaze"},
/* 04A0 */ { "LETTRE MAJUSCULE CYRILLIQUE KA BACHKIR",NULL},
/* 04A1 */ { "LETTRE MINUSCULE CYRILLIQUE KA BACHKIR",NULL},
/* 04A2 */ { "LETTRE MAJUSCULE CYRILLIQUE ENNE CRAMPON",NULL},
/* 04A3 */ { "LETTRE MINUSCULE CYRILLIQUE ENNE CRAMPON","	* bachkir, etc."},
/* 04A4 */ { "LIGATURE CYRILLIQUE MAJUSCULE ENG",NULL},
/* 04A5 */ { "LIGATURE CYRILLIQUE MINUSCULE ENG","	* altaï, mari (ou tchérémisse), iakoute\n"
	"	* également utilisé pour le enne doux en vieux slave\n"
	"	* il s'agit d'une ligature non décomposable"},
/* 04A6 */ { "LETTRE MAJUSCULE CYRILLIQUE PÉ CROCHET MÉDIAN",NULL},
/* 04A7 */ { "LETTRE MINUSCULE CYRILLIQUE PÉ CROCHET MÉDIAN","	* formes anciennes de l'abkhaze"},
/* 04A8 */ { "LETTRE MAJUSCULE CYRILLIQUE HA ABKHAZE",NULL},
/* 04A9 */ { "LETTRE MINUSCULE CYRILLIQUE HA ABKHAZE",NULL},
/* 04AA */ { "LETTRE MAJUSCULE CYRILLIQUE ESSE CRAMPON",NULL},
/* 04AB */ { "LETTRE MINUSCULE CYRILLIQUE ESSE CRAMPON","	* bachkir, tchouvache\n"
	"	* les formes à crochet vers la droite sont privilégiées, bien que l'on rencontre parfois des formes à crochet vers la gauche\n"
	"	* en Tchouvachie, on rencontre souvent des formes identiques ou similaires à 00E7"},
/* 04AC */ { "LETTRE MAJUSCULE CYRILLIQUE TÉ CRAMPON",NULL},
/* 04AD */ { "LETTRE MINUSCULE CYRILLIQUE TÉ CRAMPON","	* abkhaze"},
/* 04AE */ { "LETTRE MAJUSCULE CYRILLIQUE OU DROIT",NULL},
/* 04AF */ { "LETTRE MINUSCULE CYRILLIQUE OU DROIT","	* le jambage est droit, contrairement à celui de la LETTRE OU\n"
	"	* azéri, bachkir, etc.\n"
	"	x (lettre majuscule cyrillique ou - 0423)"},
/* 04B0 */ { "LETTRE MAJUSCULE CYRILLIQUE OU DROIT BARRÉ",NULL},
/* 04B1 */ { "LETTRE MINUSCULE CYRILLIQUE OU DROIT BARRÉ","	* kazakh"},
/* 04B2 */ { "LETTRE MAJUSCULE CYRILLIQUE KHA CRAMPON",NULL},
/* 04B3 */ { "LETTRE MINUSCULE CYRILLIQUE KHA CRAMPON","	* abkhaze, tadjik, ouzbek"},
/* 04B4 */ { "LIGATURE MAJUSCULE CYRILLIQUE TÉ TSÉ",NULL},
/* 04B5 */ { "LIGATURE MINUSCULE CYRILLIQUE TÉ TSÉ","	* abkhaze\n"
	"	* il s'agit d'une ligature non décomposable"},
/* 04B6 */ { "LETTRE MAJUSCULE CYRILLIQUE TCHÉ CRAMPON",NULL},
/* 04B7 */ { "LETTRE MINUSCULE CYRILLIQUE TCHÉ CRAMPON","	* abkhaze, tadjik"},
/* 04B8 */ { "LETTRE MAJUSCULE CYRILLIQUE TCHÉ BARRE VERTICALE",NULL},
/* 04B9 */ { "LETTRE MINUSCULE CYRILLIQUE TCHÉ BARRE VERTICALE","	* azéri"},
/* 04BA */ { "LETTRE MAJUSCULE CYRILLIQUE HÉ",NULL},
/* 04BB */ { "LETTRE MINUSCULE CYRILLIQUE HÉ","	* dérivé à l'origine d'un « h » latin, mais la majuscule 04BA est plus proche d'un tché renversé (0427)\n"
	"	* azéri, bachkir, etc.\n"
	"	x (lettre minuscule latine h - 0068)"},
/* 04BC */ { "LETTRE MAJUSCULE CYRILLIQUE TCHÉ ABKHAZE",NULL},
/* 04BD */ { "LETTRE MINUSCULE CYRILLIQUE TCHÉ ABKHAZE",NULL},
/* 04BE */ { "LETTRE MAJUSCULE CYRILLIQUE TCHÉ CRAMPON ABKHAZE",NULL},
/* 04BF */ { "LETTRE MINUSCULE CYRILLIQUE TCHÉ CRAMPON ABKHAZE","	* certaines polices abkhazes anciennes montrent un appendice représenté comme un ogonek ou une virgule réfléchie"},
/* 04C0 */ { "LETTRE CYRILLIQUE PALOTCHKA","	* signe d'aspiration pour de nombreuses langues caucasiennes\n"
	"	* n'a habituellement pas de variante de casse, mais sa minuscule officielle est 04CF\n"
	"	x (lettre majuscule latine i - 0049)\n"
	"	x (lettre majuscule cyrillique i biélorusse-ukrainien - 0406)"},
/* 04C1 */ { "LETTRE MAJUSCULE CYRILLIQUE JÉ BRÈVE","	: 0416 0306"},
/* 04C2 */ { "LETTRE MINUSCULE CYRILLIQUE JÉ BRÈVE","	* moldave\n"
	"	: 0436 0306"},
/* 04C3 */ { "LETTRE MAJUSCULE CYRILLIQUE KA HAMEÇON",NULL},
/* 04C4 */ { "LETTRE MINUSCULE CYRILLIQUE KA HAMEÇON","	* alphabets de la Sibérie et de l'Extrême-Orient russe"},
/* 04C5 */ { "LETTRE MAJUSCULE CYRILLIQUE ELLE À QUEUE",NULL},
/* 04C6 */ { "LETTRE MINUSCULE CYRILLIQUE ELLE À QUEUE","	* same de Kildin"},
/* 04C7 */ { "LETTRE MAJUSCULE CYRILLIQUE ENNE HAMEÇON",NULL},
/* 04C8 */ { "LETTRE MINUSCULE CYRILLIQUE ENNE HAMEÇON","	* évène, altaï, khante, same de Kildin, nénetse, nivkhe, etc."},
/* 04C9 */ { "LETTRE MAJUSCULE CYRILLIQUE ENNE À QUEUE",NULL},
/* 04CA */ { "LETTRE MINUSCULE CYRILLIQUE ENNE À QUEUE","	* same de Kildin"},
/* 04CB */ { "LETTRE MAJUSCULE CYRILLIQUE TCHÉ KHAKASSE",NULL},
/* 04CC */ { "LETTRE MINUSCULE CYRILLIQUE TCHÉ KHAKASSE",NULL},
/* 04CD */ { "LETTRE MAJUSCULE CYRILLIQUE EMME À QUEUE",NULL},
/* 04CE */ { "LETTRE MINUSCULE CYRILLIQUE EMME À QUEUE","	* same de Kildin"},
/* 04CF */ { "LETTRE MINUSCULE CYRILLIQUE PALOTCHKA",NULL},
/* 04D0 */ { "LETTRE MAJUSCULE CYRILLIQUE A BRÈVE","	: 0410 0306"},
/* 04D1 */ { "LETTRE MINUSCULE CYRILLIQUE A BRÈVE","	: 0430 0306"},
/* 04D2 */ { "LETTRE MAJUSCULE CYRILLIQUE A TRÉMA","	: 0410 0308"},
/* 04D3 */ { "LETTRE MINUSCULE CYRILLIQUE A TRÉMA","	: 0430 0308"},
/* 04D4 */ { "LIGATURE MAJUSCULE CYRILLIQUE A IÉ",NULL},
/* 04D5 */ { "LIGATURE MINUSCULE CYRILLIQUE A IÉ","	= ié dans l'a\n"
	"	* il s'agit d'une ligature non décomposable\n"
	"	x (lettre minuscule latine ae - 00E6)"},
/* 04D6 */ { "LETTRE MAJUSCULE CYRILLIQUE IÉ BRÈVE","	: 0415 0306"},
/* 04D7 */ { "LETTRE MINUSCULE CYRILLIQUE IÉ BRÈVE","	: 0435 0306"},
/* 04D8 */ { "LETTRE MAJUSCULE CYRILLIQUE SCHWA",NULL},
/* 04D9 */ { "LETTRE MINUSCULE CYRILLIQUE SCHWA","	x (lettre minuscule latine schwa - 0259)"},
/* 04DA */ { "LETTRE MAJUSCULE CYRILLIQUE SCHWA TRÉMA","	: 04D8 0308"},
/* 04DB */ { "LETTRE MINUSCULE CYRILLIQUE SCHWA TRÉMA","	: 04D9 0308"},
/* 04DC */ { "LETTRE MAJUSCULE CYRILLIQUE JÉ TRÉMA","	: 0416 0308"},
/* 04DD */ { "LETTRE MINUSCULE CYRILLIQUE JÉ TRÉMA","	: 0436 0308"},
/* 04DE */ { "LETTRE MAJUSCULE CYRILLIQUE ZÉ TRÉMA","	: 0417 0308"},
/* 04DF */ { "LETTRE MINUSCULE CYRILLIQUE ZÉ TRÉMA","	: 0437 0308"},
/* 04E0 */ { "LETTRE MAJUSCULE CYRILLIQUE DZÉ ABKHAZE",NULL},
/* 04E1 */ { "LETTRE MINUSCULE CYRILLIQUE DZÉ ABKHAZE","	x (lettre minuscule latine ej - 0292)"},
/* 04E2 */ { "LETTRE MAJUSCULE CYRILLIQUE I MACRON","	: 0418 0304"},
/* 04E3 */ { "LETTRE MINUSCULE CYRILLIQUE I MACRON","	: 0438 0304"},
/* 04E4 */ { "LETTRE MAJUSCULE CYRILLIQUE I TRÉMA","	: 0418 0308"},
/* 04E5 */ { "LETTRE MINUSCULE CYRILLIQUE I TRÉMA","	: 0438 0308"},
/* 04E6 */ { "LETTRE MAJUSCULE CYRILLIQUE O TRÉMA","	: 041E 0308"},
/* 04E7 */ { "LETTRE MINUSCULE CYRILLIQUE O TRÉMA","	: 043E 0308"},
/* 04E8 */ { "LETTRE MAJUSCULE CYRILLIQUE O BARRÉ",NULL},
/* 04E9 */ { "LETTRE MINUSCULE CYRILLIQUE O BARRÉ","	x (lettre minuscule latine o barré - 0275)"},
/* 04EA */ { "LETTRE MAJUSCULE CYRILLIQUE O BARRÉ TRÉMA","	: 04E8 0308"},
/* 04EB */ { "LETTRE MINUSCULE CYRILLIQUE O BARRÉ TRÉMA","	: 04E9 0308"},
/* 04EC */ { "LETTRE MAJUSCULE CYRILLIQUE É TRÉMA","	: 042D 0308"},
/* 04ED */ { "LETTRE MINUSCULE CYRILLIQUE É TRÉMA","	* same de Kildin\n"
	"	: 044D 0308"},
/* 04EE */ { "LETTRE MAJUSCULE CYRILLIQUE OU MACRON","	: 0423 0304"},
/* 04EF */ { "LETTRE MINUSCULE CYRILLIQUE OU MACRON","	: 0443 0304"},
/* 04F0 */ { "LETTRE MAJUSCULE CYRILLIQUE OU TRÉMA","	: 0423 0308"},
/* 04F1 */ { "LETTRE MINUSCULE CYRILLIQUE OU TRÉMA","	: 0443 0308"},
/* 04F2 */ { "LETTRE MAJUSCULE CYRILLIQUE OU DOUBLE ACCENT AIGU","	: 0423 030B"},
/* 04F3 */ { "LETTRE MINUSCULE CYRILLIQUE OU DOUBLE ACCENT AIGU","	: 0443 030B"},
/* 04F4 */ { "LETTRE MAJUSCULE CYRILLIQUE TCHÉ TRÉMA","	: 0427 0308"},
/* 04F5 */ { "LETTRE MINUSCULE CYRILLIQUE TCHÉ TRÉMA","	: 0447 0308"},
/* 04F6 */ { "LETTRE MAJUSCULE CYRILLIQUE GUÉ CRAMPON",NULL},
/* 04F7 */ { "LETTRE MINUSCULE CYRILLIQUE GUÉ CRAMPON","	* youpik"},
/* 04F8 */ { "LETTRE MAJUSCULE CYRILLIQUE YÉROU TRÉMA","	: 042B 0308"},
/* 04F9 */ { "LETTRE MINUSCULE CYRILLIQUE YÉROU TRÉMA","	: 044B 0308"},
/* 04FA */ { "LETTRE MAJUSCULE CYRILLIQUE GUÉ BARRÉ HAMEÇON",NULL},
/* 04FB */ { "LETTRE MINUSCULE CYRILLIQUE GUÉ BARRÉ HAMEÇON",NULL},
/* 04FC */ { "LETTRE MAJUSCULE CYRILLIQUE KHA HAMEÇON",NULL},
/* 04FD */ { "LETTRE MINUSCULE CYRILLIQUE KHA HAMEÇON",NULL},
/* 04FE */ { "LETTRE MAJUSCULE CYRILLIQUE KHA BARRÉ",NULL},
/* 04FF */ { "LETTRE MINUSCULE CYRILLIQUE KHA BARRÉ",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_05[] = {
/* 0500 */ { "LETTRE MAJUSCULE CYRILLIQUE DÉ KOMI",NULL},
/* 0501 */ { "LETTRE MINUSCULE CYRILLIQUE DÉ KOMI",NULL},
/* 0502 */ { "LETTRE MAJUSCULE CYRILLIQUE DJÉ KOMI",NULL},
/* 0503 */ { "LETTRE MINUSCULE CYRILLIQUE DJE KOMI",NULL},
/* 0504 */ { "LETTRE MAJUSCULE CYRILLIQUE ZJÉ KOMI",NULL},
/* 0505 */ { "LETTRE MINUSCULE CYRILLIQUE ZJÉ KOMI",NULL},
/* 0506 */ { "LETTRE MAJUSCULE CYRILLIQUE DZJÉ KOMI",NULL},
/* 0507 */ { "LETTRE MINUSCULE CYRILLIQUE DZJÉ KOMI",NULL},
/* 0508 */ { "LETTRE MAJUSCULE CYRILLIQUE LJÉ KOMI",NULL},
/* 0509 */ { "LETTRE MINUSCULE CYRILLIQUE LJÉ KOMI",NULL},
/* 050A */ { "LETTRE MAJUSCULE CYRILLIQUE NJÉ KOMI",NULL},
/* 050B */ { "LETTRE MINUSCULE CYRILLIQUE NJÉ KOMI",NULL},
/* 050C */ { "LETTRE MAJUSCULE CYRILLIQUE SJÉ KOMI",NULL},
/* 050D */ { "LETTRE MINUSCULE CYRILLIQUE SJÉ KOMI",NULL},
/* 050E */ { "LETTRE MAJUSCULE CYRILLIQUE TJÉ KOMI",NULL},
/* 050F */ { "LETTRE MINUSCULE CYRILLIQUE TJÉ KOMI",NULL},
/* 0510 */ { "LETTRE MAJUSCULE CYRILLIQUE ZÉ RÉFLÉCHI",NULL},
/* 0511 */ { "LETTRE MINUSCULE CYRILLIQUE ZÉ RÉFLÉCHI","	* aussi pour l'énetse"},
/* 0512 */ { "LETTRE MAJUSCULE CYRILLIQUE ELLE HAMEÇON",NULL},
/* 0513 */ { "LETTRE MINUSCULE CYRILLIQUE ELLE HAMEÇON","	* aussi pour l'itelmène"},
/* 0514 */ { "LETTRE MAJUSCULE CYRILLIQUE LHA",NULL},
/* 0515 */ { "LETTRE MINUSCULE CYRILLIQUE LHA","	= l non voisé"},
/* 0516 */ { "LETTRE MAJUSCULE CYRILLIQUE RHA",NULL},
/* 0517 */ { "LETTRE MINUSCULE CYRILLIQUE RHA","	= r non voisé"},
/* 0518 */ { "LETTRE MAJUSCULE CYRILLIQUE YÈ",NULL},
/* 0519 */ { "LETTRE MINUSCULE CYRILLIQUE YÈ",NULL},
/* 051A */ { "LETTRE MAJUSCULE CYRILLIQUE QA",NULL},
/* 051B */ { "LETTRE MINUSCULE CYRILLIQUE QA",NULL},
/* 051C */ { "LETTRE MAJUSCULE CYRILLIQUE WÉ",NULL},
/* 051D */ { "LETTRE MINUSCULE CYRILLIQUE WÉ",NULL},
/* 051E */ { "LETTRE MAJUSCULE CYRILLIQUE KA ALÉOUTE",NULL},
/* 051F */ { "LETTRE MINUSCULE CYRILLIQUE KA ALÉOUTE","	* pour [q] en aléoute"},
/* 0520 */ { "LETTRE MAJUSCULE CYRILLIQUE ELLE CROCHET MÉDIAN",NULL},
/* 0521 */ { "LETTRE MINUSCULE CYRILLIQUE ELLE CROCHET MÉDIAN","	= l palatalisé"},
/* 0522 */ { "LETTRE MAJUSCULE CYRILLIQUE ENNE CROCHET MÉDIAN",NULL},
/* 0523 */ { "LETTRE MINUSCULE CYRILLIQUE ENNE CROCHET MÉDIAN","	= n palatalisé"},
/* 0524 */ { "LETTRE MAJUSCULE CYRILLIQUE PÉ CRAMPON",NULL},
/* 0525 */ { "LETTRE MINUSCULE CYRILLIQUE PÉ CRAMPON","	* aussi dans l'orthographe abkhaze moderne\n"
	"	x (lettre minuscule cyrillique pé crochet médian - 04A7)"},
/* 0526 */ { "LETTRE MAJUSCULE CYRILLIQUE HÉ CRAMPON",NULL},
/* 0527 */ { "LETTRE MINUSCULE CYRILLIQUE HÉ CRAMPON",NULL},
/* 0528 */ { "LETTRE MAJUSCULE CYRILLIQUE ENNE HAMEÇON À GAUCHE",NULL},
/* 0529 */ { "LETTRE MINUSCULE CYRILLIQUE ENNE HAMEÇON À GAUCHE",NULL},
/* 052A */ { "LETTRE MAJUSCULE CYRILLIQUE DZZHÉ",NULL},
/* 052B */ { "LETTRE MINUSCULE CYRILLIQUE DZZHÉ","	* aussi pour l'ossète"},
/* 052C */ { "LETTRE MAJUSCULE CYRILLIQUE DCHÉ",NULL},
/* 052D */ { "LETTRE MINUSCULE CYRILLIQUE DCHÉ",NULL},
/* 052E */ { "LETTRE MAJUSCULE CYRILLIQUE ELLE CRAMPON",NULL},
/* 052F */ { "LETTRE MINUSCULE CYRILLIQUE ELLE CRAMPON","	* aussi pour le nénetse"},
/* 0530 */ { NULL,NULL},
/* 0531 */ { "LETTRE MAJUSCULE ARMÉNIENNE AÏP",NULL},
/* 0532 */ { "LETTRE MAJUSCULE ARMÉNIENNE PÈN",NULL},
/* 0533 */ { "LETTRE MAJUSCULE ARMÉNIENNE KIM",NULL},
/* 0534 */ { "LETTRE MAJUSCULE ARMÉNIENNE TA",NULL},
/* 0535 */ { "LETTRE MAJUSCULE ARMÉNIENNE YÈTCH",NULL},
/* 0536 */ { "LETTRE MAJUSCULE ARMÉNIENNE ZA",NULL},
/* 0537 */ { "LETTRE MAJUSCULE ARMÉNIENNE É",NULL},
/* 0538 */ { "LETTRE MAJUSCULE ARMÉNIENNE ETT",NULL},
/* 0539 */ { "LETTRE MAJUSCULE ARMÉNIENNE TÔ",NULL},
/* 053A */ { "LETTRE MAJUSCULE ARMÉNIENNE JÉ",NULL},
/* 053B */ { "LETTRE MAJUSCULE ARMÉNIENNE INI",NULL},
/* 053C */ { "LETTRE MAJUSCULE ARMÉNIENNE LIOUN",NULL},
/* 053D */ { "LETTRE MAJUSCULE ARMÉNIENNE KHÉ",NULL},
/* 053E */ { "LETTRE MAJUSCULE ARMÉNIENNE DZA",NULL},
/* 053F */ { "LETTRE MAJUSCULE ARMÉNIENNE GUÉN",NULL},
/* 0540 */ { "LETTRE MAJUSCULE ARMÉNIENNE HÔ",NULL},
/* 0541 */ { "LETTRE MAJUSCULE ARMÉNIENNE TSA",NULL},
/* 0542 */ { "LETTRE MAJUSCULE ARMÉNIENNE GHAD",NULL},
/* 0543 */ { "LETTRE MAJUSCULE ARMÉNIENNE DJÉ",NULL},
/* 0544 */ { "LETTRE MAJUSCULE ARMÉNIENNE MÈN",NULL},
/* 0545 */ { "LETTRE MAJUSCULE ARMÉNIENNE HÎ",NULL},
/* 0546 */ { "LETTRE MAJUSCULE ARMÉNIENNE NOU",NULL},
/* 0547 */ { "LETTRE MAJUSCULE ARMÉNIENNE CHA",NULL},
/* 0548 */ { "LETTRE MAJUSCULE ARMÉNIENNE VO",NULL},
/* 0549 */ { "LETTRE MAJUSCULE ARMÉNIENNE TCHA",NULL},
/* 054A */ { "LETTRE MAJUSCULE ARMÉNIENNE BÉ",NULL},
/* 054B */ { "LETTRE MAJUSCULE ARMÉNIENNE DCHÉ",NULL},
/* 054C */ { "LETTRE MAJUSCULE ARMÉNIENNE RRA",NULL},
/* 054D */ { "LETTRE MAJUSCULE ARMÉNIENNE SÉ",NULL},
/* 054E */ { "LETTRE MAJUSCULE ARMÉNIENNE VÈV",NULL},
/* 054F */ { "LETTRE MAJUSCULE ARMÉNIENNE DIOUN",NULL},
/* 0550 */ { "LETTRE MAJUSCULE ARMÉNIENNE RÉ",NULL},
/* 0551 */ { "LETTRE MAJUSCULE ARMÉNIENNE TSÔ",NULL},
/* 0552 */ { "LETTRE MAJUSCULE ARMÉNIENNE HIOUN",NULL},
/* 0553 */ { "LETTRE MAJUSCULE ARMÉNIENNE PIOUR",NULL},
/* 0554 */ { "LETTRE MAJUSCULE ARMÉNIENNE KÉ",NULL},
/* 0555 */ { "LETTRE MAJUSCULE ARMÉNIENNE Ô",NULL},
/* 0556 */ { "LETTRE MAJUSCULE ARMÉNIENNE FÉ",NULL},
/* 0557 */ { NULL,NULL},
/* 0558 */ { NULL,NULL},
/* 0559 */ { "LETTRE MODIFICATIVE ARMÉNIENNE DEMI-ROND GAUCHE","	x (lettre modificative virgule réfléchie - 02BD)\n"
	"	x (lettre modificative demi-rond gauche - 02BF)\n"
	"	x (diacritique virgule réfléchie en chef - 0314)"},
/* 055A */ { "APOSTROPHE ARMÉNIENNE","	= lettre modificative arménienne demi-rond droit (1.0)\n"
	"	x (lettre modificative apostrophe - 02BC)\n"
	"	x (lettre modificative demi-rond droit - 02BE)\n"
	"	x (diacritique virgule en chef - 0313)"},
/* 055B */ { "SIGNE D'ACCENTUATION ARMÉNIEN","	= chèchte\n"
	"	x (lettre modificative accent aigu - 02CA)"},
/* 055C */ { "POINT D'EXCLAMATION ARMÉNIEN","	= batsagantchakane nchane\n"
	"	* il marque l'intonation sur un mot plutôt que d'apparaître en fin de phrase"},
/* 055D */ { "VIRGULE ARMÉNIENNE","	= booute\n"
	"	x (lettre modificative accent grave - 02CB)"},
/* 055E */ { "POINT D'INTERROGATION ARMÉNIEN","	= hartsakane nchane\n"
	"	* il marque l'intonation sur un mot plutôt que d'apparaître en fin de phrase"},
/* 055F */ { "SIGNE D'ABRÉVIATION ARMÉNIEN","	= patiou"},
/* 0560 */ { NULL,NULL},
/* 0561 */ { "LETTRE MINUSCULE ARMÉNIENNE AÏP",NULL},
/* 0562 */ { "LETTRE MINUSCULE ARMÉNIENNE PÈN",NULL},
/* 0563 */ { "LETTRE MINUSCULE ARMÉNIENNE KIM",NULL},
/* 0564 */ { "LETTRE MINUSCULE ARMÉNIENNE TA",NULL},
/* 0565 */ { "LETTRE MINUSCULE ARMÉNIENNE YÈTCH",NULL},
/* 0566 */ { "LETTRE MINUSCULE ARMÉNIENNE ZA",NULL},
/* 0567 */ { "LETTRE MINUSCULE ARMÉNIENNE É",NULL},
/* 0568 */ { "LETTRE MINUSCULE ARMÉNIENNE ETT",NULL},
/* 0569 */ { "LETTRE MINUSCULE ARMÉNIENNE TÔ",NULL},
/* 056A */ { "LETTRE MINUSCULE ARMÉNIENNE JÉ",NULL},
/* 056B */ { "LETTRE MINUSCULE ARMÉNIENNE INI",NULL},
/* 056C */ { "LETTRE MINUSCULE ARMÉNIENNE LIOUN",NULL},
/* 056D */ { "LETTRE MINUSCULE ARMÉNIENNE KHÉ",NULL},
/* 056E */ { "LETTRE MINUSCULE ARMÉNIENNE DZA",NULL},
/* 056F */ { "LETTRE MINUSCULE ARMÉNIENNE GUÉN",NULL},
/* 0570 */ { "LETTRE MINUSCULE ARMÉNIENNE HÔ",NULL},
/* 0571 */ { "LETTRE MINUSCULE ARMÉNIENNE TSA",NULL},
/* 0572 */ { "LETTRE MINUSCULE ARMÉNIENNE GHAD",NULL},
/* 0573 */ { "LETTRE MINUSCULE ARMÉNIENNE DJÉ",NULL},
/* 0574 */ { "LETTRE MINUSCULE ARMÉNIENNE MÈN",NULL},
/* 0575 */ { "LETTRE MINUSCULE ARMÉNIENNE HÎ",NULL},
/* 0576 */ { "LETTRE MINUSCULE ARMÉNIENNE NOU",NULL},
/* 0577 */ { "LETTRE MINUSCULE ARMÉNIENNE CHA",NULL},
/* 0578 */ { "LETTRE MINUSCULE ARMÉNIENNE VO",NULL},
/* 0579 */ { "LETTRE MINUSCULE ARMÉNIENNE TCHA",NULL},
/* 057A */ { "LETTRE MINUSCULE ARMÉNIENNE BÉ",NULL},
/* 057B */ { "LETTRE MINUSCULE ARMÉNIENNE DCHÉ",NULL},
/* 057C */ { "LETTRE MINUSCULE ARMÉNIENNE RRA",NULL},
/* 057D */ { "LETTRE MINUSCULE ARMÉNIENNE SÉ",NULL},
/* 057E */ { "LETTRE MINUSCULE ARMÉNIENNE VÈV",NULL},
/* 057F */ { "LETTRE MINUSCULE ARMÉNIENNE DIOUN",NULL},
/* 0580 */ { "LETTRE MINUSCULE ARMÉNIENNE RÉ",NULL},
/* 0581 */ { "LETTRE MINUSCULE ARMÉNIENNE TSÔ",NULL},
/* 0582 */ { "LETTRE MINUSCULE ARMÉNIENNE HIOUN",NULL},
/* 0583 */ { "LETTRE MINUSCULE ARMÉNIENNE PIOUR",NULL},
/* 0584 */ { "LETTRE MINUSCULE ARMÉNIENNE KÉ",NULL},
/* 0585 */ { "LETTRE MINUSCULE ARMÉNIENNE Ô",NULL},
/* 0586 */ { "LETTRE MINUSCULE ARMÉNIENNE FÉ",NULL},
/* 0587 */ { "LIGATURE MINUSCULE ARMÉNIENNE YÈTCH HIOUN","	# 0565 0582"},
/* 0588 */ { NULL,NULL},
/* 0589 */ { "POINT ARMÉNIEN","	= vertsakète\n"
	"	* peut être utilisé aussi dans des textes historiques géorgiens\n"
	"	x (deux-points - 003A)"},
/* 058A */ { "TRAIT D'UNION ARMÉNIEN","	= yentamna"},
/* 058B */ { NULL,NULL},
/* 058C */ { NULL,NULL},
/* 058D */ { "SIGNE ARMÉNIEN D'ÉTERNITÉ DEXTROGYRE",NULL},
/* 058E */ { "SIGNE ARMÉNIEN D'ÉTERNITÉ LÉVOGYRE","	* correspondance avec AST 34.005:1997"},
/* 058F */ { "SYMBOLE DRAM ARMÉNIEN",NULL},
/* 0590 */ { NULL,NULL},
/* 0591 */ { "ACCENT HÉBREU ATNAH","	= etnahta"},
/* 0592 */ { "ACCENT HÉBREU SEGOLTA","	= sègol"},
/* 0593 */ { "ACCENT HÉBREU CHALCHELET",NULL},
/* 0594 */ { "ACCENT HÉBREU ZAQEF QATON",NULL},
/* 0595 */ { "ACCENT HÉBREU ZAQEF GADOL",NULL},
/* 0596 */ { "ACCENT HÉBREU TARHA","	= tipha\n"
	"	= me'ayla ~ mayla"},
/* 0597 */ { "ACCENT HÉBREU RAVIA","	= revia, revi'i"},
/* 0598 */ { "ACCENT HÉBREU TSINORIT","	* Ce caractère doit être utilisé lorsque le zarqa, ou tsinor, est suscrit (et centré), ainsi que pour le tsinorit.\n"
	"	* l'appellation anglaise de ce caractère est erronée\n"
	"	x (accent hébreu zarqa - 05AE)"},
/* 0599 */ { "ACCENT HÉBREU PACHTA",NULL},
/* 059A */ { "ACCENT HÉBREU YETIV",NULL},
/* 059B */ { "ACCENT HÉBREU TEVIR",NULL},
/* 059C */ { "ACCENT HÉBREU GERICH","	= gerech, teres"},
/* 059D */ { "ACCENT HÉBREU GERICH MOUQDAM","	= gerech mouqdam"},
/* 059E */ { "ACCENT HÉBREU CHENÉ GRICHINE","	= gerchâïm"},
/* 059F */ { "ACCENT HÉBREU KARNÉ FARAH","	= pazer gadol"},
/* 05A0 */ { "ACCENT HÉBREU TALCHAH","	= telicha-gedolah"},
/* 05A1 */ { "ACCENT HÉBREU PAZER","	= pazer qatan"},
/* 05A2 */ { "ACCENT HÉBREU ATNAH HAFOUKH","	x (accent hébreu yaréah ben yomo - 05AA)"},
/* 05A3 */ { "ACCENT HÉBREU CHOFAR HOLEKH","	= mounah"},
/* 05A4 */ { "ACCENT HÉBREU CHOFAR MEHOUPPAKH","	= mahpakh"},
/* 05A5 */ { "ACCENT HÉBREU MÂRIKH","	= merkha\n"
	"	= yored"},
/* 05A6 */ { "ACCENT HÉBREU TERÉ TÂMÉ","	= merkha khefoulah"},
/* 05A7 */ { "ACCENT HÉBREU DARGA",NULL},
/* 05A8 */ { "ACCENT HÉBREU QADMA","	= azla"},
/* 05A9 */ { "ACCENT HÉBREU TARSA","	= telicha qetannah"},
/* 05AA */ { "ACCENT HÉBREU YARÉAH BEN YOMO","	= galgal\n"
	"	x (accent hébreu atnah hafoukh - 05A2)"},
/* 05AB */ { "ACCENT HÉBREU OLEH",NULL},
/* 05AC */ { "ACCENT HÉBREU ILOUZ",NULL},
/* 05AD */ { "ACCENT HÉBREU DEHI",NULL},
/* 05AE */ { "ACCENT HÉBREU ZARQA","	= tsinor\n"
	"	* Ce caractère doit être utilisé lorsque le zarqa (ou tsinor) est suscrit à gauche.\n"
	"	* l'appellation anglaise de ce caractère est erronée\n"
	"	x (accent hébreu tsinorit - 0598)"},
/* 05AF */ { "DIACRITIQUE HÉBREU CERCLE MASSORÉTIQUE",NULL},
/* 05B0 */ { "POINT HÉBREU CHEVA",NULL},
/* 05B1 */ { "POINT HÉBREU HATAF SEGOL",NULL},
/* 05B2 */ { "POINT HÉBREU HATAF PATAH",NULL},
/* 05B3 */ { "POINT HÉBREU HATAF QAMATS",NULL},
/* 05B4 */ { "POINT HÉBREU HIRIK",NULL},
/* 05B5 */ { "POINT HÉBREU TSÉRÈ",NULL},
/* 05B6 */ { "POINT HÉBREU SEGOL",NULL},
/* 05B7 */ { "POINT HÉBREU PATAH","	* le patah furtif n'est pas un caractère séparé"},
/* 05B8 */ { "POINT HÉBREU QAMATS","	* utilisé de façon générique ou comme un qamats gadol dans une orthographe qui le différencie du qamats qatan\n"
	"	x (point hébreu qamats qatan - 05C7)"},
/* 05B9 */ { "POINT HÉBREU HOLAM",NULL},
/* 05BA */ { "POINT HÉBREU HOLAM HASSER POUR WAW",NULL},
/* 05BB */ { "POINT HÉBREU KOUBOUTS",NULL},
/* 05BC */ { "POINT HÉBREU DAGUÈCH OU MAPIQ","	= ou chourouk\n"
	"	* s'inscrit à l'intérieur de la lettre de base"},
/* 05BD */ { "POINT HÉBREU METEG","	= silouq\n"
	"	* peut être utilisé pour noter l'accent hébreu sof pasouq"},
/* 05BE */ { "PONCTUATION HÉBRAÏQUE MAQAF",NULL},
/* 05BF */ { "POINT HÉBREU RAFE","	x (point hébreu judéo-espagnol varika - FB1E)"},
/* 05C0 */ { "PONCTUATION HÉBRAÏQUE PASEQ","	= pési\n"
	"	= légarméh\n"
	"	* peut être considérée comme une ponctuation à chasse et non comme un point\n"
	"	x (barre verticale - 007C)"},
/* 05C1 */ { "POINT HÉBREU CHINE",NULL},
/* 05C2 */ { "POINT HÉBREU SINE",NULL},
/* 05C3 */ { "PONCTUATION HÉBRAÏQUE SOF PASOUQ","	* peut servir de deux-points hébreu\n"
	"	x (deux-points - 003A)"},
/* 05C4 */ { "DIACRITIQUE HÉBREU POINT SUPÉRIEUR",NULL},
/* 05C5 */ { "DIACRITIQUE HÉBREU POINT INFÉRIEUR","	* punctum extraordinarium (Psaumes 27:13)\n"
	"	x (point hébreu hirik - 05B4)"},
/* 05C6 */ { "PONCTUATION HÉBRAÏQUE NOUN HAFOUKHA","	* sans rapport historique avec la lettre noun\n"
	"	x (lettre hébraïque noun - 05E0)"},
/* 05C7 */ { "POINT HÉBREU QAMATS QATAN","	x (point hébreu qamats - 05B8)"},
/* 05C8 */ { NULL,NULL},
/* 05C9 */ { NULL,NULL},
/* 05CA */ { NULL,NULL},
/* 05CB */ { NULL,NULL},
/* 05CC */ { NULL,NULL},
/* 05CD */ { NULL,NULL},
/* 05CE */ { NULL,NULL},
/* 05CF */ { NULL,NULL},
/* 05D0 */ { "LETTRE HÉBRAÏQUE ALEF","	= aleph\n"
	"	x (symbole alef - 2135)"},
/* 05D1 */ { "LETTRE HÉBRAÏQUE BÈT","	= beth\n"
	"	x (symbole bèt - 2136)"},
/* 05D2 */ { "LETTRE HÉBRAÏQUE GUIMEL","	x (symbole guimel - 2137)"},
/* 05D3 */ { "LETTRE HÉBRAÏQUE DALÈT","	= daleth\n"
	"	x (symbole dalèt - 2138)"},
/* 05D4 */ { "LETTRE HÉBRAÏQUE HÈ",NULL},
/* 05D5 */ { "LETTRE HÉBRAÏQUE WAW",NULL},
/* 05D6 */ { "LETTRE HÉBRAÏQUE ZAÏN",NULL},
/* 05D7 */ { "LETTRE HÉBRAÏQUE HÈT",NULL},
/* 05D8 */ { "LETTRE HÉBRAÏQUE TÈT",NULL},
/* 05D9 */ { "LETTRE HÉBRAÏQUE YOD",NULL},
/* 05DA */ { "LETTRE HÉBRAÏQUE KAF FINAL",NULL},
/* 05DB */ { "LETTRE HÉBRAÏQUE KAF",NULL},
/* 05DC */ { "LETTRE HÉBRAÏQUE LAMÈD",NULL},
/* 05DD */ { "LETTRE HÉBRAÏQUE MÉM FINAL",NULL},
/* 05DE */ { "LETTRE HÉBRAÏQUE MÉM",NULL},
/* 05DF */ { "LETTRE HÉBRAÏQUE NOUN FINAL",NULL},
/* 05E0 */ { "LETTRE HÉBRAÏQUE NOUN",NULL},
/* 05E1 */ { "LETTRE HÉBRAÏQUE SAMÈKH",NULL},
/* 05E2 */ { "LETTRE HÉBRAÏQUE 'AÏN",NULL},
/* 05E3 */ { "LETTRE HÉBRAÏQUE PÉ FINAL",NULL},
/* 05E4 */ { "LETTRE HÉBRAÏQUE PÉ",NULL},
/* 05E5 */ { "LETTRE HÉBRAÏQUE TSADÉ FINAL",NULL},
/* 05E6 */ { "LETTRE HÉBRAÏQUE TSADÉ","	= zadé"},
/* 05E7 */ { "LETTRE HÉBRAÏQUE QOUF",NULL},
/* 05E8 */ { "LETTRE HÉBRAÏQUE RÈCH",NULL},
/* 05E9 */ { "LETTRE HÉBRAÏQUE CHINE",NULL},
/* 05EA */ { "LETTRE HÉBRAÏQUE TAW",NULL},
/* 05EB */ { NULL,NULL},
/* 05EC */ { NULL,NULL},
/* 05ED */ { NULL,NULL},
/* 05EE */ { NULL,NULL},
/* 05EF */ { NULL,NULL},
/* 05F0 */ { "LIGATURE HÉBRAÏQUE YIDICHE DOUBLE WAW","	= tsvey vovn"},
/* 05F1 */ { "LIGATURE HÉBRAÏQUE YIDICHE WAW YOD",NULL},
/* 05F2 */ { "LIGATURE HÉBRAÏQUE YIDICHE DOUBLE YOD","	= tsvey youdn"},
/* 05F3 */ { "PONCTUATION HÉBRAÏQUE GERICH","	= gerech\n"
	"	x (apostrophe - 0027)"},
/* 05F4 */ { "PONCTUATION HÉBRAÏQUE GERCHÂÏM","	x (guillemet anglais - 0022)"},
/* 05F5 */ { NULL,NULL},
/* 05F6 */ { NULL,NULL},
/* 05F7 */ { NULL,NULL},
/* 05F8 */ { NULL,NULL},
/* 05F9 */ { NULL,NULL},
/* 05FA */ { NULL,NULL},
/* 05FB */ { NULL,NULL},
/* 05FC */ { NULL,NULL},
/* 05FD */ { NULL,NULL},
/* 05FE */ { NULL,NULL},
/* 05FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_06[] = {
/* 0600 */ { "SIGNE NUMÉRAL ARABE",NULL},
/* 0601 */ { "SIGNE ARABE SANAH",NULL},
/* 0602 */ { "APPEL DE NOTE ARABE",NULL},
/* 0603 */ { "SIGNE ARABE SAFHA",NULL},
/* 0604 */ { "SIGNE ARABE SAMVAT","	* utilisé pour l'écriture des dates de l'ère samvat en ourdou"},
/* 0605 */ { "SIGNE NUMÉRAL ARABE EN CHEF","	* peut être utilisé avec les valeurs des épactes coptes"},
/* 0606 */ { "RACINE CUBIQUE ARABO-INDIENNE","	x (racine cubique - 221B)"},
/* 0607 */ { "RACINE QUATRIÈME ARABO-INDIENNE","	x (racine quatrième - 221C)"},
/* 0608 */ { "RAYON ARABE",NULL},
/* 0609 */ { "SYMBOLE ARABO-INDIEN POUR MILLE","	x (symbole pour mille - 2030)"},
/* 060A */ { "SYMBOLE ARABO-INDIEN POUR DIX MILLE","	x (symbole pour dix mille - 2031)"},
/* 060B */ { "SYMBOLE AFGHANI",NULL},
/* 060C */ { "VIRGULE ARABE","	* signe également utilisé dans les textes modernes thâna et syriaques\n"
	"	x (virgule - 002C)\n"
	"	x (virgule culbutée - 2E32)\n"
	"	x (virgule réfléchie - 2E41)"},
/* 060D */ { "SÉPARATEUR DE DATE ARABE",NULL},
/* 060E */ { "SIGNE ARABE DE VERS POÉTIQUE",NULL},
/* 060F */ { "SIGNE ARABE MISRA",NULL},
/* 0610 */ { "DIACRITIQUE ARABE SALLALLÂHOU ALAYHI WA SALLAM","	* représente sallallâhou alayhi wa sallam « que la paix et la bénédiction de Dieu soient sur lui »"},
/* 0611 */ { "DIACRITIQUE ARABE ALAYHI ASSALLAM","	* représente alayhi assallam « que la paix soit sur lui »"},
/* 0612 */ { "DIACRITIQUE ARABE RAHMATOULLAH ALAYHI","	* représente rahmatoullah alayhi « que Dieu lui fasse miséricorde »"},
/* 0613 */ { "DIACRITIQUE ARABE RADI ALLÂHOU ANHOU","	* représente radi allâhou anhou « que Dieu l'agrée »"},
/* 0614 */ { "DIACRITIQUE ARABE TAKHALLOUS","	* signe placé au-dessus du nom ou du pseudonyme d'un poète ou, parfois, pour indiquer tous les noms propres"},
/* 0615 */ { "PETIT TA' ARABE EN CHEF","	* indique une pause recommandée dans certains corans publiés en Iran et au Pakistan\n"
	"	* ne doit pas être confondu avec le petit signe TA' utilisé comme diacritique avec certaines lettres comme 0679"},
/* 0616 */ { "PETITE LIGATURE ARABE EN CHEF ALIF LAM YA'","	* vieux persan"},
/* 0617 */ { "PETIT ZAÏN ARABE EN CHEF",NULL},
/* 0618 */ { "PETIT FATHA ARABE","	* ne doit pas être confondu avec 064E FATHA"},
/* 0619 */ { "PETIT DAMMA ARABE","	* ne doit pas être confondu avec 064F DAMMA"},
/* 061A */ { "PETIT KASRA ARABE","	* ne doit pas être confondu avec 0650 KASRA"},
/* 061B */ { "POINT-VIRGULE ARABE","	* signe également utilisé dans les textes modernes thâna et syriaques\n"
	"	x (point-virgule - 003B)\n"
	"	x (point-virgule réfléchi - 204F)\n"
	"	x (point-virgule culbuté - 2E35)"},
/* 061C */ { "MARQUE DE LETTRE ARABE","	x (marque droite-à-gauche - 200F)"},
/* 061D */ { NULL,NULL},
/* 061E */ { "TROIS-POINTS ARABE",NULL},
/* 061F */ { "POINT D'INTERROGATION ARABE","	* signe également utilisé dans les textes modernes thâna et syriaques\n"
	"	x (point d'interrogation - 003F)\n"
	"	x (point d'interrogation réfléchi - 2E2E)"},
/* 0620 */ { "LETTRE ARABE CACHEMIRI YA'",NULL},
/* 0621 */ { "LETTRE ARABE HAMZA","	= hemza\n"
	"	* attaque vocalique, coup d'éperon\n"
	"	x (lettre modificative demi-rond droit - 02BE)"},
/* 0622 */ { "LETTRE ARABE ALIF MADDA EN CHEF","	: 0627 0653"},
/* 0623 */ { "LETTRE ARABE ALIF HAMZA EN CHEF","	: 0627 0654"},
/* 0624 */ { "LETTRE ARABE WAW HAMZA EN CHEF","	: 0648 0654"},
/* 0625 */ { "LETTRE ARABE ALIF HAMZA SOUSCRITE","	: 0627 0655"},
/* 0626 */ { "LETTRE ARABE YA' HAMZA EN CHEF","	: 064A 0654"},
/* 0627 */ { "LETTRE ARABE ALIF",NULL},
/* 0628 */ { "LETTRE ARABE BA'",NULL},
/* 0629 */ { "LETTRE ARABE TÉ' MARBOUTA","	= tâ' marboûta, tâ' lié"},
/* 062A */ { "LETTRE ARABE TÉ'","	= tâ'"},
/* 062B */ { "LETTRE ARABE THÉ'","	= thâ'"},
/* 062C */ { "LETTRE ARABE DJÎM",NULL},
/* 062D */ { "LETTRE ARABE HA'",NULL},
/* 062E */ { "LETTRE ARABE KHA'",NULL},
/* 062F */ { "LETTRE ARABE DAL",NULL},
/* 0630 */ { "LETTRE ARABE DHAL",NULL},
/* 0631 */ { "LETTRE ARABE RA'",NULL},
/* 0632 */ { "LETTRE ARABE ZAÏN",NULL},
/* 0633 */ { "LETTRE ARABE SÎN",NULL},
/* 0634 */ { "LETTRE ARABE CHÎN",NULL},
/* 0635 */ { "LETTRE ARABE ÇAD","	= sad"},
/* 0636 */ { "LETTRE ARABE DAD",NULL},
/* 0637 */ { "LETTRE ARABE TA'",NULL},
/* 0638 */ { "LETTRE ARABE ZZA'",NULL},
/* 0639 */ { "LETTRE ARABE 'AÏN","	x (lettre minuscule latine ej réfléchi - 01B9)\n"
	"	x (lettre modificative demi-rond gauche - 02BF)"},
/* 063A */ { "LETTRE ARABE GHAÏN",NULL},
/* 063B */ { "LETTRE ARABE KEHA' DEUX POINTS EN CHEF",NULL},
/* 063C */ { "LETTRE ARABE KEHA' TROIS POINTS SOUSCRITS",NULL},
/* 063D */ { "LETTRE ARABE FARSI YA' PIGNON","	* azéri"},
/* 063E */ { "LETTRE ARABE FARSI YA' DEUX POINTS EN CHEF",NULL},
/* 063F */ { "LETTRE ARABE FARSI YA' TROIS POINTS EN CHEF",NULL},
/* 0640 */ { "TATOUÏL ARABE","	= kachidé, allonge, tatwil\n"
	"	* inséré pour justifier horizontalement les lignes de texte, en étendant la longueur des caractères\n"
	"	* utilisé aussi en mandéen, en manichéen, en pehlvi des psautiers et en syriaque"},
/* 0641 */ { "LETTRE ARABE FA'",NULL},
/* 0642 */ { "LETTRE ARABE QAF",NULL},
/* 0643 */ { "LETTRE ARABE KAF",NULL},
/* 0644 */ { "LETTRE ARABE LAM",NULL},
/* 0645 */ { "LETTRE ARABE MÎM",NULL},
/* 0646 */ { "LETTRE ARABE NOÛN",NULL},
/* 0647 */ { "LETTRE ARABE HÉ'",NULL},
/* 0648 */ { "LETTRE ARABE WAW",NULL},
/* 0649 */ { "LETTRE ARABE ALIF MAKSOURA","	= alif maqsoûra, alif bref\n"
	"	* représente une lettre en forme de ya' sans point en position finale ou isolée\n"
	"	* elle n'est pas destinée pour une utilisation en combinaison avec 0654\n"
	"	x (lettre arabe ya' hamza en chef - 0626)"},
/* 064A */ { "LETTRE ARABE YA'","	* elle perd ses points quand elle est utilisée en combinaison avec 0654\n"
	"	* elle conserve ses points quand elle est utilisée en combinaison avec d'autres diacritiques\n"
	"	x (lettre arabe ya' deux points souscrits et hamza en chef - 08A8)"},
/* 064B */ { "FATHATAN ARABE","	= tanwîn, tenouyn"},
/* 064C */ { "DAMMATAN ARABE","	* une autre forme commune se présente comme deux dammas entrelacés, dont l'un est tourné de 180 degrés"},
/* 064D */ { "KASRATAN ARABE",NULL},
/* 064E */ { "FATHA ARABE","	= nasbéh"},
/* 064F */ { "DAMMA ARABE","	= dhammah, roufa'h"},
/* 0650 */ { "KASRA ARABE","	= khoufdah"},
/* 0651 */ { "CHADDA ARABE","	= tachdîd, chedda\n"
	"	* indique la gémination (ou le renforcement) de la consonne"},
/* 0652 */ { "SOUKOUN ARABE","	= djezm, quiescence, soukoûn\n"
	"	* indique l'absence de voyelle après une consonne de base\n"
	"	* utilisé dans les annotations coraniques pour indiquer une longue voyelle à ignorer\n"
	"	* peut prendre une variété de formes, y compris une forme circulaire ou une forme semblable à 06E1\n"
	"	x (petite tête de kha' arabe en chef sans point - 06E1)"},
/* 0653 */ { "MADDA ARABE EN CHEF","	= medda suscrite"},
/* 0654 */ { "HAMZA ARABE EN CHEF","	= hemza suscrite"},
/* 0655 */ { "HAMZA ARABE SOUSCRITE","	= hemza souscrite"},
/* 0656 */ { "ALIF ARABE SOUSCRIT",NULL},
/* 0657 */ { "DAMMA ARABE CULBUTÉ","	* cachemiri, ourdou"},
/* 0658 */ { "DIACRITIQUE ARABE NOÛN GHOUNNA","	* baloutche\n"
	"	* indique la nasalisation en ourdou"},
/* 0659 */ { "ZWARAKAÏ ARABE","	* pachto"},
/* 065A */ { "DIACRITIQUE VOYELLE ARABE PETIT V EN CHEF","	* langues africaines"},
/* 065B */ { "DIACRITIQUE VOYELLE ARABE PIGNON","	* langues africaines"},
/* 065C */ { "DIACRITIQUE VOYELLE ARABE POINT SOUSCRIT","	* langues africaines"},
/* 065D */ { "DAMMA ARABE RÉFLÉCHI","	* langues africaines"},
/* 065E */ { "FATHA ARABE À DEUX POINTS","	* kohistani de Kalam"},
/* 065F */ { "HAMZA ONDÉE ARABE SOUSCRITE","	* cachemiri"},
/* 0660 */ { "CHIFFRE ARABO-INDIEN ZÉRO",NULL},
/* 0661 */ { "CHIFFRE ARABO-INDIEN UN",NULL},
/* 0662 */ { "CHIFFRE ARABO-INDIEN DEUX",NULL},
/* 0663 */ { "CHIFFRE ARABO-INDIEN TROIS",NULL},
/* 0664 */ { "CHIFFRE ARABO-INDIEN QUATRE",NULL},
/* 0665 */ { "CHIFFRE ARABO-INDIEN CINQ",NULL},
/* 0666 */ { "CHIFFRE ARABO-INDIEN SIX",NULL},
/* 0667 */ { "CHIFFRE ARABO-INDIEN SEPT",NULL},
/* 0668 */ { "CHIFFRE ARABO-INDIEN HUIT",NULL},
/* 0669 */ { "CHIFFRE ARABO-INDIEN NEUF",NULL},
/* 066A */ { "SYMBOLE ARABE POUR CENT","	x (symbole pour cent - 0025)"},
/* 066B */ { "SÉPARATEUR DÉCIMAL ARABE",NULL},
/* 066C */ { "SÉPARATEUR DE MILLIERS ARABE","	x (apostrophe - 0027)\n"
	"	x (guillemet-apostrophe - 2019)"},
/* 066D */ { "ÉTOILE À CINQ BRANCHES ARABE","	* apparence variable\n"
	"	x (astérisque - 002A)"},
/* 066E */ { "LETTRE ARABE BA' SANS POINT",NULL},
/* 066F */ { "LETTRE ARABE QAF SANS POINT",NULL},
/* 0670 */ { "DIACRITIQUE VOYELLE ARABE ALIF EN CHEF","	* l'appellation anglaise de ce caractère est erronée"},
/* 0671 */ { "LETTRE ARABE ALIF WASLA","	= alif ouasl\n"
	"	* arabe coranique"},
/* 0672 */ { "LETTRE ARABE ALIF HAMZA ONDÉE EN CHEF","	* baloutche, cachemiri"},
/* 0673 */ { "LETTRE ARABE ALIF HAMZA ONDÉE SOUSCRITE","	* cachemiri\n"
	"	* ce caractère est obsolète et son utilisation est fortement déconseillée\n"
	"	* il faut utiliser plutôt la séquence 0627 065F"},
/* 0674 */ { "LETTRE ARABE HAMZA ÉLEVÉE","	* kazakh\n"
	"	* permet de former des digrammes"},
/* 0675 */ { "LETTRE ARABE HAMZA ÉLEVÉE ALIF","	* kazakh\n"
	"	# 0627 0674"},
/* 0676 */ { "LETTRE ARABE HAMZA ÉLEVÉE WAW","	* kazakh\n"
	"	# 0648 0674"},
/* 0677 */ { "LETTRE ARABE OU HAMZA EN CHEF","	* kazakh\n"
	"	# 06C7 0674"},
/* 0678 */ { "LETTRE ARABE HAMZA ÉLEVÉE YA'","	* kazakh\n"
	"	# 064A 0674"},
/* 0679 */ { "LETTRE ARABE TTA'","	* ourdou"},
/* 067A */ { "LETTRE ARABE TTEHA'","	* sindhi"},
/* 067B */ { "LETTRE ARABE BEA'","	* sindhi"},
/* 067C */ { "LETTRE ARABE TÉ' ROND","	* pachto"},
/* 067D */ { "LETTRE ARABE TÉ' TROIS POINTS EN CHEF POINTANT VERS LE BAS","	* sindhi"},
/* 067E */ { "LETTRE ARABE PA'","	* persan, ourdou, etc."},
/* 067F */ { "LETTRE ARABE TEHA'","	* sindhi"},
/* 0680 */ { "LETTRE ARABE BEHA'","	* sindhi"},
/* 0681 */ { "LETTRE ARABE HA' HAMZA EN CHEF","	* pachto"},
/* 0682 */ { "LETTRE ARABE HA' DEUX POINTS VERTICAUX EN CHEF","	* inusité en pachto moderne"},
/* 0683 */ { "LETTRE ARABE NYA'","	* sindhi"},
/* 0684 */ { "LETTRE ARABE DYA'","	* sindhi"},
/* 0685 */ { "LETTRE ARABE HA' TROIS POINTS EN CHEF","	* pachto, chorasmien (khwarezmien)"},
/* 0686 */ { "LETTRE ARABE TCHIM'","	* persan, ourdou, etc."},
/* 0687 */ { "LETTRE ARABE TCHEHA'","	* sindhi"},
/* 0688 */ { "LETTRE ARABE DDAL","	* ourdou"},
/* 0689 */ { "LETTRE ARABE DAL ROND","	* pachto"},
/* 068A */ { "LETTRE ARABE DAL POINT SOUSCRIT","	* sindhi, vieux persan"},
/* 068B */ { "LETTRE ARABE DAL POINT SOUSCRIT ET PETIT TA'","	* langues lahnda"},
/* 068C */ { "LETTRE ARABE DAHAL","	* sindhi"},
/* 068D */ { "LETTRE ARABE DDAHAL","	* sindhi"},
/* 068E */ { "LETTRE ARABE DOUL","	* forme désormais désuète du DOUL en sindhi\n"
	"	* bourouchaski"},
/* 068F */ { "LETTRE ARABE DAL TROIS POINTS EN CHEF POINTANT VERS LE BAS","	* sindhi\n"
	"	* forme actuelle du DOUL"},
/* 0690 */ { "LETTRE ARABE DAL QUATRE POINTS EN CHEF","	* vieil ourdou, inusité"},
/* 0691 */ { "LETTRE ARABE RRA'","	* ourdou"},
/* 0692 */ { "LETTRE ARABE RA' PETIT V","	* kurde"},
/* 0693 */ { "LETTRE ARABE RA' ROND","	* pachto"},
/* 0694 */ { "LETTRE ARABE RA' POINT SOUSCRIT","	* kurde, vieux persan"},
/* 0695 */ { "LETTRE ARABE RA' PETIT V SOUSCRIT","	* kurde"},
/* 0696 */ { "LETTRE ARABE RA' POINT SOUSCRIT ET POINT EN CHEF","	* pachto"},
/* 0697 */ { "LETTRE ARABE RA' DEUX POINTS EN CHEF","	* dargwa"},
/* 0698 */ { "LETTRE ARABE JA'","	* persan, ourdou, etc."},
/* 0699 */ { "LETTRE ARABE RA' QUATRE POINTS EN CHEF","	* sindhi"},
/* 069A */ { "LETTRE ARABE SÎN POINT SOUSCRIT ET POINT EN CHEF","	* pachto"},
/* 069B */ { "LETTRE ARABE SÎN TROIS POINTS SOUSCRITS","	* vieux persan"},
/* 069C */ { "LETTRE ARABE SÎN TROIS POINTS SOUSCRITS ET TROIS POINTS EN CHEF","	* arabe marocain"},
/* 069D */ { "LETTRE ARABE ÇAD DEUX POINTS SOUSCRITS","	* langues turques"},
/* 069E */ { "LETTRE ARABE ÇAD TROIS POINTS EN CHEF","	* berbère, bourouchaski"},
/* 069F */ { "LETTRE ARABE TA' TROIS POINTS EN CHEF","	* vieil haoussa"},
/* 06A0 */ { "LETTRE ARABE 'AÏN TROIS POINTS EN CHEF","	* vieux malais"},
/* 06A1 */ { "LETTRE ARABE FA' SANS POINT","	* adighe"},
/* 06A2 */ { "LETTRE ARABE FA' POINT DESCENDU","	* arabe maghrébin"},
/* 06A3 */ { "LETTRE ARABE FA' POINT SOUSCRIT","	* ingouche"},
/* 06A4 */ { "LETTRE ARABE VA'","	* parfois utilisée pour l'écriture de mots d'emprunt en arabe\n"
	"	* kurde, chorasmien (khwarezmien), vieux persan"},
/* 06A5 */ { "LETTRE ARABE FA' TROIS POINTS SOUSCRITS","	* arabe maghrébin dans les mots d'emprunt"},
/* 06A6 */ { "LETTRE ARABE PEHA'","	* sindhi"},
/* 06A7 */ { "LETTRE ARABE QAF POINT EN CHEF","	* arabe maghrébin, ouïgour"},
/* 06A8 */ { "LETTRE ARABE QAF TROIS POINTS EN CHEF","	* arabe tunisien"},
/* 06A9 */ { "LETTRE ARABE KEHA'","	* persan, ourdou, etc."},
/* 06AA */ { "LETTRE ARABE KAF ÉCRASÉ","	= kaf de l'impiété, kaf paraphe\n"
	"	* en sindhi, représente un lettre distincte du KAF arabe (0643)"},
/* 06AB */ { "LETTRE ARABE KAF ROND","	* pachto\n"
	"	* peut ressembler à un KAF arabe (0643) avec un rond souscrit"},
/* 06AC */ { "LETTRE ARABE KAF POINT EN CHEF","	* vieux malais"},
/* 06AD */ { "LETTRE ARABE NG","	* ouïgour, kazakh, vieux malais, vieux persan, etc."},
/* 06AE */ { "LETTRE ARABE KAF TROIS POINTS SOUSCRITS","	* berbère, vieux persan"},
/* 06AF */ { "LETTRE ARABE GAF","	* persan, ourdou, etc."},
/* 06B0 */ { "LETTRE ARABE GAF ROND","	* langues lahnda"},
/* 06B1 */ { "LETTRE ARABE NGOA'","	* sindhi"},
/* 06B2 */ { "LETTRE ARABE GAF DEUX POINTS SOUSCRITS","	* inusité en sindhi"},
/* 06B3 */ { "LETTRE ARABE GOUA'","	* sindhi"},
/* 06B4 */ { "LETTRE ARABE GAF TROIS POINTS EN CHEF","	* inusité en sindhi"},
/* 06B5 */ { "LETTRE ARABE LAM PETIT V","	* kurde"},
/* 06B6 */ { "LETTRE ARABE LAM POINT EN CHEF","	* kurde"},
/* 06B7 */ { "LETTRE ARABE LAM TROIS POINTS EN CHEF","	* kurde"},
/* 06B8 */ { "LETTRE ARABE LAM TROIS POINTS SOUSCRITS",NULL},
/* 06B9 */ { "LETTRE ARABE NOÛN POINT SOUSCRIT",NULL},
/* 06BA */ { "LETTRE ARABE NOÛN GHOUNNA","	* ourdou, arabe archaïque\n"
	"	* n'a de point dans aucune de ses quatre formes"},
/* 06BB */ { "LETTRE ARABE NNOÛN","	* sindhi"},
/* 06BC */ { "LETTRE ARABE NOÛN ROND","	* pachto"},
/* 06BD */ { "LETTRE ARABE NOÛN TROIS POINTS EN CHEF","	* vieux malais"},
/* 06BE */ { "LETTRE ARABE HÉ' DOATCHACHMI","	= hé' noué\n"
	"	* forme des digrammes aspirés en ourdou et dans d'autres langues d'Asie du Sud\n"
	"	* représente la fricative glottale /h/ en ouïgour"},
/* 06BF */ { "LETTRE ARABE TCHIM' POINT EN CHEF",NULL},
/* 06C0 */ { "LIGATURE ARABE HÉ' YA' EN CHEF","	= lettre arabe hamza sur hé' (1.0)\n"
	"	= izafet\n"
	"	* l'appellation anglaise de ce caractère est erronée\n"
	"	: 06D5 0654"},
/* 06C1 */ { "LETTRE ARABE HÉ' GÔL","	* ourdou"},
/* 06C2 */ { "LIGATURE ARABE HÉ' GÔL HAMZA EN CHEF","	* ourdou\n"
	"	* l'appellation anglaise de ce caractère est erronée\n"
	"	: 06C1 0654"},
/* 06C3 */ { "LETTRE ARABE TÉ' MARBOUTA GÔL","	* ourdou"},
/* 06C4 */ { "LETTRE ARABE WAW ROND","	* cachemiri"},
/* 06C5 */ { "LETTRE ARABE KIRGHIZE EU","	* kirghize\n"
	"	* composée d'un waw diacrité d'une barre inscrite"},
/* 06C6 */ { "LETTRE ARABE EU","	* ouïgour, kurde, kazakh, azéri\n"
	"	* composée d'un waw diacrité d'un petit v suscrit"},
/* 06C7 */ { "LETTRE ARABE OU","	* kirghize, azéri"},
/* 06C8 */ { "LETTRE ARABE YOU","	* ouïgour\n"
	"	* composée d'un waw diacrité d'un petit alif suscrit"},
/* 06C9 */ { "LETTRE ARABE KIRGHIZE YOU","	* kazakh, kirghize"},
/* 06CA */ { "LETTRE ARABE WAW DEUX POINTS EN CHEF","	* kurde"},
/* 06CB */ { "LETTRE ARABE VÉ","	* ouïgour, kazakh"},
/* 06CC */ { "LETTRE ARABE FARSI YA'","	* arabe, persan, ourdou, cachemiri, etc.\n"
	"	* les formes initiales et médiales de cette lettre sont pourvues de points\n"
	"	x (lettre arabe alif maksoura - 0649)\n"
	"	x (lettre arabe ya' - 064A)"},
/* 06CD */ { "LETTRE ARABE YA' À QUEUE","	* pachto, sindhi"},
/* 06CE */ { "LETTRE ARABE YA' PETIT V","	* kurde"},
/* 06CF */ { "LETTRE ARABE WAW POINT EN CHEF",NULL},
/* 06D0 */ { "LETTRE ARABE É","	* pachto, ouïgour\n"
	"	* représente la lettre bbé' en sindhi"},
/* 06D1 */ { "LETTRE ARABE YA' TROIS POINTS SOUSCRITS","	* vieux malais"},
/* 06D2 */ { "LETTRE ARABE YA' BARRÉ","	* ourdou"},
/* 06D3 */ { "LIGATURE ARABE YA' BARRÉ HAMZA EN CHEF","	* ourdou\n"
	"	* l'appellation anglaise de ce caractère est erronée\n"
	"	: 06D2 0654"},
/* 06D4 */ { "POINT ARABE","	* ourdou"},
/* 06D5 */ { "LETTRE ARABE E","	* ouïgour, kazakh, kirghize"},
/* 06D6 */ { "PETITE LIGATURE ARABE EN CHEF ÇAD LAM ALIF MAKSOURA",NULL},
/* 06D7 */ { "PETITE LIGATURE ARABE EN CHEF QAF LAM ALIF MAKSOURA",NULL},
/* 06D8 */ { "PETIT MÎM INITIAL ARABE EN CHEF",NULL},
/* 06D9 */ { "PETIT LAM ALIF ARABE EN CHEF",NULL},
/* 06DA */ { "PETIT DJÎM ARABE EN CHEF",NULL},
/* 06DB */ { "TROIS POINTS ARABES EN CHEF",NULL},
/* 06DC */ { "PETIT SÎN ARABE EN CHEF",NULL},
/* 06DD */ { "FIN D'AYA ARABE",NULL},
/* 06DE */ { "DÉBUT DE ROUB EL HIZB ARABE",NULL},
/* 06DF */ { "PETIT ZÉRO ARABE EN CHEF ARRONDI","	* plus petit que la forme circulaire utilisée pour 0652"},
/* 06E0 */ { "PETIT ZÉRO ARABE EN CHEF RECTANGULAIRE VERTICAL",NULL},
/* 06E1 */ { "PETITE TÊTE DE KHA' ARABE EN CHEF SANS POINT","	= djezm arabe\n"
	"	* la forme de présentation de 0652 avec le choix de la forme de variante par le biais de la police est recommandée\n"
	"	* s'utilise dans le Coran pour indiquer l'absence de voyelle\n"
	"	x (soukoun arabe - 0652)"},
/* 06E2 */ { "PETIT MÎM ARABE EN CHEF ISOLÉ",NULL},
/* 06E3 */ { "PETIT SÎN ARABE SOUSCRIT",NULL},
/* 06E4 */ { "PETIT MADDA ARABE EN CHEF","	* s'utilise généralement avec 06E5, 06E6, 06E7 et 08F3"},
/* 06E5 */ { "PETIT WAW ARABE","	x (petit waw arabe en chef - 08F3)"},
/* 06E6 */ { "PETIT YA' ARABE",NULL},
/* 06E7 */ { "PETIT YA' ARABE EN CHEF",NULL},
/* 06E8 */ { "PETIT NOÛN ARABE EN CHEF",NULL},
/* 06E9 */ { "SIGNE DE PROSTERNATION ARABE","	= sajdah\n"
	"	* une série de glyphes conviennent pour ce caractère"},
/* 06EA */ { "POINT CONTOUR ARABE SOUSCRIT",NULL},
/* 06EB */ { "POINT CONTOUR ARABE EN CHEF",NULL},
/* 06EC */ { "POINT PLEIN ARABE EN CHEF",NULL},
/* 06ED */ { "PETIT MÎM ARABE SOUSCRIT",NULL},
/* 06EE */ { "LETTRE ARABE DAL PIGNON",NULL},
/* 06EF */ { "LETTRE ARABE RA' PIGNON","	* utilisée aussi en vieux persan"},
/* 06F0 */ { "CHIFFRE ARABO-INDIEN ÉTENDU ZÉRO",NULL},
/* 06F1 */ { "CHIFFRE ARABO-INDIEN ÉTENDU UN",NULL},
/* 06F2 */ { "CHIFFRE ARABO-INDIEN ÉTENDU DEUX",NULL},
/* 06F3 */ { "CHIFFRE ARABO-INDIEN ÉTENDU TROIS",NULL},
/* 06F4 */ { "CHIFFRE ARABO-INDIEN ÉTENDU QUATRE","	* le glyphe persan est différent du glyphe sindhi et ourdou"},
/* 06F5 */ { "CHIFFRE ARABO-INDIEN ÉTENDU CINQ","	* le persan, le sindhi et l'ourdou partagent un même glyphe, différent du glyphe arabe"},
/* 06F6 */ { "CHIFFRE ARABO-INDIEN ÉTENDU SIX","	* le persan, le sindhi et l'ourdou ont des glyphes différents du glyphe arabe"},
/* 06F7 */ { "CHIFFRE ARABO-INDIEN ÉTENDU SEPT","	* l'ourdou et le sindhi ont des glyphes différents du glyphe arabe"},
/* 06F8 */ { "CHIFFRE ARABO-INDIEN ÉTENDU HUIT",NULL},
/* 06F9 */ { "CHIFFRE ARABO-INDIEN ÉTENDU NEUF",NULL},
/* 06FA */ { "LETTRE ARABE CHÎN POINT SOUSCRIT",NULL},
/* 06FB */ { "LETTRE ARABE DAD POINT SOUSCRIT",NULL},
/* 06FC */ { "LETTRE ARABE GHAÏN POINT SOUSCRIT",NULL},
/* 06FD */ { "SIGNE ARABE SINDHI PERLUÈTE",NULL},
/* 06FE */ { "SIGNE ARABE SINDHI MEN DE POSTPOSITION",NULL},
/* 06FF */ { "LETTRE ARABE HÉ' PIGNON",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_07[] = {
/* 0700 */ { "FIN DE PARAGRAPHE SYRIAQUE","	* marque la fin d'un paragraphe"},
/* 0701 */ { "POINT SYRIAQUE SUPRALINÉAIRE","	* indique une interrogative, l'impératif et les pauses, particulièrement dans les textes bibliques"},
/* 0702 */ { "POINT SYRIAQUE SUBLINÉAIRE","	* indique les propositions subordonnées et les courtes pauses, particulièrement dans les textes bibliques"},
/* 0703 */ { "DEUX-POINTS SYRIAQUE SUPRALINÉAIRE","	* marque l'étonnement"},
/* 0704 */ { "DEUX-POINTS SYRIAQUE SUBLINÉAIRE","	* utilisé à la fin de versets d'imploration"},
/* 0705 */ { "DEUX-POINTS SYRIAQUE HORIZONTAL","	* rapproche deux mots là où un ton montant est adapté"},
/* 0706 */ { "DEUX-POINTS SYRIAQUE EN BIAIS À GAUCHE","	* indique une subordonnée"},
/* 0707 */ { "DEUX-POINTS SYRIAQUE EN BIAIS À DROITE","	* indique la fin d'une subdivision de l'apodose, la dernière partie d'un verset biblique"},
/* 0708 */ { "DEUX-POINTS SYRIAQUE SUPRALINÉAIRE EN BIAIS À GAUCHE","	* indique une division mineure dans une proposition"},
/* 0709 */ { "DEUX-POINTS SYRIAQUE SUBLINÉAIRE EN BIAIS À GAUCHE","	* indique la fin d'une question réelle ou oratoire\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 070A */ { "CONTRACTION SYRIAQUE","	* signe de contraction, utilisé principalement en syriaque oriental\n"
	"	* placée à la fin d'un mot inachevé"},
/* 070B */ { "OBÈLE SYRIAQUE HÉRACLÉEN","	= obèle d'Harqel\n"
	"	* indique le début d'une proposition, d'un mot ou d'un morphème glosé\n"
	"	x (signe de division - 00F7)"},
/* 070C */ { "MÉTOBÈLE SYRIAQUE HÉRACLÉEN","	= métobèle d'Harqel\n"
	"	* indique la fin d'une section glosée"},
/* 070D */ { "ASTÉRISQUE SYRIAQUE HÉRACLÉEN","	= astérisque d'Harqel\n"
	"	* indique le début d'une proposition, d'un mot ou d'un morphème glosé"},
/* 070E */ { NULL,NULL},
/* 070F */ { "SIGNE D'ABRÉVIATION SYRIAQUE","	* indique le début d'une abréviation syriaque"},
/* 0710 */ { "LETTRE SYRIAQUE ÂLAPH",NULL},
/* 0711 */ { "LETTRE SYRIAQUE ÂLAPH EN CHEF","	* utilisée dans les textes syriaques orientaux pour indiquer un âlaph étymologique"},
/* 0712 */ { "LETTRE SYRIAQUE BÊTH",NULL},
/* 0713 */ { "LETTRE SYRIAQUE GÂMAL",NULL},
/* 0714 */ { "LETTRE SYRIAQUE GÂMAL GARCHOUNI","	* utilisée dans les documents garchounis"},
/* 0715 */ { "LETTRE SYRIAQUE DÂLATH",NULL},
/* 0716 */ { "LETTRE SYRIAQUE DÂLATH RÎCH SANS POINT","	* forme ambiguë et non différenciée des dâlath et des rîch primitifs"},
/* 0717 */ { "LETTRE SYRIAQUE HÊ",NULL},
/* 0718 */ { "LETTRE SYRIAQUE WAW",NULL},
/* 0719 */ { "LETTRE SYRIAQUE ZAÏN",NULL},
/* 071A */ { "LETTRE SYRIAQUE HHÊTH",NULL},
/* 071B */ { "LETTRE SYRIAQUE TTÊTH",NULL},
/* 071C */ { "LETTRE SYRIAQUE TTÊTH GARCHOUNI","	* utilisée dans les documents garchounis"},
/* 071D */ { "LETTRE SYRIAQUE YOÛDH",NULL},
/* 071E */ { "LETTRE SYRIAQUE YOÛDH HÊ","	* utilisée principalement dans des textes syriaques orientaux"},
/* 071F */ { "LETTRE SYRIAQUE KÂPH",NULL},
/* 0720 */ { "LETTRE SYRIAQUE LÂMADH",NULL},
/* 0721 */ { "LETTRE SYRIAQUE MÎM",NULL},
/* 0722 */ { "LETTRE SYRIAQUE NOÛN",NULL},
/* 0723 */ { "LETTRE SYRIAQUE SEMKATH",NULL},
/* 0724 */ { "LETTRE SYRIAQUE SEMKATH FINAL",NULL},
/* 0725 */ { "LETTRE SYRIAQUE 'Ê",NULL},
/* 0726 */ { "LETTRE SYRIAQUE PÊ",NULL},
/* 0727 */ { "LETTRE SYRIAQUE PÊ RÉFLÉCHI","	* utilisée en araméen chrétien de Palestine"},
/* 0728 */ { "LETTRE SYRIAQUE SSÂDHÊ","	= çâdhê"},
/* 0729 */ { "LETTRE SYRIAQUE QOÛPH",NULL},
/* 072A */ { "LETTRE SYRIAQUE RÎCH",NULL},
/* 072B */ { "LETTRE SYRIAQUE CHÎN",NULL},
/* 072C */ { "LETTRE SYRIAQUE TAW",NULL},
/* 072D */ { "LETTRE SYRIAQUE PERSANE BHÂTH",NULL},
/* 072E */ { "LETTRE SYRIAQUE PERSANE GHÂMAL",NULL},
/* 072F */ { "LETTRE SYRIAQUE PERSANE DHÂLATH",NULL},
/* 0730 */ { "PETHÂHHÂ SYRIAQUE EN CHEF",NULL},
/* 0731 */ { "PETHÂHHÂ SYRIAQUE SOUSCRIT",NULL},
/* 0732 */ { "PETHÂHHÂ SYRIAQUE POINTÉ",NULL},
/* 0733 */ { "ZEQÂPHÂ SYRIAQUE EN CHEF",NULL},
/* 0734 */ { "ZEQÂPHÂ SYRIAQUE SOUSCRIT",NULL},
/* 0735 */ { "ZEQÂPHÂ SYRIAQUE POINTILLÉ",NULL},
/* 0736 */ { "REVÂSSÂ SYRIAQUE EN CHEF",NULL},
/* 0737 */ { "REVÂSSÂ SYRIAQUE SOUSCRIT",NULL},
/* 0738 */ { "ZELÂMÂ SYRIAQUE POINTILLÉ HORIZONTAL",NULL},
/* 0739 */ { "ZELÂMÂ SYRIAQUE POINTILLÉ OBLIQUE",NULL},
/* 073A */ { "HHEVÂSSÂ SYRIAQUE EN CHEF",NULL},
/* 073B */ { "HHEVÂSSÂ SYRIAQUE SOUSCRIT",NULL},
/* 073C */ { "HHEVÂSSÂ-'ESSÂSÂ SYRIAQUE POINTÉ",NULL},
/* 073D */ { "'ESSÂSÂ SYRIAQUE EN CHEF",NULL},
/* 073E */ { "'ESSÂSÂ SYRIAQUE SOUSCRIT",NULL},
/* 073F */ { "REWÂHHÂ SYRIAQUE",NULL},
/* 0740 */ { "POINT FÉMININ SYRIAQUE","	* marque du féminin utilisée avec la désinence féminine taw"},
/* 0741 */ { "QOUCHCHÂI SYRIAQUE","	* indique une prononciation plosive"},
/* 0742 */ { "ROUKKÂKH SYRIAQUE","	* indique une prononciation aspirée (spirante)"},
/* 0743 */ { "DEUX POINTS VERTICAUX SYRIAQUES EN CHEF","	* accent utilisé dans des manuscrits anciens"},
/* 0744 */ { "DEUX POINTS VERTICAUX SYRIAQUES SOUSCRITS","	* accent utilisé dans des manuscrits anciens"},
/* 0745 */ { "TROIS POINTS SYRIAQUES EN CHEF","	* diacritique utilisé en touroyo pour les lettres inexistantes en syriaque"},
/* 0746 */ { "TROIS POINTS SYRIAQUES SOUSCRITS","	* diacritique utilisé en touroyo pour les lettres inexistantes en syriaque"},
/* 0747 */ { "LIGNE OBLIQUE SYRIAQUE EN CHEF","	= trait occultant suscrit, abrogateur suscrit\n"
	"	* indique une lettre muette"},
/* 0748 */ { "LIGNE OBLIQUE SYRIAQUE SOUSCRITE","	= trait occultant souscrit, abrogateur souscrit\n"
	"	* indique une lettre muette\n"
	"	* indique également des nombres multipliés par une constante donnée"},
/* 0749 */ { "MUSIQUE SYRIAQUE","	* un signe de musique\n"
	"	* signe également utilisé dans l'Anaphore orthodoxe syrienne pour indiquer la rupture du pain de l'Eucharistie"},
/* 074A */ { "BARREKH SYRIAQUE","	* croix diacritique utilisée dans les textes liturgiques"},
/* 074B */ { NULL,NULL},
/* 074C */ { NULL,NULL},
/* 074D */ { "LETTRE SYRIAQUE SOGDIENNE ZHAÏN",NULL},
/* 074E */ { "LETTRE SYRIAQUE SOGDIENNE KHÂPH",NULL},
/* 074F */ { "LETTRE SYRIAQUE SOGDIENNE FÊ",NULL},
/* 0750 */ { "LETTRE ARABE BA' TROIS POINTS HORIZONTAUX SOUSCRITS",NULL},
/* 0751 */ { "LETTRE ARABE BA' UN POINT SOUSCRIT ET TROIS POINTS EN CHEF",NULL},
/* 0752 */ { "LETTRE ARABE BA' TROIS POINTS SOUSCRITS POINTANT VERS LE HAUT",NULL},
/* 0753 */ { "LETTRE ARABE BA' TROIS POINTS SOUSCRITS POINTANT VERS LE HAUT ET DEUX POINTS EN CHEF",NULL},
/* 0754 */ { "LETTRE ARABE BA' DEUX POINTS SOUSCRITS ET POINT EN CHEF",NULL},
/* 0755 */ { "LETTRE ARABE BA' PIGNON SOUSCRIT",NULL},
/* 0756 */ { "LETTRE ARABE BA' PETIT V EN CHEF",NULL},
/* 0757 */ { "LETTRE ARABE HA' DEUX POINTS EN CHEF",NULL},
/* 0758 */ { "LETTRE ARABE HA' TROIS POINTS SOUSCRITS POINTANT VERS LE HAUT",NULL},
/* 0759 */ { "LETTRE ARABE DAL DEUX POINTS VERTICAUX SOUSCRITS ET PETIT TA'","	* saraïki"},
/* 075A */ { "LETTRE ARABE DAL PIGNON SOUSCRIT",NULL},
/* 075B */ { "LETTRE ARABE RA' BARRÉ",NULL},
/* 075C */ { "LETTRE ARABE SÎN QUATRE POINTS EN CHEF","	* china"},
/* 075D */ { "LETTRE ARABE 'AÏN DEUX POINTS EN CHEF",NULL},
/* 075E */ { "LETTRE ARABE 'AÏN TROIS POINTS EN CHEF POINTANT VERS LE BAS",NULL},
/* 075F */ { "LETTRE ARABE 'AÏN DEUX POINTS VERTICAUX EN CHEF",NULL},
/* 0760 */ { "LETTRE ARABE FA' DEUX POINTS SOUSCRITS",NULL},
/* 0761 */ { "LETTRE ARABE FA' TROIS POINTS SOUSCRITS POINTANT VERS LE HAUT",NULL},
/* 0762 */ { "LETTRE ARABE KEHA' POINT EN CHEF","	* vieux malais, préférée à 06AC\n"
	"	x (lettre arabe kaf point en chef - 06AC)"},
/* 0763 */ { "LETTRE ARABE KEHA' TROIS POINTS EN CHEF","	* arabe marocain, berbère, bourouchaski\n"
	"	x (lettre arabe ng - 06AD)"},
/* 0764 */ { "LETTRE ARABE KEHA' TROIS POINTS SOUSCRITS POINTANT VERS LE HAUT",NULL},
/* 0765 */ { "LETTRE ARABE MÎM POINT EN CHEF",NULL},
/* 0766 */ { "LETTRE ARABE MÎM POINT SOUSCRIT","	* maba"},
/* 0767 */ { "LETTRE ARABE NOÛN DEUX POINTS SOUSCRITS",NULL},
/* 0768 */ { "LETTRE ARABE NOÛN PETIT TA'","	* saraïki, pathwari"},
/* 0769 */ { "LETTRE ARABE NOÛN PETIT V EN CHEF","	* goudjeri (gojri)"},
/* 076A */ { "LETTRE ARABE LAM BARRÉ",NULL},
/* 076B */ { "LETTRE ARABE RA' DEUX POINTS VERTICAUX EN CHEF","	* torwali, ormouri"},
/* 076C */ { "LETTRE ARABE RA' HAMZA EN CHEF","	* ormouri\n"
	"	* représente une fricative laminale alvéolopalatale sonore\n"
	"	x (lettre minuscule latine z bouclé - 0291)"},
/* 076D */ { "LETTRE ARABE SÎN DEUX POINTS VERTICAUX EN CHEF","	* kohistani de Kalam, ormouri"},
/* 076E */ { "LETTRE ARABE HA' PETIT TA' SOUSCRIT",NULL},
/* 076F */ { "LETTRE ARABE HA' PETIT TA' ET DEUX POINTS",NULL},
/* 0770 */ { "LETTRE ARABE SÎN PETIT TA' ET DEUX POINTS",NULL},
/* 0771 */ { "LETTRE ARABE RA' PETIT TA' ET DEUX POINTS",NULL},
/* 0772 */ { "LETTRE ARABE HA' PETIT TA' EN CHEF",NULL},
/* 0773 */ { "LETTRE ARABE ALIF AVEC CHIFFRE ARABO-INDIEN ÉTENDU DEUX SUSCRIT",NULL},
/* 0774 */ { "LETTRE ARABE ALIF AVEC CHIFFRE ARABO-INDIEN ÉTENDU TROIS SUSCRIT",NULL},
/* 0775 */ { "LETTRE ARABE FARSI YA' AVEC CHIFFRE ARABO-INDIEN ÉTENDU DEUX SUSCRIT",NULL},
/* 0776 */ { "LETTRE ARABE FARSI YA' AVEC CHIFFRE ARABO-INDIEN ÉTENDU TROIS SUSCRIT",NULL},
/* 0777 */ { "LETTRE ARABE FARSI YA' AVEC CHIFFRE ARABO-INDIEN ÉTENDU QUATRE SOUSCRIT",NULL},
/* 0778 */ { "LETTRE ARABE WAW AVEC CHIFFRE ARABO-INDIEN ÉTENDU DEUX SUSCRIT",NULL},
/* 0779 */ { "LETTRE ARABE WAW AVEC CHIFFRE ARABO-INDIEN ÉTENDU TROIS SUSCRIT",NULL},
/* 077A */ { "LETTRE ARABE YA' BARRÉ AVEC CHIFFRE ARABO-INDIEN ÉTENDU DEUX SUSCRIT",NULL},
/* 077B */ { "LETTRE ARABE YA' BARRÉ AVEC CHIFFRE ARABO-INDIEN ÉTENDU TROIS SUSCRIT",NULL},
/* 077C */ { "LETTRE ARABE HA' AVEC CHIFFRE ARABO-INDIEN ÉTENDU QUATRE SOUSCRIT",NULL},
/* 077D */ { "LETTRE ARABE SÎN AVEC CHIFFRE ARABO-INDIEN ÉTENDU QUATRE SUSCRIT",NULL},
/* 077E */ { "LETTRE ARABE SÎN PIGNON",NULL},
/* 077F */ { "LETTRE ARABE KAF DEUX POINTS EN CHEF",NULL},
/* 0780 */ { "LETTRE THÂNA HÂ","	= lettre thâna h"},
/* 0781 */ { "LETTRE THÂNA CHAVIYANI","	= lettre thâna ch"},
/* 0782 */ { "LETTRE THÂNA NOÛNOU","	= lettre thâna n"},
/* 0783 */ { "LETTRE THÂNA RÂ","	= lettre thâna r"},
/* 0784 */ { "LETTRE THÂNA BÂ","	= lettre thâna b"},
/* 0785 */ { "LETTRE THÂNA LHAVIYANI","	= lettre thâna lh"},
/* 0786 */ { "LETTRE THÂNA KÂFOU","	= lettre thâna k"},
/* 0787 */ { "LETTRE THÂNA ALIFOU",NULL},
/* 0788 */ { "LETTRE THÂNA VÂVOU","	= lettre thâna v"},
/* 0789 */ { "LETTRE THÂNA MÎMOU","	= lettre thâna m"},
/* 078A */ { "LETTRE THÂNA FÂFOU","	= lettre thâna f"},
/* 078B */ { "LETTRE THÂNA DHÂLOU","	= lettre thâna dh"},
/* 078C */ { "LETTRE THÂNA THÂ","	= lettre thâna th"},
/* 078D */ { "LETTRE THÂNA LÂMOU","	= lettre thâna l"},
/* 078E */ { "LETTRE THÂNA GÂFOU","	= lettre thâna g"},
/* 078F */ { "LETTRE THÂNA GNAVIYANI","	= lettre thâna gn"},
/* 0790 */ { "LETTRE THÂNA SÎNOU","	= lettre thâna s"},
/* 0791 */ { "LETTRE THÂNA DAVIYANI","	= lettre thâna d"},
/* 0792 */ { "LETTRE THÂNA ZAVIYANI","	= lettre thâna z"},
/* 0793 */ { "LETTRE THÂNA TAVIYANI","	= lettre thâna t"},
/* 0794 */ { "LETTRE THÂNA YÂ","	= lettre thâna y"},
/* 0795 */ { "LETTRE THÂNA PAVIYANI","	= lettre thâna p"},
/* 0796 */ { "LETTRE THÂNA DJAVIYANI","	= lettre thâna dj"},
/* 0797 */ { "LETTRE THÂNA TCHAVIYANI","	= lettre thâna tch"},
/* 0798 */ { "LETTRE THÂNA TTÂ",NULL},
/* 0799 */ { "LETTRE THÂNA HHÂ",NULL},
/* 079A */ { "LETTRE THÂNA KHÂ",NULL},
/* 079B */ { "LETTRE THÂNA THÂLOU",NULL},
/* 079C */ { "LETTRE THÂNA ZÂ",NULL},
/* 079D */ { "LETTRE THÂNA CHÎNOU",NULL},
/* 079E */ { "LETTRE THÂNA SÂDHOU",NULL},
/* 079F */ { "LETTRE THÂNA DÂDHOU",NULL},
/* 07A0 */ { "LETTRE THÂNA TO",NULL},
/* 07A1 */ { "LETTRE THÂNA ZO",NULL},
/* 07A2 */ { "LETTRE THÂNA AÏNOU",NULL},
/* 07A3 */ { "LETTRE THÂNA GHAÏNOU",NULL},
/* 07A4 */ { "LETTRE THÂNA QÂFOU",NULL},
/* 07A5 */ { "LETTRE THÂNA WÂVOU",NULL},
/* 07A6 */ { "ABAFILI THÂNA","	= lettre thâna a"},
/* 07A7 */ { "ÂBÂFILI THÂNA","	= lettre thâna â"},
/* 07A8 */ { "IBIFILI THÂNA","	= lettre thâna i"},
/* 07A9 */ { "ÎBÎFILI THÂNA","	= lettre thâna î"},
/* 07AA */ { "OUBOUFILI THÂNA","	= lettre thâna ou"},
/* 07AB */ { "OÛBOÛFILI THÂNA","	= lettre thâna oû"},
/* 07AC */ { "ÉBÉFILI THÂNA","	= lettre thâna é"},
/* 07AD */ { "ÊBÊFILI THÂNA","	= lettre thâna ê"},
/* 07AE */ { "OBOFILI THÂNA","	= lettre thâna o"},
/* 07AF */ { "ÔBÔFILI THÂNA","	= lettre thâna ô"},
/* 07B0 */ { "SOUKOUN THÂNA","	* absence de voyelle sur une consonne"},
/* 07B1 */ { "LETTRE THÂNA NÂ",NULL},
/* 07B2 */ { NULL,NULL},
/* 07B3 */ { NULL,NULL},
/* 07B4 */ { NULL,NULL},
/* 07B5 */ { NULL,NULL},
/* 07B6 */ { NULL,NULL},
/* 07B7 */ { NULL,NULL},
/* 07B8 */ { NULL,NULL},
/* 07B9 */ { NULL,NULL},
/* 07BA */ { NULL,NULL},
/* 07BB */ { NULL,NULL},
/* 07BC */ { NULL,NULL},
/* 07BD */ { NULL,NULL},
/* 07BE */ { NULL,NULL},
/* 07BF */ { NULL,NULL},
/* 07C0 */ { "CHIFFRE N'KO ZÉRO",NULL},
/* 07C1 */ { "CHIFFRE N'KO UN",NULL},
/* 07C2 */ { "CHIFFRE N'KO DEUX",NULL},
/* 07C3 */ { "CHIFFRE N'KO TROIS",NULL},
/* 07C4 */ { "CHIFFRE N'KO QUATRE",NULL},
/* 07C5 */ { "CHIFFRE N'KO CINQ",NULL},
/* 07C6 */ { "CHIFFRE N'KO SIX",NULL},
/* 07C7 */ { "CHIFFRE N'KO SEPT",NULL},
/* 07C8 */ { "CHIFFRE N'KO HUIT",NULL},
/* 07C9 */ { "CHIFFRE N'KO NEUF",NULL},
/* 07CA */ { "LETTRE N'KO A",NULL},
/* 07CB */ { "LETTRE N'KO É",NULL},
/* 07CC */ { "LETTRE N'KO I",NULL},
/* 07CD */ { "LETTRE N'KO È",NULL},
/* 07CE */ { "LETTRE N'KO OU",NULL},
/* 07CF */ { "LETTRE N'KO Ô",NULL},
/* 07D0 */ { "LETTRE N'KO O",NULL},
/* 07D1 */ { "LETTRE N'KO DAGBASIN'NA",NULL},
/* 07D2 */ { "LETTRE N'KO N'","	= n syllabique"},
/* 07D3 */ { "LETTRE N'KO BA",NULL},
/* 07D4 */ { "LETTRE N'KO PA",NULL},
/* 07D5 */ { "LETTRE N'KO TA",NULL},
/* 07D6 */ { "LETTRE N'KO DJA",NULL},
/* 07D7 */ { "LETTRE N'KO TCHA",NULL},
/* 07D8 */ { "LETTRE N'KO DA",NULL},
/* 07D9 */ { "LETTRE N'KO RA",NULL},
/* 07DA */ { "LETTRE N'KO RRA",NULL},
/* 07DB */ { "LETTRE N'KO SA",NULL},
/* 07DC */ { "LETTRE N'KO GBA",NULL},
/* 07DD */ { "LETTRE N'KO FA",NULL},
/* 07DE */ { "LETTRE N'KO KA",NULL},
/* 07DF */ { "LETTRE N'KO LA",NULL},
/* 07E0 */ { "LETTRE N'KO NA WOLOSO",NULL},
/* 07E1 */ { "LETTRE N'KO MA",NULL},
/* 07E2 */ { "LETTRE N'KO GNA","	= lettre n'ko nya"},
/* 07E3 */ { "LETTRE N'KO NA",NULL},
/* 07E4 */ { "LETTRE N'KO HA",NULL},
/* 07E5 */ { "LETTRE N'KO WA",NULL},
/* 07E6 */ { "LETTRE N'KO YA",NULL},
/* 07E7 */ { "LETTRE N'KO GNA WOLOSO","	= lettre n'ko nya woloso"},
/* 07E8 */ { "LETTRE N'KO DJONA DJA","	= lettre archaïque dja"},
/* 07E9 */ { "LETTRE N'KO DJONA TCHA","	= lettre archaïque tcha"},
/* 07EA */ { "LETTRE N'KO DJONA RA","	= lettre archaïque ra\n"
	"	x (lettre n'ko ra - 07D9)"},
/* 07EB */ { "DIACRITIQUE N'KO TON BREF HAUT","	x (diacritique macron - 0304)"},
/* 07EC */ { "DIACRITIQUE N'KO TON BREF BAS","	x (diacritique tilde - 0303)"},
/* 07ED */ { "DIACRITIQUE N'KO TON BREF MONTANT","	x (diacritique point en chef - 0307)"},
/* 07EE */ { "DIACRITIQUE N'KO TON LONG DESCENDANT","	x (diacritique accent circonflexe - 0302)"},
/* 07EF */ { "DIACRITIQUE N'KO TON LONG HAUT",NULL},
/* 07F0 */ { "DIACRITIQUE N'KO TON LONG BAS",NULL},
/* 07F1 */ { "DIACRITIQUE N'KO TON LONG MONTANT",NULL},
/* 07F2 */ { "DIACRITIQUE N'KO DE NASALISATION","	x (diacritique point souscrit - 0323)"},
/* 07F3 */ { "DIACRITIQUE N'KO TRÉMA EXTENSEUR","	x (diacritique tréma - 0308)"},
/* 07F4 */ { "APOSTROPHE N'KO DE TON HAUT","	x (lettre modificative apostrophe - 02BC)"},
/* 07F5 */ { "APOSTROPHE N'KO DE TON BAS","	x (lettre modificative virgule culbutée - 02BB)"},
/* 07F6 */ { "SYMBOLE N'KO Ô DÉNÈN",NULL},
/* 07F7 */ { "SYMBOLE N'KO GBAKOUROUNÈN",NULL},
/* 07F8 */ { "VIRGULE N'KO",NULL},
/* 07F9 */ { "POINT D'EXCLAMATION N'KO",NULL},
/* 07FA */ { "LADJAGNALAN N'KO","	x (tiret bas - 005F)\n"
	"	x (tatouïl arabe - 0640)"},
/* 07FB */ { NULL,NULL},
/* 07FC */ { NULL,NULL},
/* 07FD */ { NULL,NULL},
/* 07FE */ { NULL,NULL},
/* 07FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_08[] = {
/* 0800 */ { "LETTRE SAMARITAINE ALAF",NULL},
/* 0801 */ { "LETTRE SAMARITAINE BIT",NULL},
/* 0802 */ { "LETTRE SAMARITAINE GAMAN",NULL},
/* 0803 */ { "LETTRE SAMARITAINE DALAT",NULL},
/* 0804 */ { "LETTRE SAMARITAINE IY",NULL},
/* 0805 */ { "LETTRE SAMARITAINE BÂ",NULL},
/* 0806 */ { "LETTRE SAMARITAINE ZEN",NULL},
/* 0807 */ { "LETTRE SAMARITAINE IT",NULL},
/* 0808 */ { "LETTRE SAMARITAINE TIT",NULL},
/* 0809 */ { "LETTRE SAMARITAINE YOUT",NULL},
/* 080A */ { "LETTRE SAMARITAINE KÂF",NULL},
/* 080B */ { "LETTRE SAMARITAINE LABAT",NULL},
/* 080C */ { "LETTRE SAMARITAINE MIM",NULL},
/* 080D */ { "LETTRE SAMARITAINE NOUN",NULL},
/* 080E */ { "LETTRE SAMARITAINE SINGÂT",NULL},
/* 080F */ { "LETTRE SAMARITAINE IN",NULL},
/* 0810 */ { "LETTRE SAMARITAINE FI",NULL},
/* 0811 */ { "LETTRE SAMARITAINE TSÂDIY",NULL},
/* 0812 */ { "LETTRE SAMARITAINE QOUF",NULL},
/* 0813 */ { "LETTRE SAMARITAINE RICH",NULL},
/* 0814 */ { "LETTRE SAMARITAINE CHAN",NULL},
/* 0815 */ { "LETTRE SAMARITAINE TÂF",NULL},
/* 0816 */ { "DIACRITIQUE SAMARITAIN IN",NULL},
/* 0817 */ { "DIACRITIQUE SAMARITAIN IN-ALAF",NULL},
/* 0818 */ { "DIACRITIQUE SAMARITAIN OCCLUSION",NULL},
/* 0819 */ { "DIACRITIQUE SAMARITAIN DAGUÈCH",NULL},
/* 081A */ { "LETTRE MODIFICATIVE SAMARITAINE ÉPENTHÉTIQUE YOUT",NULL},
/* 081B */ { "DIACRITIQUE SAMARITAIN ÉPENTHÉTIQUE YOUT",NULL},
/* 081C */ { "DIACRITIQUE VOYELLE SAMARITAINE É LONG","	= fatha al-nida"},
/* 081D */ { "DIACRITIQUE VOYELLE SAMARITAINE É",NULL},
/* 081E */ { "DIACRITIQUE VOYELLE SAMARITAINE Â TRÈS LONG","	= fatha al-ima"},
/* 081F */ { "DIACRITIQUE VOYELLE SAMARITAINE Â LONG",NULL},
/* 0820 */ { "DIACRITIQUE VOYELLE SAMARITAINE Â",NULL},
/* 0821 */ { "DIACRITIQUE VOYELLE SAMARITAINE A TRÈS LONG","	= fatha al-iha"},
/* 0822 */ { "DIACRITIQUE VOYELLE SAMARITAINE A LONG",NULL},
/* 0823 */ { "DIACRITIQUE VOYELLE SAMARITAINE A",NULL},
/* 0824 */ { "LETTRE MODIFICATIVE SAMARITAINE A BREF",NULL},
/* 0825 */ { "DIACRITIQUE VOYELLE SAMARITAINE A BREF","	= fatha"},
/* 0826 */ { "DIACRITIQUE VOYELLE SAMARITAINE OU LONG","	= damma"},
/* 0827 */ { "DIACRITIQUE VOYELLE SAMARITAINE OU",NULL},
/* 0828 */ { "LETTRE MODIFICATIVE SAMARITAINE I",NULL},
/* 0829 */ { "DIACRITIQUE VOYELLE SAMARITAINE I LONG","	= kasra"},
/* 082A */ { "DIACRITIQUE VOYELLE SAMARITAINE I",NULL},
/* 082B */ { "DIACRITIQUE VOYELLE SAMARITAINE O",NULL},
/* 082C */ { "DIACRITIQUE VOYELLE SAMARITAINE SOUKOUN",NULL},
/* 082D */ { "DIACRITIQUE SAMARITAIN NEQOUDÂ",NULL},
/* 082E */ { NULL,NULL},
/* 082F */ { NULL,NULL},
/* 0830 */ { "PONCTUATION SAMARITAINE NEQOUDÂ","	= séparateur de mots"},
/* 0831 */ { "PONCTUATION SAMARITAINE AFSÂQ","	= interruption"},
/* 0832 */ { "PONCTUATION SAMARITAINE ANGED","	= retenue"},
/* 0833 */ { "PONCTUATION SAMARITAINE BAOU","	= prière"},
/* 0834 */ { "PONCTUATION SAMARITAINE ATMÂOU","	= surprise"},
/* 0835 */ { "PONCTUATION SAMARITAINE SHIYYÂLÂ","	= question"},
/* 0836 */ { "SIGNE D'ABRÉVIATION SAMARITAIN",NULL},
/* 0837 */ { "PONCTUATION SAMARITAINE QITSA MÉLODIQUE",NULL},
/* 0838 */ { "PONCTUATION SAMARITAINE ZIQÂ","	= cris"},
/* 0839 */ { "PONCTUATION SAMARITAINE QITSA","	= fin de paragraphe"},
/* 083A */ { "PONCTUATION SAMARITAINE ZAEF","	= éclat"},
/* 083B */ { "PONCTUATION SAMARITAINE TOUROU","	= enseignement"},
/* 083C */ { "PONCTUATION SAMARITAINE ARKÂNOU","	= soumission"},
/* 083D */ { "PONCTUATION SAMARITAINE SOF MACHFÂT","	= point final"},
/* 083E */ { "PONCTUATION SAMARITAINE ANNÂOU","	= repos"},
/* 083F */ { NULL,NULL},
/* 0840 */ { "LETTRE MANDÉENNE HALQA",NULL},
/* 0841 */ { "LETTRE MANDÉENNE AB",NULL},
/* 0842 */ { "LETTRE MANDÉENNE AG",NULL},
/* 0843 */ { "LETTRE MANDÉENNE AD",NULL},
/* 0844 */ { "LETTRE MANDÉENNE AH",NULL},
/* 0845 */ { "LETTRE MANDÉENNE OUCHENNA",NULL},
/* 0846 */ { "LETTRE MANDÉENNE AZ",NULL},
/* 0847 */ { "LETTRE MANDÉENNE IT",NULL},
/* 0848 */ { "LETTRE MANDÉENNE ATT",NULL},
/* 0849 */ { "LETTRE MANDÉENNE AKSA",NULL},
/* 084A */ { "LETTRE MANDÉENNE AK",NULL},
/* 084B */ { "LETTRE MANDÉENNE AL",NULL},
/* 084C */ { "LETTRE MANDÉENNE AM",NULL},
/* 084D */ { "LETTRE MANDÉENNE AN",NULL},
/* 084E */ { "LETTRE MANDÉENNE AS",NULL},
/* 084F */ { "LETTRE MANDÉENNE IN",NULL},
/* 0850 */ { "LETTRE MANDÉENNE AP",NULL},
/* 0851 */ { "LETTRE MANDÉENNE ASZ",NULL},
/* 0852 */ { "LETTRE MANDÉENNE AQ",NULL},
/* 0853 */ { "LETTRE MANDÉENNE AR",NULL},
/* 0854 */ { "LETTRE MANDÉENNE ASH",NULL},
/* 0855 */ { "LETTRE MANDÉENNE AT",NULL},
/* 0856 */ { "LETTRE MANDÉENNE DOUCHENNA",NULL},
/* 0857 */ { "LETTRE MANDÉENNE KAD",NULL},
/* 0858 */ { "LETTRE MANDÉENNE 'AÏN",NULL},
/* 0859 */ { "DIACRITIQUE MANDÉEN D'AFFRICATION",NULL},
/* 085A */ { "DIACRITIQUE MANDÉEN DE VOCALISATION",NULL},
/* 085B */ { "DIACRITIQUE MANDÉEN DE GÉMINATION",NULL},
/* 085C */ { NULL,NULL},
/* 085D */ { NULL,NULL},
/* 085E */ { "PONCTUATION MANDÉENNE",NULL},
/* 085F */ { NULL,NULL},
/* 0860 */ { "LETTRE SYRIAQUE MALAYALAM NGA","	x (lettre malayalam nga - 0D19)"},
/* 0861 */ { "LETTRE SYRIAQUE MALAYALAM DJA","	x (lettre malayalam dja - 0D1C)"},
/* 0862 */ { "LETTRE SYRIAQUE MALAYALAM ÑA","	x (lettre malayalam ña - 0D1E)"},
/* 0863 */ { "LETTRE SYRIAQUE MALAYALAM TTA","	x (lettre malayalam tta - 0D1F)"},
/* 0864 */ { "LETTRE SYRIAQUE MALAYALAM NNA","	x (lettre malayalam nna - 0D23)"},
/* 0865 */ { "LETTRE SYRIAQUE MALAYALAM NNNA","	x (lettre malayalam nnna - 0D29)"},
/* 0866 */ { "LETTRE SYRIAQUE MALAYALAM BHA","	x (lettre malayalam bha - 0D2D)"},
/* 0867 */ { "LETTRE SYRIAQUE MALAYALAM RA","	x (lettre malayalam ra - 0D30)"},
/* 0868 */ { "LETTRE SYRIAQUE MALAYALAM LLA","	x (lettre malayalam lla - 0D33)"},
/* 0869 */ { "LETTRE SYRIAQUE MALAYALAM LLLA","	x (lettre malayalam llla - 0D34)"},
/* 086A */ { "LETTRE SYRIAQUE MALAYALAM CHA","	x (lettre malayalam cha - 0D37)"},
/* 086B */ { NULL,NULL},
/* 086C */ { NULL,NULL},
/* 086D */ { NULL,NULL},
/* 086E */ { NULL,NULL},
/* 086F */ { NULL,NULL},
/* 0870 */ { NULL,NULL},
/* 0871 */ { NULL,NULL},
/* 0872 */ { NULL,NULL},
/* 0873 */ { NULL,NULL},
/* 0874 */ { NULL,NULL},
/* 0875 */ { NULL,NULL},
/* 0876 */ { NULL,NULL},
/* 0877 */ { NULL,NULL},
/* 0878 */ { NULL,NULL},
/* 0879 */ { NULL,NULL},
/* 087A */ { NULL,NULL},
/* 087B */ { NULL,NULL},
/* 087C */ { NULL,NULL},
/* 087D */ { NULL,NULL},
/* 087E */ { NULL,NULL},
/* 087F */ { NULL,NULL},
/* 0880 */ { NULL,NULL},
/* 0881 */ { NULL,NULL},
/* 0882 */ { NULL,NULL},
/* 0883 */ { NULL,NULL},
/* 0884 */ { NULL,NULL},
/* 0885 */ { NULL,NULL},
/* 0886 */ { NULL,NULL},
/* 0887 */ { NULL,NULL},
/* 0888 */ { NULL,NULL},
/* 0889 */ { NULL,NULL},
/* 088A */ { NULL,NULL},
/* 088B */ { NULL,NULL},
/* 088C */ { NULL,NULL},
/* 088D */ { NULL,NULL},
/* 088E */ { NULL,NULL},
/* 088F */ { NULL,NULL},
/* 0890 */ { NULL,NULL},
/* 0891 */ { NULL,NULL},
/* 0892 */ { NULL,NULL},
/* 0893 */ { NULL,NULL},
/* 0894 */ { NULL,NULL},
/* 0895 */ { NULL,NULL},
/* 0896 */ { NULL,NULL},
/* 0897 */ { NULL,NULL},
/* 0898 */ { NULL,NULL},
/* 0899 */ { NULL,NULL},
/* 089A */ { NULL,NULL},
/* 089B */ { NULL,NULL},
/* 089C */ { NULL,NULL},
/* 089D */ { NULL,NULL},
/* 089E */ { NULL,NULL},
/* 089F */ { NULL,NULL},
/* 08A0 */ { "LETTRE ARABE BA' LETTRE ARABE PETIT V SOUSCRIT",NULL},
/* 08A1 */ { "LETTRE ARABE BA' HAMZA EN CHEF","	* foulfouldé d'Adamaoua (Cameroun)\n"
	"	* utilisée pour l'occlusive bilabiale implosive\n"
	"	x (lettre minuscule latine b crosse - 0253)"},
/* 08A2 */ { "LETTRE ARABE DJÎM DEUX POINTS EN CHEF",NULL},
/* 08A3 */ { "LETTRE ARABE TA' DEUX POINTS EN CHEF",NULL},
/* 08A4 */ { "LETTRE ARABE FA' POINT SOUSCRIT ET POINT EN CHEF",NULL},
/* 08A5 */ { "LETTRE ARABE QAF POINT SOUSCRIT",NULL},
/* 08A6 */ { "LETTRE ARABE LAM DOUBLE BARRE",NULL},
/* 08A7 */ { "LETTRE ARABE MÎM TROIS POINTS EN CHEF",NULL},
/* 08A8 */ { "LETTRE ARABE YA' DEUX POINTS SOUSCRITS ET HAMZA EN CHEF","	* foulfouldé d'Adamaoua\n"
	"	x (lettre minuscule latine y crosse - 01B4)"},
/* 08A9 */ { "LETTRE ARABE YA' DEUX POINTS SOUSCRITS ET POINT EN CHEF","	* foulfouldé d'Adamaoua\n"
	"	x (lettre minuscule latine n hameçon à gauche - 0272)"},
/* 08AA */ { "LETTRE ARABE RA' BOUCLE",NULL},
/* 08AB */ { "LETTRE ARABE WAW POINT INSCRIT",NULL},
/* 08AC */ { "LETTRE ARABE ROHINGYA YA'",NULL},
/* 08AD */ { "LETTRE ARABE ALIF BAS","	* bachkir, tatar"},
/* 08AE */ { "LETTRE ARABE DAL TROIS POINTS SOUSCRITS","	* biélorusse"},
/* 08AF */ { "LETTRE ARABE ÇAD TROIS POINTS SOUSCRITS","	* biélorusse"},
/* 08B0 */ { "LETTRE ARABE GAF TRAIT RENVERSÉ","	* tatar de Crimée, tchétchène, lak"},
/* 08B1 */ { "LETTRE ARABE WAW DROIT","	* tatar"},
/* 08B2 */ { "LETTRE ARABE ZAÏN V RENVERSÉ SUSCRIT",NULL},
/* 08B3 */ { "LETTRE ARABE 'AÏN TROIS POINTS SOUSCRITS",NULL},
/* 08B4 */ { "LETTRE ARABE KAF POINT SOUSCRIT",NULL},
/* 08B5 */ { NULL,NULL},
/* 08B6 */ { "LETTRE ARABE BA' PETIT MÎM EN CHEF",NULL},
/* 08B7 */ { "LETTRE ARABE PA' PETIT MÎM EN CHEF",NULL},
/* 08B8 */ { "LETTRE ARABE TÉ' PETIT TÉ' EN CHEF",NULL},
/* 08B9 */ { "LETTRE ARABE RA' PETIT NOÛN EN CHEF",NULL},
/* 08BA */ { "LETTRE ARABE YA' DEUX POINTS SOUSCRITS ET PETIT NOÛN EN CHEF",NULL},
/* 08BB */ { "LETTRE ARABE AFRICAINE FA'","	* les formes initiale et médiale ont un point souscrit\n"
	"	x (lettre arabe fa' sans point - 06A1)\n"
	"	x (lettre arabe fa' point descendu - 06A2)"},
/* 08BC */ { "LETTRE ARABE AFRICAINE QAF","	* les formes initiale et médiale ont un point suscrit\n"
	"	x (lettre arabe qaf sans point - 066F)\n"
	"	x (lettre arabe qaf point en chef - 06A7)"},
/* 08BD */ { "LETTRE ARABE AFRICAINE NOÛN","	* les formes initiale et médiale ont un point suscrit\n"
	"	x (lettre arabe noûn ghounna - 06BA)\n"
	"	x (lettre arabe noûn - 0646)"},
/* 08BE */ { NULL,NULL},
/* 08BF */ { NULL,NULL},
/* 08C0 */ { NULL,NULL},
/* 08C1 */ { NULL,NULL},
/* 08C2 */ { NULL,NULL},
/* 08C3 */ { NULL,NULL},
/* 08C4 */ { NULL,NULL},
/* 08C5 */ { NULL,NULL},
/* 08C6 */ { NULL,NULL},
/* 08C7 */ { NULL,NULL},
/* 08C8 */ { NULL,NULL},
/* 08C9 */ { NULL,NULL},
/* 08CA */ { NULL,NULL},
/* 08CB */ { NULL,NULL},
/* 08CC */ { NULL,NULL},
/* 08CD */ { NULL,NULL},
/* 08CE */ { NULL,NULL},
/* 08CF */ { NULL,NULL},
/* 08D0 */ { NULL,NULL},
/* 08D1 */ { NULL,NULL},
/* 08D2 */ { NULL,NULL},
/* 08D3 */ { NULL,NULL},
/* 08D4 */ { "PETIT MOT ARABE EN CHEF AR-ROUB",NULL},
/* 08D5 */ { "PETIT ÇAD ARABE EN CHEF",NULL},
/* 08D6 */ { "PETIT 'AÏN ARABE EN CHEF",NULL},
/* 08D7 */ { "PETIT QAF ARABE EN CHEF",NULL},
/* 08D8 */ { "PETIT NOÛN ARABE EN CHEF AVEC KASRA",NULL},
/* 08D9 */ { "PETIT NOÛN ARABE SOUSCRIT AVEC KASRA",NULL},
/* 08DA */ { "PETIT MOT ARABE EN CHEF ATH-THALATHA",NULL},
/* 08DB */ { "PETIT MOT ARABE EN CHEF AS-SADJDA",NULL},
/* 08DC */ { "PETIT MOT ARABE EN CHEF AN-NISF",NULL},
/* 08DD */ { "PETIT MOT ARABE EN CHEF SAKTA",NULL},
/* 08DE */ { "PETIT MOT ARABE EN CHEF QIF",NULL},
/* 08DF */ { "PETIT MOT ARABE EN CHEF WAQFA",NULL},
/* 08E0 */ { "PETIT APPEL DE NOTE ARABE EN CHEF",NULL},
/* 08E1 */ { "PETIT SIGNE ARABE EN CHEF SAPHA",NULL},
/* 08E2 */ { "FIN CONTESTÉE D'AYA ARABE",NULL},
/* 08E3 */ { "DAMMA ARABE CULBUTÉ SOUSCRIT",NULL},
/* 08E4 */ { "FATHA ARABE RECOURBÉ",NULL},
/* 08E5 */ { "DAMMA ARABE RECOURBÉ",NULL},
/* 08E6 */ { "KASRA ARABE RECOURBÉ",NULL},
/* 08E7 */ { "FATHATAN ARABE RECOURBÉ",NULL},
/* 08E8 */ { "DAMMATAN ARABE RECOURBÉ",NULL},
/* 08E9 */ { "KASRATAN ARABE RECOURBÉ",NULL},
/* 08EA */ { "TON ARABE POINT EN CHEF",NULL},
/* 08EB */ { "TON ARABE DEUX POINTS EN CHEF",NULL},
/* 08EC */ { "TON ARABE BOUCLE EN CHEF",NULL},
/* 08ED */ { "TON ARABE POINT SOUSCRIT",NULL},
/* 08EE */ { "TON ARABE DEUX POINTS SOUSCRITS",NULL},
/* 08EF */ { "TON ARABE BOUCLE SOUSCRITE",NULL},
/* 08F0 */ { "FATHATAN ARABE OUVERT",NULL},
/* 08F1 */ { "DAMMATAN ARABE OUVERT",NULL},
/* 08F2 */ { "KASRATAN ARABE OUVERT",NULL},
/* 08F3 */ { "PETIT WAW ARABE EN CHEF",NULL},
/* 08F4 */ { "FATHA ARABE AVEC ROND",NULL},
/* 08F5 */ { "FATHA ARABE POINT EN CHEF",NULL},
/* 08F6 */ { "KASRA ARABE POINT SOUSCRIT","	* utilisé aussi dans les langues philippines"},
/* 08F7 */ { "POINTE DE FLÈCHE ARABE EN CHEF VERS LA GAUCHE",NULL},
/* 08F8 */ { "POINTE DE FLÈCHE ARABE EN CHEF VERS LA DROITE",NULL},
/* 08F9 */ { "POINTE DE FLÈCHE ARABE SOUSCRITE VERS LA GAUCHE",NULL},
/* 08FA */ { "POINTE DE FLÈCHE ARABE SOUSCRITE VERS LA DROITE",NULL},
/* 08FB */ { "DOUBLE POINTE DE FLÈCHE ARABE EN CHEF VERS LA DROITE",NULL},
/* 08FC */ { "DOUBLE POINTE DE FLÈCHE ARABE EN CHEF VERS LA DROITE AVEC POINT",NULL},
/* 08FD */ { "POINTE DE FLÈCHE ARABE EN CHEF VERS LA DROITE AVEC POINT",NULL},
/* 08FE */ { "DAMMA ARABE AVEC POINT","	* langues philippines"},
/* 08FF */ { "DIACRITIQUE ARABE NOÛN GHOUNNA COUCHÉ",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_09[] = {
/* 0900 */ { "DIACRITIQUE DÉVANÂGARÎ TCHANDRABINDOU RENVERSÉ","	= vaïdika adhomoukha tchandrabindou"},
/* 0901 */ { "DIACRITIQUE DÉVANÂGARÎ TCHANDRABINDOU","	= anounassika\n"
	"	x (diacritique tchandrabindou - 0310)"},
/* 0902 */ { "DIACRITIQUE DÉVANÂGARÎ ANOUSVÂRA","	= bindou"},
/* 0903 */ { "DIACRITIQUE DÉVANÂGARÎ VISARGA",NULL},
/* 0904 */ { "LETTRE DÉVANÂGARÎ A BREF",NULL},
/* 0905 */ { "LETTRE DÉVANÂGARÎ A",NULL},
/* 0906 */ { "LETTRE DÉVANÂGARÎ Â",NULL},
/* 0907 */ { "LETTRE DÉVANÂGARÎ I",NULL},
/* 0908 */ { "LETTRE DÉVANÂGARÎ Î",NULL},
/* 0909 */ { "LETTRE DÉVANÂGARÎ OU",NULL},
/* 090A */ { "LETTRE DÉVANÂGARÎ OÛ",NULL},
/* 090B */ { "LETTRE DÉVANÂGARÎ R VOCALIQUE",NULL},
/* 090C */ { "LETTRE DÉVANÂGARÎ L VOCALIQUE",NULL},
/* 090D */ { "LETTRE DÉVANÂGARÎ É TCHANDRA",NULL},
/* 090E */ { "LETTRE DÉVANÂGARÎ É BREF","	* cachemiri, bihari\n"
	"	* sert aussi pour transcrire le e bref dravidien"},
/* 090F */ { "LETTRE DÉVANÂGARÎ É",NULL},
/* 0910 */ { "LETTRE DÉVANÂGARÎ AÏ",NULL},
/* 0911 */ { "LETTRE DÉVANÂGARÎ O TCHANDRA",NULL},
/* 0912 */ { "LETTRE DÉVANÂGARÎ O BREF","	* cachemiri, bihari\n"
	"	* sert aussi pour transcrire le o bref dravidien"},
/* 0913 */ { "LETTRE DÉVANÂGARÎ Ô",NULL},
/* 0914 */ { "LETTRE DÉVANÂGARÎ AOU",NULL},
/* 0915 */ { "LETTRE DÉVANÂGARÎ KA",NULL},
/* 0916 */ { "LETTRE DÉVANÂGARÎ KHA",NULL},
/* 0917 */ { "LETTRE DÉVANÂGARÎ GA",NULL},
/* 0918 */ { "LETTRE DÉVANÂGARÎ GHA",NULL},
/* 0919 */ { "LETTRE DÉVANÂGARÎ NGA",NULL},
/* 091A */ { "LETTRE DÉVANÂGARÎ TCHA",NULL},
/* 091B */ { "LETTRE DÉVANÂGARÎ TCHHA",NULL},
/* 091C */ { "LETTRE DÉVANÂGARÎ DJA",NULL},
/* 091D */ { "LETTRE DÉVANÂGARÎ DJHA",NULL},
/* 091E */ { "LETTRE DÉVANÂGARÎ ÑA",NULL},
/* 091F */ { "LETTRE DÉVANÂGARÎ TTA",NULL},
/* 0920 */ { "LETTRE DÉVANÂGARÎ TTHA",NULL},
/* 0921 */ { "LETTRE DÉVANÂGARÎ DDA",NULL},
/* 0922 */ { "LETTRE DÉVANÂGARÎ DDHA",NULL},
/* 0923 */ { "LETTRE DÉVANÂGARÎ NNA",NULL},
/* 0924 */ { "LETTRE DÉVANÂGARÎ TA",NULL},
/* 0925 */ { "LETTRE DÉVANÂGARÎ THA",NULL},
/* 0926 */ { "LETTRE DÉVANÂGARÎ DA",NULL},
/* 0927 */ { "LETTRE DÉVANÂGARÎ DHA",NULL},
/* 0928 */ { "LETTRE DÉVANÂGARÎ NA",NULL},
/* 0929 */ { "LETTRE DÉVANÂGARÎ NNNA","	* pour transcrire le n alvéolaire dravidien\n"
	"	: 0928 093C"},
/* 092A */ { "LETTRE DÉVANÂGARÎ PA",NULL},
/* 092B */ { "LETTRE DÉVANÂGARÎ PHA",NULL},
/* 092C */ { "LETTRE DÉVANÂGARÎ BA",NULL},
/* 092D */ { "LETTRE DÉVANÂGARÎ BHA",NULL},
/* 092E */ { "LETTRE DÉVANÂGARÎ MA",NULL},
/* 092F */ { "LETTRE DÉVANÂGARÎ YA",NULL},
/* 0930 */ { "LETTRE DÉVANÂGARÎ RA",NULL},
/* 0931 */ { "LETTRE DÉVANÂGARÎ RRA","	* pour transcrire le r alvéolaire dravidien\n"
	"	* la demi-forme est représentée par un RA « cil »\n"
	"	: 0930 093C"},
/* 0932 */ { "LETTRE DÉVANÂGARÎ LA",NULL},
/* 0933 */ { "LETTRE DÉVANÂGARÎ LLA",NULL},
/* 0934 */ { "LETTRE DÉVANÂGARÎ LLLA","	* pour transcrire le l dravidien\n"
	"	: 0933 093C"},
/* 0935 */ { "LETTRE DÉVANÂGARÎ VA",NULL},
/* 0936 */ { "LETTRE DÉVANÂGARÎ ÇA",NULL},
/* 0937 */ { "LETTRE DÉVANÂGARÎ CHA",NULL},
/* 0938 */ { "LETTRE DÉVANÂGARÎ SA",NULL},
/* 0939 */ { "LETTRE DÉVANÂGARÎ HA",NULL},
/* 093A */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ OE",NULL},
/* 093B */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ ÔE",NULL},
/* 093C */ { "DIACRITIQUE DÉVANÂGARÎ NOUKTA","	* pour étendre l'alphabet et former de nouvelles lettres"},
/* 093D */ { "SIGNE DÉVANÂGARÎ AVAGRAHA",NULL},
/* 093E */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ Â",NULL},
/* 093F */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ I","	* à la gauche de la consonne"},
/* 0940 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ Î",NULL},
/* 0941 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ OU",NULL},
/* 0942 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ OÛ",NULL},
/* 0943 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ R VOCALIQUE",NULL},
/* 0944 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ RR VOCALIQUE",NULL},
/* 0945 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ É TCHANDRA",NULL},
/* 0946 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ É BREF","	* cachemiri, bihari\n"
	"	* sert aussi pour transcrire le e bref dravidien"},
/* 0947 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ É",NULL},
/* 0948 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ AÏ","	* souvent la monophtongue française « ê »"},
/* 0949 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ O TCHANDRA",NULL},
/* 094A */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ O BREF","	* cachemiri, bihari\n"
	"	* sert aussi pour transcrire le o bref dravidien"},
/* 094B */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ Ô",NULL},
/* 094C */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ AOU",NULL},
/* 094D */ { "DIACRITIQUE DÉVANÂGARÎ VIRÂMA","	= halant (le nom hindi recommandé)\n"
	"	* supprime la voyelle inhérente"},
/* 094E */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ PRISHTHAMATRA E","	* ce caractère a un usage historique uniquement"},
/* 094F */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ AW","	* cachemiri, bihari"},
/* 0950 */ { "OM DÉVANÂGARÎ","	x (symbole om - 1F549)"},
/* 0951 */ { "DIACRITIQUE D'ACCENTUATION DÉVANÂGARÎ OUDATTA","	= ton védique oudatta\n"
	"	* utilisé le plus souvent pour le svarita, emploi rare pour l'oudatta\n"
	"	* utilisé aussi dans les textes védiques rédigés avec d'autres écritures\n"
	"	x (diacritique ton védique double svarita - 1CDA)"},
/* 0952 */ { "DIACRITIQUE D'ACCENTUATION DÉVANÂGARÎ ANOUDATTA","	= ton védique anoudatta\n"
	"	* utilisé aussi dans les textes védiques rédigés avec d'autres écritures\n"
	"	x (diacritique ton védique kathaka anoudatta - 1CDC)"},
/* 0953 */ { "ACCENT GRAVE DÉVANÂGARÎ","	x (diacritique accent grave - 0300)"},
/* 0954 */ { "ACCENT AIGU DÉVANÂGARÎ","	x (diacritique accent aigu - 0301)"},
/* 0955 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ TCHANDRA LONG E","	* s'emploie pour la translittération de l'avestique"},
/* 0956 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ UE",NULL},
/* 0957 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ OÛE",NULL},
/* 0958 */ { "LETTRE DÉVANÂGARÎ QA","	: 0915 093C"},
/* 0959 */ { "LETTRE DÉVANÂGARÎ KHHA","	: 0916 093C"},
/* 095A */ { "LETTRE DÉVANÂGARÎ GHHA","	: 0917 093C"},
/* 095B */ { "LETTRE DÉVANÂGARÎ ZA","	: 091C 093C"},
/* 095C */ { "LETTRE DÉVANÂGARÎ DDDHA","	: 0921 093C"},
/* 095D */ { "LETTRE DÉVANÂGARÎ RHA","	: 0922 093C"},
/* 095E */ { "LETTRE DÉVANÂGARÎ FA","	: 092B 093C"},
/* 095F */ { "LETTRE DÉVANÂGARÎ YYA","	: 092F 093C"},
/* 0960 */ { "LETTRE DÉVANÂGARÎ RR VOCALIQUE",NULL},
/* 0961 */ { "LETTRE DÉVANÂGARÎ LL VOCALIQUE",NULL},
/* 0962 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ L VOCALIQUE",NULL},
/* 0963 */ { "DIACRITIQUE VOYELLE DÉVANÂGARÎ LL VOCALIQUE",NULL},
/* 0964 */ { "DANDA DÉVANÂGARÎ","	= pourna viram\n"
	"	* séparateur de propositions"},
/* 0965 */ { "DOUBLE DANDA DÉVANÂGARÎ","	= déérgh viram"},
/* 0966 */ { "CHIFFRE DÉVANÂGARÎ ZÉRO",NULL},
/* 0967 */ { "CHIFFRE DÉVANÂGARÎ UN",NULL},
/* 0968 */ { "CHIFFRE DÉVANÂGARÎ DEUX",NULL},
/* 0969 */ { "CHIFFRE DÉVANÂGARÎ TROIS",NULL},
/* 096A */ { "CHIFFRE DÉVANÂGARÎ QUATRE",NULL},
/* 096B */ { "CHIFFRE DÉVANÂGARÎ CINQ",NULL},
/* 096C */ { "CHIFFRE DÉVANÂGARÎ SIX",NULL},
/* 096D */ { "CHIFFRE DÉVANÂGARÎ SEPT",NULL},
/* 096E */ { "CHIFFRE DÉVANÂGARÎ HUIT",NULL},
/* 096F */ { "CHIFFRE DÉVANÂGARÎ NEUF",NULL},
/* 0970 */ { "SIGNE D'ABRÉVIATION DÉVANÂGARÎ",NULL},
/* 0971 */ { "POINT À CHASSE DÉVANÂGARÎ ÉLEVÉ",NULL},
/* 0972 */ { "LETTRE DÉVANÂGARÎ TCHANDRA A",NULL},
/* 0973 */ { "LETTRE DÉVANÂGARÎ OE",NULL},
/* 0974 */ { "LETTRE DÉVANÂGARÎ OOE",NULL},
/* 0975 */ { "LETTRE DÉVANÂGARÎ AW",NULL},
/* 0976 */ { "LETTRE DÉVANÂGARÎ OUE",NULL},
/* 0977 */ { "LETTRE DÉVANÂGARÎ OÛE",NULL},
/* 0978 */ { "LETTRE DÉVANÂGARÎ MARWARI DDA",NULL},
/* 0979 */ { "LETTRE DÉVANÂGARÎ ZHA","	* s'emploie pour la translittération de l'avestique\n"
	"	x (lettre goudjarati zha - 0AF9)"},
/* 097A */ { "LETTRE DÉVANÂGARÎ YA LOURD",NULL},
/* 097B */ { "LETTRE DÉVANÂGARÎ GGA",NULL},
/* 097C */ { "LETTRE DÉVANÂGARÎ DJJA",NULL},
/* 097D */ { "LETTRE DÉVANÂGARÎ COUP DE GLOTTE","	* utilisée dans l'écriture du limbu en dévanâgarî\n"
	"	* une variante est surmontée d'une barre supérieure continue (la ligne de tête)"},
/* 097E */ { "LETTRE DÉVANÂGARÎ DDDA",NULL},
/* 097F */ { "LETTRE DÉVANÂGARÎ BBA",NULL},
/* 0980 */ { "ANDJI BENGALI","	= siddham, siddhirastou\n"
	"	* placé au début d'un texte comme une invocation"},
/* 0981 */ { "DIACRITIQUE BENGALI TCHANDRABINDOU",NULL},
/* 0982 */ { "DIACRITIQUE BENGALI ANOUSVÂRA",NULL},
/* 0983 */ { "DIACRITIQUE BENGALI VISARGA",NULL},
/* 0984 */ { NULL,NULL},
/* 0985 */ { "LETTRE BENGALI A",NULL},
/* 0986 */ { "LETTRE BENGALI Â",NULL},
/* 0987 */ { "LETTRE BENGALI I",NULL},
/* 0988 */ { "LETTRE BENGALI Î",NULL},
/* 0989 */ { "LETTRE BENGALI OU",NULL},
/* 098A */ { "LETTRE BENGALI OÛ",NULL},
/* 098B */ { "LETTRE BENGALI R VOCALIQUE",NULL},
/* 098C */ { "LETTRE BENGALI L VOCALIQUE",NULL},
/* 098D */ { NULL,NULL},
/* 098E */ { NULL,NULL},
/* 098F */ { "LETTRE BENGALI É",NULL},
/* 0990 */ { "LETTRE BENGALI AÏ",NULL},
/* 0991 */ { NULL,NULL},
/* 0992 */ { NULL,NULL},
/* 0993 */ { "LETTRE BENGALI Ô",NULL},
/* 0994 */ { "LETTRE BENGALI AOU",NULL},
/* 0995 */ { "LETTRE BENGALI KA",NULL},
/* 0996 */ { "LETTRE BENGALI KHA",NULL},
/* 0997 */ { "LETTRE BENGALI GA",NULL},
/* 0998 */ { "LETTRE BENGALI GHA",NULL},
/* 0999 */ { "LETTRE BENGALI NGA",NULL},
/* 099A */ { "LETTRE BENGALI TCHA",NULL},
/* 099B */ { "LETTRE BENGALI TCHHA",NULL},
/* 099C */ { "LETTRE BENGALI DJA",NULL},
/* 099D */ { "LETTRE BENGALI DJHA",NULL},
/* 099E */ { "LETTRE BENGALI ÑA",NULL},
/* 099F */ { "LETTRE BENGALI TTA",NULL},
/* 09A0 */ { "LETTRE BENGALI TTHA",NULL},
/* 09A1 */ { "LETTRE BENGALI DDA",NULL},
/* 09A2 */ { "LETTRE BENGALI DDHA",NULL},
/* 09A3 */ { "LETTRE BENGALI NNA",NULL},
/* 09A4 */ { "LETTRE BENGALI TA",NULL},
/* 09A5 */ { "LETTRE BENGALI THA",NULL},
/* 09A6 */ { "LETTRE BENGALI DA",NULL},
/* 09A7 */ { "LETTRE BENGALI DHA",NULL},
/* 09A8 */ { "LETTRE BENGALI NA",NULL},
/* 09A9 */ { NULL,NULL},
/* 09AA */ { "LETTRE BENGALI PA",NULL},
/* 09AB */ { "LETTRE BENGALI PHA",NULL},
/* 09AC */ { "LETTRE BENGALI BA","	= lettre bengali va, lettre bengali wa"},
/* 09AD */ { "LETTRE BENGALI BHA",NULL},
/* 09AE */ { "LETTRE BENGALI MA",NULL},
/* 09AF */ { "LETTRE BENGALI YA",NULL},
/* 09B0 */ { "LETTRE BENGALI RA",NULL},
/* 09B1 */ { NULL,NULL},
/* 09B2 */ { "LETTRE BENGALI LA",NULL},
/* 09B3 */ { NULL,NULL},
/* 09B4 */ { NULL,NULL},
/* 09B5 */ { NULL,NULL},
/* 09B6 */ { "LETTRE BENGALI ÇA",NULL},
/* 09B7 */ { "LETTRE BENGALI CHA",NULL},
/* 09B8 */ { "LETTRE BENGALI SA",NULL},
/* 09B9 */ { "LETTRE BENGALI HA",NULL},
/* 09BA */ { NULL,NULL},
/* 09BB */ { NULL,NULL},
/* 09BC */ { "DIACRITIQUE BENGALI NOUKTA","	* pour étendre l'alphabet et former de nouvelles lettres"},
/* 09BD */ { "SIGNE BENGALI AVAGRAHA",NULL},
/* 09BE */ { "DIACRITIQUE VOYELLE BENGALI Â",NULL},
/* 09BF */ { "DIACRITIQUE VOYELLE BENGALI I","	* à la gauche de la consonne"},
/* 09C0 */ { "DIACRITIQUE VOYELLE BENGALI Î",NULL},
/* 09C1 */ { "DIACRITIQUE VOYELLE BENGALI OU",NULL},
/* 09C2 */ { "DIACRITIQUE VOYELLE BENGALI OÛ",NULL},
/* 09C3 */ { "DIACRITIQUE VOYELLE BENGALI R VOCALIQUE",NULL},
/* 09C4 */ { "DIACRITIQUE VOYELLE BENGALI RR VOCALIQUE",NULL},
/* 09C5 */ { NULL,NULL},
/* 09C6 */ { NULL,NULL},
/* 09C7 */ { "DIACRITIQUE VOYELLE BENGALI É","	* à la gauche de la consonne"},
/* 09C8 */ { "DIACRITIQUE VOYELLE BENGALI AÏ","	* à la gauche de la consonne"},
/* 09C9 */ { NULL,NULL},
/* 09CA */ { NULL,NULL},
/* 09CB */ { "DIACRITIQUE VOYELLE BENGALI Ô","	: 09C7 09BE"},
/* 09CC */ { "DIACRITIQUE VOYELLE BENGALI AOU","	: 09C7 09D7"},
/* 09CD */ { "DIACRITIQUE BENGALI VIRÂMA","	= hasant (terme bengali désignant le halant)"},
/* 09CE */ { "LETTRE BENGALI KHANDA TA","	* un ta qui a la forme d'une consonne morte, sans voyelle implicite, utilisé dans certaines séquences"},
/* 09CF */ { NULL,NULL},
/* 09D0 */ { NULL,NULL},
/* 09D1 */ { NULL,NULL},
/* 09D2 */ { NULL,NULL},
/* 09D3 */ { NULL,NULL},
/* 09D4 */ { NULL,NULL},
/* 09D5 */ { NULL,NULL},
/* 09D6 */ { NULL,NULL},
/* 09D7 */ { "SIGNE DE LONGUEUR BENGALI AOU",NULL},
/* 09D8 */ { NULL,NULL},
/* 09D9 */ { NULL,NULL},
/* 09DA */ { NULL,NULL},
/* 09DB */ { NULL,NULL},
/* 09DC */ { "LETTRE BENGALI RRA","	: 09A1 09BC"},
/* 09DD */ { "LETTRE BENGALI RHA","	: 09A2 09BC"},
/* 09DE */ { NULL,NULL},
/* 09DF */ { "LETTRE BENGALI YYA","	: 09AF 09BC"},
/* 09E0 */ { "LETTRE BENGALI RR VOCALIQUE",NULL},
/* 09E1 */ { "LETTRE BENGALI LL VOCALIQUE",NULL},
/* 09E2 */ { "DIACRITIQUE VOYELLE BENGALI L VOCALIQUE",NULL},
/* 09E3 */ { "DIACRITIQUE VOYELLE BENGALI LL VOCALIQUE",NULL},
/* 09E4 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 09E5 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 09E6 */ { "CHIFFRE BENGALI ZÉRO",NULL},
/* 09E7 */ { "CHIFFRE BENGALI UN",NULL},
/* 09E8 */ { "CHIFFRE BENGALI DEUX",NULL},
/* 09E9 */ { "CHIFFRE BENGALI TROIS",NULL},
/* 09EA */ { "CHIFFRE BENGALI QUATRE",NULL},
/* 09EB */ { "CHIFFRE BENGALI CINQ",NULL},
/* 09EC */ { "CHIFFRE BENGALI SIX",NULL},
/* 09ED */ { "CHIFFRE BENGALI SEPT",NULL},
/* 09EE */ { "CHIFFRE BENGALI HUIT",NULL},
/* 09EF */ { "CHIFFRE BENGALI NEUF",NULL},
/* 09F0 */ { "LETTRE BENGALI RA AVEC BARRE OBLIQUE MÉDIANE","	= lettre assamaise ra"},
/* 09F1 */ { "LETTRE BENGALI RA AVEC BARRE OBLIQUE SOUSCRITE","	= lettre assamaise wa\n"
	"	= lettre bengali va avec barre oblique souscrite (1.0)"},
/* 09F2 */ { "SIGNE BENGALI ROUPIE","	= taka\n"
	"	* signe monétaire historique"},
/* 09F3 */ { "SYMBOLE BENGALI ROUPIE","	= taka bangladais"},
/* 09F4 */ { "NUMÉRATEUR MONÉTAIRE BENGALI UN","	* tombé en désuétude"},
/* 09F5 */ { "NUMÉRATEUR MONÉTAIRE BENGALI DEUX","	* tombé en désuétude"},
/* 09F6 */ { "NUMÉRATEUR MONÉTAIRE BENGALI TROIS","	* tombé en désuétude"},
/* 09F7 */ { "NUMÉRATEUR MONÉTAIRE BENGALI QUATRE",NULL},
/* 09F8 */ { "NUMÉRATEUR MONÉTAIRE BENGALI DÉNOMINATEUR MOINS UN",NULL},
/* 09F9 */ { "DÉNOMINATEUR MONÉTAIRE BENGALI SEIZE",NULL},
/* 09FA */ { "ÎSCHAR BENGALI","	= ishvar\n"
	"	* représente le nom d'une divinité\n"
	"	= svargiya\n"
	"	* s'écrit devant le nom d'une personne décédée"},
/* 09FB */ { "SYMBOLE BENGALI GANDA",NULL},
/* 09FC */ { "LETTRE BENGALI ANOUSVÂRA VÉDIQUE",NULL},
/* 09FD */ { "SIGNE D'ABRÉVIATION BENGALI",NULL},
/* 09FE */ { NULL,NULL},
/* 09FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_0A[] = {
/* 0A00 */ { NULL,NULL},
/* 0A01 */ { "DIACRITIQUE GOURMOUKHÎ ADDAK BINDI",NULL},
/* 0A02 */ { "DIACRITIQUE GOURMOUKHÎ BINDI",NULL},
/* 0A03 */ { "DIACRITIQUE GOURMOUKHÎ VISARGA",NULL},
/* 0A04 */ { NULL,NULL},
/* 0A05 */ { "LETTRE GOURMOUKHÎ A","	= aïra"},
/* 0A06 */ { "LETTRE GOURMOUKHÎ Â",NULL},
/* 0A07 */ { "LETTRE GOURMOUKHÎ I",NULL},
/* 0A08 */ { "LETTRE GOURMOUKHÎ Î",NULL},
/* 0A09 */ { "LETTRE GOURMOUKHÎ OU",NULL},
/* 0A0A */ { "LETTRE GOURMOUKHÎ OÛ",NULL},
/* 0A0B */ { NULL,NULL},
/* 0A0C */ { NULL,NULL},
/* 0A0D */ { NULL,NULL},
/* 0A0E */ { NULL,NULL},
/* 0A0F */ { "LETTRE GOURMOUKHÎ Ê",NULL},
/* 0A10 */ { "LETTRE GOURMOUKHÎ AÏ",NULL},
/* 0A11 */ { NULL,NULL},
/* 0A12 */ { NULL,NULL},
/* 0A13 */ { "LETTRE GOURMOUKHÎ Ô",NULL},
/* 0A14 */ { "LETTRE GOURMOUKHÎ AOU",NULL},
/* 0A15 */ { "LETTRE GOURMOUKHÎ KA",NULL},
/* 0A16 */ { "LETTRE GOURMOUKHÎ KHA",NULL},
/* 0A17 */ { "LETTRE GOURMOUKHÎ GA",NULL},
/* 0A18 */ { "LETTRE GOURMOUKHÎ GHA",NULL},
/* 0A19 */ { "LETTRE GOURMOUKHÎ NGA",NULL},
/* 0A1A */ { "LETTRE GOURMOUKHÎ TCHA",NULL},
/* 0A1B */ { "LETTRE GOURMOUKHÎ TCHHA",NULL},
/* 0A1C */ { "LETTRE GOURMOUKHÎ DJA",NULL},
/* 0A1D */ { "LETTRE GOURMOUKHÎ TJA",NULL},
/* 0A1E */ { "LETTRE GOURMOUKHÎ ÑA",NULL},
/* 0A1F */ { "LETTRE GOURMOUKHÎ TTA",NULL},
/* 0A20 */ { "LETTRE GOURMOUKHÎ TTHA",NULL},
/* 0A21 */ { "LETTRE GOURMOUKHÎ DDA",NULL},
/* 0A22 */ { "LETTRE GOURMOUKHÎ DDHA",NULL},
/* 0A23 */ { "LETTRE GOURMOUKHÎ NNA",NULL},
/* 0A24 */ { "LETTRE GOURMOUKHÎ TA",NULL},
/* 0A25 */ { "LETTRE GOURMOUKHÎ THA",NULL},
/* 0A26 */ { "LETTRE GOURMOUKHÎ DA",NULL},
/* 0A27 */ { "LETTRE GOURMOUKHÎ DHA",NULL},
/* 0A28 */ { "LETTRE GOURMOUKHÎ NA",NULL},
/* 0A29 */ { NULL,NULL},
/* 0A2A */ { "LETTRE GOURMOUKHÎ PA",NULL},
/* 0A2B */ { "LETTRE GOURMOUKHÎ PHA",NULL},
/* 0A2C */ { "LETTRE GOURMOUKHÎ BA",NULL},
/* 0A2D */ { "LETTRE GOURMOUKHÎ BHA",NULL},
/* 0A2E */ { "LETTRE GOURMOUKHÎ MA",NULL},
/* 0A2F */ { "LETTRE GOURMOUKHÎ YA",NULL},
/* 0A30 */ { "LETTRE GOURMOUKHÎ RA",NULL},
/* 0A31 */ { NULL,NULL},
/* 0A32 */ { "LETTRE GOURMOUKHÎ LA",NULL},
/* 0A33 */ { "LETTRE GOURMOUKHÎ LLA","	: 0A32 0A3C"},
/* 0A34 */ { NULL,NULL},
/* 0A35 */ { "LETTRE GOURMOUKHÎ VA",NULL},
/* 0A36 */ { "LETTRE GOURMOUKHÎ ÇA","	: 0A38 0A3C"},
/* 0A37 */ { NULL,NULL},
/* 0A38 */ { "LETTRE GOURMOUKHÎ SA",NULL},
/* 0A39 */ { "LETTRE GOURMOUKHÎ HA",NULL},
/* 0A3A */ { NULL,NULL},
/* 0A3B */ { NULL,NULL},
/* 0A3C */ { "DIACRITIQUE GOURMOUKHÎ NOUKTA","	= païrin bindi\n"
	"	* pour étendre l'alphabet et former de nouvelles lettres"},
/* 0A3D */ { NULL,NULL},
/* 0A3E */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ Â","	= kanna"},
/* 0A3F */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ I","	= siharî\n"
	"	* à la gauche de la consonne"},
/* 0A40 */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ Î","	= biharî"},
/* 0A41 */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ OU","	= aounkar"},
/* 0A42 */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ OÛ","	= doulaïnkar"},
/* 0A43 */ { NULL,NULL},
/* 0A44 */ { NULL,NULL},
/* 0A45 */ { NULL,NULL},
/* 0A46 */ { NULL,NULL},
/* 0A47 */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ Ê","	= lanvan"},
/* 0A48 */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ AÏ","	= doulanvan"},
/* 0A49 */ { NULL,NULL},
/* 0A4A */ { NULL,NULL},
/* 0A4B */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ Ô","	= hora"},
/* 0A4C */ { "DIACRITIQUE VOYELLE GOURMOUKHÎ AOU","	= kanaoura"},
/* 0A4D */ { "DIACRITIQUE GOURMOUKHÎ VIRÂMA",NULL},
/* 0A4E */ { NULL,NULL},
/* 0A4F */ { NULL,NULL},
/* 0A50 */ { NULL,NULL},
/* 0A51 */ { "DIACRITIQUE GOURMOUKHÎ OUDÂT",NULL},
/* 0A52 */ { NULL,NULL},
/* 0A53 */ { NULL,NULL},
/* 0A54 */ { NULL,NULL},
/* 0A55 */ { NULL,NULL},
/* 0A56 */ { NULL,NULL},
/* 0A57 */ { NULL,NULL},
/* 0A58 */ { NULL,NULL},
/* 0A59 */ { "LETTRE GOURMOUKHÎ KHHA","	: 0A16 0A3C"},
/* 0A5A */ { "LETTRE GOURMOUKHÎ GHHA","	: 0A17 0A3C"},
/* 0A5B */ { "LETTRE GOURMOUKHÎ ZA","	: 0A1C 0A3C"},
/* 0A5C */ { "LETTRE GOURMOUKHÎ RRA",NULL},
/* 0A5D */ { NULL,NULL},
/* 0A5E */ { "LETTRE GOURMOUKHÎ FA","	: 0A2B 0A3C"},
/* 0A5F */ { NULL,NULL},
/* 0A60 */ { NULL,NULL},
/* 0A61 */ { NULL,NULL},
/* 0A62 */ { NULL,NULL},
/* 0A63 */ { NULL,NULL},
/* 0A64 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 0A65 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 0A66 */ { "CHIFFRE GOURMOUKHÎ ZÉRO",NULL},
/* 0A67 */ { "CHIFFRE GOURMOUKHÎ UN",NULL},
/* 0A68 */ { "CHIFFRE GOURMOUKHÎ DEUX",NULL},
/* 0A69 */ { "CHIFFRE GOURMOUKHÎ TROIS",NULL},
/* 0A6A */ { "CHIFFRE GOURMOUKHÎ QUATRE",NULL},
/* 0A6B */ { "CHIFFRE GOURMOUKHÎ CINQ",NULL},
/* 0A6C */ { "CHIFFRE GOURMOUKHÎ SIX",NULL},
/* 0A6D */ { "CHIFFRE GOURMOUKHÎ SEPT",NULL},
/* 0A6E */ { "CHIFFRE GOURMOUKHÎ HUIT",NULL},
/* 0A6F */ { "CHIFFRE GOURMOUKHÎ NEUF",NULL},
/* 0A70 */ { "TIPPI GOURMOUKHÎ","	* nasalisation"},
/* 0A71 */ { "ADDAK GOURMOUKHÎ","	* doublé quand il suit une consonne"},
/* 0A72 */ { "IRI GOURMOUKHÎ","	* base de voyelles"},
/* 0A73 */ { "OURA GOURMOUKHÎ","	* base de voyelles"},
/* 0A74 */ { "EK ONKAR GOURMOUKHÎ","	* Dieu est unique"},
/* 0A75 */ { "DIACRITIQUE GOURMOUKHÎ YAKACH","	* certaines polices utilisent un autre glyphe, formé davantage comme la partie inférieure de 0A2F"},
/* 0A76 */ { NULL,NULL},
/* 0A77 */ { NULL,NULL},
/* 0A78 */ { NULL,NULL},
/* 0A79 */ { NULL,NULL},
/* 0A7A */ { NULL,NULL},
/* 0A7B */ { NULL,NULL},
/* 0A7C */ { NULL,NULL},
/* 0A7D */ { NULL,NULL},
/* 0A7E */ { NULL,NULL},
/* 0A7F */ { NULL,NULL},
/* 0A80 */ { NULL,NULL},
/* 0A81 */ { "DIACRITIQUE GOUDJARATI TCHANDRABINDOU",NULL},
/* 0A82 */ { "DIACRITIQUE GOUDJARATI ANOUSVÂRA",NULL},
/* 0A83 */ { "DIACRITIQUE GOUDJARATI VISARGA",NULL},
/* 0A84 */ { NULL,NULL},
/* 0A85 */ { "LETTRE GOUDJARATI A",NULL},
/* 0A86 */ { "LETTRE GOUDJARATI Â",NULL},
/* 0A87 */ { "LETTRE GOUDJARATI I",NULL},
/* 0A88 */ { "LETTRE GOUDJARATI Î",NULL},
/* 0A89 */ { "LETTRE GOUDJARATI OU",NULL},
/* 0A8A */ { "LETTRE GOUDJARATI OÛ",NULL},
/* 0A8B */ { "LETTRE GOUDJARATI R VOCALIQUE",NULL},
/* 0A8C */ { "LETTRE GOUDJARATI L VOCALIQUE",NULL},
/* 0A8D */ { "VOYELLE GOUDJARATI É TCHANDRA",NULL},
/* 0A8E */ { NULL,NULL},
/* 0A8F */ { "LETTRE GOUDJARATI É",NULL},
/* 0A90 */ { "LETTRE GOUDJARATI AÏ",NULL},
/* 0A91 */ { "VOYELLE GOUDJARATI O TCHANDRA",NULL},
/* 0A92 */ { NULL,NULL},
/* 0A93 */ { "LETTRE GOUDJARATI Ô",NULL},
/* 0A94 */ { "LETTRE GOUDJARATI AOU",NULL},
/* 0A95 */ { "LETTRE GOUDJARATI KA",NULL},
/* 0A96 */ { "LETTRE GOUDJARATI KHA",NULL},
/* 0A97 */ { "LETTRE GOUDJARATI GA",NULL},
/* 0A98 */ { "LETTRE GOUDJARATI GHA",NULL},
/* 0A99 */ { "LETTRE GOUDJARATI NGA",NULL},
/* 0A9A */ { "LETTRE GOUDJARATI TCHA",NULL},
/* 0A9B */ { "LETTRE GOUDJARATI TCHHA",NULL},
/* 0A9C */ { "LETTRE GOUDJARATI DJA",NULL},
/* 0A9D */ { "LETTRE GOUDJARATI DJHA",NULL},
/* 0A9E */ { "LETTRE GOUDJARATI ÑA",NULL},
/* 0A9F */ { "LETTRE GOUDJARATI TTA",NULL},
/* 0AA0 */ { "LETTRE GOUDJARATI TTHA",NULL},
/* 0AA1 */ { "LETTRE GOUDJARATI DDA",NULL},
/* 0AA2 */ { "LETTRE GOUDJARATI DDHA",NULL},
/* 0AA3 */ { "LETTRE GOUDJARATI NNA",NULL},
/* 0AA4 */ { "LETTRE GOUDJARATI TA",NULL},
/* 0AA5 */ { "LETTRE GOUDJARATI THA",NULL},
/* 0AA6 */ { "LETTRE GOUDJARATI DA",NULL},
/* 0AA7 */ { "LETTRE GOUDJARATI DHA",NULL},
/* 0AA8 */ { "LETTRE GOUDJARATI NA",NULL},
/* 0AA9 */ { NULL,NULL},
/* 0AAA */ { "LETTRE GOUDJARATI PA",NULL},
/* 0AAB */ { "LETTRE GOUDJARATI PHA",NULL},
/* 0AAC */ { "LETTRE GOUDJARATI BA",NULL},
/* 0AAD */ { "LETTRE GOUDJARATI BHA",NULL},
/* 0AAE */ { "LETTRE GOUDJARATI MA",NULL},
/* 0AAF */ { "LETTRE GOUDJARATI YA",NULL},
/* 0AB0 */ { "LETTRE GOUDJARATI RA",NULL},
/* 0AB1 */ { NULL,NULL},
/* 0AB2 */ { "LETTRE GOUDJARATI LA",NULL},
/* 0AB3 */ { "LETTRE GOUDJARATI LLA",NULL},
/* 0AB4 */ { NULL,NULL},
/* 0AB5 */ { "LETTRE GOUDJARATI VA",NULL},
/* 0AB6 */ { "LETTRE GOUDJARATI ÇA",NULL},
/* 0AB7 */ { "LETTRE GOUDJARATI CHA",NULL},
/* 0AB8 */ { "LETTRE GOUDJARATI SA",NULL},
/* 0AB9 */ { "LETTRE GOUDJARATI HA",NULL},
/* 0ABA */ { NULL,NULL},
/* 0ABB */ { NULL,NULL},
/* 0ABC */ { "DIACRITIQUE GOUDJARATI NOUKTA","	* pour étendre l'alphabet et former de nouvelles lettres"},
/* 0ABD */ { "SIGNE GOUDJARATI AVAGRAHA",NULL},
/* 0ABE */ { "DIACRITIQUE VOYELLE GOUDJARATI Â",NULL},
/* 0ABF */ { "DIACRITIQUE VOYELLE GOUDJARATI I","	* à la gauche de la consonne"},
/* 0AC0 */ { "DIACRITIQUE VOYELLE GOUDJARATI Î",NULL},
/* 0AC1 */ { "DIACRITIQUE VOYELLE GOUDJARATI OU",NULL},
/* 0AC2 */ { "DIACRITIQUE VOYELLE GOUDJARATI OÛ",NULL},
/* 0AC3 */ { "DIACRITIQUE VOYELLE GOUDJARATI R VOCALIQUE",NULL},
/* 0AC4 */ { "DIACRITIQUE VOYELLE GOUDJARATI RR VOCALIQUE",NULL},
/* 0AC5 */ { "DIACRITIQUE VOYELLE GOUDJARATI É TCHANDRA",NULL},
/* 0AC6 */ { NULL,NULL},
/* 0AC7 */ { "DIACRITIQUE VOYELLE GOUDJARATI É",NULL},
/* 0AC8 */ { "DIACRITIQUE VOYELLE GOUDJARATI AÏ",NULL},
/* 0AC9 */ { "DIACRITIQUE VOYELLE GOUDJARATI O TCHANDRA",NULL},
/* 0ACA */ { NULL,NULL},
/* 0ACB */ { "DIACRITIQUE VOYELLE GOUDJARATI Ô",NULL},
/* 0ACC */ { "DIACRITIQUE VOYELLE GOUDJARATI AOU",NULL},
/* 0ACD */ { "DIACRITIQUE GOUDJARATI VIRÂMA",NULL},
/* 0ACE */ { NULL,NULL},
/* 0ACF */ { NULL,NULL},
/* 0AD0 */ { "OM GOUDJARATI",NULL},
/* 0AD1 */ { NULL,NULL},
/* 0AD2 */ { NULL,NULL},
/* 0AD3 */ { NULL,NULL},
/* 0AD4 */ { NULL,NULL},
/* 0AD5 */ { NULL,NULL},
/* 0AD6 */ { NULL,NULL},
/* 0AD7 */ { NULL,NULL},
/* 0AD8 */ { NULL,NULL},
/* 0AD9 */ { NULL,NULL},
/* 0ADA */ { NULL,NULL},
/* 0ADB */ { NULL,NULL},
/* 0ADC */ { NULL,NULL},
/* 0ADD */ { NULL,NULL},
/* 0ADE */ { NULL,NULL},
/* 0ADF */ { NULL,NULL},
/* 0AE0 */ { "LETTRE GOUDJARATI RR VOCALIQUE",NULL},
/* 0AE1 */ { "LETTRE GOUDJARATI LL VOCALIQUE",NULL},
/* 0AE2 */ { "DIACRITIQUE VOYELLE GOUDJARATI L VOCALIQUE",NULL},
/* 0AE3 */ { "DIACRITIQUE VOYELLE GOUDJARATI LL VOCALIQUE",NULL},
/* 0AE4 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 0AE5 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 0AE6 */ { "CHIFFRE GOUDJARATI ZÉRO",NULL},
/* 0AE7 */ { "CHIFFRE GOUDJARATI UN",NULL},
/* 0AE8 */ { "CHIFFRE GOUDJARATI DEUX",NULL},
/* 0AE9 */ { "CHIFFRE GOUDJARATI TROIS",NULL},
/* 0AEA */ { "CHIFFRE GOUDJARATI QUATRE",NULL},
/* 0AEB */ { "CHIFFRE GOUDJARATI CINQ",NULL},
/* 0AEC */ { "CHIFFRE GOUDJARATI SIX",NULL},
/* 0AED */ { "CHIFFRE GOUDJARATI SEPT",NULL},
/* 0AEE */ { "CHIFFRE GOUDJARATI HUIT",NULL},
/* 0AEF */ { "CHIFFRE GOUDJARATI NEUF",NULL},
/* 0AF0 */ { "SIGNE D'ABRÉVIATION GOUDJARATI",NULL},
/* 0AF1 */ { "SYMBOLE GOUDJARATI ROUPIE","	* l'écriture recommandée est 0AB0 0AC2 0AF0"},
/* 0AF2 */ { NULL,NULL},
/* 0AF3 */ { NULL,NULL},
/* 0AF4 */ { NULL,NULL},
/* 0AF5 */ { NULL,NULL},
/* 0AF6 */ { NULL,NULL},
/* 0AF7 */ { NULL,NULL},
/* 0AF8 */ { NULL,NULL},
/* 0AF9 */ { "LETTRE GOUDJARATI ZHA","	* s'emploie pour la translittération de l'avestique\n"
	"	x (lettre dévanâgarî zha - 0979)"},
/* 0AFA */ { "DIACRITIQUE GOUDJARATI SOUKOUN",NULL},
/* 0AFB */ { "DIACRITIQUE GOUDJARATI CHADDA",NULL},
/* 0AFC */ { "DIACRITIQUE GOUDJARATI MADDAH",NULL},
/* 0AFD */ { "DIACRITIQUE GOUDJARATI NOUKTA SUSCRIT FORMÉ DE TROIS POINTS",NULL},
/* 0AFE */ { "DIACRITIQUE GOUDJARATI NOUKTA SUSCRIT FORMÉ D'UN CERCLE",NULL},
/* 0AFF */ { "DIACRITIQUE GOUDJARATI NOUKTA SUSCRIT FORMÉ DE DEUX CERCLES",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_0B[] = {
/* 0B00 */ { NULL,NULL},
/* 0B01 */ { "DIACRITIQUE ORIYA TCHANDRABINDOU",NULL},
/* 0B02 */ { "DIACRITIQUE ORIYA ANOUSVÂRA",NULL},
/* 0B03 */ { "DIACRITIQUE ORIYA VISARGA",NULL},
/* 0B04 */ { NULL,NULL},
/* 0B05 */ { "LETTRE ORIYA A",NULL},
/* 0B06 */ { "LETTRE ORIYA Â",NULL},
/* 0B07 */ { "LETTRE ORIYA I",NULL},
/* 0B08 */ { "LETTRE ORIYA Î",NULL},
/* 0B09 */ { "LETTRE ORIYA OU",NULL},
/* 0B0A */ { "LETTRE ORIYA OÛ",NULL},
/* 0B0B */ { "LETTRE ORIYA R VOCALIQUE",NULL},
/* 0B0C */ { "LETTRE ORIYA L VOCALIQUE",NULL},
/* 0B0D */ { NULL,NULL},
/* 0B0E */ { NULL,NULL},
/* 0B0F */ { "LETTRE ORIYA É",NULL},
/* 0B10 */ { "LETTRE ORIYA AÏ",NULL},
/* 0B11 */ { NULL,NULL},
/* 0B12 */ { NULL,NULL},
/* 0B13 */ { "LETTRE ORIYA Ô",NULL},
/* 0B14 */ { "LETTRE ORIYA AOU",NULL},
/* 0B15 */ { "LETTRE ORIYA KA",NULL},
/* 0B16 */ { "LETTRE ORIYA KHA",NULL},
/* 0B17 */ { "LETTRE ORIYA GA",NULL},
/* 0B18 */ { "LETTRE ORIYA GHA",NULL},
/* 0B19 */ { "LETTRE ORIYA NGA",NULL},
/* 0B1A */ { "LETTRE ORIYA TCHA",NULL},
/* 0B1B */ { "LETTRE ORIYA TCHHA",NULL},
/* 0B1C */ { "LETTRE ORIYA DJA",NULL},
/* 0B1D */ { "LETTRE ORIYA DJHA",NULL},
/* 0B1E */ { "LETTRE ORIYA ÑA",NULL},
/* 0B1F */ { "LETTRE ORIYA TTA",NULL},
/* 0B20 */ { "LETTRE ORIYA TTHA",NULL},
/* 0B21 */ { "LETTRE ORIYA DDA",NULL},
/* 0B22 */ { "LETTRE ORIYA DDHA",NULL},
/* 0B23 */ { "LETTRE ORIYA NNA",NULL},
/* 0B24 */ { "LETTRE ORIYA TA",NULL},
/* 0B25 */ { "LETTRE ORIYA THA",NULL},
/* 0B26 */ { "LETTRE ORIYA DA",NULL},
/* 0B27 */ { "LETTRE ORIYA DHA",NULL},
/* 0B28 */ { "LETTRE ORIYA NA",NULL},
/* 0B29 */ { NULL,NULL},
/* 0B2A */ { "LETTRE ORIYA PA",NULL},
/* 0B2B */ { "LETTRE ORIYA PHA",NULL},
/* 0B2C */ { "LETTRE ORIYA BA","	= lettre oriya va, lettre oriya wa\n"
	"	x (lettre oriya va - 0B35)"},
/* 0B2D */ { "LETTRE ORIYA BHA",NULL},
/* 0B2E */ { "LETTRE ORIYA MA",NULL},
/* 0B2F */ { "LETTRE ORIYA YA","	= ja"},
/* 0B30 */ { "LETTRE ORIYA RA",NULL},
/* 0B31 */ { NULL,NULL},
/* 0B32 */ { "LETTRE ORIYA LA",NULL},
/* 0B33 */ { "LETTRE ORIYA LLA",NULL},
/* 0B34 */ { NULL,NULL},
/* 0B35 */ { "LETTRE ORIYA VA","	x (lettre oriya ba - 0B2C)"},
/* 0B36 */ { "LETTRE ORIYA ÇA",NULL},
/* 0B37 */ { "LETTRE ORIYA SSA",NULL},
/* 0B38 */ { "LETTRE ORIYA SA",NULL},
/* 0B39 */ { "LETTRE ORIYA HA",NULL},
/* 0B3A */ { NULL,NULL},
/* 0B3B */ { NULL,NULL},
/* 0B3C */ { "DIACRITIQUE ORIYA NOUKTA","	* pour étendre l'alphabet et former de nouvelles lettres"},
/* 0B3D */ { "SIGNE ORIYA AVAGRAHA",NULL},
/* 0B3E */ { "DIACRITIQUE VOYELLE ORIYA Â",NULL},
/* 0B3F */ { "DIACRITIQUE VOYELLE ORIYA I",NULL},
/* 0B40 */ { "DIACRITIQUE VOYELLE ORIYA Î",NULL},
/* 0B41 */ { "DIACRITIQUE VOYELLE ORIYA OU",NULL},
/* 0B42 */ { "DIACRITIQUE VOYELLE ORIYA OÛ",NULL},
/* 0B43 */ { "DIACRITIQUE VOYELLE ORIYA R VOCALIQUE",NULL},
/* 0B44 */ { "DIACRITIQUE VOYELLE ORIYA RR VOCALIQUE",NULL},
/* 0B45 */ { NULL,NULL},
/* 0B46 */ { NULL,NULL},
/* 0B47 */ { "DIACRITIQUE VOYELLE ORIYA É","	* à la gauche de la consonne"},
/* 0B48 */ { "DIACRITIQUE VOYELLE ORIYA AÏ","	* à la gauche de la consonne et au-dessus de la consonne\n"
	"	: 0B47 0B56"},
/* 0B49 */ { NULL,NULL},
/* 0B4A */ { NULL,NULL},
/* 0B4B */ { "DIACRITIQUE VOYELLE ORIYA Ô","	: 0B47 0B3E"},
/* 0B4C */ { "DIACRITIQUE VOYELLE ORIYA AOU","	: 0B47 0B57"},
/* 0B4D */ { "DIACRITIQUE ORIYA VIRÂMA",NULL},
/* 0B4E */ { NULL,NULL},
/* 0B4F */ { NULL,NULL},
/* 0B50 */ { NULL,NULL},
/* 0B51 */ { NULL,NULL},
/* 0B52 */ { NULL,NULL},
/* 0B53 */ { NULL,NULL},
/* 0B54 */ { NULL,NULL},
/* 0B55 */ { NULL,NULL},
/* 0B56 */ { "SIGNE DE LONGUEUR ORIYA AÏ",NULL},
/* 0B57 */ { "SIGNE DE LONGUEUR ORIYA AOU",NULL},
/* 0B58 */ { NULL,NULL},
/* 0B59 */ { NULL,NULL},
/* 0B5A */ { NULL,NULL},
/* 0B5B */ { NULL,NULL},
/* 0B5C */ { "LETTRE ORIYA RRA","	= dda\n"
	"	: 0B21 0B3C"},
/* 0B5D */ { "LETTRE ORIYA RHA","	= ddha\n"
	"	: 0B22 0B3C"},
/* 0B5E */ { NULL,NULL},
/* 0B5F */ { "LETTRE ORIYA YYA","	= ya"},
/* 0B60 */ { "LETTRE ORIYA RR VOCALIQUE",NULL},
/* 0B61 */ { "LETTRE ORIYA LL VOCALIQUE",NULL},
/* 0B62 */ { "DIACRITIQUE VOYELLE ORIYA L VOCALIQUE",NULL},
/* 0B63 */ { "DIACRITIQUE VOYELLE ORIYA LL VOCALIQUE",NULL},
/* 0B64 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 0B65 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 0B66 */ { "CHIFFRE ORIYA ZÉRO",NULL},
/* 0B67 */ { "CHIFFRE ORIYA UN",NULL},
/* 0B68 */ { "CHIFFRE ORIYA DEUX",NULL},
/* 0B69 */ { "CHIFFRE ORIYA TROIS",NULL},
/* 0B6A */ { "CHIFFRE ORIYA QUATRE",NULL},
/* 0B6B */ { "CHIFFRE ORIYA CINQ",NULL},
/* 0B6C */ { "CHIFFRE ORIYA SIX",NULL},
/* 0B6D */ { "CHIFFRE ORIYA SEPT",NULL},
/* 0B6E */ { "CHIFFRE ORIYA HUIT",NULL},
/* 0B6F */ { "CHIFFRE ORIYA NEUF",NULL},
/* 0B70 */ { "ÎSCHAR ORIYA",NULL},
/* 0B71 */ { "LETTRE ORIYA WA","	x (lettre oriya ô - 0B13)\n"
	"	x (lettre oriya va - 0B35)"},
/* 0B72 */ { "FRACTION ORIYA UN QUART",NULL},
/* 0B73 */ { "FRACTION ORIYA UN DEMI",NULL},
/* 0B74 */ { "FRACTION ORIYA TROIS QUARTS",NULL},
/* 0B75 */ { "FRACTION ORIYA UN SIXIÈME",NULL},
/* 0B76 */ { "FRACTION ORIYA UN HUITIÈME",NULL},
/* 0B77 */ { "FRACTION ORIYA TROIS SEIZIÈMES",NULL},
/* 0B78 */ { NULL,NULL},
/* 0B79 */ { NULL,NULL},
/* 0B7A */ { NULL,NULL},
/* 0B7B */ { NULL,NULL},
/* 0B7C */ { NULL,NULL},
/* 0B7D */ { NULL,NULL},
/* 0B7E */ { NULL,NULL},
/* 0B7F */ { NULL,NULL},
/* 0B80 */ { NULL,NULL},
/* 0B81 */ { NULL,NULL},
/* 0B82 */ { "DIACRITIQUE TAMOUL ANOUSVÂRA","	* inusité en tamoul"},
/* 0B83 */ { "SYMBOLE TAMOUL VISARGA","	= aytham\n"
	"	* ce signe tire son origine d'une forme particulière de visarga, mais n'est pas utilisé comme un visarga en tamoul\n"
	"	* le glyphe de l'aytham, comme celui du poulli tamoul, peut présenter soit des points, soit des cercles"},
/* 0B84 */ { NULL,NULL},
/* 0B85 */ { "LETTRE TAMOULE A",NULL},
/* 0B86 */ { "LETTRE TAMOULE Â",NULL},
/* 0B87 */ { "LETTRE TAMOULE I",NULL},
/* 0B88 */ { "LETTRE TAMOULE Î",NULL},
/* 0B89 */ { "LETTRE TAMOULE OU",NULL},
/* 0B8A */ { "LETTRE TAMOULE OÛ",NULL},
/* 0B8B */ { NULL,NULL},
/* 0B8C */ { NULL,NULL},
/* 0B8D */ { NULL,NULL},
/* 0B8E */ { "LETTRE TAMOULE É",NULL},
/* 0B8F */ { "LETTRE TAMOULE Ê",NULL},
/* 0B90 */ { "LETTRE TAMOULE AÏ",NULL},
/* 0B91 */ { NULL,NULL},
/* 0B92 */ { "LETTRE TAMOULE O",NULL},
/* 0B93 */ { "LETTRE TAMOULE Ô",NULL},
/* 0B94 */ { "LETTRE TAMOULE AOU","	: 0B92 0BD7"},
/* 0B95 */ { "LETTRE TAMOULE KA",NULL},
/* 0B96 */ { NULL,NULL},
/* 0B97 */ { NULL,NULL},
/* 0B98 */ { NULL,NULL},
/* 0B99 */ { "LETTRE TAMOULE NGA",NULL},
/* 0B9A */ { "LETTRE TAMOULE TCHA",NULL},
/* 0B9B */ { NULL,NULL},
/* 0B9C */ { "LETTRE TAMOULE DJA",NULL},
/* 0B9D */ { NULL,NULL},
/* 0B9E */ { "LETTRE TAMOULE ÑA",NULL},
/* 0B9F */ { "LETTRE TAMOULE TTA",NULL},
/* 0BA0 */ { NULL,NULL},
/* 0BA1 */ { NULL,NULL},
/* 0BA2 */ { NULL,NULL},
/* 0BA3 */ { "LETTRE TAMOULE NNA",NULL},
/* 0BA4 */ { "LETTRE TAMOULE TA",NULL},
/* 0BA5 */ { NULL,NULL},
/* 0BA6 */ { NULL,NULL},
/* 0BA7 */ { NULL,NULL},
/* 0BA8 */ { "LETTRE TAMOULE NA",NULL},
/* 0BA9 */ { "LETTRE TAMOULE NNNA",NULL},
/* 0BAA */ { "LETTRE TAMOULE PA","	* désigne aussi la fraction un vingtième"},
/* 0BAB */ { NULL,NULL},
/* 0BAC */ { NULL,NULL},
/* 0BAD */ { NULL,NULL},
/* 0BAE */ { "LETTRE TAMOULE MA",NULL},
/* 0BAF */ { "LETTRE TAMOULE YA",NULL},
/* 0BB0 */ { "LETTRE TAMOULE RA",NULL},
/* 0BB1 */ { "LETTRE TAMOULE RRA",NULL},
/* 0BB2 */ { "LETTRE TAMOULE LA",NULL},
/* 0BB3 */ { "LETTRE TAMOULE LLA",NULL},
/* 0BB4 */ { "LETTRE TAMOULE LLLA",NULL},
/* 0BB5 */ { "LETTRE TAMOULE VA","	* désigne aussi la fraction un quart"},
/* 0BB6 */ { "LETTRE TAMOULE ÇA",NULL},
/* 0BB7 */ { "LETTRE TAMOULE SSA",NULL},
/* 0BB8 */ { "LETTRE TAMOULE SA",NULL},
/* 0BB9 */ { "LETTRE TAMOULE HA",NULL},
/* 0BBA */ { NULL,NULL},
/* 0BBB */ { NULL,NULL},
/* 0BBC */ { NULL,NULL},
/* 0BBD */ { NULL,NULL},
/* 0BBE */ { "DIACRITIQUE VOYELLE TAMOULE Â",NULL},
/* 0BBF */ { "DIACRITIQUE VOYELLE TAMOULE I",NULL},
/* 0BC0 */ { "DIACRITIQUE VOYELLE TAMOULE Î",NULL},
/* 0BC1 */ { "DIACRITIQUE VOYELLE TAMOULE OU",NULL},
/* 0BC2 */ { "DIACRITIQUE VOYELLE TAMOULE OÛ",NULL},
/* 0BC3 */ { NULL,NULL},
/* 0BC4 */ { NULL,NULL},
/* 0BC5 */ { NULL,NULL},
/* 0BC6 */ { "DIACRITIQUE VOYELLE TAMOULE É","	* à la gauche de la consonne"},
/* 0BC7 */ { "DIACRITIQUE VOYELLE TAMOULE Ê","	* à la gauche de la consonne"},
/* 0BC8 */ { "DIACRITIQUE VOYELLE TAMOULE AÏ","	* à la gauche de la consonne"},
/* 0BC9 */ { NULL,NULL},
/* 0BCA */ { "DIACRITIQUE VOYELLE TAMOULE O","	: 0BC6 0BBE"},
/* 0BCB */ { "DIACRITIQUE VOYELLE TAMOULE Ô","	: 0BC7 0BBE"},
/* 0BCC */ { "DIACRITIQUE VOYELLE TAMOULE AOU","	: 0BC6 0BD7"},
/* 0BCD */ { "DIACRITIQUE TAMOUL VIRÂMA","	= poulli"},
/* 0BCE */ { NULL,NULL},
/* 0BCF */ { NULL,NULL},
/* 0BD0 */ { "OM TAMOUL",NULL},
/* 0BD1 */ { NULL,NULL},
/* 0BD2 */ { NULL,NULL},
/* 0BD3 */ { NULL,NULL},
/* 0BD4 */ { NULL,NULL},
/* 0BD5 */ { NULL,NULL},
/* 0BD6 */ { NULL,NULL},
/* 0BD7 */ { "SIGNE DE LONGUEUR TAMOUL AOU",NULL},
/* 0BD8 */ { NULL,NULL},
/* 0BD9 */ { NULL,NULL},
/* 0BDA */ { NULL,NULL},
/* 0BDB */ { NULL,NULL},
/* 0BDC */ { NULL,NULL},
/* 0BDD */ { NULL,NULL},
/* 0BDE */ { NULL,NULL},
/* 0BDF */ { NULL,NULL},
/* 0BE0 */ { NULL,NULL},
/* 0BE1 */ { NULL,NULL},
/* 0BE2 */ { NULL,NULL},
/* 0BE3 */ { NULL,NULL},
/* 0BE4 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 0BE5 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 0BE6 */ { "CHIFFRE TAMOUL ZÉRO",NULL},
/* 0BE7 */ { "CHIFFRE TAMOUL UN",NULL},
/* 0BE8 */ { "CHIFFRE TAMOUL DEUX",NULL},
/* 0BE9 */ { "CHIFFRE TAMOUL TROIS",NULL},
/* 0BEA */ { "CHIFFRE TAMOUL QUATRE",NULL},
/* 0BEB */ { "CHIFFRE TAMOUL CINQ",NULL},
/* 0BEC */ { "CHIFFRE TAMOUL SIX",NULL},
/* 0BED */ { "CHIFFRE TAMOUL SEPT",NULL},
/* 0BEE */ { "CHIFFRE TAMOUL HUIT",NULL},
/* 0BEF */ { "CHIFFRE TAMOUL NEUF",NULL},
/* 0BF0 */ { "NOMBRE TAMOUL DIX",NULL},
/* 0BF1 */ { "NOMBRE TAMOUL CENT",NULL},
/* 0BF2 */ { "NOMBRE TAMOUL MILLE",NULL},
/* 0BF3 */ { "SYMBOLE TAMOUL DU JOUR","	= nâl, nâli/padi\n"
	"	= pillaiyâr souli\n"
	"	* désigne le bonheur"},
/* 0BF4 */ { "SYMBOLE TAMOUL DU MOIS","	= mâtham"},
/* 0BF5 */ { "SYMBOLE TAMOUL DE L'ANNÉE","	= varoudam"},
/* 0BF6 */ { "SYMBOLE TAMOUL DE DÉBIT","	= patrou"},
/* 0BF7 */ { "SYMBOLE TAMOUL DE CRÉDIT","	= varavou"},
/* 0BF8 */ { "SYMBOLE TAMOUL COMME CI-DESSUS","	= merpadi"},
/* 0BF9 */ { "SYMBOLE TAMOUL ROUPIE","	= roupai"},
/* 0BFA */ { "SYMBOLE TAMOUL NUMÉRO","	= enn\n"
	"	* désigne le solde\n"
	"	* utilisé parfois comme symbole pour numéro, distinct du signe traditionnel"},
/* 0BFB */ { NULL,NULL},
/* 0BFC */ { NULL,NULL},
/* 0BFD */ { NULL,NULL},
/* 0BFE */ { NULL,NULL},
/* 0BFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_0C[] = {
/* 0C00 */ { "DIACRITIQUE TÉLOUGOU TCHANDRABINDOU SUSCRIT",NULL},
/* 0C01 */ { "DIACRITIQUE TÉLOUGOU TCHANDRABINDOU","	= arasounna"},
/* 0C02 */ { "DIACRITIQUE TÉLOUGOU ANOUSVÂRA","	= sounna"},
/* 0C03 */ { "DIACRITIQUE TÉLOUGOU VISARGA",NULL},
/* 0C04 */ { NULL,NULL},
/* 0C05 */ { "LETTRE TÉLOUGOU A",NULL},
/* 0C06 */ { "LETTRE TÉLOUGOU Â",NULL},
/* 0C07 */ { "LETTRE TÉLOUGOU I",NULL},
/* 0C08 */ { "LETTRE TÉLOUGOU Î",NULL},
/* 0C09 */ { "LETTRE TÉLOUGOU OU",NULL},
/* 0C0A */ { "LETTRE TÉLOUGOU OÛ",NULL},
/* 0C0B */ { "LETTRE TÉLOUGOU R VOCALIQUE",NULL},
/* 0C0C */ { "LETTRE TÉLOUGOU L VOCALIQUE",NULL},
/* 0C0D */ { NULL,NULL},
/* 0C0E */ { "LETTRE TÉLOUGOU É",NULL},
/* 0C0F */ { "LETTRE TÉLOUGOU Ê",NULL},
/* 0C10 */ { "LETTRE TÉLOUGOU AÏ",NULL},
/* 0C11 */ { NULL,NULL},
/* 0C12 */ { "LETTRE TÉLOUGOU O",NULL},
/* 0C13 */ { "LETTRE TÉLOUGOU Ô",NULL},
/* 0C14 */ { "LETTRE TÉLOUGOU AOU",NULL},
/* 0C15 */ { "LETTRE TÉLOUGOU KA",NULL},
/* 0C16 */ { "LETTRE TÉLOUGOU KHA",NULL},
/* 0C17 */ { "LETTRE TÉLOUGOU GA",NULL},
/* 0C18 */ { "LETTRE TÉLOUGOU GHA",NULL},
/* 0C19 */ { "LETTRE TÉLOUGOU NGA",NULL},
/* 0C1A */ { "LETTRE TÉLOUGOU TCHA",NULL},
/* 0C1B */ { "LETTRE TÉLOUGOU TCHHA",NULL},
/* 0C1C */ { "LETTRE TÉLOUGOU DJA",NULL},
/* 0C1D */ { "LETTRE TÉLOUGOU DJHA",NULL},
/* 0C1E */ { "LETTRE TÉLOUGOU ÑA",NULL},
/* 0C1F */ { "LETTRE TÉLOUGOU TTA",NULL},
/* 0C20 */ { "LETTRE TÉLOUGOU TTHA",NULL},
/* 0C21 */ { "LETTRE TÉLOUGOU DDA",NULL},
/* 0C22 */ { "LETTRE TÉLOUGOU DDHA",NULL},
/* 0C23 */ { "LETTRE TÉLOUGOU NNA",NULL},
/* 0C24 */ { "LETTRE TÉLOUGOU TA",NULL},
/* 0C25 */ { "LETTRE TÉLOUGOU THA",NULL},
/* 0C26 */ { "LETTRE TÉLOUGOU DA",NULL},
/* 0C27 */ { "LETTRE TÉLOUGOU DHA",NULL},
/* 0C28 */ { "LETTRE TÉLOUGOU NA",NULL},
/* 0C29 */ { NULL,NULL},
/* 0C2A */ { "LETTRE TÉLOUGOU PA",NULL},
/* 0C2B */ { "LETTRE TÉLOUGOU PHA",NULL},
/* 0C2C */ { "LETTRE TÉLOUGOU BA",NULL},
/* 0C2D */ { "LETTRE TÉLOUGOU BHA",NULL},
/* 0C2E */ { "LETTRE TÉLOUGOU MA",NULL},
/* 0C2F */ { "LETTRE TÉLOUGOU YA",NULL},
/* 0C30 */ { "LETTRE TÉLOUGOU RA",NULL},
/* 0C31 */ { "LETTRE TÉLOUGOU RRA",NULL},
/* 0C32 */ { "LETTRE TÉLOUGOU LA",NULL},
/* 0C33 */ { "LETTRE TÉLOUGOU LLA",NULL},
/* 0C34 */ { "LETTRE TÉLOUGOU LLLA",NULL},
/* 0C35 */ { "LETTRE TÉLOUGOU VA",NULL},
/* 0C36 */ { "LETTRE TÉLOUGOU ÇA",NULL},
/* 0C37 */ { "LETTRE TÉLOUGOU CHA",NULL},
/* 0C38 */ { "LETTRE TÉLOUGOU SA",NULL},
/* 0C39 */ { "LETTRE TÉLOUGOU HA",NULL},
/* 0C3A */ { NULL,NULL},
/* 0C3B */ { NULL,NULL},
/* 0C3C */ { NULL,NULL},
/* 0C3D */ { "SIGNE TÉLOUGOU AVAGRAHA",NULL},
/* 0C3E */ { "DIACRITIQUE VOYELLE TÉLOUGOU Â",NULL},
/* 0C3F */ { "DIACRITIQUE VOYELLE TÉLOUGOU I",NULL},
/* 0C40 */ { "DIACRITIQUE VOYELLE TÉLOUGOU Î",NULL},
/* 0C41 */ { "DIACRITIQUE VOYELLE TÉLOUGOU OU",NULL},
/* 0C42 */ { "DIACRITIQUE VOYELLE TÉLOUGOU OÛ",NULL},
/* 0C43 */ { "DIACRITIQUE VOYELLE TÉLOUGOU R VOCALIQUE",NULL},
/* 0C44 */ { "DIACRITIQUE VOYELLE TÉLOUGOU RR VOCALIQUE",NULL},
/* 0C45 */ { NULL,NULL},
/* 0C46 */ { "DIACRITIQUE VOYELLE TÉLOUGOU E",NULL},
/* 0C47 */ { "DIACRITIQUE VOYELLE TÉLOUGOU Ê",NULL},
/* 0C48 */ { "DIACRITIQUE VOYELLE TÉLOUGOU AÏ","	: 0C46 0C56"},
/* 0C49 */ { NULL,NULL},
/* 0C4A */ { "DIACRITIQUE VOYELLE TÉLOUGOU O",NULL},
/* 0C4B */ { "DIACRITIQUE VOYELLE TÉLOUGOU Ô",NULL},
/* 0C4C */ { "DIACRITIQUE VOYELLE TÉLOUGOU AOU",NULL},
/* 0C4D */ { "DIACRITIQUE TÉLOUGOU VIRÂMA","	= halant (le nom recommandé)"},
/* 0C4E */ { NULL,NULL},
/* 0C4F */ { NULL,NULL},
/* 0C50 */ { NULL,NULL},
/* 0C51 */ { NULL,NULL},
/* 0C52 */ { NULL,NULL},
/* 0C53 */ { NULL,NULL},
/* 0C54 */ { NULL,NULL},
/* 0C55 */ { "SIGNE DE LONGUEUR TÉLOUGOU",NULL},
/* 0C56 */ { "SIGNE DE LONGUEUR TÉLOUGOU AÏ",NULL},
/* 0C57 */ { NULL,NULL},
/* 0C58 */ { "LETTRE TÉLOUGOU TSA",NULL},
/* 0C59 */ { "LETTRE TÉLOUGOU DZA",NULL},
/* 0C5A */ { "LETTRE TÉLOUGOU RRRA","	* lettre pour une consonne alvéolaire dont la valeur phonétique exacte n'est pas connue"},
/* 0C5B */ { NULL,NULL},
/* 0C5C */ { NULL,NULL},
/* 0C5D */ { NULL,NULL},
/* 0C5E */ { NULL,NULL},
/* 0C5F */ { NULL,NULL},
/* 0C60 */ { "LETTRE TÉLOUGOU RR VOCALIQUE",NULL},
/* 0C61 */ { "LETTRE TÉLOUGOU LL VOCALIQUE",NULL},
/* 0C62 */ { "DIACRITIQUE VOYELLE TÉLOUGOU L VOCALIQUE",NULL},
/* 0C63 */ { "DIACRITIQUE VOYELLE TÉLOUGOU LL VOCALIQUE",NULL},
/* 0C64 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 0C65 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 0C66 */ { "CHIFFRE TÉLOUGOU ZÉRO",NULL},
/* 0C67 */ { "CHIFFRE TÉLOUGOU UN",NULL},
/* 0C68 */ { "CHIFFRE TÉLOUGOU DEUX",NULL},
/* 0C69 */ { "CHIFFRE TÉLOUGOU TROIS",NULL},
/* 0C6A */ { "CHIFFRE TÉLOUGOU QUATRE",NULL},
/* 0C6B */ { "CHIFFRE TÉLOUGOU CINQ",NULL},
/* 0C6C */ { "CHIFFRE TÉLOUGOU SIX",NULL},
/* 0C6D */ { "CHIFFRE TÉLOUGOU SEPT",NULL},
/* 0C6E */ { "CHIFFRE TÉLOUGOU HUIT",NULL},
/* 0C6F */ { "CHIFFRE TÉLOUGOU NEUF",NULL},
/* 0C70 */ { NULL,NULL},
/* 0C71 */ { NULL,NULL},
/* 0C72 */ { NULL,NULL},
/* 0C73 */ { NULL,NULL},
/* 0C74 */ { NULL,NULL},
/* 0C75 */ { NULL,NULL},
/* 0C76 */ { NULL,NULL},
/* 0C77 */ { NULL,NULL},
/* 0C78 */ { "NUMÉRATEUR TÉLOUGOU ZÉRO POUR LES PUISSANCES IMPAIRES DE QUATRE",NULL},
/* 0C79 */ { "NUMÉRATEUR TÉLOUGOU UN POUR LES PUISSANCES IMPAIRES DE QUATRE",NULL},
/* 0C7A */ { "NUMÉRATEUR TÉLOUGOU DEUX POUR LES PUISSANCES IMPAIRES DE QUATRE",NULL},
/* 0C7B */ { "NUMÉRATEUR TÉLOUGOU TROIS POUR LES PUISSANCES IMPAIRES DE QUATRE",NULL},
/* 0C7C */ { "NUMÉRATEUR TÉLOUGOU UN POUR LES PUISSANCES PAIRES DE QUATRE",NULL},
/* 0C7D */ { "NUMÉRATEUR TÉLOUGOU DEUX POUR LES PUISSANCES PAIRES DE QUATRE",NULL},
/* 0C7E */ { "NUMÉRATEUR TÉLOUGOU TROIS POUR LES PUISSANCES PAIRES DE QUATRE",NULL},
/* 0C7F */ { "SYMBOLE TÉLOUGOU TOÛMOU",NULL},
/* 0C80 */ { "SIGNE KANNARA TCHANDRABINDOU À CHASSE",NULL},
/* 0C81 */ { "DIACRITIQUE KANNARA TCHANDRABINDOU",NULL},
/* 0C82 */ { "DIACRITIQUE KANNARA ANOUSVÂRA",NULL},
/* 0C83 */ { "DIACRITIQUE KANNARA VISARGA",NULL},
/* 0C84 */ { NULL,NULL},
/* 0C85 */ { "LETTRE KANNARA A",NULL},
/* 0C86 */ { "LETTRE KANNARA Â",NULL},
/* 0C87 */ { "LETTRE KANNARA I",NULL},
/* 0C88 */ { "LETTRE KANNARA Î",NULL},
/* 0C89 */ { "LETTRE KANNARA OU",NULL},
/* 0C8A */ { "LETTRE KANNARA OÛ",NULL},
/* 0C8B */ { "LETTRE KANNARA R VOCALIQUE",NULL},
/* 0C8C */ { "LETTRE KANNARA L VOCALIQUE",NULL},
/* 0C8D */ { NULL,NULL},
/* 0C8E */ { "LETTRE KANNARA É",NULL},
/* 0C8F */ { "LETTRE KANNARA Ê",NULL},
/* 0C90 */ { "LETTRE KANNARA AÏ",NULL},
/* 0C91 */ { NULL,NULL},
/* 0C92 */ { "LETTRE KANNARA O",NULL},
/* 0C93 */ { "LETTRE KANNARA Ô",NULL},
/* 0C94 */ { "LETTRE KANNARA AOU",NULL},
/* 0C95 */ { "LETTRE KANNARA KA",NULL},
/* 0C96 */ { "LETTRE KANNARA KHA",NULL},
/* 0C97 */ { "LETTRE KANNARA GA",NULL},
/* 0C98 */ { "LETTRE KANNARA GHA",NULL},
/* 0C99 */ { "LETTRE KANNARA NGA",NULL},
/* 0C9A */ { "LETTRE KANNARA TCHA",NULL},
/* 0C9B */ { "LETTRE KANNARA TCHHA",NULL},
/* 0C9C */ { "LETTRE KANNARA DJA",NULL},
/* 0C9D */ { "LETTRE KANNARA DJHA",NULL},
/* 0C9E */ { "LETTRE KANNARA ÑA",NULL},
/* 0C9F */ { "LETTRE KANNARA TTA",NULL},
/* 0CA0 */ { "LETTRE KANNARA TTHA",NULL},
/* 0CA1 */ { "LETTRE KANNARA DDA",NULL},
/* 0CA2 */ { "LETTRE KANNARA DDHA",NULL},
/* 0CA3 */ { "LETTRE KANNARA NNA",NULL},
/* 0CA4 */ { "LETTRE KANNARA TA",NULL},
/* 0CA5 */ { "LETTRE KANNARA THA",NULL},
/* 0CA6 */ { "LETTRE KANNARA DA",NULL},
/* 0CA7 */ { "LETTRE KANNARA DHA",NULL},
/* 0CA8 */ { "LETTRE KANNARA NA",NULL},
/* 0CA9 */ { NULL,NULL},
/* 0CAA */ { "LETTRE KANNARA PA",NULL},
/* 0CAB */ { "LETTRE KANNARA PHA",NULL},
/* 0CAC */ { "LETTRE KANNARA BA",NULL},
/* 0CAD */ { "LETTRE KANNARA BHA",NULL},
/* 0CAE */ { "LETTRE KANNARA MA",NULL},
/* 0CAF */ { "LETTRE KANNARA YA",NULL},
/* 0CB0 */ { "LETTRE KANNARA RA",NULL},
/* 0CB1 */ { "LETTRE KANNARA RRA",NULL},
/* 0CB2 */ { "LETTRE KANNARA LA",NULL},
/* 0CB3 */ { "LETTRE KANNARA LLA",NULL},
/* 0CB4 */ { NULL,NULL},
/* 0CB5 */ { "LETTRE KANNARA VA",NULL},
/* 0CB6 */ { "LETTRE KANNARA ÇA",NULL},
/* 0CB7 */ { "LETTRE KANNARA CHA",NULL},
/* 0CB8 */ { "LETTRE KANNARA SA",NULL},
/* 0CB9 */ { "LETTRE KANNARA HA",NULL},
/* 0CBA */ { NULL,NULL},
/* 0CBB */ { NULL,NULL},
/* 0CBC */ { "DIACRITIQUE KANNARA NOUKTA",NULL},
/* 0CBD */ { "SIGNE KANNARA AVAGRAHA",NULL},
/* 0CBE */ { "DIACRITIQUE VOYELLE KANNARA Â",NULL},
/* 0CBF */ { "DIACRITIQUE VOYELLE KANNARA I",NULL},
/* 0CC0 */ { "DIACRITIQUE VOYELLE KANNARA Î","	: 0CBF 0CD5"},
/* 0CC1 */ { "DIACRITIQUE VOYELLE KANNARA OU",NULL},
/* 0CC2 */ { "DIACRITIQUE VOYELLE KANNARA OÛ",NULL},
/* 0CC3 */ { "DIACRITIQUE VOYELLE KANNARA R VOCALIQUE",NULL},
/* 0CC4 */ { "DIACRITIQUE VOYELLE KANNARA RR VOCALIQUE",NULL},
/* 0CC5 */ { NULL,NULL},
/* 0CC6 */ { "DIACRITIQUE VOYELLE KANNARA É",NULL},
/* 0CC7 */ { "DIACRITIQUE VOYELLE KANNARA Ê","	: 0CC6 0CD5"},
/* 0CC8 */ { "DIACRITIQUE VOYELLE KANNARA AÏ","	: 0CC6 0CD6"},
/* 0CC9 */ { NULL,NULL},
/* 0CCA */ { "DIACRITIQUE VOYELLE KANNARA O","	: 0CC6 0CC2"},
/* 0CCB */ { "DIACRITIQUE VOYELLE KANNARA Ô","	: 0CCA 0CD5"},
/* 0CCC */ { "DIACRITIQUE VOYELLE KANNARA AOU",NULL},
/* 0CCD */ { "DIACRITIQUE KANNARA VIRÂMA","	* le nom recommandé est halant"},
/* 0CCE */ { NULL,NULL},
/* 0CCF */ { NULL,NULL},
/* 0CD0 */ { NULL,NULL},
/* 0CD1 */ { NULL,NULL},
/* 0CD2 */ { NULL,NULL},
/* 0CD3 */ { NULL,NULL},
/* 0CD4 */ { NULL,NULL},
/* 0CD5 */ { "SIGNE DE LONGUEUR KANNARA",NULL},
/* 0CD6 */ { "SIGNE DE LONGUEUR KANNARA AÏ",NULL},
/* 0CD7 */ { NULL,NULL},
/* 0CD8 */ { NULL,NULL},
/* 0CD9 */ { NULL,NULL},
/* 0CDA */ { NULL,NULL},
/* 0CDB */ { NULL,NULL},
/* 0CDC */ { NULL,NULL},
/* 0CDD */ { NULL,NULL},
/* 0CDE */ { "LETTRE KANNARA LLLA","	* lettre historique désuète\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 0CDF */ { NULL,NULL},
/* 0CE0 */ { "LETTRE KANNARA RR VOCALIQUE",NULL},
/* 0CE1 */ { "LETTRE KANNARA LL VOCALIQUE",NULL},
/* 0CE2 */ { "DIACRITIQUE VOYELLE KANNARA L VOCALIQUE",NULL},
/* 0CE3 */ { "DIACRITIQUE VOYELLE KANNARA LL VOCALIQUE",NULL},
/* 0CE4 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 0CE5 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 0CE6 */ { "CHIFFRE KANNARA ZÉRO",NULL},
/* 0CE7 */ { "CHIFFRE KANNARA UN",NULL},
/* 0CE8 */ { "CHIFFRE KANNARA DEUX",NULL},
/* 0CE9 */ { "CHIFFRE KANNARA TROIS",NULL},
/* 0CEA */ { "CHIFFRE KANNARA QUATRE",NULL},
/* 0CEB */ { "CHIFFRE KANNARA CINQ",NULL},
/* 0CEC */ { "CHIFFRE KANNARA SIX",NULL},
/* 0CED */ { "CHIFFRE KANNARA SEPT",NULL},
/* 0CEE */ { "CHIFFRE KANNARA HUIT",NULL},
/* 0CEF */ { "CHIFFRE KANNARA NEUF",NULL},
/* 0CF0 */ { NULL,NULL},
/* 0CF1 */ { "SIGNE KANNARA DJIHVAMOULIYA","	x (signe védique djihvamouliya - 1CF5)"},
/* 0CF2 */ { "SIGNE KANNARA OUPADHMANIYA","	x (signe védique oupadhmaniya - 1CF6)"},
/* 0CF3 */ { NULL,NULL},
/* 0CF4 */ { NULL,NULL},
/* 0CF5 */ { NULL,NULL},
/* 0CF6 */ { NULL,NULL},
/* 0CF7 */ { NULL,NULL},
/* 0CF8 */ { NULL,NULL},
/* 0CF9 */ { NULL,NULL},
/* 0CFA */ { NULL,NULL},
/* 0CFB */ { NULL,NULL},
/* 0CFC */ { NULL,NULL},
/* 0CFD */ { NULL,NULL},
/* 0CFE */ { NULL,NULL},
/* 0CFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_0D[] = {
/* 0D00 */ { "DIACRITIQUE MALAYALAM ANOUSVÂRA SUSCRIT",NULL},
/* 0D01 */ { "DIACRITIQUE MALAYALAM TCHANDRABINDOU",NULL},
/* 0D02 */ { "DIACRITIQUE MALAYALAM ANOUSVÂRA","	* utilisé dans les textes en langue prâkrit pour indiquer la gémination de la consonne suivante"},
/* 0D03 */ { "DIACRITIQUE MALAYALAM VISARGA",NULL},
/* 0D04 */ { NULL,NULL},
/* 0D05 */ { "LETTRE MALAYALAM A",NULL},
/* 0D06 */ { "LETTRE MALAYALAM Â",NULL},
/* 0D07 */ { "LETTRE MALAYALAM I",NULL},
/* 0D08 */ { "LETTRE MALAYALAM Î",NULL},
/* 0D09 */ { "LETTRE MALAYALAM OU",NULL},
/* 0D0A */ { "LETTRE MALAYALAM OÛ",NULL},
/* 0D0B */ { "LETTRE MALAYALAM R VOCALIQUE",NULL},
/* 0D0C */ { "LETTRE MALAYALAM L VOCALIQUE",NULL},
/* 0D0D */ { NULL,NULL},
/* 0D0E */ { "LETTRE MALAYALAM É",NULL},
/* 0D0F */ { "LETTRE MALAYALAM Ê",NULL},
/* 0D10 */ { "LETTRE MALAYALAM AÏ",NULL},
/* 0D11 */ { NULL,NULL},
/* 0D12 */ { "LETTRE MALAYALAM O",NULL},
/* 0D13 */ { "LETTRE MALAYALAM Ô",NULL},
/* 0D14 */ { "LETTRE MALAYALAM AOU",NULL},
/* 0D15 */ { "LETTRE MALAYALAM KA",NULL},
/* 0D16 */ { "LETTRE MALAYALAM KHA",NULL},
/* 0D17 */ { "LETTRE MALAYALAM GA",NULL},
/* 0D18 */ { "LETTRE MALAYALAM GHA",NULL},
/* 0D19 */ { "LETTRE MALAYALAM NGA",NULL},
/* 0D1A */ { "LETTRE MALAYALAM TCHA","	= cha"},
/* 0D1B */ { "LETTRE MALAYALAM TCHHA","	= chha"},
/* 0D1C */ { "LETTRE MALAYALAM DJA",NULL},
/* 0D1D */ { "LETTRE MALAYALAM DJHA",NULL},
/* 0D1E */ { "LETTRE MALAYALAM ÑA","	= nha"},
/* 0D1F */ { "LETTRE MALAYALAM TTA","	= ta"},
/* 0D20 */ { "LETTRE MALAYALAM TTHA","	= tta"},
/* 0D21 */ { "LETTRE MALAYALAM DDA","	= da dur"},
/* 0D22 */ { "LETTRE MALAYALAM DDHA","	= dda dur"},
/* 0D23 */ { "LETTRE MALAYALAM NNA","	= na dur"},
/* 0D24 */ { "LETTRE MALAYALAM TA","	= tha"},
/* 0D25 */ { "LETTRE MALAYALAM THA","	= ttha"},
/* 0D26 */ { "LETTRE MALAYALAM DA","	= da mou"},
/* 0D27 */ { "LETTRE MALAYALAM DHA","	= dda mou"},
/* 0D28 */ { "LETTRE MALAYALAM NA",NULL},
/* 0D29 */ { "LETTRE MALAYALAM NNNA","	* usage historique uniquement"},
/* 0D2A */ { "LETTRE MALAYALAM PA",NULL},
/* 0D2B */ { "LETTRE MALAYALAM PHA",NULL},
/* 0D2C */ { "LETTRE MALAYALAM BA",NULL},
/* 0D2D */ { "LETTRE MALAYALAM BHA",NULL},
/* 0D2E */ { "LETTRE MALAYALAM MA","	* s'utilise aussi pour la fraction un quatre-vingtième (ou un huitantième)"},
/* 0D2F */ { "LETTRE MALAYALAM YA",NULL},
/* 0D30 */ { "LETTRE MALAYALAM RA",NULL},
/* 0D31 */ { "LETTRE MALAYALAM RRA",NULL},
/* 0D32 */ { "LETTRE MALAYALAM LA",NULL},
/* 0D33 */ { "LETTRE MALAYALAM LLA",NULL},
/* 0D34 */ { "LETTRE MALAYALAM LLLA","	= ja"},
/* 0D35 */ { "LETTRE MALAYALAM VA",NULL},
/* 0D36 */ { "LETTRE MALAYALAM ÇA","	= cha mou"},
/* 0D37 */ { "LETTRE MALAYALAM CHA","	= sha"},
/* 0D38 */ { "LETTRE MALAYALAM SA",NULL},
/* 0D39 */ { "LETTRE MALAYALAM HA",NULL},
/* 0D3A */ { "LETTRE MALAYALAM TTTA","	* usage historique uniquement"},
/* 0D3B */ { "DIACRITIQUE MALAYALAM VIRÂMA EN FORME DE BARRE VERTICALE",NULL},
/* 0D3C */ { "DIACRITIQUE MALAYALAM VIRÂMA CIRCULAIRE",NULL},
/* 0D3D */ { "SIGNE MALAYALAM AVAGRAHA","	= praslecham"},
/* 0D3E */ { "DIACRITIQUE VOYELLE MALAYALAM Â",NULL},
/* 0D3F */ { "DIACRITIQUE VOYELLE MALAYALAM I",NULL},
/* 0D40 */ { "DIACRITIQUE VOYELLE MALAYALAM Î",NULL},
/* 0D41 */ { "DIACRITIQUE VOYELLE MALAYALAM OU",NULL},
/* 0D42 */ { "DIACRITIQUE VOYELLE MALAYALAM OÛ",NULL},
/* 0D43 */ { "DIACRITIQUE VOYELLE MALAYALAM R VOCALIQUE",NULL},
/* 0D44 */ { "DIACRITIQUE VOYELLE MALAYALAM RR VOCALIQUE",NULL},
/* 0D45 */ { NULL,NULL},
/* 0D46 */ { "DIACRITIQUE VOYELLE MALAYALAM É","	* à la gauche de la consonne"},
/* 0D47 */ { "DIACRITIQUE VOYELLE MALAYALAM Ê","	* à la gauche de la consonne"},
/* 0D48 */ { "DIACRITIQUE VOYELLE MALAYALAM AÏ","	* à la gauche de la consonne"},
/* 0D49 */ { NULL,NULL},
/* 0D4A */ { "DIACRITIQUE VOYELLE MALAYALAM O","	: 0D46 0D3E"},
/* 0D4B */ { "DIACRITIQUE VOYELLE MALAYALAM Ô","	: 0D47 0D3E"},
/* 0D4C */ { "DIACRITIQUE VOYELLE MALAYALAM AOU","	* forme archaïque de la voyelle diacritique /aou/\n"
	"	x (signe de longueur malayalam aou - 0D57)\n"
	"	: 0D46 0D57"},
/* 0D4D */ { "DIACRITIQUE MALAYALAM VIRÂMA","	= tchandrakkala (le nom recommandé)\n"
	"	= e muet malayalam, schwa malayalam"},
/* 0D4E */ { "LETTRE MALAYALAM REPHA POINT","	* inusité dans la l'orthographe moderne malayalam"},
/* 0D4F */ { "SYMBOLE MALAYALAM PARA","	* utilisé autrefois pour la mesure du riz"},
/* 0D50 */ { NULL,NULL},
/* 0D51 */ { NULL,NULL},
/* 0D52 */ { NULL,NULL},
/* 0D53 */ { NULL,NULL},
/* 0D54 */ { "LETTRE MALAYALAM M TCHILLOU",NULL},
/* 0D55 */ { "LETTRE MALAYALAM Y TCHILLOU",NULL},
/* 0D56 */ { "LETTRE MALAYALAM LLL TCHILLOU",NULL},
/* 0D57 */ { "SIGNE DE LONGUEUR MALAYALAM AOU","	* s'utilise seul dans les textes modernes pour représenter la voyelle diacritique /aou/\n"
	"	x (diacritique voyelle malayalam aou - 0D4C)"},
/* 0D58 */ { "FRACTION MALAYALAM UN CENT-SOIXANTIÈME","	= arakâni"},
/* 0D59 */ { "FRACTION MALAYALAM UN QUARANTIÈME","	= aramâ"},
/* 0D5A */ { "FRACTION MALAYALAM TROIS QUATRE-VINGTIÈMES","	= fraction malayalam trois huitantièmes\n"
	"	= moûnnoukâni"},
/* 0D5B */ { "FRACTION MALAYALAM UN VINGTIÈME","	= oroumâ"},
/* 0D5C */ { "FRACTION MALAYALAM UN DIXIÈME","	= rantoumâ"},
/* 0D5D */ { "FRACTION MALAYALAM TROIS VINGTIÈMES","	= moûnnoumâ"},
/* 0D5E */ { "FRACTION MALAYALAM UN CINQUIÈME","	= nâloumâ"},
/* 0D5F */ { "LETTRE MALAYALAM ARCHAÏQUE Î",NULL},
/* 0D60 */ { "LETTRE MALAYALAM RR VOCALIQUE",NULL},
/* 0D61 */ { "LETTRE MALAYALAM LL VOCALIQUE",NULL},
/* 0D62 */ { "DIACRITIQUE VOYELLE MALAYALAM L VOCALIQUE",NULL},
/* 0D63 */ { "DIACRITIQUE VOYELLE MALAYALAM LL VOCALIQUE",NULL},
/* 0D64 */ { NULL,"	x (danda dévanâgarî - 0964)"},
/* 0D65 */ { NULL,"	x (double danda dévanâgarî - 0965)"},
/* 0D66 */ { "CHIFFRE MALAYALAM ZÉRO",NULL},
/* 0D67 */ { "CHIFFRE MALAYALAM UN",NULL},
/* 0D68 */ { "CHIFFRE MALAYALAM DEUX",NULL},
/* 0D69 */ { "CHIFFRE MALAYALAM TROIS",NULL},
/* 0D6A */ { "CHIFFRE MALAYALAM QUATRE",NULL},
/* 0D6B */ { "CHIFFRE MALAYALAM CINQ",NULL},
/* 0D6C */ { "CHIFFRE MALAYALAM SIX",NULL},
/* 0D6D */ { "CHIFFRE MALAYALAM SEPT",NULL},
/* 0D6E */ { "CHIFFRE MALAYALAM HUIT",NULL},
/* 0D6F */ { "CHIFFRE MALAYALAM NEUF",NULL},
/* 0D70 */ { "NOMBRE MALAYALAM DIX",NULL},
/* 0D71 */ { "NOMBRE MALAYALAM CENT",NULL},
/* 0D72 */ { "NOMBRE MALAYALAM MILLE",NULL},
/* 0D73 */ { "FRACTION MALAYALAM UN QUART","	= kâl"},
/* 0D74 */ { "FRACTION MALAYALAM UN DEMI","	= ara"},
/* 0D75 */ { "FRACTION MALAYALAM TROIS QUARTS","	= moukkâl"},
/* 0D76 */ { "FRACTION MALAYALAM UN SEIZIÈME","	= mâkâni"},
/* 0D77 */ { "FRACTION MALAYALAM UN HUITIÈME","	= arakkâl"},
/* 0D78 */ { "FRACTION MALAYALAM TROIS SEIZIÈMES","	= mountâni"},
/* 0D79 */ { "SYMBOLE MALAYALAM QUANTIÈME",NULL},
/* 0D7A */ { "LETTRE MALAYALAM NN TCHILLOU",NULL},
/* 0D7B */ { "LETTRE MALAYALAM N TCHILLOU",NULL},
/* 0D7C */ { "LETTRE MALAYALAM RR TCHILLOU",NULL},
/* 0D7D */ { "LETTRE MALAYALAM L TCHILLOU",NULL},
/* 0D7E */ { "LETTRE MALAYALAM LL TCHILLOU",NULL},
/* 0D7F */ { "LETTRE MALAYALAM K TCHILLOU",NULL},
/* 0D80 */ { NULL,NULL},
/* 0D81 */ { NULL,NULL},
/* 0D82 */ { "DIACRITIQUE SINGHALAIS ANOUSVÂRAYA","	= anusvara"},
/* 0D83 */ { "DIACRITIQUE SINGHALAIS VISARGAYA","	= visarga"},
/* 0D84 */ { NULL,NULL},
/* 0D85 */ { "LETTRE SINGHALAISE AYANNA","	= lettre singhalaise a"},
/* 0D86 */ { "LETTRE SINGHALAISE ÂYANNA","	= lettre singhalaise â"},
/* 0D87 */ { "LETTRE SINGHALAISE ÆYANNA","	= lettre singhalaise æ"},
/* 0D88 */ { "LETTRE SINGHALAISE ÆÆYANNA","	= lettre singhalaise ææ"},
/* 0D89 */ { "LETTRE SINGHALAISE IYANNA","	= lettre singhalaise i"},
/* 0D8A */ { "LETTRE SINGHALAISE ÎYANNA","	= lettre singhalaise î"},
/* 0D8B */ { "LETTRE SINGHALAISE OUYANNA","	= lettre singhalaise ou"},
/* 0D8C */ { "LETTRE SINGHALAISE OÛYANNA","	= lettre singhalaise oû"},
/* 0D8D */ { "LETTRE SINGHALAISE IROUYANNA","	= lettre singhalaise r vocalique"},
/* 0D8E */ { "LETTRE SINGHALAISE IROÛYANNA","	= lettre singhalaise rr vocalique"},
/* 0D8F */ { "LETTRE SINGHALAISE ILOUYANNA","	= lettre singhalaise l vocalique"},
/* 0D90 */ { "LETTRE SINGHALAISE ILOÛYANNA","	= lettre singhalaise ll vocalique"},
/* 0D91 */ { "LETTRE SINGHALAISE ÉYANNA","	= lettre singhalaise é"},
/* 0D92 */ { "LETTRE SINGHALAISE ÊYANNA","	= lettre singhalaise ê"},
/* 0D93 */ { "LETTRE SINGHALAISE AÏYANNA","	= lettre singhalaise aï"},
/* 0D94 */ { "LETTRE SINGHALAISE OYANNA","	= lettre singhalaise o"},
/* 0D95 */ { "LETTRE SINGHALAISE ÔYANNA","	= lettre singhalaise ô"},
/* 0D96 */ { "LETTRE SINGHALAISE AOUYANNA","	= lettre singhalaise aou"},
/* 0D97 */ { NULL,NULL},
/* 0D98 */ { NULL,NULL},
/* 0D99 */ { NULL,NULL},
/* 0D9A */ { "LETTRE SINGHALAISE ALPAPRÂNA KAYANNA","	= lettre singhalaise ka"},
/* 0D9B */ { "LETTRE SINGHALAISE MAHÂPRÂNA KAYANNA","	= lettre singhalaise kha"},
/* 0D9C */ { "LETTRE SINGHALAISE ALPAPRÂNA GAYANNA","	= lettre singhalaise ga"},
/* 0D9D */ { "LETTRE SINGHALAISE MAHÂPRÂNA GAYANNA","	= lettre singhalaise gha"},
/* 0D9E */ { "LETTRE SINGHALAISE KANTADJA NÂSIKYAYA","	= lettre singhalaise nna"},
/* 0D9F */ { "LETTRE SINGHALAISE SAÑAKA GAYANNA","	= lettre singhalaise nnga"},
/* 0DA0 */ { "LETTRE SINGHALAISE ALPAPRÂNA TCHAYANNA","	= lettre singhalaise tcha"},
/* 0DA1 */ { "LETTRE SINGHALAISE MAHÂPRÂNA TCHAYANNA","	= lettre singhalaise tchha"},
/* 0DA2 */ { "LETTRE SINGHALAISE ALPAPRÂNA DJAYANNA","	= lettre singhalaise dja"},
/* 0DA3 */ { "LETTRE SINGHALAISE MAHÂPRÂNA DJAYANNA","	= lettre singhalaise djha"},
/* 0DA4 */ { "LETTRE SINGHALAISE TÂLOUDJA NÂSIKYAYA","	= lettre singhalaise ña"},
/* 0DA5 */ { "LETTRE SINGHALAISE TÂLOUDJA SANYÔGA NÂKSIKYAYA","	= lettre singhalaise djña"},
/* 0DA6 */ { "LETTRE SINGHALAISE SAÑAKA DJAYANNA","	= lettre singhalaise ñdja"},
/* 0DA7 */ { "LETTRE SINGHALAISE ALPAPRÂNA TTAYANNA","	= lettre singhalaise tta"},
/* 0DA8 */ { "LETTRE SINGHALAISE MAHÂPRÂNA TTAYANNA","	= lettre singhalaise ttha"},
/* 0DA9 */ { "LETTRE SINGHALAISE ALPAPRÂNA DDAYANNA","	= lettre singhalaise dda"},
/* 0DAA */ { "LETTRE SINGHALAISE MAHÂPRÂNA DDAYANNA","	= lettre singhalaise ddha"},
/* 0DAB */ { "LETTRE SINGHALAISE MOÛRDHADJA NAYANNA","	= lettre singhalaise nna"},
/* 0DAC */ { "LETTRE SINGHALAISE SAÑAKA DDAYANNA","	= lettre singhalaise nndda"},
/* 0DAD */ { "LETTRE SINGHALAISE ALPAPRÂNA TAYANNA","	= lettre singhalaise ta"},
/* 0DAE */ { "LETTRE SINGHALAISE MAHÂPRÂNA TAYANNA","	= lettre singhalaise tha"},
/* 0DAF */ { "LETTRE SINGHALAISE ALPAPRÂNA DAYANNA","	= lettre singhalaise da"},
/* 0DB0 */ { "LETTRE SINGHALAISE MAHÂPRÂNA DAYANNA","	= lettre singhalaise dha"},
/* 0DB1 */ { "LETTRE SINGHALAISE DANTADJA NAYANNA","	= lettre singhalaise na"},
/* 0DB2 */ { NULL,NULL},
/* 0DB3 */ { "LETTRE SINGHALAISE SAÑAKA DAYANNA","	= lettre singhalaise nda"},
/* 0DB4 */ { "LETTRE SINGHALAISE ALPAPRÂNA PAYANNA","	= lettre singhalaise pa"},
/* 0DB5 */ { "LETTRE SINGHALAISE MAHÂPRÂNA PAYANNA","	= lettre singhalaise pha"},
/* 0DB6 */ { "LETTRE SINGHALAISE ALPAPRÂNA BAYANNA","	= lettre singhalaise ba"},
/* 0DB7 */ { "LETTRE SINGHALAISE MAHÂPRÂNA BAYANNA","	= lettre singhalaise bha"},
/* 0DB8 */ { "LETTRE SINGHALAISE MAYANNA","	= lettre singhalaise ma"},
/* 0DB9 */ { "LETTRE SINGHALAISE AMBA BAYANNA","	= lettre singhalaise mba"},
/* 0DBA */ { "LETTRE SINGHALAISE YAYANNA","	= lettre singhalaise ya"},
/* 0DBB */ { "LETTRE SINGHALAISE RAYANNA","	= lettre singhalaise ra"},
/* 0DBC */ { NULL,NULL},
/* 0DBD */ { "LETTRE SINGHALAISE DANTADJA LAYANNA","	= lettre singhalaise la\n"
	"	* dentale"},
/* 0DBE */ { NULL,NULL},
/* 0DBF */ { NULL,NULL},
/* 0DC0 */ { "LETTRE SINGHALAISE VAYANNA","	= lettre singhalaise va"},
/* 0DC1 */ { "LETTRE SINGHALAISE TÂLOUDJA ÇAYANNA","	= lettre singhalaise ça"},
/* 0DC2 */ { "LETTRE SINGHALAISE MOÛRDHADJA CHAYANNA","	= lettre singhalaise ssa\n"
	"	* rétroflexe"},
/* 0DC3 */ { "LETTRE SINGHALAISE DANTADJA SAYANNA","	= lettre singhalaise sa\n"
	"	* dentale"},
/* 0DC4 */ { "LETTRE SINGHALAISE HAYANNA","	= lettre singhalaise ha"},
/* 0DC5 */ { "LETTRE SINGHALAISE MOÛRDHADJA LAYANNA","	= lettre singhalaise lla\n"
	"	* rétroflexe"},
/* 0DC6 */ { "LETTRE SINGHALAISE FAYANNA","	= lettre singhalaise fa"},
/* 0DC7 */ { NULL,NULL},
/* 0DC8 */ { NULL,NULL},
/* 0DC9 */ { NULL,NULL},
/* 0DCA */ { "DIACRITIQUE SINGHALAIS AL-LAKOUNA","	= virâma"},
/* 0DCB */ { NULL,NULL},
/* 0DCC */ { NULL,NULL},
/* 0DCD */ { NULL,NULL},
/* 0DCE */ { NULL,NULL},
/* 0DCF */ { "DIACRITIQUE VOYELLE SINGHALAISE ÆLA-PILLA","	= diacritique voyelle singhalaise â"},
/* 0DD0 */ { "DIACRITIQUE VOYELLE SINGHALAISE KÉTTI ÆDA-PILLA","	= diacritique voyelle singhalaise æ"},
/* 0DD1 */ { "DIACRITIQUE VOYELLE SINGHALAISE DIGA ÆDA-PILLA","	= diacritique voyelle singhalaise æ"},
/* 0DD2 */ { "DIACRITIQUE VOYELLE SINGHALAISE KÉTTI IS-PILLA","	= diacritique voyelle singhalaise i"},
/* 0DD3 */ { "DIACRITIQUE VOYELLE SINGHALAISE DIGA IS-PILLA","	= diacritique voyelle singhalaise î"},
/* 0DD4 */ { "DIACRITIQUE VOYELLE SINGHALAISE KÉTTI PÂ-PILLA","	= diacritique voyelle singhalaise ou"},
/* 0DD5 */ { NULL,NULL},
/* 0DD6 */ { "DIACRITIQUE VOYELLE SINGHALAISE DIGA PÂ-PILLA","	= diacritique voyelle singhalaise oû"},
/* 0DD7 */ { NULL,NULL},
/* 0DD8 */ { "DIACRITIQUE VOYELLE SINGHALAISE GÆTTA-PILLA","	= diacritique voyelle singhalaise r vocalique"},
/* 0DD9 */ { "DIACRITIQUE VOYELLE SINGHALAISE KOMBOUVA","	= diacritique voyelle singhalaise é"},
/* 0DDA */ { "DIACRITIQUE VOYELLE SINGHALAISE DIGA KOMBOUVA","	= diacritique voyelle singhalaise ê\n"
	"	: 0DD9 0DCA"},
/* 0DDB */ { "DIACRITIQUE VOYELLE SINGHALAISE KOMBOU DEKA","	= diacritique voyelle singhalaise aï"},
/* 0DDC */ { "DIACRITIQUE VOYELLE SINGHALAISE KOMBOUVA HAA ÆLA-PILLA","	= diacritique voyelle singhalaise o\n"
	"	: 0DD9 0DCF"},
/* 0DDD */ { "DIACRITIQUE VOYELLE SINGHALAISE KOMBOUVA HAA DIGA ÆLA-PILLA","	= diacritique voyelle singhalaise ô\n"
	"	: 0DDC 0DCA"},
/* 0DDE */ { "DIACRITIQUE VOYELLE SINGHALAISE KOMBOUVA HAA GAYANOUKITTA","	= diacritique voyelle singhalaise aou\n"
	"	: 0DD9 0DDF"},
/* 0DDF */ { "DIACRITIQUE VOYELLE SINGHALAISE GAYANOUKITTA","	= diacritique voyelle singhalaise l vocalique"},
/* 0DE0 */ { NULL,NULL},
/* 0DE1 */ { NULL,NULL},
/* 0DE2 */ { NULL,NULL},
/* 0DE3 */ { NULL,NULL},
/* 0DE4 */ { NULL,NULL},
/* 0DE5 */ { NULL,NULL},
/* 0DE6 */ { "CHIFFRE LITH SINGHALAIS ZÉRO",NULL},
/* 0DE7 */ { "CHIFFRE LITH SINGHALAIS UN",NULL},
/* 0DE8 */ { "CHIFFRE LITH SINGHALAIS DEUX",NULL},
/* 0DE9 */ { "CHIFFRE LITH SINGHALAIS TROIS",NULL},
/* 0DEA */ { "CHIFFRE LITH SINGHALAIS QUATRE",NULL},
/* 0DEB */ { "CHIFFRE LITH SINGHALAIS CINQ",NULL},
/* 0DEC */ { "CHIFFRE LITH SINGHALAIS SIX",NULL},
/* 0DED */ { "CHIFFRE LITH SINGHALAIS SEPT",NULL},
/* 0DEE */ { "CHIFFRE LITH SINGHALAIS HUIT",NULL},
/* 0DEF */ { "CHIFFRE LITH SINGHALAIS NEUF",NULL},
/* 0DF0 */ { NULL,NULL},
/* 0DF1 */ { NULL,NULL},
/* 0DF2 */ { "DIACRITIQUE VOYELLE SINGHALAISE DIGA GÆTTA-PILLA","	= diacritique voyelle singhalaise rr vocalique"},
/* 0DF3 */ { "DIACRITIQUE VOYELLE SINGHALAISE DIGA GAYANOUKITTA","	= diacritique voyelle singhalaise ll vocalique"},
/* 0DF4 */ { "PONCTUATION SINGHALAISE KOUNDDALIYA",NULL},
/* 0DF5 */ { NULL,NULL},
/* 0DF6 */ { NULL,NULL},
/* 0DF7 */ { NULL,NULL},
/* 0DF8 */ { NULL,NULL},
/* 0DF9 */ { NULL,NULL},
/* 0DFA */ { NULL,NULL},
/* 0DFB */ { NULL,NULL},
/* 0DFC */ { NULL,NULL},
/* 0DFD */ { NULL,NULL},
/* 0DFE */ { NULL,NULL},
/* 0DFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_0E[] = {
/* 0E00 */ { NULL,NULL},
/* 0E01 */ { "CARACTÈRE THAÏ KO KAÏ",NULL},
/* 0E02 */ { "CARACTÈRE THAÏ KHO KHAÏ",NULL},
/* 0E03 */ { "CARACTÈRE THAÏ KHO KHOUAT",NULL},
/* 0E04 */ { "CARACTÈRE THAÏ KHO KHWAÏ",NULL},
/* 0E05 */ { "CARACTÈRE THAÏ KHO KHON",NULL},
/* 0E06 */ { "CARACTÈRE THAÏ KHO RAKHANG",NULL},
/* 0E07 */ { "CARACTÈRE THAÏ NGO NGOU",NULL},
/* 0E08 */ { "CARACTÈRE THAÏ TCHO TCHAN",NULL},
/* 0E09 */ { "CARACTÈRE THAÏ TCHO TCHING",NULL},
/* 0E0A */ { "CARACTÈRE THAÏ TCHO TCHANG",NULL},
/* 0E0B */ { "CARACTÈRE THAÏ SO SO",NULL},
/* 0E0C */ { "CARACTÈRE THAÏ TCHO TCHEU",NULL},
/* 0E0D */ { "CARACTÈRE THAÏ YO YING",NULL},
/* 0E0E */ { "CARACTÈRE THAÏ DO TCHADA",NULL},
/* 0E0F */ { "CARACTÈRE THAÏ TO PATAK",NULL},
/* 0E10 */ { "CARACTÈRE THAÏ THO THAN",NULL},
/* 0E11 */ { "CARACTÈRE THAÏ THO NANGMONTHO",NULL},
/* 0E12 */ { "CARACTÈRE THAÏ THO PHOUTHAO",NULL},
/* 0E13 */ { "CARACTÈRE THAÏ NO NÉN",NULL},
/* 0E14 */ { "CARACTÈRE THAÏ DO DEK",NULL},
/* 0E15 */ { "CARACTÈRE THAÏ TO TAO",NULL},
/* 0E16 */ { "CARACTÈRE THAÏ THO THOUNG",NULL},
/* 0E17 */ { "CARACTÈRE THAÏ THO THAHAN",NULL},
/* 0E18 */ { "CARACTÈRE THAÏ THO THONG",NULL},
/* 0E19 */ { "CARACTÈRE THAÏ NO NOU",NULL},
/* 0E1A */ { "CARACTÈRE THAÏ BO BAÏMAÏ",NULL},
/* 0E1B */ { "CARACTÈRE THAÏ PO PLA",NULL},
/* 0E1C */ { "CARACTÈRE THAÏ PHO PHUNG",NULL},
/* 0E1D */ { "CARACTÈRE THAÏ FO FA",NULL},
/* 0E1E */ { "CARACTÈRE THAÏ PHO PHAN",NULL},
/* 0E1F */ { "CARACTÈRE THAÏ FO FAN",NULL},
/* 0E20 */ { "CARACTÈRE THAÏ PHO SAMPHAO",NULL},
/* 0E21 */ { "CARACTÈRE THAÏ MO MA",NULL},
/* 0E22 */ { "CARACTÈRE THAÏ YO YAK",NULL},
/* 0E23 */ { "CARACTÈRE THAÏ RO RUA",NULL},
/* 0E24 */ { "CARACTÈRE THAÏ RU","	* voyelle indépendante utilisée pour l'écriture en sanskrit"},
/* 0E25 */ { "CARACTÈRE THAÏ LO LING",NULL},
/* 0E26 */ { "CARACTÈRE THAÏ LU","	* voyelle indépendante utilisée pour l'écriture en sanskrit"},
/* 0E27 */ { "CARACTÈRE THAÏ WO WÈN",NULL},
/* 0E28 */ { "CARACTÈRE THAÏ SO SALA",NULL},
/* 0E29 */ { "CARACTÈRE THAÏ SO RUSI",NULL},
/* 0E2A */ { "CARACTÈRE THAÏ SO SUA",NULL},
/* 0E2B */ { "CARACTÈRE THAÏ HO HIP",NULL},
/* 0E2C */ { "CARACTÈRE THAÏ LO TCHOULA",NULL},
/* 0E2D */ { "CARACTÈRE THAÏ O ANG",NULL},
/* 0E2E */ { "CARACTÈRE THAÏ HO NOKHOUK","	= ho nok houk"},
/* 0E2F */ { "CARACTÈRE THAÏ PAÏYANNOÏ","	= païyan noï\n"
	"	* points de suspension, abréviation"},
/* 0E30 */ { "CARACTÈRE THAÏ SARA A",NULL},
/* 0E31 */ { "CARACTÈRE THAÏ MAÏ HAN-AKAT",NULL},
/* 0E32 */ { "CARACTÈRE THAÏ SARA Â","	x (caractère thaï lakkhangyao - 0E45)"},
/* 0E33 */ { "CARACTÈRE THAÏ SARA AM","	# 0E4D 0E32"},
/* 0E34 */ { "CARACTÈRE THAÏ SARA I",NULL},
/* 0E35 */ { "CARACTÈRE THAÏ SARA Î",NULL},
/* 0E36 */ { "CARACTÈRE THAÏ SARA U",NULL},
/* 0E37 */ { "CARACTÈRE THAÏ SARA Û","	= sara oûé"},
/* 0E38 */ { "CARACTÈRE THAÏ SARA OU",NULL},
/* 0E39 */ { "CARACTÈRE THAÏ SARA OÛ",NULL},
/* 0E3A */ { "CARACTÈRE THAÏ PHINTHOU","	* virâma pali"},
/* 0E3B */ { NULL,NULL},
/* 0E3C */ { NULL,NULL},
/* 0E3D */ { NULL,NULL},
/* 0E3E */ { NULL,NULL},
/* 0E3F */ { "SYMBOLE MONÉTAIRE THAÏ BAHT",NULL},
/* 0E40 */ { "CARACTÈRE THAÏ SARA É",NULL},
/* 0E41 */ { "CARACTÈRE THAÏ SARA È",NULL},
/* 0E42 */ { "CARACTÈRE THAÏ SARA O",NULL},
/* 0E43 */ { "CARACTÈRE THAÏ SARA AÏ MAÏMOUAN","	= sara aï maï mouan"},
/* 0E44 */ { "CARACTÈRE THAÏ SARA AÏ MAÏMALAÏ","	= sara aï maï malaï"},
/* 0E45 */ { "CARACTÈRE THAÏ LAKKHANGYAO","	= lakkhang yao\n"
	"	* indication de longueur de voyelle particulière utilisée avec 0E24 ou 0E26\n"
	"	x (caractère thaï sara â - 0E32)"},
/* 0E46 */ { "CARACTÈRE THAÏ MAÏYAMOK","	= maï yamok\n"
	"	* répétition"},
/* 0E47 */ { "CARACTÈRE THAÏ MAÏTAÏKHOU","	= maï taïkhou"},
/* 0E48 */ { "CARACTÈRE THAÏ MAÏ EK",NULL},
/* 0E49 */ { "CARACTÈRE THAÏ MAÏ THO",NULL},
/* 0E4A */ { "CARACTÈRE THAÏ MAÏ TRI",NULL},
/* 0E4B */ { "CARACTÈRE THAÏ MAÏ TCHATTAWA",NULL},
/* 0E4C */ { "CARACTÈRE THAÏ THANTHAKHAT","	* signe d'annulation\n"
	"	x (diacritique khmer toandakhiat - 17CD)"},
/* 0E4D */ { "CARACTÈRE THAÏ NIKHAHIT","	= nikkhahit\n"
	"	* nasale finale"},
/* 0E4E */ { "CARACTÈRE THAÏ YAMAKKAN",NULL},
/* 0E4F */ { "CARACTÈRE THAÏ FONGMAN","	* utilisé comme puce\n"
	"	x (signe khmer phnèk moen - 17D9)"},
/* 0E50 */ { "CHIFFRE THAÏ ZÉRO",NULL},
/* 0E51 */ { "CHIFFRE THAÏ UN",NULL},
/* 0E52 */ { "CHIFFRE THAÏ DEUX",NULL},
/* 0E53 */ { "CHIFFRE THAÏ TROIS",NULL},
/* 0E54 */ { "CHIFFRE THAÏ QUATRE",NULL},
/* 0E55 */ { "CHIFFRE THAÏ CINQ",NULL},
/* 0E56 */ { "CHIFFRE THAÏ SIX",NULL},
/* 0E57 */ { "CHIFFRE THAÏ SEPT",NULL},
/* 0E58 */ { "CHIFFRE THAÏ HUIT",NULL},
/* 0E59 */ { "CHIFFRE THAÏ NEUF",NULL},
/* 0E5A */ { "CARACTÈRE THAÏ ANGKHANKHOU","	* s'utilise pour indiquer la fin de longues sections\n"
	"	* s'utilise avec 0E30 pour indiquer la fin d'un vers"},
/* 0E5B */ { "CARACTÈRE THAÏ KHOMOUT","	* s'utilise pour indiquer la fin d'un chapitre ou d'un document\n"
	"	x (signe khmer koomoût - 17DA)"},
/* 0E5C */ { NULL,NULL},
/* 0E5D */ { NULL,NULL},
/* 0E5E */ { NULL,NULL},
/* 0E5F */ { NULL,NULL},
/* 0E60 */ { NULL,NULL},
/* 0E61 */ { NULL,NULL},
/* 0E62 */ { NULL,NULL},
/* 0E63 */ { NULL,NULL},
/* 0E64 */ { NULL,NULL},
/* 0E65 */ { NULL,NULL},
/* 0E66 */ { NULL,NULL},
/* 0E67 */ { NULL,NULL},
/* 0E68 */ { NULL,NULL},
/* 0E69 */ { NULL,NULL},
/* 0E6A */ { NULL,NULL},
/* 0E6B */ { NULL,NULL},
/* 0E6C */ { NULL,NULL},
/* 0E6D */ { NULL,NULL},
/* 0E6E */ { NULL,NULL},
/* 0E6F */ { NULL,NULL},
/* 0E70 */ { NULL,NULL},
/* 0E71 */ { NULL,NULL},
/* 0E72 */ { NULL,NULL},
/* 0E73 */ { NULL,NULL},
/* 0E74 */ { NULL,NULL},
/* 0E75 */ { NULL,NULL},
/* 0E76 */ { NULL,NULL},
/* 0E77 */ { NULL,NULL},
/* 0E78 */ { NULL,NULL},
/* 0E79 */ { NULL,NULL},
/* 0E7A */ { NULL,NULL},
/* 0E7B */ { NULL,NULL},
/* 0E7C */ { NULL,NULL},
/* 0E7D */ { NULL,NULL},
/* 0E7E */ { NULL,NULL},
/* 0E7F */ { NULL,NULL},
/* 0E80 */ { NULL,NULL},
/* 0E81 */ { "LETTRE LAOTIENNE KO","	= ko kay"},
/* 0E82 */ { "LETTRE LAOTIENNE KHO SOUNG","	= kho khay"},
/* 0E83 */ { NULL,NULL},
/* 0E84 */ { "LETTRE LAOTIENNE KHO TAM","	= kho khouay"},
/* 0E85 */ { NULL,NULL},
/* 0E86 */ { NULL,NULL},
/* 0E87 */ { "LETTRE LAOTIENNE NGO","	= ngo ngou, ngo ngoua"},
/* 0E88 */ { "LETTRE LAOTIENNE TCHO","	= co cok, co tchoua"},
/* 0E89 */ { NULL,NULL},
/* 0E8A */ { "LETTRE LAOTIENNE SO TAM","	= so sang"},
/* 0E8B */ { NULL,NULL},
/* 0E8C */ { NULL,NULL},
/* 0E8D */ { "LETTRE LAOTIENNE ÑO","	= nyo nyoung"},
/* 0E8E */ { NULL,NULL},
/* 0E8F */ { NULL,NULL},
/* 0E90 */ { NULL,NULL},
/* 0E91 */ { NULL,NULL},
/* 0E92 */ { NULL,NULL},
/* 0E93 */ { NULL,NULL},
/* 0E94 */ { "LETTRE LAOTIENNE DO","	= do dek"},
/* 0E95 */ { "LETTRE LAOTIENNE TO","	= to ta"},
/* 0E96 */ { "LETTRE LAOTIENNE THO SOUNG","	= tho thong"},
/* 0E97 */ { "LETTRE LAOTIENNE THO TAM","	= tho thoung"},
/* 0E98 */ { NULL,NULL},
/* 0E99 */ { "LETTRE LAOTIENNE NO","	= no nok"},
/* 0E9A */ { "LETTRE LAOTIENNE BO","	= bo be, bo bet"},
/* 0E9B */ { "LETTRE LAOTIENNE PO","	= po pa"},
/* 0E9C */ { "LETTRE LAOTIENNE PHO SOUNG","	= pho pheng"},
/* 0E9D */ { "LETTRE LAOTIENNE FO SOUNG","	= fo fa\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 0E9E */ { "LETTRE LAOTIENNE PHO TAM","	= pho phou"},
/* 0E9F */ { "LETTRE LAOTIENNE FO TAM","	= fo fay\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 0EA0 */ { NULL,NULL},
/* 0EA1 */ { "LETTRE LAOTIENNE MO","	= mo mew, mo ma"},
/* 0EA2 */ { "LETTRE LAOTIENNE YO","	= yo ya"},
/* 0EA3 */ { "LETTRE LAOTIENNE LO LÔT","	= ro rot\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 0EA4 */ { NULL,NULL},
/* 0EA5 */ { "LETTRE LAOTIENNE LO LING","	= lo\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 0EA6 */ { NULL,NULL},
/* 0EA7 */ { "LETTRE LAOTIENNE WO","	= wo wi"},
/* 0EA8 */ { NULL,NULL},
/* 0EA9 */ { NULL,NULL},
/* 0EAA */ { "LETTRE LAOTIENNE SO SOUNG","	= so sya"},
/* 0EAB */ { "LETTRE LAOTIENNE HO SOUNG","	= ho hay, ho han"},
/* 0EAC */ { NULL,NULL},
/* 0EAD */ { "LETTRE LAOTIENNE O","	= o o"},
/* 0EAE */ { "LETTRE LAOTIENNE HO TAM","	= ho hya, ho hyan"},
/* 0EAF */ { "POINTS DE SUSPENSION LAOTIENS",NULL},
/* 0EB0 */ { "DIACRITIQUE VOYELLE LAOTIENNE A",NULL},
/* 0EB1 */ { "DIACRITIQUE VOYELLE LAOTIENNE MAÏ KAN","	* écourte la voyelle"},
/* 0EB2 */ { "DIACRITIQUE VOYELLE LAOTIENNE Â",NULL},
/* 0EB3 */ { "DIACRITIQUE VOYELLE LAOTIENNE AM","	# 0ECD 0EB2"},
/* 0EB4 */ { "DIACRITIQUE VOYELLE LAOTIENNE I",NULL},
/* 0EB5 */ { "DIACRITIQUE VOYELLE LAOTIENNE Î",NULL},
/* 0EB6 */ { "DIACRITIQUE VOYELLE LAOTIENNE U",NULL},
/* 0EB7 */ { "DIACRITIQUE VOYELLE LAOTIENNE Û",NULL},
/* 0EB8 */ { "DIACRITIQUE VOYELLE LAOTIENNE OU",NULL},
/* 0EB9 */ { "DIACRITIQUE VOYELLE LAOTIENNE OÛ",NULL},
/* 0EBA */ { NULL,NULL},
/* 0EBB */ { "DIACRITIQUE VOYELLE LAOTIENNE MAÏ KON","	= maï kong"},
/* 0EBC */ { "DIACRITIQUE SEMI-VOYELLE LAOTIENNE LO",NULL},
/* 0EBD */ { "DIACRITIQUE SEMI-VOYELLE LAOTIENNE ÑO","	= nyo fyang"},
/* 0EBE */ { NULL,NULL},
/* 0EBF */ { NULL,NULL},
/* 0EC0 */ { "DIACRITIQUE VOYELLE LAOTIENNE É",NULL},
/* 0EC1 */ { "DIACRITIQUE VOYELLE LAOTIENNE Ê",NULL},
/* 0EC2 */ { "DIACRITIQUE VOYELLE LAOTIENNE O",NULL},
/* 0EC3 */ { "DIACRITIQUE VOYELLE LAOTIENNE AY","	= maï mouan"},
/* 0EC4 */ { "DIACRITIQUE VOYELLE LAOTIENNE AÏ","	= maï may"},
/* 0EC5 */ { NULL,NULL},
/* 0EC6 */ { "KO LA LAOTIEN","	* répétition"},
/* 0EC7 */ { NULL,NULL},
/* 0EC8 */ { "DIACRITIQUE TON LAOTIEN MAÏ EK",NULL},
/* 0EC9 */ { "DIACRITIQUE TON LAOTIEN MAÏ THO",NULL},
/* 0ECA */ { "DIACRITIQUE TON LAOTIEN MAÏ TI",NULL},
/* 0ECB */ { "DIACRITIQUE TON LAOTIEN MAÏ TCHATAWA",NULL},
/* 0ECC */ { "DIACRITIQUE LAOTIEN D'ANNULATION",NULL},
/* 0ECD */ { "DIACRITIQUE LAOTIEN NIGGAHITA","	* nasale finale ou longue voyelle o (ô)"},
/* 0ECE */ { NULL,NULL},
/* 0ECF */ { NULL,NULL},
/* 0ED0 */ { "CHIFFRE LAOTIEN ZÉRO",NULL},
/* 0ED1 */ { "CHIFFRE LAOTIEN UN",NULL},
/* 0ED2 */ { "CHIFFRE LAOTIEN DEUX",NULL},
/* 0ED3 */ { "CHIFFRE LAOTIEN TROIS",NULL},
/* 0ED4 */ { "CHIFFRE LAOTIEN QUATRE",NULL},
/* 0ED5 */ { "CHIFFRE LAOTIEN CINQ",NULL},
/* 0ED6 */ { "CHIFFRE LAOTIEN SIX",NULL},
/* 0ED7 */ { "CHIFFRE LAOTIEN SEPT",NULL},
/* 0ED8 */ { "CHIFFRE LAOTIEN HUIT",NULL},
/* 0ED9 */ { "CHIFFRE LAOTIEN NEUF",NULL},
/* 0EDA */ { NULL,NULL},
/* 0EDB */ { NULL,NULL},
/* 0EDC */ { "HO NO LAOTIEN","	# 0EAB 0E99"},
/* 0EDD */ { "HO MO LAOTIEN","	# 0EAB 0EA1"},
/* 0EDE */ { "LETTRE LAOTIENNE KHMOU GO",NULL},
/* 0EDF */ { "LETTRE LAOTIENNE KHMOU ÑO",NULL},
/* 0EE0 */ { NULL,NULL},
/* 0EE1 */ { NULL,NULL},
/* 0EE2 */ { NULL,NULL},
/* 0EE3 */ { NULL,NULL},
/* 0EE4 */ { NULL,NULL},
/* 0EE5 */ { NULL,NULL},
/* 0EE6 */ { NULL,NULL},
/* 0EE7 */ { NULL,NULL},
/* 0EE8 */ { NULL,NULL},
/* 0EE9 */ { NULL,NULL},
/* 0EEA */ { NULL,NULL},
/* 0EEB */ { NULL,NULL},
/* 0EEC */ { NULL,NULL},
/* 0EED */ { NULL,NULL},
/* 0EEE */ { NULL,NULL},
/* 0EEF */ { NULL,NULL},
/* 0EF0 */ { NULL,NULL},
/* 0EF1 */ { NULL,NULL},
/* 0EF2 */ { NULL,NULL},
/* 0EF3 */ { NULL,NULL},
/* 0EF4 */ { NULL,NULL},
/* 0EF5 */ { NULL,NULL},
/* 0EF6 */ { NULL,NULL},
/* 0EF7 */ { NULL,NULL},
/* 0EF8 */ { NULL,NULL},
/* 0EF9 */ { NULL,NULL},
/* 0EFA */ { NULL,NULL},
/* 0EFB */ { NULL,NULL},
/* 0EFC */ { NULL,NULL},
/* 0EFD */ { NULL,NULL},
/* 0EFE */ { NULL,NULL},
/* 0EFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_0F[] = {
/* 0F00 */ { "SYLLABE TIBÉTAINE OM",NULL},
/* 0F01 */ { "SIGNE TIBÉTAIN GTER YIG MGO A TRONQUÉ","	= ter yik go a t'oung"},
/* 0F02 */ { "SIGNE TIBÉTAIN GTER YIG MGO 'UM RNAM BCAD MA","	= ter yik go woum nam tché ma"},
/* 0F03 */ { "SIGNE TIBÉTAIN GTER YIG MGO 'UM GTER TSHEG MA","	= ter yik go woum ter ts'ék ma"},
/* 0F04 */ { "SIGNE TIBÉTAIN YIG MGO MDUN MA OUVRANT","	= yik go dun ma\n"
	"	* honorifique ; indique le début du texte ou d'un nouveau feuillet\n"
	"	x (birga mongol - 1800)"},
/* 0F05 */ { "SIGNE TIBÉTAIN YIG MGO SGAB MA FERMANT","	= yik go kab ma\n"
	"	* suit et se lie au yik-go initial (ouvrant)"},
/* 0F06 */ { "SIGNE TIBÉTAIN D'INSERTION YIG MGO PHUR SHAD MA","	= yik go p'our ché ma"},
/* 0F07 */ { "SIGNE TIBÉTAIN YIG MGO TSHEG SHAD MA","	= yik go ts'ék chè ma"},
/* 0F08 */ { "SIGNE TIBÉTAIN SBRUL SHAD","	= trul chè\n"
	"	* signale le début d'un sujet"},
/* 0F09 */ { "SIGNE TIBÉTAIN BSKUR YIG MGO","	= kour yik go\n"
	"	* énumérateur de liste, s'utilise au Bhoutan"},
/* 0F0A */ { "FIORITURE TIBÉTAINE DE PÉTITION HONORIFIQUE","	= z'ou yik gui go\n"
	"	* s'utilise au Bhoutan quand un inférieur s'adresse à un supérieur\n"
	"	* le nom anglais est incorrect, il se réfère à 0FD0 qui s'utilise dans la situation inverse"},
/* 0F0B */ { "SIGNE TIBÉTAIN TSHEG","	= ts'ék\n"
	"	* délimiteur de morphèmes, séparateur de syllabes (sens approximatif)\n"
	"	* le ts'ék habituel, qui indique une position sécable\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 0F0C */ { "SIGNE TIBÉTAIN TSHEG INSÉCABLE","	* variante insécable du signe 0F0B, qui s'utilise exclusivement entre 0F44 et 0F0D\n"
	"	* l'appellation anglaise de ce caractère est erronée\n"
	"	# <insécable> 0F0B"},
/* 0F0D */ { "SIGNE TIBÉTAIN SHAD","	= ché\n"
	"	* marque la fin d'une section dans un texte\n"
	"	x (danda dévanâgarî - 0964)"},
/* 0F0E */ { "SIGNE TIBÉTAIN ÑIS SHAD","	= double ché\n"
	"	* marque la fin d'un sujet complet (don-tchan)\n"
	"	x (double danda dévanâgarî - 0965)"},
/* 0F0F */ { "SIGNE TIBÉTAIN TSHEG SHAD","	= ts'ék ché"},
/* 0F10 */ { "SIGNE TIBÉTAIN ÑIS TSHEG SHAD","	= ñi ts'ék ché"},
/* 0F11 */ { "SIGNE TIBÉTAIN RIN CHEN SPUNGS SHAD","	= rine tch'ène poung ché\n"
	"	* ché qui suit un ts'ék tar qui commence une nouvelle ligne"},
/* 0F12 */ { "SIGNE TIBÉTAIN RGYA GRAM SHAD","	= gya tram ché"},
/* 0F13 */ { "SIGNE TIBÉTAIN D'INSERTION DZUD RTAGS ME LONG TCHAN","	= dzu ta mé long tchène"},
/* 0F14 */ { "SIGNE TIBÉTAIN GTER TSHEG","	= ter ts'ék\n"
	"	* délimiteur proche de la virgule\n"
	"	x (signe khmer tchamnotch pii koûh - 17D6)"},
/* 0F15 */ { "LOGOTYPE TIBETAIN CHAD RTAGS","	= tch'é ta"},
/* 0F16 */ { "LOGOTYPE TIBÉTAIN LHAG RTAGS","	= hlak ta"},
/* 0F17 */ { "SIGNE TIBÉTAIN ASTROLOGIQUE SGRA GCAN 'CHAR RTAGS","	= tra tchène tch'ar ta"},
/* 0F18 */ { "DIACRITIQUE TIBÉTAIN ASTROLOGIQUE 'KHYUD PA","	= kyu pa\n"
	"	* se combine avec les chiffres"},
/* 0F19 */ { "DIACRITIQUE TIBÉTAIN ASTROLOGIQUE SDONG TSHUGS","	= dong tsou\n"
	"	* se combine avec les chiffres"},
/* 0F1A */ { "SIGNE TIBÉTAIN UNE PIERRE BLANCHE","	= dé ka tchig"},
/* 0F1B */ { "SIGNE TIBÉTAIN DEUX PIERRES BLANCHES","	= dé ka ñi"},
/* 0F1C */ { "SIGNE TIBÉTAIN TROIS PIERRES BLANCHES","	= dé ka soum\n"
	"	x (symbole alchimique de l'huile - 1F746)"},
/* 0F1D */ { "SIGNE TIBÉTAIN UNE PIERRE NOIRE","	= dé na tchig"},
/* 0F1E */ { "SIGNE TIBÉTAIN DEUX PIERRES NOIRES","	= dé na ñi"},
/* 0F1F */ { "SIGNE TIBÉTAIN UNE PIERRE BLANCHE ET UNE PIERRE NOIRE","	= dé ka dé na\n"
	"	x (signe tibétain une pierre noire et une pierre blanche - 0FCE)"},
/* 0F20 */ { "CHIFFRE TIBÉTAIN ZÉRO",NULL},
/* 0F21 */ { "CHIFFRE TIBÉTAIN UN",NULL},
/* 0F22 */ { "CHIFFRE TIBÉTAIN DEUX",NULL},
/* 0F23 */ { "CHIFFRE TIBÉTAIN TROIS",NULL},
/* 0F24 */ { "CHIFFRE TIBÉTAIN QUATRE",NULL},
/* 0F25 */ { "CHIFFRE TIBÉTAIN CINQ",NULL},
/* 0F26 */ { "CHIFFRE TIBÉTAIN SIX",NULL},
/* 0F27 */ { "CHIFFRE TIBÉTAIN SEPT",NULL},
/* 0F28 */ { "CHIFFRE TIBÉTAIN HUIT",NULL},
/* 0F29 */ { "CHIFFRE TIBÉTAIN NEUF",NULL},
/* 0F2A */ { "CHIFFRE TIBÉTAIN UN MOINS UN DEMI",NULL},
/* 0F2B */ { "CHIFFRE TIBÉTAIN DEUX MOINS UN DEMI",NULL},
/* 0F2C */ { "CHIFFRE TIBÉTAIN TROIS MOINS UN DEMI",NULL},
/* 0F2D */ { "CHIFFRE TIBÉTAIN QUATRE MOINS UN DEMI",NULL},
/* 0F2E */ { "CHIFFRE TIBÉTAIN CINQ MOINS UN DEMI",NULL},
/* 0F2F */ { "CHIFFRE TIBÉTAIN SIX MOINS UN DEMI",NULL},
/* 0F30 */ { "CHIFFRE TIBÉTAIN SEPT MOINS UN DEMI",NULL},
/* 0F31 */ { "CHIFFRE TIBÉTAIN HUIT MOINS UN DEMI",NULL},
/* 0F32 */ { "CHIFFRE TIBÉTAIN NEUF MOINS UN DEMI",NULL},
/* 0F33 */ { "CHIFFRE TIBÉTAIN ZÉRO MOINS UN DEMI",NULL},
/* 0F34 */ { "SIGNE TIBÉTAIN RÉPÉTITION","	= du ta\n"
	"	* répétition"},
/* 0F35 */ { "DIACRITIQUE TIBÉTAIN MISE EN EXERGUE HONORIFIQUE","	= ngé zoung ñi da\n"
	"	* honorifique, mise en exergue, correspond au soulignement"},
/* 0F36 */ { "SIGNE TIBÉTAIN D'INSERTION DE GLOSE","	= dzu ta chi mig tchène\n"
	"	* indique un point d'insertion de texte ou de glose"},
/* 0F37 */ { "DIACRITIQUE TIBÉTAIN MISE EN EXERGUE","	= ngé zoung gor ta\n"
	"	* mise en exergue, correspond au soulignement"},
/* 0F38 */ { "SIGNE TIBÉTAIN CHE MGO","	= tch'é go"},
/* 0F39 */ { "DIACRITIQUE TIBÉTAIN DE LÉNITION","	= tsa trou\n"
	"	* signe de lénition ou d'adoucissement"},
/* 0F3A */ { "SIGNE TIBÉTAIN GUG RTAGS GYON","	= goug ta yeun\n"
	"	* parenthèse ouvrante"},
/* 0F3B */ { "SIGNE TIBÉTAIN GUG RTAGS GYAS","	= goug ta yé\n"
	"	* parenthèse fermante"},
/* 0F3C */ { "SIGNE TIBÉTAIN ANG KHANG GYON","	= ang kang yeun\n"
	"	* parenthèse à toit ouvrante"},
/* 0F3D */ { "SIGNE TIBÉTAIN PARENTHÈSE À TOIT","	= ang kang yé\n"
	"	* parenthèse à toit fermante"},
/* 0F3E */ { "DIACRITIQUE TIBÉTAIN YAR TSHES","	= yar ts'é\n"
	"	* se combine avec les chiffres"},
/* 0F3F */ { "DIACRITIQUE TIBÉTAIN MAR TSHES","	= mar ts'é\n"
	"	* se combine avec les chiffres"},
/* 0F40 */ { "LETTRE TIBÉTAINE KA",NULL},
/* 0F41 */ { "LETTRE TIBÉTAINE KHA","	= lettre tibétaine k'a"},
/* 0F42 */ { "LETTRE TIBÉTAINE GA",NULL},
/* 0F43 */ { "LETTRE TIBÉTAINE GHA","	= lettre tibétaine gaha\n"
	"	: 0F42 0FB7"},
/* 0F44 */ { "LETTRE TIBÉTAINE NGA",NULL},
/* 0F45 */ { "LETTRE TIBÉTAINE CA","	= lettre tibétaine tcha"},
/* 0F46 */ { "LETTRE TIBÉTAINE CHA","	= lettre tibétaine tch'a"},
/* 0F47 */ { "LETTRE TIBÉTAINE JA","	= lettre tibétaine dja"},
/* 0F48 */ { NULL,NULL},
/* 0F49 */ { "LETTRE TIBÉTAINE ÑA",NULL},
/* 0F4A */ { "LETTRE TIBÉTAINE TTA",NULL},
/* 0F4B */ { "LETTRE TIBÉTAINE TTHA","	= lettre tibétaine tt'a"},
/* 0F4C */ { "LETTRE TIBÉTAINE DDA",NULL},
/* 0F4D */ { "LETTRE TIBÉTAINE DDHA","	= lettre tibétaine draha\n"
	"	: 0F4C 0FB7"},
/* 0F4E */ { "LETTRE TIBÉTAINE NNA",NULL},
/* 0F4F */ { "LETTRE TIBÉTAINE TA",NULL},
/* 0F50 */ { "LETTRE TIBÉTAINE THA","	= lettre tibétaine t'a"},
/* 0F51 */ { "LETTRE TIBÉTAINE DA","	= lettre tibétaine ta"},
/* 0F52 */ { "LETTRE TIBÉTAINE DHA","	= lettre tibétaine daha\n"
	"	: 0F51 0FB7"},
/* 0F53 */ { "LETTRE TIBÉTAINE NA",NULL},
/* 0F54 */ { "LETTRE TIBÉTAINE PA",NULL},
/* 0F55 */ { "LETTRE TIBÉTAINE PHA","	= lettre tibétaine p'a"},
/* 0F56 */ { "LETTRE TIBÉTAINE BA",NULL},
/* 0F57 */ { "LETTRE TIBÉTAINE BHA","	= lettre tibétaine baha\n"
	"	: 0F56 0FB7"},
/* 0F58 */ { "LETTRE TIBÉTAINE MA",NULL},
/* 0F59 */ { "LETTRE TIBÉTAINE TSA",NULL},
/* 0F5A */ { "LETTRE TIBÉTAINE TSHA","	= lettre tibétaine ts'a"},
/* 0F5B */ { "LETTRE TIBÉTAINE DZA",NULL},
/* 0F5C */ { "LETTRE TIBÉTAINE DZHA","	= lettre tibétaine dzaha\n"
	"	: 0F5B 0FB7"},
/* 0F5D */ { "LETTRE TIBÉTAINE WA","	= lettre tibétaine oua"},
/* 0F5E */ { "LETTRE TIBÉTAINE ZHA","	= lettre tibétaine z'a"},
/* 0F5F */ { "LETTRE TIBÉTAINE ZA","	= lettre tibétaine sa"},
/* 0F60 */ { "LETTRE TIBÉTAINE 'A",NULL},
/* 0F61 */ { "LETTRE TIBÉTAINE YA",NULL},
/* 0F62 */ { "LETTRE TIBÉTAINE RA","	* quand elle est suivie d'une lettre subjointe = ra go, ra suscrit"},
/* 0F63 */ { "LETTRE TIBÉTAINE LA",NULL},
/* 0F64 */ { "LETTRE TIBÉTAINE SHA","	= lettre tibétaine ça"},
/* 0F65 */ { "LETTRE TIBÉTAINE SSA","	= lettre tibétaine cha"},
/* 0F66 */ { "LETTRE TIBÉTAINE SA",NULL},
/* 0F67 */ { "LETTRE TIBÉTAINE HA",NULL},
/* 0F68 */ { "LETTRE TIBÉTAINE A","	* base pour des voyelles dépendantes"},
/* 0F69 */ { "LETTRE TIBÉTAINE KSSA","	= lettre tibétaine k'ya\n"
	"	: 0F40 0FB5"},
/* 0F6A */ { "LETTRE TIBÉTAINE RA À FORME FIXE","	* ne s'utilise que dans les translittérations et transcriptions\n"
	"	x (lettre tibétaine ra - 0F62)"},
/* 0F6B */ { "LETTRE TIBÉTAINE KKA",NULL},
/* 0F6C */ { "LETTRE TIBÉTAINE RRA",NULL},
/* 0F6D */ { NULL,NULL},
/* 0F6E */ { NULL,NULL},
/* 0F6F */ { NULL,NULL},
/* 0F70 */ { NULL,NULL},
/* 0F71 */ { "DIACRITIQUE VOYELLE TIBÉTAINE Â","	= a-tchoung\n"
	"	* commun, allongement de voyelle"},
/* 0F72 */ { "DIACRITIQUE VOYELLE TIBÉTAINE I",NULL},
/* 0F73 */ { "DIACRITIQUE VOYELLE TIBÉTAINE Î","	* l'utilisation de ce caractère est déconseillée\n"
	"	: 0F71 0F72"},
/* 0F74 */ { "DIACRITIQUE VOYELLE TIBÉTAINE OU",NULL},
/* 0F75 */ { "DIACRITIQUE VOYELLE TIBÉTAINE OÛ","	* l'utilisation de ce caractère est déconseillée\n"
	"	: 0F71 0F74"},
/* 0F76 */ { "DIACRITIQUE VOYELLE TIBÉTAINE R VOCALIQUE","	: 0FB2 0F80"},
/* 0F77 */ { "DIACRITIQUE VOYELLE TIBÉTAINE RR VOCALIQUE","	* ce caractère est obsolète et son utilisation est fortement déconseillée\n"
	"	# 0FB2 0F81"},
/* 0F78 */ { "DIACRITIQUE VOYELLE TIBÉTAINE L VOCALIQUE","	: 0FB3 0F80"},
/* 0F79 */ { "DIACRITIQUE VOYELLE TIBÉTAINE LL VOCALIQUE","	* ce caractère est obsolète et son utilisation est fortement déconseillée\n"
	"	# 0FB3 0F81"},
/* 0F7A */ { "DIACRITIQUE VOYELLE TIBÉTAINE É",NULL},
/* 0F7B */ { "DIACRITIQUE VOYELLE TIBÉTAINE Ê",NULL},
/* 0F7C */ { "DIACRITIQUE VOYELLE TIBÉTAINE O",NULL},
/* 0F7D */ { "DIACRITIQUE VOYELLE TIBÉTAINE Ô",NULL},
/* 0F7E */ { "DIACRITIQUE TIBÉTAIN RJES SO NGA RO","	= djé sou nga ro\n"
	"	= anusvara"},
/* 0F7F */ { "DIACRITIQUE TIBÉTAIN RNAM BCAD","	= nam tché\n"
	"	= visarga"},
/* 0F80 */ { "DIACRITIQUE VOYELLE TIBÉTAINE I RÉFLÉCHI",NULL},
/* 0F81 */ { "DIACRITIQUE VOYELLE TIBÉTAINE Î RÉFLÉCHI","	* l'utilisation de ce caractère est déconseillée\n"
	"	: 0F71 0F80"},
/* 0F82 */ { "DIACRITIQUE TIBÉTAIN ÑI ZLA NÂ DA","	= ñi da na da"},
/* 0F83 */ { "DIACRITIQUE TIBÉTAIN SNA LDAN","	= nan dé\n"
	"	x (diacritique dévanâgarî tchandrabindou - 0901)"},
/* 0F84 */ { "DIACRITIQUE TIBÉTAIN HALANTA","	= rok mé\n"
	"	x (diacritique dévanâgarî virâma - 094D)"},
/* 0F85 */ { "SIGNE TIBÉTAIN PALUTA","	= palouta\n"
	"	* translittération de l'avagraha sanskrit\n"
	"	x (signe dévanâgarî avagraha - 093D)"},
/* 0F86 */ { "DIACRITIQUE TIBÉTAIN LCI RTAGS","	= dji ta"},
/* 0F87 */ { "DIACRITIQUE TIBÉTAIN YANG RTAGS","	= yang ta"},
/* 0F88 */ { "SIGNE TIBÉTAIN LCE TSA CAN","	= tché tsa tchène\n"
	"	x (signe védique djihvamouliya - 1CF5)\n"
	"	x (lettre mongole damarou ali gali - 1882)"},
/* 0F89 */ { "SIGNE TIBÉTAIN MCHU CAN","	= tch'ou tchène\n"
	"	x (signe védique oupadhmaniya - 1CF6)\n"
	"	x (lettre mongole oubadama culbuté ali gali - 1884)"},
/* 0F8A */ { "SIGNE TIBÉTAIN GRU CAN RGYINGS","	= trou tchène guing\n"
	"	* toujours suivi de 0F82"},
/* 0F8B */ { "SIGNE TIBÉTAIN GRU MED RGYINGS","	= trou mé guing"},
/* 0F8C */ { "SIGNE TIBÉTAIN MCHU CAN CULBUTÉ","	x (lettre mongole oubadama ali gali - 1883)"},
/* 0F8D */ { "SIGNE SUBJOINT TIBÉTAIN LCE TSA CAN",NULL},
/* 0F8E */ { "SIGNE SUBJOINT TIBÉTAIN MCHU CAN",NULL},
/* 0F8F */ { "SIGNE SUBJOINT TIBÉTAIN MCHU CAN CULBUTÉ",NULL},
/* 0F90 */ { "LETTRE SUBJOINTE TIBÉTAINE KA",NULL},
/* 0F91 */ { "LETTRE SUBJOINTE TIBÉTAINE KHA","	= k'a subjoint"},
/* 0F92 */ { "LETTRE SUBJOINTE TIBÉTAINE GA",NULL},
/* 0F93 */ { "LETTRE SUBJOINTE TIBÉTAINE GHA","	= gaha subjoint\n"
	"	: 0F92 0FB7"},
/* 0F94 */ { "LETTRE SUBJOINTE TIBÉTAINE NGA",NULL},
/* 0F95 */ { "LETTRE SUBJOINTE TIBÉTAINE CA","	= tcha subjoint"},
/* 0F96 */ { "LETTRE SUBJOINTE TIBÉTAINE CHA","	= tch'a subjoint"},
/* 0F97 */ { "LETTRE SUBJOINTE TIBÉTAINE JA","	= dja subjoint"},
/* 0F98 */ { NULL,NULL},
/* 0F99 */ { "LETTRE SUBJOINTE TIBÉTAINE ÑA","	= ña subjoint"},
/* 0F9A */ { "LETTRE SUBJOINTE TIBÉTAINE TTA",NULL},
/* 0F9B */ { "LETTRE SUBJOINTE TIBÉTAINE TTHA",NULL},
/* 0F9C */ { "LETTRE SUBJOINTE TIBÉTAINE DDA",NULL},
/* 0F9D */ { "LETTRE SUBJOINTE TIBÉTAINE DDHA","	= draha subjoint\n"
	"	: 0F9C 0FB7"},
/* 0F9E */ { "LETTRE SUBJOINTE TIBÉTAINE NNA",NULL},
/* 0F9F */ { "LETTRE SUBJOINTE TIBÉTAINE TA",NULL},
/* 0FA0 */ { "LETTRE SUBJOINTE TIBÉTAINE THA","	= t'a subjoint"},
/* 0FA1 */ { "LETTRE SUBJOINTE TIBÉTAINE DA",NULL},
/* 0FA2 */ { "LETTRE SUBJOINTE TIBÉTAINE DHA","	= daha subjoint\n"
	"	: 0FA1 0FB7"},
/* 0FA3 */ { "LETTRE SUBJOINTE TIBÉTAINE NA",NULL},
/* 0FA4 */ { "LETTRE SUBJOINTE TIBÉTAINE PA",NULL},
/* 0FA5 */ { "LETTRE SUBJOINTE TIBÉTAINE PHA","	= p'a subjoint"},
/* 0FA6 */ { "LETTRE SUBJOINTE TIBÉTAINE BA",NULL},
/* 0FA7 */ { "LETTRE SUBJOINTE TIBÉTAINE BHA","	= baha subjoint\n"
	"	: 0FA6 0FB7"},
/* 0FA8 */ { "LETTRE SUBJOINTE TIBÉTAINE MA",NULL},
/* 0FA9 */ { "LETTRE SUBJOINTE TIBÉTAINE TSA",NULL},
/* 0FAA */ { "LETTRE SUBJOINTE TIBÉTAINE TSHA","	= ts'a subjoint"},
/* 0FAB */ { "LETTRE SUBJOINTE TIBÉTAINE DZA",NULL},
/* 0FAC */ { "LETTRE SUBJOINTE TIBÉTAINE DZHA","	= dzaha subjoint\n"
	"	: 0FAB 0FB7"},
/* 0FAD */ { "LETTRE SUBJOINTE TIBÉTAINE OUA","	= oua subjoint, oua sour"},
/* 0FAE */ { "LETTRE SUBJOINTE TIBÉTAINE ZHA","	= z'a subjoint"},
/* 0FAF */ { "LETTRE SUBJOINTE TIBÉTAINE ZA",NULL},
/* 0FB0 */ { "LETTRE SUBJOINTE TIBÉTAINE 'A","	* rare, s'utilise uniquement avec une lettre subjointe de pleine taille\n"
	"	x (diacritique voyelle tibétaine â - 0F71)"},
/* 0FB1 */ { "LETTRE SUBJOINTE TIBÉTAINE YA","	= ya-btags, ya ta"},
/* 0FB2 */ { "LETTRE SUBJOINTE TIBÉTAINE RA","	= ra-btags, ra ta"},
/* 0FB3 */ { "LETTRE SUBJOINTE TIBÉTAINE LA",NULL},
/* 0FB4 */ { "LETTRE SUBJOINTE TIBÉTAINE SHA","	= ça subjoint"},
/* 0FB5 */ { "LETTRE SUBJOINTE TIBÉTAINE SSA","	= cha subjoint"},
/* 0FB6 */ { "LETTRE SUBJOINTE TIBÉTAINE SA",NULL},
/* 0FB7 */ { "LETTRE SUBJOINTE TIBÉTAINE HA",NULL},
/* 0FB8 */ { "LETTRE SUBJOINTE TIBÉTAINE A",NULL},
/* 0FB9 */ { "LETTRE SUBJOINTE TIBÉTAINE KSSA","	= k'ya subjoint\n"
	"	: 0F90 0FB5"},
/* 0FBA */ { "LETTRE SUBJOINTE TIBÉTAINE WA À FORME FIXE","	= oua subjoint à forme fixe"},
/* 0FBB */ { "LETTRE SUBJOINTE TIBÉTAINE YA À FORME FIXE",NULL},
/* 0FBC */ { "LETTRE SUBJOINTE TIBÉTAINE RA À FORME FIXE",NULL},
/* 0FBD */ { NULL,NULL},
/* 0FBE */ { "SIGNE TIBÉTAIN KU RU KHA","	= kourouk'a\n"
	"	* souvent répété trois fois, indique un refrain"},
/* 0FBF */ { "SIGNE TIBÉTAIN KU RU KHA BZHI MIG CAN","	= kourouk'a chi mik tchène\n"
	"	* indique un point d'insertion de texte ou de glose\n"
	"	x (marque de référence - 203B)"},
/* 0FC0 */ { "SIGNE TIBÉTAIN DE CANTILLATION TEMPS FORT","	* marque un fort coup de tambour"},
/* 0FC1 */ { "SIGNE TIBÉTAIN DE CANTILLATION TEMPS FAIBLE","	* marque un léger coup de tambour"},
/* 0FC2 */ { "SIGNE TIBÉTAIN DE CANTILLATION TAMBOURIN","	= tchang tyou\n"
	"	* symbole du petit tambour à main tibétain"},
/* 0FC3 */ { "SIGNE TIBÉTAIN DE CANTILLATION CYMBALE","	= boub tché\n"
	"	* symbole de la cymbale tibétaine"},
/* 0FC4 */ { "SYMBOLE TIBÉTAIN CLOCHETTE","	= drilbou\n"
	"	* symbole de la clochette tibétaine\n"
	"	x (cloche - 1F514)"},
/* 0FC5 */ { "SYMBOLE TIBÉTAIN RDO RJE","	= dordjé"},
/* 0FC6 */ { "SYMBOLE TIBÉTAIN PADMA GDAN","	= pé ma dène"},
/* 0FC7 */ { "SYMBOLE TIBÉTAIN RDO RJE RGYA GRAM","	= dordjé gya dram"},
/* 0FC8 */ { "SYMBOLE TIBÉTAIN PHUR PA","	= p'ourba"},
/* 0FC9 */ { "SYMBOLE TIBÉTAIN NOR BU","	= norbou"},
/* 0FCA */ { "SYMBOLE TIBÉTAIN DOUBLE CORPS","	= norbou ñi khyi\n"
	"	* symbole du double corps\n"
	"	x (yin et yang - 262F)"},
/* 0FCB */ { "SYMBOLE TIBÉTAIN TRIPLE CORPS","	= norbou soum khyi\n"
	"	* le tri-kaya ou symbole du triple corps"},
/* 0FCC */ { "SYMBOLE TIBÉTAIN QUADRUPLE CORPS","	= norbou chi khyi\n"
	"	* symbole du corps quadruple, une forme de svastika\n"
	"	x (svastika lévogyre - 0FD6)"},
/* 0FCD */ { NULL,NULL},
/* 0FCE */ { "SIGNE TIBÉTAIN UNE PIERRE NOIRE ET UNE PIERRE BLANCHE","	= déna déka\n"
	"	* signifie « mauvaise fortune hier, bonne fortune demain »\n"
	"	x (signe tibétain une pierre blanche et une pierre noire - 0F1F)"},
/* 0FCF */ { "SIGNE TIBÉTAIN TROIS PIERRES NOIRES","	= dé na soum"},
/* 0FD0 */ { "FIORITURE TIBÉTAINE POUR DONNER UN ORDRE","	= ka cho gi go guien\n"
	"	* en usage au Bhoutan quand un supérieur s'adresse à un inférieur\n"
	"	* il y a une erreur dans le nom anglais de ce caractère"},
/* 0FD1 */ { "FIORITURE TIBÉTAINE POUR S'ADRESSER À UN ÉGAL","	= nyam yik gi go guien\n"
	"	* en usage au Bhoutan quand on s'adresse à un égal"},
/* 0FD2 */ { "SIGNE TIBÉTAIN ÑIS TSHEG","	= ñi ts'ék"},
/* 0FD3 */ { "SIGNE TIBÉTAIN YIG MGO MDUN MA OUVRANT ARCHAÏQUE","	= da ñing yik go dun ma"},
/* 0FD4 */ { "SIGNE TIBÉTAIN YIG MGO SGAB MA FERMANT ARCHAÏQUE","	= da ñing yik go kab ma"},
/* 0FD5 */ { "SVASTIKA DEXTROGYRE","	= gyung drung nang 'khor\n"
	"	* en Inde, symbole de la bonne fortune et du bien-être\n"
	"	x 5350"},
/* 0FD6 */ { "SVASTIKA LÉVOGYRE","	= gyung drung phyi 'khor\n"
	"	x 534D"},
/* 0FD7 */ { "SVASTIKA DEXTROGYRE AVEC POINTS","	= gyung drung nang 'khor bzhi mig can"},
/* 0FD8 */ { "SVASTIKA LÉVOGYRE AVEC POINTS","	= gyung drung phyi 'khor bzhi mig can"},
/* 0FD9 */ { "SIGNE TIBÉTAIN INITIAL MCHAN RTAGS",NULL},
/* 0FDA */ { "SIGNE TIBÉTAIN FINAL MCHAN RTAGS",NULL},
/* 0FDB */ { NULL,NULL},
/* 0FDC */ { NULL,NULL},
/* 0FDD */ { NULL,NULL},
/* 0FDE */ { NULL,NULL},
/* 0FDF */ { NULL,NULL},
/* 0FE0 */ { NULL,NULL},
/* 0FE1 */ { NULL,NULL},
/* 0FE2 */ { NULL,NULL},
/* 0FE3 */ { NULL,NULL},
/* 0FE4 */ { NULL,NULL},
/* 0FE5 */ { NULL,NULL},
/* 0FE6 */ { NULL,NULL},
/* 0FE7 */ { NULL,NULL},
/* 0FE8 */ { NULL,NULL},
/* 0FE9 */ { NULL,NULL},
/* 0FEA */ { NULL,NULL},
/* 0FEB */ { NULL,NULL},
/* 0FEC */ { NULL,NULL},
/* 0FED */ { NULL,NULL},
/* 0FEE */ { NULL,NULL},
/* 0FEF */ { NULL,NULL},
/* 0FF0 */ { NULL,NULL},
/* 0FF1 */ { NULL,NULL},
/* 0FF2 */ { NULL,NULL},
/* 0FF3 */ { NULL,NULL},
/* 0FF4 */ { NULL,NULL},
/* 0FF5 */ { NULL,NULL},
/* 0FF6 */ { NULL,NULL},
/* 0FF7 */ { NULL,NULL},
/* 0FF8 */ { NULL,NULL},
/* 0FF9 */ { NULL,NULL},
/* 0FFA */ { NULL,NULL},
/* 0FFB */ { NULL,NULL},
/* 0FFC */ { NULL,NULL},
/* 0FFD */ { NULL,NULL},
/* 0FFE */ { NULL,NULL},
/* 0FFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_10[] = {
/* 1000 */ { "LETTRE BIRMANE KA","	~ 1000 FE00 forme pointée"},
/* 1001 */ { "LETTRE BIRMANE KHA",NULL},
/* 1002 */ { "LETTRE BIRMANE GA","	~ 1002 FE00 forme pointée"},
/* 1003 */ { "LETTRE BIRMANE GHA",NULL},
/* 1004 */ { "LETTRE BIRMANE NGA","	~ 1004 FE00 forme pointée"},
/* 1005 */ { "LETTRE BIRMANE TCHA",NULL},
/* 1006 */ { "LETTRE BIRMANE TCHHA",NULL},
/* 1007 */ { "LETTRE BIRMANE DJA",NULL},
/* 1008 */ { "LETTRE BIRMANE DJHA",NULL},
/* 1009 */ { "LETTRE BIRMANE ÑA",NULL},
/* 100A */ { "LETTRE BIRMANE ÑÑA",NULL},
/* 100B */ { "LETTRE BIRMANE TTA",NULL},
/* 100C */ { "LETTRE BIRMANE TTHA",NULL},
/* 100D */ { "LETTRE BIRMANE DDA",NULL},
/* 100E */ { "LETTRE BIRMANE DDHA",NULL},
/* 100F */ { "LETTRE BIRMANE NNA",NULL},
/* 1010 */ { "LETTRE BIRMANE TA","	~ 1010 FE00 forme pointée"},
/* 1011 */ { "LETTRE BIRMANE THA","	~ 1011 FE00 forme pointée"},
/* 1012 */ { "LETTRE BIRMANE DA",NULL},
/* 1013 */ { "LETTRE BIRMANE DHA",NULL},
/* 1014 */ { "LETTRE BIRMANE NA",NULL},
/* 1015 */ { "LETTRE BIRMANE PA","	~ 1015 FE00 forme pointée"},
/* 1016 */ { "LETTRE BIRMANE PHA",NULL},
/* 1017 */ { "LETTRE BIRMANE BA",NULL},
/* 1018 */ { "LETTRE BIRMANE BHA",NULL},
/* 1019 */ { "LETTRE BIRMANE MA","	~ 1019 FE00 forme pointée"},
/* 101A */ { "LETTRE BIRMANE YA","	~ 101A FE00 forme pointée"},
/* 101B */ { "LETTRE BIRMANE RA",NULL},
/* 101C */ { "LETTRE BIRMANE LA","	~ 101C FE00 forme pointée"},
/* 101D */ { "LETTRE BIRMANE WA","	~ 101D FE00 forme pointée"},
/* 101E */ { "LETTRE BIRMANE SA",NULL},
/* 101F */ { "LETTRE BIRMANE HA",NULL},
/* 1020 */ { "LETTRE BIRMANE LLA",NULL},
/* 1021 */ { "LETTRE BIRMANE Â","	* représente également un coup de glotte en tant que consonne"},
/* 1022 */ { "LETTRE BIRMANE CHAN A","	~ 1022 FE00 forme pointée"},
/* 1023 */ { "LETTRE BIRMANE I",NULL},
/* 1024 */ { "LETTRE BIRMANE Î",NULL},
/* 1025 */ { "LETTRE BIRMANE OU",NULL},
/* 1026 */ { "LETTRE BIRMANE OÛ","	: 1025 102E"},
/* 1027 */ { "LETTRE BIRMANE É",NULL},
/* 1028 */ { "LETTRE BIRMANE MÔN É",NULL},
/* 1029 */ { "LETTRE BIRMANE O",NULL},
/* 102A */ { "LETTRE BIRMANE AOU",NULL},
/* 102B */ { "DIACRITIQUE VOYELLE BIRMANE Â ALLONGÉ",NULL},
/* 102C */ { "DIACRITIQUE VOYELLE BIRMANE Â",NULL},
/* 102D */ { "DIACRITIQUE VOYELLE BIRMANE I",NULL},
/* 102E */ { "DIACRITIQUE VOYELLE BIRMANE Î",NULL},
/* 102F */ { "DIACRITIQUE VOYELLE BIRMANE OU",NULL},
/* 1030 */ { "DIACRITIQUE VOYELLE BIRMANE OÛ",NULL},
/* 1031 */ { "DIACRITIQUE VOYELLE BIRMANE É","	* à la gauche de la consonne\n"
	"	~ 1031 FE00 forme pointée"},
/* 1032 */ { "DIACRITIQUE VOYELLE BIRMANE AÏ",NULL},
/* 1033 */ { "DIACRITIQUE VOYELLE BIRMANE MÔN Î",NULL},
/* 1034 */ { "DIACRITIQUE VOYELLE BIRMANE MÔN O",NULL},
/* 1035 */ { "DIACRITIQUE VOYELLE BIRMANE É SUSCRIT",NULL},
/* 1036 */ { "DIACRITIQUE BIRMAN ANOUSVÂRA",NULL},
/* 1037 */ { "DIACRITIQUE BIRMAN POINT SOUSCRIT","	= aukmyit\n"
	"	* un signe de ton"},
/* 1038 */ { "DIACRITIQUE BIRMAN VISARGA",NULL},
/* 1039 */ { "DIACRITIQUE BIRMAN VIRÂMA","	= halant (quand on l'affiche)"},
/* 103A */ { "DIACRITIQUE BIRMAN ASAT","	= halant (toujours visible)"},
/* 103B */ { "DIACRITIQUE CONSONNE BIRMANE YA MÉDIAL",NULL},
/* 103C */ { "DIACRITIQUE CONSONNE BIRMANE RA MÉDIAL",NULL},
/* 103D */ { "DIACRITIQUE CONSONNE BIRMANE WA MÉDIAL",NULL},
/* 103E */ { "DIACRITIQUE CONSONNE BIRMANE HA MÉDIAL",NULL},
/* 103F */ { "LETTRE BIRMANE GRAND SA",NULL},
/* 1040 */ { "CHIFFRE BIRMAN ZÉRO",NULL},
/* 1041 */ { "CHIFFRE BIRMAN UN",NULL},
/* 1042 */ { "CHIFFRE BIRMAN DEUX",NULL},
/* 1043 */ { "CHIFFRE BIRMAN TROIS",NULL},
/* 1044 */ { "CHIFFRE BIRMAN QUATRE",NULL},
/* 1045 */ { "CHIFFRE BIRMAN CINQ",NULL},
/* 1046 */ { "CHIFFRE BIRMAN SIX",NULL},
/* 1047 */ { "CHIFFRE BIRMAN SEPT",NULL},
/* 1048 */ { "CHIFFRE BIRMAN HUIT",NULL},
/* 1049 */ { "CHIFFRE BIRMAN NEUF",NULL},
/* 104A */ { "SIGNE BIRMAN PETITE SECTION","	= temps d'arrêt\n"
	"	x (danda dévanâgarî - 0964)"},
/* 104B */ { "SIGNE BIRMAN SECTION","	= point\n"
	"	x (double danda dévanâgarî - 0965)"},
/* 104C */ { "SYMBOLE BIRMAN LOCATIF",NULL},
/* 104D */ { "SYMBOLE BIRMAN ACCOMPLI",NULL},
/* 104E */ { "SYMBOLE BIRMAN LEDIT",NULL},
/* 104F */ { "SYMBOLE BIRMAN GÉNITIF",NULL},
/* 1050 */ { "LETTRE BIRMANE ÇA",NULL},
/* 1051 */ { "LETTRE BIRMANE CHA",NULL},
/* 1052 */ { "LETTRE BIRMANE R VOCALIQUE",NULL},
/* 1053 */ { "LETTRE BIRMANE RR VOCALIQUE",NULL},
/* 1054 */ { "LETTRE BIRMANE L VOCALIQUE",NULL},
/* 1055 */ { "LETTRE BIRMANE LL VOCALIQUE",NULL},
/* 1056 */ { "DIACRITIQUE VOYELLE BIRMANE R VOCALIQUE",NULL},
/* 1057 */ { "DIACRITIQUE VOYELLE BIRMANE RR VOCALIQUE",NULL},
/* 1058 */ { "DIACRITIQUE VOYELLE BIRMANE L VOCALIQUE",NULL},
/* 1059 */ { "DIACRITIQUE VOYELLE BIRMANE LL VOCALIQUE",NULL},
/* 105A */ { "LETTRE BIRMANE MÔN NGA",NULL},
/* 105B */ { "LETTRE BIRMANE MÔN DJHA",NULL},
/* 105C */ { "LETTRE BIRMANE MÔN BBA",NULL},
/* 105D */ { "LETTRE BIRMANE MÔN BBÉ",NULL},
/* 105E */ { "DIACRITIQUE CONSONNE BIRMANE MÔN NA MÉDIAL",NULL},
/* 105F */ { "DIACRITIQUE CONSONNE BIRMANE MÔN MA MÉDIAL",NULL},
/* 1060 */ { "DIACRITIQUE CONSONNE BIRMANE MÔN LA MÉDIAL",NULL},
/* 1061 */ { "LETTRE BIRMANE KAREN SGAW CHA",NULL},
/* 1062 */ { "DIACRITIQUE VOYELLE BIRMANE KAREN SGAW EU",NULL},
/* 1063 */ { "DIACRITIQUE TON BIRMAN KAREN SGAW HATHI",NULL},
/* 1064 */ { "DIACRITIQUE TON BIRMAN KAREN SGAW KE PHO",NULL},
/* 1065 */ { "LETTRE BIRMANE KAREN PWO OCCIDENTAL THA",NULL},
/* 1066 */ { "LETTRE BIRMANE KAREN PWO OCCIDENTAL PWA",NULL},
/* 1067 */ { "DIACRITIQUE VOYELLE BIRMANE KAREN PWO OCCIDENTAL EU",NULL},
/* 1068 */ { "DIACRITIQUE VOYELLE BIRMANE KAREN PWO OCCIDENTAL OU",NULL},
/* 1069 */ { "DIACRITIQUE BIRMAN KAREN PWO OCCIDENTAL TON-1",NULL},
/* 106A */ { "DIACRITIQUE BIRMAN KAREN PWO OCCIDENTAL TON-2",NULL},
/* 106B */ { "DIACRITIQUE BIRMAN KAREN PWO OCCIDENTAL TON-3",NULL},
/* 106C */ { "DIACRITIQUE BIRMAN KAREN PWO OCCIDENTAL TON-4",NULL},
/* 106D */ { "DIACRITIQUE BIRMAN KAREN PWO OCCIDENTAL TON-5",NULL},
/* 106E */ { "LETTRE BIRMANE KAREN PWO ORIENTAL NNA",NULL},
/* 106F */ { "LETTRE BIRMANE KAREN PWO ORIENTAL YWA",NULL},
/* 1070 */ { "LETTRE BIRMANE KAREN PWO ORIENTAL GHWA",NULL},
/* 1071 */ { "DIACRITIQUE VOYELLE BIRMANE KAREN GEBA I",NULL},
/* 1072 */ { "DIACRITIQUE VOYELLE BIRMANE KAYAH OE",NULL},
/* 1073 */ { "DIACRITIQUE VOYELLE BIRMANE KAYAH OU",NULL},
/* 1074 */ { "DIACRITIQUE VOYELLE BIRMANE KAYAH Ê",NULL},
/* 1075 */ { "LETTRE BIRMANE CHAN KA","	~ 1075 FE00 forme pointée"},
/* 1076 */ { "LETTRE BIRMANE CHAN KHA",NULL},
/* 1077 */ { "LETTRE BIRMANE CHAN GA",NULL},
/* 1078 */ { "LETTRE BIRMANE CHAN TCHA","	~ 1078 FE00 forme pointée"},
/* 1079 */ { "LETTRE BIRMANE CHAN ZA",NULL},
/* 107A */ { "LETTRE BIRMANE CHAN ÑA","	~ 107A FE00 forme pointée"},
/* 107B */ { "LETTRE BIRMANE CHAN DA",NULL},
/* 107C */ { "LETTRE BIRMANE CHAN NA",NULL},
/* 107D */ { "LETTRE BIRMANE CHAN PHA",NULL},
/* 107E */ { "LETTRE BIRMANE CHAN FA",NULL},
/* 107F */ { "LETTRE BIRMANE CHAN BA",NULL},
/* 1080 */ { "LETTRE BIRMANE CHAN THA","	~ 1080 FE00 forme pointée"},
/* 1081 */ { "LETTRE BIRMANE CHAN HA",NULL},
/* 1082 */ { "DIACRITIQUE CONSONNE BIRMANE CHAN WA MÉDIAL",NULL},
/* 1083 */ { "DIACRITIQUE VOYELLE BIRMANE CHAN Â",NULL},
/* 1084 */ { "DIACRITIQUE VOYELLE BIRMANE CHAN É",NULL},
/* 1085 */ { "DIACRITIQUE VOYELLE BIRMANE CHAN É SUSCRIT",NULL},
/* 1086 */ { "DIACRITIQUE VOYELLE BIRMANE CHAN Y",NULL},
/* 1087 */ { "DIACRITIQUE BIRMAN CHAN TON-2",NULL},
/* 1088 */ { "DIACRITIQUE BIRMAN CHAN TON-3",NULL},
/* 1089 */ { "DIACRITIQUE BIRMAN CHAN TON-5",NULL},
/* 108A */ { "DIACRITIQUE BIRMAN CHAN TON-6",NULL},
/* 108B */ { "DIACRITIQUE BIRMAN CHAN TON-2 DU CONSEIL",NULL},
/* 108C */ { "DIACRITIQUE BIRMAN CHAN TON-3 DU CONSEIL",NULL},
/* 108D */ { "DIACRITIQUE BIRMAN CHAN TON EMPHATIQUE DU CONSEIL",NULL},
/* 108E */ { "LETTRE BIRMANE RUMAI PALAUNG FA",NULL},
/* 108F */ { "DIACRITIQUE BIRMAN RUMAI PALAUNG TON-5",NULL},
/* 1090 */ { "CHIFFRE BIRMAN CHAN ZÉRO",NULL},
/* 1091 */ { "CHIFFRE BIRMAN CHAN UN",NULL},
/* 1092 */ { "CHIFFRE BIRMAN CHAN DEUX",NULL},
/* 1093 */ { "CHIFFRE BIRMAN CHAN TROIS",NULL},
/* 1094 */ { "CHIFFRE BIRMAN CHAN QUATRE",NULL},
/* 1095 */ { "CHIFFRE BIRMAN CHAN CINQ",NULL},
/* 1096 */ { "CHIFFRE BIRMAN CHAN SIX",NULL},
/* 1097 */ { "CHIFFRE BIRMAN CHAN SEPT",NULL},
/* 1098 */ { "CHIFFRE BIRMAN CHAN HUIT",NULL},
/* 1099 */ { "CHIFFRE BIRMAN CHAN NEUF",NULL},
/* 109A */ { "DIACRITIQUE BIRMAN KHAMTI TON-1",NULL},
/* 109B */ { "DIACRITIQUE BIRMAN KHAMTI TON-3",NULL},
/* 109C */ { "DIACRITIQUE VOYELLE BIRMANE AITON A",NULL},
/* 109D */ { "DIACRITIQUE VOYELLE BIRMANE AITON AI",NULL},
/* 109E */ { "SYMBOLE BIRMAN CHAN UN",NULL},
/* 109F */ { "SYMBOLE BIRMAN CHAN EXCLAMATION",NULL},
/* 10A0 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI AN",NULL},
/* 10A1 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI BAN",NULL},
/* 10A2 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI GAN",NULL},
/* 10A3 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI DON",NULL},
/* 10A4 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI ÈN",NULL},
/* 10A5 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI VIN",NULL},
/* 10A6 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI ZÉN",NULL},
/* 10A7 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI THAN",NULL},
/* 10A8 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI IN",NULL},
/* 10A9 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI K'AN",NULL},
/* 10AA */ { "LETTRE GÉORGIENNE ASSOMTAVROULI LASS",NULL},
/* 10AB */ { "LETTRE GÉORGIENNE ASSOMTAVROULI MAN",NULL},
/* 10AC */ { "LETTRE GÉORGIENNE ASSOMTAVROULI NAR",NULL},
/* 10AD */ { "LETTRE GÉORGIENNE ASSOMTAVROULI ON",NULL},
/* 10AE */ { "LETTRE GÉORGIENNE ASSOMTAVROULI P'AR",NULL},
/* 10AF */ { "LETTRE GÉORGIENNE ASSOMTAVROULI JAN",NULL},
/* 10B0 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI RAÉ",NULL},
/* 10B1 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI SAN",NULL},
/* 10B2 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI T'AR",NULL},
/* 10B3 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI OUN",NULL},
/* 10B4 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI PHAR",NULL},
/* 10B5 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI KHAR",NULL},
/* 10B6 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI GHAN",NULL},
/* 10B7 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI Q'AR",NULL},
/* 10B8 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI CHIN",NULL},
/* 10B9 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI TCHIN",NULL},
/* 10BA */ { "LETTRE GÉORGIENNE ASSOMTAVROULI TSIN",NULL},
/* 10BB */ { "LETTRE GÉORGIENNE ASSOMTAVROULI DZIL",NULL},
/* 10BC */ { "LETTRE GÉORGIENNE ASSOMTAVROULI TS'IL",NULL},
/* 10BD */ { "LETTRE GÉORGIENNE ASSOMTAVROULI TCH'AR",NULL},
/* 10BE */ { "LETTRE GÉORGIENNE ASSOMTAVROULI KHAN",NULL},
/* 10BF */ { "LETTRE GÉORGIENNE ASSOMTAVROULI DJAN",NULL},
/* 10C0 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI HAÉ",NULL},
/* 10C1 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI HÉ",NULL},
/* 10C2 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI IÉ",NULL},
/* 10C3 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI WIÉ",NULL},
/* 10C4 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI QAR",NULL},
/* 10C5 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI HOÉ",NULL},
/* 10C6 */ { NULL,NULL},
/* 10C7 */ { "LETTRE GÉORGIENNE ASSOMTAVROULI YN",NULL},
/* 10C8 */ { NULL,NULL},
/* 10C9 */ { NULL,NULL},
/* 10CA */ { NULL,NULL},
/* 10CB */ { NULL,NULL},
/* 10CC */ { NULL,NULL},
/* 10CD */ { "LETTRE GÉORGIENNE ASSOMTAVROULI AÈN",NULL},
/* 10CE */ { NULL,NULL},
/* 10CF */ { NULL,NULL},
/* 10D0 */ { "LETTRE GÉORGIENNE AN",NULL},
/* 10D1 */ { "LETTRE GÉORGIENNE BAN",NULL},
/* 10D2 */ { "LETTRE GÉORGIENNE GAN",NULL},
/* 10D3 */ { "LETTRE GÉORGIENNE DON",NULL},
/* 10D4 */ { "LETTRE GÉORGIENNE ÈN",NULL},
/* 10D5 */ { "LETTRE GÉORGIENNE VIN",NULL},
/* 10D6 */ { "LETTRE GÉORGIENNE ZÉN",NULL},
/* 10D7 */ { "LETTRE GÉORGIENNE THAN",NULL},
/* 10D8 */ { "LETTRE GÉORGIENNE IN",NULL},
/* 10D9 */ { "LETTRE GÉORGIENNE K'AN",NULL},
/* 10DA */ { "LETTRE GÉORGIENNE LASS",NULL},
/* 10DB */ { "LETTRE GÉORGIENNE MAN",NULL},
/* 10DC */ { "LETTRE GÉORGIENNE NAR",NULL},
/* 10DD */ { "LETTRE GÉORGIENNE ON",NULL},
/* 10DE */ { "LETTRE GÉORGIENNE P'AR",NULL},
/* 10DF */ { "LETTRE GÉORGIENNE JAN",NULL},
/* 10E0 */ { "LETTRE GÉORGIENNE RAÉ",NULL},
/* 10E1 */ { "LETTRE GÉORGIENNE SAN",NULL},
/* 10E2 */ { "LETTRE GÉORGIENNE T'AR",NULL},
/* 10E3 */ { "LETTRE GÉORGIENNE OUN",NULL},
/* 10E4 */ { "LETTRE GÉORGIENNE PHAR",NULL},
/* 10E5 */ { "LETTRE GÉORGIENNE KHAR",NULL},
/* 10E6 */ { "LETTRE GÉORGIENNE GHAN",NULL},
/* 10E7 */ { "LETTRE GÉORGIENNE Q'AR",NULL},
/* 10E8 */ { "LETTRE GÉORGIENNE CHIN",NULL},
/* 10E9 */ { "LETTRE GÉORGIENNE TCHIN",NULL},
/* 10EA */ { "LETTRE GÉORGIENNE TSIN",NULL},
/* 10EB */ { "LETTRE GÉORGIENNE DZIL",NULL},
/* 10EC */ { "LETTRE GÉORGIENNE TS'IL",NULL},
/* 10ED */ { "LETTRE GÉORGIENNE TCH'AR",NULL},
/* 10EE */ { "LETTRE GÉORGIENNE KHAN",NULL},
/* 10EF */ { "LETTRE GÉORGIENNE DJAN",NULL},
/* 10F0 */ { "LETTRE GÉORGIENNE HAÉ",NULL},
/* 10F1 */ { "LETTRE GÉORGIENNE HÉ",NULL},
/* 10F2 */ { "LETTRE GÉORGIENNE IÉ",NULL},
/* 10F3 */ { "LETTRE GÉORGIENNE WIÉ",NULL},
/* 10F4 */ { "LETTRE GÉORGIENNE QAR",NULL},
/* 10F5 */ { "LETTRE GÉORGIENNE HOÉ",NULL},
/* 10F6 */ { "LETTRE GÉORGIENNE FI",NULL},
/* 10F7 */ { "LETTRE GÉORGIENNE YN",NULL},
/* 10F8 */ { "LETTRE GÉORGIENNE ELIFI",NULL},
/* 10F9 */ { "LETTRE GÉORGIENNE GAN CULBUTÉ",NULL},
/* 10FA */ { "LETTRE GÉORGIENNE 'AÏN",NULL},
/* 10FB */ { "SÉPARATEUR DE PARAGRAPHES GÉORGIEN","	x (trois-points - 2056)"},
/* 10FC */ { "LETTRE MODIFICATIVE GÉORGIENNE NAR","	# <exp> 10DC"},
/* 10FD */ { "LETTRE GÉORGIENNE AÈN",NULL},
/* 10FE */ { "LETTRE GÉORGIENNE SIGNE DUR",NULL},
/* 10FF */ { "LETTRE GÉORGIENNE SIGNE LABIAL",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_11[] = {
/* 1100 */ { "HANGÛL TCH'ÔSONG KIYOK","	= K"},
/* 1101 */ { "HANGÛL TCH'ÔSONG SSANGKIYOK","	= KK"},
/* 1102 */ { "HANGÛL TCH'ÔSONG NIÛN","	= N"},
/* 1103 */ { "HANGÛL TCH'ÔSONG TIKÛT","	= T"},
/* 1104 */ { "HANGÛL TCH'ÔSONG SSANGTIKÛT","	= TT"},
/* 1105 */ { "HANGÛL TCH'ÔSONG RIÛL","	= L"},
/* 1106 */ { "HANGÛL TCH'ÔSONG MIÛM","	= M"},
/* 1107 */ { "HANGÛL TCH'ÔSONG PIÛP","	= P"},
/* 1108 */ { "HANGÛL TCH'ÔSONG SSANGPIÛP","	= PP"},
/* 1109 */ { "HANGÛL TCH'ÔSONG SIÔS","	= S"},
/* 110A */ { "HANGÛL TCH'ÔSONG SSANGSIÔS","	= SS"},
/* 110B */ { "HANGÛL TCH'ÔSONG IÛNG",NULL},
/* 110C */ { "HANGÛL TCH'ÔSONG TCHIÛTCH","	= TCH"},
/* 110D */ { "HANGÛL TCH'ÔSONG SSANGTCHIÛTCH","	= TCHTCH"},
/* 110E */ { "HANGÛL TCH'ÔSONG TCH'IÛTCH'","	= TCH'"},
/* 110F */ { "HANGÛL TCH'ÔSONG K'IÛK'","	= K'"},
/* 1110 */ { "HANGÛL TCH'ÔSONG T'IÛT'","	= T'"},
/* 1111 */ { "HANGÛL TCH'ÔSONG P'IÛP'","	= P'"},
/* 1112 */ { "HANGÛL TCH'ÔSONG HIÛH","	= H"},
/* 1113 */ { "HANGÛL TCH'ÔSONG NIÛN-KIYOK",NULL},
/* 1114 */ { "HANGÛL TCH'ÔSONG SSANGNIÛN",NULL},
/* 1115 */ { "HANGÛL TCH'ÔSONG NIÛN-TIKÛT",NULL},
/* 1116 */ { "HANGÛL TCH'ÔSONG NIÛN-PIÛP",NULL},
/* 1117 */ { "HANGÛL TCH'ÔSONG TIKÛT-KIYOK",NULL},
/* 1118 */ { "HANGÛL TCH'ÔSONG RIÛL-NIÛN",NULL},
/* 1119 */ { "HANGÛL TCH'ÔSONG SSANGRIÛL",NULL},
/* 111A */ { "HANGÛL TCH'ÔSONG RIÛL-HIÛH",NULL},
/* 111B */ { "HANGÛL TCH'ÔSONG KAPYO-OUNRIÛL",NULL},
/* 111C */ { "HANGÛL TCH'ÔSONG MIÛM-PIÛP",NULL},
/* 111D */ { "HANGÛL TCH'ÔSONG KAPYO-OUNMIÛM",NULL},
/* 111E */ { "HANGÛL TCH'ÔSONG PIÛP-KIYOK",NULL},
/* 111F */ { "HANGÛL TCH'ÔSONG PIÛP-NIÛN",NULL},
/* 1120 */ { "HANGÛL TCH'ÔSONG PIÛP-TIKÛT",NULL},
/* 1121 */ { "HANGÛL TCH'ÔSONG PIÛP-SIÔS",NULL},
/* 1122 */ { "HANGÛL TCH'ÔSONG PIÛP-SIÔS-KIYOK",NULL},
/* 1123 */ { "HANGÛL TCH'ÔSONG PIÛP-SIÔS-TIKÛT",NULL},
/* 1124 */ { "HANGÛL TCH'ÔSONG PIÛP-SIÔS-PIÛP",NULL},
/* 1125 */ { "HANGÛL TCH'ÔSONG PIÛP-SSANGSIÔS",NULL},
/* 1126 */ { "HANGÛL TCH'ÔSONG PIÛP-SIÔS-TCHIÛTCH",NULL},
/* 1127 */ { "HANGÛL TCH'ÔSONG PIÛP-TCHIÛTCH",NULL},
/* 1128 */ { "HANGÛL TCH'ÔSONG PIÛP-TCH'IÛTCH'",NULL},
/* 1129 */ { "HANGÛL TCH'ÔSONG PIÛP-T'IÛT'",NULL},
/* 112A */ { "HANGÛL TCH'ÔSONG PIÛP-P'IÛP'",NULL},
/* 112B */ { "HANGÛL TCH'ÔSONG KAPYO-OUNPIÛP",NULL},
/* 112C */ { "HANGÛL TCH'ÔSONG KAPYO-OUNSSANGPIÛP",NULL},
/* 112D */ { "HANGÛL TCH'ÔSONG SIÔS-KIYOK",NULL},
/* 112E */ { "HANGÛL TCH'ÔSONG SIÔS-NIÛN",NULL},
/* 112F */ { "HANGÛL TCH'ÔSONG SIÔS-TIKÛT",NULL},
/* 1130 */ { "HANGÛL TCH'ÔSONG SIÔS-RIÛL",NULL},
/* 1131 */ { "HANGÛL TCH'ÔSONG SIÔS-MIÛM",NULL},
/* 1132 */ { "HANGÛL TCH'ÔSONG SIÔS-PIÛP",NULL},
/* 1133 */ { "HANGÛL TCH'ÔSONG SIÔS-PIÛP-KIYOK",NULL},
/* 1134 */ { "HANGÛL TCH'ÔSONG SIÔS-SSANGSIÔS",NULL},
/* 1135 */ { "HANGÛL TCH'ÔSONG SIÔS-IÛNG",NULL},
/* 1136 */ { "HANGÛL TCH'ÔSONG SIÔS-TCHIÛTCH",NULL},
/* 1137 */ { "HANGÛL TCH'ÔSONG SIÔS-TCH'IÛTCH'",NULL},
/* 1138 */ { "HANGÛL TCH'ÔSONG SIÔS-K'IÛK'",NULL},
/* 1139 */ { "HANGÛL TCH'ÔSONG SIÔS-T'IÛT'",NULL},
/* 113A */ { "HANGÛL TCH'ÔSONG SIÔS-P'IÛP'",NULL},
/* 113B */ { "HANGÛL TCH'ÔSONG SIÔS-HIÛH",NULL},
/* 113C */ { "HANGÛL TCH'ÔSONG TCH'ITOUÛMSIÔS",NULL},
/* 113D */ { "HANGÛL TCH'ÔSONG TCH'ITOUÛMSSANGSIÔS",NULL},
/* 113E */ { "HANGÛL TCH'ÔSONG TCHONGTCH'IÛMSIÔS",NULL},
/* 113F */ { "HANGÛL TCH'ÔSONG TCHONGTCH'IÛMSSANGSIÔS",NULL},
/* 1140 */ { "HANGÛL TCH'ÔSONG PANSIÔS",NULL},
/* 1141 */ { "HANGÛL TCH'ÔSONG IÛNG-KIYOK",NULL},
/* 1142 */ { "HANGÛL TCH'ÔSONG IÛNG-TIKÛT",NULL},
/* 1143 */ { "HANGÛL TCH'ÔSONG IÛNG-MIÛM",NULL},
/* 1144 */ { "HANGÛL TCH'ÔSONG IÛNG-PIÛP",NULL},
/* 1145 */ { "HANGÛL TCH'ÔSONG IÛNG-SIÔS",NULL},
/* 1146 */ { "HANGÛL TCH'ÔSONG IÛNG-PANSIÔS",NULL},
/* 1147 */ { "HANGÛL TCH'ÔSONG SSANGIÛNG",NULL},
/* 1148 */ { "HANGÛL TCH'ÔSONG IÛNG-TCHIÛTCH",NULL},
/* 1149 */ { "HANGÛL TCH'ÔSONG IÛNG-TCH'IÛTCH'",NULL},
/* 114A */ { "HANGÛL TCH'ÔSONG IÛNG-T'IÛT'",NULL},
/* 114B */ { "HANGÛL TCH'ÔSONG IÛNG-P'IÛP'",NULL},
/* 114C */ { "HANGÛL TCH'ÔSONG YESIÛNG",NULL},
/* 114D */ { "HANGÛL TCH'ÔSONG TCHIÛTCH-IÛNG",NULL},
/* 114E */ { "HANGÛL TCH'ÔSONG TCH'ITOUÛMTCHIÛTCH",NULL},
/* 114F */ { "HANGÛL TCH'ÔSONG TCH'ITOUÛMSSANGTCHIÛTCH",NULL},
/* 1150 */ { "HANGÛL TCH'ÔSONG TCHONGTCH'IÛMTCHIÛTCH",NULL},
/* 1151 */ { "HANGÛL TCH'ÔSONG TCHONGTCH'IÛMSSANGTCHIÛTCH",NULL},
/* 1152 */ { "HANGÛL TCH'ÔSONG TCH'IÛTCH'-K'IÛK'",NULL},
/* 1153 */ { "HANGÛL TCH'ÔSONG TCH'IÛTCH'-HIÛH",NULL},
/* 1154 */ { "HANGÛL TCH'ÔSONG TCH'ITOUÛMTCH'IÛTCH'",NULL},
/* 1155 */ { "HANGÛL TCH'ÔSONG TCHONGTCH'IÛMTCH'IÛTCH'",NULL},
/* 1156 */ { "HANGÛL TCH'ÔSONG P'IÛP'-PIÛP",NULL},
/* 1157 */ { "HANGÛL TCH'ÔSONG KAPYO-OUNP'IÛP'",NULL},
/* 1158 */ { "HANGÛL TCH'ÔSONG SSANGHIÛH",NULL},
/* 1159 */ { "HANGÛL TCH'ÔSONG YORINHIÛH","	* coup de glotte"},
/* 115A */ { "HANGÛL TCH'ÔSONG KIYEOK-TIKEUT",NULL},
/* 115B */ { "HANGÛL TCH'ÔSONG NIEUN-SIOS",NULL},
/* 115C */ { "HANGÛL TCH'ÔSONG NIEUN-CIEUC",NULL},
/* 115D */ { "HANGÛL TCH'ÔSONG NIEUN-HIEUH",NULL},
/* 115E */ { "HANGÛL TCH'ÔSONG TIKEUT-RIEUL",NULL},
/* 115F */ { "BOURRE HANGÛL TCH'ÔSONG",NULL},
/* 1160 */ { "BOURRE HANGÛL DJOUNGSONG",NULL},
/* 1161 */ { "HANGÛL DJOUNGSONG A","	= A"},
/* 1162 */ { "HANGÛL DJOUNGSONG È","	= È"},
/* 1163 */ { "HANGÛL DJOUNGSONG YA","	= YA"},
/* 1164 */ { "HANGÛL DJOUNGSONG YÈ","	= YÈ"},
/* 1165 */ { "HANGÛL DJOUNGSONG O","	= O"},
/* 1166 */ { "HANGÛL DJOUNGSONG É","	= É"},
/* 1167 */ { "HANGÛL DJOUNGSONG YO","	= YO"},
/* 1168 */ { "HANGÛL DJOUNGSONG YÉ","	= YÉ"},
/* 1169 */ { "HANGÛL DJOUNGSONG Ô","	= Ô"},
/* 116A */ { "HANGÛL DJOUNGSONG WA","	= WA"},
/* 116B */ { "HANGÛL DJOUNGSONG WÈ","	= WÈ"},
/* 116C */ { "HANGÛL DJOUNGSONG EU","	= EU"},
/* 116D */ { "HANGÛL DJOUNGSONG YÔ","	= YÔ"},
/* 116E */ { "HANGÛL DJOUNGSONG OU","	= OU"},
/* 116F */ { "HANGÛL DJOUNGSONG WO","	= WO"},
/* 1170 */ { "HANGÛL DJOUNGSONG WÉ","	= WÉ"},
/* 1171 */ { "HANGÛL DJOUNGSONG WI","	= WI"},
/* 1172 */ { "HANGÛL DJOUNGSONG YOU","	= YOU"},
/* 1173 */ { "HANGÛL DJOUNGSONG Û","	= Û"},
/* 1174 */ { "HANGÛL DJOUNGSONG ÛI","	= ÛI"},
/* 1175 */ { "HANGÛL DJOUNGSONG I","	= I"},
/* 1176 */ { "HANGÛL DJOUNGSONG A-Ô",NULL},
/* 1177 */ { "HANGÛL DJOUNGSONG A-OU",NULL},
/* 1178 */ { "HANGÛL DJOUNGSONG YA-Ô",NULL},
/* 1179 */ { "HANGÛL DJOUNGSONG YA-YÔ",NULL},
/* 117A */ { "HANGÛL DJOUNGSONG O-Ô",NULL},
/* 117B */ { "HANGÛL DJOUNGSONG O-OU",NULL},
/* 117C */ { "HANGÛL DJOUNGSONG O-Û",NULL},
/* 117D */ { "HANGÛL DJOUNGSONG YO-Ô",NULL},
/* 117E */ { "HANGÛL DJOUNGSONG YO-OU",NULL},
/* 117F */ { "HANGÛL DJOUNGSONG Ô-O",NULL},
/* 1180 */ { "HANGÛL DJOUNGSONG Ô-É",NULL},
/* 1181 */ { "HANGÛL DJOUNGSONG Ô-YÉ",NULL},
/* 1182 */ { "HANGÛL DJOUNGSONG Ô-Ô",NULL},
/* 1183 */ { "HANGÛL DJOUNGSONG Ô-OU",NULL},
/* 1184 */ { "HANGÛL DJOUNGSONG YÔ-YA",NULL},
/* 1185 */ { "HANGÛL DJOUNGSONG YÔ-YÈ",NULL},
/* 1186 */ { "HANGÛL DJOUNGSONG YÔ-YO",NULL},
/* 1187 */ { "HANGÛL DJOUNGSONG YÔ-Ô",NULL},
/* 1188 */ { "HANGÛL DJOUNGSONG YÔ-I",NULL},
/* 1189 */ { "HANGÛL DJOUNGSONG OU-A",NULL},
/* 118A */ { "HANGÛL DJOUNGSONG OU-È",NULL},
/* 118B */ { "HANGÛL DJOUNGSONG OU-O-Û",NULL},
/* 118C */ { "HANGÛL DJOUNGSONG OU-YÉ",NULL},
/* 118D */ { "HANGÛL DJOUNGSONG OU-OU",NULL},
/* 118E */ { "HANGÛL DJOUNGSONG YOU-A",NULL},
/* 118F */ { "HANGÛL DJOUNGSONG YOU-O",NULL},
/* 1190 */ { "HANGÛL DJOUNGSONG YOU-É",NULL},
/* 1191 */ { "HANGÛL DJOUNGSONG YOU-YO",NULL},
/* 1192 */ { "HANGÛL DJOUNGSONG YOU-YÉ",NULL},
/* 1193 */ { "HANGÛL DJOUNGSONG YOU-OU",NULL},
/* 1194 */ { "HANGÛL DJOUNGSONG YOU-I",NULL},
/* 1195 */ { "HANGÛL DJOUNGSONG Û-OU",NULL},
/* 1196 */ { "HANGÛL DJOUNGSONG Û-Û",NULL},
/* 1197 */ { "HANGÛL DJOUNGSONG ÛI-OU",NULL},
/* 1198 */ { "HANGÛL DJOUNGSONG I-A",NULL},
/* 1199 */ { "HANGÛL DJOUNGSONG I-YA",NULL},
/* 119A */ { "HANGÛL DJOUNGSONG I-Ô",NULL},
/* 119B */ { "HANGÛL DJOUNGSONG I-OU",NULL},
/* 119C */ { "HANGÛL DJOUNGSONG I-Û",NULL},
/* 119D */ { "HANGÛL DJOUNGSONG I-ARÈA",NULL},
/* 119E */ { "HANGÛL DJOUNGSONG ARÈA",NULL},
/* 119F */ { "HANGÛL DJOUNGSONG ARÈA-O",NULL},
/* 11A0 */ { "HANGÛL DJOUNGSONG ARÈA-OU",NULL},
/* 11A1 */ { "HANGÛL DJOUNGSONG ARÈA-I",NULL},
/* 11A2 */ { "HANGÛL DJOUNGSONG SSANGARÈA",NULL},
/* 11A3 */ { "HANGÛL DJOUNGSONG GA-EU",NULL},
/* 11A4 */ { "HANGÛL DJOUNGSONG YA-U",NULL},
/* 11A5 */ { "HANGÛL DJOUNGSONG YEO-YA",NULL},
/* 11A6 */ { "HANGÛL DJOUNGSONG O-YA",NULL},
/* 11A7 */ { "HANGÛL DJOUNGSONG O-YAE",NULL},
/* 11A8 */ { "HANGÛL DJÔNGSONG KIYOK","	= K"},
/* 11A9 */ { "HANGÛL DJÔNGSONG SSANGKIYOK","	= KK"},
/* 11AA */ { "HANGÛL DJÔNGSONG KIYOK-SIÔS","	= KS"},
/* 11AB */ { "HANGÛL DJÔNGSONG NIÛN","	= N"},
/* 11AC */ { "HANGÛL DJÔNGSONG NIÛN-TCHIÛTCH","	= NTCH"},
/* 11AD */ { "HANGÛL DJÔNGSONG NIÛN-HIÛH","	= NH"},
/* 11AE */ { "HANGÛL DJÔNGSONG TIKÛT","	= T"},
/* 11AF */ { "HANGÛL DJÔNGSONG RIÛL","	= L"},
/* 11B0 */ { "HANGÛL DJÔNGSONG RIÛL-KIYOK","	= LK"},
/* 11B1 */ { "HANGÛL DJÔNGSONG RIÛL-MIÛM","	= LM"},
/* 11B2 */ { "HANGÛL DJÔNGSONG RIÛL-PIÛP","	= LP"},
/* 11B3 */ { "HANGÛL DJÔNGSONG RIÛL-SIÔS","	= LS"},
/* 11B4 */ { "HANGÛL DJÔNGSONG RIÛL-T'IÛT'","	= LT'"},
/* 11B5 */ { "HANGÛL DJÔNGSONG RIÛL-P'IÛP'","	= LP'"},
/* 11B6 */ { "HANGÛL DJÔNGSONG RIÛL-HIÛH","	= LH"},
/* 11B7 */ { "HANGÛL DJÔNGSONG MIÛM","	= M"},
/* 11B8 */ { "HANGÛL DJÔNGSONG PIÛP","	= P"},
/* 11B9 */ { "HANGÛL DJÔNGSONG PIÛP-SIÔS","	= PS"},
/* 11BA */ { "HANGÛL DJÔNGSONG SIÔS","	= S"},
/* 11BB */ { "HANGÛL DJÔNGSONG SSANGSIÔS","	= SS"},
/* 11BC */ { "HANGÛL DJÔNGSONG IÛNG","	= NG"},
/* 11BD */ { "HANGÛL DJÔNGSONG TCHIÛTCH","	= TCH"},
/* 11BE */ { "HANGÛL DJÔNGSONG TCH'IÛTCH'","	= TCH'"},
/* 11BF */ { "HANGÛL DJÔNGSONG K'IÛK'","	= K'"},
/* 11C0 */ { "HANGÛL DJÔNGSONG T'IÛT'","	= T'"},
/* 11C1 */ { "HANGÛL DJÔNGSONG P'IÛP'","	= P'"},
/* 11C2 */ { "HANGÛL DJÔNGSONG HIÛH","	= H"},
/* 11C3 */ { "HANGÛL DJÔNGSONG KIYOK-RIÛL",NULL},
/* 11C4 */ { "HANGÛL DJÔNGSONG KIYOK-SIÔS-KIYOK",NULL},
/* 11C5 */ { "HANGÛL DJÔNGSONG NIÛN-KIYOK",NULL},
/* 11C6 */ { "HANGÛL DJÔNGSONG NIÛN-TIKÛT",NULL},
/* 11C7 */ { "HANGÛL DJÔNGSONG NIÛN-SIÔS",NULL},
/* 11C8 */ { "HANGÛL DJÔNGSONG NIÛN-PANSIÔS",NULL},
/* 11C9 */ { "HANGÛL DJÔNGSONG NIÛN-T'IÛT'",NULL},
/* 11CA */ { "HANGÛL DJÔNGSONG TIKÛT-KIYOK",NULL},
/* 11CB */ { "HANGÛL DJÔNGSONG TIKÛT-RIÛL",NULL},
/* 11CC */ { "HANGÛL DJÔNGSONG RIÛL-KIYOK-SIÔS",NULL},
/* 11CD */ { "HANGÛL DJÔNGSONG RIÛL-NIÛN",NULL},
/* 11CE */ { "HANGÛL DJÔNGSONG RIÛL-TIKÛT",NULL},
/* 11CF */ { "HANGÛL DJÔNGSONG RIÛL-TIKÛT-HIÛH",NULL},
/* 11D0 */ { "HANGÛL DJÔNGSONG SSANGRIÛL",NULL},
/* 11D1 */ { "HANGÛL DJÔNGSONG RIÛL-MIÛM-KIYOK",NULL},
/* 11D2 */ { "HANGÛL DJÔNGSONG RIÛL-MIÛM-SIÔS",NULL},
/* 11D3 */ { "HANGÛL DJÔNGSONG RIÛL-PIÛP-SIÔS",NULL},
/* 11D4 */ { "HANGÛL DJÔNGSONG RIÛL-PIÛP-HIÛH",NULL},
/* 11D5 */ { "HANGÛL DJÔNGSONG RIÛL-KAPYO-OUNPIÛP",NULL},
/* 11D6 */ { "HANGÛL DJÔNGSONG RIÛL-SSANGSIÔS",NULL},
/* 11D7 */ { "HANGÛL DJÔNGSONG RIÛL-PANSIÔS",NULL},
/* 11D8 */ { "HANGÛL DJÔNGSONG RIÛL-K'IÛK'",NULL},
/* 11D9 */ { "HANGÛL DJÔNGSONG RIÛL-YORINHIÛH",NULL},
/* 11DA */ { "HANGÛL DJÔNGSONG MIÛM-KIYOK",NULL},
/* 11DB */ { "HANGÛL DJÔNGSONG MIÛM-RIÛL",NULL},
/* 11DC */ { "HANGÛL DJÔNGSONG MIÛM-PIÛP",NULL},
/* 11DD */ { "HANGÛL DJÔNGSONG MIÛM-SIÔS",NULL},
/* 11DE */ { "HANGÛL DJÔNGSONG MIÛM-SSANGSIÔS",NULL},
/* 11DF */ { "HANGÛL DJÔNGSONG MIÛM-PANSIÔS",NULL},
/* 11E0 */ { "HANGÛL DJÔNGSONG MIÛM-TCH'IÛTCH'",NULL},
/* 11E1 */ { "HANGÛL DJÔNGSONG MIÛM-HIÛH",NULL},
/* 11E2 */ { "HANGÛL DJÔNGSONG KAPYO-OUNMIÛM",NULL},
/* 11E3 */ { "HANGÛL DJÔNGSONG PIÛP-RIÛL",NULL},
/* 11E4 */ { "HANGÛL DJÔNGSONG PIÛP-P'IÛP'",NULL},
/* 11E5 */ { "HANGÛL DJÔNGSONG PIÛP-HIÛH",NULL},
/* 11E6 */ { "HANGÛL DJÔNGSONG KAPYO-OUNPIÛP",NULL},
/* 11E7 */ { "HANGÛL DJÔNGSONG SIÔS-KIYOK",NULL},
/* 11E8 */ { "HANGÛL DJÔNGSONG SIÔS-TIKÛT",NULL},
/* 11E9 */ { "HANGÛL DJÔNGSONG SIÔS-RIÛL",NULL},
/* 11EA */ { "HANGÛL DJÔNGSONG SIÔS-PIÛP",NULL},
/* 11EB */ { "HANGÛL DJÔNGSONG PANSIÔS",NULL},
/* 11EC */ { "HANGÛL DJÔNGSONG YESIÛNG-KIYOK",NULL},
/* 11ED */ { "HANGÛL DJÔNGSONG YESIÛNG-SSANGKIYOK",NULL},
/* 11EE */ { "HANGÛL DJÔNGSONG SSANGYESIÛNG",NULL},
/* 11EF */ { "HANGÛL DJÔNGSONG YESIÛNG-K'IÛK'","	* les appellations anglaises des quatre caractères précédents (11EC-11EF) sont erronées"},
/* 11F0 */ { "HANGÛL DJÔNGSONG YESIÛNG",NULL},
/* 11F1 */ { "HANGÛL DJÔNGSONG YESIÛNG-SIÔS",NULL},
/* 11F2 */ { "HANGÛL DJÔNGSONG YESIÛNG-PANSIÔS",NULL},
/* 11F3 */ { "HANGÛL DJÔNGSONG P'IÛP'-PIÛP",NULL},
/* 11F4 */ { "HANGÛL DJÔNGSONG KAPYO-OUNP'IÛP'",NULL},
/* 11F5 */ { "HANGÛL DJÔNGSONG HIÛH-NIÛN",NULL},
/* 11F6 */ { "HANGÛL DJÔNGSONG HIÛH-RIÛL",NULL},
/* 11F7 */ { "HANGÛL DJÔNGSONG HIÛH-MIÛM",NULL},
/* 11F8 */ { "HANGÛL DJÔNGSONG HIÛH-PIÛP",NULL},
/* 11F9 */ { "HANGÛL DJÔNGSONG YORINHIÛH",NULL},
/* 11FA */ { "HANGÛL DJÔNGSONG KIYEOK-NIEUN",NULL},
/* 11FB */ { "HANGÛL DJÔNGSONG KIYEOK-PIEUP",NULL},
/* 11FC */ { "HANGÛL DJÔNGSONG KIYEOK-CHIEUCH",NULL},
/* 11FD */ { "HANGÛL DJÔNGSONG KIYEOK-KHIEUKH",NULL},
/* 11FE */ { "HANGÛL DJÔNGSONG KIYEOK-HIEUH",NULL},
/* 11FF */ { "HANGÛL DJÔNGSONG SSANGNIEUN",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_12[] = {
/* 1200 */ { "SYLLABE ÉTHIOPIENNE HÄ",NULL},
/* 1201 */ { "SYLLABE ÉTHIOPIENNE HOU",NULL},
/* 1202 */ { "SYLLABE ÉTHIOPIENNE HI",NULL},
/* 1203 */ { "SYLLABE ÉTHIOPIENNE HA",NULL},
/* 1204 */ { "SYLLABE ÉTHIOPIENNE HÉ",NULL},
/* 1205 */ { "SYLLABE ÉTHIOPIENNE HE",NULL},
/* 1206 */ { "SYLLABE ÉTHIOPIENNE HO",NULL},
/* 1207 */ { "SYLLABE ÉTHIOPIENNE HOÄ","	* il s'agit d'un ho au « o » ouvert"},
/* 1208 */ { "SYLLABE ÉTHIOPIENNE LÄ",NULL},
/* 1209 */ { "SYLLABE ÉTHIOPIENNE LOU",NULL},
/* 120A */ { "SYLLABE ÉTHIOPIENNE LI",NULL},
/* 120B */ { "SYLLABE ÉTHIOPIENNE LA",NULL},
/* 120C */ { "SYLLABE ÉTHIOPIENNE LÉ",NULL},
/* 120D */ { "SYLLABE ÉTHIOPIENNE LE",NULL},
/* 120E */ { "SYLLABE ÉTHIOPIENNE LO",NULL},
/* 120F */ { "SYLLABE ÉTHIOPIENNE LWA","	* le socle de la lettre sert à noter les combinaisons de consonne avec w"},
/* 1210 */ { "SYLLABE ÉTHIOPIENNE HHÄ",NULL},
/* 1211 */ { "SYLLABE ÉTHIOPIENNE HHOU",NULL},
/* 1212 */ { "SYLLABE ÉTHIOPIENNE HHI",NULL},
/* 1213 */ { "SYLLABE ÉTHIOPIENNE HHA",NULL},
/* 1214 */ { "SYLLABE ÉTHIOPIENNE HHÉ",NULL},
/* 1215 */ { "SYLLABE ÉTHIOPIENNE HHE",NULL},
/* 1216 */ { "SYLLABE ÉTHIOPIENNE HHO",NULL},
/* 1217 */ { "SYLLABE ÉTHIOPIENNE HHWA",NULL},
/* 1218 */ { "SYLLABE ÉTHIOPIENNE MÄ",NULL},
/* 1219 */ { "SYLLABE ÉTHIOPIENNE MOU",NULL},
/* 121A */ { "SYLLABE ÉTHIOPIENNE MI",NULL},
/* 121B */ { "SYLLABE ÉTHIOPIENNE MA",NULL},
/* 121C */ { "SYLLABE ÉTHIOPIENNE MÉ",NULL},
/* 121D */ { "SYLLABE ÉTHIOPIENNE ME",NULL},
/* 121E */ { "SYLLABE ÉTHIOPIENNE MO",NULL},
/* 121F */ { "SYLLABE ÉTHIOPIENNE MWA",NULL},
/* 1220 */ { "SYLLABE ÉTHIOPIENNE ÇÄ",NULL},
/* 1221 */ { "SYLLABE ÉTHIOPIENNE ÇOU",NULL},
/* 1222 */ { "SYLLABE ÉTHIOPIENNE ÇI",NULL},
/* 1223 */ { "SYLLABE ÉTHIOPIENNE ÇA",NULL},
/* 1224 */ { "SYLLABE ÉTHIOPIENNE ÇÉ",NULL},
/* 1225 */ { "SYLLABE ÉTHIOPIENNE ÇE",NULL},
/* 1226 */ { "SYLLABE ÉTHIOPIENNE ÇO",NULL},
/* 1227 */ { "SYLLABE ÉTHIOPIENNE ÇWA",NULL},
/* 1228 */ { "SYLLABE ÉTHIOPIENNE RÄ",NULL},
/* 1229 */ { "SYLLABE ÉTHIOPIENNE ROU",NULL},
/* 122A */ { "SYLLABE ÉTHIOPIENNE RI",NULL},
/* 122B */ { "SYLLABE ÉTHIOPIENNE RA",NULL},
/* 122C */ { "SYLLABE ÉTHIOPIENNE RÉ",NULL},
/* 122D */ { "SYLLABE ÉTHIOPIENNE RE",NULL},
/* 122E */ { "SYLLABE ÉTHIOPIENNE RO",NULL},
/* 122F */ { "SYLLABE ÉTHIOPIENNE RWA",NULL},
/* 1230 */ { "SYLLABE ÉTHIOPIENNE SÄ",NULL},
/* 1231 */ { "SYLLABE ÉTHIOPIENNE SOU",NULL},
/* 1232 */ { "SYLLABE ÉTHIOPIENNE SI",NULL},
/* 1233 */ { "SYLLABE ÉTHIOPIENNE SA",NULL},
/* 1234 */ { "SYLLABE ÉTHIOPIENNE SÉ",NULL},
/* 1235 */ { "SYLLABE ÉTHIOPIENNE SE",NULL},
/* 1236 */ { "SYLLABE ÉTHIOPIENNE SO",NULL},
/* 1237 */ { "SYLLABE ÉTHIOPIENNE SWA",NULL},
/* 1238 */ { "SYLLABE ÉTHIOPIENNE CHÄ",NULL},
/* 1239 */ { "SYLLABE ÉTHIOPIENNE CHOU",NULL},
/* 123A */ { "SYLLABE ÉTHIOPIENNE CHI",NULL},
/* 123B */ { "SYLLABE ÉTHIOPIENNE CHA",NULL},
/* 123C */ { "SYLLABE ÉTHIOPIENNE CHÉ",NULL},
/* 123D */ { "SYLLABE ÉTHIOPIENNE CHE",NULL},
/* 123E */ { "SYLLABE ÉTHIOPIENNE CHO",NULL},
/* 123F */ { "SYLLABE ÉTHIOPIENNE CHWA",NULL},
/* 1240 */ { "SYLLABE ÉTHIOPIENNE QÄ",NULL},
/* 1241 */ { "SYLLABE ÉTHIOPIENNE QOU",NULL},
/* 1242 */ { "SYLLABE ÉTHIOPIENNE QI",NULL},
/* 1243 */ { "SYLLABE ÉTHIOPIENNE QA",NULL},
/* 1244 */ { "SYLLABE ÉTHIOPIENNE QÉ",NULL},
/* 1245 */ { "SYLLABE ÉTHIOPIENNE QE",NULL},
/* 1246 */ { "SYLLABE ÉTHIOPIENNE QO",NULL},
/* 1247 */ { "SYLLABE ÉTHIOPIENNE QOÄ","	* « oä » dénote un « o » ouvert\n"
	"	* série pour noter le me'en, le moursi et le souri"},
/* 1248 */ { "SYLLABE ÉTHIOPIENNE QWÄ",NULL},
/* 1249 */ { NULL,NULL},
/* 124A */ { "SYLLABE ÉTHIOPIENNE QWI",NULL},
/* 124B */ { "SYLLABE ÉTHIOPIENNE QWA",NULL},
/* 124C */ { "SYLLABE ÉTHIOPIENNE QWÉ",NULL},
/* 124D */ { "SYLLABE ÉTHIOPIENNE QWE",NULL},
/* 124E */ { NULL,NULL},
/* 124F */ { NULL,NULL},
/* 1250 */ { "SYLLABE ÉTHIOPIENNE QHÄ","	* la partie supérieure de la lettre se nomme parfois chapeau"},
/* 1251 */ { "SYLLABE ÉTHIOPIENNE QHOU",NULL},
/* 1252 */ { "SYLLABE ÉTHIOPIENNE QHI",NULL},
/* 1253 */ { "SYLLABE ÉTHIOPIENNE QHA",NULL},
/* 1254 */ { "SYLLABE ÉTHIOPIENNE QHÉ",NULL},
/* 1255 */ { "SYLLABE ÉTHIOPIENNE QHE",NULL},
/* 1256 */ { "SYLLABE ÉTHIOPIENNE QHO",NULL},
/* 1257 */ { NULL,NULL},
/* 1258 */ { "SYLLABE ÉTHIOPIENNE QHWÄ",NULL},
/* 1259 */ { NULL,NULL},
/* 125A */ { "SYLLABE ÉTHIOPIENNE QHWI",NULL},
/* 125B */ { "SYLLABE ÉTHIOPIENNE QHWA",NULL},
/* 125C */ { "SYLLABE ÉTHIOPIENNE QHWÉ",NULL},
/* 125D */ { "SYLLABE ÉTHIOPIENNE QHWE",NULL},
/* 125E */ { NULL,NULL},
/* 125F */ { NULL,NULL},
/* 1260 */ { "SYLLABE ÉTHIOPIENNE BÄ",NULL},
/* 1261 */ { "SYLLABE ÉTHIOPIENNE BOU",NULL},
/* 1262 */ { "SYLLABE ÉTHIOPIENNE BI",NULL},
/* 1263 */ { "SYLLABE ÉTHIOPIENNE BA",NULL},
/* 1264 */ { "SYLLABE ÉTHIOPIENNE BÉ",NULL},
/* 1265 */ { "SYLLABE ÉTHIOPIENNE BE",NULL},
/* 1266 */ { "SYLLABE ÉTHIOPIENNE BO",NULL},
/* 1267 */ { "SYLLABE ÉTHIOPIENNE BWA",NULL},
/* 1268 */ { "SYLLABE ÉTHIOPIENNE VÄ",NULL},
/* 1269 */ { "SYLLABE ÉTHIOPIENNE VOU",NULL},
/* 126A */ { "SYLLABE ÉTHIOPIENNE VI",NULL},
/* 126B */ { "SYLLABE ÉTHIOPIENNE VA",NULL},
/* 126C */ { "SYLLABE ÉTHIOPIENNE VÉ",NULL},
/* 126D */ { "SYLLABE ÉTHIOPIENNE VE",NULL},
/* 126E */ { "SYLLABE ÉTHIOPIENNE VO",NULL},
/* 126F */ { "SYLLABE ÉTHIOPIENNE VWA",NULL},
/* 1270 */ { "SYLLABE ÉTHIOPIENNE TÄ",NULL},
/* 1271 */ { "SYLLABE ÉTHIOPIENNE TOU",NULL},
/* 1272 */ { "SYLLABE ÉTHIOPIENNE TI",NULL},
/* 1273 */ { "SYLLABE ÉTHIOPIENNE TA",NULL},
/* 1274 */ { "SYLLABE ÉTHIOPIENNE TÉ",NULL},
/* 1275 */ { "SYLLABE ÉTHIOPIENNE TE",NULL},
/* 1276 */ { "SYLLABE ÉTHIOPIENNE TO",NULL},
/* 1277 */ { "SYLLABE ÉTHIOPIENNE TWA",NULL},
/* 1278 */ { "SYLLABE ÉTHIOPIENNE TCHÄ",NULL},
/* 1279 */ { "SYLLABE ÉTHIOPIENNE TCHOU",NULL},
/* 127A */ { "SYLLABE ÉTHIOPIENNE TCHI",NULL},
/* 127B */ { "SYLLABE ÉTHIOPIENNE TCHA",NULL},
/* 127C */ { "SYLLABE ÉTHIOPIENNE TCHÉ",NULL},
/* 127D */ { "SYLLABE ÉTHIOPIENNE TCHE",NULL},
/* 127E */ { "SYLLABE ÉTHIOPIENNE TCHO",NULL},
/* 127F */ { "SYLLABE ÉTHIOPIENNE TCHWA",NULL},
/* 1280 */ { "SYLLABE ÉTHIOPIENNE XÄ",NULL},
/* 1281 */ { "SYLLABE ÉTHIOPIENNE XOU",NULL},
/* 1282 */ { "SYLLABE ÉTHIOPIENNE XI",NULL},
/* 1283 */ { "SYLLABE ÉTHIOPIENNE XA",NULL},
/* 1284 */ { "SYLLABE ÉTHIOPIENNE XÉ",NULL},
/* 1285 */ { "SYLLABE ÉTHIOPIENNE XE",NULL},
/* 1286 */ { "SYLLABE ÉTHIOPIENNE XO",NULL},
/* 1287 */ { "SYLLABE ÉTHIOPIENNE XOÄ",NULL},
/* 1288 */ { "SYLLABE ÉTHIOPIENNE XWÄ",NULL},
/* 1289 */ { NULL,NULL},
/* 128A */ { "SYLLABE ÉTHIOPIENNE XWI",NULL},
/* 128B */ { "SYLLABE ÉTHIOPIENNE XWA",NULL},
/* 128C */ { "SYLLABE ÉTHIOPIENNE XWÉ",NULL},
/* 128D */ { "SYLLABE ÉTHIOPIENNE XWE",NULL},
/* 128E */ { NULL,NULL},
/* 128F */ { NULL,NULL},
/* 1290 */ { "SYLLABE ÉTHIOPIENNE NÄ",NULL},
/* 1291 */ { "SYLLABE ÉTHIOPIENNE NOU",NULL},
/* 1292 */ { "SYLLABE ÉTHIOPIENNE NI",NULL},
/* 1293 */ { "SYLLABE ÉTHIOPIENNE NA",NULL},
/* 1294 */ { "SYLLABE ÉTHIOPIENNE NÉ",NULL},
/* 1295 */ { "SYLLABE ÉTHIOPIENNE NE",NULL},
/* 1296 */ { "SYLLABE ÉTHIOPIENNE NO",NULL},
/* 1297 */ { "SYLLABE ÉTHIOPIENNE NWA",NULL},
/* 1298 */ { "SYLLABE ÉTHIOPIENNE ÑÄ",NULL},
/* 1299 */ { "SYLLABE ÉTHIOPIENNE ÑOU",NULL},
/* 129A */ { "SYLLABE ÉTHIOPIENNE ÑI",NULL},
/* 129B */ { "SYLLABE ÉTHIOPIENNE ÑA",NULL},
/* 129C */ { "SYLLABE ÉTHIOPIENNE ÑÉ",NULL},
/* 129D */ { "SYLLABE ÉTHIOPIENNE ÑE",NULL},
/* 129E */ { "SYLLABE ÉTHIOPIENNE ÑO",NULL},
/* 129F */ { "SYLLABE ÉTHIOPIENNE ÑWA",NULL},
/* 12A0 */ { "SYLLABE ÉTHIOPIENNE Ä GLOTTAL",NULL},
/* 12A1 */ { "SYLLABE ÉTHIOPIENNE OU GLOTTAL",NULL},
/* 12A2 */ { "SYLLABE ÉTHIOPIENNE I GLOTTAL",NULL},
/* 12A3 */ { "SYLLABE ÉTHIOPIENNE A GLOTTAL",NULL},
/* 12A4 */ { "SYLLABE ÉTHIOPIENNE É GLOTTAL",NULL},
/* 12A5 */ { "SYLLABE ÉTHIOPIENNE E GLOTTAL",NULL},
/* 12A6 */ { "SYLLABE ÉTHIOPIENNE O GLOTTAL",NULL},
/* 12A7 */ { "SYLLABE ÉTHIOPIENNE WA GLOTTAL",NULL},
/* 12A8 */ { "SYLLABE ÉTHIOPIENNE KÄ",NULL},
/* 12A9 */ { "SYLLABE ÉTHIOPIENNE KOU",NULL},
/* 12AA */ { "SYLLABE ÉTHIOPIENNE KI",NULL},
/* 12AB */ { "SYLLABE ÉTHIOPIENNE KA",NULL},
/* 12AC */ { "SYLLABE ÉTHIOPIENNE KÉ",NULL},
/* 12AD */ { "SYLLABE ÉTHIOPIENNE KE",NULL},
/* 12AE */ { "SYLLABE ÉTHIOPIENNE KO",NULL},
/* 12AF */ { "SYLLABE ÉTHIOPIENNE KOÄ",NULL},
/* 12B0 */ { "SYLLABE ÉTHIOPIENNE KWÄ",NULL},
/* 12B1 */ { NULL,NULL},
/* 12B2 */ { "SYLLABE ÉTHIOPIENNE KWI",NULL},
/* 12B3 */ { "SYLLABE ÉTHIOPIENNE KWA",NULL},
/* 12B4 */ { "SYLLABE ÉTHIOPIENNE KWÉ",NULL},
/* 12B5 */ { "SYLLABE ÉTHIOPIENNE KWE",NULL},
/* 12B6 */ { NULL,NULL},
/* 12B7 */ { NULL,NULL},
/* 12B8 */ { "SYLLABE ÉTHIOPIENNE KXÄ",NULL},
/* 12B9 */ { "SYLLABE ÉTHIOPIENNE KXOU",NULL},
/* 12BA */ { "SYLLABE ÉTHIOPIENNE KXI",NULL},
/* 12BB */ { "SYLLABE ÉTHIOPIENNE KXA",NULL},
/* 12BC */ { "SYLLABE ÉTHIOPIENNE KXÉ",NULL},
/* 12BD */ { "SYLLABE ÉTHIOPIENNE KXE",NULL},
/* 12BE */ { "SYLLABE ÉTHIOPIENNE KXO",NULL},
/* 12BF */ { NULL,NULL},
/* 12C0 */ { "SYLLABE ÉTHIOPIENNE KXWÄ",NULL},
/* 12C1 */ { NULL,NULL},
/* 12C2 */ { "SYLLABE ÉTHIOPIENNE KXWI",NULL},
/* 12C3 */ { "SYLLABE ÉTHIOPIENNE KXWA",NULL},
/* 12C4 */ { "SYLLABE ÉTHIOPIENNE KXWÉ",NULL},
/* 12C5 */ { "SYLLABE ÉTHIOPIENNE KXWE",NULL},
/* 12C6 */ { NULL,NULL},
/* 12C7 */ { NULL,NULL},
/* 12C8 */ { "SYLLABE ÉTHIOPIENNE WÄ",NULL},
/* 12C9 */ { "SYLLABE ÉTHIOPIENNE WOU",NULL},
/* 12CA */ { "SYLLABE ÉTHIOPIENNE WI",NULL},
/* 12CB */ { "SYLLABE ÉTHIOPIENNE WA",NULL},
/* 12CC */ { "SYLLABE ÉTHIOPIENNE WÉ",NULL},
/* 12CD */ { "SYLLABE ÉTHIOPIENNE WE",NULL},
/* 12CE */ { "SYLLABE ÉTHIOPIENNE WO",NULL},
/* 12CF */ { "SYLLABE ÉTHIOPIENNE WOÄ",NULL},
/* 12D0 */ { "SYLLABE ÉTHIOPIENNE Ä PHARYNGAL",NULL},
/* 12D1 */ { "SYLLABE ÉTHIOPIENNE OU PHARYNGAL",NULL},
/* 12D2 */ { "SYLLABE ÉTHIOPIENNE I PHARYNGAL",NULL},
/* 12D3 */ { "SYLLABE ÉTHIOPIENNE A PHARYNGAL",NULL},
/* 12D4 */ { "SYLLABE ÉTHIOPIENNE É PHARYNGAL",NULL},
/* 12D5 */ { "SYLLABE ÉTHIOPIENNE E PHARYNGAL",NULL},
/* 12D6 */ { "SYLLABE ÉTHIOPIENNE O PHARYNGAL",NULL},
/* 12D7 */ { NULL,NULL},
/* 12D8 */ { "SYLLABE ÉTHIOPIENNE ZÄ",NULL},
/* 12D9 */ { "SYLLABE ÉTHIOPIENNE ZOU",NULL},
/* 12DA */ { "SYLLABE ÉTHIOPIENNE ZI",NULL},
/* 12DB */ { "SYLLABE ÉTHIOPIENNE ZA",NULL},
/* 12DC */ { "SYLLABE ÉTHIOPIENNE ZÉ",NULL},
/* 12DD */ { "SYLLABE ÉTHIOPIENNE ZE",NULL},
/* 12DE */ { "SYLLABE ÉTHIOPIENNE ZO",NULL},
/* 12DF */ { "SYLLABE ÉTHIOPIENNE ZWA",NULL},
/* 12E0 */ { "SYLLABE ÉTHIOPIENNE JÄ",NULL},
/* 12E1 */ { "SYLLABE ÉTHIOPIENNE JOU",NULL},
/* 12E2 */ { "SYLLABE ÉTHIOPIENNE JI",NULL},
/* 12E3 */ { "SYLLABE ÉTHIOPIENNE JA",NULL},
/* 12E4 */ { "SYLLABE ÉTHIOPIENNE JÉ",NULL},
/* 12E5 */ { "SYLLABE ÉTHIOPIENNE JE",NULL},
/* 12E6 */ { "SYLLABE ÉTHIOPIENNE JO",NULL},
/* 12E7 */ { "SYLLABE ÉTHIOPIENNE JWA",NULL},
/* 12E8 */ { "SYLLABE ÉTHIOPIENNE YÄ",NULL},
/* 12E9 */ { "SYLLABE ÉTHIOPIENNE YOU",NULL},
/* 12EA */ { "SYLLABE ÉTHIOPIENNE YI",NULL},
/* 12EB */ { "SYLLABE ÉTHIOPIENNE YA",NULL},
/* 12EC */ { "SYLLABE ÉTHIOPIENNE YÉ",NULL},
/* 12ED */ { "SYLLABE ÉTHIOPIENNE YE",NULL},
/* 12EE */ { "SYLLABE ÉTHIOPIENNE YO",NULL},
/* 12EF */ { "SYLLABE ÉTHIOPIENNE YOÄ",NULL},
/* 12F0 */ { "SYLLABE ÉTHIOPIENNE DÄ",NULL},
/* 12F1 */ { "SYLLABE ÉTHIOPIENNE DOU",NULL},
/* 12F2 */ { "SYLLABE ÉTHIOPIENNE DI",NULL},
/* 12F3 */ { "SYLLABE ÉTHIOPIENNE DA",NULL},
/* 12F4 */ { "SYLLABE ÉTHIOPIENNE DÉ",NULL},
/* 12F5 */ { "SYLLABE ÉTHIOPIENNE DE",NULL},
/* 12F6 */ { "SYLLABE ÉTHIOPIENNE DO",NULL},
/* 12F7 */ { "SYLLABE ÉTHIOPIENNE DWA",NULL},
/* 12F8 */ { "SYLLABE ÉTHIOPIENNE DDÄ",NULL},
/* 12F9 */ { "SYLLABE ÉTHIOPIENNE DDOU",NULL},
/* 12FA */ { "SYLLABE ÉTHIOPIENNE DDI",NULL},
/* 12FB */ { "SYLLABE ÉTHIOPIENNE DDA",NULL},
/* 12FC */ { "SYLLABE ÉTHIOPIENNE DDÉ",NULL},
/* 12FD */ { "SYLLABE ÉTHIOPIENNE DDE",NULL},
/* 12FE */ { "SYLLABE ÉTHIOPIENNE DDO",NULL},
/* 12FF */ { "SYLLABE ÉTHIOPIENNE DDWA",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_13[] = {
/* 1300 */ { "SYLLABE ÉTHIOPIENNE DJÄ",NULL},
/* 1301 */ { "SYLLABE ÉTHIOPIENNE DJOU",NULL},
/* 1302 */ { "SYLLABE ÉTHIOPIENNE DJI",NULL},
/* 1303 */ { "SYLLABE ÉTHIOPIENNE DJA",NULL},
/* 1304 */ { "SYLLABE ÉTHIOPIENNE DJÉ",NULL},
/* 1305 */ { "SYLLABE ÉTHIOPIENNE DJE",NULL},
/* 1306 */ { "SYLLABE ÉTHIOPIENNE DJO",NULL},
/* 1307 */ { "SYLLABE ÉTHIOPIENNE DJWA",NULL},
/* 1308 */ { "SYLLABE ÉTHIOPIENNE GÄ",NULL},
/* 1309 */ { "SYLLABE ÉTHIOPIENNE GOU",NULL},
/* 130A */ { "SYLLABE ÉTHIOPIENNE GI",NULL},
/* 130B */ { "SYLLABE ÉTHIOPIENNE GA",NULL},
/* 130C */ { "SYLLABE ÉTHIOPIENNE GÉ",NULL},
/* 130D */ { "SYLLABE ÉTHIOPIENNE GE",NULL},
/* 130E */ { "SYLLABE ÉTHIOPIENNE GO",NULL},
/* 130F */ { "SYLLABE ÉTHIOPIENNE GOÄ",NULL},
/* 1310 */ { "SYLLABE ÉTHIOPIENNE GWÄ",NULL},
/* 1311 */ { NULL,NULL},
/* 1312 */ { "SYLLABE ÉTHIOPIENNE GWI",NULL},
/* 1313 */ { "SYLLABE ÉTHIOPIENNE GWA",NULL},
/* 1314 */ { "SYLLABE ÉTHIOPIENNE GWÉ",NULL},
/* 1315 */ { "SYLLABE ÉTHIOPIENNE GWE",NULL},
/* 1316 */ { NULL,NULL},
/* 1317 */ { NULL,NULL},
/* 1318 */ { "SYLLABE ÉTHIOPIENNE GGÄ",NULL},
/* 1319 */ { "SYLLABE ÉTHIOPIENNE GGOU",NULL},
/* 131A */ { "SYLLABE ÉTHIOPIENNE GGI",NULL},
/* 131B */ { "SYLLABE ÉTHIOPIENNE GGA",NULL},
/* 131C */ { "SYLLABE ÉTHIOPIENNE GGÉ",NULL},
/* 131D */ { "SYLLABE ÉTHIOPIENNE GGE",NULL},
/* 131E */ { "SYLLABE ÉTHIOPIENNE GGO",NULL},
/* 131F */ { "SYLLABE ÉTHIOPIENNE GGWA",NULL},
/* 1320 */ { "SYLLABE ÉTHIOPIENNE THÄ",NULL},
/* 1321 */ { "SYLLABE ÉTHIOPIENNE THOU",NULL},
/* 1322 */ { "SYLLABE ÉTHIOPIENNE THI",NULL},
/* 1323 */ { "SYLLABE ÉTHIOPIENNE THA",NULL},
/* 1324 */ { "SYLLABE ÉTHIOPIENNE THÉ",NULL},
/* 1325 */ { "SYLLABE ÉTHIOPIENNE THE",NULL},
/* 1326 */ { "SYLLABE ÉTHIOPIENNE THO",NULL},
/* 1327 */ { "SYLLABE ÉTHIOPIENNE THWA",NULL},
/* 1328 */ { "SYLLABE ÉTHIOPIENNE TTCHÄ",NULL},
/* 1329 */ { "SYLLABE ÉTHIOPIENNE TTCHOU",NULL},
/* 132A */ { "SYLLABE ÉTHIOPIENNE TTCHI",NULL},
/* 132B */ { "SYLLABE ÉTHIOPIENNE TTCHA",NULL},
/* 132C */ { "SYLLABE ÉTHIOPIENNE TTCHÉ",NULL},
/* 132D */ { "SYLLABE ÉTHIOPIENNE TTCHE",NULL},
/* 132E */ { "SYLLABE ÉTHIOPIENNE TTCHO",NULL},
/* 132F */ { "SYLLABE ÉTHIOPIENNE TTCHWA",NULL},
/* 1330 */ { "SYLLABE ÉTHIOPIENNE PHÄ",NULL},
/* 1331 */ { "SYLLABE ÉTHIOPIENNE PHOU",NULL},
/* 1332 */ { "SYLLABE ÉTHIOPIENNE PHI",NULL},
/* 1333 */ { "SYLLABE ÉTHIOPIENNE PHA",NULL},
/* 1334 */ { "SYLLABE ÉTHIOPIENNE PHÉ",NULL},
/* 1335 */ { "SYLLABE ÉTHIOPIENNE PHE",NULL},
/* 1336 */ { "SYLLABE ÉTHIOPIENNE PHO",NULL},
/* 1337 */ { "SYLLABE ÉTHIOPIENNE PHWA",NULL},
/* 1338 */ { "SYLLABE ÉTHIOPIENNE TSÄ",NULL},
/* 1339 */ { "SYLLABE ÉTHIOPIENNE TSOU",NULL},
/* 133A */ { "SYLLABE ÉTHIOPIENNE TSI",NULL},
/* 133B */ { "SYLLABE ÉTHIOPIENNE TSA",NULL},
/* 133C */ { "SYLLABE ÉTHIOPIENNE TSÉ",NULL},
/* 133D */ { "SYLLABE ÉTHIOPIENNE TSE",NULL},
/* 133E */ { "SYLLABE ÉTHIOPIENNE TSO",NULL},
/* 133F */ { "SYLLABE ÉTHIOPIENNE TSWA",NULL},
/* 1340 */ { "SYLLABE ÉTHIOPIENNE TZÄ",NULL},
/* 1341 */ { "SYLLABE ÉTHIOPIENNE TZOU",NULL},
/* 1342 */ { "SYLLABE ÉTHIOPIENNE TZI",NULL},
/* 1343 */ { "SYLLABE ÉTHIOPIENNE TZA",NULL},
/* 1344 */ { "SYLLABE ÉTHIOPIENNE TZÉ",NULL},
/* 1345 */ { "SYLLABE ÉTHIOPIENNE TZE",NULL},
/* 1346 */ { "SYLLABE ÉTHIOPIENNE TZO",NULL},
/* 1347 */ { "SYLLABE ÉTHIOPIENNE TZOÄ",NULL},
/* 1348 */ { "SYLLABE ÉTHIOPIENNE FÄ",NULL},
/* 1349 */ { "SYLLABE ÉTHIOPIENNE FOU",NULL},
/* 134A */ { "SYLLABE ÉTHIOPIENNE FI",NULL},
/* 134B */ { "SYLLABE ÉTHIOPIENNE FA",NULL},
/* 134C */ { "SYLLABE ÉTHIOPIENNE FÉ",NULL},
/* 134D */ { "SYLLABE ÉTHIOPIENNE FE",NULL},
/* 134E */ { "SYLLABE ÉTHIOPIENNE FO",NULL},
/* 134F */ { "SYLLABE ÉTHIOPIENNE FWA",NULL},
/* 1350 */ { "SYLLABE ÉTHIOPIENNE PÄ",NULL},
/* 1351 */ { "SYLLABE ÉTHIOPIENNE POU",NULL},
/* 1352 */ { "SYLLABE ÉTHIOPIENNE PI",NULL},
/* 1353 */ { "SYLLABE ÉTHIOPIENNE PA",NULL},
/* 1354 */ { "SYLLABE ÉTHIOPIENNE PÉ",NULL},
/* 1355 */ { "SYLLABE ÉTHIOPIENNE PE",NULL},
/* 1356 */ { "SYLLABE ÉTHIOPIENNE PO",NULL},
/* 1357 */ { "SYLLABE ÉTHIOPIENNE PWA",NULL},
/* 1358 */ { "SYLLABE ÉTHIOPIENNE RYÄ",NULL},
/* 1359 */ { "SYLLABE ÉTHIOPIENNE MYÄ",NULL},
/* 135A */ { "SYLLABE ÉTHIOPIENNE FYÄ",NULL},
/* 135B */ { NULL,NULL},
/* 135C */ { NULL,NULL},
/* 135D */ { "DIACRITIQUE ÉTHIOPIEN DE GÉMINATION ET DE LONGUEUR DE VOYELLE","	* basketo"},
/* 135E */ { "DIACRITIQUE ÉTHIOPIEN DE LONGUEUR DE VOYELLE","	* basketo"},
/* 135F */ { "DIACRITIQUE ÉTHIOPIEN DE GÉMINATION",NULL},
/* 1360 */ { "REPÈRE DE SECTION ÉTHIOPIEN",NULL},
/* 1361 */ { "ESPACE ÉTHIOPIENNE",NULL},
/* 1362 */ { "POINT ÉTHIOPIEN",NULL},
/* 1363 */ { "VIRGULE ÉTHIOPIENNE",NULL},
/* 1364 */ { "POINT-VIRGULE ÉTHIOPIEN",NULL},
/* 1365 */ { "DEUX-POINTS ÉTHIOPIEN",NULL},
/* 1366 */ { "DEUX-POINTS DE PRÉFACE ÉTHIOPIEN",NULL},
/* 1367 */ { "POINT D'INTERROGATION ÉTHIOPIEN",NULL},
/* 1368 */ { "SÉPARATEUR DE PARAGRAPHES ÉTHIOPIEN",NULL},
/* 1369 */ { "CHIFFRE ÉTHIOPIEN UN",NULL},
/* 136A */ { "CHIFFRE ÉTHIOPIEN DEUX",NULL},
/* 136B */ { "CHIFFRE ÉTHIOPIEN TROIS",NULL},
/* 136C */ { "CHIFFRE ÉTHIOPIEN QUATRE",NULL},
/* 136D */ { "CHIFFRE ÉTHIOPIEN CINQ",NULL},
/* 136E */ { "CHIFFRE ÉTHIOPIEN SIX",NULL},
/* 136F */ { "CHIFFRE ÉTHIOPIEN SEPT",NULL},
/* 1370 */ { "CHIFFRE ÉTHIOPIEN HUIT",NULL},
/* 1371 */ { "CHIFFRE ÉTHIOPIEN NEUF",NULL},
/* 1372 */ { "NOMBRE ÉTHIOPIEN DIX",NULL},
/* 1373 */ { "NOMBRE ÉTHIOPIEN VINGT",NULL},
/* 1374 */ { "NOMBRE ÉTHIOPIEN TRENTE",NULL},
/* 1375 */ { "NOMBRE ÉTHIOPIEN QUARANTE",NULL},
/* 1376 */ { "NOMBRE ÉTHIOPIEN CINQUANTE",NULL},
/* 1377 */ { "NOMBRE ÉTHIOPIEN SOIXANTE",NULL},
/* 1378 */ { "NOMBRE ÉTHIOPIEN SOIXANTE-DIX","	= nombre éthiopien septante"},
/* 1379 */ { "NOMBRE ÉTHIOPIEN QUATRE-VINGTS","	= nombre éthiopien huitante"},
/* 137A */ { "NOMBRE ÉTHIOPIEN QUATRE-VINGT-DIX","	= nombre éthiopien nonante"},
/* 137B */ { "NOMBRE ÉTHIOPIEN CENT",NULL},
/* 137C */ { "NOMBRE ÉTHIOPIEN DIX MILLE",NULL},
/* 137D */ { NULL,NULL},
/* 137E */ { NULL,NULL},
/* 137F */ { NULL,NULL},
/* 1380 */ { "SYLLABE ÉTHIOPIENNE MWÄ",NULL},
/* 1381 */ { "SYLLABE ÉTHIOPIENNE MWI",NULL},
/* 1382 */ { "SYLLABE ÉTHIOPIENNE MWÉ",NULL},
/* 1383 */ { "SYLLABE ÉTHIOPIENNE MWE",NULL},
/* 1384 */ { "SYLLABE ÉTHIOPIENNE BWÄ",NULL},
/* 1385 */ { "SYLLABE ÉTHIOPIENNE BWI",NULL},
/* 1386 */ { "SYLLABE ÉTHIOPIENNE BWÉ",NULL},
/* 1387 */ { "SYLLABE ÉTHIOPIENNE BWE",NULL},
/* 1388 */ { "SYLLABE ÉTHIOPIENNE FWÄ",NULL},
/* 1389 */ { "SYLLABE ÉTHIOPIENNE FWI",NULL},
/* 138A */ { "SYLLABE ÉTHIOPIENNE FWÉ",NULL},
/* 138B */ { "SYLLABE ÉTHIOPIENNE FWE",NULL},
/* 138C */ { "SYLLABE ÉTHIOPIENNE PWÄ",NULL},
/* 138D */ { "SYLLABE ÉTHIOPIENNE PWI",NULL},
/* 138E */ { "SYLLABE ÉTHIOPIENNE PWÉ",NULL},
/* 138F */ { "SYLLABE ÉTHIOPIENNE PWE",NULL},
/* 1390 */ { "SIGNE DE TON ÉTHIOPIEN YEZÄT","	* pause ou accentuation"},
/* 1391 */ { "SIGNE DE TON ÉTHIOPIEN DÄRÄT","	* la mélodie s'arrête, le ton monte"},
/* 1392 */ { "SIGNE DE TON ÉTHIOPIEN REKREK","	* répétition du son"},
/* 1393 */ { "SIGNE DE TON ÉTHIOPIEN BREF REKREK",NULL},
/* 1394 */ { "SIGNE DE TON ÉTHIOPIEN DEFAT","	* le ton devrait baisser au début de la lettre"},
/* 1395 */ { "SIGNE DE TON ÉTHIOPIEN KENAT","	* soutenir la mélodie, hausser le ton"},
/* 1396 */ { "SIGNE DE TON ÉTHIOPIEN TTCHERÄT","	* la mélodie s'accélère"},
/* 1397 */ { "SIGNE DE TON ÉTHIOPIEN HIDÄT","	* la psalmodie enjambe plusieurs mots"},
/* 1398 */ { "SIGNE DE TON ÉTHIOPIEN DÄRÄT-HIDÄT","	* ton continu montant"},
/* 1399 */ { "SIGNE DE TON ÉTHIOPIEN KOURT","	* tenue du dernier mot et pause"},
/* 139A */ { NULL,NULL},
/* 139B */ { NULL,NULL},
/* 139C */ { NULL,NULL},
/* 139D */ { NULL,NULL},
/* 139E */ { NULL,NULL},
/* 139F */ { NULL,NULL},
/* 13A0 */ { "SYLLABE CHÉROKIE A",NULL},
/* 13A1 */ { "SYLLABE CHÉROKIE É",NULL},
/* 13A2 */ { "SYLLABE CHÉROKIE I",NULL},
/* 13A3 */ { "SYLLABE CHÉROKIE O",NULL},
/* 13A4 */ { "SYLLABE CHÉROKIE OU",NULL},
/* 13A5 */ { "SYLLABE CHÉROKIE ËN","	= syllabe chérokie v\n"
	"	= schwa nasal chéroki"},
/* 13A6 */ { "SYLLABE CHÉROKIE GA",NULL},
/* 13A7 */ { "SYLLABE CHÉROKIE KA",NULL},
/* 13A8 */ { "SYLLABE CHÉROKIE GUÉ",NULL},
/* 13A9 */ { "SYLLABE CHÉROKIE GUI",NULL},
/* 13AA */ { "SYLLABE CHÉROKIE GO",NULL},
/* 13AB */ { "SYLLABE CHÉROKIE GOU",NULL},
/* 13AC */ { "SYLLABE CHÉROKIE GUËN","	= syllabe chérokie gv"},
/* 13AD */ { "SYLLABE CHÉROKIE HA",NULL},
/* 13AE */ { "SYLLABE CHÉROKIE HÉ",NULL},
/* 13AF */ { "SYLLABE CHÉROKIE HI",NULL},
/* 13B0 */ { "SYLLABE CHÉROKIE HO",NULL},
/* 13B1 */ { "SYLLABE CHÉROKIE HOU",NULL},
/* 13B2 */ { "SYLLABE CHÉROKIE HËN","	= syllabe chérokie hv"},
/* 13B3 */ { "SYLLABE CHÉROKIE LA",NULL},
/* 13B4 */ { "SYLLABE CHÉROKIE LÉ",NULL},
/* 13B5 */ { "SYLLABE CHÉROKIE LI",NULL},
/* 13B6 */ { "SYLLABE CHÉROKIE LO",NULL},
/* 13B7 */ { "SYLLABE CHÉROKIE LOU",NULL},
/* 13B8 */ { "SYLLABE CHÉROKIE LËN","	= syllabe chérokie lv"},
/* 13B9 */ { "SYLLABE CHÉROKIE MA",NULL},
/* 13BA */ { "SYLLABE CHÉROKIE MÉ",NULL},
/* 13BB */ { "SYLLABE CHÉROKIE MI",NULL},
/* 13BC */ { "SYLLABE CHÉROKIE MO",NULL},
/* 13BD */ { "SYLLABE CHÉROKIE MOU",NULL},
/* 13BE */ { "SYLLABE CHÉROKIE NA",NULL},
/* 13BF */ { "SYLLABE CHÉROKIE HNA",NULL},
/* 13C0 */ { "SYLLABE CHÉROKIE NAH",NULL},
/* 13C1 */ { "SYLLABE CHÉROKIE NÉ",NULL},
/* 13C2 */ { "SYLLABE CHÉROKIE NI",NULL},
/* 13C3 */ { "SYLLABE CHÉROKIE NO",NULL},
/* 13C4 */ { "SYLLABE CHÉROKIE NOU",NULL},
/* 13C5 */ { "SYLLABE CHÉROKIE NËN","	= syllabe chérokie nv"},
/* 13C6 */ { "SYLLABE CHÉROKIE KWA",NULL},
/* 13C7 */ { "SYLLABE CHÉROKIE KWÉ",NULL},
/* 13C8 */ { "SYLLABE CHÉROKIE KWI",NULL},
/* 13C9 */ { "SYLLABE CHÉROKIE KWO",NULL},
/* 13CA */ { "SYLLABE CHÉROKIE KWOU",NULL},
/* 13CB */ { "SYLLABE CHÉROKIE KWËN","	= syllabe chérokie quv"},
/* 13CC */ { "SYLLABE CHÉROKIE SA",NULL},
/* 13CD */ { "SYLLABE CHÉROKIE S",NULL},
/* 13CE */ { "SYLLABE CHÉROKIE SÉ",NULL},
/* 13CF */ { "SYLLABE CHÉROKIE SI",NULL},
/* 13D0 */ { "SYLLABE CHÉROKIE SO",NULL},
/* 13D1 */ { "SYLLABE CHÉROKIE SOU",NULL},
/* 13D2 */ { "SYLLABE CHÉROKIE SËN","	= syllabe chérokie sv"},
/* 13D3 */ { "SYLLABE CHÉROKIE DA",NULL},
/* 13D4 */ { "SYLLABE CHÉROKIE TA",NULL},
/* 13D5 */ { "SYLLABE CHÉROKIE DÉ",NULL},
/* 13D6 */ { "SYLLABE CHÉROKIE TÉ",NULL},
/* 13D7 */ { "SYLLABE CHÉROKIE DI",NULL},
/* 13D8 */ { "SYLLABE CHÉROKIE TI",NULL},
/* 13D9 */ { "SYLLABE CHÉROKIE DO",NULL},
/* 13DA */ { "SYLLABE CHÉROKIE DOU",NULL},
/* 13DB */ { "SYLLABE CHÉROKIE DËN","	= syllabe chérokie dv"},
/* 13DC */ { "SYLLABE CHÉROKIE DLA",NULL},
/* 13DD */ { "SYLLABE CHÉROKIE TLA",NULL},
/* 13DE */ { "SYLLABE CHÉROKIE TLÉ",NULL},
/* 13DF */ { "SYLLABE CHÉROKIE TLI",NULL},
/* 13E0 */ { "SYLLABE CHÉROKIE TLO",NULL},
/* 13E1 */ { "SYLLABE CHÉROKIE TLOU",NULL},
/* 13E2 */ { "SYLLABE CHÉROKIE TLËN","	= syllabe chérokie tlv"},
/* 13E3 */ { "SYLLABE CHÉROKIE TSA",NULL},
/* 13E4 */ { "SYLLABE CHÉROKIE TSÉ",NULL},
/* 13E5 */ { "SYLLABE CHÉROKIE TSI",NULL},
/* 13E6 */ { "SYLLABE CHÉROKIE TSO",NULL},
/* 13E7 */ { "SYLLABE CHÉROKIE TSOU",NULL},
/* 13E8 */ { "SYLLABE CHÉROKIE TSËN","	= syllabe chérokie tsv"},
/* 13E9 */ { "SYLLABE CHÉROKIE WA",NULL},
/* 13EA */ { "SYLLABE CHÉROKIE WÉ",NULL},
/* 13EB */ { "SYLLABE CHÉROKIE WI",NULL},
/* 13EC */ { "SYLLABE CHÉROKIE WO",NULL},
/* 13ED */ { "SYLLABE CHÉROKIE WOU",NULL},
/* 13EE */ { "SYLLABE CHÉROKIE WËN","	= syllabe chérokie wv"},
/* 13EF */ { "SYLLABE CHÉROKIE YA",NULL},
/* 13F0 */ { "SYLLABE CHÉROKIE YÉ",NULL},
/* 13F1 */ { "SYLLABE CHÉROKIE YI",NULL},
/* 13F2 */ { "SYLLABE CHÉROKIE YO",NULL},
/* 13F3 */ { "SYLLABE CHÉROKIE YOU",NULL},
/* 13F4 */ { "SYLLABE CHÉROKIE YËN","	= syllabe chérokie yv"},
/* 13F5 */ { "SYLLABE CHÉROKIE MËN","	= syllabe chérokie mv"},
/* 13F6 */ { NULL,NULL},
/* 13F7 */ { NULL,NULL},
/* 13F8 */ { "SYLLABE CHÉROKIE MINUSCULE YÉ",NULL},
/* 13F9 */ { "SYLLABE CHÉROKIE MINUSCULE YI",NULL},
/* 13FA */ { "SYLLABE CHÉROKIE MINUSCULE YO",NULL},
/* 13FB */ { "SYLLABE CHÉROKIE MINUSCULE YOU",NULL},
/* 13FC */ { "SYLLABE CHÉROKIE MINUSCULE YËN","	= syllabe chérokie minuscule yv"},
/* 13FD */ { "SYLLABE CHÉROKIE MINUSCULE MËN","	= syllabe chérokie minuscule mv"},
/* 13FE */ { NULL,NULL},
/* 13FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_14[] = {
/* 1400 */ { "TRAIT D'UNION SYLLABE CANADIENNE",NULL},
/* 1401 */ { "SYLLABE CANADIENNE É","	* inuktitut (AÏ), porteur (OU)"},
/* 1402 */ { "SYLLABE CANADIENNE ÂÏ","	* inuktitut"},
/* 1403 */ { "SYLLABE CANADIENNE I","	* porteur (O)"},
/* 1404 */ { "SYLLABE CANADIENNE Î",NULL},
/* 1405 */ { "SYLLABE CANADIENNE O","	* inuktitut (OU), porteur (É)"},
/* 1406 */ { "SYLLABE CANADIENNE Ô","	* inuktitut (OÛ)"},
/* 1407 */ { "SYLLABE CANADIENNE Ô CRI-Y",NULL},
/* 1408 */ { "SYLLABE CANADIENNE É PORTEUR",NULL},
/* 1409 */ { "SYLLABE CANADIENNE I PORTEUR",NULL},
/* 140A */ { "SYLLABE CANADIENNE A",NULL},
/* 140B */ { "SYLLABE CANADIENNE Â",NULL},
/* 140C */ { "SYLLABE CANADIENNE OUÉ",NULL},
/* 140D */ { "SYLLABE CANADIENNE OUÉ CRI DES PLAINES",NULL},
/* 140E */ { "SYLLABE CANADIENNE OUI",NULL},
/* 140F */ { "SYLLABE CANADIENNE OUI CRI DES PLAINES",NULL},
/* 1410 */ { "SYLLABE CANADIENNE OUÎ",NULL},
/* 1411 */ { "SYLLABE CANADIENNE OUÎ CRI DES PLAINES",NULL},
/* 1412 */ { "SYLLABE CANADIENNE OUO",NULL},
/* 1413 */ { "SYLLABE CANADIENNE OUO CRI DES PLAINES",NULL},
/* 1414 */ { "SYLLABE CANADIENNE OUÔ",NULL},
/* 1415 */ { "SYLLABE CANADIENNE OUÔ CRI DES PLAINES",NULL},
/* 1416 */ { "SYLLABE CANADIENNE OUÔ NASKAPI",NULL},
/* 1417 */ { "SYLLABE CANADIENNE OUA",NULL},
/* 1418 */ { "SYLLABE CANADIENNE OUA CRI DES PLAINES",NULL},
/* 1419 */ { "SYLLABE CANADIENNE OUÂ",NULL},
/* 141A */ { "SYLLABE CANADIENNE OUÂ CRI DES PLAINES",NULL},
/* 141B */ { "SYLLABE CANADIENNE OUÂ NASKAPI",NULL},
/* 141C */ { "SYLLABE CANADIENNE AÏ","	* cri oriental"},
/* 141D */ { "SYLLABE CANADIENNE OU CRI-Y",NULL},
/* 141E */ { "SYLLABE CANADIENNE COUP DE GLOTTE","	* cri de Moose (Y), algonquien (COUP DE GLOTTE)"},
/* 141F */ { "SYLLABE CANADIENNE FINALE ACCENT AIGU","	* cri occidental (T), cri oriental (Y), inuktitut (COUP DE GLOTTE)\n"
	"	* athabascan (B/P), sayisi (I), porteur (G)"},
/* 1420 */ { "SYLLABE CANADIENNE FINALE ACCENT GRAVE","	* cri occidental (K), athabascan (K), porteur (KH)"},
/* 1421 */ { "SYLLABE CANADIENNE FINALE DEMI-ROND INFÉRIEUR","	* cri-n (CH), sayisi (R), porteur (NG)"},
/* 1422 */ { "SYLLABE CANADIENNE FINALE DEMI-ROND SUPÉRIEUR","	* algonquien (S), tchipéwayan (R), sayisi (S)"},
/* 1423 */ { "SYLLABE CANADIENNE FINALE DEMI-ROND DROIT","	* cri occidental (N), athabascan (D/T), sayisi (N), porteur (N)"},
/* 1424 */ { "SYLLABE CANADIENNE FINALE ROND","	* cri occidental (OU), sayisi (O)"},
/* 1425 */ { "SYLLABE CANADIENNE FINALE DOUBLE ACCENT AIGU","	* tchipéwayan (TT), esclave du Sud (GH)"},
/* 1426 */ { "SYLLABE CANADIENNE FINALE DOUBLES TRAITS VERTICAUX COURTS","	* algonquien (H), porteur (R)"},
/* 1427 */ { "SYLLABE CANADIENNE FINALE POINT MÉDIAN","	* cri de Moose (OU), athabascan (Y), sayisi (YOU), pied-noir (S)"},
/* 1428 */ { "SYLLABE CANADIENNE FINALE TRAIT HORIZONTAL COURT","	* cri occidental (C), sayisi (D)"},
/* 1429 */ { "SYLLABE CANADIENNE FINALE SIGNE PLUS","	* athabascan (N), sayisi (AÏ)"},
/* 142A */ { "SYLLABE CANADIENNE FINALE TAQUET VERS LE BAS","	* cri-n (L), porteur (D)\n"
	"	x (taquet vers le bas - 22A4)"},
/* 142B */ { "SYLLABE CANADIENNE ENNE",NULL},
/* 142C */ { "SYLLABE CANADIENNE INNE",NULL},
/* 142D */ { "SYLLABE CANADIENNE ONNE",NULL},
/* 142E */ { "SYLLABE CANADIENNE ANNE",NULL},
/* 142F */ { "SYLLABE CANADIENNE PÉ","	* inuktitut (PAÏ), athabascan (BÉ), porteur (HOU)"},
/* 1430 */ { "SYLLABE CANADIENNE PÂÏ","	* inuktitut"},
/* 1431 */ { "SYLLABE CANADIENNE PI",NULL},
/* 1432 */ { "SYLLABE CANADIENNE PÎ",NULL},
/* 1433 */ { "SYLLABE CANADIENNE PO","	* inuktitut (POU), athabascan (BO), porteur (HÉ)"},
/* 1434 */ { "SYLLABE CANADIENNE PÔ","	* inuktitut (POÛ)"},
/* 1435 */ { "SYLLABE CANADIENNE PÔ CRI-Y",NULL},
/* 1436 */ { "SYLLABE CANADIENNE HÉ PORTEUR",NULL},
/* 1437 */ { "SYLLABE CANADIENNE HI PORTEUR",NULL},
/* 1438 */ { "SYLLABE CANADIENNE PA","	* athabascan (BA), porteur (HA)"},
/* 1439 */ { "SYLLABE CANADIENNE PÂ",NULL},
/* 143A */ { "SYLLABE CANADIENNE POUÉ",NULL},
/* 143B */ { "SYLLABE CANADIENNE POUÉ CRI DES PLAINES",NULL},
/* 143C */ { "SYLLABE CANADIENNE POUI",NULL},
/* 143D */ { "SYLLABE CANADIENNE POUI CRI DES PLAINES",NULL},
/* 143E */ { "SYLLABE CANADIENNE POUÎ",NULL},
/* 143F */ { "SYLLABE CANADIENNE POUÎ CRI DES PLAINES",NULL},
/* 1440 */ { "SYLLABE CANADIENNE POUO",NULL},
/* 1441 */ { "SYLLABE CANADIENNE POUO CRI DES PLAINES",NULL},
/* 1442 */ { "SYLLABE CANADIENNE POUÔ",NULL},
/* 1443 */ { "SYLLABE CANADIENNE POUÔ CRI DES PLAINES",NULL},
/* 1444 */ { "SYLLABE CANADIENNE POUA",NULL},
/* 1445 */ { "SYLLABE CANADIENNE POUA CRI DES PLAINES",NULL},
/* 1446 */ { "SYLLABE CANADIENNE POUÂ",NULL},
/* 1447 */ { "SYLLABE CANADIENNE POUÂ CRI DES PLAINES",NULL},
/* 1448 */ { "SYLLABE CANADIENNE POUÂ CRI-Y",NULL},
/* 1449 */ { "SYLLABE CANADIENNE P","	* pied-noir (Y)"},
/* 144A */ { "SYLLABE CANADIENNE P CRI DES PLAINES","	* sayisi (G)"},
/* 144B */ { "SYLLABE CANADIENNE H PORTEUR",NULL},
/* 144C */ { "SYLLABE CANADIENNE TÉ","	* inuktitut (TAÏ), athabascan (DI), porteur (DOU)"},
/* 144D */ { "SYLLABE CANADIENNE TÂÏ","	* inuktitut"},
/* 144E */ { "SYLLABE CANADIENNE TI","	* athabascan (DÉ), porteur (DO)"},
/* 144F */ { "SYLLABE CANADIENNE TÎ",NULL},
/* 1450 */ { "SYLLABE CANADIENNE TO","	* inuktitut (TOU), athabascan (DO), porteur (DÉ), sayisi (DOU)"},
/* 1451 */ { "SYLLABE CANADIENNE TÔ","	* inuktitut (TOÛ)"},
/* 1452 */ { "SYLLABE CANADIENNE TÔ CRI-Y",NULL},
/* 1453 */ { "SYLLABE CANADIENNE DÉ PORTEUR",NULL},
/* 1454 */ { "SYLLABE CANADIENNE DI PORTEUR",NULL},
/* 1455 */ { "SYLLABE CANADIENNE TA","	* athabascan (DA)"},
/* 1456 */ { "SYLLABE CANADIENNE TÂ",NULL},
/* 1457 */ { "SYLLABE CANADIENNE TOUÉ",NULL},
/* 1458 */ { "SYLLABE CANADIENNE TOUÉ CRI DES PLAINES",NULL},
/* 1459 */ { "SYLLABE CANADIENNE TOUI",NULL},
/* 145A */ { "SYLLABE CANADIENNE TOUI CRI DES PLAINES",NULL},
/* 145B */ { "SYLLABE CANADIENNE TOUÎ",NULL},
/* 145C */ { "SYLLABE CANADIENNE TOUÎ CRI DES PLAINES",NULL},
/* 145D */ { "SYLLABE CANADIENNE TOUO",NULL},
/* 145E */ { "SYLLABE CANADIENNE TOUO CRI DES PLAINES",NULL},
/* 145F */ { "SYLLABE CANADIENNE TOUÔ",NULL},
/* 1460 */ { "SYLLABE CANADIENNE TOUÔ CRI DES PLAINES",NULL},
/* 1461 */ { "SYLLABE CANADIENNE TOUA",NULL},
/* 1462 */ { "SYLLABE CANADIENNE TOUA CRI DES PLAINES",NULL},
/* 1463 */ { "SYLLABE CANADIENNE TOUÂ",NULL},
/* 1464 */ { "SYLLABE CANADIENNE TOUÂ CRI DES PLAINES",NULL},
/* 1465 */ { "SYLLABE CANADIENNE TOUÂ NASKAPI",NULL},
/* 1466 */ { "SYLLABE CANADIENNE T",NULL},
/* 1467 */ { "SYLLABE CANADIENNE TTÉ","	* esclave du Sud (DEH)"},
/* 1468 */ { "SYLLABE CANADIENNE TTI","	* esclave du Sud (DIH)"},
/* 1469 */ { "SYLLABE CANADIENNE TTO","	* esclave du Sud (DOH)"},
/* 146A */ { "SYLLABE CANADIENNE TTA","	* esclave du Sud (DAH)"},
/* 146B */ { "SYLLABE CANADIENNE KÉ","	* inuktitut (KAÏ), pied-noir (PA)"},
/* 146C */ { "SYLLABE CANADIENNE KÂÏ","	* inuktitut"},
/* 146D */ { "SYLLABE CANADIENNE KI","	* pied-noir (PÉ)"},
/* 146E */ { "SYLLABE CANADIENNE KÎ",NULL},
/* 146F */ { "SYLLABE CANADIENNE KO","	* inuktitut (KOU), sayisi (KOU), pied-noir (PI)"},
/* 1470 */ { "SYLLABE CANADIENNE KÔ","	* inuktitut (KOÛ)"},
/* 1471 */ { "SYLLABE CANADIENNE KÔ CRI-Y",NULL},
/* 1472 */ { "SYLLABE CANADIENNE KA","	* pied-noir (PO)"},
/* 1473 */ { "SYLLABE CANADIENNE KÂ",NULL},
/* 1474 */ { "SYLLABE CANADIENNE KOUÉ",NULL},
/* 1475 */ { "SYLLABE CANADIENNE KOUÉ CRI DES PLAINES",NULL},
/* 1476 */ { "SYLLABE CANADIENNE KOUI",NULL},
/* 1477 */ { "SYLLABE CANADIENNE KOUI CRI DES PLAINES",NULL},
/* 1478 */ { "SYLLABE CANADIENNE KOUÎ",NULL},
/* 1479 */ { "SYLLABE CANADIENNE KOUÎ CRI DES PLAINES",NULL},
/* 147A */ { "SYLLABE CANADIENNE KOUO",NULL},
/* 147B */ { "SYLLABE CANADIENNE KOUO CRI DES PLAINES",NULL},
/* 147C */ { "SYLLABE CANADIENNE KOUÔ",NULL},
/* 147D */ { "SYLLABE CANADIENNE KOUÔ CRI DES PLAINES",NULL},
/* 147E */ { "SYLLABE CANADIENNE KOUA",NULL},
/* 147F */ { "SYLLABE CANADIENNE KOUA CRI DES PLAINES",NULL},
/* 1480 */ { "SYLLABE CANADIENNE KOUÂ",NULL},
/* 1481 */ { "SYLLABE CANADIENNE KOUÂ CRI DES PLAINES",NULL},
/* 1482 */ { "SYLLABE CANADIENNE KOUÂ NASKAPI",NULL},
/* 1483 */ { "SYLLABE CANADIENNE K",NULL},
/* 1484 */ { "SYLLABE CANADIENNE KOU","	* cri oriental"},
/* 1485 */ { "SYLLABE CANADIENNE KÉH ESCLAVE DU SUD",NULL},
/* 1486 */ { "SYLLABE CANADIENNE KIH ESCLAVE DU SUD",NULL},
/* 1487 */ { "SYLLABE CANADIENNE KOH ESCLAVE DU SUD",NULL},
/* 1488 */ { "SYLLABE CANADIENNE KAH ESCLAVE DU SUD",NULL},
/* 1489 */ { "SYLLABE CANADIENNE TCHÉ","	* inuktitut (GAÏ), athabascan (DHE), sayisi (THE), pied-noir (MA)"},
/* 148A */ { "SYLLABE CANADIENNE TCHÂÏ","	* inuktitut (GÂÏ)"},
/* 148B */ { "SYLLABE CANADIENNE TCHI","	* inuktitut (GI), athabascan (DHI), sayisi (THI), pied-noir (MÉ)"},
/* 148C */ { "SYLLABE CANADIENNE TCHÎ","	* inuktitut (GÎ)"},
/* 148D */ { "SYLLABE CANADIENNE TCHO","	* inuktitut (GOU), athabascan (DHO), sayisi (tho), pied-noir (mi)"},
/* 148E */ { "SYLLABE CANADIENNE TCHÔ","	* inuktitut (GOÛ)"},
/* 148F */ { "SYLLABE CANADIENNE TCHÔ CRI-Y",NULL},
/* 1490 */ { "SYLLABE CANADIENNE TCHA","	* inuktitut (GA), athabascan (DHA), sayisi (THA), pied-noir (MO)"},
/* 1491 */ { "SYLLABE CANADIENNE TCHÂ","	* inuktitut (GÂ)"},
/* 1492 */ { "SYLLABE CANADIENNE TCHOUÉ",NULL},
/* 1493 */ { "SYLLABE CANADIENNE TCHOUÉ CRI DES PLAINES",NULL},
/* 1494 */ { "SYLLABE CANADIENNE TCHOUI",NULL},
/* 1495 */ { "SYLLABE CANADIENNE TCHOUI CRI DES PLAINES",NULL},
/* 1496 */ { "SYLLABE CANADIENNE TCHOUÎ",NULL},
/* 1497 */ { "SYLLABE CANADIENNE TCHOUÎ CRI DES PLAINES",NULL},
/* 1498 */ { "SYLLABE CANADIENNE TCHOUO",NULL},
/* 1499 */ { "SYLLABE CANADIENNE TCHOUO CRI DES PLAINES",NULL},
/* 149A */ { "SYLLABE CANADIENNE TCHOUÔ",NULL},
/* 149B */ { "SYLLABE CANADIENNE TCHOUÔ CRI DES PLAINES",NULL},
/* 149C */ { "SYLLABE CANADIENNE TCHOUA",NULL},
/* 149D */ { "SYLLABE CANADIENNE TCHOUA CRI DES PLAINES",NULL},
/* 149E */ { "SYLLABE CANADIENNE TCHOUÂ",NULL},
/* 149F */ { "SYLLABE CANADIENNE TCHOUÂ CRI DES PLAINES",NULL},
/* 14A0 */ { "SYLLABE CANADIENNE TCHOUÂ NASKAPI",NULL},
/* 14A1 */ { "SYLLABE CANADIENNE TCH","	* inuktitut (G), sayisi (T)"},
/* 14A2 */ { "SYLLABE CANADIENNE TH SAYISI","	* athabascan (DH)"},
/* 14A3 */ { "SYLLABE CANADIENNE MÉ","	* inuktitut (MAÏ), pied-noir (TA)"},
/* 14A4 */ { "SYLLABE CANADIENNE MÂÏ","	* inuktitut"},
/* 14A5 */ { "SYLLABE CANADIENNE MI","	* pied-noir (TÉ)"},
/* 14A6 */ { "SYLLABE CANADIENNE MÎ",NULL},
/* 14A7 */ { "SYLLABE CANADIENNE MO","	* inuktitut (MOU), sayisi (MOU), pied-noir (TI)"},
/* 14A8 */ { "SYLLABE CANADIENNE MÔ","	* inuktitut (MOÛ)"},
/* 14A9 */ { "SYLLABE CANADIENNE MÔ CRI-Y",NULL},
/* 14AA */ { "SYLLABE CANADIENNE MA","	* pied-noir (TO)"},
/* 14AB */ { "SYLLABE CANADIENNE MÂ",NULL},
/* 14AC */ { "SYLLABE CANADIENNE MOUÉ",NULL},
/* 14AD */ { "SYLLABE CANADIENNE MOUÉ CRI DES PLAINES",NULL},
/* 14AE */ { "SYLLABE CANADIENNE MOUI",NULL},
/* 14AF */ { "SYLLABE CANADIENNE MOUI CRI DES PLAINES",NULL},
/* 14B0 */ { "SYLLABE CANADIENNE MOUÎ",NULL},
/* 14B1 */ { "SYLLABE CANADIENNE MOUÎ CRI DES PLAINES",NULL},
/* 14B2 */ { "SYLLABE CANADIENNE MOUO",NULL},
/* 14B3 */ { "SYLLABE CANADIENNE MOUO CRI DES PLAINES",NULL},
/* 14B4 */ { "SYLLABE CANADIENNE MOUÔ",NULL},
/* 14B5 */ { "SYLLABE CANADIENNE MOUÔ CRI DES PLAINES",NULL},
/* 14B6 */ { "SYLLABE CANADIENNE MOUA",NULL},
/* 14B7 */ { "SYLLABE CANADIENNE MOUA CRI DES PLAINES",NULL},
/* 14B8 */ { "SYLLABE CANADIENNE MOUÂ",NULL},
/* 14B9 */ { "SYLLABE CANADIENNE MOUÂ CRI DES PLAINES",NULL},
/* 14BA */ { "SYLLABE CANADIENNE MOUÂ NASKAPI",NULL},
/* 14BB */ { "SYLLABE CANADIENNE M",NULL},
/* 14BC */ { "SYLLABE CANADIENNE M CRI DES PLAINES","	* porteur (M)"},
/* 14BD */ { "SYLLABE CANADIENNE MH",NULL},
/* 14BE */ { "SYLLABE CANADIENNE M ATHABASCAN",NULL},
/* 14BF */ { "SYLLABE CANADIENNE M SAYISI",NULL},
/* 14C0 */ { "SYLLABE CANADIENNE NÉ","	* inuktitut (NAÏ)"},
/* 14C1 */ { "SYLLABE CANADIENNE NÂÏ","	* inuktitut"},
/* 14C2 */ { "SYLLABE CANADIENNE NI",NULL},
/* 14C3 */ { "SYLLABE CANADIENNE NÎ",NULL},
/* 14C4 */ { "SYLLABE CANADIENNE NO","	* inuktitut (NOU), sayisi (NOU)"},
/* 14C5 */ { "SYLLABE CANADIENNE NÔ","	* inuktitut (NOÛ)"},
/* 14C6 */ { "SYLLABE CANADIENNE NÔ CRI-Y",NULL},
/* 14C7 */ { "SYLLABE CANADIENNE NA",NULL},
/* 14C8 */ { "SYLLABE CANADIENNE NÂ",NULL},
/* 14C9 */ { "SYLLABE CANADIENNE NOUÉ",NULL},
/* 14CA */ { "SYLLABE CANADIENNE NOUÉ CRI DES PLAINES",NULL},
/* 14CB */ { "SYLLABE CANADIENNE NOUA",NULL},
/* 14CC */ { "SYLLABE CANADIENNE NOUA CRI DES PLAINES",NULL},
/* 14CD */ { "SYLLABE CANADIENNE NOUÂ",NULL},
/* 14CE */ { "SYLLABE CANADIENNE NOUÂ CRI DES PLAINES",NULL},
/* 14CF */ { "SYLLABE CANADIENNE NOUÂ NASKAPI",NULL},
/* 14D0 */ { "SYLLABE CANADIENNE N",NULL},
/* 14D1 */ { "SYLLABE CANADIENNE NG PORTEUR",NULL},
/* 14D2 */ { "SYLLABE CANADIENNE NH",NULL},
/* 14D3 */ { "SYLLABE CANADIENNE LÉ","	* inuktitut (LAÏ)"},
/* 14D4 */ { "SYLLABE CANADIENNE LÂÏ","	* inuktitut"},
/* 14D5 */ { "SYLLABE CANADIENNE LI",NULL},
/* 14D6 */ { "SYLLABE CANADIENNE LÎ",NULL},
/* 14D7 */ { "SYLLABE CANADIENNE LO","	* inuktitut (LOU)"},
/* 14D8 */ { "SYLLABE CANADIENNE LÔ","	* inuktitut (LOÛ)"},
/* 14D9 */ { "SYLLABE CANADIENNE LÔ CRI-Y",NULL},
/* 14DA */ { "SYLLABE CANADIENNE LA",NULL},
/* 14DB */ { "SYLLABE CANADIENNE LÂ",NULL},
/* 14DC */ { "SYLLABE CANADIENNE LOUÉ",NULL},
/* 14DD */ { "SYLLABE CANADIENNE LOUÉ CRI DES PLAINES",NULL},
/* 14DE */ { "SYLLABE CANADIENNE LOUI",NULL},
/* 14DF */ { "SYLLABE CANADIENNE LOUI CRI DES PLAINES",NULL},
/* 14E0 */ { "SYLLABE CANADIENNE LOUÎ",NULL},
/* 14E1 */ { "SYLLABE CANADIENNE LOUÎ CRI DES PLAINES",NULL},
/* 14E2 */ { "SYLLABE CANADIENNE LOUO",NULL},
/* 14E3 */ { "SYLLABE CANADIENNE LOUO CRI DES PLAINES",NULL},
/* 14E4 */ { "SYLLABE CANADIENNE LOUÔ",NULL},
/* 14E5 */ { "SYLLABE CANADIENNE LOUÔ CRI DES PLAINES",NULL},
/* 14E6 */ { "SYLLABE CANADIENNE LOUA",NULL},
/* 14E7 */ { "SYLLABE CANADIENNE LOUA CRI DES PLAINES",NULL},
/* 14E8 */ { "SYLLABE CANADIENNE LOUÂ",NULL},
/* 14E9 */ { "SYLLABE CANADIENNE LOUÂ CRI DES PLAINES",NULL},
/* 14EA */ { "SYLLABE CANADIENNE L",NULL},
/* 14EB */ { "SYLLABE CANADIENNE L CRI DES PLAINES",NULL},
/* 14EC */ { "SYLLABE CANADIENNE L MÉDIAL",NULL},
/* 14ED */ { "SYLLABE CANADIENNE SÉ","	* inuktitut (SAÏ), pied-noir (SA)"},
/* 14EE */ { "SYLLABE CANADIENNE SÂÏ","	* inuktitut"},
/* 14EF */ { "SYLLABE CANADIENNE SI","	* pied-noir (SÉ)"},
/* 14F0 */ { "SYLLABE CANADIENNE SÎ",NULL},
/* 14F1 */ { "SYLLABE CANADIENNE SO","	* inuktitut (SOU), sayisi (SOU), pied-noir (SI)"},
/* 14F2 */ { "SYLLABE CANADIENNE SÔ","	* inuktitut (SOÛ)"},
/* 14F3 */ { "SYLLABE CANADIENNE SÔ CRI-Y",NULL},
/* 14F4 */ { "SYLLABE CANADIENNE SA","	* pied-noir (SO)"},
/* 14F5 */ { "SYLLABE CANADIENNE SÂ",NULL},
/* 14F6 */ { "SYLLABE CANADIENNE SOUÉ",NULL},
/* 14F7 */ { "SYLLABE CANADIENNE SOUÉ CRI DES PLAINES",NULL},
/* 14F8 */ { "SYLLABE CANADIENNE SOUI",NULL},
/* 14F9 */ { "SYLLABE CANADIENNE SOUI CRI DES PLAINES",NULL},
/* 14FA */ { "SYLLABE CANADIENNE SOUÎ",NULL},
/* 14FB */ { "SYLLABE CANADIENNE SOUÎ CRI DES PLAINES",NULL},
/* 14FC */ { "SYLLABE CANADIENNE SOUO",NULL},
/* 14FD */ { "SYLLABE CANADIENNE SOUO CRI DES PLAINES",NULL},
/* 14FE */ { "SYLLABE CANADIENNE SOUÔ",NULL},
/* 14FF */ { "SYLLABE CANADIENNE SOUÔ CRI DES PLAINES",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_15[] = {
/* 1500 */ { "SYLLABE CANADIENNE SOUA",NULL},
/* 1501 */ { "SYLLABE CANADIENNE SOUA CRI DES PLAINES",NULL},
/* 1502 */ { "SYLLABE CANADIENNE SOUÂ",NULL},
/* 1503 */ { "SYLLABE CANADIENNE SOUÂ CRI DES PLAINES",NULL},
/* 1504 */ { "SYLLABE CANADIENNE SOUÂ NASKAPI",NULL},
/* 1505 */ { "SYLLABE CANADIENNE S",NULL},
/* 1506 */ { "SYLLABE CANADIENNE S ATHABASCAN",NULL},
/* 1507 */ { "SYLLABE CANADIENNE SOU",NULL},
/* 1508 */ { "SYLLABE CANADIENNE S PIED-NOIR",NULL},
/* 1509 */ { "SYLLABE CANADIENNE SK CRI DE MOOSE",NULL},
/* 150A */ { "SYLLABE CANADIENNE SKOU NASKAPI",NULL},
/* 150B */ { "SYLLABE CANADIENNE S-OU NASKAPI",NULL},
/* 150C */ { "SYLLABE CANADIENNE SPOUA NASKAPI",NULL},
/* 150D */ { "SYLLABE CANADIENNE STOUA NASKAPI",NULL},
/* 150E */ { "SYLLABE CANADIENNE SKOUA NASKAPI",NULL},
/* 150F */ { "SYLLABE CANADIENNE STCHOUA NASKAPI",NULL},
/* 1510 */ { "SYLLABE CANADIENNE CHÉ",NULL},
/* 1511 */ { "SYLLABE CANADIENNE CHI",NULL},
/* 1512 */ { "SYLLABE CANADIENNE CHÎ",NULL},
/* 1513 */ { "SYLLABE CANADIENNE CHO",NULL},
/* 1514 */ { "SYLLABE CANADIENNE CHÔ",NULL},
/* 1515 */ { "SYLLABE CANADIENNE CHA",NULL},
/* 1516 */ { "SYLLABE CANADIENNE CHÂ",NULL},
/* 1517 */ { "SYLLABE CANADIENNE CHOUÉ",NULL},
/* 1518 */ { "SYLLABE CANADIENNE CHOUÉ CRI DES PLAINES",NULL},
/* 1519 */ { "SYLLABE CANADIENNE CHOUI",NULL},
/* 151A */ { "SYLLABE CANADIENNE CHOUI CRI DES PLAINES",NULL},
/* 151B */ { "SYLLABE CANADIENNE CHOUÎ",NULL},
/* 151C */ { "SYLLABE CANADIENNE CHOUÎ CRI DES PLAINES",NULL},
/* 151D */ { "SYLLABE CANADIENNE CHOUO",NULL},
/* 151E */ { "SYLLABE CANADIENNE CHOUO CRI DES PLAINES",NULL},
/* 151F */ { "SYLLABE CANADIENNE CHOUÔ",NULL},
/* 1520 */ { "SYLLABE CANADIENNE CHOUÔ CRI DES PLAINES",NULL},
/* 1521 */ { "SYLLABE CANADIENNE CHOUA",NULL},
/* 1522 */ { "SYLLABE CANADIENNE CHOUA CRI DES PLAINES",NULL},
/* 1523 */ { "SYLLABE CANADIENNE CHOUÂ",NULL},
/* 1524 */ { "SYLLABE CANADIENNE CHOUÂ CRI DES PLAINES",NULL},
/* 1525 */ { "SYLLABE CANADIENNE CH",NULL},
/* 1526 */ { "SYLLABE CANADIENNE YÉ","	* inuktitut (yaï), pied-noir (YA)"},
/* 1527 */ { "SYLLABE CANADIENNE YÂÏ","	* inuktitut"},
/* 1528 */ { "SYLLABE CANADIENNE YI","	* pied-noir (YÉ)"},
/* 1529 */ { "SYLLABE CANADIENNE YÎ",NULL},
/* 152A */ { "SYLLABE CANADIENNE YO","	* inuktitut (you), pied-noir (YI)"},
/* 152B */ { "SYLLABE CANADIENNE YÔ","	* inuktitut (YOÛ)"},
/* 152C */ { "SYLLABE CANADIENNE YÔ CRI-Y",NULL},
/* 152D */ { "SYLLABE CANADIENNE YA","	* pied-noir (YO)"},
/* 152E */ { "SYLLABE CANADIENNE YÂ",NULL},
/* 152F */ { "SYLLABE CANADIENNE YOUÉ",NULL},
/* 1530 */ { "SYLLABE CANADIENNE YOUÉ CRI DES PLAINES",NULL},
/* 1531 */ { "SYLLABE CANADIENNE YOUI",NULL},
/* 1532 */ { "SYLLABE CANADIENNE YOUI CRI DES PLAINES",NULL},
/* 1533 */ { "SYLLABE CANADIENNE YOUÎ",NULL},
/* 1534 */ { "SYLLABE CANADIENNE YOUÎ CRI DES PLAINES",NULL},
/* 1535 */ { "SYLLABE CANADIENNE YOUO",NULL},
/* 1536 */ { "SYLLABE CANADIENNE YOUO CRI DES PLAINES",NULL},
/* 1537 */ { "SYLLABE CANADIENNE YOUÔ",NULL},
/* 1538 */ { "SYLLABE CANADIENNE YOUÔ CRI DES PLAINES",NULL},
/* 1539 */ { "SYLLABE CANADIENNE YOUA",NULL},
/* 153A */ { "SYLLABE CANADIENNE YOUA CRI DES PLAINES",NULL},
/* 153B */ { "SYLLABE CANADIENNE YOUÂ",NULL},
/* 153C */ { "SYLLABE CANADIENNE YOUÂ CRI DES PLAINES",NULL},
/* 153D */ { "SYLLABE CANADIENNE YOUÂ NASKAPI",NULL},
/* 153E */ { "SYLLABE CANADIENNE Y",NULL},
/* 153F */ { "SYLLABE CANADIENNE Y CRI BIBLIQUE",NULL},
/* 1540 */ { "SYLLABE CANADIENNE Y CRI DES PLAINES",NULL},
/* 1541 */ { "SYLLABE CANADIENNE YI SAYISI",NULL},
/* 1542 */ { "SYLLABE CANADIENNE RÉ","	* inuktitut (RAÏ)"},
/* 1543 */ { "SYLLABE CANADIENNE RÉ CRI-R","	* athabascan (LÉ)"},
/* 1544 */ { "SYLLABE CANADIENNE LÉ CRI DES PLAINES","	* athabascan (LI)"},
/* 1545 */ { "SYLLABE CANADIENNE RÂÏ","	* inuktitut"},
/* 1546 */ { "SYLLABE CANADIENNE RI",NULL},
/* 1547 */ { "SYLLABE CANADIENNE RÎ",NULL},
/* 1548 */ { "SYLLABE CANADIENNE RO","	* inuktitut (ROU)"},
/* 1549 */ { "SYLLABE CANADIENNE RÔ","	* inuktitut (ROÛ)"},
/* 154A */ { "SYLLABE CANADIENNE LO CRI DES PLAINES","	* sayisi (LOU)"},
/* 154B */ { "SYLLABE CANADIENNE RA",NULL},
/* 154C */ { "SYLLABE CANADIENNE RÂ",NULL},
/* 154D */ { "SYLLABE CANADIENNE LA CRI DES PLAINES",NULL},
/* 154E */ { "SYLLABE CANADIENNE ROUÂ",NULL},
/* 154F */ { "SYLLABE CANADIENNE ROUÂ CRI DES PLAINES",NULL},
/* 1550 */ { "SYLLABE CANADIENNE R",NULL},
/* 1551 */ { "SYLLABE CANADIENNE R CRI DES PLAINES",NULL},
/* 1552 */ { "SYLLABE CANADIENNE R MÉDIAL",NULL},
/* 1553 */ { "SYLLABE CANADIENNE FÉ","	* inuktitut (FAÏ)"},
/* 1554 */ { "SYLLABE CANADIENNE FÂÏ","	* inuktitut"},
/* 1555 */ { "SYLLABE CANADIENNE FI",NULL},
/* 1556 */ { "SYLLABE CANADIENNE FÎ",NULL},
/* 1557 */ { "SYLLABE CANADIENNE FO",NULL},
/* 1558 */ { "SYLLABE CANADIENNE FÔ",NULL},
/* 1559 */ { "SYLLABE CANADIENNE FA",NULL},
/* 155A */ { "SYLLABE CANADIENNE FÂ",NULL},
/* 155B */ { "SYLLABE CANADIENNE FOUÂ",NULL},
/* 155C */ { "SYLLABE CANADIENNE FOUÂ CRI DES PLAINES",NULL},
/* 155D */ { "SYLLABE CANADIENNE F",NULL},
/* 155E */ { "SYLLABE CANADIENNE THÉ","	* sayisi (TÉ)"},
/* 155F */ { "SYLLABE CANADIENNE THÉ CRI-N",NULL},
/* 1560 */ { "SYLLABE CANADIENNE THI","	* sayisi (TI)"},
/* 1561 */ { "SYLLABE CANADIENNE THI CRI-N",NULL},
/* 1562 */ { "SYLLABE CANADIENNE THÎ",NULL},
/* 1563 */ { "SYLLABE CANADIENNE THÎ CRI-N",NULL},
/* 1564 */ { "SYLLABE CANADIENNE THO","	* sayisi (TOU)"},
/* 1565 */ { "SYLLABE CANADIENNE THÔ",NULL},
/* 1566 */ { "SYLLABE CANADIENNE THA","	* sayisi (TA)"},
/* 1567 */ { "SYLLABE CANADIENNE THÂ",NULL},
/* 1568 */ { "SYLLABE CANADIENNE THOUÂ",NULL},
/* 1569 */ { "SYLLABE CANADIENNE THOUÂ CRI DES PLAINES",NULL},
/* 156A */ { "SYLLABE CANADIENNE TH",NULL},
/* 156B */ { "SYLLABE CANADIENNE TTHÉ",NULL},
/* 156C */ { "SYLLABE CANADIENNE TTHI",NULL},
/* 156D */ { "SYLLABE CANADIENNE TTHO","	* sayisi (TTHOU)"},
/* 156E */ { "SYLLABE CANADIENNE TTHA",NULL},
/* 156F */ { "SYLLABE CANADIENNE TTH","	* probablement une interprétation erronée d'un astérisque indiquant un nom propre\n"
	"	x (astérisque - 002A)"},
/* 1570 */ { "SYLLABE CANADIENNE TYÉ",NULL},
/* 1571 */ { "SYLLABE CANADIENNE TYI",NULL},
/* 1572 */ { "SYLLABE CANADIENNE TYO",NULL},
/* 1573 */ { "SYLLABE CANADIENNE TYA",NULL},
/* 1574 */ { "SYLLABE CANADIENNE HÉ DU NUNAVIK",NULL},
/* 1575 */ { "SYLLABE CANADIENNE HI DU NUNAVIK",NULL},
/* 1576 */ { "SYLLABE CANADIENNE HÎ DU NUNAVIK",NULL},
/* 1577 */ { "SYLLABE CANADIENNE HO DU NUNAVIK",NULL},
/* 1578 */ { "SYLLABE CANADIENNE HÔ DU NUNAVIK",NULL},
/* 1579 */ { "SYLLABE CANADIENNE HA DU NUNAVIK",NULL},
/* 157A */ { "SYLLABE CANADIENNE HÂ DU NUNAVIK",NULL},
/* 157B */ { "SYLLABE CANADIENNE H DU NUNAVIK",NULL},
/* 157C */ { "SYLLABE CANADIENNE H DU NUNAVUT",NULL},
/* 157D */ { "SYLLABE CANADIENNE HK","	* algonquien"},
/* 157E */ { "SYLLABE CANADIENNE QÂÏ","	* inuktitut"},
/* 157F */ { "SYLLABE CANADIENNE QI",NULL},
/* 1580 */ { "SYLLABE CANADIENNE QÎ",NULL},
/* 1581 */ { "SYLLABE CANADIENNE QO","	* inuktitut (QOU)"},
/* 1582 */ { "SYLLABE CANADIENNE QÔ","	* inuktitut (QOÛ)"},
/* 1583 */ { "SYLLABE CANADIENNE QA",NULL},
/* 1584 */ { "SYLLABE CANADIENNE QÂ",NULL},
/* 1585 */ { "SYLLABE CANADIENNE Q",NULL},
/* 1586 */ { "SYLLABE CANADIENNE TLHÉ","	* sayisi (KLÉ)"},
/* 1587 */ { "SYLLABE CANADIENNE TLHI","	* sayisi (KLI)"},
/* 1588 */ { "SYLLABE CANADIENNE TLHO","	* sayisi (KLOU)"},
/* 1589 */ { "SYLLABE CANADIENNE TLHA","	* sayisi (KLA)"},
/* 158A */ { "SYLLABE CANADIENNE RÉ CRI DES PLAINES",NULL},
/* 158B */ { "SYLLABE CANADIENNE RI CRI DES PLAINES",NULL},
/* 158C */ { "SYLLABE CANADIENNE RO CRI DES PLAINES",NULL},
/* 158D */ { "SYLLABE CANADIENNE RA CRI DES PLAINES",NULL},
/* 158E */ { "SYLLABE CANADIENNE NGÂÏ","	* inuktitut"},
/* 158F */ { "SYLLABE CANADIENNE NGI",NULL},
/* 1590 */ { "SYLLABE CANADIENNE NGÎ",NULL},
/* 1591 */ { "SYLLABE CANADIENNE NGO","	* inuktitut (NGOU)"},
/* 1592 */ { "SYLLABE CANADIENNE NGÔ","	* inuktitut (NGOÛ)"},
/* 1593 */ { "SYLLABE CANADIENNE NGA",NULL},
/* 1594 */ { "SYLLABE CANADIENNE NGÂ",NULL},
/* 1595 */ { "SYLLABE CANADIENNE NG",NULL},
/* 1596 */ { "SYLLABE CANADIENNE NNG",NULL},
/* 1597 */ { "SYLLABE CANADIENNE CHÉ SAYISI",NULL},
/* 1598 */ { "SYLLABE CANADIENNE CHI SAYISI",NULL},
/* 1599 */ { "SYLLABE CANADIENNE CHO SAYISI","	* sayisi (CHOU)"},
/* 159A */ { "SYLLABE CANADIENNE CHA SAYISI",NULL},
/* 159B */ { "SYLLABE CANADIENNE THÉ CRI DES BOIS",NULL},
/* 159C */ { "SYLLABE CANADIENNE THI CRI DES BOIS",NULL},
/* 159D */ { "SYLLABE CANADIENNE THO CRI DES BOIS",NULL},
/* 159E */ { "SYLLABE CANADIENNE THA CRI DES BOIS",NULL},
/* 159F */ { "SYLLABE CANADIENNE TH CRI DES BOIS",NULL},
/* 15A0 */ { "SYLLABE CANADIENNE LHI",NULL},
/* 15A1 */ { "SYLLABE CANADIENNE LHÎ",NULL},
/* 15A2 */ { "SYLLABE CANADIENNE LHO","	* inuktitut (LHOU)"},
/* 15A3 */ { "SYLLABE CANADIENNE LHÔ","	* inuktitut (LHOÛ)"},
/* 15A4 */ { "SYLLABE CANADIENNE LHA",NULL},
/* 15A5 */ { "SYLLABE CANADIENNE LHÂ",NULL},
/* 15A6 */ { "SYLLABE CANADIENNE LH",NULL},
/* 15A7 */ { "SYLLABE CANADIENNE THÉ CRI-TH",NULL},
/* 15A8 */ { "SYLLABE CANADIENNE THI CRI-TH",NULL},
/* 15A9 */ { "SYLLABE CANADIENNE THÎ CRI-TH",NULL},
/* 15AA */ { "SYLLABE CANADIENNE THO CRI-TH",NULL},
/* 15AB */ { "SYLLABE CANADIENNE THÔ CRI-TH",NULL},
/* 15AC */ { "SYLLABE CANADIENNE THA CRI-TH",NULL},
/* 15AD */ { "SYLLABE CANADIENNE THÂ CRI-TH",NULL},
/* 15AE */ { "SYLLABE CANADIENNE TH CRI-TH",NULL},
/* 15AF */ { "SYLLABE CANADIENNE B AÏVILIK",NULL},
/* 15B0 */ { "SYLLABE CANADIENNE É PIED-NOIR",NULL},
/* 15B1 */ { "SYLLABE CANADIENNE I PIED-NOIR",NULL},
/* 15B2 */ { "SYLLABE CANADIENNE O PIED-NOIR",NULL},
/* 15B3 */ { "SYLLABE CANADIENNE A PIED-NOIR",NULL},
/* 15B4 */ { "SYLLABE CANADIENNE OUÉ PIED-NOIR",NULL},
/* 15B5 */ { "SYLLABE CANADIENNE OUI PIED-NOIR",NULL},
/* 15B6 */ { "SYLLABE CANADIENNE OUO PIED-NOIR",NULL},
/* 15B7 */ { "SYLLABE CANADIENNE OUA PIED-NOIR",NULL},
/* 15B8 */ { "SYLLABE CANADIENNE NÉ PIED-NOIR",NULL},
/* 15B9 */ { "SYLLABE CANADIENNE NI PIED-NOIR",NULL},
/* 15BA */ { "SYLLABE CANADIENNE NO PIED-NOIR",NULL},
/* 15BB */ { "SYLLABE CANADIENNE NA PIED-NOIR",NULL},
/* 15BC */ { "SYLLABE CANADIENNE KÉ PIED-NOIR",NULL},
/* 15BD */ { "SYLLABE CANADIENNE KI PIED-NOIR",NULL},
/* 15BE */ { "SYLLABE CANADIENNE KO PIED-NOIR",NULL},
/* 15BF */ { "SYLLABE CANADIENNE KA PIED-NOIR",NULL},
/* 15C0 */ { "SYLLABE CANADIENNE HÉ SAYISI",NULL},
/* 15C1 */ { "SYLLABE CANADIENNE HI SAYISI",NULL},
/* 15C2 */ { "SYLLABE CANADIENNE HO SAYISI","	* sayisi (HOU)"},
/* 15C3 */ { "SYLLABE CANADIENNE HA SAYISI",NULL},
/* 15C4 */ { "SYLLABE CANADIENNE GHOU PORTEUR",NULL},
/* 15C5 */ { "SYLLABE CANADIENNE GHO PORTEUR",NULL},
/* 15C6 */ { "SYLLABE CANADIENNE GHE PORTEUR",NULL},
/* 15C7 */ { "SYLLABE CANADIENNE GHÉ PORTEUR",NULL},
/* 15C8 */ { "SYLLABE CANADIENNE GHI PORTEUR",NULL},
/* 15C9 */ { "SYLLABE CANADIENNE GHA PORTEUR",NULL},
/* 15CA */ { "SYLLABE CANADIENNE ROU PORTEUR",NULL},
/* 15CB */ { "SYLLABE CANADIENNE RO PORTEUR",NULL},
/* 15CC */ { "SYLLABE CANADIENNE RE PORTEUR",NULL},
/* 15CD */ { "SYLLABE CANADIENNE RÉ PORTEUR",NULL},
/* 15CE */ { "SYLLABE CANADIENNE RI PORTEUR",NULL},
/* 15CF */ { "SYLLABE CANADIENNE RA PORTEUR",NULL},
/* 15D0 */ { "SYLLABE CANADIENNE OUOU PORTEUR",NULL},
/* 15D1 */ { "SYLLABE CANADIENNE OUO PORTEUR",NULL},
/* 15D2 */ { "SYLLABE CANADIENNE OUE PORTEUR",NULL},
/* 15D3 */ { "SYLLABE CANADIENNE OUÉ PORTEUR",NULL},
/* 15D4 */ { "SYLLABE CANADIENNE OUI PORTEUR",NULL},
/* 15D5 */ { "SYLLABE CANADIENNE OUA PORTEUR",NULL},
/* 15D6 */ { "SYLLABE CANADIENNE HOUOU PORTEUR",NULL},
/* 15D7 */ { "SYLLABE CANADIENNE HOUO PORTEUR",NULL},
/* 15D8 */ { "SYLLABE CANADIENNE HOUE PORTEUR",NULL},
/* 15D9 */ { "SYLLABE CANADIENNE HOUÉ PORTEUR",NULL},
/* 15DA */ { "SYLLABE CANADIENNE HOUI PORTEUR",NULL},
/* 15DB */ { "SYLLABE CANADIENNE HOUA PORTEUR",NULL},
/* 15DC */ { "SYLLABE CANADIENNE THOU PORTEUR",NULL},
/* 15DD */ { "SYLLABE CANADIENNE THO PORTEUR",NULL},
/* 15DE */ { "SYLLABE CANADIENNE THE PORTEUR",NULL},
/* 15DF */ { "SYLLABE CANADIENNE THÉ PORTEUR",NULL},
/* 15E0 */ { "SYLLABE CANADIENNE THI PORTEUR",NULL},
/* 15E1 */ { "SYLLABE CANADIENNE THA PORTEUR",NULL},
/* 15E2 */ { "SYLLABE CANADIENNE TTOU PORTEUR",NULL},
/* 15E3 */ { "SYLLABE CANADIENNE TTO PORTEUR",NULL},
/* 15E4 */ { "SYLLABE CANADIENNE TTE PORTEUR",NULL},
/* 15E5 */ { "SYLLABE CANADIENNE TTÉ PORTEUR",NULL},
/* 15E6 */ { "SYLLABE CANADIENNE TTI PORTEUR",NULL},
/* 15E7 */ { "SYLLABE CANADIENNE TTA PORTEUR",NULL},
/* 15E8 */ { "SYLLABE CANADIENNE POU PORTEUR",NULL},
/* 15E9 */ { "SYLLABE CANADIENNE PO PORTEUR",NULL},
/* 15EA */ { "SYLLABE CANADIENNE PE PORTEUR",NULL},
/* 15EB */ { "SYLLABE CANADIENNE PÉ PORTEUR",NULL},
/* 15EC */ { "SYLLABE CANADIENNE PI PORTEUR",NULL},
/* 15ED */ { "SYLLABE CANADIENNE PA PORTEUR",NULL},
/* 15EE */ { "SYLLABE CANADIENNE P PORTEUR",NULL},
/* 15EF */ { "SYLLABE CANADIENNE GOU PORTEUR",NULL},
/* 15F0 */ { "SYLLABE CANADIENNE GO PORTEUR",NULL},
/* 15F1 */ { "SYLLABE CANADIENNE GE PORTEUR",NULL},
/* 15F2 */ { "SYLLABE CANADIENNE GÉ PORTEUR",NULL},
/* 15F3 */ { "SYLLABE CANADIENNE GI PORTEUR",NULL},
/* 15F4 */ { "SYLLABE CANADIENNE GA PORTEUR",NULL},
/* 15F5 */ { "SYLLABE CANADIENNE KHOU PORTEUR",NULL},
/* 15F6 */ { "SYLLABE CANADIENNE KHO PORTEUR",NULL},
/* 15F7 */ { "SYLLABE CANADIENNE KHE PORTEUR",NULL},
/* 15F8 */ { "SYLLABE CANADIENNE KHÉ PORTEUR",NULL},
/* 15F9 */ { "SYLLABE CANADIENNE KHI PORTEUR",NULL},
/* 15FA */ { "SYLLABE CANADIENNE KHA PORTEUR",NULL},
/* 15FB */ { "SYLLABE CANADIENNE KKOU PORTEUR",NULL},
/* 15FC */ { "SYLLABE CANADIENNE KKO PORTEUR",NULL},
/* 15FD */ { "SYLLABE CANADIENNE KKE PORTEUR",NULL},
/* 15FE */ { "SYLLABE CANADIENNE KKÉ PORTEUR",NULL},
/* 15FF */ { "SYLLABE CANADIENNE KKI PORTEUR",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_16[] = {
/* 1600 */ { "SYLLABE CANADIENNE KKA PORTEUR",NULL},
/* 1601 */ { "SYLLABE CANADIENNE KK PORTEUR",NULL},
/* 1602 */ { "SYLLABE CANADIENNE NOU PORTEUR",NULL},
/* 1603 */ { "SYLLABE CANADIENNE NO PORTEUR",NULL},
/* 1604 */ { "SYLLABE CANADIENNE NE PORTEUR",NULL},
/* 1605 */ { "SYLLABE CANADIENNE NÉ PORTEUR",NULL},
/* 1606 */ { "SYLLABE CANADIENNE NI PORTEUR",NULL},
/* 1607 */ { "SYLLABE CANADIENNE NA PORTEUR",NULL},
/* 1608 */ { "SYLLABE CANADIENNE MOU PORTEUR",NULL},
/* 1609 */ { "SYLLABE CANADIENNE MO PORTEUR",NULL},
/* 160A */ { "SYLLABE CANADIENNE ME PORTEUR",NULL},
/* 160B */ { "SYLLABE CANADIENNE MÉ PORTEUR",NULL},
/* 160C */ { "SYLLABE CANADIENNE MI PORTEUR",NULL},
/* 160D */ { "SYLLABE CANADIENNE MA PORTEUR",NULL},
/* 160E */ { "SYLLABE CANADIENNE YOU PORTEUR",NULL},
/* 160F */ { "SYLLABE CANADIENNE YO PORTEUR",NULL},
/* 1610 */ { "SYLLABE CANADIENNE YE PORTEUR",NULL},
/* 1611 */ { "SYLLABE CANADIENNE YÉ PORTEUR",NULL},
/* 1612 */ { "SYLLABE CANADIENNE YI PORTEUR",NULL},
/* 1613 */ { "SYLLABE CANADIENNE YA PORTEUR",NULL},
/* 1614 */ { "SYLLABE CANADIENNE DJOU PORTEUR","	* athabascan (ZA), sayisi (TZO), esclave du Sud (DHA)"},
/* 1615 */ { "SYLLABE CANADIENNE DJOU SAYISI","	* athabascan (ZO), sayisi (TZOU), esclave du Sud (DHO)"},
/* 1616 */ { "SYLLABE CANADIENNE DJO PORTEUR",NULL},
/* 1617 */ { "SYLLABE CANADIENNE DJE PORTEUR",NULL},
/* 1618 */ { "SYLLABE CANADIENNE DJÉ PORTEUR",NULL},
/* 1619 */ { "SYLLABE CANADIENNE DJI PORTEUR",NULL},
/* 161A */ { "SYLLABE CANADIENNE DJI SAYISI","	* athabascan (ZÉ), sayisi (TZÉ), esclave du Sud (DHÉ)"},
/* 161B */ { "SYLLABE CANADIENNE DJA PORTEUR","	* athabascan (ZI), sayisi (TZI), esclave du Sud (DHI)"},
/* 161C */ { "SYLLABE CANADIENNE DJJOU PORTEUR",NULL},
/* 161D */ { "SYLLABE CANADIENNE DJJO PORTEUR",NULL},
/* 161E */ { "SYLLABE CANADIENNE DJJE PORTEUR",NULL},
/* 161F */ { "SYLLABE CANADIENNE DJJÉ PORTEUR",NULL},
/* 1620 */ { "SYLLABE CANADIENNE DJJI PORTEUR",NULL},
/* 1621 */ { "SYLLABE CANADIENNE DJJA PORTEUR",NULL},
/* 1622 */ { "SYLLABE CANADIENNE LOU PORTEUR",NULL},
/* 1623 */ { "SYLLABE CANADIENNE LO PORTEUR",NULL},
/* 1624 */ { "SYLLABE CANADIENNE LE PORTEUR",NULL},
/* 1625 */ { "SYLLABE CANADIENNE LÉ PORTEUR",NULL},
/* 1626 */ { "SYLLABE CANADIENNE LI PORTEUR",NULL},
/* 1627 */ { "SYLLABE CANADIENNE LA PORTEUR",NULL},
/* 1628 */ { "SYLLABE CANADIENNE DLOU PORTEUR",NULL},
/* 1629 */ { "SYLLABE CANADIENNE DLO PORTEUR",NULL},
/* 162A */ { "SYLLABE CANADIENNE DLE PORTEUR",NULL},
/* 162B */ { "SYLLABE CANADIENNE DLÉ PORTEUR",NULL},
/* 162C */ { "SYLLABE CANADIENNE DLI PORTEUR",NULL},
/* 162D */ { "SYLLABE CANADIENNE DLA PORTEUR",NULL},
/* 162E */ { "SYLLABE CANADIENNE LHOU PORTEUR",NULL},
/* 162F */ { "SYLLABE CANADIENNE LHO PORTEUR",NULL},
/* 1630 */ { "SYLLABE CANADIENNE LHE PORTEUR",NULL},
/* 1631 */ { "SYLLABE CANADIENNE LHÉ PORTEUR",NULL},
/* 1632 */ { "SYLLABE CANADIENNE LHI PORTEUR",NULL},
/* 1633 */ { "SYLLABE CANADIENNE LHA PORTEUR",NULL},
/* 1634 */ { "SYLLABE CANADIENNE TLHOU PORTEUR",NULL},
/* 1635 */ { "SYLLABE CANADIENNE TLHO PORTEUR",NULL},
/* 1636 */ { "SYLLABE CANADIENNE TLHE PORTEUR",NULL},
/* 1637 */ { "SYLLABE CANADIENNE TLHÉ PORTEUR",NULL},
/* 1638 */ { "SYLLABE CANADIENNE TLHI PORTEUR",NULL},
/* 1639 */ { "SYLLABE CANADIENNE TLHA PORTEUR",NULL},
/* 163A */ { "SYLLABE CANADIENNE TLOU PORTEUR",NULL},
/* 163B */ { "SYLLABE CANADIENNE TLO PORTEUR",NULL},
/* 163C */ { "SYLLABE CANADIENNE TLE PORTEUR",NULL},
/* 163D */ { "SYLLABE CANADIENNE TLÉ PORTEUR",NULL},
/* 163E */ { "SYLLABE CANADIENNE TLI PORTEUR",NULL},
/* 163F */ { "SYLLABE CANADIENNE TLA PORTEUR",NULL},
/* 1640 */ { "SYLLABE CANADIENNE ZOU PORTEUR",NULL},
/* 1641 */ { "SYLLABE CANADIENNE ZO PORTEUR",NULL},
/* 1642 */ { "SYLLABE CANADIENNE ZE PORTEUR",NULL},
/* 1643 */ { "SYLLABE CANADIENNE ZÉ PORTEUR",NULL},
/* 1644 */ { "SYLLABE CANADIENNE ZI PORTEUR",NULL},
/* 1645 */ { "SYLLABE CANADIENNE ZA PORTEUR",NULL},
/* 1646 */ { "SYLLABE CANADIENNE Z PORTEUR",NULL},
/* 1647 */ { "SYLLABE CANADIENNE Z INITIAL PORTEUR",NULL},
/* 1648 */ { "SYLLABE CANADIENNE DZOU PORTEUR",NULL},
/* 1649 */ { "SYLLABE CANADIENNE DZO PORTEUR",NULL},
/* 164A */ { "SYLLABE CANADIENNE DZE PORTEUR",NULL},
/* 164B */ { "SYLLABE CANADIENNE DZÉ PORTEUR",NULL},
/* 164C */ { "SYLLABE CANADIENNE DZI PORTEUR",NULL},
/* 164D */ { "SYLLABE CANADIENNE DZA PORTEUR",NULL},
/* 164E */ { "SYLLABE CANADIENNE SOU PORTEUR",NULL},
/* 164F */ { "SYLLABE CANADIENNE SO PORTEUR",NULL},
/* 1650 */ { "SYLLABE CANADIENNE SE PORTEUR",NULL},
/* 1651 */ { "SYLLABE CANADIENNE SÉ PORTEUR",NULL},
/* 1652 */ { "SYLLABE CANADIENNE SI PORTEUR",NULL},
/* 1653 */ { "SYLLABE CANADIENNE SA PORTEUR",NULL},
/* 1654 */ { "SYLLABE CANADIENNE CHOU PORTEUR",NULL},
/* 1655 */ { "SYLLABE CANADIENNE CHO PORTEUR",NULL},
/* 1656 */ { "SYLLABE CANADIENNE CHE PORTEUR",NULL},
/* 1657 */ { "SYLLABE CANADIENNE CHÉ PORTEUR",NULL},
/* 1658 */ { "SYLLABE CANADIENNE CHI PORTEUR",NULL},
/* 1659 */ { "SYLLABE CANADIENNE CHA PORTEUR",NULL},
/* 165A */ { "SYLLABE CANADIENNE CH PORTEUR",NULL},
/* 165B */ { "SYLLABE CANADIENNE TSOU PORTEUR",NULL},
/* 165C */ { "SYLLABE CANADIENNE TSO PORTEUR",NULL},
/* 165D */ { "SYLLABE CANADIENNE TSE PORTEUR",NULL},
/* 165E */ { "SYLLABE CANADIENNE TSÉ PORTEUR",NULL},
/* 165F */ { "SYLLABE CANADIENNE TSI PORTEUR",NULL},
/* 1660 */ { "SYLLABE CANADIENNE TSA PORTEUR",NULL},
/* 1661 */ { "SYLLABE CANADIENNE TCHOU PORTEUR",NULL},
/* 1662 */ { "SYLLABE CANADIENNE TCHO PORTEUR",NULL},
/* 1663 */ { "SYLLABE CANADIENNE TCHE PORTEUR",NULL},
/* 1664 */ { "SYLLABE CANADIENNE TCHÉ PORTEUR",NULL},
/* 1665 */ { "SYLLABE CANADIENNE TCHI PORTEUR",NULL},
/* 1666 */ { "SYLLABE CANADIENNE TCHA PORTEUR",NULL},
/* 1667 */ { "SYLLABE CANADIENNE TTSOU PORTEUR",NULL},
/* 1668 */ { "SYLLABE CANADIENNE TTSO PORTEUR",NULL},
/* 1669 */ { "SYLLABE CANADIENNE TTSE PORTEUR",NULL},
/* 166A */ { "SYLLABE CANADIENNE TTSÉ PORTEUR",NULL},
/* 166B */ { "SYLLABE CANADIENNE TTSI PORTEUR",NULL},
/* 166C */ { "SYLLABE CANADIENNE TTSA PORTEUR",NULL},
/* 166D */ { "SIGNE SYLLABE CANADIENNE KHI","	* algonquien\n"
	"	* utilisé comme symbole du Christ\n"
	"	x (chrisme - 2627)"},
/* 166E */ { "POINT SYLLABE CANADIENNE","	x (point sténographique - 2E3C)"},
/* 166F */ { "SYLLABE CANADIENNE QAÏ",NULL},
/* 1670 */ { "SYLLABE CANADIENNE NGAÏ",NULL},
/* 1671 */ { "SYLLABE CANADIENNE NNGI",NULL},
/* 1672 */ { "SYLLABE CANADIENNE NNGÎ",NULL},
/* 1673 */ { "SYLLABE CANADIENNE NNGO","	* inuktitut (NNGOU)"},
/* 1674 */ { "SYLLABE CANADIENNE NNGÔ","	* inuktitut (NNGOÛ)"},
/* 1675 */ { "SYLLABE CANADIENNE NNGA",NULL},
/* 1676 */ { "SYLLABE CANADIENNE NNGÂ",NULL},
/* 1677 */ { "SYLLABE CANADIENNE THOUÉ CRI DES BOIS",NULL},
/* 1678 */ { "SYLLABE CANADIENNE THOUI CRI DES BOIS",NULL},
/* 1679 */ { "SYLLABE CANADIENNE THOUÎ CRI DES BOIS",NULL},
/* 167A */ { "SYLLABE CANADIENNE THOUO CRI DES BOIS",NULL},
/* 167B */ { "SYLLABE CANADIENNE THOUÔ CRI DES BOIS",NULL},
/* 167C */ { "SYLLABE CANADIENNE THOUA CRI DES BOIS",NULL},
/* 167D */ { "SYLLABE CANADIENNE THOUÂ CRI DES BOIS",NULL},
/* 167E */ { "SYLLABE CANADIENNE T FINAL CRI DES BOIS",NULL},
/* 167F */ { "SYLLABE CANADIENNE OU PIED-NOIR",NULL},
/* 1680 */ { "ESPACE D'OGAM","	* le glyphe est vierge dans les polices sans « jambage »\n"
	"	x (espace - 0020)"},
/* 1681 */ { "LETTRE D'OGAM BEITH",NULL},
/* 1682 */ { "LETTRE D'OGAM LUIS",NULL},
/* 1683 */ { "LETTRE D'OGAM FEARN",NULL},
/* 1684 */ { "LETTRE D'OGAM SAIL",NULL},
/* 1685 */ { "LETTRE D'OGAM NION",NULL},
/* 1686 */ { "LETTRE D'OGAM UATH",NULL},
/* 1687 */ { "LETTRE D'OGAM DAIR",NULL},
/* 1688 */ { "LETTRE D'OGAM TINNE",NULL},
/* 1689 */ { "LETTRE D'OGAM COLL",NULL},
/* 168A */ { "LETTRE D'OGAM CEIRT",NULL},
/* 168B */ { "LETTRE D'OGAM MUIN",NULL},
/* 168C */ { "LETTRE D'OGAM GORT",NULL},
/* 168D */ { "LETTRE D'OGAM NGÉADAL",NULL},
/* 168E */ { "LETTRE D'OGAM STRAIF",NULL},
/* 168F */ { "LETTRE D'OGAM RUIS",NULL},
/* 1690 */ { "LETTRE D'OGAM AILM",NULL},
/* 1691 */ { "LETTRE D'OGAM ONN",NULL},
/* 1692 */ { "LETTRE D'OGAM ÚR",NULL},
/* 1693 */ { "LETTRE D'OGAM EADHADH",NULL},
/* 1694 */ { "LETTRE D'OGAM IODHADH",NULL},
/* 1695 */ { "LETTRE D'OGAM ÉABHADH",NULL},
/* 1696 */ { "LETTRE D'OGAM ÓR",NULL},
/* 1697 */ { "LETTRE D'OGAM UILLEANN",NULL},
/* 1698 */ { "LETTRE D'OGAM IFÍN",NULL},
/* 1699 */ { "LETTRE D'OGAM EAMHANCHOLL",NULL},
/* 169A */ { "LETTRE D'OGAM PEITH",NULL},
/* 169B */ { "PLUME D'OGAM","	* indique le début d'un texte en alphabet ogamique"},
/* 169C */ { "PLUME RÉFLÉCHIE D'OGAM","	* indique la fin d'un texte en alphabet ogamique"},
/* 169D */ { NULL,NULL},
/* 169E */ { NULL,NULL},
/* 169F */ { NULL,NULL},
/* 16A0 */ { "LETTRE RUNIQUE FÉHU FÉOH FÉ F",NULL},
/* 16A1 */ { "LETTRE RUNIQUE V",NULL},
/* 16A2 */ { "LETTRE RUNIQUE URUZ UR OU",NULL},
/* 16A3 */ { "LETTRE RUNIQUE YR",NULL},
/* 16A4 */ { "LETTRE RUNIQUE Y",NULL},
/* 16A5 */ { "LETTRE RUNIQUE W",NULL},
/* 16A6 */ { "LETTRE RUNIQUE THURISAZ THORN THURS TH","	x (lettre minuscule latine thorn - 00FE)"},
/* 16A7 */ { "LETTRE RUNIQUE ETH",NULL},
/* 16A8 */ { "LETTRE RUNIQUE ANSUZ A",NULL},
/* 16A9 */ { "LETTRE RUNIQUE OS O",NULL},
/* 16AA */ { "LETTRE RUNIQUE AC A",NULL},
/* 16AB */ { "LETTRE RUNIQUE ÆSC",NULL},
/* 16AC */ { "LETTRE RUNIQUE OSS-À-BRANCHE-LONGUE O",NULL},
/* 16AD */ { "LETTRE RUNIQUE OSS-À-RAMILLE O",NULL},
/* 16AE */ { "LETTRE RUNIQUE O",NULL},
/* 16AF */ { "LETTRE RUNIQUE OE",NULL},
/* 16B0 */ { "LETTRE RUNIQUE ON",NULL},
/* 16B1 */ { "LETTRE RUNIQUE RAIDO RAD REID R",NULL},
/* 16B2 */ { "LETTRE RUNIQUE KAUNA",NULL},
/* 16B3 */ { "LETTRE RUNIQUE CEN",NULL},
/* 16B4 */ { "LETTRE RUNIQUE KAUN K",NULL},
/* 16B5 */ { "LETTRE RUNIQUE G",NULL},
/* 16B6 */ { "LETTRE RUNIQUE ENG",NULL},
/* 16B7 */ { "LETTRE RUNIQUE GEBO GEOFU G",NULL},
/* 16B8 */ { "LETTRE RUNIQUE GAR",NULL},
/* 16B9 */ { "LETTRE RUNIQUE WUNJO WYNN W","	x (lettre latine wynn - 01BF)"},
/* 16BA */ { "LETTRE RUNIQUE HAGLAZ H",NULL},
/* 16BB */ { "LETTRE RUNIQUE HÆGL H",NULL},
/* 16BC */ { "LETTRE RUNIQUE HAGALL-À-LONGUE-BRANCHE H",NULL},
/* 16BD */ { "LETTRE RUNIQUE HAGALL-À-RAMILLE H",NULL},
/* 16BE */ { "LETTRE RUNIQUE NAUDIZ NYD NAUD N",NULL},
/* 16BF */ { "LETTRE RUNIQUE NAUD-À-RAMILLE N",NULL},
/* 16C0 */ { "LETTRE RUNIQUE N-POINTÉ",NULL},
/* 16C1 */ { "LETTRE RUNIQUE ISA IS ISS I",NULL},
/* 16C2 */ { "LETTRE RUNIQUE E",NULL},
/* 16C3 */ { "LETTRE RUNIQUE JERAN J",NULL},
/* 16C4 */ { "LETTRE RUNIQUE GER",NULL},
/* 16C5 */ { "LETTRE RUNIQUE AR-À-LONGUE-BRANCHE Æ",NULL},
/* 16C6 */ { "LETTRE RUNIQUE AR A",NULL},
/* 16C7 */ { "LETTRE RUNIQUE IWAZ EOH",NULL},
/* 16C8 */ { "LETTRE RUNIQUE PERTHRO PEORTH P",NULL},
/* 16C9 */ { "LETTRE RUNIQUE ALGIZ EOLHX",NULL},
/* 16CA */ { "LETTRE RUNIQUE SOWILO S",NULL},
/* 16CB */ { "LETTRE RUNIQUE SIGEL SOL-À-LONGUE-BRANCHE S",NULL},
/* 16CC */ { "LETTRE RUNIQUE SOL-À-RAMILLE S",NULL},
/* 16CD */ { "LETTRE RUNIQUE C",NULL},
/* 16CE */ { "LETTRE RUNIQUE Z",NULL},
/* 16CF */ { "LETTRE RUNIQUE TIWAZ TIR TYR T",NULL},
/* 16D0 */ { "LETTRE RUNIQUE TYR-À-RAMILLE T",NULL},
/* 16D1 */ { "LETTRE RUNIQUE D",NULL},
/* 16D2 */ { "LETTRE RUNIQUE BERKANAN BEORC BIARKAN B",NULL},
/* 16D3 */ { "LETTRE RUNIQUE BIARKAN-À-RAMILLE B",NULL},
/* 16D4 */ { "LETTRE RUNIQUE P-POINTÉ",NULL},
/* 16D5 */ { "LETTRE RUNIQUE P-OUVERT",NULL},
/* 16D6 */ { "LETTRE RUNIQUE EHWAZ EH E",NULL},
/* 16D7 */ { "LETTRE RUNIQUE MANNAZ MAN M",NULL},
/* 16D8 */ { "LETTRE RUNIQUE MADR-À-LONGUE-BRANCHE M",NULL},
/* 16D9 */ { "LETTRE RUNIQUE MADR-À-RAMILLE M",NULL},
/* 16DA */ { "LETTRE RUNIQUE LAUKAZ LAGU LOGR L",NULL},
/* 16DB */ { "LETTRE RUNIQUE L-POINTÉ",NULL},
/* 16DC */ { "LETTRE RUNIQUE INGWAZ",NULL},
/* 16DD */ { "LETTRE RUNIQUE ING",NULL},
/* 16DE */ { "LETTRE RUNIQUE DAGAZ DÆG D",NULL},
/* 16DF */ { "LETTRE RUNIQUE OTHALAN ETHEL O",NULL},
/* 16E0 */ { "LETTRE RUNIQUE EAR",NULL},
/* 16E1 */ { "LETTRE RUNIQUE IOR",NULL},
/* 16E2 */ { "LETTRE RUNIQUE CWEORTH",NULL},
/* 16E3 */ { "LETTRE RUNIQUE CALC",NULL},
/* 16E4 */ { "LETTRE RUNIQUE CEALC",NULL},
/* 16E5 */ { "LETTRE RUNIQUE STAN",NULL},
/* 16E6 */ { "LETTRE RUNIQUE YR-À-LONGUE-BRANCHE",NULL},
/* 16E7 */ { "LETTRE RUNIQUE YR-À-RAMILLE",NULL},
/* 16E8 */ { "LETTRE RUNIQUE YR-ISLANDAIS",NULL},
/* 16E9 */ { "LETTRE RUNIQUE Q",NULL},
/* 16EA */ { "LETTRE RUNIQUE X",NULL},
/* 16EB */ { "PONCTUATION RUNIQUE SIMPLE",NULL},
/* 16EC */ { "PONCTUATION RUNIQUE MULTIPLE",NULL},
/* 16ED */ { "PONCTUATION RUNIQUE EN CROIX",NULL},
/* 16EE */ { "SYMBOLE RUNIQUE ARLAUG","	* nombre d'or 17"},
/* 16EF */ { "SYMBOLE RUNIQUE TVIMADUR","	* nombre d'or 18"},
/* 16F0 */ { "SYMBOLE RUNIQUE BELGTHOR","	* nombre d'or 19"},
/* 16F1 */ { "LETTRE RUNIQUE K",NULL},
/* 16F2 */ { "LETTRE RUNIQUE SH",NULL},
/* 16F3 */ { "LETTRE RUNIQUE OO",NULL},
/* 16F4 */ { "LETTRE RUNIQUE DU COFFRET D'AUZON OS",NULL},
/* 16F5 */ { "LETTRE RUNIQUE DU COFFRET D'AUZON IS",NULL},
/* 16F6 */ { "LETTRE RUNIQUE DU COFFRET D'AUZON EH",NULL},
/* 16F7 */ { "LETTRE RUNIQUE DU COFFRET D'AUZON AC",NULL},
/* 16F8 */ { "LETTRE RUNIQUE DU COFFRET D'AUZON ÆSC",NULL},
/* 16F9 */ { NULL,NULL},
/* 16FA */ { NULL,NULL},
/* 16FB */ { NULL,NULL},
/* 16FC */ { NULL,NULL},
/* 16FD */ { NULL,NULL},
/* 16FE */ { NULL,NULL},
/* 16FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_17[] = {
/* 1700 */ { "LETTRE TAGALOG A",NULL},
/* 1701 */ { "LETTRE TAGALOG I",NULL},
/* 1702 */ { "LETTRE TAGALOG OU",NULL},
/* 1703 */ { "LETTRE TAGALOG KA",NULL},
/* 1704 */ { "LETTRE TAGALOG GA",NULL},
/* 1705 */ { "LETTRE TAGALOG NGA",NULL},
/* 1706 */ { "LETTRE TAGALOG TA",NULL},
/* 1707 */ { "LETTRE TAGALOG DA",NULL},
/* 1708 */ { "LETTRE TAGALOG NA",NULL},
/* 1709 */ { "LETTRE TAGALOG PA",NULL},
/* 170A */ { "LETTRE TAGALOG BA",NULL},
/* 170B */ { "LETTRE TAGALOG MA",NULL},
/* 170C */ { "LETTRE TAGALOG YA",NULL},
/* 170D */ { NULL,NULL},
/* 170E */ { "LETTRE TAGALOG LA",NULL},
/* 170F */ { "LETTRE TAGALOG WA",NULL},
/* 1710 */ { "LETTRE TAGALOG SA",NULL},
/* 1711 */ { "LETTRE TAGALOG HA",NULL},
/* 1712 */ { "DIACRITIQUE VOYELLE TAGALOG I",NULL},
/* 1713 */ { "DIACRITIQUE VOYELLE TAGALOG OU",NULL},
/* 1714 */ { "DIACRITIQUE TAGALOG VIRÂMA",NULL},
/* 1715 */ { NULL,NULL},
/* 1716 */ { NULL,NULL},
/* 1717 */ { NULL,NULL},
/* 1718 */ { NULL,NULL},
/* 1719 */ { NULL,NULL},
/* 171A */ { NULL,NULL},
/* 171B */ { NULL,NULL},
/* 171C */ { NULL,NULL},
/* 171D */ { NULL,NULL},
/* 171E */ { NULL,NULL},
/* 171F */ { NULL,NULL},
/* 1720 */ { "LETTRE HANOUNÓO A",NULL},
/* 1721 */ { "LETTRE HANOUNÓO I",NULL},
/* 1722 */ { "LETTRE HANOUNÓO OU",NULL},
/* 1723 */ { "LETTRE HANOUNÓO KA",NULL},
/* 1724 */ { "LETTRE HANOUNÓO GA",NULL},
/* 1725 */ { "LETTRE HANOUNÓO NGA",NULL},
/* 1726 */ { "LETTRE HANOUNÓO TA",NULL},
/* 1727 */ { "LETTRE HANOUNÓO DA",NULL},
/* 1728 */ { "LETTRE HANOUNÓO NA",NULL},
/* 1729 */ { "LETTRE HANOUNÓO PA",NULL},
/* 172A */ { "LETTRE HANOUNÓO BA",NULL},
/* 172B */ { "LETTRE HANOUNÓO MA",NULL},
/* 172C */ { "LETTRE HANOUNÓO YA",NULL},
/* 172D */ { "LETTRE HANOUNÓO RA",NULL},
/* 172E */ { "LETTRE HANOUNÓO LA",NULL},
/* 172F */ { "LETTRE HANOUNÓO WA",NULL},
/* 1730 */ { "LETTRE HANOUNÓO SA",NULL},
/* 1731 */ { "LETTRE HANOUNÓO HA",NULL},
/* 1732 */ { "DIACRITIQUE VOYELLE HANOUNÓO I",NULL},
/* 1733 */ { "DIACRITIQUE VOYELLE HANOUNÓO OU",NULL},
/* 1734 */ { "DIACRITIQUE HANOUNÓO PAMOUDPOD",NULL},
/* 1735 */ { "PONCTUATION PHILIPPINE SIMPLE","	x (danda dévanâgarî - 0964)"},
/* 1736 */ { "PONCTUATION PHILIPPINE DOUBLE","	x (double danda dévanâgarî - 0965)"},
/* 1737 */ { NULL,NULL},
/* 1738 */ { NULL,NULL},
/* 1739 */ { NULL,NULL},
/* 173A */ { NULL,NULL},
/* 173B */ { NULL,NULL},
/* 173C */ { NULL,NULL},
/* 173D */ { NULL,NULL},
/* 173E */ { NULL,NULL},
/* 173F */ { NULL,NULL},
/* 1740 */ { "LETTRE BOUHID A",NULL},
/* 1741 */ { "LETTRE BOUHID I",NULL},
/* 1742 */ { "LETTRE BOUHID OU",NULL},
/* 1743 */ { "LETTRE BOUHID KA",NULL},
/* 1744 */ { "LETTRE BOUHID GA",NULL},
/* 1745 */ { "LETTRE BOUHID NGA",NULL},
/* 1746 */ { "LETTRE BOUHID TA",NULL},
/* 1747 */ { "LETTRE BOUHID DA",NULL},
/* 1748 */ { "LETTRE BOUHID NA",NULL},
/* 1749 */ { "LETTRE BOUHID PA",NULL},
/* 174A */ { "LETTRE BOUHID BA",NULL},
/* 174B */ { "LETTRE BOUHID MA",NULL},
/* 174C */ { "LETTRE BOUHID YA",NULL},
/* 174D */ { "LETTRE BOUHID RA",NULL},
/* 174E */ { "LETTRE BOUHID LA",NULL},
/* 174F */ { "LETTRE BOUHID WA",NULL},
/* 1750 */ { "LETTRE BOUHID SA",NULL},
/* 1751 */ { "LETTRE BOUHID HA",NULL},
/* 1752 */ { "DIACRITIQUE VOYELLE BOUHID I",NULL},
/* 1753 */ { "DIACRITIQUE VOYELLE BOUHID OU",NULL},
/* 1754 */ { NULL,NULL},
/* 1755 */ { NULL,NULL},
/* 1756 */ { NULL,NULL},
/* 1757 */ { NULL,NULL},
/* 1758 */ { NULL,NULL},
/* 1759 */ { NULL,NULL},
/* 175A */ { NULL,NULL},
/* 175B */ { NULL,NULL},
/* 175C */ { NULL,NULL},
/* 175D */ { NULL,NULL},
/* 175E */ { NULL,NULL},
/* 175F */ { NULL,NULL},
/* 1760 */ { "LETTRE TAGBANOUA A",NULL},
/* 1761 */ { "LETTRE TAGBANOUA I",NULL},
/* 1762 */ { "LETTRE TAGBANOUA OU",NULL},
/* 1763 */ { "LETTRE TAGBANOUA KA",NULL},
/* 1764 */ { "LETTRE TAGBANOUA GA",NULL},
/* 1765 */ { "LETTRE TAGBANOUA NGA",NULL},
/* 1766 */ { "LETTRE TAGBANOUA TA",NULL},
/* 1767 */ { "LETTRE TAGBANOUA DA",NULL},
/* 1768 */ { "LETTRE TAGBANOUA NA",NULL},
/* 1769 */ { "LETTRE TAGBANOUA PA",NULL},
/* 176A */ { "LETTRE TAGBANOUA BA",NULL},
/* 176B */ { "LETTRE TAGBANOUA MA",NULL},
/* 176C */ { "LETTRE TAGBANOUA YA",NULL},
/* 176D */ { NULL,NULL},
/* 176E */ { "LETTRE TAGBANOUA LA",NULL},
/* 176F */ { "LETTRE TAGBANOUA WA",NULL},
/* 1770 */ { "LETTRE TAGBANOUA SA",NULL},
/* 1771 */ { NULL,NULL},
/* 1772 */ { "DIACRITIQUE VOYELLE TAGBANOUA I",NULL},
/* 1773 */ { "DIACRITIQUE VOYELLE TAGBANOUA OU",NULL},
/* 1774 */ { NULL,NULL},
/* 1775 */ { NULL,NULL},
/* 1776 */ { NULL,NULL},
/* 1777 */ { NULL,NULL},
/* 1778 */ { NULL,NULL},
/* 1779 */ { NULL,NULL},
/* 177A */ { NULL,NULL},
/* 177B */ { NULL,NULL},
/* 177C */ { NULL,NULL},
/* 177D */ { NULL,NULL},
/* 177E */ { NULL,NULL},
/* 177F */ { NULL,NULL},
/* 1780 */ { "LETTRE KHMÈRE KA",NULL},
/* 1781 */ { "LETTRE KHMÈRE KHA",NULL},
/* 1782 */ { "LETTRE KHMÈRE KO",NULL},
/* 1783 */ { "LETTRE KHMÈRE KHO",NULL},
/* 1784 */ { "LETTRE KHMÈRE NGO",NULL},
/* 1785 */ { "LETTRE KHMÈRE TCHA",NULL},
/* 1786 */ { "LETTRE KHMÈRE TCHHA",NULL},
/* 1787 */ { "LETTRE KHMÈRE TCHO",NULL},
/* 1788 */ { "LETTRE KHMÈRE TCHHO",NULL},
/* 1789 */ { "LETTRE KHMÈRE ÑO",NULL},
/* 178A */ { "LETTRE KHMÈRE DA",NULL},
/* 178B */ { "LETTRE KHMÈRE TTHA",NULL},
/* 178C */ { "LETTRE KHMÈRE DO",NULL},
/* 178D */ { "LETTRE KHMÈRE TTHO",NULL},
/* 178E */ { "LETTRE KHMÈRE NA","	* l'appellation anglaise de ce caractère est erronée"},
/* 178F */ { "LETTRE KHMÈRE TA",NULL},
/* 1790 */ { "LETTRE KHMÈRE THA",NULL},
/* 1791 */ { "LETTRE KHMÈRE TO",NULL},
/* 1792 */ { "LETTRE KHMÈRE THO",NULL},
/* 1793 */ { "LETTRE KHMÈRE NO",NULL},
/* 1794 */ { "LETTRE KHMÈRE BA",NULL},
/* 1795 */ { "LETTRE KHMÈRE PHA",NULL},
/* 1796 */ { "LETTRE KHMÈRE PO",NULL},
/* 1797 */ { "LETTRE KHMÈRE PHO",NULL},
/* 1798 */ { "LETTRE KHMÈRE MO",NULL},
/* 1799 */ { "LETTRE KHMÈRE YO",NULL},
/* 179A */ { "LETTRE KHMÈRE RO",NULL},
/* 179B */ { "LETTRE KHMÈRE LO",NULL},
/* 179C */ { "LETTRE KHMÈRE VO",NULL},
/* 179D */ { "LETTRE KHMÈRE ÇA","	* uniquement pour les translittérations du pali et du sanskrit"},
/* 179E */ { "LETTRE KHMÈRE CHA","	* uniquement pour les translittérations du pali et du sanskrit\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 179F */ { "LETTRE KHMÈRE SA",NULL},
/* 17A0 */ { "LETTRE KHMÈRE HA",NULL},
/* 17A1 */ { "LETTRE KHMÈRE LA",NULL},
/* 17A2 */ { "LETTRE KHMÈRE 'A","	* coup de glotte"},
/* 17A3 */ { "VOYELLE PLEINE KHMÈRE 'A'","	* l'utilisation de ce caractère est fortement déconseillée ; il faut plutôt utiliser 17A2"},
/* 17A4 */ { "VOYELLE PLEINE KHMÈRE 'AA","	* l'utilisation de ce caractère n'est pas recommandée ; il faut plutôt utiliser la suite 17A2 17B6"},
/* 17A5 */ { "VOYELLE PLEINE KHMÈRE 'I",NULL},
/* 17A6 */ { "VOYELLE PLEINE KHMÈRE 'II",NULL},
/* 17A7 */ { "VOYELLE PLEINE KHMÈRE 'OU",NULL},
/* 17A8 */ { "VOYELLE PLEINE KHMÈRE 'OUK","	* ligature désuète de la suite 17A7 1780\n"
	"	* l'emploi de cette séquence est aujourd'hui recommandée"},
/* 17A9 */ { "VOYELLE PLEINE KHMÈRE 'OÛ","	* redoublement du son ou /u/"},
/* 17AA */ { "VOYELLE PLEINE KHMÈRE 'EOU",NULL},
/* 17AB */ { "VOYELLE PLEINE KHMÈRE RY","	* parfois romanisé rü ou reu"},
/* 17AC */ { "VOYELLE PLEINE KHMÈRE RYY",NULL},
/* 17AD */ { "VOYELLE PLEINE KHMÈRE LY","	* parfois romanisé lü ou leu"},
/* 17AE */ { "VOYELLE PLEINE KHMÈRE LYY",NULL},
/* 17AF */ { "VOYELLE PLEINE KHMÈRE 'ÈÈ",NULL},
/* 17B0 */ { "VOYELLE PLEINE KHMÈRE 'AÏ",NULL},
/* 17B1 */ { "VOYELLE PLEINE KHMÈRE 'OO TYPE UN",NULL},
/* 17B2 */ { "VOYELLE PLEINE KHMÈRE 'OO TYPE DEUX","	* il s'agit d'une variante de 17B1, utilisée seulement dans deux mots\n"
	"	* 17B1 est la variante habituelle de cette voyelle"},
/* 17B3 */ { "VOYELLE PLEINE KHMÈRE 'AOU",NULL},
/* 17B4 */ { "VOYELLE IMPLICITE KHMÈRE A'",NULL},
/* 17B5 */ { "VOYELLE IMPLICITE KHMÈRE AA",NULL},
/* 17B6 */ { "DIACRITIQUE VOYELLE KHMÈRE AA",NULL},
/* 17B7 */ { "DIACRITIQUE VOYELLE KHMÈRE I",NULL},
/* 17B8 */ { "DIACRITIQUE VOYELLE KHMÈRE II",NULL},
/* 17B9 */ { "DIACRITIQUE VOYELLE KHMÈRE Y","	= ü, eu"},
/* 17BA */ { "DIACRITIQUE VOYELLE KHMÈRE YY","	= üü, eû"},
/* 17BB */ { "DIACRITIQUE VOYELLE KHMÈRE OU",NULL},
/* 17BC */ { "DIACRITIQUE VOYELLE KHMÈRE OÛ","	* redoublement du son ou /u/"},
/* 17BD */ { "DIACRITIQUE VOYELLE KHMÈRE OUE",NULL},
/* 17BE */ { "DIACRITIQUE VOYELLE KHMÈRE EE","	= oe, œ"},
/* 17BF */ { "DIACRITIQUE VOYELLE KHMÈRE YE","	= üeu, eue"},
/* 17C0 */ { "DIACRITIQUE VOYELLE KHMÈRE IE",NULL},
/* 17C1 */ { "DIACRITIQUE VOYELLE KHMÈRE ÉÉ",NULL},
/* 17C2 */ { "DIACRITIQUE VOYELLE KHMÈRE ÈÈ","	= ae"},
/* 17C3 */ { "DIACRITIQUE VOYELLE KHMÈRE AÏ",NULL},
/* 17C4 */ { "DIACRITIQUE VOYELLE KHMÈRE OO",NULL},
/* 17C5 */ { "DIACRITIQUE VOYELLE KHMÈRE AOU",NULL},
/* 17C6 */ { "DIACRITIQUE KHMER NIKAHIT","	= srak âm\n"
	"	= anousvâra\n"
	"	* nasalisation finale\n"
	"	* on considère habituellement ce caractère comme la voyelle âm ; il permet d'écrire les voyelles om et aam\n"
	"	x (caractère thaï nikhahit - 0E4D)\n"
	"	x (diacritique birman anousvâra - 1036)"},
/* 17C7 */ { "DIACRITIQUE KHMER RÉAHMOUK","	= srak ah\n"
	"	= visarga\n"
	"	x (diacritique birman visarga - 1038)"},
/* 17C8 */ { "DIACRITIQUE KHMER YOUKALÉAKPINTOU","	* insère une voyelle inhérente brève accompagnée d'un coup de glotte abrupt"},
/* 17C9 */ { "DIACRITIQUE KHMER MOÛSÉKETOEN","	* passe du second registre au premier"},
/* 17CA */ { "DIACRITIQUE KHMER TREISAP","	* passe du premier registre au second"},
/* 17CB */ { "DIACRITIQUE KHMER BANTAK","	* abrège la voyelle de la syllabe orthographique précédente"},
/* 17CC */ { "DIACRITIQUE KHMER ROBAT","	* diacritique correspondant autrefois à la forme repha du ra dévanâgarî"},
/* 17CD */ { "DIACRITIQUE KHMER TOANDAKHIAT","	* signale que le caractère de base est muet\n"
	"	x (caractère thaï thanthakhat - 0E4C)"},
/* 17CE */ { "DIACRITIQUE KHMER KAKABAT","	= patte de corbeau\n"
	"	* s'utilise dans certaines exclamations"},
/* 17CF */ { "DIACRITIQUE KHMER AHSDAA","	* marque une intonation forte dans certains mots à une consonne"},
/* 17D0 */ { "DIACRITIQUE KHMER SAÑÑOK SAÑÑAA","	* indique une prononciation irrégulière, habituellement dans les mots empruntés au pali/sanskrit, au français, etc."},
/* 17D1 */ { "DIACRITIQUE KHMER VIRIAM","	* signe « tueur » moribond\n"
	"	* indique que le caractère de base correspond à la consonne finale d'un mot sans sa voyelle inhérente (on dit que la consonne est dévoyellée)"},
/* 17D2 */ { "DIACRITIQUE KHMER TCHOENG","	* indique que la lettre khmère suivante doit être souscrite à l'affichage\n"
	"	* la forme choisie est arbitraire, invisible"},
/* 17D3 */ { "DIACRITIQUE KHMER PATHAMASAT","	* destiné initialement à représenter un symbole du calendrier lunaire\n"
	"	* l'utilisation de ce caractère est déconseillée, au profit de l'ensemble complet des symboles du calendrier lunaire\n"
	"	x (symbole khmer pathamasat - 19E0)"},
/* 17D4 */ { "SIGNE KHMER KHAN","	* équivalent à un point final, un point\n"
	"	x (caractère thaï païyannoï - 0E2F)\n"
	"	x (signe birman petite section - 104A)"},
/* 17D5 */ { "SIGNE KHMER PAREIAOSAAN","	* indique la fin d'une section ou d'un texte\n"
	"	x (caractère thaï angkhankhou - 0E5A)\n"
	"	x (signe birman section - 104B)"},
/* 17D6 */ { "SIGNE KHMER TCHAMNOTCH PII KOÛH","	* s'utilise comme un deux-points\n"
	"	x (signe de division - 00F7)\n"
	"	x (signe tibétain gter tsheg - 0F14)"},
/* 17D7 */ { "SIGNE KHMER LÉÉK TOO","	* signe de répétition\n"
	"	x (caractère thaï maïyamok - 0E46)"},
/* 17D8 */ { "SIGNE KHMER PÉÉIAAL","	= lak\n"
	"	* et cetera\n"
	"	* l'utilisation de ce caractère n'est pas conseillée ; il existe d'autres abréviations d'et cetera\n"
	"	* écriture recommandée : 17D4 179B 17D4"},
/* 17D9 */ { "SIGNE KHMER PHNÈK MOEN","	= œil de coq\n"
	"	* indique le début d'un livre ou d'un traité\n"
	"	x (caractère thaï fongman - 0E4F)"},
/* 17DA */ { "SIGNE KHMER KOOMOÛT","	= urine de vache, komot, koumout\n"
	"	* indique la fin d'un livre ou d'un traité\n"
	"	* pendant de 17D9\n"
	"	x (caractère thaï khomout - 0E5B)"},
/* 17DB */ { "SYMBOLE MONÉTAIRE KHMER RIEL",NULL},
/* 17DC */ { "SIGNE KHMER AVAKRAHASAÑÑAA","	= avakraha sannya\n"
	"	* rare, indique la suppression d'une voyelle sanskrite, de la même façon qu'une apostrophe\n"
	"	x (signe dévanâgarî avagraha - 093D)"},
/* 17DD */ { "DIACRITIQUE KHMER ATTHATCHAN","	* signe moribond\n"
	"	* indique que le caractère de base correspond à la consonne finale d'un mot avec sa voyelle inhérente associée dans la prononciation\n"
	"	x (diacritique khmer viriam - 17D1)"},
/* 17DE */ { NULL,NULL},
/* 17DF */ { NULL,NULL},
/* 17E0 */ { "CHIFFRE KHMER ZÉRO",NULL},
/* 17E1 */ { "CHIFFRE KHMER UN",NULL},
/* 17E2 */ { "CHIFFRE KHMER DEUX",NULL},
/* 17E3 */ { "CHIFFRE KHMER TROIS",NULL},
/* 17E4 */ { "CHIFFRE KHMER QUATRE",NULL},
/* 17E5 */ { "CHIFFRE KHMER CINQ",NULL},
/* 17E6 */ { "CHIFFRE KHMER SIX",NULL},
/* 17E7 */ { "CHIFFRE KHMER SEPT",NULL},
/* 17E8 */ { "CHIFFRE KHMER HUIT",NULL},
/* 17E9 */ { "CHIFFRE KHMER NEUF",NULL},
/* 17EA */ { NULL,NULL},
/* 17EB */ { NULL,NULL},
/* 17EC */ { NULL,NULL},
/* 17ED */ { NULL,NULL},
/* 17EE */ { NULL,NULL},
/* 17EF */ { NULL,NULL},
/* 17F0 */ { "CHIFFRE DIVINATOIRE KHMER ZÉRO","	= léékh attak soon"},
/* 17F1 */ { "CHIFFRE DIVINATOIRE KHMER UN","	= léékh attak mouei"},
/* 17F2 */ { "CHIFFRE DIVINATOIRE KHMER DEUX","	= léékh attak pii"},
/* 17F3 */ { "CHIFFRE DIVINATOIRE KHMER TROIS","	= léékh attak bèi"},
/* 17F4 */ { "CHIFFRE DIVINATOIRE KHMER QUATRE","	= léékh attak buen"},
/* 17F5 */ { "CHIFFRE DIVINATOIRE KHMER CINQ","	= léékh attak pram"},
/* 17F6 */ { "CHIFFRE DIVINATOIRE KHMER SIX","	= léékh attak pram-mouei"},
/* 17F7 */ { "CHIFFRE DIVINATOIRE KHMER SEPT","	= léékh attak pram-pii"},
/* 17F8 */ { "CHIFFRE DIVINATOIRE KHMER HUIT","	= léékh attak pram-bèi"},
/* 17F9 */ { "CHIFFRE DIVINATOIRE KHMER NEUF","	= léékh attak pram-buen"},
/* 17FA */ { NULL,NULL},
/* 17FB */ { NULL,NULL},
/* 17FC */ { NULL,NULL},
/* 17FD */ { NULL,NULL},
/* 17FE */ { NULL,NULL},
/* 17FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_18[] = {
/* 1800 */ { "BIRGA MONGOL","	x (signe tibétain yig mgo mdun ma ouvrant - 0F04)"},
/* 1801 */ { "POINTS DE SUSPENSION MONGOLS",NULL},
/* 1802 */ { "VIRGULE MONGOLE",NULL},
/* 1803 */ { "POINT MONGOL",NULL},
/* 1804 */ { "DEUX-POINTS MONGOL",NULL},
/* 1805 */ { "QUATRE-POINTS MONGOL","	* indique la fin d'un chapitre"},
/* 1806 */ { "TRAIT D'UNION CONDITIONNEL MONGOL TODO","	* pas un caractère de formatage, mais simplement un trait d'union pour le todo\n"
	"	x (trait d'union conditionnel - 00AD)"},
/* 1807 */ { "SÉPARATEUR DE SYLLABES MONGOL SÎBÉ","	~ 1807 ALT1 première forme (medial)"},
/* 1808 */ { "VIRGULE MONGOLE MANDCHOUE",NULL},
/* 1809 */ { "POINT MONGOL MANDCHOU",NULL},
/* 180A */ { "NIROUGOU MONGOL","	~ 180A ALT1 première forme (medial)"},
/* 180B */ { "SÉLECTEUR DE VARIANTE LIBRE MONGOL UN",NULL},
/* 180C */ { "SÉLECTEUR DE VARIANTE LIBRE MONGOL DEUX",NULL},
/* 180D */ { "SÉLECTEUR DE VARIANTE LIBRE MONGOL TROIS",NULL},
/* 180E */ { "SÉPARATEUR DE VOYELLES MONGOL",NULL},
/* 180F */ { NULL,NULL},
/* 1810 */ { "CHIFFRE MONGOL ZÉRO",NULL},
/* 1811 */ { "CHIFFRE MONGOL UN",NULL},
/* 1812 */ { "CHIFFRE MONGOL DEUX",NULL},
/* 1813 */ { "CHIFFRE MONGOL TROIS",NULL},
/* 1814 */ { "CHIFFRE MONGOL QUATRE",NULL},
/* 1815 */ { "CHIFFRE MONGOL CINQ",NULL},
/* 1816 */ { "CHIFFRE MONGOL SIX",NULL},
/* 1817 */ { "CHIFFRE MONGOL SEPT",NULL},
/* 1818 */ { "CHIFFRE MONGOL HUIT",NULL},
/* 1819 */ { "CHIFFRE MONGOL NEUF",NULL},
/* 181A */ { NULL,NULL},
/* 181B */ { NULL,NULL},
/* 181C */ { NULL,NULL},
/* 181D */ { NULL,NULL},
/* 181E */ { NULL,NULL},
/* 181F */ { NULL,NULL},
/* 1820 */ { "LETTRE MONGOLE A","	x (lettre minuscule cyrillique a - 0430)\n"
	"	~ 1820 ALT1 première forme (initial)\n"
	"	~ 1820 ALT1 première forme (medial)\n"
	"	~ 1820 ALT1 première forme (final)\n"
	"	~ 1820 180B deuxième forme (isolate)\n"
	"	~ 1820 180B deuxième forme (medial)\n"
	"	~ 1820 180B deuxième forme (final)\n"
	"	~ 1820 180C troisième forme (medial)"},
/* 1821 */ { "LETTRE MONGOLE È","	= lettre mongole ä\n"
	"	x (lettre minuscule cyrillique é - 044D)\n"
	"	~ 1821 ALT1 première forme (initial)\n"
	"	~ 1821 ALT1 première forme (medial)\n"
	"	~ 1821 ALT1 première forme (final)\n"
	"	~ 1821 180B deuxième forme (initial)\n"
	"	~ 1821 180B deuxième forme (final)"},
/* 1822 */ { "LETTRE MONGOLE I","	x (lettre minuscule cyrillique i - 0438)\n"
	"	~ 1822 ALT1 première forme (initial)\n"
	"	~ 1822 ALT1 première forme (medial)\n"
	"	~ 1822 ALT1 première forme (final)\n"
	"	~ 1822 180B deuxième forme (medial)"},
/* 1823 */ { "LETTRE MONGOLE O","	x (lettre minuscule cyrillique o - 043E)\n"
	"	~ 1823 ALT1 première forme (initial)\n"
	"	~ 1823 ALT1 première forme (medial)\n"
	"	~ 1823 ALT1 première forme (final)\n"
	"	~ 1823 180B deuxième forme (medial)\n"
	"	~ 1823 180B deuxième forme (final)"},
/* 1824 */ { "LETTRE MONGOLE OU","	x (lettre minuscule cyrillique ou - 0443)\n"
	"	~ 1824 ALT1 première forme (isolate)\n"
	"	~ 1824 ALT1 première forme (initial)\n"
	"	~ 1824 ALT1 première forme (medial)\n"
	"	~ 1824 ALT1 première forme (final)\n"
	"	~ 1824 180B deuxième forme (medial)"},
/* 1825 */ { "LETTRE MONGOLE EU","	= lettre mongole ö\n"
	"	x (lettre minuscule cyrillique o barré - 04E9)\n"
	"	~ 1825 ALT1 première forme (initial)\n"
	"	~ 1825 ALT1 première forme (medial)\n"
	"	~ 1825 ALT1 première forme (final)\n"
	"	~ 1825 180B deuxième forme (medial)\n"
	"	~ 1825 180B deuxième forme (final)\n"
	"	~ 1825 180C troisième forme (medial)"},
/* 1826 */ { "LETTRE MONGOLE U","	= lettre mongole ü\n"
	"	x (lettre minuscule cyrillique ou droit - 04AF)\n"
	"	~ 1826 ALT1 première forme (isolate)\n"
	"	~ 1826 ALT1 première forme (initial)\n"
	"	~ 1826 ALT1 première forme (medial)\n"
	"	~ 1826 ALT1 première forme (final)\n"
	"	~ 1826 180B deuxième forme (isolate)\n"
	"	~ 1826 180B deuxième forme (medial)\n"
	"	~ 1826 180B deuxième forme (final)\n"
	"	~ 1826 180C troisième forme (medial)"},
/* 1827 */ { "LETTRE MONGOLE Î","	~ 1827 ALT1 première forme (initial)\n"
	"	~ 1827 ALT1 première forme (medial)\n"
	"	~ 1827 ALT1 première forme (final)"},
/* 1828 */ { "LETTRE MONGOLE NA","	x (lettre minuscule cyrillique enne - 043D)\n"
	"	~ 1828 ALT1 première forme (initial)\n"
	"	~ 1828 ALT1 première forme (medial)\n"
	"	~ 1828 ALT1 première forme (final)\n"
	"	~ 1828 180B deuxième forme (initial)\n"
	"	~ 1828 180B deuxième forme (medial)\n"
	"	~ 1828 180C troisième forme (medial)\n"
	"	~ 1828 180D quatrième forme (medial)"},
/* 1829 */ { "LETTRE MONGOLE ANG","	~ 1829 ALT1 première forme (initial)\n"
	"	~ 1829 ALT1 première forme (medial)\n"
	"	~ 1829 ALT1 première forme (final)"},
/* 182A */ { "LETTRE MONGOLE BA","	x (lettre minuscule cyrillique bé - 0431)\n"
	"	~ 182A ALT1 première forme (initial)\n"
	"	~ 182A ALT1 première forme (medial)\n"
	"	~ 182A ALT1 première forme (final)\n"
	"	~ 182A 180B deuxième forme (final)"},
/* 182B */ { "LETTRE MONGOLE PA","	x (lettre minuscule cyrillique pé - 043F)\n"
	"	~ 182B ALT1 première forme (initial)\n"
	"	~ 182B ALT1 première forme (medial)\n"
	"	~ 182B ALT1 première forme (final)"},
/* 182C */ { "LETTRE MONGOLE QA","	= xa\n"
	"	x (lettre minuscule cyrillique kha - 0445)\n"
	"	~ 182C ALT1 première forme (initial)\n"
	"	~ 182C ALT1 première forme (medial)\n"
	"	~ 182C ALT1 première forme (final)\n"
	"	~ 182C 180B deuxième forme (isolate)\n"
	"	~ 182C 180B deuxième forme (initial)\n"
	"	~ 182C 180B deuxième forme (medial)\n"
	"	~ 182C 180C troisième forme (medial)\n"
	"	~ 182C 180D quatrième forme (medial)"},
/* 182D */ { "LETTRE MONGOLE GA","	x (lettre minuscule cyrillique gué - 0433)\n"
	"	~ 182D ALT1 première forme (initial)\n"
	"	~ 182D ALT1 première forme (medial)\n"
	"	~ 182D ALT1 première forme (final)\n"
	"	~ 182D 180B deuxième forme (initial)\n"
	"	~ 182D 180B deuxième forme (medial)\n"
	"	~ 182D 180B deuxième forme (final)\n"
	"	~ 182D 180C troisième forme (medial)\n"
	"	~ 182D 180D quatrième forme (medial)"},
/* 182E */ { "LETTRE MONGOLE MA","	x (lettre minuscule cyrillique emme - 043C)\n"
	"	~ 182E ALT1 première forme (initial)\n"
	"	~ 182E ALT1 première forme (medial)\n"
	"	~ 182E ALT1 première forme (final)"},
/* 182F */ { "LETTRE MONGOLE LA","	x (lettre minuscule cyrillique elle - 043B)\n"
	"	~ 182F ALT1 première forme (initial)\n"
	"	~ 182F ALT1 première forme (medial)\n"
	"	~ 182F ALT1 première forme (final)"},
/* 1830 */ { "LETTRE MONGOLE SA","	x (lettre minuscule cyrillique esse - 0441)\n"
	"	~ 1830 ALT1 première forme (initial)\n"
	"	~ 1830 ALT1 première forme (medial)\n"
	"	~ 1830 ALT1 première forme (final)\n"
	"	~ 1830 180B deuxième forme (final)\n"
	"	~ 1830 180C troisième forme (final)"},
/* 1831 */ { "LETTRE MONGOLE CHA","	x (lettre minuscule cyrillique cha - 0448)\n"
	"	~ 1831 ALT1 première forme (initial)\n"
	"	~ 1831 ALT1 première forme (medial)\n"
	"	~ 1831 ALT1 première forme (final)"},
/* 1832 */ { "LETTRE MONGOLE TA","	x (lettre minuscule cyrillique té - 0442)\n"
	"	~ 1832 ALT1 première forme (initial)\n"
	"	~ 1832 ALT1 première forme (medial)\n"
	"	~ 1832 ALT1 première forme (final)\n"
	"	~ 1832 180B deuxième forme (medial)"},
/* 1833 */ { "LETTRE MONGOLE DA","	x (lettre minuscule cyrillique dé - 0434)\n"
	"	~ 1833 ALT1 première forme (initial)\n"
	"	~ 1833 ALT1 première forme (medial)\n"
	"	~ 1833 ALT1 première forme (final)\n"
	"	~ 1833 180B deuxième forme (initial)\n"
	"	~ 1833 180B deuxième forme (medial)\n"
	"	~ 1833 180B deuxième forme (final)"},
/* 1834 */ { "LETTRE MONGOLE TCHA","	x (lettre minuscule cyrillique tché - 0447)\n"
	"	~ 1834 ALT1 première forme (initial)\n"
	"	~ 1834 ALT1 première forme (medial)\n"
	"	~ 1834 ALT1 première forme (final)"},
/* 1835 */ { "LETTRE MONGOLE DJA","	x (lettre minuscule cyrillique jé - 0436)\n"
	"	~ 1835 ALT1 première forme (initial)\n"
	"	~ 1835 ALT1 première forme (medial)\n"
	"	~ 1835 ALT1 première forme (final)\n"
	"	~ 1835 180B deuxième forme (medial)"},
/* 1836 */ { "LETTRE MONGOLE YA","	x (lettre minuscule cyrillique i bref - 0439)\n"
	"	~ 1836 ALT1 première forme (initial)\n"
	"	~ 1836 ALT1 première forme (medial)\n"
	"	~ 1836 ALT1 première forme (final)\n"
	"	~ 1836 180B deuxième forme (initial)\n"
	"	~ 1836 180B deuxième forme (medial)\n"
	"	~ 1836 180C troisième forme (medial)"},
/* 1837 */ { "LETTRE MONGOLE RA","	x (lettre minuscule cyrillique erre - 0440)\n"
	"	~ 1837 ALT1 première forme (initial)\n"
	"	~ 1837 ALT1 première forme (medial)\n"
	"	~ 1837 ALT1 première forme (final)"},
/* 1838 */ { "LETTRE MONGOLE WA","	x (lettre minuscule cyrillique vé - 0432)\n"
	"	~ 1838 ALT1 première forme (initial)\n"
	"	~ 1838 ALT1 première forme (medial)\n"
	"	~ 1838 ALT1 première forme (final)\n"
	"	~ 1838 180B deuxième forme (final)"},
/* 1839 */ { "LETTRE MONGOLE FA","	x (lettre minuscule cyrillique effe - 0444)\n"
	"	~ 1839 ALT1 première forme (initial)\n"
	"	~ 1839 ALT1 première forme (medial)\n"
	"	~ 1839 ALT1 première forme (final)"},
/* 183A */ { "LETTRE MONGOLE KA","	x (lettre minuscule cyrillique kha - 0445)\n"
	"	~ 183A ALT1 première forme (initial)\n"
	"	~ 183A ALT1 première forme (medial)\n"
	"	~ 183A ALT1 première forme (final)"},
/* 183B */ { "LETTRE MONGOLE KHA","	x (lettre minuscule cyrillique ka - 043A)\n"
	"	~ 183B ALT1 première forme (initial)\n"
	"	~ 183B ALT1 première forme (medial)\n"
	"	~ 183B ALT1 première forme (final)"},
/* 183C */ { "LETTRE MONGOLE TSA","	x (lettre minuscule cyrillique tsé - 0446)\n"
	"	~ 183C ALT1 première forme (initial)\n"
	"	~ 183C ALT1 première forme (medial)\n"
	"	~ 183C ALT1 première forme (final)"},
/* 183D */ { "LETTRE MONGOLE ZA","	x (lettre minuscule cyrillique zé - 0437)\n"
	"	~ 183D ALT1 première forme (initial)\n"
	"	~ 183D ALT1 première forme (medial)\n"
	"	~ 183D ALT1 première forme (final)"},
/* 183E */ { "LETTRE MONGOLE HÂ","	x (lettre minuscule cyrillique kha - 0445)\n"
	"	~ 183E ALT1 première forme (initial)\n"
	"	~ 183E ALT1 première forme (medial)\n"
	"	~ 183E ALT1 première forme (final)"},
/* 183F */ { "LETTRE MONGOLE ZRA","	x (lettre minuscule cyrillique jé - 0436)\n"
	"	~ 183F ALT1 première forme (initial)\n"
	"	~ 183F ALT1 première forme (medial)\n"
	"	~ 183F ALT1 première forme (final)"},
/* 1840 */ { "LETTRE MONGOLE LHA","	~ 1840 ALT1 première forme (initial)\n"
	"	~ 1840 ALT1 première forme (medial)\n"
	"	~ 1840 ALT1 première forme (final)"},
/* 1841 */ { "LETTRE MONGOLE TCHE","	~ 1841 ALT1 première forme (initial)\n"
	"	~ 1841 ALT1 première forme (medial)\n"
	"	~ 1841 ALT1 première forme (final)"},
/* 1842 */ { "LETTRE MONGOLE TCH'E","	~ 1842 ALT1 première forme (initial)\n"
	"	~ 1842 ALT1 première forme (medial)\n"
	"	~ 1842 ALT1 première forme (final)"},
/* 1843 */ { "LETTRE MONGOLE SIGNE DE VOYELLE LONGUE TODO","	~ 1843 ALT1 première forme (initial)\n"
	"	~ 1843 ALT1 première forme (medial)\n"
	"	~ 1843 ALT1 première forme (final)"},
/* 1844 */ { "LETTRE MONGOLE É TODO","	~ 1844 ALT1 première forme (initial)\n"
	"	~ 1844 ALT1 première forme (medial)\n"
	"	~ 1844 ALT1 première forme (final)\n"
	"	~ 1844 180B deuxième forme (medial)"},
/* 1845 */ { "LETTRE MONGOLE I TODO","	~ 1845 ALT1 première forme (initial)\n"
	"	~ 1845 ALT1 première forme (medial)\n"
	"	~ 1845 ALT1 première forme (final)\n"
	"	~ 1845 180B deuxième forme (medial)"},
/* 1846 */ { "LETTRE MONGOLE O TODO","	~ 1846 ALT1 première forme (initial)\n"
	"	~ 1846 ALT1 première forme (medial)\n"
	"	~ 1846 ALT1 première forme (final)\n"
	"	~ 1846 180B deuxième forme (medial)"},
/* 1847 */ { "LETTRE MONGOLE OU TODO","	~ 1847 ALT1 première forme (initial)\n"
	"	~ 1847 ALT1 première forme (medial)\n"
	"	~ 1847 ALT1 première forme (final)\n"
	"	~ 1847 180B deuxième forme (isolate)\n"
	"	~ 1847 180B deuxième forme (medial)\n"
	"	~ 1847 180B deuxième forme (final)\n"
	"	~ 1847 180C troisième forme (medial)"},
/* 1848 */ { "LETTRE MONGOLE EU TODO","	= lettre mongole ö todo\n"
	"	~ 1848 ALT1 première forme (initial)\n"
	"	~ 1848 ALT1 première forme (medial)\n"
	"	~ 1848 ALT1 première forme (final)\n"
	"	~ 1848 180B deuxième forme (medial)"},
/* 1849 */ { "LETTRE MONGOLE U TODO","	= lettre mongole ü todo\n"
	"	~ 1849 ALT1 première forme (initial)\n"
	"	~ 1849 ALT1 première forme (medial)\n"
	"	~ 1849 ALT1 première forme (final)\n"
	"	~ 1849 180B deuxième forme (isolate)\n"
	"	~ 1849 180B deuxième forme (medial)"},
/* 184A */ { "LETTRE MONGOLE ANG TODO","	~ 184A ALT1 première forme (initial)\n"
	"	~ 184A ALT1 première forme (medial)\n"
	"	~ 184A ALT1 première forme (final)"},
/* 184B */ { "LETTRE MONGOLE BA TODO","	~ 184B ALT1 première forme (initial)\n"
	"	~ 184B ALT1 première forme (medial)\n"
	"	~ 184B ALT1 première forme (final)"},
/* 184C */ { "LETTRE MONGOLE PA TODO","	~ 184C ALT1 première forme (initial)\n"
	"	~ 184C ALT1 première forme (medial)\n"
	"	~ 184C ALT1 première forme (final)"},
/* 184D */ { "LETTRE MONGOLE QA TODO","	= lettre mongole xa todo\n"
	"	~ 184D ALT1 première forme (initial)\n"
	"	~ 184D ALT1 première forme (medial)\n"
	"	~ 184D ALT1 première forme (final)\n"
	"	~ 184D 180B deuxième forme (initial)\n"
	"	~ 184D 180B deuxième forme (medial)"},
/* 184E */ { "LETTRE MONGOLE GA TODO","	~ 184E ALT1 première forme (initial)\n"
	"	~ 184E ALT1 première forme (medial)\n"
	"	~ 184E ALT1 première forme (final)\n"
	"	~ 184E 180B deuxième forme (medial)"},
/* 184F */ { "LETTRE MONGOLE MA TODO","	~ 184F ALT1 première forme (initial)\n"
	"	~ 184F ALT1 première forme (medial)\n"
	"	~ 184F ALT1 première forme (final)"},
/* 1850 */ { "LETTRE MONGOLE TA TODO","	~ 1850 ALT1 première forme (initial)\n"
	"	~ 1850 ALT1 première forme (medial)\n"
	"	~ 1850 ALT1 première forme (final)"},
/* 1851 */ { "LETTRE MONGOLE DA TODO","	~ 1851 ALT1 première forme (initial)\n"
	"	~ 1851 ALT1 première forme (medial)\n"
	"	~ 1851 ALT1 première forme (final)"},
/* 1852 */ { "LETTRE MONGOLE TCHA TODO","	~ 1852 ALT1 première forme (initial)\n"
	"	~ 1852 ALT1 première forme (medial)\n"
	"	~ 1852 ALT1 première forme (final)"},
/* 1853 */ { "LETTRE MONGOLE DJA TODO","	~ 1853 ALT1 première forme (initial)\n"
	"	~ 1853 ALT1 première forme (medial)\n"
	"	~ 1853 ALT1 première forme (final)"},
/* 1854 */ { "LETTRE MONGOLE TSA TODO","	~ 1854 ALT1 première forme (initial)\n"
	"	~ 1854 ALT1 première forme (medial)\n"
	"	~ 1854 ALT1 première forme (final)"},
/* 1855 */ { "LETTRE MONGOLE YA TODO","	~ 1855 ALT1 première forme (initial)\n"
	"	~ 1855 ALT1 première forme (medial)\n"
	"	~ 1855 ALT1 première forme (final)"},
/* 1856 */ { "LETTRE MONGOLE WA TODO","	~ 1856 ALT1 première forme (initial)\n"
	"	~ 1856 ALT1 première forme (medial)\n"
	"	~ 1856 ALT1 première forme (final)"},
/* 1857 */ { "LETTRE MONGOLE KA TODO","	~ 1857 ALT1 première forme (initial)\n"
	"	~ 1857 ALT1 première forme (medial)\n"
	"	~ 1857 ALT1 première forme (final)"},
/* 1858 */ { "LETTRE MONGOLE GÂ TODO","	~ 1858 ALT1 première forme (initial)\n"
	"	~ 1858 ALT1 première forme (medial)\n"
	"	~ 1858 ALT1 première forme (final)"},
/* 1859 */ { "LETTRE MONGOLE HÂ TODO","	~ 1859 ALT1 première forme (initial)\n"
	"	~ 1859 ALT1 première forme (medial)\n"
	"	~ 1859 ALT1 première forme (final)"},
/* 185A */ { "LETTRE MONGOLE DJIA TODO","	~ 185A ALT1 première forme (initial)\n"
	"	~ 185A ALT1 première forme (medial)\n"
	"	~ 185A ALT1 première forme (final)"},
/* 185B */ { "LETTRE MONGOLE NIA TODO","	~ 185B ALT1 première forme (initial)\n"
	"	~ 185B ALT1 première forme (medial)\n"
	"	~ 185B ALT1 première forme (final)"},
/* 185C */ { "LETTRE MONGOLE DZA TODO","	~ 185C ALT1 première forme (initial)\n"
	"	~ 185C ALT1 première forme (medial)\n"
	"	~ 185C ALT1 première forme (final)"},
/* 185D */ { "LETTRE MONGOLE É SÎBÉ","	~ 185D ALT1 première forme (isolate)\n"
	"	~ 185D ALT1 première forme (initial)\n"
	"	~ 185D ALT1 première forme (medial)\n"
	"	~ 185D ALT1 première forme (final)\n"
	"	~ 185D 180B deuxième forme (medial)\n"
	"	~ 185D 180B deuxième forme (final)"},
/* 185E */ { "LETTRE MONGOLE I SÎBÉ","	~ 185E ALT1 première forme (isolate)\n"
	"	~ 185E ALT1 première forme (initial)\n"
	"	~ 185E ALT1 première forme (medial)\n"
	"	~ 185E ALT1 première forme (final)\n"
	"	~ 185E 180B deuxième forme (medial)\n"
	"	~ 185E 180B deuxième forme (final)\n"
	"	~ 185E 180C troisième forme (medial)\n"
	"	~ 185E 180C troisième forme (final)"},
/* 185F */ { "LETTRE MONGOLE IY SÎBÉ","	~ 185F ALT1 première forme (initial)\n"
	"	~ 185F ALT1 première forme (medial)\n"
	"	~ 185F ALT1 première forme (final)"},
/* 1860 */ { "LETTRE MONGOLE U SÎBÉ","	= lettre mongole ü sîbé\n"
	"	~ 1860 ALT1 première forme (initial)\n"
	"	~ 1860 ALT1 première forme (medial)\n"
	"	~ 1860 ALT1 première forme (final)\n"
	"	~ 1860 180B deuxième forme (medial)\n"
	"	~ 1860 180B deuxième forme (final)"},
/* 1861 */ { "LETTRE MONGOLE OU SÎBÉ","	~ 1861 ALT1 première forme (isolate)\n"
	"	~ 1861 ALT1 première forme (initial)\n"
	"	~ 1861 ALT1 première forme (medial)\n"
	"	~ 1861 ALT1 première forme (final)"},
/* 1862 */ { "LETTRE MONGOLE ANG SÎBÉ","	~ 1862 ALT1 première forme (initial)\n"
	"	~ 1862 ALT1 première forme (medial)\n"
	"	~ 1862 ALT1 première forme (final)"},
/* 1863 */ { "LETTRE MONGOLE KA SÎBÉ","	~ 1863 ALT1 première forme (initial)\n"
	"	~ 1863 ALT1 première forme (medial)\n"
	"	~ 1863 ALT1 première forme (final)\n"
	"	~ 1863 180B deuxième forme (medial)"},
/* 1864 */ { "LETTRE MONGOLE GA SÎBÉ","	~ 1864 ALT1 première forme (initial)\n"
	"	~ 1864 ALT1 première forme (medial)\n"
	"	~ 1864 ALT1 première forme (final)"},
/* 1865 */ { "LETTRE MONGOLE HA SÎBÉ","	~ 1865 ALT1 première forme (initial)\n"
	"	~ 1865 ALT1 première forme (medial)\n"
	"	~ 1865 ALT1 première forme (final)"},
/* 1866 */ { "LETTRE MONGOLE PA SÎBÉ","	~ 1866 ALT1 première forme (initial)\n"
	"	~ 1866 ALT1 première forme (medial)\n"
	"	~ 1866 ALT1 première forme (final)"},
/* 1867 */ { "LETTRE MONGOLE CHA SÎBÉ","	~ 1867 ALT1 première forme (initial)\n"
	"	~ 1867 ALT1 première forme (medial)\n"
	"	~ 1867 ALT1 première forme (final)"},
/* 1868 */ { "LETTRE MONGOLE TA SÎBÉ","	~ 1868 ALT1 première forme (initial)\n"
	"	~ 1868 ALT1 première forme (medial)\n"
	"	~ 1868 ALT1 première forme (final)\n"
	"	~ 1868 180B deuxième forme (initial)\n"
	"	~ 1868 180B deuxième forme (medial)\n"
	"	~ 1868 180C troisième forme (medial)"},
/* 1869 */ { "LETTRE MONGOLE DA SÎBÉ","	~ 1869 ALT1 première forme (initial)\n"
	"	~ 1869 ALT1 première forme (medial)\n"
	"	~ 1869 ALT1 première forme (final)\n"
	"	~ 1869 180B deuxième forme (initial)\n"
	"	~ 1869 180B deuxième forme (medial)"},
/* 186A */ { "LETTRE MONGOLE DJA SÎBÉ","	~ 186A ALT1 première forme (initial)\n"
	"	~ 186A ALT1 première forme (medial)\n"
	"	~ 186A ALT1 première forme (final)"},
/* 186B */ { "LETTRE MONGOLE FA SÎBÉ","	~ 186B ALT1 première forme (initial)\n"
	"	~ 186B ALT1 première forme (medial)\n"
	"	~ 186B ALT1 première forme (final)"},
/* 186C */ { "LETTRE MONGOLE GÂ SÎBÉ","	~ 186C ALT1 première forme (initial)\n"
	"	~ 186C ALT1 première forme (medial)\n"
	"	~ 186C ALT1 première forme (final)"},
/* 186D */ { "LETTRE MONGOLE HÂ SÎBÉ","	~ 186D ALT1 première forme (initial)\n"
	"	~ 186D ALT1 première forme (medial)\n"
	"	~ 186D ALT1 première forme (final)"},
/* 186E */ { "LETTRE MONGOLE TSA SÎBÉ","	~ 186E ALT1 première forme (initial)\n"
	"	~ 186E ALT1 première forme (medial)\n"
	"	~ 186E ALT1 première forme (final)"},
/* 186F */ { "LETTRE MONGOLE ZA SÎBÉ","	~ 186F ALT1 première forme (initial)\n"
	"	~ 186F ALT1 première forme (medial)\n"
	"	~ 186F ALT1 première forme (final)\n"
	"	~ 186F 180B deuxième forme (initial)\n"
	"	~ 186F 180B deuxième forme (medial)"},
/* 1870 */ { "LETTRE MONGOLE RÂ SÎBÉ","	~ 1870 ALT1 première forme (initial)\n"
	"	~ 1870 ALT1 première forme (medial)\n"
	"	~ 1870 ALT1 première forme (final)"},
/* 1871 */ { "LETTRE MONGOLE TCHA SÎBÉ","	~ 1871 ALT1 première forme (initial)\n"
	"	~ 1871 ALT1 première forme (medial)\n"
	"	~ 1871 ALT1 première forme (final)"},
/* 1872 */ { "LETTRE MONGOLE ZHA SÎBÉ","	~ 1872 ALT1 première forme (initial)\n"
	"	~ 1872 ALT1 première forme (medial)\n"
	"	~ 1872 ALT1 première forme (final)"},
/* 1873 */ { "LETTRE MONGOLE I MANDCHOU","	~ 1873 ALT1 première forme (isolate)\n"
	"	~ 1873 ALT1 première forme (initial)\n"
	"	~ 1873 ALT1 première forme (medial)\n"
	"	~ 1873 ALT1 première forme (final)\n"
	"	~ 1873 180B deuxième forme (medial)\n"
	"	~ 1873 180B deuxième forme (final)\n"
	"	~ 1873 180C troisième forme (medial)\n"
	"	~ 1873 180C troisième forme (final)\n"
	"	~ 1873 180D quatrième forme (medial)"},
/* 1874 */ { "LETTRE MONGOLE KA MANDCHOU","	~ 1874 ALT1 première forme (initial)\n"
	"	~ 1874 ALT1 première forme (medial)\n"
	"	~ 1874 ALT1 première forme (final)\n"
	"	~ 1874 180B deuxième forme (medial)\n"
	"	~ 1874 180B deuxième forme (final)\n"
	"	~ 1874 180C troisième forme (medial)\n"
	"	~ 1874 180C troisième forme (final)\n"
	"	~ 1874 180D quatrième forme (medial)"},
/* 1875 */ { "LETTRE MONGOLE RA MANDCHOU","	~ 1875 ALT1 première forme (initial)\n"
	"	~ 1875 ALT1 première forme (medial)\n"
	"	~ 1875 ALT1 première forme (final)"},
/* 1876 */ { "LETTRE MONGOLE FA MANDCHOU","	~ 1876 ALT1 première forme (initial)\n"
	"	~ 1876 ALT1 première forme (medial)\n"
	"	~ 1876 ALT1 première forme (final)\n"
	"	~ 1876 180B deuxième forme (initial)\n"
	"	~ 1876 180B deuxième forme (medial)"},
/* 1877 */ { "LETTRE MONGOLE ZHA MANDCHOU","	~ 1877 ALT1 première forme (initial)\n"
	"	~ 1877 ALT1 première forme (medial)\n"
	"	~ 1877 ALT1 première forme (final)"},
/* 1878 */ { NULL,NULL},
/* 1879 */ { NULL,NULL},
/* 187A */ { NULL,NULL},
/* 187B */ { NULL,NULL},
/* 187C */ { NULL,NULL},
/* 187D */ { NULL,NULL},
/* 187E */ { NULL,NULL},
/* 187F */ { NULL,NULL},
/* 1880 */ { "LETTRE MONGOLE ANOUSVÂRA UN ALI GALI","	x (diacritique tibétain sna ldan - 0F83)\n"
	"	~ 1880 180B deuxième forme"},
/* 1881 */ { "LETTRE MONGOLE VISARGA UN ALI GALI","	x (diacritique tibétain rnam bcad - 0F7F)\n"
	"	~ 1881 180B deuxième forme"},
/* 1882 */ { "LETTRE MONGOLE DAMAROU ALI GALI","	x (signe tibétain lce tsa can - 0F88)"},
/* 1883 */ { "LETTRE MONGOLE OUBADAMA ALI GALI",NULL},
/* 1884 */ { "LETTRE MONGOLE OUBADAMA CULBUTÉ ALI GALI","	x (signe tibétain mchu can - 0F89)"},
/* 1885 */ { "LETTRE MONGOLE BALOUDA ALI GALI","	x (signe tibétain paluta - 0F85)"},
/* 1886 */ { "LETTRE MONGOLE TROIS BALOUDAS ALI GALI",NULL},
/* 1887 */ { "LETTRE MONGOLE A ALI GALI","	~ 1887 ALT1 première forme (initial)\n"
	"	~ 1887 ALT1 première forme (medial)\n"
	"	~ 1887 ALT1 première forme (final)\n"
	"	~ 1887 180B deuxième forme (isolate)\n"
	"	~ 1887 180B deuxième forme (final)\n"
	"	~ 1887 180C troisième forme (final)\n"
	"	~ 1887 180D quatrième forme (final)"},
/* 1888 */ { "LETTRE MONGOLE I ALI GALI","	~ 1888 ALT1 première forme (initial)\n"
	"	~ 1888 ALT1 première forme (medial)\n"
	"	~ 1888 ALT1 première forme (final)\n"
	"	~ 1888 180B deuxième forme (final)"},
/* 1889 */ { "LETTRE MONGOLE KA ALI GALI","	~ 1889 ALT1 première forme (initial)\n"
	"	~ 1889 ALT1 première forme (medial)\n"
	"	~ 1889 ALT1 première forme (final)"},
/* 188A */ { "LETTRE MONGOLE NGA ALI GALI","	~ 188A ALT1 première forme (initial)\n"
	"	~ 188A ALT1 première forme (medial)\n"
	"	~ 188A ALT1 première forme (final)\n"
	"	~ 188A 180B deuxième forme (initial)\n"
	"	~ 188A 180B deuxième forme (medial)"},
/* 188B */ { "LETTRE MONGOLE TCHA ALI GALI","	~ 188B ALT1 première forme (initial)\n"
	"	~ 188B ALT1 première forme (medial)\n"
	"	~ 188B ALT1 première forme (final)"},
/* 188C */ { "LETTRE MONGOLE TTA ALI GALI","	~ 188C ALT1 première forme (initial)\n"
	"	~ 188C ALT1 première forme (medial)\n"
	"	~ 188C ALT1 première forme (final)"},
/* 188D */ { "LETTRE MONGOLE TTHA ALI GALI","	~ 188D ALT1 première forme (initial)\n"
	"	~ 188D ALT1 première forme (medial)\n"
	"	~ 188D ALT1 première forme (final)"},
/* 188E */ { "LETTRE MONGOLE DDA ALI GALI","	~ 188E ALT1 première forme (initial)\n"
	"	~ 188E ALT1 première forme (medial)\n"
	"	~ 188E ALT1 première forme (final)"},
/* 188F */ { "LETTRE MONGOLE NNA ALI GALI","	~ 188F ALT1 première forme (initial)\n"
	"	~ 188F ALT1 première forme (medial)\n"
	"	~ 188F ALT1 première forme (final)"},
/* 1890 */ { "LETTRE MONGOLE TA ALI GALI","	~ 1890 ALT1 première forme (initial)\n"
	"	~ 1890 ALT1 première forme (medial)\n"
	"	~ 1890 ALT1 première forme (final)"},
/* 1891 */ { "LETTRE MONGOLE DA ALI GALI","	~ 1891 ALT1 première forme (initial)\n"
	"	~ 1891 ALT1 première forme (medial)\n"
	"	~ 1891 ALT1 première forme (final)"},
/* 1892 */ { "LETTRE MONGOLE PA ALI GALI","	~ 1892 ALT1 première forme (initial)\n"
	"	~ 1892 ALT1 première forme (medial)\n"
	"	~ 1892 ALT1 première forme (final)"},
/* 1893 */ { "LETTRE MONGOLE PHA ALI GALI","	~ 1893 ALT1 première forme (initial)\n"
	"	~ 1893 ALT1 première forme (medial)\n"
	"	~ 1893 ALT1 première forme (final)"},
/* 1894 */ { "LETTRE MONGOLE ÇA ALI GALI","	~ 1894 ALT1 première forme (initial)\n"
	"	~ 1894 ALT1 première forme (medial)\n"
	"	~ 1894 ALT1 première forme (final)"},
/* 1895 */ { "LETTRE MONGOLE ZHA ALI GALI","	~ 1895 ALT1 première forme (initial)\n"
	"	~ 1895 ALT1 première forme (medial)\n"
	"	~ 1895 ALT1 première forme (final)"},
/* 1896 */ { "LETTRE MONGOLE ZA ALI GALI","	~ 1896 ALT1 première forme (initial)\n"
	"	~ 1896 ALT1 première forme (medial)\n"
	"	~ 1896 ALT1 première forme (final)"},
/* 1897 */ { "LETTRE MONGOLE AH ALI GALI","	~ 1897 ALT1 première forme (initial)\n"
	"	~ 1897 ALT1 première forme (medial)\n"
	"	~ 1897 ALT1 première forme (final)"},
/* 1898 */ { "LETTRE MONGOLE TA TODO ALI GALI","	~ 1898 ALT1 première forme (initial)\n"
	"	~ 1898 ALT1 première forme (medial)\n"
	"	~ 1898 ALT1 première forme (final)"},
/* 1899 */ { "LETTRE MONGOLE ZHA TODO ALI GALI","	~ 1899 ALT1 première forme (initial)\n"
	"	~ 1899 ALT1 première forme (medial)\n"
	"	~ 1899 ALT1 première forme (final)"},
/* 189A */ { "LETTRE MONGOLE GHA ALI GALI","	~ 189A ALT1 première forme (initial)\n"
	"	~ 189A ALT1 première forme (medial)\n"
	"	~ 189A ALT1 première forme (final)"},
/* 189B */ { "LETTRE MONGOLE NGA MANDCHOU ALI GALI","	~ 189B ALT1 première forme (initial)\n"
	"	~ 189B ALT1 première forme (medial)\n"
	"	~ 189B ALT1 première forme (final)"},
/* 189C */ { "LETTRE MONGOLE TCHA MANDCHOU ALI GALI","	~ 189C ALT1 première forme (initial)\n"
	"	~ 189C ALT1 première forme (medial)\n"
	"	~ 189C ALT1 première forme (final)"},
/* 189D */ { "LETTRE MONGOLE DJHA MANDCHOU ALI GALI","	~ 189D ALT1 première forme (initial)\n"
	"	~ 189D ALT1 première forme (medial)\n"
	"	~ 189D ALT1 première forme (final)"},
/* 189E */ { "LETTRE MONGOLE TTA MANDCHOU ALI GALI","	~ 189E ALT1 première forme (initial)\n"
	"	~ 189E ALT1 première forme (medial)\n"
	"	~ 189E ALT1 première forme (final)"},
/* 189F */ { "LETTRE MONGOLE DDHA MANDCHOU ALI GALI","	~ 189F ALT1 première forme (initial)\n"
	"	~ 189F ALT1 première forme (medial)\n"
	"	~ 189F ALT1 première forme (final)"},
/* 18A0 */ { "LETTRE MONGOLE TA MANDCHOU ALI GALI","	~ 18A0 ALT1 première forme (initial)\n"
	"	~ 18A0 ALT1 première forme (medial)\n"
	"	~ 18A0 ALT1 première forme (final)"},
/* 18A1 */ { "LETTRE MONGOLE DHA MANDCHOU ALI GALI","	~ 18A1 ALT1 première forme (initial)\n"
	"	~ 18A1 ALT1 première forme (medial)\n"
	"	~ 18A1 ALT1 première forme (final)"},
/* 18A2 */ { "LETTRE MONGOLE ÇA MANDCHOU ALI GALI","	~ 18A2 ALT1 première forme (initial)\n"
	"	~ 18A2 ALT1 première forme (medial)\n"
	"	~ 18A2 ALT1 première forme (final)"},
/* 18A3 */ { "LETTRE MONGOLE TCHYA MANDCHOU ALI GALI","	~ 18A3 ALT1 première forme (initial)\n"
	"	~ 18A3 ALT1 première forme (medial)\n"
	"	~ 18A3 ALT1 première forme (final)"},
/* 18A4 */ { "LETTRE MONGOLE ZHA MANDCHOU ALI GALI","	~ 18A4 ALT1 première forme (initial)\n"
	"	~ 18A4 ALT1 première forme (medial)\n"
	"	~ 18A4 ALT1 première forme (final)"},
/* 18A5 */ { "LETTRE MONGOLE ZA MANDCHOU ALI GALI","	~ 18A5 ALT1 première forme (initial)\n"
	"	~ 18A5 ALT1 première forme (medial)\n"
	"	~ 18A5 ALT1 première forme (final)"},
/* 18A6 */ { "LETTRE MONGOLE DEMI OU ALI GALI","	~ 18A6 ALT1 première forme (initial)\n"
	"	~ 18A6 ALT1 première forme (medial)\n"
	"	~ 18A6 ALT1 première forme (final)"},
/* 18A7 */ { "LETTRE MONGOLE DEMI YA ALI GALI","	~ 18A7 ALT1 première forme (initial)\n"
	"	~ 18A7 ALT1 première forme (medial)\n"
	"	~ 18A7 ALT1 première forme (final)"},
/* 18A8 */ { "LETTRE MONGOLE BHA ALI GALI","	~ 18A8 ALT1 première forme (initial)\n"
	"	~ 18A8 ALT1 première forme (medial)\n"
	"	~ 18A8 ALT1 première forme (final)"},
/* 18A9 */ { "LETTRE MONGOLE DAGALGA ALI GALI",NULL},
/* 18AA */ { "LETTRE MONGOLE MANDCHOUE LHA ALI GALI","	~ 18AA ALT1 première forme (initial)\n"
	"	~ 18AA ALT1 première forme (medial)\n"
	"	~ 18AA ALT1 première forme (final)"},
/* 18AB */ { NULL,NULL},
/* 18AC */ { NULL,NULL},
/* 18AD */ { NULL,NULL},
/* 18AE */ { NULL,NULL},
/* 18AF */ { NULL,NULL},
/* 18B0 */ { "SYLLABE CANADIENNE OY",NULL},
/* 18B1 */ { "SYLLABE CANADIENNE AY",NULL},
/* 18B2 */ { "SYLLABE CANADIENNE ÂY",NULL},
/* 18B3 */ { "SYLLABE CANADIENNE WAY",NULL},
/* 18B4 */ { "SYLLABE CANADIENNE POY",NULL},
/* 18B5 */ { "SYLLABE CANADIENNE PAY",NULL},
/* 18B6 */ { "SYLLABE CANADIENNE POUOY",NULL},
/* 18B7 */ { "SYLLABE CANADIENNE TAY",NULL},
/* 18B8 */ { "SYLLABE CANADIENNE KAY",NULL},
/* 18B9 */ { "SYLLABE CANADIENNE KOUAY",NULL},
/* 18BA */ { "SYLLABE CANADIENNE MAY",NULL},
/* 18BB */ { "SYLLABE CANADIENNE NOY",NULL},
/* 18BC */ { "SYLLABE CANADIENNE NAY",NULL},
/* 18BD */ { "SYLLABE CANADIENNE LAY",NULL},
/* 18BE */ { "SYLLABE CANADIENNE SOY",NULL},
/* 18BF */ { "SYLLABE CANADIENNE SAY",NULL},
/* 18C0 */ { "SYLLABE CANADIENNE SHOY",NULL},
/* 18C1 */ { "SYLLABE CANADIENNE CHAY",NULL},
/* 18C2 */ { "SYLLABE CANADIENNE CHOUOY",NULL},
/* 18C3 */ { "SYLLABE CANADIENNE YOY",NULL},
/* 18C4 */ { "SYLLABE CANADIENNE YAY",NULL},
/* 18C5 */ { "SYLLABE CANADIENNE RAY",NULL},
/* 18C6 */ { "SYLLABE CANADIENNE NOUI",NULL},
/* 18C7 */ { "SYLLABE CANADIENNE NOUI OJIBWÉ",NULL},
/* 18C8 */ { "SYLLABE CANADIENNE NOUÎ",NULL},
/* 18C9 */ { "SYLLABE CANADIENNE NOUÎ OJIBWÉ",NULL},
/* 18CA */ { "SYLLABE CANADIENNE NOUO",NULL},
/* 18CB */ { "SYLLABE CANADIENNE NOUO OJIBWÉ",NULL},
/* 18CC */ { "SYLLABE CANADIENNE NOUÔ",NULL},
/* 18CD */ { "SYLLABE CANADIENNE NOUÔ OJIBWÉ",NULL},
/* 18CE */ { "SYLLABE CANADIENNE ROUÉ",NULL},
/* 18CF */ { "SYLLABE CANADIENNE ROUI",NULL},
/* 18D0 */ { "SYLLABE CANADIENNE ROUÎ",NULL},
/* 18D1 */ { "SYLLABE CANADIENNE ROUO",NULL},
/* 18D2 */ { "SYLLABE CANADIENNE ROUÔ",NULL},
/* 18D3 */ { "SYLLABE CANADIENNE ROUA",NULL},
/* 18D4 */ { "SYLLABE CANADIENNE P OJIBWÉ",NULL},
/* 18D5 */ { "SYLLABE CANADIENNE T OJIBWÉ",NULL},
/* 18D6 */ { "SYLLABE CANADIENNE K OJIBWÉ",NULL},
/* 18D7 */ { "SYLLABE CANADIENNE TCH OJIBWÉ",NULL},
/* 18D8 */ { "SYLLABE CANADIENNE M OJIBWÉ",NULL},
/* 18D9 */ { "SYLLABE CANADIENNE N OJIBWÉ",NULL},
/* 18DA */ { "SYLLABE CANADIENNE S OJIBWÉ",NULL},
/* 18DB */ { "SYLLABE CANADIENNE CH OJIBWÉ",NULL},
/* 18DC */ { "SYLLABE CANADIENNE OU DE L'EST",NULL},
/* 18DD */ { "SYLLABE CANADIENNE OU DE L'OUEST",NULL},
/* 18DE */ { "SYLLABE CANADIENNE FINALE PETIT ROND",NULL},
/* 18DF */ { "SYLLABE CANADIENNE FINALE POINT ÉLEVÉ",NULL},
/* 18E0 */ { "SYLLABE CANADIENNE ROUE CRI-R",NULL},
/* 18E1 */ { "SYLLABE CANADIENNE LÔ CRI DES PLAINES",NULL},
/* 18E2 */ { "SYLLABE CANADIENNE LÂ CRI DES PLAINES",NULL},
/* 18E3 */ { "SYLLABE CANADIENNE THOUE",NULL},
/* 18E4 */ { "SYLLABE CANADIENNE THOUA",NULL},
/* 18E5 */ { "SYLLABE CANADIENNE TTHOUE",NULL},
/* 18E6 */ { "SYLLABE CANADIENNE TTHÔ",NULL},
/* 18E7 */ { "SYLLABE CANADIENNE TTHÂ",NULL},
/* 18E8 */ { "SYLLABE CANADIENNE TLHOUE",NULL},
/* 18E9 */ { "SYLLABE CANADIENNE TLHÔ",NULL},
/* 18EA */ { "SYLLABE CANADIENNE CHOUE SAYISI",NULL},
/* 18EB */ { "SYLLABE CANADIENNE CHÔ SAYISI",NULL},
/* 18EC */ { "SYLLABE CANADIENNE HÔ SAYISI",NULL},
/* 18ED */ { "SYLLABE CANADIENNE GOUOU PORTEUR",NULL},
/* 18EE */ { "SYLLABE CANADIENNE GÉ DÉNÉ PORTEUR",NULL},
/* 18EF */ { "SYLLABE CANADIENNE GÂ PORTEUR",NULL},
/* 18F0 */ { "SYLLABE CANADIENNE GOUA PORTEUR",NULL},
/* 18F1 */ { "SYLLABE CANADIENNE DJOÛ SAYISI",NULL},
/* 18F2 */ { "SYLLABE CANADIENNE DJOUA PORTEUR",NULL},
/* 18F3 */ { "SYLLABE CANADIENNE L DÉNÉ CASTOR",NULL},
/* 18F4 */ { "SYLLABE CANADIENNE R DÉNÉ CASTOR",NULL},
/* 18F5 */ { "SYLLABE CANADIENNE S DENTAL PORTEUR",NULL},
/* 18F6 */ { NULL,NULL},
/* 18F7 */ { NULL,NULL},
/* 18F8 */ { NULL,NULL},
/* 18F9 */ { NULL,NULL},
/* 18FA */ { NULL,NULL},
/* 18FB */ { NULL,NULL},
/* 18FC */ { NULL,NULL},
/* 18FD */ { NULL,NULL},
/* 18FE */ { NULL,NULL},
/* 18FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_19[] = {
/* 1900 */ { "LETTRE LIMBU PORTE-VOYELLE",NULL},
/* 1901 */ { "LETTRE LIMBU KA",NULL},
/* 1902 */ { "LETTRE LIMBU KHA",NULL},
/* 1903 */ { "LETTRE LIMBU GA",NULL},
/* 1904 */ { "LETTRE LIMBU GHA",NULL},
/* 1905 */ { "LETTRE LIMBU NGA",NULL},
/* 1906 */ { "LETTRE LIMBU TCHA",NULL},
/* 1907 */ { "LETTRE LIMBU TCHHA",NULL},
/* 1908 */ { "LETTRE LIMBU DJA",NULL},
/* 1909 */ { "LETTRE LIMBU DJHA",NULL},
/* 190A */ { "LETTRE LIMBU YAN",NULL},
/* 190B */ { "LETTRE LIMBU TA",NULL},
/* 190C */ { "LETTRE LIMBU THA",NULL},
/* 190D */ { "LETTRE LIMBU DA",NULL},
/* 190E */ { "LETTRE LIMBU DHA",NULL},
/* 190F */ { "LETTRE LIMBU NA",NULL},
/* 1910 */ { "LETTRE LIMBU PA",NULL},
/* 1911 */ { "LETTRE LIMBU PHA",NULL},
/* 1912 */ { "LETTRE LIMBU BA",NULL},
/* 1913 */ { "LETTRE LIMBU BHA",NULL},
/* 1914 */ { "LETTRE LIMBU MA",NULL},
/* 1915 */ { "LETTRE LIMBU YA",NULL},
/* 1916 */ { "LETTRE LIMBU RA",NULL},
/* 1917 */ { "LETTRE LIMBU LA",NULL},
/* 1918 */ { "LETTRE LIMBU WA",NULL},
/* 1919 */ { "LETTRE LIMBU ÇA",NULL},
/* 191A */ { "LETTRE LIMBU CHA",NULL},
/* 191B */ { "LETTRE LIMBU SA",NULL},
/* 191C */ { "LETTRE LIMBU HA",NULL},
/* 191D */ { "LETTRE LIMBU GYAN",NULL},
/* 191E */ { "LETTRE LIMBU TRA",NULL},
/* 191F */ { NULL,NULL},
/* 1920 */ { "DIACRITIQUE VOYELLE LIMBU A",NULL},
/* 1921 */ { "DIACRITIQUE VOYELLE LIMBU I",NULL},
/* 1922 */ { "DIACRITIQUE VOYELLE LIMBU OU",NULL},
/* 1923 */ { "DIACRITIQUE VOYELLE LIMBU É",NULL},
/* 1924 */ { "DIACRITIQUE VOYELLE LIMBU AÏ",NULL},
/* 1925 */ { "DIACRITIQUE VOYELLE LIMBU Ô",NULL},
/* 1926 */ { "DIACRITIQUE VOYELLE LIMBU AOU",NULL},
/* 1927 */ { "DIACRITIQUE VOYELLE LIMBU È",NULL},
/* 1928 */ { "DIACRITIQUE VOYELLE LIMBU O",NULL},
/* 1929 */ { "LETTRE SUBJOINTE LIMBU YA",NULL},
/* 192A */ { "LETTRE SUBJOINTE LIMBU RA",NULL},
/* 192B */ { "LETTRE SUBJOINTE LIMBU WA",NULL},
/* 192C */ { NULL,NULL},
/* 192D */ { NULL,NULL},
/* 192E */ { NULL,NULL},
/* 192F */ { NULL,NULL},
/* 1930 */ { "PETITE LETTRE LIMBU KA",NULL},
/* 1931 */ { "PETITE LETTRE LIMBU NGA",NULL},
/* 1932 */ { "PETITE LETTRE LIMBU ANOUSVÂRA",NULL},
/* 1933 */ { "PETITE LETTRE LIMBU TA",NULL},
/* 1934 */ { "PETITE LETTRE LIMBU NA",NULL},
/* 1935 */ { "PETITE LETTRE LIMBU PA",NULL},
/* 1936 */ { "PETITE LETTRE LIMBU MA",NULL},
/* 1937 */ { "PETITE LETTRE LIMBU RA",NULL},
/* 1938 */ { "PETITE LETTRE LIMBU LA",NULL},
/* 1939 */ { "DIACRITIQUE LIMBU MOUKPHRENG",NULL},
/* 193A */ { "DIACRITIQUE LIMBU KEMPHRENG",NULL},
/* 193B */ { "DIACRITIQUE LIMBU SA-I",NULL},
/* 193C */ { NULL,NULL},
/* 193D */ { NULL,NULL},
/* 193E */ { NULL,NULL},
/* 193F */ { NULL,NULL},
/* 1940 */ { "SIGNE LIMBU LÔ",NULL},
/* 1941 */ { NULL,NULL},
/* 1942 */ { NULL,NULL},
/* 1943 */ { NULL,NULL},
/* 1944 */ { "POINT D'EXCLAMATION LIMBU",NULL},
/* 1945 */ { "POINT D'INTERROGATION LIMBU",NULL},
/* 1946 */ { "CHIFFRE LIMBU ZÉRO",NULL},
/* 1947 */ { "CHIFFRE LIMBU UN",NULL},
/* 1948 */ { "CHIFFRE LIMBU DEUX",NULL},
/* 1949 */ { "CHIFFRE LIMBU TROIS",NULL},
/* 194A */ { "CHIFFRE LIMBU QUATRE",NULL},
/* 194B */ { "CHIFFRE LIMBU CINQ",NULL},
/* 194C */ { "CHIFFRE LIMBU SIX",NULL},
/* 194D */ { "CHIFFRE LIMBU SEPT",NULL},
/* 194E */ { "CHIFFRE LIMBU HUIT",NULL},
/* 194F */ { "CHIFFRE LIMBU NEUF",NULL},
/* 1950 */ { "LETTRE TAÏ-LE KA",NULL},
/* 1951 */ { "LETTRE TAÏ-LE XA",NULL},
/* 1952 */ { "LETTRE TAÏ-LE NGA",NULL},
/* 1953 */ { "LETTRE TAÏ-LE TSA",NULL},
/* 1954 */ { "LETTRE TAÏ-LE SA",NULL},
/* 1955 */ { "LETTRE TAÏ-LE YA",NULL},
/* 1956 */ { "LETTRE TAÏ-LE TA",NULL},
/* 1957 */ { "LETTRE TAÏ-LE THA",NULL},
/* 1958 */ { "LETTRE TAÏ-LE LA",NULL},
/* 1959 */ { "LETTRE TAÏ-LE PA",NULL},
/* 195A */ { "LETTRE TAÏ-LE PHA",NULL},
/* 195B */ { "LETTRE TAÏ-LE MA",NULL},
/* 195C */ { "LETTRE TAÏ-LE FA",NULL},
/* 195D */ { "LETTRE TAÏ-LE VA",NULL},
/* 195E */ { "LETTRE TAÏ-LE HA",NULL},
/* 195F */ { "LETTRE TAÏ-LE 'A",NULL},
/* 1960 */ { "LETTRE TAÏ-LE KHA",NULL},
/* 1961 */ { "LETTRE TAÏ-LE TCHA",NULL},
/* 1962 */ { "LETTRE TAÏ-LE NA",NULL},
/* 1963 */ { "LETTRE TAÏ-LE A",NULL},
/* 1964 */ { "LETTRE TAÏ-LE I",NULL},
/* 1965 */ { "LETTRE TAÏ-LE É",NULL},
/* 1966 */ { "LETTRE TAÏ-LE IA",NULL},
/* 1967 */ { "LETTRE TAÏ-LE OU",NULL},
/* 1968 */ { "LETTRE TAÏ-LE Ô",NULL},
/* 1969 */ { "LETTRE TAÏ-LE O",NULL},
/* 196A */ { "LETTRE TAÏ-LE OUE",NULL},
/* 196B */ { "LETTRE TAÏ-LE E",NULL},
/* 196C */ { "LETTRE TAÏ-LE AOUE",NULL},
/* 196D */ { "LETTRE TAÏ-LE AÏ",NULL},
/* 196E */ { NULL,NULL},
/* 196F */ { NULL,NULL},
/* 1970 */ { "LETTRE TAÏ-LE TON-2",NULL},
/* 1971 */ { "LETTRE TAÏ-LE TON-3",NULL},
/* 1972 */ { "LETTRE TAÏ-LE TON-4",NULL},
/* 1973 */ { "LETTRE TAÏ-LE TON-5",NULL},
/* 1974 */ { "LETTRE TAÏ-LE TON-6",NULL},
/* 1975 */ { NULL,NULL},
/* 1976 */ { NULL,NULL},
/* 1977 */ { NULL,NULL},
/* 1978 */ { NULL,NULL},
/* 1979 */ { NULL,NULL},
/* 197A */ { NULL,NULL},
/* 197B */ { NULL,NULL},
/* 197C */ { NULL,NULL},
/* 197D */ { NULL,NULL},
/* 197E */ { NULL,NULL},
/* 197F */ { NULL,NULL},
/* 1980 */ { "LETTRE NOUVEAU TAÏ LÜ QA HAUT",NULL},
/* 1981 */ { "LETTRE NOUVEAU TAÏ LÜ QA BAS",NULL},
/* 1982 */ { "LETTRE NOUVEAU TAÏ LÜ KA HAUT",NULL},
/* 1983 */ { "LETTRE NOUVEAU TAÏ LÜ XA HAUT",NULL},
/* 1984 */ { "LETTRE NOUVEAU TAÏ LÜ NGA HAUT",NULL},
/* 1985 */ { "LETTRE NOUVEAU TAÏ LÜ KA BAS",NULL},
/* 1986 */ { "LETTRE NOUVEAU TAÏ LÜ XA BAS",NULL},
/* 1987 */ { "LETTRE NOUVEAU TAÏ LÜ NGA BAS",NULL},
/* 1988 */ { "LETTRE NOUVEAU TAÏ LÜ TSA HAUT",NULL},
/* 1989 */ { "LETTRE NOUVEAU TAÏ LÜ SA HAUT",NULL},
/* 198A */ { "LETTRE NOUVEAU TAÏ LÜ YA HAUT",NULL},
/* 198B */ { "LETTRE NOUVEAU TAÏ LÜ TSA BAS",NULL},
/* 198C */ { "LETTRE NOUVEAU TAÏ LÜ SA BAS",NULL},
/* 198D */ { "LETTRE NOUVEAU TAÏ LÜ YA BAS",NULL},
/* 198E */ { "LETTRE NOUVEAU TAÏ LÜ TA HAUT",NULL},
/* 198F */ { "LETTRE NOUVEAU TAÏ LÜ THA HAUT",NULL},
/* 1990 */ { "LETTRE NOUVEAU TAÏ LÜ NA HAUT",NULL},
/* 1991 */ { "LETTRE NOUVEAU TAÏ LÜ TA BAS",NULL},
/* 1992 */ { "LETTRE NOUVEAU TAÏ LÜ THA BAS",NULL},
/* 1993 */ { "LETTRE NOUVEAU TAÏ LÜ NA BAS",NULL},
/* 1994 */ { "LETTRE NOUVEAU TAÏ LÜ PA HAUT",NULL},
/* 1995 */ { "LETTRE NOUVEAU TAÏ LÜ PHA HAUT",NULL},
/* 1996 */ { "LETTRE NOUVEAU TAÏ LÜ MA HAUT",NULL},
/* 1997 */ { "LETTRE NOUVEAU TAÏ LÜ PA BAS",NULL},
/* 1998 */ { "LETTRE NOUVEAU TAÏ LÜ PHA BAS",NULL},
/* 1999 */ { "LETTRE NOUVEAU TAÏ LÜ MA BAS",NULL},
/* 199A */ { "LETTRE NOUVEAU TAÏ LÜ FA HAUT",NULL},
/* 199B */ { "LETTRE NOUVEAU TAÏ LÜ VA HAUT",NULL},
/* 199C */ { "LETTRE NOUVEAU TAÏ LÜ LA HAUT",NULL},
/* 199D */ { "LETTRE NOUVEAU TAÏ LÜ FA BAS",NULL},
/* 199E */ { "LETTRE NOUVEAU TAÏ LÜ VA BAS",NULL},
/* 199F */ { "LETTRE NOUVEAU TAÏ LÜ LA BAS",NULL},
/* 19A0 */ { "LETTRE NOUVEAU TAÏ LÜ HA HAUT",NULL},
/* 19A1 */ { "LETTRE NOUVEAU TAÏ LÜ DA HAUT",NULL},
/* 19A2 */ { "LETTRE NOUVEAU TAÏ LÜ BA HAUT",NULL},
/* 19A3 */ { "LETTRE NOUVEAU TAÏ LÜ HA BAS",NULL},
/* 19A4 */ { "LETTRE NOUVEAU TAÏ LÜ DA BAS",NULL},
/* 19A5 */ { "LETTRE NOUVEAU TAÏ LÜ BA BAS",NULL},
/* 19A6 */ { "LETTRE NOUVEAU TAÏ LÜ KVA HAUT",NULL},
/* 19A7 */ { "LETTRE NOUVEAU TAÏ LÜ XVA HAUT",NULL},
/* 19A8 */ { "LETTRE NOUVEAU TAÏ LÜ KVA BAS",NULL},
/* 19A9 */ { "LETTRE NOUVEAU TAÏ LÜ XVA BAS",NULL},
/* 19AA */ { "LETTRE NOUVEAU TAÏ LÜ SUA HAUT",NULL},
/* 19AB */ { "LETTRE NOUVEAU TAÏ LÜ SUA BAS","	* un groupe consonantique labialisé"},
/* 19AC */ { NULL,NULL},
/* 19AD */ { NULL,NULL},
/* 19AE */ { NULL,NULL},
/* 19AF */ { NULL,NULL},
/* 19B0 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ RÉDUCTEUR DE VOYELLE",NULL},
/* 19B1 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ Â",NULL},
/* 19B2 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ Î",NULL},
/* 19B3 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ OU",NULL},
/* 19B4 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ OÛ",NULL},
/* 19B5 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ É",NULL},
/* 19B6 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ Ê",NULL},
/* 19B7 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ Ô",NULL},
/* 19B8 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ O",NULL},
/* 19B9 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ Û",NULL},
/* 19BA */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ AÏ",NULL},
/* 19BB */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ ÂÏ",NULL},
/* 19BC */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ OUÏ",NULL},
/* 19BD */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ ÔÏ",NULL},
/* 19BE */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ OÏ",NULL},
/* 19BF */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ UÏ",NULL},
/* 19C0 */ { "DIACRITIQUE VOYELLE NOUVEAU TAÏ LÜ EÏ",NULL},
/* 19C1 */ { "LETTRE NOUVEAU TAÏ LÜ V FINAL",NULL},
/* 19C2 */ { "LETTRE NOUVEAU TAÏ LÜ NG FINAL",NULL},
/* 19C3 */ { "LETTRE NOUVEAU TAÏ LÜ N FINAL",NULL},
/* 19C4 */ { "LETTRE NOUVEAU TAÏ LÜ M FINAL",NULL},
/* 19C5 */ { "LETTRE NOUVEAU TAÏ LÜ K FINAL",NULL},
/* 19C6 */ { "LETTRE NOUVEAU TAÏ LÜ D FINAL",NULL},
/* 19C7 */ { "LETTRE NOUVEAU TAÏ LÜ B FINAL",NULL},
/* 19C8 */ { "DIACRITIQUE NOUVEAU TAÏ LÜ TON-1",NULL},
/* 19C9 */ { "DIACRITIQUE NOUVEAU TAÏ LÜ TON-2",NULL},
/* 19CA */ { NULL,NULL},
/* 19CB */ { NULL,NULL},
/* 19CC */ { NULL,NULL},
/* 19CD */ { NULL,NULL},
/* 19CE */ { NULL,NULL},
/* 19CF */ { NULL,NULL},
/* 19D0 */ { "CHIFFRE NOUVEAU TAÏ LÜ ZÉRO",NULL},
/* 19D1 */ { "CHIFFRE NOUVEAU TAÏ LÜ UN",NULL},
/* 19D2 */ { "CHIFFRE NOUVEAU TAÏ LÜ DEUX",NULL},
/* 19D3 */ { "CHIFFRE NOUVEAU TAÏ LÜ TROIS",NULL},
/* 19D4 */ { "CHIFFRE NOUVEAU TAÏ LÜ QUATRE",NULL},
/* 19D5 */ { "CHIFFRE NOUVEAU TAÏ LÜ CINQ",NULL},
/* 19D6 */ { "CHIFFRE NOUVEAU TAÏ LÜ SIX",NULL},
/* 19D7 */ { "CHIFFRE NOUVEAU TAÏ LÜ SEPT",NULL},
/* 19D8 */ { "CHIFFRE NOUVEAU TAÏ LÜ HUIT",NULL},
/* 19D9 */ { "CHIFFRE NOUVEAU TAÏ LÜ NEUF",NULL},
/* 19DA */ { "CHIFFRE NOUVEAU TAÏ LÜ THAM UN",NULL},
/* 19DB */ { NULL,NULL},
/* 19DC */ { NULL,NULL},
/* 19DD */ { NULL,NULL},
/* 19DE */ { "SIGNE NOUVEAU TAÏ LÜ LÊ","	* conjonction : et"},
/* 19DF */ { "SIGNE NOUVEAU TAÏ LÜ LÊV","	* perfectif"},
/* 19E0 */ { "SYMBOLE KHMER PATHAMASAT","	* représente le premier août des années bissextiles\n"
	"		Les quinze caractères suivants représentent les quinze jours de lune croissante."},
/* 19E1 */ { "SYMBOLE KHMER PREMIÈRE LUNE CROISSANTE","	= mouei khneut"},
/* 19E2 */ { "SYMBOLE KHMER DEUXIÈME LUNE CROISSANTE","	= pii khneut"},
/* 19E3 */ { "SYMBOLE KHMER TROISIÈME LUNE CROISSANTE","	= bèi khneut"},
/* 19E4 */ { "SYMBOLE KHMER QUATRIÈME LUNE CROISSANTE","	= buen khneut"},
/* 19E5 */ { "SYMBOLE KHMER CINQUIÈME LUNE CROISSANTE","	= pram khneut"},
/* 19E6 */ { "SYMBOLE KHMER SIXIÈME LUNE CROISSANTE","	= pram-mouei khneut"},
/* 19E7 */ { "SYMBOLE KHMER SEPTIÈME LUNE CROISSANTE","	= pram-pii khneut"},
/* 19E8 */ { "SYMBOLE KHMER HUITIÈME LUNE CROISSANTE","	= pram-bèi khneut"},
/* 19E9 */ { "SYMBOLE KHMER NEUVIÈME LUNE CROISSANTE","	= pram-buen khneut"},
/* 19EA */ { "SYMBOLE KHMER DIXIÈME LUNE CROISSANTE","	= dâp khneut"},
/* 19EB */ { "SYMBOLE KHMER ONZIÈME LUNE CROISSANTE","	= dâp-mouei khneut"},
/* 19EC */ { "SYMBOLE KHMER DOUZIÈME LUNE CROISSANTE","	= dâp-pii khneut"},
/* 19ED */ { "SYMBOLE KHMER TREIZIÈME LUNE CROISSANTE","	= dâp-bèi khneut"},
/* 19EE */ { "SYMBOLE KHMER QUATORZIÈME LUNE CROISSANTE","	= dâp-buen khneut"},
/* 19EF */ { "SYMBOLE KHMER QUINZIÈME LUNE CROISSANTE","	= dâp-pram khneut"},
/* 19F0 */ { "SYMBOLE KHMER TUTEYASAT","	* représente le deux août des années bissextiles\n"
	"		Les quinze caractères suivants représentent les quinze jours de lune décroissante."},
/* 19F1 */ { "SYMBOLE KHMER PREMIÈRE LUNE DÉCROISSANTE","	= mouei rootch"},
/* 19F2 */ { "SYMBOLE KHMER DEUXIÈME LUNE DÉCROISSANTE","	= pii rootch"},
/* 19F3 */ { "SYMBOLE KHMER TROISIÈME LUNE DÉCROISSANTE","	= bèi rootch"},
/* 19F4 */ { "SYMBOLE KHMER QUATRIÈME LUNE DÉCROISSANTE","	= buen rootch"},
/* 19F5 */ { "SYMBOLE KHMER CINQUIÈME LUNE DÉCROISSANTE","	= pram rootch"},
/* 19F6 */ { "SYMBOLE KHMER SIXIÈME LUNE DÉCROISSANTE","	= pram-moeui rootch"},
/* 19F7 */ { "SYMBOLE KHMER SEPTIÈME LUNE DÉCROISSANTE","	= pram-pii rootch"},
/* 19F8 */ { "SYMBOLE KHMER HUITIÈME LUNE DÉCROISSANTE","	= pram-bèi rootch"},
/* 19F9 */ { "SYMBOLE KHMER NEUVIÈME LUNE DÉCROISSANTE","	= pram-buen rootch"},
/* 19FA */ { "SYMBOLE KHMER DIXIÈME LUNE DÉCROISSANTE","	= dâp rootch"},
/* 19FB */ { "SYMBOLE KHMER ONZIÈME LUNE DÉCROISSANTE","	= dâp-moei rootch"},
/* 19FC */ { "SYMBOLE KHMER DOUZIÈME LUNE DÉCROISSANTE","	= dâp-pii rootch"},
/* 19FD */ { "SYMBOLE KHMER TREIZIÈME LUNE DÉCROISSANTE","	= dâp-bèi rootch"},
/* 19FE */ { "SYMBOLE KHMER QUATORZIÈME LUNE DÉCROISSANTE","	= dâp-buen rootch"},
/* 19FF */ { "SYMBOLE KHMER QUINZIÈME LUNE DÉCROISSANTE","	= dâp-pram rootch"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_1A[] = {
/* 1A00 */ { "LETTRE BOUGUIE KA",NULL},
/* 1A01 */ { "LETTRE BOUGUIE GA",NULL},
/* 1A02 */ { "LETTRE BOUGUIE NGA",NULL},
/* 1A03 */ { "LETTRE BOUGUIE NGKA",NULL},
/* 1A04 */ { "LETTRE BOUGUIE PA",NULL},
/* 1A05 */ { "LETTRE BOUGUIE BA",NULL},
/* 1A06 */ { "LETTRE BOUGUIE MA",NULL},
/* 1A07 */ { "LETTRE BOUGUIE MPA",NULL},
/* 1A08 */ { "LETTRE BOUGUIE TA",NULL},
/* 1A09 */ { "LETTRE BOUGUIE DA",NULL},
/* 1A0A */ { "LETTRE BOUGUIE NA",NULL},
/* 1A0B */ { "LETTRE BOUGUIE NRA",NULL},
/* 1A0C */ { "LETTRE BOUGUIE TCHA",NULL},
/* 1A0D */ { "LETTRE BOUGUIE DJA",NULL},
/* 1A0E */ { "LETTRE BOUGUIE ÑA",NULL},
/* 1A0F */ { "LETTRE BOUGUIE ÑTCHA",NULL},
/* 1A10 */ { "LETTRE BOUGUIE YA",NULL},
/* 1A11 */ { "LETTRE BOUGUIE RA",NULL},
/* 1A12 */ { "LETTRE BOUGUIE LA",NULL},
/* 1A13 */ { "LETTRE BOUGUIE VA",NULL},
/* 1A14 */ { "LETTRE BOUGUIE SA",NULL},
/* 1A15 */ { "LETTRE BOUGUIE A",NULL},
/* 1A16 */ { "LETTRE BOUGUIE HA",NULL},
/* 1A17 */ { "DIACRITIQUE VOYELLE BOUGUIE I",NULL},
/* 1A18 */ { "DIACRITIQUE VOYELLE BOUGUIE OU",NULL},
/* 1A19 */ { "DIACRITIQUE VOYELLE BOUGUIE É",NULL},
/* 1A1A */ { "DIACRITIQUE VOYELLE BOUGUIE O",NULL},
/* 1A1B */ { "DIACRITIQUE VOYELLE BOUGUIE E",NULL},
/* 1A1C */ { NULL,NULL},
/* 1A1D */ { NULL,NULL},
/* 1A1E */ { "PALLAWA BOUGUI",NULL},
/* 1A1F */ { "FIN DE SECTION BOUGUIE",NULL},
/* 1A20 */ { "LETTRE TAÏ-THAM KA HAUT",NULL},
/* 1A21 */ { "LETTRE TAÏ-THAM KHA HAUT",NULL},
/* 1A22 */ { "LETTRE TAÏ-THAM KXA HAUT",NULL},
/* 1A23 */ { "LETTRE TAÏ-THAM KA BAS",NULL},
/* 1A24 */ { "LETTRE TAÏ-THAM KXA BAS",NULL},
/* 1A25 */ { "LETTRE TAÏ-THAM KHA BAS",NULL},
/* 1A26 */ { "LETTRE TAÏ-THAM NGA",NULL},
/* 1A27 */ { "LETTRE TAÏ-THAM CA HAUT",NULL},
/* 1A28 */ { "LETTRE TAÏ-THAM CHA HAUT",NULL},
/* 1A29 */ { "LETTRE TAÏ-THAM CA BAS",NULL},
/* 1A2A */ { "LETTRE TAÏ-THAM SA BAS",NULL},
/* 1A2B */ { "LETTRE TAÏ-THAM CHA BAS",NULL},
/* 1A2C */ { "LETTRE TAÏ-THAM ÑA",NULL},
/* 1A2D */ { "LETTRE TAÏ-THAM RATA",NULL},
/* 1A2E */ { "LETTRE TAÏ-THAM RATHA HAUT","	* une variante avec la partie supérieure qui a la forme de 1A33 est utilisée en Thaïlande et au Laos\n"
	"	* contraste avec la séquence 1A2D 1A5B"},
/* 1A2F */ { "LETTRE TAÏ-THAM DA",NULL},
/* 1A30 */ { "LETTRE TAÏ-THAM RATHA BAS",NULL},
/* 1A31 */ { "LETTRE TAÏ-THAM RANA",NULL},
/* 1A32 */ { "LETTRE TAÏ-THAM TA HAUT",NULL},
/* 1A33 */ { "LETTRE TAÏ-THAM THA HAUT",NULL},
/* 1A34 */ { "LETTRE TAÏ-THAM TA BAS",NULL},
/* 1A35 */ { "LETTRE TAÏ-THAM THA BAS",NULL},
/* 1A36 */ { "LETTRE TAÏ-THAM NA",NULL},
/* 1A37 */ { "LETTRE TAÏ-THAM BA",NULL},
/* 1A38 */ { "LETTRE TAÏ-THAM PA HAUT",NULL},
/* 1A39 */ { "LETTRE TAÏ-THAM PHA HAUT",NULL},
/* 1A3A */ { "LETTRE TAÏ-THAM FA HAUT",NULL},
/* 1A3B */ { "LETTRE TAÏ-THAM PA BAS",NULL},
/* 1A3C */ { "LETTRE TAÏ-THAM FA BAS",NULL},
/* 1A3D */ { "LETTRE TAÏ-THAM PHA BAS",NULL},
/* 1A3E */ { "LETTRE TAÏ-THAM MA",NULL},
/* 1A3F */ { "LETTRE TAÏ-THAM YA BAS",NULL},
/* 1A40 */ { "LETTRE TAÏ-THAM YA HAUT",NULL},
/* 1A41 */ { "LETTRE TAÏ-THAM RA",NULL},
/* 1A42 */ { "LETTRE TAÏ-THAM RUE",NULL},
/* 1A43 */ { "LETTRE TAÏ-THAM LA",NULL},
/* 1A44 */ { "LETTRE TAÏ-THAM LUE",NULL},
/* 1A45 */ { "LETTRE TAÏ-THAM WA",NULL},
/* 1A46 */ { "LETTRE TAÏ-THAM SHA HAUT",NULL},
/* 1A47 */ { "LETTRE TAÏ-THAM SSA HAUT",NULL},
/* 1A48 */ { "LETTRE TAÏ-THAM SA HAUT",NULL},
/* 1A49 */ { "LETTRE TAÏ-THAM HA HAUT",NULL},
/* 1A4A */ { "LETTRE TAÏ-THAM LLA",NULL},
/* 1A4B */ { "LETTRE TAÏ-THAM A","	* indique une consonne glottale"},
/* 1A4C */ { "LETTRE TAÏ-THAM HA BAS",NULL},
/* 1A4D */ { "LETTRE TAÏ-THAM I",NULL},
/* 1A4E */ { "LETTRE TAÏ-THAM II",NULL},
/* 1A4F */ { "LETTRE TAÏ-THAM U",NULL},
/* 1A50 */ { "LETTRE TAÏ-THAM UU",NULL},
/* 1A51 */ { "LETTRE TAÏ-THAM EE",NULL},
/* 1A52 */ { "LETTRE TAÏ-THAM OO",NULL},
/* 1A53 */ { "LETTRE TAÏ-THAM LAE",NULL},
/* 1A54 */ { "LETTRE TAÏ-THAM GRAND SA",NULL},
/* 1A55 */ { "DIACRITIQUE CONSONNE TAÏ-THAM RA MÉDIAL",NULL},
/* 1A56 */ { "DIACRITIQUE CONSONNE TAÏ-THAM LA MÉDIAL",NULL},
/* 1A57 */ { "DIACRITIQUE CONSONNE TAÏ-THAM LA TANG LAI",NULL},
/* 1A58 */ { "DIACRITIQUE TAÏ-THAM MAI KANG LAI",NULL},
/* 1A59 */ { "DIACRITIQUE CONSONNE TAÏ-THAM NGA FINAL",NULL},
/* 1A5A */ { "DIACRITIQUE CONSONNE TAÏ-THAM PA BAS",NULL},
/* 1A5B */ { "DIACRITIQUE CONSONNE TAÏ-THAM RATHA HAUT OU PA BAS",NULL},
/* 1A5C */ { "DIACRITIQUE CONSONNE TAÏ-THAM MA",NULL},
/* 1A5D */ { "DIACRITIQUE CONSONNE TAÏ-THAM BA",NULL},
/* 1A5E */ { "DIACRITIQUE CONSONNE TAÏ-THAM SA",NULL},
/* 1A5F */ { NULL,NULL},
/* 1A60 */ { "DIACRITIQUE TAÏ-THAM SAKOT",NULL},
/* 1A61 */ { "DIACRITIQUE VOYELLE TAÏ-THAM A",NULL},
/* 1A62 */ { "DIACRITIQUE VOYELLE TAÏ-THAM MAI SAT",NULL},
/* 1A63 */ { "DIACRITIQUE VOYELLE TAÏ-THAM AA",NULL},
/* 1A64 */ { "DIACRITIQUE VOYELLE TAÏ-THAM GRAND AA",NULL},
/* 1A65 */ { "DIACRITIQUE VOYELLE TAÏ-THAM I",NULL},
/* 1A66 */ { "DIACRITIQUE VOYELLE TAÏ-THAM II",NULL},
/* 1A67 */ { "DIACRITIQUE VOYELLE TAÏ-THAM UE",NULL},
/* 1A68 */ { "DIACRITIQUE VOYELLE TAÏ-THAM UUE",NULL},
/* 1A69 */ { "DIACRITIQUE VOYELLE TAÏ-THAM U",NULL},
/* 1A6A */ { "DIACRITIQUE VOYELLE TAÏ-THAM UU",NULL},
/* 1A6B */ { "DIACRITIQUE VOYELLE TAÏ-THAM O",NULL},
/* 1A6C */ { "DIACRITIQUE VOYELLE TAÏ-THAM OA SOUSCRIT",NULL},
/* 1A6D */ { "DIACRITIQUE VOYELLE TAÏ-THAM OY",NULL},
/* 1A6E */ { "DIACRITIQUE VOYELLE TAÏ-THAM E",NULL},
/* 1A6F */ { "DIACRITIQUE VOYELLE TAÏ-THAM AE",NULL},
/* 1A70 */ { "DIACRITIQUE VOYELLE TAÏ-THAM OO",NULL},
/* 1A71 */ { "DIACRITIQUE VOYELLE TAÏ-THAM AI",NULL},
/* 1A72 */ { "DIACRITIQUE VOYELLE TAÏ-THAM THAM AI",NULL},
/* 1A73 */ { "DIACRITIQUE VOYELLE TAÏ-THAM OA SUSCRIT",NULL},
/* 1A74 */ { "DIACRITIQUE TAÏ-THAM MAI KANG",NULL},
/* 1A75 */ { "DIACRITIQUE TAÏ-THAM TON-1",NULL},
/* 1A76 */ { "DIACRITIQUE TAÏ-THAM TON-2",NULL},
/* 1A77 */ { "DIACRITIQUE TAÏ-THAM KHÜN TON-3",NULL},
/* 1A78 */ { "DIACRITIQUE TAÏ-THAM KHÜN TON-4",NULL},
/* 1A79 */ { "DIACRITIQUE TAÏ-THAM KHÜN TON-5",NULL},
/* 1A7A */ { "DIACRITIQUE TAÏ-THAM RA HAAM",NULL},
/* 1A7B */ { "DIACRITIQUE TAÏ-THAM MAI SAM",NULL},
/* 1A7C */ { "DIACRITIQUE TAÏ-THAM KHÜN-LÜ KARAN",NULL},
/* 1A7D */ { NULL,NULL},
/* 1A7E */ { NULL,NULL},
/* 1A7F */ { "DIACRITIQUE TAÏ-THAM POINT CRYPTOGRAPHIQUE",NULL},
/* 1A80 */ { "CHIFFRE TAÏ-THAM HORA ZÉRO",NULL},
/* 1A81 */ { "CHIFFRE TAÏ-THAM HORA UN",NULL},
/* 1A82 */ { "CHIFFRE TAÏ-THAM HORA DEUX",NULL},
/* 1A83 */ { "CHIFFRE TAÏ-THAM HORA TROIS",NULL},
/* 1A84 */ { "CHIFFRE TAÏ-THAM HORA QUATRE",NULL},
/* 1A85 */ { "CHIFFRE TAÏ-THAM HORA CINQ",NULL},
/* 1A86 */ { "CHIFFRE TAÏ-THAM HORA SIX",NULL},
/* 1A87 */ { "CHIFFRE TAÏ-THAM HORA SEPT",NULL},
/* 1A88 */ { "CHIFFRE TAÏ-THAM HORA HUIT",NULL},
/* 1A89 */ { "CHIFFRE TAÏ-THAM HORA NEUF",NULL},
/* 1A8A */ { NULL,NULL},
/* 1A8B */ { NULL,NULL},
/* 1A8C */ { NULL,NULL},
/* 1A8D */ { NULL,NULL},
/* 1A8E */ { NULL,NULL},
/* 1A8F */ { NULL,NULL},
/* 1A90 */ { "CHIFFRE TAÏ-THAM THAM ZÉRO",NULL},
/* 1A91 */ { "CHIFFRE TAÏ-THAM THAM UN",NULL},
/* 1A92 */ { "CHIFFRE TAÏ-THAM THAM DEUX",NULL},
/* 1A93 */ { "CHIFFRE TAÏ-THAM THAM TROIS",NULL},
/* 1A94 */ { "CHIFFRE TAÏ-THAM THAM QUATRE",NULL},
/* 1A95 */ { "CHIFFRE TAÏ-THAM THAM CINQ",NULL},
/* 1A96 */ { "CHIFFRE TAÏ-THAM THAM SIX",NULL},
/* 1A97 */ { "CHIFFRE TAÏ-THAM THAM SEPT",NULL},
/* 1A98 */ { "CHIFFRE TAÏ-THAM THAM HUIT",NULL},
/* 1A99 */ { "CHIFFRE TAÏ-THAM THAM NEUF",NULL},
/* 1A9A */ { NULL,NULL},
/* 1A9B */ { NULL,NULL},
/* 1A9C */ { NULL,NULL},
/* 1A9D */ { NULL,NULL},
/* 1A9E */ { NULL,NULL},
/* 1A9F */ { NULL,NULL},
/* 1AA0 */ { "SIGNE TAÏ-THAM WIANG","	* logogramme pour ville"},
/* 1AA1 */ { "SIGNE TAÏ-THAM WIANGWAAK","	* logogramme pour village"},
/* 1AA2 */ { "SIGNE TAÏ-THAM SAWAN","	* logogramme pour le ciel"},
/* 1AA3 */ { "SIGNE TAÏ-THAM KEOW","	= cour"},
/* 1AA4 */ { "SIGNE TAÏ-THAM HOY","	= huître"},
/* 1AA5 */ { "SIGNE TAÏ-THAM DOKMAI","	= fleur\n"
	"	x (point-fleur - 2055)"},
/* 1AA6 */ { "SIGNE TAÏ-THAM RANA COUCHÉ RÉFLÉCHI",NULL},
/* 1AA7 */ { "SIGNE TAÏ-THAM MAÏ YAMOK","	x (caractère thaï maïyamok - 0E46)"},
/* 1AA8 */ { "SIGNE TAÏ-THAM KAAN","	* danda"},
/* 1AA9 */ { "SIGNE TAÏ-THAM KAANKUU","	* double danda"},
/* 1AAA */ { "SIGNE TAÏ-THAM SATKAAN",NULL},
/* 1AAB */ { "SIGNE TAÏ-THAM SATKAANKUU","	x (caractère thaï angkhankhou - 0E5A)"},
/* 1AAC */ { "SIGNE TAÏ-THAM HANG","	* s'utilise en combinaison avec d'autres signes de ponctuation à la fin des sections"},
/* 1AAD */ { "SIGNE TAÏ-THAM CAANG",NULL},
/* 1AAE */ { NULL,NULL},
/* 1AAF */ { NULL,NULL},
/* 1AB0 */ { "DIACRITIQUE DOUBLE ACCENT CIRCONFLEXE",NULL},
/* 1AB1 */ { "DIACRITIQUE TRÉMA-ROND",NULL},
/* 1AB2 */ { "DIACRITIQUE INFINI",NULL},
/* 1AB3 */ { "DIACRITIQUE FLÈCHE VERS LE BAS",NULL},
/* 1AB4 */ { "DIACRITIQUE TRIPLE POINT",NULL},
/* 1AB5 */ { "DIACRITIQUE DEUX X SOUSCRITS",NULL},
/* 1AB6 */ { "DIACRITIQUE LIGNE ONDULÉE SOUSCRITE",NULL},
/* 1AB7 */ { "DIACRITIQUE OUVERTURE SOUSCRITE","	x (diacritique ogonek - 0328)\n"
	"	x (diacritique grec iota souscrit - 0345)"},
/* 1AB8 */ { "DIACRITIQUE DOUBLE OUVERTURE SOUSCRITE",NULL},
/* 1AB9 */ { "DIACRITIQUE TRAIT DE CENTRALISATION LÉGER SOUSCRIT",NULL},
/* 1ABA */ { "DIACRITIQUE TRAIT DE CENTRALISATION FORT SOUSCRIT",NULL},
/* 1ABB */ { "DIACRITIQUE PARENTHÈSES SUSCRITES","	* destiné à encadrer un diacritique suscrit"},
/* 1ABC */ { "DIACRITIQUE DOUBLES PARENTHÈSES SUSCRITES",NULL},
/* 1ABD */ { "DIACRITIQUE PARENTHÈSES SOUSCRITES","	* destiné à encadrer un diacritique souscrit"},
/* 1ABE */ { "DIACRITIQUE PARENTHÈSES COUVRANTES","	* destiné à encadrer une lettre de base\n"
	"	* le placement exact dépend de la police"},
/* 1ABF */ { NULL,NULL},
/* 1AC0 */ { NULL,NULL},
/* 1AC1 */ { NULL,NULL},
/* 1AC2 */ { NULL,NULL},
/* 1AC3 */ { NULL,NULL},
/* 1AC4 */ { NULL,NULL},
/* 1AC5 */ { NULL,NULL},
/* 1AC6 */ { NULL,NULL},
/* 1AC7 */ { NULL,NULL},
/* 1AC8 */ { NULL,NULL},
/* 1AC9 */ { NULL,NULL},
/* 1ACA */ { NULL,NULL},
/* 1ACB */ { NULL,NULL},
/* 1ACC */ { NULL,NULL},
/* 1ACD */ { NULL,NULL},
/* 1ACE */ { NULL,NULL},
/* 1ACF */ { NULL,NULL},
/* 1AD0 */ { NULL,NULL},
/* 1AD1 */ { NULL,NULL},
/* 1AD2 */ { NULL,NULL},
/* 1AD3 */ { NULL,NULL},
/* 1AD4 */ { NULL,NULL},
/* 1AD5 */ { NULL,NULL},
/* 1AD6 */ { NULL,NULL},
/* 1AD7 */ { NULL,NULL},
/* 1AD8 */ { NULL,NULL},
/* 1AD9 */ { NULL,NULL},
/* 1ADA */ { NULL,NULL},
/* 1ADB */ { NULL,NULL},
/* 1ADC */ { NULL,NULL},
/* 1ADD */ { NULL,NULL},
/* 1ADE */ { NULL,NULL},
/* 1ADF */ { NULL,NULL},
/* 1AE0 */ { NULL,NULL},
/* 1AE1 */ { NULL,NULL},
/* 1AE2 */ { NULL,NULL},
/* 1AE3 */ { NULL,NULL},
/* 1AE4 */ { NULL,NULL},
/* 1AE5 */ { NULL,NULL},
/* 1AE6 */ { NULL,NULL},
/* 1AE7 */ { NULL,NULL},
/* 1AE8 */ { NULL,NULL},
/* 1AE9 */ { NULL,NULL},
/* 1AEA */ { NULL,NULL},
/* 1AEB */ { NULL,NULL},
/* 1AEC */ { NULL,NULL},
/* 1AED */ { NULL,NULL},
/* 1AEE */ { NULL,NULL},
/* 1AEF */ { NULL,NULL},
/* 1AF0 */ { NULL,NULL},
/* 1AF1 */ { NULL,NULL},
/* 1AF2 */ { NULL,NULL},
/* 1AF3 */ { NULL,NULL},
/* 1AF4 */ { NULL,NULL},
/* 1AF5 */ { NULL,NULL},
/* 1AF6 */ { NULL,NULL},
/* 1AF7 */ { NULL,NULL},
/* 1AF8 */ { NULL,NULL},
/* 1AF9 */ { NULL,NULL},
/* 1AFA */ { NULL,NULL},
/* 1AFB */ { NULL,NULL},
/* 1AFC */ { NULL,NULL},
/* 1AFD */ { NULL,NULL},
/* 1AFE */ { NULL,NULL},
/* 1AFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_1B[] = {
/* 1B00 */ { "DIACRITIQUE BALINAIS ULU RICEM","	= ardhatchandra"},
/* 1B01 */ { "DIACRITIQUE BALINAIS ULU CANDRA","	= tchandrabindou"},
/* 1B02 */ { "DIACRITIQUE BALINAIS CECEK","	= anousvâra"},
/* 1B03 */ { "DIACRITIQUE BALINAIS SURANG","	= repha"},
/* 1B04 */ { "DIACRITIQUE BALINAIS BISAH","	= visarga"},
/* 1B05 */ { "LETTRE BALINAISE AKARA","	= a"},
/* 1B06 */ { "LETTRE BALINAISE AKARA TEDUNG","	= â\n"
	"	: 1B05 1B35"},
/* 1B07 */ { "LETTRE BALINAISE IKARA","	= i"},
/* 1B08 */ { "LETTRE BALINAISE IKARA TEDUNG","	= î\n"
	"	: 1B07 1B35"},
/* 1B09 */ { "LETTRE BALINAISE UKARA","	= ou"},
/* 1B0A */ { "LETTRE BALINAISE UKARA TEDUNG","	= oû\n"
	"	: 1B09 1B35"},
/* 1B0B */ { "LETTRE BALINAISE RA REPA","	= r vocalique"},
/* 1B0C */ { "LETTRE BALINAISE RA REPA TEDUNG","	= rr vocalique\n"
	"	: 1B0B 1B35"},
/* 1B0D */ { "LETTRE BALINAISE LA LENGA","	= l vocalique"},
/* 1B0E */ { "LETTRE BALINAISE LA LENGA TEDUNG","	= ll vocalique\n"
	"	: 1B0D 1B35"},
/* 1B0F */ { "LETTRE BALINAISE EKARA","	= é"},
/* 1B10 */ { "LETTRE BALINAISE AIKARA","	= aï"},
/* 1B11 */ { "LETTRE BALINAISE OKARA","	= o"},
/* 1B12 */ { "LETTRE BALINAISE OKARA TEDUNG","	= aou\n"
	"	: 1B11 1B35"},
/* 1B13 */ { "LETTRE BALINAISE KA",NULL},
/* 1B14 */ { "LETTRE BALINAISE KA MAHAPRANA","	= kha"},
/* 1B15 */ { "LETTRE BALINAISE GA",NULL},
/* 1B16 */ { "LETTRE BALINAISE GA GORA","	= gha"},
/* 1B17 */ { "LETTRE BALINAISE NGA",NULL},
/* 1B18 */ { "LETTRE BALINAISE CA",NULL},
/* 1B19 */ { "LETTRE BALINAISE CA LACA","	= tcha"},
/* 1B1A */ { "LETTRE BALINAISE JA",NULL},
/* 1B1B */ { "LETTRE BALINAISE JA JERA","	= dja"},
/* 1B1C */ { "LETTRE BALINAISE ÑA",NULL},
/* 1B1D */ { "LETTRE BALINAISE TA LATIK","	= tta"},
/* 1B1E */ { "LETTRE BALINAISE TA MURDA MAHAPRANA","	= ttha"},
/* 1B1F */ { "LETTRE BALINAISE DA MURDA ALPAPRANA","	= dda"},
/* 1B20 */ { "LETTRE BALINAISE DA MURDA MAHAPRANA","	= ddha"},
/* 1B21 */ { "LETTRE BALINAISE NA RAMBAT","	= nna"},
/* 1B22 */ { "LETTRE BALINAISE TA",NULL},
/* 1B23 */ { "LETTRE BALINAISE TA TAWA","	= tha"},
/* 1B24 */ { "LETTRE BALINAISE DA",NULL},
/* 1B25 */ { "LETTRE BALINAISE DA MADU","	= dha"},
/* 1B26 */ { "LETTRE BALINAISE NA",NULL},
/* 1B27 */ { "LETTRE BALINAISE PA",NULL},
/* 1B28 */ { "LETTRE BALINAISE PA KAPAL","	= pha"},
/* 1B29 */ { "LETTRE BALINAISE BA",NULL},
/* 1B2A */ { "LETTRE BALINAISE BA KEMBANG","	= bha"},
/* 1B2B */ { "LETTRE BALINAISE MA",NULL},
/* 1B2C */ { "LETTRE BALINAISE YA",NULL},
/* 1B2D */ { "LETTRE BALINAISE RA",NULL},
/* 1B2E */ { "LETTRE BALINAISE LA",NULL},
/* 1B2F */ { "LETTRE BALINAISE WA",NULL},
/* 1B30 */ { "LETTRE BALINAISE SA SAGA","	= cha"},
/* 1B31 */ { "LETTRE BALINAISE SA SAPA","	= ssa"},
/* 1B32 */ { "LETTRE BALINAISE SA",NULL},
/* 1B33 */ { "LETTRE BALINAISE HA",NULL},
/* 1B34 */ { "DIACRITIQUE BALINAIS REREKAN","	= noukta"},
/* 1B35 */ { "DIACRITIQUE VOYELLE BALINAISE TEDUNG","	= â"},
/* 1B36 */ { "DIACRITIQUE VOYELLE BALINAISE ULU","	= i"},
/* 1B37 */ { "DIACRITIQUE VOYELLE BALINAISE ULU SARI","	= î"},
/* 1B38 */ { "DIACRITIQUE VOYELLE BALINAISE SUKU","	= ou"},
/* 1B39 */ { "DIACRITIQUE VOYELLE BALINAISE SUKU ILUT","	= oû"},
/* 1B3A */ { "DIACRITIQUE VOYELLE BALINAISE RA REPA","	= r vocalique"},
/* 1B3B */ { "DIACRITIQUE VOYELLE BALINAISE RA REPA TEDUNG","	= rr vocalique\n"
	"	: 1B3A 1B35"},
/* 1B3C */ { "DIACRITIQUE VOYELLE BALINAISE LA LENGA","	= l vocalique"},
/* 1B3D */ { "DIACRITIQUE VOYELLE BALINAISE LA LENGA TEDUNG","	= ll vocalique\n"
	"	: 1B3C 1B35"},
/* 1B3E */ { "DIACRITIQUE VOYELLE BALINAISE TALING","	= é"},
/* 1B3F */ { "DIACRITIQUE VOYELLE BALINAISE TALING REPA","	= aï"},
/* 1B40 */ { "DIACRITIQUE VOYELLE BALINAISE TALING TEDUNG","	= o\n"
	"	: 1B3E 1B35"},
/* 1B41 */ { "DIACRITIQUE VOYELLE BALINAISE TALING REPA TEDUNG","	= aou\n"
	"	: 1B3F 1B35"},
/* 1B42 */ { "DIACRITIQUE VOYELLE BALINAISE PEPET","	= aé"},
/* 1B43 */ { "DIACRITIQUE VOYELLE BALINAISE PEPET TEDUNG","	= oé\n"
	"	: 1B42 1B35"},
/* 1B44 */ { "ADEG ADEG BALINAIS","	= virâma"},
/* 1B45 */ { "LETTRE BALINAISE KAF SASAK",NULL},
/* 1B46 */ { "LETTRE BALINAISE KHOT SASAK",NULL},
/* 1B47 */ { "LETTRE BALINAISE TZIR SASAK",NULL},
/* 1B48 */ { "LETTRE BALINAISE EF SASAK",NULL},
/* 1B49 */ { "LETTRE BALINAISE VE SASAK",NULL},
/* 1B4A */ { "LETTRE BALINAISE ZAL SASAK",NULL},
/* 1B4B */ { "LETTRE BALINAISE ASYURA SASAK",NULL},
/* 1B4C */ { NULL,NULL},
/* 1B4D */ { NULL,NULL},
/* 1B4E */ { NULL,NULL},
/* 1B4F */ { NULL,NULL},
/* 1B50 */ { "CHIFFRE BALINAIS ZÉRO",NULL},
/* 1B51 */ { "CHIFFRE BALINAIS UN",NULL},
/* 1B52 */ { "CHIFFRE BALINAIS DEUX",NULL},
/* 1B53 */ { "CHIFFRE BALINAIS TROIS",NULL},
/* 1B54 */ { "CHIFFRE BALINAIS QUATRE",NULL},
/* 1B55 */ { "CHIFFRE BALINAIS CINQ",NULL},
/* 1B56 */ { "CHIFFRE BALINAIS SIX",NULL},
/* 1B57 */ { "CHIFFRE BALINAIS SEPT",NULL},
/* 1B58 */ { "CHIFFRE BALINAIS HUIT",NULL},
/* 1B59 */ { "CHIFFRE BALINAIS NEUF",NULL},
/* 1B5A */ { "PANTI BALINAIS","	= section"},
/* 1B5B */ { "PAMADA BALINAIS","	= section honorifique"},
/* 1B5C */ { "WINDU BALINAIS","	= cercle de ponctuation"},
/* 1B5D */ { "CARIK PAMUNGKAH BALINAIS","	= deux-points"},
/* 1B5E */ { "CARIK SIKI BALINAIS","	= danda\n"
	"	x (danda dévanâgarî - 0964)"},
/* 1B5F */ { "CARIK PAREREN BALINAIS","	= double danda\n"
	"	x (double danda dévanâgarî - 0965)"},
/* 1B60 */ { "PAMENENG BALINAIS","	= trait de coupure de ligne, division"},
/* 1B61 */ { "SYMBOLE MUSICAL BALINAIS DONG",NULL},
/* 1B62 */ { "SYMBOLE MUSICAL BALINAIS DENG",NULL},
/* 1B63 */ { "SYMBOLE MUSICAL BALINAIS DUNG",NULL},
/* 1B64 */ { "SYMBOLE MUSICAL BALINAIS DANG",NULL},
/* 1B65 */ { "SYMBOLE MUSICAL BALINAIS DANG SURANG",NULL},
/* 1B66 */ { "SYMBOLE MUSICAL BALINAIS DING",NULL},
/* 1B67 */ { "SYMBOLE MUSICAL BALINAIS DAENG",NULL},
/* 1B68 */ { "SYMBOLE MUSICAL BALINAIS DEUNG",NULL},
/* 1B69 */ { "SYMBOLE MUSICAL BALINAIS DAING",NULL},
/* 1B6A */ { "SYMBOLE MUSICAL BALINAIS DANG GEDE",NULL},
/* 1B6B */ { "DIACRITIQUE MUSICAL BALINAIS TEGEH",NULL},
/* 1B6C */ { "DIACRITIQUE MUSICAL BALINAIS ENDEP",NULL},
/* 1B6D */ { "DIACRITIQUE MUSICAL BALINAIS KEMPUL",NULL},
/* 1B6E */ { "DIACRITIQUE MUSICAL BALINAIS KEMPLI",NULL},
/* 1B6F */ { "DIACRITIQUE MUSICAL BALINAIS JEGOGAN",NULL},
/* 1B70 */ { "DIACRITIQUE MUSICAL BALINAIS KEMPUL AVEC JEGOGAN",NULL},
/* 1B71 */ { "DIACRITIQUE MUSICAL BALINAIS KEMPLI AVEC JEGOGAN",NULL},
/* 1B72 */ { "DIACRITIQUE MUSICAL BALINAIS BENDE",NULL},
/* 1B73 */ { "DIACRITIQUE MUSICAL BALINAIS GONG",NULL},
/* 1B74 */ { "SYMBOLE MUSICAL BALINAIS DUG MAIN DROITE OUVERTE",NULL},
/* 1B75 */ { "SYMBOLE MUSICAL BALINAIS DAG MAIN DROITE OUVERTE",NULL},
/* 1B76 */ { "SYMBOLE MUSICAL BALINAIS TUK MAIN DROITE FERMÉE",NULL},
/* 1B77 */ { "SYMBOLE MUSICAL BALINAIS TAK MAIN DROITE FERMÉE",NULL},
/* 1B78 */ { "SYMBOLE MUSICAL BALINAIS PANG MAIN GAUCHE OUVERTE",NULL},
/* 1B79 */ { "SYMBOLE MUSICAL BALINAIS PUNG MAIN GAUCHE OUVERTE",NULL},
/* 1B7A */ { "SYMBOLE MUSICAL BALINAIS PLAK MAIN GAUCHE FERMÉE",NULL},
/* 1B7B */ { "SYMBOLE MUSICAL BALINAIS PLUK MAIN GAUCHE FERMÉE",NULL},
/* 1B7C */ { "SYMBOLE MUSICAL BALINAIS PING MAIN GAUCHE OUVERTE",NULL},
/* 1B7D */ { NULL,NULL},
/* 1B7E */ { NULL,NULL},
/* 1B7F */ { NULL,NULL},
/* 1B80 */ { "DIACRITIQUE SOUNDANAIS PANYECEK","	= anousvâra"},
/* 1B81 */ { "DIACRITIQUE SOUNDANAIS PANGLAYAR","	= repha"},
/* 1B82 */ { "DIACRITIQUE SOUNDANAIS PANGWISAD","	= visarga"},
/* 1B83 */ { "LETTRE SOUNDANAISE A",NULL},
/* 1B84 */ { "LETTRE SOUNDANAISE I",NULL},
/* 1B85 */ { "LETTRE SOUNDANAISE OU",NULL},
/* 1B86 */ { "LETTRE SOUNDANAISE AE",NULL},
/* 1B87 */ { "LETTRE SOUNDANAISE O",NULL},
/* 1B88 */ { "LETTRE SOUNDANAISE É",NULL},
/* 1B89 */ { "LETTRE SOUNDANAISE EU",NULL},
/* 1B8A */ { "LETTRE SOUNDANAISE KA",NULL},
/* 1B8B */ { "LETTRE SOUNDANAISE QA",NULL},
/* 1B8C */ { "LETTRE SOUNDANAISE GA",NULL},
/* 1B8D */ { "LETTRE SOUNDANAISE NGA",NULL},
/* 1B8E */ { "LETTRE SOUNDANAISE TCHA",NULL},
/* 1B8F */ { "LETTRE SOUNDANAISE DJA",NULL},
/* 1B90 */ { "LETTRE SOUNDANAISE ZA",NULL},
/* 1B91 */ { "LETTRE SOUNDANAISE ÑA",NULL},
/* 1B92 */ { "LETTRE SOUNDANAISE TA",NULL},
/* 1B93 */ { "LETTRE SOUNDANAISE DA",NULL},
/* 1B94 */ { "LETTRE SOUNDANAISE NA",NULL},
/* 1B95 */ { "LETTRE SOUNDANAISE PA",NULL},
/* 1B96 */ { "LETTRE SOUNDANAISE FA",NULL},
/* 1B97 */ { "LETTRE SOUNDANAISE VA",NULL},
/* 1B98 */ { "LETTRE SOUNDANAISE BA",NULL},
/* 1B99 */ { "LETTRE SOUNDANAISE MA",NULL},
/* 1B9A */ { "LETTRE SOUNDANAISE YA",NULL},
/* 1B9B */ { "LETTRE SOUNDANAISE RA",NULL},
/* 1B9C */ { "LETTRE SOUNDANAISE LA",NULL},
/* 1B9D */ { "LETTRE SOUNDANAISE WA",NULL},
/* 1B9E */ { "LETTRE SOUNDANAISE SA",NULL},
/* 1B9F */ { "LETTRE SOUNDANAISE XA",NULL},
/* 1BA0 */ { "LETTRE SOUNDANAISE HA",NULL},
/* 1BA1 */ { "DIACRITIQUE CONSONNE SOUNDANAISE PAMINGKAL","	= ya subjoint"},
/* 1BA2 */ { "DIACRITIQUE CONSONNE SOUNDANAISE PANYAKRA","	= ra subjoint"},
/* 1BA3 */ { "DIACRITIQUE CONSONNE SOUNDANAISE PANYIKU","	= la subjoint"},
/* 1BA4 */ { "DIACRITIQUE VOYELLE SOUNDANAISE PANGHULU","	= i"},
/* 1BA5 */ { "DIACRITIQUE VOYELLE SOUNDANAISE PANYUKU","	= u"},
/* 1BA6 */ { "DIACRITIQUE VOYELLE SOUNDANAISE PANAELAENG","	= ae"},
/* 1BA7 */ { "DIACRITIQUE VOYELLE SOUNDANAISE PANOLONG","	= o"},
/* 1BA8 */ { "DIACRITIQUE VOYELLE SOUNDANAISE PAMEPET","	= e"},
/* 1BA9 */ { "DIACRITIQUE VOYELLE SOUNDANAISE PANEULEUNG","	= eu"},
/* 1BAA */ { "DIACRITIQUE SOUNDANAIS PAMÂEH","	* ne forme pas de ligatures"},
/* 1BAB */ { "DIACRITIQUE SOUNDANAIS VIRÂMA","	* forme des ligatures dans une orthographe ancienne"},
/* 1BAC */ { "DIACRITIQUE CONSONNE SOUNDANAISE PASANGAN MA","	= ma subjoint"},
/* 1BAD */ { "DIACRITIQUE CONSONNE SOUNDANAISE PASANGAN WA","	= wa subjoint"},
/* 1BAE */ { "LETTRE SOUNDANAISE KHA",NULL},
/* 1BAF */ { "LETTRE SOUNDANAISE SYA",NULL},
/* 1BB0 */ { "CHIFFRE SOUNDANAIS ZÉRO",NULL},
/* 1BB1 */ { "CHIFFRE SOUNDANAIS UN",NULL},
/* 1BB2 */ { "CHIFFRE SOUNDANAIS DEUX",NULL},
/* 1BB3 */ { "CHIFFRE SOUNDANAIS TROIS",NULL},
/* 1BB4 */ { "CHIFFRE SOUNDANAIS QUATRE",NULL},
/* 1BB5 */ { "CHIFFRE SOUNDANAIS CINQ",NULL},
/* 1BB6 */ { "CHIFFRE SOUNDANAIS SIX",NULL},
/* 1BB7 */ { "CHIFFRE SOUNDANAIS SEPT",NULL},
/* 1BB8 */ { "CHIFFRE SOUNDANAIS HUIT",NULL},
/* 1BB9 */ { "CHIFFRE SOUNDANAIS NEUF",NULL},
/* 1BBA */ { "AVAGRAHA SOUNDANAIS",NULL},
/* 1BBB */ { "LETTRE SOUNDANAISE REU","	* r vocalique"},
/* 1BBC */ { "LETTRE SOUNDANAISE LEU","	* l vocalique"},
/* 1BBD */ { "LETTRE SOUNDANAISE BHA",NULL},
/* 1BBE */ { "LETTRE SOUNDANAISE K FINAL",NULL},
/* 1BBF */ { "LETTRE SOUNDANAISE M FINAL",NULL},
/* 1BC0 */ { "LETTRE BATAK A","	* lettre a ou ha pour le karo et le pakpak"},
/* 1BC1 */ { "LETTRE BATAK SIMALUNGUN A",NULL},
/* 1BC2 */ { "LETTRE BATAK HA","	* lettre toba ha ou ka\n"
	"	* désigne aussi la lettre ka pour le karo et le pakpak"},
/* 1BC3 */ { "LETTRE BATAK SIMALUNGUN HA","	* désigne aussi la lettre simalungun ka"},
/* 1BC4 */ { "LETTRE BATAK MANDAILING HA",NULL},
/* 1BC5 */ { "LETTRE BATAK BA",NULL},
/* 1BC6 */ { "LETTRE BATAK KARO BA",NULL},
/* 1BC7 */ { "LETTRE BATAK PA",NULL},
/* 1BC8 */ { "LETTRE BATAK SIMALUNGUN PA",NULL},
/* 1BC9 */ { "LETTRE BATAK NA",NULL},
/* 1BCA */ { "LETTRE BATAK MANDAILING NA",NULL},
/* 1BCB */ { "LETTRE BATAK WA","	* la lettre toba wa peut être représentée soit par 1BCB, soit par 1BCD"},
/* 1BCC */ { "LETTRE BATAK SIMALUNGUN WA",NULL},
/* 1BCD */ { "LETTRE BATAK PAKPAK WA",NULL},
/* 1BCE */ { "LETTRE BATAK GA",NULL},
/* 1BCF */ { "LETTRE BATAK SIMALUNGUN GA",NULL},
/* 1BD0 */ { "LETTRE BATAK JA",NULL},
/* 1BD1 */ { "LETTRE BATAK DA",NULL},
/* 1BD2 */ { "LETTRE BATAK RA",NULL},
/* 1BD3 */ { "LETTRE BATAK SIMALUNGUN RA",NULL},
/* 1BD4 */ { "LETTRE BATAK MA",NULL},
/* 1BD5 */ { "LETTRE BATAK SIMALUNGUN MA",NULL},
/* 1BD6 */ { "LETTRE BATAK TA DU SUD","	* la lettre toba ta peut être représentée soit par 1BD6, soit par 1BD7"},
/* 1BD7 */ { "LETTRE BATAK TA DU NORD",NULL},
/* 1BD8 */ { "LETTRE BATAK SA","	* lettre pakpak sa ou ca"},
/* 1BD9 */ { "LETTRE BATAK SIMALUNGUN SA",NULL},
/* 1BDA */ { "LETTRE BATAK MANDAILING SA",NULL},
/* 1BDB */ { "LETTRE BATAK YA",NULL},
/* 1BDC */ { "LETTRE BATAK SIMALUNGUN YA",NULL},
/* 1BDD */ { "LETTRE BATAK NGA",NULL},
/* 1BDE */ { "LETTRE BATAK LA",NULL},
/* 1BDF */ { "LETTRE BATAK SIMALUNGUN LA",NULL},
/* 1BE0 */ { "LETTRE BATAK ÑA","	* la lettre karo ca peut être représentée soit par 1BE0, soit par 1BE1"},
/* 1BE1 */ { "LETTRE BATAK CA",NULL},
/* 1BE2 */ { "LETTRE BATAK NDA",NULL},
/* 1BE3 */ { "LETTRE BATAK MBA",NULL},
/* 1BE4 */ { "LETTRE BATAK I",NULL},
/* 1BE5 */ { "LETTRE BATAK U",NULL},
/* 1BE6 */ { "DIACRITIQUE BATAK TOMPI",NULL},
/* 1BE7 */ { "DIACRITIQUE VOYELLE BATAK E","	= kebereten"},
/* 1BE8 */ { "DIACRITIQUE VOYELLE BATAK PAKPAK E","	= ketolongen"},
/* 1BE9 */ { "DIACRITIQUE VOYELLE BATAK EE","	= talinga"},
/* 1BEA */ { "DIACRITIQUE VOYELLE BATAK I","	= ulua"},
/* 1BEB */ { "DIACRITIQUE VOYELLE BATAK KARO I","	= haluan"},
/* 1BEC */ { "DIACRITIQUE VOYELLE BATAK O","	= siala ulu"},
/* 1BED */ { "DIACRITIQUE VOYELLE BATAK KARO O","	= hatulungan"},
/* 1BEE */ { "DIACRITIQUE VOYELLE BATAK U","	= boruta"},
/* 1BEF */ { "DIACRITIQUE VOYELLE BATAK U POUR SIMALUNGUN SA","	= haboritan pour sa simalungun"},
/* 1BF0 */ { "DIACRITIQUE CONSONNE BATAK NG","	= amisara"},
/* 1BF1 */ { "DIACRITIQUE CONSONNE BATAK H","	= hajoringan"},
/* 1BF2 */ { "PANGOLAT BATAK","	= virâma\n"
	"	* ne peut pas suivre un signe voyelle"},
/* 1BF3 */ { "PANONGONAN BATAK","	= virâma"},
/* 1BF4 */ { NULL,NULL},
/* 1BF5 */ { NULL,NULL},
/* 1BF6 */ { NULL,NULL},
/* 1BF7 */ { NULL,NULL},
/* 1BF8 */ { NULL,NULL},
/* 1BF9 */ { NULL,NULL},
/* 1BFA */ { NULL,NULL},
/* 1BFB */ { NULL,NULL},
/* 1BFC */ { "SYMBOLE BATAK BINDOU NA METEK",NULL},
/* 1BFD */ { "SYMBOLE BATAK BINDOU PINARBORAS",NULL},
/* 1BFE */ { "SYMBOLE BATAK BINDOU JUDUL",NULL},
/* 1BFF */ { "SYMBOLE BATAK BINDOU PANGOLAT",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_1C[] = {
/* 1C00 */ { "LETTRE LEPTCHA KA",NULL},
/* 1C01 */ { "LETTRE LEPTCHA KLA",NULL},
/* 1C02 */ { "LETTRE LEPTCHA KHA",NULL},
/* 1C03 */ { "LETTRE LEPTCHA GA",NULL},
/* 1C04 */ { "LETTRE LEPTCHA GLA",NULL},
/* 1C05 */ { "LETTRE LEPTCHA NGA",NULL},
/* 1C06 */ { "LETTRE LEPTCHA TCHA",NULL},
/* 1C07 */ { "LETTRE LEPTCHA TCHHA",NULL},
/* 1C08 */ { "LETTRE LEPTCHA DJA",NULL},
/* 1C09 */ { "LETTRE LEPTCHA ÑA",NULL},
/* 1C0A */ { "LETTRE LEPTCHA TA",NULL},
/* 1C0B */ { "LETTRE LEPTCHA THA",NULL},
/* 1C0C */ { "LETTRE LEPTCHA DA",NULL},
/* 1C0D */ { "LETTRE LEPTCHA NA",NULL},
/* 1C0E */ { "LETTRE LEPTCHA PA",NULL},
/* 1C0F */ { "LETTRE LEPTCHA PLA",NULL},
/* 1C10 */ { "LETTRE LEPTCHA PHA",NULL},
/* 1C11 */ { "LETTRE LEPTCHA FA",NULL},
/* 1C12 */ { "LETTRE LEPTCHA FLA",NULL},
/* 1C13 */ { "LETTRE LEPTCHA BA",NULL},
/* 1C14 */ { "LETTRE LEPTCHA BLA",NULL},
/* 1C15 */ { "LETTRE LEPTCHA MA",NULL},
/* 1C16 */ { "LETTRE LEPTCHA MLA",NULL},
/* 1C17 */ { "LETTRE LEPTCHA TSA",NULL},
/* 1C18 */ { "LETTRE LEPTCHA TÇA",NULL},
/* 1C19 */ { "LETTRE LEPTCHA DZA",NULL},
/* 1C1A */ { "LETTRE LEPTCHA YA",NULL},
/* 1C1B */ { "LETTRE LEPTCHA RA",NULL},
/* 1C1C */ { "LETTRE LEPTCHA LA",NULL},
/* 1C1D */ { "LETTRE LEPTCHA HA",NULL},
/* 1C1E */ { "LETTRE LEPTCHA HLA",NULL},
/* 1C1F */ { "LETTRE LEPTCHA VA",NULL},
/* 1C20 */ { "LETTRE LEPTCHA SA",NULL},
/* 1C21 */ { "LETTRE LEPTCHA ÇA",NULL},
/* 1C22 */ { "LETTRE LEPTCHA WA",NULL},
/* 1C23 */ { "LETTRE LEPTCHA A",NULL},
/* 1C24 */ { "LETTRE SUBJOINTE LEPTCHA YA",NULL},
/* 1C25 */ { "LETTRE SUBJOINTE LEPTCHA RA",NULL},
/* 1C26 */ { "DIACRITIQUE VOYELLE LEPTCHA Â",NULL},
/* 1C27 */ { "DIACRITIQUE VOYELLE LEPTCHA I",NULL},
/* 1C28 */ { "DIACRITIQUE VOYELLE LEPTCHA O",NULL},
/* 1C29 */ { "DIACRITIQUE VOYELLE LEPTCHA Ô",NULL},
/* 1C2A */ { "DIACRITIQUE VOYELLE LEPTCHA OU",NULL},
/* 1C2B */ { "DIACRITIQUE VOYELLE LEPTCHA OÛ",NULL},
/* 1C2C */ { "DIACRITIQUE VOYELLE LEPTCHA É",NULL},
/* 1C2D */ { "DIACRITIQUE CONSONNE LEPTCHA K",NULL},
/* 1C2E */ { "DIACRITIQUE CONSONNE LEPTCHA M",NULL},
/* 1C2F */ { "DIACRITIQUE CONSONNE LEPTCHA L",NULL},
/* 1C30 */ { "DIACRITIQUE CONSONNE LEPTCHA N",NULL},
/* 1C31 */ { "DIACRITIQUE CONSONNE LEPTCHA P",NULL},
/* 1C32 */ { "DIACRITIQUE CONSONNE LEPTCHA R",NULL},
/* 1C33 */ { "DIACRITIQUE CONSONNE LEPTCHA T",NULL},
/* 1C34 */ { "DIACRITIQUE CONSONNE LEPTCHA ÑIN-DO",NULL},
/* 1C35 */ { "DIACRITIQUE CONSONNE LEPTCHA KANG",NULL},
/* 1C36 */ { "DIACRITIQUE LEPTCHA RAN",NULL},
/* 1C37 */ { "DIACRITIQUE LEPTCHA NOUKTA",NULL},
/* 1C38 */ { NULL,NULL},
/* 1C39 */ { NULL,NULL},
/* 1C3A */ { NULL,NULL},
/* 1C3B */ { "PONCTUATION LEPTCHA TA-TOL",NULL},
/* 1C3C */ { "PONCTUATION LEPTCHA ÑET THYÔM TA-ROL",NULL},
/* 1C3D */ { "PONCTUATION LEPTCHA CER-WA",NULL},
/* 1C3E */ { "PONCTUATION LEPTCHA TCHÔK CER-WA",NULL},
/* 1C3F */ { "PONCTUATION LEPTCHA TCHÔK",NULL},
/* 1C40 */ { "CHIFFRE LEPTCHA ZÉRO",NULL},
/* 1C41 */ { "CHIFFRE LEPTCHA UN",NULL},
/* 1C42 */ { "CHIFFRE LEPTCHA DEUX",NULL},
/* 1C43 */ { "CHIFFRE LEPTCHA TROIS",NULL},
/* 1C44 */ { "CHIFFRE LEPTCHA QUATRE",NULL},
/* 1C45 */ { "CHIFFRE LEPTCHA CINQ",NULL},
/* 1C46 */ { "CHIFFRE LEPTCHA SIX",NULL},
/* 1C47 */ { "CHIFFRE LEPTCHA SEPT",NULL},
/* 1C48 */ { "CHIFFRE LEPTCHA HUIT",NULL},
/* 1C49 */ { "CHIFFRE LEPTCHA NEUF",NULL},
/* 1C4A */ { NULL,NULL},
/* 1C4B */ { NULL,NULL},
/* 1C4C */ { NULL,NULL},
/* 1C4D */ { "LETTRE LEPTCHA TTA",NULL},
/* 1C4E */ { "LETTRE LEPTCHA TTHA",NULL},
/* 1C4F */ { "LETTRE LEPTCHA DDA",NULL},
/* 1C50 */ { "CHIFFRE OL TCHIKI ZÉRO",NULL},
/* 1C51 */ { "CHIFFRE OL TCHIKI UN",NULL},
/* 1C52 */ { "CHIFFRE OL TCHIKI DEUX",NULL},
/* 1C53 */ { "CHIFFRE OL TCHIKI TROIS",NULL},
/* 1C54 */ { "CHIFFRE OL TCHIKI QUATRE",NULL},
/* 1C55 */ { "CHIFFRE OL TCHIKI CINQ",NULL},
/* 1C56 */ { "CHIFFRE OL TCHIKI SIX",NULL},
/* 1C57 */ { "CHIFFRE OL TCHIKI SEPT",NULL},
/* 1C58 */ { "CHIFFRE OL TCHIKI HUIT",NULL},
/* 1C59 */ { "CHIFFRE OL TCHIKI NEUF",NULL},
/* 1C5A */ { "LETTRE OL TCHIKI LA",NULL},
/* 1C5B */ { "LETTRE OL TCHIKI AT",NULL},
/* 1C5C */ { "LETTRE OL TCHIKI AG",NULL},
/* 1C5D */ { "LETTRE OL TCHIKI ANG",NULL},
/* 1C5E */ { "LETTRE OL TCHIKI AL",NULL},
/* 1C5F */ { "LETTRE OL TCHIKI LÂ",NULL},
/* 1C60 */ { "LETTRE OL TCHIKI ÂK",NULL},
/* 1C61 */ { "LETTRE OL TCHIKI ÂJ",NULL},
/* 1C62 */ { "LETTRE OL TCHIKI ÂM",NULL},
/* 1C63 */ { "LETTRE OL TCHIKI ÂW",NULL},
/* 1C64 */ { "LETTRE OL TCHIKI LI",NULL},
/* 1C65 */ { "LETTRE OL TCHIKI IS",NULL},
/* 1C66 */ { "LETTRE OL TCHIKI IH",NULL},
/* 1C67 */ { "LETTRE OL TCHIKI IÑ",NULL},
/* 1C68 */ { "LETTRE OL TCHIKI IR",NULL},
/* 1C69 */ { "LETTRE OL TCHIKI LOU",NULL},
/* 1C6A */ { "LETTRE OL TCHIKI OUTCH",NULL},
/* 1C6B */ { "LETTRE OL TCHIKI OUD",NULL},
/* 1C6C */ { "LETTRE OL TCHIKI OUNN",NULL},
/* 1C6D */ { "LETTRE OL TCHIKI OUY",NULL},
/* 1C6E */ { "LETTRE OL TCHIKI LÉ",NULL},
/* 1C6F */ { "LETTRE OL TCHIKI ÉP",NULL},
/* 1C70 */ { "LETTRE OL TCHIKI ÉDD",NULL},
/* 1C71 */ { "LETTRE OL TCHIKI ÉN",NULL},
/* 1C72 */ { "LETTRE OL TCHIKI ÉRR",NULL},
/* 1C73 */ { "LETTRE OL TCHIKI LO",NULL},
/* 1C74 */ { "LETTRE OL TCHIKI OTT",NULL},
/* 1C75 */ { "LETTRE OL TCHIKI OB",NULL},
/* 1C76 */ { "LETTRE OL TCHIKI OV",NULL},
/* 1C77 */ { "LETTRE OL TCHIKI OH",NULL},
/* 1C78 */ { "MOU TTOUDDAG OL TCHIKI","	* marque de nasalisation"},
/* 1C79 */ { "GÂHLÂ TTOUDDÂG OL TCHIKI","	* modificateur de voyelle"},
/* 1C7A */ { "MOU-GÂHLÂ TTOUDDÂG OL TCHIKI",NULL},
/* 1C7B */ { "RÉLÂ OL TCHIKI","	* marque de longueur, indique une prononciation longue"},
/* 1C7C */ { "PHÂRKÂ OL TCHIKI",NULL},
/* 1C7D */ { "AHAD OL TCHIKI",NULL},
/* 1C7E */ { "PONCTUATION OL TCHIKI MOUTCHÂD",NULL},
/* 1C7F */ { "PONCTUATION OL TCHIKI DOUBLE MOUTCHÂD",NULL},
/* 1C80 */ { "LETTRE MINUSCULE CYRILLIQUE VÉ ARRONDI","	x (lettre minuscule cyrillique vé - 0432)"},
/* 1C81 */ { "LETTRE MINUSCULE CYRILLIQUE DÉ À HAMPE LONGUE","	x (lettre minuscule cyrillique dé - 0434)"},
/* 1C82 */ { "LETTRE MINUSCULE CYRILLIQUE O ÉTROIT","	x (lettre minuscule cyrillique o - 043E)"},
/* 1C83 */ { "LETTRE MINUSCULE CYRILLIQUE GRAND ESSE","	x (lettre minuscule cyrillique esse - 0441)"},
/* 1C84 */ { "LETTRE MINUSCULE CYRILLIQUE TÉ HAUT",NULL},
/* 1C85 */ { "LETTRE MINUSCULE CYRILLIQUE TÉ À TROIS HAMPES","	x (lettre minuscule cyrillique té - 0442)"},
/* 1C86 */ { "LETTRE MINUSCULE CYRILLIQUE SIGNE DUR HAUT","	x (lettre minuscule cyrillique signe dur - 044A)"},
/* 1C87 */ { "LETTRE MINUSCULE CYRILLIQUE YATE HAUT","	x (lettre minuscule cyrillique iat' - 0463)"},
/* 1C88 */ { "LETTRE MINUSCULE CYRILLIQUE OUK NON MÉLANGÉ","	x (lettre minuscule cyrillique ouk - 0479)\n"
	"	x (lettre minuscule cyrillique monogramme ouk - A64B)"},
/* 1C89 */ { NULL,NULL},
/* 1C8A */ { NULL,NULL},
/* 1C8B */ { NULL,NULL},
/* 1C8C */ { NULL,NULL},
/* 1C8D */ { NULL,NULL},
/* 1C8E */ { NULL,NULL},
/* 1C8F */ { NULL,NULL},
/* 1C90 */ { NULL,NULL},
/* 1C91 */ { NULL,NULL},
/* 1C92 */ { NULL,NULL},
/* 1C93 */ { NULL,NULL},
/* 1C94 */ { NULL,NULL},
/* 1C95 */ { NULL,NULL},
/* 1C96 */ { NULL,NULL},
/* 1C97 */ { NULL,NULL},
/* 1C98 */ { NULL,NULL},
/* 1C99 */ { NULL,NULL},
/* 1C9A */ { NULL,NULL},
/* 1C9B */ { NULL,NULL},
/* 1C9C */ { NULL,NULL},
/* 1C9D */ { NULL,NULL},
/* 1C9E */ { NULL,NULL},
/* 1C9F */ { NULL,NULL},
/* 1CA0 */ { NULL,NULL},
/* 1CA1 */ { NULL,NULL},
/* 1CA2 */ { NULL,NULL},
/* 1CA3 */ { NULL,NULL},
/* 1CA4 */ { NULL,NULL},
/* 1CA5 */ { NULL,NULL},
/* 1CA6 */ { NULL,NULL},
/* 1CA7 */ { NULL,NULL},
/* 1CA8 */ { NULL,NULL},
/* 1CA9 */ { NULL,NULL},
/* 1CAA */ { NULL,NULL},
/* 1CAB */ { NULL,NULL},
/* 1CAC */ { NULL,NULL},
/* 1CAD */ { NULL,NULL},
/* 1CAE */ { NULL,NULL},
/* 1CAF */ { NULL,NULL},
/* 1CB0 */ { NULL,NULL},
/* 1CB1 */ { NULL,NULL},
/* 1CB2 */ { NULL,NULL},
/* 1CB3 */ { NULL,NULL},
/* 1CB4 */ { NULL,NULL},
/* 1CB5 */ { NULL,NULL},
/* 1CB6 */ { NULL,NULL},
/* 1CB7 */ { NULL,NULL},
/* 1CB8 */ { NULL,NULL},
/* 1CB9 */ { NULL,NULL},
/* 1CBA */ { NULL,NULL},
/* 1CBB */ { NULL,NULL},
/* 1CBC */ { NULL,NULL},
/* 1CBD */ { NULL,NULL},
/* 1CBE */ { NULL,NULL},
/* 1CBF */ { NULL,NULL},
/* 1CC0 */ { "PONCTUATION SOUNDANAISE BINDU SURYA","	* soleil"},
/* 1CC1 */ { "PONCTUATION SOUNDANAISE BINDU PANGLONG","	* demi-lune"},
/* 1CC2 */ { "PONCTUATION SOUNDANAISE BINDU PURNAMA","	* pleine lune"},
/* 1CC3 */ { "PONCTUATION SOUNDANAISE BINDU CAKRA","	* roue"},
/* 1CC4 */ { "PONCTUATION SOUNDANAISE BINDU LEU SATANGA",NULL},
/* 1CC5 */ { "PONCTUATION SOUNDANAISE BINDU KA SATANGA",NULL},
/* 1CC6 */ { "PONCTUATION SOUNDANAISE BINDU DA SATANGA",NULL},
/* 1CC7 */ { "PONCTUATION SOUNDANAISE BINDU BA SATANGA",NULL},
/* 1CC8 */ { NULL,NULL},
/* 1CC9 */ { NULL,NULL},
/* 1CCA */ { NULL,NULL},
/* 1CCB */ { NULL,NULL},
/* 1CCC */ { NULL,NULL},
/* 1CCD */ { NULL,NULL},
/* 1CCE */ { NULL,NULL},
/* 1CCF */ { NULL,NULL},
/* 1CD0 */ { "DIACRITIQUE TON VÉDIQUE KARSHANA","	= vaïdika sâmasvara karshanna"},
/* 1CD1 */ { "DIACRITIQUE TON VÉDIQUE SHARA","	= vaïdika svarita oûrdhva shara"},
/* 1CD2 */ { "DIACRITIQUE TON VÉDIQUE PRENKHA","	= vaïdika sâmasvara prenkha"},
/* 1CD3 */ { "SIGNE VÉDIQUE NIHSHVASA","	= vaïdika sâmagâna yogakâla"},
/* 1CD4 */ { "DIACRITIQUE VÉDIQUE YAJURVÉDIQUE SVARITA MÉDIAN",NULL},
/* 1CD5 */ { "DIACRITIQUE TON VÉDIQUE YAJURVÉDIQUE SVARITA INDÉPENDANT AGGRAVÉ","	= vaïdika svarita adho nyoubdja"},
/* 1CD6 */ { "DIACRITIQUE TON VÉDIQUE YAJURVÉDIQUE SVARITA INDÉPENDANT","	= vaïdika svarita adhah konna"},
/* 1CD7 */ { "DIACRITIQUE TON VÉDIQUE YAJURVÉDIQUE KATHAKA SVARITA INDÉPENDANT","	= vaïdika svarita adho vakra rékhâ"},
/* 1CD8 */ { "DIACRITIQUE TON VÉDIQUE TCHANDRA SOUSCRIT","	= vaïdika svarita adho'rdha vakra"},
/* 1CD9 */ { "DIACRITIQUE TON VÉDIQUE YAJURVÉDIQUE KATHAKA SVARITA INDÉPENDANT SCHROEDER","	= vaïdika svarita adhah samyoukta rékhâ"},
/* 1CDA */ { "DIACRITIQUE TON VÉDIQUE DOUBLE SVARITA","	= vaïdika svarita oûrdhva dvi rékhâ\n"
	"	x (diacritique d'accentuation dévanâgarî oudatta - 0951)"},
/* 1CDB */ { "DIACRITIQUE TON VÉDIQUE TRIPLE SVARITA","	= vaïdika svarita oûrdhva tri rékhâ"},
/* 1CDC */ { "DIACRITIQUE TON VÉDIQUE KATHAKA ANOUDATTA","	= vaïdika svarita adho rékhâ\n"
	"	x (diacritique d'accentuation dévanâgarî anoudatta - 0952)"},
/* 1CDD */ { "DIACRITIQUE TON VÉDIQUE POINT SOUSCRIT","	= vaïdika svarita adho bindou"},
/* 1CDE */ { "DIACRITIQUE TON VÉDIQUE DEUX POINTS SOUSCRITS","	= vaïdika svarita adho dvi bindou"},
/* 1CDF */ { "DIACRITIQUE TON VÉDIQUE TROIS POINTS SOUSCRITS","	= vaïdika svarita adhas tri bindou"},
/* 1CE0 */ { "DIACRITIQUE TON VÉDIQUE RIGVÉDIQUE CACHEMIRI SVARITA INDÉPENDANT","	= vaïdika uurdhva vakra rékhâ"},
/* 1CE1 */ { "DIACRITIQUE TON VÉDIQUE ATHARVAVÉDIQUE SVARITA INDÉPENDANT","	= vaïdika svarita dvi vakra khannda"},
/* 1CE2 */ { "DIACRITIQUE VÉDIQUE VISARGA SVARITA","	= vaïdika madhyarekhâ"},
/* 1CE3 */ { "DIACRITIQUE VÉDIQUE VISARGA OUDATTA","	= vaïdika visarga dakshinnatah oûrdhvaga"},
/* 1CE4 */ { "DIACRITIQUE VÉDIQUE VISARGA OUDATTA RÉFLÉCHI","	= vaïdika visarga vâmatah oûrdhvaga"},
/* 1CE5 */ { "DIACRITIQUE VÉDIQUE VISARGA ANOUDATTA","	= vaïdika visarga vâmatah adhoga"},
/* 1CE6 */ { "DIACRITIQUE VÉDIQUE VISARGA ANOUDATTA RÉFLÉCHI","	= vaïdika visarga dakshinnatah adhoga"},
/* 1CE7 */ { "DIACRITIQUE VÉDIQUE VISARGA OUDATTA HAMEÇON","	= vaïdika visarga dakshinnatah oûrdhva vakra"},
/* 1CE8 */ { "DIACRITIQUE VÉDIQUE VISARGA ANOUDATTA HAMEÇON","	= vaïdika visarga vâmatah adho vakra"},
/* 1CE9 */ { "SIGNE VÉDIQUE ANOUSVÂRA ANTARGOMOUKHA","	= vaïdika anousvâra antarmoukha"},
/* 1CEA */ { "SIGNE VÉDIQUE ANOUSVÂRA BAHIRGOMOUKHA","	= vaïdika anousvâra nâgaphanna"},
/* 1CEB */ { "SIGNE VÉDIQUE ANOUSVÂRA VAMAGOMOUKHA","	= vaïdika anousvâra vâmagomoukha"},
/* 1CEC */ { "SIGNE VÉDIQUE ANOUSVÂRA VAMAGOMOUKHA HAMEÇON","	= vaïdika anousvâra vâmagomoukha sa-vakra"},
/* 1CED */ { "DIACRITIQUE VÉDIQUE TIRYAK","	= vaïdika tiryak"},
/* 1CEE */ { "SIGNE VÉDIQUE ANOUSVÂRA LONG HEXAFORME","	= vaïdika anousvâra anougâmî"},
/* 1CEF */ { "SIGNE VÉDIQUE ANOUSVÂRA LONG","	= vaïdika anousvâra dakshinnamoukha"},
/* 1CF0 */ { "SIGNE VÉDIQUE RTHANG ANOUSVÂRA LONG","	= vaïdika anousvâra ttha-sadrisha"},
/* 1CF1 */ { "SIGNE VÉDIQUE ANOUSVÂRA OUBHAYATO MOUKHA","	= vaïdika anousvâra oubhayato moukha"},
/* 1CF2 */ { "DIACRITIQUE VÉDIQUE ARDHAVISARGA","	= vaïdika anousvâra ttha-sadrisha"},
/* 1CF3 */ { "DIACRITIQUE VÉDIQUE ARDHAVISARGA COUCHÉ",NULL},
/* 1CF4 */ { "DIACRITIQUE TON VÉDIQUE TCHANDRA EN CHEF",NULL},
/* 1CF5 */ { "SIGNE VÉDIQUE DJIHVAMOULIYA","	x (signe kannara djihvamouliya - 0CF1)\n"
	"	x (signe tibétain lce tsa can - 0F88)"},
/* 1CF6 */ { "SIGNE VÉDIQUE OUPADHMANIYA","	x (signe kannara oupadhmaniya - 0CF2)\n"
	"	x (signe tibétain mchu can - 0F89)"},
/* 1CF7 */ { "DIACRITIQUE VÉDIQUE ATIKRAMA","	= vaïdika sâmagâna atikrama\n"
	"	* indique la suppression d'un svara"},
/* 1CF8 */ { "DIACRITIQUE TON VÉDIQUE ROND SUSCRIT",NULL},
/* 1CF9 */ { "DIACRITIQUE TON VÉDIQUE DOUBLE ROND SUSCRIT",NULL},
/* 1CFA */ { NULL,NULL},
/* 1CFB */ { NULL,NULL},
/* 1CFC */ { NULL,NULL},
/* 1CFD */ { NULL,NULL},
/* 1CFE */ { NULL,NULL},
/* 1CFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_1D[] = {
/* 1D00 */ { "LETTRE LATINE PETITE CAPITALE A",NULL},
/* 1D01 */ { "LETTRE LATINE PETITE CAPITALE AE",NULL},
/* 1D02 */ { "LETTRE MINUSCULE LATINE AE CULBUTÉ","	* le glyphe peut également apparaître de biais"},
/* 1D03 */ { "LETTRE LATINE PETITE CAPITALE B BARRÉ",NULL},
/* 1D04 */ { "LETTRE LATINE PETITE CAPITALE C",NULL},
/* 1D05 */ { "LETTRE LATINE PETITE CAPITALE D",NULL},
/* 1D06 */ { "LETTRE LATINE PETITE CAPITALE ETH",NULL},
/* 1D07 */ { "LETTRE LATINE PETITE CAPITALE E",NULL},
/* 1D08 */ { "LETTRE MINUSCULE LATINE EPSILON CULBUTÉ",NULL},
/* 1D09 */ { "LETTRE MINUSCULE LATINE I CULBUTÉ",NULL},
/* 1D0A */ { "LETTRE LATINE PETITE CAPITALE J",NULL},
/* 1D0B */ { "LETTRE LATINE PETITE CAPITALE K",NULL},
/* 1D0C */ { "LETTRE LATINE PETITE CAPITALE L BARRÉ OBLIQUEMENT","	= lettre petite capitale l coticé"},
/* 1D0D */ { "LETTRE LATINE PETITE CAPITALE M",NULL},
/* 1D0E */ { "LETTRE LATINE PETITE CAPITALE N RÉFLÉCHI",NULL},
/* 1D0F */ { "LETTRE LATINE PETITE CAPITALE O",NULL},
/* 1D10 */ { "LETTRE LATINE PETITE CAPITALE O OUVERT",NULL},
/* 1D11 */ { "LETTRE MINUSCULE LATINE O COUCHÉ",NULL},
/* 1D12 */ { "LETTRE MINUSCULE LATINE O OUVERT COUCHÉ",NULL},
/* 1D13 */ { "LETTRE MINUSCULE LATINE O COUCHÉ BARRÉ OBLIQUEMENT","	= lettre minuscule o coticé"},
/* 1D14 */ { "LETTRE MINUSCULE LATINE OE CULBUTÉ","	* le glyphe peut également apparaître de biais"},
/* 1D15 */ { "LETTRE LATINE PETITE CAPITALE OU",NULL},
/* 1D16 */ { "LETTRE MINUSCULE LATINE MOITIÉ SUPÉRIEURE DE O",NULL},
/* 1D17 */ { "LETTRE MINUSCULE LATINE MOITIÉ INFÉRIEURE DE O",NULL},
/* 1D18 */ { "LETTRE LATINE PETITE CAPITALE P","	* représente un [p] semi-voisé"},
/* 1D19 */ { "LETTRE LATINE PETITE CAPITALE R RÉFLÉCHI",NULL},
/* 1D1A */ { "LETTRE LATINE PETITE CAPITALE R CULBUTÉ",NULL},
/* 1D1B */ { "LETTRE LATINE PETITE CAPITALE T",NULL},
/* 1D1C */ { "LETTRE LATINE PETITE CAPITALE U",NULL},
/* 1D1D */ { "LETTRE MINUSCULE LATINE U COUCHÉ",NULL},
/* 1D1E */ { "LETTRE MINUSCULE LATINE U TRÉMA COUCHÉ","	* le glyphe peut également apparaître de biais"},
/* 1D1F */ { "LETTRE MINUSCULE LATINE M COUCHÉ",NULL},
/* 1D20 */ { "LETTRE LATINE PETITE CAPITALE V",NULL},
/* 1D21 */ { "LETTRE LATINE PETITE CAPITALE W",NULL},
/* 1D22 */ { "LETTRE LATINE PETITE CAPITALE Z",NULL},
/* 1D23 */ { "LETTRE LATINE PETITE CAPITALE EJ",NULL},
/* 1D24 */ { "LETTRE LATINE FRICATIVE PHARYNGALE VOISÉE",NULL},
/* 1D25 */ { "LETTRE LATINE 'AÏN",NULL},
/* 1D26 */ { "LETTRE GRECQUE PETITE CAPITALE GAMMA",NULL},
/* 1D27 */ { "LETTRE GRECQUE PETITE CAPITALE LAMBDA",NULL},
/* 1D28 */ { "LETTRE GRECQUE PETITE CAPITALE PI",NULL},
/* 1D29 */ { "LETTRE GRECQUE PETITE CAPITALE RHÔ","	* représente une vibrante uvulaire sourde"},
/* 1D2A */ { "LETTRE GRECQUE PETITE CAPITALE PSI",NULL},
/* 1D2B */ { "LETTRE CYRILLIQUE PETITE CAPITALE ELLE","	* dans un contexte italique, cette lettre est penchée au lieu d'avoir un tracé italique\n"
	"	x (lettre minuscule cyrillique elle - 043B)"},
/* 1D2C */ { "LETTRE MODIFICATIVE MAJUSCULE A","	# <exp> 0041"},
/* 1D2D */ { "LETTRE MODIFICATIVE MAJUSCULE AE","	# <exp> 00C6"},
/* 1D2E */ { "LETTRE MODIFICATIVE MAJUSCULE B","	# <exp> 0042"},
/* 1D2F */ { "LETTRE MODIFICATIVE MAJUSCULE B BARRÉ",NULL},
/* 1D30 */ { "LETTRE MODIFICATIVE MAJUSCULE D","	# <exp> 0044"},
/* 1D31 */ { "LETTRE MODIFICATIVE MAJUSCULE E","	# <exp> 0045"},
/* 1D32 */ { "LETTRE MODIFICATIVE MAJUSCULE E RÉFLÉCHI","	# <exp> 018E"},
/* 1D33 */ { "LETTRE MODIFICATIVE MAJUSCULE G","	# <exp> 0047"},
/* 1D34 */ { "LETTRE MODIFICATIVE MAJUSCULE H","	# <exp> 0048"},
/* 1D35 */ { "LETTRE MODIFICATIVE MAJUSCULE I","	# <exp> 0049"},
/* 1D36 */ { "LETTRE MODIFICATIVE MAJUSCULE J","	# <exp> 004A"},
/* 1D37 */ { "LETTRE MODIFICATIVE MAJUSCULE K","	# <exp> 004B"},
/* 1D38 */ { "LETTRE MODIFICATIVE MAJUSCULE L","	# <exp> 004C"},
/* 1D39 */ { "LETTRE MODIFICATIVE MAJUSCULE M","	# <exp> 004D"},
/* 1D3A */ { "LETTRE MODIFICATIVE MAJUSCULE N","	# <exp> 004E"},
/* 1D3B */ { "LETTRE MODIFICATIVE MAJUSCULE N RÉFLÉCHI",NULL},
/* 1D3C */ { "LETTRE MODIFICATIVE MAJUSCULE O","	# <exp> 004F"},
/* 1D3D */ { "LETTRE MODIFICATIVE MAJUSCULE OU","	# <exp> 0222"},
/* 1D3E */ { "LETTRE MODIFICATIVE MAJUSCULE P","	# <exp> 0050"},
/* 1D3F */ { "LETTRE MODIFICATIVE MAJUSCULE R","	# <exp> 0052"},
/* 1D40 */ { "LETTRE MODIFICATIVE MAJUSCULE T","	# <exp> 0054"},
/* 1D41 */ { "LETTRE MODIFICATIVE MAJUSCULE U","	# <exp> 0055"},
/* 1D42 */ { "LETTRE MODIFICATIVE MAJUSCULE W","	# <exp> 0057"},
/* 1D43 */ { "LETTRE MODIFICATIVE MINUSCULE A","	# <exp> 0061"},
/* 1D44 */ { "LETTRE MODIFICATIVE MINUSCULE A CULBUTÉ","	# <exp> 0250"},
/* 1D45 */ { "LETTRE MODIFICATIVE MINUSCULE ALPHA","	# <exp> 0251"},
/* 1D46 */ { "LETTRE MODIFICATIVE MINUSCULE AE CULBUTÉ","	# <exp> 1D02"},
/* 1D47 */ { "LETTRE MODIFICATIVE MINUSCULE B","	# <exp> 0062"},
/* 1D48 */ { "LETTRE MODIFICATIVE MINUSCULE D","	# <exp> 0064"},
/* 1D49 */ { "LETTRE MODIFICATIVE MINUSCULE E","	# <exp> 0065"},
/* 1D4A */ { "LETTRE MODIFICATIVE MINUSCULE SCHWA","	# <exp> 0259"},
/* 1D4B */ { "LETTRE MODIFICATIVE MINUSCULE EPSILON","	# <exp> 025B"},
/* 1D4C */ { "LETTRE MODIFICATIVE MINUSCULE EPSILON CULBUTÉ","	* 1D08 serait probablement une meilleure équivalence\n"
	"	# <exp> 025C"},
/* 1D4D */ { "LETTRE MODIFICATIVE MINUSCULE G","	# <exp> 0067"},
/* 1D4E */ { "LETTRE MODIFICATIVE MINUSCULE I CULBUTÉ",NULL},
/* 1D4F */ { "LETTRE MODIFICATIVE MINUSCULE K","	# <exp> 006B"},
/* 1D50 */ { "LETTRE MODIFICATIVE MINUSCULE M","	# <exp> 006D"},
/* 1D51 */ { "LETTRE MODIFICATIVE MINUSCULE ENG","	# <exp> 014B"},
/* 1D52 */ { "LETTRE MODIFICATIVE MINUSCULE O","	# <exp> 006F"},
/* 1D53 */ { "LETTRE MODIFICATIVE MINUSCULE O OUVERT","	# <exp> 0254"},
/* 1D54 */ { "LETTRE MODIFICATIVE MINUSCULE MOITIÉ SUPÉRIEURE DE O","	# <exp> 1D16"},
/* 1D55 */ { "LETTRE MODIFICATIVE MINUSCULE MOITIÉ INFÉRIEURE DE O","	# <exp> 1D17"},
/* 1D56 */ { "LETTRE MODIFICATIVE MINUSCULE P","	# <exp> 0070"},
/* 1D57 */ { "LETTRE MODIFICATIVE MINUSCULE T","	# <exp> 0074"},
/* 1D58 */ { "LETTRE MODIFICATIVE MINUSCULE U","	# <exp> 0075"},
/* 1D59 */ { "LETTRE MODIFICATIVE MINUSCULE U COUCHÉ","	# <exp> 1D1D"},
/* 1D5A */ { "LETTRE MODIFICATIVE MINUSCULE M CULBUTÉ","	# <exp> 026F"},
/* 1D5B */ { "LETTRE MODIFICATIVE MINUSCULE V","	# <exp> 0076"},
/* 1D5C */ { "LETTRE MODIFICATIVE MINUSCULE 'AÏN","	# <exp> 1D25"},
/* 1D5D */ { "LETTRE MODIFICATIVE MINUSCULE BÊTA","	# <exp> 03B2"},
/* 1D5E */ { "LETTRE MODIFICATIVE MINUSCULE GRECQUE GAMMA","	# <exp> 03B3"},
/* 1D5F */ { "LETTRE MODIFICATIVE MINUSCULE DELTA","	# <exp> 03B4"},
/* 1D60 */ { "LETTRE MODIFICATIVE MINUSCULE GRECQUE PHI","	# <exp> 03C6"},
/* 1D61 */ { "LETTRE MODIFICATIVE MINUSCULE KHI","	# <exp> 03C7"},
/* 1D62 */ { "INDICE LETTRE MINUSCULE LATINE I","	# <souscrite> 0069"},
/* 1D63 */ { "INDICE LETTRE MINUSCULE LATINE R","	# <souscrite> 0072"},
/* 1D64 */ { "INDICE LETTRE MINUSCULE LATINE U","	# <souscrite> 0075"},
/* 1D65 */ { "INDICE LETTRE MINUSCULE LATINE V","	# <souscrite> 0076"},
/* 1D66 */ { "INDICE LETTRE MINUSCULE GRECQUE BÊTA","	# <souscrite> 03B2"},
/* 1D67 */ { "INDICE LETTRE MINUSCULE GRECQUE GAMMA","	# <souscrite> 03B3"},
/* 1D68 */ { "INDICE LETTRE MINUSCULE GRECQUE RHÔ","	# <souscrite> 03C1"},
/* 1D69 */ { "INDICE LETTRE MINUSCULE GRECQUE PHI","	# <souscrite> 03C6"},
/* 1D6A */ { "INDICE LETTRE MINUSCULE GRECQUE KHI","	# <souscrite> 03C7"},
/* 1D6B */ { "LETTRE MINUSCULE LATINE UE",NULL},
/* 1D6C */ { "LETTRE MINUSCULE LATINE B TILDE MÉDIAN",NULL},
/* 1D6D */ { "LETTRE MINUSCULE LATINE D TILDE MÉDIAN",NULL},
/* 1D6E */ { "LETTRE MINUSCULE LATINE F TILDE MÉDIAN",NULL},
/* 1D6F */ { "LETTRE MINUSCULE LATINE M TILDE MÉDIAN",NULL},
/* 1D70 */ { "LETTRE MINUSCULE LATINE N TILDE MÉDIAN",NULL},
/* 1D71 */ { "LETTRE MINUSCULE LATINE P TILDE MÉDIAN",NULL},
/* 1D72 */ { "LETTRE MINUSCULE LATINE R TILDE MÉDIAN",NULL},
/* 1D73 */ { "LETTRE MINUSCULE LATINE R SANS OBIT TILDE MÉDIAN",NULL},
/* 1D74 */ { "LETTRE MINUSCULE LATINE S TILDE MÉDIAN",NULL},
/* 1D75 */ { "LETTRE MINUSCULE LATINE T TILDE MÉDIAN",NULL},
/* 1D76 */ { "LETTRE MINUSCULE LATINE Z TILDE MÉDIAN",NULL},
/* 1D77 */ { "LETTRE MINUSCULE LATINE G CULBUTÉ","	* transcription du géorgien\n"
	"	x (lettre géorgienne gan culbuté - 10F9)"},
/* 1D78 */ { "LETTRE MODIFICATIVE CYRILLIQUE ENNE","	# <exp> 043D"},
/* 1D79 */ { "LETTRE MINUSCULE LATINE G INSULAIRE","	* ancienne notation phonétique irlandaise\n"
	"	* la majuscule est A77D\n"
	"	x (lettre minuscule latine g - 0067)\n"
	"	x (lettre minuscule latine yogh - 021D)\n"
	"	x (lettre minuscule latine g cursif - 0261)\n"
	"	x (lettre minuscule latine gamma - 0263)"},
/* 1D7A */ { "LETTRE MINUSCULE LATINE TH BARRÉ OBLIQUEMENT","	* usage lexicographique américain\n"
	"	x (lettre minuscule grecque thêta - 03B8)"},
/* 1D7B */ { "LETTRE LATINE PETITE CAPITALE I BARRÉ","	* a des sens différents pour les américanistes et les dictionnaires Oxford"},
/* 1D7C */ { "LETTRE MINUSCULE LATINE IOTA BARRÉ","	* utilisée par les russistes"},
/* 1D7D */ { "LETTRE MINUSCULE LATINE P BARRÉ","	* utilisée par les américanistes\n"
	"	* la majuscule est 2C63"},
/* 1D7E */ { "LETTRE LATINE PETITE CAPITALE U BARRÉ","	* utilisée par les américanistes"},
/* 1D7F */ { "LETTRE MINUSCULE LATINE UPSILON BARRÉ","	* utilisée par les américanistes et les dictionnaires Oxford"},
/* 1D80 */ { "LETTRE MINUSCULE LATINE B HAMEÇON PALATAL",NULL},
/* 1D81 */ { "LETTRE MINUSCULE LATINE D HAMEÇON PALATAL",NULL},
/* 1D82 */ { "LETTRE MINUSCULE LATINE F HAMEÇON PALATAL",NULL},
/* 1D83 */ { "LETTRE MINUSCULE LATINE G HAMEÇON PALATAL",NULL},
/* 1D84 */ { "LETTRE MINUSCULE LATINE K HAMEÇON PALATAL",NULL},
/* 1D85 */ { "LETTRE MINUSCULE LATINE L HAMEÇON PALATAL",NULL},
/* 1D86 */ { "LETTRE MINUSCULE LATINE M HAMEÇON PALATAL",NULL},
/* 1D87 */ { "LETTRE MINUSCULE LATINE N HAMEÇON PALATAL",NULL},
/* 1D88 */ { "LETTRE MINUSCULE LATINE P HAMEÇON PALATAL",NULL},
/* 1D89 */ { "LETTRE MINUSCULE LATINE R HAMEÇON PALATAL",NULL},
/* 1D8A */ { "LETTRE MINUSCULE LATINE S HAMEÇON PALATAL",NULL},
/* 1D8B */ { "LETTRE MINUSCULE LATINE ECH HAMEÇON PALATAL",NULL},
/* 1D8C */ { "LETTRE MINUSCULE LATINE V HAMEÇON PALATAL",NULL},
/* 1D8D */ { "LETTRE MINUSCULE LATINE X HAMEÇON PALATAL",NULL},
/* 1D8E */ { "LETTRE MINUSCULE LATINE Z HAMEÇON PALATAL",NULL},
/* 1D8F */ { "LETTRE MINUSCULE LATINE A HAMEÇON RÉTROFLEXE",NULL},
/* 1D90 */ { "LETTRE MINUSCULE LATINE ALPHA HAMEÇON RÉTROFLEXE",NULL},
/* 1D91 */ { "LETTRE MINUSCULE LATINE D CROSSE ET HAMEÇON RÉTROFLEXE",NULL},
/* 1D92 */ { "LETTRE MINUSCULE LATINE E HAMEÇON RÉTROFLEXE",NULL},
/* 1D93 */ { "LETTRE MINUSCULE LATINE EPSILON HAMEÇON RÉTROFLEXE",NULL},
/* 1D94 */ { "LETTRE MINUSCULE LATINE EPSILON RÉFLÉCHI HAMEÇON RÉTROFLEXE","	x (lettre minuscule latine e ouvert réfléchi crochet - 025D)"},
/* 1D95 */ { "LETTRE MINUSCULE LATINE SCHWA HAMEÇON RÉTROFLEXE","	x (lettre minuscule latine schwa crochet - 025A)"},
/* 1D96 */ { "LETTRE MINUSCULE LATINE I HAMEÇON RÉTROFLEXE",NULL},
/* 1D97 */ { "LETTRE MINUSCULE LATINE O OUVERT HAMEÇON RÉTROFLEXE",NULL},
/* 1D98 */ { "LETTRE MINUSCULE LATINE ECH HAMEÇON RÉTROFLEXE",NULL},
/* 1D99 */ { "LETTRE MINUSCULE LATINE U HAMEÇON RÉTROFLEXE",NULL},
/* 1D9A */ { "LETTRE MINUSCULE LATINE EJ HAMEÇON RÉTROFLEXE",NULL},
/* 1D9B */ { "LETTRE MODIFICATIVE MINUSCULE ALPHA CULBUTÉ","	# <exp> 0252"},
/* 1D9C */ { "LETTRE MODIFICATIVE MINUSCULE C","	# <exp> 0063"},
/* 1D9D */ { "LETTRE MODIFICATIVE MINUSCULE C BOUCLÉ","	# <exp> 0255"},
/* 1D9E */ { "LETTRE MODIFICATIVE MINUSCULE ED","	# <exp> 00F0"},
/* 1D9F */ { "LETTRE MODIFICATIVE MINUSCULE EPSILON RÉFLÉCHI","	# <exp> 025C"},
/* 1DA0 */ { "LETTRE MODIFICATIVE MINUSCULE F","	# <exp> 0066"},
/* 1DA1 */ { "LETTRE MODIFICATIVE MINUSCULE J SANS POINT BARRÉ","	# <exp> 025F"},
/* 1DA2 */ { "LETTRE MODIFICATIVE MINUSCULE G CURSIF","	# <exp> 0261"},
/* 1DA3 */ { "LETTRE MODIFICATIVE MINUSCULE H CULBUTÉ","	# <exp> 0265"},
/* 1DA4 */ { "LETTRE MODIFICATIVE MINUSCULE I BARRÉ","	# <exp> 0268"},
/* 1DA5 */ { "LETTRE MODIFICATIVE MINUSCULE IOTA","	# <exp> 0269"},
/* 1DA6 */ { "LETTRE MODIFICATIVE PETITE CAPITALE I","	* pas destiné à l'APO\n"
	"	x (lettre modificative majuscule i - 1D35)\n"
	"	# <exp> 026A"},
/* 1DA7 */ { "LETTRE MODIFICATIVE PETITE CAPITALE I BARRÉ","	# <exp> 1D7B"},
/* 1DA8 */ { "LETTRE MODIFICATIVE MINUSCULE J À QUEUE CROISÉE","	# <exp> 029D"},
/* 1DA9 */ { "LETTRE MODIFICATIVE MINUSCULE L HAMEÇON RÉTROFLEXE","	# <exp> 026D"},
/* 1DAA */ { "LETTRE MODIFICATIVE MINUSCULE L HAMEÇON PALATAL","	# <exp> 1D85"},
/* 1DAB */ { "LETTRE MODIFICATIVE PETITE CAPITALE L","	* pas destiné à l'APO\n"
	"	x (lettre modificative majuscule l - 1D38)\n"
	"	# <exp> 029F"},
/* 1DAC */ { "LETTRE MODIFICATIVE MINUSCULE M HAMEÇON","	# <exp> 0271"},
/* 1DAD */ { "LETTRE MODIFICATIVE MINUSCULE M CULBUTÉ À LONG FÛT","	# <exp> 0270"},
/* 1DAE */ { "LETTRE MODIFICATIVE MINUSCULE N HAMEÇON À GAUCHE","	# <exp> 0272"},
/* 1DAF */ { "LETTRE MODIFICATIVE MINUSCULE N HAMEÇON RÉTROFLEXE","	# <exp> 0273"},
/* 1DB0 */ { "LETTRE MODIFICATIVE PETITE CAPITALE N","	* pas destiné à l'APO\n"
	"	x (lettre modificative majuscule n - 1D3A)\n"
	"	# <exp> 0274"},
/* 1DB1 */ { "LETTRE MODIFICATIVE MINUSCULE O BARRÉ","	# <exp> 0275"},
/* 1DB2 */ { "LETTRE MODIFICATIVE MINUSCULE PHI","	# <exp> 0278"},
/* 1DB3 */ { "LETTRE MODIFICATIVE MINUSCULE S HAMEÇON RÉTROFLEXE","	# <exp> 0282"},
/* 1DB4 */ { "LETTRE MODIFICATIVE MINUSCULE ECH","	# <exp> 0283"},
/* 1DB5 */ { "LETTRE MODIFICATIVE MINUSCULE T HAMEÇON PALATAL","	# <exp> 01AB"},
/* 1DB6 */ { "LETTRE MODIFICATIVE MINUSCULE U BARRÉ","	# <exp> 0289"},
/* 1DB7 */ { "LETTRE MODIFICATIVE MINUSCULE UPSILON","	# <exp> 028A"},
/* 1DB8 */ { "LETTRE MODIFICATIVE PETITE CAPITALE U","	* pas destiné à l'APO\n"
	"	x (lettre modificative majuscule u - 1D41)\n"
	"	# <exp> 1D1C"},
/* 1DB9 */ { "LETTRE MODIFICATIVE MINUSCULE V CROSSE","	# <exp> 028B"},
/* 1DBA */ { "LETTRE MODIFICATIVE MINUSCULE V CULBUTÉ","	# <exp> 028C"},
/* 1DBB */ { "LETTRE MODIFICATIVE MINUSCULE Z","	# <exp> 007A"},
/* 1DBC */ { "LETTRE MODIFICATIVE MINUSCULE Z HAMEÇON RÉTROFLEXE","	# <exp> 0290"},
/* 1DBD */ { "LETTRE MODIFICATIVE MINUSCULE Z BOUCLÉ","	# <exp> 0291"},
/* 1DBE */ { "LETTRE MODIFICATIVE MINUSCULE EJ","	# <exp> 0292"},
/* 1DBF */ { "LETTRE MODIFICATIVE MINUSCULE THÊTA","	# <exp> 03B8"},
/* 1DC0 */ { "DIACRITIQUE ACCENT GRAVE POINTÉ","	x (tréma et accent grave grecs - 1FED)"},
/* 1DC1 */ { "DIACRITIQUE ACCENT AIGU POINTÉ","	x (diacritique grec tréma accent - 0344)\n"
	"	x (tréma et accent aigu grecs - 1FEE)"},
/* 1DC2 */ { "DIACRITIQUE SERPENT SOUSCRIT",NULL},
/* 1DC3 */ { "DIACRITIQUE POINT DE SUSPENSION","	* glagolitique\n"
	"	x (diacritique brève - 0306)"},
/* 1DC4 */ { "DIACRITIQUE MACRON-AIGU",NULL},
/* 1DC5 */ { "DIACRITIQUE GRAVE-MACRON",NULL},
/* 1DC6 */ { "DIACRITIQUE MACRON-GRAVE",NULL},
/* 1DC7 */ { "DIACRITIQUE AIGU-MACRON",NULL},
/* 1DC8 */ { "DIACRITIQUE GRAVE-AIGU-GRAVE",NULL},
/* 1DC9 */ { "DIACRITIQUE AIGU-GRAVE-AIGU",NULL},
/* 1DCA */ { "DIACRITIQUE LETTRE MINUSCULE LATINE R SOUSCRITE",NULL},
/* 1DCB */ { "DIACRITIQUE BRÈVE-MACRON","	* dialectologie lituanienne"},
/* 1DCC */ { "DIACRITIQUE MACRON-BRÈVE","	* dialectologie lituanienne"},
/* 1DCD */ { "DIACRITIQUE DOUBLE CIRCONFLEXE",NULL},
/* 1DCE */ { "DIACRITIQUE OGONEK EN CHEF",NULL},
/* 1DCF */ { "DIACRITIQUE EN ZIGZAG SOUSCRIT",NULL},
/* 1DD0 */ { "DIACRITIQUE IS SOUSCRIT",NULL},
/* 1DD1 */ { "DIACRITIQUE UR SUSCRIT",NULL},
/* 1DD2 */ { "DIACRITIQUE US SUSCRIT",NULL},
/* 1DD3 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE A OUVERT APLATI SUSCRIT",NULL},
/* 1DD4 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE AE",NULL},
/* 1DD5 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE AO",NULL},
/* 1DD6 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE AV",NULL},
/* 1DD7 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE C CÉDILLE",NULL},
/* 1DD8 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE D INSULAIRE",NULL},
/* 1DD9 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE ETH",NULL},
/* 1DDA */ { "DIACRITIQUE LETTRE MINUSCULE LATINE G",NULL},
/* 1DDB */ { "DIACRITIQUE LETTRE LATINE PETITE CAPITALE G",NULL},
/* 1DDC */ { "DIACRITIQUE LETTRE MINUSCULE LATINE K",NULL},
/* 1DDD */ { "DIACRITIQUE LETTRE MINUSCULE LATINE L",NULL},
/* 1DDE */ { "DIACRITIQUE LETTRE LATINE PETITE CAPITALE L",NULL},
/* 1DDF */ { "DIACRITIQUE LETTRE LATINE PETITE CAPITALE M",NULL},
/* 1DE0 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE N",NULL},
/* 1DE1 */ { "DIACRITIQUE LETTRE LATINE PETITE CAPITALE N",NULL},
/* 1DE2 */ { "DIACRITIQUE LETTRE LATINE PETITE CAPITALE R",NULL},
/* 1DE3 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE R ROTUNDA",NULL},
/* 1DE4 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE S",NULL},
/* 1DE5 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE S LONG",NULL},
/* 1DE6 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE Z",NULL},
/* 1DE7 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE ALPHA",NULL},
/* 1DE8 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE B",NULL},
/* 1DE9 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE BÊTA",NULL},
/* 1DEA */ { "DIACRITIQUE LETTRE MINUSCULE LATINE SCHWA",NULL},
/* 1DEB */ { "DIACRITIQUE LETTRE MINUSCULE LATINE F",NULL},
/* 1DEC */ { "DIACRITIQUE LETTRE MINUSCULE LATINE L DOUBLE TILDE MÉDIAN",NULL},
/* 1DED */ { "DIACRITIQUE LETTRE MINUSCULE LATINE O À TRAIT DE CENTRALISATION LÉGER",NULL},
/* 1DEE */ { "DIACRITIQUE LETTRE MINUSCULE LATINE P",NULL},
/* 1DEF */ { "DIACRITIQUE LETTRE MINUSCULE LATINE ECH",NULL},
/* 1DF0 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE U À TRAIT DE CENTRALISATION LÉGER",NULL},
/* 1DF1 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE W",NULL},
/* 1DF2 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE A TRÉMA",NULL},
/* 1DF3 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE O TRÉMA",NULL},
/* 1DF4 */ { "DIACRITIQUE LETTRE MINUSCULE LATINE U TRÉMA",NULL},
/* 1DF5 */ { "DIACRITIQUE TAQUET HAUT",NULL},
/* 1DF6 */ { "DIACRITIQUE KAVYKA EN CHEF À DROITE",NULL},
/* 1DF7 */ { "DIACRITIQUE KAVYKA EN CHEF À GAUCHE","	x (diacritique cyrillique kavyka - A67C)"},
/* 1DF8 */ { "DIACRITIQUE POINT EN CHEF À GAUCHE","	x (diacritique point en chef à droite - 0358)"},
/* 1DF9 */ { "DIACRITIQUE PONT RENVERSÉ SOUSCRIT","	x (diacritique pontet renversé souscrit - 033A)"},
/* 1DFA */ { NULL,NULL},
/* 1DFB */ { "DIACRITIQUE DE SUPPRESSION",NULL},
/* 1DFC */ { "DIACRITIQUE DOUBLE BRÈVE CULBUTÉE",NULL},
/* 1DFD */ { "DIACRITIQUE SOUSCRIT PRESQUE ÉGAL À","	* indique une voyelle stridente dans les langues khoï"},
/* 1DFE */ { "DIACRITIQUE POINTE DE FLÈCHE VERS LA GAUCHE EN CHEF",NULL},
/* 1DFF */ { "DIACRITIQUE POINTES DE FLÈCHE VERS LA DROITE ET VERS LE BAS SOUSCRITES",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_1E[] = {
/* 1E00 */ { "LETTRE MAJUSCULE LATINE A ROND SOUSCRIT","	: 0041 0325"},
/* 1E01 */ { "LETTRE MINUSCULE LATINE A ROND SOUSCRIT","	: 0061 0325"},
/* 1E02 */ { "LETTRE MAJUSCULE LATINE B POINT EN CHEF","	: 0042 0307"},
/* 1E03 */ { "LETTRE MINUSCULE LATINE B POINT EN CHEF","	* gaélique irlandais (ancienne orthographe)\n"
	"	: 0062 0307"},
/* 1E04 */ { "LETTRE MAJUSCULE LATINE B POINT SOUSCRIT","	: 0042 0323"},
/* 1E05 */ { "LETTRE MINUSCULE LATINE B POINT SOUSCRIT","	: 0062 0323"},
/* 1E06 */ { "LETTRE MAJUSCULE LATINE B LIGNE SOUSCRITE","	: 0042 0331"},
/* 1E07 */ { "LETTRE MINUSCULE LATINE B LIGNE SOUSCRITE","	: 0062 0331"},
/* 1E08 */ { "LETTRE MAJUSCULE LATINE C CÉDILLE ET ACCENT AIGU","	: 00C7 0301"},
/* 1E09 */ { "LETTRE MINUSCULE LATINE C CÉDILLE ET ACCENT AIGU","	: 00E7 0301"},
/* 1E0A */ { "LETTRE MAJUSCULE LATINE D POINT EN CHEF","	: 0044 0307"},
/* 1E0B */ { "LETTRE MINUSCULE LATINE D POINT EN CHEF","	* gaélique irlandais (ancienne orthographe)\n"
	"	: 0064 0307"},
/* 1E0C */ { "LETTRE MAJUSCULE LATINE D POINT SOUSCRIT","	: 0044 0323"},
/* 1E0D */ { "LETTRE MINUSCULE LATINE D POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 0064 0323"},
/* 1E0E */ { "LETTRE MAJUSCULE LATINE D LIGNE SOUSCRITE","	: 0044 0331"},
/* 1E0F */ { "LETTRE MINUSCULE LATINE D LIGNE SOUSCRITE","	: 0064 0331"},
/* 1E10 */ { "LETTRE MAJUSCULE LATINE D CÉDILLE","	: 0044 0327"},
/* 1E11 */ { "LETTRE MINUSCULE LATINE D CÉDILLE","	* live\n"
	"	: 0064 0327"},
/* 1E12 */ { "LETTRE MAJUSCULE LATINE D ACCENT CIRCONFLEXE SOUSCRIT","	: 0044 032D"},
/* 1E13 */ { "LETTRE MINUSCULE LATINE D ACCENT CIRCONFLEXE SOUSCRIT","	: 0064 032D"},
/* 1E14 */ { "LETTRE MAJUSCULE LATINE E MACRON ET ACCENT GRAVE","	: 0112 0300"},
/* 1E15 */ { "LETTRE MINUSCULE LATINE E MACRON ET ACCENT GRAVE","	: 0113 0300"},
/* 1E16 */ { "LETTRE MAJUSCULE LATINE E MACRON ET ACCENT AIGU","	: 0112 0301"},
/* 1E17 */ { "LETTRE MINUSCULE LATINE E MACRON ET ACCENT AIGU","	: 0113 0301"},
/* 1E18 */ { "LETTRE MAJUSCULE LATINE E ACCENT CIRCONFLEXE SOUSCRIT","	: 0045 032D"},
/* 1E19 */ { "LETTRE MINUSCULE LATINE E ACCENT CIRCONFLEXE SOUSCRIT","	: 0065 032D"},
/* 1E1A */ { "LETTRE MAJUSCULE LATINE E TILDE SOUSCRIT","	: 0045 0330"},
/* 1E1B */ { "LETTRE MINUSCULE LATINE E TILDE SOUSCRIT","	: 0065 0330"},
/* 1E1C */ { "LETTRE MAJUSCULE LATINE E CÉDILLE ET BRÈVE","	: 0228 0306"},
/* 1E1D */ { "LETTRE MINUSCULE LATINE E CÉDILLE ET BRÈVE","	* translittération de l'hébreu\n"
	"	: 0229 0306"},
/* 1E1E */ { "LETTRE MAJUSCULE LATINE F POINT EN CHEF","	: 0046 0307"},
/* 1E1F */ { "LETTRE MINUSCULE LATINE F POINT EN CHEF","	* gaélique irlandais (ancienne orthographe)\n"
	"	: 0066 0307"},
/* 1E20 */ { "LETTRE MAJUSCULE LATINE G MACRON","	: 0047 0304"},
/* 1E21 */ { "LETTRE MINUSCULE LATINE G MACRON","	: 0067 0304"},
/* 1E22 */ { "LETTRE MAJUSCULE LATINE H POINT EN CHEF","	: 0048 0307"},
/* 1E23 */ { "LETTRE MINUSCULE LATINE H POINT EN CHEF","	: 0068 0307"},
/* 1E24 */ { "LETTRE MAJUSCULE LATINE H POINT SOUSCRIT","	: 0048 0323"},
/* 1E25 */ { "LETTRE MINUSCULE LATINE H POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 0068 0323"},
/* 1E26 */ { "LETTRE MAJUSCULE LATINE H TRÉMA","	: 0048 0308"},
/* 1E27 */ { "LETTRE MINUSCULE LATINE H TRÉMA","	: 0068 0308"},
/* 1E28 */ { "LETTRE MAJUSCULE LATINE H CÉDILLE","	: 0048 0327"},
/* 1E29 */ { "LETTRE MINUSCULE LATINE H CÉDILLE","	: 0068 0327"},
/* 1E2A */ { "LETTRE MAJUSCULE LATINE H BRÈVE SOUSCRIT","	: 0048 032E"},
/* 1E2B */ { "LETTRE MINUSCULE LATINE H BRÈVE SOUSCRIT","	* translittération des langues sémitiques\n"
	"	: 0068 032E"},
/* 1E2C */ { "LETTRE MAJUSCULE LATINE I TILDE SOUSCRIT","	: 0049 0330"},
/* 1E2D */ { "LETTRE MINUSCULE LATINE I TILDE SOUSCRIT","	: 0069 0330"},
/* 1E2E */ { "LETTRE MAJUSCULE LATINE I TRÉMA ET ACCENT AIGU","	: 00CF 0301"},
/* 1E2F */ { "LETTRE MINUSCULE LATINE I TRÉMA ET ACCENT AIGU","	: 00EF 0301"},
/* 1E30 */ { "LETTRE MAJUSCULE LATINE K ACCENT AIGU","	: 004B 0301"},
/* 1E31 */ { "LETTRE MINUSCULE LATINE K ACCENT AIGU","	* translittération du macédonien\n"
	"	: 006B 0301"},
/* 1E32 */ { "LETTRE MAJUSCULE LATINE K POINT SOUSCRIT","	: 004B 0323"},
/* 1E33 */ { "LETTRE MINUSCULE LATINE K POINT SOUSCRIT","	: 006B 0323"},
/* 1E34 */ { "LETTRE MAJUSCULE LATINE K LIGNE SOUSCRITE","	: 004B 0331"},
/* 1E35 */ { "LETTRE MINUSCULE LATINE K LIGNE SOUSCRITE","	: 006B 0331"},
/* 1E36 */ { "LETTRE MAJUSCULE LATINE L POINT SOUSCRIT","	: 004C 0323"},
/* 1E37 */ { "LETTRE MINUSCULE LATINE L POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 006C 0323\n"
	"	* voir ISO 15919 pour la distinction entre le point souscrit et le rond souscrit dans les translittérations des écritures indiennes\n"
	"	x (diacritique rond souscrit - 0325)"},
/* 1E38 */ { "LETTRE MAJUSCULE LATINE L POINT SOUSCRIT ET MACRON","	: 1E36 0304"},
/* 1E39 */ { "LETTRE MINUSCULE LATINE L POINT SOUSCRIT ET MACRON","	* translittération des langues indiennes\n"
	"	: 1E37 0304"},
/* 1E3A */ { "LETTRE MAJUSCULE LATINE L LIGNE SOUSCRITE","	: 004C 0331"},
/* 1E3B */ { "LETTRE MINUSCULE LATINE L LIGNE SOUSCRITE","	* translittération des langues indiennes\n"
	"	: 006C 0331"},
/* 1E3C */ { "LETTRE MAJUSCULE LATINE L ACCENT CIRCONFLEXE SOUSCRIT","	: 004C 032D"},
/* 1E3D */ { "LETTRE MINUSCULE LATINE L ACCENT CIRCONFLEXE SOUSCRIT","	: 006C 032D"},
/* 1E3E */ { "LETTRE MAJUSCULE LATINE M ACCENT AIGU","	: 004D 0301"},
/* 1E3F */ { "LETTRE MINUSCULE LATINE M ACCENT AIGU","	: 006D 0301"},
/* 1E40 */ { "LETTRE MAJUSCULE LATINE M POINT EN CHEF","	: 004D 0307"},
/* 1E41 */ { "LETTRE MINUSCULE LATINE M POINT EN CHEF","	* gaélique irlandais (ancienne orthographe)\n"
	"	: 006D 0307"},
/* 1E42 */ { "LETTRE MAJUSCULE LATINE M POINT SOUSCRIT","	: 004D 0323"},
/* 1E43 */ { "LETTRE MINUSCULE LATINE M POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 006D 0323"},
/* 1E44 */ { "LETTRE MAJUSCULE LATINE N POINT EN CHEF","	: 004E 0307"},
/* 1E45 */ { "LETTRE MINUSCULE LATINE N POINT EN CHEF","	* translittération des langues indiennes\n"
	"	: 006E 0307"},
/* 1E46 */ { "LETTRE MAJUSCULE LATINE N POINT SOUSCRIT","	: 004E 0323"},
/* 1E47 */ { "LETTRE MINUSCULE LATINE N POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 006E 0323"},
/* 1E48 */ { "LETTRE MAJUSCULE LATINE N LIGNE SOUSCRITE","	: 004E 0331"},
/* 1E49 */ { "LETTRE MINUSCULE LATINE N LIGNE SOUSCRITE","	* translittération des langues indiennes\n"
	"	: 006E 0331"},
/* 1E4A */ { "LETTRE MAJUSCULE LATINE N ACCENT CIRCONFLEXE SOUSCRIT","	: 004E 032D"},
/* 1E4B */ { "LETTRE MINUSCULE LATINE N ACCENT CIRCONFLEXE SOUSCRIT","	: 006E 032D"},
/* 1E4C */ { "LETTRE MAJUSCULE LATINE O TILDE ET ACCENT AIGU","	: 00D5 0301"},
/* 1E4D */ { "LETTRE MINUSCULE LATINE O TILDE ET ACCENT AIGU","	: 00F5 0301"},
/* 1E4E */ { "LETTRE MAJUSCULE LATINE O TILDE ET TRÉMA","	: 00D5 0308"},
/* 1E4F */ { "LETTRE MINUSCULE LATINE O TILDE ET TRÉMA","	: 00F5 0308"},
/* 1E50 */ { "LETTRE MAJUSCULE LATINE O MACRON ET ACCENT GRAVE","	: 014C 0300"},
/* 1E51 */ { "LETTRE MINUSCULE LATINE O MACRON ET ACCENT GRAVE","	: 014D 0300"},
/* 1E52 */ { "LETTRE MAJUSCULE LATINE O MACRON ET ACCENT AIGU","	: 014C 0301"},
/* 1E53 */ { "LETTRE MINUSCULE LATINE O MACRON ET ACCENT AIGU","	: 014D 0301"},
/* 1E54 */ { "LETTRE MAJUSCULE LATINE P ACCENT AIGU","	: 0050 0301"},
/* 1E55 */ { "LETTRE MINUSCULE LATINE P ACCENT AIGU","	: 0070 0301"},
/* 1E56 */ { "LETTRE MAJUSCULE LATINE P POINT EN CHEF","	: 0050 0307"},
/* 1E57 */ { "LETTRE MINUSCULE LATINE P POINT EN CHEF","	* gaélique irlandais (ancienne orthographe)\n"
	"	: 0070 0307"},
/* 1E58 */ { "LETTRE MAJUSCULE LATINE R POINT EN CHEF","	: 0052 0307"},
/* 1E59 */ { "LETTRE MINUSCULE LATINE R POINT EN CHEF","	: 0072 0307"},
/* 1E5A */ { "LETTRE MAJUSCULE LATINE R POINT SOUSCRIT","	: 0052 0323"},
/* 1E5B */ { "LETTRE MINUSCULE LATINE R POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 0072 0323\n"
	"	* voir ISO 15919 pour la distinction entre le point souscrit et le rond souscrit dans les translittérations des écritures indiennes\n"
	"	x (diacritique rond souscrit - 0325)"},
/* 1E5C */ { "LETTRE MAJUSCULE LATINE R POINT SOUSCRIT ET MACRON","	: 1E5A 0304"},
/* 1E5D */ { "LETTRE MINUSCULE LATINE R POINT SOUSCRIT ET MACRON","	* translittération des langues indiennes\n"
	"	: 1E5B 0304"},
/* 1E5E */ { "LETTRE MAJUSCULE LATINE R LIGNE SOUSCRITE","	: 0052 0331"},
/* 1E5F */ { "LETTRE MINUSCULE LATINE R LIGNE SOUSCRITE","	* translittération des langues indiennes\n"
	"	: 0072 0331"},
/* 1E60 */ { "LETTRE MAJUSCULE LATINE S POINT EN CHEF","	: 0053 0307"},
/* 1E61 */ { "LETTRE MINUSCULE LATINE S POINT EN CHEF","	* gaélique irlandais (ancienne orthographe)\n"
	"	: 0073 0307"},
/* 1E62 */ { "LETTRE MAJUSCULE LATINE S POINT SOUSCRIT","	: 0053 0323"},
/* 1E63 */ { "LETTRE MINUSCULE LATINE S POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 0073 0323"},
/* 1E64 */ { "LETTRE MAJUSCULE LATINE S ACCENT AIGU ET POINT EN CHEF","	: 015A 0307"},
/* 1E65 */ { "LETTRE MINUSCULE LATINE S ACCENT AIGU ET POINT EN CHEF","	: 015B 0307"},
/* 1E66 */ { "LETTRE MAJUSCULE LATINE S CARON ET POINT EN CHEF","	: 0160 0307"},
/* 1E67 */ { "LETTRE MINUSCULE LATINE S CARON ET POINT EN CHEF","	: 0161 0307"},
/* 1E68 */ { "LETTRE MAJUSCULE LATINE S POINT SOUSCRIT ET POINT EN CHEF","	: 1E62 0307"},
/* 1E69 */ { "LETTRE MINUSCULE LATINE S POINT SOUSCRIT ET POINT EN CHEF","	: 1E63 0307"},
/* 1E6A */ { "LETTRE MAJUSCULE LATINE T POINT EN CHEF","	: 0054 0307"},
/* 1E6B */ { "LETTRE MINUSCULE LATINE T POINT EN CHEF","	* gaélique irlandais (ancienne orthographe)\n"
	"	: 0074 0307"},
/* 1E6C */ { "LETTRE MAJUSCULE LATINE T POINT SOUSCRIT","	: 0054 0323"},
/* 1E6D */ { "LETTRE MINUSCULE LATINE T POINT SOUSCRIT","	* translittération des langues indiennes\n"
	"	: 0074 0323"},
/* 1E6E */ { "LETTRE MAJUSCULE LATINE T LIGNE SOUSCRITE","	: 0054 0331"},
/* 1E6F */ { "LETTRE MINUSCULE LATINE T LIGNE SOUSCRITE","	* translittération des langues sémitiques\n"
	"	: 0074 0331"},
/* 1E70 */ { "LETTRE MAJUSCULE LATINE T ACCENT CIRCONFLEXE SOUSCRIT","	: 0054 032D"},
/* 1E71 */ { "LETTRE MINUSCULE LATINE T ACCENT CIRCONFLEXE SOUSCRIT","	: 0074 032D"},
/* 1E72 */ { "LETTRE MAJUSCULE LATINE U TRÉMA SOUSCRIT","	: 0055 0324"},
/* 1E73 */ { "LETTRE MINUSCULE LATINE U TRÉMA SOUSCRIT","	: 0075 0324"},
/* 1E74 */ { "LETTRE MAJUSCULE LATINE U TILDE SOUSCRIT","	: 0055 0330"},
/* 1E75 */ { "LETTRE MINUSCULE LATINE U TILDE SOUSCRIT","	: 0075 0330"},
/* 1E76 */ { "LETTRE MAJUSCULE LATINE U ACCENT CIRCONFLEXE SOUSCRIT","	: 0055 032D"},
/* 1E77 */ { "LETTRE MINUSCULE LATINE U ACCENT CIRCONFLEXE SOUSCRIT","	: 0075 032D"},
/* 1E78 */ { "LETTRE MAJUSCULE LATINE U TILDE ET ACCENT AIGU","	: 0168 0301"},
/* 1E79 */ { "LETTRE MINUSCULE LATINE U TILDE ET ACCENT AIGU","	: 0169 0301"},
/* 1E7A */ { "LETTRE MAJUSCULE LATINE U MACRON ET TRÉMA","	: 016A 0308"},
/* 1E7B */ { "LETTRE MINUSCULE LATINE U MACRON ET TRÉMA","	: 016B 0308"},
/* 1E7C */ { "LETTRE MAJUSCULE LATINE V TILDE","	: 0056 0303"},
/* 1E7D */ { "LETTRE MINUSCULE LATINE V TILDE","	: 0076 0303"},
/* 1E7E */ { "LETTRE MAJUSCULE LATINE V POINT SOUSCRIT","	: 0056 0323"},
/* 1E7F */ { "LETTRE MINUSCULE LATINE V POINT SOUSCRIT","	: 0076 0323"},
/* 1E80 */ { "LETTRE MAJUSCULE LATINE W ACCENT GRAVE","	: 0057 0300"},
/* 1E81 */ { "LETTRE MINUSCULE LATINE W ACCENT GRAVE","	* gallois\n"
	"	: 0077 0300"},
/* 1E82 */ { "LETTRE MAJUSCULE LATINE W ACCENT AIGU","	: 0057 0301"},
/* 1E83 */ { "LETTRE MINUSCULE LATINE W ACCENT AIGU","	* gallois\n"
	"	: 0077 0301"},
/* 1E84 */ { "LETTRE MAJUSCULE LATINE W TRÉMA","	: 0057 0308"},
/* 1E85 */ { "LETTRE MINUSCULE LATINE W TRÉMA","	* gallois\n"
	"	: 0077 0308"},
/* 1E86 */ { "LETTRE MAJUSCULE LATINE W POINT EN CHEF","	: 0057 0307"},
/* 1E87 */ { "LETTRE MINUSCULE LATINE W POINT EN CHEF","	: 0077 0307"},
/* 1E88 */ { "LETTRE MAJUSCULE LATINE W POINT SOUSCRIT","	: 0057 0323"},
/* 1E89 */ { "LETTRE MINUSCULE LATINE W POINT SOUSCRIT","	: 0077 0323"},
/* 1E8A */ { "LETTRE MAJUSCULE LATINE X POINT EN CHEF","	: 0058 0307"},
/* 1E8B */ { "LETTRE MINUSCULE LATINE X POINT EN CHEF","	: 0078 0307"},
/* 1E8C */ { "LETTRE MAJUSCULE LATINE X TRÉMA","	: 0058 0308"},
/* 1E8D */ { "LETTRE MINUSCULE LATINE X TRÉMA","	: 0078 0308"},
/* 1E8E */ { "LETTRE MAJUSCULE LATINE Y POINT EN CHEF","	: 0059 0307"},
/* 1E8F */ { "LETTRE MINUSCULE LATINE Y POINT EN CHEF","	: 0079 0307"},
/* 1E90 */ { "LETTRE MAJUSCULE LATINE Z ACCENT CIRCONFLEXE","	: 005A 0302"},
/* 1E91 */ { "LETTRE MINUSCULE LATINE Z ACCENT CIRCONFLEXE","	: 007A 0302"},
/* 1E92 */ { "LETTRE MAJUSCULE LATINE Z POINT SOUSCRIT","	: 005A 0323"},
/* 1E93 */ { "LETTRE MINUSCULE LATINE Z POINT SOUSCRIT","	* translittération des langues sémitiques\n"
	"	x (lettre arabe zza' - 0638)\n"
	"	: 007A 0323"},
/* 1E94 */ { "LETTRE MAJUSCULE LATINE Z LIGNE SOUSCRITE","	: 005A 0331"},
/* 1E95 */ { "LETTRE MINUSCULE LATINE Z LIGNE SOUSCRITE","	* translittération des langues sémitiques\n"
	"	: 007A 0331"},
/* 1E96 */ { "LETTRE MINUSCULE LATINE H LIGNE SOUSCRITE","	* translittération des langues sémitiques\n"
	"	: 0068 0331"},
/* 1E97 */ { "LETTRE MINUSCULE LATINE T TRÉMA","	: 0074 0308"},
/* 1E98 */ { "LETTRE MINUSCULE LATINE W ROND EN CHEF","	: 0077 030A"},
/* 1E99 */ { "LETTRE MINUSCULE LATINE Y ROND EN CHEF","	: 0079 030A"},
/* 1E9A */ { "LETTRE MINUSCULE LATINE A DEMI-ROND DROIT","	# 0061 02BE"},
/* 1E9B */ { "LETTRE MINUSCULE LATINE LONG S POINT EN CHEF","	* s'utilise actuellement en gaélique (variante de glyphe de 1E61)\n"
	"	: 017F 0307"},
/* 1E9C */ { "LETTRE MINUSCULE LATINE S LONG À BARRE DIAGONALE","	* usage médiéviste pour plusieurs abréviations\n"
	"	* utilisée dans l'orthographe lettone d'avant 1921\n"
	"	* utilisée dans les polices gothiques de l'orthographe du bas-sorabe d'avant 1950\n"
	"	x (lettre minuscule latine s barre oblique - A7A9)"},
/* 1E9D */ { "LETTRE MINUSCULE LATINE S LONG À BARRE HAUTE",NULL},
/* 1E9E */ { "LETTRE MAJUSCULE LATINE S DUR","	* la minuscule est 00DF\n"
	"	x (lettre minuscule latine s dur - 00DF)"},
/* 1E9F */ { "LETTRE MINUSCULE LATINE DELTA",NULL},
/* 1EA0 */ { "LETTRE MAJUSCULE LATINE A POINT SOUSCRIT","	: 0041 0323"},
/* 1EA1 */ { "LETTRE MINUSCULE LATINE A POINT SOUSCRIT","	: 0061 0323"},
/* 1EA2 */ { "LETTRE MAJUSCULE LATINE A CROCHET EN CHEF","	: 0041 0309"},
/* 1EA3 */ { "LETTRE MINUSCULE LATINE A CROCHET EN CHEF","	: 0061 0309"},
/* 1EA4 */ { "LETTRE MAJUSCULE LATINE A ACCENT CIRCONFLEXE ET ACCENT AIGU","	: 00C2 0301"},
/* 1EA5 */ { "LETTRE MINUSCULE LATINE A ACCENT CIRCONFLEXE ET ACCENT AIGU","	: 00E2 0301"},
/* 1EA6 */ { "LETTRE MAJUSCULE LATINE A ACCENT CIRCONFLEXE ET ACCENT GRAVE","	: 00C2 0300"},
/* 1EA7 */ { "LETTRE MINUSCULE LATINE A ACCENT CIRCONFLEXE ET ACCENT GRAVE","	: 00E2 0300"},
/* 1EA8 */ { "LETTRE MAJUSCULE LATINE A ACCENT CIRCONFLEXE ET CROCHET EN CHEF","	: 00C2 0309"},
/* 1EA9 */ { "LETTRE MINUSCULE LATINE A ACCENT CIRCONFLEXE ET CROCHET EN CHEF","	: 00E2 0309"},
/* 1EAA */ { "LETTRE MAJUSCULE LATINE A ACCENT CIRCONFLEXE ET TILDE","	: 00C2 0303"},
/* 1EAB */ { "LETTRE MINUSCULE LATINE A ACCENT CIRCONFLEXE ET TILDE","	: 00E2 0303"},
/* 1EAC */ { "LETTRE MAJUSCULE LATINE A ACCENT CIRCONFLEXE ET POINT SOUSCRIT","	: 1EA0 0302"},
/* 1EAD */ { "LETTRE MINUSCULE LATINE A ACCENT CIRCONFLEXE ET POINT SOUSCRIT","	: 1EA1 0302"},
/* 1EAE */ { "LETTRE MAJUSCULE LATINE A BRÈVE ET ACCENT AIGU","	: 0102 0301"},
/* 1EAF */ { "LETTRE MINUSCULE LATINE A BRÈVE ET ACCENT AIGU","	: 0103 0301"},
/* 1EB0 */ { "LETTRE MAJUSCULE LATINE A BRÈVE ET ACCENT GRAVE","	: 0102 0300"},
/* 1EB1 */ { "LETTRE MINUSCULE LATINE A BRÈVE ET ACCENT GRAVE","	: 0103 0300"},
/* 1EB2 */ { "LETTRE MAJUSCULE LATINE A BRÈVE ET CROCHET EN CHEF","	: 0102 0309"},
/* 1EB3 */ { "LETTRE MINUSCULE LATINE A BRÈVE ET CROCHET EN CHEF","	: 0103 0309"},
/* 1EB4 */ { "LETTRE MAJUSCULE LATINE A BRÈVE ET TILDE","	: 0102 0303"},
/* 1EB5 */ { "LETTRE MINUSCULE LATINE A BRÈVE ET TILDE","	: 0103 0303"},
/* 1EB6 */ { "LETTRE MAJUSCULE LATINE A BRÈVE ET POINT SOUSCRIT","	: 1EA0 0306"},
/* 1EB7 */ { "LETTRE MINUSCULE LATINE A BRÈVE ET POINT SOUSCRIT","	: 1EA1 0306"},
/* 1EB8 */ { "LETTRE MAJUSCULE LATINE E POINT SOUSCRIT","	: 0045 0323"},
/* 1EB9 */ { "LETTRE MINUSCULE LATINE E POINT SOUSCRIT","	: 0065 0323"},
/* 1EBA */ { "LETTRE MAJUSCULE LATINE E CROCHET EN CHEF","	: 0045 0309"},
/* 1EBB */ { "LETTRE MINUSCULE LATINE E CROCHET EN CHEF","	: 0065 0309"},
/* 1EBC */ { "LETTRE MAJUSCULE LATINE E TILDE","	: 0045 0303"},
/* 1EBD */ { "LETTRE MINUSCULE LATINE E TILDE","	: 0065 0303"},
/* 1EBE */ { "LETTRE MAJUSCULE LATINE E ACCENT CIRCONFLEXE ET ACCENT AIGU","	: 00CA 0301"},
/* 1EBF */ { "LETTRE MINUSCULE LATINE E ACCENT CIRCONFLEXE ET ACCENT AIGU","	: 00EA 0301"},
/* 1EC0 */ { "LETTRE MAJUSCULE LATINE E ACCENT CIRCONFLEXE ET ACCENT GRAVE","	: 00CA 0300"},
/* 1EC1 */ { "LETTRE MINUSCULE LATINE E ACCENT CIRCONFLEXE ET ACCENT GRAVE","	: 00EA 0300"},
/* 1EC2 */ { "LETTRE MAJUSCULE LATINE E ACCENT CIRCONFLEXE ET CROCHET EN CHEF","	: 00CA 0309"},
/* 1EC3 */ { "LETTRE MINUSCULE LATINE E ACCENT CIRCONFLEXE ET CROCHET EN CHEF","	: 00EA 0309"},
/* 1EC4 */ { "LETTRE MAJUSCULE LATINE E ACCENT CIRCONFLEXE ET TILDE","	: 00CA 0303"},
/* 1EC5 */ { "LETTRE MINUSCULE LATINE E ACCENT CIRCONFLEXE ET TILDE","	: 00EA 0303"},
/* 1EC6 */ { "LETTRE MAJUSCULE LATINE E ACCENT CIRCONFLEXE ET POINT SOUSCRIT","	: 1EB8 0302"},
/* 1EC7 */ { "LETTRE MINUSCULE LATINE E ACCENT CIRCONFLEXE ET POINT SOUSCRIT","	: 1EB9 0302"},
/* 1EC8 */ { "LETTRE MAJUSCULE LATINE I CROCHET EN CHEF","	: 0049 0309"},
/* 1EC9 */ { "LETTRE MINUSCULE LATINE I CROCHET EN CHEF","	: 0069 0309"},
/* 1ECA */ { "LETTRE MAJUSCULE LATINE I POINT SOUSCRIT","	: 0049 0323"},
/* 1ECB */ { "LETTRE MINUSCULE LATINE I POINT SOUSCRIT","	: 0069 0323"},
/* 1ECC */ { "LETTRE MAJUSCULE LATINE O POINT SOUSCRIT","	: 004F 0323"},
/* 1ECD */ { "LETTRE MINUSCULE LATINE O POINT SOUSCRIT","	: 006F 0323"},
/* 1ECE */ { "LETTRE MAJUSCULE LATINE O CROCHET EN CHEF","	: 004F 0309"},
/* 1ECF */ { "LETTRE MINUSCULE LATINE O CROCHET EN CHEF","	: 006F 0309"},
/* 1ED0 */ { "LETTRE MAJUSCULE LATINE O ACCENT CIRCONFLEXE ET ACCENT AIGU","	: 00D4 0301"},
/* 1ED1 */ { "LETTRE MINUSCULE LATINE O ACCENT CIRCONFLEXE ET ACCENT AIGU","	: 00F4 0301"},
/* 1ED2 */ { "LETTRE MAJUSCULE LATINE O ACCENT CIRCONFLEXE ET ACCENT GRAVE","	: 00D4 0300"},
/* 1ED3 */ { "LETTRE MINUSCULE LATINE O ACCENT CIRCONFLEXE ET ACCENT GRAVE","	: 00F4 0300"},
/* 1ED4 */ { "LETTRE MAJUSCULE LATINE O ACCENT CIRCONFLEXE ET CROCHET EN CHEF","	: 00D4 0309"},
/* 1ED5 */ { "LETTRE MINUSCULE LATINE O ACCENT CIRCONFLEXE ET CROCHET EN CHEF","	: 00F4 0309"},
/* 1ED6 */ { "LETTRE MAJUSCULE LATINE O ACCENT CIRCONFLEXE ET TILDE","	: 00D4 0303"},
/* 1ED7 */ { "LETTRE MINUSCULE LATINE O ACCENT CIRCONFLEXE ET TILDE","	: 00F4 0303"},
/* 1ED8 */ { "LETTRE MAJUSCULE LATINE O ACCENT CIRCONFLEXE ET POINT SOUSCRIT","	: 1ECC 0302"},
/* 1ED9 */ { "LETTRE MINUSCULE LATINE O ACCENT CIRCONFLEXE ET POINT SOUSCRIT","	: 1ECD 0302"},
/* 1EDA */ { "LETTRE MAJUSCULE LATINE O CORNU ACCENT AIGU","	: 01A0 0301"},
/* 1EDB */ { "LETTRE MINUSCULE LATINE O CORNU ACCENT AIGU","	: 01A1 0301"},
/* 1EDC */ { "LETTRE MAJUSCULE LATINE O CORNU ACCENT GRAVE","	: 01A0 0300"},
/* 1EDD */ { "LETTRE MINUSCULE LATINE O CORNU ACCENT GRAVE","	: 01A1 0300"},
/* 1EDE */ { "LETTRE MAJUSCULE LATINE O CORNU CROCHET EN CHEF","	: 01A0 0309"},
/* 1EDF */ { "LETTRE MINUSCULE LATINE O CORNU CROCHET EN CHEF","	: 01A1 0309"},
/* 1EE0 */ { "LETTRE MAJUSCULE LATINE O CORNU TILDE","	: 01A0 0303"},
/* 1EE1 */ { "LETTRE MINUSCULE LATINE O CORNU TILDE","	: 01A1 0303"},
/* 1EE2 */ { "LETTRE MAJUSCULE LATINE O CORNU POINT SOUSCRIT","	: 01A0 0323"},
/* 1EE3 */ { "LETTRE MINUSCULE LATINE O CORNU POINT SOUSCRIT","	: 01A1 0323"},
/* 1EE4 */ { "LETTRE MAJUSCULE LATINE U POINT SOUSCRIT","	: 0055 0323"},
/* 1EE5 */ { "LETTRE MINUSCULE LATINE U POINT SOUSCRIT","	: 0075 0323"},
/* 1EE6 */ { "LETTRE MAJUSCULE LATINE U CROCHET EN CHEF","	: 0055 0309"},
/* 1EE7 */ { "LETTRE MINUSCULE LATINE U CROCHET EN CHEF","	: 0075 0309"},
/* 1EE8 */ { "LETTRE MAJUSCULE LATINE U CORNU ACCENT AIGU","	: 01AF 0301"},
/* 1EE9 */ { "LETTRE MINUSCULE LATINE U CORNU ACCENT AIGU","	: 01B0 0301"},
/* 1EEA */ { "LETTRE MAJUSCULE LATINE U CORNU ACCENT GRAVE","	: 01AF 0300"},
/* 1EEB */ { "LETTRE MINUSCULE LATINE U CORNU ACCENT GRAVE","	: 01B0 0300"},
/* 1EEC */ { "LETTRE MAJUSCULE LATINE U CORNU CROCHET EN CHEF","	: 01AF 0309"},
/* 1EED */ { "LETTRE MINUSCULE LATINE U CORNU CROCHET EN CHEF","	: 01B0 0309"},
/* 1EEE */ { "LETTRE MAJUSCULE LATINE U CORNU TILDE","	: 01AF 0303"},
/* 1EEF */ { "LETTRE MINUSCULE LATINE U CORNU TILDE","	: 01B0 0303"},
/* 1EF0 */ { "LETTRE MAJUSCULE LATINE U CORNU POINT SOUSCRIT","	: 01AF 0323"},
/* 1EF1 */ { "LETTRE MINUSCULE LATINE U CORNU POINT SOUSCRIT","	: 01B0 0323"},
/* 1EF2 */ { "LETTRE MAJUSCULE LATINE Y ACCENT GRAVE","	: 0059 0300"},
/* 1EF3 */ { "LETTRE MINUSCULE LATINE Y ACCENT GRAVE","	* gallois\n"
	"	: 0079 0300"},
/* 1EF4 */ { "LETTRE MAJUSCULE LATINE Y POINT SOUSCRIT","	: 0059 0323"},
/* 1EF5 */ { "LETTRE MINUSCULE LATINE Y POINT SOUSCRIT","	: 0079 0323"},
/* 1EF6 */ { "LETTRE MAJUSCULE LATINE Y CROCHET EN CHEF","	: 0059 0309"},
/* 1EF7 */ { "LETTRE MINUSCULE LATINE Y CROCHET EN CHEF","	: 0079 0309"},
/* 1EF8 */ { "LETTRE MAJUSCULE LATINE Y TILDE","	: 0059 0303"},
/* 1EF9 */ { "LETTRE MINUSCULE LATINE Y TILDE","	: 0079 0303"},
/* 1EFA */ { "LETTRE MAJUSCULE LATINE LL MOYEN GALLOIS",NULL},
/* 1EFB */ { "LETTRE MINUSCULE LATINE LL MOYEN GALLOIS",NULL},
/* 1EFC */ { "LETTRE MAJUSCULE LATINE V MOYEN GALLOIS",NULL},
/* 1EFD */ { "LETTRE MINUSCULE LATINE V MOYEN GALLOIS",NULL},
/* 1EFE */ { "LETTRE MAJUSCULE LATINE Y BOUCLÉ",NULL},
/* 1EFF */ { "LETTRE MINUSCULE LATINE Y BOUCLÉ",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_1F[] = {
/* 1F00 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX","	: 03B1 0313"},
/* 1F01 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE","	: 03B1 0314"},
/* 1F02 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX ET ACCENT GRAVE","	: 1F00 0300"},
/* 1F03 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE ET ACCENT GRAVE","	: 1F01 0300"},
/* 1F04 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX ET ACCENT AIGU","	: 1F00 0301"},
/* 1F05 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE ET ACCENT AIGU","	: 1F01 0301"},
/* 1F06 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX ET CIRCONFLEXE","	: 1F00 0342"},
/* 1F07 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE ET CIRCONFLEXE","	: 1F01 0342"},
/* 1F08 */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX","	: 0391 0313"},
/* 1F09 */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE","	: 0391 0314"},
/* 1F0A */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX ET ACCENT GRAVE","	: 1F08 0300"},
/* 1F0B */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE ET ACCENT GRAVE","	: 1F09 0300"},
/* 1F0C */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX ET ACCENT AIGU","	: 1F08 0301"},
/* 1F0D */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE ET ACCENT AIGU","	: 1F09 0301"},
/* 1F0E */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX ET CIRCONFLEXE","	: 1F08 0342"},
/* 1F0F */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE ET CIRCONFLEXE","	: 1F09 0342"},
/* 1F10 */ { "LETTRE MINUSCULE GRECQUE EPSILON ESPRIT DOUX","	: 03B5 0313"},
/* 1F11 */ { "LETTRE MINUSCULE GRECQUE EPSILON ESPRIT RUDE","	: 03B5 0314"},
/* 1F12 */ { "LETTRE MINUSCULE GRECQUE EPSILON ESPRIT DOUX ET ACCENT GRAVE","	: 1F10 0300"},
/* 1F13 */ { "LETTRE MINUSCULE GRECQUE EPSILON ESPRIT RUDE ET ACCENT GRAVE","	: 1F11 0300"},
/* 1F14 */ { "LETTRE MINUSCULE GRECQUE EPSILON ESPRIT DOUX ET ACCENT AIGU","	: 1F10 0301"},
/* 1F15 */ { "LETTRE MINUSCULE GRECQUE EPSILON ESPRIT RUDE ET ACCENT AIGU","	: 1F11 0301"},
/* 1F16 */ { NULL,NULL},
/* 1F17 */ { NULL,NULL},
/* 1F18 */ { "LETTRE MAJUSCULE GRECQUE EPSILON ESPRIT DOUX","	: 0395 0313"},
/* 1F19 */ { "LETTRE MAJUSCULE GRECQUE EPSILON ESPRIT RUDE","	: 0395 0314"},
/* 1F1A */ { "LETTRE MAJUSCULE GRECQUE EPSILON ESPRIT DOUX ET ACCENT GRAVE","	: 1F18 0300"},
/* 1F1B */ { "LETTRE MAJUSCULE GRECQUE EPSILON ESPRIT RUDE ET ACCENT GRAVE","	: 1F19 0300"},
/* 1F1C */ { "LETTRE MAJUSCULE GRECQUE EPSILON ESPRIT DOUX ET ACCENT AIGU","	: 1F18 0301"},
/* 1F1D */ { "LETTRE MAJUSCULE GRECQUE EPSILON ESPRIT RUDE ET ACCENT AIGU","	: 1F19 0301"},
/* 1F1E */ { NULL,NULL},
/* 1F1F */ { NULL,NULL},
/* 1F20 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX","	: 03B7 0313"},
/* 1F21 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE","	: 03B7 0314"},
/* 1F22 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX ET ACCENT GRAVE","	: 1F20 0300"},
/* 1F23 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE ET ACCENT GRAVE","	: 1F21 0300"},
/* 1F24 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX ET ACCENT AIGU","	: 1F20 0301"},
/* 1F25 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE ET ACCENT AIGU","	: 1F21 0301"},
/* 1F26 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX ET CIRCONFLEXE","	: 1F20 0342"},
/* 1F27 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE ET CIRCONFLEXE","	: 1F21 0342"},
/* 1F28 */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX","	: 0397 0313"},
/* 1F29 */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE","	: 0397 0314"},
/* 1F2A */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX ET ACCENT GRAVE","	: 1F28 0300"},
/* 1F2B */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE ET ACCENT GRAVE","	: 1F29 0300"},
/* 1F2C */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX ET ACCENT AIGU","	: 1F28 0301"},
/* 1F2D */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE ET ACCENT AIGU","	: 1F29 0301"},
/* 1F2E */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX ET CIRCONFLEXE","	: 1F28 0342"},
/* 1F2F */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE ET CIRCONFLEXE","	: 1F29 0342"},
/* 1F30 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT DOUX","	: 03B9 0313"},
/* 1F31 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT RUDE","	: 03B9 0314"},
/* 1F32 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT DOUX ET ACCENT GRAVE","	: 1F30 0300"},
/* 1F33 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT RUDE ET ACCENT GRAVE","	: 1F31 0300"},
/* 1F34 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT DOUX ET ACCENT AIGU","	: 1F30 0301"},
/* 1F35 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT RUDE ET ACCENT AIGU","	: 1F31 0301"},
/* 1F36 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT DOUX ET CIRCONFLEXE","	: 1F30 0342"},
/* 1F37 */ { "LETTRE MINUSCULE GRECQUE IOTA ESPRIT RUDE ET CIRCONFLEXE","	: 1F31 0342"},
/* 1F38 */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT DOUX","	: 0399 0313"},
/* 1F39 */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT RUDE","	: 0399 0314"},
/* 1F3A */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT DOUX ET ACCENT GRAVE","	: 1F38 0300"},
/* 1F3B */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT RUDE ET ACCENT GRAVE","	: 1F39 0300"},
/* 1F3C */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT DOUX ET ACCENT AIGU","	: 1F38 0301"},
/* 1F3D */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT RUDE ET ACCENT AIGU","	: 1F39 0301"},
/* 1F3E */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT DOUX ET CIRCONFLEXE","	: 1F38 0342"},
/* 1F3F */ { "LETTRE MAJUSCULE GRECQUE IOTA ESPRIT RUDE ET CIRCONFLEXE","	: 1F39 0342"},
/* 1F40 */ { "LETTRE MINUSCULE GRECQUE OMICRON ESPRIT DOUX","	: 03BF 0313"},
/* 1F41 */ { "LETTRE MINUSCULE GRECQUE OMICRON ESPRIT RUDE","	: 03BF 0314"},
/* 1F42 */ { "LETTRE MINUSCULE GRECQUE OMICRON ESPRIT DOUX ET ACCENT GRAVE","	: 1F40 0300"},
/* 1F43 */ { "LETTRE MINUSCULE GRECQUE OMICRON ESPRIT RUDE ET ACCENT GRAVE","	: 1F41 0300"},
/* 1F44 */ { "LETTRE MINUSCULE GRECQUE OMICRON ESPRIT DOUX ET ACCENT AIGU","	: 1F40 0301"},
/* 1F45 */ { "LETTRE MINUSCULE GRECQUE OMICRON ESPRIT RUDE ET ACCENT AIGU","	: 1F41 0301"},
/* 1F46 */ { NULL,NULL},
/* 1F47 */ { NULL,NULL},
/* 1F48 */ { "LETTRE MAJUSCULE GRECQUE OMICRON ESPRIT DOUX","	: 039F 0313"},
/* 1F49 */ { "LETTRE MAJUSCULE GRECQUE OMICRON ESPRIT RUDE","	: 039F 0314"},
/* 1F4A */ { "LETTRE MAJUSCULE GRECQUE OMICRON ESPRIT DOUX ET ACCENT GRAVE","	: 1F48 0300"},
/* 1F4B */ { "LETTRE MAJUSCULE GRECQUE OMICRON ESPRIT RUDE ET ACCENT GRAVE","	: 1F49 0300"},
/* 1F4C */ { "LETTRE MAJUSCULE GRECQUE OMICRON ESPRIT DOUX ET ACCENT AIGU","	: 1F48 0301"},
/* 1F4D */ { "LETTRE MAJUSCULE GRECQUE OMICRON ESPRIT RUDE ET ACCENT AIGU","	: 1F49 0301"},
/* 1F4E */ { NULL,NULL},
/* 1F4F */ { NULL,NULL},
/* 1F50 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT DOUX","	: 03C5 0313"},
/* 1F51 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT RUDE","	: 03C5 0314"},
/* 1F52 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT DOUX ET ACCENT GRAVE","	: 1F50 0300"},
/* 1F53 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT RUDE ET ACCENT GRAVE","	: 1F51 0300"},
/* 1F54 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT DOUX ET ACCENT AIGU","	: 1F50 0301"},
/* 1F55 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT RUDE ET ACCENT AIGU","	: 1F51 0301"},
/* 1F56 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT DOUX ET CIRCONFLEXE","	: 1F50 0342"},
/* 1F57 */ { "LETTRE MINUSCULE GRECQUE UPSILON ESPRIT RUDE ET CIRCONFLEXE","	: 1F51 0342"},
/* 1F58 */ { NULL,NULL},
/* 1F59 */ { "LETTRE MAJUSCULE GRECQUE UPSILON ESPRIT RUDE","	: 03A5 0314"},
/* 1F5A */ { NULL,NULL},
/* 1F5B */ { "LETTRE MAJUSCULE GRECQUE UPSILON ESPRIT RUDE ET ACCENT GRAVE","	: 1F59 0300"},
/* 1F5C */ { NULL,NULL},
/* 1F5D */ { "LETTRE MAJUSCULE GRECQUE UPSILON ESPRIT RUDE ET ACCENT AIGU","	: 1F59 0301"},
/* 1F5E */ { NULL,NULL},
/* 1F5F */ { "LETTRE MAJUSCULE GRECQUE UPSILON ESPRIT RUDE ET CIRCONFLEXE","	: 1F59 0342"},
/* 1F60 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX","	: 03C9 0313"},
/* 1F61 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE","	: 03C9 0314"},
/* 1F62 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX ET ACCENT GRAVE","	: 1F60 0300"},
/* 1F63 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE ET ACCENT GRAVE","	: 1F61 0300"},
/* 1F64 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX ET ACCENT AIGU","	: 1F60 0301"},
/* 1F65 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE ET ACCENT AIGU","	: 1F61 0301"},
/* 1F66 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX ET CIRCONFLEXE","	: 1F60 0342"},
/* 1F67 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE ET CIRCONFLEXE","	: 1F61 0342"},
/* 1F68 */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX","	: 03A9 0313"},
/* 1F69 */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE","	: 03A9 0314"},
/* 1F6A */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX ET ACCENT GRAVE","	: 1F68 0300"},
/* 1F6B */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE ET ACCENT GRAVE","	: 1F69 0300"},
/* 1F6C */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX ET ACCENT AIGU","	: 1F68 0301"},
/* 1F6D */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE ET ACCENT AIGU","	: 1F69 0301"},
/* 1F6E */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX ET CIRCONFLEXE","	: 1F68 0342"},
/* 1F6F */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE ET CIRCONFLEXE","	: 1F69 0342"},
/* 1F70 */ { "LETTRE MINUSCULE GRECQUE ALPHA ACCENT GRAVE","	: 03B1 0300"},
/* 1F71 */ { "LETTRE MINUSCULE GRECQUE ALPHA ACCENT AIGU","	: 03AC lettre minuscule grecque alpha accent"},
/* 1F72 */ { "LETTRE MINUSCULE GRECQUE EPSILON ACCENT GRAVE","	: 03B5 0300"},
/* 1F73 */ { "LETTRE MINUSCULE GRECQUE EPSILON ACCENT AIGU","	: 03AD lettre minuscule grecque epsilon accent"},
/* 1F74 */ { "LETTRE MINUSCULE GRECQUE ÊTA ACCENT GRAVE","	: 03B7 0300"},
/* 1F75 */ { "LETTRE MINUSCULE GRECQUE ÊTA ACCENT AIGU","	: 03AE lettre minuscule grecque êta accent"},
/* 1F76 */ { "LETTRE MINUSCULE GRECQUE IOTA ACCENT GRAVE","	: 03B9 0300"},
/* 1F77 */ { "LETTRE MINUSCULE GRECQUE IOTA ACCENT AIGU","	: 03AF lettre minuscule grecque iota accent"},
/* 1F78 */ { "LETTRE MINUSCULE GRECQUE OMICRON ACCENT GRAVE","	: 03BF 0300"},
/* 1F79 */ { "LETTRE MINUSCULE GRECQUE OMICRON ACCENT AIGU","	: 03CC lettre minuscule grecque omicron accent"},
/* 1F7A */ { "LETTRE MINUSCULE GRECQUE UPSILON ACCENT GRAVE","	: 03C5 0300"},
/* 1F7B */ { "LETTRE MINUSCULE GRECQUE UPSILON ACCENT AIGU","	: 03CD lettre minuscule grecque upsilon accent"},
/* 1F7C */ { "LETTRE MINUSCULE GRECQUE OMÉGA ACCENT GRAVE","	: 03C9 0300"},
/* 1F7D */ { "LETTRE MINUSCULE GRECQUE OMÉGA ACCENT AIGU","	: 03CE lettre minuscule grecque oméga accent"},
/* 1F7E */ { NULL,NULL},
/* 1F7F */ { NULL,NULL},
/* 1F80 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX IOTA SOUSCRIT","	: 1F00 0345"},
/* 1F81 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE IOTA SOUSCRIT","	: 1F01 0345"},
/* 1F82 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F02 0345"},
/* 1F83 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F03 0345"},
/* 1F84 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX ACCENT AIGU ET IOTA SOUSCRIT","	: 1F04 0345"},
/* 1F85 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE ACCENT AIGU ET IOTA SOUSCRIT","	: 1F05 0345"},
/* 1F86 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT DOUX CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F06 0345"},
/* 1F87 */ { "LETTRE MINUSCULE GRECQUE ALPHA ESPRIT RUDE CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F07 0345"},
/* 1F88 */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX IOTA SOUSCRIT","	: 1F08 0345"},
/* 1F89 */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE IOTA SOUSCRIT","	: 1F09 0345"},
/* 1F8A */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F0A 0345"},
/* 1F8B */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F0B 0345"},
/* 1F8C */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX ACCENT AIGU ET IOTA SOUSCRIT","	: 1F0C 0345"},
/* 1F8D */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE ACCENT AIGU ET IOTA SOUSCRIT","	: 1F0D 0345"},
/* 1F8E */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT DOUX CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F0E 0345"},
/* 1F8F */ { "LETTRE MAJUSCULE GRECQUE ALPHA ESPRIT RUDE CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F0F 0345"},
/* 1F90 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX IOTA SOUSCRIT","	: 1F20 0345"},
/* 1F91 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE IOTA SOUSCRIT","	: 1F21 0345"},
/* 1F92 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F22 0345"},
/* 1F93 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F23 0345"},
/* 1F94 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX ACCENT AIGU ET IOTA SOUSCRIT","	: 1F24 0345"},
/* 1F95 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE ACCENT AIGU ET IOTA SOUSCRIT","	: 1F25 0345"},
/* 1F96 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT DOUX CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F26 0345"},
/* 1F97 */ { "LETTRE MINUSCULE GRECQUE ÊTA ESPRIT RUDE CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F27 0345"},
/* 1F98 */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX IOTA SOUSCRIT","	: 1F28 0345"},
/* 1F99 */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE IOTA SOUSCRIT","	: 1F29 0345"},
/* 1F9A */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F2A 0345"},
/* 1F9B */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F2B 0345"},
/* 1F9C */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX ACCENT AIGU ET IOTA SOUSCRIT","	: 1F2C 0345"},
/* 1F9D */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE ACCENT AIGU ET IOTA SOUSCRIT","	: 1F2D 0345"},
/* 1F9E */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT DOUX CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F2E 0345"},
/* 1F9F */ { "LETTRE MAJUSCULE GRECQUE ÊTA ESPRIT RUDE CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F2F 0345"},
/* 1FA0 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX IOTA SOUSCRIT","	: 1F60 0345"},
/* 1FA1 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE IOTA SOUSCRIT","	: 1F61 0345"},
/* 1FA2 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F62 0345"},
/* 1FA3 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F63 0345"},
/* 1FA4 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX ACCENT AIGU ET IOTA SOUSCRIT","	: 1F64 0345"},
/* 1FA5 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE ACCENT AIGU ET IOTA SOUSCRIT","	: 1F65 0345"},
/* 1FA6 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT DOUX CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F66 0345"},
/* 1FA7 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ESPRIT RUDE CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F67 0345"},
/* 1FA8 */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX IOTA SOUSCRIT","	: 1F68 0345"},
/* 1FA9 */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE IOTA SOUSCRIT","	: 1F69 0345"},
/* 1FAA */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F6A 0345"},
/* 1FAB */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE ACCENT GRAVE ET IOTA SOUSCRIT","	: 1F6B 0345"},
/* 1FAC */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX ACCENT AIGU ET IOTA SOUSCRIT","	: 1F6C 0345"},
/* 1FAD */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE ACCENT AIGU ET IOTA SOUSCRIT","	: 1F6D 0345"},
/* 1FAE */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT DOUX CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F6E 0345"},
/* 1FAF */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ESPRIT RUDE CIRCONFLEXE ET IOTA SOUSCRIT","	: 1F6F 0345"},
/* 1FB0 */ { "LETTRE MINUSCULE GRECQUE ALPHA BRÈVE","	: 03B1 0306"},
/* 1FB1 */ { "LETTRE MINUSCULE GRECQUE ALPHA MACRON","	: 03B1 0304"},
/* 1FB2 */ { "LETTRE MINUSCULE GRECQUE ALPHA ACCENT GRAVE IOTA SOUSCRIT","	: 1F70 0345"},
/* 1FB3 */ { "LETTRE MINUSCULE GRECQUE ALPHA IOTA SOUSCRIT","	: 03B1 0345"},
/* 1FB4 */ { "LETTRE MINUSCULE GRECQUE ALPHA ACCENT AIGU IOTA SOUSCRIT","	: 03AC 0345"},
/* 1FB5 */ { NULL,NULL},
/* 1FB6 */ { "LETTRE MINUSCULE GRECQUE ALPHA CIRCONFLEXE","	: 03B1 0342"},
/* 1FB7 */ { "LETTRE MINUSCULE GRECQUE ALPHA CIRCONFLEXE IOTA SOUSCRIT","	: 1FB6 0345"},
/* 1FB8 */ { "LETTRE MAJUSCULE GRECQUE ALPHA BRÈVE","	: 0391 0306"},
/* 1FB9 */ { "LETTRE MAJUSCULE GRECQUE ALPHA MACRON","	: 0391 0304"},
/* 1FBA */ { "LETTRE MAJUSCULE GRECQUE ALPHA ACCENT GRAVE","	: 0391 0300"},
/* 1FBB */ { "LETTRE MAJUSCULE GRECQUE ALPHA ACCENT AIGU","	: 0386 lettre majuscule grecque alpha accent"},
/* 1FBC */ { "LETTRE MAJUSCULE GRECQUE ALPHA IOTA SOUSCRIT","	: 0391 0345"},
/* 1FBD */ { "CORONIS GRECQUE","	# 0020 0313"},
/* 1FBE */ { "IOTA GREC SOUSCRIT","	: 03B9 lettre minuscule grecque iota"},
/* 1FBF */ { "ESPRIT DOUX GREC","	x (lettre modificative apostrophe - 02BC)\n"
	"	# 0020 0313"},
/* 1FC0 */ { "ACCENT CIRCONFLEXE GREC","	# 0020 0342"},
/* 1FC1 */ { "TRÉMA ET ACCENT CIRCONFLEXE GRECS","	: 00A8 0342"},
/* 1FC2 */ { "LETTRE MINUSCULE GRECQUE ÊTA ACCENT GRAVE IOTA SOUSCRIT","	: 1F74 0345"},
/* 1FC3 */ { "LETTRE MINUSCULE GRECQUE ÊTA IOTA SOUSCRIT","	: 03B7 0345"},
/* 1FC4 */ { "LETTRE MINUSCULE GRECQUE ÊTA ACCENT AIGU IOTA SOUSCRIT","	: 03AE 0345"},
/* 1FC5 */ { NULL,NULL},
/* 1FC6 */ { "LETTRE MINUSCULE GRECQUE ÊTA CIRCONFLEXE","	: 03B7 0342"},
/* 1FC7 */ { "LETTRE MINUSCULE GRECQUE ÊTA CIRCONFLEXE IOTA SOUSCRIT","	: 1FC6 0345"},
/* 1FC8 */ { "LETTRE MAJUSCULE GRECQUE EPSILON ACCENT GRAVE","	: 0395 0300"},
/* 1FC9 */ { "LETTRE MAJUSCULE GRECQUE EPSILON ACCENT AIGU","	: 0388 lettre majuscule grecque epsilon accent"},
/* 1FCA */ { "LETTRE MAJUSCULE GRECQUE ÊTA ACCENT GRAVE","	: 0397 0300"},
/* 1FCB */ { "LETTRE MAJUSCULE GRECQUE ÊTA ACCENT AIGU","	: 0389 lettre majuscule grecque êta accent"},
/* 1FCC */ { "LETTRE MAJUSCULE GRECQUE ÊTA IOTA SOUSCRIT","	: 0397 0345"},
/* 1FCD */ { "ESPRIT DOUX ET ACCENT GRAVE GRECS","	: 1FBF 0300"},
/* 1FCE */ { "ESPRIT DOUX ET ACCENT AIGU GRECS","	: 1FBF 0301"},
/* 1FCF */ { "ESPRIT DOUX ET ACCENT CIRCONFLEXE GRECS","	: 1FBF 0342"},
/* 1FD0 */ { "LETTRE MINUSCULE GRECQUE IOTA BRÈVE","	: 03B9 0306"},
/* 1FD1 */ { "LETTRE MINUSCULE GRECQUE IOTA MACRON","	: 03B9 0304"},
/* 1FD2 */ { "LETTRE MINUSCULE GRECQUE IOTA TRÉMA ET ACCENT GRAVE","	: 03CA 0300"},
/* 1FD3 */ { "LETTRE MINUSCULE GRECQUE IOTA TRÉMA ET ACCENT AIGU","	: 0390 lettre minuscule grecque iota tréma et accent"},
/* 1FD4 */ { NULL,NULL},
/* 1FD5 */ { NULL,NULL},
/* 1FD6 */ { "LETTRE MINUSCULE GRECQUE IOTA CIRCONFLEXE","	: 03B9 0342"},
/* 1FD7 */ { "LETTRE MINUSCULE GRECQUE IOTA TRÉMA ET CIRCONFLEXE","	: 03CA 0342"},
/* 1FD8 */ { "LETTRE MAJUSCULE GRECQUE IOTA BRÈVE","	: 0399 0306"},
/* 1FD9 */ { "LETTRE MAJUSCULE GRECQUE IOTA MACRON","	: 0399 0304"},
/* 1FDA */ { "LETTRE MAJUSCULE GRECQUE IOTA ACCENT GRAVE","	: 0399 0300"},
/* 1FDB */ { "LETTRE MAJUSCULE GRECQUE IOTA ACCENT AIGU","	: 038A lettre majuscule grecque iota accent"},
/* 1FDC */ { NULL,NULL},
/* 1FDD */ { "ESPRIT RUDE ET ACCENT GRAVE GRECS","	: 1FFE 0300"},
/* 1FDE */ { "ESPRIT RUDE ET ACCENT AIGU GRECS","	: 1FFE 0301"},
/* 1FDF */ { "ESPRIT RUDE ET ACCENT CIRCONFLEXE GRECS","	: 1FFE 0342"},
/* 1FE0 */ { "LETTRE MINUSCULE GRECQUE UPSILON BRÈVE","	: 03C5 0306"},
/* 1FE1 */ { "LETTRE MINUSCULE GRECQUE UPSILON MACRON","	: 03C5 0304"},
/* 1FE2 */ { "LETTRE MINUSCULE GRECQUE UPSILON TRÉMA ET ACCENT GRAVE","	: 03CB 0300"},
/* 1FE3 */ { "LETTRE MINUSCULE GRECQUE UPSILON TRÉMA ET ACCENT AIGU","	: 03B0 lettre minuscule grecque upsilon tréma et accent"},
/* 1FE4 */ { "LETTRE MINUSCULE GRECQUE RHÔ ESPRIT DOUX","	: 03C1 0313"},
/* 1FE5 */ { "LETTRE MINUSCULE GRECQUE RHÔ ESPRIT RUDE","	: 03C1 0314"},
/* 1FE6 */ { "LETTRE MINUSCULE GRECQUE UPSILON CIRCONFLEXE","	: 03C5 0342"},
/* 1FE7 */ { "LETTRE MINUSCULE GRECQUE UPSILON TRÉMA ET CIRCONFLEXE","	: 03CB 0342"},
/* 1FE8 */ { "LETTRE MAJUSCULE GRECQUE UPSILON BRÈVE","	: 03A5 0306"},
/* 1FE9 */ { "LETTRE MAJUSCULE GRECQUE UPSILON MACRON","	: 03A5 0304"},
/* 1FEA */ { "LETTRE MAJUSCULE GRECQUE UPSILON ACCENT GRAVE","	: 03A5 0300"},
/* 1FEB */ { "LETTRE MAJUSCULE GRECQUE UPSILON ACCENT AIGU","	: 038E lettre majuscule grecque upsilon accent"},
/* 1FEC */ { "LETTRE MAJUSCULE GRECQUE RHÔ ESPRIT RUDE","	: 03A1 0314"},
/* 1FED */ { "TRÉMA ET ACCENT GRAVE GRECS","	: 00A8 0300"},
/* 1FEE */ { "TRÉMA ET ACCENT AIGU GRECS","	: 0385 tréma accent grec"},
/* 1FEF */ { "ACCENT GRAVE GREC","	: 0060 accent grave"},
/* 1FF0 */ { NULL,NULL},
/* 1FF1 */ { NULL,NULL},
/* 1FF2 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ACCENT GRAVE IOTA SOUSCRIT","	: 1F7C 0345"},
/* 1FF3 */ { "LETTRE MINUSCULE GRECQUE OMÉGA IOTA SOUSCRIT","	: 03C9 0345"},
/* 1FF4 */ { "LETTRE MINUSCULE GRECQUE OMÉGA ACCENT AIGU IOTA SOUSCRIT","	: 03CE 0345"},
/* 1FF5 */ { NULL,NULL},
/* 1FF6 */ { "LETTRE MINUSCULE GRECQUE OMÉGA CIRCONFLEXE","	: 03C9 0342"},
/* 1FF7 */ { "LETTRE MINUSCULE GRECQUE OMÉGA CIRCONFLEXE IOTA SOUSCRIT","	: 1FF6 0345"},
/* 1FF8 */ { "LETTRE MAJUSCULE GRECQUE OMICRON ACCENT GRAVE","	: 039F 0300"},
/* 1FF9 */ { "LETTRE MAJUSCULE GRECQUE OMICRON ACCENT AIGU","	: 038C lettre majuscule grecque omicron accent"},
/* 1FFA */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ACCENT GRAVE","	: 03A9 0300"},
/* 1FFB */ { "LETTRE MAJUSCULE GRECQUE OMÉGA ACCENT AIGU","	: 038F lettre majuscule grecque oméga accent"},
/* 1FFC */ { "LETTRE MAJUSCULE GRECQUE OMÉGA IOTA SOUSCRIT","	: 03A9 0345"},
/* 1FFD */ { "ACCENT AIGU GREC","	: 00B4 accent aigu"},
/* 1FFE */ { "ESPRIT RUDE GREC","	x (lettre modificative virgule réfléchie - 02BD)\n"
	"	# 0020 0314"},
/* 1FFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_20[] = {
/* 2000 */ { "DEMI-CADRATIN","	* ce caractère est en pratique équivalent à l'espace demi-cadratin\n"
	"	: 2002 espace demi-cadratin"},
/* 2001 */ { "CADRATIN","	* ce caractère est en pratique équivalent à l'espace cadratin\n"
	"	: 2003 espace cadratin"},
/* 2002 */ { "ESPACE DEMI-CADRATIN","	# 0020 espace"},
/* 2003 */ { "ESPACE CADRATIN","	* espace dont la largeur correspond à la force de corps utilisée\n"
	"	* elle peut cependant varier en fonction du degré de modification de la chasse d'une fonte de caractères\n"
	"	# 0020 espace"},
/* 2004 */ { "ESPACE TIERS DE CADRATIN","	# 0020 espace"},
/* 2005 */ { "ESPACE QUART DE CADRATIN","	# 0020 espace"},
/* 2006 */ { "ESPACE SIXIÈME DE CADRATIN","	* en typographie informatique, espace parfois assimilée à l'espace fine\n"
	"	# 0020 espace"},
/* 2007 */ { "ESPACE TABULAIRE","	= espace-nombre\n"
	"	* espace de largeur égale à un chiffre dans une police où les chiffres ont une chasse fixe\n"
	"	# <insécable> 0020"},
/* 2008 */ { "ESPACE PONCTUATION","	* espace de largeur égale à la ponctuation étroite d'une police\n"
	"	# 0020 espace"},
/* 2009 */ { "ESPACE FINE","	* un cinquième de cadratin (parfois un sixième) dans la typographie anglo-saxonne\n"
	"	* un quart de cadratin, en principe, en typographie française\n"
	"	x (espace insécable étroite - 202F)\n"
	"	# 0020 espace"},
/* 200A */ { "ESPACE ULTRAFINE","	* chasse moins que l'espace fine\n"
	"	* dans la typographie traditionnelle, la plus étroite des espaces disponibles\n"
	"	# 0020 espace"},
/* 200B */ { "ESPACE SANS CHASSE","	= espace à chasse nulle\n"
	"	* communément abrégée ZWSP (zero width space)\n"
	"	* caractère destiné à maîtriser la coupure de ligne ; au sens strict, caractère à chasse nulle, bien qu'il puisse s'étirer lors de la justification"},
/* 200C */ { "ANTILIANT SANS CHASSE","	* communément abrégé ZWNJ (zero width non-joiner)"},
/* 200D */ { "LIANT SANS CHASSE","	* communément abrégé ZWJ (zero width joiner)"},
/* 200E */ { "MARQUE GAUCHE-À-DROITE","	* communément abrégée LRM (left-to-right mark)"},
/* 200F */ { "MARQUE DROITE-À-GAUCHE","	* communément abrégée RLM (right-to-left mark)\n"
	"	x (marque de lettre arabe - 061C)"},
/* 2010 */ { "TRAIT D'UNION","	= division\n"
	"	x (trait d'union-signe moins - 002D)\n"
	"	x (trait d'union conditionnel - 00AD)"},
/* 2011 */ { "TRAIT D'UNION INSÉCABLE","	x (trait d'union-signe moins - 002D)\n"
	"	x (trait d'union conditionnel - 00AD)\n"
	"	# <insécable> 2010"},
/* 2012 */ { "TIRET NUMÉRIQUE",NULL},
/* 2013 */ { "TIRET DEMI-CADRATIN","	* dans la typographie anglo-saxonne, il peut être utilisé pour séparer les bornes d'un intervalle\n"
	"	* dans la typographie française, il est utilisé (en remplacement du tiret cadratin) pour encadrer les propositions incises dans la fonction de quasi-parenthèse ou pour introduire les répliques des dialogues"},
/* 2014 */ { "TIRET CADRATIN","	= tiret sur cadratin\n"
	"	* parfois appelé « tiret » ou « moins » par les typographes\n"
	"	* dans la typographie française, il est utilisé pour encadrer les propositions incises dans la fonction de quasi-parenthèse et pour introduire les répliques des dialogues\n"
	"	x (tiret double cadratin - 2E3A)\n"
	"	x (marque katakana-hiragana de son prolongé - 30FC)"},
/* 2015 */ { "BARRE HORIZONTALE","	* peut s'utiliser pour introduire les répliques des dialogues ; le tiret cadratin remplit la même fonction"},
/* 2016 */ { "DOUBLE LIGNE VERTICALE","	* s'utilise par paire pour indiquer une norme matricielle\n"
	"	x (diacritique double barre verticale couvrante - 20E6)\n"
	"	x (parallèle à - 2225)\n"
	"	x (double barre verticale - 23F8)"},
/* 2017 */ { "DOUBLE TIRET BAS","	* ce caractère chasse\n"
	"	x (tiret bas - 005F)\n"
	"	x (diacritique double trait souscrit - 0333)\n"
	"	# 0020 0333"},
/* 2018 */ { "GUILLEMET-APOSTROPHE CULBUTÉ","	* caractère recommandé (par opposition avec 201B)\n"
	"	x (apostrophe - 0027)\n"
	"	x (lettre modificative virgule culbutée - 02BB)\n"
	"	x (guillemet de fantaisie en forme de grosse virgule simple culbutée - 275B)"},
/* 2019 */ { "GUILLEMET-APOSTROPHE","	= apostrophe typographique\n"
	"	* caractère recommandé pour indiquer l'apostrophe\n"
	"	* son tracé est plus ou moins incliné et généralement courbe\n"
	"	* en allemand, ce caractère est appelé « Hochkomma » (« virgule haute ») dans le langage courant\n"
	"	x (apostrophe - 0027)\n"
	"	x (lettre modificative apostrophe - 02BC)\n"
	"	x (guillemet de fantaisie en forme de grosse virgule simple - 275C)"},
/* 201A */ { "GUILLEMET-VIRGULE INFÉRIEUR","	* s'utilise comme guillemet simple ouvrant dans certaines langues"},
/* 201B */ { "GUILLEMET-VIRGULE SUPÉRIEUR CULBUTÉ","	* a la même signification que 2018, mais diffère dans sa forme\n"
	"	x (lettre modificative virgule réfléchie - 02BD)"},
/* 201C */ { "GUILLEMET-APOSTROPHE DOUBLE CULBUTÉ","	* caractère recommandé (par opposition avec 201F)\n"
	"	x (guillemet anglais - 0022)\n"
	"	x (guillemet de fantaisie en forme de grosse virgule double culbutée - 275D)\n"
	"	x (guillemet double prime réfléchi - 301D)"},
/* 201D */ { "GUILLEMET-APOSTROPHE DOUBLE","	x (guillemet anglais - 0022)\n"
	"	x (double prime - 2033)\n"
	"	x (guillemet de fantaisie en forme de grosse virgule double - 275E)\n"
	"	x (guillemet double prime - 301E)"},
/* 201E */ { "GUILLEMET-VIRGULE DOUBLE INFÉRIEUR","	* s'utilise comme guillemet double ouvrant dans certaines langues\n"
	"	x (guillemet-virgule double inférieur réfléchi - 2E42)\n"
	"	x (guillemet double prime inférieur - 301F)"},
/* 201F */ { "GUILLEMET-VIRGULE DOUBLE SUPÉRIEUR CULBUTÉ","	* a la même signification que 201C, mais diffère dans sa forme"},
/* 2020 */ { "OBÈLE","	x (obèle culbuté - 2E38)"},
/* 2021 */ { "DOUBLE OBÈLE",NULL},
/* 2022 */ { "PUCE","	x (point médian - 00B7)\n"
	"	x (point de conduite simple - 2024)\n"
	"	x (opérateur puce - 2219)\n"
	"	x (puce noir au blanc - 25D8)\n"
	"	x (puce blanche - 25E6)"},
/* 2023 */ { "PUCE TRIANGULAIRE","	x (ce qu'il fallait démontrer - 220E)\n"
	"	x (petit triangle noir pointant vers la droite - 25B8)"},
/* 2024 */ { "POINT DE CONDUITE SIMPLE","	* sert également de point-virgule arménien (midjaket)\n"
	"	x (point médian - 00B7)\n"
	"	x (puce - 2022)\n"
	"	x (opérateur puce - 2219)\n"
	"	# 002E point"},
/* 2025 */ { "POINT DE CONDUITE DOUBLE","	# 002E 002E"},
/* 2026 */ { "POINTS DE SUSPENSION","	x (trois points suspendus - 22EE)\n"
	"	x (forme de présentation de points de suspension verticaux - FE19)\n"
	"	# 002E 002E 002E"},
/* 2027 */ { "POINT DE COUPURE DE MOT","	* symbole visible utilisé pour indiquer les positions correctes pour la division d'un mot, comme dans dic·tion·nai·res"},
/* 2028 */ { "SÉPARATEUR DE LIGNES","	* peut s'utiliser pour représenter sans équivoque ce concept"},
/* 2029 */ { "SÉPARATEUR DE PARAGRAPHES","	* peut s'utiliser pour représenter sans équivoque ce concept"},
/* 202A */ { "ENCHÂSSEMENT GAUCHE-À-DROITE","	* communément abrégé LRE (left-to-right embedding)"},
/* 202B */ { "ENCHÂSSEMENT DROITE-À-GAUCHE","	* communément abrégé RLE (right-to-left embedding)"},
/* 202C */ { "DÉPILEMENT DE FORMATAGE DIRECTIONNEL","	* communément abrégé PDF (pop directional formatting)"},
/* 202D */ { "FORÇAGE GAUCHE-À-DROITE","	* communément abrégé LRO (left-to-right override)"},
/* 202E */ { "FORÇAGE DROITE-À-GAUCHE","	* communément abrégé RLO (right-to-left override)"},
/* 202F */ { "ESPACE INSÉCABLE ÉTROITE","	* communément abrégée NNBSP (narrow no-break space)\n"
	"	* une espace insécable étroite, qui a généralement la largeur d'un cinquième de cadratin ou d'un quart de cadratin\n"
	"	x (espace insécable - 00A0)\n"
	"	x (espace quart de cadratin - 2005)\n"
	"	x (espace fine - 2009)\n"
	"	# <insécable> 0020"},
/* 2030 */ { "SYMBOLE POUR MILLE","	* utilisé, par exemple, en mesure de salinité, d'alcoolémie, etc.\n"
	"	x (symbole pour cent - 0025)\n"
	"	x (symbole arabo-indien pour mille - 0609)"},
/* 2031 */ { "SYMBOLE POUR DIX MILLE","	= par myriade\n"
	"	* pourcentage d'un pourcentage, rarement utilisé\n"
	"	x (symbole pour cent - 0025)\n"
	"	x (symbole arabo-indien pour dix mille - 060A)"},
/* 2032 */ { "PRIME","	= minutes, pieds\n"
	"	x (apostrophe - 0027)\n"
	"	x (accent aigu - 00B4)\n"
	"	x (lettre modificative prime - 02B9)"},
/* 2033 */ { "DOUBLE PRIME","	= secondes, pouces\n"
	"	x (guillemet anglais - 0022)\n"
	"	x (lettre modificative seconde - 02BA)\n"
	"	x (guillemet-apostrophe double - 201D)\n"
	"	x (guillemet de répétition - 3003)\n"
	"	x (guillemet double prime - 301E)\n"
	"	# 2032 2032"},
/* 2034 */ { "TRIPLE PRIME","	= ligne (unité de mesure archaïque, utilisée notamment dans l'horlogerie)\n"
	"	# 2032 2032 2032"},
/* 2035 */ { "PRIME RÉFLÉCHI","	x (accent grave - 0060)"},
/* 2036 */ { "DOUBLE PRIME RÉFLÉCHI","	x (guillemet double prime réfléchi - 301D)\n"
	"	# 2035 2035"},
/* 2037 */ { "TRIPLE PRIME RÉFLÉCHI","	# 2035 2035 2035"},
/* 2038 */ { "CHEVRON D'INSERTION","	x (pointe de flèche vers le haut - 2303)\n"
	"	x (lettre modificative accent circonflexe bas - A788)"},
/* 2039 */ { "GUILLEMET SIMPLE VERS LA GAUCHE","	* habituellement ouvrant, mais dans certaines langues fermant\n"
	"	x (signe inférieur à - 003C)\n"
	"	x (chevron pointant à gauche - 2329)\n"
	"	x (chevron gauche - 3008)"},
/* 203A */ { "GUILLEMET SIMPLE VERS LA DROITE","	* habituellement fermant, mais dans certaines langues ouvrant\n"
	"	x (signe supérieur à - 003E)\n"
	"	x (chevron pointant à droite - 232A)\n"
	"	x (chevron droit - 3009)"},
/* 203B */ { "MARQUE DE RÉFÉRENCE","	= komé japonais\n"
	"	= séparateur de paragraphes ourdou\n"
	"	* marque de cahier en reliure, indice de collationnement\n"
	"	x (signe tibétain ku ru kha bzhi mig can - 0FBF)\n"
	"	x (idéogramme unifié cjc-200AD - 200AD)"},
/* 203C */ { "DOUBLE POINT D'EXCLAMATION","	x (point d'exclamation - 0021)\n"
	"	# 0021 0021"},
/* 203D */ { "POINT EXCLARROGATIF","	x (point d'exclamation - 0021)\n"
	"	x (point d'interrogation - 003F)\n"
	"	x (point exclarrogatif culbuté - 2E18)\n"
	"	x (ornement point exclarrogatif au trait fort - 1F679)"},
/* 203E */ { "TIRET HAUT","	= tiret suscrit avec chasse\n"
	"	# 0020 0305"},
/* 203F */ { "TIRANT BAS","	= énotikon grec\n"
	"	x (sourire - 2323)"},
/* 2040 */ { "TIRANT HAUT","	= concaténation d'une séquence en notation z\n"
	"	= dos-d'âne suscrit\n"
	"	x (moue - 2322)"},
/* 2041 */ { "LAMBDA D'INSERTION","	* signe de correcteur : insérer ici\n"
	"	x (produit semi-direct à droite - 22CC)"},
/* 2042 */ { "ASTÉRISME",NULL},
/* 2043 */ { "PUCE TRAIT D'UNION","	x (trait d'union-signe moins - 002D)"},
/* 2044 */ { "BARRE DE FRACTION","	= barre fractionnaire\n"
	"	* pour composer des fractions arbitraires\n"
	"	x (barre oblique - 002F)\n"
	"	x (barre oblique de division - 2215)"},
/* 2045 */ { "CROCHET GAUCHE AVEC PIQUE",NULL},
/* 2046 */ { "CROCHET DROIT AVEC PIQUE",NULL},
/* 2047 */ { "DOUBLE POINT D'INTERROGATION","	# 003F 003F"},
/* 2048 */ { "POINT D'INTERROGATION-EXCLAMATION","	# 003F 0021"},
/* 2049 */ { "POINT D'EXCLAMATION-INTERROGATION","	# 0021 003F"},
/* 204A */ { "NOTE TIRONIENNE ET","	* gaélique irlandais, vieil anglais\n"
	"	x (perluète - 0026)\n"
	"	x (ornement ligature et cursif - 1F670)"},
/* 204B */ { "PIED-DE-MOUCHE RÉFLÉCHI","	x (pied-de-mouche - 00B6)"},
/* 204C */ { "PUCE NOIRE TRONQUÉE À DROITE",NULL},
/* 204D */ { "PUCE NOIRE TRONQUÉE À GAUCHE",NULL},
/* 204E */ { "ASTÉRISQUE BAISSÉ","	x (astérisque - 002A)\n"
	"	x (diacritique astérisque souscrit - 0359)"},
/* 204F */ { "POINT-VIRGULE RÉFLÉCHI","	* s'utilise aussi en sindhi\n"
	"	x (point-virgule - 003B)\n"
	"	x (point-virgule arabe - 061B)"},
/* 2050 */ { "RESSERRER","	* signe de correcteur : diminuer une espace ou joindre deux signes\n"
	"	x (brève modificative et brève renversée - AB5B)"},
/* 2051 */ { "DEUX ASTÉRISQUES ALIGNÉS VERTICALEMENT",NULL},
/* 2052 */ { "SIGNE MOINS COMMERCIAL","	= « abzüglich » (déduction en allemand), « med avdrag av » (déduction en suédois), « piska » (fouet en suédois)\n"
	"	* une variante commune de repli ressemble à « ./. »\n"
	"	* peut également servir de dingbat pour indiquer que l'option est correcte\n"
	"	* utilisé dans l'alphabet phonétique finno-ougrien pour indiquer qu'une forme empruntée voisine se prononce différemment\n"
	"	x (symbole pour cent - 0025)\n"
	"	x (symbole arabe pour cent - 066A)\n"
	"	x (signe de division - 00F7)"},
/* 2053 */ { "TIRET ONDÉ","	x (tilde - 007E)"},
/* 2054 */ { "TIRANT BAS RENVERSÉ",NULL},
/* 2055 */ { "POINT-FLEUR","	= phoul, pouspika, phul\n"
	"	* sert de signe de ponctuation en sylotî nâgrî, en bengali et dans d'autres écritures de l'Inde\n"
	"	x (gros astérisque-hélice à huit branches larmées - 274B)"},
/* 2056 */ { "TROIS-POINTS","	x (séparateur de paragraphes géorgien - 10FB)"},
/* 2057 */ { "QUADRUPLE PRIME","	# 2032 2032 2032 2032"},
/* 2058 */ { "QUATRE-POINTS EN LOSANGE",NULL},
/* 2059 */ { "CINQ-POINTS EN QUINCONCE","	= pentonkion grec\n"
	"	= quinconce\n"
	"	x (face de dé-5 - 2684)"},
/* 205A */ { "DEUX-POINTS EN CAPITALE","	* autrefois utilisé pour indiquer la fin d'une phrase ou le changement de locuteur\n"
	"	* va de la ligne de base à celle de la hauteur des capitales\n"
	"	x (forme de présentation de point de conduite double vertical - FE30)\n"
	"	x (deux acrophonique grec épidaurien - 1015B)"},
/* 205B */ { "QUATRE-POINTS EN CROIX","	* signe marginal de mise en évidence utilisé par les scribes\n"
	"	* le signe est centré dans la ligne, mais s'étend au-delà du haut et du bas de la ligne"},
/* 205C */ { "CROIX POINTÉE","	* signe marginal de mise en évidence utilisé par les scribes"},
/* 205D */ { "TROIS-POINTS VERTICAL","	= symbole trois acrophonique épidaurien\n"
	"	x (trois points suspendus - 22EE)\n"
	"	x (opérateur trois-points - 2AF6)\n"
	"	x (forme de présentation de points de suspension verticaux - FE19)"},
/* 205E */ { "QUATRE-POINTS VERTICAL","	* sert dans les dictionnaires anglo-saxons pour indiquer une coupure de mot licite mais peu souhaitable\n"
	"	* couvre la hauteur totale de la ligne\n"
	"	x (six-points vertical - 2E3D)"},
/* 205F */ { "ESPACE MOYENNE MATHÉMATIQUE","	* parfois abrégée MMSP (medium mathematical space)\n"
	"	* quatre dix-huitièmes d'un cadratin\n"
	"	# 0020 espace"},
/* 2060 */ { "GLUON DE MOTS","	* communément abrégé WJ (word joiner)\n"
	"	* une espace insécable sans chasse (rien de plus)\n"
	"	* permet de désambiguïser les fonctions pour l'indicateur d'ordre des octets\n"
	"	x (indicateur d'ordre des octets - FEFF)"},
/* 2061 */ { "APPLICATION D'UNE FONCTION","	* type de juxtaposition séparant une fonction de son argument"},
/* 2062 */ { "SIGNE DE MULTIPLICATION INVISIBLE","	* type de juxtaposition indiquant une multiplication"},
/* 2063 */ { "SÉPARATEUR INVISIBLE","	= virgule invisible\n"
	"	* type de juxtaposition indiquant qu'une suite de symboles mathématiques forme une liste (comme pour les indices qui ne sont pas séparés par des virgules visibles)"},
/* 2064 */ { "PLUS INVISIBLE","	* type de juxtaposition indiquant une addition"},
/* 2065 */ { NULL,NULL},
/* 2066 */ { "ISOLAT GAUCHE-À-DROITE",NULL},
/* 2067 */ { "ISOLAT DROITE-À-GAUCHE",NULL},
/* 2068 */ { "ISOLAT À DIRECTION DU PREMIER FORT",NULL},
/* 2069 */ { "DÉPILEMENT D'ISOLAT DIRECTIONNEL",NULL},
/* 206A */ { "INHIBITEUR D'ÉCHANGE SYMÉTRIQUE",NULL},
/* 206B */ { "ACTIVATEUR D'ÉCHANGE SYMÉTRIQUE",NULL},
/* 206C */ { "INHIBITEUR DE FORMAGE ARABE",NULL},
/* 206D */ { "ACTIVATEUR DE FORMAGE ARABE",NULL},
/* 206E */ { "SÉLECTEUR DE FORMES NUMÉRALES NATIONALES",NULL},
/* 206F */ { "SÉLECTEUR DE FORMES NUMÉRALES DE RÉFÉRENCE",NULL},
/* 2070 */ { "EXPOSANT ZÉRO","	# <exp> 0030"},
/* 2071 */ { "EXPOSANT LETTRE MINUSCULE LATINE I","	* fonctionne comme une lettre modificative\n"
	"	# <exp> 0069"},
/* 2072 */ { NULL,"	x (exposant deux - 00B2)"},
/* 2073 */ { NULL,"	x (exposant trois - 00B3)"},
/* 2074 */ { "EXPOSANT QUATRE","	# <exp> 0034"},
/* 2075 */ { "EXPOSANT CINQ","	# <exp> 0035"},
/* 2076 */ { "EXPOSANT SIX","	# <exp> 0036"},
/* 2077 */ { "EXPOSANT SEPT","	# <exp> 0037"},
/* 2078 */ { "EXPOSANT HUIT","	# <exp> 0038"},
/* 2079 */ { "EXPOSANT NEUF","	# <exp> 0039"},
/* 207A */ { "EXPOSANT SIGNE PLUS","	# <exp> 002B"},
/* 207B */ { "EXPOSANT SIGNE MOINS","	# <exp> 2212"},
/* 207C */ { "EXPOSANT SIGNE ÉGAL","	# <exp> 003D"},
/* 207D */ { "EXPOSANT PARENTHÈSE GAUCHE","	# <exp> 0028"},
/* 207E */ { "EXPOSANT PARENTHÈSE DROITE","	# <exp> 0029"},
/* 207F */ { "EXPOSANT LETTRE MINUSCULE LATINE N","	* fonctionne comme une lettre modificative\n"
	"	# <exp> 006E"},
/* 2080 */ { "INDICE ZÉRO","	# <souscrite> 0030"},
/* 2081 */ { "INDICE UN","	# <souscrite> 0031"},
/* 2082 */ { "INDICE DEUX","	# <souscrite> 0032"},
/* 2083 */ { "INDICE TROIS","	# <souscrite> 0033"},
/* 2084 */ { "INDICE QUATRE","	# <souscrite> 0034"},
/* 2085 */ { "INDICE CINQ","	# <souscrite> 0035"},
/* 2086 */ { "INDICE SIX","	# <souscrite> 0036"},
/* 2087 */ { "INDICE SEPT","	# <souscrite> 0037"},
/* 2088 */ { "INDICE HUIT","	# <souscrite> 0038"},
/* 2089 */ { "INDICE NEUF","	# <souscrite> 0039"},
/* 208A */ { "INDICE SIGNE PLUS","	# <souscrite> 002B"},
/* 208B */ { "INDICE SIGNE MOINS","	# <souscrite> 2212"},
/* 208C */ { "INDICE SIGNE ÉGAL","	# <souscrite> 003D"},
/* 208D */ { "INDICE PARENTHÈSE GAUCHE","	# <souscrite> 0028"},
/* 208E */ { "INDICE PARENTHÈSE DROITE","	# <souscrite> 0029"},
/* 208F */ { NULL,NULL},
/* 2090 */ { "INDICE LETTRE MINUSCULE LATINE A","	# <souscrite> 0061"},
/* 2091 */ { "INDICE LETTRE MINUSCULE LATINE E","	# <souscrite> 0065"},
/* 2092 */ { "INDICE LETTRE MINUSCULE LATINE O","	# <souscrite> 006F"},
/* 2093 */ { "INDICE LETTRE MINUSCULE LATINE X","	# <souscrite> 0078"},
/* 2094 */ { "INDICE LETTRE MINUSCULE LATINE SCHWA","	# <souscrite> 0259"},
/* 2095 */ { "INDICE LETTRE MINUSCULE LATINE H","	# <souscrite> 0068"},
/* 2096 */ { "INDICE LETTRE MINUSCULE LATINE K","	# <souscrite> 006B"},
/* 2097 */ { "INDICE LETTRE MINUSCULE LATINE L","	# <souscrite> 006C"},
/* 2098 */ { "INDICE LETTRE MINUSCULE LATINE M","	# <souscrite> 006D"},
/* 2099 */ { "INDICE LETTRE MINUSCULE LATINE N","	# <souscrite> 006E"},
/* 209A */ { "INDICE LETTRE MINUSCULE LATINE P","	# <souscrite> 0070"},
/* 209B */ { "INDICE LETTRE MINUSCULE LATINE S","	# <souscrite> 0073"},
/* 209C */ { "INDICE LETTRE MINUSCULE LATINE T","	# <souscrite> 0074"},
/* 209D */ { NULL,NULL},
/* 209E */ { NULL,NULL},
/* 209F */ { NULL,NULL},
/* 20A0 */ { "SYMBOLE ÉCU","	* prévu pour l'ECU\n"
	"	* caractère historique ; il ne s'agit pas de l'euro\n"
	"	x (symbole euro - 20AC)"},
/* 20A1 */ { "SYMBOLE COLON","	* Costa Rica, Salvador"},
/* 20A2 */ { "SYMBOLE CRUZEIRO","	* Brésil"},
/* 20A3 */ { "SYMBOLE FRANC FRANÇAIS","	* France"},
/* 20A4 */ { "SYMBOLE LIRE","	* destiné à représenter la lire, mais le symbole est peu utilisé\n"
	"	* le caractère recommandé pour la lire est 00A3\n"
	"	x (symbole livre - 00A3)\n"
	"	x (symbole lire turque - 20BA)"},
/* 20A5 */ { "SYMBOLE MILLIÈME","	* États-Unis (1/10 de cent)"},
/* 20A6 */ { "SYMBOLE NAIRA","	* Nigeria"},
/* 20A7 */ { "SYMBOLE PESETA","	* Espagne\n"
	"	x (symbole peso - 20B1)"},
/* 20A8 */ { "SYMBOLE ROUPIE","	* Inde, symbole utilisé anciennement\n"
	"	x (symbole roupie indienne - 20B9)\n"
	"	# 0052 0073"},
/* 20A9 */ { "SYMBOLE WON","	* Corée"},
/* 20AA */ { "SYMBOLE NOUVEAU CHÉKEL","	* Israël"},
/* 20AB */ { "SYMBOLE DONG","	* Viêt Nam"},
/* 20AC */ { "SYMBOLE EURO","	* symbole monétaire de l'Union monétaire européenne\n"
	"	* euro, il ne s'agit pas de l'ECU\n"
	"	x (symbole écu - 20A0)"},
/* 20AD */ { "SYMBOLE KIP","	* Laos"},
/* 20AE */ { "SYMBOLE TOUGRIK","	* Mongolie\n"
	"	* se translittère aussi tougroug, tougric, tougrog, togrog"},
/* 20AF */ { "SYMBOLE DRACHME","	= drakhmê\n"
	"	* Grèce"},
/* 20B0 */ { "SYMBOLE PFENNIG","	= denier, pfennig allemand\n"
	"	* Allemagne"},
/* 20B1 */ { "SYMBOLE PESO","	* Philippines\n"
	"	* le symbole dollar s'utilise pour le peso, qui est le nom de plusieurs devises d'Amérique latine\n"
	"	x (symbole dollar - 0024)\n"
	"	x (symbole peseta - 20A7)"},
/* 20B2 */ { "SYMBOLE GUARANI","	* Paraguay\n"
	"	* souvent représenté au moyen de « G. » ou de « Gs. »"},
/* 20B3 */ { "SYMBOLE AUSTRAL","	* ancienne monnaie argentine"},
/* 20B4 */ { "SYMBOLE HRYVNIA","	* Ukraine"},
/* 20B5 */ { "SYMBOLE CEDI","	* Ghana\n"
	"	* le glyphe peut ressembler à 023B ou à un C avec une petite barre verticale traversant l'arc supérieur\n"
	"	x (symbole centime - 00A2)\n"
	"	x (lettre majuscule latine c barré - 023B)"},
/* 20B6 */ { "SYMBOLE LIVRE TOURNOIS","	* monnaie de compte qui fut utilisée en France des XIIIe au XVIIIe siècles"},
/* 20B7 */ { "SYMBOLE SPESMILO","	* unité de compte monétaire historique associée à l'espéranto"},
/* 20B8 */ { "SYMBOLE TENGE","	* Kazakhstan\n"
	"	x (symbole de fonction apl taquet vers le bas surligné - 2351)\n"
	"	x (filet vers le bas simple et horizontal double - 2564)\n"
	"	x (marque postale - 3012)"},
/* 20B9 */ { "SYMBOLE ROUPIE INDIENNE","	* symbole officiel de la monnaie de l'Inde\n"
	"	* contraste avec les symboles de la roupie propres à certaines polices\n"
	"	x (lettre dévanâgarî ra - 0930)"},
/* 20BA */ { "SYMBOLE LIRE TURQUE","	* symbole monétaire officiel de la lire turque"},
/* 20BB */ { "SYMBOLE MARK NORDIQUE","	* ancienne représentation du mark utilisé au Danemark et en Norvège\n"
	"	x (majuscule m de ronde - 2133)"},
/* 20BC */ { "SYMBOLE MANAT","	* Azerbaïdjan"},
/* 20BD */ { "SYMBOLE ROUBLE","	* Russie"},
/* 20BE */ { "SYMBOLE LARI","	* Géorgie"},
/* 20BF */ { "SYMBOLE BITCOIN",NULL},
/* 20C0 */ { NULL,NULL},
/* 20C1 */ { NULL,NULL},
/* 20C2 */ { NULL,NULL},
/* 20C3 */ { NULL,NULL},
/* 20C4 */ { NULL,NULL},
/* 20C5 */ { NULL,NULL},
/* 20C6 */ { NULL,NULL},
/* 20C7 */ { NULL,NULL},
/* 20C8 */ { NULL,NULL},
/* 20C9 */ { NULL,NULL},
/* 20CA */ { NULL,NULL},
/* 20CB */ { NULL,NULL},
/* 20CC */ { NULL,NULL},
/* 20CD */ { NULL,NULL},
/* 20CE */ { NULL,NULL},
/* 20CF */ { NULL,NULL},
/* 20D0 */ { "DIACRITIQUE VECTEUR VERS LA GAUCHE EN CHEF",NULL},
/* 20D1 */ { "DIACRITIQUE VECTEUR VERS LA DROITE EN CHEF","	* vecteur"},
/* 20D2 */ { "DIACRITIQUE LIGNE VERTICALE LONGUE COUVRANTE","	* négation"},
/* 20D3 */ { "DIACRITIQUE LIGNE VERTICALE COURTE COUVRANTE","	* variante occasionnelle pour la négation"},
/* 20D4 */ { "DIACRITIQUE FLÈCHE SENS ANTIHORAIRE EN CHEF",NULL},
/* 20D5 */ { "DIACRITIQUE FLÈCHE SENS HORAIRE EN CHEF","	* rotation"},
/* 20D6 */ { "DIACRITIQUE FLÈCHE VERS LA GAUCHE EN CHEF",NULL},
/* 20D7 */ { "DIACRITIQUE FLÈCHE VERS LA DROITE EN CHEF","	* vecteur"},
/* 20D8 */ { "DIACRITIQUE ROND COUVRANT",NULL},
/* 20D9 */ { "DIACRITIQUE ROND SENS HORAIRE COUVRANT",NULL},
/* 20DA */ { "DIACRITIQUE ROND SENS ANTIHORAIRE COUVRANT",NULL},
/* 20DB */ { "DIACRITIQUE TROIS POINTS EN CHEF","	= troisième dérivée"},
/* 20DC */ { "DIACRITIQUE QUATRE POINTS EN CHEF","	= quatrième dérivée"},
/* 20DD */ { "DIACRITIQUE CERCLE ENGLOBANT","	= cercle de composition JIS\n"
	"	= diacritique cyrillique myriade, diacritique cyrillique symbole dix mille\n"
	"	x (cercle blanc - 25CB)\n"
	"	x (grand cercle - 25EF)\n"
	"	x (zéro idéographique - 3007)"},
/* 20DE */ { "DIACRITIQUE CARRÉ ENGLOBANT","	x (carré blanc - 25A1)"},
/* 20DF */ { "DIACRITIQUE LOSANGE ENGLOBANT","	x (losange blanc - 25C7)"},
/* 20E0 */ { "DIACRITIQUE CERCLE ENGLOBANT ET BARRE OBLIQUE INVERSÉE","	= diacritique cercle englobant contre-coticé\n"
	"	* interdiction\n"
	"	x (symbole d'interdiction - 1F6C7)"},
/* 20E1 */ { "DIACRITIQUE FLÈCHE GAUCHE-DROITE EN CHEF","	* tenseur"},
/* 20E2 */ { "DIACRITIQUE ÉCRAN ENGLOBANT","	* s'utilise pour composer les symboles complets suivants d'ISO/CEI 9995-7\n"
	"	x (symbole effacer écran - 239A)\n"
	"	x (écran - 1F5B5)"},
/* 20E3 */ { "DIACRITIQUE TOUCHE ENGLOBANTE",NULL},
/* 20E4 */ { "DIACRITIQUE TRIANGLE ENGLOBANT POINTANT VERS LE HAUT","	x (triangle blanc pointant vers le haut - 25B3)"},
/* 20E5 */ { "DIACRITIQUE BARRE OBLIQUE INVERSÉE COUVRANTE","	= diacritique contre-cotice couvrante\n"
	"	= diacritique contre-oblique couvrante\n"
	"	x (barre oblique inversée - 005C)"},
/* 20E6 */ { "DIACRITIQUE DOUBLE BARRE VERTICALE COUVRANTE","	= diacritique fonction finie en notation z\n"
	"	x (double ligne verticale - 2016)"},
/* 20E7 */ { "DIACRITIQUE SYMBOLE DE RENTE","	= anglet actuariel\n"
	"	x (plafond à droite - 2309)"},
/* 20E8 */ { "DIACRITIQUE TROIS POINTS SOUSCRITS",NULL},
/* 20E9 */ { "DIACRITIQUE PONT EN CHEF","	= opérateur de contraction\n"
	"	* couvre toute la largeur du caractère de base\n"
	"	x (diacritique pontet en chef - 0346)"},
/* 20EA */ { "DIACRITIQUE FLÈCHE VERS LA GAUCHE COUVRANTE","	x (flèche vers la gauche - 2190)"},
/* 20EB */ { "DIACRITIQUE DOUBLE BARRE OBLIQUE LONGUE COUVRANTE","	= longue double cotice couvrante"},
/* 20EC */ { "DIACRITIQUE HARPON VERS LA DROITE AVEC BARBILLON VERS LE BAS",NULL},
/* 20ED */ { "DIACRITIQUE HARPON VERS LA GAUCHE AVEC BARBILLON VERS LE BAS",NULL},
/* 20EE */ { "DIACRITIQUE FLÈCHE VERS LA GAUCHE SOUSCRITE",NULL},
/* 20EF */ { "DIACRITIQUE FLÈCHE VERS LA DROITE SOUSCRITE",NULL},
/* 20F0 */ { "DIACRITIQUE ASTÉRISQUE SUSCRIT",NULL},
/* 20F1 */ { NULL,NULL},
/* 20F2 */ { NULL,NULL},
/* 20F3 */ { NULL,NULL},
/* 20F4 */ { NULL,NULL},
/* 20F5 */ { NULL,NULL},
/* 20F6 */ { NULL,NULL},
/* 20F7 */ { NULL,NULL},
/* 20F8 */ { NULL,NULL},
/* 20F9 */ { NULL,NULL},
/* 20FA */ { NULL,NULL},
/* 20FB */ { NULL,NULL},
/* 20FC */ { NULL,NULL},
/* 20FD */ { NULL,NULL},
/* 20FE */ { NULL,NULL},
/* 20FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_21[] = {
/* 2100 */ { "AU COMPTE DE","	# 0061 002F 0063"},
/* 2101 */ { "AUX BONS SOINS DE","	= au sujet de\n"
	"	x (aktieselskab - 214D)\n"
	"	# 0061 002F 0073"},
/* 2102 */ { "MAJUSCULE C AJOURÉ","	= c majuscule éclairé\n"
	"	= l'ensemble des nombres complexes\n"
	"	# <police> 0043 lettre majuscule latine c"},
/* 2103 */ { "DEGRÉ CELSIUS","	= degrés centigrades (à éviter)\n"
	"	# 00B0 0043"},
/* 2104 */ { "SYMBOLE LIGNE DE CENTRE","	= clone"},
/* 2105 */ { "CARE OF","	* en français : a/s (aux soins de), et l'on utilise 2101\n"
	"	* compte ouvert\n"
	"	# 0063 002F 006F"},
/* 2106 */ { "CADA UNA","	# 0063 002F 0075"},
/* 2107 */ { "CONSTANTE D'EULER","	x (lettre majuscule latine e - 0045)\n"
	"	# 0190 lettre majuscule latine e ouvert"},
/* 2108 */ { "SCRUPULE",NULL},
/* 2109 */ { "DEGRÉ FAHRENHEIT","	# 00B0 0046"},
/* 210A */ { "MINUSCULE G DE RONDE","	= symbole nombre réel\n"
	"	# <police> 0067 lettre minuscule latine g"},
/* 210B */ { "MAJUSCULE H DE RONDE","	= opérateur hamiltonien\n"
	"	# <police> 0048 lettre majuscule latine h"},
/* 210C */ { "MAJUSCULE H GOTHIQUE","	= espace de Hilbert séparable\n"
	"	# <police> 0048 lettre majuscule latine h"},
/* 210D */ { "MAJUSCULE H AJOURÉ","	= majuscule h éclairé\n"
	"	# <police> 0048 lettre majuscule latine h"},
/* 210E */ { "CONSTANTE DE PLANCK","	= hauteur, enthalpie spécifique\n"
	"	* simplement un h mathématique italique ; le nom de ce caractère trouve son origine dans un usage historique\n"
	"	# <police> 0068 lettre minuscule latine h"},
/* 210F */ { "CONSTANTE DE PLANCK SUR DEUX PI","	= constante de Planck réduite\n"
	"	x (lettre minuscule cyrillique tié - 045B)\n"
	"	# <police> 0127 lettre minuscule latine h barré"},
/* 2110 */ { "MAJUSCULE I DE RONDE","	# <police> 0049 lettre majuscule latine i"},
/* 2111 */ { "MAJUSCULE I GOTHIQUE","	= partie imaginaire\n"
	"	# <police> 0049 lettre majuscule latine i"},
/* 2112 */ { "MAJUSCULE L DE RONDE","	= transformation de Laplace\n"
	"	# <police> 004C lettre majuscule latine l"},
/* 2113 */ { "MINUSCULE L DE RONDE","	= symbole mathématique elle\n"
	"	= litre (symbole traditionnel)\n"
	"	* en dépit de son nom, ce symbole trouve son origine dans une variante italique particulière du l minuscule\n"
	"	* le symbole SI recommandé pour le litre est 006C\n"
	"	x (minuscule mathématique l de ronde - 1D4C1)\n"
	"	# <police> 006C lettre minuscule latine l"},
/* 2114 */ { "SYMBOLE L B BARRÉ","	= livre poids\n"
	"	x (croisillon - 0023)"},
/* 2115 */ { "MAJUSCULE N AJOURÉ","	= majuscule n éclairé\n"
	"	= ensemble des nombres naturels\n"
	"	* il existe une variante de glyphe avec des hastes doublées\n"
	"	# <police> 004E lettre majuscule latine n"},
/* 2116 */ { "SYMBOLE NUMÉRO","	# 004E 006F"},
/* 2117 */ { "COPYRIGHT DE PHONOGRAMME","	x (symbole copyright - 00A9)\n"
	"	x (lettre majuscule latine p cerclée - 24C5)"},
/* 2118 */ { "SYMBOLE FONCTION ELLIPTIQUE DE WEIERSTRASS","	* ce symbole a la forme d'un p calligraphique minuscule\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 2119 */ { "MAJUSCULE P AJOURÉ","	= majuscule p éclairé\n"
	"	# <police> 0050 lettre majuscule latine p"},
/* 211A */ { "MAJUSCULE Q AJOURÉ","	= majuscule q éclairé\n"
	"	= l'ensemble des nombres rationnels\n"
	"	# <police> 0051 lettre majuscule latine q"},
/* 211B */ { "MAJUSCULE R DE RONDE","	= intégrale de Riemann\n"
	"	# <police> 0052 lettre majuscule latine r"},
/* 211C */ { "MAJUSCULE R GOTHIQUE","	= partie réelle\n"
	"	# <police> 0052 lettre majuscule latine r"},
/* 211D */ { "MAJUSCULE R AJOURÉ","	= majuscule r éclairé\n"
	"	= l'ensemble des nombres réels\n"
	"	# <police> 0052 lettre majuscule latine r"},
/* 211E */ { "ORDONNANCES","	= prescriptions"},
/* 211F */ { "RÉPONS",NULL},
/* 2120 */ { "SYMBOLE MARQUE DE SERVICE","	# <exp> 0053 004D"},
/* 2121 */ { "SYMBOLE TÉLÉPHONE","	* le symbole peut être présenté sous la forme d'une minuscule, d'une petite capitale ou d'une lettre suscrite\n"
	"	x (téléphone noir - 260E)\n"
	"	x (symbole d'emplacement du téléphone - 2706)\n"
	"	x (récepteur téléphonique - 1F4DE)\n"
	"	# 0054 0045 004C"},
/* 2122 */ { "SYMBOLE MARQUE DE COMMERCE","	x (wz cerclé - 1F12E)\n"
	"	# <exp> 0054 004D"},
/* 2123 */ { "VERSICULE","	= verset"},
/* 2124 */ { "MAJUSCULE Z AJOURÉ","	= majuscule z éclairé\n"
	"	= l'ensemble des entiers relatifs\n"
	"	# <police> 005A lettre majuscule latine z"},
/* 2125 */ { "SYMBOLE ONCE","	x (lettre minuscule latine ej - 0292)\n"
	"	x (symbole alchimique de la demi-once - 1F773)"},
/* 2126 */ { "SYMBOLE OHM","	= résistance\n"
	"	* unité SI de la résistance, commémore le physicien allemand Georg Ohm\n"
	"	* 03A9 est la représentation recommandée\n"
	"	x (nœud ascendant - 260A)\n"
	"	: 03A9 lettre majuscule grecque oméga"},
/* 2127 */ { "SYMBOLE OHM RENVERSÉ","	= symbole mho\n"
	"	= conductance\n"
	"	* symbole SI désuet de la conductance, remplacé par S (Siemens)\n"
	"	* typographiquement, une lettre majuscule grecque oméga culbutée\n"
	"	x (lettre majuscule latine upsilon - 01B1)\n"
	"	x (lettre majuscule grecque oméga - 03A9)\n"
	"	x (nœud descendant - 260B)"},
/* 2128 */ { "MAJUSCULE Z GOTHIQUE","	# <police> 005A lettre majuscule latine z"},
/* 2129 */ { "LETTRE MINUSCULE GRECQUE IOTA CULBUTÉ","	= seul élément\n"
	"	* seul élément qui corresponde à la description (en logique)\n"
	"	x (lettre minuscule grecque iota - 03B9)"},
/* 212A */ { "SYMBOLE KELVIN","	: 004B lettre majuscule latine k"},
/* 212B */ { "SYMBOLE ANGSTRÖM","	* unité de longueur non SI (= 0,1 nm), commémore le physicien suédois Anders Ångström\n"
	"	* 00C5 est la représentation recommandée\n"
	"	: 00C5 lettre majuscule latine a rond en chef"},
/* 212C */ { "MAJUSCULE B DE RONDE","	= fonction de Bernoulli\n"
	"	# <police> 0042 lettre majuscule latine b"},
/* 212D */ { "MAJUSCULE C GOTHIQUE","	# <police> 0043 lettre majuscule latine c"},
/* 212E */ { "SYMBOLE ESTIMÉ","	* utilisé sur les emballages européens\n"
	"	x (lettre minuscule latine e - 0065)"},
/* 212F */ { "MINUSCULE E DE RONDE","	= erreur\n"
	"	= exposant naturel\n"
	"	# <police> 0065 lettre minuscule latine e"},
/* 2130 */ { "MAJUSCULE E DE RONDE","	= fem (force électromagnétique)\n"
	"	# <police> 0045 lettre majuscule latine e"},
/* 2131 */ { "MAJUSCULE F DE RONDE","	= transformée de Fourier, transformation de Fourier\n"
	"	# <police> 0046 lettre majuscule latine f"},
/* 2132 */ { "MAJUSCULE F CULBUTÉ","	= digamma inversé claudien\n"
	"	* la minuscule est 214E\n"
	"	x (lettre majuscule latine f - 0046)\n"
	"	x (lettre grecque digamma - 03DC)"},
/* 2133 */ { "MAJUSCULE M DE RONDE","	= matrice M\n"
	"	= moment d'une force\n"
	"	= symbole du mark allemand avant la Seconde Guerre mondiale\n"
	"	x (symbole mark nordique - 20BB)\n"
	"	# <police> 004D lettre majuscule latine m"},
/* 2134 */ { "MINUSCULE O DE RONDE","	= ordre\n"
	"	# <police> 006F lettre minuscule latine o"},
/* 2135 */ { "SYMBOLE ALEF","	= aleph\n"
	"	= premier nombre transfini\n"
	"	= dénombrable\n"
	"	# 05D0 lettre hébraïque alef"},
/* 2136 */ { "SYMBOLE BÈT","	= beth\n"
	"	= deuxième nombre transfini\n"
	"	= le continu\n"
	"	# 05D1 lettre hébraïque bèt"},
/* 2137 */ { "SYMBOLE GUIMEL","	= gimel\n"
	"	= troisième nombre transfini\n"
	"	= fonctions d'une variable réelle\n"
	"	# 05D2 lettre hébraïque guimel"},
/* 2138 */ { "SYMBOLE DALÈT","	= daleth\n"
	"	= quatrième nombre transfini\n"
	"	# 05D3 lettre hébraïque dalèt"},
/* 2139 */ { "SOURCE D'INFORMATION","	* destiné à être utilisé avec 20DD\n"
	"	x (symbole source d'information cerclé - 1F6C8)\n"
	"	# <police> 0069 lettre minuscule latine i"},
/* 213A */ { "MAJUSCULE Q COUCHÉ","	* marque de cahier en reliure, indice de collationnement\n"
	"	* tiré d'ISO 5426-2:1996"},
/* 213B */ { "SYMBOLE TÉLÉCOPIE","	* le symbole peut être présenté sous la forme d'une minuscule, d'une petite capitale ou d'une lettre suscrite\n"
	"	x (symbole téléphone - 2121)\n"
	"	x (télécopieur - 1F4E0)\n"
	"	# 0046 0041 0058"},
/* 213C */ { "MINUSCULE PI AJOURÉ","	# <police> 03C0 lettre minuscule grecque pi"},
/* 213D */ { "MINUSCULE GAMMA AJOURÉ","	# <police> 03B3 lettre minuscule grecque gamma"},
/* 213E */ { "MAJUSCULE GAMMA AJOURÉ","	# <police> 0393 lettre majuscule grecque gamma"},
/* 213F */ { "MAJUSCULE PI AJOURÉ","	# <police> 03A0 lettre majuscule grecque pi"},
/* 2140 */ { "SOMMATION DE LA FAMILLE AJOURÉ","	# <police> 2211 sommation de la famille"},
/* 2141 */ { "MAJUSCULE G CULBUTÉ SANS EMPATTEMENT",NULL},
/* 2142 */ { "MAJUSCULE L CULBUTÉ SANS EMPATTEMENT",NULL},
/* 2143 */ { "MAJUSCULE L RÉFLÉCHI SANS EMPATTEMENT",NULL},
/* 2144 */ { "MAJUSCULE Y CULBUTÉ SANS EMPATTEMENT",NULL},
/* 2145 */ { "MAJUSCULE D ITALIQUE AJOURÉ","	* représente parfois la différentielle\n"
	"	# <police> 0044 lettre majuscule latine d"},
/* 2146 */ { "MINUSCULE D ITALIQUE AJOURÉ","	* représente parfois la différentielle\n"
	"	# <police> 0064 lettre minuscule latine d"},
/* 2147 */ { "MINUSCULE E ITALIQUE AJOURÉ","	* représente parfois l'exposant naturel\n"
	"	# <police> 0065 lettre minuscule latine e"},
/* 2148 */ { "MINUSCULE I ITALIQUE AJOURÉ","	* représente parfois l'unité imaginaire\n"
	"	# <police> 0069 lettre minuscule latine i"},
/* 2149 */ { "MINUSCULE J ITALIQUE AJOURÉ","	* représente parfois l'unité imaginaire\n"
	"	# <police> 006A lettre minuscule latine j"},
/* 214A */ { "LIMITE DE PROPRIÉTÉ",NULL},
/* 214B */ { "PERLUÈTE CULBUTÉE","	* utilisée en logique linéaire\n"
	"	x (perluète - 0026)"},
/* 214C */ { "SYMBOLE PER","	* représente le mot latin « per »"},
/* 214D */ { "AKTIESELSKAB","	x (aux bons soins de - 2101)"},
/* 214E */ { "MINUSCULE F CULBUTÉ","	* la majuscule est 2132\n"
	"	x (lettre minuscule grecque digamma - 03DD)"},
/* 214F */ { "SYMBOLE INDIQUANT UNE SOURCE SAMARITAINE",NULL},
/* 2150 */ { "FRACTION ORDINAIRE UN SEPTIÈME","	# <fraction> 0031 2044 0037"},
/* 2151 */ { "FRACTION ORDINAIRE UN NEUVIÈME","	# <fraction> 0031 2044 0039"},
/* 2152 */ { "FRACTION ORDINAIRE UN DIXIÈME","	# <fraction> 0031 2044 0031 0030"},
/* 2153 */ { "FRACTION ORDINAIRE UN TIERS","	# <fraction> 0031 2044 0033"},
/* 2154 */ { "FRACTION ORDINAIRE DEUX TIERS","	# <fraction> 0032 2044 0033"},
/* 2155 */ { "FRACTION ORDINAIRE UN CINQUIÈME","	# <fraction> 0031 2044 0035"},
/* 2156 */ { "FRACTION ORDINAIRE DEUX CINQUIÈMES","	# <fraction> 0032 2044 0035"},
/* 2157 */ { "FRACTION ORDINAIRE TROIS CINQUIÈMES","	# <fraction> 0033 2044 0035"},
/* 2158 */ { "FRACTION ORDINAIRE QUATRE CINQUIÈMES","	# <fraction> 0034 2044 0035"},
/* 2159 */ { "FRACTION ORDINAIRE UN SIXIÈME","	# <fraction> 0031 2044 0036"},
/* 215A */ { "FRACTION ORDINAIRE CINQ SIXIÈMES","	# <fraction> 0035 2044 0036"},
/* 215B */ { "FRACTION ORDINAIRE UN HUITIÈME","	# <fraction> 0031 2044 0038"},
/* 215C */ { "FRACTION ORDINAIRE TROIS HUITIÈMES","	# <fraction> 0033 2044 0038"},
/* 215D */ { "FRACTION ORDINAIRE CINQ HUITIÈMES","	# <fraction> 0035 2044 0038"},
/* 215E */ { "FRACTION ORDINAIRE SEPT HUITIÈMES","	# <fraction> 0037 2044 0038"},
/* 215F */ { "NUMÉRATEUR FRACTIONNAIRE UN","	# <fraction> 0031 2044"},
/* 2160 */ { "CHIFFRE ROMAIN UN","	# 0049 lettre majuscule latine i"},
/* 2161 */ { "CHIFFRE ROMAIN DEUX","	# 0049 0049"},
/* 2162 */ { "CHIFFRE ROMAIN TROIS","	# 0049 0049 0049"},
/* 2163 */ { "CHIFFRE ROMAIN QUATRE","	* parfois écrit IIII (en horlogerie, notoirement)\n"
	"	# 0049 0056"},
/* 2164 */ { "CHIFFRE ROMAIN CINQ","	# 0056 lettre majuscule latine v"},
/* 2165 */ { "CHIFFRE ROMAIN SIX","	# 0056 0049"},
/* 2166 */ { "CHIFFRE ROMAIN SEPT","	# 0056 0049 0049"},
/* 2167 */ { "CHIFFRE ROMAIN HUIT","	# 0056 0049 0049 0049"},
/* 2168 */ { "CHIFFRE ROMAIN NEUF","	# 0049 0058"},
/* 2169 */ { "CHIFFRE ROMAIN DIX","	# 0058 lettre majuscule latine x"},
/* 216A */ { "CHIFFRE ROMAIN ONZE","	# 0058 0049"},
/* 216B */ { "CHIFFRE ROMAIN DOUZE","	# 0058 0049 0049"},
/* 216C */ { "CHIFFRE ROMAIN CINQUANTE","	# 004C lettre majuscule latine l"},
/* 216D */ { "CHIFFRE ROMAIN CENT","	# 0043 lettre majuscule latine c"},
/* 216E */ { "CHIFFRE ROMAIN CINQ CENTS","	# 0044 lettre majuscule latine d"},
/* 216F */ { "CHIFFRE ROMAIN MILLE","	# 004D lettre majuscule latine m"},
/* 2170 */ { "CHIFFRE ROMAIN MINUSCULE UN","	# 0069 lettre minuscule latine i"},
/* 2171 */ { "CHIFFRE ROMAIN MINUSCULE DEUX","	# 0069 0069"},
/* 2172 */ { "CHIFFRE ROMAIN MINUSCULE TROIS","	# 0069 0069 0069"},
/* 2173 */ { "CHIFFRE ROMAIN MINUSCULE QUATRE","	# 0069 0076"},
/* 2174 */ { "CHIFFRE ROMAIN MINUSCULE CINQ","	# 0076 lettre minuscule latine v"},
/* 2175 */ { "CHIFFRE ROMAIN MINUSCULE SIX","	# 0076 0069"},
/* 2176 */ { "CHIFFRE ROMAIN MINUSCULE SEPT","	# 0076 0069 0069"},
/* 2177 */ { "CHIFFRE ROMAIN MINUSCULE HUIT","	# 0076 0069 0069 0069"},
/* 2178 */ { "CHIFFRE ROMAIN MINUSCULE NEUF","	# 0069 0078"},
/* 2179 */ { "CHIFFRE ROMAIN MINUSCULE DIX","	# 0078 lettre minuscule latine x"},
/* 217A */ { "CHIFFRE ROMAIN MINUSCULE ONZE","	# 0078 0069"},
/* 217B */ { "CHIFFRE ROMAIN MINUSCULE DOUZE","	# 0078 0069 0069"},
/* 217C */ { "CHIFFRE ROMAIN MINUSCULE CINQUANTE","	# 006C lettre minuscule latine l"},
/* 217D */ { "CHIFFRE ROMAIN MINUSCULE CENT","	# 0063 lettre minuscule latine c"},
/* 217E */ { "CHIFFRE ROMAIN MINUSCULE CINQ CENTS","	# 0064 lettre minuscule latine d"},
/* 217F */ { "CHIFFRE ROMAIN MINUSCULE MILLE","	# 006D lettre minuscule latine m"},
/* 2180 */ { "CHIFFRE ROMAIN MILLE C D",NULL},
/* 2181 */ { "CHIFFRE ROMAIN CINQ MILLE",NULL},
/* 2182 */ { "CHIFFRE ROMAIN DIX MILLE",NULL},
/* 2183 */ { "CHIFFRE ROMAIN CENT RÉFLÉCHI","	= C apostrophique\n"
	"	= antisigma claudien\n"
	"	* s'utilise avec C et I pour former de grands nombres\n"
	"	* la minuscule est 2184\n"
	"	x (symbole grec sigma lunaire majuscule réfléchi - 03FD)"},
/* 2184 */ { "LETTRE MINUSCULE LATINE C RÉFLÉCHI","	x (symbole grec sigma lunaire minuscule réfléchi - 037B)"},
/* 2185 */ { "CHIFFRE ROMAIN SIX FORME TARDIVE","	x (lettre grecque stigma - 03DA)"},
/* 2186 */ { "CHIFFRE ROMAIN CINQUANTE FORME ARCHAÏQUE","	x (lettre runique z - 16CE)\n"
	"	x (flèche vers le bas - 2193)"},
/* 2187 */ { "CHIFFRE ROMAIN CINQUANTE MILLE",NULL},
/* 2188 */ { "CHIFFRE ROMAIN CENT MILLE",NULL},
/* 2189 */ { "FRACTION ORDINAIRE ZÉRO TIERS","	* s'utilise pour les scores de baseball, tiré d'ARIB STD-B24\n"
	"	# <fraction> 0030 2044 0033"},
/* 218A */ { "CHIFFRE DEUX CULBUTÉ",NULL},
/* 218B */ { "CHIFFRE TROIS CULBUTÉ","	x (lettre majuscule latine e ouvert - 0190)\n"
	"	x (constante d'euler - 2107)\n"
	"	x (lettre minuscule latine tresillo - A72B)"},
/* 218C */ { NULL,NULL},
/* 218D */ { NULL,NULL},
/* 218E */ { NULL,NULL},
/* 218F */ { NULL,NULL},
/* 2190 */ { "FLÈCHE VERS LA GAUCHE","	x (diacritique flèche vers la gauche couvrante - 20EA)"},
/* 2191 */ { "FLÈCHE VERS LE HAUT","	* API : phonation égressive"},
/* 2192 */ { "FLÈCHE VERS LA DROITE","	= fonction totale (notation z)"},
/* 2193 */ { "FLÈCHE VERS LE BAS","	* API : phonation ingressive"},
/* 2194 */ { "FLÈCHE GAUCHE-DROITE","	= relation binaire (notation z)"},
/* 2195 */ { "FLÈCHE HAUT-BAS",NULL},
/* 2196 */ { "FLÈCHE NORD-OUEST",NULL},
/* 2197 */ { "FLÈCHE NORD-EST",NULL},
/* 2198 */ { "FLÈCHE SUD-EST",NULL},
/* 2199 */ { "FLÈCHE SUD-OUEST",NULL},
/* 219A */ { "FLÈCHE VERS LA GAUCHE BARRÉE","	* négation de 2190\n"
	"	: 2190 0338"},
/* 219B */ { "FLÈCHE VERS LA DROITE BARRÉE","	* négation de 2192\n"
	"	: 2192 0338"},
/* 219C */ { "FLÈCHE VERS LA GAUCHE ONDULÉE","	x (flèche ondulée pointant directement à gauche - 2B3F)"},
/* 219D */ { "FLÈCHE VERS LA DROITE ONDULÉE",NULL},
/* 219E */ { "FLÈCHE À DEUX POINTES VERS LA GAUCHE","	= déplacement rapide du curseur vers la gauche\n"
	"	x (flèche à deux pointes triangulaires vers la gauche - 2BEC)"},
/* 219F */ { "FLÈCHE À DEUX POINTES VERS LE HAUT","	= déplacement rapide du curseur vers le haut"},
/* 21A0 */ { "FLÈCHE À DEUX POINTES VERS LA DROITE","	= déplacement rapide du curseur vers la droite\n"
	"	= surjection totale (notation z)"},
/* 21A1 */ { "FLÈCHE À DEUX POINTES VERS LE BAS","	= déplacement rapide du curseur vers le bas\n"
	"	= page suivante"},
/* 21A2 */ { "FLÈCHE VERS LA GAUCHE EMPENNÉE",NULL},
/* 21A3 */ { "FLÈCHE VERS LA DROITE EMPENNÉE","	= injection totale (notation z)"},
/* 21A4 */ { "FLÈCHE D'UN TAQUET VERS LA GAUCHE","	= flèche à socle, flèche à béquillon"},
/* 21A5 */ { "FLÈCHE D'UN TAQUET VERS LE HAUT",NULL},
/* 21A6 */ { "FLÈCHE D'UN TAQUET VERS LA DROITE","	= flèche à socle, flèche à béquillon"},
/* 21A7 */ { "FLÈCHE D'UN TAQUET VERS LE BAS","	= symbole de profondeur"},
/* 21A8 */ { "FLÈCHE HAUT-BAS SUR BASE",NULL},
/* 21A9 */ { "FLÈCHE VERS LA GAUCHE À CROCHET",NULL},
/* 21AA */ { "FLÈCHE VERS LA DROITE À CROCHET",NULL},
/* 21AB */ { "FLÈCHE VERS LA GAUCHE À BOUCLE",NULL},
/* 21AC */ { "FLÈCHE VERS LA DROITE À BOUCLE",NULL},
/* 21AD */ { "FLÈCHE GAUCHE-DROITE ONDULÉE",NULL},
/* 21AE */ { "FLÈCHE GAUCHE-DROITE BARRÉE","	* négation de 2194\n"
	"	: 2194 0338"},
/* 21AF */ { "FLÈCHE VERS LE BAS EN ZIGZAG","	= électrolyse\n"
	"	x (flèche à pointe en triangle vers le bas en zigzag - 2B4D)"},
/* 21B0 */ { "FLÈCHE VERS LE HAUT AVEC POINTE VERS LA GAUCHE",NULL},
/* 21B1 */ { "FLÈCHE VERS LE HAUT AVEC POINTE VERS LA DROITE",NULL},
/* 21B2 */ { "FLÈCHE VERS LE BAS AVEC POINTE VERS LA GAUCHE",NULL},
/* 21B3 */ { "FLÈCHE VERS LE BAS AVEC POINTE VERS LA DROITE",NULL},
/* 21B4 */ { "FLÈCHE VERS LA DROITE AVEC COIN VERS LE BAS","	= ligne suivante"},
/* 21B5 */ { "FLÈCHE VERS LE BAS AVEC COIN VERS LA GAUCHE","	* peut représenter un retour de chariot ou un passage à la ligne\n"
	"	x (symbole retour de chariot - 23CE)"},
/* 21B6 */ { "FLÈCHE SEMI-CIRCULAIRE SENS ANTIHORAIRE EN CHEF",NULL},
/* 21B7 */ { "FLÈCHE SEMI-CIRCULAIRE SENS HORAIRE EN CHEF",NULL},
/* 21B8 */ { "FLÈCHE NORD-OUEST JUSQU'À UN LONG TAQUET","	= début"},
/* 21B9 */ { "FLÈCHE VERS LA GAUCHE JUSQU'À UN TAQUET SUR FLÈCHE VERS LA DROITE JUSQU'À UN TAQUET","	= tabulation à droite et à gauche\n"
	"	x (touche de tabulation horizontale - 2B7E)"},
/* 21BA */ { "FLÈCHE CIRCULAIRE OUVERTE SENS ANTIHORAIRE",NULL},
/* 21BB */ { "FLÈCHE CIRCULAIRE OUVERTE SENS HORAIRE",NULL},
/* 21BC */ { "HARPON VERS LA GAUCHE AVEC BARBILLON VERS LE HAUT",NULL},
/* 21BD */ { "HARPON VERS LA GAUCHE AVEC BARBILLON VERS LE BAS",NULL},
/* 21BE */ { "HARPON VERS LE HAUT AVEC BARBILLON VERS LA DROITE",NULL},
/* 21BF */ { "HARPON VERS LE HAUT AVEC BARBILLON VERS LA GAUCHE",NULL},
/* 21C0 */ { "HARPON VERS LA DROITE AVEC BARBILLON VERS LE HAUT",NULL},
/* 21C1 */ { "HARPON VERS LA DROITE AVEC BARBILLON VERS LE BAS",NULL},
/* 21C2 */ { "HARPON VERS LE BAS AVEC BARBILLON VERS LA DROITE",NULL},
/* 21C3 */ { "HARPON VERS LE BAS AVEC BARBILLON VERS LA GAUCHE",NULL},
/* 21C4 */ { "FLÈCHE VERS LA DROITE SUR FLÈCHE VERS LA GAUCHE",NULL},
/* 21C5 */ { "FLÈCHE VERS LE HAUT À GAUCHE D'UNE FLÈCHE VERS LE BAS",NULL},
/* 21C6 */ { "FLÈCHE VERS LA GAUCHE SUR FLÈCHE VERS LA DROITE",NULL},
/* 21C7 */ { "PAIRE DE FLÈCHES VERS LA GAUCHE",NULL},
/* 21C8 */ { "PAIRE DE FLÈCHES VERS LE HAUT",NULL},
/* 21C9 */ { "PAIRE DE FLÈCHES VERS LA DROITE",NULL},
/* 21CA */ { "PAIRE DE FLÈCHES VERS LE BAS",NULL},
/* 21CB */ { "HARPON VERS LA GAUCHE SUR HARPON VERS LA DROITE",NULL},
/* 21CC */ { "HARPON VERS LA DROITE SUR HARPON VERS LA GAUCHE",NULL},
/* 21CD */ { "DOUBLE FLÈCHE VERS LA GAUCHE BARRÉE","	* négation de 21D0\n"
	"	: 21D0 0338"},
/* 21CE */ { "DOUBLE FLÈCHE GAUCHE-DROITE BARRÉE","	* négation de 21D4\n"
	"	: 21D4 0338"},
/* 21CF */ { "DOUBLE FLÈCHE VERS LA DROITE BARRÉE","	* négation de 21D2\n"
	"	: 21D2 0338"},
/* 21D0 */ { "DOUBLE FLÈCHE VERS LA GAUCHE",NULL},
/* 21D1 */ { "DOUBLE FLÈCHE VERS LE HAUT",NULL},
/* 21D2 */ { "DOUBLE FLÈCHE VERS LA DROITE",NULL},
/* 21D3 */ { "DOUBLE FLÈCHE VERS LE BAS",NULL},
/* 21D4 */ { "DOUBLE FLÈCHE GAUCHE-DROITE",NULL},
/* 21D5 */ { "DOUBLE FLÈCHE HAUT-BAS",NULL},
/* 21D6 */ { "DOUBLE FLÈCHE NORD-OUEST",NULL},
/* 21D7 */ { "DOUBLE FLÈCHE NORD-EST",NULL},
/* 21D8 */ { "DOUBLE FLÈCHE SUD-EST",NULL},
/* 21D9 */ { "DOUBLE FLÈCHE SUD-OUEST",NULL},
/* 21DA */ { "TRIPLE FLÈCHE VERS LA GAUCHE",NULL},
/* 21DB */ { "TRIPLE FLÈCHE VERS LA DROITE",NULL},
/* 21DC */ { "FLÈCHE VERS LA GAUCHE EN TIRE-BOUCHON","	= flèche gauche dentée\n"
	"	x (longue flèche vers la gauche en tire-bouchon - 2B33)"},
/* 21DD */ { "FLÈCHE VERS LA DROITE EN TIRE-BOUCHON","	= flèche droite dentée"},
/* 21DE */ { "FLÈCHE VERS LE HAUT AVEC DOUBLE BARRE","	= page précédente"},
/* 21DF */ { "FLÈCHE VERS LE BAS AVEC DOUBLE BARRE","	= page suivante"},
/* 21E0 */ { "FLÈCHE À TRAITS DISCONTINUS VERS LA GAUCHE",NULL},
/* 21E1 */ { "FLÈCHE À TRAITS DISCONTINUS VERS LE HAUT",NULL},
/* 21E2 */ { "FLÈCHE À TRAITS DISCONTINUS VERS LA DROITE",NULL},
/* 21E3 */ { "FLÈCHE À TRAITS DISCONTINUS VERS LE BAS",NULL},
/* 21E4 */ { "FLÈCHE VERS LA GAUCHE JUSQU'À UN TAQUET","	= tabulation vers la gauche"},
/* 21E5 */ { "FLÈCHE VERS LA DROITE JUSQU'À UN TAQUET","	= tabulation vers la droite"},
/* 21E6 */ { "FLÈCHE BLANCHE VERS LA GAUCHE","	x (flèche blanche nord-est - 2B00)"},
/* 21E7 */ { "FLÈCHE BLANCHE VERS LE HAUT","	= majuscules\n"
	"	= sélection du niveau 2 (ISO 9995-7)"},
/* 21E8 */ { "FLÈCHE BLANCHE VERS LA DROITE","	= sélection de groupe (ISO 9995-7)"},
/* 21E9 */ { "FLÈCHE BLANCHE VERS LE BAS",NULL},
/* 21EA */ { "FLÈCHE BLANCHE D'UN TAQUET VERS LE HAUT","	= verrouillage des majuscules"},
/* 21EB */ { "FLÈCHE BLANCHE VERS LE HAUT SUR SOCLE","	= verrouillage niveau 2"},
/* 21EC */ { "FLÈCHE BLANCHE VERS LE HAUT SUR SOCLE ET TRAIT HORIZONTAL","	= verrouillage des majuscules\n"
	"	* pour l'ISO/CEI 9995-7, cette fonction est l'équivalent de 21EB sur certains claviers et pour certaines touches\n"
	"	x (flèche blanche d'un taquet vers le haut barrée horizontalement - 2BB8)"},
/* 21ED */ { "FLÈCHE BLANCHE VERS LE HAUT SUR SOCLE ET BARRE VERTICALE","	= verrouillage numérique"},
/* 21EE */ { "DOUBLE FLÈCHE BLANCHE VERS LE HAUT","	= sélection du niveau 3"},
/* 21EF */ { "DOUBLE FLÈCHE BLANCHE VERS LE HAUT SUR SOCLE","	= verrouillage niveau 3"},
/* 21F0 */ { "FLÈCHE BLANCHE D'UN MUR VERS LA DROITE","	= verrouillage de groupe"},
/* 21F1 */ { "FLÈCHE NORD-OUEST EN ENCOIGNURE","	= début"},
/* 21F2 */ { "FLÈCHE SUD-EST EN ENCOIGNURE","	= fin"},
/* 21F3 */ { "FLÈCHE BLANCHE HAUT-BAS","	= défilement\n"
	"	x (flèche blanche gauche-droite - 2B04)"},
/* 21F4 */ { "FLÈCHE VERS LA DROITE À PETIT CERCLE","	x (flèche vers la gauche à petit cercle - 2B30)"},
/* 21F5 */ { "FLÈCHE VERS LE BAS À GAUCHE D'UNE FLÈCHE VERS LE HAUT",NULL},
/* 21F6 */ { "TROIS FLÈCHES VERS LA DROITE","	x (trois flèches vers la gauche - 2B31)"},
/* 21F7 */ { "FLÈCHE VERS LA GAUCHE BARRÉE VERTICALEMENT",NULL},
/* 21F8 */ { "FLÈCHE VERS LA DROITE BARRÉE VERTICALEMENT","	= fonction partielle en notation z"},
/* 21F9 */ { "FLÈCHE VERS LA DROITE ET LA GAUCHE BARRÉE VERTICALEMENT","	= relation partielle en notation z"},
/* 21FA */ { "FLÈCHE VERS LA GAUCHE BARRÉE DEUX FOIS VERTICALEMENT",NULL},
/* 21FB */ { "FLÈCHE VERS LA DROITE BARRÉE DEUX FOIS VERTICALEMENT","	= fonction finie en notation z"},
/* 21FC */ { "FLÈCHE GAUCHE-DROITE BARRÉE DEUX FOIS VERTICALEMENT","	= relation finie en notation z"},
/* 21FD */ { "FLÈCHE VERS LA GAUCHE À TÊTE CREUSE",NULL},
/* 21FE */ { "FLÈCHE VERS LA DROITE À TÊTE CREUSE",NULL},
/* 21FF */ { "FLÈCHE VERS LA DROITE ET LA GAUCHE À TÊTE CREUSE",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_22[] = {
/* 2200 */ { "POUR TOUS","	= quanteur quel que soit, quanteur universel"},
/* 2201 */ { "COMPLÉMENT","	x (lettre latine c étiré - 0297)"},
/* 2202 */ { "DÉRIVÉE PARTIELLE","	= d rond"},
/* 2203 */ { "IL EXISTE","	= quanteur existe"},
/* 2204 */ { "IL N'EXISTE PAS","	: 2203 0338"},
/* 2205 */ { "ENSEMBLE VIDE","	* s'utilise en linguistique pour indiquer un morphème nul ou un « zéro » phonologique\n"
	"	x (lettre majuscule latine o barré obliquement - 00D8)\n"
	"	x (symbole diamètre - 2300)\n"
	"	~ 2205 FE00 sous la forme d'un zéro avec une longue barre diagonale couvrante"},
/* 2206 */ { "INCRÉMENT","	= laplacien\n"
	"	= disjonction exclusive\n"
	"	= différence symétrique (dans la théorie des ensembles)\n"
	"	* d'autres symboles peuvent être utilisés pour la différence symétrique\n"
	"	x (lettre majuscule grecque delta - 0394)\n"
	"	x (triangle blanc pointant vers le haut - 25B3)"},
/* 2207 */ { "NABLA","	= atled\n"
	"	= gradient, del\n"
	"	= laplacien\n"
	"	* utilisé pour l'opérateur laplacien avec un exposant 2\n"
	"	x (triangle blanc pointant vers le bas - 25BD)"},
/* 2208 */ { "APPARTIENT À",NULL},
/* 2209 */ { "N'APPARTIENT PAS À","	: 2208 0338"},
/* 220A */ { "PETIT APPARTIENT À","	* trouve son origine dans les « fontes pi » mathématiques ; il ne s'agit pas de l'epsilon normal\n"
	"	x (symbole grec epsilon lunaire - 03F5)"},
/* 220B */ { "CONTIENT COMME ÉLÉMENT",NULL},
/* 220C */ { "NE CONTIENT PAS COMME ÉLÉMENT","	: 220B 0338"},
/* 220D */ { "PETIT CONTIENT COMME ÉLÉMENT","	x (symbole grec epsilon lunaire réfléchi - 03F6)"},
/* 220E */ { "CE QU'IL FALLAIT DÉMONTRER","	= CQFD\n"
	"	x (puce triangulaire - 2023)\n"
	"	x (rectangle vertical noir - 25AE)"},
/* 220F */ { "PRODUIT DE LA FAMILLE","	= signe produit\n"
	"	x (lettre majuscule grecque pi - 03A0)"},
/* 2210 */ { "COPRODUIT DE LA FAMILLE","	= signe coproduit"},
/* 2211 */ { "SOMMATION DE LA FAMILLE","	= signe somme\n"
	"	x (lettre majuscule grecque sigma - 03A3)\n"
	"	x (sommation de la famille ajouré - 2140)"},
/* 2212 */ { "SIGNE MOINS","	= soustraction\n"
	"	x (trait d'union-signe moins - 002D)\n"
	"	x (signe moins épais - 2796)"},
/* 2213 */ { "SIGNE MOINS-OU-PLUS","	x (signe plus-ou-moins - 00B1)"},
/* 2214 */ { "PLUS POINTÉ",NULL},
/* 2215 */ { "BARRE OBLIQUE DE DIVISION","	* opérateur de division générique\n"
	"	x (barre oblique - 002F)\n"
	"	x (barre de fraction - 2044)\n"
	"	x (diagonale mathématique ascendante - 27CB)"},
/* 2216 */ { "DIFFÉRENCE D'ENSEMBLES","	x (barre oblique inversée - 005C)\n"
	"	x (diagonale mathématique descendante - 27CD)\n"
	"	x (opérateur barre oblique inversée - 29F5)"},
/* 2217 */ { "OPÉRATEUR ASTÉRISQUE","	x (astérisque - 002A)"},
/* 2218 */ { "OPÉRATEUR ROND","	= rond, fonction composée\n"
	"	x (symbole degré - 00B0)\n"
	"	x (signe d'abréviation dévanâgarî - 0970)\n"
	"	x (puce blanche - 25E6)\n"
	"	x (signe d'abréviation avestique - 10B39)"},
/* 2219 */ { "OPÉRATEUR PUCE","	x (point médian - 00B7)\n"
	"	x (puce - 2022)\n"
	"	x (point de conduite simple - 2024)"},
/* 221A */ { "RACINE CARRÉE","	= radical\n"
	"	x (coche - 2713)"},
/* 221B */ { "RACINE CUBIQUE","	x (racine cubique arabo-indienne - 0606)"},
/* 221C */ { "RACINE QUATRIÈME","	x (racine quatrième arabo-indienne - 0607)"},
/* 221D */ { "PROPORTIONNEL À","	x (lettre minuscule grecque alpha - 03B1)"},
/* 221E */ { "INFINI",NULL},
/* 221F */ { "ANGLE DROIT",NULL},
/* 2220 */ { "ANGLE","	x (angle aigu - 299F)"},
/* 2221 */ { "ANGLE MESURÉ",NULL},
/* 2222 */ { "ANGLE SPHÉRIQUE","	= arc angulaire"},
/* 2223 */ { "EST UN DIVISEUR DE","	= tel que\n"
	"	= tige APL\n"
	"	x (barre verticale - 007C)\n"
	"	x (lettre latine clic dental - 01C0)"},
/* 2224 */ { "N'EST PAS UN DIVISEUR DE","	: 2223 0338"},
/* 2225 */ { "PARALLÈLE À","	x (lettre latine clic latéral - 01C1)\n"
	"	x (double ligne verticale - 2016)"},
/* 2226 */ { "NON PARALLÈLE À","	: 2225 0338"},
/* 2227 */ { "ET LOGIQUE","	= conjonction\n"
	"	x (et logique de la famille - 22C0)\n"
	"	x (pointe de flèche vers le haut - 2303)"},
/* 2228 */ { "OU LOGIQUE","	= disjonction, vel\n"
	"	x (ou logique de la famille - 22C1)\n"
	"	x (pointe de flèche vers le bas - 2304)"},
/* 2229 */ { "INTERSECTION","	= inter\n"
	"	x (intersection de la famille - 22C2)\n"
	"	~ 2229 FE00 avec des empattements"},
/* 222A */ { "UNION","	= réunion\n"
	"	x (réunion de la famille - 22C3)\n"
	"	~ 222A FE00 avec des empattements"},
/* 222B */ { "INTÉGRALE","	x (lettre minuscule latine ech - 0283)"},
/* 222C */ { "INTÉGRALE DOUBLE","	# 222B 222B"},
/* 222D */ { "INTÉGRALE TRIPLE","	x (intégrale quadruple - 2A0C)\n"
	"	# 222B 222B 222B"},
/* 222E */ { "INTÉGRALE DE CONTOUR","	x (intégrale autour d'un opérateur point - 2A15)"},
/* 222F */ { "INTÉGRALE DE SURFACE","	# 222E 222E"},
/* 2230 */ { "INTÉGRALE DE VOLUME","	# 222E 222E 222E"},
/* 2231 */ { "INTÉGRALE SENS HORAIRE",NULL},
/* 2232 */ { "INTÉGRALE DE CONTOUR SENS HORAIRE",NULL},
/* 2233 */ { "INTÉGRALE DE CONTOUR SENS ANTIHORAIRE","	* les flèches sens horaire et sens antihoraire ne sont pas inversées lors de la composition en miroir, alors que le signe normal de l'intégrale sera réfléchi"},
/* 2234 */ { "PAR CONSÉQUENT","	= donc\n"
	"	x (site historique - 26EC)"},
/* 2235 */ { "PARCE QUE",NULL},
/* 2236 */ { "RAPPORT","	* préféré à 003A pour le signe de division ou d'échelle dans les emplois mathématiques\n"
	"	x (deux-points - 003A)"},
/* 2237 */ { "PROPORTION",NULL},
/* 2238 */ { "MOINS POINTÉ","	= soustraction saturante\n"
	"	* parfois présenté comme le symbole pour la différence symétrique de deux ensembles, mais l'emploi de 2206 est recommandé pour cet usage"},
/* 2239 */ { "EXCÈS",NULL},
/* 223A */ { "PROPORTION GÉOMÉTRIQUE",NULL},
/* 223B */ { "HOMOTHÉTIQUE","	x (opérateur tilde avec points ascendants - 2A6B)"},
/* 223C */ { "OPÉRATEUR TILDE","	= varié avec (proportionnel à)\n"
	"	= similaire à\n"
	"	= non\n"
	"	= cycle\n"
	"	= équivalent\n"
	"	= tilde APL\n"
	"	x (tilde - 007E)\n"
	"	x (signe négation - 00AC)\n"
	"	x (petit tilde - 02DC)"},
/* 223D */ { "OPÉRATEUR TILDE RÉFLÉCHI","	= s couché\n"
	"	* le tilde renversé et le s couché sont des variantes de glyphe"},
/* 223E */ { "S COUCHÉ RENVERSÉ","	= le plus positif"},
/* 223F */ { "SINUSOÏDE","	= courant alternatif"},
/* 2240 */ { "PRODUIT COURONNE",NULL},
/* 2241 */ { "NON TILDE","	= pas équivalent\n"
	"	: 223C 0338"},
/* 2242 */ { "MOINS TILDE",NULL},
/* 2243 */ { "ASYMPTOTIQUEMENT ÉGAL À",NULL},
/* 2244 */ { "NON ASYMPTOTIQUEMENT ÉGAL À","	: 2243 0338"},
/* 2245 */ { "APPROXIMATIVEMENT ÉGAL À",NULL},
/* 2246 */ { "APPROXIMATIVEMENT MAIS NON STRICTEMENT ÉGAL À",NULL},
/* 2247 */ { "NI APPROXIMATIVEMENT NI STRICTEMENT ÉGAL À","	: 2245 0338"},
/* 2248 */ { "PRESQUE ÉGAL À","	= asymptotique à"},
/* 2249 */ { "NON PRESQUE ÉGAL À","	: 2248 0338"},
/* 224A */ { "PRESQUE ÉGAL OU ÉGAL À",NULL},
/* 224B */ { "TRIPLE TILDE",NULL},
/* 224C */ { "ENTIÈREMENT ÉGAL À","	* le tilde renversé et le s couché sont des variantes de glyphe"},
/* 224D */ { "ÉQUIVALENT À",NULL},
/* 224E */ { "GÉOMÉTRIQUEMENT ÉQUIVALENT À",NULL},
/* 224F */ { "DIFFÉRENCE ENTRE",NULL},
/* 2250 */ { "TEND VERS LA LIMITE",NULL},
/* 2251 */ { "GÉOMÉTRIQUEMENT ÉGAL À",NULL},
/* 2252 */ { "APPROXIMATIVEMENT ÉGAL À OU IMAGE DE","	= presque égal à"},
/* 2253 */ { "IMAGE DE OU APPROXIMATIVEMENT ÉGAL À",NULL},
/* 2254 */ { "DEUX-POINTS ÉGAL",NULL},
/* 2255 */ { "ÉGAL DEUX-POINTS",NULL},
/* 2256 */ { "ROND DANS ÉGAL",NULL},
/* 2257 */ { "ÉGAL AVEC ROND EN CHEF","	= approximativement égal à"},
/* 2258 */ { "CORRESPOND À",NULL},
/* 2259 */ { "ESTIME","	= correspond à"},
/* 225A */ { "ÉQUIANGULAIRE À",NULL},
/* 225B */ { "ÉGAL AVEC ÉTOILE EN CHEF",NULL},
/* 225C */ { "ÉGAL DELTA","	= équiangulaire\n"
	"	= égal par définition à"},
/* 225D */ { "ÉGAL PAR DÉFINITION À",NULL},
/* 225E */ { "MESURÉ PAR",NULL},
/* 225F */ { "ÉGALITÉ EN DOUTE",NULL},
/* 2260 */ { "PAS ÉGAL À","	x (signe égal - 003D)\n"
	"	x (lettre latine clic alvéolaire - 01C2)\n"
	"	: 003D 0338"},
/* 2261 */ { "IDENTIQUE À","	= congru à, identiteur"},
/* 2262 */ { "NON IDENTIQUE À","	: 2261 0338"},
/* 2263 */ { "STRICTEMENT ÉQUIVALENT À",NULL},
/* 2264 */ { "INFÉRIEUR OU ÉGAL À",NULL},
/* 2265 */ { "SUPÉRIEUR OU ÉGAL À",NULL},
/* 2266 */ { "INFÉRIEUR À SUR ÉGAL À",NULL},
/* 2267 */ { "SUPÉRIEUR À SUR ÉGAL À",NULL},
/* 2268 */ { "INFÉRIEUR MAIS PAS ÉGAL À","	~ 2268 FE00 avec une barre verticale"},
/* 2269 */ { "SUPÉRIEUR MAIS PAS ÉGAL À","	~ 2269 FE00 avec une barre verticale"},
/* 226A */ { "TRÈS INFÉRIEUR À","	x (guillemet gauche - 00AB)"},
/* 226B */ { "TRÈS SUPÉRIEUR À","	x (guillemet droit - 00BB)"},
/* 226C */ { "ENTRE",NULL},
/* 226D */ { "NON ÉQUIVALENT À","	: 224D 0338"},
/* 226E */ { "PAS INFÉRIEUR À","	: 003C 0338"},
/* 226F */ { "PAS SUPÉRIEUR À","	: 003E 0338"},
/* 2270 */ { "NI INFÉRIEUR NI ÉGAL À","	: 2264 0338"},
/* 2271 */ { "NI SUPÉRIEUR NI ÉGAL À","	: 2265 0338"},
/* 2272 */ { "INFÉRIEUR OU ÉQUIVALENT À","	~ 2272 FE00 suivant l'inclinaison de la jambe inférieure"},
/* 2273 */ { "SUPÉRIEUR OU ÉQUIVALENT À","	~ 2273 FE00 suivant l'inclinaison de la jambe inférieure"},
/* 2274 */ { "NI INFÉRIEUR NI ÉQUIVALENT À","	: 2272 0338"},
/* 2275 */ { "NI SUPÉRIEUR NI ÉQUIVALENT À","	: 2273 0338"},
/* 2276 */ { "INFÉRIEUR OU SUPÉRIEUR À",NULL},
/* 2277 */ { "SUPÉRIEUR OU INFÉRIEUR À",NULL},
/* 2278 */ { "NI INFÉRIEUR NI SUPÉRIEUR À","	: 2276 0338"},
/* 2279 */ { "NI SUPÉRIEUR NI INFÉRIEUR À","	: 2277 0338"},
/* 227A */ { "PRÉCÈDE","	= est dominé (notation de Hardy)\n"
	"	x (précède sous relation - 22B0)"},
/* 227B */ { "SUIT","	x (suit sous relation - 22B1)"},
/* 227C */ { "PRÉCÈDE OU EST ÉGAL À",NULL},
/* 227D */ { "SUIT OU EST ÉGAL À",NULL},
/* 227E */ { "PRÉCÈDE OU EST ÉQUIVALENT À",NULL},
/* 227F */ { "SUIT OU EST ÉQUIVALENT À",NULL},
/* 2280 */ { "NE PRÉCÈDE PAS","	: 227A 0338"},
/* 2281 */ { "NE SUIT PAS","	: 227B 0338"},
/* 2282 */ { "SOUS-ENSEMBLE DE","	x (crampillon couché gauche - 2E26)"},
/* 2283 */ { "SUR-ENSEMBLE DE","	x (crampillon couché droit - 2E27)"},
/* 2284 */ { "PAS UN SOUS-ENSEMBLE DE","	: 2282 0338"},
/* 2285 */ { "PAS UN SUR-ENSEMBLE DE","	: 2283 0338"},
/* 2286 */ { "SOUS-ENSEMBLE DE OU ÉGAL À",NULL},
/* 2287 */ { "SUR-ENSEMBLE DE OU ÉGAL À",NULL},
/* 2288 */ { "NI UN SOUS-ENSEMBLE DE NI ÉGAL À","	: 2286 0338"},
/* 2289 */ { "NI UN SUR-ENSEMBLE DE NI ÉGAL À","	: 2287 0338"},
/* 228A */ { "SOUS-ENSEMBLE DE MAIS PAS ÉGAL À","	~ 228A FE00 avec une barre à travers les éléments inférieurs"},
/* 228B */ { "SUR-ENSEMBLE DE MAIS PAS ÉGAL À","	~ 228B FE00 avec une barre à travers les éléments inférieurs"},
/* 228C */ { "MULTIENSEMBLE",NULL},
/* 228D */ { "MULTIPLICATION DE MULTIENSEMBLE","	x (opérateur union n-aire pointé - 2A03)\n"
	"	x (intersection pointée - 2A40)"},
/* 228E */ { "UNION DE MULTIENSEMBLE","	= addition de sacs en notation z\n"
	"	x (opérateur union n-aire avec plus - 2A04)"},
/* 228F */ { "IMAGE CARRÉE DE",NULL},
/* 2290 */ { "ORIGINAL CARRÉ DE",NULL},
/* 2291 */ { "IMAGE CARRÉE DE OU ÉGAL À","	= appartient à un sous-sac en notation z"},
/* 2292 */ { "ORIGINAL CARRÉ DE OU ÉGAL À",NULL},
/* 2293 */ { "CHAPEAU CARRÉ","	x (opérateur intersection carré n-aire - 2A05)\n"
	"	~ 2293 FE00 avec des empattements"},
/* 2294 */ { "COUPE CARRÉE","	x (opérateur union carré n-aire - 2A06)\n"
	"	~ 2294 FE00 avec des empattements"},
/* 2295 */ { "PLUS CERCLÉ","	= somme directe\n"
	"	= vecteur pointant vers l'intérieur de la page\n"
	"	x (opérateur plus cerclé n-aire - 2A01)\n"
	"	x (symbole alchimique du vert-de-gris - 1F728)\n"
	"	~ 2295 FE00 avec une bordure blanche"},
/* 2296 */ { "MOINS CERCLÉ","	= différence symétrique\n"
	"	x (cercle avec barre horizontale - 29B5)\n"
	"	x (symbole alchimique du sel - 1F714)"},
/* 2297 */ { "MULTIPLIÉ PAR CERCLÉ","	= produit tensoriel\n"
	"	= vecteur pointant vers l'intérieur de la page\n"
	"	x (voies croisées cerclées - 26D2)\n"
	"	x (opérateur de multiplication n-aire cerclé - 2A02)\n"
	"	x (x cerclé - 2BBE)\n"
	"	~ 2297 FE00 avec une bordure blanche"},
/* 2298 */ { "BARRE OBLIQUE DE DIVISION CERCLÉE",NULL},
/* 2299 */ { "OPÉRATEUR POINT CERCLÉ","	= vecteur pointant hors de la page\n"
	"	= produit direct\n"
	"	x (lettre latine clic bilabial - 0298)\n"
	"	x (soleil - 2609)\n"
	"	x (opérateur point cerclé n-aire - 2A00)"},
/* 229A */ { "OPÉRATEUR ROND CERCLÉ","	x (symbole de fonction apl beigne - 233E)\n"
	"	x (deux cercles concentriques - 25CE)"},
/* 229B */ { "OPÉRATEUR ASTÉRISQUE CERCLÉ","	x (symbole de fonction apl citron - 235F)"},
/* 229C */ { "ÉGAL CERCLÉ","	~ 229C FE00 avec un signe égal touchant le cercle"},
/* 229D */ { "TIRET CERCLÉ",NULL},
/* 229E */ { "PLUS ENCADRÉ",NULL},
/* 229F */ { "MOINS ENCADRÉ",NULL},
/* 22A0 */ { "MULTIPLIÉ PAR ENCADRÉ","	x (case de bulletin marquée d'un x - 2612)\n"
	"	x (sautoir encadré - 26DD)\n"
	"	x (symbole alchimique du mois - 1F771)"},
/* 22A1 */ { "OPÉRATEUR POINT ENCADRÉ","	x (symbole alchimique de l'urine - 1F755)"},
/* 22A2 */ { "TAQUET DROIT","	= tourniquet, portillon\n"
	"	= prouve, implique, fournit\n"
	"	= réductible"},
/* 22A3 */ { "TAQUET GAUCHE","	= tourniquet inversé, portillon inversé\n"
	"	= non-théorème, ne fournit pas"},
/* 22A4 */ { "TAQUET VERS LE BAS","	= dessus\n"
	"	x (signe d'interpolation élevé - 2E06)\n"
	"	x (symbole alchimique du creuset-4 - 1F768)"},
/* 22A5 */ { "TAQUET VERS LE HAUT","	= base, dessous\n"
	"	x (perpendiculaire à - 27C2)"},
/* 22A6 */ { "ASSERTION","	= se réduit à"},
/* 22A7 */ { "MODÉLISE","	= est valide (en logique mathématique)"},
/* 22A8 */ { "VRAI","	= l'énoncé est vrai\n"
	"	= valable\n"
	"	= est une tautologie\n"
	"	= satisfait"},
/* 22A9 */ { "OBLIGE",NULL},
/* 22AA */ { "BARRE VERTICALE TRIPLE AVEC TOURNIQUET À DROITE",NULL},
/* 22AB */ { "BARRE VERTICALE DOUBLE AVEC TOURNIQUET À DROITE DOUBLE",NULL},
/* 22AC */ { "NE PROUVE PAS","	: 22A2 0338"},
/* 22AD */ { "PAS VRAI","	: 22A8 0338"},
/* 22AE */ { "N'OBLIGE PAS","	: 22A9 0338"},
/* 22AF */ { "NON-BARRE VERTICALE DOUBLE AVEC TOURNIQUET À DROITE DOUBLE","	: 22AB 0338"},
/* 22B0 */ { "PRÉCÈDE SOUS RELATION","	x (précède - 227A)"},
/* 22B1 */ { "SUIT SOUS RELATION","	x (suit - 227B)"},
/* 22B2 */ { "SOUS-GROUPE NORMAL DE","	x (pointeur blanc vers la gauche - 25C5)"},
/* 22B3 */ { "CONTIENT COMME SOUS-GROUPE NORMAL","	x (pointeur blanc vers la droite - 25BB)"},
/* 22B4 */ { "SOUS-GROUPE NORMAL DE OU ÉGAL À",NULL},
/* 22B5 */ { "CONTIENT COMME SOUS-GROUPE NORMAL OU ÉGAL À",NULL},
/* 22B6 */ { "ORIGINAL DE",NULL},
/* 22B7 */ { "IMAGE DE",NULL},
/* 22B8 */ { "MULTIJECTION","	= multimap, liste associative"},
/* 22B9 */ { "MATRICE HERMITIENNE CONJUGUÉE",NULL},
/* 22BA */ { "INTERCALE",NULL},
/* 22BB */ { "OU EXCLUSIF","	= aut\n"
	"	x (demi-sextile - 26BA)"},
/* 22BC */ { "NON ET","	x (projective - 2305)\n"
	"	x (quinconce - 26BB)"},
/* 22BD */ { "NON OU",NULL},
/* 22BE */ { "ANGLE DROIT AVEC ARC",NULL},
/* 22BF */ { "TRIANGLE RECTANGLE",NULL},
/* 22C0 */ { "ET LOGIQUE DE LA FAMILLE","	* représente aussi le quanteur universel\n"
	"	x (et logique - 2227)"},
/* 22C1 */ { "OU LOGIQUE DE LA FAMILLE","	* représente aussi le quanteur existe\n"
	"	x (ou logique - 2228)"},
/* 22C2 */ { "INTERSECTION DE LA FAMILLE","	= intersection généralisée en notation z\n"
	"	x (intersection - 2229)"},
/* 22C3 */ { "RÉUNION DE LA FAMILLE","	= union généralisée en notation z\n"
	"	x (union - 222A)"},
/* 22C4 */ { "OPÉRATEUR LOSANGE","	x (losange blanc - 25C7)\n"
	"	x (petit losange noir - 2B29)"},
/* 22C5 */ { "OPÉRATEUR POINT","	* préféré à 00B7 pour noter la multiplication\n"
	"	x (point médian - 00B7)"},
/* 22C6 */ { "OPÉRATEUR ÉTOILE","	* APL\n"
	"	x (étoile à cinq branches arabe - 066D)\n"
	"	x (étoile noire - 2605)\n"
	"	x (étoile moyenne blanche - 2B50)"},
/* 22C7 */ { "DIVISÉ MULTIPLIÉ",NULL},
/* 22C8 */ { "NŒUD PAPILLON","	x (nœud papillon roc - 2445)"},
/* 22C9 */ { "PRODUIT SEMI-DIRECT À GAUCHE DE FACTEUR NORMAL",NULL},
/* 22CA */ { "PRODUIT SEMI-DIRECT À DROITE DE FACTEUR NORMAL",NULL},
/* 22CB */ { "PRODUIT SEMI-DIRECT À GAUCHE",NULL},
/* 22CC */ { "PRODUIT SEMI-DIRECT À DROITE","	x (lambda d'insertion - 2041)"},
/* 22CD */ { "ÉGAL TILDE RENVERSÉ",NULL},
/* 22CE */ { "OU LOGIQUE RECOURBÉ",NULL},
/* 22CF */ { "ET LOGIQUE RECOURBÉ",NULL},
/* 22D0 */ { "SOUS-ENSEMBLE DOUBLE",NULL},
/* 22D1 */ { "SUR-ENSEMBLE DOUBLE",NULL},
/* 22D2 */ { "INTERSECTION DOUBLE",NULL},
/* 22D3 */ { "UNION DOUBLE",NULL},
/* 22D4 */ { "FOURCHE","	= intersection stricte"},
/* 22D5 */ { "ÉGAL ET PARALLÈLE À","	x (carré de visualisation - 2317)"},
/* 22D6 */ { "INFÉRIEUR À AVEC POINT",NULL},
/* 22D7 */ { "SUPÉRIEUR À AVEC POINT",NULL},
/* 22D8 */ { "CONSIDÉRABLEMENT INFÉRIEUR À",NULL},
/* 22D9 */ { "CONSIDÉRABLEMENT SUPÉRIEUR À",NULL},
/* 22DA */ { "INFÉRIEUR OU ÉGAL OU SUPÉRIEUR À","	~ 22DA FE00 avec un égal incliné"},
/* 22DB */ { "SUPÉRIEUR OU ÉGAL OU INFÉRIEUR À","	~ 22DB FE00 avec un égal incliné"},
/* 22DC */ { "ÉGAL OU INFÉRIEUR À",NULL},
/* 22DD */ { "ÉGAL OU SUPÉRIEUR À",NULL},
/* 22DE */ { "ÉGAL OU PRÉCÈDE",NULL},
/* 22DF */ { "ÉGAL OU SUIT",NULL},
/* 22E0 */ { "NI PRÉCÉDANT NI ÉGAL À","	: 227C 0338"},
/* 22E1 */ { "NI SUIVANT NI ÉGAL À","	: 227D 0338"},
/* 22E2 */ { "NI IMAGE CARRÉE DE NI ÉGAL À","	: 2291 0338"},
/* 22E3 */ { "NI ORIGINAL CARRÉ DE NI ÉGAL À","	: 2292 0338"},
/* 22E4 */ { "IMAGE CARRÉE OU DIFFÉRENT DE",NULL},
/* 22E5 */ { "ORIGINAL CARRÉ OU DIFFÉRENT DE",NULL},
/* 22E6 */ { "INFÉRIEUR MAIS NON ÉQUIVALENT À",NULL},
/* 22E7 */ { "SUPÉRIEUR MAIS NON ÉQUIVALENT À",NULL},
/* 22E8 */ { "PRÉCÈDE MAIS NON ÉQUIVALENT À",NULL},
/* 22E9 */ { "SUIT MAIS NON ÉQUIVALENT À",NULL},
/* 22EA */ { "PAS UN SOUS-GROUPE NORMAL DE","	: 22B2 0338"},
/* 22EB */ { "NE CONTIENT PAS COMME SOUS-GROUPE NORMAL","	: 22B3 0338"},
/* 22EC */ { "PAS UN SOUS-GROUPE NORMAL DE NI ÉGAL À","	: 22B4 0338"},
/* 22ED */ { "NI ÉGAL NI CONTENANT COMME SOUS-GROUPE NORMAL","	: 22B5 0338"},
/* 22EE */ { "TROIS POINTS SUSPENDUS","	* ces quatre caractères s'utilisent pour représenter l'élision de rangées ou de colonnes d'une matrice\n"
	"	x (trois-points vertical - 205D)\n"
	"	x (points de suspension - 2026)\n"
	"	x (forme de présentation de points de suspension verticaux - FE19)"},
/* 22EF */ { "TROIS POINTS MÉDIANS",NULL},
/* 22F0 */ { "TROIS POINTS DIAGONAUX VERS LE COIN HAUT À DROITE",NULL},
/* 22F1 */ { "TROIS POINTS DIAGONAUX VERS LE COIN BAS À DROITE",NULL},
/* 22F2 */ { "APPARTIENT À AVEC LONG TRAIT HORIZONTAL",NULL},
/* 22F3 */ { "APPARTIENT À AVEC BARRE VERTICALE AU BOUT DU TRAIT HORIZONTAL",NULL},
/* 22F4 */ { "PETIT APPARTIENT À AVEC BARRE VERTICALE AU BOUT DU TRAIT HORIZONTAL",NULL},
/* 22F5 */ { "APPARTIENT À AVEC POINT EN CHEF",NULL},
/* 22F6 */ { "APPARTIENT À AVEC TRAIT EN CHEF",NULL},
/* 22F7 */ { "PETIT APPARTIENT À AVEC TRAIT EN CHEF",NULL},
/* 22F8 */ { "APPARTIENT À AVEC TRAIT SOUSCRIT",NULL},
/* 22F9 */ { "APPARTIENT À AVEC DEUX TRAITS HORIZONTAUX",NULL},
/* 22FA */ { "CONTIENT AVEC LONG TRAIT HORIZONTAL",NULL},
/* 22FB */ { "CONTIENT AVEC BARRE VERTICALE AU BOUT DU TRAIT HORIZONTAL",NULL},
/* 22FC */ { "PETIT CONTIENT AVEC BARRE VERTICALE AU BOUT DU TRAIT HORIZONTAL",NULL},
/* 22FD */ { "CONTIENT AVEC TRAIT EN CHEF",NULL},
/* 22FE */ { "PETIT CONTIENT AVEC TRAIT EN CHEF",NULL},
/* 22FF */ { "ÉLÉMENT D'UN SAC EN NOTATION Z","	= appartient à un multi-ensemble"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_23[] = {
/* 2300 */ { "SYMBOLE DIAMÈTRE","	x (ensemble vide - 2205)"},
/* 2301 */ { "FLÈCHE ÉLECTRIQUE","	* tiré d'ISO 2047\n"
	"	* symbole représentant la fin de transmission"},
/* 2302 */ { "MAISON",NULL},
/* 2303 */ { "POINTE DE FLÈCHE VERS LE HAUT","	x (accent circonflexe - 005E)\n"
	"	x (lettre modificative pointe de flèche vers le haut - 02C4)\n"
	"	x (chevron d'insertion - 2038)\n"
	"	x (et logique - 2227)"},
/* 2304 */ { "POINTE DE FLÈCHE VERS LE BAS","	x (lettre modificative pointe de flèche vers le bas - 02C5)\n"
	"	x (ou logique - 2228)\n"
	"	x (fraisage - 2335)"},
/* 2305 */ { "PROJECTIVE","	x (non et - 22BC)"},
/* 2306 */ { "PERSPECTIVE",NULL},
/* 2307 */ { "LIGNE ONDULÉE","	x (ligne verticale ondulée - 2E3E)\n"
	"	x (tiret ondulé - 3030)"},
/* 2308 */ { "PLAFOND À GAUCHE","	= montant APL\n"
	"	x (anglet supérieur gauche - 2E22)\n"
	"	x (anglet gauche - 300C)"},
/* 2309 */ { "PLAFOND À DROITE","	x (diacritique symbole de rente - 20E7)\n"
	"	x (anglet supérieur droit - 2E23)"},
/* 230A */ { "PLANCHER À GAUCHE","	= descendant APL\n"
	"	x (anglet inférieur gauche - 2E24)"},
/* 230B */ { "PLANCHER À DROITE","	x (anglet droit - 300D)\n"
	"	x (anglet inférieur droit - 2E25)"},
/* 230C */ { "REPÈRE SUD-EST","	= hirondelle sud-est\n"
	"	* ensemble de quatre repères de coupe dont les branches pointent vers les marges"},
/* 230D */ { "REPÈRE SUD-OUEST","	= hirondelle sud-ouest"},
/* 230E */ { "REPÈRE NORD-EST","	= hirondelle nord-est"},
/* 230F */ { "REPÈRE NORD-OUEST","	= hirondelle nord-ouest"},
/* 2310 */ { "SIGNE NÉGATION RÉFLÉCHI","	= début de ligne\n"
	"	x (signe négation - 00AC)"},
/* 2311 */ { "PASTILLE CARRÉE","	= Kissen (oreiller)\n"
	"	* symbole utilisé par certains ordinateurs très anciens comme délimiteur de commande\n"
	"	x (valvule à quatre branches blanche couchée - 2BCF)"},
/* 2312 */ { "ARC","	= position d'une ligne\n"
	"	x (demi-cercle supérieur - 25E0)"},
/* 2313 */ { "SEGMENT","	= position d'une surface"},
/* 2314 */ { "SECTEUR",NULL},
/* 2315 */ { "ENREGISTREUR TÉLÉPHONIQUE",NULL},
/* 2316 */ { "REPÈRE DE CALAGE","	= croix de repérage\n"
	"	x (repère de calage carré - 2BD0)"},
/* 2317 */ { "CARRÉ DE VISUALISATION","	x (égal et parallèle à - 22D5)"},
/* 2318 */ { "SYMBOLE DE POINT D'INTÉRÊT","	= touche commande (1.0)\n"
	"	= touche du système d'exploitation (ISO 9995-7)"},
/* 2319 */ { "SIGNE NÉGATION CULBUTÉ","	= repère de ligne"},
/* 231A */ { "MONTRE","	x (réveille-matin - 23F0)\n"
	"	x (cadran d'horloge à une heure - 1F550)"},
/* 231B */ { "SABLIER","	= symbole alchimique de l'heure"},
/* 231C */ { "COIN NORD-OUEST","	x (anglet de substitution - 2E00)\n"
	"	x (anglet supérieur gauche - 2E22)"},
/* 231D */ { "COIN NORD-EST",NULL},
/* 231E */ { "COIN SUD-OUEST",NULL},
/* 231F */ { "COIN SUD-EST",NULL},
/* 2320 */ { "MOITIÉ SUPÉRIEURE D'INTÉGRALE","	x (rallonge d'intégrale - 23AE)"},
/* 2321 */ { "MOITIÉ INFÉRIEURE D'INTÉGRALE",NULL},
/* 2322 */ { "MOUE","	x (tirant haut - 2040)"},
/* 2323 */ { "SOURIRE","	x (tirant bas - 203F)"},
/* 2324 */ { "POINTE DE FLÈCHE VERS LE HAUT ENTRE DEUX TRAITS HORIZONTAUX","	= touche retour"},
/* 2325 */ { "TOUCHE OPTION",NULL},
/* 2326 */ { "EFFACEMENT À DROITE","	= touche d'effacement à droite"},
/* 2327 */ { "X DANS UN RECTANGLE","	= touche effacer"},
/* 2328 */ { "CLAVIER","	x (clavier et souris - 1F5A6)\n"
	"	x (clavier filaire - 1F5AE)"},
/* 2329 */ { "CHEVRON POINTANT À GAUCHE","	x (signe inférieur à - 003C)\n"
	"	x (guillemet simple vers la gauche - 2039)\n"
	"	x (chevron mathématique gauche - 27E8)\n"
	"	: 3008 chevron gauche"},
/* 232A */ { "CHEVRON POINTANT À DROITE","	x (signe supérieur à - 003E)\n"
	"	x (guillemet simple vers la droite - 203A)\n"
	"	x (chevron mathématique droit - 27E9)\n"
	"	: 3009 chevron droit"},
/* 232B */ { "EFFACEMENT À GAUCHE","	= touche d'effacement à gauche, suppression arrière"},
/* 232C */ { "ANNEAU DE BENZÈNE",NULL},
/* 232D */ { "CYLINDRICITÉ",NULL},
/* 232E */ { "PROFIL HORS-TOUT",NULL},
/* 232F */ { "SYMÉTRIE",NULL},
/* 2330 */ { "COURSE TOTALE",NULL},
/* 2331 */ { "ORIGINE DE MESURE",NULL},
/* 2332 */ { "RÉTRÉCISSEMENT CONIQUE",NULL},
/* 2333 */ { "PENTE","	x (triangle rectangle inférieur gauche - 25FA)"},
/* 2334 */ { "ALÉSAGE","	x (boîte ouverte - 2423)"},
/* 2335 */ { "FRAISAGE","	x (pointe de flèche vers le bas - 2304)"},
/* 2336 */ { "SYMBOLE DE FONCTION APL RAIL","	= poutre en i"},
/* 2337 */ { "SYMBOLE DE FONCTION APL QUADRAT MINCE","	x (symbole de fonction apl quadrat - 2395)\n"
	"	x (rectangle vertical blanc - 25AF)\n"
	"	x (barre verticale blanche n-aire - 2AFF)"},
/* 2338 */ { "SYMBOLE DE FONCTION APL ÉTAGÈRE","	= baril"},
/* 2339 */ { "SYMBOLE DE FONCTION APL DOMINO",NULL},
/* 233A */ { "SYMBOLE DE FONCTION APL RIDEAUX","	x (losange blanc dans un carré - 26CB)"},
/* 233B */ { "SYMBOLE DE FONCTION APL AS","	x (petit cercle encadré - 29C7)"},
/* 233C */ { "SYMBOLE DE FONCTION APL RHÉOSTAT",NULL},
/* 233D */ { "SYMBOLE DE FONCTION APL FUSEAU",NULL},
/* 233E */ { "SYMBOLE DE FONCTION APL BEIGNE","	x (opérateur rond cerclé - 229A)\n"
	"	x (puce blanche cerclée - 29BE)"},
/* 233F */ { "SYMBOLE DE FONCTION APL COTICE BARRÉE","	x (symbole romain as - 1019A)"},
/* 2340 */ { "SYMBOLE DE FONCTION APL CONTRE-COTICE BARRÉE","	x (barre oblique inversée à traverse horizontale - 29F7)"},
/* 2341 */ { "SYMBOLE DE FONCTION APL QUADRAT OBLIQUE","	x (oblique encadrée - 29C4)"},
/* 2342 */ { "SYMBOLE DE FONCTION APL QUADRAT OBLIQUE INVERSÉE","	x (oblique inversée encadrée - 29C5)"},
/* 2343 */ { "SYMBOLE DE FONCTION APL QUADRAT PLUS PETIT QUE",NULL},
/* 2344 */ { "SYMBOLE DE FONCTION APL QUADRAT PLUS GRAND QUE",NULL},
/* 2345 */ { "SYMBOLE DE FONCTION APL BARBE VERS LA GAUCHE",NULL},
/* 2346 */ { "SYMBOLE DE FONCTION APL BARBE VERS LA DROITE",NULL},
/* 2347 */ { "SYMBOLE DE FONCTION APL QUADRAT LIBÉRAL",NULL},
/* 2348 */ { "SYMBOLE DE FONCTION APL QUADRAT CONSERVATEUR",NULL},
/* 2349 */ { "SYMBOLE DE FONCTION APL SATURNE","	x (ensemble vide réfléchi - 29B0)"},
/* 234A */ { "SYMBOLE DE FONCTION APL TAQUET VERS LE HAUT SOULIGNÉ","	* l'appellation recommandée pour les taquets APL suit maintenant la Convention de Londres dans ISO/CEI 13751:2000 (APL étendu)\n"
	"	x (taquet vers le haut - 22A5)"},
/* 234B */ { "SYMBOLE DE FONCTION APL SAPIN","	= parapluie"},
/* 234C */ { "SYMBOLE DE FONCTION APL QUADRAT CIRCONFLEXE RENVERSÉ",NULL},
/* 234D */ { "SYMBOLE DE FONCTION APL QUADRAT DELTA",NULL},
/* 234E */ { "SYMBOLE DE FONCTION APL FORMATAGE","	x (taquet vers le haut - 22A5)"},
/* 234F */ { "SYMBOLE DE FONCTION APL BARBE VERS LE HAUT",NULL},
/* 2350 */ { "SYMBOLE DE FONCTION APL QUADRAT CIEL",NULL},
/* 2351 */ { "SYMBOLE DE FONCTION APL TAQUET VERS LE BAS SURLIGNÉ","	x (taquet vers le bas - 22A4)\n"
	"	x (marque postale - 3012)"},
/* 2352 */ { "SYMBOLE DE FONCTION APL CAROTTE",NULL},
/* 2353 */ { "SYMBOLE DE FONCTION APL QUADRAT CIRCONFLEXE","	x (pointe de flèche vers le haut inscrite dans une boîte rectangulaire - 2BB9)"},
/* 2354 */ { "SYMBOLE DE FONCTION APL QUADRAT DEL",NULL},
/* 2355 */ { "SYMBOLE DE FONCTION APL EXÉCUTION","	x (taquet vers le bas - 22A4)"},
/* 2356 */ { "SYMBOLE DE FONCTION APL BARBE VERS LE BAS",NULL},
/* 2357 */ { "SYMBOLE DE FONCTION APL QUADRAT ENFER",NULL},
/* 2358 */ { "SYMBOLE DE FONCTION APL APOSTROPHE SOULIGNÉ",NULL},
/* 2359 */ { "SYMBOLE DE FONCTION APL DELTA SOULIGNÉ",NULL},
/* 235A */ { "SYMBOLE DE FONCTION APL LOSANGE SOULIGNÉ",NULL},
/* 235B */ { "SYMBOLE DE FONCTION APL PETIT ROND SOULIGNÉ","	= pof"},
/* 235C */ { "SYMBOLE DE FONCTION APL ROND SOULIGNÉ",NULL},
/* 235D */ { "SYMBOLE DE FONCTION APL ABAT-JOUR","	x (intersection pointée - 2A40)"},
/* 235E */ { "SYMBOLE DE FONCTION APL APOSTROPHE ENCADRÉ",NULL},
/* 235F */ { "SYMBOLE DE FONCTION APL CITRON","	x (opérateur astérisque cerclé - 229B)"},
/* 2360 */ { "SYMBOLE DE FONCTION APL BOUTON CARRÉ",NULL},
/* 2361 */ { "SYMBOLE DE FONCTION APL SÉRIEUX","	x (taquet vers le bas - 22A4)"},
/* 2362 */ { "SYMBOLE DE FONCTION APL CORBEAU","	= cigogne"},
/* 2363 */ { "SYMBOLE DE FONCTION APL SÛR",NULL},
/* 2364 */ { "SYMBOLE DE FONCTION APL MINNIE","	= hululement"},
/* 2365 */ { "SYMBOLE DE FONCTION APL DINGO","	= Goofy, braillement"},
/* 2366 */ { "SYMBOLE DE FONCTION APL FOURCHE",NULL},
/* 2367 */ { "SYMBOLE DE FONCTION APL CENTIME","	= cent"},
/* 2368 */ { "SYMBOLE DE FONCTION APL MOUE","	= sourire narquois"},
/* 2369 */ { "SYMBOLE DE FONCTION APL MOINEAU",NULL},
/* 236A */ { "SYMBOLE DE FONCTION APL BARBICHE",NULL},
/* 236B */ { "SYMBOLE DE FONCTION APL VERROU",NULL},
/* 236C */ { "SYMBOLE DE FONCTION APL ZILDE",NULL},
/* 236D */ { "SYMBOLE DE FONCTION APL ALOHA",NULL},
/* 236E */ { "SYMBOLE DE FONCTION APL POINT-VIRGULE SOULIGNÉ",NULL},
/* 236F */ { "SYMBOLE DE FONCTION APL QUADRAT DIFFÉRENT DE",NULL},
/* 2370 */ { "SYMBOLE DE FONCTION APL QUADRAT INFO","	x (signe d'incertitude - 2BD1)"},
/* 2371 */ { "SYMBOLE DE FONCTION APL NON-ET",NULL},
/* 2372 */ { "SYMBOLE DE FONCTION APL NON-OU",NULL},
/* 2373 */ { "SYMBOLE DE FONCTION APL IOTA",NULL},
/* 2374 */ { "SYMBOLE DE FONCTION APL RHÔ",NULL},
/* 2375 */ { "SYMBOLE DE FONCTION APL OMÉGA",NULL},
/* 2376 */ { "SYMBOLE DE FONCTION APL ALPHA SOULIGNÉ",NULL},
/* 2377 */ { "SYMBOLE DE FONCTION APL EPSILON SOULIGNÉ",NULL},
/* 2378 */ { "SYMBOLE DE FONCTION APL IOTA SOULIGNÉ",NULL},
/* 2379 */ { "SYMBOLE DE FONCTION APL OMÉGA SOULIGNÉ",NULL},
/* 237A */ { "SYMBOLE DE FONCTION APL ALPHA",NULL},
/* 237B */ { "SIGNE DE NON-VÉRIFICATION","	* tiré d'ISO 2047\n"
	"	* symbole pour « accusé de réception négatif »"},
/* 237C */ { "ANGLE DROIT AVEC FLÈCHE EN ZIGZAG VERS LE BAS",NULL},
/* 237D */ { "CAISSE OUVERTE À ÉPAULEMENT","	* tiré d'ISO 9995-7\n"
	"	* symbole de touche pour « espace insécable »\n"
	"	x (boîte ouverte - 2423)"},
/* 237E */ { "SYMBOLE SONNERIE","	* tiré d'ISO 2047"},
/* 237F */ { "LIGNE VERTICALE À POINT MÉDIAN","	* tiré d'ISO 2047\n"
	"	* symbole pour « fin de support »"},
/* 2380 */ { "SYMBOLE INSERTION",NULL},
/* 2381 */ { "SYMBOLE SOULIGNEMENT CONTINU",NULL},
/* 2382 */ { "SYMBOLE SOULIGNEMENT DISCONTINU",NULL},
/* 2383 */ { "SYMBOLE INSISTANCE","	= mise en valeur"},
/* 2384 */ { "SYMBOLE COMPOSITION",NULL},
/* 2385 */ { "CARRÉ BLANC AVEC LIGNE MÉDIANE VERTICALE","	= centrage"},
/* 2386 */ { "SYMBOLE ENTRÉE",NULL},
/* 2387 */ { "SYMBOLE DE TOUCHE ALTERNATIVE","	= touche alt"},
/* 2388 */ { "SYMBOLE BARRE À ROUE","	= contrôle\n"
	"	x (roue de dharma - 2638)"},
/* 2389 */ { "BARRE HORIZONTALE ENCOCHÉE CERCLÉE","	= pause"},
/* 238A */ { "TRIANGLE POINTE VERS LE BAS CERCLÉ","	= arrêt"},
/* 238B */ { "CERCLE BRISÉ À FLÈCHE NORD-OUEST","	= échappement"},
/* 238C */ { "SYMBOLE DÉFAIRE","	= renoncement"},
/* 238D */ { "SYMBOLE MONOSTABLE",NULL},
/* 238E */ { "SYMBOLE HYSTÉRÉSIS",NULL},
/* 238F */ { "SYMBOLE SORTIE EN CIRCUIT OUVERT DE TYPE H",NULL},
/* 2390 */ { "SYMBOLE SORTIE EN CIRCUIT OUVERT DE TYPE L",NULL},
/* 2391 */ { "SYMBOLE SORTIE PASSIVE ABAISSEUSE",NULL},
/* 2392 */ { "SYMBOLE SORTIE PASSIVE ÉLEVEUSE",NULL},
/* 2393 */ { "SYMBOLE COURANT CONTINU FORME DEUX",NULL},
/* 2394 */ { "SYMBOLE FONCTION LOGICIELLE",NULL},
/* 2395 */ { "SYMBOLE DE FONCTION APL QUADRAT","	x (symbole de fonction apl quadrat mince - 2337)\n"
	"	x (rectangle vertical blanc - 25AF)"},
/* 2396 */ { "SYMBOLE DE TOUCHE SÉPARATEUR DÉCIMAL",NULL},
/* 2397 */ { "PAGE PRÉCÉDENTE","	x (back avec flèche vers la gauche suscrite - 1F519)"},
/* 2398 */ { "PAGE SUIVANTE",NULL},
/* 2399 */ { "SYMBOLE IMPRIMER ÉCRAN",NULL},
/* 239A */ { "SYMBOLE EFFACER ÉCRAN","	x (diacritique écran englobant - 20E2)"},
/* 239B */ { "ARC SUPÉRIEUR DE PARENTHÈSE GAUCHE",NULL},
/* 239C */ { "RALLONGE DE PARENTHÈSE GAUCHE",NULL},
/* 239D */ { "ARC INFÉRIEUR DE PARENTHÈSE GAUCHE",NULL},
/* 239E */ { "ARC SUPÉRIEUR DE PARENTHÈSE DROITE",NULL},
/* 239F */ { "RALLONGE DE PARENTHÈSE DROITE",NULL},
/* 23A0 */ { "ARC INFÉRIEUR DE PARENTHÈSE DROITE",NULL},
/* 23A1 */ { "COIN SUPÉRIEUR DE CROCHET GAUCHE",NULL},
/* 23A2 */ { "RALLONGE DE CROCHET GAUCHE",NULL},
/* 23A3 */ { "COIN INFÉRIEUR DE CROCHET GAUCHE",NULL},
/* 23A4 */ { "COIN SUPÉRIEUR DE CROCHET DROIT",NULL},
/* 23A5 */ { "RALLONGE DE CROCHET DROIT",NULL},
/* 23A6 */ { "COIN INFÉRIEUR DE CROCHET DROIT",NULL},
/* 23A7 */ { "ARC SUPÉRIEUR D'ACCOLADE GAUCHE",NULL},
/* 23A8 */ { "MILIEU D'ACCOLADE GAUCHE",NULL},
/* 23A9 */ { "ARC INFÉRIEUR D'ACCOLADE GAUCHE",NULL},
/* 23AA */ { "RALLONGE D'ACCOLADE",NULL},
/* 23AB */ { "ARC SUPÉRIEUR D'ACCOLADE DROITE",NULL},
/* 23AC */ { "MILIEU D'ACCOLADE DROITE",NULL},
/* 23AD */ { "ARC INFÉRIEUR D'ACCOLADE DROITE",NULL},
/* 23AE */ { "RALLONGE D'INTÉGRALE","	x (moitié supérieure d'intégrale - 2320)\n"
	"	x (moitié inférieure d'intégrale - 2321)"},
/* 23AF */ { "RALLONGE DE LIGNE HORIZONTALE","	* sert pour l'allongement des flèches\n"
	"	x (rallonge de ligne verticale - 23D0)"},
/* 23B0 */ { "MOITIÉ SUPÉRIEURE GAUCHE OU INFÉRIEURE DROITE D'ACCOLADE","	= moustache gauche"},
/* 23B1 */ { "MOITIÉ SUPÉRIEURE DROITE OU INFÉRIEURE GAUCHE D'ACCOLADE","	= moustache droite"},
/* 23B2 */ { "HAUT DU SIGNE DE SOMME",NULL},
/* 23B3 */ { "BAS DU SIGNE DE SOMME","	x (sommation de la famille - 2211)"},
/* 23B4 */ { "CROCHET SUPÉRIEUR","	x (forme de présentation de crochet gauche vertical - FE47)"},
/* 23B5 */ { "CROCHET INFÉRIEUR","	x (forme de présentation de crochet droit vertical - FE48)"},
/* 23B6 */ { "CROCHET INFÉRIEUR SUR CROCHET SUPÉRIEUR","	* ne s'utilise qu'en émulation de terminal CJC"},
/* 23B7 */ { "BAS DU RADICAL",NULL},
/* 23B8 */ { "FILET VERTICAL GAUCHE",NULL},
/* 23B9 */ { "FILET VERTICAL DROIT",NULL},
/* 23BA */ { "LIGNE DE BALAYAGE HORIZONTAL 1",NULL},
/* 23BB */ { "LIGNE DE BALAYAGE HORIZONTAL 3","	* la ligne de balayage 5 est unifiée avec le caractère 2500"},
/* 23BC */ { "LIGNE DE BALAYAGE HORIZONTAL 7",NULL},
/* 23BD */ { "LIGNE DE BALAYAGE HORIZONTAL 9",NULL},
/* 23BE */ { "SYMBOLE DENTAIRE TRAITS VERTICAL ET SUPÉRIEUR DROIT MAIGRES","	x (plafond à gauche - 2308)"},
/* 23BF */ { "SYMBOLE DENTAIRE TRAITS VERTICAL ET INFÉRIEUR DROIT MAIGRES","	x (plancher à gauche - 230A)"},
/* 23C0 */ { "SYMBOLE DENTAIRE TRAIT VERTICAL ET CERCLE MAIGRES",NULL},
/* 23C1 */ { "SYMBOLE DENTAIRE T ET CERCLE MAIGRES",NULL},
/* 23C2 */ { "SYMBOLE DENTAIRE T CULBUTÉ ET CERCLE MAIGRES",NULL},
/* 23C3 */ { "SYMBOLE DENTAIRE TRAIT VERTICAL ET TRIANGLE MAIGRES",NULL},
/* 23C4 */ { "SYMBOLE DENTAIRE T ET TRIANGLE MAIGRES",NULL},
/* 23C5 */ { "SYMBOLE DENTAIRE T CULBUTÉ ET TRIANGLE MAIGRES",NULL},
/* 23C6 */ { "SYMBOLE DENTAIRE TRAIT VERTICAL ET ONDE MAIGRES",NULL},
/* 23C7 */ { "SYMBOLE DENTAIRE T ET ONDE MAIGRES",NULL},
/* 23C8 */ { "SYMBOLE DENTAIRE T CULBUTÉ ET ONDE MAIGRES",NULL},
/* 23C9 */ { "SYMBOLE DENTAIRE T MAIGRE","	x (taquet vers le bas - 22A4)\n"
	"	x (filet fin vers le bas et horizontal - 252C)"},
/* 23CA */ { "SYMBOLE DENTAIRE T CULBUTÉ MAIGRE","	x (taquet vers le haut - 22A5)\n"
	"	x (filet fin vers le haut et horizontal - 2534)"},
/* 23CB */ { "SYMBOLE DENTAIRE TRAITS VERTICAL ET SUPÉRIEUR GAUCHE MAIGRES","	x (plafond à droite - 2309)"},
/* 23CC */ { "SYMBOLE DENTAIRE TRAITS VERTICAL ET INFÉRIEUR GAUCHE MAIGRES","	x (plancher à droite - 230B)"},
/* 23CD */ { "PIED CARRÉ",NULL},
/* 23CE */ { "SYMBOLE RETOUR DE CHARIOT","	* le glyphe peut être évidé ou plein\n"
	"	x (flèche vers le bas avec coin vers la gauche - 21B5)\n"
	"	x (retour de chariot à gauche - 2B90)"},
/* 23CF */ { "SYMBOLE ÉJECTION","	* symbole utilisé pour représenter l'éjection du support"},
/* 23D0 */ { "RALLONGE DE LIGNE VERTICALE","	* sert pour l'allongement des flèches\n"
	"	x (rallonge de ligne horizontale - 23AF)"},
/* 23D1 */ { "BRÈVE MÉTRIQUE",NULL},
/* 23D2 */ { "LONGUE SURMONTANT BRÈVE MÉTRIQUE","	= habituellement brève"},
/* 23D3 */ { "BRÈVE SURMONTANT LONGUE MÉTRIQUE","	= habituellement longue"},
/* 23D4 */ { "LONGUE SURMONTANT DEUX BRÈVES MÉTRIQUE","	= contraction"},
/* 23D5 */ { "DEUX BRÈVES SURMONTANT LONGUE MÉTRIQUE","	= résolution"},
/* 23D6 */ { "DEUX BRÈVES JOINTES MÉTRIQUE","	= long résolu"},
/* 23D7 */ { "TRISÈME LONGUE-BRÈVE MÉTRIQUE","	= trois temps irrationnel\n"
	"	x (diacritique musical grec trisème - 1D242)"},
/* 23D8 */ { "TÉTRASÈME MÉTRIQUE","	= quatre temps irrationnel\n"
	"	x (diacritique musical grec tétrasème - 1D243)"},
/* 23D9 */ { "PENTASÈME MÉTRIQUE","	= cinq temps irrationnel\n"
	"	x (diacritique musical grec pentasème - 1D244)"},
/* 23DA */ { "MISE À LA TERRE",NULL},
/* 23DB */ { "FUSIBLE",NULL},
/* 23DC */ { "PARENTHÈSE SUPÉRIEURE","	x (forme de présentation de parenthèse gauche verticale - FE35)"},
/* 23DD */ { "PARENTHÈSE INFÉRIEURE","	x (forme de présentation de parenthèse droite verticale - FE36)"},
/* 23DE */ { "ACCOLADE SUPÉRIEURE","	x (forme de présentation d'accolade gauche verticale - FE37)"},
/* 23DF */ { "ACCOLADE INFÉRIEURE","	x (forme de présentation d'accolade droite verticale - FE38)"},
/* 23E0 */ { "CROCHET EN ÉCAILLE SUPÉRIEUR","	x (forme de présentation de crochet en écaille gauche vertical - FE39)"},
/* 23E1 */ { "CROCHET EN ÉCAILLE INFÉRIEUR","	x (forme de présentation de crochet en écaille droit vertical - FE3A)"},
/* 23E2 */ { "TRAPÈZE BLANC",NULL},
/* 23E3 */ { "ANNEAU DE BENZÈNE AVEC CERCLE",NULL},
/* 23E4 */ { "RECTITUDE",NULL},
/* 23E5 */ { "PLANÉITÉ",NULL},
/* 23E6 */ { "COURANT ALTERNATIF",NULL},
/* 23E7 */ { "INTERSECTION ÉLECTRIQUE",NULL},
/* 23E8 */ { "SYMBOLE EXPOSANT DÉCIMAL",NULL},
/* 23E9 */ { "DOUBLE TRIANGLE NOIR POINTANT VERS LA DROITE","	= avance rapide"},
/* 23EA */ { "DOUBLE TRIANGLE NOIR POINTANT VERS LA GAUCHE","	= rembobinage rapide"},
/* 23EB */ { "DOUBLE TRIANGLE NOIR POINTANT VERS LE HAUT",NULL},
/* 23EC */ { "DOUBLE TRIANGLE NOIR POINTANT VERS LE BAS",NULL},
/* 23ED */ { "DOUBLE TRIANGLE NOIR POINTANT VERS LA DROITE AVEC BARRE VERTICALE",NULL},
/* 23EE */ { "DOUBLE TRIANGLE NOIR POINTANT VERS LA GAUCHE AVEC BARRE VERTICALE",NULL},
/* 23EF */ { "TRIANGLE NOIR POINTANT VERS LA DROITE AVEC DOUBLE BARRE VERTICALE",NULL},
/* 23F0 */ { "RÉVEILLE-MATIN","	x (montre - 231A)\n"
	"	x (cadran d'horloge à une heure - 1F550)\n"
	"	x (horloge de cheminée - 1F570)"},
/* 23F1 */ { "CHRONOMÈTRE",NULL},
/* 23F2 */ { "MINUTERIE",NULL},
/* 23F3 */ { "SABLIER AVEC COULÉE DE SABLE","	x (sablier - 231B)"},
/* 23F4 */ { "TRIANGLE NOIR MOYEN POINTANT VERS LA GAUCHE","	= arrière\n"
	"	* préféré à 25C0\n"
	"	x (triangle moyen noir vers la gauche centré - 2BC7)\n"
	"	x (triangle isocèle droit noir pointant vers la gauche - 1F780)"},
/* 23F5 */ { "TRIANGLE NOIR MOYEN POINTANT VERS LA DROITE","	= avant\n"
	"	* préféré à 25B6\n"
	"	x (triangle moyen noir vers la droite centré - 2BC8)\n"
	"	x (triangle isocèle droit noir pointant vers la droite - 1F782)"},
/* 23F6 */ { "TRIANGLE NOIR MOYEN POINTANT VERS LE HAUT","	= augmenter\n"
	"	* préféré à 25B2\n"
	"	x (triangle moyen noir vers le haut centré - 2BC5)\n"
	"	x (triangle isocèle droit noir pointant vers le haut - 1F781)"},
/* 23F7 */ { "TRIANGLE NOIR MOYEN POINTANT VERS LE BAS","	= diminuer\n"
	"	* préféré à 25BC\n"
	"	x (triangle moyen noir vers le bas centré - 2BC6)\n"
	"	x (triangle isocèle droit noir pointant vers le bas - 1F783)"},
/* 23F8 */ { "DOUBLE BARRE VERTICALE","	= pause\n"
	"	x (double ligne verticale - 2016)"},
/* 23F9 */ { "CARRÉ NOIR POUR ARRÊT","	= arrêt\n"
	"	x (carré moyen noir - 25FC)"},
/* 23FA */ { "CERCLE NOIR POUR ENREGISTREMENT","	= enregistrer\n"
	"	x (cercle noir moyen - 26AB)"},
/* 23FB */ { "SYMBOLE MISE SOUS TENSION","	* symbole de veille CEI 5009\n"
	"	* symbole d'alimentation IEEE 1621"},
/* 23FC */ { "SYMBOLE MARCHE-ARRÊT","	* symbole de marche-arrêt CEI 5010"},
/* 23FD */ { "SYMBOLE MISE EN MARCHE","	* utilisez 2B58 pour le symbole d'arrêt\n"
	"	x (cercle épais - 2B58)"},
/* 23FE */ { "SYMBOLE MISE EN VEILLE","	x (dernier quartier de lune - 263E)"},
/* 23FF */ { "SYMBOLE DE L'ŒIL OBSERVATEUR",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_24[] = {
/* 2400 */ { "SYMBOLE POUR NUL",NULL},
/* 2401 */ { "SYMBOLE POUR DÉBUT D'EN-TÊTE",NULL},
/* 2402 */ { "SYMBOLE POUR DÉBUT DE TEXTE",NULL},
/* 2403 */ { "SYMBOLE POUR FIN DE TEXTE",NULL},
/* 2404 */ { "SYMBOLE POUR FIN DE TRANSMISSION",NULL},
/* 2405 */ { "SYMBOLE POUR DEMANDE",NULL},
/* 2406 */ { "SYMBOLE POUR ACCUSÉ DE RÉCEPTION",NULL},
/* 2407 */ { "SYMBOLE POUR SONNERIE",NULL},
/* 2408 */ { "SYMBOLE POUR ESPACE ARRIÈRE",NULL},
/* 2409 */ { "SYMBOLE POUR TABULATION HORIZONTALE",NULL},
/* 240A */ { "SYMBOLE POUR CHANGEMENT DE LIGNE",NULL},
/* 240B */ { "SYMBOLE POUR TABULATION VERTICALE",NULL},
/* 240C */ { "SYMBOLE POUR SAUT DE PAGE",NULL},
/* 240D */ { "SYMBOLE POUR RETOUR DE CHARIOT",NULL},
/* 240E */ { "SYMBOLE POUR HORS CODE",NULL},
/* 240F */ { "SYMBOLE POUR EN CODE",NULL},
/* 2410 */ { "SYMBOLE POUR ÉCHAPPEMENT TRANSMISSION",NULL},
/* 2411 */ { "SYMBOLE POUR COMMANDE DE DISPOSITIF UN",NULL},
/* 2412 */ { "SYMBOLE POUR COMMANDE DE DISPOSITIF DEUX",NULL},
/* 2413 */ { "SYMBOLE POUR COMMANDE DE DISPOSITIF TROIS",NULL},
/* 2414 */ { "SYMBOLE POUR COMMANDE DE DISPOSITIF QUATRE",NULL},
/* 2415 */ { "SYMBOLE POUR ACCUSÉ DE RÉCEPTION NÉGATIF",NULL},
/* 2416 */ { "SYMBOLE POUR SYNCHRONISATION",NULL},
/* 2417 */ { "SYMBOLE POUR FIN DE BLOC DE TRANSMISSION",NULL},
/* 2418 */ { "SYMBOLE POUR ANNULATION",NULL},
/* 2419 */ { "SYMBOLE POUR FIN DE SUPPORT",NULL},
/* 241A */ { "SYMBOLE POUR SUBSTITUTION",NULL},
/* 241B */ { "SYMBOLE POUR ÉCHAPPEMENT",NULL},
/* 241C */ { "SYMBOLE POUR SÉPARATEUR DE FICHIERS",NULL},
/* 241D */ { "SYMBOLE POUR SÉPARATEUR DE GROUPES",NULL},
/* 241E */ { "SYMBOLE POUR SÉPARATEUR D'ENREGISTREMENTS",NULL},
/* 241F */ { "SYMBOLE POUR SÉPARATEUR D'UNITÉS",NULL},
/* 2420 */ { "SYMBOLE POUR ESPACE",NULL},
/* 2421 */ { "SYMBOLE POUR SUPPRESSION",NULL},
/* 2422 */ { "SYMBOLE VISUEL POUR L'ESPACE","	* symbole visuel pour l'espace\n"
	"	x (lettre minuscule latine b barré - 0180)"},
/* 2423 */ { "BOÎTE OUVERTE","	* symbole visuel pour l'espace\n"
	"	x (alésage - 2334)"},
/* 2424 */ { "SYMBOLE POUR NOUVELLE LIGNE",NULL},
/* 2425 */ { "SYMBOLE POUR SUPPRESSION FORME DEUX","	* tiré d'ISO 9995-7\n"
	"	* symbole sur le clavier pour la suppression irréversible"},
/* 2426 */ { "SYMBOLE POUR SUBSTITUTION FORME DEUX","	* tiré d'ISO 2047\n"
	"	x (point d'interrogation arabe - 061F)"},
/* 2427 */ { NULL,NULL},
/* 2428 */ { NULL,NULL},
/* 2429 */ { NULL,NULL},
/* 242A */ { NULL,NULL},
/* 242B */ { NULL,NULL},
/* 242C */ { NULL,NULL},
/* 242D */ { NULL,NULL},
/* 242E */ { NULL,NULL},
/* 242F */ { NULL,NULL},
/* 2430 */ { NULL,NULL},
/* 2431 */ { NULL,NULL},
/* 2432 */ { NULL,NULL},
/* 2433 */ { NULL,NULL},
/* 2434 */ { NULL,NULL},
/* 2435 */ { NULL,NULL},
/* 2436 */ { NULL,NULL},
/* 2437 */ { NULL,NULL},
/* 2438 */ { NULL,NULL},
/* 2439 */ { NULL,NULL},
/* 243A */ { NULL,NULL},
/* 243B */ { NULL,NULL},
/* 243C */ { NULL,NULL},
/* 243D */ { NULL,NULL},
/* 243E */ { NULL,NULL},
/* 243F */ { NULL,NULL},
/* 2440 */ { "CROCHET ROC",NULL},
/* 2441 */ { "CHAISE ROC",NULL},
/* 2442 */ { "FOURCHETTE ROC",NULL},
/* 2443 */ { "FOURCHETTE CULBUTÉE ROC",NULL},
/* 2444 */ { "BOUCLE DE CEINTURE ROC",NULL},
/* 2445 */ { "NŒUD PAPILLON ROC","	x (nœud papillon - 22C8)"},
/* 2446 */ { "IDENTIFICATION DE SUCCURSALE BANCAIRE ROC","	= domiciliation"},
/* 2447 */ { "MONTANT DU CHÈQUE ROC","	= montant"},
/* 2448 */ { "SYMBOLE RCEM SUR NOUS","	= sur nous\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 2449 */ { "SYMBOLE RCEM TIRET","	= tiret\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* 244A */ { "DOUBLE BARRE OBLIQUE INVERSÉE ROC","	= double contre-cotice ROC"},
/* 244B */ { NULL,NULL},
/* 244C */ { NULL,NULL},
/* 244D */ { NULL,NULL},
/* 244E */ { NULL,NULL},
/* 244F */ { NULL,NULL},
/* 2450 */ { NULL,NULL},
/* 2451 */ { NULL,NULL},
/* 2452 */ { NULL,NULL},
/* 2453 */ { NULL,NULL},
/* 2454 */ { NULL,NULL},
/* 2455 */ { NULL,NULL},
/* 2456 */ { NULL,NULL},
/* 2457 */ { NULL,NULL},
/* 2458 */ { NULL,NULL},
/* 2459 */ { NULL,NULL},
/* 245A */ { NULL,NULL},
/* 245B */ { NULL,NULL},
/* 245C */ { NULL,NULL},
/* 245D */ { NULL,NULL},
/* 245E */ { NULL,NULL},
/* 245F */ { NULL,NULL},
/* 2460 */ { "CHIFFRE UN CERCLÉ","	# <cerclée> 0031"},
/* 2461 */ { "CHIFFRE DEUX CERCLÉ","	# <cerclée> 0032"},
/* 2462 */ { "CHIFFRE TROIS CERCLÉ","	# <cerclée> 0033"},
/* 2463 */ { "CHIFFRE QUATRE CERCLÉ","	# <cerclée> 0034"},
/* 2464 */ { "CHIFFRE CINQ CERCLÉ","	# <cerclée> 0035"},
/* 2465 */ { "CHIFFRE SIX CERCLÉ","	# <cerclée> 0036"},
/* 2466 */ { "CHIFFRE SEPT CERCLÉ","	# <cerclée> 0037"},
/* 2467 */ { "CHIFFRE HUIT CERCLÉ","	# <cerclée> 0038"},
/* 2468 */ { "CHIFFRE NEUF CERCLÉ","	# <cerclée> 0039"},
/* 2469 */ { "NOMBRE DIX CERCLÉ","	# <cerclée> 0031 0030"},
/* 246A */ { "NOMBRE ONZE CERCLÉ","	# <cerclée> 0031 0031"},
/* 246B */ { "NOMBRE DOUZE CERCLÉ","	# <cerclée> 0031 0032"},
/* 246C */ { "NOMBRE TREIZE CERCLÉ","	# <cerclée> 0031 0033"},
/* 246D */ { "NOMBRE QUATORZE CERCLÉ","	# <cerclée> 0031 0034"},
/* 246E */ { "NOMBRE QUINZE CERCLÉ","	# <cerclée> 0031 0035"},
/* 246F */ { "NOMBRE SEIZE CERCLÉ","	# <cerclée> 0031 0036"},
/* 2470 */ { "NOMBRE DIX-SEPT CERCLÉ","	# <cerclée> 0031 0037"},
/* 2471 */ { "NOMBRE DIX-HUIT CERCLÉ","	# <cerclée> 0031 0038"},
/* 2472 */ { "NOMBRE DIX-NEUF CERCLÉ","	# <cerclée> 0031 0039"},
/* 2473 */ { "NOMBRE VINGT CERCLÉ","	# <cerclée> 0032 0030"},
/* 2474 */ { "CHIFFRE UN ENTRE PARENTHÈSES","	# 0028 0031 0029"},
/* 2475 */ { "CHIFFRE DEUX ENTRE PARENTHÈSES","	# 0028 0032 0029"},
/* 2476 */ { "CHIFFRE TROIS ENTRE PARENTHÈSES","	# 0028 0033 0029"},
/* 2477 */ { "CHIFFRE QUATRE ENTRE PARENTHÈSES","	# 0028 0034 0029"},
/* 2478 */ { "CHIFFRE CINQ ENTRE PARENTHÈSES","	# 0028 0035 0029"},
/* 2479 */ { "CHIFFRE SIX ENTRE PARENTHÈSES","	# 0028 0036 0029"},
/* 247A */ { "CHIFFRE SEPT ENTRE PARENTHÈSES","	# 0028 0037 0029"},
/* 247B */ { "CHIFFRE HUIT ENTRE PARENTHÈSES","	# 0028 0038 0029"},
/* 247C */ { "CHIFFRE NEUF ENTRE PARENTHÈSES","	# 0028 0039 0029"},
/* 247D */ { "NOMBRE DIX ENTRE PARENTHÈSES","	# 0028 0031 0030 0029"},
/* 247E */ { "NOMBRE ONZE ENTRE PARENTHÈSES","	# 0028 0031 0031 0029"},
/* 247F */ { "NOMBRE DOUZE ENTRE PARENTHÈSES","	# 0028 0031 0032 0029"},
/* 2480 */ { "NOMBRE TREIZE ENTRE PARENTHÈSES","	# 0028 0031 0033 0029"},
/* 2481 */ { "NOMBRE QUATORZE ENTRE PARENTHÈSES","	# 0028 0031 0034 0029"},
/* 2482 */ { "NOMBRE QUINZE ENTRE PARENTHÈSES","	# 0028 0031 0035 0029"},
/* 2483 */ { "NOMBRE SEIZE ENTRE PARENTHÈSES","	# 0028 0031 0036 0029"},
/* 2484 */ { "NOMBRE DIX-SEPT ENTRE PARENTHÈSES","	# 0028 0031 0037 0029"},
/* 2485 */ { "NOMBRE DIX-HUIT ENTRE PARENTHÈSES","	# 0028 0031 0038 0029"},
/* 2486 */ { "NOMBRE DIX-NEUF ENTRE PARENTHÈSES","	# 0028 0031 0039 0029"},
/* 2487 */ { "NOMBRE VINGT ENTRE PARENTHÈSES","	# 0028 0032 0030 0029"},
/* 2488 */ { "CHIFFRE UN POINT","	# 0031 002E"},
/* 2489 */ { "CHIFFRE DEUX POINT","	# 0032 002E"},
/* 248A */ { "CHIFFRE TROIS POINT","	# 0033 002E"},
/* 248B */ { "CHIFFRE QUATRE POINT","	# 0034 002E"},
/* 248C */ { "CHIFFRE CINQ POINT","	# 0035 002E"},
/* 248D */ { "CHIFFRE SIX POINT","	# 0036 002E"},
/* 248E */ { "CHIFFRE SEPT POINT","	# 0037 002E"},
/* 248F */ { "CHIFFRE HUIT POINT","	# 0038 002E"},
/* 2490 */ { "CHIFFRE NEUF POINT","	# 0039 002E"},
/* 2491 */ { "NOMBRE DIX POINT","	# 0031 0030 002E"},
/* 2492 */ { "NOMBRE ONZE POINT","	# 0031 0031 002E"},
/* 2493 */ { "NOMBRE DOUZE POINT","	# 0031 0032 002E"},
/* 2494 */ { "NOMBRE TREIZE POINT","	# 0031 0033 002E"},
/* 2495 */ { "NOMBRE QUATORZE POINT","	# 0031 0034 002E"},
/* 2496 */ { "NOMBRE QUINZE POINT","	# 0031 0035 002E"},
/* 2497 */ { "NOMBRE SEIZE POINT","	# 0031 0036 002E"},
/* 2498 */ { "NOMBRE DIX-SEPT POINT","	# 0031 0037 002E"},
/* 2499 */ { "NOMBRE DIX-HUIT POINT","	# 0031 0038 002E"},
/* 249A */ { "NOMBRE DIX-NEUF POINT","	# 0031 0039 002E"},
/* 249B */ { "NOMBRE VINGT POINT","	# 0032 0030 002E"},
/* 249C */ { "LETTRE MINUSCULE LATINE A ENTRE PARENTHÈSES","	# 0028 0061 0029"},
/* 249D */ { "LETTRE MINUSCULE LATINE B ENTRE PARENTHÈSES","	# 0028 0062 0029"},
/* 249E */ { "LETTRE MINUSCULE LATINE C ENTRE PARENTHÈSES","	# 0028 0063 0029"},
/* 249F */ { "LETTRE MINUSCULE LATINE D ENTRE PARENTHÈSES","	# 0028 0064 0029"},
/* 24A0 */ { "LETTRE MINUSCULE LATINE E ENTRE PARENTHÈSES","	# 0028 0065 0029"},
/* 24A1 */ { "LETTRE MINUSCULE LATINE F ENTRE PARENTHÈSES","	# 0028 0066 0029"},
/* 24A2 */ { "LETTRE MINUSCULE LATINE G ENTRE PARENTHÈSES","	# 0028 0067 0029"},
/* 24A3 */ { "LETTRE MINUSCULE LATINE H ENTRE PARENTHÈSES","	# 0028 0068 0029"},
/* 24A4 */ { "LETTRE MINUSCULE LATINE I ENTRE PARENTHÈSES","	# 0028 0069 0029"},
/* 24A5 */ { "LETTRE MINUSCULE LATINE J ENTRE PARENTHÈSES","	# 0028 006A 0029"},
/* 24A6 */ { "LETTRE MINUSCULE LATINE K ENTRE PARENTHÈSES","	# 0028 006B 0029"},
/* 24A7 */ { "LETTRE MINUSCULE LATINE L ENTRE PARENTHÈSES","	# 0028 006C 0029"},
/* 24A8 */ { "LETTRE MINUSCULE LATINE M ENTRE PARENTHÈSES","	# 0028 006D 0029"},
/* 24A9 */ { "LETTRE MINUSCULE LATINE N ENTRE PARENTHÈSES","	# 0028 006E 0029"},
/* 24AA */ { "LETTRE MINUSCULE LATINE O ENTRE PARENTHÈSES","	# 0028 006F 0029"},
/* 24AB */ { "LETTRE MINUSCULE LATINE P ENTRE PARENTHÈSES","	# 0028 0070 0029"},
/* 24AC */ { "LETTRE MINUSCULE LATINE Q ENTRE PARENTHÈSES","	# 0028 0071 0029"},
/* 24AD */ { "LETTRE MINUSCULE LATINE R ENTRE PARENTHÈSES","	# 0028 0072 0029"},
/* 24AE */ { "LETTRE MINUSCULE LATINE S ENTRE PARENTHÈSES","	# 0028 0073 0029"},
/* 24AF */ { "LETTRE MINUSCULE LATINE T ENTRE PARENTHÈSES","	# 0028 0074 0029"},
/* 24B0 */ { "LETTRE MINUSCULE LATINE U ENTRE PARENTHÈSES","	# 0028 0075 0029"},
/* 24B1 */ { "LETTRE MINUSCULE LATINE V ENTRE PARENTHÈSES","	# 0028 0076 0029"},
/* 24B2 */ { "LETTRE MINUSCULE LATINE W ENTRE PARENTHÈSES","	# 0028 0077 0029"},
/* 24B3 */ { "LETTRE MINUSCULE LATINE X ENTRE PARENTHÈSES","	# 0028 0078 0029"},
/* 24B4 */ { "LETTRE MINUSCULE LATINE Y ENTRE PARENTHÈSES","	# 0028 0079 0029"},
/* 24B5 */ { "LETTRE MINUSCULE LATINE Z ENTRE PARENTHÈSES","	# 0028 007A 0029"},
/* 24B6 */ { "LETTRE MAJUSCULE LATINE A CERCLÉE","	# <cerclée> 0041"},
/* 24B7 */ { "LETTRE MAJUSCULE LATINE B CERCLÉE","	# <cerclée> 0042"},
/* 24B8 */ { "LETTRE MAJUSCULE LATINE C CERCLÉE","	x (symbole copyright - 00A9)\n"
	"	# <cerclée> 0043"},
/* 24B9 */ { "LETTRE MAJUSCULE LATINE D CERCLÉE","	# <cerclée> 0044"},
/* 24BA */ { "LETTRE MAJUSCULE LATINE E CERCLÉE","	# <cerclée> 0045"},
/* 24BB */ { "LETTRE MAJUSCULE LATINE F CERCLÉE","	# <cerclée> 0046"},
/* 24BC */ { "LETTRE MAJUSCULE LATINE G CERCLÉE","	# <cerclée> 0047"},
/* 24BD */ { "LETTRE MAJUSCULE LATINE H CERCLÉE","	# <cerclée> 0048"},
/* 24BE */ { "LETTRE MAJUSCULE LATINE I CERCLÉE","	# <cerclée> 0049"},
/* 24BF */ { "LETTRE MAJUSCULE LATINE J CERCLÉE","	# <cerclée> 004A"},
/* 24C0 */ { "LETTRE MAJUSCULE LATINE K CERCLÉE","	# <cerclée> 004B"},
/* 24C1 */ { "LETTRE MAJUSCULE LATINE L CERCLÉE","	# <cerclée> 004C"},
/* 24C2 */ { "LETTRE MAJUSCULE LATINE M CERCLÉE","	# <cerclée> 004D"},
/* 24C3 */ { "LETTRE MAJUSCULE LATINE N CERCLÉE","	# <cerclée> 004E"},
/* 24C4 */ { "LETTRE MAJUSCULE LATINE O CERCLÉE","	# <cerclée> 004F"},
/* 24C5 */ { "LETTRE MAJUSCULE LATINE P CERCLÉE","	x (copyright de phonogramme - 2117)\n"
	"	# <cerclée> 0050"},
/* 24C6 */ { "LETTRE MAJUSCULE LATINE Q CERCLÉE","	# <cerclée> 0051"},
/* 24C7 */ { "LETTRE MAJUSCULE LATINE R CERCLÉE","	x (symbole marque déposée - 00AE)\n"
	"	# <cerclée> 0052"},
/* 24C8 */ { "LETTRE MAJUSCULE LATINE S CERCLÉE","	# <cerclée> 0053"},
/* 24C9 */ { "LETTRE MAJUSCULE LATINE T CERCLÉE","	# <cerclée> 0054"},
/* 24CA */ { "LETTRE MAJUSCULE LATINE U CERCLÉE","	# <cerclée> 0055"},
/* 24CB */ { "LETTRE MAJUSCULE LATINE V CERCLÉE","	# <cerclée> 0056"},
/* 24CC */ { "LETTRE MAJUSCULE LATINE W CERCLÉE","	# <cerclée> 0057"},
/* 24CD */ { "LETTRE MAJUSCULE LATINE X CERCLÉE","	# <cerclée> 0058"},
/* 24CE */ { "LETTRE MAJUSCULE LATINE Y CERCLÉE","	# <cerclée> 0059"},
/* 24CF */ { "LETTRE MAJUSCULE LATINE Z CERCLÉE","	# <cerclée> 005A"},
/* 24D0 */ { "LETTRE MINUSCULE LATINE A CERCLÉE","	# <cerclée> 0061"},
/* 24D1 */ { "LETTRE MINUSCULE LATINE B CERCLÉE","	# <cerclée> 0062"},
/* 24D2 */ { "LETTRE MINUSCULE LATINE C CERCLÉE","	# <cerclée> 0063"},
/* 24D3 */ { "LETTRE MINUSCULE LATINE D CERCLÉE","	# <cerclée> 0064"},
/* 24D4 */ { "LETTRE MINUSCULE LATINE E CERCLÉE","	# <cerclée> 0065"},
/* 24D5 */ { "LETTRE MINUSCULE LATINE F CERCLÉE","	# <cerclée> 0066"},
/* 24D6 */ { "LETTRE MINUSCULE LATINE G CERCLÉE","	# <cerclée> 0067"},
/* 24D7 */ { "LETTRE MINUSCULE LATINE H CERCLÉE","	# <cerclée> 0068"},
/* 24D8 */ { "LETTRE MINUSCULE LATINE I CERCLÉE","	# <cerclée> 0069"},
/* 24D9 */ { "LETTRE MINUSCULE LATINE J CERCLÉE","	# <cerclée> 006A"},
/* 24DA */ { "LETTRE MINUSCULE LATINE K CERCLÉE","	# <cerclée> 006B"},
/* 24DB */ { "LETTRE MINUSCULE LATINE L CERCLÉE","	# <cerclée> 006C"},
/* 24DC */ { "LETTRE MINUSCULE LATINE M CERCLÉE","	# <cerclée> 006D"},
/* 24DD */ { "LETTRE MINUSCULE LATINE N CERCLÉE","	# <cerclée> 006E"},
/* 24DE */ { "LETTRE MINUSCULE LATINE O CERCLÉE","	# <cerclée> 006F"},
/* 24DF */ { "LETTRE MINUSCULE LATINE P CERCLÉE","	# <cerclée> 0070"},
/* 24E0 */ { "LETTRE MINUSCULE LATINE Q CERCLÉE","	# <cerclée> 0071"},
/* 24E1 */ { "LETTRE MINUSCULE LATINE R CERCLÉE","	# <cerclée> 0072"},
/* 24E2 */ { "LETTRE MINUSCULE LATINE S CERCLÉE","	# <cerclée> 0073"},
/* 24E3 */ { "LETTRE MINUSCULE LATINE T CERCLÉE","	# <cerclée> 0074"},
/* 24E4 */ { "LETTRE MINUSCULE LATINE U CERCLÉE","	# <cerclée> 0075"},
/* 24E5 */ { "LETTRE MINUSCULE LATINE V CERCLÉE","	# <cerclée> 0076"},
/* 24E6 */ { "LETTRE MINUSCULE LATINE W CERCLÉE","	# <cerclée> 0077"},
/* 24E7 */ { "LETTRE MINUSCULE LATINE X CERCLÉE","	# <cerclée> 0078"},
/* 24E8 */ { "LETTRE MINUSCULE LATINE Y CERCLÉE","	# <cerclée> 0079"},
/* 24E9 */ { "LETTRE MINUSCULE LATINE Z CERCLÉE","	# <cerclée> 007A"},
/* 24EA */ { "CHIFFRE ZÉRO CERCLÉ","	# <cerclée> 0030"},
/* 24EB */ { "NOMBRE ONZE CERCLÉ NOIR AU BLANC",NULL},
/* 24EC */ { "NOMBRE DOUZE CERCLÉ NOIR AU BLANC",NULL},
/* 24ED */ { "NOMBRE TREIZE CERCLÉ NOIR AU BLANC",NULL},
/* 24EE */ { "NOMBRE QUATORZE CERCLÉ NOIR AU BLANC",NULL},
/* 24EF */ { "NOMBRE QUINZE CERCLÉ NOIR AU BLANC",NULL},
/* 24F0 */ { "NOMBRE SEIZE CERCLÉ NOIR AU BLANC",NULL},
/* 24F1 */ { "NOMBRE DIX-SEPT CERCLÉ NOIR AU BLANC",NULL},
/* 24F2 */ { "NOMBRE DIX-HUIT CERCLÉ NOIR AU BLANC",NULL},
/* 24F3 */ { "NOMBRE DIX-NEUF CERCLÉ NOIR AU BLANC",NULL},
/* 24F4 */ { "NOMBRE VINGT CERCLÉ NOIR AU BLANC",NULL},
/* 24F5 */ { "CHIFFRE UN DOUBLEMENT CERCLÉ",NULL},
/* 24F6 */ { "CHIFFRE DEUX DOUBLEMENT CERCLÉ",NULL},
/* 24F7 */ { "CHIFFRE TROIS DOUBLEMENT CERCLÉ",NULL},
/* 24F8 */ { "CHIFFRE QUATRE DOUBLEMENT CERCLÉ",NULL},
/* 24F9 */ { "CHIFFRE CINQ DOUBLEMENT CERCLÉ",NULL},
/* 24FA */ { "CHIFFRE SIX DOUBLEMENT CERCLÉ",NULL},
/* 24FB */ { "CHIFFRE SEPT DOUBLEMENT CERCLÉ",NULL},
/* 24FC */ { "CHIFFRE HUIT DOUBLEMENT CERCLÉ",NULL},
/* 24FD */ { "CHIFFRE NEUF DOUBLEMENT CERCLÉ",NULL},
/* 24FE */ { "NOMBRE DIX DOUBLEMENT CERCLÉ",NULL},
/* 24FF */ { "CHIFFRE ZÉRO CERCLÉ NOIR AU BLANC","	x (vignette chiffre un cerclé noir au blanc - 2776)"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_25[] = {
/* 2500 */ { "FILET HORIZONTAL FIN","	= Mosaïque Vidéotex DG 15"},
/* 2501 */ { "FILET HORIZONTAL GRAS",NULL},
/* 2502 */ { "FILET VERTICAL FIN","	= Mosaïque Vidéotex DG 14"},
/* 2503 */ { "FILET VERTICAL GRAS",NULL},
/* 2504 */ { "FILET BRISÉ TRIPLE HORIZONTAL FIN",NULL},
/* 2505 */ { "FILET BRISÉ TRIPLE HORIZONTAL GRAS",NULL},
/* 2506 */ { "FILET BRISÉ TRIPLE VERTICAL FIN",NULL},
/* 2507 */ { "FILET BRISÉ TRIPLE VERTICAL GRAS",NULL},
/* 2508 */ { "FILET BRISÉ QUADRUPLE HORIZONTAL FIN",NULL},
/* 2509 */ { "FILET BRISÉ QUADRUPLE HORIZONTAL GRAS",NULL},
/* 250A */ { "FILET BRISÉ QUADRUPLE VERTICAL FIN",NULL},
/* 250B */ { "FILET BRISÉ QUADRUPLE VERTICAL GRAS",NULL},
/* 250C */ { "FILET FIN VERS LE BAS ET VERS LA DROITE","	= Mosaïque Vidéotex DG 16"},
/* 250D */ { "FILET FIN VERS LE BAS ET GRAS VERS LA DROITE",NULL},
/* 250E */ { "FILET GRAS VERS LE BAS ET FIN VERS LA DROITE",NULL},
/* 250F */ { "FILET GRAS VERS LE BAS ET VERS LA DROITE",NULL},
/* 2510 */ { "FILET FIN VERS LE BAS ET VERS LA GAUCHE","	= Mosaïque Vidéotex DG 17"},
/* 2511 */ { "FILET FIN VERS LE BAS ET GRAS VERS LA GAUCHE",NULL},
/* 2512 */ { "FILET GRAS VERS LE BAS ET FIN VERS LA GAUCHE",NULL},
/* 2513 */ { "FILET GRAS VERS LE BAS ET VERS LA GAUCHE",NULL},
/* 2514 */ { "FILET FIN VERS LE HAUT ET VERS LA DROITE","	= Mosaïque Vidéotex DG 18"},
/* 2515 */ { "FILET FIN VERS LE HAUT ET GRAS VERS LA DROITE",NULL},
/* 2516 */ { "FILET GRAS VERS LE HAUT ET FIN VERS LA DROITE",NULL},
/* 2517 */ { "FILET GRAS VERS LE HAUT ET VERS LA DROITE",NULL},
/* 2518 */ { "FILET FIN VERS LE HAUT ET VERS LA GAUCHE","	= Mosaïque Vidéotex DG 19"},
/* 2519 */ { "FILET FIN VERS LE HAUT ET GRAS VERS LA GAUCHE",NULL},
/* 251A */ { "FILET GRAS VERS LE HAUT ET FIN VERS LA GAUCHE",NULL},
/* 251B */ { "FILET GRAS VERS LE HAUT ET VERS LA GAUCHE",NULL},
/* 251C */ { "FILET FIN VERTICAL ET VERS LA DROITE","	= Mosaïque Vidéotex DG 20"},
/* 251D */ { "FILET FIN VERTICAL ET GRAS VERS LA DROITE","	= Mosaïque Vidéotex DG 03"},
/* 251E */ { "FILET GRAS VERS LE HAUT ET FIN VERS LA DROITE ET VERS LE BAS",NULL},
/* 251F */ { "FILET GRAS VERS LE BAS ET FIN VERS LA DROITE ET VERS LE HAUT",NULL},
/* 2520 */ { "FILET GRAS VERTICAL ET FIN VERS LA DROITE",NULL},
/* 2521 */ { "FILET FIN VERS LE BAS ET GRAS VERS LA DROITE ET VERS LE HAUT",NULL},
/* 2522 */ { "FILET FIN VERS LE HAUT ET GRAS VERS LA DROITE ET VERS LE BAS",NULL},
/* 2523 */ { "FILET GRAS VERTICAL ET VERS LA DROITE",NULL},
/* 2524 */ { "FILET FIN VERTICAL ET VERS LA GAUCHE","	= Mosaïque Vidéotex DG 21"},
/* 2525 */ { "FILET FIN VERTICAL ET GRAS VERS LA GAUCHE","	= Mosaïque Vidéotex DG 04"},
/* 2526 */ { "FILET GRAS VERS LE HAUT ET FIN VERS LA GAUCHE ET VERS LE BAS",NULL},
/* 2527 */ { "FILET GRAS VERS LE BAS ET FIN VERS LA GAUCHE ET VERS LE HAUT",NULL},
/* 2528 */ { "FILET GRAS VERTICAL ET FIN VERS LA GAUCHE",NULL},
/* 2529 */ { "FILET FIN VERS LE BAS ET GRAS VERS LA GAUCHE ET VERS LE HAUT",NULL},
/* 252A */ { "FILET FIN VERS LE HAUT ET GRAS VERS LA GAUCHE ET VERS LE BAS",NULL},
/* 252B */ { "FILET GRAS VERTICAL ET VERS LA GAUCHE",NULL},
/* 252C */ { "FILET FIN VERS LE BAS ET HORIZONTAL","	= Mosaïque Vidéotex DG 22"},
/* 252D */ { "FILET GRAS VERS LA GAUCHE ET FIN VERS LA DROITE ET VERS LE BAS",NULL},
/* 252E */ { "FILET GRAS VERS LA DROITE ET FIN VERS LA GAUCHE ET VERS LE BAS",NULL},
/* 252F */ { "FILET FIN VERS LE BAS ET GRAS HORIZONTAL","	= Mosaïque Vidéotex DG 02"},
/* 2530 */ { "FILET GRAS VERS LE BAS ET FIN HORIZONTAL",NULL},
/* 2531 */ { "FILET FIN VERS LA DROITE ET GRAS VERS LA GAUCHE ET VERS LE BAS",NULL},
/* 2532 */ { "FILET FIN VERS LA GAUCHE ET GRAS VERS LA DROITE ET VERS LE BAS",NULL},
/* 2533 */ { "FILET GRAS VERS LE BAS ET HORIZONTAL",NULL},
/* 2534 */ { "FILET FIN VERS LE HAUT ET HORIZONTAL","	= Mosaïque Vidéotex DG 23"},
/* 2535 */ { "FILET GRAS VERS LA GAUCHE ET FIN VERS LA DROITE ET VERS LE HAUT",NULL},
/* 2536 */ { "FILET GRAS VERS LA DROITE ET FIN VERS LA GAUCHE ET VERS LE HAUT",NULL},
/* 2537 */ { "FILET FIN VERS LE HAUT ET GRAS HORIZONTAL","	= Mosaïque Vidéotex DG 01"},
/* 2538 */ { "FILET GRAS VERS LE HAUT ET FIN HORIZONTAL",NULL},
/* 2539 */ { "FILET FIN VERS LA DROITE ET GRAS VERS LA GAUCHE ET VERS LE HAUT",NULL},
/* 253A */ { "FILET FIN VERS LA GAUCHE ET GRAS VERS LA DROITE ET VERS LE HAUT",NULL},
/* 253B */ { "FILET GRAS VERS LE HAUT ET HORIZONTAL",NULL},
/* 253C */ { "FILET FIN VERTICAL ET HORIZONTAL","	= Mosaïque Vidéotex DG 24"},
/* 253D */ { "FILET GRAS VERS LA GAUCHE ET FIN VERS LA DROITE ET VERTICAL",NULL},
/* 253E */ { "FILET GRAS VERS LA DROITE ET FIN VERS LA GAUCHE ET VERTICAL",NULL},
/* 253F */ { "FILET VERTICAL FIN ET HORIZONTAL GRAS","	= Mosaïque Vidéotex DG 13"},
/* 2540 */ { "FILET GRAS VERS LE HAUT ET FIN VERS LE BAS ET HORIZONTAL",NULL},
/* 2541 */ { "FILET GRAS VERS LE BAS ET FIN VERS LE HAUT ET HORIZONTAL",NULL},
/* 2542 */ { "FILET VERTICAL GRAS ET HORIZONTAL FIN",NULL},
/* 2543 */ { "FILET GRAS VERS LA GAUCHE ET VERS LE HAUT ET FIN VERS LA DROITE ET VERS LE BAS",NULL},
/* 2544 */ { "FILET GRAS VERS LA DROITE ET VERS LE HAUT ET FIN VERS LA GAUCHE ET VERS LE BAS",NULL},
/* 2545 */ { "FILET GRAS VERS LA GAUCHE ET VERS LE BAS ET FIN VERS LA DROITE ET VERS LE HAUT",NULL},
/* 2546 */ { "FILET GRAS VERS LA DROITE ET VERS LE BAS ET FIN VERS LA GAUCHE ET VERS LE HAUT",NULL},
/* 2547 */ { "FILET FIN VERS LE BAS ET GRAS VERS LE HAUT ET HORIZONTAL",NULL},
/* 2548 */ { "FILET FIN VERS LE HAUT ET GRAS VERS LE BAS ET HORIZONTAL",NULL},
/* 2549 */ { "FILET FIN VERS LA DROITE ET GRAS VERS LA GAUCHE ET VERTICAL",NULL},
/* 254A */ { "FILET FIN VERS LA GAUCHE ET GRAS VERS LA DROITE ET VERTICAL",NULL},
/* 254B */ { "FILET VERTICAL ET HORIZONTAL GRAS",NULL},
/* 254C */ { "FILET BRISÉ DOUBLE HORIZONTAL FIN",NULL},
/* 254D */ { "FILET BRISÉ DOUBLE HORIZONTAL GRAS",NULL},
/* 254E */ { "FILET BRISÉ DOUBLE VERTICAL FIN",NULL},
/* 254F */ { "FILET BRISÉ DOUBLE VERTICAL GRAS",NULL},
/* 2550 */ { "FILET DOUBLE HORIZONTAL",NULL},
/* 2551 */ { "FILET DOUBLE VERTICAL",NULL},
/* 2552 */ { "FILET SIMPLE VERS LE BAS ET DOUBLE VERS LA DROITE",NULL},
/* 2553 */ { "FILET DOUBLE VERS LE BAS ET SIMPLE VERS LA DROITE",NULL},
/* 2554 */ { "FILET DOUBLE VERS LE BAS ET VERS LA DROITE",NULL},
/* 2555 */ { "FILET SIMPLE VERS LE BAS ET DOUBLE VERS LA GAUCHE",NULL},
/* 2556 */ { "FILET DOUBLE VERS LE BAS ET SIMPLE VERS LA GAUCHE",NULL},
/* 2557 */ { "FILET DOUBLE VERS LE BAS ET VERS LA GAUCHE",NULL},
/* 2558 */ { "FILET SIMPLE VERS LE HAUT ET DOUBLE VERS LA DROITE",NULL},
/* 2559 */ { "FILET DOUBLE VERS LE HAUT ET SIMPLE VERS LA DROITE",NULL},
/* 255A */ { "FILET DOUBLE VERS LE HAUT ET VERS LA DROITE",NULL},
/* 255B */ { "FILET SIMPLE VERS LE HAUT ET DOUBLE VERS LA GAUCHE",NULL},
/* 255C */ { "FILET DOUBLE VERS LE HAUT ET SIMPLE VERS LA GAUCHE",NULL},
/* 255D */ { "FILET DOUBLE VERS LE HAUT ET VERS LA GAUCHE",NULL},
/* 255E */ { "FILET VERTICAL SIMPLE ET DROIT DOUBLE",NULL},
/* 255F */ { "FILET VERTICAL DOUBLE ET DROIT SIMPLE",NULL},
/* 2560 */ { "FILET DOUBLE VERTICAL ET VERS LA DROITE",NULL},
/* 2561 */ { "FILET VERTICAL SIMPLE ET GAUCHE DOUBLE",NULL},
/* 2562 */ { "FILET VERTICAL DOUBLE ET GAUCHE SIMPLE",NULL},
/* 2563 */ { "FILET DOUBLE VERTICAL ET VERS LA GAUCHE",NULL},
/* 2564 */ { "FILET VERS LE BAS SIMPLE ET HORIZONTAL DOUBLE",NULL},
/* 2565 */ { "FILET VERS LE BAS DOUBLE ET HORIZONTAL SIMPLE",NULL},
/* 2566 */ { "FILET DOUBLE VERS LE BAS ET HORIZONTAL",NULL},
/* 2567 */ { "FILET VERS LE HAUT SIMPLE ET HORIZONTAL DOUBLE",NULL},
/* 2568 */ { "FILET VERS LE HAUT DOUBLE ET HORIZONTAL SIMPLE",NULL},
/* 2569 */ { "FILET DOUBLE VERS LE HAUT ET HORIZONTAL",NULL},
/* 256A */ { "FILET VERTICAL SIMPLE ET HORIZONTAL DOUBLE",NULL},
/* 256B */ { "FILET VERTICAL DOUBLE ET HORIZONTAL SIMPLE",NULL},
/* 256C */ { "FILET DOUBLE VERTICAL ET HORIZONTAL",NULL},
/* 256D */ { "FILET FIN ARC VERS LE BAS ET VERS LA DROITE",NULL},
/* 256E */ { "FILET FIN ARC VERS LE BAS ET VERS LA GAUCHE",NULL},
/* 256F */ { "FILET FIN ARC VERS LE HAUT ET VERS LA GAUCHE",NULL},
/* 2570 */ { "FILET FIN ARC VERS LE HAUT ET VERS LA DROITE",NULL},
/* 2571 */ { "FILET DIAGONAL FIN DU COIN SUPÉRIEUR DROIT AU COIN INFÉRIEUR GAUCHE","	* pas destiné à représenter un symbole mathématique\n"
	"	x (barre oblique inversée - 005C)\n"
	"	x (différence d'ensembles - 2216)\n"
	"	x (opérateur barre oblique inversée - 29F5)"},
/* 2572 */ { "FILET DIAGONAL FIN DU COIN SUPÉRIEUR GAUCHE VERS LE COIN INFÉRIEUR DROIT","	* pas destiné à représenter un symbole mathématique\n"
	"	x (barre oblique - 002F)\n"
	"	x (barre de fraction - 2044)\n"
	"	x (barre oblique de division - 2215)"},
/* 2573 */ { "FILET DIAGONAL FIN EN CROIX","	x (sautoir - 2613)\n"
	"	x (x de multiplication - 2715)"},
/* 2574 */ { "FILET FIN VERS LA GAUCHE",NULL},
/* 2575 */ { "FILET FIN VERS LE HAUT",NULL},
/* 2576 */ { "FILET FIN VERS LA DROITE",NULL},
/* 2577 */ { "FILET FIN VERS LE BAS",NULL},
/* 2578 */ { "FILET GRAS VERS LA GAUCHE",NULL},
/* 2579 */ { "FILET GRAS VERS LE HAUT",NULL},
/* 257A */ { "FILET GRAS VERS LA DROITE",NULL},
/* 257B */ { "FILET GRAS VERS LE BAS",NULL},
/* 257C */ { "FILET FIN VERS LA GAUCHE ET GRAS VERS LA DROITE",NULL},
/* 257D */ { "FILET FIN VERS LE HAUT ET GRAS VERS LE BAS",NULL},
/* 257E */ { "FILET GRAS VERS LA GAUCHE ET FIN VERS LA DROITE",NULL},
/* 257F */ { "FILET GRAS VERS LE HAUT ET FIN VERS LE BAS",NULL},
/* 2580 */ { "MOITIÉ SUPÉRIEURE DE PAVÉ",NULL},
/* 2581 */ { "HUITIÈME INFÉRIEUR DE PAVÉ",NULL},
/* 2582 */ { "QUART INFÉRIEUR DE PAVÉ",NULL},
/* 2583 */ { "TROIS HUITIÈMES INFÉRIEURS DE PAVÉ",NULL},
/* 2584 */ { "MOITIÉ INFÉRIEURE DE PAVÉ",NULL},
/* 2585 */ { "CINQ HUITIÈMES INFÉRIEURS DE PAVÉ",NULL},
/* 2586 */ { "TROIS QUARTS INFÉRIEURS DE PAVÉ",NULL},
/* 2587 */ { "SEPT HUITIÈMES INFÉRIEURS DE PAVÉ",NULL},
/* 2588 */ { "PAVÉ PLEIN","	x (carré noir - 25A0)"},
/* 2589 */ { "SEPT HUITIÈMES GAUCHES DE PAVÉ",NULL},
/* 258A */ { "TROIS QUARTS GAUCHES DE PAVÉ",NULL},
/* 258B */ { "CINQ HUITIÈMES GAUCHES DE PAVÉ",NULL},
/* 258C */ { "MOITIÉ GAUCHE DE PAVÉ",NULL},
/* 258D */ { "TROIS HUITIÈMES GAUCHES DE PAVÉ",NULL},
/* 258E */ { "UN QUART GAUCHE DE PAVÉ",NULL},
/* 258F */ { "UN HUITIÈME GAUCHE DE PAVÉ",NULL},
/* 2590 */ { "MOITIÉ DROITE DE PAVÉ",NULL},
/* 2591 */ { "OMBRE LÉGÈRE","	* 25 %"},
/* 2592 */ { "OMBRE MOYENNE","	= remplissage de mouchetures, remplissage pointillé\n"
	"	* 50 %\n"
	"	* sert dans la correspondance avec cp949"},
/* 2593 */ { "OMBRE FONCÉE","	* 75 %"},
/* 2594 */ { "HUITIÈME SUPÉRIEUR DE PAVÉ",NULL},
/* 2595 */ { "HUITIÈME DROIT DE PAVÉ",NULL},
/* 2596 */ { "QUADRANT INFÉRIEUR GAUCHE",NULL},
/* 2597 */ { "QUADRANT INFÉRIEUR DROIT",NULL},
/* 2598 */ { "QUADRANT SUPÉRIEUR GAUCHE",NULL},
/* 2599 */ { "QUADRANT SUPÉRIEUR GAUCHE INFÉRIEUR GAUCHE ET INFÉRIEUR DROIT",NULL},
/* 259A */ { "QUADRANT SUPÉRIEUR GAUCHE ET INFÉRIEUR DROIT","	x (damier inversé - 1F67F)"},
/* 259B */ { "QUADRANT SUPÉRIEUR GAUCHE SUPÉRIEUR DROIT ET INFÉRIEUR GAUCHE",NULL},
/* 259C */ { "QUADRANT SUPÉRIEUR GAUCHE SUPÉRIEUR DROIT ET INFÉRIEUR DROIT",NULL},
/* 259D */ { "QUADRANT SUPÉRIEUR DROIT",NULL},
/* 259E */ { "QUADRANT SUPÉRIEUR DROIT ET INFÉRIEUR GAUCHE","	x (damier - 1F67E)"},
/* 259F */ { "QUADRANT SUPÉRIEUR DROIT INFÉRIEUR GAUCHE ET INFÉRIEUR DROIT",NULL},
/* 25A0 */ { "CARRÉ NOIR","	= carré plein, signe mòdîng (dans les textes idéographiques)\n"
	"	x (pavé plein - 2588)\n"
	"	x (grand carré noir - 2B1B)"},
/* 25A1 */ { "CARRÉ BLANC","	= carré vide, quadrature astronomique\n"
	"	= symbole alchimique du sel\n"
	"	* peut servir à représenter un idéogramme manquant\n"
	"	x (diacritique carré englobant - 20DE)\n"
	"	x (carré moyen blanc - 25FB)\n"
	"	x (case de bulletin - 2610)\n"
	"	x (grand carré blanc - 2B1C)\n"
	"	x (signe geta - 3013)"},
/* 25A2 */ { "CARRÉ BLANC AUX COINS ARRONDIS",NULL},
/* 25A3 */ { "CARRÉ BLANC CONTENANT UN PETIT CARRÉ NOIR",NULL},
/* 25A4 */ { "CARRÉ HACHURÉ HORIZONTALEMENT",NULL},
/* 25A5 */ { "CARRÉ HACHURÉ VERTICALEMENT",NULL},
/* 25A6 */ { "CARRÉ QUADRILLÉ",NULL},
/* 25A7 */ { "CARRÉ HACHURÉ DU HAUT À GAUCHE VERS LE BAS À DROITE",NULL},
/* 25A8 */ { "CARRÉ HACHURÉ DU HAUT À DROITE VERS LE BAS À GAUCHE",NULL},
/* 25A9 */ { "CARRÉ QUADRILLÉ EN DIAGONALE",NULL},
/* 25AA */ { "PETIT CARRÉ NOIR","	= puce carrée\n"
	"	x (très petit carré noir - 2B1D)"},
/* 25AB */ { "PETIT CARRÉ BLANC","	x (très petit carré blanc - 2B1E)"},
/* 25AC */ { "RECTANGLE NOIR",NULL},
/* 25AD */ { "RECTANGLE BLANC",NULL},
/* 25AE */ { "RECTANGLE VERTICAL NOIR","	= billette noire\n"
	"	x (ce qu'il fallait démontrer - 220E)"},
/* 25AF */ { "RECTANGLE VERTICAL BLANC","	= billette blanche\n"
	"	x (symbole de fonction apl quadrat mince - 2337)\n"
	"	x (symbole de fonction apl quadrat - 2395)"},
/* 25B0 */ { "PARALLÉLOGRAMME NOIR",NULL},
/* 25B1 */ { "PARALLÉLOGRAMME BLANC",NULL},
/* 25B2 */ { "TRIANGLE NOIR POINTANT VERS LE HAUT","	x (triangle noir moyen pointant vers le haut - 23F6)\n"
	"	x (triangle moyen noir vers le haut centré - 2BC5)\n"
	"	x (triangle rouge pointant vers le haut - 1F53A)"},
/* 25B3 */ { "TRIANGLE BLANC POINTANT VERS LE HAUT","	x (diacritique triangle englobant pointant vers le haut - 20E4)\n"
	"	x (incrément - 2206)\n"
	"	x (triangle aux coins arrondis - 1F6C6)\n"
	"	x (symbole alchimique du feu - 1F702)"},
/* 25B4 */ { "PETIT TRIANGLE NOIR POINTANT VERS LE HAUT","	x (petit triangle rouge pointant vers le haut - 1F53C)"},
/* 25B5 */ { "PETIT TRIANGLE BLANC POINTANT VERS LE HAUT",NULL},
/* 25B6 */ { "TRIANGLE NOIR POINTANT VERS LA DROITE","	x (triangle noir moyen pointant vers la droite - 23F5)\n"
	"	x (triangle moyen noir vers la droite centré - 2BC8)"},
/* 25B7 */ { "TRIANGLE BLANC POINTANT VERS LA DROITE","	= restriction de codomaine en notation z"},
/* 25B8 */ { "PETIT TRIANGLE NOIR POINTANT VERS LA DROITE","	x (puce triangulaire - 2023)"},
/* 25B9 */ { "PETIT TRIANGLE BLANC POINTANT VERS LA DROITE",NULL},
/* 25BA */ { "POINTEUR NOIR VERS LA DROITE",NULL},
/* 25BB */ { "POINTEUR BLANC VERS LA DROITE","	= indicateur de flèche avant\n"
	"	x (contient comme sous-groupe normal - 22B3)"},
/* 25BC */ { "TRIANGLE NOIR POINTANT VERS LE BAS","	x (triangle noir moyen pointant vers le bas - 23F7)\n"
	"	x (triangle moyen noir vers le bas centré - 2BC6)\n"
	"	x (triangle rouge pointant vers le bas - 1F53B)"},
/* 25BD */ { "TRIANGLE BLANC POINTANT VERS LE BAS","	= opérateur hamiltonien\n"
	"	x (nabla - 2207)\n"
	"	x (triangle épais blanc pointant vers le bas - 26DB)\n"
	"	x (symbole alchimique de l'eau - 1F704)"},
/* 25BE */ { "PETIT TRIANGLE NOIR POINTANT VERS LE BAS","	x (petit triangle rouge pointant vers le bas - 1F53D)"},
/* 25BF */ { "PETIT TRIANGLE BLANC POINTANT VERS LE BAS",NULL},
/* 25C0 */ { "TRIANGLE NOIR POINTANT VERS LA GAUCHE","	x (triangle noir moyen pointant vers la gauche - 23F4)\n"
	"	x (triangle moyen noir vers la gauche centré - 2BC7)"},
/* 25C1 */ { "TRIANGLE BLANC POINTANT VERS LA GAUCHE","	= restriction de domaine en notation z"},
/* 25C2 */ { "PETIT TRIANGLE NOIR POINTANT VERS LA GAUCHE",NULL},
/* 25C3 */ { "PETIT TRIANGLE BLANC POINTANT VERS LA GAUCHE",NULL},
/* 25C4 */ { "POINTEUR NOIR VERS LA GAUCHE",NULL},
/* 25C5 */ { "POINTEUR BLANC VERS LA GAUCHE","	= indicateur de flèche arrière\n"
	"	x (sous-groupe normal de - 22B2)"},
/* 25C6 */ { "LOSANGE NOIR","	x (enseigne de carreau noire - 2666)\n"
	"	x (losange moyen noir - 2B25)\n"
	"	x (grand losange orange - 1F536)"},
/* 25C7 */ { "LOSANGE BLANC","	x (diacritique losange englobant - 20DF)\n"
	"	x (opérateur losange - 22C4)\n"
	"	x (enseigne de carreau blanche - 2662)\n"
	"	x (losange blanc à côtés concaves - 27E1)\n"
	"	x (losange moyen blanc - 2B26)\n"
	"	x (symbole alchimique du savon - 1F754)"},
/* 25C8 */ { "LOSANGE BLANC CONTENANT UN PETIT LOSANGE NOIR","	= losange blanc avec petit losange noir en abyme, macle blanche"},
/* 25C9 */ { "CERCLE BLANC ÉVIDÉ","	= petit cercle noir inscrit dans un cercle blanc, annelet blanc, œil de poisson\n"
	"	= tainome (puce typographique japonaise)"},
/* 25CA */ { "RHOMBE","	x (enseigne de carreau blanche - 2662)"},
/* 25CB */ { "CERCLE BLANC","	x (diacritique cercle englobant - 20DD)\n"
	"	x (grand cercle - 25EF)\n"
	"	x (cercle épais - 2B58)\n"
	"	x (zéro idéographique - 3007)\n"
	"	x (symbole de la pleine lune - 1F315)"},
/* 25CC */ { "CERCLE POINTILLÉ","	* remarquez que le glyphe-témoin utilisé pour ce caractère est à dessein plus grand que le glyphe circulaire pointillé qui est utilisé dans ce standard pour désigner un diacritique ; voir, par exemple, 0300"},
/* 25CD */ { "CERCLE HACHURÉ VERTICALEMENT",NULL},
/* 25CE */ { "DEUX CERCLES CONCENTRIQUES","	x (opérateur rond cerclé - 229A)\n"
	"	x (cercle épais avec cercle inscrit - 2B57)\n"
	"	x (coup direct - 1F3AF)\n"
	"	x (cible ronde - 1F78B)"},
/* 25CF */ { "CERCLE NOIR","	x (grand cercle noir - 2B24)\n"
	"	x (symbole de la nouvelle lune - 1F311)\n"
	"	x (grand cercle rouge - 1F534)"},
/* 25D0 */ { "CERCLE AVEC MOITIÉ GAUCHE NOIRE","	x (symbole du premier quartier de lune - 1F313)"},
/* 25D1 */ { "CERCLE AVEC MOITIÉ DROITE NOIRE","	x (symbole du dernier quartier de lune - 1F317)"},
/* 25D2 */ { "CERCLE AVEC MOITIÉ INFÉRIEURE NOIRE",NULL},
/* 25D3 */ { "CERCLE AVEC MOITIÉ SUPÉRIEURE NOIRE",NULL},
/* 25D4 */ { "CERCLE AVEC QUADRANT SUPÉRIEUR DROIT NOIR",NULL},
/* 25D5 */ { "CERCLE AVEC QUADRANT SUPÉRIEUR GAUCHE BLANC",NULL},
/* 25D6 */ { "DEMI-CERCLE GAUCHE NOIR",NULL},
/* 25D7 */ { "DEMI-CERCLE DROIT NOIR",NULL},
/* 25D8 */ { "PUCE NOIR AU BLANC","	x (puce - 2022)\n"
	"	x (puce blanche - 25E6)"},
/* 25D9 */ { "CERCLE NOIR AU BLANC",NULL},
/* 25DA */ { "DEMI-CERCLE SUPÉRIEUR NOIR AU BLANC",NULL},
/* 25DB */ { "DEMI-CERCLE INFÉRIEUR NOIR AU BLANC",NULL},
/* 25DC */ { "ARC DE CERCLE DANS LE QUADRANT SUPÉRIEUR GAUCHE",NULL},
/* 25DD */ { "ARC DE CERCLE DANS LE QUADRANT SUPÉRIEUR DROIT",NULL},
/* 25DE */ { "ARC DE CERCLE DANS LE QUADRANT INFÉRIEUR DROIT",NULL},
/* 25DF */ { "ARC DE CERCLE DANS LE QUADRANT INFÉRIEUR GAUCHE",NULL},
/* 25E0 */ { "DEMI-CERCLE SUPÉRIEUR","	x (arc - 2312)"},
/* 25E1 */ { "DEMI-CERCLE INFÉRIEUR",NULL},
/* 25E2 */ { "COIN TRIANGULAIRE NOIR INFÉRIEUR DROIT",NULL},
/* 25E3 */ { "COIN TRIANGULAIRE NOIR INFÉRIEUR GAUCHE",NULL},
/* 25E4 */ { "COIN TRIANGULAIRE NOIR SUPÉRIEUR GAUCHE",NULL},
/* 25E5 */ { "COIN TRIANGULAIRE NOIR SUPÉRIEUR DROIT",NULL},
/* 25E6 */ { "PUCE BLANCHE","	x (puce - 2022)\n"
	"	x (opérateur rond - 2218)\n"
	"	x (puce noir au blanc - 25D8)"},
/* 25E7 */ { "CARRÉ À MOITIÉ GAUCHE NOIRE","	x (carré à moitié supérieure noire - 2B12)"},
/* 25E8 */ { "CARRÉ À MOITIÉ DROITE NOIRE",NULL},
/* 25E9 */ { "CARRÉ À MOITIÉ SUPÉRIEURE GAUCHE NOIRE",NULL},
/* 25EA */ { "CARRÉ À MOITIÉ INFÉRIEURE DROITE NOIRE",NULL},
/* 25EB */ { "CARRÉ BLANC À LIGNE BISSECTRICE VERTICALE",NULL},
/* 25EC */ { "TRIANGLE BLANC POINTANT VERS LE HAUT POINTÉ",NULL},
/* 25ED */ { "TRIANGLE POINTE VERS LE HAUT À MOITIÉ GAUCHE NOIRE",NULL},
/* 25EE */ { "TRIANGLE POINTE VERS LE HAUT À MOITIÉ DROITE NOIRE",NULL},
/* 25EF */ { "GRAND CERCLE","	x (diacritique cercle englobant - 20DD)\n"
	"	x (cercle blanc - 25CB)\n"
	"	x (grand cercle noir - 2B24)\n"
	"	x (grand cercle épais - 2B55)\n"
	"	x (zéro idéographique - 3007)"},
/* 25F0 */ { "CARRÉ BLANC À QUARTIER SUPÉRIEUR GAUCHE",NULL},
/* 25F1 */ { "CARRÉ BLANC À QUARTIER INFÉRIEUR GAUCHE",NULL},
/* 25F2 */ { "CARRÉ BLANC À QUARTIER INFÉRIEUR DROIT",NULL},
/* 25F3 */ { "CARRÉ BLANC À QUARTIER SUPÉRIEUR DROIT",NULL},
/* 25F4 */ { "CERCLE BLANC À QUARTIER SUPÉRIEUR GAUCHE",NULL},
/* 25F5 */ { "CERCLE BLANC À QUARTIER INFÉRIEUR GAUCHE",NULL},
/* 25F6 */ { "CERCLE BLANC À QUARTIER INFÉRIEUR DROIT",NULL},
/* 25F7 */ { "CERCLE BLANC À QUARTIER SUPÉRIEUR DROIT",NULL},
/* 25F8 */ { "TRIANGLE RECTANGLE SUPÉRIEUR GAUCHE",NULL},
/* 25F9 */ { "TRIANGLE RECTANGLE SUPÉRIEUR DROIT",NULL},
/* 25FA */ { "TRIANGLE RECTANGLE INFÉRIEUR GAUCHE","	x (triangle rectangle - 22BF)"},
/* 25FB */ { "CARRÉ MOYEN BLANC","	= toujours (opérateur modal)\n"
	"	x (carré blanc - 25A1)\n"
	"	x (carré blanc avec trait à gauche - 27E4)"},
/* 25FC */ { "CARRÉ MOYEN NOIR","	x (carré noir pour arrêt - 23F9)\n"
	"	x (carré noir - 25A0)"},
/* 25FD */ { "CARRÉ MODÉRÉMENT PETIT BLANC","	x (petit carré blanc - 25AB)"},
/* 25FE */ { "CARRÉ MODÉRÉMENT PETIT NOIR","	x (petit carré noir - 25AA)"},
/* 25FF */ { "TRIANGLE RECTANGLE INFÉRIEUR DROIT","	x (triangle rectangle - 22BF)"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_26[] = {
/* 2600 */ { "SOLEIL NOIR AVEC RAYONS","	= beau temps\n"
	"	x (soleil - 2609)\n"
	"	x (symbole de la forte intensité - 1F506)"},
/* 2601 */ { "NUAGE","	= nuageux"},
/* 2602 */ { "PARAPLUIE","	= pluvieux\n"
	"	x (parapluie fermé - 1F302)"},
/* 2603 */ { "BONHOMME DE NEIGE","	= temps de neige"},
/* 2604 */ { "COMÈTE",NULL},
/* 2605 */ { "ÉTOILE NOIRE","	= étoile pleine\n"
	"	x (opérateur étoile - 22C6)\n"
	"	x (petite étoile noire - 2B51)\n"
	"	x (étoile noire à cinq branches fine - 1F7C9)"},
/* 2606 */ { "ÉTOILE BLANCHE","	= étoile vide\n"
	"	x (étoile blanche à contour accentué - 2729)\n"
	"	x (étoile moyenne blanche - 2B50)\n"
	"	x (étoile brillante - 1F31F)"},
/* 2607 */ { "ÉCLAIR",NULL},
/* 2608 */ { "ORAGE",NULL},
/* 2609 */ { "SOLEIL","	= symbole alchimique de l'or\n"
	"	x (opérateur point cerclé - 2299)\n"
	"	x (soleil noir avec rayons - 2600)\n"
	"	x (soleil blanc avec rayons - 263C)\n"
	"	x (soleil avec visage - 1F31E)"},
/* 260A */ { "NŒUD ASCENDANT",NULL},
/* 260B */ { "NŒUD DESCENDANT","	x (symbole alchimique purifier - 1F763)"},
/* 260C */ { "CONJONCTION","	= symbole alchimique du jour"},
/* 260D */ { "OPPOSITION",NULL},
/* 260E */ { "TÉLÉPHONE NOIR","	x (symbole téléphone - 2121)\n"
	"	x (symbole d'emplacement du téléphone - 2706)\n"
	"	x (récepteur téléphonique - 1F4DE)\n"
	"	x (téléphone à clavier noir - 1F57F)"},
/* 260F */ { "TÉLÉPHONE BLANC","	x (téléphone à clavier blanc - 1F57E)"},
/* 2610 */ { "CASE DE BULLETIN","	x (carré blanc - 25A1)"},
/* 2611 */ { "CASE DE BULLETIN MARQUÉE D'UNE COCHE","	= coche encadrée\n"
	"	x (case de bulletin marquée d'une coche grasse - 1F5F9)"},
/* 2612 */ { "CASE DE BULLETIN MARQUÉE D'UN X","	x (multiplié par encadré - 22A0)\n"
	"	x (case de bulletin marquée d'un x fin - 2BBD)\n"
	"	x (urne avec bulletin - 1F5F3)\n"
	"	x (case de bulletin marquée d'un x cursif - 1F5F5)"},
/* 2613 */ { "SAUTOIR","	= croix de saint André, croix encadrée, croix en sautoir, croix de Bourgogne\n"
	"	x (x de vote - 2717)\n"
	"	x (sautoir fin - 1F7A9)"},
/* 2614 */ { "PARAPLUIE AVEC GOUTTES DE PLUIE","	= mauvais temps"},
/* 2615 */ { "BOISSON CHAUDE","	= thé ou café selon le profil culturel\n"
	"	* peut indiquer une attente\n"
	"	x (montre - 231A)\n"
	"	x (sablier - 231B)\n"
	"	x (tasse à thé sans anse - 1F375)"},
/* 2616 */ { "PIÈCE DE CHOGI BLANCHE",NULL},
/* 2617 */ { "PIÈCE DE CHOGI NOIRE",NULL},
/* 2618 */ { "TRÈFLE IRLANDAIS","	x (trèfle à quatre feuilles - 1F340)"},
/* 2619 */ { "CŒUR FLORAL COUCHÉ À DROITE","	= feuille de lierre couchée à droite\n"
	"	* marque de cahier en reliure\n"
	"	x (cœur floral couché - 2767)\n"
	"	x (feuille de vigne sud-ouest - 1F659)"},
/* 261A */ { "INDEX NOIR POINTANT VERS LA GAUCHE",NULL},
/* 261B */ { "INDEX NOIR POINTANT VERS LA DROITE",NULL},
/* 261C */ { "INDEX BLANC POINTANT VERS LA GAUCHE","	x (index de revers de main blanc pointant vers la gauche - 1F448)\n"
	"	x (index blanc pointant vers la gauche couché - 1F598)"},
/* 261D */ { "INDEX BLANC POINTANT VERS LE HAUT","	x (index blanc pointant vers le haut couché - 1F59E)"},
/* 261E */ { "INDEX BLANC POINTANT VERS LA DROITE","	= main (terme typographique)\n"
	"	x (index blanc pointant vers la droite couché - 1F599)"},
/* 261F */ { "INDEX BLANC POINTANT VERS LE BAS","	x (index de la main gauche blanc pointant vers le bas - 1F597)\n"
	"	x (index blanc pointant vers le bas couché - 1F59F)"},
/* 2620 */ { "TÊTE DE MORT","	= symbole de danger, symbole pirate\n"
	"	x (tête de mort noire - 1F571)"},
/* 2621 */ { "VIRAGES",NULL},
/* 2622 */ { "SYMBOLE POUR RADIOACTIF",NULL},
/* 2623 */ { "SYMBOLE DANGER BIOLOGIQUE",NULL},
/* 2624 */ { "CADUCÉE","	* à multiples lovements\n"
	"	x (bâton serpentaire d'esculape - 2695)\n"
	"	x (symbole alchimique de la caducée - 1F750)"},
/* 2625 */ { "ANKH","	= croix égyptienne"},
/* 2626 */ { "CROIX ORTHODOXE",NULL},
/* 2627 */ { "CHRISME","	= khi rhô, croix de Constantin\n"
	"	x (symbole copte khi rhô - 2CE9)"},
/* 2628 */ { "CROIX DE LORRAINE",NULL},
/* 2629 */ { "CROIX DE JÉRUSALEM","	= croix à béquilles\n"
	"	* se distingue de la croix de Jérusalem réelle, qui est composée d'une grande croix grecque cantonnée de quatre petites croix, également grecques\n"
	"	x (symbole alchimique du vinaigre - 1F70A)"},
/* 262A */ { "ÉTOILE ET CROISSANT",NULL},
/* 262B */ { "SYMBOLE FARSI","	= symbole de l'Iran (1.0)"},
/* 262C */ { "ÂDI ÇAKTI","	= khanda gourmoukhî"},
/* 262D */ { "FAUCILLE ET MARTEAU",NULL},
/* 262E */ { "SYMBOLE DE LA PAIX",NULL},
/* 262F */ { "YIN ET YANG","	x (symbole tibétain double corps - 0FCA)"},
/* 2630 */ { "TRIGRAMME DU CIEL","	= ts'ien, qian2"},
/* 2631 */ { "TRIGRAMME DU LAC","	= touei, dui4"},
/* 2632 */ { "TRIGRAMME DU FEU","	= li, li2"},
/* 2633 */ { "TRIGRAMME DU TONNERRE","	= tchen, zhen4"},
/* 2634 */ { "TRIGRAMME DU VENT","	= hsiun, xun4"},
/* 2635 */ { "TRIGRAMME DE L'EAU","	= k'an, kan3"},
/* 2636 */ { "TRIGRAMME DE LA MONTAGNE","	= ken, gen4"},
/* 2637 */ { "TRIGRAMME DE LA TERRE","	= k'ouen, kun1"},
/* 2638 */ { "ROUE DE DHARMA","	x (symbole barre à roue - 2388)"},
/* 2639 */ { "VISAGE BLANC GRIMAÇANT","	x (visage légèrement grimaçant - 1F641)"},
/* 263A */ { "VISAGE BLANC SOURIANT","	= bonne journée !\n"
	"	x (visage légèrement souriant - 1F642)"},
/* 263B */ { "VISAGE NOIR SOURIANT",NULL},
/* 263C */ { "SOLEIL BLANC AVEC RAYONS","	= compas\n"
	"	x (soleil - 2609)\n"
	"	x (soleil blanc - 1F323)\n"
	"	x (symbole de la forte intensité - 1F506)"},
/* 263D */ { "PREMIER QUARTIER DE LUNE","	= symbole alchimique de l'argent"},
/* 263E */ { "DERNIER QUARTIER DE LUNE","	= symbole alchimique de l'argent\n"
	"	x (symbole mise en veille - 23FE)\n"
	"	x (croissant de lune - 1F319)"},
/* 263F */ { "MERCURE","	= symbole alchimique du mercure"},
/* 2640 */ { "SIGNE FEMELLE","	= Vénus\n"
	"	= symbole alchimique du cuivre\n"
	"	x (femme - 1F469)\n"
	"	x (symbole femmes - 1F6BA)"},
/* 2641 */ { "TERRE","	= symbole alchimique de l'antimoine\n"
	"	x (symbole alchimique du vert-de-gris - 1F728)"},
/* 2642 */ { "SIGNE MÂLE","	= Mars\n"
	"	= symbole alchimique du fer\n"
	"	x (homme - 1F468)\n"
	"	x (symbole hommes - 1F6B9)"},
/* 2643 */ { "JUPITER","	= symbole alchimique de l'étain"},
/* 2644 */ { "SATURNE","	= symbole alchimique du plomb"},
/* 2645 */ { "URANUS","	x (symbole astronomique d'uranus - 26E2)"},
/* 2646 */ { "NEPTUNE","	= symbole alchimique du bismuth (de l'étain de glace)"},
/* 2647 */ { "PLUTON",NULL},
/* 2648 */ { "BÉLIER","	x (bouc - 1F40F)"},
/* 2649 */ { "TAUREAU",NULL},
/* 264A */ { "GÉMEAUX",NULL},
/* 264B */ { "CANCER","	x (crabe - 1F980)"},
/* 264C */ { "LION","	x (face de lion - 1F981)"},
/* 264D */ { "VIERGE","	= autre glyphe pour la goutte, la minime anglo-saxonne"},
/* 264E */ { "BALANCE","	x (balance de thémis - 2696)\n"
	"	x (symbole alchimique sublimer - 1F75E)"},
/* 264F */ { "SCORPION","	= goutte, minime anglo-saxonne\n"
	"	x (symbole scorpion - 1F982)"},
/* 2650 */ { "SAGITTAIRE","	x (arc et flèche - 1F3F9)"},
/* 2651 */ { "CAPRICORNE",NULL},
/* 2652 */ { "VERSEAU","	x (amphore - 1F3FA)"},
/* 2653 */ { "POISSONS",NULL},
/* 2654 */ { "ROI BLANC DU JEU D'ÉCHECS",NULL},
/* 2655 */ { "DAME BLANCHE DU JEU D'ÉCHECS",NULL},
/* 2656 */ { "TOUR BLANCHE DU JEU D'ÉCHECS",NULL},
/* 2657 */ { "FOU BLANC DU JEU D'ÉCHECS",NULL},
/* 2658 */ { "CAVALIER BLANC DU JEU D'ÉCHECS",NULL},
/* 2659 */ { "PION BLANC DU JEU D'ÉCHECS",NULL},
/* 265A */ { "ROI NOIR DU JEU D'ÉCHECS",NULL},
/* 265B */ { "DAME NOIRE DU JEU D'ÉCHECS",NULL},
/* 265C */ { "TOUR NOIRE DU JEU D'ÉCHECS",NULL},
/* 265D */ { "FOU NOIR DU JEU D'ÉCHECS",NULL},
/* 265E */ { "CAVALIER NOIR DU JEU D'ÉCHECS",NULL},
/* 265F */ { "PION NOIR DU JEU D'ÉCHECS",NULL},
/* 2660 */ { "ENSEIGNE DE PIQUE NOIRE",NULL},
/* 2661 */ { "ENSEIGNE DE CŒUR BLANCHE",NULL},
/* 2662 */ { "ENSEIGNE DE CARREAU BLANCHE","	x (losange blanc - 25C7)\n"
	"	x (rhombe - 25CA)"},
/* 2663 */ { "ENSEIGNE DE TRÈFLE NOIRE","	x (trèfle irlandais - 2618)"},
/* 2664 */ { "ENSEIGNE DE PIQUE BLANCHE",NULL},
/* 2665 */ { "ENSEIGNE DE CŒUR NOIRE","	x (cœur noir épais - 2764)\n"
	"	x (cœur avec pointe à gauche - 1F394)\n"
	"	x (cœur bleu - 1F499)\n"
	"	x (cœur noir - 1F5A4)"},
/* 2666 */ { "ENSEIGNE DE CARREAU NOIRE","	x (losange noir - 25C6)"},
/* 2667 */ { "ENSEIGNE DE TRÈFLE BLANCHE",NULL},
/* 2668 */ { "SOURCES CHAUDES",NULL},
/* 2669 */ { "NOTE NOIRE","	x (symbole musical noire - 1D15F)"},
/* 266A */ { "NOTE CROCHE","	x (symbole musical croche - 1D160)\n"
	"	x (note de musique - 1F3B5)"},
/* 266B */ { "DEUX CROCHES RAMÉES","	x (notes de musique descendantes ramées - 1F39D)\n"
	"	x (notes de musique multiples - 1F3B6)"},
/* 266C */ { "DEUX DOUBLES CROCHES RAMÉES",NULL},
/* 266D */ { "BÉMOL",NULL},
/* 266E */ { "BÉCARRE",NULL},
/* 266F */ { "DIÈSE","	= cardinalité d'un sac, taille d'un ensemble en notation z\n"
	"	x (croisillon - 0023)"},
/* 2670 */ { "CROIX SYRIAQUE OCCIDENTALE",NULL},
/* 2671 */ { "CROIX SYRIAQUE ORIENTALE",NULL},
/* 2672 */ { "SYMBOLE DE RECYCLAGE UNIVERSEL","	* utilisé comme symbole générique pour le recyclage ou pour indiquer qu'un produit est recyclable\n"
	"	* représenté par trois flèches dont chacune pointe vers l'empennage d'une des deux autres, de façon à constituer un ruban de Möbius en forme de triangle"},
/* 2673 */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES PLASTIQUES DE TYPE 1","	* polytéréphtalate d'éthylène (PET)"},
/* 2674 */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES PLASTIQUES DE TYPE 2","	* polyéthylène haute densité (PEHD)"},
/* 2675 */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES PLASTIQUES DE TYPE 3","	* vinyle, polychlorure de vinyle (PVC)"},
/* 2676 */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES PLASTIQUES DE TYPE 4","	* polyéthylène basse densité (PEBD)"},
/* 2677 */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES PLASTIQUES DE TYPE 5","	* polypropylène (PP, PPi)"},
/* 2678 */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES PLASTIQUES DE TYPE 6","	* polystyrène (PS)"},
/* 2679 */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES PLASTIQUES DE TYPE 7","	* autres matières plastiques"},
/* 267A */ { "SYMBOLE DE RECYCLAGE POUR MATIÈRES GÉNÉRIQUES","	* s'utilise en compagnie d'un texte ou d'un dessin supplémentaire pour indiquer le produit à recycler"},
/* 267B */ { "SYMBOLE DE RECYCLAGE UNIVERSEL NOIR","	x (flèches vers la droite et vers la gauche sens horaire en cercle ouvert - 1F501)"},
/* 267C */ { "SYMBOLE PAPIER RECYCLÉ","	* indique un composé à base de papier 100 % recyclé"},
/* 267D */ { "SYMBOLE PAPIER PARTIELLEMENT RECYCLÉ","	* le pourcentage de papier recyclé est imprimé au-dessus ou à côté de ce symbole"},
/* 267E */ { "SYMBOLE PAPIER PERMANENT",NULL},
/* 267F */ { "SYMBOLE FAUTEUIL ROULANT",NULL},
/* 2680 */ { "FACE DE DÉ-1","	x (dé à jouer - 1F3B2)"},
/* 2681 */ { "FACE DE DÉ-2",NULL},
/* 2682 */ { "FACE DE DÉ-3",NULL},
/* 2683 */ { "FACE DE DÉ-4",NULL},
/* 2684 */ { "FACE DE DÉ-5",NULL},
/* 2685 */ { "FACE DE DÉ-6",NULL},
/* 2686 */ { "CERCLE BLANC AVEC POINT À DROITE",NULL},
/* 2687 */ { "CERCLE BLANC AVEC DEUX POINTS","	x (visage sans bouche - 1F636)"},
/* 2688 */ { "CERCLE NOIR AVEC POINT BLANC À DROITE",NULL},
/* 2689 */ { "CERCLE NOIR AVEC DEUX POINTS BLANCS",NULL},
/* 268A */ { "MONOGRAMME DU YANG",NULL},
/* 268B */ { "MONOGRAMME DU YIN",NULL},
/* 268C */ { "DIGRAMME DU GRAND YANG",NULL},
/* 268D */ { "DIGRAMME DU PETIT YIN",NULL},
/* 268E */ { "DIGRAMME DU PETIT YANG",NULL},
/* 268F */ { "DIGRAMME DU GRAND YIN",NULL},
/* 2690 */ { "DRAPEAU BLANC","	x (drapeau blanc battant au vent - 1F3F3)"},
/* 2691 */ { "DRAPEAU NOIR",NULL},
/* 2692 */ { "MARTEAU ET PIOCHE","	= mine, jour ouvrable (dans les horaires ou indicateurs)\n"
	"	x (pioche - 26CF)\n"
	"	x (marteau et clé à écrous - 1F6E0)"},
/* 2693 */ { "ANCRE","	= terme nautique, port (sur les cartes)"},
/* 2694 */ { "ÉPÉES CROISÉES","	= terme militaire, champ de bataille (sur les cartes), tué au combat\n"
	"	x (escrimeur - 1F93A)"},
/* 2695 */ { "BÂTON SERPENTAIRE D'ESCULAPE","	= terme médical\n"
	"	* les deux formes de représentation de ce symbole, inclinée ou droite, sont pareillement répandues\n"
	"	x (caducée - 2624)\n"
	"	x (coupe d'hygie - 1F54F)"},
/* 2696 */ { "BALANCE DE THÉMIS","	= terme juridique, jurisprudence\n"
	"	x (balance - 264E)"},
/* 2697 */ { "ALAMBIC","	= terme chimique, chimie\n"
	"	x (symbole alchimique de la cornue - 1F76D)"},
/* 2698 */ { "FLEUR","	= terme botanique\n"
	"	x (point-fleur - 2055)\n"
	"	x (fleuron blanc - 2740)\n"
	"	x (tulipe - 1F337)"},
/* 2699 */ { "ROUE DENTÉE","	= technique, outils"},
/* 269A */ { "CADUCÉE D'HERMÈS","	* symbole du commerce comme de l'éloquence\n"
	"	* le glyphe représente un bâton héraldique agrémenté d'une roue ailée"},
/* 269B */ { "SYMBOLE ATOME","	= centrale nucléaire (sur les cartes)"},
/* 269C */ { "FLEUR DE LIS",NULL},
/* 269D */ { "ÉTOILE BLANCHE À CONTOUR","	* autre forme du pentagramme tressé (un symbole du Maroc)\n"
	"	x (pentagramme tressé à droite - 26E5)"},
/* 269E */ { "TROIS LIGNES CONVERGENTES VERS LA DROITE","	= voix de premier plan\n"
	"	x (trois rayons vers la gauche - 1F5E6)"},
/* 269F */ { "TROIS LIGNES CONVERGENTES VERS LA GAUCHE","	= voix d'arrière-plan\n"
	"	x (trois rayons vers la droite - 1F5E7)"},
/* 26A0 */ { "SIGNAL DE DANGER","	x (panneau octogonal - 1F6D1)"},
/* 26A1 */ { "SIGNAL DE HAUTE TENSION","	= tonnerre\n"
	"	= symbole de la foudre\n"
	"	x (humeur de foudre - 1F5F2)"},
/* 26A2 */ { "SIGNE FEMELLE DOUBLE","	= lesbianisme, saphisme\n"
	"	x (deux femmes se tenant par la main - 1F46D)"},
/* 26A3 */ { "SIGNE MÂLE DOUBLE","	= homosexualité mâle\n"
	"	* une variante de glyphe représente les deux cercles sur la même ligne\n"
	"	x (deux hommes se tenant par la main - 1F46C)"},
/* 26A4 */ { "SIGNE MÂLE ET FEMELLE ENLACÉS","	= bisexualité\n"
	"	* une variante de glyphe représente les deux cercles sur la même ligne"},
/* 26A5 */ { "SIGNE MÂLE ET FEMELLE","	= sexualité transsexuelle ou transgenre\n"
	"	= hermaphrodite (en entomologie)"},
/* 26A6 */ { "SIGNE MÂLE À TRAIT","	= sexualité transsexuelle ou transgenre\n"
	"	= peroxide de fer (alchimie et ancienne chimie)"},
/* 26A7 */ { "SIGNE MÂLE À TRAIT ET MÂLE ET FEMELLE","	= sexualité transsexuelle ou transgenre"},
/* 26A8 */ { "SIGNE MÂLE VERTICAL AVEC TRAIT","	= sulfate ferreux (alchimie et ancienne chimie)"},
/* 26A9 */ { "SIGNE MÂLE HORIZONTAL AVEC TRAIT","	= magnésium (alchimie et ancienne chimie)"},
/* 26AA */ { "CERCLE BLANC MOYEN","	= asexualité, asexué, sans-genre\n"
	"	= fiancé\n"
	"	* base des signes mâle et femelle\n"
	"	x (cercle blanc moyennement gras - 1F785)"},
/* 26AB */ { "CERCLE NOIR MOYEN","	* symbole d'IU pour l'enregistrement\n"
	"	x (cercle noir pour enregistrement - 23FA)"},
/* 26AC */ { "CERCLE BLANC MODÉRÉMENT PETIT","	= fiancé (en généalogie)\n"
	"	* peut représenter l'alliance, l'anneau nuptial"},
/* 26AD */ { "SYMBOLE DU MARIAGE","	x (infini - 221E)\n"
	"	x (mariage - 1F492)"},
/* 26AE */ { "SYMBOLE DU DIVORCE","	x (infini nié par une barre verticale - 29DE)"},
/* 26AF */ { "SYMBOLE DE COUPLE NON MARIÉ","	x (multijection à deux têtes - 29DF)"},
/* 26B0 */ { "CERCUEIL","	= enterré (généalogie)\n"
	"	x (rectangle blanc - 25AD)"},
/* 26B1 */ { "URNE FUNÉRAIRE","	= incinéré (généalogie)"},
/* 26B2 */ { "NEUTRE",NULL},
/* 26B3 */ { "CÉRÈS",NULL},
/* 26B4 */ { "PALLAS",NULL},
/* 26B5 */ { "JUNON",NULL},
/* 26B6 */ { "VESTA",NULL},
/* 26B7 */ { "CHIRON",NULL},
/* 26B8 */ { "LUNE NOIRE LILITH",NULL},
/* 26B9 */ { "SEXTILE","	x (astérisque - 002A)\n"
	"	x (étoile noire à six branches - 2736)\n"
	"	x (symbole alchimique du sel ammoniac - 1F739)"},
/* 26BA */ { "DEMI-SEXTILE","	x (ou exclusif - 22BB)"},
/* 26BB */ { "QUINCONCE","	x (non et - 22BC)"},
/* 26BC */ { "SESQUICARRÉ",NULL},
/* 26BD */ { "BALLON DE FOOTBALL",NULL},
/* 26BE */ { "BALLE DE BASEBALL",NULL},
/* 26BF */ { "CLÉ ENCADRÉE","	= contrôle parental\n"
	"	x (clé - 1F511)"},
/* 26C0 */ { "PION BLANC DE DAMES",NULL},
/* 26C1 */ { "DAME BLANCHE DE DAMES",NULL},
/* 26C2 */ { "PION NOIR DE DAMES",NULL},
/* 26C3 */ { "DAME NOIRE DE DAMES",NULL},
/* 26C4 */ { "BONHOMME DE NEIGE SANS NEIGE","	= neige peu abondante"},
/* 26C5 */ { "SOLEIL DERRIÈRE UN NUAGE","	= partiellement nuageux\n"
	"	x (soleil blanc avec petit nuage - 1F324)"},
/* 26C6 */ { "PLUIE","	= temps pluvieux"},
/* 26C7 */ { "BONHOMME DE NEIGE NOIR","	= neige abondante"},
/* 26C8 */ { "NUAGE ORAGEUX ET PLUIE","	= orage\n"
	"	x (nuage avec éclair - 1F329)"},
/* 26C9 */ { "PIÈCE DE CHOGI BLANCHE CULBUTÉE",NULL},
/* 26CA */ { "PIÈCE DE CHOGI NOIRE CULBUTÉE",NULL},
/* 26CB */ { "LOSANGE BLANC DANS UN CARRÉ","	x (symbole de fonction apl rideaux - 233A)"},
/* 26CC */ { "VOIES CROISÉES","	= accident\n"
	"	x (diagonale descendante sur diagonale montante - 292C)"},
/* 26CD */ { "VOITURE EN PANNE",NULL},
/* 26CE */ { "SERPENTAIRE",NULL},
/* 26CF */ { "PIOCHE","	= en construction\n"
	"	x (marteau et pioche - 2692)\n"
	"	x (panneau indicateur de construction - 1F6A7)"},
/* 26D0 */ { "VOITURE EN DÉRAPAGE","	= route verglacée"},
/* 26D1 */ { "CASQUE AVEC CROIX BLANCHE","	= maintenance, entretien\n"
	"	x (ouvrier de la construction - 1F477)"},
/* 26D2 */ { "VOIES CROISÉES CERCLÉES","	= route barrée\n"
	"	x (multiplié par cerclé - 2297)"},
/* 26D3 */ { "CHAÎNES","	= chaînes à neige obligatoires"},
/* 26D4 */ { "ENTRÉE INTERDITE","	x (panneau entrée interdite - 1F6AB)"},
/* 26D5 */ { "CIRCULATION ALTERNÉE SUR LA VOIE DE GAUCHE","	* conduite à gauche"},
/* 26D6 */ { "CIRCULATION BIDIRECTIONNELLE CONDUITE À GAUCHE NOIR","	* conduite à gauche"},
/* 26D7 */ { "CIRCULATION BIDIRECTIONNELLE CONDUITE À GAUCHE BLANC","	* conduite à gauche"},
/* 26D8 */ { "CONVERGENCE À GAUCHE NOIR","	* conduite à gauche"},
/* 26D9 */ { "CONVERGENCE À GAUCHE BLANC","	* conduite à gauche"},
/* 26DA */ { "PANNEAU ROULEZ LENTEMENT",NULL},
/* 26DB */ { "TRIANGLE ÉPAIS BLANC POINTANT VERS LE BAS","	= roulez lentement\n"
	"	x (triangle blanc pointant vers le bas - 25BD)"},
/* 26DC */ { "ENTRÉE À GAUCHE FERMÉE",NULL},
/* 26DD */ { "SAUTOIR ENCADRÉ","	= entrée fermée\n"
	"	x (multiplié par encadré - 22A0)"},
/* 26DE */ { "DIAGONALE DESCENDANTE DANS UN CERCLE BLANC SUR CARRÉ NOIR","	= interdit aux poids lourds"},
/* 26DF */ { "CAMION NOIR","	= interdit aux poids lourds (variante)\n"
	"	x (camion de livraison - 1F69A)"},
/* 26E0 */ { "ENTRÉE GAUCHE RESTREINTE-1",NULL},
/* 26E1 */ { "ENTRÉE GAUCHE RESTREINTE-2",NULL},
/* 26E2 */ { "SYMBOLE ASTRONOMIQUE D'URANUS","	x (uranus - 2645)"},
/* 26E3 */ { "CERCLE ÉPAIS AVEC BARRE VERTICALE ENTRE DEUX POINTS EN CHEF",NULL},
/* 26E4 */ { "PENTAGRAMME","	* symbole pour différents usages, incluant le symbole sur le drapeau marocain\n"
	"	x (étoile blanche - 2606)"},
/* 26E5 */ { "PENTAGRAMME TRESSÉ À DROITE","	* symbole de divers pays, incluant le Maroc\n"
	"	x (étoile blanche à contour - 269D)"},
/* 26E6 */ { "PENTAGRAMME TRESSÉ À GAUCHE","	* symbole de divers pays, incluant l'Éthiopie"},
/* 26E7 */ { "PENTAGRAMME RENVERSÉ",NULL},
/* 26E8 */ { "CROIX NOIRE SUR BOUCLIER","	= hôpital\n"
	"	x (hôpital - 1F3E5)"},
/* 26E9 */ { "SANCTUAIRE SHINTOÏSTE","	= torii"},
/* 26EA */ { "ÉGLISE",NULL},
/* 26EB */ { "CHÂTEAU","	x (château européen - 1F3F0)"},
/* 26EC */ { "SITE HISTORIQUE","	x (par conséquent - 2234)"},
/* 26ED */ { "ROUE D'ENGRENAGE SANS MOYEU","	= usine\n"
	"	x (roue dentée - 2699)\n"
	"	x (usine - 1F3ED)"},
/* 26EE */ { "ROUE D'ENGRENAGE AVEC POIGNÉES","	= centrale électrique"},
/* 26EF */ { "SYMBOLE CARTOGRAPHIQUE DE PHARE",NULL},
/* 26F0 */ { "MONTAGNE","	x (cime enneigée - 1F3D4)"},
/* 26F1 */ { "PARAPLUIE AU SOL","	= plage de baignade\n"
	"	x (parapluie - 2602)\n"
	"	x (plage avec parasol - 1F3D6)"},
/* 26F2 */ { "FONTAINE","	= parc"},
/* 26F3 */ { "FANION DANS UN TROU","	= parcours de golf\n"
	"	x (fanion triangulaire de localisation - 1F6A9)"},
/* 26F4 */ { "BAC","	= terminal de ferry\n"
	"	x (navire - 1F6A2)"},
/* 26F5 */ { "VOILIER","	= port de plaisance\n"
	"	x (canot à rames - 1F6A3)"},
/* 26F6 */ { "QUATRE COINS EN CARRÉ","	= carrefour"},
/* 26F7 */ { "SKIEUR","	= station de ski\n"
	"	x (ski et botte de ski - 1F3BF)"},
/* 26F8 */ { "PATIN À GLACE","	= patinoire"},
/* 26F9 */ { "PERSONNE AVEC BALLON","	= complexe d'athlétisme, gymnase"},
/* 26FA */ { "TENTE","	= aire de camping\n"
	"	x (camping - 1F3D5)"},
/* 26FB */ { "SYMBOLE JAPONAIS DE BANQUE","	x (banque - 1F3E6)"},
/* 26FC */ { "SYMBOLE DE CIMETIÈRE","	= nécropole"},
/* 26FD */ { "POMPE À ESSENCE","	= station-service"},
/* 26FE */ { "TASSE SUR CARRÉ NOIR","	= restoroute\n"
	"	x (boisson chaude - 2615)\n"
	"	x (tasse à thé sans anse - 1F375)"},
/* 26FF */ { "DRAPEAU BLANC À BANDE MÉDIANE HORIZONTALE NOIRE","	= site des forces japonaises d'autodéfense"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_27[] = {
/* 2700 */ { "CISEAUX DE SÉCURITÉ NOIRS","	* forme une paire avec 2704"},
/* 2701 */ { "CISEAUX À LAME SUPÉRIEURE VISIBLE",NULL},
/* 2702 */ { "CISEAUX NOIRS",NULL},
/* 2703 */ { "CISEAUX À LAME INFÉRIEURE VISIBLE",NULL},
/* 2704 */ { "CISEAUX BLANCS",NULL},
/* 2705 */ { "COCHE ÉPAISSE BLANCHE","	x (coche épaisse - 2714)"},
/* 2706 */ { "SYMBOLE D'EMPLACEMENT DU TÉLÉPHONE","	x (symbole téléphone - 2121)\n"
	"	x (récepteur téléphonique - 1F4DE)"},
/* 2707 */ { "DÉROULEUR DE RUBAN",NULL},
/* 2708 */ { "AVION","	x (avion pointant vers le haut - 1F6E7)"},
/* 2709 */ { "ENVELOPPE","	x (enveloppe de réception - 1F4E8)\n"
	"	x (dos d'enveloppe - 1F582)"},
/* 270A */ { "POING LEVÉ","	= pierre ou roche (jeu des trois coups)\n"
	"	x (signe du coup de poing - 1F44A)"},
/* 270B */ { "MAIN LEVÉE","	= papier ou feuille (jeu des trois coups)\n"
	"	x (salut de la main - 1F44B)\n"
	"	x (main levée avec doigts écartés - 1F590)"},
/* 270C */ { "MAIN DE LA VICTOIRE","	= ciseaux (jeu des trois coups)\n"
	"	x (main de dos faisant le signe de la victoire - 1F594)"},
/* 270D */ { "MAIN ÉCRIVANT","	= lettre manuscrite\n"
	"	x (main gauche écrivant - 1F58E)"},
/* 270E */ { "CRAYON VERS LE BAS À DROITE","	x (crayon vers le bas à gauche - 1F589)"},
/* 270F */ { "CRAYON",NULL},
/* 2710 */ { "CRAYON VERS LE HAUT À DROITE",NULL},
/* 2711 */ { "BEC DE PLUME BLANC","	x (stylo plume vers le bas à gauche - 1F58B)"},
/* 2712 */ { "BEC DE PLUME NOIR",NULL},
/* 2713 */ { "COCHE","	x (racine carrée - 221A)\n"
	"	x (coche mince - 1F5F8)"},
/* 2714 */ { "COCHE ÉPAISSE",NULL},
/* 2715 */ { "X DE MULTIPLICATION","	x (signe de multiplication - 00D7)\n"
	"	x (filet diagonal fin en croix - 2573)"},
/* 2716 */ { "X DE MULTIPLICATION ÉPAIS",NULL},
/* 2717 */ { "X DE VOTE","	x (sautoir - 2613)\n"
	"	x (x cursif de vote - 1F5F4)"},
/* 2718 */ { "X DE VOTE ÉPAIS","	x (x cursif de vote gras - 1F5F6)"},
/* 2719 */ { "CROIX GRECQUE AVEC CONTOUR",NULL},
/* 271A */ { "CROIX GRECQUE ÉPAISSE","	x (croix grecque très grasse - 1F7A5)"},
/* 271B */ { "CROIX PERCÉE D'UN CARRÉ",NULL},
/* 271C */ { "CROIX ÉPAISSE PERCÉE D'UN CARRÉ",NULL},
/* 271D */ { "CROIX LATINE",NULL},
/* 271E */ { "CROIX LATINE BLANCHE OMBRÉE","	x (croix latine blanche - 1F546)"},
/* 271F */ { "CROIX LATINE AVEC CONTOUR",NULL},
/* 2720 */ { "CROIX DE MALTE","	* la croix de Malte a pris plusieurs formes ; le dessin du caractère présenté est semblable à celui de la croix pattée\n"
	"	x (croix pattée cerclée - 1F902)"},
/* 2721 */ { "ÉTOILE DE DAVID","	x (étoile à six branches avec point médian - 1F52F)"},
/* 2722 */ { "CROIX LARMÉE",NULL},
/* 2723 */ { "CROIX POMMETÉE",NULL},
/* 2724 */ { "GROSSE CROIX POMMETÉE",NULL},
/* 2725 */ { "CROIX TRÉFLÉE",NULL},
/* 2726 */ { "ÉTOILE À QUATRE BRANCHES NOIRE","	x (valvule fine à quatre branches noire - 2BCC)\n"
	"	x (étoile noire à quatre branches - 1F7C6)"},
/* 2727 */ { "ÉTOILE À QUATRE BRANCHES BLANCHE","	x (valvule à quatre branches blanche - 2BCE)"},
/* 2728 */ { "SCINTILLEMENTS",NULL},
/* 2729 */ { "ÉTOILE BLANCHE À CONTOUR ACCENTUÉ","	x (étoile blanche - 2606)"},
/* 272A */ { "ÉTOILE BLANCHE CERCLÉE",NULL},
/* 272B */ { "MOLETTE NOIRE",NULL},
/* 272C */ { "MOLETTE BLANCHE",NULL},
/* 272D */ { "ÉTOILE NOIRE À CONTOUR",NULL},
/* 272E */ { "ÉTOILE NOIRE À CONTOUR ÉPAIS",NULL},
/* 272F */ { "ÉTOILE EN MOULINET",NULL},
/* 2730 */ { "ÉTOILE BLANCHE OMBRÉE",NULL},
/* 2731 */ { "GROS ASTÉRISQUE","	x (astérisque - 002A)\n"
	"	x (astérisque à six branches épais - 1F7B8)"},
/* 2732 */ { "ASTÉRISQUE PERCÉ",NULL},
/* 2733 */ { "ASTÉRISQUE À HUIT BRANCHES","	x (astérisque à huit branches fin - 1F7BB)"},
/* 2734 */ { "ÉTOILE NOIRE À HUIT BRANCHES",NULL},
/* 2735 */ { "ÉTOILE EN MOULINET À HUIT BRANCHES","	x (étoile en moulinet à huit branches épaisse - 1F7D1)"},
/* 2736 */ { "ÉTOILE NOIRE À SIX BRANCHES","	x (sextile - 26B9)"},
/* 2737 */ { "ÉTOILE RECTILIGNE À HUIT BRANCHES","	x (étoile noire à huit branches demi-grasse - 1F7CE)"},
/* 2738 */ { "GROSSE ÉTOILE RECTILIGNE À HUIT BRANCHES","	x (étoile noire à huit branches épaisse - 1F7CF)"},
/* 2739 */ { "ÉTOILE NOIRE À DOUZE BRANCHES",NULL},
/* 273A */ { "ASTÉRISQUE À SEIZE BRANCHES","	= étoile rayonnante\n"
	"	= feu d'artifice"},
/* 273B */ { "ASTÉRISQUE LARMÉ",NULL},
/* 273C */ { "ASTÉRISQUE LARMÉ PERCÉ",NULL},
/* 273D */ { "GROS ASTÉRISQUE LARMÉ",NULL},
/* 273E */ { "FLEURON NOIR ET BLANC À SIX PÉTALES",NULL},
/* 273F */ { "FLEURON NOIR",NULL},
/* 2740 */ { "FLEURON BLANC","	x (rosette - 1F3F5)\n"
	"	x (fleur blanche - 1F4AE)"},
/* 2741 */ { "FLEURON NOIR À CONTOUR À HUIT PÉTALES","	x (rosette noire - 1F3F6)"},
/* 2742 */ { "ÉTOILE CERCLÉE PERCÉE À HUIT BRANCHES",NULL},
/* 2743 */ { "GROS ASTÉRISQUE RAYONNANT LARMÉ",NULL},
/* 2744 */ { "FLOCON DE NEIGE",NULL},
/* 2745 */ { "FLOCON DE NEIGE À TROIS FOLIOLES TRANSPERCÉ","	= flocon trifolié resserré"},
/* 2746 */ { "GROS FLOCON DE NEIGE À CHEVRONS",NULL},
/* 2747 */ { "ÉTINCELLEMENT",NULL},
/* 2748 */ { "GROS ÉTINCELLEMENT",NULL},
/* 2749 */ { "ASTÉRISQUE POMMETÉ",NULL},
/* 274A */ { "ASTÉRISQUE-HÉLICE À HUIT BRANCHES LARMÉES",NULL},
/* 274B */ { "GROS ASTÉRISQUE-HÉLICE À HUIT BRANCHES LARMÉES",NULL},
/* 274C */ { "SIGNE EN FORME DE CROIX","	x (signe de multiplication - 00D7)\n"
	"	x (x d'annulation - 1F5D9)"},
/* 274D */ { "CERCLE BLANC OMBRÉ","	x (cercle blanc ombré en bas à droite - 1F53E)"},
/* 274E */ { "SIGNE EN FORME DE CROIX ENCADRÉ",NULL},
/* 274F */ { "CARRÉ BLANC À OMBRE PROJETÉE SOUS LE COIN INFÉRIEUR DROIT",NULL},
/* 2750 */ { "CARRÉ BLANC À OMBRE PROJETÉE SOUS LE COIN SUPÉRIEUR DROIT",NULL},
/* 2751 */ { "CARRÉ BLANC OMBRÉ AU COIN INFÉRIEUR DROIT",NULL},
/* 2752 */ { "CARRÉ BLANC OMBRÉ AU COIN SUPÉRIEUR DROIT",NULL},
/* 2753 */ { "POINT D'INTERROGATION NOIR DE FANTAISIE",NULL},
/* 2754 */ { "POINT D'INTERROGATION BLANC DE FANTAISIE",NULL},
/* 2755 */ { "POINT D'EXCLAMATION BLANC DE FANTAISIE",NULL},
/* 2756 */ { "LOSANGE NOIR MARQUÉ D'UN X BLANC",NULL},
/* 2757 */ { "SYMBOLE POINT D'EXCLAMATION ÉPAIS","	= obstacles sur la route (ARIB STD-B24)"},
/* 2758 */ { "BARRE VERTICALE FINE","	x (barre verticale - 007C)"},
/* 2759 */ { "BARRE VERTICALE MOYENNE",NULL},
/* 275A */ { "BARRE VERTICALE ÉPAISSE",NULL},
/* 275B */ { "GUILLEMET DE FANTAISIE EN FORME DE GROSSE VIRGULE SIMPLE CULBUTÉE","	x (guillemet-apostrophe culbuté - 2018)"},
/* 275C */ { "GUILLEMET DE FANTAISIE EN FORME DE GROSSE VIRGULE SIMPLE","	x (guillemet-apostrophe - 2019)"},
/* 275D */ { "GUILLEMET DE FANTAISIE EN FORME DE GROSSE VIRGULE DOUBLE CULBUTÉE","	x (guillemet-apostrophe double culbuté - 201C)\n"
	"	x (guillemet de fantaisie en forme de grosse virgule double culbutée sans empattement - 1F676)"},
/* 275E */ { "GUILLEMET DE FANTAISIE EN FORME DE GROSSE VIRGULE DOUBLE","	x (guillemet-apostrophe double - 201D)\n"
	"	x (guillemet de fantaisie en forme de grosse virgule double sans empattement - 1F677)"},
/* 275F */ { "GUILLEMET INFÉRIEUR DE FANTAISIE EN FORME DE GROSSE VIRGULE SIMPLE","	x (guillemet-virgule inférieur - 201A)"},
/* 2760 */ { "GUILLEMET INFÉRIEUR DE FANTAISIE EN FORME DE GROSSE VIRGULE DOUBLE","	x (guillemet-virgule double inférieur - 201E)\n"
	"	x (guillemet inférieur de fantaisie en forme de grosse virgule double sans empattement - 1F678)"},
/* 2761 */ { "PIED-DE-MOUCHE DE FANTAISIE À JAMBAGE COURBÉ","	x (pied-de-mouche - 00B6)"},
/* 2762 */ { "POINT D'EXCLAMATION DE FANTAISIE ÉPAIS","	x (point d'exclamation - 0021)"},
/* 2763 */ { "POINT D'EXCLAMATION DE FANTAISIE ÉPAIS EN FORME DE CŒUR",NULL},
/* 2764 */ { "CŒUR NOIR ÉPAIS","	x (enseigne de cœur noire - 2665)"},
/* 2765 */ { "CŒUR NOIR ÉPAIS COUCHÉ",NULL},
/* 2766 */ { "CŒUR FLORAL","	= feuille d'Alde, feuille de lierre verticale"},
/* 2767 */ { "CŒUR FLORAL COUCHÉ","	= feuille de lierre\n"
	"	* également une marque de cahier en reliure, un indice de collationnement\n"
	"	x (cœur floral couché à droite - 2619)\n"
	"	x (feuille de vigne sud-est - 1F65B)"},
/* 2768 */ { "PARENTHÈSE DE FANTAISIE GAUCHE DEMI-GRASSE","	x (parenthèse gauche - 0028)"},
/* 2769 */ { "PARENTHÈSE DE FANTAISIE DROITE DEMI-GRASSE","	x (parenthèse droite - 0029)"},
/* 276A */ { "PARENTHÈSE DE FANTAISIE APLATIE GAUCHE DEMI-GRASSE",NULL},
/* 276B */ { "PARENTHÈSE DE FANTAISIE APLATIE DROITE DEMI-GRASSE",NULL},
/* 276C */ { "CHEVRON DE FANTAISIE POINTANT À GAUCHE DEMI-GRAS","	x (chevron pointant à gauche - 2329)"},
/* 276D */ { "CHEVRON DE FANTAISIE POINTANT À DROITE DEMI-GRAS","	x (chevron pointant à droite - 232A)"},
/* 276E */ { "GUILLEMET DE FANTAISIE GAUCHE ÉPAIS","	x (guillemet simple vers la gauche - 2039)"},
/* 276F */ { "GUILLEMET DE FANTAISIE DROIT ÉPAIS","	x (guillemet simple vers la droite - 203A)"},
/* 2770 */ { "CHEVRON DE FANTAISIE POINTANT À GAUCHE ÉPAIS",NULL},
/* 2771 */ { "CHEVRON DE FANTAISIE POINTANT À DROITE ÉPAIS",NULL},
/* 2772 */ { "CROCHET DE FANTAISIE EN ÉCAILLE GAUCHE MAIGRE","	x (crochet en écaille gauche - 3014)"},
/* 2773 */ { "CROCHET DE FANTAISIE EN ÉCAILLE DROIT MAIGRE","	x (crochet en écaille droit - 3015)"},
/* 2774 */ { "ACCOLADE DE FANTAISIE GAUCHE DEMI-GRASSE","	x (accolade gauche - 007B)"},
/* 2775 */ { "ACCOLADE DE FANTAISIE DROITE DEMI-GRASSE","	x (accolade droite - 007D)"},
/* 2776 */ { "VIGNETTE CHIFFRE UN CERCLÉ NOIR AU BLANC",NULL},
/* 2777 */ { "VIGNETTE CHIFFRE DEUX CERCLÉ NOIR AU BLANC",NULL},
/* 2778 */ { "VIGNETTE CHIFFRE TROIS CERCLÉ NOIR AU BLANC",NULL},
/* 2779 */ { "VIGNETTE CHIFFRE QUATRE CERCLÉ NOIR AU BLANC",NULL},
/* 277A */ { "VIGNETTE CHIFFRE CINQ CERCLÉ NOIR AU BLANC",NULL},
/* 277B */ { "VIGNETTE CHIFFRE SIX CERCLÉ NOIR AU BLANC",NULL},
/* 277C */ { "VIGNETTE CHIFFRE SEPT CERCLÉ NOIR AU BLANC",NULL},
/* 277D */ { "VIGNETTE CHIFFRE HUIT CERCLÉ NOIR AU BLANC",NULL},
/* 277E */ { "VIGNETTE CHIFFRE NEUF CERCLÉ NOIR AU BLANC",NULL},
/* 277F */ { "VIGNETTE NOMBRE DIX CERCLÉ NOIR AU BLANC",NULL},
/* 2780 */ { "VIGNETTE CHIFFRE UN SANS EMPATTEMENT CERCLÉ",NULL},
/* 2781 */ { "VIGNETTE CHIFFRE DEUX SANS EMPATTEMENT CERCLÉ",NULL},
/* 2782 */ { "VIGNETTE CHIFFRE TROIS SANS EMPATTEMENT CERCLÉ",NULL},
/* 2783 */ { "VIGNETTE CHIFFRE QUATRE SANS EMPATTEMENT CERCLÉ",NULL},
/* 2784 */ { "VIGNETTE CHIFFRE CINQ SANS EMPATTEMENT CERCLÉ",NULL},
/* 2785 */ { "VIGNETTE CHIFFRE SIX SANS EMPATTEMENT CERCLÉ",NULL},
/* 2786 */ { "VIGNETTE CHIFFRE SEPT SANS EMPATTEMENT CERCLÉ",NULL},
/* 2787 */ { "VIGNETTE CHIFFRE HUIT SANS EMPATTEMENT CERCLÉ",NULL},
/* 2788 */ { "VIGNETTE CHIFFRE NEUF SANS EMPATTEMENT CERCLÉ",NULL},
/* 2789 */ { "VIGNETTE NOMBRE DIX SANS EMPATTEMENT CERCLÉ",NULL},
/* 278A */ { "VIGNETTE CHIFFRE UN SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 278B */ { "VIGNETTE CHIFFRE DEUX SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 278C */ { "VIGNETTE CHIFFRE TROIS SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 278D */ { "VIGNETTE CHIFFRE QUATRE SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 278E */ { "VIGNETTE CHIFFRE CINQ SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 278F */ { "VIGNETTE CHIFFRE SIX SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 2790 */ { "VIGNETTE CHIFFRE SEPT SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 2791 */ { "VIGNETTE CHIFFRE HUIT SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 2792 */ { "VIGNETTE CHIFFRE NEUF SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 2793 */ { "VIGNETTE NOMBRE DIX SANS EMPATTEMENT CERCLÉ NOIR AU BLANC",NULL},
/* 2794 */ { "FLÈCHE VERS LA DROITE ÉPAISSE À POINTE LARGE","	x (flèche demi-grasse à pointe large vers la droite - 1F872)"},
/* 2795 */ { "SIGNE PLUS ÉPAIS","	x (signe plus - 002B)"},
/* 2796 */ { "SIGNE MOINS ÉPAIS","	x (signe moins - 2212)"},
/* 2797 */ { "SIGNE DE DIVISION ÉPAIS","	x (signe de division - 00F7)"},
/* 2798 */ { "FLÈCHE SUD-EST ÉPAISSE",NULL},
/* 2799 */ { "FLÈCHE VERS LA DROITE ÉPAISSE",NULL},
/* 279A */ { "FLÈCHE NORD-EST ÉPAISSE",NULL},
/* 279B */ { "FLÈCHE DE TRAÇAGE VERS LA DROITE",NULL},
/* 279C */ { "FLÈCHE VERS LA DROITE ÉPAISSE À POINTE ARRONDIE",NULL},
/* 279D */ { "FLÈCHE VERS LA DROITE À POINTE EN TRIANGLE",NULL},
/* 279E */ { "FLÈCHE VERS LA DROITE ÉPAISSE À POINTE EN TRIANGLE",NULL},
/* 279F */ { "FLÈCHE VERS LA DROITE À POINTE EN TRIANGLE ET À TRAITS DISCONTINUS",NULL},
/* 27A0 */ { "FLÈCHE VERS LA DROITE ÉPAISSE À POINTE EN TRIANGLE ET À TRAITS DISCONTINUS",NULL},
/* 27A1 */ { "FLÈCHE VERS LA DROITE NOIRE","	x (flèche noire vers la gauche - 2B05)\n"
	"	x (flèche noire vers la droite - 2B95)"},
/* 27A2 */ { "POINTE DE FLÈCHE VERS LA DROITE EN TROMPE-L'ŒIL ÉCLAIRÉE PAR LE HAUT","	x (pointe de flèche équilatérale vers la droite en trompe-l'œil éclairée par le haut - 2B9A)"},
/* 27A3 */ { "POINTE DE FLÈCHE VERS LA DROITE EN TROMPE-L'ŒIL ÉCLAIRÉE PAR LE BAS",NULL},
/* 27A4 */ { "POINTE DE FLÈCHE NOIRE VERS LA DROITE","	x (pointe de flèche équilatérale noire vers la droite - 2B9E)"},
/* 27A5 */ { "FLÈCHE NOIRE ÉPAISSE COURBÉE VERS LE BAS ET VERS LA DROITE","	x (flèche noire courbée vers le bas et vers la droite - 2BA9)"},
/* 27A6 */ { "FLÈCHE NOIRE ÉPAISSE COURBÉE VERS LE HAUT ET VERS LA DROITE","	x (flèche noire courbée vers le haut et vers la droite - 2BAB)"},
/* 27A7 */ { "FLÈCHE NOIRE TRAPUE VERS LA DROITE","	x (flèche comprimée épaisse vers la droite - 1F842)"},
/* 27A8 */ { "FLÈCHE NOIRE ÉPAISSE VERS LA DROITE À POINTE CONCAVE",NULL},
/* 27A9 */ { "FLÈCHE BLANCHE VERS LA DROITE OMBRÉE À L'AVANT","	x (flèche blanche ombrée à droite vers la droite - 1F8A5)"},
/* 27AA */ { "FLÈCHE BLANCHE VERS LA DROITE OMBRÉE À L'ARRIÈRE","	x (flèche blanche ombrée à gauche vers la droite - 1F8A7)"},
/* 27AB */ { "FLÈCHE BLANCHE VERS LA DROITE PENCHÉE VERS L'ARRIÈRE ET OMBRÉE","	x (flèche blanche ombrée vers la droite penchée vers l'arrière - 1F8A9)"},
/* 27AC */ { "FLÈCHE BLANCHE VERS LA DROITE PENCHÉE VERS L'AVANT ET OMBRÉE","	x (flèche blanche ombrée vers la droite penchée vers l'avant - 1F8AB)"},
/* 27AD */ { "FLÈCHE BLANCHE ÉPAISSE VERS LA DROITE OMBRÉE À L'AVANT ET PAR-DESSOUS",NULL},
/* 27AE */ { "FLÈCHE BLANCHE ÉPAISSE VERS LA DROITE OMBRÉE À L'AVANT ET PAR-DESSUS",NULL},
/* 27AF */ { "FLÈCHE ENCOCHÉE BLANCHE VERS LA DROITE OMBRÉE À L'AVANT ET PAR-DESSOUS","	x (flèche vers la droite à talon encoché - 1F89A)"},
/* 27B0 */ { "BOUCLE RECOURBÉE","	= kururi"},
/* 27B1 */ { "FLÈCHE ENCOCHÉE BLANCHE VERS LA DROITE OMBRÉE À L'AVANT ET PAR-DESSUS",NULL},
/* 27B2 */ { "FLÈCHE BLANCHE ÉPAISSE VERS LA DROITE À CONTOUR CIRCULAIRE",NULL},
/* 27B3 */ { "FLÈCHE VERS LA DROITE À EMPENNAGE BLANC",NULL},
/* 27B4 */ { "FLÈCHE SUD-EST À EMPENNAGE NOIR",NULL},
/* 27B5 */ { "FLÈCHE VERS LA DROITE À EMPENNAGE NOIR",NULL},
/* 27B6 */ { "FLÈCHE NORD-EST À EMPENNAGE NOIR",NULL},
/* 27B7 */ { "FLÈCHE ÉPAISSE SUD-EST À EMPENNAGE NOIR",NULL},
/* 27B8 */ { "FLÈCHE ÉPAISSE VERS LA DROITE À EMPENNAGE NOIR",NULL},
/* 27B9 */ { "FLÈCHE ÉPAISSE NORD-EST À EMPENNAGE NOIR",NULL},
/* 27BA */ { "FLÈCHE VERS LA DROITE À POINTE LARMÉE",NULL},
/* 27BB */ { "FLÈCHE ÉPAISSE VERS LA DROITE À TIGE LARMÉE",NULL},
/* 27BC */ { "FLÈCHE VERS LA DROITE À TALON EN FORME DE COIN",NULL},
/* 27BD */ { "FLÈCHE ÉPAISSE VERS LA DROITE À TALON EN FORME DE COIN",NULL},
/* 27BE */ { "FLÈCHE VERS LA DROITE À CONTOUR OUVERT",NULL},
/* 27BF */ { "DOUBLE BOUCLE RECOURBÉE",NULL},
/* 27C0 */ { "ANGLE TRIDIMENSIONNEL","	* utilisé par Euclide"},
/* 27C1 */ { "TRIANGLE BLANC CONTENANT UN PETIT TRIANGLE BLANC","	* utilisé par Euclide"},
/* 27C2 */ { "PERPENDICULAIRE À","	= orthogonal à\n"
	"	* relation, composé avec plus de blanc\n"
	"	x (taquet vers le haut - 22A5)"},
/* 27C3 */ { "SOUS-ENSEMBLE OUVERT",NULL},
/* 27C4 */ { "SUR-ENSEMBLE OUVERT",NULL},
/* 27C5 */ { "DÉLIMITEUR DE SAC EN S GAUCHE",NULL},
/* 27C6 */ { "DÉLIMITEUR DE SAC EN S DROITE",NULL},
/* 27C7 */ { "OU AVEC POINT INSCRIT",NULL},
/* 27C8 */ { "SOUS-ENSEMBLE PRÉCÉDÉ D'UNE BARRE OBLIQUE INVERSÉE","	= sous-ensemble précédé d'une contre-oblique"},
/* 27C9 */ { "SUR-ENSEMBLE SUIVI D'UNE BARRE OBLIQUE","	= sur-ensemble suivi d'une oblique"},
/* 27CA */ { "BARRE VERTICALE À UNE TRAVERSE","	x (parallèle à vertical à une traverse - 2AF2)\n"
	"	x (triple barre verticale à une traverse - 2AF5)"},
/* 27CB */ { "DIAGONALE MATHÉMATIQUE ASCENDANTE","	= \\diagup\n"
	"	x (barre oblique de division - 2215)"},
/* 27CC */ { "POTENCE DE DIVISION","	x (signe de division - 00F7)\n"
	"	x (barre oblique de division - 2215)\n"
	"	x (racine carrée - 221A)"},
/* 27CD */ { "DIAGONALE MATHÉMATIQUE DESCENDANTE","	= \\diagdown\n"
	"	x (différence d'ensembles - 2216)\n"
	"	x (opérateur barre oblique inversée - 29F5)"},
/* 27CE */ { "ET LOGIQUE ENCADRÉ","	= box min"},
/* 27CF */ { "OU LOGIQUE ENCADRÉ","	= box max"},
/* 27D0 */ { "LOSANGE BLANC À POINT CENTRÉ","	x (forme de losange avec un point à l'intérieur - 1F4A0)"},
/* 27D1 */ { "ET POINTÉ","	x (et logique - 2227)\n"
	"	x (intersection pointée - 2A40)"},
/* 27D2 */ { "APPARTIENT À OUVERT VERS LE HAUT","	x (appartient à ouvert vers le bas - 2AD9)"},
/* 27D3 */ { "COIN INFÉRIEUR DROIT POINTÉ","	= retrait\n"
	"	x (plancher à droite - 230B)"},
/* 27D4 */ { "COIN SUPÉRIEUR GAUCHE POINTÉ","	= refoulement\n"
	"	x (plafond à gauche - 2308)"},
/* 27D5 */ { "JOINTURE EXTERNE GAUCHE",NULL},
/* 27D6 */ { "JOINTURE EXTERNE DROITE",NULL},
/* 27D7 */ { "JOINTURE EXTERNE COMPLÈTE","	x (jointure - 2A1D)"},
/* 27D8 */ { "GRAND TAQUET VERS LE HAUT","	x (taquet vers le haut - 22A5)"},
/* 27D9 */ { "GRAND TAQUET VERS LE BAS","	x (taquet vers le bas - 22A4)"},
/* 27DA */ { "DOUBLE TOURNIQUET BILATÉRAL","	x (vrai - 22A8)\n"
	"	x (double tourniquet gauche à barre verticale - 2AE4)"},
/* 27DB */ { "TOURNIQUET BILATÉRAL","	= taquets vers la gauche et vers la droite, taquet gauche-droite\n"
	"	x (taquet droit - 22A2)"},
/* 27DC */ { "MULTIJECTION GAUCHE","	= multimap gauche\n"
	"	x (multijection - 22B8)"},
/* 27DD */ { "LONG TAQUET DROIT","	x (taquet droit - 22A2)"},
/* 27DE */ { "LONG TAQUET GAUCHE","	x (taquet gauche - 22A3)"},
/* 27DF */ { "TAQUET VERS LE HAUT SURMONTÉ D'UN CERCLE","	= élément radial\n"
	"	x (taquet vers le bas surmontant un cercle - 2AF1)"},
/* 27E0 */ { "RHOMBE COUPÉ","	* désigne une forme de possibilité en logique modale\n"
	"	x (rhombe - 25CA)"},
/* 27E1 */ { "LOSANGE BLANC À CÔTÉS CONCAVES","	= jamais (opérateur modal)\n"
	"	x (losange blanc - 25C7)"},
/* 27E2 */ { "LOSANGE BLANC À CÔTÉS CONCAVES AVEC TRAIT À GAUCHE","	= ne fut jamais (opérateur modal)"},
/* 27E3 */ { "LOSANGE BLANC À CÔTÉS CONCAVES AVEC TRAIT À DROITE","	= ne sera jamais (opérateur modal)"},
/* 27E4 */ { "CARRÉ BLANC AVEC TRAIT À GAUCHE","	= fut toujours (opérateur modal)\n"
	"	x (carré blanc - 25A1)\n"
	"	x (carré moyen blanc - 25FB)"},
/* 27E5 */ { "CARRÉ BLANC AVEC TRAIT À DROITE","	= sera à jamais (opérateur modal)"},
/* 27E6 */ { "CROCHET MATHÉMATIQUE BLANC GAUCHE","	= crochet de sac gauche en notation z\n"
	"	x (crochet blanc gauche - 301A)"},
/* 27E7 */ { "CROCHET MATHÉMATIQUE BLANC DROIT","	= crochet de sac droit en notation z\n"
	"	x (crochet blanc droit - 301B)"},
/* 27E8 */ { "CHEVRON MATHÉMATIQUE GAUCHE","	= crochet de séquence gauche en notation z\n"
	"	x (chevron pointant à gauche - 2329)\n"
	"	x (chevron gauche - 3008)"},
/* 27E9 */ { "CHEVRON MATHÉMATIQUE DROIT","	= crochet de séquence droit en notation z\n"
	"	x (chevron pointant à droite - 232A)\n"
	"	x (chevron droit - 3009)"},
/* 27EA */ { "DOUBLE CHEVRON MATHÉMATIQUE GAUCHE","	= chevron gauche en notation z\n"
	"	x (double chevron gauche - 300A)"},
/* 27EB */ { "DOUBLE CHEVRON MATHÉMATIQUE DROIT","	= chevron droit en notation z\n"
	"	x (double chevron droit - 300B)"},
/* 27EC */ { "CROCHET EN ÉCAILLE MATHÉMATIQUE BLANC GAUCHE","	x (crochet en écaille noir gauche - 2997)\n"
	"	x (crochet en écaille blanc gauche - 3018)"},
/* 27ED */ { "CROCHET EN ÉCAILLE MATHÉMATIQUE BLANC DROIT","	x (crochet en écaille noir droit - 2998)\n"
	"	x (crochet en écaille blanc droit - 3019)"},
/* 27EE */ { "PARENTHÈSE MATHÉMATIQUE APLATIE GAUCHE","	= lgroup"},
/* 27EF */ { "PARENTHÈSE MATHÉMATIQUE APLATIE DROITE","	= rgroup"},
/* 27F0 */ { "QUADRUPLE FLÈCHE VERS LE HAUT","	x (triple flèche vers le haut - 290A)\n"
	"	x (quadruple flèche vers la gauche - 2B45)"},
/* 27F1 */ { "QUADRUPLE FLÈCHE VERS LE BAS","	x (triple flèche vers le bas - 290B)"},
/* 27F2 */ { "FLÈCHE CIRCULAIRE ENTROUVERTE SENS ANTIHORAIRE","	x (flèche circulaire ouverte sens antihoraire - 21BA)\n"
	"	x (cercle fléché sens antihoraire - 2940)"},
/* 27F3 */ { "FLÈCHE CIRCULAIRE ENTROUVERTE SENS HORAIRE","	x (flèche circulaire ouverte sens horaire - 21BB)\n"
	"	x (cercle fléché sens horaire - 2941)"},
/* 27F4 */ { "FLÈCHE VERS LA DROITE À SIGNE PLUS CERCLÉ","	x (flèche vers la gauche à signe plus cerclé - 2B32)"},
/* 27F5 */ { "LONGUE FLÈCHE VERS LA GAUCHE","	x (flèche vers la gauche - 2190)"},
/* 27F6 */ { "LONGUE FLÈCHE VERS LA DROITE","	x (flèche vers la droite - 2192)"},
/* 27F7 */ { "LONGUE FLÈCHE GAUCHE-DROITE","	x (flèche gauche-droite - 2194)"},
/* 27F8 */ { "LONGUE DOUBLE FLÈCHE VERS LA GAUCHE","	x (double flèche vers la gauche - 21D0)"},
/* 27F9 */ { "LONGUE DOUBLE FLÈCHE VERS LA DROITE","	x (double flèche vers la droite - 21D2)"},
/* 27FA */ { "LONGUE DOUBLE FLÈCHE GAUCHE-DROITE","	x (double flèche gauche-droite - 21D4)"},
/* 27FB */ { "LONGUE FLÈCHE D'UN TAQUET VERS LA GAUCHE","	= est l'image de\n"
	"	= longue flèche à socle vers la gauche\n"
	"	= longue flèche à béquillon vers la gauche\n"
	"	x (flèche d'un taquet vers la gauche - 21A4)"},
/* 27FC */ { "LONGUE FLÈCHE D'UN TAQUET VERS LA DROITE","	= a pour image\n"
	"	x (flèche d'un taquet vers la droite - 21A6)"},
/* 27FD */ { "LONGUE DOUBLE FLÈCHE D'UN TAQUET VERS LA GAUCHE","	x (double flèche d'un taquet vers la gauche - 2906)"},
/* 27FE */ { "LONGUE DOUBLE FLÈCHE D'UN TAQUET VERS LA DROITE","	x (double flèche d'un taquet vers la droite - 2907)"},
/* 27FF */ { "LONGUE FLÈCHE VERS LA DROITE EN TIRE-BOUCHON","	= longue flèche droite dentée\n"
	"	x (flèche vers la droite en tire-bouchon - 21DD)\n"
	"	x (longue flèche vers la gauche en tire-bouchon - 2B33)"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_28[] = {
/* 2800 */ { "COMBINAISON BRAILLE BLANC","	* bien que ce caractère soit représenté par un blanc à chasse fixe dans de nombreuses polices, il ne joue pas le rôle d'une espace"},
/* 2801 */ { "COMBINAISON BRAILLE POINTS-1",NULL},
/* 2802 */ { "COMBINAISON BRAILLE POINTS-2",NULL},
/* 2803 */ { "COMBINAISON BRAILLE POINTS-12",NULL},
/* 2804 */ { "COMBINAISON BRAILLE POINTS-3",NULL},
/* 2805 */ { "COMBINAISON BRAILLE POINTS-13",NULL},
/* 2806 */ { "COMBINAISON BRAILLE POINTS-23",NULL},
/* 2807 */ { "COMBINAISON BRAILLE POINTS-123",NULL},
/* 2808 */ { "COMBINAISON BRAILLE POINTS-4",NULL},
/* 2809 */ { "COMBINAISON BRAILLE POINTS-14",NULL},
/* 280A */ { "COMBINAISON BRAILLE POINTS-24",NULL},
/* 280B */ { "COMBINAISON BRAILLE POINTS-124",NULL},
/* 280C */ { "COMBINAISON BRAILLE POINTS-34",NULL},
/* 280D */ { "COMBINAISON BRAILLE POINTS-134",NULL},
/* 280E */ { "COMBINAISON BRAILLE POINTS-234",NULL},
/* 280F */ { "COMBINAISON BRAILLE POINTS-1234",NULL},
/* 2810 */ { "COMBINAISON BRAILLE POINTS-5",NULL},
/* 2811 */ { "COMBINAISON BRAILLE POINTS-15",NULL},
/* 2812 */ { "COMBINAISON BRAILLE POINTS-25",NULL},
/* 2813 */ { "COMBINAISON BRAILLE POINTS-125",NULL},
/* 2814 */ { "COMBINAISON BRAILLE POINTS-35",NULL},
/* 2815 */ { "COMBINAISON BRAILLE POINTS-135",NULL},
/* 2816 */ { "COMBINAISON BRAILLE POINTS-235",NULL},
/* 2817 */ { "COMBINAISON BRAILLE POINTS-1235",NULL},
/* 2818 */ { "COMBINAISON BRAILLE POINTS-45",NULL},
/* 2819 */ { "COMBINAISON BRAILLE POINTS-145",NULL},
/* 281A */ { "COMBINAISON BRAILLE POINTS-245",NULL},
/* 281B */ { "COMBINAISON BRAILLE POINTS-1245",NULL},
/* 281C */ { "COMBINAISON BRAILLE POINTS-345",NULL},
/* 281D */ { "COMBINAISON BRAILLE POINTS-1345",NULL},
/* 281E */ { "COMBINAISON BRAILLE POINTS-2345",NULL},
/* 281F */ { "COMBINAISON BRAILLE POINTS-12345",NULL},
/* 2820 */ { "COMBINAISON BRAILLE POINTS-6",NULL},
/* 2821 */ { "COMBINAISON BRAILLE POINTS-16",NULL},
/* 2822 */ { "COMBINAISON BRAILLE POINTS-26",NULL},
/* 2823 */ { "COMBINAISON BRAILLE POINTS-126",NULL},
/* 2824 */ { "COMBINAISON BRAILLE POINTS-36",NULL},
/* 2825 */ { "COMBINAISON BRAILLE POINTS-136",NULL},
/* 2826 */ { "COMBINAISON BRAILLE POINTS-236",NULL},
/* 2827 */ { "COMBINAISON BRAILLE POINTS-1236",NULL},
/* 2828 */ { "COMBINAISON BRAILLE POINTS-46",NULL},
/* 2829 */ { "COMBINAISON BRAILLE POINTS-146",NULL},
/* 282A */ { "COMBINAISON BRAILLE POINTS-246",NULL},
/* 282B */ { "COMBINAISON BRAILLE POINTS-1246",NULL},
/* 282C */ { "COMBINAISON BRAILLE POINTS-346",NULL},
/* 282D */ { "COMBINAISON BRAILLE POINTS-1346",NULL},
/* 282E */ { "COMBINAISON BRAILLE POINTS-2346",NULL},
/* 282F */ { "COMBINAISON BRAILLE POINTS-12346",NULL},
/* 2830 */ { "COMBINAISON BRAILLE POINTS-56",NULL},
/* 2831 */ { "COMBINAISON BRAILLE POINTS-156",NULL},
/* 2832 */ { "COMBINAISON BRAILLE POINTS-256",NULL},
/* 2833 */ { "COMBINAISON BRAILLE POINTS-1256",NULL},
/* 2834 */ { "COMBINAISON BRAILLE POINTS-356",NULL},
/* 2835 */ { "COMBINAISON BRAILLE POINTS-1356",NULL},
/* 2836 */ { "COMBINAISON BRAILLE POINTS-2356",NULL},
/* 2837 */ { "COMBINAISON BRAILLE POINTS-12356",NULL},
/* 2838 */ { "COMBINAISON BRAILLE POINTS-456",NULL},
/* 2839 */ { "COMBINAISON BRAILLE POINTS-1456",NULL},
/* 283A */ { "COMBINAISON BRAILLE POINTS-2456",NULL},
/* 283B */ { "COMBINAISON BRAILLE POINTS-12456",NULL},
/* 283C */ { "COMBINAISON BRAILLE POINTS-3456",NULL},
/* 283D */ { "COMBINAISON BRAILLE POINTS-13456",NULL},
/* 283E */ { "COMBINAISON BRAILLE POINTS-23456",NULL},
/* 283F */ { "COMBINAISON BRAILLE POINTS-123456",NULL},
/* 2840 */ { "COMBINAISON BRAILLE POINTS-7",NULL},
/* 2841 */ { "COMBINAISON BRAILLE POINTS-17",NULL},
/* 2842 */ { "COMBINAISON BRAILLE POINTS-27",NULL},
/* 2843 */ { "COMBINAISON BRAILLE POINTS-127",NULL},
/* 2844 */ { "COMBINAISON BRAILLE POINTS-37",NULL},
/* 2845 */ { "COMBINAISON BRAILLE POINTS-137",NULL},
/* 2846 */ { "COMBINAISON BRAILLE POINTS-237",NULL},
/* 2847 */ { "COMBINAISON BRAILLE POINTS-1237",NULL},
/* 2848 */ { "COMBINAISON BRAILLE POINTS-47",NULL},
/* 2849 */ { "COMBINAISON BRAILLE POINTS-147",NULL},
/* 284A */ { "COMBINAISON BRAILLE POINTS-247",NULL},
/* 284B */ { "COMBINAISON BRAILLE POINTS-1247",NULL},
/* 284C */ { "COMBINAISON BRAILLE POINTS-347",NULL},
/* 284D */ { "COMBINAISON BRAILLE POINTS-1347",NULL},
/* 284E */ { "COMBINAISON BRAILLE POINTS-2347",NULL},
/* 284F */ { "COMBINAISON BRAILLE POINTS-12347",NULL},
/* 2850 */ { "COMBINAISON BRAILLE POINTS-57",NULL},
/* 2851 */ { "COMBINAISON BRAILLE POINTS-157",NULL},
/* 2852 */ { "COMBINAISON BRAILLE POINTS-257",NULL},
/* 2853 */ { "COMBINAISON BRAILLE POINTS-1257",NULL},
/* 2854 */ { "COMBINAISON BRAILLE POINTS-357",NULL},
/* 2855 */ { "COMBINAISON BRAILLE POINTS-1357",NULL},
/* 2856 */ { "COMBINAISON BRAILLE POINTS-2357",NULL},
/* 2857 */ { "COMBINAISON BRAILLE POINTS-12357",NULL},
/* 2858 */ { "COMBINAISON BRAILLE POINTS-457",NULL},
/* 2859 */ { "COMBINAISON BRAILLE POINTS-1457",NULL},
/* 285A */ { "COMBINAISON BRAILLE POINTS-2457",NULL},
/* 285B */ { "COMBINAISON BRAILLE POINTS-12457",NULL},
/* 285C */ { "COMBINAISON BRAILLE POINTS-3457",NULL},
/* 285D */ { "COMBINAISON BRAILLE POINTS-13457",NULL},
/* 285E */ { "COMBINAISON BRAILLE POINTS-23457",NULL},
/* 285F */ { "COMBINAISON BRAILLE POINTS-123457",NULL},
/* 2860 */ { "COMBINAISON BRAILLE POINTS-67",NULL},
/* 2861 */ { "COMBINAISON BRAILLE POINTS-167",NULL},
/* 2862 */ { "COMBINAISON BRAILLE POINTS-267",NULL},
/* 2863 */ { "COMBINAISON BRAILLE POINTS-1267",NULL},
/* 2864 */ { "COMBINAISON BRAILLE POINTS-367",NULL},
/* 2865 */ { "COMBINAISON BRAILLE POINTS-1367",NULL},
/* 2866 */ { "COMBINAISON BRAILLE POINTS-2367",NULL},
/* 2867 */ { "COMBINAISON BRAILLE POINTS-12367",NULL},
/* 2868 */ { "COMBINAISON BRAILLE POINTS-467",NULL},
/* 2869 */ { "COMBINAISON BRAILLE POINTS-1467",NULL},
/* 286A */ { "COMBINAISON BRAILLE POINTS-2467",NULL},
/* 286B */ { "COMBINAISON BRAILLE POINTS-12467",NULL},
/* 286C */ { "COMBINAISON BRAILLE POINTS-3467",NULL},
/* 286D */ { "COMBINAISON BRAILLE POINTS-13467",NULL},
/* 286E */ { "COMBINAISON BRAILLE POINTS-23467",NULL},
/* 286F */ { "COMBINAISON BRAILLE POINTS-123467",NULL},
/* 2870 */ { "COMBINAISON BRAILLE POINTS-567",NULL},
/* 2871 */ { "COMBINAISON BRAILLE POINTS-1567",NULL},
/* 2872 */ { "COMBINAISON BRAILLE POINTS-2567",NULL},
/* 2873 */ { "COMBINAISON BRAILLE POINTS-12567",NULL},
/* 2874 */ { "COMBINAISON BRAILLE POINTS-3567",NULL},
/* 2875 */ { "COMBINAISON BRAILLE POINTS-13567",NULL},
/* 2876 */ { "COMBINAISON BRAILLE POINTS-23567",NULL},
/* 2877 */ { "COMBINAISON BRAILLE POINTS-123567",NULL},
/* 2878 */ { "COMBINAISON BRAILLE POINTS-4567",NULL},
/* 2879 */ { "COMBINAISON BRAILLE POINTS-14567",NULL},
/* 287A */ { "COMBINAISON BRAILLE POINTS-24567",NULL},
/* 287B */ { "COMBINAISON BRAILLE POINTS-124567",NULL},
/* 287C */ { "COMBINAISON BRAILLE POINTS-34567",NULL},
/* 287D */ { "COMBINAISON BRAILLE POINTS-134567",NULL},
/* 287E */ { "COMBINAISON BRAILLE POINTS-234567",NULL},
/* 287F */ { "COMBINAISON BRAILLE POINTS-1234567",NULL},
/* 2880 */ { "COMBINAISON BRAILLE POINTS-8",NULL},
/* 2881 */ { "COMBINAISON BRAILLE POINTS-18",NULL},
/* 2882 */ { "COMBINAISON BRAILLE POINTS-28",NULL},
/* 2883 */ { "COMBINAISON BRAILLE POINTS-128",NULL},
/* 2884 */ { "COMBINAISON BRAILLE POINTS-38",NULL},
/* 2885 */ { "COMBINAISON BRAILLE POINTS-138",NULL},
/* 2886 */ { "COMBINAISON BRAILLE POINTS-238",NULL},
/* 2887 */ { "COMBINAISON BRAILLE POINTS-1238",NULL},
/* 2888 */ { "COMBINAISON BRAILLE POINTS-48",NULL},
/* 2889 */ { "COMBINAISON BRAILLE POINTS-148",NULL},
/* 288A */ { "COMBINAISON BRAILLE POINTS-248",NULL},
/* 288B */ { "COMBINAISON BRAILLE POINTS-1248",NULL},
/* 288C */ { "COMBINAISON BRAILLE POINTS-348",NULL},
/* 288D */ { "COMBINAISON BRAILLE POINTS-1348",NULL},
/* 288E */ { "COMBINAISON BRAILLE POINTS-2348",NULL},
/* 288F */ { "COMBINAISON BRAILLE POINTS-12348",NULL},
/* 2890 */ { "COMBINAISON BRAILLE POINTS-58",NULL},
/* 2891 */ { "COMBINAISON BRAILLE POINTS-158",NULL},
/* 2892 */ { "COMBINAISON BRAILLE POINTS-258",NULL},
/* 2893 */ { "COMBINAISON BRAILLE POINTS-1258",NULL},
/* 2894 */ { "COMBINAISON BRAILLE POINTS-358",NULL},
/* 2895 */ { "COMBINAISON BRAILLE POINTS-1358",NULL},
/* 2896 */ { "COMBINAISON BRAILLE POINTS-2358",NULL},
/* 2897 */ { "COMBINAISON BRAILLE POINTS-12358",NULL},
/* 2898 */ { "COMBINAISON BRAILLE POINTS-458",NULL},
/* 2899 */ { "COMBINAISON BRAILLE POINTS-1458",NULL},
/* 289A */ { "COMBINAISON BRAILLE POINTS-2458",NULL},
/* 289B */ { "COMBINAISON BRAILLE POINTS-12458",NULL},
/* 289C */ { "COMBINAISON BRAILLE POINTS-3458",NULL},
/* 289D */ { "COMBINAISON BRAILLE POINTS-13458",NULL},
/* 289E */ { "COMBINAISON BRAILLE POINTS-23458",NULL},
/* 289F */ { "COMBINAISON BRAILLE POINTS-123458",NULL},
/* 28A0 */ { "COMBINAISON BRAILLE POINTS-68",NULL},
/* 28A1 */ { "COMBINAISON BRAILLE POINTS-168",NULL},
/* 28A2 */ { "COMBINAISON BRAILLE POINTS-268",NULL},
/* 28A3 */ { "COMBINAISON BRAILLE POINTS-1268",NULL},
/* 28A4 */ { "COMBINAISON BRAILLE POINTS-368",NULL},
/* 28A5 */ { "COMBINAISON BRAILLE POINTS-1368",NULL},
/* 28A6 */ { "COMBINAISON BRAILLE POINTS-2368",NULL},
/* 28A7 */ { "COMBINAISON BRAILLE POINTS-12368",NULL},
/* 28A8 */ { "COMBINAISON BRAILLE POINTS-468",NULL},
/* 28A9 */ { "COMBINAISON BRAILLE POINTS-1468",NULL},
/* 28AA */ { "COMBINAISON BRAILLE POINTS-2468",NULL},
/* 28AB */ { "COMBINAISON BRAILLE POINTS-12468",NULL},
/* 28AC */ { "COMBINAISON BRAILLE POINTS-3468",NULL},
/* 28AD */ { "COMBINAISON BRAILLE POINTS-13468",NULL},
/* 28AE */ { "COMBINAISON BRAILLE POINTS-23468",NULL},
/* 28AF */ { "COMBINAISON BRAILLE POINTS-123468",NULL},
/* 28B0 */ { "COMBINAISON BRAILLE POINTS-568",NULL},
/* 28B1 */ { "COMBINAISON BRAILLE POINTS-1568",NULL},
/* 28B2 */ { "COMBINAISON BRAILLE POINTS-2568",NULL},
/* 28B3 */ { "COMBINAISON BRAILLE POINTS-12568",NULL},
/* 28B4 */ { "COMBINAISON BRAILLE POINTS-3568",NULL},
/* 28B5 */ { "COMBINAISON BRAILLE POINTS-13568",NULL},
/* 28B6 */ { "COMBINAISON BRAILLE POINTS-23568",NULL},
/* 28B7 */ { "COMBINAISON BRAILLE POINTS-123568",NULL},
/* 28B8 */ { "COMBINAISON BRAILLE POINTS-4568",NULL},
/* 28B9 */ { "COMBINAISON BRAILLE POINTS-14568",NULL},
/* 28BA */ { "COMBINAISON BRAILLE POINTS-24568",NULL},
/* 28BB */ { "COMBINAISON BRAILLE POINTS-124568",NULL},
/* 28BC */ { "COMBINAISON BRAILLE POINTS-34568",NULL},
/* 28BD */ { "COMBINAISON BRAILLE POINTS-134568",NULL},
/* 28BE */ { "COMBINAISON BRAILLE POINTS-234568",NULL},
/* 28BF */ { "COMBINAISON BRAILLE POINTS-1234568",NULL},
/* 28C0 */ { "COMBINAISON BRAILLE POINTS-78",NULL},
/* 28C1 */ { "COMBINAISON BRAILLE POINTS-178",NULL},
/* 28C2 */ { "COMBINAISON BRAILLE POINTS-278",NULL},
/* 28C3 */ { "COMBINAISON BRAILLE POINTS-1278",NULL},
/* 28C4 */ { "COMBINAISON BRAILLE POINTS-378",NULL},
/* 28C5 */ { "COMBINAISON BRAILLE POINTS-1378",NULL},
/* 28C6 */ { "COMBINAISON BRAILLE POINTS-2378",NULL},
/* 28C7 */ { "COMBINAISON BRAILLE POINTS-12378",NULL},
/* 28C8 */ { "COMBINAISON BRAILLE POINTS-478",NULL},
/* 28C9 */ { "COMBINAISON BRAILLE POINTS-1478",NULL},
/* 28CA */ { "COMBINAISON BRAILLE POINTS-2478",NULL},
/* 28CB */ { "COMBINAISON BRAILLE POINTS-12478",NULL},
/* 28CC */ { "COMBINAISON BRAILLE POINTS-3478",NULL},
/* 28CD */ { "COMBINAISON BRAILLE POINTS-13478",NULL},
/* 28CE */ { "COMBINAISON BRAILLE POINTS-23478",NULL},
/* 28CF */ { "COMBINAISON BRAILLE POINTS-123478",NULL},
/* 28D0 */ { "COMBINAISON BRAILLE POINTS-578",NULL},
/* 28D1 */ { "COMBINAISON BRAILLE POINTS-1578",NULL},
/* 28D2 */ { "COMBINAISON BRAILLE POINTS-2578",NULL},
/* 28D3 */ { "COMBINAISON BRAILLE POINTS-12578",NULL},
/* 28D4 */ { "COMBINAISON BRAILLE POINTS-3578",NULL},
/* 28D5 */ { "COMBINAISON BRAILLE POINTS-13578",NULL},
/* 28D6 */ { "COMBINAISON BRAILLE POINTS-23578",NULL},
/* 28D7 */ { "COMBINAISON BRAILLE POINTS-123578",NULL},
/* 28D8 */ { "COMBINAISON BRAILLE POINTS-4578",NULL},
/* 28D9 */ { "COMBINAISON BRAILLE POINTS-14578",NULL},
/* 28DA */ { "COMBINAISON BRAILLE POINTS-24578",NULL},
/* 28DB */ { "COMBINAISON BRAILLE POINTS-124578",NULL},
/* 28DC */ { "COMBINAISON BRAILLE POINTS-34578",NULL},
/* 28DD */ { "COMBINAISON BRAILLE POINTS-134578",NULL},
/* 28DE */ { "COMBINAISON BRAILLE POINTS-234578",NULL},
/* 28DF */ { "COMBINAISON BRAILLE POINTS-1234578",NULL},
/* 28E0 */ { "COMBINAISON BRAILLE POINTS-678",NULL},
/* 28E1 */ { "COMBINAISON BRAILLE POINTS-1678",NULL},
/* 28E2 */ { "COMBINAISON BRAILLE POINTS-2678",NULL},
/* 28E3 */ { "COMBINAISON BRAILLE POINTS-12678",NULL},
/* 28E4 */ { "COMBINAISON BRAILLE POINTS-3678",NULL},
/* 28E5 */ { "COMBINAISON BRAILLE POINTS-13678",NULL},
/* 28E6 */ { "COMBINAISON BRAILLE POINTS-23678",NULL},
/* 28E7 */ { "COMBINAISON BRAILLE POINTS-123678",NULL},
/* 28E8 */ { "COMBINAISON BRAILLE POINTS-4678",NULL},
/* 28E9 */ { "COMBINAISON BRAILLE POINTS-14678",NULL},
/* 28EA */ { "COMBINAISON BRAILLE POINTS-24678",NULL},
/* 28EB */ { "COMBINAISON BRAILLE POINTS-124678",NULL},
/* 28EC */ { "COMBINAISON BRAILLE POINTS-34678",NULL},
/* 28ED */ { "COMBINAISON BRAILLE POINTS-134678",NULL},
/* 28EE */ { "COMBINAISON BRAILLE POINTS-234678",NULL},
/* 28EF */ { "COMBINAISON BRAILLE POINTS-1234678",NULL},
/* 28F0 */ { "COMBINAISON BRAILLE POINTS-5678",NULL},
/* 28F1 */ { "COMBINAISON BRAILLE POINTS-15678",NULL},
/* 28F2 */ { "COMBINAISON BRAILLE POINTS-25678",NULL},
/* 28F3 */ { "COMBINAISON BRAILLE POINTS-125678",NULL},
/* 28F4 */ { "COMBINAISON BRAILLE POINTS-35678",NULL},
/* 28F5 */ { "COMBINAISON BRAILLE POINTS-135678",NULL},
/* 28F6 */ { "COMBINAISON BRAILLE POINTS-235678",NULL},
/* 28F7 */ { "COMBINAISON BRAILLE POINTS-1235678",NULL},
/* 28F8 */ { "COMBINAISON BRAILLE POINTS-45678",NULL},
/* 28F9 */ { "COMBINAISON BRAILLE POINTS-145678",NULL},
/* 28FA */ { "COMBINAISON BRAILLE POINTS-245678",NULL},
/* 28FB */ { "COMBINAISON BRAILLE POINTS-1245678",NULL},
/* 28FC */ { "COMBINAISON BRAILLE POINTS-345678",NULL},
/* 28FD */ { "COMBINAISON BRAILLE POINTS-1345678",NULL},
/* 28FE */ { "COMBINAISON BRAILLE POINTS-2345678",NULL},
/* 28FF */ { "COMBINAISON BRAILLE POINTS-12345678",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_29[] = {
/* 2900 */ { "FLÈCHE À DEUX POINTES VERS LA DROITE BARRÉE VERTICALEMENT","	= surjection partielle en notation z\n"
	"	x (flèche à deux pointes vers la gauche barrée verticalement - 2B34)"},
/* 2901 */ { "FLÈCHE À DEUX POINTES VERS LA DROITE BARRÉE DEUX FOIS VERTICALEMENT","	= surjection finie en notation z\n"
	"	x (flèche à deux pointes vers la gauche barrée deux fois verticalement - 2B35)"},
/* 2902 */ { "DOUBLE FLÈCHE VERS LA GAUCHE BARRÉE VERTICALEMENT",NULL},
/* 2903 */ { "DOUBLE FLÈCHE VERS LA DROITE BARRÉE VERTICALEMENT",NULL},
/* 2904 */ { "DOUBLE FLÈCHE GAUCHE-DROITE BARRÉE VERTICALEMENT",NULL},
/* 2905 */ { "FLÈCHE À DEUX POINTES D'UN TAQUET VERS LA DROITE","	= a pour image\n"
	"	x (flèche à deux pointes d'un taquet vers la gauche - 2B36)"},
/* 2906 */ { "DOUBLE FLÈCHE D'UN TAQUET VERS LA GAUCHE","	= est l'image de\n"
	"	x (longue flèche d'un taquet vers la gauche - 27FB)"},
/* 2907 */ { "DOUBLE FLÈCHE D'UN TAQUET VERS LA DROITE","	= a pour image\n"
	"	x (longue flèche d'un taquet vers la droite - 27FC)"},
/* 2908 */ { "FLÈCHE VERS LE BAS BARRÉE HORIZONTALEMENT",NULL},
/* 2909 */ { "FLÈCHE VERS LE HAUT BARRÉE HORIZONTALEMENT",NULL},
/* 290A */ { "TRIPLE FLÈCHE VERS LE HAUT","	x (double flèche vers le haut - 21D1)\n"
	"	x (quadruple flèche vers le haut - 27F0)"},
/* 290B */ { "TRIPLE FLÈCHE VERS LE BAS","	x (double flèche vers le bas - 21D3)\n"
	"	x (quadruple flèche vers le bas - 27F1)"},
/* 290C */ { "FLÈCHE À DEUX TRAITS VERS LA GAUCHE",NULL},
/* 290D */ { "FLÈCHE À DEUX TRAITS VERS LA DROITE",NULL},
/* 290E */ { "FLÈCHE À TROIS TRAITS VERS LA GAUCHE",NULL},
/* 290F */ { "FLÈCHE À TROIS TRAITS VERS LA DROITE",NULL},
/* 2910 */ { "FLÈCHE À TROIS TRAITS ET À DEUX TÊTES VERS LA DROITE","	x (flèche à trois traits et à deux têtes vers la gauche - 2B37)"},
/* 2911 */ { "FLÈCHE VERS LA DROITE À FÛT POINTILLÉ","	x (flèche vers la gauche à fût pointillé - 2B38)"},
/* 2912 */ { "FLÈCHE VERS LE HAUT JUSQU'À UN TAQUET",NULL},
/* 2913 */ { "FLÈCHE VERS LE BAS JUSQU'À UN TAQUET",NULL},
/* 2914 */ { "FLÈCHE EMPENNÉE VERS LA DROITE BARRÉE VERTICALEMENT","	= injection partielle en notation z\n"
	"	x (flèche empennée vers la gauche barrée verticalement - 2B39)"},
/* 2915 */ { "FLÈCHE EMPENNÉE VERS LA DROITE BARRÉE DEUX FOIS VERTICALEMENT","	= injection finie en notation z\n"
	"	x (flèche empennée vers la gauche barrée deux fois verticalement - 2B3A)"},
/* 2916 */ { "FLÈCHE EMPENNÉE À DEUX POINTES VERS LA DROITE","	= bijection\n"
	"	= bijection en notation z\n"
	"	x (flèche empennée à deux pointes vers la gauche - 2B3B)"},
/* 2917 */ { "FLÈCHE EMPENNÉE À DEUX POINTES VERS LA DROITE BARRÉE VERTICALEMENT","	= injection surjective en notation z\n"
	"	x (flèche empennée à deux pointes vers la gauche barrée verticalement - 2B3C)"},
/* 2918 */ { "FLÈCHE EMPENNÉE À DEUX POINTES VERS LA DROITE BARRÉE DEUX FOIS VERTICALEMENT","	= injection surjective finie en notation z\n"
	"	x (flèche empennée à deux pointes vers la gauche barrée deux fois verticalement - 2B3D)"},
/* 2919 */ { "EMPENNE VERS LA GAUCHE",NULL},
/* 291A */ { "EMPENNE VERS LA DROITE",NULL},
/* 291B */ { "DOUBLE EMPENNE VERS LA GAUCHE",NULL},
/* 291C */ { "DOUBLE EMPENNE VERS LA DROITE",NULL},
/* 291D */ { "FLÈCHE VERS UN LOSANGE NOIR À GAUCHE",NULL},
/* 291E */ { "FLÈCHE VERS UN LOSANGE NOIR À DROITE",NULL},
/* 291F */ { "FLÈCHE D'UN TAQUET VERS UN LOSANGE NOIR À GAUCHE",NULL},
/* 2920 */ { "FLÈCHE D'UN TAQUET VERS UN LOSANGE NOIR À DROITE",NULL},
/* 2921 */ { "FLÈCHE NORD-OUEST ET SUD-EST",NULL},
/* 2922 */ { "FLÈCHE NORD-EST ET SUD-OUEST",NULL},
/* 2923 */ { "FLÈCHE NORD-OUEST À CROCHET",NULL},
/* 2924 */ { "FLÈCHE NORD-EST À CROCHET",NULL},
/* 2925 */ { "FLÈCHE SUD-EST À CROCHET",NULL},
/* 2926 */ { "FLÈCHE SUD-OUEST À CROCHET",NULL},
/* 2927 */ { "FLÈCHES NORD-OUEST ET NORD-EST",NULL},
/* 2928 */ { "FLÈCHES NORD-EST ET SUD-EST",NULL},
/* 2929 */ { "FLÈCHES SUD-EST ET SUD-OUEST",NULL},
/* 292A */ { "FLÈCHES SUD-OUEST ET NORD-OUEST",NULL},
/* 292B */ { "DIAGONALE MONTANTE SUR DIAGONALE DESCENDANTE",NULL},
/* 292C */ { "DIAGONALE DESCENDANTE SUR DIAGONALE MONTANTE","	x (voies croisées - 26CC)"},
/* 292D */ { "FLÈCHE SUD-EST SUR FLÈCHE NORD-EST",NULL},
/* 292E */ { "FLÈCHE NORD-EST SUR FLÈCHE SUD-EST",NULL},
/* 292F */ { "DIAGONALE DESCENDANTE SUR FLÈCHE NORD-EST",NULL},
/* 2930 */ { "DIAGONALE MONTANTE SUR FLÈCHE SUD-EST",NULL},
/* 2931 */ { "FLÈCHE NORD-EST SUR FLÈCHE NORD-OUEST",NULL},
/* 2932 */ { "FLÈCHE NORD-OUEST SUR FLÈCHE NORD-EST",NULL},
/* 2933 */ { "FLÈCHE ONDULÉE POINTANT DIRECTEMENT À DROITE","	x (flèche vers la droite ondulée - 219D)\n"
	"	x (flèche ondulée pointant directement à gauche - 2B3F)"},
/* 2934 */ { "FLÈCHE DIRIGÉE VERS LA DROITE PUIS TOURNANT VERS LE HAUT",NULL},
/* 2935 */ { "FLÈCHE DIRIGÉE VERS LA DROITE PUIS TOURNANT VERS LE BAS",NULL},
/* 2936 */ { "FLÈCHE DIRIGÉE VERS LE BAS PUIS TOURNANT VERS LA GAUCHE",NULL},
/* 2937 */ { "FLÈCHE DIRIGÉE VERS LE BAS PUIS TOURNANT VERS LA DROITE",NULL},
/* 2938 */ { "ARC DE CERCLE DROIT FLÉCHÉ SENS HORAIRE",NULL},
/* 2939 */ { "ARC DE CERCLE GAUCHE FLÉCHÉ SENS ANTIHORAIRE",NULL},
/* 293A */ { "ARC DE CERCLE SUPÉRIEUR FLÉCHÉ SENS ANTIHORAIRE",NULL},
/* 293B */ { "ARC DE CERCLE INFÉRIEUR FLÉCHÉ SENS ANTIHORAIRE",NULL},
/* 293C */ { "ARC DE CERCLE SUPÉRIEUR FLÉCHÉ SENS HORAIRE ET SIGNE MOINS",NULL},
/* 293D */ { "ARC DE CERCLE SUPÉRIEUR FLÉCHÉ SENS ANTIHORAIRE ET SIGNE PLUS",NULL},
/* 293E */ { "DEMI-CERCLE FLÉCHÉ INFÉRIEUR DROIT SENS HORAIRE",NULL},
/* 293F */ { "DEMI-CERCLE FLÉCHÉ INFÉRIEUR GAUCHE SENS ANTIHORAIRE",NULL},
/* 2940 */ { "CERCLE FLÉCHÉ SENS ANTIHORAIRE","	x (diacritique rond sens antihoraire couvrant - 20DA)"},
/* 2941 */ { "CERCLE FLÉCHÉ SENS HORAIRE","	x (diacritique rond sens horaire couvrant - 20D9)"},
/* 2942 */ { "FLÈCHE VERS LA DROITE SURMONTANT FLÉCHETTE VERS LA GAUCHE",NULL},
/* 2943 */ { "FLÈCHE VERS LA GAUCHE SURMONTANT FLÉCHETTE VERS LA DROITE",NULL},
/* 2944 */ { "FLÉCHETTE VERS LA DROITE SURMONTANT FLÈCHE VERS LA GAUCHE",NULL},
/* 2945 */ { "FLÈCHE VERS LA DROITE SURMONTANT SIGNE MOINS",NULL},
/* 2946 */ { "FLÈCHE VERS LA GAUCHE SURMONTANT SIGNE MOINS",NULL},
/* 2947 */ { "FLÈCHE VERS LA DROITE À TRAVERS X","	x (flèche vers la gauche à travers x - 2B3E)"},
/* 2948 */ { "PETIT CERCLE TRAVERSÉ D'UNE FLÈCHE GAUCHE-DROITE",NULL},
/* 2949 */ { "PETIT CERCLE SURMONTÉ D'UNE FLÈCHE MONTANTE À DEUX POINTES",NULL},
/* 294A */ { "HARPON À BARBILLON GAUCHE DRESSÉ ET BARBILLON DROIT BAISSÉ",NULL},
/* 294B */ { "HARPON À BARBILLON GAUCHE BAISSÉ ET BARBILLON DROIT DRESSÉ",NULL},
/* 294C */ { "HARPON À BARBILLON SUPÉRIEUR DROIT ET BARBILLON INFÉRIEUR GAUCHE",NULL},
/* 294D */ { "HARPON À BARBILLON SUPÉRIEUR GAUCHE ET BARBILLON INFÉRIEUR DROIT",NULL},
/* 294E */ { "HARPON À BARBILLON GAUCHE DRESSÉ ET BARBILLON DROIT DRESSÉ",NULL},
/* 294F */ { "HARPON À BARBILLON SUPÉRIEUR DROIT ET BARBILLON INFÉRIEUR DROIT",NULL},
/* 2950 */ { "HARPON À BARBILLON GAUCHE BAISSÉ ET BARBILLON DROIT BAISSÉ",NULL},
/* 2951 */ { "HARPON À BARBILLON SUPÉRIEUR GAUCHE ET BARBILLON INFÉRIEUR GAUCHE",NULL},
/* 2952 */ { "HARPON À BARBILLON DRESSÉ VERS UN TAQUET À GAUCHE",NULL},
/* 2953 */ { "HARPON À BARBILLON DRESSÉ VERS UN TAQUET À DROITE",NULL},
/* 2954 */ { "HARPON À BARBILLON DROIT VERS UN TAQUET EN HAUT",NULL},
/* 2955 */ { "HARPON À BARBILLON DROIT VERS UN TAQUET EN BAS",NULL},
/* 2956 */ { "HARPON À BARBILLON BAISSÉ VERS UN TAQUET À GAUCHE",NULL},
/* 2957 */ { "HARPON À BARBILLON BAISSÉ VERS UN TAQUET À DROITE",NULL},
/* 2958 */ { "HARPON À BARBILLON GAUCHE VERS UN TAQUET EN HAUT",NULL},
/* 2959 */ { "HARPON À BARBILLON GAUCHE VERS UN TAQUET EN BAS",NULL},
/* 295A */ { "HARPON À BARBILLON DRESSÉ D'UN TAQUET VERS LA GAUCHE",NULL},
/* 295B */ { "HARPON À BARBILLON DRESSÉ D'UN TAQUET VERS LA DROITE",NULL},
/* 295C */ { "HARPON À BARBILLON DROIT D'UN TAQUET VERS LE HAUT",NULL},
/* 295D */ { "HARPON À BARBILLON DROIT D'UN TAQUET VERS LE BAS",NULL},
/* 295E */ { "HARPON À BARBILLON BAISSÉ D'UN TAQUET VERS LA GAUCHE",NULL},
/* 295F */ { "HARPON À BARBILLON BAISSÉ D'UN TAQUET VERS LA DROITE",NULL},
/* 2960 */ { "HARPON À BARBILLON GAUCHE D'UN TAQUET VERS LE HAUT",NULL},
/* 2961 */ { "HARPON À BARBILLON GAUCHE D'UN TAQUET VERS LE BAS",NULL},
/* 2962 */ { "HARPON VERS LA GAUCHE À BARBILLON DRESSÉ SUR HARPON VERS LA GAUCHE À BARBILLON BAISSÉ",NULL},
/* 2963 */ { "HARPON VERS LE HAUT À BARBILLON GAUCHE À CÔTÉ DE HARPON VERS LE HAUT À BARBILLON DROIT",NULL},
/* 2964 */ { "HARPON VERS LA DROITE À BARBILLON DRESSÉ SUR HARPON VERS LA DROITE À BARBILLON BAISSÉ",NULL},
/* 2965 */ { "HARPON VERS LE BAS À BARBILLON GAUCHE À CÔTÉ DE HARPON VERS LE BAS À BARBILLON DROIT",NULL},
/* 2966 */ { "HARPON VERS LA GAUCHE À BARBILLON DRESSÉ SUR HARPON VERS LA DROITE À BARBILLON DRESSÉ",NULL},
/* 2967 */ { "HARPON VERS LA GAUCHE À BARBILLON BAISSÉ SUR HARPON VERS LA DROITE À BARBILLON BAISSÉ",NULL},
/* 2968 */ { "HARPON VERS LA DROITE À BARBILLON DRESSÉ SUR HARPON VERS LA GAUCHE À BARBILLON DRESSÉ",NULL},
/* 2969 */ { "HARPON VERS LA DROITE À BARBILLON BAISSÉ SUR HARPON VERS LA GAUCHE À BARBILLON BAISSÉ",NULL},
/* 296A */ { "HARPON VERS LA GAUCHE À BARBILLON DRESSÉ SUR LONG TIRET",NULL},
/* 296B */ { "HARPON VERS LA GAUCHE À BARBILLON BAISSÉ SOUS LONG TIRET",NULL},
/* 296C */ { "HARPON VERS LA DROITE À BARBILLON DRESSÉ SUR LONG TIRET",NULL},
/* 296D */ { "HARPON VERS LA DROITE À BARBILLON BAISSÉ SOUS LONG TIRET",NULL},
/* 296E */ { "HARPON VERS LE HAUT À BARBILLON GAUCHE À CÔTÉ DE HARPON VERS LE BAS À BARBILLON DROIT",NULL},
/* 296F */ { "HARPON VERS LE BAS À BARBILLON GAUCHE À CÔTÉ DE HARPON VERS LE HAUT À BARBILLON DROIT",NULL},
/* 2970 */ { "FLÈCHE EN ÉPINGLE À CHEVEU VERS LA DROITE","	x (sur-ensemble de - 2283)"},
/* 2971 */ { "SIGNE ÉGAL SUR FLÈCHE VERS LA DROITE","	x (signe égal sur flèche vers la gauche - 2B40)"},
/* 2972 */ { "OPÉRATEUR TILDE SUR FLÈCHE VERS LA DROITE","	x (opérateur tilde réfléchi sur flèche vers la gauche - 2B41)"},
/* 2973 */ { "FLÈCHE VERS LA GAUCHE SUR OPÉRATEUR TILDE","	x (flèche vers la droite sur opérateur tilde réfléchi - 2B4C)"},
/* 2974 */ { "FLÈCHE VERS LA DROITE SUR OPÉRATEUR TILDE","	x (flèche vers la gauche sur opérateur tilde réfléchi - 2B4B)"},
/* 2975 */ { "FLÈCHE VERS LA DROITE SUR PRESQUE ÉGAL À","	x (flèche vers la gauche sur presque égal à réfléchi - 2B42)"},
/* 2976 */ { "INFÉRIEUR À SUR FLÈCHE VERS LA GAUCHE",NULL},
/* 2977 */ { "FLÈCHE VERS LA GAUCHE À TRAVERS INFÉRIEUR À","	x (flèche vers la droite à travers supérieur à - 2B43)"},
/* 2978 */ { "SUPÉRIEUR À SUR FLÈCHE VERS LA DROITE",NULL},
/* 2979 */ { "SOUS-ENSEMBLE SUR FLÈCHE VERS LA DROITE",NULL},
/* 297A */ { "FLÈCHE VERS LA GAUCHE À TRAVERS SOUS-ENSEMBLE","	x (flèche vers la droite à travers sur-ensemble - 2B44)"},
/* 297B */ { "SUR-ENSEMBLE SUR FLÈCHE VERS LA GAUCHE",NULL},
/* 297C */ { "ANCRE VERS LA GAUCHE",NULL},
/* 297D */ { "ANCRE VERS LA DROITE",NULL},
/* 297E */ { "ANCRE VERS LE HAUT",NULL},
/* 297F */ { "ANCRE VERS LE BAS",NULL},
/* 2980 */ { "DÉLIMITEUR TRIPLE BARRE VERTICALE","	x (relation binaire triple barre verticale - 2AF4)\n"
	"	x (grand opérateur à trois barres verticales - 2AFC)"},
/* 2981 */ { "BOULET","	* cercle noir de petite à moyenne taille\n"
	"	x (opérateur puce - 2219)\n"
	"	x (cercle noir - 25CF)"},
/* 2982 */ { "DEUX-POINTS EN NOTATION Z","	x (diacritique tibétain rnam bcad - 0F7F)"},
/* 2983 */ { "ACCOLADE BLANCHE GAUCHE",NULL},
/* 2984 */ { "ACCOLADE BLANCHE DROITE",NULL},
/* 2985 */ { "PARENTHÈSE BLANCHE GAUCHE","	x (double parenthèse gauche - 2E28)\n"
	"	x (parenthèse blanche gauche pleine chasse - FF5F)"},
/* 2986 */ { "PARENTHÈSE BLANCHE DROITE","	* utilisée pour les intervalles bourbakistes\n"
	"	x (double parenthèse droite - 2E29)\n"
	"	x (parenthèse blanche droite pleine chasse - FF60)"},
/* 2987 */ { "PARENTHÈSE IMAGE DE GAUCHE EN NOTATION Z",NULL},
/* 2988 */ { "PARENTHÈSE IMAGE DE DROITE EN NOTATION Z",NULL},
/* 2989 */ { "PARENTHÈSE LIEN GAUCHE EN NOTATION Z",NULL},
/* 298A */ { "PARENTHÈSE LIEN DROITE EN NOTATION Z",NULL},
/* 298B */ { "CROCHET GAUCHE AVEC BARRE SOUSCRITE",NULL},
/* 298C */ { "CROCHET DROIT AVEC BARRE SOUSCRITE",NULL},
/* 298D */ { "CROCHET GAUCHE AVEC TRAIT DANS LE COIN SUPÉRIEUR",NULL},
/* 298E */ { "CROCHET DROIT AVEC TRAIT DANS LE COIN INFÉRIEUR",NULL},
/* 298F */ { "CROCHET GAUCHE AVEC TRAIT DANS LE COIN INFÉRIEUR",NULL},
/* 2990 */ { "CROCHET DROIT AVEC TRAIT DANS LE COIN SUPÉRIEUR",NULL},
/* 2991 */ { "CHEVRON POINTÉ GAUCHE",NULL},
/* 2992 */ { "CHEVRON POINTÉ DROIT",NULL},
/* 2993 */ { "PARENTHÈSE ARC GAUCHE ET INFÉRIEUR À",NULL},
/* 2994 */ { "PARENTHÈSE ARC DROITE ET SUPÉRIEUR À",NULL},
/* 2995 */ { "PARENTHÈSE DOUBLE ARC DROITE ET SUPÉRIEUR À",NULL},
/* 2996 */ { "PARENTHÈSE DOUBLE ARC GAUCHE ET INFÉRIEUR À",NULL},
/* 2997 */ { "CROCHET EN ÉCAILLE NOIR GAUCHE","	x (crochet en écaille mathématique blanc gauche - 27EC)\n"
	"	x (crochet en écaille gauche - 3014)\n"
	"	x (crochet en écaille blanc gauche - 3018)"},
/* 2998 */ { "CROCHET EN ÉCAILLE NOIR DROIT",NULL},
/* 2999 */ { "CLÔTURE POINTILLÉE","	* quatre points verticaux rapprochés"},
/* 299A */ { "LIGNE VERTICALE EN ZIGZAG","	x (ligne ondulée - 2307)"},
/* 299B */ { "ANGLE MESURÉ S'OUVRANT VERS LA GAUCHE","	x (angle mesuré - 2221)"},
/* 299C */ { "VARIANTE D'ANGLE AVEC CARRÉ","	x (angle droit - 221F)"},
/* 299D */ { "ANGLE DROIT MESURÉ POINTÉ",NULL},
/* 299E */ { "ANGLE AVEC S INSCRIT",NULL},
/* 299F */ { "ANGLE AIGU","	x (angle - 2220)"},
/* 29A0 */ { "ANGLE SPHÉRIQUE S'OUVRANT VERS LA GAUCHE","	x (angle sphérique - 2222)"},
/* 29A1 */ { "ANGLE SPHÉRIQUE S'OUVRANT VERS LE HAUT",NULL},
/* 29A2 */ { "ANGLE CULBUTÉ","	x (angle - 2220)"},
/* 29A3 */ { "ANGLE RÉFLÉCHI",NULL},
/* 29A4 */ { "ANGLE AVEC BARRE SOUSCRITE",NULL},
/* 29A5 */ { "ANGLE RÉFLÉCHI AVEC BARRE SOUSCRITE",NULL},
/* 29A6 */ { "ANGLE OBLIQUE S'OUVRANT VERS LE HAUT",NULL},
/* 29A7 */ { "ANGLE OBLIQUE S'OUVRANT VERS LE BAS",NULL},
/* 29A8 */ { "ANGLE CALCULÉ À BRAS VERS L'EST ET BRAS FLÉCHÉ VERS LE NORD-EST",NULL},
/* 29A9 */ { "ANGLE CALCULÉ À BRAS VERS L'OUEST ET BRAS FLÉCHÉ VERS LE NORD-OUEST",NULL},
/* 29AA */ { "ANGLE CALCULÉ À BRAS VERS L'EST ET BRAS FLÉCHÉ VERS LE SUD-EST",NULL},
/* 29AB */ { "ANGLE CALCULÉ À BRAS VERS L'OUEST ET BRAS FLÉCHÉ VERS LE SUD-OUEST",NULL},
/* 29AC */ { "ANGLE CALCULÉ À BRAS VERS LE NORD ET BRAS FLÉCHÉ VERS LE NORD-EST",NULL},
/* 29AD */ { "ANGLE CALCULÉ À BRAS VERS LE NORD ET BRAS FLÉCHÉ VERS LE NORD-OUEST",NULL},
/* 29AE */ { "ANGLE CALCULÉ À BRAS VERS LE SUD ET BRAS FLÉCHÉ VERS LE SUD-EST",NULL},
/* 29AF */ { "ANGLE CALCULÉ À BRAS VERS LE SUD ET BRAS FLÉCHÉ VERS LE SUD-OUEST",NULL},
/* 29B0 */ { "ENSEMBLE VIDE RÉFLÉCHI","	x (ensemble vide - 2205)\n"
	"	x (symbole de fonction apl saturne - 2349)"},
/* 29B1 */ { "ENSEMBLE VIDE AVEC BARRE EN CHEF",NULL},
/* 29B2 */ { "ENSEMBLE VIDE AVEC PETIT CERCLE EN CHEF",NULL},
/* 29B3 */ { "ENSEMBLE VIDE AVEC FLÈCHE DROITE EN CHEF",NULL},
/* 29B4 */ { "ENSEMBLE VIDE AVEC FLÈCHE GAUCHE EN CHEF",NULL},
/* 29B5 */ { "CERCLE AVEC BARRE HORIZONTALE","	x (moins cerclé - 2296)"},
/* 29B6 */ { "BARRE VERTICALE CERCLÉE","	x (symbole alchimique du salpêtre - 1F715)"},
/* 29B7 */ { "PARALLÈLES CERCLÉES",NULL},
/* 29B8 */ { "BARRE OBLIQUE INVERSÉE CERCLÉE","	= contre-oblique cerclée, contre-cotice cerclée"},
/* 29B9 */ { "PERPENDICULAIRE CERCLÉ",NULL},
/* 29BA */ { "CERCLE DIVISÉ PAR UNE BARRE HORIZONTALE ET UNE BARRE VERTICALE DANS LA MOITIÉ SUPÉRIEURE",NULL},
/* 29BB */ { "CERCLE SUPERPOSÉ D'UN X","	x (multiplié par cerclé - 2297)"},
/* 29BC */ { "SIGNE DE DIVISION PIVOTÉ SENS ANTIHORAIRE CERCLÉ",NULL},
/* 29BD */ { "CERCLE TRAVERSÉ D'UNE FLÈCHE MONTANTE",NULL},
/* 29BE */ { "PUCE BLANCHE CERCLÉE","	x (opérateur rond cerclé - 229A)\n"
	"	x (symbole de fonction apl beigne - 233E)\n"
	"	x (deux cercles concentriques - 25CE)"},
/* 29BF */ { "PUCE CERCLÉE","	* fait partie d'un jeu étalonné de cercles dont le cercle noir intérieur varie en taille\n"
	"	x (opérateur point cerclé - 2299)\n"
	"	x (cercle blanc évidé - 25C9)\n"
	"	x (opérateur point cerclé n-aire - 2A00)"},
/* 29C0 */ { "INFÉRIEUR À CERCLÉ",NULL},
/* 29C1 */ { "SUPÉRIEUR À CERCLÉ",NULL},
/* 29C2 */ { "CERCLE AVEC PETIT CERCLE À DROITE",NULL},
/* 29C3 */ { "CERCLE AVEC DEUX PETITS TRAITS HORIZONTAUX À DROITE",NULL},
/* 29C4 */ { "OBLIQUE ENCADRÉE","	= cotice encadrée\n"
	"	x (symbole de fonction apl quadrat oblique - 2341)\n"
	"	x (signe masu - 303C)"},
/* 29C5 */ { "OBLIQUE INVERSÉE ENCADRÉE","	= contre-oblique encadrée, contre-cotice encadrée\n"
	"	x (symbole de fonction apl quadrat oblique inversée - 2342)"},
/* 29C6 */ { "ASTÉRISQUE ENCADRÉ",NULL},
/* 29C7 */ { "PETIT CERCLE ENCADRÉ","	x (symbole de fonction apl as - 233B)"},
/* 29C8 */ { "CARRÉ ENCADRÉ","	= deux carrés concentriques"},
/* 29C9 */ { "CARRÉS SE CHEVAUCHANT",NULL},
/* 29CA */ { "TRIANGLE AVEC POINT EN CHEF",NULL},
/* 29CB */ { "TRIANGLE AVEC BARRE SOUSCRITE",NULL},
/* 29CC */ { "S INSCRIT DANS UN TRIANGLE",NULL},
/* 29CD */ { "TRIANGLE À EMPATTEMENTS INFÉRIEURS","	x (triangle blanc pointant vers le haut - 25B3)"},
/* 29CE */ { "TRIANGLE DROIT SUR TRIANGLE GAUCHE",NULL},
/* 29CF */ { "TRIANGLE GAUCHE À CÔTÉ D'UNE BARRE VERTICALE",NULL},
/* 29D0 */ { "BARRE VERTICALE À CÔTÉ D'UN TRIANGLE DROIT",NULL},
/* 29D1 */ { "NŒUD PAPILLON À AILE GAUCHE NOIRE","	x (nœud papillon - 22C8)"},
/* 29D2 */ { "NŒUD PAPILLON À AILE DROITE NOIRE",NULL},
/* 29D3 */ { "NŒUD PAPILLON NOIR",NULL},
/* 29D4 */ { "SIGNE DE MULTIPLICATION À MOITIÉ GAUCHE NOIRE","	x (produit semi-direct à gauche de facteur normal - 22C9)"},
/* 29D5 */ { "SIGNE DE MULTIPLICATION À MOITIÉ DROITE NOIRE","	x (produit semi-direct à droite de facteur normal - 22CA)"},
/* 29D6 */ { "SABLIER BLANC","	= nœud papillon vertical\n"
	"	x (sablier - 231B)"},
/* 29D7 */ { "SABLIER NOIR",NULL},
/* 29D8 */ { "CLÔTURE DENTELÉE GAUCHE","	x (forme de présentation de tiret bas ondulé vertical - FE34)"},
/* 29D9 */ { "CLÔTURE DENTELÉE DROITE",NULL},
/* 29DA */ { "DOUBLE CLÔTURE DENTELÉE GAUCHE",NULL},
/* 29DB */ { "DOUBLE CLÔTURE DENTELÉE DROITE",NULL},
/* 29DC */ { "INFINI INCOMPLET","	= entité ISOtech &iinfin;\n"
	"	x (infini - 221E)"},
/* 29DD */ { "BOUCLE SUR INFINI","	= infini surmonté d'une boucle"},
/* 29DE */ { "INFINI NIÉ PAR UNE BARRE VERTICALE",NULL},
/* 29DF */ { "MULTIJECTION À DEUX TÊTES","	x (multijection - 22B8)\n"
	"	x (symbole alchimique de l'arsenic - 1F73A)"},
/* 29E0 */ { "CARRÉ OMBRÉ","	= d'alembertien\n"
	"	x (carré blanc à ombre projetée sous le coin inférieur droit - 274F)"},
/* 29E1 */ { "AUGMENTE AVEC","	x (sous-groupe normal de ou égal à - 22B4)"},
/* 29E2 */ { "PRODUIT DE PERMUTATION","	x (élément d'un sac en notation z - 22FF)"},
/* 29E3 */ { "SIGNE ÉGAL ET PARALLÈLE INCLINÉ","	x (croisillon - 0023)\n"
	"	x (égal et parallèle à - 22D5)"},
/* 29E4 */ { "SIGNE ÉGAL ET PARALLÈLE INCLINÉ SURMONTÉS D'UN TILDE",NULL},
/* 29E5 */ { "IDENTIQUE À ET PARALLÈLE INCLINÉ","	x (deux barres verticales à trois traverses - 2A68)"},
/* 29E6 */ { "GLEICH STARK","	= équivalent tautologique"},
/* 29E7 */ { "THERMODYNAMIQUE","	* barre verticale à deux traverses\n"
	"	x (pas égal à - 2260)\n"
	"	x (marque de groupe - 2BD2)"},
/* 29E8 */ { "TRIANGLE POINTE VERS LE BAS À MOITIÉ GAUCHE NOIRE","	x (triangle pointe vers le haut à moitié gauche noire - 25ED)"},
/* 29E9 */ { "TRIANGLE POINTE VERS LE BAS À MOITIÉ DROITE NOIRE","	x (triangle pointe vers le haut à moitié droite noire - 25EE)"},
/* 29EA */ { "LOSANGE NOIR AVEC FLÈCHE VERS LE BAS",NULL},
/* 29EB */ { "RHOMBE NOIR","	x (rhombe - 25CA)"},
/* 29EC */ { "CERCLE BLANC AVEC FLÈCHE VERS LE BAS",NULL},
/* 29ED */ { "CERCLE NOIR AVEC FLÈCHE VERS LE BAS",NULL},
/* 29EE */ { "BARRE D'ERREUR AVEC CARRÉ BLANC",NULL},
/* 29EF */ { "BARRE D'ERREUR AVEC CARRÉ NOIR",NULL},
/* 29F0 */ { "BARRE D'ERREUR AVEC LOSANGE BLANC",NULL},
/* 29F1 */ { "BARRE D'ERREUR AVEC LOSANGE NOIR",NULL},
/* 29F2 */ { "BARRE D'ERREUR AVEC CERCLE BLANC",NULL},
/* 29F3 */ { "BARRE D'ERREUR AVEC CERCLE NOIR",NULL},
/* 29F4 */ { "RÈGLE DIFFÉRÉE","	= deux-points suivi d'une flèche"},
/* 29F5 */ { "OPÉRATEUR BARRE OBLIQUE INVERSÉE","	= opérateur contre-oblique, opérateur contre-cotice\n"
	"	x (barre oblique inversée - 005C)\n"
	"	x (différence d'ensembles - 2216)\n"
	"	x (diagonale mathématique descendante - 27CD)"},
/* 29F6 */ { "BARRE OBLIQUE AVEC BARRE EN CHEF","	= oblique barre en chef, cotice barre en chef"},
/* 29F7 */ { "BARRE OBLIQUE INVERSÉE À TRAVERSE HORIZONTALE","	= contre-oblique à traverse horizontale, contre-cotice à traverse horizontale\n"
	"	x (symbole de fonction apl contre-cotice barrée - 2340)"},
/* 29F8 */ { "GRANDE BARRE OBLIQUE","	x (barre oblique de division - 2215)"},
/* 29F9 */ { "GRANDE BARRE OBLIQUE INVERSÉE","	= grande contre-oblique, grande contre-cotice\n"
	"	= masquage de schémas en notation z\n"
	"	x (différence d'ensembles - 2216)"},
/* 29FA */ { "DOUBLE PLUS",NULL},
/* 29FB */ { "TRIPLE PLUS",NULL},
/* 29FC */ { "CHEVRON COURBÉ POINTANT À GAUCHE","	x (précède - 227A)\n"
	"	x (chevron pointant à gauche - 2329)"},
/* 29FD */ { "CHEVRON COURBÉ POINTANT À DROITE","	x (suit - 227B)\n"
	"	x (chevron pointant à droite - 232A)"},
/* 29FE */ { "TINY","	x (signe plus - 002B)"},
/* 29FF */ { "MINY","	x (signe moins - 2212)"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_2A[] = {
/* 2A00 */ { "OPÉRATEUR POINT CERCLÉ N-AIRE","	x (opérateur point cerclé - 2299)\n"
	"	x (cercle blanc évidé - 25C9)"},
/* 2A01 */ { "OPÉRATEUR PLUS CERCLÉ N-AIRE","	x (plus cerclé - 2295)"},
/* 2A02 */ { "OPÉRATEUR DE MULTIPLICATION N-AIRE CERCLÉ","	x (multiplié par cerclé - 2297)\n"
	"	x (sautoir cerclé épais - 2B59)"},
/* 2A03 */ { "OPÉRATEUR UNION N-AIRE POINTÉ","	x (multiplication de multiensemble - 228D)"},
/* 2A04 */ { "OPÉRATEUR UNION N-AIRE AVEC PLUS","	x (union de multiensemble - 228E)"},
/* 2A05 */ { "OPÉRATEUR INTERSECTION CARRÉ N-AIRE","	x (chapeau carré - 2293)"},
/* 2A06 */ { "OPÉRATEUR UNION CARRÉ N-AIRE","	x (coupe carrée - 2294)"},
/* 2A07 */ { "OPÉRATEUR DEUX ET LOGIQUES","	= fusion\n"
	"	x (deux et logiques entrecroisés - 2A55)"},
/* 2A08 */ { "OPÉRATEUR DEUX OU LOGIQUES","	x (deux ou logiques entrecroisés - 2A56)"},
/* 2A09 */ { "OPÉRATEUR DE MULTIPLICATION N-AIRE","	x (signe de multiplication - 00D7)"},
/* 2A0A */ { "SOMMATION MODULO DEUX","	x (sommation de la famille - 2211)"},
/* 2A0B */ { "SOMMATION AVEC INTÉGRALE",NULL},
/* 2A0C */ { "INTÉGRALE QUADRUPLE","	x (intégrale triple - 222D)\n"
	"	# 222B 222B 222B 222B"},
/* 2A0D */ { "INTÉGRALE À PARTIE FINIE",NULL},
/* 2A0E */ { "INTÉGRALE AVEC DEUX BARRES HORIZONTALES",NULL},
/* 2A0F */ { "MOYENNE D'INTÉGRALE AVEC BARRE OBLIQUE",NULL},
/* 2A10 */ { "FONCTION DE CIRCULATION",NULL},
/* 2A11 */ { "INTÉGRALE SENS ANTIHORAIRE",NULL},
/* 2A12 */ { "INTÉGRALE DE LIGNE À CHEMIN RECTANGULAIRE AUTOUR DU PÔLE",NULL},
/* 2A13 */ { "INTÉGRALE DE LIGNE À CHEMIN SEMI-CIRCULAIRE AUTOUR DU PÔLE",NULL},
/* 2A14 */ { "INTÉGRALE DE LIGNE ÉVITANT LE PÔLE",NULL},
/* 2A15 */ { "INTÉGRALE AUTOUR D'UN OPÉRATEUR POINT","	x (intégrale de contour - 222E)"},
/* 2A16 */ { "INTÉGRALE QUATERNION",NULL},
/* 2A17 */ { "INTÉGRALE AVEC FLÈCHE VERS LA GAUCHE À CROCHET",NULL},
/* 2A18 */ { "INTÉGRALE AVEC SIGNE DE MULTIPLICATION",NULL},
/* 2A19 */ { "INTÉGRALE AVEC SIGNE D'INTERSECTION",NULL},
/* 2A1A */ { "INTÉGRALE AVEC SIGNE D'UNION",NULL},
/* 2A1B */ { "INTÉGRALE AVEC BARRE EN CHEF","	= intégrale supérieure"},
/* 2A1C */ { "INTÉGRALE AVEC BARRE SOUSCRITE","	= intégrale inférieure"},
/* 2A1D */ { "JOINTURE","	= gros nœud papillon\n"
	"	* théorie des bases de données relationnelles\n"
	"	x (nœud papillon - 22C8)\n"
	"	x (jointure externe complète - 27D7)"},
/* 2A1E */ { "GROS OPÉRATEUR TRIANGLE GAUCHE","	* théorie des bases de données relationnelles\n"
	"	x (triangle blanc pointant vers la gauche - 25C1)"},
/* 2A1F */ { "COMPOSITION DE SCHÉMAS EN NOTATION Z","	x (composition relationnelle en notation z - 2A3E)"},
/* 2A20 */ { "TUBAGE DE SCHÉMAS EN NOTATION Z","	x (très supérieur à - 226B)"},
/* 2A21 */ { "PROJECTION DE SCHÉMAS EN NOTATION Z","	x (harpon vers le haut avec barbillon vers la droite - 21BE)"},
/* 2A22 */ { "SIGNE PLUS AVEC ROND EN CHEF",NULL},
/* 2A23 */ { "SIGNE PLUS AVEC ACCENT CIRCONFLEXE EN CHEF",NULL},
/* 2A24 */ { "SIGNE PLUS AVEC TILDE EN CHEF","	= différence positive ou somme"},
/* 2A25 */ { "SIGNE PLUS AVEC POINT SOUSCRIT","	x (plus pointé - 2214)"},
/* 2A26 */ { "SIGNE PLUS AVEC TILDE SOUSCRIT","	= somme ou différence positive"},
/* 2A27 */ { "SIGNE PLUS AVEC INDICE DEUX","	= addition nim"},
/* 2A28 */ { "SIGNE PLUS AVEC TRIANGLE NOIR",NULL},
/* 2A29 */ { "SIGNE MOINS AVEC VIRGULE EN CHEF",NULL},
/* 2A2A */ { "SIGNE MOINS AVEC POINT SOUSCRIT","	x (moins pointé - 2238)"},
/* 2A2B */ { "SIGNE MOINS AVEC POINTS DESCENDANTS",NULL},
/* 2A2C */ { "SIGNE MOINS AVEC POINTS ASCENDANTS",NULL},
/* 2A2D */ { "SIGNE PLUS DANS UN DEMI-CERCLE GAUCHE",NULL},
/* 2A2E */ { "SIGNE PLUS DANS UN DEMI-CERCLE DROIT",NULL},
/* 2A2F */ { "PRODUIT VECTORIEL","	x (signe de multiplication - 00D7)"},
/* 2A30 */ { "SIGNE DE MULTIPLICATION AVEC POINT EN CHEF",NULL},
/* 2A31 */ { "SIGNE DE MULTIPLICATION AVEC BARRE SOUSCRITE",NULL},
/* 2A32 */ { "PRODUIT SEMI-DIRECT FERMÉ EN BAS",NULL},
/* 2A33 */ { "PRODUIT FUSIONNÉ",NULL},
/* 2A34 */ { "SIGNE DE MULTIPLICATION DANS UN DEMI-CERCLE GAUCHE",NULL},
/* 2A35 */ { "SIGNE DE MULTIPLICATION DANS UN DEMI-CERCLE DROIT",NULL},
/* 2A36 */ { "SIGNE DE MULTIPLICATION CERCLÉ AVEC ACCENT CIRCONFLEXE",NULL},
/* 2A37 */ { "SIGNE DE MULTIPLICATION DOUBLEMENT CERCLÉ",NULL},
/* 2A38 */ { "SIGNE DE DIVISION CERCLÉ",NULL},
/* 2A39 */ { "SIGNE PLUS DANS UN TRIANGLE",NULL},
/* 2A3A */ { "SIGNE MOINS DANS UN TRIANGLE",NULL},
/* 2A3B */ { "SIGNE DE MULTIPLICATION DANS UN TRIANGLE",NULL},
/* 2A3C */ { "PRODUIT INTÉRIEUR","	x (plancher à droite - 230B)\n"
	"	~ 2A3C FE00 variante haute à pied étroit"},
/* 2A3D */ { "PRODUIT INTÉRIEUR À DROITE","	x (plancher à gauche - 230A)\n"
	"	x (signe négation culbuté - 2319)\n"
	"	~ 2A3D FE00 variante haute à pied étroit"},
/* 2A3E */ { "COMPOSITION RELATIONNELLE EN NOTATION Z","	x (composition de schémas en notation z - 2A1F)"},
/* 2A3F */ { "AMALGAMATION OU COPRODUIT","	x (coproduit de la famille - 2210)"},
/* 2A40 */ { "INTERSECTION POINTÉE","	x (et logique - 2227)\n"
	"	x (et pointé - 27D1)"},
/* 2A41 */ { "UNION À SIGNE MOINS","	= différence de sacs en notation z\n"
	"	x (union de multiensemble - 228E)"},
/* 2A42 */ { "UNION À BARRE EN CHEF",NULL},
/* 2A43 */ { "INTERSECTION À BARRE EN CHEF",NULL},
/* 2A44 */ { "INTERSECTION AVEC ET LOGIQUE",NULL},
/* 2A45 */ { "UNION AVEC OU LOGIQUE",NULL},
/* 2A46 */ { "UNION SUR INTERSECTION",NULL},
/* 2A47 */ { "INTERSECTION SUR UNION",NULL},
/* 2A48 */ { "UNION SUR TRAIT SUR INTERSECTION",NULL},
/* 2A49 */ { "INTERSECTION SUR TRAIT SUR UNION",NULL},
/* 2A4A */ { "DEUX UNIONS SOUDÉES CÔTE À CÔTE",NULL},
/* 2A4B */ { "DEUX INTERSECTIONS SOUDÉES CÔTE À CÔTE",NULL},
/* 2A4C */ { "UNION FERMÉE À EMPATTEMENTS","	x (union - 222A)"},
/* 2A4D */ { "INTERSECTION FERMÉE À EMPATTEMENTS","	x (intersection - 2229)"},
/* 2A4E */ { "DEUX INTERSECTIONS CARRÉES EMBOÎTÉES",NULL},
/* 2A4F */ { "DEUX UNIONS CARRÉES EMBOÎTÉES",NULL},
/* 2A50 */ { "UNION FERMÉE À EMPATTEMENTS ET PRODUIT FUSIONNÉ",NULL},
/* 2A51 */ { "ET LOGIQUE À POINT EN CHEF",NULL},
/* 2A52 */ { "OU LOGIQUE À POINT EN CHEF",NULL},
/* 2A53 */ { "DOUBLE ET LOGIQUE",NULL},
/* 2A54 */ { "DOUBLE OU LOGIQUE",NULL},
/* 2A55 */ { "DEUX ET LOGIQUES ENTRECROISÉS","	x (opérateur deux et logiques - 2A07)"},
/* 2A56 */ { "DEUX OU LOGIQUES ENTRECROISÉS","	x (opérateur deux ou logiques - 2A08)"},
/* 2A57 */ { "GRAND OU INCLINÉ",NULL},
/* 2A58 */ { "GRAND ET INCLINÉ",NULL},
/* 2A59 */ { "ET ET OU LOGIQUES ENTRECROISÉS",NULL},
/* 2A5A */ { "ET LOGIQUE À HAMPE MÉDIANE",NULL},
/* 2A5B */ { "OU LOGIQUE À HAMPE MÉDIANE",NULL},
/* 2A5C */ { "ET LOGIQUE À TIRET HORIZONTAL",NULL},
/* 2A5D */ { "OU LOGIQUE À TIRET HORIZONTAL",NULL},
/* 2A5E */ { "ET LOGIQUE À DEUX BARRES EN CHEF","	x (perspective - 2306)"},
/* 2A5F */ { "ET LOGIQUE À BARRE SOUSCRITE",NULL},
/* 2A60 */ { "ET LOGIQUE À DEUX BARRES SOUSCRITES","	x (estime - 2259)"},
/* 2A61 */ { "PETIT V À BARRE SOUSCRITE","	x (équiangulaire à - 225A)"},
/* 2A62 */ { "OU LOGIQUE À DEUX BARRES EN CHEF",NULL},
/* 2A63 */ { "OU LOGIQUE À DEUX BARRES SOUSCRITES","	x (équiangulaire à - 225A)"},
/* 2A64 */ { "ANTIRESTRICTION DE DOMAINE EN NOTATION Z",NULL},
/* 2A65 */ { "ANTIRESTRICTION DE CODOMAINE EN NOTATION Z","	x (rétrécissement conique - 2332)"},
/* 2A66 */ { "SIGNE ÉGAL AVEC POINT SOUSCRIT","	x (tend vers la limite - 2250)"},
/* 2A67 */ { "IDENTIQUE AVEC POINT EN CHEF",NULL},
/* 2A68 */ { "DEUX BARRES VERTICALES À TROIS TRAVERSES","	= identique et parallèle à\n"
	"	x (égal et parallèle à - 22D5)\n"
	"	x (identique à et parallèle incliné - 29E5)"},
/* 2A69 */ { "TROIS BARRES VERTICALES À TROIS TRAVERSES",NULL},
/* 2A6A */ { "OPÉRATEUR TILDE AVEC POINT EN CHEF",NULL},
/* 2A6B */ { "OPÉRATEUR TILDE AVEC POINTS ASCENDANTS","	x (homothétique - 223B)"},
/* 2A6C */ { "SIMILAIRE MOINS SIMILAIRE",NULL},
/* 2A6D */ { "CONGRUENT AVEC POINT EN CHEF","	x (approximativement égal à - 2245)"},
/* 2A6E */ { "ÉGAL AVEC ASTÉRISQUE","	x (égal avec étoile en chef - 225B)"},
/* 2A6F */ { "PRESQUE ÉGAL À AVEC ACCENT CIRCONFLEXE",NULL},
/* 2A70 */ { "APPROXIMATIVEMENT ÉGAL OU ÉGAL À",NULL},
/* 2A71 */ { "SIGNE ÉGAL SUR SIGNE PLUS",NULL},
/* 2A72 */ { "SIGNE PLUS SUR SIGNE ÉGAL",NULL},
/* 2A73 */ { "SIGNE ÉGAL SUR OPÉRATEUR TILDE",NULL},
/* 2A74 */ { "DOUBLE DEUX-POINTS ÉGAL","	# 003A 003A 003D"},
/* 2A75 */ { "DEUX SIGNES ÉGAL CONSÉCUTIFS","	# 003D 003D"},
/* 2A76 */ { "TROIS SIGNES ÉGAL CONSÉCUTIFS","	# 003D 003D 003D"},
/* 2A77 */ { "SIGNE ÉGAL AVEC DEUX POINTS EN CHEF ET DEUX POINTS SOUSCRITS",NULL},
/* 2A78 */ { "ÉQUIVALENT AVEC QUATRE POINTS EN CHEF",NULL},
/* 2A79 */ { "INFÉRIEUR À AVEC CERCLE INSCRIT",NULL},
/* 2A7A */ { "SUPÉRIEUR À AVEC CERCLE INSCRIT",NULL},
/* 2A7B */ { "INFÉRIEUR À AVEC POINT D'INTERROGATION EN CHEF",NULL},
/* 2A7C */ { "SUPÉRIEUR À AVEC POINT D'INTERROGATION EN CHEF",NULL},
/* 2A7D */ { "INFÉRIEUR À OU ÉGAL À INCLINÉ","	x (inférieur ou égal à - 2264)"},
/* 2A7E */ { "SUPÉRIEUR À OU ÉGAL À INCLINÉ","	x (supérieur ou égal à - 2265)"},
/* 2A7F */ { "INFÉRIEUR À OU ÉGAL À INCLINÉ AVEC POINT INSCRIT",NULL},
/* 2A80 */ { "SUPÉRIEUR À OU ÉGAL À INCLINÉ AVEC POINT INSCRIT",NULL},
/* 2A81 */ { "INFÉRIEUR À OU ÉGAL À INCLINÉ AVEC POINT EN CHEF",NULL},
/* 2A82 */ { "SUPÉRIEUR À OU ÉGAL À INCLINÉ AVEC POINT EN CHEF",NULL},
/* 2A83 */ { "INFÉRIEUR À OU ÉGAL À INCLINÉ AVEC POINT EN CHEF À DROITE",NULL},
/* 2A84 */ { "SUPÉRIEUR À OU ÉGAL À INCLINÉ AVEC POINT EN CHEF À GAUCHE",NULL},
/* 2A85 */ { "INFÉRIEUR À OU PROCHE DE",NULL},
/* 2A86 */ { "SUPÉRIEUR À OU PROCHE DE",NULL},
/* 2A87 */ { "INFÉRIEUR À ET PAS ÉGAL À EN UNE LIGNE","	x (inférieur mais pas égal à - 2268)"},
/* 2A88 */ { "SUPÉRIEUR À ET PAS ÉGAL À EN UNE LIGNE","	x (supérieur mais pas égal à - 2269)"},
/* 2A89 */ { "INFÉRIEUR À ET NON PROCHE DE",NULL},
/* 2A8A */ { "SUPÉRIEUR À ET NON PROCHE DE",NULL},
/* 2A8B */ { "INFÉRIEUR À SUR ÉGAL EN DEUX LIGNES SUR SUPÉRIEUR À","	x (inférieur ou égal ou supérieur à - 22DA)"},
/* 2A8C */ { "SUPÉRIEUR À SUR ÉGAL EN DEUX LIGNES SUR INFÉRIEUR À","	x (supérieur ou égal ou inférieur à - 22DB)"},
/* 2A8D */ { "INFÉRIEUR À SUR SIMILAIRE OU ÉGAL",NULL},
/* 2A8E */ { "SUPÉRIEUR À SUR SIMILAIRE OU ÉGAL",NULL},
/* 2A8F */ { "INFÉRIEUR À SUR SIMILAIRE SUR SUPÉRIEUR À",NULL},
/* 2A90 */ { "SUPÉRIEUR À SUR SIMILAIRE SUR INFÉRIEUR À",NULL},
/* 2A91 */ { "INFÉRIEUR À SUR SUPÉRIEUR À SUR ÉGAL EN DEUX LIGNES",NULL},
/* 2A92 */ { "SUPÉRIEUR À SUR INFÉRIEUR À SUR ÉGAL EN DEUX LIGNES",NULL},
/* 2A93 */ { "INFÉRIEUR À SUR ÉGAL INCLINÉ SUR SUPÉRIEUR À SUR ÉGAL INCLINÉ",NULL},
/* 2A94 */ { "SUPÉRIEUR À SUR ÉGAL INCLINÉ SUR INFÉRIEUR À SUR ÉGAL INCLINÉ",NULL},
/* 2A95 */ { "ÉGAL À INCLINÉ OU INFÉRIEUR À","	x (égal ou inférieur à - 22DC)"},
/* 2A96 */ { "ÉGAL À INCLINÉ OU SUPÉRIEUR À","	x (égal ou supérieur à - 22DD)"},
/* 2A97 */ { "ÉGAL À INCLINÉ OU INFÉRIEUR À AVEC POINT INSCRIT",NULL},
/* 2A98 */ { "ÉGAL À INCLINÉ OU SUPÉRIEUR À AVEC POINT INSCRIT",NULL},
/* 2A99 */ { "ÉGAL EN DEUX LIGNES OU INFÉRIEUR À","	x (égal ou inférieur à - 22DC)"},
/* 2A9A */ { "ÉGAL EN DEUX LIGNES OU SUPÉRIEUR À","	x (égal ou supérieur à - 22DD)"},
/* 2A9B */ { "ÉGAL EN DEUX LIGNES INCLINÉES OU INFÉRIEUR À",NULL},
/* 2A9C */ { "ÉGAL EN DEUX LIGNES INCLINÉES OU SUPÉRIEUR À",NULL},
/* 2A9D */ { "SIMILAIRE OU INFÉRIEUR À","	~ 2A9D FE00 avec similaire suivant l'inclinaison de la jambe supérieure"},
/* 2A9E */ { "SIMILAIRE OU SUPÉRIEUR À","	~ 2A9E FE00 avec similaire suivant l'inclinaison de la jambe supérieure"},
/* 2A9F */ { "SIMILAIRE À SUR INFÉRIEUR À SUR SIGNE ÉGAL",NULL},
/* 2AA0 */ { "SIMILAIRE À SUR SUPÉRIEUR À SUR SIGNE ÉGAL",NULL},
/* 2AA1 */ { "DEUX INFÉRIEUR À EMBOÎTÉS","	= continuité absolue\n"
	"	x (très inférieur à - 226A)"},
/* 2AA2 */ { "DEUX SUPÉRIEUR À EMBOÎTÉS","	x (très supérieur à - 226B)"},
/* 2AA3 */ { "DEUX INFÉRIEUR À EMBOÎTÉS AVEC BARRE SOUSCRITE",NULL},
/* 2AA4 */ { "DEUX SUPÉRIEUR À ENTRECROISÉS",NULL},
/* 2AA5 */ { "SUPÉRIEUR À À CÔTÉ DE INFÉRIEUR À",NULL},
/* 2AA6 */ { "INFÉRIEUR À FERMÉ D'UN ARC",NULL},
/* 2AA7 */ { "SUPÉRIEUR À FERMÉ D'UN ARC",NULL},
/* 2AA8 */ { "INFÉRIEUR À FERMÉ D'UN ARC SUR ÉGAL INCLINÉ",NULL},
/* 2AA9 */ { "SUPÉRIEUR À FERMÉ D'UN ARC SUR ÉGAL INCLINÉ",NULL},
/* 2AAA */ { "PLUS PETIT QUE EN FOURCHE",NULL},
/* 2AAB */ { "PLUS GRAND QUE EN FOURCHE",NULL},
/* 2AAC */ { "PLUS PETIT OU ÉGAL À EN FOURCHE","	~ 2AAC FE00 avec un égal incliné"},
/* 2AAD */ { "PLUS GRAND OU ÉGAL À EN FOURCHE","	~ 2AAD FE00 avec un égal incliné"},
/* 2AAE */ { "SIGNE ÉGAL AVEC DOS-D'ÂNE EN CHEF","	x (différence entre - 224F)"},
/* 2AAF */ { "PRÉCÈDE SUR SIGNE ÉGAL EN UNE LIGNE","	x (précède ou est égal à - 227C)"},
/* 2AB0 */ { "SUIT SUR SIGNE ÉGAL EN UNE LIGNE","	x (suit ou est égal à - 227D)"},
/* 2AB1 */ { "PRÉCÈDE SUR PAS ÉGAL À EN UNE LIGNE",NULL},
/* 2AB2 */ { "SUIT SUR PAS ÉGAL À EN UNE LIGNE",NULL},
/* 2AB3 */ { "PRÉCÈDE SUR SIGNE ÉGAL",NULL},
/* 2AB4 */ { "SUIT SUR SIGNE ÉGAL",NULL},
/* 2AB5 */ { "PRÉCÈDE SUR PAS ÉGAL À",NULL},
/* 2AB6 */ { "SUIT SUR PAS ÉGAL À",NULL},
/* 2AB7 */ { "PRÉCÈDE SUR PRESQUE ÉGAL À",NULL},
/* 2AB8 */ { "SUIT SUR PRESQUE ÉGAL À",NULL},
/* 2AB9 */ { "PRÉCÈDE SUR NON PRESQUE ÉGAL À",NULL},
/* 2ABA */ { "SUIT SUR NON PRESQUE ÉGAL À",NULL},
/* 2ABB */ { "DOUBLE PRÉCÈDE",NULL},
/* 2ABC */ { "DOUBLE SUIT",NULL},
/* 2ABD */ { "SOUS-ENSEMBLE POINTÉ",NULL},
/* 2ABE */ { "SUR-ENSEMBLE POINTÉ",NULL},
/* 2ABF */ { "SOUS-ENSEMBLE AVEC SIGNE PLUS SOUSCRIT",NULL},
/* 2AC0 */ { "SUR-ENSEMBLE AVEC SIGNE PLUS SOUSCRIT",NULL},
/* 2AC1 */ { "SOUS-ENSEMBLE AVEC SIGNE DE MULTIPLICATION SOUSCRIT",NULL},
/* 2AC2 */ { "SUR-ENSEMBLE AVEC SIGNE DE MULTIPLICATION SOUSCRIT",NULL},
/* 2AC3 */ { "SOUS-ENSEMBLE DE OU ÉGAL À AVEC POINT EN CHEF",NULL},
/* 2AC4 */ { "SUR-ENSEMBLE DE OU ÉGAL À AVEC POINT EN CHEF",NULL},
/* 2AC5 */ { "SOUS-ENSEMBLE DE SUR SIGNE ÉGAL",NULL},
/* 2AC6 */ { "SUR-ENSEMBLE DE SUR SIGNE ÉGAL",NULL},
/* 2AC7 */ { "SOUS-ENSEMBLE DE SUR OPÉRATEUR TILDE",NULL},
/* 2AC8 */ { "SUR-ENSEMBLE DE SUR OPÉRATEUR TILDE",NULL},
/* 2AC9 */ { "SOUS-ENSEMBLE DE SUR PRESQUE ÉGAL À",NULL},
/* 2ACA */ { "SUR-ENSEMBLE DE SUR PRESQUE ÉGAL À",NULL},
/* 2ACB */ { "SOUS-ENSEMBLE DE SUR PAS ÉGAL À","	~ 2ACB FE00 avec une barre à travers les éléments inférieurs"},
/* 2ACC */ { "SUR-ENSEMBLE DE SUR PAS ÉGAL À","	~ 2ACC FE00 avec une barre à travers les éléments inférieurs"},
/* 2ACD */ { "OPÉRATEUR BOÎTE CARRÉE OUVERTE GAUCHE",NULL},
/* 2ACE */ { "OPÉRATEUR BOÎTE CARRÉE OUVERTE DROITE",NULL},
/* 2ACF */ { "SOUS-ENSEMBLE CLOS","	x (sous-ensemble de - 2282)"},
/* 2AD0 */ { "SUR-ENSEMBLE CLOS","	x (sur-ensemble de - 2283)"},
/* 2AD1 */ { "SOUS-ENSEMBLE CLOS OU ÉGAL À",NULL},
/* 2AD2 */ { "SUR-ENSEMBLE CLOS OU ÉGAL À",NULL},
/* 2AD3 */ { "SOUS-ENSEMBLE SUR SUR-ENSEMBLE",NULL},
/* 2AD4 */ { "SUR-ENSEMBLE SUR SOUS-ENSEMBLE",NULL},
/* 2AD5 */ { "SOUS-ENSEMBLE SUR SOUS-ENSEMBLE",NULL},
/* 2AD6 */ { "SUR-ENSEMBLE SUR SUR-ENSEMBLE",NULL},
/* 2AD7 */ { "SUR-ENSEMBLE À CÔTÉ DE SOUS-ENSEMBLE",NULL},
/* 2AD8 */ { "SUR-ENSEMBLE CHAÎNÉ À SOUS-ENSEMBLE",NULL},
/* 2AD9 */ { "APPARTIENT À OUVERT VERS LE BAS","	x (appartient à - 2208)\n"
	"	x (appartient à ouvert vers le haut - 27D2)"},
/* 2ADA */ { "FOURCHE SURMONTÉE D'UN T","	x (fourche - 22D4)"},
/* 2ADB */ { "INTERSECTION TRANSVERSALE","	x (fourche - 22D4)"},
/* 2ADC */ { "BIFURCATION","	= non indépendant\n"
	"	* symbole en logique équationnelle, pas un symbole informatique\n"
	"	* la non-indépendance (le concept d'origine) est apparentée à la bifurcation\n"
	"	: 2ADD 0338"},
/* 2ADD */ { "NON-BIFURCATION","	= indépendant\n"
	"	* symbole en logique équationnelle, pas un symbole informatique\n"
	"	* l'indépendance (le concept d'origine) est apparentée à la non-bifurcation"},
/* 2ADE */ { "TAQUET GAUCHE COURT","	x (taquet gauche - 22A3)"},
/* 2ADF */ { "TAQUET COURT VERS LE BAS","	x (taquet vers le bas - 22A4)"},
/* 2AE0 */ { "TAQUET COURT VERS LE HAUT","	x (taquet vers le haut - 22A5)"},
/* 2AE1 */ { "PERPENDICULAIRE À S",NULL},
/* 2AE2 */ { "TRIPLE TOURNIQUET DROIT À BARRE VERTICALE","	= satisfait habituellement"},
/* 2AE3 */ { "TOURNIQUET GAUCHE À DOUBLE BARRE VERTICALE","	x (oblige - 22A9)"},
/* 2AE4 */ { "DOUBLE TOURNIQUET GAUCHE À BARRE VERTICALE","	x (vrai - 22A8)"},
/* 2AE5 */ { "DOUBLE TOURNIQUET GAUCHE À DOUBLE BARRE VERTICALE",NULL},
/* 2AE6 */ { "DOUBLE BARRE VERTICALE GAUCHE À TRAVERSE","	x (oblige - 22A9)"},
/* 2AE7 */ { "TAQUET COURT VERS LE BAS AVEC BARRE EN CHEF","	x (taquet vers le bas - 22A4)\n"
	"	x (symbole de fonction apl taquet vers le bas surligné - 2351)"},
/* 2AE8 */ { "TAQUET COURT VERS LE HAUT AVEC BARRE SOUSCRITE","	x (taquet vers le haut - 22A5)\n"
	"	x (symbole de fonction apl taquet vers le haut souligné - 234A)"},
/* 2AE9 */ { "TAQUET COURT VERS LE HAUT SUR TAQUET COURT VERS LE BAS",NULL},
/* 2AEA */ { "DOUBLE TAQUET VERS LE BAS",NULL},
/* 2AEB */ { "DOUBLE TAQUET VERS LE HAUT","	= indépendance\n"
	"	* théorie des probabilités"},
/* 2AEC */ { "SIGNE NÉGATION À DEUX TRAITS","	x (signe négation - 00AC)"},
/* 2AED */ { "SIGNE NÉGATION À DEUX TRAITS RÉFLÉCHI","	x (signe négation réfléchi - 2310)"},
/* 2AEE */ { "N'EST PAS UN DIVISEUR DE À BARRE DE NÉGATION RÉFLÉCHIE","	x (n'est pas un diviseur de - 2224)"},
/* 2AEF */ { "LIGNE VERTICALE CERCLE EN CHEF",NULL},
/* 2AF0 */ { "LIGNE VERTICALE CERCLE SOUSCRIT",NULL},
/* 2AF1 */ { "TAQUET VERS LE BAS SURMONTANT UN CERCLE","	= satisfait nécessairement\n"
	"	x (taquet vers le haut surmonté d'un cercle - 27DF)"},
/* 2AF2 */ { "PARALLÈLE À VERTICAL À UNE TRAVERSE","	x (non parallèle à - 2226)\n"
	"	x (barre verticale à une traverse - 27CA)"},
/* 2AF3 */ { "PARALLÈLE À AVEC OPÉRATEUR TILDE",NULL},
/* 2AF4 */ { "RELATION BINAIRE TRIPLE BARRE VERTICALE","	= imbriquer\n"
	"	x (délimiteur triple barre verticale - 2980)"},
/* 2AF5 */ { "TRIPLE BARRE VERTICALE À UNE TRAVERSE","	x (barre verticale à une traverse - 27CA)"},
/* 2AF6 */ { "OPÉRATEUR TROIS-POINTS","	* logique\n"
	"	x (trois-points vertical - 205D)\n"
	"	x (trois points suspendus - 22EE)"},
/* 2AF7 */ { "TROIS INFÉRIEUR À EMBOÎTÉS","	x (considérablement inférieur à - 22D8)"},
/* 2AF8 */ { "TROIS SUPÉRIEUR À EMBOÎTÉS","	x (considérablement supérieur à - 22D9)"},
/* 2AF9 */ { "INFÉRIEUR OU ÉGAL À EN DEUX LIGNES INCLINÉES","	x (inférieur à sur égal à - 2266)"},
/* 2AFA */ { "SUPÉRIEUR OU ÉGAL À EN DEUX LIGNES INCLINÉES","	x (supérieur à sur égal à - 2267)"},
/* 2AFB */ { "RELATION BINAIRE TRIPLE OBLIQUE","	x (relation binaire triple barre verticale - 2AF4)"},
/* 2AFC */ { "GRAND OPÉRATEUR À TROIS BARRES VERTICALES","	* souvent n-aire\n"
	"	x (relation binaire triple barre verticale - 2AF4)\n"
	"	x (délimiteur triple barre verticale - 2980)"},
/* 2AFD */ { "OPÉRATEUR DOUBLE OBLIQUE","	x (parallèle à - 2225)"},
/* 2AFE */ { "BARRE VERTICALE BLANCHE","	= choix de Dijkstra"},
/* 2AFF */ { "BARRE VERTICALE BLANCHE N-AIRE","	= choix n-aire de Dijkstra"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_2B[] = {
/* 2B00 */ { "FLÈCHE BLANCHE NORD-EST",NULL},
/* 2B01 */ { "FLÈCHE BLANCHE NORD-OUEST",NULL},
/* 2B02 */ { "FLÈCHE BLANCHE SUD-EST",NULL},
/* 2B03 */ { "FLÈCHE BLANCHE SUD-OUEST",NULL},
/* 2B04 */ { "FLÈCHE BLANCHE GAUCHE-DROITE","	x (flèche blanche vers la gauche - 21E6)\n"
	"	x (flèche blanche haut-bas - 21F3)"},
/* 2B05 */ { "FLÈCHE NOIRE VERS LA GAUCHE","	x (flèche vers la droite noire - 27A1)\n"
	"	x (flèche noire vers la droite - 2B95)"},
/* 2B06 */ { "FLÈCHE NOIRE VERS LE HAUT",NULL},
/* 2B07 */ { "FLÈCHE NOIRE VERS LE BAS",NULL},
/* 2B08 */ { "FLÈCHE NOIRE NORD-EST",NULL},
/* 2B09 */ { "FLÈCHE NOIRE NORD-OUEST",NULL},
/* 2B0A */ { "FLÈCHE NOIRE SUD-EST",NULL},
/* 2B0B */ { "FLÈCHE NOIRE SUD-OUEST",NULL},
/* 2B0C */ { "FLÈCHE NOIRE GAUCHE-DROITE",NULL},
/* 2B0D */ { "FLÈCHE NOIRE HAUT-BAS",NULL},
/* 2B0E */ { "FLÈCHE VERS LA DROITE À POINTE PLIÉE VERS LE BAS",NULL},
/* 2B0F */ { "FLÈCHE VERS LA DROITE À POINTE PLIÉE VERS LE HAUT",NULL},
/* 2B10 */ { "FLÈCHE VERS LA GAUCHE À POINTE PLIÉE VERS LE BAS",NULL},
/* 2B11 */ { "FLÈCHE VERS LA GAUCHE À POINTE PLIÉE VERS LE HAUT",NULL},
/* 2B12 */ { "CARRÉ À MOITIÉ SUPÉRIEURE NOIRE","	x (carré à moitié gauche noire - 25E7)"},
/* 2B13 */ { "CARRÉ À MOITIÉ INFÉRIEURE NOIRE",NULL},
/* 2B14 */ { "CARRÉ À MOITIÉ DIAGONALE SUPÉRIEURE DROITE NOIRE",NULL},
/* 2B15 */ { "CARRÉ À MOITIÉ DIAGONALE INFÉRIEURE DROITE NOIRE",NULL},
/* 2B16 */ { "LOSANGE À MOITIÉ GAUCHE NOIRE",NULL},
/* 2B17 */ { "LOSANGE À MOITIÉ DROITE NOIRE",NULL},
/* 2B18 */ { "LOSANGE À MOITIÉ SUPÉRIEURE NOIRE",NULL},
/* 2B19 */ { "LOSANGE À MOITIÉ INFÉRIEURE NOIRE",NULL},
/* 2B1A */ { "CARRÉ POINTILLÉ",NULL},
/* 2B1B */ { "GRAND CARRÉ NOIR","	x (carré noir - 25A0)"},
/* 2B1C */ { "GRAND CARRÉ BLANC","	x (carré blanc - 25A1)"},
/* 2B1D */ { "TRÈS PETIT CARRÉ NOIR","	x (petit carré noir - 25AA)"},
/* 2B1E */ { "TRÈS PETIT CARRÉ BLANC","	x (petit carré blanc - 25AB)"},
/* 2B1F */ { "PENTAGONE NOIR",NULL},
/* 2B20 */ { "PENTAGONE BLANC",NULL},
/* 2B21 */ { "HEXAGONE BLANC",NULL},
/* 2B22 */ { "HEXAGONE NOIR",NULL},
/* 2B23 */ { "HEXAGONE NOIR POSÉ SUR UN CÔTÉ",NULL},
/* 2B24 */ { "GRAND CERCLE NOIR","	x (cercle noir - 25CF)\n"
	"	x (grand cercle - 25EF)\n"
	"	x (grand cercle rouge - 1F534)"},
/* 2B25 */ { "LOSANGE MOYEN NOIR","	x (losange noir - 25C6)"},
/* 2B26 */ { "LOSANGE MOYEN BLANC","	x (losange blanc - 25C7)\n"
	"	x (symbole alchimique du savon - 1F754)"},
/* 2B27 */ { "RHOMBE MOYEN NOIR",NULL},
/* 2B28 */ { "RHOMBE MOYEN BLANC","	x (rhombe - 25CA)"},
/* 2B29 */ { "PETIT LOSANGE NOIR","	x (opérateur losange - 22C4)\n"
	"	x (petit losange orange - 1F538)"},
/* 2B2A */ { "PETIT RHOMBE NOIR",NULL},
/* 2B2B */ { "PETIT RHOMBE BLANC",NULL},
/* 2B2C */ { "ELLIPSE HORIZONTALE NOIRE",NULL},
/* 2B2D */ { "ELLIPSE HORIZONTALE BLANCHE",NULL},
/* 2B2E */ { "ELLIPSE VERTICALE NOIRE",NULL},
/* 2B2F */ { "ELLIPSE VERTICALE BLANCHE",NULL},
/* 2B30 */ { "FLÈCHE VERS LA GAUCHE À PETIT CERCLE","	x (flèche vers la droite à petit cercle - 21F4)"},
/* 2B31 */ { "TROIS FLÈCHES VERS LA GAUCHE","	x (trois flèches vers la droite - 21F6)"},
/* 2B32 */ { "FLÈCHE VERS LA GAUCHE À SIGNE PLUS CERCLÉ","	x (flèche vers la droite à signe plus cerclé - 27F4)"},
/* 2B33 */ { "LONGUE FLÈCHE VERS LA GAUCHE EN TIRE-BOUCHON","	x (longue flèche vers la droite en tire-bouchon - 27FF)\n"
	"	x (flèche vers la gauche en tire-bouchon - 21DC)"},
/* 2B34 */ { "FLÈCHE À DEUX POINTES VERS LA GAUCHE BARRÉE VERTICALEMENT","	x (flèche à deux pointes vers la droite barrée verticalement - 2900)"},
/* 2B35 */ { "FLÈCHE À DEUX POINTES VERS LA GAUCHE BARRÉE DEUX FOIS VERTICALEMENT","	x (flèche à deux pointes vers la droite barrée deux fois verticalement - 2901)"},
/* 2B36 */ { "FLÈCHE À DEUX POINTES D'UN TAQUET VERS LA GAUCHE","	x (flèche à deux pointes d'un taquet vers la droite - 2905)"},
/* 2B37 */ { "FLÈCHE À TROIS TRAITS ET À DEUX TÊTES VERS LA GAUCHE","	x (flèche à trois traits et à deux têtes vers la droite - 2910)"},
/* 2B38 */ { "FLÈCHE VERS LA GAUCHE À FÛT POINTILLÉ","	x (flèche vers la droite à fût pointillé - 2911)"},
/* 2B39 */ { "FLÈCHE EMPENNÉE VERS LA GAUCHE BARRÉE VERTICALEMENT","	x (flèche empennée vers la droite barrée verticalement - 2914)"},
/* 2B3A */ { "FLÈCHE EMPENNÉE VERS LA GAUCHE BARRÉE DEUX FOIS VERTICALEMENT","	x (flèche empennée vers la droite barrée deux fois verticalement - 2915)"},
/* 2B3B */ { "FLÈCHE EMPENNÉE À DEUX POINTES VERS LA GAUCHE","	x (flèche empennée à deux pointes vers la droite - 2916)"},
/* 2B3C */ { "FLÈCHE EMPENNÉE À DEUX POINTES VERS LA GAUCHE BARRÉE VERTICALEMENT","	x (flèche empennée à deux pointes vers la droite barrée verticalement - 2917)"},
/* 2B3D */ { "FLÈCHE EMPENNÉE À DEUX POINTES VERS LA GAUCHE BARRÉE DEUX FOIS VERTICALEMENT","	x (flèche empennée à deux pointes vers la droite barrée deux fois verticalement - 2918)"},
/* 2B3E */ { "FLÈCHE VERS LA GAUCHE À TRAVERS X","	x (flèche vers la droite à travers x - 2947)"},
/* 2B3F */ { "FLÈCHE ONDULÉE POINTANT DIRECTEMENT À GAUCHE","	x (flèche ondulée pointant directement à droite - 2933)\n"
	"	x (flèche vers la gauche ondulée - 219C)"},
/* 2B40 */ { "SIGNE ÉGAL SUR FLÈCHE VERS LA GAUCHE","	x (signe égal sur flèche vers la droite - 2971)"},
/* 2B41 */ { "OPÉRATEUR TILDE RÉFLÉCHI SUR FLÈCHE VERS LA GAUCHE","	* image miroir de « ⥲ »\n"
	"	x (opérateur tilde sur flèche vers la droite - 2972)"},
/* 2B42 */ { "FLÈCHE VERS LA GAUCHE SUR PRESQUE ÉGAL À RÉFLÉCHI","	* image miroir de « ⥵ »\n"
	"	x (flèche vers la droite sur presque égal à - 2975)"},
/* 2B43 */ { "FLÈCHE VERS LA DROITE À TRAVERS SUPÉRIEUR À","	* image miroir de « ⥷ »\n"
	"	x (flèche vers la gauche à travers inférieur à - 2977)"},
/* 2B44 */ { "FLÈCHE VERS LA DROITE À TRAVERS SUR-ENSEMBLE","	* image miroir de « ⥺ »\n"
	"	x (flèche vers la gauche à travers sous-ensemble - 297A)"},
/* 2B45 */ { "QUADRUPLE FLÈCHE VERS LA GAUCHE","	x (quadruple flèche vers le haut - 27F0)"},
/* 2B46 */ { "QUADRUPLE FLÈCHE VERS LA DROITE",NULL},
/* 2B47 */ { "OPÉRATEUR TILDE RÉFLÉCHI SUR FLÈCHE VERS LA DROITE",NULL},
/* 2B48 */ { "FLÈCHE VERS LA DROITE SUR PRESQUE ÉGAL À RÉFLÉCHI",NULL},
/* 2B49 */ { "OPÉRATEUR TILDE SUR FLÈCHE VERS LA GAUCHE",NULL},
/* 2B4A */ { "FLÈCHE VERS LA GAUCHE SUR PRESQUE ÉGAL À",NULL},
/* 2B4B */ { "FLÈCHE VERS LA GAUCHE SUR OPÉRATEUR TILDE RÉFLÉCHI","	* image miroir de « ⥴ »\n"
	"	x (flèche vers la droite sur opérateur tilde - 2974)"},
/* 2B4C */ { "FLÈCHE VERS LA DROITE SUR OPÉRATEUR TILDE RÉFLÉCHI","	* image miroir de « ⥳ »\n"
	"	x (flèche vers la gauche sur opérateur tilde - 2973)"},
/* 2B4D */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE BAS EN ZIGZAG","	x (flèche vers le bas en zigzag - 21AF)"},
/* 2B4E */ { "FLÈCHE COURTE NORD INCLINÉE",NULL},
/* 2B4F */ { "FLÈCHE COURTE SUD INCLINÉE EN ARRIÈRE",NULL},
/* 2B50 */ { "ÉTOILE MOYENNE BLANCHE","	x (étoile blanche - 2606)"},
/* 2B51 */ { "PETITE ÉTOILE NOIRE","	x (étoile à cinq branches arabe - 066D)\n"
	"	x (opérateur étoile - 22C6)\n"
	"	x (étoile noire - 2605)"},
/* 2B52 */ { "PETITE ÉTOILE BLANCHE",NULL},
/* 2B53 */ { "PENTAGONE NOIR POINTANT VERS LA DROITE",NULL},
/* 2B54 */ { "PENTAGONE BLANC POINTANT VERS LA DROITE",NULL},
/* 2B55 */ { "GRAND CERCLE ÉPAIS","	= symbole de base pour les limitations de vitesse\n"
	"	x (grand cercle - 25EF)"},
/* 2B56 */ { "OVALE ÉPAIS AVEC OVALE INSCRIT","	= office préfectoral"},
/* 2B57 */ { "CERCLE ÉPAIS AVEC CERCLE INSCRIT","	= office municipal\n"
	"	x (deux cercles concentriques - 25CE)"},
/* 2B58 */ { "CERCLE ÉPAIS","	= office villageois\n"
	"	= symbole de mise en marche\n"
	"	x (symbole mise en marche - 23FD)\n"
	"	x (cercle blanc - 25CB)"},
/* 2B59 */ { "SAUTOIR CERCLÉ ÉPAIS","	= bureau de police\n"
	"	x (opérateur de multiplication n-aire cerclé - 2A02)"},
/* 2B5A */ { "FLÈCHE NORD INCLINÉE À TÊTE EN CROCHET",NULL},
/* 2B5B */ { "FLÈCHE SUD INCLINÉE EN ARRIÈRE À TALON EN CROCHET",NULL},
/* 2B5C */ { "FLÈCHE NORD INCLINÉE À TALON HORIZONTAL",NULL},
/* 2B5D */ { "FLÈCHE SUD INCLINÉE EN ARRIÈRE À TALON HORIZONTAL",NULL},
/* 2B5E */ { "FLÈCHE COUDÉE POINTANT VERS LE BAS PUIS AU NORD-EST",NULL},
/* 2B5F */ { "FLÈCHE COURTE COUDÉE POINTANT VERS LE BAS PUIS AU NORD-EST",NULL},
/* 2B60 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA GAUCHE","	x (flèche vers la gauche - 2190)"},
/* 2B61 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE HAUT","	x (flèche vers le haut - 2191)"},
/* 2B62 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA DROITE","	x (flèche vers la droite - 2192)\n"
	"	x (flèche vers la droite à pointe en triangle - 279D)"},
/* 2B63 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE BAS","	x (flèche vers le bas - 2193)"},
/* 2B64 */ { "FLÈCHE GAUCHE-DROITE À POINTES EN TRIANGLE","	x (flèche gauche-droite - 2194)"},
/* 2B65 */ { "FLÈCHE HAUT-BAS À POINTES EN TRIANGLE","	x (flèche haut-bas - 2195)"},
/* 2B66 */ { "FLÈCHE À POINTE EN TRIANGLE NORD-OUEST","	x (flèche nord-ouest - 2196)"},
/* 2B67 */ { "FLÈCHE À POINTE EN TRIANGLE NORD-EST","	x (flèche nord-est - 2197)"},
/* 2B68 */ { "FLÈCHE À POINTE EN TRIANGLE SUD-EST","	x (flèche sud-est - 2198)"},
/* 2B69 */ { "FLÈCHE À POINTE EN TRIANGLE SUD-OUEST","	x (flèche sud-ouest - 2199)"},
/* 2B6A */ { "FLÈCHE À TRAITS DISCONTINUS À POINTE EN TRIANGLE VERS LA GAUCHE","	x (flèche à traits discontinus vers la gauche - 21E0)"},
/* 2B6B */ { "FLÈCHE À TRAITS DISCONTINUS À POINTE EN TRIANGLE VERS LE HAUT","	x (flèche à traits discontinus vers le haut - 21E1)"},
/* 2B6C */ { "FLÈCHE À TRAITS DISCONTINUS À POINTE EN TRIANGLE VERS LA DROITE","	x (flèche à traits discontinus vers la droite - 21E2)"},
/* 2B6D */ { "FLÈCHE À TRAITS DISCONTINUS À POINTE EN TRIANGLE VERS LE BAS","	x (flèche à traits discontinus vers le bas - 21E3)"},
/* 2B6E */ { "FLÈCHE CIRCULAIRE OUVERTE À POINTE EN TRIANGLE SENS HORAIRE","	x (flèche circulaire ouverte sens horaire - 21BB)"},
/* 2B6F */ { "FLÈCHE CIRCULAIRE OUVERTE À POINTE EN TRIANGLE SENS ANTIHORAIRE","	x (flèche circulaire ouverte sens antihoraire - 21BA)"},
/* 2B70 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA GAUCHE JUSQU'À UN TAQUET","	= tabulation arrière\n"
	"	x (flèche vers la gauche jusqu'à un taquet - 21E4)"},
/* 2B71 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE HAUT JUSQU'À UN TAQUET","	= tabulation vers le haut\n"
	"	x (flèche vers le haut jusqu'à un taquet - 2912)"},
/* 2B72 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA DROITE JUSQU'À UN TAQUET","	= tabulation\n"
	"	x (flèche vers la droite jusqu'à un taquet - 21E5)"},
/* 2B73 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE BAS JUSQU'À UN TAQUET","	= tabulation vers le bas\n"
	"	x (flèche vers le bas jusqu'à un taquet - 2913)"},
/* 2B74 */ { NULL,NULL},
/* 2B75 */ { NULL,NULL},
/* 2B76 */ { "FLÈCHE À POINTE EN TRIANGLE NORD-OUEST JUSQU'À UN TAQUET","	= début"},
/* 2B77 */ { "FLÈCHE À POINTE EN TRIANGLE NORD-EST JUSQU'À UN TAQUET",NULL},
/* 2B78 */ { "FLÈCHE À POINTE EN TRIANGLE SUD-EST JUSQU'À UN TAQUET","	= fin"},
/* 2B79 */ { "FLÈCHE À POINTE EN TRIANGLE SUD-OUEST JUSQU'À UN TAQUET",NULL},
/* 2B7A */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA GAUCHE À DOUBLE TRAIT VERTICAL","	* l'appellation anglaise de ce caractère est erronée"},
/* 2B7B */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE HAUT À DOUBLE TRAIT HORIZONTAL","	= page précédente"},
/* 2B7C */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA DROITE À DOUBLE TRAIT VERTICAL","	* l'appellation anglaise de ce caractère est erronée"},
/* 2B7D */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE BAS À DOUBLE TRAIT HORIZONTAL","	= page suivante"},
/* 2B7E */ { "TOUCHE DE TABULATION HORIZONTALE","	x (flèche vers la gauche jusqu'à un taquet sur flèche vers la droite jusqu'à un taquet - 21B9)"},
/* 2B7F */ { "TOUCHE DE TABULATION VERTICALE",NULL},
/* 2B80 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA GAUCHE SUR UNE FLÈCHE À POINTE EN TRIANGLE VERS LA DROITE","	x (flèche vers la gauche sur flèche vers la droite - 21C6)"},
/* 2B81 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE HAUT À GAUCHE D'UNE FLÈCHE À POINTE EN TRIANGLE VERS LE BAS",NULL},
/* 2B82 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LA DROITE SUR UNE FLÈCHE À POINTE EN TRIANGLE VERS LA GAUCHE",NULL},
/* 2B83 */ { "FLÈCHE À POINTE EN TRIANGLE VERS LE BAS À GAUCHE D'UNE FLÈCHE À POINTE EN TRIANGLE VERS LE HAUT","	x (flèche vers le bas à gauche d'une flèche vers le haut - 21F5)"},
/* 2B84 */ { "PAIRE DE FLÈCHES À POINTE EN TRIANGLE VERS LA GAUCHE","	x (paire de flèches vers la gauche - 21C7)"},
/* 2B85 */ { "PAIRE DE FLÈCHES À POINTE EN TRIANGLE VERS LE HAUT","	x (paire de flèches vers le haut - 21C8)"},
/* 2B86 */ { "PAIRE DE FLÈCHES À POINTE EN TRIANGLE VERS LA DROITE","	x (paire de flèches vers la droite - 21C9)"},
/* 2B87 */ { "PAIRE DE FLÈCHES À POINTE EN TRIANGLE VERS LE BAS","	x (paire de flèches vers le bas - 21CA)"},
/* 2B88 */ { "FLÈCHE BLANCHE CERCLÉE DE NOIR VERS LA GAUCHE",NULL},
/* 2B89 */ { "FLÈCHE BLANCHE CERCLÉE DE NOIR VERS LE HAUT",NULL},
/* 2B8A */ { "FLÈCHE BLANCHE CERCLÉE DE NOIR VERS LA DROITE","	x (flèche blanche épaisse vers la droite à contour circulaire - 27B2)"},
/* 2B8B */ { "FLÈCHE BLANCHE CERCLÉE DE NOIR VERS LE BAS",NULL},
/* 2B8C */ { "FLÈCHE EN U À DROITE À POINTE EN TRIANGLE SENS ANTIHORAIRE",NULL},
/* 2B8D */ { "FLÈCHE EN U EN BAS À POINTE EN TRIANGLE SENS ANTIHORAIRE",NULL},
/* 2B8E */ { "FLÈCHE EN U À GAUCHE À POINTE EN TRIANGLE SENS ANTIHORAIRE",NULL},
/* 2B8F */ { "FLÈCHE EN U EN HAUT À POINTE EN TRIANGLE SENS ANTIHORAIRE","	x (flèche semi-circulaire sens antihoraire en chef - 21B6)"},
/* 2B90 */ { "RETOUR DE CHARIOT À GAUCHE","	x (symbole retour de chariot - 23CE)"},
/* 2B91 */ { "RETOUR DE CHARIOT À DROITE",NULL},
/* 2B92 */ { "NOUVELLE LIGNE À GAUCHE",NULL},
/* 2B93 */ { "NOUVELLE LIGNE À DROITE",NULL},
/* 2B94 */ { "QUATRE FLÈCHES EN COIN TOURNANT EN SENS ANTIHORAIRE","	= boucle"},
/* 2B95 */ { "FLÈCHE NOIRE VERS LA DROITE","	x (flèche vers la droite noire - 27A1)\n"
	"	x (flèche noire vers la gauche - 2B05)"},
/* 2B96 */ { NULL,NULL},
/* 2B97 */ { NULL,NULL},
/* 2B98 */ { "POINTE DE FLÈCHE ÉQUILATÉRALE VERS LA GAUCHE EN TROMPE-L'ŒIL ÉCLAIRÉE PAR LE HAUT",NULL},
/* 2B99 */ { "POINTE DE FLÈCHE ÉQUILATÉRALE VERS LE HAUT EN TROMPE-L'ŒIL ÉCLAIRÉE PAR LA DROITE",NULL},
/* 2B9A */ { "POINTE DE FLÈCHE ÉQUILATÉRALE VERS LA DROITE EN TROMPE-L'ŒIL ÉCLAIRÉE PAR LE HAUT","	x (pointe de flèche vers la droite en trompe-l'œil éclairée par le haut - 27A2)"},
/* 2B9B */ { "POINTE DE FLÈCHE ÉQUILATÉRALE VERS LE BAS EN TROMPE-L'ŒIL ÉCLAIRÉE PAR LA GAUCHE",NULL},
/* 2B9C */ { "POINTE DE FLÈCHE ÉQUILATÉRALE NOIRE VERS LA GAUCHE",NULL},
/* 2B9D */ { "POINTE DE FLÈCHE ÉQUILATÉRALE NOIRE VERS LE HAUT",NULL},
/* 2B9E */ { "POINTE DE FLÈCHE ÉQUILATÉRALE NOIRE VERS LA DROITE","	x (pointe de flèche noire vers la droite - 27A4)"},
/* 2B9F */ { "POINTE DE FLÈCHE ÉQUILATÉRALE NOIRE VERS LE BAS",NULL},
/* 2BA0 */ { "FLÈCHE VERS LE BAS À POINTE LONGUE EN TRIANGLE VERS LA GAUCHE","	x (flèche vers le bas avec pointe vers la gauche - 21B2)"},
/* 2BA1 */ { "FLÈCHE VERS LE BAS À POINTE LONGUE EN TRIANGLE VERS LA DROITE","	x (flèche vers le bas avec pointe vers la droite - 21B3)"},
/* 2BA2 */ { "FLÈCHE VERS LE HAUT À POINTE LONGUE EN TRIANGLE VERS LA GAUCHE","	x (flèche vers le haut avec pointe vers la gauche - 21B0)"},
/* 2BA3 */ { "FLÈCHE VERS LE HAUT À POINTE LONGUE EN TRIANGLE VERS LA DROITE","	x (flèche vers le haut avec pointe vers la droite - 21B1)"},
/* 2BA4 */ { "FLÈCHE VERS LA GAUCHE À POINTE LONGUE EN TRIANGLE VERS LE HAUT","	x (flèche vers la gauche à pointe pliée vers le haut - 2B11)"},
/* 2BA5 */ { "FLÈCHE VERS LA DROITE À POINTE LONGUE EN TRIANGLE VERS LE HAUT","	x (flèche vers la droite à pointe pliée vers le haut - 2B0F)"},
/* 2BA6 */ { "FLÈCHE VERS LA GAUCHE À POINTE LONGUE EN TRIANGLE VERS LE BAS","	x (flèche vers la gauche à pointe pliée vers le bas - 2B10)"},
/* 2BA7 */ { "FLÈCHE VERS LA DROITE À POINTE LONGUE EN TRIANGLE VERS LE BAS","	x (flèche vers la droite à pointe pliée vers le bas - 2B0E)"},
/* 2BA8 */ { "FLÈCHE NOIRE COURBÉE VERS LE BAS ET VERS LA GAUCHE",NULL},
/* 2BA9 */ { "FLÈCHE NOIRE COURBÉE VERS LE BAS ET VERS LA DROITE","	x (flèche noire épaisse courbée vers le bas et vers la droite - 27A5)"},
/* 2BAA */ { "FLÈCHE NOIRE COURBÉE VERS LE HAUT ET VERS LA GAUCHE",NULL},
/* 2BAB */ { "FLÈCHE NOIRE COURBÉE VERS LE HAUT ET VERS LA DROITE","	x (flèche noire épaisse courbée vers le haut et vers la droite - 27A6)"},
/* 2BAC */ { "FLÈCHE NOIRE COURBÉE VERS LA GAUCHE ET VERS LE HAUT",NULL},
/* 2BAD */ { "FLÈCHE NOIRE COURBÉE VERS LA DROITE ET VERS LE HAUT",NULL},
/* 2BAE */ { "FLÈCHE NOIRE COURBÉE VERS LA GAUCHE ET VERS LE BAS",NULL},
/* 2BAF */ { "FLÈCHE NOIRE COURBÉE VERS LA DROITE ET VERS LE BAS",NULL},
/* 2BB0 */ { "FLÈCHE EN RUBAN VERS LE BAS ET VERS LA GAUCHE",NULL},
/* 2BB1 */ { "FLÈCHE EN RUBAN VERS LE BAS ET VERS LA DROITE",NULL},
/* 2BB2 */ { "FLÈCHE EN RUBAN VERS LE HAUT ET VERS LA GAUCHE",NULL},
/* 2BB3 */ { "FLÈCHE EN RUBAN VERS LE HAUT ET VERS LA DROITE",NULL},
/* 2BB4 */ { "FLÈCHE EN RUBAN VERS LA GAUCHE ET VERS LE HAUT",NULL},
/* 2BB5 */ { "FLÈCHE EN RUBAN VERS LA DROITE ET VERS LE HAUT",NULL},
/* 2BB6 */ { "FLÈCHE EN RUBAN VERS LA GAUCHE ET VERS LE BAS",NULL},
/* 2BB7 */ { "FLÈCHE EN RUBAN VERS LA DROITE ET VERS LE BAS",NULL},
/* 2BB8 */ { "FLÈCHE BLANCHE D'UN TAQUET VERS LE HAUT BARRÉE HORIZONTALEMENT","	= verrouillage des majuscules\n"
	"	x (flèche blanche vers le haut sur socle et trait horizontal - 21EC)"},
/* 2BB9 */ { "POINTE DE FLÈCHE VERS LE HAUT INSCRITE DANS UNE BOÎTE RECTANGULAIRE","	= échappement\n"
	"	x (symbole de fonction apl quadrat circonflexe - 2353)"},
/* 2BBA */ { NULL,NULL},
/* 2BBB */ { NULL,NULL},
/* 2BBC */ { NULL,NULL},
/* 2BBD */ { "CASE DE BULLETIN MARQUÉE D'UN X FIN","	x (case de bulletin marquée d'un x - 2612)"},
/* 2BBE */ { "X CERCLÉ","	x (multiplié par cerclé - 2297)"},
/* 2BBF */ { "X GRAS CERCLÉ",NULL},
/* 2BC0 */ { "CARRÉ NOIR CENTRÉ",NULL},
/* 2BC1 */ { "LOSANGE NOIR CENTRÉ",NULL},
/* 2BC2 */ { "PENTAGONE NOIR CULBUTÉ",NULL},
/* 2BC3 */ { "OCTOGONE NOIR HORIZONTAL","	x (panneau octogonal - 1F6D1)"},
/* 2BC4 */ { "OCTOGONE NOIR",NULL},
/* 2BC5 */ { "TRIANGLE MOYEN NOIR VERS LE HAUT CENTRÉ","	x (triangle noir pointant vers le haut - 25B2)"},
/* 2BC6 */ { "TRIANGLE MOYEN NOIR VERS LE BAS CENTRÉ","	x (triangle noir pointant vers le bas - 25BC)"},
/* 2BC7 */ { "TRIANGLE MOYEN NOIR VERS LA GAUCHE CENTRÉ","	x (triangle noir pointant vers la gauche - 25C0)"},
/* 2BC8 */ { "TRIANGLE MOYEN NOIR VERS LA DROITE CENTRÉ","	x (triangle noir pointant vers la droite - 25B6)"},
/* 2BC9 */ { NULL,NULL},
/* 2BCA */ { "MOITIÉ SUPÉRIEURE DE CERCLE NOIR",NULL},
/* 2BCB */ { "MOITIÉ INFÉRIEURE DE CERCLE NOIR",NULL},
/* 2BCC */ { "VALVULE FINE À QUATRE BRANCHES NOIRE","	x (étoile à quatre branches noire - 2726)"},
/* 2BCD */ { "VALVULE FINE À QUATRE BRANCHES NOIRE COUCHÉE",NULL},
/* 2BCE */ { "VALVULE À QUATRE BRANCHES BLANCHE","	x (étoile à quatre branches blanche - 2727)"},
/* 2BCF */ { "VALVULE À QUATRE BRANCHES BLANCHE COUCHÉE","	x (pastille carrée - 2311)"},
/* 2BD0 */ { "REPÈRE DE CALAGE CARRÉ","	x (repère de calage - 2316)"},
/* 2BD1 */ { "SIGNE D'INCERTITUDE","	x (symbole de fonction apl quadrat info - 2370)\n"
	"	x (caractère de remplacement - FFFD)"},
/* 2BD2 */ { "MARQUE DE GROUPE","	* utilisée jadis comme un caractère séparateur pour les opérations d'E/S\n"
	"	x (double obèle - 2021)\n"
	"	x (thermodynamique - 29E7)"},
/* 2BD3 */ { NULL,NULL},
/* 2BD4 */ { NULL,NULL},
/* 2BD5 */ { NULL,NULL},
/* 2BD6 */ { NULL,NULL},
/* 2BD7 */ { NULL,NULL},
/* 2BD8 */ { NULL,NULL},
/* 2BD9 */ { NULL,NULL},
/* 2BDA */ { NULL,NULL},
/* 2BDB */ { NULL,NULL},
/* 2BDC */ { NULL,NULL},
/* 2BDD */ { NULL,NULL},
/* 2BDE */ { NULL,NULL},
/* 2BDF */ { NULL,NULL},
/* 2BE0 */ { NULL,NULL},
/* 2BE1 */ { NULL,NULL},
/* 2BE2 */ { NULL,NULL},
/* 2BE3 */ { NULL,NULL},
/* 2BE4 */ { NULL,NULL},
/* 2BE5 */ { NULL,NULL},
/* 2BE6 */ { NULL,NULL},
/* 2BE7 */ { NULL,NULL},
/* 2BE8 */ { NULL,NULL},
/* 2BE9 */ { NULL,NULL},
/* 2BEA */ { NULL,NULL},
/* 2BEB */ { NULL,NULL},
/* 2BEC */ { "FLÈCHE À DEUX POINTES TRIANGULAIRES VERS LA GAUCHE","	= déplacement rapide du curseur vers la gauche\n"
	"	x (flèche à deux pointes vers la gauche - 219E)"},
/* 2BED */ { "FLÈCHE À DEUX POINTES TRIANGULAIRES VERS LE HAUT","	= déplacement rapide du curseur vers le haut"},
/* 2BEE */ { "FLÈCHE À DEUX POINTES TRIANGULAIRES VERS LA DROITE","	= déplacement rapide du curseur vers la droite"},
/* 2BEF */ { "FLÈCHE À DEUX POINTES TRIANGULAIRES VERS LE BAS","	= déplacement rapide du curseur vers le bas"},
/* 2BF0 */ { NULL,NULL},
/* 2BF1 */ { NULL,NULL},
/* 2BF2 */ { NULL,NULL},
/* 2BF3 */ { NULL,NULL},
/* 2BF4 */ { NULL,NULL},
/* 2BF5 */ { NULL,NULL},
/* 2BF6 */ { NULL,NULL},
/* 2BF7 */ { NULL,NULL},
/* 2BF8 */ { NULL,NULL},
/* 2BF9 */ { NULL,NULL},
/* 2BFA */ { NULL,NULL},
/* 2BFB */ { NULL,NULL},
/* 2BFC */ { NULL,NULL},
/* 2BFD */ { NULL,NULL},
/* 2BFE */ { NULL,NULL},
/* 2BFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_2C[] = {
/* 2C00 */ { "LETTRE MAJUSCULE GLAGOLITIQUE AZE",NULL},
/* 2C01 */ { "LETTRE MAJUSCULE GLAGOLITIQUE BOUKI",NULL},
/* 2C02 */ { "LETTRE MAJUSCULE GLAGOLITIQUE VÉDI",NULL},
/* 2C03 */ { "LETTRE MAJUSCULE GLAGOLITIQUE GLAGOL'",NULL},
/* 2C04 */ { "LETTRE MAJUSCULE GLAGOLITIQUE DOBRO",NULL},
/* 2C05 */ { "LETTRE MAJUSCULE GLAGOLITIQUE IÉST'",NULL},
/* 2C06 */ { "LETTRE MAJUSCULE GLAGOLITIQUE JIVÉTÉ",NULL},
/* 2C07 */ { "LETTRE MAJUSCULE GLAGOLITIQUE DZELO",NULL},
/* 2C08 */ { "LETTRE MAJUSCULE GLAGOLITIQUE ZEMLIA",NULL},
/* 2C09 */ { "LETTRE MAJUSCULE GLAGOLITIQUE IJÉ",NULL},
/* 2C0A */ { "LETTRE MAJUSCULE GLAGOLITIQUE IJÉ INITIAL",NULL},
/* 2C0B */ { "LETTRE MAJUSCULE GLAGOLITIQUE I",NULL},
/* 2C0C */ { "LETTRE MAJUSCULE GLAGOLITIQUE DIÉRV'",NULL},
/* 2C0D */ { "LETTRE MAJUSCULE GLAGOLITIQUE KAKO",NULL},
/* 2C0E */ { "LETTRE MAJUSCULE GLAGOLITIQUE LIOUDIÉ",NULL},
/* 2C0F */ { "LETTRE MAJUSCULE GLAGOLITIQUE MYSLÉTÉ",NULL},
/* 2C10 */ { "LETTRE MAJUSCULE GLAGOLITIQUE NACH'",NULL},
/* 2C11 */ { "LETTRE MAJUSCULE GLAGOLITIQUE ONE",NULL},
/* 2C12 */ { "LETTRE MAJUSCULE GLAGOLITIQUE POKOÏ",NULL},
/* 2C13 */ { "LETTRE MAJUSCULE GLAGOLITIQUE RTSY",NULL},
/* 2C14 */ { "LETTRE MAJUSCULE GLAGOLITIQUE SLOVO",NULL},
/* 2C15 */ { "LETTRE MAJUSCULE GLAGOLITIQUE TVERDO",NULL},
/* 2C16 */ { "LETTRE MAJUSCULE GLAGOLITIQUE OUKE",NULL},
/* 2C17 */ { "LETTRE MAJUSCULE GLAGOLITIQUE FERTE",NULL},
/* 2C18 */ { "LETTRE MAJUSCULE GLAGOLITIQUE KHÈRE",NULL},
/* 2C19 */ { "LETTRE MAJUSCULE GLAGOLITIQUE O-TE",NULL},
/* 2C1A */ { "LETTRE MAJUSCULE GLAGOLITIQUE PÉ",NULL},
/* 2C1B */ { "LETTRE MAJUSCULE GLAGOLITIQUE CHTA",NULL},
/* 2C1C */ { "LETTRE MAJUSCULE GLAGOLITIQUE TSY",NULL},
/* 2C1D */ { "LETTRE MAJUSCULE GLAGOLITIQUE TCHERV'",NULL},
/* 2C1E */ { "LETTRE MAJUSCULE GLAGOLITIQUE CHA",NULL},
/* 2C1F */ { "LETTRE MAJUSCULE GLAGOLITIQUE IÈRE",NULL},
/* 2C20 */ { "LETTRE MAJUSCULE GLAGOLITIQUE IÈR'",NULL},
/* 2C21 */ { "LETTRE MAJUSCULE GLAGOLITIQUE IAT'",NULL},
/* 2C22 */ { "LETTRE MAJUSCULE GLAGOLITIQUE KHÈRE SOLAIRE","	= khère arachnéen"},
/* 2C23 */ { "LETTRE MAJUSCULE GLAGOLITIQUE IOU",NULL},
/* 2C24 */ { "LETTRE MAJUSCULE GLAGOLITIQUE PETIT IOUSSE","	= in\n"
	"	* son nasal « in », comme dans « vin »"},
/* 2C25 */ { "LETTRE MAJUSCULE GLAGOLITIQUE PETIT IOUSSE À QUEUE",NULL},
/* 2C26 */ { "LETTRE MAJUSCULE GLAGOLITIQUE IO",NULL},
/* 2C27 */ { "LETTRE MAJUSCULE GLAGOLITIQUE PETIT IOUSSE YODISÉ","	= ien\n"
	"	* son nasal « ien », comme dans « bien »"},
/* 2C28 */ { "LETTRE MAJUSCULE GLAGOLITIQUE GRAND IOUSSE","	= on\n"
	"	* son nasal « on », comme dans « mon »"},
/* 2C29 */ { "LETTRE MAJUSCULE GLAGOLITIQUE GRAND IOUSSE YODISÉ","	= ion\n"
	"	* son nasal « ion », comme dans « réunion »"},
/* 2C2A */ { "LETTRE MAJUSCULE GLAGOLITIQUE FITA",NULL},
/* 2C2B */ { "LETTRE MAJUSCULE GLAGOLITIQUE IJITSA",NULL},
/* 2C2C */ { "LETTRE MAJUSCULE GLAGOLITIQUE CHTAPITCH",NULL},
/* 2C2D */ { "LETTRE MAJUSCULE GLAGOLITIQUE A TROKOUTAST'",NULL},
/* 2C2E */ { "LETTRE MAJUSCULE GLAGOLITIQUE MYSLÉTÉ LATINISANT",NULL},
/* 2C2F */ { NULL,NULL},
/* 2C30 */ { "LETTRE MINUSCULE GLAGOLITIQUE AZE",NULL},
/* 2C31 */ { "LETTRE MINUSCULE GLAGOLITIQUE BOUKI",NULL},
/* 2C32 */ { "LETTRE MINUSCULE GLAGOLITIQUE VÉDI",NULL},
/* 2C33 */ { "LETTRE MINUSCULE GLAGOLITIQUE GLAGOL'",NULL},
/* 2C34 */ { "LETTRE MINUSCULE GLAGOLITIQUE DOBRO",NULL},
/* 2C35 */ { "LETTRE MINUSCULE GLAGOLITIQUE IÉST'",NULL},
/* 2C36 */ { "LETTRE MINUSCULE GLAGOLITIQUE JIVÉTÉ",NULL},
/* 2C37 */ { "LETTRE MINUSCULE GLAGOLITIQUE DZELO",NULL},
/* 2C38 */ { "LETTRE MINUSCULE GLAGOLITIQUE ZEMLIA",NULL},
/* 2C39 */ { "LETTRE MINUSCULE GLAGOLITIQUE IJÉ",NULL},
/* 2C3A */ { "LETTRE MINUSCULE GLAGOLITIQUE IJÉ INITIAL","	x (lettre minuscule cyrillique iota - A647)"},
/* 2C3B */ { "LETTRE MINUSCULE GLAGOLITIQUE I",NULL},
/* 2C3C */ { "LETTRE MINUSCULE GLAGOLITIQUE DIÉRV'",NULL},
/* 2C3D */ { "LETTRE MINUSCULE GLAGOLITIQUE KAKO",NULL},
/* 2C3E */ { "LETTRE MINUSCULE GLAGOLITIQUE LIOUDIÉ",NULL},
/* 2C3F */ { "LETTRE MINUSCULE GLAGOLITIQUE MYSLÉTÉ",NULL},
/* 2C40 */ { "LETTRE MINUSCULE GLAGOLITIQUE NACH'",NULL},
/* 2C41 */ { "LETTRE MINUSCULE GLAGOLITIQUE ONE",NULL},
/* 2C42 */ { "LETTRE MINUSCULE GLAGOLITIQUE POKOÏ",NULL},
/* 2C43 */ { "LETTRE MINUSCULE GLAGOLITIQUE RTSY",NULL},
/* 2C44 */ { "LETTRE MINUSCULE GLAGOLITIQUE SLOVO",NULL},
/* 2C45 */ { "LETTRE MINUSCULE GLAGOLITIQUE TVERDO",NULL},
/* 2C46 */ { "LETTRE MINUSCULE GLAGOLITIQUE OUKE",NULL},
/* 2C47 */ { "LETTRE MINUSCULE GLAGOLITIQUE FERTE",NULL},
/* 2C48 */ { "LETTRE MINUSCULE GLAGOLITIQUE KHÈRE",NULL},
/* 2C49 */ { "LETTRE MINUSCULE GLAGOLITIQUE O-TE",NULL},
/* 2C4A */ { "LETTRE MINUSCULE GLAGOLITIQUE PÉ",NULL},
/* 2C4B */ { "LETTRE MINUSCULE GLAGOLITIQUE CHTA",NULL},
/* 2C4C */ { "LETTRE MINUSCULE GLAGOLITIQUE TSY",NULL},
/* 2C4D */ { "LETTRE MINUSCULE GLAGOLITIQUE TCHERV'",NULL},
/* 2C4E */ { "LETTRE MINUSCULE GLAGOLITIQUE CHA",NULL},
/* 2C4F */ { "LETTRE MINUSCULE GLAGOLITIQUE IÈRE",NULL},
/* 2C50 */ { "LETTRE MINUSCULE GLAGOLITIQUE IÈR'",NULL},
/* 2C51 */ { "LETTRE MINUSCULE GLAGOLITIQUE IAT'",NULL},
/* 2C52 */ { "LETTRE MINUSCULE GLAGOLITIQUE KHÈRE SOLAIRE",NULL},
/* 2C53 */ { "LETTRE MINUSCULE GLAGOLITIQUE IOU",NULL},
/* 2C54 */ { "LETTRE MINUSCULE GLAGOLITIQUE PETIT IOUSSE",NULL},
/* 2C55 */ { "LETTRE MINUSCULE GLAGOLITIQUE PETIT IOUSSE À QUEUE",NULL},
/* 2C56 */ { "LETTRE MINUSCULE GLAGOLITIQUE IO",NULL},
/* 2C57 */ { "LETTRE MINUSCULE GLAGOLITIQUE PETIT IOUSSE YODISÉ",NULL},
/* 2C58 */ { "LETTRE MINUSCULE GLAGOLITIQUE GRAND IOUSSE",NULL},
/* 2C59 */ { "LETTRE MINUSCULE GLAGOLITIQUE GRAND IOUSSE YODISÉ",NULL},
/* 2C5A */ { "LETTRE MINUSCULE GLAGOLITIQUE FITA",NULL},
/* 2C5B */ { "LETTRE MINUSCULE GLAGOLITIQUE IJITSA",NULL},
/* 2C5C */ { "LETTRE MINUSCULE GLAGOLITIQUE CHTAPITCH",NULL},
/* 2C5D */ { "LETTRE MINUSCULE GLAGOLITIQUE A TROKOUTAST' A",NULL},
/* 2C5E */ { "LETTRE MINUSCULE GLAGOLITIQUE MYSLÉTÉ LATINISANT",NULL},
/* 2C5F */ { NULL,NULL},
/* 2C60 */ { "LETTRE MAJUSCULE LATINE L À DOUBLE BARRE",NULL},
/* 2C61 */ { "LETTRE MINUSCULE LATINE L À DOUBLE BARRE",NULL},
/* 2C62 */ { "LETTRE MAJUSCULE LATINE L TILDE MÉDIAN","	* la minuscule est 026B"},
/* 2C63 */ { "LETTRE MAJUSCULE LATINE P BARRÉ","	* la minuscule est 1D7D"},
/* 2C64 */ { "LETTRE MAJUSCULE LATINE R HAMEÇON RÉTROFLEXE","	* la minuscule est 027D"},
/* 2C65 */ { "LETTRE MINUSCULE LATINE A BARRÉ","	* la majuscule est 023A"},
/* 2C66 */ { "LETTRE MINUSCULE LATINE T BARRÉ DIAGONALEMENT","	* la majuscule est 023E"},
/* 2C67 */ { "LETTRE MAJUSCULE LATINE H CRAMPON",NULL},
/* 2C68 */ { "LETTRE MINUSCULE LATINE H CRAMPON",NULL},
/* 2C69 */ { "LETTRE MAJUSCULE LATINE K CRAMPON",NULL},
/* 2C6A */ { "LETTRE MINUSCULE LATINE K CRAMPON",NULL},
/* 2C6B */ { "LETTRE MAJUSCULE LATINE Z CRAMPON",NULL},
/* 2C6C */ { "LETTRE MINUSCULE LATINE Z CRAMPON",NULL},
/* 2C6D */ { "LETTRE MAJUSCULE LATINE ALPHA","	* la minuscule est 0251"},
/* 2C6E */ { "LETTRE MAJUSCULE LATINE M HAMEÇON","	* la minuscule est 0271"},
/* 2C6F */ { "LETTRE MAJUSCULE LATINE A CULBUTÉ","	* la minuscule est 0250"},
/* 2C70 */ { "LETTRE MAJUSCULE LATINE ALPHA CULBUTÉ","	* la minuscule est 0252"},
/* 2C71 */ { "LETTRE MINUSCULE LATINE V CROSSE À DROITE",NULL},
/* 2C72 */ { "LETTRE MAJUSCULE LATINE W CROSSE",NULL},
/* 2C73 */ { "LETTRE MINUSCULE LATINE W CROSSE",NULL},
/* 2C74 */ { "LETTRE MINUSCULE LATINE V BOUCLÉ",NULL},
/* 2C75 */ { "LETTRE MAJUSCULE LATINE MOITIÉ DE H","	x (lettre majuscule grecque hêta - 0370)\n"
	"	x (majuscule f culbuté - 2132)\n"
	"	x (chiffre romain cent réfléchi - 2183)"},
/* 2C76 */ { "LETTRE MINUSCULE LATINE MOITIÉ DE H","	x (lettre minuscule grecque hêta - 0371)"},
/* 2C77 */ { "LETTRE MINUSCULE LATINE PHI SANS QUEUE","	* o moyen arrondi"},
/* 2C78 */ { "LETTRE MINUSCULE LATINE E À CRAN",NULL},
/* 2C79 */ { "LETTRE MINUSCULE LATINE R HAMEÇON CULBUTÉ",NULL},
/* 2C7A */ { "LETTRE MINUSCULE LATINE O À PETIT ROND INSCRIT",NULL},
/* 2C7B */ { "LETTRE LATINE PETITE CAPITALE E CULBUTÉ",NULL},
/* 2C7C */ { "INDICE LETTRE MINUSCULE LATINE J","	# <souscrite> 006A"},
/* 2C7D */ { "LETTRE MODIFICATIVE MAJUSCULE V","	# <exp> 0056"},
/* 2C7E */ { "LETTRE MAJUSCULE LATINE S À PARAPHE","	* la minuscule est 023F"},
/* 2C7F */ { "LETTRE MAJUSCULE LATINE Z À PARAPHE","	* la minuscule est 0240"},
/* 2C80 */ { "LETTRE MAJUSCULE COPTE ALPHA",NULL},
/* 2C81 */ { "LETTRE MINUSCULE COPTE ALPHA",NULL},
/* 2C82 */ { "LETTRE MAJUSCULE COPTE VITA",NULL},
/* 2C83 */ { "LETTRE MINUSCULE COPTE VITA",NULL},
/* 2C84 */ { "LETTRE MAJUSCULE COPTE GAMMA",NULL},
/* 2C85 */ { "LETTRE MINUSCULE COPTE GAMMA",NULL},
/* 2C86 */ { "LETTRE MAJUSCULE COPTE DELTA",NULL},
/* 2C87 */ { "LETTRE MINUSCULE COPTE DELTA",NULL},
/* 2C88 */ { "LETTRE MAJUSCULE COPTE EI",NULL},
/* 2C89 */ { "LETTRE MINUSCULE COPTE EI",NULL},
/* 2C8A */ { "LETTRE MAJUSCULE COPTE SOU",NULL},
/* 2C8B */ { "LETTRE MINUSCULE COPTE SOU",NULL},
/* 2C8C */ { "LETTRE MAJUSCULE COPTE ZITA",NULL},
/* 2C8D */ { "LETTRE MINUSCULE COPTE ZITA",NULL},
/* 2C8E */ { "LETTRE MAJUSCULE COPTE ITA",NULL},
/* 2C8F */ { "LETTRE MINUSCULE COPTE ITA",NULL},
/* 2C90 */ { "LETTRE MAJUSCULE COPTE THITA",NULL},
/* 2C91 */ { "LETTRE MINUSCULE COPTE THITA",NULL},
/* 2C92 */ { "LETTRE MAJUSCULE COPTE IOTA",NULL},
/* 2C93 */ { "LETTRE MINUSCULE COPTE IOTA",NULL},
/* 2C94 */ { "LETTRE MAJUSCULE COPTE KAPPA",NULL},
/* 2C95 */ { "LETTRE MINUSCULE COPTE KAPPA",NULL},
/* 2C96 */ { "LETTRE MAJUSCULE COPTE LAOULA",NULL},
/* 2C97 */ { "LETTRE MINUSCULE COPTE LAOULA",NULL},
/* 2C98 */ { "LETTRE MAJUSCULE COPTE MI",NULL},
/* 2C99 */ { "LETTRE MINUSCULE COPTE MI",NULL},
/* 2C9A */ { "LETTRE MAJUSCULE COPTE NI",NULL},
/* 2C9B */ { "LETTRE MINUSCULE COPTE NI",NULL},
/* 2C9C */ { "LETTRE MAJUSCULE COPTE KSI",NULL},
/* 2C9D */ { "LETTRE MINUSCULE COPTE KSI",NULL},
/* 2C9E */ { "LETTRE MAJUSCULE COPTE O",NULL},
/* 2C9F */ { "LETTRE MINUSCULE COPTE O",NULL},
/* 2CA0 */ { "LETTRE MAJUSCULE COPTE PI",NULL},
/* 2CA1 */ { "LETTRE MINUSCULE COPTE PI",NULL},
/* 2CA2 */ { "LETTRE MAJUSCULE COPTE RHÔ",NULL},
/* 2CA3 */ { "LETTRE MINUSCULE COPTE RHÔ",NULL},
/* 2CA4 */ { "LETTRE MAJUSCULE COPTE SIMA",NULL},
/* 2CA5 */ { "LETTRE MINUSCULE COPTE SIMA",NULL},
/* 2CA6 */ { "LETTRE MAJUSCULE COPTE TAU",NULL},
/* 2CA7 */ { "LETTRE MINUSCULE COPTE TAU",NULL},
/* 2CA8 */ { "LETTRE MAJUSCULE COPTE HEI",NULL},
/* 2CA9 */ { "LETTRE MINUSCULE COPTE HEI",NULL},
/* 2CAA */ { "LETTRE MAJUSCULE COPTE PHI",NULL},
/* 2CAB */ { "LETTRE MINUSCULE COPTE PHI",NULL},
/* 2CAC */ { "LETTRE MAJUSCULE COPTE KHI",NULL},
/* 2CAD */ { "LETTRE MINUSCULE COPTE KHI",NULL},
/* 2CAE */ { "LETTRE MAJUSCULE COPTE PSI",NULL},
/* 2CAF */ { "LETTRE MINUSCULE COPTE PSI",NULL},
/* 2CB0 */ { "LETTRE MAJUSCULE COPTE Ô",NULL},
/* 2CB1 */ { "LETTRE MINUSCULE COPTE Ô",NULL},
/* 2CB2 */ { "LETTRE MAJUSCULE COPTE DIALECTE-P ALEF",NULL},
/* 2CB3 */ { "LETTRE MINUSCULE COPTE DIALECTE-P ALEF",NULL},
/* 2CB4 */ { "LETTRE MAJUSCULE VIEUX COPTE 'AÏN",NULL},
/* 2CB5 */ { "LETTRE MINUSCULE VIEUX COPTE 'AÏN",NULL},
/* 2CB6 */ { "LETTRE MAJUSCULE COPTE CRYPTOGRAPHIQUE EI",NULL},
/* 2CB7 */ { "LETTRE MINUSCULE COPTE CRYPTOGRAPHIQUE EI",NULL},
/* 2CB8 */ { "LETTRE MAJUSCULE COPTE DIALECTE-P KAPPA",NULL},
/* 2CB9 */ { "LETTRE MINUSCULE COPTE DIALECTE-P KAPPA",NULL},
/* 2CBA */ { "LETTRE MAJUSCULE COPTE DIALECTE-P NI","	= nu en tiret"},
/* 2CBB */ { "LETTRE MINUSCULE COPTE DIALECTE-P NI",NULL},
/* 2CBC */ { "LETTRE MAJUSCULE COPTE CRYPTOGRAPHIQUE NI",NULL},
/* 2CBD */ { "LETTRE MINUSCULE COPTE CRYPTOGRAPHIQUE NI",NULL},
/* 2CBE */ { "LETTRE MAJUSCULE VIEUX COPTE Ô",NULL},
/* 2CBF */ { "LETTRE MINUSCULE VIEUX COPTE Ô",NULL},
/* 2CC0 */ { "LETTRE MAJUSCULE COPTE SAMPI",NULL},
/* 2CC1 */ { "LETTRE MINUSCULE COPTE SAMPI",NULL},
/* 2CC2 */ { "LETTRE MAJUSCULE COPTE CHAÏ À CROIX",NULL},
/* 2CC3 */ { "LETTRE MINUSCULE COPTE CHAÏ À CROIX",NULL},
/* 2CC4 */ { "LETTRE MAJUSCULE VIEUX COPTE CHAÏ",NULL},
/* 2CC5 */ { "LETTRE MINUSCULE VIEUX COPTE CHAÏ",NULL},
/* 2CC6 */ { "LETTRE MAJUSCULE VIEUX COPTE ECH","	= barre de fraction"},
/* 2CC7 */ { "LETTRE MINUSCULE VIEUX COPTE ECH",NULL},
/* 2CC8 */ { "LETTRE MAJUSCULE COPTE AKHMÎMIQUE KHAÏ",NULL},
/* 2CC9 */ { "LETTRE MINUSCULE COPTE AKHMÎMIQUE KHAÏ",NULL},
/* 2CCA */ { "LETTRE MAJUSCULE COPTE DIALECTE-P HORI","	= hori barré"},
/* 2CCB */ { "LETTRE MINUSCULE COPTE DIALECTE-P HORI",NULL},
/* 2CCC */ { "LETTRE MAJUSCULE VIEUX COPTE HORI",NULL},
/* 2CCD */ { "LETTRE MINUSCULE VIEUX COPTE HORI",NULL},
/* 2CCE */ { "LETTRE MAJUSCULE VIEUX COPTE HA",NULL},
/* 2CCF */ { "LETTRE MINUSCULE VIEUX COPTE HA",NULL},
/* 2CD0 */ { "LETTRE MAJUSCULE COPTE HA EN L",NULL},
/* 2CD1 */ { "LETTRE MINUSCULE COPTE HA EN L",NULL},
/* 2CD2 */ { "LETTRE MAJUSCULE VIEUX COPTE HEI",NULL},
/* 2CD3 */ { "LETTRE MINUSCULE VIEUX COPTE HEI",NULL},
/* 2CD4 */ { "LETTRE MAJUSCULE VIEUX COPTE HAT",NULL},
/* 2CD5 */ { "LETTRE MINUSCULE VIEUX COPTE HAT",NULL},
/* 2CD6 */ { "LETTRE MAJUSCULE VIEUX COPTE DJANDJA",NULL},
/* 2CD7 */ { "LETTRE MINUSCULE VIEUX COPTE DJANDJA",NULL},
/* 2CD8 */ { "LETTRE MAJUSCULE VIEUX COPTE DJA",NULL},
/* 2CD9 */ { "LETTRE MINUSCULE VIEUX COPTE DJA",NULL},
/* 2CDA */ { "LETTRE MAJUSCULE VIEUX COPTE TCHIMA","	= triangle divisé"},
/* 2CDB */ { "LETTRE MINUSCULE VIEUX COPTE TCHIMA",NULL},
/* 2CDC */ { "LETTRE MAJUSCULE COPTE VIEUX NUBIEN TCHIMA",NULL},
/* 2CDD */ { "LETTRE MINUSCULE COPTE VIEUX NUBIEN TCHIMA",NULL},
/* 2CDE */ { "LETTRE MAJUSCULE COPTE VIEUX NUBIEN NGI",NULL},
/* 2CDF */ { "LETTRE MINUSCULE COPTE VIEUX NUBIEN NGI",NULL},
/* 2CE0 */ { "LETTRE MAJUSCULE COPTE VIEUX NUBIEN ÑI",NULL},
/* 2CE1 */ { "LETTRE MINUSCULE COPTE VIEUX NUBIEN ÑI",NULL},
/* 2CE2 */ { "LETTRE MAJUSCULE COPTE VIEUX NUBIEN WAU",NULL},
/* 2CE3 */ { "LETTRE MINUSCULE COPTE VIEUX NUBIEN WAU",NULL},
/* 2CE4 */ { "SYMBOLE COPTE KAI","	x (symbole grec kai - 03D7)"},
/* 2CE5 */ { "SYMBOLE COPTE MI RHÔ",NULL},
/* 2CE6 */ { "SYMBOLE COPTE PI RHÔ",NULL},
/* 2CE7 */ { "SYMBOLE COPTE STAUROS","	* abréviation de croix"},
/* 2CE8 */ { "SYMBOLE COPTE TAU RHÔ","	x (symbole grec tau rhô - 101A0)"},
/* 2CE9 */ { "SYMBOLE COPTE KHI RHÔ","	x (chrisme - 2627)"},
/* 2CEA */ { "SYMBOLE COPTE TCHIMA SIMA","	* abréviation de Seigneur (« tchoïs »), habituellement surmontée de la barre de contraction"},
/* 2CEB */ { "LETTRE MAJUSCULE COPTE CRYPTOGRAPHIQUE CHAÏ",NULL},
/* 2CEC */ { "LETTRE MINUSCULE COPTE CRYPTOGRAPHIQUE CHAÏ",NULL},
/* 2CED */ { "LETTRE MAJUSCULE COPTE CRYPTOGRAPHIQUE DJANDJA",NULL},
/* 2CEE */ { "LETTRE MINUSCULE COPTE CRYPTOGRAPHIQUE DJANDJA",NULL},
/* 2CEF */ { "DIACRITIQUE COPTE NI SUSCRIT","	* ce signe est utilisé en position finale et s'étend au-dessus du caractère suivant (généralement une espace)"},
/* 2CF0 */ { "DIACRITIQUE COPTE ESPRIT RUDE","	x (diacritique virgule réfléchie en chef - 0314)\n"
	"	x (diacritique cyrillique dasia pneumata - 0485)"},
/* 2CF1 */ { "DIACRITIQUE COPTE ESPRIT DOUX","	x (diacritique virgule en chef - 0313)\n"
	"	x (diacritique cyrillique psili pneumata - 0486)"},
/* 2CF2 */ { "LETTRE MAJUSCULE COPTE BOHAÏRIQUE KHAÏ","	x (lettre majuscule copte khaï - 03E6)"},
/* 2CF3 */ { "LETTRE MINUSCULE COPTE BOHAÏRIQUE KHAÏ","	x (lettre minuscule copte khaï - 03E7)"},
/* 2CF4 */ { NULL,NULL},
/* 2CF5 */ { NULL,NULL},
/* 2CF6 */ { NULL,NULL},
/* 2CF7 */ { NULL,NULL},
/* 2CF8 */ { NULL,NULL},
/* 2CF9 */ { "POINT COPTE VIEUX NUBIEN",NULL},
/* 2CFA */ { "POINT D'INTERROGATION DIRECTE COPTE VIEUX NUBIEN",NULL},
/* 2CFB */ { "POINT D'INTERROGATION INDIRECTE COPTE VIEUX NUBIEN",NULL},
/* 2CFC */ { "DIVISEUR DE VERS COPTE VIEUX NUBIEN",NULL},
/* 2CFD */ { "FRACTION COPTE UN DEMI",NULL},
/* 2CFE */ { "POINT COPTE",NULL},
/* 2CFF */ { "DIVISEUR MORPHOLOGIQUE COPTE",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_2D[] = {
/* 2D00 */ { "LETTRE GÉORGIENNE NOUSKHOURI AN",NULL},
/* 2D01 */ { "LETTRE GÉORGIENNE NOUSKHOURI BAN",NULL},
/* 2D02 */ { "LETTRE GÉORGIENNE NOUSKHOURI GAN",NULL},
/* 2D03 */ { "LETTRE GÉORGIENNE NOUSKHOURI DON",NULL},
/* 2D04 */ { "LETTRE GÉORGIENNE NOUSKHOURI ÈN",NULL},
/* 2D05 */ { "LETTRE GÉORGIENNE NOUSKHOURI VIN",NULL},
/* 2D06 */ { "LETTRE GÉORGIENNE NOUSKHOURI ZÉN",NULL},
/* 2D07 */ { "LETTRE GÉORGIENNE NOUSKHOURI THAN",NULL},
/* 2D08 */ { "LETTRE GÉORGIENNE NOUSKHOURI IN",NULL},
/* 2D09 */ { "LETTRE GÉORGIENNE NOUSKHOURI K'AN",NULL},
/* 2D0A */ { "LETTRE GÉORGIENNE NOUSKHOURI LASS",NULL},
/* 2D0B */ { "LETTRE GÉORGIENNE NOUSKHOURI MAN",NULL},
/* 2D0C */ { "LETTRE GÉORGIENNE NOUSKHOURI NAR",NULL},
/* 2D0D */ { "LETTRE GÉORGIENNE NOUSKHOURI ON",NULL},
/* 2D0E */ { "LETTRE GÉORGIENNE NOUSKHOURI P'AR",NULL},
/* 2D0F */ { "LETTRE GÉORGIENNE NOUSKHOURI JAN",NULL},
/* 2D10 */ { "LETTRE GÉORGIENNE NOUSKHOURI RAÉ",NULL},
/* 2D11 */ { "LETTRE GÉORGIENNE NOUSKHOURI SAN",NULL},
/* 2D12 */ { "LETTRE GÉORGIENNE NOUSKHOURI T'AR",NULL},
/* 2D13 */ { "LETTRE GÉORGIENNE NOUSKHOURI OUN",NULL},
/* 2D14 */ { "LETTRE GÉORGIENNE NOUSKHOURI PHAR",NULL},
/* 2D15 */ { "LETTRE GÉORGIENNE NOUSKHOURI KHAR",NULL},
/* 2D16 */ { "LETTRE GÉORGIENNE NOUSKHOURI GHAN",NULL},
/* 2D17 */ { "LETTRE GÉORGIENNE NOUSKHOURI Q'AR",NULL},
/* 2D18 */ { "LETTRE GÉORGIENNE NOUSKHOURI CHIN",NULL},
/* 2D19 */ { "LETTRE GÉORGIENNE NOUSKHOURI TCHIN",NULL},
/* 2D1A */ { "LETTRE GÉORGIENNE NOUSKHOURI TSIN",NULL},
/* 2D1B */ { "LETTRE GÉORGIENNE NOUSKHOURI DZIL",NULL},
/* 2D1C */ { "LETTRE GÉORGIENNE NOUSKHOURI TS'IL",NULL},
/* 2D1D */ { "LETTRE GÉORGIENNE NOUSKHOURI TCH'AR",NULL},
/* 2D1E */ { "LETTRE GÉORGIENNE NOUSKHOURI KHAN",NULL},
/* 2D1F */ { "LETTRE GÉORGIENNE NOUSKHOURI DJAN",NULL},
/* 2D20 */ { "LETTRE GÉORGIENNE NOUSKHOURI HAÉ",NULL},
/* 2D21 */ { "LETTRE GÉORGIENNE NOUSKHOURI HÉ",NULL},
/* 2D22 */ { "LETTRE GÉORGIENNE NOUSKHOURI IÉ",NULL},
/* 2D23 */ { "LETTRE GÉORGIENNE NOUSKHOURI WIÉ",NULL},
/* 2D24 */ { "LETTRE GÉORGIENNE NOUSKHOURI QAR",NULL},
/* 2D25 */ { "LETTRE GÉORGIENNE NOUSKHOURI HOÉ",NULL},
/* 2D26 */ { NULL,NULL},
/* 2D27 */ { "LETTRE GÉORGIENNE NOUSKHOURI YN",NULL},
/* 2D28 */ { NULL,NULL},
/* 2D29 */ { NULL,NULL},
/* 2D2A */ { NULL,NULL},
/* 2D2B */ { NULL,NULL},
/* 2D2C */ { NULL,NULL},
/* 2D2D */ { "LETTRE GÉORGIENNE NOUSKHOURI AÈN",NULL},
/* 2D2E */ { NULL,NULL},
/* 2D2F */ { NULL,NULL},
/* 2D30 */ { "LETTRE TIFINAGHE YA",NULL},
/* 2D31 */ { "LETTRE TIFINAGHE YAB",NULL},
/* 2D32 */ { "LETTRE TIFINAGHE YABH",NULL},
/* 2D33 */ { "LETTRE TIFINAGHE YAG",NULL},
/* 2D34 */ { "LETTRE TIFINAGHE YAGHH",NULL},
/* 2D35 */ { "LETTRE TIFINAGHE YADJ ACADÉMIE BERBÈRE",NULL},
/* 2D36 */ { "LETTRE TIFINAGHE YADJ",NULL},
/* 2D37 */ { "LETTRE TIFINAGHE YAD",NULL},
/* 2D38 */ { "LETTRE TIFINAGHE YADH",NULL},
/* 2D39 */ { "LETTRE TIFINAGHE YADD",NULL},
/* 2D3A */ { "LETTRE TIFINAGHE YADDH",NULL},
/* 2D3B */ { "LETTRE TIFINAGHE YEY",NULL},
/* 2D3C */ { "LETTRE TIFINAGHE YAF",NULL},
/* 2D3D */ { "LETTRE TIFINAGHE YAK",NULL},
/* 2D3E */ { "LETTRE TIFINAGHE YAK TOUAREG",NULL},
/* 2D3F */ { "LETTRE TIFINAGHE YAKHH",NULL},
/* 2D40 */ { "LETTRE TIFINAGHE YAH","	= yab touareg"},
/* 2D41 */ { "LETTRE TIFINAGHE YAH ACADÉMIE BERBÈRE",NULL},
/* 2D42 */ { "LETTRE TIFINAGHE YAH TOUAREG",NULL},
/* 2D43 */ { "LETTRE TIFINAGHE YAHH",NULL},
/* 2D44 */ { "LETTRE TIFINAGHE YA'",NULL},
/* 2D45 */ { "LETTRE TIFINAGHE YAKH",NULL},
/* 2D46 */ { "LETTRE TIFINAGHE YAKH TOUAREG",NULL},
/* 2D47 */ { "LETTRE TIFINAGHE YAQ",NULL},
/* 2D48 */ { "LETTRE TIFINAGHE YAQ TOUAREG",NULL},
/* 2D49 */ { "LETTRE TIFINAGHE YI",NULL},
/* 2D4A */ { "LETTRE TIFINAGHE YAJ",NULL},
/* 2D4B */ { "LETTRE TIFINAGHE YAJ DE L'AHAGGAR",NULL},
/* 2D4C */ { "LETTRE TIFINAGHE YAJ TOUAREG",NULL},
/* 2D4D */ { "LETTRE TIFINAGHE YAL",NULL},
/* 2D4E */ { "LETTRE TIFINAGHE YAM",NULL},
/* 2D4F */ { "LETTRE TIFINAGHE YAN",NULL},
/* 2D50 */ { "LETTRE TIFINAGHE YAGN TOUAREG",NULL},
/* 2D51 */ { "LETTRE TIFINAGHE YANG TOUAREG",NULL},
/* 2D52 */ { "LETTRE TIFINAGHE YAP",NULL},
/* 2D53 */ { "LETTRE TIFINAGHE YOU","	= yaw touareg"},
/* 2D54 */ { "LETTRE TIFINAGHE YAR",NULL},
/* 2D55 */ { "LETTRE TIFINAGHE YARR",NULL},
/* 2D56 */ { "LETTRE TIFINAGHE YAGH",NULL},
/* 2D57 */ { "LETTRE TIFINAGHE YAGH TOUAREG",NULL},
/* 2D58 */ { "LETTRE TIFINAGHE YAGH DE L'AÏR","	= yadj de l'Adrar"},
/* 2D59 */ { "LETTRE TIFINAGHE YAS",NULL},
/* 2D5A */ { "LETTRE TIFINAGHE YASS",NULL},
/* 2D5B */ { "LETTRE TIFINAGHE YACH",NULL},
/* 2D5C */ { "LETTRE TIFINAGHE YAT",NULL},
/* 2D5D */ { "LETTRE TIFINAGHE YATH",NULL},
/* 2D5E */ { "LETTRE TIFINAGHE YATCH",NULL},
/* 2D5F */ { "LETTRE TIFINAGHE YATT",NULL},
/* 2D60 */ { "LETTRE TIFINAGHE YAV",NULL},
/* 2D61 */ { "LETTRE TIFINAGHE YAW",NULL},
/* 2D62 */ { "LETTRE TIFINAGHE YAY",NULL},
/* 2D63 */ { "LETTRE TIFINAGHE YAZ",NULL},
/* 2D64 */ { "LETTRE TIFINAGHE YAZ TAWELLEMET","	= yaz harpon"},
/* 2D65 */ { "LETTRE TIFINAGHE YAZZ",NULL},
/* 2D66 */ { "LETTRE TIFINAGHE YÉ",NULL},
/* 2D67 */ { "LETTRE TIFINAGHE YO",NULL},
/* 2D68 */ { NULL,NULL},
/* 2D69 */ { NULL,NULL},
/* 2D6A */ { NULL,NULL},
/* 2D6B */ { NULL,NULL},
/* 2D6C */ { NULL,NULL},
/* 2D6D */ { NULL,NULL},
/* 2D6E */ { NULL,NULL},
/* 2D6F */ { "LETTRE MODIFICATIVE TIFINAGHE DE LABIALISATION","	= tamatart\n"
	"	# <exp> 2D61"},
/* 2D70 */ { "SÉPARATEUR TIFINAGHE","	= tazarast"},
/* 2D71 */ { NULL,NULL},
/* 2D72 */ { NULL,NULL},
/* 2D73 */ { NULL,NULL},
/* 2D74 */ { NULL,NULL},
/* 2D75 */ { NULL,NULL},
/* 2D76 */ { NULL,NULL},
/* 2D77 */ { NULL,NULL},
/* 2D78 */ { NULL,NULL},
/* 2D79 */ { NULL,NULL},
/* 2D7A */ { NULL,NULL},
/* 2D7B */ { NULL,NULL},
/* 2D7C */ { NULL,NULL},
/* 2D7D */ { NULL,NULL},
/* 2D7E */ { NULL,NULL},
/* 2D7F */ { "LIANT DE CONSONNES TIFINAGHE","	* supprime la voyelle inhérente\n"
	"	* sert à indiquer que le caractère qui le précède et qui le suit forme un groupe biconsonnantique\n"
	"	* la forme choisie est arbitraire, invisible"},
/* 2D80 */ { "SYLLABE ÉTHIOPIENNE LOA",NULL},
/* 2D81 */ { "SYLLABE ÉTHIOPIENNE MOA",NULL},
/* 2D82 */ { "SYLLABE ÉTHIOPIENNE ROA",NULL},
/* 2D83 */ { "SYLLABE ÉTHIOPIENNE SOA",NULL},
/* 2D84 */ { "SYLLABE ÉTHIOPIENNE CHOA",NULL},
/* 2D85 */ { "SYLLABE ÉTHIOPIENNE BOA",NULL},
/* 2D86 */ { "SYLLABE ÉTHIOPIENNE TOA",NULL},
/* 2D87 */ { "SYLLABE ÉTHIOPIENNE TCHOA",NULL},
/* 2D88 */ { "SYLLABE ÉTHIOPIENNE NOA",NULL},
/* 2D89 */ { "SYLLABE ÉTHIOPIENNE ÑOA",NULL},
/* 2D8A */ { "SYLLABE ÉTHIOPIENNE OA GLOTTAL",NULL},
/* 2D8B */ { "SYLLABE ÉTHIOPIENNE ZOA",NULL},
/* 2D8C */ { "SYLLABE ÉTHIOPIENNE DOA",NULL},
/* 2D8D */ { "SYLLABE ÉTHIOPIENNE DDOA",NULL},
/* 2D8E */ { "SYLLABE ÉTHIOPIENNE DJOA",NULL},
/* 2D8F */ { "SYLLABE ÉTHIOPIENNE THOA",NULL},
/* 2D90 */ { "SYLLABE ÉTHIOPIENNE TTCHOA",NULL},
/* 2D91 */ { "SYLLABE ÉTHIOPIENNE PHOA",NULL},
/* 2D92 */ { "SYLLABE ÉTHIOPIENNE POA",NULL},
/* 2D93 */ { "SYLLABE ÉTHIOPIENNE GGWÄ",NULL},
/* 2D94 */ { "SYLLABE ÉTHIOPIENNE GGWI",NULL},
/* 2D95 */ { "SYLLABE ÉTHIOPIENNE GGWÉ",NULL},
/* 2D96 */ { "SYLLABE ÉTHIOPIENNE GGWE",NULL},
/* 2D97 */ { NULL,NULL},
/* 2D98 */ { NULL,NULL},
/* 2D99 */ { NULL,NULL},
/* 2D9A */ { NULL,NULL},
/* 2D9B */ { NULL,NULL},
/* 2D9C */ { NULL,NULL},
/* 2D9D */ { NULL,NULL},
/* 2D9E */ { NULL,NULL},
/* 2D9F */ { NULL,NULL},
/* 2DA0 */ { "SYLLABE ÉTHIOPIENNE SSÄ",NULL},
/* 2DA1 */ { "SYLLABE ÉTHIOPIENNE SSOU",NULL},
/* 2DA2 */ { "SYLLABE ÉTHIOPIENNE SSI",NULL},
/* 2DA3 */ { "SYLLABE ÉTHIOPIENNE SSA",NULL},
/* 2DA4 */ { "SYLLABE ÉTHIOPIENNE SSÉ",NULL},
/* 2DA5 */ { "SYLLABE ÉTHIOPIENNE SSE",NULL},
/* 2DA6 */ { "SYLLABE ÉTHIOPIENNE SSO",NULL},
/* 2DA7 */ { NULL,NULL},
/* 2DA8 */ { "SYLLABE ÉTHIOPIENNE TCHTCHÄ",NULL},
/* 2DA9 */ { "SYLLABE ÉTHIOPIENNE TCHTCHOU",NULL},
/* 2DAA */ { "SYLLABE ÉTHIOPIENNE TCHTCHI",NULL},
/* 2DAB */ { "SYLLABE ÉTHIOPIENNE TCHTCHA",NULL},
/* 2DAC */ { "SYLLABE ÉTHIOPIENNE TCHTCHÉ",NULL},
/* 2DAD */ { "SYLLABE ÉTHIOPIENNE TCHTCHE",NULL},
/* 2DAE */ { "SYLLABE ÉTHIOPIENNE TCHTCHO",NULL},
/* 2DAF */ { NULL,NULL},
/* 2DB0 */ { "SYLLABE ÉTHIOPIENNE ZZÄ",NULL},
/* 2DB1 */ { "SYLLABE ÉTHIOPIENNE ZZOU",NULL},
/* 2DB2 */ { "SYLLABE ÉTHIOPIENNE ZZI",NULL},
/* 2DB3 */ { "SYLLABE ÉTHIOPIENNE ZZA",NULL},
/* 2DB4 */ { "SYLLABE ÉTHIOPIENNE ZZÉ",NULL},
/* 2DB5 */ { "SYLLABE ÉTHIOPIENNE ZZE",NULL},
/* 2DB6 */ { "SYLLABE ÉTHIOPIENNE ZZO",NULL},
/* 2DB7 */ { NULL,NULL},
/* 2DB8 */ { "SYLLABE ÉTHIOPIENNE TTCHTTCHÄ",NULL},
/* 2DB9 */ { "SYLLABE ÉTHIOPIENNE TTCHTTCHOU",NULL},
/* 2DBA */ { "SYLLABE ÉTHIOPIENNE TTCHTTCHI",NULL},
/* 2DBB */ { "SYLLABE ÉTHIOPIENNE TTCHTTCHA",NULL},
/* 2DBC */ { "SYLLABE ÉTHIOPIENNE TTCHTTCHÉ",NULL},
/* 2DBD */ { "SYLLABE ÉTHIOPIENNE TTCHTTCHE",NULL},
/* 2DBE */ { "SYLLABE ÉTHIOPIENNE TTCHTTCHO",NULL},
/* 2DBF */ { NULL,NULL},
/* 2DC0 */ { "SYLLABE ÉTHIOPIENNE QYÄ",NULL},
/* 2DC1 */ { "SYLLABE ÉTHIOPIENNE QYOU",NULL},
/* 2DC2 */ { "SYLLABE ÉTHIOPIENNE QYI",NULL},
/* 2DC3 */ { "SYLLABE ÉTHIOPIENNE QYA",NULL},
/* 2DC4 */ { "SYLLABE ÉTHIOPIENNE QYÉ",NULL},
/* 2DC5 */ { "SYLLABE ÉTHIOPIENNE QYE",NULL},
/* 2DC6 */ { "SYLLABE ÉTHIOPIENNE QYO",NULL},
/* 2DC7 */ { NULL,NULL},
/* 2DC8 */ { "SYLLABE ÉTHIOPIENNE KYÄ",NULL},
/* 2DC9 */ { "SYLLABE ÉTHIOPIENNE KYOU",NULL},
/* 2DCA */ { "SYLLABE ÉTHIOPIENNE KYI",NULL},
/* 2DCB */ { "SYLLABE ÉTHIOPIENNE KYA",NULL},
/* 2DCC */ { "SYLLABE ÉTHIOPIENNE KYÉ",NULL},
/* 2DCD */ { "SYLLABE ÉTHIOPIENNE KYE",NULL},
/* 2DCE */ { "SYLLABE ÉTHIOPIENNE KYO",NULL},
/* 2DCF */ { NULL,NULL},
/* 2DD0 */ { "SYLLABE ÉTHIOPIENNE XYÄ",NULL},
/* 2DD1 */ { "SYLLABE ÉTHIOPIENNE XYOU",NULL},
/* 2DD2 */ { "SYLLABE ÉTHIOPIENNE XYI",NULL},
/* 2DD3 */ { "SYLLABE ÉTHIOPIENNE XYA",NULL},
/* 2DD4 */ { "SYLLABE ÉTHIOPIENNE XYÉ",NULL},
/* 2DD5 */ { "SYLLABE ÉTHIOPIENNE XYE",NULL},
/* 2DD6 */ { "SYLLABE ÉTHIOPIENNE XYO",NULL},
/* 2DD7 */ { NULL,NULL},
/* 2DD8 */ { "SYLLABE ÉTHIOPIENNE GYÄ",NULL},
/* 2DD9 */ { "SYLLABE ÉTHIOPIENNE GYOU",NULL},
/* 2DDA */ { "SYLLABE ÉTHIOPIENNE GYI",NULL},
/* 2DDB */ { "SYLLABE ÉTHIOPIENNE GYA",NULL},
/* 2DDC */ { "SYLLABE ÉTHIOPIENNE GYÉ",NULL},
/* 2DDD */ { "SYLLABE ÉTHIOPIENNE GYE",NULL},
/* 2DDE */ { "SYLLABE ÉTHIOPIENNE GYO",NULL},
/* 2DDF */ { NULL,NULL},
/* 2DE0 */ { "DIACRITIQUE LETTRE CYRILLIQUE BÉ",NULL},
/* 2DE1 */ { "DIACRITIQUE LETTRE CYRILLIQUE VÉ",NULL},
/* 2DE2 */ { "DIACRITIQUE LETTRE CYRILLIQUE GUÉ",NULL},
/* 2DE3 */ { "DIACRITIQUE LETTRE CYRILLIQUE DÉ",NULL},
/* 2DE4 */ { "DIACRITIQUE LETTRE CYRILLIQUE JÉ",NULL},
/* 2DE5 */ { "DIACRITIQUE LETTRE CYRILLIQUE ZÉ",NULL},
/* 2DE6 */ { "DIACRITIQUE LETTRE CYRILLIQUE KA",NULL},
/* 2DE7 */ { "DIACRITIQUE LETTRE CYRILLIQUE ELLE",NULL},
/* 2DE8 */ { "DIACRITIQUE LETTRE CYRILLIQUE EMME","	x (diacritique lettre latine petite capitale m - 1DDF)"},
/* 2DE9 */ { "DIACRITIQUE LETTRE CYRILLIQUE ENNE",NULL},
/* 2DEA */ { "DIACRITIQUE LETTRE CYRILLIQUE O","	x (diacritique lettre minuscule latine o - 0366)"},
/* 2DEB */ { "DIACRITIQUE LETTRE CYRILLIQUE PÉ",NULL},
/* 2DEC */ { "DIACRITIQUE LETTRE CYRILLIQUE ERRE",NULL},
/* 2DED */ { "DIACRITIQUE LETTRE CYRILLIQUE ESSE","	x (diacritique lettre minuscule latine c - 0368)"},
/* 2DEE */ { "DIACRITIQUE LETTRE CYRILLIQUE TÉ",NULL},
/* 2DEF */ { "DIACRITIQUE LETTRE CYRILLIQUE KHA","	x (diacritique lettre minuscule latine x - 036F)"},
/* 2DF0 */ { "DIACRITIQUE LETTRE CYRILLIQUE TSÉ",NULL},
/* 2DF1 */ { "DIACRITIQUE LETTRE CYRILLIQUE TCHÉ",NULL},
/* 2DF2 */ { "DIACRITIQUE LETTRE CYRILLIQUE CHA",NULL},
/* 2DF3 */ { "DIACRITIQUE LETTRE CYRILLIQUE CHTCHA",NULL},
/* 2DF4 */ { "DIACRITIQUE LETTRE CYRILLIQUE FITA",NULL},
/* 2DF5 */ { "DIACRITIQUE LETTRE CYRILLIQUE ESTÉ","	* la représentation recommandée est la séquence 2DED 2DEE"},
/* 2DF6 */ { "DIACRITIQUE LETTRE CYRILLIQUE A","	x (diacritique lettre minuscule latine a - 0363)"},
/* 2DF7 */ { "DIACRITIQUE LETTRE CYRILLIQUE IÉ","	x (diacritique lettre minuscule latine e - 0364)"},
/* 2DF8 */ { "DIACRITIQUE LETTRE CYRILLIQUE DIÉRV",NULL},
/* 2DF9 */ { "DIACRITIQUE LETTRE CYRILLIQUE OUK MONOGRAMME",NULL},
/* 2DFA */ { "DIACRITIQUE LETTRE CYRILLIQUE YATE",NULL},
/* 2DFB */ { "DIACRITIQUE LETTRE CYRILLIQUE YOU",NULL},
/* 2DFC */ { "DIACRITIQUE LETTRE CYRILLIQUE A YODISÉ",NULL},
/* 2DFD */ { "DIACRITIQUE LETTRE CYRILLIQUE PETIT YOUSSE",NULL},
/* 2DFE */ { "DIACRITIQUE LETTRE CYRILLIQUE GRAND YOUSSE",NULL},
/* 2DFF */ { "DIACRITIQUE LETTRE CYRILLIQUE GRAND YOUSSE YODISÉ",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_2E[] = {
/* 2E00 */ { "ANGLET DE SUBSTITUTION","	x (coin nord-ouest - 231C)"},
/* 2E01 */ { "ANGLET DE SUBSTITUTION POINTÉ",NULL},
/* 2E02 */ { "CROCHET DE SUBSTITUTION GAUCHE",NULL},
/* 2E03 */ { "CROCHET DE SUBSTITUTION DROIT",NULL},
/* 2E04 */ { "CROCHET DE SUBSTITUTION GAUCHE POINTÉ",NULL},
/* 2E05 */ { "CROCHET DE SUBSTITUTION DROIT POINTÉ",NULL},
/* 2E06 */ { "SIGNE D'INTERPOLATION ÉLEVÉ","	x (taquet vers le bas - 22A4)"},
/* 2E07 */ { "SIGNE D'INTERPOLATION ÉLEVÉ POINTÉ",NULL},
/* 2E08 */ { "SIGNE DE TRANSPOSITION POINTÉ",NULL},
/* 2E09 */ { "ESSE DE TRANSPOSITION GAUCHE",NULL},
/* 2E0A */ { "ESSE DE TRANSPOSITION DROITE",NULL},
/* 2E0B */ { "CARRÉ ÉLEVÉ","	* s'utilise comme parenthèse d'omission ouvrante surélevée"},
/* 2E0C */ { "OBLIQUE D'OMISSION GAUCHE ÉLEVÉE","	* s'utilise comme parenthèse d'omission ouvrante ou fermante surélevée"},
/* 2E0D */ { "OBLIQUE D'OMISSION DROITE ÉLEVÉE","	* s'utilise comme parenthèse d'omission ouvrante surélevée"},
/* 2E0E */ { "CORONIS ÉDITORIALE","	* connaît de nombreuses variantes de glyphe\n"
	"	* indique la fin d'un poème ou d'une section\n"
	"	x (coronis grecque - 1FBD)"},
/* 2E0F */ { "PARAGRAPHOS","	* changement de locuteur ou de strophe"},
/* 2E10 */ { "PARAGRAPHOS FOURCHU",NULL},
/* 2E11 */ { "PARAGRAPHOS FOURCHU RÉFLÉCHI",NULL},
/* 2E12 */ { "HYPODIASTOLE","	= ypodiastoli"},
/* 2E13 */ { "OBÈLE POINTÉ","	* les variantes de glyphe peuvent ressembler à 00F7 ou à 2238\n"
	"	x (signe moins commercial - 2052)"},
/* 2E14 */ { "ANCORA VERS LE HAUT","	* suppression ou correction au-dessus du signe"},
/* 2E15 */ { "ANCORA VERS LE BAS","	* suppression ou correction en dessous du signe"},
/* 2E16 */ { "CHEVRON POINTANT À DROITE À DEUX POINTS","	= diplê périéstigménê"},
/* 2E17 */ { "TRAIT D'UNION DOUBLE OBLIQUE","	* utilisé dans l'ancienne linguistique du Proche-Orient\n"
	"	* le trait d'union dans les textes gothiques (Fraktur) se code à l'aide de 002D ou de 2010, mais les polices gothiques (Fraktur) afficheront un glyphe similaire à 2E17\n"
	"	x (trait d'union-signe moins - 002D)\n"
	"	x (signe égal - 003D)\n"
	"	x (trait d'union - 2010)\n"
	"	x (trait d'union double - 2E40)"},
/* 2E18 */ { "POINT EXCLARROGATIF CULBUTÉ","	= gnaborretni\n"
	"	x (point exclarrogatif - 203D)"},
/* 2E19 */ { "PALME","	* signe servant de séparateur"},
/* 2E1A */ { "TRAIT D'UNION À TRÉMA","	* indique l'inflexion de la voyelle thématique d'une forme plurielle"},
/* 2E1B */ { "TILDE À CERCLE SUSCRIT","	* indique le changement de casse pour une forme dérivée"},
/* 2E1C */ { "OBLIQUE DE PARAPHRASE OUVRANTE",NULL},
/* 2E1D */ { "OBLIQUE DE PARAPHRASE FERMANTE","	* utilisée en n'ko"},
/* 2E1E */ { "TILDE À POINT SUSCRIT","	* indique que le mot dérivé s'écrit avec une majuscule"},
/* 2E1F */ { "TILDE À POINT SOUSCRIT","	* indique que le mot dérivé s'écrit avec une minuscule"},
/* 2E20 */ { "ÉCHASSE GAUCHE",NULL},
/* 2E21 */ { "ÉCHASSE DROITE",NULL},
/* 2E22 */ { "ANGLET SUPÉRIEUR GAUCHE","	x (plafond à gauche - 2308)\n"
	"	x (coin nord-ouest - 231C)\n"
	"	x (anglet gauche - 300C)"},
/* 2E23 */ { "ANGLET SUPÉRIEUR DROIT",NULL},
/* 2E24 */ { "ANGLET INFÉRIEUR GAUCHE",NULL},
/* 2E25 */ { "ANGLET INFÉRIEUR DROIT",NULL},
/* 2E26 */ { "CRAMPILLON COUCHÉ GAUCHE","	x (sous-ensemble de - 2282)"},
/* 2E27 */ { "CRAMPILLON COUCHÉ DROIT","	x (sur-ensemble de - 2283)"},
/* 2E28 */ { "DOUBLE PARENTHÈSE GAUCHE","	x (parenthèse blanche gauche - 2985)\n"
	"	x (parenthèse blanche gauche pleine chasse - FF5F)"},
/* 2E29 */ { "DOUBLE PARENTHÈSE DROITE",NULL},
/* 2E2A */ { "PONCTUATION DEUX POINTS SUR UN POINT",NULL},
/* 2E2B */ { "PONCTUATION UN POINT SUR DEUX POINTS",NULL},
/* 2E2C */ { "PONCTUATION QUATRE POINTS EN CARRÉ",NULL},
/* 2E2D */ { "SIGNE À CINQ POINTS",NULL},
/* 2E2E */ { "POINT D'INTERROGATION RÉFLÉCHI","	= punctus percontativus\n"
	"	x (point d'interrogation - 003F)\n"
	"	x (point d'interrogation renversé - 00BF)\n"
	"	x (point d'interrogation arabe - 061F)"},
/* 2E2F */ { "TILDE VERTICAL","	* utilisé pour le yérik cyrillique\n"
	"	x (diacritique tilde vertical - 033E)\n"
	"	x (payérok cyrillique - A67F)"},
/* 2E30 */ { "POINT ÉVIDÉ","	* utilisé en avestique\n"
	"	x (opérateur rond - 2218)\n"
	"	x (puce blanche - 25E6)"},
/* 2E31 */ { "POINT MÉDIAN SÉPARATEUR DE MOTS","	* utilisé en avestique, en samaritain, etc.\n"
	"	x (point médian - 00B7)"},
/* 2E32 */ { "VIRGULE CULBUTÉE","	* indique la nasalisation\n"
	"	x (virgule arabe - 060C)"},
/* 2E33 */ { "POINT ÉLEVÉ","	* le glyphe a une position intermédiaire par rapport à celles de 002E et de 00B7\n"
	"	x (point - 002E)\n"
	"	x (point médian - 00B7)"},
/* 2E34 */ { "VIRGULE ÉLEVÉE","	x (virgule - 002C)"},
/* 2E35 */ { "POINT-VIRGULE CULBUTÉ","	x (point-virgule arabe - 061B)"},
/* 2E36 */ { "OBÈLE GARDE GAUCHE",NULL},
/* 2E37 */ { "OBÈLE GARDE DROITE",NULL},
/* 2E38 */ { "OBÈLE CULBUTÉ","	x (obèle - 2020)"},
/* 2E39 */ { "MOITIÉ SUPÉRIEURE DE PARAGRAPHE","	x (paragraphe - 00A7)"},
/* 2E3A */ { "TIRET DOUBLE CADRATIN","	x (tiret cadratin - 2014)"},
/* 2E3B */ { "TIRET TRIPLE CADRATIN",NULL},
/* 2E3C */ { "POINT STÉNOGRAPHIQUE","	x (point - 002E)\n"
	"	x (point syllabe canadienne - 166E)"},
/* 2E3D */ { "SIX-POINTS VERTICAL","	x (quatre-points vertical - 205E)\n"
	"	x (clôture pointillée - 2999)"},
/* 2E3E */ { "LIGNE VERTICALE ONDULÉE","	x (ligne ondulée - 2307)\n"
	"	x (ligne verticale en zigzag - 299A)"},
/* 2E3F */ { "CAPITULE","	* ancêtre du pied-de-mouche\n"
	"	x (pied-de-mouche - 00B6)"},
/* 2E40 */ { "TRAIT D'UNION DOUBLE","	x (signe égal - 003D)\n"
	"	x (trait d'union - 2010)\n"
	"	x (trait d'union double oblique - 2E17)\n"
	"	x (double trait katakana-hiragana - 30A0)\n"
	"	x (lettre modificative signe égal court - A78A)"},
/* 2E41 */ { "VIRGULE RÉFLÉCHIE","	* s'utilise aussi en sindhi\n"
	"	x (virgule - 002C)\n"
	"	x (virgule arabe - 060C)"},
/* 2E42 */ { "GUILLEMET-VIRGULE DOUBLE INFÉRIEUR RÉFLÉCHI","	x (guillemet-virgule double inférieur - 201E)"},
/* 2E43 */ { "TIRET HAMPÉ À GAUCHE",NULL},
/* 2E44 */ { "POINT DE SUSPENSION DOUBLE",NULL},
/* 2E45 */ { "KAVYKA BAS RENVERSÉ",NULL},
/* 2E46 */ { "KAVYKA BAS RENVERSÉ KAVYKA PAR-DESSUS","	x (brève modificative et brève renversée - AB5B)"},
/* 2E47 */ { "KAVYKA BAS","	x (kavyka cyrillique - A67E)"},
/* 2E48 */ { "KAVYKA BAS AVEC POINT",NULL},
/* 2E49 */ { "DEUX VIRGULES SUPERPOSÉES",NULL},
/* 2E4A */ { NULL,NULL},
/* 2E4B */ { NULL,NULL},
/* 2E4C */ { NULL,NULL},
/* 2E4D */ { NULL,NULL},
/* 2E4E */ { NULL,NULL},
/* 2E4F */ { NULL,NULL},
/* 2E50 */ { NULL,NULL},
/* 2E51 */ { NULL,NULL},
/* 2E52 */ { NULL,NULL},
/* 2E53 */ { NULL,NULL},
/* 2E54 */ { NULL,NULL},
/* 2E55 */ { NULL,NULL},
/* 2E56 */ { NULL,NULL},
/* 2E57 */ { NULL,NULL},
/* 2E58 */ { NULL,NULL},
/* 2E59 */ { NULL,NULL},
/* 2E5A */ { NULL,NULL},
/* 2E5B */ { NULL,NULL},
/* 2E5C */ { NULL,NULL},
/* 2E5D */ { NULL,NULL},
/* 2E5E */ { NULL,NULL},
/* 2E5F */ { NULL,NULL},
/* 2E60 */ { NULL,NULL},
/* 2E61 */ { NULL,NULL},
/* 2E62 */ { NULL,NULL},
/* 2E63 */ { NULL,NULL},
/* 2E64 */ { NULL,NULL},
/* 2E65 */ { NULL,NULL},
/* 2E66 */ { NULL,NULL},
/* 2E67 */ { NULL,NULL},
/* 2E68 */ { NULL,NULL},
/* 2E69 */ { NULL,NULL},
/* 2E6A */ { NULL,NULL},
/* 2E6B */ { NULL,NULL},
/* 2E6C */ { NULL,NULL},
/* 2E6D */ { NULL,NULL},
/* 2E6E */ { NULL,NULL},
/* 2E6F */ { NULL,NULL},
/* 2E70 */ { NULL,NULL},
/* 2E71 */ { NULL,NULL},
/* 2E72 */ { NULL,NULL},
/* 2E73 */ { NULL,NULL},
/* 2E74 */ { NULL,NULL},
/* 2E75 */ { NULL,NULL},
/* 2E76 */ { NULL,NULL},
/* 2E77 */ { NULL,NULL},
/* 2E78 */ { NULL,NULL},
/* 2E79 */ { NULL,NULL},
/* 2E7A */ { NULL,NULL},
/* 2E7B */ { NULL,NULL},
/* 2E7C */ { NULL,NULL},
/* 2E7D */ { NULL,NULL},
/* 2E7E */ { NULL,NULL},
/* 2E7F */ { NULL,NULL},
/* 2E80 */ { "CLÉ CJC BIS",NULL},
/* 2E81 */ { "CLÉ CJC FALAISE","	x 5382"},
/* 2E82 */ { "CLÉ CJC DOUBLE CROCHET UN","	x 4E5B"},
/* 2E83 */ { "CLÉ CJC SECOND DEUX","	x 4E5A"},
/* 2E84 */ { "CLÉ CJC SECOND TROIS","	x 4E59"},
/* 2E85 */ { "CLÉ CJC HOMME","	* forme utilisée à gauche\n"
	"	x 4EBB"},
/* 2E86 */ { "CLÉ CJC PLACE","	x 5182"},
/* 2E87 */ { "CLÉ CJC TABOURET","	x 51E0"},
/* 2E88 */ { "CLÉ CJC COUTEAU UN","	* forme utilisée au-dessus\n"
	"	x 5200"},
/* 2E89 */ { "CLÉ CJC COUTEAU DEUX","	* forme utilisée à droite\n"
	"	x 5202"},
/* 2E8A */ { "CLÉ CJC DIVINATION","	* forme utilisée au-dessus\n"
	"	x 535C"},
/* 2E8B */ { "CLÉ CJC SCEAU","	* forme utilisée en dessous\n"
	"	x 353E"},
/* 2E8C */ { "CLÉ CJC PETIT UN","	* forme utilisée au-dessus\n"
	"	x 5C0F"},
/* 2E8D */ { "CLÉ CJC PETIT DEUX","	* forme utilisée au-dessus\n"
	"	x 5C0F"},
/* 2E8E */ { "CLÉ CJC INFIRME UN","	x 5C22"},
/* 2E8F */ { "CLÉ CJC INFIRME DEUX","	x 5C23"},
/* 2E90 */ { "CLÉ CJC INFIRME TROIS","	x 5C22"},
/* 2E91 */ { "CLÉ CJC INFIRME QUATRE","	x 5C23"},
/* 2E92 */ { "CLÉ CJC SIGNE DU SERPENT","	x 5DF3"},
/* 2E93 */ { "CLÉ CJC FIL","	x 5E7A"},
/* 2E94 */ { "CLÉ CJC GROIN UN","	x 5F51"},
/* 2E95 */ { "CLÉ CJC GROIN DEUX","	x 5F50"},
/* 2E96 */ { "CLÉ CJC CŒUR UN","	* forme utilisée à gauche\n"
	"	x 5FC4"},
/* 2E97 */ { "CLÉ CJC CŒUR DEUX","	* forme utilisée en dessous\n"
	"	x 5FC3"},
/* 2E98 */ { "CLÉ CJC MAIN","	* forme utilisée à gauche\n"
	"	x 624C"},
/* 2E99 */ { "CLÉ CJC TAPER","	* forme utilisée à droite\n"
	"	x 6535"},
/* 2E9A */ { NULL,NULL},
/* 2E9B */ { "CLÉ CJC ÉTRANGLER","	x 65E1"},
/* 2E9C */ { "CLÉ CJC SOLEIL","	x 65E5"},
/* 2E9D */ { "CLÉ CJC LUNE","	x 6708"},
/* 2E9E */ { "CLÉ CJC MAUVAIS","	x 6B7A"},
/* 2E9F */ { "CLÉ CJC MÈRE","	# 6BCD"},
/* 2EA0 */ { "CLÉ CJC CIVIL","	x 6C11"},
/* 2EA1 */ { "CLÉ CJC EAU UN","	* forme utilisée à gauche\n"
	"	x 6C35"},
/* 2EA2 */ { "CLÉ CJC EAU DEUX","	* forme utilisée (rarement) en dessous\n"
	"	x 6C3A"},
/* 2EA3 */ { "CLÉ CJC FEU","	* forme utilisée en dessous\n"
	"	x 706C"},
/* 2EA4 */ { "CLÉ CJC PATTE UN","	* forme utilisée au-dessus\n"
	"	x 722B"},
/* 2EA5 */ { "CLÉ CJC PATTE DEUX","	* forme utilisée au-dessus\n"
	"	x 722B"},
/* 2EA6 */ { "CLÉ CJC DEMI-ARBRE SIMPLIFIÉ","	x 4E2C"},
/* 2EA7 */ { "CLÉ CJC BŒUF","	x 725B"},
/* 2EA8 */ { "CLÉ CJC CHIEN","	* forme utilisée à gauche\n"
	"	x 72AD"},
/* 2EA9 */ { "CLÉ CJC JADE","	* forme utilisée à gauche\n"
	"	x 738B"},
/* 2EAA */ { "CLÉ CJC PIÈCE D'ÉTOFFE","	* forme utilisée à gauche\n"
	"	x 758B"},
/* 2EAB */ { "CLÉ CJC ŒIL","	* forme utilisée au-dessus\n"
	"	x (clé cjc filet deux - 2EB2)\n"
	"	x 76EE"},
/* 2EAC */ { "CLÉ CJC RITES UN","	x 793A"},
/* 2EAD */ { "CLÉ CJC RITES DEUX","	x 793B"},
/* 2EAE */ { "CLÉ CJC BAMBOU","	x 7AF9"},
/* 2EAF */ { "CLÉ CJC SOIE","	* forme utilisée à gauche\n"
	"	x 7CF9"},
/* 2EB0 */ { "CLÉ CJC C-SIMPLIFIÉ SOIE","	* forme utilisée à gauche\n"
	"	x 7E9F"},
/* 2EB1 */ { "CLÉ CJC FILET UN","	x 7F53"},
/* 2EB2 */ { "CLÉ CJC FILET DEUX","	x (clé cjc œil - 2EAB)\n"
	"	x 7F52"},
/* 2EB3 */ { "CLÉ CJC FILET TROIS","	x 7F51"},
/* 2EB4 */ { "CLÉ CJC FILET QUATRE","	x 7F51"},
/* 2EB5 */ { "CLÉ CJC MAILLE","	x 2626B"},
/* 2EB6 */ { "CLÉ CJC MOUTON","	* forme utilisée à gauche\n"
	"	x 7F8A"},
/* 2EB7 */ { "CLÉ CJC BÉLIER","	* forme utilisée au-dessus\n"
	"	x 7F8A"},
/* 2EB8 */ { "CLÉ CJC BREBIS","	x 7F8B"},
/* 2EB9 */ { "CLÉ CJC ANCIEN","	x 8002"},
/* 2EBA */ { "CLÉ CJC PINCEAU UN","	x 8080"},
/* 2EBB */ { "CLÉ CJC PINCEAU DEUX","	x 807F"},
/* 2EBC */ { "CLÉ CJC VIANDE","	x 8089"},
/* 2EBD */ { "CLÉ CJC MORTIER","	x 81FC"},
/* 2EBE */ { "CLÉ CJC HERBE UN","	x 8279"},
/* 2EBF */ { "CLÉ CJC HERBE DEUX","	x 8279"},
/* 2EC0 */ { "CLÉ CJC HERBE TROIS","	x 8279"},
/* 2EC1 */ { "CLÉ CJC TIGRE","	x 864E"},
/* 2EC2 */ { "CLÉ CJC HABITS","	* forme utilisée à gauche\n"
	"	x 8864"},
/* 2EC3 */ { "CLÉ CJC OUEST UN","	* forme utilisée au-dessus\n"
	"	x 8980"},
/* 2EC4 */ { "CLÉ CJC OUEST DEUX","	* forme utilisée à gauche\n"
	"	x 897F"},
/* 2EC5 */ { "CLÉ CJC C-SIMPLIFIÉ VOIR","	x 89C1"},
/* 2EC6 */ { "CLÉ CJC SIMPLIFIÉ CORNE","	x 89D2"},
/* 2EC7 */ { "CLÉ CJC CORNE","	x 278B2"},
/* 2EC8 */ { "CLÉ CJC C-SIMPLIFIÉ PAROLE","	x 8BA0"},
/* 2EC9 */ { "CLÉ CJC C-SIMPLIFIÉ COQUILLAGE","	x 8D1D"},
/* 2ECA */ { "CLÉ CJC PIED","	* forme utilisée à gauche\n"
	"	x 8DB3"},
/* 2ECB */ { "CLÉ CJC C-SIMPLIFIÉ VÉHICULE","	x 8F66"},
/* 2ECC */ { "CLÉ CJC SIMPLIFIÉ PROMENADE","	x 8FB6"},
/* 2ECD */ { "CLÉ CJC PROMENADE UN","	x 8FB6"},
/* 2ECE */ { "CLÉ CJC PROMENADE DEUX","	x 8FB6"},
/* 2ECF */ { "CLÉ CJC VILLE","	* forme utilisée à droite\n"
	"	x 9091"},
/* 2ED0 */ { "CLÉ CJC C-SIMPLIFIÉ OR","	x 9485"},
/* 2ED1 */ { "CLÉ CJC LONG UN","	x 9577"},
/* 2ED2 */ { "CLÉ CJC LONG DEUX","	* forme utilisée à gauche\n"
	"	x 9578"},
/* 2ED3 */ { "CLÉ CJC C-SIMPLIFIÉ LONG","	x 957F"},
/* 2ED4 */ { "CLÉ CJC C-SIMPLIFIÉ PORTE","	x 95E8"},
/* 2ED5 */ { "CLÉ CJC TERTRE UN","	x 961C\n"
	"	x 28E0F"},
/* 2ED6 */ { "CLÉ CJC TERTRE DEUX","	* forme utilisée à gauche\n"
	"	x 961D"},
/* 2ED7 */ { "CLÉ CJC PLUIE","	x 96E8"},
/* 2ED8 */ { "CLÉ CJC BLEU","	x 9752"},
/* 2ED9 */ { "CLÉ CJC C-SIMPLIFIÉ CUIR TANNÉ","	x 97E6"},
/* 2EDA */ { "CLÉ CJC C-SIMPLIFIÉ FEUILLE","	x 9875"},
/* 2EDB */ { "CLÉ CJC C-SIMPLIFIÉ VENT","	x 98CE"},
/* 2EDC */ { "CLÉ CJC C-SIMPLIFIÉ VOLTIGER","	x 98DE"},
/* 2EDD */ { "CLÉ CJC MANGER UN","	* forme utilisée en dessous\n"
	"	x 98DF"},
/* 2EDE */ { "CLÉ CJC MANGER DEUX","	* forme utilisée à gauche\n"
	"	x 2967F"},
/* 2EDF */ { "CLÉ CJC MANGER TROIS","	* forme utilisée à gauche\n"
	"	x 98E0"},
/* 2EE0 */ { "CLÉ CJC C-SIMPLIFIÉ MANGER","	* forme utilisée à gauche\n"
	"	x 9963"},
/* 2EE1 */ { "CLÉ CJC TÊTE","	x 29810"},
/* 2EE2 */ { "CLÉ CJC C-SIMPLIFIÉ CHEVAL","	x 9A6C"},
/* 2EE3 */ { "CLÉ CJC OS","	x 9AA8"},
/* 2EE4 */ { "CLÉ CJC DÉMON","	x 9B3C"},
/* 2EE5 */ { "CLÉ CJC C-SIMPLIFIÉ POISSON","	x 9C7C"},
/* 2EE6 */ { "CLÉ CJC C-SIMPLIFIÉ OISEAU","	x 9E1F"},
/* 2EE7 */ { "CLÉ CJC C-SIMPLIFIÉ SEL","	x 5364"},
/* 2EE8 */ { "CLÉ CJC SIMPLIFIÉ BLÉ","	x 9EA6"},
/* 2EE9 */ { "CLÉ CJC SIMPLIFIÉ JAUNE","	x 9EC4"},
/* 2EEA */ { "CLÉ CJC C-SIMPLIFIÉ TÊTARD","	x 9EFE"},
/* 2EEB */ { "CLÉ CJC J-SIMPLIFIÉ HARMONIE","	x 6589"},
/* 2EEC */ { "CLÉ CJC C-SIMPLIFIÉ HARMONIE","	x 9F50"},
/* 2EED */ { "CLÉ CJC J-SIMPLIFIÉ DENTS","	x 6B6F"},
/* 2EEE */ { "CLÉ CJC C-SIMPLIFIÉ DENTS","	x 9F7F"},
/* 2EEF */ { "CLÉ CJC J-SIMPLIFIÉ DRAGON","	x 9F8D"},
/* 2EF0 */ { "CLÉ CJC C-SIMPLIFIÉ DRAGON","	x 9F99"},
/* 2EF1 */ { "CLÉ CJC TORTUE","	x 9F9C"},
/* 2EF2 */ { "CLÉ CJC J-SIMPLIFIÉ TORTUE","	x 4E80"},
/* 2EF3 */ { "CLÉ CJC C-SIMPLIFIÉ TORTUE","	# 9F9F"},
/* 2EF4 */ { NULL,NULL},
/* 2EF5 */ { NULL,NULL},
/* 2EF6 */ { NULL,NULL},
/* 2EF7 */ { NULL,NULL},
/* 2EF8 */ { NULL,NULL},
/* 2EF9 */ { NULL,NULL},
/* 2EFA */ { NULL,NULL},
/* 2EFB */ { NULL,NULL},
/* 2EFC */ { NULL,NULL},
/* 2EFD */ { NULL,NULL},
/* 2EFE */ { NULL,NULL},
/* 2EFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_2F[] = {
/* 2F00 */ { "CLÉ CHINOISE UN","	# 4E00"},
/* 2F01 */ { "CLÉ CHINOISE BARRE","	# 4E28"},
/* 2F02 */ { "CLÉ CHINOISE POINT","	# 4E36"},
/* 2F03 */ { "CLÉ CHINOISE OBLIQUE À GAUCHE","	# 4E3F"},
/* 2F04 */ { "CLÉ CHINOISE DOUBLE CROCHET","	# 4E59"},
/* 2F05 */ { "CLÉ CHINOISE CROCHET","	# 4E85"},
/* 2F06 */ { "CLÉ CHINOISE DEUX","	# 4E8C"},
/* 2F07 */ { "CLÉ CHINOISE DESSUS","	# 4EA0"},
/* 2F08 */ { "CLÉ CHINOISE HOMME","	# 4EBA"},
/* 2F09 */ { "CLÉ CHINOISE JAMBES","	# 513F"},
/* 2F0A */ { "CLÉ CHINOISE ENTRER","	# 5165"},
/* 2F0B */ { "CLÉ CHINOISE HUIT","	# 516B"},
/* 2F0C */ { "CLÉ CHINOISE PLACE","	# 5182"},
/* 2F0D */ { "CLÉ CHINOISE COUVRIR","	# 5196"},
/* 2F0E */ { "CLÉ CHINOISE GLACE","	# 51AB"},
/* 2F0F */ { "CLÉ CHINOISE TABOURET","	# 51E0"},
/* 2F10 */ { "CLÉ CHINOISE FOSSE","	# 51F5"},
/* 2F11 */ { "CLÉ CHINOISE COUTEAU","	# 5200"},
/* 2F12 */ { "CLÉ CHINOISE FORCE","	# 529B"},
/* 2F13 */ { "CLÉ CHINOISE ENVELOPPER","	# 52F9"},
/* 2F14 */ { "CLÉ CHINOISE CUILLÈRE","	# 5315"},
/* 2F15 */ { "CLÉ CHINOISE COFFRE","	# 531A"},
/* 2F16 */ { "CLÉ CHINOISE CACHETTE","	# 5338"},
/* 2F17 */ { "CLÉ CHINOISE DIX","	# 5341"},
/* 2F18 */ { "CLÉ CHINOISE DIVINATION","	# 535C"},
/* 2F19 */ { "CLÉ CHINOISE SCEAU","	# 5369"},
/* 2F1A */ { "CLÉ CHINOISE FALAISE","	# 5382"},
/* 2F1B */ { "CLÉ CHINOISE PRIVÉ","	# 53B6"},
/* 2F1C */ { "CLÉ CHINOISE ENCORE","	# 53C8"},
/* 2F1D */ { "CLÉ CHINOISE BOUCHE","	# 53E3"},
/* 2F1E */ { "CLÉ CHINOISE ENCEINTE","	# 56D7"},
/* 2F1F */ { "CLÉ CHINOISE TERRE","	# 571F"},
/* 2F20 */ { "CLÉ CHINOISE LETTRÉ","	# 58EB"},
/* 2F21 */ { "CLÉ CHINOISE ALLER","	# 5902"},
/* 2F22 */ { "CLÉ CHINOISE CHEMINER","	# 590A"},
/* 2F23 */ { "CLÉ CHINOISE SOIR","	# 5915"},
/* 2F24 */ { "CLÉ CHINOISE GRAND","	# 5927"},
/* 2F25 */ { "CLÉ CHINOISE FEMME","	# 5973"},
/* 2F26 */ { "CLÉ CHINOISE ENFANT","	# 5B50"},
/* 2F27 */ { "CLÉ CHINOISE TOIT","	# 5B80"},
/* 2F28 */ { "CLÉ CHINOISE POUCE","	# 5BF8"},
/* 2F29 */ { "CLÉ CHINOISE PETIT","	# 5C0F"},
/* 2F2A */ { "CLÉ CHINOISE INFIRME","	# 5C22"},
/* 2F2B */ { "CLÉ CHINOISE CADAVRE","	# 5C38"},
/* 2F2C */ { "CLÉ CHINOISE BOURGEON","	# 5C6E"},
/* 2F2D */ { "CLÉ CHINOISE MONTAGNE","	# 5C71"},
/* 2F2E */ { "CLÉ CHINOISE RIVIÈRE","	# 5DDB"},
/* 2F2F */ { "CLÉ CHINOISE TRAVAIL","	# 5DE5"},
/* 2F30 */ { "CLÉ CHINOISE SOI-MÊME","	# 5DF1"},
/* 2F31 */ { "CLÉ CHINOISE SERVIETTE","	# 5DFE"},
/* 2F32 */ { "CLÉ CHINOISE SEC","	# 5E72"},
/* 2F33 */ { "CLÉ CHINOISE MINCE","	= clé chinoise fin\n"
	"	# 5E7A"},
/* 2F34 */ { "CLÉ CHINOISE APPENTIS","	# 5E7F"},
/* 2F35 */ { "CLÉ CHINOISE ENJAMBÉE","	# 5EF4"},
/* 2F36 */ { "CLÉ CHINOISE DEUX MAINS","	# 5EFE"},
/* 2F37 */ { "CLÉ CHINOISE TIRER","	# 5F0B"},
/* 2F38 */ { "CLÉ CHINOISE ARC","	# 5F13"},
/* 2F39 */ { "CLÉ CHINOISE GROIN","	# 5F50"},
/* 2F3A */ { "CLÉ CHINOISE POIL","	# 5F61"},
/* 2F3B */ { "CLÉ CHINOISE PAS","	# 5F73"},
/* 2F3C */ { "CLÉ CHINOISE CŒUR","	# 5FC3"},
/* 2F3D */ { "CLÉ CHINOISE HALLEBARDE","	# 6208"},
/* 2F3E */ { "CLÉ CHINOISE BATTANT DE PORTE","	# 6236"},
/* 2F3F */ { "CLÉ CHINOISE MAIN","	# 624B"},
/* 2F40 */ { "CLÉ CHINOISE BRANCHE","	# 652F"},
/* 2F41 */ { "CLÉ CHINOISE TAPER","	# 6534"},
/* 2F42 */ { "CLÉ CHINOISE ÉCRITURE","	# 6587"},
/* 2F43 */ { "CLÉ CHINOISE BOISSEAU","	# 6597"},
/* 2F44 */ { "CLÉ CHINOISE HACHE","	# 65A4"},
/* 2F45 */ { "CLÉ CHINOISE CARRÉ","	# 65B9"},
/* 2F46 */ { "CLÉ CHINOISE NE PAS","	# 65E0"},
/* 2F47 */ { "CLÉ CHINOISE SOLEIL","	# 65E5"},
/* 2F48 */ { "CLÉ CHINOISE DIRE","	# 66F0"},
/* 2F49 */ { "CLÉ CHINOISE LUNE","	# 6708"},
/* 2F4A */ { "CLÉ CHINOISE ARBRE","	# 6728"},
/* 2F4B */ { "CLÉ CHINOISE MANQUE","	# 6B20"},
/* 2F4C */ { "CLÉ CHINOISE ARRÊT","	# 6B62"},
/* 2F4D */ { "CLÉ CHINOISE MORT","	# 6B79"},
/* 2F4E */ { "CLÉ CHINOISE ARME","	# 6BB3"},
/* 2F4F */ { "CLÉ CHINOISE IL N'Y A PAS","	# 6BCB"},
/* 2F50 */ { "CLÉ CHINOISE COMPARER","	# 6BD4"},
/* 2F51 */ { "CLÉ CHINOISE TOUFFE DE POIL","	# 6BDB"},
/* 2F52 */ { "CLÉ CHINOISE CLAN","	# 6C0F"},
/* 2F53 */ { "CLÉ CHINOISE VAPEUR","	# 6C14"},
/* 2F54 */ { "CLÉ CHINOISE EAU","	# 6C34"},
/* 2F55 */ { "CLÉ CHINOISE FEU","	# 706B"},
/* 2F56 */ { "CLÉ CHINOISE GRIFFE","	# 722A"},
/* 2F57 */ { "CLÉ CHINOISE PÈRE","	# 7236"},
/* 2F58 */ { "CLÉ CHINOISE ENTRELACÉ","	# 723B"},
/* 2F59 */ { "CLÉ CHINOISE MOITIÉ GAUCHE DE BÛCHE","	# 723F"},
/* 2F5A */ { "CLÉ CHINOISE TRANCHE","	# 7247"},
/* 2F5B */ { "CLÉ CHINOISE CROC","	# 7259"},
/* 2F5C */ { "CLÉ CHINOISE BŒUF","	# 725B"},
/* 2F5D */ { "CLÉ CHINOISE CHIEN","	# 72AC"},
/* 2F5E */ { "CLÉ CHINOISE MYSTÉRIEUX","	# 7384"},
/* 2F5F */ { "CLÉ CHINOISE JADE","	# 7389"},
/* 2F60 */ { "CLÉ CHINOISE MELON","	# 74DC"},
/* 2F61 */ { "CLÉ CHINOISE TUILE","	# 74E6"},
/* 2F62 */ { "CLÉ CHINOISE DOUX","	# 7518"},
/* 2F63 */ { "CLÉ CHINOISE NAÎTRE","	# 751F"},
/* 2F64 */ { "CLÉ CHINOISE UTILISER","	# 7528"},
/* 2F65 */ { "CLÉ CHINOISE CHAMP","	# 7530"},
/* 2F66 */ { "CLÉ CHINOISE PIÈCE D'ÉTOFFE","	# 758B"},
/* 2F67 */ { "CLÉ CHINOISE MALADIE","	# 7592"},
/* 2F68 */ { "CLÉ CHINOISE MONTER","	# 7676"},
/* 2F69 */ { "CLÉ CHINOISE BLANC","	# 767D"},
/* 2F6A */ { "CLÉ CHINOISE PEAU","	# 76AE"},
/* 2F6B */ { "CLÉ CHINOISE VAISSELLE","	# 76BF"},
/* 2F6C */ { "CLÉ CHINOISE ŒIL","	# 76EE"},
/* 2F6D */ { "CLÉ CHINOISE LANCE","	# 77DB"},
/* 2F6E */ { "CLÉ CHINOISE FLÈCHE","	# 77E2"},
/* 2F6F */ { "CLÉ CHINOISE PIERRE","	# 77F3"},
/* 2F70 */ { "CLÉ CHINOISE RITES","	# 793A"},
/* 2F71 */ { "CLÉ CHINOISE TRACES","	# 79B8"},
/* 2F72 */ { "CLÉ CHINOISE CÉRÉALES","	# 79BE"},
/* 2F73 */ { "CLÉ CHINOISE CAVERNE","	# 7A74"},
/* 2F74 */ { "CLÉ CHINOISE DEBOUT","	# 7ACB"},
/* 2F75 */ { "CLÉ CHINOISE BAMBOU","	# 7AF9"},
/* 2F76 */ { "CLÉ CHINOISE RIZ","	# 7C73"},
/* 2F77 */ { "CLÉ CHINOISE SOIE","	# 7CF8"},
/* 2F78 */ { "CLÉ CHINOISE POTERIE","	# 7F36"},
/* 2F79 */ { "CLÉ CHINOISE FILET","	# 7F51"},
/* 2F7A */ { "CLÉ CHINOISE MOUTON","	# 7F8A"},
/* 2F7B */ { "CLÉ CHINOISE PLUME","	# 7FBD"},
/* 2F7C */ { "CLÉ CHINOISE VIEUX","	# 8001"},
/* 2F7D */ { "CLÉ CHINOISE ALORS","	# 800C"},
/* 2F7E */ { "CLÉ CHINOISE CHARRUE","	# 8012"},
/* 2F7F */ { "CLÉ CHINOISE OREILLE","	# 8033"},
/* 2F80 */ { "CLÉ CHINOISE PINCEAU","	# 807F"},
/* 2F81 */ { "CLÉ CHINOISE VIANDE","	# 8089"},
/* 2F82 */ { "CLÉ CHINOISE MINISTRE","	# 81E3"},
/* 2F83 */ { "CLÉ CHINOISE PERSONNELLEMENT","	# 81EA"},
/* 2F84 */ { "CLÉ CHINOISE ARRIVER","	# 81F3"},
/* 2F85 */ { "CLÉ CHINOISE MORTIER","	# 81FC"},
/* 2F86 */ { "CLÉ CHINOISE LANGUE","	# 820C"},
/* 2F87 */ { "CLÉ CHINOISE S'OPPOSER","	# 821B"},
/* 2F88 */ { "CLÉ CHINOISE BATEAU","	# 821F"},
/* 2F89 */ { "CLÉ CHINOISE RÉSISTER","	# 826E"},
/* 2F8A */ { "CLÉ CHINOISE COULEUR","	# 8272"},
/* 2F8B */ { "CLÉ CHINOISE HERBE","	# 8278"},
/* 2F8C */ { "CLÉ CHINOISE TIGRE","	# 864D"},
/* 2F8D */ { "CLÉ CHINOISE INSECTE","	# 866B"},
/* 2F8E */ { "CLÉ CHINOISE SANG","	# 8840"},
/* 2F8F */ { "CLÉ CHINOISE DÉFILER","	# 884C"},
/* 2F90 */ { "CLÉ CHINOISE HABITS","	# 8863"},
/* 2F91 */ { "CLÉ CHINOISE OUEST","	# 897E"},
/* 2F92 */ { "CLÉ CHINOISE VOIR","	# 898B"},
/* 2F93 */ { "CLÉ CHINOISE CORNE","	# 89D2"},
/* 2F94 */ { "CLÉ CHINOISE PAROLE","	# 8A00"},
/* 2F95 */ { "CLÉ CHINOISE VALLÉE","	# 8C37"},
/* 2F96 */ { "CLÉ CHINOISE HARICOT","	# 8C46"},
/* 2F97 */ { "CLÉ CHINOISE COCHON","	# 8C55"},
/* 2F98 */ { "CLÉ CHINOISE ANIMAL","	# 8C78"},
/* 2F99 */ { "CLÉ CHINOISE COQUILLAGE","	# 8C9D"},
/* 2F9A */ { "CLÉ CHINOISE ROUGE","	# 8D64"},
/* 2F9B */ { "CLÉ CHINOISE COURIR","	# 8D70"},
/* 2F9C */ { "CLÉ CHINOISE PIED","	# 8DB3"},
/* 2F9D */ { "CLÉ CHINOISE CORPS","	# 8EAB"},
/* 2F9E */ { "CLÉ CHINOISE VÉHICULE","	# 8ECA"},
/* 2F9F */ { "CLÉ CHINOISE ÂCRE","	# 8F9B"},
/* 2FA0 */ { "CLÉ CHINOISE MATIN","	# 8FB0"},
/* 2FA1 */ { "CLÉ CHINOISE PROMENADE","	# 8FB5"},
/* 2FA2 */ { "CLÉ CHINOISE RÉGION","	# 9091"},
/* 2FA3 */ { "CLÉ CHINOISE SIGNE DU COQ","	= clé chinoise amphore\n"
	"	# 9149"},
/* 2FA4 */ { "CLÉ CHINOISE CUEILLIR","	# 91C6"},
/* 2FA5 */ { "CLÉ CHINOISE HAMEAU","	# 91CC"},
/* 2FA6 */ { "CLÉ CHINOISE OR","	# 91D1"},
/* 2FA7 */ { "CLÉ CHINOISE LONG","	# 9577"},
/* 2FA8 */ { "CLÉ CHINOISE PORTE","	# 9580"},
/* 2FA9 */ { "CLÉ CHINOISE TERTRE","	# 961C"},
/* 2FAA */ { "CLÉ CHINOISE ESCLAVE","	# 96B6"},
/* 2FAB */ { "CLÉ CHINOISE OISEAU À QUEUE COURTE","	# 96B9"},
/* 2FAC */ { "CLÉ CHINOISE PLUIE","	# 96E8"},
/* 2FAD */ { "CLÉ CHINOISE BLEU","	# 9751"},
/* 2FAE */ { "CLÉ CHINOISE TORT","	# 975E"},
/* 2FAF */ { "CLÉ CHINOISE VISAGE","	# 9762"},
/* 2FB0 */ { "CLÉ CHINOISE CUIR","	# 9769"},
/* 2FB1 */ { "CLÉ CHINOISE CUIR TANNÉ","	# 97CB"},
/* 2FB2 */ { "CLÉ CHINOISE CIBOULETTE","	# 97ED"},
/* 2FB3 */ { "CLÉ CHINOISE SON","	# 97F3"},
/* 2FB4 */ { "CLÉ CHINOISE FEUILLE","	# 9801"},
/* 2FB5 */ { "CLÉ CHINOISE VENT","	# 98A8"},
/* 2FB6 */ { "CLÉ CHINOISE VOLTIGER","	# 98DB"},
/* 2FB7 */ { "CLÉ CHINOISE MANGER","	# 98DF"},
/* 2FB8 */ { "CLÉ CHINOISE TÊTE","	# 9996"},
/* 2FB9 */ { "CLÉ CHINOISE PARFUM","	# 9999"},
/* 2FBA */ { "CLÉ CHINOISE CHEVAL","	# 99AC"},
/* 2FBB */ { "CLÉ CHINOISE OS","	# 9AA8"},
/* 2FBC */ { "CLÉ CHINOISE HAUT","	# 9AD8"},
/* 2FBD */ { "CLÉ CHINOISE CHEVELURE","	# 9ADF"},
/* 2FBE */ { "CLÉ CHINOISE RIXE","	# 9B25"},
/* 2FBF */ { "CLÉ CHINOISE VIN SACRIFICIEL","	# 9B2F"},
/* 2FC0 */ { "CLÉ CHINOISE CHAUDRON","	# 9B32"},
/* 2FC1 */ { "CLÉ CHINOISE DÉMON","	# 9B3C"},
/* 2FC2 */ { "CLÉ CHINOISE POISSON","	# 9B5A"},
/* 2FC3 */ { "CLÉ CHINOISE OISEAU","	# 9CE5"},
/* 2FC4 */ { "CLÉ CHINOISE SEL","	# 9E75"},
/* 2FC5 */ { "CLÉ CHINOISE CERF","	# 9E7F"},
/* 2FC6 */ { "CLÉ CHINOISE BLÉ","	# 9EA5"},
/* 2FC7 */ { "CLÉ CHINOISE CHANVRE","	# 9EBB"},
/* 2FC8 */ { "CLÉ CHINOISE JAUNE","	# 9EC3"},
/* 2FC9 */ { "CLÉ CHINOISE MILLET","	# 9ECD"},
/* 2FCA */ { "CLÉ CHINOISE NOIR","	# 9ED1"},
/* 2FCB */ { "CLÉ CHINOISE BRODERIE","	# 9EF9"},
/* 2FCC */ { "CLÉ CHINOISE GRENOUILLE","	# 9EFD"},
/* 2FCD */ { "CLÉ CHINOISE TRIPODE","	# 9F0E"},
/* 2FCE */ { "CLÉ CHINOISE TAMBOUR","	# 9F13"},
/* 2FCF */ { "CLÉ CHINOISE RAT","	# 9F20"},
/* 2FD0 */ { "CLÉ CHINOISE NEZ","	# 9F3B"},
/* 2FD1 */ { "CLÉ CHINOISE HARMONIE","	# 9F4A"},
/* 2FD2 */ { "CLÉ CHINOISE DENT","	# 9F52"},
/* 2FD3 */ { "CLÉ CHINOISE DRAGON","	# 9F8D"},
/* 2FD4 */ { "CLÉ CHINOISE TORTUE","	# 9F9C"},
/* 2FD5 */ { "CLÉ CHINOISE FLÛTE","	# 9FA0"},
/* 2FD6 */ { NULL,NULL},
/* 2FD7 */ { NULL,NULL},
/* 2FD8 */ { NULL,NULL},
/* 2FD9 */ { NULL,NULL},
/* 2FDA */ { NULL,NULL},
/* 2FDB */ { NULL,NULL},
/* 2FDC */ { NULL,NULL},
/* 2FDD */ { NULL,NULL},
/* 2FDE */ { NULL,NULL},
/* 2FDF */ { NULL,NULL},
/* 2FE0 */ { NULL,NULL},
/* 2FE1 */ { NULL,NULL},
/* 2FE2 */ { NULL,NULL},
/* 2FE3 */ { NULL,NULL},
/* 2FE4 */ { NULL,NULL},
/* 2FE5 */ { NULL,NULL},
/* 2FE6 */ { NULL,NULL},
/* 2FE7 */ { NULL,NULL},
/* 2FE8 */ { NULL,NULL},
/* 2FE9 */ { NULL,NULL},
/* 2FEA */ { NULL,NULL},
/* 2FEB */ { NULL,NULL},
/* 2FEC */ { NULL,NULL},
/* 2FED */ { NULL,NULL},
/* 2FEE */ { NULL,NULL},
/* 2FEF */ { NULL,NULL},
/* 2FF0 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE GAUCHE À DROITE",NULL},
/* 2FF1 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE DE HAUT EN BAS",NULL},
/* 2FF2 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE DE LA GAUCHE AU MILIEU PUIS À LA DROITE",NULL},
/* 2FF3 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE DU HAUT AU MILIEU PUIS EN BAS",NULL},
/* 2FF4 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE TOUT AUTOUR",NULL},
/* 2FF5 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE AUTOUR À PARTIR DU HAUT",NULL},
/* 2FF6 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE AUTOUR À PARTIR DU BAS",NULL},
/* 2FF7 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE AUTOUR À PARTIR DE LA GAUCHE",NULL},
/* 2FF8 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE AUTOUR À PARTIR D'EN HAUT À GAUCHE",NULL},
/* 2FF9 */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE AUTOUR À PARTIR D'EN HAUT À DROITE",NULL},
/* 2FFA */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE AUTOUR À PARTIR D'EN BAS À GAUCHE",NULL},
/* 2FFB */ { "CARACTÈRE DE DESCRIPTION IDÉOGRAPHIQUE CHEVAUCHEMENT",NULL},
/* 2FFC */ { NULL,NULL},
/* 2FFD */ { NULL,NULL},
/* 2FFE */ { NULL,NULL},
/* 2FFF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_30[] = {
/* 3000 */ { "ESPACE IDÉOGRAPHIQUE","	x (espace - 0020)\n"
	"	# <large> 0020"},
/* 3001 */ { "VIRGULE IDÉOGRAPHIQUE","	* en chinois, délimite les éléments d'une liste ou d'une série\n"
	"	x (virgule - 002C)\n"
	"	x (virgule pleine chasse - FF0C)"},
/* 3002 */ { "POINT IDÉOGRAPHIQUE","	x (point - 002E)"},
/* 3003 */ { "GUILLEMET DE RÉPÉTITION","	x (double prime - 2033)"},
/* 3004 */ { "SYMBOLE DE NORME INDUSTRIELLE JAPONAISE",NULL},
/* 3005 */ { "MARQUE D'ITÉRATION IDÉOGRAPHIQUE","	x (marque d'itération tangoute - 16FE0)"},
/* 3006 */ { "MARQUE IDÉOGRAPHIQUE DE FERMETURE",NULL},
/* 3007 */ { "ZÉRO IDÉOGRAPHIQUE","	x (diacritique cercle englobant - 20DD)\n"
	"	x (cercle blanc - 25CB)\n"
	"	x (grand cercle - 25EF)"},
/* 3008 */ { "CHEVRON GAUCHE","	x (signe inférieur à - 003C)\n"
	"	x (guillemet simple vers la gauche - 2039)\n"
	"	x (chevron pointant à gauche - 2329)\n"
	"	x (chevron mathématique gauche - 27E8)"},
/* 3009 */ { "CHEVRON DROIT","	x (signe supérieur à - 003E)\n"
	"	x (guillemet simple vers la droite - 203A)\n"
	"	x (chevron pointant à droite - 232A)\n"
	"	x (chevron mathématique droit - 27E9)"},
/* 300A */ { "DOUBLE CHEVRON GAUCHE","	x (guillemet gauche - 00AB)\n"
	"	x (double chevron mathématique gauche - 27EA)"},
/* 300B */ { "DOUBLE CHEVRON DROIT","	x (guillemet droit - 00BB)\n"
	"	x (double chevron mathématique droit - 27EB)"},
/* 300C */ { "ANGLET GAUCHE","	x (plafond à gauche - 2308)"},
/* 300D */ { "ANGLET DROIT","	* ces deux anglets servent de guillemets\n"
	"	x (plancher à droite - 230B)"},
/* 300E */ { "ANGLET BLANC GAUCHE",NULL},
/* 300F */ { "ANGLET BLANC DROIT","	* ces deux anglets servent de guillemets"},
/* 3010 */ { "CROCHET LENTICULAIRE NOIR GAUCHE",NULL},
/* 3011 */ { "CROCHET LENTICULAIRE NOIR DROIT",NULL},
/* 3012 */ { "MARQUE POSTALE","	x (bureau de poste japonais - 1F3E3)"},
/* 3013 */ { "SIGNE GETA","	* remplace un idéogramme absent de la police\n"
	"	* convention éditoriale pour représenter une lacune\n"
	"	x (carré blanc - 25A1)"},
/* 3014 */ { "CROCHET EN ÉCAILLE GAUCHE",NULL},
/* 3015 */ { "CROCHET EN ÉCAILLE DROIT",NULL},
/* 3016 */ { "CROCHET LENTICULAIRE BLANC GAUCHE",NULL},
/* 3017 */ { "CROCHET LENTICULAIRE BLANC DROIT",NULL},
/* 3018 */ { "CROCHET EN ÉCAILLE BLANC GAUCHE","	x (crochet en écaille mathématique blanc gauche - 27EC)"},
/* 3019 */ { "CROCHET EN ÉCAILLE BLANC DROIT","	x (crochet en écaille mathématique blanc droit - 27ED)"},
/* 301A */ { "CROCHET BLANC GAUCHE","	= crochet gauche de syntaxe abstraite\n"
	"	x (crochet mathématique blanc gauche - 27E6)"},
/* 301B */ { "CROCHET BLANC DROIT","	= crochet droit de syntaxe abstraite\n"
	"	x (crochet mathématique blanc droit - 27E7)"},
/* 301C */ { "TIRET EN ESSE","		Ce caractère est repris pour la correspondance avec le « tiret ondulé » de JIS C 6226-1978 1-33.\n"
	"	x (tiret ondé - 2053)\n"
	"	x (tiret ondulé - 3030)\n"
	"	x (tilde pleine chasse - FF5E)"},
/* 301D */ { "GUILLEMET DOUBLE PRIME RÉFLÉCHI","	* parfois représenté comme un guillemet double prime\n"
	"	x (guillemet-apostrophe double culbuté - 201C)\n"
	"	x (double prime réfléchi - 2036)"},
/* 301E */ { "GUILLEMET DOUBLE PRIME","	* il s'agit d'une erreur analogue à 201D ; 301F est recommandé\n"
	"	x (guillemet-apostrophe double - 201D)\n"
	"	x (double prime - 2033)"},
/* 301F */ { "GUILLEMET DOUBLE PRIME INFÉRIEUR","	* peut être représenté comme un guillemet bas double prime inversé"},
/* 3020 */ { "VISAGE EN MARQUE POSTALE",NULL},
/* 3021 */ { "CHIFFRE SUZHOU UN",NULL},
/* 3022 */ { "CHIFFRE SUZHOU DEUX",NULL},
/* 3023 */ { "CHIFFRE SUZHOU TROIS",NULL},
/* 3024 */ { "CHIFFRE SUZHOU QUATRE",NULL},
/* 3025 */ { "CHIFFRE SUZHOU CINQ",NULL},
/* 3026 */ { "CHIFFRE SUZHOU SIX",NULL},
/* 3027 */ { "CHIFFRE SUZHOU SEPT",NULL},
/* 3028 */ { "CHIFFRE SUZHOU HUIT",NULL},
/* 3029 */ { "CHIFFRE SUZHOU NEUF",NULL},
/* 302A */ { "DIACRITIQUE IDÉOGRAPHIQUE TON FIXE",NULL},
/* 302B */ { "DIACRITIQUE IDÉOGRAPHIQUE TON ASCENDANT",NULL},
/* 302C */ { "DIACRITIQUE IDÉOGRAPHIQUE TON SORTANT",NULL},
/* 302D */ { "DIACRITIQUE IDÉOGRAPHIQUE TON ENTRANT",NULL},
/* 302E */ { "DIACRITIQUE TON HANGÛL POINT","	= Pangdjom à un point"},
/* 302F */ { "DIACRITIQUE TON HANGÛL DOUBLE POINT","	= Pangdjom à double point"},
/* 3030 */ { "TIRET ONDULÉ","	x (ligne ondulée - 2307)\n"
	"	x (tiret en esse - 301C)"},
/* 3031 */ { "MARQUE VERTICALE KANA DE RÉPÉTITION",NULL},
/* 3032 */ { "MARQUE VERTICALE KANA DE RÉPÉTITION AVEC SON VOISÉ","	* caractères conçus de façon telle que les glyphes ont une hauteur correpondant à deux cadratins"},
/* 3033 */ { "MOITIÉ SUPÉRIEURE DE MARQUE VERTICALE KANA DE RÉPÉTITION",NULL},
/* 3034 */ { "MOITIÉ SUPÉRIEURE DE MARQUE VERTICALE KANA DE RÉPÉTITION AVEC SON VOISÉ","	* caractères conçus de façon telle que les glyphes ont une hauteur correpondant à un cadratin et se combinent avec le caractère qui suit pour former des glyphes liés d'une hauteur de deux cadratins pour les marques de répétition complètes"},
/* 3035 */ { "MOITIÉ INFÉRIEURE DE MARQUE VERTICALE KANA DE RÉPÉTITION",NULL},
/* 3036 */ { "MARQUE POSTALE CERCLÉE","	# 3012 marque postale"},
/* 3037 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE SÉPARATEUR DE CHANGEMENT DE LIGNE",NULL},
/* 3038 */ { "NOMBRE SUZHOU DIX","	# 5341"},
/* 3039 */ { "NOMBRE SUZHOU VINGT","	# 5344"},
/* 303A */ { "NOMBRE SUZHOU TRENTE","	# 5345"},
/* 303B */ { "MARQUE D'ITÉRATION IDÉOGRAPHIQUE VERTICALE",NULL},
/* 303C */ { "SIGNE MASU","	* abréviation japonaise courante représentant le suffixe -masu\n"
	"	x (oblique encadrée - 29C4)"},
/* 303D */ { "SIGNE DE CHANGEMENT DE PARTIE","	* signale le début d'une partie de chanson en japonais"},
/* 303E */ { "INDICATEUR DE VARIANTE IDÉOGRAPHIQUE","	* caractère visuel qui indique que l'on doit interpréter l'idéogramme suivant comme une variante du caractère désiré"},
/* 303F */ { "DEMI-ESPACE IDÉOGRAPHIQUE","	* caractère visuel qui indique une espace à l'écran de chasse égale à la moitié d'un idéogramme"},
/* 3040 */ { NULL,NULL},
/* 3041 */ { "SYLLABE HIRAGANA PETIT A",NULL},
/* 3042 */ { "SYLLABE HIRAGANA A",NULL},
/* 3043 */ { "SYLLABE HIRAGANA PETIT I",NULL},
/* 3044 */ { "SYLLABE HIRAGANA I",NULL},
/* 3045 */ { "SYLLABE HIRAGANA PETIT U",NULL},
/* 3046 */ { "SYLLABE HIRAGANA U",NULL},
/* 3047 */ { "SYLLABE HIRAGANA PETIT E",NULL},
/* 3048 */ { "SYLLABE HIRAGANA E",NULL},
/* 3049 */ { "SYLLABE HIRAGANA PETIT O",NULL},
/* 304A */ { "SYLLABE HIRAGANA O",NULL},
/* 304B */ { "SYLLABE HIRAGANA KA",NULL},
/* 304C */ { "SYLLABE HIRAGANA GA","	: 304B 3099"},
/* 304D */ { "SYLLABE HIRAGANA KI",NULL},
/* 304E */ { "SYLLABE HIRAGANA GI","	: 304D 3099"},
/* 304F */ { "SYLLABE HIRAGANA KU",NULL},
/* 3050 */ { "SYLLABE HIRAGANA GU","	: 304F 3099"},
/* 3051 */ { "SYLLABE HIRAGANA KE",NULL},
/* 3052 */ { "SYLLABE HIRAGANA GE","	: 3051 3099"},
/* 3053 */ { "SYLLABE HIRAGANA KO",NULL},
/* 3054 */ { "SYLLABE HIRAGANA GO","	: 3053 3099"},
/* 3055 */ { "SYLLABE HIRAGANA SA",NULL},
/* 3056 */ { "SYLLABE HIRAGANA ZA","	: 3055 3099"},
/* 3057 */ { "SYLLABE HIRAGANA SI","	= chi"},
/* 3058 */ { "SYLLABE HIRAGANA ZI","	= dji (pas unique)\n"
	"	: 3057 3099"},
/* 3059 */ { "SYLLABE HIRAGANA SU",NULL},
/* 305A */ { "SYLLABE HIRAGANA ZU","	: 3059 3099"},
/* 305B */ { "SYLLABE HIRAGANA SE",NULL},
/* 305C */ { "SYLLABE HIRAGANA ZE","	: 305B 3099"},
/* 305D */ { "SYLLABE HIRAGANA SO",NULL},
/* 305E */ { "SYLLABE HIRAGANA ZO","	: 305D 3099"},
/* 305F */ { "SYLLABE HIRAGANA TA",NULL},
/* 3060 */ { "SYLLABE HIRAGANA DA","	: 305F 3099"},
/* 3061 */ { "SYLLABE HIRAGANA TI","	= tchi"},
/* 3062 */ { "SYLLABE HIRAGANA DI","	= dji (pas unique)\n"
	"	: 3061 3099"},
/* 3063 */ { "SYLLABE HIRAGANA PETIT TU","	= petit tsou"},
/* 3064 */ { "SYLLABE HIRAGANA TU","	= tsou"},
/* 3065 */ { "SYLLABE HIRAGANA DU","	= zou (pas unique)\n"
	"	: 3064 3099"},
/* 3066 */ { "SYLLABE HIRAGANA TE",NULL},
/* 3067 */ { "SYLLABE HIRAGANA DE","	: 3066 3099"},
/* 3068 */ { "SYLLABE HIRAGANA TO",NULL},
/* 3069 */ { "SYLLABE HIRAGANA DO","	: 3068 3099"},
/* 306A */ { "SYLLABE HIRAGANA NA",NULL},
/* 306B */ { "SYLLABE HIRAGANA NI",NULL},
/* 306C */ { "SYLLABE HIRAGANA NU",NULL},
/* 306D */ { "SYLLABE HIRAGANA NE",NULL},
/* 306E */ { "SYLLABE HIRAGANA NO",NULL},
/* 306F */ { "SYLLABE HIRAGANA HA",NULL},
/* 3070 */ { "SYLLABE HIRAGANA BA","	: 306F 3099"},
/* 3071 */ { "SYLLABE HIRAGANA PA","	: 306F 309A"},
/* 3072 */ { "SYLLABE HIRAGANA HI",NULL},
/* 3073 */ { "SYLLABE HIRAGANA BI","	: 3072 3099"},
/* 3074 */ { "SYLLABE HIRAGANA PI","	: 3072 309A"},
/* 3075 */ { "SYLLABE HIRAGANA HU","	= fu, fou"},
/* 3076 */ { "SYLLABE HIRAGANA BU","	: 3075 3099"},
/* 3077 */ { "SYLLABE HIRAGANA PU","	: 3075 309A"},
/* 3078 */ { "SYLLABE HIRAGANA HE",NULL},
/* 3079 */ { "SYLLABE HIRAGANA BE","	: 3078 3099"},
/* 307A */ { "SYLLABE HIRAGANA PE","	: 3078 309A"},
/* 307B */ { "SYLLABE HIRAGANA HO",NULL},
/* 307C */ { "SYLLABE HIRAGANA BO","	: 307B 3099"},
/* 307D */ { "SYLLABE HIRAGANA PO","	: 307B 309A"},
/* 307E */ { "SYLLABE HIRAGANA MA",NULL},
/* 307F */ { "SYLLABE HIRAGANA MI",NULL},
/* 3080 */ { "SYLLABE HIRAGANA MU",NULL},
/* 3081 */ { "SYLLABE HIRAGANA ME",NULL},
/* 3082 */ { "SYLLABE HIRAGANA MO",NULL},
/* 3083 */ { "SYLLABE HIRAGANA PETIT YA",NULL},
/* 3084 */ { "SYLLABE HIRAGANA YA",NULL},
/* 3085 */ { "SYLLABE HIRAGANA PETIT YU",NULL},
/* 3086 */ { "SYLLABE HIRAGANA YU",NULL},
/* 3087 */ { "SYLLABE HIRAGANA PETIT YO",NULL},
/* 3088 */ { "SYLLABE HIRAGANA YO",NULL},
/* 3089 */ { "SYLLABE HIRAGANA RA",NULL},
/* 308A */ { "SYLLABE HIRAGANA RI",NULL},
/* 308B */ { "SYLLABE HIRAGANA RU",NULL},
/* 308C */ { "SYLLABE HIRAGANA RE",NULL},
/* 308D */ { "SYLLABE HIRAGANA RO",NULL},
/* 308E */ { "SYLLABE HIRAGANA PETIT WA",NULL},
/* 308F */ { "SYLLABE HIRAGANA WA",NULL},
/* 3090 */ { "SYLLABE HIRAGANA WI",NULL},
/* 3091 */ { "SYLLABE HIRAGANA WE",NULL},
/* 3092 */ { "SYLLABE HIRAGANA WO",NULL},
/* 3093 */ { "SYLLABE HIRAGANA N",NULL},
/* 3094 */ { "SYLLABE HIRAGANA VU","	: 3046 3099"},
/* 3095 */ { "SYLLABE HIRAGANA PETIT KA",NULL},
/* 3096 */ { "SYLLABE HIRAGANA PETIT KE",NULL},
/* 3097 */ { NULL,NULL},
/* 3098 */ { NULL,NULL},
/* 3099 */ { "DIACRITIQUE KATAKANA-HIRAGANA SON VOISÉ",NULL},
/* 309A */ { "DIACRITIQUE KATAKANA-HIRAGANA SON SEMI-VOISÉ",NULL},
/* 309B */ { "MARQUE KATAKANA-HIRAGANA DE SON VOISÉ","	# 0020 3099"},
/* 309C */ { "MARQUE KATAKANA-HIRAGANA DE SON SEMI-VOISÉ","	# 0020 309A"},
/* 309D */ { "MARQUE D'ITÉRATION HIRAGANA",NULL},
/* 309E */ { "MARQUE D'ITÉRATION VOISÉE HIRAGANA","	: 309D 3099"},
/* 309F */ { "DIGRAMME HIRAGANA YORI","	* utilisé autrefois dans des dispositions verticales, mais aujourd'hui également dans une mise en forme horizontale\n"
	"	# <verticale> 3088 308A"},
/* 30A0 */ { "DOUBLE TRAIT KATAKANA-HIRAGANA","	x (signe égal - 003D)\n"
	"	x (trait d'union double - 2E40)"},
/* 30A1 */ { "SYLLABE KATAKANA PETIT A",NULL},
/* 30A2 */ { "SYLLABE KATAKANA A",NULL},
/* 30A3 */ { "SYLLABE KATAKANA PETIT I",NULL},
/* 30A4 */ { "SYLLABE KATAKANA I",NULL},
/* 30A5 */ { "SYLLABE KATAKANA PETIT U",NULL},
/* 30A6 */ { "SYLLABE KATAKANA U",NULL},
/* 30A7 */ { "SYLLABE KATAKANA PETIT E",NULL},
/* 30A8 */ { "SYLLABE KATAKANA E",NULL},
/* 30A9 */ { "SYLLABE KATAKANA PETIT O",NULL},
/* 30AA */ { "SYLLABE KATAKANA O",NULL},
/* 30AB */ { "SYLLABE KATAKANA KA",NULL},
/* 30AC */ { "SYLLABE KATAKANA GA","	: 30AB 3099"},
/* 30AD */ { "SYLLABE KATAKANA KI",NULL},
/* 30AE */ { "SYLLABE KATAKANA GI","	: 30AD 3099"},
/* 30AF */ { "SYLLABE KATAKANA KU",NULL},
/* 30B0 */ { "SYLLABE KATAKANA GU","	: 30AF 3099"},
/* 30B1 */ { "SYLLABE KATAKANA KE",NULL},
/* 30B2 */ { "SYLLABE KATAKANA GE","	: 30B1 3099"},
/* 30B3 */ { "SYLLABE KATAKANA KO",NULL},
/* 30B4 */ { "SYLLABE KATAKANA GO","	: 30B3 3099"},
/* 30B5 */ { "SYLLABE KATAKANA SA",NULL},
/* 30B6 */ { "SYLLABE KATAKANA ZA","	: 30B5 3099"},
/* 30B7 */ { "SYLLABE KATAKANA SI","	= chi"},
/* 30B8 */ { "SYLLABE KATAKANA ZI","	= dji (pas unique)\n"
	"	: 30B7 3099"},
/* 30B9 */ { "SYLLABE KATAKANA SU",NULL},
/* 30BA */ { "SYLLABE KATAKANA ZU","	: 30B9 3099"},
/* 30BB */ { "SYLLABE KATAKANA SE",NULL},
/* 30BC */ { "SYLLABE KATAKANA ZE","	: 30BB 3099"},
/* 30BD */ { "SYLLABE KATAKANA SO",NULL},
/* 30BE */ { "SYLLABE KATAKANA ZO","	: 30BD 3099"},
/* 30BF */ { "SYLLABE KATAKANA TA",NULL},
/* 30C0 */ { "SYLLABE KATAKANA DA","	: 30BF 3099"},
/* 30C1 */ { "SYLLABE KATAKANA TI","	= tchi"},
/* 30C2 */ { "SYLLABE KATAKANA DI","	= dji (pas unique)\n"
	"	: 30C1 3099"},
/* 30C3 */ { "SYLLABE KATAKANA PETIT TU","	= petit tsou"},
/* 30C4 */ { "SYLLABE KATAKANA TU","	= tsou"},
/* 30C5 */ { "SYLLABE KATAKANA DU","	= zou (pas unique)\n"
	"	: 30C4 3099"},
/* 30C6 */ { "SYLLABE KATAKANA TE",NULL},
/* 30C7 */ { "SYLLABE KATAKANA DE","	: 30C6 3099"},
/* 30C8 */ { "SYLLABE KATAKANA TO",NULL},
/* 30C9 */ { "SYLLABE KATAKANA DO","	: 30C8 3099"},
/* 30CA */ { "SYLLABE KATAKANA NA",NULL},
/* 30CB */ { "SYLLABE KATAKANA NI",NULL},
/* 30CC */ { "SYLLABE KATAKANA NU",NULL},
/* 30CD */ { "SYLLABE KATAKANA NE",NULL},
/* 30CE */ { "SYLLABE KATAKANA NO",NULL},
/* 30CF */ { "SYLLABE KATAKANA HA",NULL},
/* 30D0 */ { "SYLLABE KATAKANA BA","	: 30CF 3099"},
/* 30D1 */ { "SYLLABE KATAKANA PA","	: 30CF 309A"},
/* 30D2 */ { "SYLLABE KATAKANA HI",NULL},
/* 30D3 */ { "SYLLABE KATAKANA BI","	: 30D2 3099"},
/* 30D4 */ { "SYLLABE KATAKANA PI","	: 30D2 309A"},
/* 30D5 */ { "SYLLABE KATAKANA HU","	= fu, fou"},
/* 30D6 */ { "SYLLABE KATAKANA BU","	: 30D5 3099"},
/* 30D7 */ { "SYLLABE KATAKANA PU","	: 30D5 309A"},
/* 30D8 */ { "SYLLABE KATAKANA HE",NULL},
/* 30D9 */ { "SYLLABE KATAKANA BE","	: 30D8 3099"},
/* 30DA */ { "SYLLABE KATAKANA PE","	: 30D8 309A"},
/* 30DB */ { "SYLLABE KATAKANA HO",NULL},
/* 30DC */ { "SYLLABE KATAKANA BO","	: 30DB 3099"},
/* 30DD */ { "SYLLABE KATAKANA PO","	: 30DB 309A"},
/* 30DE */ { "SYLLABE KATAKANA MA",NULL},
/* 30DF */ { "SYLLABE KATAKANA MI",NULL},
/* 30E0 */ { "SYLLABE KATAKANA MU",NULL},
/* 30E1 */ { "SYLLABE KATAKANA ME",NULL},
/* 30E2 */ { "SYLLABE KATAKANA MO",NULL},
/* 30E3 */ { "SYLLABE KATAKANA PETIT YA",NULL},
/* 30E4 */ { "SYLLABE KATAKANA YA",NULL},
/* 30E5 */ { "SYLLABE KATAKANA PETIT YU",NULL},
/* 30E6 */ { "SYLLABE KATAKANA YU",NULL},
/* 30E7 */ { "SYLLABE KATAKANA PETIT YO",NULL},
/* 30E8 */ { "SYLLABE KATAKANA YO",NULL},
/* 30E9 */ { "SYLLABE KATAKANA RA",NULL},
/* 30EA */ { "SYLLABE KATAKANA RI",NULL},
/* 30EB */ { "SYLLABE KATAKANA RU",NULL},
/* 30EC */ { "SYLLABE KATAKANA RE",NULL},
/* 30ED */ { "SYLLABE KATAKANA RO",NULL},
/* 30EE */ { "SYLLABE KATAKANA PETIT WA",NULL},
/* 30EF */ { "SYLLABE KATAKANA WA",NULL},
/* 30F0 */ { "SYLLABE KATAKANA WI",NULL},
/* 30F1 */ { "SYLLABE KATAKANA WE",NULL},
/* 30F2 */ { "SYLLABE KATAKANA WO",NULL},
/* 30F3 */ { "SYLLABE KATAKANA N",NULL},
/* 30F4 */ { "SYLLABE KATAKANA VU","	: 30A6 3099"},
/* 30F5 */ { "SYLLABE KATAKANA PETIT KA",NULL},
/* 30F6 */ { "SYLLABE KATAKANA PETIT KE",NULL},
/* 30F7 */ { "SYLLABE KATAKANA VA","	: 30EF 3099"},
/* 30F8 */ { "SYLLABE KATAKANA VI","	: 30F0 3099"},
/* 30F9 */ { "SYLLABE KATAKANA VE","	: 30F1 3099"},
/* 30FA */ { "SYLLABE KATAKANA VO","	: 30F2 3099"},
/* 30FB */ { "POINT MÉDIAN KATAKANA","	x (point médian - 00B7)"},
/* 30FC */ { "MARQUE KATAKANA-HIRAGANA DE SON PROLONGÉ","	x (tiret cadratin - 2014)"},
/* 30FD */ { "MARQUE D'ITÉRATION KATAKANA",NULL},
/* 30FE */ { "MARQUE D'ITÉRATION VOISÉE KATAKANA","	: 30FD 3099"},
/* 30FF */ { "DIGRAMME KATAKANA KOTO","	* utilisé autrefois dans des dispositions verticales, mais aujourd'hui également dans une mise en forme horizontale\n"
	"	# <verticale> 30B3 30C8"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_31[] = {
/* 3100 */ { NULL,NULL},
/* 3101 */ { NULL,NULL},
/* 3102 */ { NULL,NULL},
/* 3103 */ { NULL,NULL},
/* 3104 */ { NULL,NULL},
/* 3105 */ { "LETTRE BOPOMOFO P",NULL},
/* 3106 */ { "LETTRE BOPOMOFO P'",NULL},
/* 3107 */ { "LETTRE BOPOMOFO M",NULL},
/* 3108 */ { "LETTRE BOPOMOFO F",NULL},
/* 3109 */ { "LETTRE BOPOMOFO T",NULL},
/* 310A */ { "LETTRE BOPOMOFO T'",NULL},
/* 310B */ { "LETTRE BOPOMOFO N",NULL},
/* 310C */ { "LETTRE BOPOMOFO L",NULL},
/* 310D */ { "LETTRE BOPOMOFO K",NULL},
/* 310E */ { "LETTRE BOPOMOFO K'",NULL},
/* 310F */ { "LETTRE BOPOMOFO H",NULL},
/* 3110 */ { "LETTRE BOPOMOFO TS",NULL},
/* 3111 */ { "LETTRE BOPOMOFO TS'",NULL},
/* 3112 */ { "LETTRE BOPOMOFO HS",NULL},
/* 3113 */ { "LETTRE BOPOMOFO TCH",NULL},
/* 3114 */ { "LETTRE BOPOMOFO TCH'",NULL},
/* 3115 */ { "LETTRE BOPOMOFO CH",NULL},
/* 3116 */ { "LETTRE BOPOMOFO J",NULL},
/* 3117 */ { "LETTRE BOPOMOFO TZ",NULL},
/* 3118 */ { "LETTRE BOPOMOFO TZ'",NULL},
/* 3119 */ { "LETTRE BOPOMOFO S",NULL},
/* 311A */ { "LETTRE BOPOMOFO A",NULL},
/* 311B */ { "LETTRE BOPOMOFO Ô",NULL},
/* 311C */ { "LETTRE BOPOMOFO E","	= lettre bopomofo ö"},
/* 311D */ { "LETTRE BOPOMOFO È",NULL},
/* 311E */ { "LETTRE BOPOMOFO AÏ",NULL},
/* 311F */ { "LETTRE BOPOMOFO EI",NULL},
/* 3120 */ { "LETTRE BOPOMOFO AO",NULL},
/* 3121 */ { "LETTRE BOPOMOFO EOU",NULL},
/* 3122 */ { "LETTRE BOPOMOFO AN",NULL},
/* 3123 */ { "LETTRE BOPOMOFO EN",NULL},
/* 3124 */ { "LETTRE BOPOMOFO ANG",NULL},
/* 3125 */ { "LETTRE BOPOMOFO ENG",NULL},
/* 3126 */ { "LETTRE BOPOMOFO EUL",NULL},
/* 3127 */ { "LETTRE BOPOMOFO I","	* la forme verticale du trait est une variante d'affichage"},
/* 3128 */ { "LETTRE BOPOMOFO OU",NULL},
/* 3129 */ { "LETTRE BOPOMOFO U",NULL},
/* 312A */ { "LETTRE BOPOMOFO V",NULL},
/* 312B */ { "LETTRE BOPOMOFO NG",NULL},
/* 312C */ { "LETTRE BOPOMOFO GN",NULL},
/* 312D */ { "LETTRE BOPOMOFO IH",NULL},
/* 312E */ { "LETTRE BOPOMOFO Ô POINT EN CHEF","	* forme ancienne de la lettre e"},
/* 312F */ { NULL,NULL},
/* 3130 */ { NULL,NULL},
/* 3131 */ { "LETTRE HANGÛL KIYOK","	# 1100 hangûl tch'ôsong kiyok"},
/* 3132 */ { "LETTRE HANGÛL SSANGKIYOK","	# 1101 hangûl tch'ôsong ssangkiyok"},
/* 3133 */ { "LETTRE HANGÛL KIYOK-SIÔS","	# 11AA hangûl djôngsong kiyok-siôs"},
/* 3134 */ { "LETTRE HANGÛL NIÛN","	# 1102 hangûl tch'ôsong niûn"},
/* 3135 */ { "LETTRE HANGÛL NIÛN-TCHIÛTCH","	# 11AC hangûl djôngsong niûn-tchiûtch"},
/* 3136 */ { "LETTRE HANGÛL NIÛN-HIÛH","	# 11AD hangûl djôngsong niûn-hiûh"},
/* 3137 */ { "LETTRE HANGÛL TIKÛT","	# 1103 hangûl tch'ôsong tikût"},
/* 3138 */ { "LETTRE HANGÛL SSANGTIKÛT","	# 1104 hangûl tch'ôsong ssangtikût"},
/* 3139 */ { "LETTRE HANGÛL RIÛL","	# 1105 hangûl tch'ôsong riûl"},
/* 313A */ { "LETTRE HANGÛL RIÛL-KIYOK","	# 11B0 hangûl djôngsong riûl-kiyok"},
/* 313B */ { "LETTRE HANGÛL RIÛL-MIÛM","	# 11B1 hangûl djôngsong riûl-miûm"},
/* 313C */ { "LETTRE HANGÛL RIÛL-PIÛP","	# 11B2 hangûl djôngsong riûl-piûp"},
/* 313D */ { "LETTRE HANGÛL RIÛL-SIÔS","	# 11B3 hangûl djôngsong riûl-siôs"},
/* 313E */ { "LETTRE HANGÛL RIÛL-T'IÛT'","	# 11B4 hangûl djôngsong riûl-t'iût'"},
/* 313F */ { "LETTRE HANGÛL RIÛL-P'IÛP'","	# 11B5 hangûl djôngsong riûl-p'iûp'"},
/* 3140 */ { "LETTRE HANGÛL RIÛL-HIÛH","	# 111A hangûl tch'ôsong riûl-hiûh"},
/* 3141 */ { "LETTRE HANGÛL MIÛM","	# 1106 hangûl tch'ôsong miûm"},
/* 3142 */ { "LETTRE HANGÛL PIÛP","	# 1107 hangûl tch'ôsong piûp"},
/* 3143 */ { "LETTRE HANGÛL SSANGPIÛP","	# 1108 hangûl tch'ôsong ssangpiûp"},
/* 3144 */ { "LETTRE HANGÛL PIÛP-SIÔS","	# 1121 hangûl tch'ôsong piûp-siôs"},
/* 3145 */ { "LETTRE HANGÛL SIÔS","	# 1109 hangûl tch'ôsong siôs"},
/* 3146 */ { "LETTRE HANGÛL SSANGSIÔS","	# 110A hangûl tch'ôsong ssangsiôs"},
/* 3147 */ { "LETTRE HANGÛL IÛNG","	# 110B hangûl tch'ôsong iûng"},
/* 3148 */ { "LETTRE HANGÛL TCHIÛTCH","	# 110C hangûl tch'ôsong tchiûtch"},
/* 3149 */ { "LETTRE HANGÛL SSANGTCHIÛTCH","	# 110D hangûl tch'ôsong ssangtchiûtch"},
/* 314A */ { "LETTRE HANGÛL TCH'IÛTCH'","	# 110E hangûl tch'ôsong tch'iûtch'"},
/* 314B */ { "LETTRE HANGÛL K'IÛK'","	# 110F hangûl tch'ôsong k'iûk'"},
/* 314C */ { "LETTRE HANGÛL T'IÛT'","	# 1110 hangûl tch'ôsong t'iût'"},
/* 314D */ { "LETTRE HANGÛL P'IÛP'","	# 1111 hangûl tch'ôsong p'iûp'"},
/* 314E */ { "LETTRE HANGÛL HIÛH","	# 1112 hangûl tch'ôsong hiûh"},
/* 314F */ { "LETTRE HANGÛL A","	# 1161 hangûl djoungsong a"},
/* 3150 */ { "LETTRE HANGÛL È","	# 1162 hangûl djoungsong è"},
/* 3151 */ { "LETTRE HANGÛL YA","	# 1163 hangûl djoungsong ya"},
/* 3152 */ { "LETTRE HANGÛL YÈ","	# 1164 hangûl djoungsong yè"},
/* 3153 */ { "LETTRE HANGÛL O","	# 1165 hangûl djoungsong o"},
/* 3154 */ { "LETTRE HANGÛL É","	# 1166 hangûl djoungsong é"},
/* 3155 */ { "LETTRE HANGÛL YO","	# 1167 hangûl djoungsong yo"},
/* 3156 */ { "LETTRE HANGÛL YÉ","	# 1168 hangûl djoungsong yé"},
/* 3157 */ { "LETTRE HANGÛL Ô","	# 1169 hangûl djoungsong ô"},
/* 3158 */ { "LETTRE HANGÛL WA","	# 116A hangûl djoungsong wa"},
/* 3159 */ { "LETTRE HANGÛL WÈ","	# 116B hangûl djoungsong wè"},
/* 315A */ { "LETTRE HANGÛL EU","	# 116C hangûl djoungsong eu"},
/* 315B */ { "LETTRE HANGÛL YÔ","	# 116D hangûl djoungsong yô"},
/* 315C */ { "LETTRE HANGÛL OU","	# 116E hangûl djoungsong ou"},
/* 315D */ { "LETTRE HANGÛL WO","	# 116F hangûl djoungsong wo"},
/* 315E */ { "LETTRE HANGÛL WÉ","	# 1170 hangûl djoungsong wé"},
/* 315F */ { "LETTRE HANGÛL WI","	# 1171 hangûl djoungsong wi"},
/* 3160 */ { "LETTRE HANGÛL YOU","	# 1172 hangûl djoungsong you"},
/* 3161 */ { "LETTRE HANGÛL Û","	# 1173 hangûl djoungsong û"},
/* 3162 */ { "LETTRE HANGÛL ÛI","	# 1174 hangûl djoungsong ûi"},
/* 3163 */ { "LETTRE HANGÛL I","	# 1175 hangûl djoungsong i"},
/* 3164 */ { "BOURRE HANGÛL","	= tch'è\n"
	"	# 1160 bourre hangûl djoungsong"},
/* 3165 */ { "LETTRE HANGÛL SSANGNIÛN","	# 1114 hangûl tch'ôsong ssangniûn"},
/* 3166 */ { "LETTRE HANGÛL NIÛN-TIKÛT","	# 1115 hangûl tch'ôsong niûn-tikût"},
/* 3167 */ { "LETTRE HANGÛL NIÛN-SIÔS","	# 11C7 hangûl djôngsong niûn-siôs"},
/* 3168 */ { "LETTRE HANGÛL NIÛN-PANSIÔS","	# 11C8 hangûl djôngsong niûn-pansiôs"},
/* 3169 */ { "LETTRE HANGÛL RIÛL-KIYOK-SIÔS","	# 11CC hangûl djôngsong riûl-kiyok-siôs"},
/* 316A */ { "LETTRE HANGÛL RIÛL-TIKÛT","	# 11CE hangûl djôngsong riûl-tikût"},
/* 316B */ { "LETTRE HANGÛL RIÛL-PIÛP-SIÔS","	# 11D3 hangûl djôngsong riûl-piûp-siôs"},
/* 316C */ { "LETTRE HANGÛL RIÛL-PANSIÔS","	# 11D7 hangûl djôngsong riûl-pansiôs"},
/* 316D */ { "LETTRE HANGÛL RIÛL-YORINHIÛH","	# 11D9 hangûl djôngsong riûl-yorinhiûh"},
/* 316E */ { "LETTRE HANGÛL MIÛM-PIÛP","	# 111C hangûl tch'ôsong miûm-piûp"},
/* 316F */ { "LETTRE HANGÛL MIÛM-SIÔS","	# 11DD hangûl djôngsong miûm-siôs"},
/* 3170 */ { "LETTRE HANGÛL MIÛM-PANSIÔS","	# 11DF hangûl djôngsong miûm-pansiôs"},
/* 3171 */ { "LETTRE HANGÛL KAPYO-OUNMIÛM","	# 111D hangûl tch'ôsong kapyo-ounmiûm"},
/* 3172 */ { "LETTRE HANGÛL PIÛP-KIYOK","	# 111E hangûl tch'ôsong piûp-kiyok"},
/* 3173 */ { "LETTRE HANGÛL PIÛP-TIKÛT","	# 1120 hangûl tch'ôsong piûp-tikût"},
/* 3174 */ { "LETTRE HANGÛL PIÛP-SIÔS-KIYOK","	# 1122 hangûl tch'ôsong piûp-siôs-kiyok"},
/* 3175 */ { "LETTRE HANGÛL PIÛP-SIÔS-TIKÛT","	# 1123 hangûl tch'ôsong piûp-siôs-tikût"},
/* 3176 */ { "LETTRE HANGÛL PIÛP-TCHIÛTCH","	# 1127 hangûl tch'ôsong piûp-tchiûtch"},
/* 3177 */ { "LETTRE HANGÛL PIÛP-T'IÛT'","	# 1129 hangûl tch'ôsong piûp-t'iût'"},
/* 3178 */ { "LETTRE HANGÛL KAPYO-OUNPIÛP","	# 112B hangûl tch'ôsong kapyo-ounpiûp"},
/* 3179 */ { "LETTRE HANGÛL KAPYO-OUNSSANGPIÛP","	# 112C hangûl tch'ôsong kapyo-ounssangpiûp"},
/* 317A */ { "LETTRE HANGÛL SIÔS-KIYOK","	# 112D hangûl tch'ôsong siôs-kiyok"},
/* 317B */ { "LETTRE HANGÛL SIÔS-NIÛN","	# 112E hangûl tch'ôsong siôs-niûn"},
/* 317C */ { "LETTRE HANGÛL SIÔS-TIKÛT","	# 112F hangûl tch'ôsong siôs-tikût"},
/* 317D */ { "LETTRE HANGÛL SIÔS-PIÛP","	# 1132 hangûl tch'ôsong siôs-piûp"},
/* 317E */ { "LETTRE HANGÛL SIÔS-TCHIÛTCH","	# 1136 hangûl tch'ôsong siôs-tchiûtch"},
/* 317F */ { "LETTRE HANGÛL PANSIÔS","	# 1140 hangûl tch'ôsong pansiôs"},
/* 3180 */ { "LETTRE HANGÛL SSANGIÛNG","	# 1147 hangûl tch'ôsong ssangiûng"},
/* 3181 */ { "LETTRE HANGÛL YESIÛNG","	# 114C hangûl tch'ôsong yesiûng"},
/* 3182 */ { "LETTRE HANGÛL YESIÛNG-SIÔS","	# 11F1 hangûl djôngsong yesiûng-siôs"},
/* 3183 */ { "LETTRE HANGÛL YESIÛNG-PANSIÔS","	# 11F2 hangûl djôngsong yesiûng-pansiôs"},
/* 3184 */ { "LETTRE HANGÛL KAPYO-OUNP'IÛP'","	# 1157 hangûl tch'ôsong kapyo-ounp'iûp'"},
/* 3185 */ { "LETTRE HANGÛL SSANGHIÛH","	# 1158 hangûl tch'ôsong ssanghiûh"},
/* 3186 */ { "LETTRE HANGÛL YORINHIÛH","	* coup de glotte\n"
	"	# 1159 hangûl tch'ôsong yorinhiûh"},
/* 3187 */ { "LETTRE HANGÛL YÔ-YA","	# 1184 hangûl djoungsong yô-ya"},
/* 3188 */ { "LETTRE HANGÛL YÔ-YÈ","	# 1185 hangûl djoungsong yô-yè"},
/* 3189 */ { "LETTRE HANGÛL YÔ-I","	# 1188 hangûl djoungsong yô-i"},
/* 318A */ { "LETTRE HANGÛL YOU-YO","	# 1191 hangûl djoungsong you-yo"},
/* 318B */ { "LETTRE HANGÛL YOU-YÉ","	# 1192 hangûl djoungsong you-yé"},
/* 318C */ { "LETTRE HANGÛL YOU-I","	# 1194 hangûl djoungsong you-i"},
/* 318D */ { "LETTRE HANGÛL ARÈA","	# 119E hangûl djoungsong arèa"},
/* 318E */ { "LETTRE HANGÛL ARÈÈ","	# 11A1 hangûl djoungsong arèa-i"},
/* 318F */ { NULL,NULL},
/* 3190 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DE LIAISON","	= tatétén"},
/* 3191 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE D'INVERSION","	= kèritén ré"},
/* 3192 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE UN","	# <exp> 4E00"},
/* 3193 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DEUX","	# <exp> 4E8C"},
/* 3194 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE TROIS","	# <exp> 4E09"},
/* 3195 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE QUATRE","	# <exp> 56DB"},
/* 3196 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU HAUT","	# <exp> 4E0A"},
/* 3197 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU CENTRE","	# <exp> 4E2D"},
/* 3198 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU BAS","	# <exp> 4E0B"},
/* 3199 */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU PREMIER","	# <exp> 7532"},
/* 319A */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU SECOND","	# <exp> 4E59"},
/* 319B */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU TROISIÈME","	# <exp> 4E19"},
/* 319C */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU QUATRIÈME","	# <exp> 4E01"},
/* 319D */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DU CIEL","	# <exp> 5929"},
/* 319E */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DE LA TERRE","	# <exp> 5730"},
/* 319F */ { "MARQUE D'ANNOTATION IDÉOGRAPHIQUE DE L'HOMME","	# <exp> 4EBA"},
/* 31A0 */ { "LETTRE BOPOMOFO B",NULL},
/* 31A1 */ { "LETTRE BOPOMOFO Z",NULL},
/* 31A2 */ { "LETTRE BOPOMOFO DJ",NULL},
/* 31A3 */ { "LETTRE BOPOMOFO G",NULL},
/* 31A4 */ { "LETTRE BOPOMOFO É",NULL},
/* 31A5 */ { "LETTRE BOPOMOFO ENN",NULL},
/* 31A6 */ { "LETTRE BOPOMOFO O",NULL},
/* 31A7 */ { "LETTRE BOPOMOFO ONN",NULL},
/* 31A8 */ { "LETTRE BOPOMOFO ÎL",NULL},
/* 31A9 */ { "LETTRE BOPOMOFO ANN",NULL},
/* 31AA */ { "LETTRE BOPOMOFO INN",NULL},
/* 31AB */ { "LETTRE BOPOMOFO OUNN",NULL},
/* 31AC */ { "LETTRE BOPOMOFO IM",NULL},
/* 31AD */ { "LETTRE BOPOMOFO NGG",NULL},
/* 31AE */ { "LETTRE BOPOMOFO AÏNN",NULL},
/* 31AF */ { "LETTRE BOPOMOFO AONN",NULL},
/* 31B0 */ { "LETTRE BOPOMOFO AM",NULL},
/* 31B1 */ { "LETTRE BOPOMOFO OM",NULL},
/* 31B2 */ { "LETTRE BOPOMOFO ONG",NULL},
/* 31B3 */ { "LETTRE BOPOMOFO INNN",NULL},
/* 31B4 */ { "LETTRE BOPOMOFO P FINAL",NULL},
/* 31B5 */ { "LETTRE BOPOMOFO T FINAL",NULL},
/* 31B6 */ { "LETTRE BOPOMOFO K' FINAL",NULL},
/* 31B7 */ { "LETTRE BOPOMOFO H FINAL",NULL},
/* 31B8 */ { "LETTRE BOPOMOFO GH",NULL},
/* 31B9 */ { "LETTRE BOPOMOFO LH",NULL},
/* 31BA */ { "LETTRE BOPOMOFO ZY",NULL},
/* 31BB */ { NULL,NULL},
/* 31BC */ { NULL,NULL},
/* 31BD */ { NULL,NULL},
/* 31BE */ { NULL,NULL},
/* 31BF */ { NULL,NULL},
/* 31C0 */ { "TRAIT CJC T","	* 2e trait de 51B0"},
/* 31C1 */ { "TRAIT CJC WG","	* 2e trait de 72D0"},
/* 31C2 */ { "TRAIT CJC XG","	* 5e trait de 6211"},
/* 31C3 */ { "TRAIT CJC BXG","	* 2e trait de 5FC3"},
/* 31C4 */ { "TRAIT CJC SW","	* 3e trait de 4EA1\n"
	"	* 4e trait de 56DB"},
/* 31C5 */ { "TRAIT CJC HZZ","	* 1er trait de 534D"},
/* 31C6 */ { "TRAIT CJC HZG","	* 1er trait de7FBD\n"
	"	* 1er trait de4E5F"},
/* 31C7 */ { "TRAIT CJC HP","	* 1er trait de 53C8\n"
	"	* 4e trait de 4ECA"},
/* 31C8 */ { "TRAIT CJC HZWG","	* 1er trait de 98DE\n"
	"	* 2e trait de 4E5D"},
/* 31C9 */ { "TRAIT CJC SZWG","	* 3e trait de 5F13\n"
	"	* 2e trait de 9A6C"},
/* 31CA */ { "TRAIT CJC HZT","	* 2e trait de 8BA1\n"
	"	* 2e trait de 9CE9"},
/* 31CB */ { "TRAIT CJC HZZP","	* 1er trait de 53CA"},
/* 31CC */ { "TRAIT CJC HPWG","	* 1er trait de 961D\n"
	"	* 6e trait de 90AE"},
/* 31CD */ { "TRAIT CJC HZW","	* 5e trait de 6295"},
/* 31CE */ { "TRAIT CJC HZZZ","	* 1er trait de 51F8"},
/* 31CF */ { "TRAIT CJC N","	* 3e trait de 5927"},
/* 31D0 */ { "TRAIT CJC H","	* 1er trait de 5927\n"
	"	* 1er trait de 4E03"},
/* 31D1 */ { "TRAIT CJC S","	* 4e trait de 4E2D"},
/* 31D2 */ { "TRAIT CJC P","	* 1er trait de 4E4F"},
/* 31D3 */ { "TRAIT CJC SP","	* 1er trait de 6708"},
/* 31D4 */ { "TRAIT CJC D","	* 3e trait de 4E38"},
/* 31D5 */ { "TRAIT CJC HZ","	* 2e trait de 56DB"},
/* 31D6 */ { "TRAIT CJC HG","	* 1er trait de 758B\n"
	"	* 1er trait de 5B50"},
/* 31D7 */ { "TRAIT CJC SZ","	* 2e trait de 5C71\n"
	"	* 2e trait de 4E1C"},
/* 31D8 */ { "TRAIT CJC SWZ","	* 6e trait de 8085"},
/* 31D9 */ { "TRAIT CJC ST","	* 3e trait de 6C11"},
/* 31DA */ { "TRAIT CJC SG","	* 1er trait de 6C34"},
/* 31DB */ { "TRAIT CJC PD","	* 1er trait de 5DE1\n"
	"	* 1er trait de 5973"},
/* 31DC */ { "TRAIT CJC PZ","	* 3e trait de 516C\n"
	"	* 4e trait de 5F18"},
/* 31DD */ { "TRAIT CJC TN","	* 8e trait de 5EFB"},
/* 31DE */ { "TRAIT CJC SZZ","	* 1er trait de 5350\n"
	"	* 4e trait de 4E9E"},
/* 31DF */ { "TRAIT CJC SWG","	* 7e trait de 4E71\n"
	"	* 3e trait de 5DF1"},
/* 31E0 */ { "TRAIT CJC HXWG","	* 1er trait de 4E59"},
/* 31E1 */ { "TRAIT CJC HZZZG","	* 1er trait de 4E43"},
/* 31E2 */ { "TRAIT CJC PG","	* 1er trait de 4E44"},
/* 31E3 */ { "TRAIT CJC Q","	* 6e trait de 3514"},
/* 31E4 */ { NULL,NULL},
/* 31E5 */ { NULL,NULL},
/* 31E6 */ { NULL,NULL},
/* 31E7 */ { NULL,NULL},
/* 31E8 */ { NULL,NULL},
/* 31E9 */ { NULL,NULL},
/* 31EA */ { NULL,NULL},
/* 31EB */ { NULL,NULL},
/* 31EC */ { NULL,NULL},
/* 31ED */ { NULL,NULL},
/* 31EE */ { NULL,NULL},
/* 31EF */ { NULL,NULL},
/* 31F0 */ { "SYLLABE KATAKANA PETIT KU",NULL},
/* 31F1 */ { "SYLLABE KATAKANA PETIT SI",NULL},
/* 31F2 */ { "SYLLABE KATAKANA PETIT SU",NULL},
/* 31F3 */ { "SYLLABE KATAKANA PETIT TO",NULL},
/* 31F4 */ { "SYLLABE KATAKANA PETIT NU",NULL},
/* 31F5 */ { "SYLLABE KATAKANA PETIT HA",NULL},
/* 31F6 */ { "SYLLABE KATAKANA PETIT HI",NULL},
/* 31F7 */ { "SYLLABE KATAKANA PETIT HU",NULL},
/* 31F8 */ { "SYLLABE KATAKANA PETIT HE",NULL},
/* 31F9 */ { "SYLLABE KATAKANA PETIT HO",NULL},
/* 31FA */ { "SYLLABE KATAKANA PETIT MU",NULL},
/* 31FB */ { "SYLLABE KATAKANA PETIT RA",NULL},
/* 31FC */ { "SYLLABE KATAKANA PETIT RI",NULL},
/* 31FD */ { "SYLLABE KATAKANA PETIT RU",NULL},
/* 31FE */ { "SYLLABE KATAKANA PETIT RE",NULL},
/* 31FF */ { "SYLLABE KATAKANA PETIT RO",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_32[] = {
/* 3200 */ { "HANGÛL KIYOK ENTRE PARENTHÈSES","	# 0028 1100 0029"},
/* 3201 */ { "HANGÛL NIÛN ENTRE PARENTHÈSES","	# 0028 1102 0029"},
/* 3202 */ { "HANGÛL TIKÛT ENTRE PARENTHÈSES","	# 0028 1103 0029"},
/* 3203 */ { "HANGÛL RIÛL ENTRE PARENTHÈSES","	# 0028 1105 0029"},
/* 3204 */ { "HANGÛL MIÛM ENTRE PARENTHÈSES","	# 0028 1106 0029"},
/* 3205 */ { "HANGÛL PIÛP ENTRE PARENTHÈSES","	# 0028 1107 0029"},
/* 3206 */ { "HANGÛL SIÔS ENTRE PARENTHÈSES","	# 0028 1109 0029"},
/* 3207 */ { "HANGÛL IÛNG ENTRE PARENTHÈSES","	# 0028 110B 0029"},
/* 3208 */ { "HANGÛL TCHIÛTCH ENTRE PARENTHÈSES","	# 0028 110C 0029"},
/* 3209 */ { "HANGÛL TCH'IÛTCH' ENTRE PARENTHÈSES","	# 0028 110E 0029"},
/* 320A */ { "HANGÛL K'IÛK' ENTRE PARENTHÈSES","	# 0028 110F 0029"},
/* 320B */ { "HANGÛL T'IÛT' ENTRE PARENTHÈSES","	# 0028 1110 0029"},
/* 320C */ { "HANGÛL P'IÛP' ENTRE PARENTHÈSES","	# 0028 1111 0029"},
/* 320D */ { "HANGÛL HIÛH ENTRE PARENTHÈSES","	# 0028 1112 0029"},
/* 320E */ { "HANGÛL KIYOK A ENTRE PARENTHÈSES","	# 0028 1100 1161 0029"},
/* 320F */ { "HANGÛL NIÛN A ENTRE PARENTHÈSES","	# 0028 1102 1161 0029"},
/* 3210 */ { "HANGÛL TIKÛT A ENTRE PARENTHÈSES","	# 0028 1103 1161 0029"},
/* 3211 */ { "HANGÛL RIÛL A ENTRE PARENTHÈSES","	# 0028 1105 1161 0029"},
/* 3212 */ { "HANGÛL MIÛM A ENTRE PARENTHÈSES","	# 0028 1106 1161 0029"},
/* 3213 */ { "HANGÛL PIÛP A ENTRE PARENTHÈSES","	# 0028 1107 1161 0029"},
/* 3214 */ { "HANGÛL SIÔS A ENTRE PARENTHÈSES","	# 0028 1109 1161 0029"},
/* 3215 */ { "HANGÛL IÛNG A ENTRE PARENTHÈSES","	# 0028 110B 1161 0029"},
/* 3216 */ { "HANGÛL TCHIÛTCH A ENTRE PARENTHÈSES","	# 0028 110C 1161 0029"},
/* 3217 */ { "HANGÛL TCH'IÛTCH' A ENTRE PARENTHÈSES","	# 0028 110E 1161 0029"},
/* 3218 */ { "HANGÛL K'IÛK' A ENTRE PARENTHÈSES","	# 0028 110F 1161 0029"},
/* 3219 */ { "HANGÛL T'IÛT' A ENTRE PARENTHÈSES","	# 0028 1110 1161 0029"},
/* 321A */ { "HANGÛL P'IÛP' A ENTRE PARENTHÈSES","	# 0028 1111 1161 0029"},
/* 321B */ { "HANGÛL HIÛH A ENTRE PARENTHÈSES","	# 0028 1112 1161 0029"},
/* 321C */ { "HANGÛL TCHIÛTCH OU ENTRE PARENTHÈSES","	# 0028 110C 116E 0029"},
/* 321D */ { "CARACTÈRE CORÉEN ENTRE PARENTHÈSES Ô TCHON","	# 0028 110B 1169 110C 1165 11AB 0029"},
/* 321E */ { "CARACTÈRE CORÉEN ENTRE PARENTHÈSES Ô HOU","	# 0028 110B 1169 1112 116E 0029"},
/* 321F */ { NULL,NULL},
/* 3220 */ { "IDÉOGRAMME UN ENTRE PARENTHÈSES","	# 0028 4E00 0029"},
/* 3221 */ { "IDÉOGRAMME DEUX ENTRE PARENTHÈSES","	# 0028 4E8C 0029"},
/* 3222 */ { "IDÉOGRAMME TROIS ENTRE PARENTHÈSES","	# 0028 4E09 0029"},
/* 3223 */ { "IDÉOGRAMME QUATRE ENTRE PARENTHÈSES","	# 0028 56DB 0029"},
/* 3224 */ { "IDÉOGRAMME CINQ ENTRE PARENTHÈSES","	# 0028 4E94 0029"},
/* 3225 */ { "IDÉOGRAMME SIX ENTRE PARENTHÈSES","	# 0028 516D 0029"},
/* 3226 */ { "IDÉOGRAMME SEPT ENTRE PARENTHÈSES","	# 0028 4E03 0029"},
/* 3227 */ { "IDÉOGRAMME HUIT ENTRE PARENTHÈSES","	# 0028 516B 0029"},
/* 3228 */ { "IDÉOGRAMME NEUF ENTRE PARENTHÈSES","	# 0028 4E5D 0029"},
/* 3229 */ { "IDÉOGRAMME DIX ENTRE PARENTHÈSES","	# 0028 5341 0029"},
/* 322A */ { "IDÉOGRAMME LUNE ENTRE PARENTHÈSES","	* lundi\n"
	"	# 0028 6708 0029"},
/* 322B */ { "IDÉOGRAMME FEU ENTRE PARENTHÈSES","	* mardi\n"
	"	# 0028 706B 0029"},
/* 322C */ { "IDÉOGRAMME EAU ENTRE PARENTHÈSES","	* mercredi\n"
	"	# 0028 6C34 0029"},
/* 322D */ { "IDÉOGRAMME BOIS ENTRE PARENTHÈSES","	* jeudi\n"
	"	# 0028 6728 0029"},
/* 322E */ { "IDÉOGRAMME MÉTAL ENTRE PARENTHÈSES","	* vendredi\n"
	"	# 0028 91D1 0029"},
/* 322F */ { "IDÉOGRAMME TERRE ENTRE PARENTHÈSES","	* samedi\n"
	"	# 0028 571F 0029"},
/* 3230 */ { "IDÉOGRAMME SOLEIL ENTRE PARENTHÈSES","	* dimanche\n"
	"	# 0028 65E5 0029"},
/* 3231 */ { "IDÉOGRAMME MARCHANDISES ENTRE PARENTHÈSES","	* société enregistrée, société anonyme\n"
	"	# 0028 682A 0029"},
/* 3232 */ { "IDÉOGRAMME AVOIR ENTRE PARENTHÈSES","	* à responsabilité limitée\n"
	"	# 0028 6709 0029"},
/* 3233 */ { "IDÉOGRAMME SOCIÉTÉ ENTRE PARENTHÈSES","	* société\n"
	"	# 0028 793E 0029"},
/* 3234 */ { "IDÉOGRAMME NOM ENTRE PARENTHÈSES","	# 0028 540D 0029"},
/* 3235 */ { "IDÉOGRAMME SPÉCIAL ENTRE PARENTHÈSES","	# 0028 7279 0029"},
/* 3236 */ { "IDÉOGRAMME FINANCIER ENTRE PARENTHÈSES","	# 0028 8CA1 0029"},
/* 3237 */ { "IDÉOGRAMME FÉLICITATIONS ENTRE PARENTHÈSES","	# 0028 795D 0029"},
/* 3238 */ { "IDÉOGRAMME TRAVAIL ENTRE PARENTHÈSES","	# 0028 52B4 0029"},
/* 3239 */ { "IDÉOGRAMME REPRÉSENTE ENTRE PARENTHÈSES","	# 0028 4EE3 0029"},
/* 323A */ { "IDÉOGRAMME APPEL ENTRE PARENTHÈSES","	# 0028 547C 0029"},
/* 323B */ { "IDÉOGRAMME ÉTUDE ENTRE PARENTHÈSES","	# 0028 5B66 0029"},
/* 323C */ { "IDÉOGRAMME SUPERVISE ENTRE PARENTHÈSES","	# 0028 76E3 0029"},
/* 323D */ { "IDÉOGRAMME ENTREPRISE ENTRE PARENTHÈSES","	# 0028 4F01 0029"},
/* 323E */ { "IDÉOGRAMME RESSOURCE ENTRE PARENTHÈSES","	# 0028 8CC7 0029"},
/* 323F */ { "IDÉOGRAMME ALLIANCE ENTRE PARENTHÈSES","	# 0028 5354 0029"},
/* 3240 */ { "IDÉOGRAMME FESTIVAL ENTRE PARENTHÈSES","	# 0028 796D 0029"},
/* 3241 */ { "IDÉOGRAMME REPOS ENTRE PARENTHÈSES","	# 0028 4F11 0029"},
/* 3242 */ { "IDÉOGRAMME SOI ENTRE PARENTHÈSES","	* expéditeur\n"
	"	# 0028 81EA 0029"},
/* 3243 */ { "IDÉOGRAMME ATTEINDRE ENTRE PARENTHÈSES","	* destinataire\n"
	"	# 0028 81F3 0029"},
/* 3244 */ { "IDÉOGRAMME CERCLÉ QUESTION","	# <cerclée> 554F"},
/* 3245 */ { "IDÉOGRAMME CERCLÉ MATERNELLE","	# <cerclée> 5E7C"},
/* 3246 */ { "IDÉOGRAMME CERCLÉ ÉCOLE","	# <cerclée> 6587"},
/* 3247 */ { "IDÉOGRAMME CERCLÉ KOTO","	# <cerclée> 7B8F"},
/* 3248 */ { "NOMBRE DIX CERCLÉ SUR CARRÉ NOIR","	= limite de vitesse 10 km/h"},
/* 3249 */ { "NOMBRE VINGT CERCLÉ SUR CARRÉ NOIR","	= limite de vitesse 20 km/h"},
/* 324A */ { "NOMBRE TRENTE CERCLÉ SUR CARRÉ NOIR","	= limite de vitesse 30 km/h"},
/* 324B */ { "NOMBRE QUARANTE CERCLÉ SUR CARRÉ NOIR","	= limite de vitesse 40 km/h"},
/* 324C */ { "NOMBRE CINQUANTE CERCLÉ SUR CARRÉ NOIR","	= limite de vitesse 50 km/h"},
/* 324D */ { "NOMBRE SOIXANTE CERCLÉ SUR CARRÉ NOIR","	= limite de vitesse 60 km/h"},
/* 324E */ { "NOMBRE SOIXANTE-DIX CERCLÉ SUR CARRÉ NOIR","	= nombre septante cerclé sur carré noir\n"
	"	= limite de vitesse 70 km/h"},
/* 324F */ { "NOMBRE QUATRE-VINGTS CERCLÉ SUR CARRÉ NOIR","	= nombre huitante cerclé sur carré noir\n"
	"	= limite de vitesse 80 km/h"},
/* 3250 */ { "SYMBOLE PARTENARIAT","	# <enCarré> 0050 0054 0045"},
/* 3251 */ { "NOMBRE VINGT ET UN CERCLÉ","	# <cerclée> 0032 0031"},
/* 3252 */ { "NOMBRE VINGT-DEUX CERCLÉ","	# <cerclée> 0032 0032"},
/* 3253 */ { "NOMBRE VINGT-TROIS CERCLÉ","	# <cerclée> 0032 0033"},
/* 3254 */ { "NOMBRE VINGT-QUATRE CERCLÉ","	# <cerclée> 0032 0034"},
/* 3255 */ { "NOMBRE VINGT-CINQ CERCLÉ","	# <cerclée> 0032 0035"},
/* 3256 */ { "NOMBRE VINGT-SIX CERCLÉ","	# <cerclée> 0032 0036"},
/* 3257 */ { "NOMBRE VINGT-SEPT CERCLÉ","	# <cerclée> 0032 0037"},
/* 3258 */ { "NOMBRE VINGT-HUIT CERCLÉ","	# <cerclée> 0032 0038"},
/* 3259 */ { "NOMBRE VINGT-NEUF CERCLÉ","	# <cerclée> 0032 0039"},
/* 325A */ { "NOMBRE TRENTE CERCLÉ","	# <cerclée> 0033 0030"},
/* 325B */ { "NOMBRE TRENTE ET UN CERCLÉ","	# <cerclée> 0033 0031"},
/* 325C */ { "NOMBRE TRENTE-DEUX CERCLÉ","	# <cerclée> 0033 0032"},
/* 325D */ { "NOMBRE TRENTE-TROIS CERCLÉ","	# <cerclée> 0033 0033"},
/* 325E */ { "NOMBRE TRENTE-QUATRE CERCLÉ","	# <cerclée> 0033 0034"},
/* 325F */ { "NOMBRE TRENTE-CINQ CERCLÉ","	# <cerclée> 0033 0035"},
/* 3260 */ { "HANGÛL CERCLÉ KIYOK","	# <cerclée> 1100"},
/* 3261 */ { "HANGÛL CERCLÉ NIÛN","	# <cerclée> 1102"},
/* 3262 */ { "HANGÛL CERCLÉ TIKÛT","	# <cerclée> 1103"},
/* 3263 */ { "HANGÛL CERCLÉ RIÛL","	# <cerclée> 1105"},
/* 3264 */ { "HANGÛL CERCLÉ MIÛM","	# <cerclée> 1106"},
/* 3265 */ { "HANGÛL CERCLÉ PIÛP","	# <cerclée> 1107"},
/* 3266 */ { "HANGÛL CERCLÉ SIÔS","	# <cerclée> 1109"},
/* 3267 */ { "HANGÛL CERCLÉ IÛNG","	# <cerclée> 110B"},
/* 3268 */ { "HANGÛL CERCLÉ TCHIÛTCH","	# <cerclée> 110C"},
/* 3269 */ { "HANGÛL CERCLÉ TCH'IÛTCH'","	# <cerclée> 110E"},
/* 326A */ { "HANGÛL CERCLÉ K'IÛK'","	# <cerclée> 110F"},
/* 326B */ { "HANGÛL CERCLÉ T'IÛT'","	# <cerclée> 1110"},
/* 326C */ { "HANGÛL CERCLÉ P'IÛP'","	# <cerclée> 1111"},
/* 326D */ { "HANGÛL CERCLÉ HIÛH","	# <cerclée> 1112"},
/* 326E */ { "HANGÛL CERCLÉ KIYOK A","	# <cerclée> 1100 1161"},
/* 326F */ { "HANGÛL CERCLÉ NIÛN A","	# <cerclée> 1102 1161"},
/* 3270 */ { "HANGÛL CERCLÉ TIKÛT A","	# <cerclée> 1103 1161"},
/* 3271 */ { "HANGÛL CERCLÉ RIÛL A","	# <cerclée> 1105 1161"},
/* 3272 */ { "HANGÛL CERCLÉ MIÛM A","	# <cerclée> 1106 1161"},
/* 3273 */ { "HANGÛL CERCLÉ PIÛP A","	# <cerclée> 1107 1161"},
/* 3274 */ { "HANGÛL CERCLÉ SIÔS A","	# <cerclée> 1109 1161"},
/* 3275 */ { "HANGÛL CERCLÉ IÛNG A","	# <cerclée> 110B 1161"},
/* 3276 */ { "HANGÛL CERCLÉ TCHIÛTCH A","	# <cerclée> 110C 1161"},
/* 3277 */ { "HANGÛL CERCLÉ TCH'IÛTCH' A","	# <cerclée> 110E 1161"},
/* 3278 */ { "HANGÛL CERCLÉ K'IÛK' A","	# <cerclée> 110F 1161"},
/* 3279 */ { "HANGÛL CERCLÉ T'IÛT' A","	# <cerclée> 1110 1161"},
/* 327A */ { "HANGÛL CERCLÉ P'IÛP' A","	# <cerclée> 1111 1161"},
/* 327B */ { "HANGÛL CERCLÉ HIÛH A","	# <cerclée> 1112 1161"},
/* 327C */ { "CARACTÈRE CORÉEN CERCLÉ TCH'AMKÔ","	# <cerclée> 110E 1161 11B7 1100 1169"},
/* 327D */ { "CARACTÈRE CORÉEN CERCLÉ TCHOUÛI","	# <cerclée> 110C 116E 110B 1174"},
/* 327E */ { "HANGÛL CERCLÉ IÛNG OU","	* symbole de code postal\n"
	"	# <cerclée> 110B 116E"},
/* 327F */ { "SYMBOLE DE NORME CORÉENNE",NULL},
/* 3280 */ { "IDÉOGRAMME UN CERCLÉ","	= marou-iti, symbole d'unification\n"
	"	# <cerclée> 4E00"},
/* 3281 */ { "IDÉOGRAMME DEUX CERCLÉ","	# <cerclée> 4E8C"},
/* 3282 */ { "IDÉOGRAMME TROIS CERCLÉ","	# <cerclée> 4E09"},
/* 3283 */ { "IDÉOGRAMME QUATRE CERCLÉ","	# <cerclée> 56DB"},
/* 3284 */ { "IDÉOGRAMME CINQ CERCLÉ","	# <cerclée> 4E94"},
/* 3285 */ { "IDÉOGRAMME SIX CERCLÉ","	# <cerclée> 516D"},
/* 3286 */ { "IDÉOGRAMME SEPT CERCLÉ","	# <cerclée> 4E03"},
/* 3287 */ { "IDÉOGRAMME HUIT CERCLÉ","	# <cerclée> 516B"},
/* 3288 */ { "IDÉOGRAMME NEUF CERCLÉ","	# <cerclée> 4E5D"},
/* 3289 */ { "IDÉOGRAMME DIX CERCLÉ","	# <cerclée> 5341"},
/* 328A */ { "IDÉOGRAMME LUNE CERCLÉ","	* lundi\n"
	"	# <cerclée> 6708"},
/* 328B */ { "IDÉOGRAMME FEU CERCLÉ","	* mardi\n"
	"	# <cerclée> 706B"},
/* 328C */ { "IDÉOGRAMME EAU CERCLÉ","	* mercredi\n"
	"	# <cerclée> 6C34"},
/* 328D */ { "IDÉOGRAMME BOIS CERCLÉ","	* jeudi\n"
	"	# <cerclée> 6728"},
/* 328E */ { "IDÉOGRAMME MÉTAL CERCLÉ","	* vendredi\n"
	"	# <cerclée> 91D1"},
/* 328F */ { "IDÉOGRAMME TERRE CERCLÉ","	* samedi\n"
	"	# <cerclée> 571F"},
/* 3290 */ { "IDÉOGRAMME SOLEIL CERCLÉ","	* dimanche\n"
	"	# <cerclée> 65E5"},
/* 3291 */ { "IDÉOGRAMME MARCHANDISES CERCLÉ","	# <cerclée> 682A"},
/* 3292 */ { "IDÉOGRAMME AVOIR CERCLÉ","	* à responsabilité limitée\n"
	"	# <cerclée> 6709"},
/* 3293 */ { "IDÉOGRAMME SOCIÉTÉ CERCLÉ","	* société\n"
	"	# <cerclée> 793E"},
/* 3294 */ { "IDÉOGRAMME NOM CERCLÉ","	# <cerclée> 540D"},
/* 3295 */ { "IDÉOGRAMME SPÉCIAL CERCLÉ","	# <cerclée> 7279"},
/* 3296 */ { "IDÉOGRAMME FINANCIER CERCLÉ","	# <cerclée> 8CA1"},
/* 3297 */ { "IDÉOGRAMME FÉLICITATIONS CERCLÉ","	# <cerclée> 795D"},
/* 3298 */ { "IDÉOGRAMME TRAVAIL CERCLÉ","	# <cerclée> 52B4"},
/* 3299 */ { "IDÉOGRAMME SECRET CERCLÉ","	# <cerclée> 79D8"},
/* 329A */ { "IDÉOGRAMME MÂLE CERCLÉ","	# <cerclée> 7537"},
/* 329B */ { "IDÉOGRAMME FEMELLE CERCLÉ","	# <cerclée> 5973"},
/* 329C */ { "IDÉOGRAMME ACCEPTABLE CERCLÉ","	# <cerclée> 9069"},
/* 329D */ { "IDÉOGRAMME EXCELLENT CERCLÉ","	# <cerclée> 512A"},
/* 329E */ { "IDÉOGRAMME IMPRIMER CERCLÉ","	* posez ici votre sceau\n"
	"	# <cerclée> 5370"},
/* 329F */ { "IDÉOGRAMME ATTENTION CERCLÉ","	# <cerclée> 6CE8"},
/* 32A0 */ { "IDÉOGRAMME ARTICLE CERCLÉ","	# <cerclée> 9805"},
/* 32A1 */ { "IDÉOGRAMME REPOS CERCLÉ","	* férié\n"
	"	# <cerclée> 4F11"},
/* 32A2 */ { "IDÉOGRAMME COPIE CERCLÉ","	# <cerclée> 5199"},
/* 32A3 */ { "IDÉOGRAMME CORRECT CERCLÉ","	# <cerclée> 6B63"},
/* 32A4 */ { "IDÉOGRAMME HAUT CERCLÉ","	# <cerclée> 4E0A"},
/* 32A5 */ { "IDÉOGRAMME CENTRE CERCLÉ","	# <cerclée> 4E2D"},
/* 32A6 */ { "IDÉOGRAMME BAS CERCLÉ","	# <cerclée> 4E0B"},
/* 32A7 */ { "IDÉOGRAMME GAUCHE CERCLÉ","	# <cerclée> 5DE6"},
/* 32A8 */ { "IDÉOGRAMME DROIT CERCLÉ","	# <cerclée> 53F3"},
/* 32A9 */ { "IDÉOGRAMME MÉDECINE CERCLÉ","	# <cerclée> 533B"},
/* 32AA */ { "IDÉOGRAMME RELIGION CERCLÉ","	# <cerclée> 5B97"},
/* 32AB */ { "IDÉOGRAMME ÉTUDE CERCLÉ","	# <cerclée> 5B66"},
/* 32AC */ { "IDÉOGRAMME SUPERVISER CERCLÉ","	# <cerclée> 76E3"},
/* 32AD */ { "IDÉOGRAMME ENTREPRISE CERCLÉ","	# <cerclée> 4F01"},
/* 32AE */ { "IDÉOGRAMME RESSOURCE CERCLÉ","	# <cerclée> 8CC7"},
/* 32AF */ { "IDÉOGRAMME ALLIANCE CERCLÉ","	# <cerclée> 5354"},
/* 32B0 */ { "IDÉOGRAMME NUIT CERCLÉ","	# <cerclée> 591C"},
/* 32B1 */ { "NOMBRE TRENTE-SIX CERCLÉ","	# <cerclée> 0033 0036"},
/* 32B2 */ { "NOMBRE TRENTE-SEPT CERCLÉ","	# <cerclée> 0033 0037"},
/* 32B3 */ { "NOMBRE TRENTE-HUIT CERCLÉ","	# <cerclée> 0033 0038"},
/* 32B4 */ { "NOMBRE TRENTE-NEUF CERCLÉ","	# <cerclée> 0033 0039"},
/* 32B5 */ { "NOMBRE QUARANTE CERCLÉ","	# <cerclée> 0034 0030"},
/* 32B6 */ { "NOMBRE QUARANTE ET UN CERCLÉ","	# <cerclée> 0034 0031"},
/* 32B7 */ { "NOMBRE QUARANTE-DEUX CERCLÉ","	# <cerclée> 0034 0032"},
/* 32B8 */ { "NOMBRE QUARANTE-TROIS CERCLÉ","	# <cerclée> 0034 0033"},
/* 32B9 */ { "NOMBRE QUARANTE-QUATRE CERCLÉ","	# <cerclée> 0034 0034"},
/* 32BA */ { "NOMBRE QUARANTE-CINQ CERCLÉ","	# <cerclée> 0034 0035"},
/* 32BB */ { "NOMBRE QUARANTE-SIX CERCLÉ","	# <cerclée> 0034 0036"},
/* 32BC */ { "NOMBRE QUARANTE-SEPT CERCLÉ","	# <cerclée> 0034 0037"},
/* 32BD */ { "NOMBRE QUARANTE-HUIT CERCLÉ","	# <cerclée> 0034 0038"},
/* 32BE */ { "NOMBRE QUARANTE-NEUF CERCLÉ","	# <cerclée> 0034 0039"},
/* 32BF */ { "NOMBRE CINQUANTE CERCLÉ","	# <cerclée> 0035 0030"},
/* 32C0 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JANVIER","	# 0031 6708"},
/* 32C1 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE FÉVRIER","	# 0032 6708"},
/* 32C2 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE MARS","	# 0033 6708"},
/* 32C3 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE AVRIL","	# 0034 6708"},
/* 32C4 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE MAI","	# 0035 6708"},
/* 32C5 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JUIN","	# 0036 6708"},
/* 32C6 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JUILLET","	# 0037 6708"},
/* 32C7 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE AOÛT","	# 0038 6708"},
/* 32C8 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE SEPTEMBRE","	# 0039 6708"},
/* 32C9 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE OCTOBRE","	# 0031 0030 6708"},
/* 32CA */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE NOVEMBRE","	# 0031 0031 6708"},
/* 32CB */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE DÉCEMBRE","	# 0031 0032 6708"},
/* 32CC */ { "HG DISPOSÉ EN CARRÉ","	# <enCarré> 0048 0067"},
/* 32CD */ { "ERG DISPOSÉ EN CARRÉ","	# <enCarré> 0065 0072 0067"},
/* 32CE */ { "EV DISPOSÉ EN CARRÉ","	# <enCarré> 0065 0056"},
/* 32CF */ { "RESPONSABILITÉ LIMITÉE DISPOSÉ EN CARRÉ","	# <enCarré> 004C 0054 0044"},
/* 32D0 */ { "KATAKANA CERCLÉ A","	# <cerclée> 30A2"},
/* 32D1 */ { "KATAKANA CERCLÉ I","	# <cerclée> 30A4"},
/* 32D2 */ { "KATAKANA CERCLÉ U","	# <cerclée> 30A6"},
/* 32D3 */ { "KATAKANA CERCLÉ E","	# <cerclée> 30A8"},
/* 32D4 */ { "KATAKANA CERCLÉ O","	# <cerclée> 30AA"},
/* 32D5 */ { "KATAKANA CERCLÉ KA","	# <cerclée> 30AB"},
/* 32D6 */ { "KATAKANA CERCLÉ KI","	# <cerclée> 30AD"},
/* 32D7 */ { "KATAKANA CERCLÉ KU","	# <cerclée> 30AF"},
/* 32D8 */ { "KATAKANA CERCLÉ KE","	# <cerclée> 30B1"},
/* 32D9 */ { "KATAKANA CERCLÉ KO","	# <cerclée> 30B3"},
/* 32DA */ { "KATAKANA CERCLÉ SA","	# <cerclée> 30B5"},
/* 32DB */ { "KATAKANA CERCLÉ SI","	# <cerclée> 30B7"},
/* 32DC */ { "KATAKANA CERCLÉ SU","	# <cerclée> 30B9"},
/* 32DD */ { "KATAKANA CERCLÉ SE","	# <cerclée> 30BB"},
/* 32DE */ { "KATAKANA CERCLÉ SO","	# <cerclée> 30BD"},
/* 32DF */ { "KATAKANA CERCLÉ TA","	# <cerclée> 30BF"},
/* 32E0 */ { "KATAKANA CERCLÉ TI","	# <cerclée> 30C1"},
/* 32E1 */ { "KATAKANA CERCLÉ TU","	# <cerclée> 30C4"},
/* 32E2 */ { "KATAKANA CERCLÉ TE","	# <cerclée> 30C6"},
/* 32E3 */ { "KATAKANA CERCLÉ TO","	# <cerclée> 30C8"},
/* 32E4 */ { "KATAKANA CERCLÉ NA","	# <cerclée> 30CA"},
/* 32E5 */ { "KATAKANA CERCLÉ NI","	# <cerclée> 30CB"},
/* 32E6 */ { "KATAKANA CERCLÉ NU","	# <cerclée> 30CC"},
/* 32E7 */ { "KATAKANA CERCLÉ NE","	# <cerclée> 30CD"},
/* 32E8 */ { "KATAKANA CERCLÉ NO","	# <cerclée> 30CE"},
/* 32E9 */ { "KATAKANA CERCLÉ HA","	# <cerclée> 30CF"},
/* 32EA */ { "KATAKANA CERCLÉ HI","	# <cerclée> 30D2"},
/* 32EB */ { "KATAKANA CERCLÉ HU","	# <cerclée> 30D5"},
/* 32EC */ { "KATAKANA CERCLÉ HE","	# <cerclée> 30D8"},
/* 32ED */ { "KATAKANA CERCLÉ HO","	# <cerclée> 30DB"},
/* 32EE */ { "KATAKANA CERCLÉ MA","	# <cerclée> 30DE"},
/* 32EF */ { "KATAKANA CERCLÉ MI","	# <cerclée> 30DF"},
/* 32F0 */ { "KATAKANA CERCLÉ MU","	# <cerclée> 30E0"},
/* 32F1 */ { "KATAKANA CERCLÉ ME","	# <cerclée> 30E1"},
/* 32F2 */ { "KATAKANA CERCLÉ MO","	# <cerclée> 30E2"},
/* 32F3 */ { "KATAKANA CERCLÉ YA","	# <cerclée> 30E4"},
/* 32F4 */ { "KATAKANA CERCLÉ YU","	# <cerclée> 30E6"},
/* 32F5 */ { "KATAKANA CERCLÉ YO","	# <cerclée> 30E8"},
/* 32F6 */ { "KATAKANA CERCLÉ RA","	# <cerclée> 30E9"},
/* 32F7 */ { "KATAKANA CERCLÉ RI","	# <cerclée> 30EA"},
/* 32F8 */ { "KATAKANA CERCLÉ RU","	# <cerclée> 30EB"},
/* 32F9 */ { "KATAKANA CERCLÉ RE","	# <cerclée> 30EC"},
/* 32FA */ { "KATAKANA CERCLÉ RO","	# <cerclée> 30ED"},
/* 32FB */ { "KATAKANA CERCLÉ WA","	# <cerclée> 30EF"},
/* 32FC */ { "KATAKANA CERCLÉ WI","	# <cerclée> 30F0"},
/* 32FD */ { "KATAKANA CERCLÉ WE","	# <cerclée> 30F1"},
/* 32FE */ { "KATAKANA CERCLÉ WO","	# <cerclée> 30F2"},
/* 32FF */ { NULL,NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_33[] = {
/* 3300 */ { "APÂTO DISPOSÉ EN CARRÉ","	* appartement\n"
	"	# <enCarré> 30A2 30D1 30FC 30C8"},
/* 3301 */ { "ARUHUA DISPOSÉ EN CARRÉ","	* alpha\n"
	"	# <enCarré> 30A2 30EB 30D5 30A1"},
/* 3302 */ { "ANPEA DISPOSÉ EN CARRÉ","	* ampère\n"
	"	# <enCarré> 30A2 30F3 30DA 30A2"},
/* 3303 */ { "ÂRU DISPOSÉ EN CARRÉ","	* are (unité de superficie)\n"
	"	# <enCarré> 30A2 30FC 30EB"},
/* 3304 */ { "ININGU DISPOSÉ EN CARRÉ","	* manche (en baseball)\n"
	"	# <enCarré> 30A4 30CB 30F3 30B0"},
/* 3305 */ { "INTI DISPOSÉ EN CARRÉ","	* pouce\n"
	"	# <enCarré> 30A4 30F3 30C1"},
/* 3306 */ { "UON DISPOSÉ EN CARRÉ","	* won (devise coréenne)\n"
	"	# <enCarré> 30A6 30A9 30F3"},
/* 3307 */ { "ESUKÛDO DISPOSÉ EN CARRÉ","	* escudo (devise portugaise)\n"
	"	# <enCarré> 30A8 30B9 30AF 30FC 30C9"},
/* 3308 */ { "ÊKÂ DISPOSÉ EN CARRÉ","	* acre, arpent\n"
	"	# <enCarré> 30A8 30FC 30AB 30FC"},
/* 3309 */ { "ONSU DISPOSÉ EN CARRÉ","	* once\n"
	"	# <enCarré> 30AA 30F3 30B9"},
/* 330A */ { "ÔMU DISPOSÉ EN CARRÉ","	* ohm\n"
	"	# <enCarré> 30AA 30FC 30E0"},
/* 330B */ { "KAIRI DISPOSÉ EN CARRÉ","	* kai-ri : mille marin\n"
	"	# <enCarré> 30AB 30A4 30EA"},
/* 330C */ { "KARATTO DISPOSÉ EN CARRÉ","	* carat\n"
	"	# <enCarré> 30AB 30E9 30C3 30C8"},
/* 330D */ { "KARORÎ DISPOSÉ EN CARRÉ","	* calorie\n"
	"	# <enCarré> 30AB 30ED 30EA 30FC"},
/* 330E */ { "GARON DISPOSÉ EN CARRÉ","	* gallon\n"
	"	# <enCarré> 30AC 30ED 30F3"},
/* 330F */ { "GANMA DISPOSÉ EN CARRÉ","	* gamma\n"
	"	# <enCarré> 30AC 30F3 30DE"},
/* 3310 */ { "GIGA DISPOSÉ EN CARRÉ","	* giga-\n"
	"	# <enCarré> 30AE 30AC"},
/* 3311 */ { "GINÎ DISPOSÉ EN CARRÉ","	* guinée\n"
	"	# <enCarré> 30AE 30CB 30FC"},
/* 3312 */ { "KYURÎ DISPOSÉ EN CARRÉ","	* curie\n"
	"	# <enCarré> 30AD 30E5 30EA 30FC"},
/* 3313 */ { "GIRUDÂ DISPOSÉ EN CARRÉ","	* florin\n"
	"	# <enCarré> 30AE 30EB 30C0 30FC"},
/* 3314 */ { "KIRO DISPOSÉ EN CARRÉ","	* kilo-\n"
	"	# <enCarré> 30AD 30ED"},
/* 3315 */ { "KIROGURAMU DISPOSÉ EN CARRÉ","	* kilogramme\n"
	"	# <enCarré> 30AD 30ED 30B0 30E9 30E0"},
/* 3316 */ { "KIROMÊTORU DISPOSÉ EN CARRÉ","	* kilomètre\n"
	"	# <enCarré> 30AD 30ED 30E1 30FC 30C8 30EB"},
/* 3317 */ { "KIROWATTO DISPOSÉ EN CARRÉ","	* kilowatt\n"
	"	# <enCarré> 30AD 30ED 30EF 30C3 30C8"},
/* 3318 */ { "GURAMU DISPOSÉ EN CARRÉ","	* gramme\n"
	"	# <enCarré> 30B0 30E9 30E0"},
/* 3319 */ { "GURAMUTON DISPOSÉ EN CARRÉ","	* gramme par tonne\n"
	"	# <enCarré> 30B0 30E9 30E0 30C8 30F3"},
/* 331A */ { "KURUZEIRO DISPOSÉ EN CARRÉ","	* cruzeiro (devise brésilienne)\n"
	"	# <enCarré> 30AF 30EB 30BC 30A4 30ED"},
/* 331B */ { "KURÔNE DISPOSÉ EN CARRÉ","	* krone, couronne scandinave\n"
	"	# <enCarré> 30AF 30ED 30FC 30CD"},
/* 331C */ { "KÊSU DISPOSÉ EN CARRÉ","	* caisse\n"
	"	# <enCarré> 30B1 30FC 30B9"},
/* 331D */ { "KORUNA DISPOSÉ EN CARRÉ","	* koruna, couronne (devise tchèque)\n"
	"	# <enCarré> 30B3 30EB 30CA"},
/* 331E */ { "KÔPO DISPOSÉ EN CARRÉ","	* coop\n"
	"	# <enCarré> 30B3 30FC 30DD"},
/* 331F */ { "SAIKURU DISPOSÉ EN CARRÉ","	* cycle\n"
	"	# <enCarré> 30B5 30A4 30AF 30EB"},
/* 3320 */ { "SANTÎMU DISPOSÉ EN CARRÉ","	* centime\n"
	"	# <enCarré> 30B5 30F3 30C1 30FC 30E0"},
/* 3321 */ { "SIRINGU DISPOSÉ EN CARRÉ","	* shilling\n"
	"	# <enCarré> 30B7 30EA 30F3 30B0"},
/* 3322 */ { "SENTI DISPOSÉ EN CARRÉ","	* centi-\n"
	"	# <enCarré> 30BB 30F3 30C1"},
/* 3323 */ { "SENTO DISPOSÉ EN CARRÉ","	* cent(ime)\n"
	"	# <enCarré> 30BB 30F3 30C8"},
/* 3324 */ { "DÂSU DISPOSÉ EN CARRÉ","	* douzaine\n"
	"	# <enCarré> 30C0 30FC 30B9"},
/* 3325 */ { "DESI DISPOSÉ EN CARRÉ","	* déci-\n"
	"	# <enCarré> 30C7 30B7"},
/* 3326 */ { "DORU DISPOSÉ EN CARRÉ","	* dollar\n"
	"	# <enCarré> 30C9 30EB"},
/* 3327 */ { "TONNE DISPOSÉ EN CARRÉ","	* tonne\n"
	"	# <enCarré> 30C8 30F3"},
/* 3328 */ { "NANO DISPOSÉ EN CARRÉ","	* nano-\n"
	"	# <enCarré> 30CA 30CE"},
/* 3329 */ { "NOTTO DISPOSÉ EN CARRÉ","	* nœud, mille marin\n"
	"	# <enCarré> 30CE 30C3 30C8"},
/* 332A */ { "HAITU DISPOSÉ EN CARRÉ","	* hauteurs\n"
	"	# <enCarré> 30CF 30A4 30C4"},
/* 332B */ { "PÂSENTO DISPOSÉ EN CARRÉ","	* pour cent\n"
	"	# <enCarré> 30D1 30FC 30BB 30F3 30C8"},
/* 332C */ { "PÂTU DISPOSÉ EN CARRÉ","	* une représentation erronée et inusitée initialement destinée pour le symbole monétaire thaï baht\n"
	"	x (symbole monétaire thaï baht - 0E3F)\n"
	"	# <enCarré> 30D1 30FC 30C4"},
/* 332D */ { "BÂRERU DISPOSÉ EN CARRÉ","	* baril\n"
	"	# <enCarré> 30D0 30FC 30EC 30EB"},
/* 332E */ { "PIASUTORU DISPOSÉ EN CARRÉ","	* piastre\n"
	"	# <enCarré> 30D4 30A2 30B9 30C8 30EB"},
/* 332F */ { "PIKURU DISPOSÉ EN CARRÉ","	* picoul, picol (60 kg)\n"
	"	# <enCarré> 30D4 30AF 30EB"},
/* 3330 */ { "PIKO DISPOSÉ EN CARRÉ","	* pico-\n"
	"	# <enCarré> 30D4 30B3"},
/* 3331 */ { "BIRU DISPOSÉ EN CARRÉ","	* édifice\n"
	"	# <enCarré> 30D3 30EB"},
/* 3332 */ { "HUARADO DISPOSÉ EN CARRÉ","	* farad\n"
	"	# <enCarré> 30D5 30A1 30E9 30C3 30C9"},
/* 3333 */ { "HUÎTO DISPOSÉ EN CARRÉ","	* pied\n"
	"	# <enCarré> 30D5 30A3 30FC 30C8"},
/* 3334 */ { "BUSSYERU DISPOSÉ EN CARRÉ","	* boisseau\n"
	"	# <enCarré> 30D6 30C3 30B7 30A7 30EB"},
/* 3335 */ { "HURAN DISPOSÉ EN CARRÉ","	* franc\n"
	"	# <enCarré> 30D5 30E9 30F3"},
/* 3336 */ { "HEKUTÂRU DISPOSÉ EN CARRÉ","	* hectare\n"
	"	# <enCarré> 30D8 30AF 30BF 30FC 30EB"},
/* 3337 */ { "PESO DISPOSÉ EN CARRÉ","	* peso\n"
	"	# <enCarré> 30DA 30BD"},
/* 3338 */ { "PENIHI DISPOSÉ EN CARRÉ","	* pfennig\n"
	"	# <enCarré> 30DA 30CB 30D2"},
/* 3339 */ { "HERUTU DISPOSÉ EN CARRÉ","	* hertz\n"
	"	# <enCarré> 30D8 30EB 30C4"},
/* 333A */ { "PENSU DISPOSÉ EN CARRÉ","	* penny\n"
	"	# <enCarré> 30DA 30F3 30B9"},
/* 333B */ { "PÊZI DISPOSÉ EN CARRÉ","	* page\n"
	"	# <enCarré> 30DA 30FC 30B8"},
/* 333C */ { "BÊTA DISPOSÉ EN CARRÉ","	* bêta\n"
	"	# <enCarré> 30D9 30FC 30BF"},
/* 333D */ { "POINTO DISPOSÉ EN CARRÉ","	* point\n"
	"	# <enCarré> 30DD 30A4 30F3 30C8"},
/* 333E */ { "BORUTO DISPOSÉ EN CARRÉ","	* volt, boulon\n"
	"	# <enCarré> 30DC 30EB 30C8"},
/* 333F */ { "HON DISPOSÉ EN CARRÉ","	* hon : volume\n"
	"	# <enCarré> 30DB 30F3"},
/* 3340 */ { "PONDO DISPOSÉ EN CARRÉ","	* livre (unité de poids)\n"
	"	# <enCarré> 30DD 30F3 30C9"},
/* 3341 */ { "HÔRU DISPOSÉ EN CARRÉ","	* vestibule\n"
	"	# <enCarré> 30DB 30FC 30EB"},
/* 3342 */ { "HÔN DISPOSÉ EN CARRÉ","	* corne\n"
	"	# <enCarré> 30DB 30FC 30F3"},
/* 3343 */ { "MAYAKURO DISPOSÉ EN CARRÉ","	* micro-\n"
	"	# <enCarré> 30DE 30A4 30AF 30ED"},
/* 3344 */ { "MAYAKRU DISPOSÉ EN CARRÉ","	* mille (unité de distance)\n"
	"	# <enCarré> 30DE 30A4 30EB"},
/* 3345 */ { "MAHHA DISPOSÉ EN CARRÉ","	* mach\n"
	"	# <enCarré> 30DE 30C3 30CF"},
/* 3346 */ { "MAKKU DISPOSÉ EN CARRÉ","	* mark\n"
	"	# <enCarré> 30DE 30EB 30AF"},
/* 3347 */ { "MANSYON DISPOSÉ EN CARRÉ","	* appartement de luxe\n"
	"	# <enCarré> 30DE 30F3 30B7 30E7 30F3"},
/* 3348 */ { "MIKURON DISPOSÉ EN CARRÉ","	* micron\n"
	"	# <enCarré> 30DF 30AF 30ED 30F3"},
/* 3349 */ { "MIRI DISPOSÉ EN CARRÉ","	* milli-\n"
	"	# <enCarré> 30DF 30EA"},
/* 334A */ { "MIRIBÂRU DISPOSÉ EN CARRÉ","	* miilibar\n"
	"	# <enCarré> 30DF 30EA 30D0 30FC 30EB"},
/* 334B */ { "MÉGA DISPOSÉ EN CARRÉ","	* méga-\n"
	"	# <enCarré> 30E1 30AC"},
/* 334C */ { "MÉGATONNE DISPOSÉ EN CARRÉ","	* mégatonne\n"
	"	# <enCarré> 30E1 30AC 30C8 30F3"},
/* 334D */ { "MÊTORU DISPOSÉ EN CARRÉ","	* mètre\n"
	"	# <enCarré> 30E1 30FC 30C8 30EB"},
/* 334E */ { "YÂDO DISPOSÉ EN CARRÉ","	* yard, verge\n"
	"	# <enCarré> 30E4 30FC 30C9"},
/* 334F */ { "YÂRU DISPOSÉ EN CARRÉ","	* yard, verge\n"
	"	# <enCarré> 30E4 30FC 30EB"},
/* 3350 */ { "YUAN DISPOSÉ EN CARRÉ","	* yuan (devise chinoise)\n"
	"	# <enCarré> 30E6 30A2 30F3"},
/* 3351 */ { "RITTORU DISPOSÉ EN CARRÉ","	* litre\n"
	"	# <enCarré> 30EA 30C3 30C8 30EB"},
/* 3352 */ { "RIRA DISPOSÉ EN CARRÉ","	* lire\n"
	"	# <enCarré> 30EA 30E9"},
/* 3353 */ { "RUPÎ DISPOSÉ EN CARRÉ","	* roupie\n"
	"	# <enCarré> 30EB 30D4 30FC"},
/* 3354 */ { "RÛBURU DISPOSÉ EN CARRÉ","	* rouble\n"
	"	# <enCarré> 30EB 30FC 30D6 30EB"},
/* 3355 */ { "REMU DISPOSÉ EN CARRÉ","	* rem (unité de radiation)\n"
	"	# <enCarré> 30EC 30E0"},
/* 3356 */ { "RENTOGEN DISPOSÉ EN CARRÉ","	* röntgen\n"
	"	# <enCarré> 30EC 30F3 30C8 30B2 30F3"},
/* 3357 */ { "WATTO DISPOSÉ EN CARRÉ","	* watt\n"
	"	# <enCarré> 30EF 30C3 30C8"},
/* 3358 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE ZÉRO","	# 0030 70B9"},
/* 3359 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE UN","	# 0031 70B9"},
/* 335A */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE DEUX","	# 0032 70B9"},
/* 335B */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE TROIS","	# 0033 70B9"},
/* 335C */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE QUATRE","	# 0034 70B9"},
/* 335D */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE CINQ","	# 0035 70B9"},
/* 335E */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE SIX","	# 0036 70B9"},
/* 335F */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE SEPT","	# 0037 70B9"},
/* 3360 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE HUIT","	# 0038 70B9"},
/* 3361 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE NEUF","	# 0039 70B9"},
/* 3362 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE DIX","	# 0031 0030 70B9"},
/* 3363 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE ONZE","	# 0031 0031 70B9"},
/* 3364 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE DOUZE","	# 0031 0032 70B9"},
/* 3365 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE TREIZE","	# 0031 0033 70B9"},
/* 3366 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE QUATORZE","	# 0031 0034 70B9"},
/* 3367 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE QUINZE","	# 0031 0035 70B9"},
/* 3368 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE SEIZE","	# 0031 0036 70B9"},
/* 3369 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE DIX-SEPT","	# 0031 0037 70B9"},
/* 336A */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE DIX-HUIT","	# 0031 0038 70B9"},
/* 336B */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE DIX-NEUF","	# 0031 0039 70B9"},
/* 336C */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE VINGT","	# 0032 0030 70B9"},
/* 336D */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE VINGT ET UN","	# 0032 0031 70B9"},
/* 336E */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE VINGT-DEUX","	# 0032 0032 70B9"},
/* 336F */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE VINGT-TROIS","	# 0032 0033 70B9"},
/* 3370 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE HEURE VINGT-QUATRE","	# 0032 0034 70B9"},
/* 3371 */ { "HPA DISPOSÉ EN CARRÉ","	# <enCarré> 0068 0050 0061"},
/* 3372 */ { "DA DISPOSÉ EN CARRÉ","	# <enCarré> 0064 0061"},
/* 3373 */ { "AU DISPOSÉ EN CARRÉ","	# <enCarré> 0041 0055"},
/* 3374 */ { "BAR DISPOSÉ EN CARRÉ","	# <enCarré> 0062 0061 0072"},
/* 3375 */ { "OV DISPOSÉ EN CARRÉ","	# <enCarré> 006F 0056"},
/* 3376 */ { "PC DISPOSÉ EN CARRÉ","	# <enCarré> 0070 0063"},
/* 3377 */ { "DM DISPOSÉ EN CARRÉ","	# <enCarré> 0064 006D"},
/* 3378 */ { "DM AU CARRÉ DISPOSÉ EN CARRÉ","	# <enCarré> 0064 006D 00B2"},
/* 3379 */ { "DM AU CUBE DISPOSÉ EN CARRÉ","	# <enCarré> 0064 006D 00B3"},
/* 337A */ { "IU DISPOSÉ EN CARRÉ","	# <enCarré> 0049 0055"},
/* 337B */ { "ÈRE HEISEI DISPOSÉ EN CARRÉ","	# <enCarré> 5E73 6210"},
/* 337C */ { "ÈRE CHÔWA DISPOSÉ EN CARRÉ","	# <enCarré> 662D 548C"},
/* 337D */ { "ÈRE TAÏCHÔ DISPOSÉ EN CARRÉ","	# <enCarré> 5927 6B63"},
/* 337E */ { "ÈRE MEIJI DISPOSÉ EN CARRÉ","	# <enCarré> 660E 6CBB"},
/* 337F */ { "SOCIÉTÉ DISPOSÉ EN CARRÉ","	= kabusiki-gaisya\n"
	"	* société anonyme\n"
	"	# <enCarré> 682A 5F0F 4F1A 793E"},
/* 3380 */ { "PA AMPÈRES DISPOSÉ EN CARRÉ","	# <enCarré> 0070 0041"},
/* 3381 */ { "NA DISPOSÉ EN CARRÉ","	# <enCarré> 006E 0041"},
/* 3382 */ { "MU A DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 0041"},
/* 3383 */ { "MA DISPOSÉ EN CARRÉ","	# <enCarré> 006D 0041"},
/* 3384 */ { "KA DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0041"},
/* 3385 */ { "KB DISPOSÉ EN CARRÉ","	# <enCarré> 004B 0042"},
/* 3386 */ { "MB DISPOSÉ EN CARRÉ","	# <enCarré> 004D 0042"},
/* 3387 */ { "GB DISPOSÉ EN CARRÉ","	# <enCarré> 0047 0042"},
/* 3388 */ { "CAL DISPOSÉ EN CARRÉ","	# <enCarré> 0063 0061 006C"},
/* 3389 */ { "KCAL DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0063 0061 006C"},
/* 338A */ { "PF DISPOSÉ EN CARRÉ","	# <enCarré> 0070 0046"},
/* 338B */ { "NF DISPOSÉ EN CARRÉ","	# <enCarré> 006E 0046"},
/* 338C */ { "MU F DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 0046"},
/* 338D */ { "MU G DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 0067"},
/* 338E */ { "MG DISPOSÉ EN CARRÉ","	# <enCarré> 006D 0067"},
/* 338F */ { "KG DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0067"},
/* 3390 */ { "HZ DISPOSÉ EN CARRÉ","	# <enCarré> 0048 007A"},
/* 3391 */ { "KHZ DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0048 007A"},
/* 3392 */ { "MHZ DISPOSÉ EN CARRÉ","	# <enCarré> 004D 0048 007A"},
/* 3393 */ { "GHZ DISPOSÉ EN CARRÉ","	# <enCarré> 0047 0048 007A"},
/* 3394 */ { "THZ DISPOSÉ EN CARRÉ","	# <enCarré> 0054 0048 007A"},
/* 3395 */ { "MU L DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 2113"},
/* 3396 */ { "ML DISPOSÉ EN CARRÉ","	# <enCarré> 006D 2113"},
/* 3397 */ { "DL DISPOSÉ EN CARRÉ","	# <enCarré> 0064 2113"},
/* 3398 */ { "KL DISPOSÉ EN CARRÉ","	# <enCarré> 006B 2113"},
/* 3399 */ { "FM DISPOSÉ EN CARRÉ","	# <enCarré> 0066 006D"},
/* 339A */ { "NM DISPOSÉ EN CARRÉ","	# <enCarré> 006E 006D"},
/* 339B */ { "MU M DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 006D"},
/* 339C */ { "MM DISPOSÉ EN CARRÉ","	# <enCarré> 006D 006D"},
/* 339D */ { "CM DISPOSÉ EN CARRÉ","	# <enCarré> 0063 006D"},
/* 339E */ { "KM DISPOSÉ EN CARRÉ","	# <enCarré> 006B 006D"},
/* 339F */ { "MM CARRÉ DISPOSÉ EN CARRÉ","	# <enCarré> 006D 006D 00B2"},
/* 33A0 */ { "CM CARRÉ DISPOSÉ EN CARRÉ","	# <enCarré> 0063 006D 00B2"},
/* 33A1 */ { "M CARRÉ DISPOSÉ EN CARRÉ","	# <enCarré> 006D 00B2"},
/* 33A2 */ { "KM CARRÉ DISPOSÉ EN CARRÉ","	# <enCarré> 006B 006D 00B2"},
/* 33A3 */ { "MM CUBE DISPOSÉ EN CARRÉ","	# <enCarré> 006D 006D 00B3"},
/* 33A4 */ { "CM CUBE DISPOSÉ EN CARRÉ","	# <enCarré> 0063 006D 00B3"},
/* 33A5 */ { "M CUBE DISPOSÉ EN CARRÉ","	# <enCarré> 006D 00B3"},
/* 33A6 */ { "KM CUBE DISPOSÉ EN CARRÉ","	# <enCarré> 006B 006D 00B3"},
/* 33A7 */ { "M SUR S DISPOSÉ EN CARRÉ","	# <enCarré> 006D 2215 0073"},
/* 33A8 */ { "M SUR S CARRÉ DISPOSÉ EN CARRÉ","	# <enCarré> 006D 2215 0073 00B2"},
/* 33A9 */ { "PA DISPOSÉ EN CARRÉ","	# <enCarré> 0050 0061"},
/* 33AA */ { "KPA DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0050 0061"},
/* 33AB */ { "MPA DISPOSÉ EN CARRÉ","	# <enCarré> 004D 0050 0061"},
/* 33AC */ { "GPA DISPOSÉ EN CARRÉ","	# <enCarré> 0047 0050 0061"},
/* 33AD */ { "RAD DISPOSÉ EN CARRÉ","	# <enCarré> 0072 0061 0064"},
/* 33AE */ { "RAD SUR S DISPOSÉ EN CARRÉ","	# <enCarré> 0072 0061 0064 2215 0073"},
/* 33AF */ { "RAD SUR S CARRÉ DISPOSÉ EN CARRÉ","	# <enCarré> 0072 0061 0064 2215 0073 00B2"},
/* 33B0 */ { "PS DISPOSÉ EN CARRÉ","	# <enCarré> 0070 0073"},
/* 33B1 */ { "NS DISPOSÉ EN CARRÉ","	# <enCarré> 006E 0073"},
/* 33B2 */ { "MU S DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 0073"},
/* 33B3 */ { "MS DISPOSÉ EN CARRÉ","	# <enCarré> 006D 0073"},
/* 33B4 */ { "PV DISPOSÉ EN CARRÉ","	# <enCarré> 0070 0056"},
/* 33B5 */ { "NV DISPOSÉ EN CARRÉ","	# <enCarré> 006E 0056"},
/* 33B6 */ { "MU V DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 0056"},
/* 33B7 */ { "MV DISPOSÉ EN CARRÉ","	# <enCarré> 006D 0056"},
/* 33B8 */ { "KV DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0056"},
/* 33B9 */ { "MV MÉGA DISPOSÉ EN CARRÉ","	# <enCarré> 004D 0056"},
/* 33BA */ { "PW DISPOSÉ EN CARRÉ","	# <enCarré> 0070 0057"},
/* 33BB */ { "NW DISPOSÉ EN CARRÉ","	# <enCarré> 006E 0057"},
/* 33BC */ { "MU W DISPOSÉ EN CARRÉ","	# <enCarré> 03BC 0057"},
/* 33BD */ { "MW DISPOSÉ EN CARRÉ","	# <enCarré> 006D 0057"},
/* 33BE */ { "KW DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0057"},
/* 33BF */ { "MW MÉGA DISPOSÉ EN CARRÉ","	# <enCarré> 004D 0057"},
/* 33C0 */ { "K OHM DISPOSÉ EN CARRÉ","	# <enCarré> 006B 03A9"},
/* 33C1 */ { "M OHM DISPOSÉ EN CARRÉ","	# <enCarré> 004D 03A9"},
/* 33C2 */ { "AM DISPOSÉ EN CARRÉ","	# <enCarré> 0061 002E 006D 002E"},
/* 33C3 */ { "BQ DISPOSÉ EN CARRÉ","	# <enCarré> 0042 0071"},
/* 33C4 */ { "CC DISPOSÉ EN CARRÉ","	# <enCarré> 0063 0063"},
/* 33C5 */ { "CD DISPOSÉ EN CARRÉ","	x (cd cerclé - 1F12D)\n"
	"	# <enCarré> 0063 0064"},
/* 33C6 */ { "C SUR KG DISPOSÉ EN CARRÉ","	# <enCarré> 0043 2215 006B 0067"},
/* 33C7 */ { "CO DISPOSÉ EN CARRÉ","	# <enCarré> 0043 006F 002E"},
/* 33C8 */ { "DB DISPOSÉ EN CARRÉ","	# <enCarré> 0064 0042"},
/* 33C9 */ { "GY DISPOSÉ EN CARRÉ","	# <enCarré> 0047 0079"},
/* 33CA */ { "HA DISPOSÉ EN CARRÉ","	# <enCarré> 0068 0061"},
/* 33CB */ { "HP DISPOSÉ EN CARRÉ","	# <enCarré> 0048 0050"},
/* 33CC */ { "IN DISPOSÉ EN CARRÉ","	# <enCarré> 0069 006E"},
/* 33CD */ { "KK DISPOSÉ EN CARRÉ","	# <enCarré> 004B 004B"},
/* 33CE */ { "KM MAJUSCULE DISPOSÉ EN CARRÉ","	# <enCarré> 004B 004D"},
/* 33CF */ { "KT DISPOSÉ EN CARRÉ","	# <enCarré> 006B 0074"},
/* 33D0 */ { "LM DISPOSÉ EN CARRÉ","	# <enCarré> 006C 006D"},
/* 33D1 */ { "LN DISPOSÉ EN CARRÉ","	# <enCarré> 006C 006E"},
/* 33D2 */ { "LOG DISPOSÉ EN CARRÉ","	# <enCarré> 006C 006F 0067"},
/* 33D3 */ { "LX DISPOSÉ EN CARRÉ","	# <enCarré> 006C 0078"},
/* 33D4 */ { "MB MINUSCULE DISPOSÉ EN CARRÉ","	# <enCarré> 006D 0062"},
/* 33D5 */ { "MIL DISPOSÉ EN CARRÉ","	# <enCarré> 006D 0069 006C"},
/* 33D6 */ { "MOL DISPOSÉ EN CARRÉ","	# <enCarré> 006D 006F 006C"},
/* 33D7 */ { "PH DISPOSÉ EN CARRÉ","	# <enCarré> 0050 0048"},
/* 33D8 */ { "PM DISPOSÉ EN CARRÉ","	# <enCarré> 0070 002E 006D 002E"},
/* 33D9 */ { "PPM DISPOSÉ EN CARRÉ","	# <enCarré> 0050 0050 004D"},
/* 33DA */ { "PR DISPOSÉ EN CARRÉ","	# <enCarré> 0050 0052"},
/* 33DB */ { "SR DISPOSÉ EN CARRÉ","	# <enCarré> 0073 0072"},
/* 33DC */ { "SV DISPOSÉ EN CARRÉ","	# <enCarré> 0053 0076"},
/* 33DD */ { "WB DISPOSÉ EN CARRÉ","	# <enCarré> 0057 0062"},
/* 33DE */ { "V SUR M DISPOSÉ EN CARRÉ","	# <enCarré> 0056 2215 006D"},
/* 33DF */ { "A SUR M DISPOSÉ EN CARRÉ","	# <enCarré> 0041 2215 006D"},
/* 33E0 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR UN","	# 0031 65E5"},
/* 33E1 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR DEUX","	# 0032 65E5"},
/* 33E2 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR TROIS","	# 0033 65E5"},
/* 33E3 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR QUATRE","	# 0034 65E5"},
/* 33E4 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR CINQ","	# 0035 65E5"},
/* 33E5 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR SIX","	# 0036 65E5"},
/* 33E6 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR SEPT","	# 0037 65E5"},
/* 33E7 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR HUIT","	# 0038 65E5"},
/* 33E8 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR NEUF","	# 0039 65E5"},
/* 33E9 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR DIX","	# 0031 0030 65E5"},
/* 33EA */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR ONZE","	# 0031 0031 65E5"},
/* 33EB */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR DOUZE","	# 0031 0032 65E5"},
/* 33EC */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR TREIZE","	# 0031 0033 65E5"},
/* 33ED */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR QUATORZE","	# 0031 0034 65E5"},
/* 33EE */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR QUINZE","	# 0031 0035 65E5"},
/* 33EF */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR SEIZE","	# 0031 0036 65E5"},
/* 33F0 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR DIX-SEPT","	# 0031 0037 65E5"},
/* 33F1 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR DIX-HUIT","	# 0031 0038 65E5"},
/* 33F2 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR DIX-NEUF","	# 0031 0039 65E5"},
/* 33F3 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT","	# 0032 0030 65E5"},
/* 33F4 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT ET UN","	# 0032 0031 65E5"},
/* 33F5 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-DEUX","	# 0032 0032 65E5"},
/* 33F6 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-TROIS","	# 0032 0033 65E5"},
/* 33F7 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-QUATRE","	# 0032 0034 65E5"},
/* 33F8 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-CINQ","	# 0032 0035 65E5"},
/* 33F9 */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-SIX","	# 0032 0036 65E5"},
/* 33FA */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-SEPT","	# 0032 0037 65E5"},
/* 33FB */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-HUIT","	# 0032 0038 65E5"},
/* 33FC */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR VINGT-NEUF","	# 0032 0039 65E5"},
/* 33FD */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR TRENTE","	# 0033 0030 65E5"},
/* 33FE */ { "SYMBOLE TÉLÉGRAPHIQUE IDÉOGRAPHIQUE JOUR TRENTE ET UN","	# 0033 0031 65E5"},
/* 33FF */ { "GAL DISPOSÉ EN CARRÉ","	# <enCarré> 0067 0061 006C"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_4D[] = {
/* 4D00 */ { NULL,NULL},
/* 4D01 */ { NULL,NULL},
/* 4D02 */ { NULL,NULL},
/* 4D03 */ { NULL,NULL},
/* 4D04 */ { NULL,NULL},
/* 4D05 */ { NULL,NULL},
/* 4D06 */ { NULL,NULL},
/* 4D07 */ { NULL,NULL},
/* 4D08 */ { NULL,NULL},
/* 4D09 */ { NULL,NULL},
/* 4D0A */ { NULL,NULL},
/* 4D0B */ { NULL,NULL},
/* 4D0C */ { NULL,NULL},
/* 4D0D */ { NULL,NULL},
/* 4D0E */ { NULL,NULL},
/* 4D0F */ { NULL,NULL},
/* 4D10 */ { NULL,NULL},
/* 4D11 */ { NULL,NULL},
/* 4D12 */ { NULL,NULL},
/* 4D13 */ { NULL,NULL},
/* 4D14 */ { NULL,NULL},
/* 4D15 */ { NULL,NULL},
/* 4D16 */ { NULL,NULL},
/* 4D17 */ { NULL,NULL},
/* 4D18 */ { NULL,NULL},
/* 4D19 */ { NULL,NULL},
/* 4D1A */ { NULL,NULL},
/* 4D1B */ { NULL,NULL},
/* 4D1C */ { NULL,NULL},
/* 4D1D */ { NULL,NULL},
/* 4D1E */ { NULL,NULL},
/* 4D1F */ { NULL,NULL},
/* 4D20 */ { NULL,NULL},
/* 4D21 */ { NULL,NULL},
/* 4D22 */ { NULL,NULL},
/* 4D23 */ { NULL,NULL},
/* 4D24 */ { NULL,NULL},
/* 4D25 */ { NULL,NULL},
/* 4D26 */ { NULL,NULL},
/* 4D27 */ { NULL,NULL},
/* 4D28 */ { NULL,NULL},
/* 4D29 */ { NULL,NULL},
/* 4D2A */ { NULL,NULL},
/* 4D2B */ { NULL,NULL},
/* 4D2C */ { NULL,NULL},
/* 4D2D */ { NULL,NULL},
/* 4D2E */ { NULL,NULL},
/* 4D2F */ { NULL,NULL},
/* 4D30 */ { NULL,NULL},
/* 4D31 */ { NULL,NULL},
/* 4D32 */ { NULL,NULL},
/* 4D33 */ { NULL,NULL},
/* 4D34 */ { NULL,NULL},
/* 4D35 */ { NULL,NULL},
/* 4D36 */ { NULL,NULL},
/* 4D37 */ { NULL,NULL},
/* 4D38 */ { NULL,NULL},
/* 4D39 */ { NULL,NULL},
/* 4D3A */ { NULL,NULL},
/* 4D3B */ { NULL,NULL},
/* 4D3C */ { NULL,NULL},
/* 4D3D */ { NULL,NULL},
/* 4D3E */ { NULL,NULL},
/* 4D3F */ { NULL,NULL},
/* 4D40 */ { NULL,NULL},
/* 4D41 */ { NULL,NULL},
/* 4D42 */ { NULL,NULL},
/* 4D43 */ { NULL,NULL},
/* 4D44 */ { NULL,NULL},
/* 4D45 */ { NULL,NULL},
/* 4D46 */ { NULL,NULL},
/* 4D47 */ { NULL,NULL},
/* 4D48 */ { NULL,NULL},
/* 4D49 */ { NULL,NULL},
/* 4D4A */ { NULL,NULL},
/* 4D4B */ { NULL,NULL},
/* 4D4C */ { NULL,NULL},
/* 4D4D */ { NULL,NULL},
/* 4D4E */ { NULL,NULL},
/* 4D4F */ { NULL,NULL},
/* 4D50 */ { NULL,NULL},
/* 4D51 */ { NULL,NULL},
/* 4D52 */ { NULL,NULL},
/* 4D53 */ { NULL,NULL},
/* 4D54 */ { NULL,NULL},
/* 4D55 */ { NULL,NULL},
/* 4D56 */ { NULL,NULL},
/* 4D57 */ { NULL,NULL},
/* 4D58 */ { NULL,NULL},
/* 4D59 */ { NULL,NULL},
/* 4D5A */ { NULL,NULL},
/* 4D5B */ { NULL,NULL},
/* 4D5C */ { NULL,NULL},
/* 4D5D */ { NULL,NULL},
/* 4D5E */ { NULL,NULL},
/* 4D5F */ { NULL,NULL},
/* 4D60 */ { NULL,NULL},
/* 4D61 */ { NULL,NULL},
/* 4D62 */ { NULL,NULL},
/* 4D63 */ { NULL,NULL},
/* 4D64 */ { NULL,NULL},
/* 4D65 */ { NULL,NULL},
/* 4D66 */ { NULL,NULL},
/* 4D67 */ { NULL,NULL},
/* 4D68 */ { NULL,NULL},
/* 4D69 */ { NULL,NULL},
/* 4D6A */ { NULL,NULL},
/* 4D6B */ { NULL,NULL},
/* 4D6C */ { NULL,NULL},
/* 4D6D */ { NULL,NULL},
/* 4D6E */ { NULL,NULL},
/* 4D6F */ { NULL,NULL},
/* 4D70 */ { NULL,NULL},
/* 4D71 */ { NULL,NULL},
/* 4D72 */ { NULL,NULL},
/* 4D73 */ { NULL,NULL},
/* 4D74 */ { NULL,NULL},
/* 4D75 */ { NULL,NULL},
/* 4D76 */ { NULL,NULL},
/* 4D77 */ { NULL,NULL},
/* 4D78 */ { NULL,NULL},
/* 4D79 */ { NULL,NULL},
/* 4D7A */ { NULL,NULL},
/* 4D7B */ { NULL,NULL},
/* 4D7C */ { NULL,NULL},
/* 4D7D */ { NULL,NULL},
/* 4D7E */ { NULL,NULL},
/* 4D7F */ { NULL,NULL},
/* 4D80 */ { NULL,NULL},
/* 4D81 */ { NULL,NULL},
/* 4D82 */ { NULL,NULL},
/* 4D83 */ { NULL,NULL},
/* 4D84 */ { NULL,NULL},
/* 4D85 */ { NULL,NULL},
/* 4D86 */ { NULL,NULL},
/* 4D87 */ { NULL,NULL},
/* 4D88 */ { NULL,NULL},
/* 4D89 */ { NULL,NULL},
/* 4D8A */ { NULL,NULL},
/* 4D8B */ { NULL,NULL},
/* 4D8C */ { NULL,NULL},
/* 4D8D */ { NULL,NULL},
/* 4D8E */ { NULL,NULL},
/* 4D8F */ { NULL,NULL},
/* 4D90 */ { NULL,NULL},
/* 4D91 */ { NULL,NULL},
/* 4D92 */ { NULL,NULL},
/* 4D93 */ { NULL,NULL},
/* 4D94 */ { NULL,NULL},
/* 4D95 */ { NULL,NULL},
/* 4D96 */ { NULL,NULL},
/* 4D97 */ { NULL,NULL},
/* 4D98 */ { NULL,NULL},
/* 4D99 */ { NULL,NULL},
/* 4D9A */ { NULL,NULL},
/* 4D9B */ { NULL,NULL},
/* 4D9C */ { NULL,NULL},
/* 4D9D */ { NULL,NULL},
/* 4D9E */ { NULL,NULL},
/* 4D9F */ { NULL,NULL},
/* 4DA0 */ { NULL,NULL},
/* 4DA1 */ { NULL,NULL},
/* 4DA2 */ { NULL,NULL},
/* 4DA3 */ { NULL,NULL},
/* 4DA4 */ { NULL,NULL},
/* 4DA5 */ { NULL,NULL},
/* 4DA6 */ { NULL,NULL},
/* 4DA7 */ { NULL,NULL},
/* 4DA8 */ { NULL,NULL},
/* 4DA9 */ { NULL,NULL},
/* 4DAA */ { NULL,NULL},
/* 4DAB */ { NULL,NULL},
/* 4DAC */ { NULL,NULL},
/* 4DAD */ { NULL,NULL},
/* 4DAE */ { NULL,NULL},
/* 4DAF */ { NULL,NULL},
/* 4DB0 */ { NULL,NULL},
/* 4DB1 */ { NULL,NULL},
/* 4DB2 */ { NULL,NULL},
/* 4DB3 */ { NULL,NULL},
/* 4DB4 */ { NULL,NULL},
/* 4DB5 */ { NULL,NULL},
/* 4DB6 */ { NULL,NULL},
/* 4DB7 */ { NULL,NULL},
/* 4DB8 */ { NULL,NULL},
/* 4DB9 */ { NULL,NULL},
/* 4DBA */ { NULL,NULL},
/* 4DBB */ { NULL,NULL},
/* 4DBC */ { NULL,NULL},
/* 4DBD */ { NULL,NULL},
/* 4DBE */ { NULL,NULL},
/* 4DBF */ { NULL,NULL},
/* 4DC0 */ { "HEXAGRAMME DE L'ÉLAN CÉLESTE","	= k'ien"},
/* 4DC1 */ { "HEXAGRAMME DE LA TERRE RÉCEPTIVE","	= k'ouen"},
/* 4DC2 */ { "HEXAGRAMME DE LA DIFFICULTÉ INITIALE","	= tchouen"},
/* 4DC3 */ { "HEXAGRAMME DU TÂTONNEMENT JUVÉNILE","	= mêng"},
/* 4DC4 */ { "HEXAGRAMME DE L'ATTENTE CONFIANTE","	= su"},
/* 4DC5 */ { "HEXAGRAMME DU CONFLIT","	= soung"},
/* 4DC6 */ { "HEXAGRAMME DE L'ARMÉE","	= che"},
/* 4DC7 */ { "HEXAGRAMME DE LA SOLIDARITÉ","	= pi"},
/* 4DC8 */ { "HEXAGRAMME DU DOUX APPRIVOISEMENT","	= siao tch'ou"},
/* 4DC9 */ { "HEXAGRAMME DE LA MARCHE PÉRILLEUSE","	= lü"},
/* 4DCA */ { "HEXAGRAMME DE LA PAIX","	= t'ai"},
/* 4DCB */ { "HEXAGRAMME DE LA STAGNATION","	= p'i"},
/* 4DCC */ { "HEXAGRAMME DE LA FRATERNITÉ","	= t'ong-jen"},
/* 4DCD */ { "HEXAGRAMME DU GRAND AVOIR","	= ta-yeou"},
/* 4DCE */ { "HEXAGRAMME DE L'INSUFFISANCE","	= k'ien"},
/* 4DCF */ { "HEXAGRAMME DE L'ENTHOUSIASME","	= yu"},
/* 4DD0 */ { "HEXAGRAMME DE LA SUITE","	= souei"},
/* 4DD1 */ { "HEXAGRAMME DU TRAVAIL SUR LE DÉCLIN","	= kou"},
/* 4DD2 */ { "HEXAGRAMME DE LA MONTÉE DE PUISSANCE","	= lin"},
/* 4DD3 */ { "HEXAGRAMME DE LA CONTEMPLATION","	= kouan"},
/* 4DD4 */ { "HEXAGRAMME DE MORDRE AU TRAVERS","	= che-hö"},
/* 4DD5 */ { "HEXAGRAMME DE LA GRÂCE","	= pi"},
/* 4DD6 */ { "HEXAGRAMME DE LA DÉCADENCE","	= po"},
/* 4DD7 */ { "HEXAGRAMME DU TOURNANT","	= fou"},
/* 4DD8 */ { "HEXAGRAMME DE LA NON-ERRANCE","	= wou-wang"},
/* 4DD9 */ { "HEXAGRAMME DU FERME APPRIVOISEMENT","	= ta-siu"},
/* 4DDA */ { "HEXAGRAMME DE L'ENTRETIEN DE LA VIE","	= yi"},
/* 4DDB */ { "HEXAGRAMME DE LA PRÉPONDÉRANCE DU GRAND","	= ta-kouo"},
/* 4DDC */ { "HEXAGRAMME DE L'EAU INSONDABLE","	= k'an"},
/* 4DDD */ { "HEXAGRAMME DU FEU QUI S'ATTACHE","	= li"},
/* 4DDE */ { "HEXAGRAMME DE L'INFLUENCE","	= hien"},
/* 4DDF */ { "HEXAGRAMME DE LA PÉRENNITÉ","	= heng"},
/* 4DE0 */ { "HEXAGRAMME DE LA RETRAITE","	= touen"},
/* 4DE1 */ { "HEXAGRAMME DE LA PUISSANCE DU GRAND","	= ta-tchouang"},
/* 4DE2 */ { "HEXAGRAMME DU PROGRÈS","	= tsin"},
/* 4DE3 */ { "HEXAGRAMME DE L'OBSCURCISSEMENT","	= ming-yi"},
/* 4DE4 */ { "HEXAGRAMME DU CLAN FAMILIAL","	= kia-jen"},
/* 4DE5 */ { "HEXAGRAMME DE L'OPPOSITION","	= k'ouei"},
/* 4DE6 */ { "HEXAGRAMME DE L'OBSTACLE","	= kien"},
/* 4DE7 */ { "HEXAGRAMME DE LA LIBÉRATION","	= sie"},
/* 4DE8 */ { "HEXAGRAMME DE LA DIMINUTION","	= souen"},
/* 4DE9 */ { "HEXAGRAMME DE L'ACCROISSEMENT","	= yi"},
/* 4DEA */ { "HEXAGRAMME DE LA PERCÉE","	= kouai"},
/* 4DEB */ { "HEXAGRAMME DE VENIR À LA RENCONTRE","	= keou"},
/* 4DEC */ { "HEXAGRAMME DU RASSEMBLEMENT","	= ts'ouei"},
/* 4DED */ { "HEXAGRAMME DE LA POUSSÉE VERS LE HAUT","	= cheng"},
/* 4DEE */ { "HEXAGRAMME DE L'ACCABLEMENT","	= k'ouen"},
/* 4DEF */ { "HEXAGRAMME DU PUITS","	= ching"},
/* 4DF0 */ { "HEXAGRAMME DE LA MUE","	= kö 333"},
/* 4DF1 */ { "HEXAGRAMME DU CHAUDRON","	= ting"},
/* 4DF2 */ { "HEXAGRAMME DU TONNERRE ÉVEILLEUR","	= tchen"},
/* 4DF3 */ { "HEXAGRAMME DE LA MONTAGNE IMMOBILE","	= ken"},
/* 4DF4 */ { "HEXAGRAMME DU PROGRÈS GRADUEL","	= tsien\n"
	"	= développement"},
/* 4DF5 */ { "HEXAGRAMME DE L'ÉPOUSÉE","	= kouei-mei"},
/* 4DF6 */ { "HEXAGRAMME DE LA PLÉNITUDE","	= fong"},
/* 4DF7 */ { "HEXAGRAMME DE L'ERRANT","	= liu"},
/* 4DF8 */ { "HEXAGRAMME DU VENT DOUX","	= siun, souen"},
/* 4DF9 */ { "HEXAGRAMME DU LAC JOYEUX","	= touei"},
/* 4DFA */ { "HEXAGRAMME DE LA DISPERSION","	= houan\n"
	"	= dissolution"},
/* 4DFB */ { "HEXAGRAMME DE LA MODÉRATION","	= tsie"},
/* 4DFC */ { "HEXAGRAMME DE LA VÉRITÉ INTÉRIEURE","	= tchoung-fou"},
/* 4DFD */ { "HEXAGRAMME DE LA PRÉPONDÉRANCE DU PETIT","	= siao-kouo"},
/* 4DFE */ { "HEXAGRAMME DU TERME DE L'ACCOMPLISSEMENT","	= ki-tsi"},
/* 4DFF */ { "HEXAGRAMME DE LA MARCHE VERS L'ACCOMPLISSEMENT","	= wei-tsi"}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_A0[] = {
/* A000 */ { "SYLLABE YI IT",NULL},
/* A001 */ { "SYLLABE YI IX",NULL},
/* A002 */ { "SYLLABE YI I",NULL},
/* A003 */ { "SYLLABE YI IP",NULL},
/* A004 */ { "SYLLABE YI IET",NULL},
/* A005 */ { "SYLLABE YI IEX",NULL},
/* A006 */ { "SYLLABE YI IE",NULL},
/* A007 */ { "SYLLABE YI IEP",NULL},
/* A008 */ { "SYLLABE YI AT",NULL},
/* A009 */ { "SYLLABE YI AX",NULL},
/* A00A */ { "SYLLABE YI A",NULL},
/* A00B */ { "SYLLABE YI AP",NULL},
/* A00C */ { "SYLLABE YI UOX",NULL},
/* A00D */ { "SYLLABE YI UO",NULL},
/* A00E */ { "SYLLABE YI UOP",NULL},
/* A00F */ { "SYLLABE YI OT",NULL},
/* A010 */ { "SYLLABE YI OX",NULL},
/* A011 */ { "SYLLABE YI O",NULL},
/* A012 */ { "SYLLABE YI OP",NULL},
/* A013 */ { "SYLLABE YI EX",NULL},
/* A014 */ { "SYLLABE YI E",NULL},
/* A015 */ { "MARQUE D'ITÉRATION SYLLABIQUE YI","	* analogue à 3005\n"
	"	* l'appellation anglaise de ce caractère est erronée"},
/* A016 */ { "SYLLABE YI BIT",NULL},
/* A017 */ { "SYLLABE YI BIX",NULL},
/* A018 */ { "SYLLABE YI BI",NULL},
/* A019 */ { "SYLLABE YI BIP",NULL},
/* A01A */ { "SYLLABE YI BIET",NULL},
/* A01B */ { "SYLLABE YI BIEX",NULL},
/* A01C */ { "SYLLABE YI BIE",NULL},
/* A01D */ { "SYLLABE YI BIEP",NULL},
/* A01E */ { "SYLLABE YI BAT",NULL},
/* A01F */ { "SYLLABE YI BAX",NULL},
/* A020 */ { "SYLLABE YI BA",NULL},
/* A021 */ { "SYLLABE YI BAP",NULL},
/* A022 */ { "SYLLABE YI BUOX",NULL},
/* A023 */ { "SYLLABE YI BUO",NULL},
/* A024 */ { "SYLLABE YI BUOP",NULL},
/* A025 */ { "SYLLABE YI BOT",NULL},
/* A026 */ { "SYLLABE YI BOX",NULL},
/* A027 */ { "SYLLABE YI BO",NULL},
/* A028 */ { "SYLLABE YI BOP",NULL},
/* A029 */ { "SYLLABE YI BEX",NULL},
/* A02A */ { "SYLLABE YI BE",NULL},
/* A02B */ { "SYLLABE YI BEP",NULL},
/* A02C */ { "SYLLABE YI BUT",NULL},
/* A02D */ { "SYLLABE YI BUX",NULL},
/* A02E */ { "SYLLABE YI BU",NULL},
/* A02F */ { "SYLLABE YI BUP",NULL},
/* A030 */ { "SYLLABE YI BURX",NULL},
/* A031 */ { "SYLLABE YI BUR",NULL},
/* A032 */ { "SYLLABE YI BYT",NULL},
/* A033 */ { "SYLLABE YI BYX",NULL},
/* A034 */ { "SYLLABE YI BY",NULL},
/* A035 */ { "SYLLABE YI BYP",NULL},
/* A036 */ { "SYLLABE YI BYRX",NULL},
/* A037 */ { "SYLLABE YI BYR",NULL},
/* A038 */ { "SYLLABE YI PIT",NULL},
/* A039 */ { "SYLLABE YI PIX",NULL},
/* A03A */ { "SYLLABE YI PI",NULL},
/* A03B */ { "SYLLABE YI PIP",NULL},
/* A03C */ { "SYLLABE YI PIEX",NULL},
/* A03D */ { "SYLLABE YI PIE",NULL},
/* A03E */ { "SYLLABE YI PIEP",NULL},
/* A03F */ { "SYLLABE YI PAT",NULL},
/* A040 */ { "SYLLABE YI PAX",NULL},
/* A041 */ { "SYLLABE YI PA",NULL},
/* A042 */ { "SYLLABE YI PAP",NULL},
/* A043 */ { "SYLLABE YI PUOX",NULL},
/* A044 */ { "SYLLABE YI PUO",NULL},
/* A045 */ { "SYLLABE YI PUOP",NULL},
/* A046 */ { "SYLLABE YI POT",NULL},
/* A047 */ { "SYLLABE YI POX",NULL},
/* A048 */ { "SYLLABE YI PO",NULL},
/* A049 */ { "SYLLABE YI POP",NULL},
/* A04A */ { "SYLLABE YI PUT",NULL},
/* A04B */ { "SYLLABE YI PUX",NULL},
/* A04C */ { "SYLLABE YI PU",NULL},
/* A04D */ { "SYLLABE YI PUP",NULL},
/* A04E */ { "SYLLABE YI PURX",NULL},
/* A04F */ { "SYLLABE YI PUR",NULL},
/* A050 */ { "SYLLABE YI PYT",NULL},
/* A051 */ { "SYLLABE YI PYX",NULL},
/* A052 */ { "SYLLABE YI PY",NULL},
/* A053 */ { "SYLLABE YI PYP",NULL},
/* A054 */ { "SYLLABE YI PYRX",NULL},
/* A055 */ { "SYLLABE YI PYR",NULL},
/* A056 */ { "SYLLABE YI BBIT",NULL},
/* A057 */ { "SYLLABE YI BBIX",NULL},
/* A058 */ { "SYLLABE YI BBI",NULL},
/* A059 */ { "SYLLABE YI BBIP",NULL},
/* A05A */ { "SYLLABE YI BBIET",NULL},
/* A05B */ { "SYLLABE YI BBIEX",NULL},
/* A05C */ { "SYLLABE YI BBIE",NULL},
/* A05D */ { "SYLLABE YI BBIEP",NULL},
/* A05E */ { "SYLLABE YI BBAT",NULL},
/* A05F */ { "SYLLABE YI BBAX",NULL},
/* A060 */ { "SYLLABE YI BBA",NULL},
/* A061 */ { "SYLLABE YI BBAP",NULL},
/* A062 */ { "SYLLABE YI BBUOX",NULL},
/* A063 */ { "SYLLABE YI BBUO",NULL},
/* A064 */ { "SYLLABE YI BBUOP",NULL},
/* A065 */ { "SYLLABE YI BBOT",NULL},
/* A066 */ { "SYLLABE YI BBOX",NULL},
/* A067 */ { "SYLLABE YI BBO",NULL},
/* A068 */ { "SYLLABE YI BBOP",NULL},
/* A069 */ { "SYLLABE YI BBEX",NULL},
/* A06A */ { "SYLLABE YI BBE",NULL},
/* A06B */ { "SYLLABE YI BBEP",NULL},
/* A06C */ { "SYLLABE YI BBUT",NULL},
/* A06D */ { "SYLLABE YI BBUX",NULL},
/* A06E */ { "SYLLABE YI BBU",NULL},
/* A06F */ { "SYLLABE YI BBUP",NULL},
/* A070 */ { "SYLLABE YI BBURX",NULL},
/* A071 */ { "SYLLABE YI BBUR",NULL},
/* A072 */ { "SYLLABE YI BBYT",NULL},
/* A073 */ { "SYLLABE YI BBYX",NULL},
/* A074 */ { "SYLLABE YI BBY",NULL},
/* A075 */ { "SYLLABE YI BBYP",NULL},
/* A076 */ { "SYLLABE YI NBIT",NULL},
/* A077 */ { "SYLLABE YI NBIX",NULL},
/* A078 */ { "SYLLABE YI NBI",NULL},
/* A079 */ { "SYLLABE YI NBIP",NULL},
/* A07A */ { "SYLLABE YI NBIEX",NULL},
/* A07B */ { "SYLLABE YI NBIE",NULL},
/* A07C */ { "SYLLABE YI NBIEP",NULL},
/* A07D */ { "SYLLABE YI NBAT",NULL},
/* A07E */ { "SYLLABE YI NBAX",NULL},
/* A07F */ { "SYLLABE YI NBA",NULL},
/* A080 */ { "SYLLABE YI NBAP",NULL},
/* A081 */ { "SYLLABE YI NBOT",NULL},
/* A082 */ { "SYLLABE YI NBOX",NULL},
/* A083 */ { "SYLLABE YI NBO",NULL},
/* A084 */ { "SYLLABE YI NBOP",NULL},
/* A085 */ { "SYLLABE YI NBUT",NULL},
/* A086 */ { "SYLLABE YI NBUX",NULL},
/* A087 */ { "SYLLABE YI NBU",NULL},
/* A088 */ { "SYLLABE YI NBUP",NULL},
/* A089 */ { "SYLLABE YI NBURX",NULL},
/* A08A */ { "SYLLABE YI NBUR",NULL},
/* A08B */ { "SYLLABE YI NBYT",NULL},
/* A08C */ { "SYLLABE YI NBYX",NULL},
/* A08D */ { "SYLLABE YI NBY",NULL},
/* A08E */ { "SYLLABE YI NBYP",NULL},
/* A08F */ { "SYLLABE YI NBYRX",NULL},
/* A090 */ { "SYLLABE YI NBYR",NULL},
/* A091 */ { "SYLLABE YI HMIT",NULL},
/* A092 */ { "SYLLABE YI HMIX",NULL},
/* A093 */ { "SYLLABE YI HMI",NULL},
/* A094 */ { "SYLLABE YI HMIP",NULL},
/* A095 */ { "SYLLABE YI HMIEX",NULL},
/* A096 */ { "SYLLABE YI HMIE",NULL},
/* A097 */ { "SYLLABE YI HMIEP",NULL},
/* A098 */ { "SYLLABE YI HMAT",NULL},
/* A099 */ { "SYLLABE YI HMAX",NULL},
/* A09A */ { "SYLLABE YI HMA",NULL},
/* A09B */ { "SYLLABE YI HMAP",NULL},
/* A09C */ { "SYLLABE YI HMUOX",NULL},
/* A09D */ { "SYLLABE YI HMUO",NULL},
/* A09E */ { "SYLLABE YI HMUOP",NULL},
/* A09F */ { "SYLLABE YI HMOT",NULL},
/* A0A0 */ { "SYLLABE YI HMOX",NULL},
/* A0A1 */ { "SYLLABE YI HMO",NULL},
/* A0A2 */ { "SYLLABE YI HMOP",NULL},
/* A0A3 */ { "SYLLABE YI HMUT",NULL},
/* A0A4 */ { "SYLLABE YI HMUX",NULL},
/* A0A5 */ { "SYLLABE YI HMU",NULL},
/* A0A6 */ { "SYLLABE YI HMUP",NULL},
/* A0A7 */ { "SYLLABE YI HMURX",NULL},
/* A0A8 */ { "SYLLABE YI HMUR",NULL},
/* A0A9 */ { "SYLLABE YI HMYX",NULL},
/* A0AA */ { "SYLLABE YI HMY",NULL},
/* A0AB */ { "SYLLABE YI HMYP",NULL},
/* A0AC */ { "SYLLABE YI HMYRX",NULL},
/* A0AD */ { "SYLLABE YI HMYR",NULL},
/* A0AE */ { "SYLLABE YI MIT",NULL},
/* A0AF */ { "SYLLABE YI MIX",NULL},
/* A0B0 */ { "SYLLABE YI MI",NULL},
/* A0B1 */ { "SYLLABE YI MIP",NULL},
/* A0B2 */ { "SYLLABE YI MIEX",NULL},
/* A0B3 */ { "SYLLABE YI MIE",NULL},
/* A0B4 */ { "SYLLABE YI MIEP",NULL},
/* A0B5 */ { "SYLLABE YI MAT",NULL},
/* A0B6 */ { "SYLLABE YI MAX",NULL},
/* A0B7 */ { "SYLLABE YI MA",NULL},
/* A0B8 */ { "SYLLABE YI MAP",NULL},
/* A0B9 */ { "SYLLABE YI MUOT",NULL},
/* A0BA */ { "SYLLABE YI MUOX",NULL},
/* A0BB */ { "SYLLABE YI MUO",NULL},
/* A0BC */ { "SYLLABE YI MUOP",NULL},
/* A0BD */ { "SYLLABE YI MOT",NULL},
/* A0BE */ { "SYLLABE YI MOX",NULL},
/* A0BF */ { "SYLLABE YI MO",NULL},
/* A0C0 */ { "SYLLABE YI MOP",NULL},
/* A0C1 */ { "SYLLABE YI MEX",NULL},
/* A0C2 */ { "SYLLABE YI ME",NULL},
/* A0C3 */ { "SYLLABE YI MUT",NULL},
/* A0C4 */ { "SYLLABE YI MUX",NULL},
/* A0C5 */ { "SYLLABE YI MU",NULL},
/* A0C6 */ { "SYLLABE YI MUP",NULL},
/* A0C7 */ { "SYLLABE YI MURX",NULL},
/* A0C8 */ { "SYLLABE YI MUR",NULL},
/* A0C9 */ { "SYLLABE YI MYT",NULL},
/* A0CA */ { "SYLLABE YI MYX",NULL},
/* A0CB */ { "SYLLABE YI MY",NULL},
/* A0CC */ { "SYLLABE YI MYP",NULL},
/* A0CD */ { "SYLLABE YI FIT",NULL},
/* A0CE */ { "SYLLABE YI FIX",NULL},
/* A0CF */ { "SYLLABE YI FI",NULL},
/* A0D0 */ { "SYLLABE YI FIP",NULL},
/* A0D1 */ { "SYLLABE YI FAT",NULL},
/* A0D2 */ { "SYLLABE YI FAX",NULL},
/* A0D3 */ { "SYLLABE YI FA",NULL},
/* A0D4 */ { "SYLLABE YI FAP",NULL},
/* A0D5 */ { "SYLLABE YI FOX",NULL},
/* A0D6 */ { "SYLLABE YI FO",NULL},
/* A0D7 */ { "SYLLABE YI FOP",NULL},
/* A0D8 */ { "SYLLABE YI FUT",NULL},
/* A0D9 */ { "SYLLABE YI FUX",NULL},
/* A0DA */ { "SYLLABE YI FU",NULL},
/* A0DB */ { "SYLLABE YI FUP",NULL},
/* A0DC */ { "SYLLABE YI FURX",NULL},
/* A0DD */ { "SYLLABE YI FUR",NULL},
/* A0DE */ { "SYLLABE YI FYT",NULL},
/* A0DF */ { "SYLLABE YI FYX",NULL},
/* A0E0 */ { "SYLLABE YI FY",NULL},
/* A0E1 */ { "SYLLABE YI FYP",NULL},
/* A0E2 */ { "SYLLABE YI VIT",NULL},
/* A0E3 */ { "SYLLABE YI VIX",NULL},
/* A0E4 */ { "SYLLABE YI VI",NULL},
/* A0E5 */ { "SYLLABE YI VIP",NULL},
/* A0E6 */ { "SYLLABE YI VIET",NULL},
/* A0E7 */ { "SYLLABE YI VIEX",NULL},
/* A0E8 */ { "SYLLABE YI VIE",NULL},
/* A0E9 */ { "SYLLABE YI VIEP",NULL},
/* A0EA */ { "SYLLABE YI VAT",NULL},
/* A0EB */ { "SYLLABE YI VAX",NULL},
/* A0EC */ { "SYLLABE YI VA",NULL},
/* A0ED */ { "SYLLABE YI VAP",NULL},
/* A0EE */ { "SYLLABE YI VOT",NULL},
/* A0EF */ { "SYLLABE YI VOX",NULL},
/* A0F0 */ { "SYLLABE YI VO",NULL},
/* A0F1 */ { "SYLLABE YI VOP",NULL},
/* A0F2 */ { "SYLLABE YI VEX",NULL},
/* A0F3 */ { "SYLLABE YI VEP",NULL},
/* A0F4 */ { "SYLLABE YI VUT",NULL},
/* A0F5 */ { "SYLLABE YI VUX",NULL},
/* A0F6 */ { "SYLLABE YI VU",NULL},
/* A0F7 */ { "SYLLABE YI VUP",NULL},
/* A0F8 */ { "SYLLABE YI VURX",NULL},
/* A0F9 */ { "SYLLABE YI VUR",NULL},
/* A0FA */ { "SYLLABE YI VYT",NULL},
/* A0FB */ { "SYLLABE YI VYX",NULL},
/* A0FC */ { "SYLLABE YI VY",NULL},
/* A0FD */ { "SYLLABE YI VYP",NULL},
/* A0FE */ { "SYLLABE YI VYRX",NULL},
/* A0FF */ { "SYLLABE YI VYR",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_A1[] = {
/* A100 */ { "SYLLABE YI DIT",NULL},
/* A101 */ { "SYLLABE YI DIX",NULL},
/* A102 */ { "SYLLABE YI DI",NULL},
/* A103 */ { "SYLLABE YI DIP",NULL},
/* A104 */ { "SYLLABE YI DIEX",NULL},
/* A105 */ { "SYLLABE YI DIE",NULL},
/* A106 */ { "SYLLABE YI DIEP",NULL},
/* A107 */ { "SYLLABE YI DAT",NULL},
/* A108 */ { "SYLLABE YI DAX",NULL},
/* A109 */ { "SYLLABE YI DA",NULL},
/* A10A */ { "SYLLABE YI DAP",NULL},
/* A10B */ { "SYLLABE YI DUOX",NULL},
/* A10C */ { "SYLLABE YI DUO",NULL},
/* A10D */ { "SYLLABE YI DOT",NULL},
/* A10E */ { "SYLLABE YI DOX",NULL},
/* A10F */ { "SYLLABE YI DO",NULL},
/* A110 */ { "SYLLABE YI DOP",NULL},
/* A111 */ { "SYLLABE YI DEX",NULL},
/* A112 */ { "SYLLABE YI DE",NULL},
/* A113 */ { "SYLLABE YI DEP",NULL},
/* A114 */ { "SYLLABE YI DUT",NULL},
/* A115 */ { "SYLLABE YI DUX",NULL},
/* A116 */ { "SYLLABE YI DU",NULL},
/* A117 */ { "SYLLABE YI DUP",NULL},
/* A118 */ { "SYLLABE YI DURX",NULL},
/* A119 */ { "SYLLABE YI DUR",NULL},
/* A11A */ { "SYLLABE YI TIT",NULL},
/* A11B */ { "SYLLABE YI TIX",NULL},
/* A11C */ { "SYLLABE YI TI",NULL},
/* A11D */ { "SYLLABE YI TIP",NULL},
/* A11E */ { "SYLLABE YI TIEX",NULL},
/* A11F */ { "SYLLABE YI TIE",NULL},
/* A120 */ { "SYLLABE YI TIEP",NULL},
/* A121 */ { "SYLLABE YI TAT",NULL},
/* A122 */ { "SYLLABE YI TAX",NULL},
/* A123 */ { "SYLLABE YI TA",NULL},
/* A124 */ { "SYLLABE YI TAP",NULL},
/* A125 */ { "SYLLABE YI TUOT",NULL},
/* A126 */ { "SYLLABE YI TUOX",NULL},
/* A127 */ { "SYLLABE YI TUO",NULL},
/* A128 */ { "SYLLABE YI TUOP",NULL},
/* A129 */ { "SYLLABE YI TOT",NULL},
/* A12A */ { "SYLLABE YI TOX",NULL},
/* A12B */ { "SYLLABE YI TO",NULL},
/* A12C */ { "SYLLABE YI TOP",NULL},
/* A12D */ { "SYLLABE YI TEX",NULL},
/* A12E */ { "SYLLABE YI TE",NULL},
/* A12F */ { "SYLLABE YI TEP",NULL},
/* A130 */ { "SYLLABE YI TUT",NULL},
/* A131 */ { "SYLLABE YI TUX",NULL},
/* A132 */ { "SYLLABE YI TU",NULL},
/* A133 */ { "SYLLABE YI TUP",NULL},
/* A134 */ { "SYLLABE YI TURX",NULL},
/* A135 */ { "SYLLABE YI TUR",NULL},
/* A136 */ { "SYLLABE YI DDIT",NULL},
/* A137 */ { "SYLLABE YI DDIX",NULL},
/* A138 */ { "SYLLABE YI DDI",NULL},
/* A139 */ { "SYLLABE YI DDIP",NULL},
/* A13A */ { "SYLLABE YI DDIEX",NULL},
/* A13B */ { "SYLLABE YI DDIE",NULL},
/* A13C */ { "SYLLABE YI DDIEP",NULL},
/* A13D */ { "SYLLABE YI DDAT",NULL},
/* A13E */ { "SYLLABE YI DDAX",NULL},
/* A13F */ { "SYLLABE YI DDA",NULL},
/* A140 */ { "SYLLABE YI DDAP",NULL},
/* A141 */ { "SYLLABE YI DDUOX",NULL},
/* A142 */ { "SYLLABE YI DDUO",NULL},
/* A143 */ { "SYLLABE YI DDUOP",NULL},
/* A144 */ { "SYLLABE YI DDOT",NULL},
/* A145 */ { "SYLLABE YI DDOX",NULL},
/* A146 */ { "SYLLABE YI DDO",NULL},
/* A147 */ { "SYLLABE YI DDOP",NULL},
/* A148 */ { "SYLLABE YI DDEX",NULL},
/* A149 */ { "SYLLABE YI DDE",NULL},
/* A14A */ { "SYLLABE YI DDEP",NULL},
/* A14B */ { "SYLLABE YI DDUT",NULL},
/* A14C */ { "SYLLABE YI DDUX",NULL},
/* A14D */ { "SYLLABE YI DDU",NULL},
/* A14E */ { "SYLLABE YI DDUP",NULL},
/* A14F */ { "SYLLABE YI DDURX",NULL},
/* A150 */ { "SYLLABE YI DDUR",NULL},
/* A151 */ { "SYLLABE YI NDIT",NULL},
/* A152 */ { "SYLLABE YI NDIX",NULL},
/* A153 */ { "SYLLABE YI NDI",NULL},
/* A154 */ { "SYLLABE YI NDIP",NULL},
/* A155 */ { "SYLLABE YI NDIEX",NULL},
/* A156 */ { "SYLLABE YI NDIE",NULL},
/* A157 */ { "SYLLABE YI NDAT",NULL},
/* A158 */ { "SYLLABE YI NDAX",NULL},
/* A159 */ { "SYLLABE YI NDA",NULL},
/* A15A */ { "SYLLABE YI NDAP",NULL},
/* A15B */ { "SYLLABE YI NDOT",NULL},
/* A15C */ { "SYLLABE YI NDOX",NULL},
/* A15D */ { "SYLLABE YI NDO",NULL},
/* A15E */ { "SYLLABE YI NDOP",NULL},
/* A15F */ { "SYLLABE YI NDEX",NULL},
/* A160 */ { "SYLLABE YI NDE",NULL},
/* A161 */ { "SYLLABE YI NDEP",NULL},
/* A162 */ { "SYLLABE YI NDUT",NULL},
/* A163 */ { "SYLLABE YI NDUX",NULL},
/* A164 */ { "SYLLABE YI NDU",NULL},
/* A165 */ { "SYLLABE YI NDUP",NULL},
/* A166 */ { "SYLLABE YI NDURX",NULL},
/* A167 */ { "SYLLABE YI NDUR",NULL},
/* A168 */ { "SYLLABE YI HNIT",NULL},
/* A169 */ { "SYLLABE YI HNIX",NULL},
/* A16A */ { "SYLLABE YI HNI",NULL},
/* A16B */ { "SYLLABE YI HNIP",NULL},
/* A16C */ { "SYLLABE YI HNIET",NULL},
/* A16D */ { "SYLLABE YI HNIEX",NULL},
/* A16E */ { "SYLLABE YI HNIE",NULL},
/* A16F */ { "SYLLABE YI HNIEP",NULL},
/* A170 */ { "SYLLABE YI HNAT",NULL},
/* A171 */ { "SYLLABE YI HNAX",NULL},
/* A172 */ { "SYLLABE YI HNA",NULL},
/* A173 */ { "SYLLABE YI HNAP",NULL},
/* A174 */ { "SYLLABE YI HNUOX",NULL},
/* A175 */ { "SYLLABE YI HNUO",NULL},
/* A176 */ { "SYLLABE YI HNOT",NULL},
/* A177 */ { "SYLLABE YI HNOX",NULL},
/* A178 */ { "SYLLABE YI HNOP",NULL},
/* A179 */ { "SYLLABE YI HNEX",NULL},
/* A17A */ { "SYLLABE YI HNE",NULL},
/* A17B */ { "SYLLABE YI HNEP",NULL},
/* A17C */ { "SYLLABE YI HNUT",NULL},
/* A17D */ { "SYLLABE YI NIT",NULL},
/* A17E */ { "SYLLABE YI NIX",NULL},
/* A17F */ { "SYLLABE YI NI",NULL},
/* A180 */ { "SYLLABE YI NIP",NULL},
/* A181 */ { "SYLLABE YI NIEX",NULL},
/* A182 */ { "SYLLABE YI NIE",NULL},
/* A183 */ { "SYLLABE YI NIEP",NULL},
/* A184 */ { "SYLLABE YI NAX",NULL},
/* A185 */ { "SYLLABE YI NA",NULL},
/* A186 */ { "SYLLABE YI NAP",NULL},
/* A187 */ { "SYLLABE YI NUOX",NULL},
/* A188 */ { "SYLLABE YI NUO",NULL},
/* A189 */ { "SYLLABE YI NUOP",NULL},
/* A18A */ { "SYLLABE YI NOT",NULL},
/* A18B */ { "SYLLABE YI NOX",NULL},
/* A18C */ { "SYLLABE YI NO",NULL},
/* A18D */ { "SYLLABE YI NOP",NULL},
/* A18E */ { "SYLLABE YI NEX",NULL},
/* A18F */ { "SYLLABE YI NE",NULL},
/* A190 */ { "SYLLABE YI NEP",NULL},
/* A191 */ { "SYLLABE YI NUT",NULL},
/* A192 */ { "SYLLABE YI NUX",NULL},
/* A193 */ { "SYLLABE YI NU",NULL},
/* A194 */ { "SYLLABE YI NUP",NULL},
/* A195 */ { "SYLLABE YI NURX",NULL},
/* A196 */ { "SYLLABE YI NUR",NULL},
/* A197 */ { "SYLLABE YI HLIT",NULL},
/* A198 */ { "SYLLABE YI HLIX",NULL},
/* A199 */ { "SYLLABE YI HLI",NULL},
/* A19A */ { "SYLLABE YI HLIP",NULL},
/* A19B */ { "SYLLABE YI HLIEX",NULL},
/* A19C */ { "SYLLABE YI HLIE",NULL},
/* A19D */ { "SYLLABE YI HLIEP",NULL},
/* A19E */ { "SYLLABE YI HLAT",NULL},
/* A19F */ { "SYLLABE YI HLAX",NULL},
/* A1A0 */ { "SYLLABE YI HLA",NULL},
/* A1A1 */ { "SYLLABE YI HLAP",NULL},
/* A1A2 */ { "SYLLABE YI HLUOX",NULL},
/* A1A3 */ { "SYLLABE YI HLUO",NULL},
/* A1A4 */ { "SYLLABE YI HLUOP",NULL},
/* A1A5 */ { "SYLLABE YI HLOX",NULL},
/* A1A6 */ { "SYLLABE YI HLO",NULL},
/* A1A7 */ { "SYLLABE YI HLOP",NULL},
/* A1A8 */ { "SYLLABE YI HLEX",NULL},
/* A1A9 */ { "SYLLABE YI HLE",NULL},
/* A1AA */ { "SYLLABE YI HLEP",NULL},
/* A1AB */ { "SYLLABE YI HLUT",NULL},
/* A1AC */ { "SYLLABE YI HLUX",NULL},
/* A1AD */ { "SYLLABE YI HLU",NULL},
/* A1AE */ { "SYLLABE YI HLUP",NULL},
/* A1AF */ { "SYLLABE YI HLURX",NULL},
/* A1B0 */ { "SYLLABE YI HLUR",NULL},
/* A1B1 */ { "SYLLABE YI HLYT",NULL},
/* A1B2 */ { "SYLLABE YI HLYX",NULL},
/* A1B3 */ { "SYLLABE YI HLY",NULL},
/* A1B4 */ { "SYLLABE YI HLYP",NULL},
/* A1B5 */ { "SYLLABE YI HLYRX",NULL},
/* A1B6 */ { "SYLLABE YI HLYR",NULL},
/* A1B7 */ { "SYLLABE YI LIT",NULL},
/* A1B8 */ { "SYLLABE YI LIX",NULL},
/* A1B9 */ { "SYLLABE YI LI",NULL},
/* A1BA */ { "SYLLABE YI LIP",NULL},
/* A1BB */ { "SYLLABE YI LIET",NULL},
/* A1BC */ { "SYLLABE YI LIEX",NULL},
/* A1BD */ { "SYLLABE YI LIE",NULL},
/* A1BE */ { "SYLLABE YI LIEP",NULL},
/* A1BF */ { "SYLLABE YI LAT",NULL},
/* A1C0 */ { "SYLLABE YI LAX",NULL},
/* A1C1 */ { "SYLLABE YI LA",NULL},
/* A1C2 */ { "SYLLABE YI LAP",NULL},
/* A1C3 */ { "SYLLABE YI LUOT",NULL},
/* A1C4 */ { "SYLLABE YI LUOX",NULL},
/* A1C5 */ { "SYLLABE YI LUO",NULL},
/* A1C6 */ { "SYLLABE YI LUOP",NULL},
/* A1C7 */ { "SYLLABE YI LOT",NULL},
/* A1C8 */ { "SYLLABE YI LOX",NULL},
/* A1C9 */ { "SYLLABE YI LO",NULL},
/* A1CA */ { "SYLLABE YI LOP",NULL},
/* A1CB */ { "SYLLABE YI LEX",NULL},
/* A1CC */ { "SYLLABE YI LE",NULL},
/* A1CD */ { "SYLLABE YI LEP",NULL},
/* A1CE */ { "SYLLABE YI LUT",NULL},
/* A1CF */ { "SYLLABE YI LUX",NULL},
/* A1D0 */ { "SYLLABE YI LU",NULL},
/* A1D1 */ { "SYLLABE YI LUP",NULL},
/* A1D2 */ { "SYLLABE YI LURX",NULL},
/* A1D3 */ { "SYLLABE YI LUR",NULL},
/* A1D4 */ { "SYLLABE YI LYT",NULL},
/* A1D5 */ { "SYLLABE YI LYX",NULL},
/* A1D6 */ { "SYLLABE YI LY",NULL},
/* A1D7 */ { "SYLLABE YI LYP",NULL},
/* A1D8 */ { "SYLLABE YI LYRX",NULL},
/* A1D9 */ { "SYLLABE YI LYR",NULL},
/* A1DA */ { "SYLLABE YI GIT",NULL},
/* A1DB */ { "SYLLABE YI GIX",NULL},
/* A1DC */ { "SYLLABE YI GI",NULL},
/* A1DD */ { "SYLLABE YI GIP",NULL},
/* A1DE */ { "SYLLABE YI GIET",NULL},
/* A1DF */ { "SYLLABE YI GIEX",NULL},
/* A1E0 */ { "SYLLABE YI GIE",NULL},
/* A1E1 */ { "SYLLABE YI GIEP",NULL},
/* A1E2 */ { "SYLLABE YI GAT",NULL},
/* A1E3 */ { "SYLLABE YI GAX",NULL},
/* A1E4 */ { "SYLLABE YI GA",NULL},
/* A1E5 */ { "SYLLABE YI GAP",NULL},
/* A1E6 */ { "SYLLABE YI GUOT",NULL},
/* A1E7 */ { "SYLLABE YI GUOX",NULL},
/* A1E8 */ { "SYLLABE YI GUO",NULL},
/* A1E9 */ { "SYLLABE YI GUOP",NULL},
/* A1EA */ { "SYLLABE YI GOT",NULL},
/* A1EB */ { "SYLLABE YI GOX",NULL},
/* A1EC */ { "SYLLABE YI GO",NULL},
/* A1ED */ { "SYLLABE YI GOP",NULL},
/* A1EE */ { "SYLLABE YI GET",NULL},
/* A1EF */ { "SYLLABE YI GEX",NULL},
/* A1F0 */ { "SYLLABE YI GE",NULL},
/* A1F1 */ { "SYLLABE YI GEP",NULL},
/* A1F2 */ { "SYLLABE YI GUT",NULL},
/* A1F3 */ { "SYLLABE YI GUX",NULL},
/* A1F4 */ { "SYLLABE YI GU",NULL},
/* A1F5 */ { "SYLLABE YI GUP",NULL},
/* A1F6 */ { "SYLLABE YI GURX",NULL},
/* A1F7 */ { "SYLLABE YI GUR",NULL},
/* A1F8 */ { "SYLLABE YI KIT",NULL},
/* A1F9 */ { "SYLLABE YI KIX",NULL},
/* A1FA */ { "SYLLABE YI KI",NULL},
/* A1FB */ { "SYLLABE YI KIP",NULL},
/* A1FC */ { "SYLLABE YI KIEX",NULL},
/* A1FD */ { "SYLLABE YI KIE",NULL},
/* A1FE */ { "SYLLABE YI KIEP",NULL},
/* A1FF */ { "SYLLABE YI KAT",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_A2[] = {
/* A200 */ { "SYLLABE YI KAX",NULL},
/* A201 */ { "SYLLABE YI KA",NULL},
/* A202 */ { "SYLLABE YI KAP",NULL},
/* A203 */ { "SYLLABE YI KUOX",NULL},
/* A204 */ { "SYLLABE YI KUO",NULL},
/* A205 */ { "SYLLABE YI KUOP",NULL},
/* A206 */ { "SYLLABE YI KOT",NULL},
/* A207 */ { "SYLLABE YI KOX",NULL},
/* A208 */ { "SYLLABE YI KO",NULL},
/* A209 */ { "SYLLABE YI KOP",NULL},
/* A20A */ { "SYLLABE YI KET",NULL},
/* A20B */ { "SYLLABE YI KEX",NULL},
/* A20C */ { "SYLLABE YI KE",NULL},
/* A20D */ { "SYLLABE YI KEP",NULL},
/* A20E */ { "SYLLABE YI KUT",NULL},
/* A20F */ { "SYLLABE YI KUX",NULL},
/* A210 */ { "SYLLABE YI KU",NULL},
/* A211 */ { "SYLLABE YI KUP",NULL},
/* A212 */ { "SYLLABE YI KURX",NULL},
/* A213 */ { "SYLLABE YI KUR",NULL},
/* A214 */ { "SYLLABE YI GGIT",NULL},
/* A215 */ { "SYLLABE YI GGIX",NULL},
/* A216 */ { "SYLLABE YI GGI",NULL},
/* A217 */ { "SYLLABE YI GGIEX",NULL},
/* A218 */ { "SYLLABE YI GGIE",NULL},
/* A219 */ { "SYLLABE YI GGIEP",NULL},
/* A21A */ { "SYLLABE YI GGAT",NULL},
/* A21B */ { "SYLLABE YI GGAX",NULL},
/* A21C */ { "SYLLABE YI GGA",NULL},
/* A21D */ { "SYLLABE YI GGAP",NULL},
/* A21E */ { "SYLLABE YI GGUOT",NULL},
/* A21F */ { "SYLLABE YI GGUOX",NULL},
/* A220 */ { "SYLLABE YI GGUO",NULL},
/* A221 */ { "SYLLABE YI GGUOP",NULL},
/* A222 */ { "SYLLABE YI GGOT",NULL},
/* A223 */ { "SYLLABE YI GGOX",NULL},
/* A224 */ { "SYLLABE YI GGO",NULL},
/* A225 */ { "SYLLABE YI GGOP",NULL},
/* A226 */ { "SYLLABE YI GGET",NULL},
/* A227 */ { "SYLLABE YI GGEX",NULL},
/* A228 */ { "SYLLABE YI GGE",NULL},
/* A229 */ { "SYLLABE YI GGEP",NULL},
/* A22A */ { "SYLLABE YI GGUT",NULL},
/* A22B */ { "SYLLABE YI GGUX",NULL},
/* A22C */ { "SYLLABE YI GGU",NULL},
/* A22D */ { "SYLLABE YI GGUP",NULL},
/* A22E */ { "SYLLABE YI GGURX",NULL},
/* A22F */ { "SYLLABE YI GGUR",NULL},
/* A230 */ { "SYLLABE YI MGIEX",NULL},
/* A231 */ { "SYLLABE YI MGIE",NULL},
/* A232 */ { "SYLLABE YI MGAT",NULL},
/* A233 */ { "SYLLABE YI MGAX",NULL},
/* A234 */ { "SYLLABE YI MGA",NULL},
/* A235 */ { "SYLLABE YI MGAP",NULL},
/* A236 */ { "SYLLABE YI MGUOX",NULL},
/* A237 */ { "SYLLABE YI MGUO",NULL},
/* A238 */ { "SYLLABE YI MGUOP",NULL},
/* A239 */ { "SYLLABE YI MGOT",NULL},
/* A23A */ { "SYLLABE YI MGOX",NULL},
/* A23B */ { "SYLLABE YI MGO",NULL},
/* A23C */ { "SYLLABE YI MGOP",NULL},
/* A23D */ { "SYLLABE YI MGEX",NULL},
/* A23E */ { "SYLLABE YI MGE",NULL},
/* A23F */ { "SYLLABE YI MGEP",NULL},
/* A240 */ { "SYLLABE YI MGUT",NULL},
/* A241 */ { "SYLLABE YI MGUX",NULL},
/* A242 */ { "SYLLABE YI MGU",NULL},
/* A243 */ { "SYLLABE YI MGUP",NULL},
/* A244 */ { "SYLLABE YI MGURX",NULL},
/* A245 */ { "SYLLABE YI MGUR",NULL},
/* A246 */ { "SYLLABE YI HXIT",NULL},
/* A247 */ { "SYLLABE YI HXIX",NULL},
/* A248 */ { "SYLLABE YI HXI",NULL},
/* A249 */ { "SYLLABE YI HXIP",NULL},
/* A24A */ { "SYLLABE YI HXIET",NULL},
/* A24B */ { "SYLLABE YI HXIEX",NULL},
/* A24C */ { "SYLLABE YI HXIE",NULL},
/* A24D */ { "SYLLABE YI HXIEP",NULL},
/* A24E */ { "SYLLABE YI HXAT",NULL},
/* A24F */ { "SYLLABE YI HXAX",NULL},
/* A250 */ { "SYLLABE YI HXA",NULL},
/* A251 */ { "SYLLABE YI HXAP",NULL},
/* A252 */ { "SYLLABE YI HXUOT",NULL},
/* A253 */ { "SYLLABE YI HXUOX",NULL},
/* A254 */ { "SYLLABE YI HXUO",NULL},
/* A255 */ { "SYLLABE YI HXUOP",NULL},
/* A256 */ { "SYLLABE YI HXOT",NULL},
/* A257 */ { "SYLLABE YI HXOX",NULL},
/* A258 */ { "SYLLABE YI HXO",NULL},
/* A259 */ { "SYLLABE YI HXOP",NULL},
/* A25A */ { "SYLLABE YI HXEX",NULL},
/* A25B */ { "SYLLABE YI HXE",NULL},
/* A25C */ { "SYLLABE YI HXEP",NULL},
/* A25D */ { "SYLLABE YI NGIEX",NULL},
/* A25E */ { "SYLLABE YI NGIE",NULL},
/* A25F */ { "SYLLABE YI NGIEP",NULL},
/* A260 */ { "SYLLABE YI NGAT",NULL},
/* A261 */ { "SYLLABE YI NGAX",NULL},
/* A262 */ { "SYLLABE YI NGA",NULL},
/* A263 */ { "SYLLABE YI NGAP",NULL},
/* A264 */ { "SYLLABE YI NGUOT",NULL},
/* A265 */ { "SYLLABE YI NGUOX",NULL},
/* A266 */ { "SYLLABE YI NGUO",NULL},
/* A267 */ { "SYLLABE YI NGOT",NULL},
/* A268 */ { "SYLLABE YI NGOX",NULL},
/* A269 */ { "SYLLABE YI NGO",NULL},
/* A26A */ { "SYLLABE YI NGOP",NULL},
/* A26B */ { "SYLLABE YI NGEX",NULL},
/* A26C */ { "SYLLABE YI NGE",NULL},
/* A26D */ { "SYLLABE YI NGEP",NULL},
/* A26E */ { "SYLLABE YI HIT",NULL},
/* A26F */ { "SYLLABE YI HIEX",NULL},
/* A270 */ { "SYLLABE YI HIE",NULL},
/* A271 */ { "SYLLABE YI HAT",NULL},
/* A272 */ { "SYLLABE YI HAX",NULL},
/* A273 */ { "SYLLABE YI HA",NULL},
/* A274 */ { "SYLLABE YI HAP",NULL},
/* A275 */ { "SYLLABE YI HUOT",NULL},
/* A276 */ { "SYLLABE YI HUOX",NULL},
/* A277 */ { "SYLLABE YI HUO",NULL},
/* A278 */ { "SYLLABE YI HUOP",NULL},
/* A279 */ { "SYLLABE YI HOT",NULL},
/* A27A */ { "SYLLABE YI HOX",NULL},
/* A27B */ { "SYLLABE YI HO",NULL},
/* A27C */ { "SYLLABE YI HOP",NULL},
/* A27D */ { "SYLLABE YI HEX",NULL},
/* A27E */ { "SYLLABE YI HE",NULL},
/* A27F */ { "SYLLABE YI HEP",NULL},
/* A280 */ { "SYLLABE YI WAT",NULL},
/* A281 */ { "SYLLABE YI WAX",NULL},
/* A282 */ { "SYLLABE YI WA",NULL},
/* A283 */ { "SYLLABE YI WAP",NULL},
/* A284 */ { "SYLLABE YI WUOX",NULL},
/* A285 */ { "SYLLABE YI WUO",NULL},
/* A286 */ { "SYLLABE YI WUOP",NULL},
/* A287 */ { "SYLLABE YI WOX",NULL},
/* A288 */ { "SYLLABE YI WO",NULL},
/* A289 */ { "SYLLABE YI WOP",NULL},
/* A28A */ { "SYLLABE YI WEX",NULL},
/* A28B */ { "SYLLABE YI WE",NULL},
/* A28C */ { "SYLLABE YI WEP",NULL},
/* A28D */ { "SYLLABE YI ZIT",NULL},
/* A28E */ { "SYLLABE YI ZIX",NULL},
/* A28F */ { "SYLLABE YI ZI",NULL},
/* A290 */ { "SYLLABE YI ZIP",NULL},
/* A291 */ { "SYLLABE YI ZIEX",NULL},
/* A292 */ { "SYLLABE YI ZIE",NULL},
/* A293 */ { "SYLLABE YI ZIEP",NULL},
/* A294 */ { "SYLLABE YI ZAT",NULL},
/* A295 */ { "SYLLABE YI ZAX",NULL},
/* A296 */ { "SYLLABE YI ZA",NULL},
/* A297 */ { "SYLLABE YI ZAP",NULL},
/* A298 */ { "SYLLABE YI ZUOX",NULL},
/* A299 */ { "SYLLABE YI ZUO",NULL},
/* A29A */ { "SYLLABE YI ZUOP",NULL},
/* A29B */ { "SYLLABE YI ZOT",NULL},
/* A29C */ { "SYLLABE YI ZOX",NULL},
/* A29D */ { "SYLLABE YI ZO",NULL},
/* A29E */ { "SYLLABE YI ZOP",NULL},
/* A29F */ { "SYLLABE YI ZEX",NULL},
/* A2A0 */ { "SYLLABE YI ZE",NULL},
/* A2A1 */ { "SYLLABE YI ZEP",NULL},
/* A2A2 */ { "SYLLABE YI ZUT",NULL},
/* A2A3 */ { "SYLLABE YI ZUX",NULL},
/* A2A4 */ { "SYLLABE YI ZU",NULL},
/* A2A5 */ { "SYLLABE YI ZUP",NULL},
/* A2A6 */ { "SYLLABE YI ZURX",NULL},
/* A2A7 */ { "SYLLABE YI ZUR",NULL},
/* A2A8 */ { "SYLLABE YI ZYT",NULL},
/* A2A9 */ { "SYLLABE YI ZYX",NULL},
/* A2AA */ { "SYLLABE YI ZY",NULL},
/* A2AB */ { "SYLLABE YI ZYP",NULL},
/* A2AC */ { "SYLLABE YI ZYRX",NULL},
/* A2AD */ { "SYLLABE YI ZYR",NULL},
/* A2AE */ { "SYLLABE YI CIT",NULL},
/* A2AF */ { "SYLLABE YI CIX",NULL},
/* A2B0 */ { "SYLLABE YI CI",NULL},
/* A2B1 */ { "SYLLABE YI CIP",NULL},
/* A2B2 */ { "SYLLABE YI CIET",NULL},
/* A2B3 */ { "SYLLABE YI CIEX",NULL},
/* A2B4 */ { "SYLLABE YI CIE",NULL},
/* A2B5 */ { "SYLLABE YI CIEP",NULL},
/* A2B6 */ { "SYLLABE YI CAT",NULL},
/* A2B7 */ { "SYLLABE YI CAX",NULL},
/* A2B8 */ { "SYLLABE YI CA",NULL},
/* A2B9 */ { "SYLLABE YI CAP",NULL},
/* A2BA */ { "SYLLABE YI CUOX",NULL},
/* A2BB */ { "SYLLABE YI CUO",NULL},
/* A2BC */ { "SYLLABE YI CUOP",NULL},
/* A2BD */ { "SYLLABE YI COT",NULL},
/* A2BE */ { "SYLLABE YI COX",NULL},
/* A2BF */ { "SYLLABE YI CO",NULL},
/* A2C0 */ { "SYLLABE YI COP",NULL},
/* A2C1 */ { "SYLLABE YI CEX",NULL},
/* A2C2 */ { "SYLLABE YI CE",NULL},
/* A2C3 */ { "SYLLABE YI CEP",NULL},
/* A2C4 */ { "SYLLABE YI CUT",NULL},
/* A2C5 */ { "SYLLABE YI CUX",NULL},
/* A2C6 */ { "SYLLABE YI CU",NULL},
/* A2C7 */ { "SYLLABE YI CUP",NULL},
/* A2C8 */ { "SYLLABE YI CURX",NULL},
/* A2C9 */ { "SYLLABE YI CUR",NULL},
/* A2CA */ { "SYLLABE YI CYT",NULL},
/* A2CB */ { "SYLLABE YI CYX",NULL},
/* A2CC */ { "SYLLABE YI CY",NULL},
/* A2CD */ { "SYLLABE YI CYP",NULL},
/* A2CE */ { "SYLLABE YI CYRX",NULL},
/* A2CF */ { "SYLLABE YI CYR",NULL},
/* A2D0 */ { "SYLLABE YI ZZIT",NULL},
/* A2D1 */ { "SYLLABE YI ZZIX",NULL},
/* A2D2 */ { "SYLLABE YI ZZI",NULL},
/* A2D3 */ { "SYLLABE YI ZZIP",NULL},
/* A2D4 */ { "SYLLABE YI ZZIET",NULL},
/* A2D5 */ { "SYLLABE YI ZZIEX",NULL},
/* A2D6 */ { "SYLLABE YI ZZIE",NULL},
/* A2D7 */ { "SYLLABE YI ZZIEP",NULL},
/* A2D8 */ { "SYLLABE YI ZZAT",NULL},
/* A2D9 */ { "SYLLABE YI ZZAX",NULL},
/* A2DA */ { "SYLLABE YI ZZA",NULL},
/* A2DB */ { "SYLLABE YI ZZAP",NULL},
/* A2DC */ { "SYLLABE YI ZZOX",NULL},
/* A2DD */ { "SYLLABE YI ZZO",NULL},
/* A2DE */ { "SYLLABE YI ZZOP",NULL},
/* A2DF */ { "SYLLABE YI ZZEX",NULL},
/* A2E0 */ { "SYLLABE YI ZZE",NULL},
/* A2E1 */ { "SYLLABE YI ZZEP",NULL},
/* A2E2 */ { "SYLLABE YI ZZUX",NULL},
/* A2E3 */ { "SYLLABE YI ZZU",NULL},
/* A2E4 */ { "SYLLABE YI ZZUP",NULL},
/* A2E5 */ { "SYLLABE YI ZZURX",NULL},
/* A2E6 */ { "SYLLABE YI ZZUR",NULL},
/* A2E7 */ { "SYLLABE YI ZZYT",NULL},
/* A2E8 */ { "SYLLABE YI ZZYX",NULL},
/* A2E9 */ { "SYLLABE YI ZZY",NULL},
/* A2EA */ { "SYLLABE YI ZZYP",NULL},
/* A2EB */ { "SYLLABE YI ZZYRX",NULL},
/* A2EC */ { "SYLLABE YI ZZYR",NULL},
/* A2ED */ { "SYLLABE YI NZIT",NULL},
/* A2EE */ { "SYLLABE YI NZIX",NULL},
/* A2EF */ { "SYLLABE YI NZI",NULL},
/* A2F0 */ { "SYLLABE YI NZIP",NULL},
/* A2F1 */ { "SYLLABE YI NZIEX",NULL},
/* A2F2 */ { "SYLLABE YI NZIE",NULL},
/* A2F3 */ { "SYLLABE YI NZIEP",NULL},
/* A2F4 */ { "SYLLABE YI NZAT",NULL},
/* A2F5 */ { "SYLLABE YI NZAX",NULL},
/* A2F6 */ { "SYLLABE YI NZA",NULL},
/* A2F7 */ { "SYLLABE YI NZAP",NULL},
/* A2F8 */ { "SYLLABE YI NZUOX",NULL},
/* A2F9 */ { "SYLLABE YI NZUO",NULL},
/* A2FA */ { "SYLLABE YI NZOX",NULL},
/* A2FB */ { "SYLLABE YI NZOP",NULL},
/* A2FC */ { "SYLLABE YI NZEX",NULL},
/* A2FD */ { "SYLLABE YI NZE",NULL},
/* A2FE */ { "SYLLABE YI NZUX",NULL},
/* A2FF */ { "SYLLABE YI NZU",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_A3[] = {
/* A300 */ { "SYLLABE YI NZUP",NULL},
/* A301 */ { "SYLLABE YI NZURX",NULL},
/* A302 */ { "SYLLABE YI NZUR",NULL},
/* A303 */ { "SYLLABE YI NZYT",NULL},
/* A304 */ { "SYLLABE YI NZYX",NULL},
/* A305 */ { "SYLLABE YI NZY",NULL},
/* A306 */ { "SYLLABE YI NZYP",NULL},
/* A307 */ { "SYLLABE YI NZYRX",NULL},
/* A308 */ { "SYLLABE YI NZYR",NULL},
/* A309 */ { "SYLLABE YI SIT",NULL},
/* A30A */ { "SYLLABE YI SIX",NULL},
/* A30B */ { "SYLLABE YI SI",NULL},
/* A30C */ { "SYLLABE YI SIP",NULL},
/* A30D */ { "SYLLABE YI SIEX",NULL},
/* A30E */ { "SYLLABE YI SIE",NULL},
/* A30F */ { "SYLLABE YI SIEP",NULL},
/* A310 */ { "SYLLABE YI SAT",NULL},
/* A311 */ { "SYLLABE YI SAX",NULL},
/* A312 */ { "SYLLABE YI SA",NULL},
/* A313 */ { "SYLLABE YI SAP",NULL},
/* A314 */ { "SYLLABE YI SUOX",NULL},
/* A315 */ { "SYLLABE YI SUO",NULL},
/* A316 */ { "SYLLABE YI SUOP",NULL},
/* A317 */ { "SYLLABE YI SOT",NULL},
/* A318 */ { "SYLLABE YI SOX",NULL},
/* A319 */ { "SYLLABE YI SO",NULL},
/* A31A */ { "SYLLABE YI SOP",NULL},
/* A31B */ { "SYLLABE YI SEX",NULL},
/* A31C */ { "SYLLABE YI SE",NULL},
/* A31D */ { "SYLLABE YI SEP",NULL},
/* A31E */ { "SYLLABE YI SUT",NULL},
/* A31F */ { "SYLLABE YI SUX",NULL},
/* A320 */ { "SYLLABE YI SU",NULL},
/* A321 */ { "SYLLABE YI SUP",NULL},
/* A322 */ { "SYLLABE YI SURX",NULL},
/* A323 */ { "SYLLABE YI SUR",NULL},
/* A324 */ { "SYLLABE YI SYT",NULL},
/* A325 */ { "SYLLABE YI SYX",NULL},
/* A326 */ { "SYLLABE YI SY",NULL},
/* A327 */ { "SYLLABE YI SYP",NULL},
/* A328 */ { "SYLLABE YI SYRX",NULL},
/* A329 */ { "SYLLABE YI SYR",NULL},
/* A32A */ { "SYLLABE YI SSIT",NULL},
/* A32B */ { "SYLLABE YI SSIX",NULL},
/* A32C */ { "SYLLABE YI SSI",NULL},
/* A32D */ { "SYLLABE YI SSIP",NULL},
/* A32E */ { "SYLLABE YI SSIEX",NULL},
/* A32F */ { "SYLLABE YI SSIE",NULL},
/* A330 */ { "SYLLABE YI SSIEP",NULL},
/* A331 */ { "SYLLABE YI SSAT",NULL},
/* A332 */ { "SYLLABE YI SSAX",NULL},
/* A333 */ { "SYLLABE YI SSA",NULL},
/* A334 */ { "SYLLABE YI SSAP",NULL},
/* A335 */ { "SYLLABE YI SSOT",NULL},
/* A336 */ { "SYLLABE YI SSOX",NULL},
/* A337 */ { "SYLLABE YI SSO",NULL},
/* A338 */ { "SYLLABE YI SSOP",NULL},
/* A339 */ { "SYLLABE YI SSEX",NULL},
/* A33A */ { "SYLLABE YI SSE",NULL},
/* A33B */ { "SYLLABE YI SSEP",NULL},
/* A33C */ { "SYLLABE YI SSUT",NULL},
/* A33D */ { "SYLLABE YI SSUX",NULL},
/* A33E */ { "SYLLABE YI SSU",NULL},
/* A33F */ { "SYLLABE YI SSUP",NULL},
/* A340 */ { "SYLLABE YI SSYT",NULL},
/* A341 */ { "SYLLABE YI SSYX",NULL},
/* A342 */ { "SYLLABE YI SSY",NULL},
/* A343 */ { "SYLLABE YI SSYP",NULL},
/* A344 */ { "SYLLABE YI SSYRX",NULL},
/* A345 */ { "SYLLABE YI SSYR",NULL},
/* A346 */ { "SYLLABE YI ZHAT",NULL},
/* A347 */ { "SYLLABE YI ZHAX",NULL},
/* A348 */ { "SYLLABE YI ZHA",NULL},
/* A349 */ { "SYLLABE YI ZHAP",NULL},
/* A34A */ { "SYLLABE YI ZHUOX",NULL},
/* A34B */ { "SYLLABE YI ZHUO",NULL},
/* A34C */ { "SYLLABE YI ZHUOP",NULL},
/* A34D */ { "SYLLABE YI ZHOT",NULL},
/* A34E */ { "SYLLABE YI ZHOX",NULL},
/* A34F */ { "SYLLABE YI ZHO",NULL},
/* A350 */ { "SYLLABE YI ZHOP",NULL},
/* A351 */ { "SYLLABE YI ZHET",NULL},
/* A352 */ { "SYLLABE YI ZHEX",NULL},
/* A353 */ { "SYLLABE YI ZHE",NULL},
/* A354 */ { "SYLLABE YI ZHEP",NULL},
/* A355 */ { "SYLLABE YI ZHUT",NULL},
/* A356 */ { "SYLLABE YI ZHUX",NULL},
/* A357 */ { "SYLLABE YI ZHU",NULL},
/* A358 */ { "SYLLABE YI ZHUP",NULL},
/* A359 */ { "SYLLABE YI ZHURX",NULL},
/* A35A */ { "SYLLABE YI ZHUR",NULL},
/* A35B */ { "SYLLABE YI ZHYT",NULL},
/* A35C */ { "SYLLABE YI ZHYX",NULL},
/* A35D */ { "SYLLABE YI ZHY",NULL},
/* A35E */ { "SYLLABE YI ZHYP",NULL},
/* A35F */ { "SYLLABE YI ZHYRX",NULL},
/* A360 */ { "SYLLABE YI ZHYR",NULL},
/* A361 */ { "SYLLABE YI CHAT",NULL},
/* A362 */ { "SYLLABE YI CHAX",NULL},
/* A363 */ { "SYLLABE YI CHA",NULL},
/* A364 */ { "SYLLABE YI CHAP",NULL},
/* A365 */ { "SYLLABE YI CHUOT",NULL},
/* A366 */ { "SYLLABE YI CHUOX",NULL},
/* A367 */ { "SYLLABE YI CHUO",NULL},
/* A368 */ { "SYLLABE YI CHUOP",NULL},
/* A369 */ { "SYLLABE YI CHOT",NULL},
/* A36A */ { "SYLLABE YI CHOX",NULL},
/* A36B */ { "SYLLABE YI CHO",NULL},
/* A36C */ { "SYLLABE YI CHOP",NULL},
/* A36D */ { "SYLLABE YI CHET",NULL},
/* A36E */ { "SYLLABE YI CHEX",NULL},
/* A36F */ { "SYLLABE YI CHE",NULL},
/* A370 */ { "SYLLABE YI CHEP",NULL},
/* A371 */ { "SYLLABE YI CHUX",NULL},
/* A372 */ { "SYLLABE YI CHU",NULL},
/* A373 */ { "SYLLABE YI CHUP",NULL},
/* A374 */ { "SYLLABE YI CHURX",NULL},
/* A375 */ { "SYLLABE YI CHUR",NULL},
/* A376 */ { "SYLLABE YI CHYT",NULL},
/* A377 */ { "SYLLABE YI CHYX",NULL},
/* A378 */ { "SYLLABE YI CHY",NULL},
/* A379 */ { "SYLLABE YI CHYP",NULL},
/* A37A */ { "SYLLABE YI CHYRX",NULL},
/* A37B */ { "SYLLABE YI CHYR",NULL},
/* A37C */ { "SYLLABE YI RRAX",NULL},
/* A37D */ { "SYLLABE YI RRA",NULL},
/* A37E */ { "SYLLABE YI RRUOX",NULL},
/* A37F */ { "SYLLABE YI RRUO",NULL},
/* A380 */ { "SYLLABE YI RROT",NULL},
/* A381 */ { "SYLLABE YI RROX",NULL},
/* A382 */ { "SYLLABE YI RRO",NULL},
/* A383 */ { "SYLLABE YI RROP",NULL},
/* A384 */ { "SYLLABE YI RRET",NULL},
/* A385 */ { "SYLLABE YI RREX",NULL},
/* A386 */ { "SYLLABE YI RRE",NULL},
/* A387 */ { "SYLLABE YI RREP",NULL},
/* A388 */ { "SYLLABE YI RRUT",NULL},
/* A389 */ { "SYLLABE YI RRUX",NULL},
/* A38A */ { "SYLLABE YI RRU",NULL},
/* A38B */ { "SYLLABE YI RRUP",NULL},
/* A38C */ { "SYLLABE YI RRURX",NULL},
/* A38D */ { "SYLLABE YI RRUR",NULL},
/* A38E */ { "SYLLABE YI RRYT",NULL},
/* A38F */ { "SYLLABE YI RRYX",NULL},
/* A390 */ { "SYLLABE YI RRY",NULL},
/* A391 */ { "SYLLABE YI RRYP",NULL},
/* A392 */ { "SYLLABE YI RRYRX",NULL},
/* A393 */ { "SYLLABE YI RRYR",NULL},
/* A394 */ { "SYLLABE YI NRAT",NULL},
/* A395 */ { "SYLLABE YI NRAX",NULL},
/* A396 */ { "SYLLABE YI NRA",NULL},
/* A397 */ { "SYLLABE YI NRAP",NULL},
/* A398 */ { "SYLLABE YI NROX",NULL},
/* A399 */ { "SYLLABE YI NRO",NULL},
/* A39A */ { "SYLLABE YI NROP",NULL},
/* A39B */ { "SYLLABE YI NRET",NULL},
/* A39C */ { "SYLLABE YI NREX",NULL},
/* A39D */ { "SYLLABE YI NRE",NULL},
/* A39E */ { "SYLLABE YI NREP",NULL},
/* A39F */ { "SYLLABE YI NRUT",NULL},
/* A3A0 */ { "SYLLABE YI NRUX",NULL},
/* A3A1 */ { "SYLLABE YI NRU",NULL},
/* A3A2 */ { "SYLLABE YI NRUP",NULL},
/* A3A3 */ { "SYLLABE YI NRURX",NULL},
/* A3A4 */ { "SYLLABE YI NRUR",NULL},
/* A3A5 */ { "SYLLABE YI NRYT",NULL},
/* A3A6 */ { "SYLLABE YI NRYX",NULL},
/* A3A7 */ { "SYLLABE YI NRY",NULL},
/* A3A8 */ { "SYLLABE YI NRYP",NULL},
/* A3A9 */ { "SYLLABE YI NRYRX",NULL},
/* A3AA */ { "SYLLABE YI NRYR",NULL},
/* A3AB */ { "SYLLABE YI SHAT",NULL},
/* A3AC */ { "SYLLABE YI SHAX",NULL},
/* A3AD */ { "SYLLABE YI SHA",NULL},
/* A3AE */ { "SYLLABE YI SHAP",NULL},
/* A3AF */ { "SYLLABE YI SHUOX",NULL},
/* A3B0 */ { "SYLLABE YI SHUO",NULL},
/* A3B1 */ { "SYLLABE YI SHUOP",NULL},
/* A3B2 */ { "SYLLABE YI SHOT",NULL},
/* A3B3 */ { "SYLLABE YI SHOX",NULL},
/* A3B4 */ { "SYLLABE YI SHO",NULL},
/* A3B5 */ { "SYLLABE YI SHOP",NULL},
/* A3B6 */ { "SYLLABE YI SHET",NULL},
/* A3B7 */ { "SYLLABE YI SHEX",NULL},
/* A3B8 */ { "SYLLABE YI SHE",NULL},
/* A3B9 */ { "SYLLABE YI SHEP",NULL},
/* A3BA */ { "SYLLABE YI SHUT",NULL},
/* A3BB */ { "SYLLABE YI SHUX",NULL},
/* A3BC */ { "SYLLABE YI SHU",NULL},
/* A3BD */ { "SYLLABE YI SHUP",NULL},
/* A3BE */ { "SYLLABE YI SHURX",NULL},
/* A3BF */ { "SYLLABE YI SHUR",NULL},
/* A3C0 */ { "SYLLABE YI SHYT",NULL},
/* A3C1 */ { "SYLLABE YI SHYX",NULL},
/* A3C2 */ { "SYLLABE YI SHY",NULL},
/* A3C3 */ { "SYLLABE YI SHYP",NULL},
/* A3C4 */ { "SYLLABE YI SHYRX",NULL},
/* A3C5 */ { "SYLLABE YI SHYR",NULL},
/* A3C6 */ { "SYLLABE YI RAT",NULL},
/* A3C7 */ { "SYLLABE YI RAX",NULL},
/* A3C8 */ { "SYLLABE YI RA",NULL},
/* A3C9 */ { "SYLLABE YI RAP",NULL},
/* A3CA */ { "SYLLABE YI RUOX",NULL},
/* A3CB */ { "SYLLABE YI RUO",NULL},
/* A3CC */ { "SYLLABE YI RUOP",NULL},
/* A3CD */ { "SYLLABE YI ROT",NULL},
/* A3CE */ { "SYLLABE YI ROX",NULL},
/* A3CF */ { "SYLLABE YI RO",NULL},
/* A3D0 */ { "SYLLABE YI ROP",NULL},
/* A3D1 */ { "SYLLABE YI REX",NULL},
/* A3D2 */ { "SYLLABE YI RE",NULL},
/* A3D3 */ { "SYLLABE YI REP",NULL},
/* A3D4 */ { "SYLLABE YI RUT",NULL},
/* A3D5 */ { "SYLLABE YI RUX",NULL},
/* A3D6 */ { "SYLLABE YI RU",NULL},
/* A3D7 */ { "SYLLABE YI RUP",NULL},
/* A3D8 */ { "SYLLABE YI RURX",NULL},
/* A3D9 */ { "SYLLABE YI RUR",NULL},
/* A3DA */ { "SYLLABE YI RYT",NULL},
/* A3DB */ { "SYLLABE YI RYX",NULL},
/* A3DC */ { "SYLLABE YI RY",NULL},
/* A3DD */ { "SYLLABE YI RYP",NULL},
/* A3DE */ { "SYLLABE YI RYRX",NULL},
/* A3DF */ { "SYLLABE YI RYR",NULL},
/* A3E0 */ { "SYLLABE YI JIT",NULL},
/* A3E1 */ { "SYLLABE YI JIX",NULL},
/* A3E2 */ { "SYLLABE YI JI",NULL},
/* A3E3 */ { "SYLLABE YI JIP",NULL},
/* A3E4 */ { "SYLLABE YI JIET",NULL},
/* A3E5 */ { "SYLLABE YI JIEX",NULL},
/* A3E6 */ { "SYLLABE YI JIE",NULL},
/* A3E7 */ { "SYLLABE YI JIEP",NULL},
/* A3E8 */ { "SYLLABE YI JUOT",NULL},
/* A3E9 */ { "SYLLABE YI JUOX",NULL},
/* A3EA */ { "SYLLABE YI JUO",NULL},
/* A3EB */ { "SYLLABE YI JUOP",NULL},
/* A3EC */ { "SYLLABE YI JOT",NULL},
/* A3ED */ { "SYLLABE YI JOX",NULL},
/* A3EE */ { "SYLLABE YI JO",NULL},
/* A3EF */ { "SYLLABE YI JOP",NULL},
/* A3F0 */ { "SYLLABE YI JUT",NULL},
/* A3F1 */ { "SYLLABE YI JUX",NULL},
/* A3F2 */ { "SYLLABE YI JU",NULL},
/* A3F3 */ { "SYLLABE YI JUP",NULL},
/* A3F4 */ { "SYLLABE YI JURX",NULL},
/* A3F5 */ { "SYLLABE YI JUR",NULL},
/* A3F6 */ { "SYLLABE YI JYT",NULL},
/* A3F7 */ { "SYLLABE YI JYX",NULL},
/* A3F8 */ { "SYLLABE YI JY",NULL},
/* A3F9 */ { "SYLLABE YI JYP",NULL},
/* A3FA */ { "SYLLABE YI JYRX",NULL},
/* A3FB */ { "SYLLABE YI JYR",NULL},
/* A3FC */ { "SYLLABE YI QIT",NULL},
/* A3FD */ { "SYLLABE YI QIX",NULL},
/* A3FE */ { "SYLLABE YI QI",NULL},
/* A3FF */ { "SYLLABE YI QIP",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_A4[] = {
/* A400 */ { "SYLLABE YI QIET",NULL},
/* A401 */ { "SYLLABE YI QIEX",NULL},
/* A402 */ { "SYLLABE YI QIE",NULL},
/* A403 */ { "SYLLABE YI QIEP",NULL},
/* A404 */ { "SYLLABE YI QUOT",NULL},
/* A405 */ { "SYLLABE YI QUOX",NULL},
/* A406 */ { "SYLLABE YI QUO",NULL},
/* A407 */ { "SYLLABE YI QUOP",NULL},
/* A408 */ { "SYLLABE YI QOT",NULL},
/* A409 */ { "SYLLABE YI QOX",NULL},
/* A40A */ { "SYLLABE YI QO",NULL},
/* A40B */ { "SYLLABE YI QOP",NULL},
/* A40C */ { "SYLLABE YI QUT",NULL},
/* A40D */ { "SYLLABE YI QUX",NULL},
/* A40E */ { "SYLLABE YI QU",NULL},
/* A40F */ { "SYLLABE YI QUP",NULL},
/* A410 */ { "SYLLABE YI QURX",NULL},
/* A411 */ { "SYLLABE YI QUR",NULL},
/* A412 */ { "SYLLABE YI QYT",NULL},
/* A413 */ { "SYLLABE YI QYX",NULL},
/* A414 */ { "SYLLABE YI QY",NULL},
/* A415 */ { "SYLLABE YI QYP",NULL},
/* A416 */ { "SYLLABE YI QYRX",NULL},
/* A417 */ { "SYLLABE YI QYR",NULL},
/* A418 */ { "SYLLABE YI JJIT",NULL},
/* A419 */ { "SYLLABE YI JJIX",NULL},
/* A41A */ { "SYLLABE YI JJI",NULL},
/* A41B */ { "SYLLABE YI JJIP",NULL},
/* A41C */ { "SYLLABE YI JJIET",NULL},
/* A41D */ { "SYLLABE YI JJIEX",NULL},
/* A41E */ { "SYLLABE YI JJIE",NULL},
/* A41F */ { "SYLLABE YI JJIEP",NULL},
/* A420 */ { "SYLLABE YI JJUOX",NULL},
/* A421 */ { "SYLLABE YI JJUO",NULL},
/* A422 */ { "SYLLABE YI JJUOP",NULL},
/* A423 */ { "SYLLABE YI JJOT",NULL},
/* A424 */ { "SYLLABE YI JJOX",NULL},
/* A425 */ { "SYLLABE YI JJO",NULL},
/* A426 */ { "SYLLABE YI JJOP",NULL},
/* A427 */ { "SYLLABE YI JJUT",NULL},
/* A428 */ { "SYLLABE YI JJUX",NULL},
/* A429 */ { "SYLLABE YI JJU",NULL},
/* A42A */ { "SYLLABE YI JJUP",NULL},
/* A42B */ { "SYLLABE YI JJURX",NULL},
/* A42C */ { "SYLLABE YI JJUR",NULL},
/* A42D */ { "SYLLABE YI JJYT",NULL},
/* A42E */ { "SYLLABE YI JJYX",NULL},
/* A42F */ { "SYLLABE YI JJY",NULL},
/* A430 */ { "SYLLABE YI JJYP",NULL},
/* A431 */ { "SYLLABE YI NJIT",NULL},
/* A432 */ { "SYLLABE YI NJIX",NULL},
/* A433 */ { "SYLLABE YI NJI",NULL},
/* A434 */ { "SYLLABE YI NJIP",NULL},
/* A435 */ { "SYLLABE YI NJIET",NULL},
/* A436 */ { "SYLLABE YI NJIEX",NULL},
/* A437 */ { "SYLLABE YI NJIE",NULL},
/* A438 */ { "SYLLABE YI NJIEP",NULL},
/* A439 */ { "SYLLABE YI NJUOX",NULL},
/* A43A */ { "SYLLABE YI NJUO",NULL},
/* A43B */ { "SYLLABE YI NJOT",NULL},
/* A43C */ { "SYLLABE YI NJOX",NULL},
/* A43D */ { "SYLLABE YI NJO",NULL},
/* A43E */ { "SYLLABE YI NJOP",NULL},
/* A43F */ { "SYLLABE YI NJUX",NULL},
/* A440 */ { "SYLLABE YI NJU",NULL},
/* A441 */ { "SYLLABE YI NJUP",NULL},
/* A442 */ { "SYLLABE YI NJURX",NULL},
/* A443 */ { "SYLLABE YI NJUR",NULL},
/* A444 */ { "SYLLABE YI NJYT",NULL},
/* A445 */ { "SYLLABE YI NJYX",NULL},
/* A446 */ { "SYLLABE YI NJY",NULL},
/* A447 */ { "SYLLABE YI NJYP",NULL},
/* A448 */ { "SYLLABE YI NJYRX",NULL},
/* A449 */ { "SYLLABE YI NJYR",NULL},
/* A44A */ { "SYLLABE YI NYIT",NULL},
/* A44B */ { "SYLLABE YI NYIX",NULL},
/* A44C */ { "SYLLABE YI NYI",NULL},
/* A44D */ { "SYLLABE YI NYIP",NULL},
/* A44E */ { "SYLLABE YI NYIET",NULL},
/* A44F */ { "SYLLABE YI NYIEX",NULL},
/* A450 */ { "SYLLABE YI NYIE",NULL},
/* A451 */ { "SYLLABE YI NYIEP",NULL},
/* A452 */ { "SYLLABE YI NYUOX",NULL},
/* A453 */ { "SYLLABE YI NYUO",NULL},
/* A454 */ { "SYLLABE YI NYUOP",NULL},
/* A455 */ { "SYLLABE YI NYOT",NULL},
/* A456 */ { "SYLLABE YI NYOX",NULL},
/* A457 */ { "SYLLABE YI NYO",NULL},
/* A458 */ { "SYLLABE YI NYOP",NULL},
/* A459 */ { "SYLLABE YI NYUT",NULL},
/* A45A */ { "SYLLABE YI NYUX",NULL},
/* A45B */ { "SYLLABE YI NYU",NULL},
/* A45C */ { "SYLLABE YI NYUP",NULL},
/* A45D */ { "SYLLABE YI XIT",NULL},
/* A45E */ { "SYLLABE YI XIX",NULL},
/* A45F */ { "SYLLABE YI XI",NULL},
/* A460 */ { "SYLLABE YI XIP",NULL},
/* A461 */ { "SYLLABE YI XIET",NULL},
/* A462 */ { "SYLLABE YI XIEX",NULL},
/* A463 */ { "SYLLABE YI XIE",NULL},
/* A464 */ { "SYLLABE YI XIEP",NULL},
/* A465 */ { "SYLLABE YI XUOX",NULL},
/* A466 */ { "SYLLABE YI XUO",NULL},
/* A467 */ { "SYLLABE YI XOT",NULL},
/* A468 */ { "SYLLABE YI XOX",NULL},
/* A469 */ { "SYLLABE YI XO",NULL},
/* A46A */ { "SYLLABE YI XOP",NULL},
/* A46B */ { "SYLLABE YI XYT",NULL},
/* A46C */ { "SYLLABE YI XYX",NULL},
/* A46D */ { "SYLLABE YI XY",NULL},
/* A46E */ { "SYLLABE YI XYP",NULL},
/* A46F */ { "SYLLABE YI XYRX",NULL},
/* A470 */ { "SYLLABE YI XYR",NULL},
/* A471 */ { "SYLLABE YI YIT",NULL},
/* A472 */ { "SYLLABE YI YIX",NULL},
/* A473 */ { "SYLLABE YI YI",NULL},
/* A474 */ { "SYLLABE YI YIP",NULL},
/* A475 */ { "SYLLABE YI YIET",NULL},
/* A476 */ { "SYLLABE YI YIEX",NULL},
/* A477 */ { "SYLLABE YI YIE",NULL},
/* A478 */ { "SYLLABE YI YIEP",NULL},
/* A479 */ { "SYLLABE YI YUOT",NULL},
/* A47A */ { "SYLLABE YI YUOX",NULL},
/* A47B */ { "SYLLABE YI YUO",NULL},
/* A47C */ { "SYLLABE YI YUOP",NULL},
/* A47D */ { "SYLLABE YI YOT",NULL},
/* A47E */ { "SYLLABE YI YOX",NULL},
/* A47F */ { "SYLLABE YI YO",NULL},
/* A480 */ { "SYLLABE YI YOP",NULL},
/* A481 */ { "SYLLABE YI YUT",NULL},
/* A482 */ { "SYLLABE YI YUX",NULL},
/* A483 */ { "SYLLABE YI YU",NULL},
/* A484 */ { "SYLLABE YI YUP",NULL},
/* A485 */ { "SYLLABE YI YURX",NULL},
/* A486 */ { "SYLLABE YI YUR",NULL},
/* A487 */ { "SYLLABE YI YYT",NULL},
/* A488 */ { "SYLLABE YI YYX",NULL},
/* A489 */ { "SYLLABE YI YY",NULL},
/* A48A */ { "SYLLABE YI YYP",NULL},
/* A48B */ { "SYLLABE YI YYRX",NULL},
/* A48C */ { "SYLLABE YI YYR",NULL},
/* A48D */ { NULL,NULL},
/* A48E */ { NULL,NULL},
/* A48F */ { NULL,NULL},
/* A490 */ { "CLÉ YI QOT","	x (syllabe yi qot - A408)"},
/* A491 */ { "CLÉ YI LI","	x (syllabe yi li - A1B9)"},
/* A492 */ { "CLÉ YI KIT",NULL},
/* A493 */ { "CLÉ YI NYIP",NULL},
/* A494 */ { "CLÉ YI CYP",NULL},
/* A495 */ { "CLÉ YI SSI",NULL},
/* A496 */ { "CLÉ YI GGOP",NULL},
/* A497 */ { "CLÉ YI GEP",NULL},
/* A498 */ { "CLÉ YI MI",NULL},
/* A499 */ { "CLÉ YI HXIT",NULL},
/* A49A */ { "CLÉ YI LYR",NULL},
/* A49B */ { "CLÉ YI BBUT",NULL},
/* A49C */ { "CLÉ YI MOP",NULL},
/* A49D */ { "CLÉ YI YO",NULL},
/* A49E */ { "CLÉ YI PUT",NULL},
/* A49F */ { "CLÉ YI HXUO",NULL},
/* A4A0 */ { "CLÉ YI HXOT",NULL},
/* A4A1 */ { "CLÉ YI GA",NULL},
/* A4A2 */ { "CLÉ YI ZUP",NULL},
/* A4A3 */ { "CLÉ YI CYT",NULL},
/* A4A4 */ { "CLÉ YI DDUR",NULL},
/* A4A5 */ { "CLÉ YI BUR",NULL},
/* A4A6 */ { "CLÉ YI GGUO",NULL},
/* A4A7 */ { "CLÉ YI NYOP",NULL},
/* A4A8 */ { "CLÉ YI TU",NULL},
/* A4A9 */ { "CLÉ YI OP",NULL},
/* A4AA */ { "CLÉ YI JJUT",NULL},
/* A4AB */ { "CLÉ YI ZOT",NULL},
/* A4AC */ { "CLÉ YI PYT",NULL},
/* A4AD */ { "CLÉ YI HMO",NULL},
/* A4AE */ { "CLÉ YI YIT",NULL},
/* A4AF */ { "CLÉ YI VUR",NULL},
/* A4B0 */ { "CLÉ YI SHY",NULL},
/* A4B1 */ { "CLÉ YI VEP",NULL},
/* A4B2 */ { "CLÉ YI ZA",NULL},
/* A4B3 */ { "CLÉ YI JO",NULL},
/* A4B4 */ { "CLÉ YI NZUP",NULL},
/* A4B5 */ { "CLÉ YI JJY",NULL},
/* A4B6 */ { "CLÉ YI GOT",NULL},
/* A4B7 */ { "CLÉ YI BE",NULL},
/* A4B8 */ { "CLÉ YI WO",NULL},
/* A4B9 */ { "CLÉ YI DU",NULL},
/* A4BA */ { "CLÉ YI SHUR",NULL},
/* A4BB */ { "CLÉ YI LIE",NULL},
/* A4BC */ { "CLÉ YI CY",NULL},
/* A4BD */ { "CLÉ YI CUOP",NULL},
/* A4BE */ { "CLÉ YI CIP",NULL},
/* A4BF */ { "CLÉ YI HXOP",NULL},
/* A4C0 */ { "CLÉ YI SHAT",NULL},
/* A4C1 */ { "CLÉ YI ZUR",NULL},
/* A4C2 */ { "CLÉ YI SHOP",NULL},
/* A4C3 */ { "CLÉ YI CHE",NULL},
/* A4C4 */ { "CLÉ YI ZZIET",NULL},
/* A4C5 */ { "CLÉ YI NBIE",NULL},
/* A4C6 */ { "CLÉ YI KE",NULL},
/* A4C7 */ { NULL,NULL},
/* A4C8 */ { NULL,NULL},
/* A4C9 */ { NULL,NULL},
/* A4CA */ { NULL,NULL},
/* A4CB */ { NULL,NULL},
/* A4CC */ { NULL,NULL},
/* A4CD */ { NULL,NULL},
/* A4CE */ { NULL,NULL},
/* A4CF */ { NULL,NULL},
/* A4D0 */ { "LETTRE LISSOU BA",NULL},
/* A4D1 */ { "LETTRE LISSOU PA",NULL},
/* A4D2 */ { "LETTRE LISSOU PHA",NULL},
/* A4D3 */ { "LETTRE LISSOU DA",NULL},
/* A4D4 */ { "LETTRE LISSOU TA",NULL},
/* A4D5 */ { "LETTRE LISSOU THA",NULL},
/* A4D6 */ { "LETTRE LISSOU GA",NULL},
/* A4D7 */ { "LETTRE LISSOU KA",NULL},
/* A4D8 */ { "LETTRE LISSOU KHA",NULL},
/* A4D9 */ { "LETTRE LISSOU JA",NULL},
/* A4DA */ { "LETTRE LISSOU CA",NULL},
/* A4DB */ { "LETTRE LISSOU CHA",NULL},
/* A4DC */ { "LETTRE LISSOU DZA",NULL},
/* A4DD */ { "LETTRE LISSOU TSA",NULL},
/* A4DE */ { "LETTRE LISSOU TSHA",NULL},
/* A4DF */ { "LETTRE LISSOU MA",NULL},
/* A4E0 */ { "LETTRE LISSOU NA",NULL},
/* A4E1 */ { "LETTRE LISSOU LA",NULL},
/* A4E2 */ { "LETTRE LISSOU SA",NULL},
/* A4E3 */ { "LETTRE LISSOU ZHA",NULL},
/* A4E4 */ { "LETTRE LISSOU ZA",NULL},
/* A4E5 */ { "LETTRE LISSOU NGA",NULL},
/* A4E6 */ { "LETTRE LISSOU HA",NULL},
/* A4E7 */ { "LETTRE LISSOU XA",NULL},
/* A4E8 */ { "LETTRE LISSOU HHA",NULL},
/* A4E9 */ { "LETTRE LISSOU FA",NULL},
/* A4EA */ { "LETTRE LISSOU WA",NULL},
/* A4EB */ { "LETTRE LISSOU SHA",NULL},
/* A4EC */ { "LETTRE LISSOU YA",NULL},
/* A4ED */ { "LETTRE LISSOU GHA",NULL},
/* A4EE */ { "LETTRE LISSOU A",NULL},
/* A4EF */ { "LETTRE LISSOU AE",NULL},
/* A4F0 */ { "LETTRE LISSOU E",NULL},
/* A4F1 */ { "LETTRE LISSOU EU",NULL},
/* A4F2 */ { "LETTRE LISSOU I",NULL},
/* A4F3 */ { "LETTRE LISSOU O",NULL},
/* A4F4 */ { "LETTRE LISSOU U",NULL},
/* A4F5 */ { "LETTRE LISSOU UE",NULL},
/* A4F6 */ { "LETTRE LISSOU UH",NULL},
/* A4F7 */ { "LETTRE LISSOU OE",NULL},
/* A4F8 */ { "LETTRE LISSOU TON MYA TI",NULL},
/* A4F9 */ { "LETTRE LISSOU TON NA PO",NULL},
/* A4FA */ { "LETTRE LISSOU TON MYA CYA",NULL},
/* A4FB */ { "LETTRE LISSOU TON MYA BO",NULL},
/* A4FC */ { "LETTRE LISSOU TON MYA NA",NULL},
/* A4FD */ { "LETTRE LISSOU TON MYA JEU",NULL},
/* A4FE */ { "PONCTUATION LISSOU VIRGULE",NULL},
/* A4FF */ { "PONCTUATION LISSOU POINT",NULL}
};

UN_DLL_LOCAL
static const struct unicode_nameannot unaFR_00_A5[] = {
/* A500 */ { "SYLLABE VAÏE É",NULL},
/* A501 */ { "SYLLABE VAÏE ÉN",NULL},
/* A502 */ { "SYLLABE VAÏE HÉ",NULL},
/* A503 */ { "SYLLABE VAÏE WÉ",NULL},
/* A504 */ { "SYLLABE VAÏE WÉN",NULL},
/* A505 */ { "SYLLABE VAÏE PÉ",NULL},
/* A506 */ { "SYLLABE VAÏE BHÉ",NULL},
/* A507 */ { "SYLLABE VAÏE BÉ",NULL},
/* A508 */ { "SYLLABE VAÏE MBÉ",NULL},
/* A509 */ { "SYLLABE VAÏE KPÉ",NULL},
/* A50A */ { "SYLLABE VAÏE MGBÉ",NULL},
/* A50B */ { "SYLLABE VAÏE GBÉ",NULL},
/* A50C */ { "SYLLABE VAÏE FÉ",NULL},
/* A50D */ { "SYLLABE VAÏE VÉ",NULL},
/* A50E */ { "SYLLABE VAÏE TÉ",NULL},
/* A50F */ { "SYLLABE VAÏE THÉ",NULL},
/* A510 */ { "SYLLABE VAÏE DHÉ",NULL},
/* A511 */ { "SYLLABE VAÏE DHHÉ",NULL},
/* A512 */ { "SYLLABE VAÏE LÉ",NULL},
/* A513 */ { "SYLLABE VAÏE RÉ",NULL},
/* A514 */ { "SYLLABE VAÏE DÉ",NULL},
/* A515 */ { "SYLLABE VAÏE NDÉ",NULL},
/* A516 */ { "SYLLABE VAÏE SÉ",NULL},
/* A517 */ { "SYLLABE VAÏE CHÉ",NULL},
/* A518 */ { "SYLLABE VAÏE ZÉ",NULL},
/* A519 */ { "SYLLABE VAÏE ZHÉ",NULL},
/* A51A */ { "SYLLABE VAÏE TCHÉ",NULL},
/* A51B */ { "SYLLABE VAÏE JÉ",NULL},
/* A51C */ { "SYLLABE VAÏE NJÉ",NULL},
/* A51D */ { "SYLLABE VAÏE YÉ",NULL},
/* A51E */ { "SYLLABE VAÏE KÉ",NULL},
/* A51F */ { "SYLLABE VAÏE NGGÉ",NULL},
/* A520 */ { "SYLLABE VAÏE GÉ",NULL},
/* A521 */ { "SYLLABE VAÏE MÉ",NULL},
/* A522 */ { "SYLLABE VAÏE NÉ",NULL},
/* A523 */ { "SYLLABE VAÏE ÑÉ",NULL},
/* A524 */ { "SYLLABE VAÏE I",NULL},
/* A525 */ { "SYLLABE VAÏE IN",NULL},
/* A526 */ { "SYLLABE VAÏE HI",NULL},
/* A527 */ { "SYLLABE VAÏE HIN",NULL},
/* A528 */ { "SYLLABE VAÏE WI",NULL},
/* A529 */ { "SYLLABE VAÏE WIN",NULL},
/* A52A */ { "SYLLABE VAÏE PI",NULL},
/* A52B */ { "SYLLABE VAÏE BHI",NULL},
/* A52C */ { "SYLLABE VAÏE BI",NULL},
/* A52D */ { "SYLLABE VAÏE MBI",NULL},
/* A52E */ { "SYLLABE VAÏE KPI",NULL},
/* A52F */ { "SYLLABE VAÏE MGBI",NULL},
/* A530 */ { "SYLLABE VAÏE GBI",NULL},
/* A531 */ { "SYLLABE VAÏE FI",NULL},
/* A532 */ { "SYLLABE VAÏE VI",NULL},
/* A533 */ { "SYLLABE VAÏE TI",NULL},
/* A534 */ { "SYLLABE VAÏE THI",NULL},
/* A535 */ { "SYLLABE VAÏE DHI",NULL},
/* A536 */ { "SYLLABE VAÏE DHHI",NULL},
/* A537 */ { "SYLLABE VAÏE LI",NULL},
/* A538 */ { "SYLLABE VAÏE RI",NULL},
/* A539 */ { "SYLLABE VAÏE DI",NULL},
/* A53A */ { "SYLLABE VAÏE NDI",NULL},
/* A53B */ { "SYLLABE VAÏE SI",NULL},
/* A53C */ { "SYLLABE VAÏE CHI",NULL},
/* A53D */ { "SYLLABE VAÏE ZI",NULL},
/* A53E */ { "SYLLABE VAÏE ZHI",NULL},
/* A53F */ { "SYLLABE VAÏE TCHI",NULL},
/* A540 */ { "SYLLABE VAÏE JI",NULL},
/* A541 */ { "SYLLABE VAÏE NJI",NULL},
/* A542 */ { "SYLLABE VAÏE YI",NULL},
/* A543 */ { "SYLLABE VAÏE KI",NULL},
/* A544 */ { "SYLLABE VAÏE NGGI",NULL},
/* A545 */ { "SYLLABE VAÏE GI",NULL},
/* A546 */ { "SYLLABE VAÏE MI",NULL},
/* A547 */ { "SYLLABE VAÏE NI",NULL},
/* A548 */ { "SYLLABE VAÏE ÑI",NULL},
/* A549 */ { "SYLLABE VAÏE A",NULL},
/* A54A */ { "SYLLABE VAÏE AN",NULL},
/* A54B */ { "SYLLABE VAÏE NGAN",NULL},
/* A54C */ { "SYLLABE VAÏE HA",NULL},
/* A54D */ { "SYLLABE VAÏE HAN",NULL},
/* A54E */ { "SYLLABE VAÏE WA",NULL},
/* A54F */ { "SYLLABE VAÏE WAN",NULL},
/* A550 */ { "SYLLABE VAÏE PA",NULL},
/* A551 */ { "SYLLABE VAÏE BHA",NULL},
/* A552 */ { "SYLLABE VAÏE BA",NULL},
/* A553 */ { "SYLLABE VAÏE MBA",NULL},
/* A554 */ { "SYLLABE VAÏE KPA",NULL},
/* A555 */ { "SYLLABE VAÏE KPAN",NULL},
/* A556 */ { "SYLLABE VAÏE MGBA",NULL},
/* A557 */ { "SYLLABE VAÏE GBA",NULL},
/* A558 */ { "SYLLABE VAÏE FA","	x (syllabe vaïe ndolé fa - A610)"},
/* A559 */ { "SYLLABE VAÏE VA",NULL},
/* A55A */ { "SYLLABE VAÏE TA",NULL},
/* A55B */ { "SYLLABE VAÏE THA",NULL},
/* A55C */ { "SYLLABE VAÏE DHA",NULL},
/* A55D */ { "SYLLABE VAÏE DHHA",NULL},
/* A55E */ { "SYLLABE VAÏE LA",NULL},
/* A55F */ { "SYLLABE VAÏE RA",NULL},
/* A560 */ { "SYLLABE VAÏE DA",NULL},
/* A561 */ { "SYLLABE VAÏE NDA",NULL},
/* A562 */ { "SYLLABE VAÏE SA",NULL},
/* A563 */ { "SYLLABE VAÏE CHA",NULL},
/* A564 */ { "SYLLABE VAÏE ZA",NULL},
/* A565 */ { "SYLLABE VAÏE ZHA",NULL},
/* A566 */ { "SYLLABE VAÏE TCHA",NULL},
/* A567 */ { "SYLLABE VAÏE JA",NULL},
/* A568 */ { "SYLLABE VAÏE NJA",NULL},
/* A569 */ { "SYLLABE VAÏE YA",NULL},
/* A56A */ { "SYLLABE VAÏE KA","	x (syllabe vaïe ndolé ka - A611)"},
/* A56B */ { "SYLLABE VAÏE KAN",NULL},
/* A56C */ { "SYLLABE VAÏE NGGA",NULL},
/* A56D */ { "SYLLABE VAÏE GA",NULL},
/* A56E */ { "SYLLABE VAÏE MA","	x (syllabe vaïe ndolé ma - A62A)"},
/* A56F */ { "SYLLABE VAÏE NA",NULL},
/* A570 */ { "SYLLABE VAÏE ÑA",NULL},
/* A571 */ { "SYLLABE VAÏE Ô",NULL},
/* A572 */ { "SYLLABE VAÏE ÔN",NULL},
/* A573 */ { "SYLLABE VAÏE HÔ",NULL},
/* A574 */ { "SYLLABE VAÏE WÔ",NULL},
/* A575 */ { "SYLLABE VAÏE WÔN",NULL},
/* A576 */ { "SYLLABE VAÏE PÔ",NULL},
/* A577 */ { "SYLLABE VAÏE BHÔ",NULL},
/* A578 */ { "SYLLABE VAÏE BÔ",NULL},
/* A579 */ { "SYLLABE VAÏE MBÔ",NULL},
/* A57A */ { "SYLLABE VAÏE KPÔ",NULL},
/* A57B */ { "SYLLABE VAÏE MGBÔ",NULL},
/* A57C */ { "SYLLABE VAÏE GBÔ",NULL},
/* A57D */ { "SYLLABE VAÏE FÔ",NULL},
/* A57E */ { "SYLLABE VAÏE VÔ",NULL},
/* A57F */ { "SYLLABE VAÏE TÔ",NULL},
/* A580 */ { "SYLLABE VAÏE THÔ",NULL},
/* A581 */ { "SYLLABE VAÏE DHÔ",NULL},
/* A582 */ { "SYLLABE VAÏE DHHÔ",NULL},
/* A583 */ { "SYLLABE VAÏE LÔ",NULL},
/* A584 */ { "SYLLABE VAÏE RÔ",NULL},
/* A585 */ { "SYLLABE VAÏE DÔ",NULL},
/* A586 */ { "SYLLABE VAÏE NDÔ",NULL},
/* A587 */ { "SYLLABE VAÏE SÔ","	x (syllabe vaïe ndolé sô - A612)"},
/* A588 */ { "SYLLABE VAÏE CHÔ",NULL},
/* A589 */ { "SYLLABE VAÏE ZÔ",NULL},
/* A58A */ { "SYLLABE VAÏE ZHÔ",NULL},
/* A58B */ { "SYLLABE VAÏE TCHÔ",NULL},
/* A58C */ { "SYLLABE VAÏE JÔ",NULL},
/* A58D */ { "SYLLABE VAÏE NJÔ",NULL},
/* A58E */ { "SYLLABE VAÏE YÔ",NULL},
/* A58F */ { "SYLLABE VAÏE KÔ",NULL},
/* A590 */ { "SYLLABE VAÏE NGGÔ",NULL},
/* A591 */ { "SYLLABE VAÏE GÔ",NULL},
/* A592 */ { "SYLLABE VAÏE MÔ",NULL},
/* A593 */ { "SYLLABE VAÏE NÔ",NULL},
/* A594 */ { "SYLLABE VAÏE ÑÔ",NULL},
/* A595 */ { "SYLLABE VAÏE OU",NULL},
/* A596 */ { "SYLLABE VAÏE OUN",NULL},
/* A597 */ { "SYLLABE VAÏE HOU",NULL},
/* A598 */ { "SYLLABE VAÏE HOUN",NULL},
/* A599 */ { "SYLLABE VAÏE WOU",NULL},
/* A59A */ { "SYLLABE VAÏE WOUN",NULL},
/* A59B */ { "SYLLABE VAÏE POU",NULL},
/* A59C */ { "SYLLABE VAÏE BHOU",NULL},
/* A59D */ { "SYLLABE VAÏE BOU",NULL},
/* A59E */ { "SYLLABE VAÏE MBOU",NULL},
/* A59F */ { "SYLLABE VAÏE KPOU",NULL},
/* A5A0 */ { "SYLLABE VAÏE MGBOU",NULL},
/* A5A1 */ { "SYLLABE VAÏE GBOU",NULL},
/* A5A2 */ { "SYLLABE VAÏE FOU",NULL},
/* A5A3 */ { "SYLLABE VAÏE VOU",NULL},
/* A5A4 */ { "SYLLABE VAÏE TOU",NULL},
/* A5A5 */ { "SYLLABE VAÏE THOU",NULL},
/* A5A6 */ { "SYLLABE VAÏE DHOU",NULL},
/* A5A7 */ { "SYLLABE VAÏE DHHOU",NULL},
/* A5A8 */ { "SYLLABE VAÏE LOU",NULL},
/* A5A9 */ { "SYLLABE VAÏE ROU",NULL},
/* A5AA */ { "SYLLABE VAÏE DOU",NULL},
/* A5AB */ { "SYLLABE VAÏE NDOU",NULL},
/* A5AC */ { "SYLLABE VAÏE SOU",NULL},
/* A5AD */ { "SYLLABE VAÏE CHOU",NULL},
/* A5AE */ { "SYLLABE VAÏE ZOU",NULL},
/* A5AF */ { "SYLLABE VAÏE ZHOU",NULL},
/* A5B0 */ { "SYLLABE VAÏE TCHOU",NULL},
/* A5B1 */ { "SYLLABE VAÏE JOU",NULL},
/* A5B2 */ { "SYLLABE VAÏE NJOU",NULL},
/* A5B3 */ { "SYLLABE VAÏE YOU",NULL},
/* A5B4 */ { "SYLLABE VAÏE KOU",NULL},
/* A5B5 */ { "SYLLABE VAÏE NGGOU",NULL},
/* A5B6 */ { "SYLLABE VAÏE GOU",NULL},
/* A5B7 */ { "SYLLABE VAÏE MOU",NULL},
/* A5B8 */ { "SYLLABE VAÏE NOU",NULL},
/* A5B9 */ { "SYLLABE VAÏE ÑOU",NULL},
/* A5BA */ { "SYLLABE VAÏE O",NULL},
/* A5BB */ { "SYLLABE VAÏE ON",NULL},
/* A5BC */ { "SYLLABE VAÏE NGON",NULL},
/* A5BD */ { "SYLLABE VAÏE HO",NULL},
/* A5BE */ { "SYLLABE VAÏE HON",NULL},
/* A5BF */ { "SYLLABE VAÏE WO",NULL},
/* A5C0 */ { "SYLLABE VAÏE WON",NULL},
/* A5C1 */ { "SYLLABE VAÏE PO",NULL},
/* A5C2 */ { "SYLLABE VAÏE BHO",NULL},
/* A5C3 */ { "SYLLABE VAÏE BO",NULL},
/* A5C4 */ { "SYLLABE VAÏE MBO",NULL},
/* A5C5 */ { "SYLLABE VAÏE KPO",NULL},
/* A5C6 */ { "SYLLABE VAÏE MGBO",NULL},
/* A5C7 */ { "SYLLABE VAÏE GBO",NULL},
/* A5C8 */ { "SYLLABE VAÏE GBON",NULL},
/* A5C9 */ { "SYLLABE VAÏE FO",NULL},
/* A5CA */ { "SYLLABE VAÏE VO",NULL},
/* A5CB */ { "SYLLABE VAÏE TO",NULL},
/* A5CC */ { "SYLLABE VAÏE THO",NULL},
/* A5CD */ { "SYLLABE VAÏE DHO",NULL},
/* A5CE */ { "SYLLABE VAÏE DHHO",NULL},
/* A5CF */ { "SYLLABE VAÏE LO",NULL},
/* A5D0 */ { "SYLLABE VAÏE RO",NULL},
/* A5D1 */ { "SYLLABE VAÏE DO","	x (syllabe vaïe ndolé do - A62B)"},
/* A5D2 */ { "SYLLABE VAÏE NDO",NULL},
/* A5D3 */ { "SYLLABE VAÏE SO",NULL},
/* A5D4 */ { "SYLLABE VAÏE CHO",NULL},
/* A5D5 */ { "SYLLABE VAÏE ZO",NULL},
/* A5D6 */ { "SYLLABE VAÏE ZHO",NULL},
/* A5D7 */ { "SYLLABE VAÏE TCHO",NULL},
/* A5D8 */ { "SYLLABE VAÏE JO",NULL},
/* A5D9 */ { "SYLLABE VAÏE NJO",NULL},
/* A5DA */ { "SYLLABE VAÏE YO",NULL},
/* A5DB */ { "SYLLABE VAÏE KO",NULL},
/* A5DC */ { "SYLLABE VAÏE NGGO",NULL},
/* A5DD */ { "SYLLABE VAÏE GO",NULL},
/* A5DE */ { "SYLLABE VAÏE MO",NULL},
/* A5DF */ { "SYLLABE VAÏE NO",NULL},
/* A5E0 */ { "SYLLABE VAÏE ÑO",NULL},
/* A5E1 */ { "SYLLABE VAÏE Ê",NULL},
/* A5E2 */ { "SYLLABE VAÏE ÊN",NULL},
/* A5E3 */ { "SYLLABE VAÏE NGÊN",NULL},
/* A5E4 */ { "SYLLABE VAÏE HÊ",NULL},
/* A5E5 */ { "SYLLABE VAÏE HÊN",NULL},
/* A5E6 */ { "SYLLABE VAÏE WÊ",NULL},
/* A5E7 */ { "SYLLABE VAÏE WÊN",NULL},
/* A5E8 */ { "SYLLABE VAÏE PÊ",NULL},
/* A5E9 */ { "SYLLABE VAÏE BHÊ",NULL},
/* A5EA */ { "SYLLABE VAÏE BÊ",NULL},
/* A5EB */ { "SYLLABE VAÏE MBÊ",NULL},
/* A5EC */ { "SYLLABE VAÏE KPÊ",NULL},
/* A5ED */ { "SYLLABE VAÏE KPÊN",NULL},
/* A5EE */ { "SYLLABE VAÏE MGBÊ",NULL},
/* A5EF */ { "SYLLABE VAÏE GBÊ",NULL},
/* A5F0 */ { "SYLLABE VAÏE GBÊN",NULL},
/* A5F1 */ { "SYLLABE VAÏE FÊ",NULL},
/* A5F2 */ { "SYLLABE VAÏE VÊ",NULL},
/* A5F3 */ { "SYLLABE VAÏE TÊ",NULL},
/* A5F4 */ { "SYLLABE VAÏE THÊ",NULL},
/* A5F5 */ { "SYLLABE VAÏE DHÊ",NULL},
/* A5F6 */ { "SYLLABE VAÏE DHHÊ",NULL},
/* A5F7 */ { "SYLLABE VAÏE LÊ",NULL},
/* A5F8 */ { "SYLLABE VAÏE RÊ",NULL},
/* A5F9 */ { "SYLLABE VAÏE DÊ",NULL},
/* A5FA */ { "SYLLABE VAÏE NDÊ",NULL},
/*