/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#include "tests/support.h"

#include <libsyncml/syncml.h>
#include <libsyncml/sml_error_internals.h>

START_TEST (error_create)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorSet(&error, SML_ERROR_GENERIC, "test%i", 1);
	sml_fail_unless(error != NULL, NULL);
	sml_fail_unless(error->type == SML_ERROR_GENERIC, NULL);
	sml_fail_unless(!strcmp(error->message, "test1"), NULL);
	sml_fail_unless(smlErrorIsSet(&error), NULL);
	
	smlErrorDeref(&error);
	sml_fail_unless(error == NULL, NULL);
}
END_TEST

START_TEST (error_create_null)
{
	setup_testbed(NULL);
	
	smlErrorSet(NULL, SML_ERROR_GENERIC, "test%i", 1);
}
END_TEST

START_TEST (error_free_null)
{
	setup_testbed(NULL);
	
	smlErrorDeref(NULL);
}
END_TEST

START_TEST (error_free_null2)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorDeref(&error);
}
END_TEST

START_TEST (error_free)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorSet(&error, SML_ERROR_GENERIC, "test");
	sml_fail_unless(error != NULL, NULL);
	smlErrorDeref(&error);
	sml_fail_unless(error == NULL, NULL);
}
END_TEST

START_TEST (error_check_null)
{
	setup_testbed(NULL);
	
	sml_fail_unless(smlErrorIsSet(NULL) == FALSE, NULL);
}
END_TEST

START_TEST (error_check_null2)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	sml_fail_unless(smlErrorIsSet(&error) == FALSE, NULL);
}
END_TEST

START_TEST (error_check)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorSet(&error, SML_ERROR_GENERIC, "test");
	sml_fail_unless(smlErrorIsSet(&error) == TRUE, NULL);
	smlErrorDeref(&error);
}
END_TEST

START_TEST (error_check2)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorSet(&error, SML_NO_ERROR, NULL);
	sml_fail_unless(smlErrorIsSet(&error) == FALSE, NULL);
}
END_TEST

START_TEST (error_update_null)
{
	setup_testbed(NULL);
	
	smlErrorUpdate(NULL, NULL);
}
END_TEST

START_TEST (error_update_null2)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorUpdate(&error, NULL);
}
END_TEST

START_TEST (error_update)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorSet(&error, SML_ERROR_GENERIC, "test");
	smlErrorUpdate(&error, "test2%i", 1);
	sml_fail_unless(!strcmp(error->message, "test21"), NULL);
	smlErrorDeref(&error);
}
END_TEST

START_TEST (error_update2)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorSet(&error, SML_ERROR_GENERIC, "test");
	smlErrorUpdate(&error, "test2%s", error->message);
	sml_fail_unless(!strcmp(error->message, "test2test"), "%s != test2test", error->message);
	smlErrorDeref(&error);
}
END_TEST

START_TEST (error_set_null)
{
	setup_testbed(NULL);
	
	smlErrorSet(NULL, SML_NO_ERROR, NULL);

}
END_TEST

START_TEST (error_set_null2)
{
	
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorUpdate(&error, NULL);
}
END_TEST

START_TEST (error_duplicate_null)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	smlErrorSet(&error, SML_ERROR_GENERIC, "asd");
	smlErrorDuplicate(NULL, &error);
	smlErrorDeref(&error);
}
END_TEST

START_TEST (error_class)
{
	setup_testbed(NULL);
	
	sml_fail_unless(smlErrorGetClass(NULL) == SML_ERRORCLASS_SUCCESS, NULL);
	
	SmlError *error = NULL;
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_SUCCESS, NULL);
	
	smlErrorSet(&error, SML_NO_ERROR, "test%i", 1);
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_SUCCESS, NULL);
	smlErrorDeref(&error);
	
	smlErrorSet(&error, SML_ERROR_SEE_OTHER_RETRY, "test%i", 1);
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_RETRY, NULL);
	smlErrorDeref(&error);
	
	smlErrorSet(&error, SML_ERROR_GENERIC, "test%i", 1);
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_FATAL, NULL);
	smlErrorDeref(&error);
	
	sml_fail_unless(error == NULL, NULL);
}
END_TEST

@SML_TESTCASE_CODE@

