///  @file    TestSBMLNamespaces.cs
///  @brief   SBMLNamespaces unit tests
///  @author  Frank Bergmann (Csharp conversion)
///  @author  Akiya Jouraku (Csharp conversion)
///  @author  Sarah Keating 
/// 
/// 
///  ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
/// 
///  DO NOT EDIT THIS FILE.
/// 
///  This file was generated automatically by converting the file located at
///  src/sbml/test/TestSBMLNamespaces.cpp
///  using the conversion program dev/utilities/translateTests/translateTests.pl.
///  Any changes made here will be lost the next time the file is regenerated.
/// 
///  -----------------------------------------------------------------------------
///  This file is part of libSBML.  Please visit http://sbml.org for more
///  information about SBML, and the latest version of libSBML.
/// 
///  Copyright 2005-2010 California Institute of Technology.
///  Copyright 2002-2005 California Institute of Technology and
///                      Japan Science and Technology Corporation.
///  
///  This library is free software; you can redistribute it and/or modify it
///  under the terms of the GNU Lesser General Public License as published by
///  the Free Software Foundation.  A copy of the license agreement is provided
///  in the file named "LICENSE.txt" included with this software distribution
///  and also available online as http://sbml.org/software/libsbml/license.html
///  -----------------------------------------------------------------------------


namespace LibSBMLCSTest.sbml {

  using libsbmlcs;

  using System;

  using System.IO;

  public class TestSBMLNamespaces {
    public class AssertionError : System.Exception 
    {
      public AssertionError() : base()
      {
        
      }
    }


    static void assertTrue(bool condition)
    {
      if (condition == true)
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        return;
      }
      else if ( (a == null) || (b == null) )
      {
        throw new AssertionError();
      }
      else if (a.Equals(b))
      {
        return;
      }
  
      throw new AssertionError();
    }

    static void assertNotEquals(object a, object b)
    {
      if ( (a == null) && (b == null) )
      {
        throw new AssertionError();
      }
      else if ( (a == null) || (b == null) )
      {
        return;
      }
      else if (a.Equals(b))
      {
        throw new AssertionError();
      }
    }

    static void assertEquals(bool a, bool b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(bool a, bool b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertEquals(int a, int b)
    {
      if ( a == b )
      {
        return;
      }
      throw new AssertionError();
    }

    static void assertNotEquals(int a, int b)
    {
      if ( a != b )
      {
        return;
      }
      throw new AssertionError();
    }


    public void test_SBMLNamespaces_L1V1()
    {
      SBMLNamespaces sbml = new SBMLNamespaces(1,1);
      assertTrue( sbml.getLevel() == 1 );
      assertTrue( sbml.getVersion() == 1 );
      XMLNamespaces ns = sbml.getNamespaces();
      assertTrue( ns.getLength() == 1 );
      assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level1" );
      assertTrue( ns.getPrefix(0) ==  "" );
      sbml = null;
    }

    public void test_SBMLNamespaces_L1V2()
    {
      SBMLNamespaces sbml = new SBMLNamespaces(1,2);
      assertTrue( sbml.getLevel() == 1 );
      assertTrue( sbml.getVersion() == 2 );
      XMLNamespaces ns = sbml.getNamespaces();
      assertTrue( ns.getLength() == 1 );
      assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level1" );
      assertTrue( ns.getPrefix(0) ==  "" );
      sbml = null;
    }

    public void test_SBMLNamespaces_L2V1()
    {
      SBMLNamespaces sbml = new SBMLNamespaces(2,1);
      assertTrue( sbml.getLevel() == 2 );
      assertTrue( sbml.getVersion() == 1 );
      XMLNamespaces ns = sbml.getNamespaces();
      assertTrue( ns.getLength() == 1 );
      assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2" );
      assertTrue( ns.getPrefix(0) ==  "" );
      sbml = null;
    }

    public void test_SBMLNamespaces_L2V2()
    {
      SBMLNamespaces sbml = new SBMLNamespaces(2,2);
      assertTrue( sbml.getLevel() == 2 );
      assertTrue( sbml.getVersion() == 2 );
      XMLNamespaces ns = sbml.getNamespaces();
      assertTrue( ns.getLength() == 1 );
      assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version2" );
      assertTrue( ns.getPrefix(0) ==  "" );
      sbml = null;
    }

    public void test_SBMLNamespaces_L2V3()
    {
      SBMLNamespaces sbml = new SBMLNamespaces(2,3);
      assertTrue( sbml.getLevel() == 2 );
      assertTrue( sbml.getVersion() == 3 );
      XMLNamespaces ns = sbml.getNamespaces();
      assertTrue( ns.getLength() == 1 );
      assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version3" );
      assertTrue( ns.getPrefix(0) ==  "" );
      sbml = null;
    }

    public void test_SBMLNamespaces_L2V4()
    {
      SBMLNamespaces sbml = new SBMLNamespaces(2,4);
      assertTrue( sbml.getLevel() == 2 );
      assertTrue( sbml.getVersion() == 4 );
      XMLNamespaces ns = sbml.getNamespaces();
      assertTrue( ns.getLength() == 1 );
      assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version4" );
      assertTrue( ns.getPrefix(0) ==  "" );
      sbml = null;
    }

    public void test_SBMLNamespaces_add_and_remove_namespaces()
    {
      SBMLNamespaces sbmlns = new SBMLNamespaces ( 3,1 );
      assertTrue( sbmlns.getLevel() == 3 );
      assertTrue( sbmlns.getVersion() == 1 );
      sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/group/version1",  "group");
      sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1", "layout");
      sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/render/version1", "render");
      sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1",  "multi");
      XMLNamespaces ns = sbmlns.getNamespaces();
      assertTrue( ns.getLength() == 5 );
      assertTrue( ns.getURI(0) ==  "http://www.sbml.org/sbml/level3/version1/core" );
      assertTrue( ns.getPrefix(0) ==  "" );
      assertTrue( ns.getURI(1) ==  "http://www.sbml.org/sbml/level3/version1/group/version1" );
      assertTrue( ns.getPrefix(1) ==  "group" );
      assertTrue( ns.getURI(2) ==  "http://www.sbml.org/sbml/level3/version1/layout/version1" );
      assertTrue( ns.getPrefix(2) ==  "layout" );
      assertTrue( ns.getURI(3) ==  "http://www.sbml.org/sbml/level3/version1/render/version1" );
      assertTrue( ns.getPrefix(3) ==  "render" );
      assertTrue( ns.getURI(4) ==  "http://www.sbml.org/sbml/level3/version1/multi/version1" );
      assertTrue( ns.getPrefix(4) ==  "multi" );
      sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1");
      sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/group/version1");
      sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/render/version1");
      sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1");
    }

    public void test_SBMLNamespaces_getURI()
    {
      assertTrue( SBMLNamespaces.getSBMLNamespaceURI(1,1) ==                              "http://www.sbml.org/sbml/level1" );
      assertTrue( SBMLNamespaces.getSBMLNamespaceURI(1,2) ==                              "http://www.sbml.org/sbml/level1" );
      assertTrue( SBMLNamespaces.getSBMLNamespaceURI(2,1) ==                              "http://www.sbml.org/sbml/level2" );
      assertTrue( SBMLNamespaces.getSBMLNamespaceURI(2,2) ==                              "http://www.sbml.org/sbml/level2/version2" );
      assertTrue( SBMLNamespaces.getSBMLNamespaceURI(2,3) ==                              "http://www.sbml.org/sbml/level2/version3" );
      assertTrue( SBMLNamespaces.getSBMLNamespaceURI(2,4) ==                              "http://www.sbml.org/sbml/level2/version4" );
    }

  }
}

