#include "osl/misc/carray2d.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <iostream>
using namespace osl;

class CArray2dTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( CArray2dTest );
  CPPUNIT_TEST(testAddress);
  CPPUNIT_TEST(testExhaustive);
  CPPUNIT_TEST_SUITE_END();
public:
  void testAddress();
  void testExhaustive();
};

CPPUNIT_TEST_SUITE_REGISTRATION(CArray2dTest);

void CArray2dTest::testAddress()
{
  const size_t c1 = 4, c2 = 3;
  CArray2d<int,c1,c2> a = { { {0, 1, 2}, {3, 4, 5}, {6, 7, 8}, {9, 10, 11} } };
  for (size_t i=0; i<c1; ++i)
  {
    for (size_t j=0; j<c2; ++j)
    {
      CPPUNIT_ASSERT_EQUAL(&a(i,j), &a[i][j]);
    }
  }
}

void CArray2dTest::testExhaustive()
{
  const size_t c1 = 4, c2 = 3;
  CArray2d<int,c1,c2> a;
  {
    int c = 0;
    for (size_t i=0; i<c1; ++i)
    {
      for (size_t j=0; j<c2; ++j)
      {
	a[i][j] = c++;
      }
    }
  }
  const CArray2d<int,c1,c2>& c = a;
  for (size_t i=0; i<c1; ++i)
  {
    for (size_t j=0; j<c2; ++j)
    {
      for (size_t i2=0; i2<c1; ++i2)
      {
	for (size_t j2=0; j2<c2; ++j2)
	{
	  if ((i==i2) && (j == j2))
	  {
	    CPPUNIT_ASSERT_EQUAL(a(i,j), c(i2,j2));

	    CPPUNIT_ASSERT(&a(i,j) == &c(i2,j2));

	    CPPUNIT_ASSERT_EQUAL(a[i][j], c[i2][j2]);

	    CPPUNIT_ASSERT(&a[i][j] == &c[i2][j2]);
	  }
	  else
	  {
	    CPPUNIT_ASSERT(a(i,j) != c(i2,j2));

	    CPPUNIT_ASSERT(&a(i,j) != &c(i2,j2));

	    CPPUNIT_ASSERT(a[i][j] != c[i2][j2]);

	    CPPUNIT_ASSERT(&a[i][j] != &c[i2][j2]);
	  }
	}
      }
    }
  }
}



// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
